/* tracker-sparql-expression.c generated by valac 0.43.90, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-property.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-collation.h"
#include "libtracker-data/tracker-ontologies.h"

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
enum  {
	TRACKER_SPARQL_EXPRESSION_0_PROPERTY,
	TRACKER_SPARQL_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_expression_properties[TRACKER_SPARQL_EXPRESSION_NUM_PROPERTIES];
typedef enum  {
	TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_SECONDS,
	TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_MINUTES,
	TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_HOURS
} TrackerSparqlExpressionTimeFormatType;

#define TRACKER_SPARQL_EXPRESSION_TYPE_TIME_FORMAT_TYPE (tracker_sparql_expression_time_format_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
	gchar* fts_sql;
	TrackerDataManager* manager;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	TrackerDataManager* manager;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
	gboolean need_binding_expression;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

static gint TrackerSparqlExpression_private_offset;
static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlExpression, g_object_unref)
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlQuery, g_object_unref)
static GType tracker_sparql_expression_time_format_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN 20
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type,
                                                              TrackerSparqlQuery* query);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlPattern, g_object_unref)
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlDataBinding, g_object_unref)
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlLiteralBinding, g_object_unref)
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value,
                                       gpointer v_object);
void tracker_sparql_value_take_context (GValue* value,
                                        gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlContext, tracker_sparql_context_unref)
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self,
                                         GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self,
                                    GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self,
                                           TrackerSparqlTokenType type,
                                           GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self,
                                      TrackerSparqlTokenType type,
                                      GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self,
                                             const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self,
                                        const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self,
                                           TrackerSparqlTokenType type,
                                           GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self,
                                      TrackerSparqlTokenType type,
                                      GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self,
                                                  gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self,
                                             gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self,
                                                            const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self,
                                                  TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self,
                                               GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self,
                                                           GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self,
                                                      GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self,
                                                                           GString* sql,
                                                                           gboolean subquery,
                                                                           gint variable_index,
                                                                           GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlVariable, g_object_unref)
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self,
                                                                    GString* sql,
                                                                    GError** error);
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self,
                                                            const gchar* name);
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlVariableBinding, g_object_unref)
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlSelectContext, tracker_sparql_context_unref)
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self,
                                                                     GString* sql,
                                                                     gboolean subquery,
                                                                     gboolean scalar_subquery,
                                                                     GError** error);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlPredicateVariable, g_object_unref)
static void tracker_sparql_expression_convert_expression_to_string (GString* sql,
                                                             TrackerPropertyType type,
                                                             glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSparqlDataTable, g_object_unref)
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self,
                                                     const gchar* value);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self,
                                                  GString* sql,
                                                  TrackerSparqlVariableBinding* binding,
                                                  TrackerSparqlVariableState variable_state);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self,
                                                                        GString* sql,
                                                                        GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self,
                                                          GString* sql,
                                                          GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self,
                                                     GString* sql,
                                                     GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self,
                                                                 GString* sql,
                                                                 GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self,
                                                GString* sql,
                                                GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self,
                                                               GString* sql,
                                                               GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self,
                                                       TrackerPropertyType* type,
                                                       GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self,
                                                 GString* sql,
                                                 GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self,
                                              GString* sql,
                                              GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql,
                                                            const gchar* expression,
                                                            TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self,
                                                 GString* sql,
                                                 gboolean* is_var,
                                                 GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self,
                                                                  GString* sql,
                                                                  const gchar* uri,
                                                                  GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self,
                                              GString* sql,
                                              GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self,
                                                GString* sql,
                                                GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self,
                                                   GString* sql,
                                                   GError** error);
static void tracker_sparql_expression_translate_date (TrackerSparqlExpression* self,
                                               GString* sql,
                                               const gchar* format,
                                               GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self,
                                                         const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self,
                                                                            GString* sql,
                                                                            GError** error);
static void tracker_sparql_expression_translate_time (TrackerSparqlExpression* self,
                                               GString* sql,
                                               TrackerSparqlExpressionTimeFormatType type,
                                               GError** error);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self,
                                                              GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self,
                                                   const gchar* prefix,
                                                   const gchar* local_name,
                                                   GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self,
                                                                        GString* sql,
                                                                        const gchar* uri,
                                                                        GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self,
                                                                               GString* sql,
                                                                               GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self,
                                                                              GString* sql,
                                                                              GError** error);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self,
                                        gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self,
                                                                          GString* sql,
                                                                          GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self,
                                                                                   GString* sql,
                                                                                   GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self,
                                                                             GString* sql,
                                                                             GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self,
                                                                            GString* sql,
                                                                            GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self,
                                                                             GString* sql,
                                                                             glong begin,
                                                                             guint n_bindings,
                                                                             TrackerPropertyType op1type,
                                                                             const gchar* operator,
                                                                             GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self,
                                                            GString* sql,
                                                            gboolean not,
                                                            GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self,
                                                                               GString* sql,
                                                                               GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self,
                                                                       GString* sql,
                                                                       GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self,
                                                                                    GString* sql,
                                                                                    GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self,
                                                                                   GString* sql,
                                                                                   GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self,
                                                                    GString* sql,
                                                                    GError** error);
static void tracker_sparql_expression_finalize (GObject * obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
tracker_sparql_expression_get_instance_private (TrackerSparqlExpression* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlExpression_private_offset);
}

static GType
tracker_sparql_expression_time_format_type_get_type (void)
{
	static volatile gsize tracker_sparql_expression_time_format_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_time_format_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_SECONDS, "TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_SECONDS", "seconds"}, {TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_MINUTES, "TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_MINUTES", "minutes"}, {TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_HOURS, "TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_HOURS", "hours"}, {0, NULL, NULL}};
		GType tracker_sparql_expression_time_format_type_type_id;
		tracker_sparql_expression_time_format_type_type_id = g_enum_register_static ("TrackerSparqlExpressionTimeFormatType", values);
		g_once_init_leave (&tracker_sparql_expression_time_format_type_type_id__volatile, tracker_sparql_expression_time_format_type_type_id);
	}
	return tracker_sparql_expression_time_format_type_type_id__volatile;
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 41 "tracker-sparql-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 724 "tracker-sparql-expression.c"
}

TrackerSparqlExpression*
tracker_sparql_expression_construct (GType object_type,
                                     TrackerSparqlQuery* query)
{
	TrackerSparqlExpression * self = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
#line 39 "tracker-sparql-expression.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 39 "tracker-sparql-expression.vala"
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
#line 40 "tracker-sparql-expression.vala"
	self->priv->query = query;
#line 41 "tracker-sparql-expression.vala"
	_tmp0_ = query->manager;
#line 41 "tracker-sparql-expression.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "tracker-sparql-expression.vala"
	_g_object_unref0 (self->priv->manager);
#line 41 "tracker-sparql-expression.vala"
	self->priv->manager = _tmp1_;
#line 39 "tracker-sparql-expression.vala"
	return self;
#line 750 "tracker-sparql-expression.c"
}

TrackerSparqlExpression*
tracker_sparql_expression_new (TrackerSparqlQuery* query)
{
#line 39 "tracker-sparql-expression.vala"
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
#line 758 "tracker-sparql-expression.c"
}

static inline gboolean
tracker_sparql_expression_next (TrackerSparqlExpression* self,
                                GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 52 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 53 "tracker-sparql-expression.vala"
	_tmp1_ = self->priv->query;
#line 53 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_query_next (_tmp1_, &_inner_error0_);
#line 53 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 53 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 779 "tracker-sparql-expression.c"
			gboolean _tmp2_ = FALSE;
#line 53 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 53 "tracker-sparql-expression.vala"
			return _tmp2_;
#line 785 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp3_ = FALSE;
#line 53 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 53 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 53 "tracker-sparql-expression.vala"
			return _tmp3_;
#line 794 "tracker-sparql-expression.c"
		}
	}
#line 53 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 53 "tracker-sparql-expression.vala"
	return result;
#line 801 "tracker-sparql-expression.c"
}

static inline TrackerSparqlTokenType
tracker_sparql_expression_current (TrackerSparqlExpression* self)
{
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
#line 56 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 57 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 57 "tracker-sparql-expression.vala"
	result = tracker_sparql_query_current (_tmp0_);
#line 57 "tracker-sparql-expression.vala"
	return result;
#line 817 "tracker-sparql-expression.c"
}

static inline TrackerSparqlTokenType
tracker_sparql_expression_last (TrackerSparqlExpression* self)
{
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
#line 60 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 61 "tracker-sparql-expression.vala"
	result = tracker_sparql_query_last (_tmp0_);
#line 61 "tracker-sparql-expression.vala"
	return result;
#line 833 "tracker-sparql-expression.c"
}

static inline gboolean
tracker_sparql_expression_accept (TrackerSparqlExpression* self,
                                  TrackerSparqlTokenType type,
                                  GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 64 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 65 "tracker-sparql-expression.vala"
	_tmp1_ = self->priv->query;
#line 65 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_query_accept (_tmp1_, type, &_inner_error0_);
#line 65 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 65 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 855 "tracker-sparql-expression.c"
			gboolean _tmp2_ = FALSE;
#line 65 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 65 "tracker-sparql-expression.vala"
			return _tmp2_;
#line 861 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp3_ = FALSE;
#line 65 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 65 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 65 "tracker-sparql-expression.vala"
			return _tmp3_;
#line 870 "tracker-sparql-expression.c"
		}
	}
#line 65 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 65 "tracker-sparql-expression.vala"
	return result;
#line 877 "tracker-sparql-expression.c"
}

static GError*
tracker_sparql_expression_get_error (TrackerSparqlExpression* self,
                                     const gchar* msg)
{
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	GError* _tmp1_;
#line 68 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "tracker-sparql-expression.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 69 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 69 "tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_get_error (_tmp0_, msg);
#line 69 "tracker-sparql-expression.vala"
	result = _tmp1_;
#line 69 "tracker-sparql-expression.vala"
	return result;
#line 899 "tracker-sparql-expression.c"
}

static gboolean
tracker_sparql_expression_expect (TrackerSparqlExpression* self,
                                  TrackerSparqlTokenType type,
                                  GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 72 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "tracker-sparql-expression.vala"
	_tmp1_ = self->priv->query;
#line 73 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_query_expect (_tmp1_, type, &_inner_error0_);
#line 73 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 921 "tracker-sparql-expression.c"
			gboolean _tmp2_ = FALSE;
#line 73 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 73 "tracker-sparql-expression.vala"
			return _tmp2_;
#line 927 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp3_ = FALSE;
#line 73 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 73 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 73 "tracker-sparql-expression.vala"
			return _tmp3_;
#line 936 "tracker-sparql-expression.c"
		}
	}
#line 73 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 73 "tracker-sparql-expression.vala"
	return result;
#line 943 "tracker-sparql-expression.c"
}

static gchar*
tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self,
                                           gint strip)
{
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gchar* _tmp1_;
#line 76 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 77 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 77 "tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_get_last_string (_tmp0_, strip);
#line 77 "tracker-sparql-expression.vala"
	result = _tmp1_;
#line 77 "tracker-sparql-expression.vala"
	return result;
#line 963 "tracker-sparql-expression.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 1148 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1149 "glib-2.0.vapi"
		separator = "";
#line 977 "tracker-sparql-expression.c"
	}
#line 1151 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 981 "tracker-sparql-expression.c"
		gboolean _tmp1_ = FALSE;
#line 1151 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1151 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 987 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1151 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 992 "tracker-sparql-expression.c"
				const gchar* _tmp3_;
#line 1151 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1151 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 998 "tracker-sparql-expression.c"
			} else {
#line 1151 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 1002 "tracker-sparql-expression.c"
			}
#line 1151 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1006 "tracker-sparql-expression.c"
		}
#line 1151 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1010 "tracker-sparql-expression.c"
	} else {
#line 1151 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1014 "tracker-sparql-expression.c"
	}
#line 1151 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1018 "tracker-sparql-expression.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
#line 1153 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1032 "tracker-sparql-expression.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1154 "glib-2.0.vapi"
			i = 0;
#line 1154 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1154 "glib-2.0.vapi"
			while (TRUE) {
#line 1041 "tracker-sparql-expression.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1154 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1048 "tracker-sparql-expression.c"
					gint _tmp5_;
#line 1154 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1154 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1054 "tracker-sparql-expression.c"
				}
#line 1154 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1154 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1154 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1062 "tracker-sparql-expression.c"
				} else {
#line 1154 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1066 "tracker-sparql-expression.c"
				}
#line 1154 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1154 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1072 "tracker-sparql-expression.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1154 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1077 "tracker-sparql-expression.c"
						const gchar* _tmp9_;
#line 1154 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1154 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1083 "tracker-sparql-expression.c"
					} else {
#line 1154 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1087 "tracker-sparql-expression.c"
					}
#line 1154 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1091 "tracker-sparql-expression.c"
				}
#line 1154 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1154 "glib-2.0.vapi"
					break;
#line 1097 "tracker-sparql-expression.c"
				}
#line 1155 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1155 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1103 "tracker-sparql-expression.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1155 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1155 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1155 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1155 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1115 "tracker-sparql-expression.c"
				} else {
#line 1155 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1119 "tracker-sparql-expression.c"
				}
#line 1155 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1123 "tracker-sparql-expression.c"
			}
		}
#line 1157 "glib-2.0.vapi"
		if (i == 0) {
#line 1128 "tracker-sparql-expression.c"
			gchar* _tmp15_;
#line 1158 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1158 "glib-2.0.vapi"
			result = _tmp15_;
#line 1158 "glib-2.0.vapi"
			return result;
#line 1136 "tracker-sparql-expression.c"
		}
#line 1160 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1161 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1161 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1161 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1163 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1163 "glib-2.0.vapi"
		res = _tmp18_;
#line 1164 "glib-2.0.vapi"
		_tmp19_ = res;
#line 1164 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1164 "glib-2.0.vapi"
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
#line 1164 "glib-2.0.vapi"
		ptr = _tmp21_;
#line 1158 "tracker-sparql-expression.c"
		{
			gboolean _tmp22_ = FALSE;
#line 1165 "glib-2.0.vapi"
			i = 1;
#line 1165 "glib-2.0.vapi"
			_tmp22_ = TRUE;
#line 1165 "glib-2.0.vapi"
			while (TRUE) {
#line 1167 "tracker-sparql-expression.c"
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
#line 1165 "glib-2.0.vapi"
				if (!_tmp22_) {
#line 1176 "tracker-sparql-expression.c"
					gint _tmp23_;
#line 1165 "glib-2.0.vapi"
					_tmp23_ = i;
#line 1165 "glib-2.0.vapi"
					i = _tmp23_ + 1;
#line 1182 "tracker-sparql-expression.c"
				}
#line 1165 "glib-2.0.vapi"
				_tmp22_ = FALSE;
#line 1165 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1165 "glib-2.0.vapi"
					break;
#line 1190 "tracker-sparql-expression.c"
				}
#line 1166 "glib-2.0.vapi"
				_tmp24_ = ptr;
#line 1166 "glib-2.0.vapi"
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
#line 1166 "glib-2.0.vapi"
				ptr = _tmp25_;
#line 1167 "glib-2.0.vapi"
				_tmp27_ = str_array[i];
#line 1167 "glib-2.0.vapi"
				if (_tmp27_ != NULL) {
#line 1202 "tracker-sparql-expression.c"
					const gchar* _tmp28_;
#line 1167 "glib-2.0.vapi"
					_tmp28_ = str_array[i];
#line 1167 "glib-2.0.vapi"
					_tmp26_ = (const gchar*) _tmp28_;
#line 1208 "tracker-sparql-expression.c"
				} else {
#line 1167 "glib-2.0.vapi"
					_tmp26_ = "";
#line 1212 "tracker-sparql-expression.c"
				}
#line 1167 "glib-2.0.vapi"
				_tmp29_ = ptr;
#line 1167 "glib-2.0.vapi"
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
#line 1167 "glib-2.0.vapi"
				ptr = _tmp30_;
#line 1220 "tracker-sparql-expression.c"
			}
		}
#line 1170 "glib-2.0.vapi"
		_tmp31_ = res;
#line 1170 "glib-2.0.vapi"
		res = NULL;
#line 1170 "glib-2.0.vapi"
		result = (gchar*) _tmp31_;
#line 1170 "glib-2.0.vapi"
		return result;
#line 1231 "tracker-sparql-expression.c"
	} else {
		gchar* _tmp32_;
#line 1172 "glib-2.0.vapi"
		_tmp32_ = g_strdup ("");
#line 1172 "glib-2.0.vapi"
		result = _tmp32_;
#line 1172 "glib-2.0.vapi"
		return result;
#line 1240 "tracker-sparql-expression.c"
	}
}

static gchar*
tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self,
                                                     const gchar* literal)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 80 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "tracker-sparql-expression.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 81 "tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_ = g_strsplit (literal, "'", 0);
#line 81 "tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 81 "tracker-sparql-expression.vala"
	_tmp2__length1 = _vala_array_length (_tmp0_);
#line 81 "tracker-sparql-expression.vala"
	_tmp3_ = _vala_g_strjoinv ("''", _tmp2_, (gint) _vala_array_length (_tmp0_));
#line 81 "tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 81 "tracker-sparql-expression.vala"
	_tmp5_ = g_strdup_printf ("'%s'", _tmp4_);
#line 81 "tracker-sparql-expression.vala"
	_tmp6_ = _tmp5_;
#line 81 "tracker-sparql-expression.vala"
	_g_free0 (_tmp4_);
#line 81 "tracker-sparql-expression.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 81 "tracker-sparql-expression.vala"
	result = _tmp6_;
#line 81 "tracker-sparql-expression.vala"
	return result;
#line 1283 "tracker-sparql-expression.c"
}

static gboolean
tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self,
                                         TrackerPropertyType type)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 84 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 85 "tracker-sparql-expression.vala"
	if (type == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 85 "tracker-sparql-expression.vala"
		_tmp3_ = TRUE;
#line 1301 "tracker-sparql-expression.c"
	} else {
#line 85 "tracker-sparql-expression.vala"
		_tmp3_ = type == TRACKER_PROPERTY_TYPE_DOUBLE;
#line 1305 "tracker-sparql-expression.c"
	}
#line 85 "tracker-sparql-expression.vala"
	if (_tmp3_) {
#line 85 "tracker-sparql-expression.vala"
		_tmp2_ = TRUE;
#line 1311 "tracker-sparql-expression.c"
	} else {
#line 85 "tracker-sparql-expression.vala"
		_tmp2_ = type == TRACKER_PROPERTY_TYPE_DATE;
#line 1315 "tracker-sparql-expression.c"
	}
#line 85 "tracker-sparql-expression.vala"
	if (_tmp2_) {
#line 85 "tracker-sparql-expression.vala"
		_tmp1_ = TRUE;
#line 1321 "tracker-sparql-expression.c"
	} else {
#line 85 "tracker-sparql-expression.vala"
		_tmp1_ = type == TRACKER_PROPERTY_TYPE_DATETIME;
#line 1325 "tracker-sparql-expression.c"
	}
#line 85 "tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 85 "tracker-sparql-expression.vala"
		_tmp0_ = TRUE;
#line 1331 "tracker-sparql-expression.c"
	} else {
#line 85 "tracker-sparql-expression.vala"
		_tmp0_ = type == TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 1335 "tracker-sparql-expression.c"
	}
#line 85 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 85 "tracker-sparql-expression.vala"
	return result;
#line 1341 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_append_collate (TrackerSparqlExpression* self,
                                          GString* sql)
{
#line 88 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 88 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 89 "tracker-sparql-expression.vala"
	g_string_append_printf (sql, " COLLATE %s", TRACKER_COLLATION_NAME);
#line 1354 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self,
                                                      GError** error)
{
	GError* _inner_error0_ = NULL;
#line 92 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 93 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 93 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 93 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 93 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 93 "tracker-sparql-expression.vala"
			return;
#line 1374 "tracker-sparql-expression.c"
		} else {
#line 93 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 93 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 93 "tracker-sparql-expression.vala"
			return;
#line 1382 "tracker-sparql-expression.c"
		}
	}
#line 94 "tracker-sparql-expression.vala"
	while (TRUE) {
#line 95 "tracker-sparql-expression.vala"
		switch (tracker_sparql_expression_current (self)) {
#line 95 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 1391 "tracker-sparql-expression.c"
			{
#line 98 "tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error0_);
#line 98 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 98 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 98 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 98 "tracker-sparql-expression.vala"
						return;
#line 1403 "tracker-sparql-expression.c"
					} else {
#line 98 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 98 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 98 "tracker-sparql-expression.vala"
						return;
#line 1411 "tracker-sparql-expression.c"
					}
				}
#line 99 "tracker-sparql-expression.vala"
				continue;
#line 1416 "tracker-sparql-expression.c"
			}
#line 95 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 95 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 1422 "tracker-sparql-expression.c"
			{
#line 102 "tracker-sparql-expression.vala"
				break;
#line 1426 "tracker-sparql-expression.c"
			}
			default:
			{
#line 104 "tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error0_);
#line 104 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 104 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 104 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 104 "tracker-sparql-expression.vala"
						return;
#line 1440 "tracker-sparql-expression.c"
					} else {
#line 104 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 104 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 104 "tracker-sparql-expression.vala"
						return;
#line 1448 "tracker-sparql-expression.c"
					}
				}
#line 105 "tracker-sparql-expression.vala"
				continue;
#line 1453 "tracker-sparql-expression.c"
			}
		}
#line 107 "tracker-sparql-expression.vala"
		break;
#line 1458 "tracker-sparql-expression.c"
	}
#line 109 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 109 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 109 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 109 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 109 "tracker-sparql-expression.vala"
			return;
#line 1470 "tracker-sparql-expression.c"
		} else {
#line 109 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 109 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 109 "tracker-sparql-expression.vala"
			return;
#line 1478 "tracker-sparql-expression.c"
		}
	}
}

void
tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self,
                                                 GError** error)
{
	GError* _inner_error0_ = NULL;
#line 112 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 113 "tracker-sparql-expression.vala"
	while (TRUE) {
#line 114 "tracker-sparql-expression.vala"
		switch (tracker_sparql_expression_current (self)) {
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 1496 "tracker-sparql-expression.c"
			{
#line 116 "tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error0_);
#line 116 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 116 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 116 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 116 "tracker-sparql-expression.vala"
						return;
#line 1508 "tracker-sparql-expression.c"
					} else {
#line 116 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 116 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 116 "tracker-sparql-expression.vala"
						return;
#line 1516 "tracker-sparql-expression.c"
					}
				}
#line 117 "tracker-sparql-expression.vala"
				continue;
#line 1521 "tracker-sparql-expression.c"
			}
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 114 "tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 1539 "tracker-sparql-expression.c"
			{
#line 126 "tracker-sparql-expression.vala"
				break;
#line 1543 "tracker-sparql-expression.c"
			}
			default:
			{
#line 128 "tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error0_);
#line 128 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 128 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 128 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 128 "tracker-sparql-expression.vala"
						return;
#line 1557 "tracker-sparql-expression.c"
					} else {
#line 128 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 128 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 128 "tracker-sparql-expression.vala"
						return;
#line 1565 "tracker-sparql-expression.c"
					}
				}
#line 129 "tracker-sparql-expression.vala"
				continue;
#line 1570 "tracker-sparql-expression.c"
			}
		}
#line 131 "tracker-sparql-expression.vala"
		break;
#line 1575 "tracker-sparql-expression.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1392 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1392 "glib-2.0.vapi"
	end = _tmp0_;
#line 1393 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1393 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1394 "glib-2.0.vapi"
		result = maxlen;
#line 1394 "glib-2.0.vapi"
		return result;
#line 1599 "tracker-sparql-expression.c"
	} else {
		gchar* _tmp2_;
#line 1396 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1396 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1396 "glib-2.0.vapi"
		return result;
#line 1608 "tracker-sparql-expression.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
#line 1403 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1405 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1405 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1627 "tracker-sparql-expression.c"
	} else {
#line 1405 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1631 "tracker-sparql-expression.c"
	}
#line 1405 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1407 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1637 "tracker-sparql-expression.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1409 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1409 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1409 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1647 "tracker-sparql-expression.c"
	}
#line 1412 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1413 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1414 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1655 "tracker-sparql-expression.c"
	} else {
#line 1416 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1659 "tracker-sparql-expression.c"
	}
#line 1418 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1419 "glib-2.0.vapi"
		len = string_length - offset;
#line 1665 "tracker-sparql-expression.c"
	}
#line 1421 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1422 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1422 "glib-2.0.vapi"
	result = _tmp3_;
#line 1422 "glib-2.0.vapi"
	return result;
#line 1675 "tracker-sparql-expression.c"
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 205 "tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 205 "tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 205 "tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1690 "tracker-sparql-expression.c"
	}
#line 205 "tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 205 "tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1696 "tracker-sparql-expression.c"
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 211 "tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 211 "tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 211 "tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1711 "tracker-sparql-expression.c"
	}
#line 211 "tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 211 "tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1717 "tracker-sparql-expression.c"
}

static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 227 "tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 227 "tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 227 "tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1732 "tracker-sparql-expression.c"
	}
#line 227 "tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 227 "tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1738 "tracker-sparql-expression.c"
}

static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 229 "tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 229 "tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 229 "tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1753 "tracker-sparql-expression.c"
	}
#line 229 "tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 229 "tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1759 "tracker-sparql-expression.c"
}

TrackerPropertyType
tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self,
                                                       GString* sql,
                                                       gboolean subquery,
                                                       gint variable_index,
                                                       GError** error)
{
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable = NULL;
	gboolean expect_close_parens = FALSE;
	gboolean as_handled = FALSE;
	glong begin = 0L;
	TrackerPropertyType type = 0;
	gboolean _tmp28_ = FALSE;
	TrackerSparqlPattern* _tmp54_;
	TrackerSparqlPattern* _tmp55_;
	TrackerSparqlVariable* _tmp56_;
	TrackerSparqlVariable* _tmp86_;
	GError* _inner_error0_ = NULL;
#line 135 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 135 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 136 "tracker-sparql-expression.vala"
	variable = NULL;
#line 137 "tracker-sparql-expression.vala"
	expect_close_parens = FALSE;
#line 138 "tracker-sparql-expression.vala"
	as_handled = FALSE;
#line 140 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 141 "tracker-sparql-expression.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 142 "tracker-sparql-expression.vala"
	if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 1797 "tracker-sparql-expression.c"
		TrackerPropertyType _tmp0_ = 0;
		TrackerSparqlContext* _tmp1_;
		TrackerSparqlContext* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		TrackerSparqlVariable* _tmp7_;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* _tmp9_;
		TrackerSparqlVariableBinding* _tmp10_;
#line 143 "tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 143 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 143 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 143 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 143 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 143 "tracker-sparql-expression.vala"
				return 0;
#line 1821 "tracker-sparql-expression.c"
			} else {
#line 143 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 143 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 143 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 143 "tracker-sparql-expression.vala"
				return 0;
#line 1831 "tracker-sparql-expression.c"
			}
		}
#line 143 "tracker-sparql-expression.vala"
		type = _tmp0_;
#line 145 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_get_context (self);
#line 145 "tracker-sparql-expression.vala"
		_tmp2_ = _tmp1_;
#line 145 "tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_get_last_string (self, 0);
#line 145 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 145 "tracker-sparql-expression.vala"
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
#line 145 "tracker-sparql-expression.vala"
		_tmp6_ = _tmp5_;
#line 145 "tracker-sparql-expression.vala"
		_tmp7_ = tracker_sparql_context_get_variable (_tmp2_, _tmp6_);
#line 145 "tracker-sparql-expression.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 145 "tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 145 "tracker-sparql-expression.vala"
		variable = _tmp8_;
#line 145 "tracker-sparql-expression.vala"
		_g_free0 (_tmp6_);
#line 145 "tracker-sparql-expression.vala"
		_g_free0 (_tmp4_);
#line 147 "tracker-sparql-expression.vala"
		_tmp9_ = variable;
#line 147 "tracker-sparql-expression.vala"
		_tmp10_ = _tmp9_->binding;
#line 147 "tracker-sparql-expression.vala"
		if (_tmp10_ == NULL) {
#line 1866 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			GError* _tmp16_;
			GError* _tmp17_;
#line 148 "tracker-sparql-expression.vala"
			_tmp11_ = variable;
#line 148 "tracker-sparql-expression.vala"
			_tmp12_ = tracker_sparql_variable_get_name (_tmp11_);
#line 148 "tracker-sparql-expression.vala"
			_tmp13_ = _tmp12_;
#line 148 "tracker-sparql-expression.vala"
			_tmp14_ = g_strdup_printf ("use of undefined variable `%s'", _tmp13_);
#line 148 "tracker-sparql-expression.vala"
			_tmp15_ = _tmp14_;
#line 148 "tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, _tmp15_);
#line 148 "tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 148 "tracker-sparql-expression.vala"
			_g_free0 (_tmp15_);
#line 148 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp17_;
#line 148 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 148 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 148 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 148 "tracker-sparql-expression.vala"
				return 0;
#line 1900 "tracker-sparql-expression.c"
			} else {
#line 148 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 148 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 148 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 148 "tracker-sparql-expression.vala"
				return 0;
#line 1910 "tracker-sparql-expression.c"
			}
		}
	} else {
		gboolean _tmp18_ = FALSE;
#line 150 "tracker-sparql-expression.vala"
		_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 150 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 150 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 150 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 150 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 150 "tracker-sparql-expression.vala"
				return 0;
#line 1927 "tracker-sparql-expression.c"
			} else {
#line 150 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 150 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 150 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 150 "tracker-sparql-expression.vala"
				return 0;
#line 1937 "tracker-sparql-expression.c"
			}
		}
#line 150 "tracker-sparql-expression.vala"
		if (_tmp18_) {
#line 151 "tracker-sparql-expression.vala"
			if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 1944 "tracker-sparql-expression.c"
				TrackerSparqlSelectContext* select_context = NULL;
				TrackerSparqlPattern* _tmp19_;
				TrackerSparqlPattern* _tmp20_;
				TrackerSparqlSelectContext* _tmp21_;
				TrackerSparqlSelectContext* _tmp22_;
				TrackerPropertyType _tmp23_;
#line 154 "tracker-sparql-expression.vala"
				g_string_append (sql, "(");
#line 155 "tracker-sparql-expression.vala"
				_tmp19_ = tracker_sparql_expression_get_pattern (self);
#line 155 "tracker-sparql-expression.vala"
				_tmp20_ = _tmp19_;
#line 155 "tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_pattern_translate_select (_tmp20_, sql, TRUE, TRUE, &_inner_error0_);
#line 155 "tracker-sparql-expression.vala"
				select_context = _tmp21_;
#line 155 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 155 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 155 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 155 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 155 "tracker-sparql-expression.vala"
						return 0;
#line 1971 "tracker-sparql-expression.c"
					} else {
#line 155 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 155 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 155 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 155 "tracker-sparql-expression.vala"
						return 0;
#line 1981 "tracker-sparql-expression.c"
					}
				}
#line 156 "tracker-sparql-expression.vala"
				g_string_append (sql, ")");
#line 158 "tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 158 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 158 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 158 "tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 158 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 158 "tracker-sparql-expression.vala"
						return 0;
#line 2000 "tracker-sparql-expression.c"
					} else {
#line 158 "tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 158 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 158 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 158 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 158 "tracker-sparql-expression.vala"
						return 0;
#line 2012 "tracker-sparql-expression.c"
					}
				}
#line 159 "tracker-sparql-expression.vala"
				_tmp22_ = select_context;
#line 159 "tracker-sparql-expression.vala"
				_tmp23_ = _tmp22_->type;
#line 159 "tracker-sparql-expression.vala"
				type = _tmp23_;
#line 151 "tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 2023 "tracker-sparql-expression.c"
			} else {
				TrackerPropertyType _tmp24_ = 0;
				gboolean _tmp25_ = FALSE;
#line 161 "tracker-sparql-expression.vala"
				_tmp24_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 161 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 161 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 161 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 161 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 161 "tracker-sparql-expression.vala"
						return 0;
#line 2039 "tracker-sparql-expression.c"
					} else {
#line 161 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 161 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 161 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 161 "tracker-sparql-expression.vala"
						return 0;
#line 2049 "tracker-sparql-expression.c"
					}
				}
#line 161 "tracker-sparql-expression.vala"
				type = _tmp24_;
#line 162 "tracker-sparql-expression.vala"
				_tmp25_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 162 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 162 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 162 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 162 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 162 "tracker-sparql-expression.vala"
						return 0;
#line 2066 "tracker-sparql-expression.c"
					} else {
#line 162 "tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 162 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 162 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 162 "tracker-sparql-expression.vala"
						return 0;
#line 2076 "tracker-sparql-expression.c"
					}
				}
#line 162 "tracker-sparql-expression.vala"
				if (_tmp25_) {
#line 2081 "tracker-sparql-expression.c"
				} else {
#line 168 "tracker-sparql-expression.vala"
					expect_close_parens = TRUE;
#line 2085 "tracker-sparql-expression.c"
				}
			}
		} else {
			TrackerPropertyType _tmp26_ = 0;
#line 174 "tracker-sparql-expression.vala"
			_tmp26_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 174 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 174 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 174 "tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 174 "tracker-sparql-expression.vala"
					return 0;
#line 2102 "tracker-sparql-expression.c"
				} else {
#line 174 "tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 174 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 174 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 174 "tracker-sparql-expression.vala"
					return 0;
#line 2112 "tracker-sparql-expression.c"
				}
			}
#line 174 "tracker-sparql-expression.vala"
			type = _tmp26_;
#line 2117 "tracker-sparql-expression.c"
		}
	}
#line 177 "tracker-sparql-expression.vala"
	if (!subquery) {
#line 2122 "tracker-sparql-expression.c"
		TrackerPropertyType _tmp27_;
#line 178 "tracker-sparql-expression.vala"
		_tmp27_ = type;
#line 178 "tracker-sparql-expression.vala"
		tracker_sparql_expression_convert_expression_to_string (sql, _tmp27_, begin);
#line 2128 "tracker-sparql-expression.c"
	}
#line 181 "tracker-sparql-expression.vala"
	_tmp28_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error0_);
#line 181 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 181 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 181 "tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 181 "tracker-sparql-expression.vala"
			return 0;
#line 2142 "tracker-sparql-expression.c"
		} else {
#line 181 "tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 181 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 181 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 181 "tracker-sparql-expression.vala"
			return 0;
#line 2152 "tracker-sparql-expression.c"
		}
	}
#line 181 "tracker-sparql-expression.vala"
	if (_tmp28_) {
#line 2157 "tracker-sparql-expression.c"
		TrackerSparqlContext* _tmp29_;
		TrackerSparqlContext* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		TrackerSparqlVariable* _tmp35_;
		TrackerSparqlVariable* _tmp36_;
		TrackerSparqlVariable* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
#line 183 "tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error0_);
#line 183 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 183 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 183 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 183 "tracker-sparql-expression.vala"
				return 0;
#line 2181 "tracker-sparql-expression.c"
			} else {
#line 183 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 183 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 183 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 183 "tracker-sparql-expression.vala"
				return 0;
#line 2191 "tracker-sparql-expression.c"
			}
		}
#line 184 "tracker-sparql-expression.vala"
		_tmp29_ = tracker_sparql_expression_get_context (self);
#line 184 "tracker-sparql-expression.vala"
		_tmp30_ = _tmp29_;
#line 184 "tracker-sparql-expression.vala"
		_tmp31_ = tracker_sparql_expression_get_last_string (self, 0);
#line 184 "tracker-sparql-expression.vala"
		_tmp32_ = _tmp31_;
#line 184 "tracker-sparql-expression.vala"
		_tmp33_ = string_substring (_tmp32_, (glong) 1, (glong) -1);
#line 184 "tracker-sparql-expression.vala"
		_tmp34_ = _tmp33_;
#line 184 "tracker-sparql-expression.vala"
		_tmp35_ = tracker_sparql_context_get_variable (_tmp30_, _tmp34_);
#line 184 "tracker-sparql-expression.vala"
		_tmp36_ = _g_object_ref0 (_tmp35_);
#line 184 "tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 184 "tracker-sparql-expression.vala"
		variable = _tmp36_;
#line 184 "tracker-sparql-expression.vala"
		_g_free0 (_tmp34_);
#line 184 "tracker-sparql-expression.vala"
		_g_free0 (_tmp32_);
#line 185 "tracker-sparql-expression.vala"
		_tmp37_ = variable;
#line 185 "tracker-sparql-expression.vala"
		_tmp38_ = tracker_sparql_variable_get_sql_expression (_tmp37_);
#line 185 "tracker-sparql-expression.vala"
		_tmp39_ = _tmp38_;
#line 185 "tracker-sparql-expression.vala"
		g_string_append_printf (sql, " AS %s", _tmp39_);
#line 186 "tracker-sparql-expression.vala"
		as_handled = TRUE;
#line 188 "tracker-sparql-expression.vala"
		if (subquery) {
#line 2230 "tracker-sparql-expression.c"
			TrackerSparqlVariableBinding* binding = NULL;
			TrackerSparqlVariableBinding* _tmp40_;
			TrackerSparqlVariableBinding* _tmp41_;
			TrackerPropertyType _tmp42_;
			TrackerSparqlVariableBinding* _tmp43_;
			TrackerSparqlVariable* _tmp44_;
			TrackerSparqlVariableBinding* _tmp45_;
			TrackerSparqlVariable* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			TrackerSparqlPattern* _tmp49_;
			TrackerSparqlPattern* _tmp50_;
			GString* _tmp51_;
			GString* _tmp52_;
			TrackerSparqlVariableBinding* _tmp53_;
#line 189 "tracker-sparql-expression.vala"
			_tmp40_ = tracker_sparql_variable_binding_new ();
#line 189 "tracker-sparql-expression.vala"
			binding = _tmp40_;
#line 190 "tracker-sparql-expression.vala"
			_tmp41_ = binding;
#line 190 "tracker-sparql-expression.vala"
			_tmp42_ = type;
#line 190 "tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) _tmp41_)->data_type = _tmp42_;
#line 191 "tracker-sparql-expression.vala"
			_tmp43_ = binding;
#line 191 "tracker-sparql-expression.vala"
			_tmp44_ = variable;
#line 191 "tracker-sparql-expression.vala"
			_tmp43_->variable = _tmp44_;
#line 192 "tracker-sparql-expression.vala"
			_tmp45_ = binding;
#line 192 "tracker-sparql-expression.vala"
			_tmp46_ = variable;
#line 192 "tracker-sparql-expression.vala"
			_tmp47_ = tracker_sparql_variable_get_sql_expression (_tmp46_);
#line 192 "tracker-sparql-expression.vala"
			_tmp48_ = _tmp47_;
#line 192 "tracker-sparql-expression.vala"
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp45_, _tmp48_);
#line 193 "tracker-sparql-expression.vala"
			_tmp49_ = tracker_sparql_expression_get_pattern (self);
#line 193 "tracker-sparql-expression.vala"
			_tmp50_ = _tmp49_;
#line 193 "tracker-sparql-expression.vala"
			_tmp51_ = g_string_new ("");
#line 193 "tracker-sparql-expression.vala"
			_tmp52_ = _tmp51_;
#line 193 "tracker-sparql-expression.vala"
			_tmp53_ = binding;
#line 193 "tracker-sparql-expression.vala"
			tracker_sparql_pattern_add_variable_binding (_tmp50_, _tmp52_, _tmp53_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 193 "tracker-sparql-expression.vala"
			_g_string_free0 (_tmp52_);
#line 188 "tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 2288 "tracker-sparql-expression.c"
		}
	}
#line 197 "tracker-sparql-expression.vala"
	_tmp54_ = tracker_sparql_expression_get_pattern (self);
#line 197 "tracker-sparql-expression.vala"
	_tmp55_ = _tmp54_;
#line 197 "tracker-sparql-expression.vala"
	_tmp56_ = _tmp55_->fts_subject;
#line 197 "tracker-sparql-expression.vala"
	if (_tmp56_ != NULL) {
#line 2299 "tracker-sparql-expression.c"
		TrackerSparqlVariable* _tmp57_;
		const gchar* _tmp64_;
#line 198 "tracker-sparql-expression.vala"
		_tmp57_ = variable;
#line 198 "tracker-sparql-expression.vala"
		if (_tmp57_ == NULL) {
#line 2306 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp58_;
			TrackerSparqlContext* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			TrackerSparqlVariable* _tmp62_;
			TrackerSparqlVariable* _tmp63_;
#line 201 "tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_get_context (self);
#line 201 "tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 201 "tracker-sparql-expression.vala"
			_tmp60_ = g_strdup_printf ("var%d", variable_index + 1);
#line 201 "tracker-sparql-expression.vala"
			_tmp61_ = _tmp60_;
#line 201 "tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_context_get_variable (_tmp59_, _tmp61_);
#line 201 "tracker-sparql-expression.vala"
			_tmp63_ = _g_object_ref0 (_tmp62_);
#line 201 "tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 201 "tracker-sparql-expression.vala"
			variable = _tmp63_;
#line 201 "tracker-sparql-expression.vala"
			_g_free0 (_tmp61_);
#line 2331 "tracker-sparql-expression.c"
		}
#line 204 "tracker-sparql-expression.vala"
		_tmp64_ = self->priv->fts_sql;
#line 204 "tracker-sparql-expression.vala"
		if (_tmp64_ == NULL) {
#line 2337 "tracker-sparql-expression.c"
			TrackerSparqlPattern* _tmp65_;
			TrackerSparqlPattern* _tmp66_;
			TrackerSparqlPattern* _tmp67_;
			TrackerSparqlPattern* _tmp68_;
			gchar** _tmp69_;
			gint _tmp69__length1;
			TrackerSparqlVariable* _tmp70_;
			const gchar* _tmp71_;
			const gchar* _tmp72_;
			gchar* _tmp73_;
#line 205 "tracker-sparql-expression.vala"
			_tmp65_ = tracker_sparql_expression_get_pattern (self);
#line 205 "tracker-sparql-expression.vala"
			_tmp66_ = _tmp65_;
#line 205 "tracker-sparql-expression.vala"
			_tmp67_ = tracker_sparql_expression_get_pattern (self);
#line 205 "tracker-sparql-expression.vala"
			_tmp68_ = _tmp67_;
#line 205 "tracker-sparql-expression.vala"
			_tmp69_ = _tmp68_->fts_variables;
#line 205 "tracker-sparql-expression.vala"
			_tmp69__length1 = _tmp68_->fts_variables_length1;
#line 205 "tracker-sparql-expression.vala"
			_tmp70_ = variable;
#line 205 "tracker-sparql-expression.vala"
			_tmp71_ = tracker_sparql_variable_get_sql_expression (_tmp70_);
#line 205 "tracker-sparql-expression.vala"
			_tmp72_ = _tmp71_;
#line 205 "tracker-sparql-expression.vala"
			_tmp73_ = g_strdup (_tmp72_);
#line 205 "tracker-sparql-expression.vala"
			_vala_array_add1 (&_tmp66_->fts_variables, &_tmp66_->fts_variables_length1, &_tmp66_->_fts_variables_size_, _tmp73_);
#line 207 "tracker-sparql-expression.vala"
			if (as_handled == FALSE) {
#line 2372 "tracker-sparql-expression.c"
				TrackerSparqlVariable* _tmp74_;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
#line 208 "tracker-sparql-expression.vala"
				_tmp74_ = variable;
#line 208 "tracker-sparql-expression.vala"
				_tmp75_ = tracker_sparql_variable_get_sql_expression (_tmp74_);
#line 208 "tracker-sparql-expression.vala"
				_tmp76_ = _tmp75_;
#line 208 "tracker-sparql-expression.vala"
				g_string_append_printf (sql, " AS %s", _tmp76_);
#line 2384 "tracker-sparql-expression.c"
			}
		} else {
			TrackerSparqlPattern* _tmp77_;
			TrackerSparqlPattern* _tmp78_;
			TrackerSparqlPattern* _tmp79_;
			TrackerSparqlPattern* _tmp80_;
			gchar** _tmp81_;
			gint _tmp81__length1;
			const gchar* _tmp82_;
			gchar* _tmp83_;
			TrackerSparqlPattern* _tmp84_;
			TrackerSparqlPattern* _tmp85_;
#line 211 "tracker-sparql-expression.vala"
			_tmp77_ = tracker_sparql_expression_get_pattern (self);
#line 211 "tracker-sparql-expression.vala"
			_tmp78_ = _tmp77_;
#line 211 "tracker-sparql-expression.vala"
			_tmp79_ = tracker_sparql_expression_get_pattern (self);
#line 211 "tracker-sparql-expression.vala"
			_tmp80_ = _tmp79_;
#line 211 "tracker-sparql-expression.vala"
			_tmp81_ = _tmp80_->fts_variables;
#line 211 "tracker-sparql-expression.vala"
			_tmp81__length1 = _tmp80_->fts_variables_length1;
#line 211 "tracker-sparql-expression.vala"
			_tmp82_ = self->priv->fts_sql;
#line 211 "tracker-sparql-expression.vala"
			_tmp83_ = g_strdup (_tmp82_);
#line 211 "tracker-sparql-expression.vala"
			_vala_array_add2 (&_tmp78_->fts_variables, &_tmp78_->fts_variables_length1, &_tmp78_->_fts_variables_size_, _tmp83_);
#line 212 "tracker-sparql-expression.vala"
			_tmp84_ = tracker_sparql_expression_get_pattern (self);
#line 212 "tracker-sparql-expression.vala"
			_tmp85_ = _tmp84_;
#line 212 "tracker-sparql-expression.vala"
			_tmp85_->queries_fts_data = TRUE;
#line 2421 "tracker-sparql-expression.c"
		}
	}
#line 216 "tracker-sparql-expression.vala"
	if (expect_close_parens) {
#line 217 "tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 217 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 217 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 217 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 217 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 217 "tracker-sparql-expression.vala"
				return 0;
#line 2438 "tracker-sparql-expression.c"
			} else {
#line 217 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 217 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 217 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 217 "tracker-sparql-expression.vala"
				return 0;
#line 2448 "tracker-sparql-expression.c"
			}
		}
	}
#line 220 "tracker-sparql-expression.vala"
	_tmp86_ = variable;
#line 220 "tracker-sparql-expression.vala"
	if (_tmp86_ != NULL) {
#line 2456 "tracker-sparql-expression.c"
		gint state = 0;
		TrackerSparqlContext* _tmp87_;
		TrackerSparqlContext* _tmp88_;
		GHashTable* _tmp89_;
		TrackerSparqlVariable* _tmp90_;
		gconstpointer _tmp91_;
		TrackerSparqlContext* _tmp92_;
		TrackerSparqlContext* _tmp93_;
		GHashTable* _tmp94_;
		TrackerSparqlVariable* _tmp95_;
		TrackerSparqlVariable* _tmp96_;
		TrackerSparqlContext* _tmp97_;
		TrackerSparqlContext* _tmp98_;
		TrackerSparqlContext* _tmp99_;
		TrackerSparqlContext* _tmp100_;
		gchar** _tmp101_;
		gint _tmp101__length1;
		TrackerSparqlVariable* _tmp102_;
		const gchar* _tmp103_;
		const gchar* _tmp104_;
		gchar* _tmp105_;
#line 221 "tracker-sparql-expression.vala"
		_tmp87_ = tracker_sparql_expression_get_context (self);
#line 221 "tracker-sparql-expression.vala"
		_tmp88_ = _tmp87_;
#line 221 "tracker-sparql-expression.vala"
		_tmp89_ = _tmp88_->var_set;
#line 221 "tracker-sparql-expression.vala"
		_tmp90_ = variable;
#line 221 "tracker-sparql-expression.vala"
		_tmp91_ = g_hash_table_lookup (_tmp89_, _tmp90_);
#line 221 "tracker-sparql-expression.vala"
		state = (gint) ((gintptr) _tmp91_);
#line 222 "tracker-sparql-expression.vala"
		if (state == 0) {
#line 223 "tracker-sparql-expression.vala"
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 2494 "tracker-sparql-expression.c"
		}
#line 225 "tracker-sparql-expression.vala"
		_tmp92_ = tracker_sparql_expression_get_context (self);
#line 225 "tracker-sparql-expression.vala"
		_tmp93_ = _tmp92_;
#line 225 "tracker-sparql-expression.vala"
		_tmp94_ = _tmp93_->select_var_set;
#line 225 "tracker-sparql-expression.vala"
		_tmp95_ = variable;
#line 225 "tracker-sparql-expression.vala"
		_tmp96_ = _g_object_ref0 (_tmp95_);
#line 225 "tracker-sparql-expression.vala"
		g_hash_table_insert (_tmp94_, _tmp96_, (gpointer) ((gintptr) state));
#line 227 "tracker-sparql-expression.vala"
		_tmp97_ = tracker_sparql_expression_get_context (self);
#line 227 "tracker-sparql-expression.vala"
		_tmp98_ = _tmp97_;
#line 227 "tracker-sparql-expression.vala"
		_tmp99_ = tracker_sparql_expression_get_context (self);
#line 227 "tracker-sparql-expression.vala"
		_tmp100_ = _tmp99_;
#line 227 "tracker-sparql-expression.vala"
		_tmp101_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names;
#line 227 "tracker-sparql-expression.vala"
		_tmp101__length1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1;
#line 227 "tracker-sparql-expression.vala"
		_tmp102_ = variable;
#line 227 "tracker-sparql-expression.vala"
		_tmp103_ = tracker_sparql_variable_get_name (_tmp102_);
#line 227 "tracker-sparql-expression.vala"
		_tmp104_ = _tmp103_;
#line 227 "tracker-sparql-expression.vala"
		_tmp105_ = g_strdup (_tmp104_);
#line 227 "tracker-sparql-expression.vala"
		_vala_array_add3 (&G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names, &G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1, &G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->_variable_names_size_, _tmp105_);
#line 2530 "tracker-sparql-expression.c"
	} else {
		TrackerSparqlContext* _tmp106_;
		TrackerSparqlContext* _tmp107_;
		TrackerSparqlContext* _tmp108_;
		TrackerSparqlContext* _tmp109_;
		gchar** _tmp110_;
		gint _tmp110__length1;
		gchar* _tmp111_;
#line 229 "tracker-sparql-expression.vala"
		_tmp106_ = tracker_sparql_expression_get_context (self);
#line 229 "tracker-sparql-expression.vala"
		_tmp107_ = _tmp106_;
#line 229 "tracker-sparql-expression.vala"
		_tmp108_ = tracker_sparql_expression_get_context (self);
#line 229 "tracker-sparql-expression.vala"
		_tmp109_ = _tmp108_;
#line 229 "tracker-sparql-expression.vala"
		_tmp110_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names;
#line 229 "tracker-sparql-expression.vala"
		_tmp110__length1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1;
#line 229 "tracker-sparql-expression.vala"
		_tmp111_ = g_strdup_printf ("var%d", variable_index + 1);
#line 229 "tracker-sparql-expression.vala"
		_vala_array_add4 (&G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names, &G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1, &G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->_variable_names_size_, _tmp111_);
#line 2555 "tracker-sparql-expression.c"
	}
#line 232 "tracker-sparql-expression.vala"
	_g_free0 (self->priv->fts_sql);
#line 232 "tracker-sparql-expression.vala"
	self->priv->fts_sql = NULL;
#line 234 "tracker-sparql-expression.vala"
	result = type;
#line 234 "tracker-sparql-expression.vala"
	_g_object_unref0 (variable);
#line 234 "tracker-sparql-expression.vala"
	return result;
#line 2567 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self,
                                                                   GString* sql,
                                                                   GError** error)
{
	glong begin = 0L;
	TrackerPropertyType _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
#line 237 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 237 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 238 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 239 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 239 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 239 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 239 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 239 "tracker-sparql-expression.vala"
			return;
#line 2594 "tracker-sparql-expression.c"
		} else {
#line 239 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 239 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 239 "tracker-sparql-expression.vala"
			return;
#line 2602 "tracker-sparql-expression.c"
		}
	}
#line 239 "tracker-sparql-expression.vala"
	if (_tmp0_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 241 "tracker-sparql-expression.vala"
		g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
#line 242 "tracker-sparql-expression.vala"
		g_string_append (sql, ")");
#line 2611 "tracker-sparql-expression.c"
	}
}

void
tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self,
                                                     GString* sql,
                                                     GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 246 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 246 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 247 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error0_);
#line 247 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 247 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 247 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 247 "tracker-sparql-expression.vala"
			return;
#line 2636 "tracker-sparql-expression.c"
		} else {
#line 247 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 247 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 247 "tracker-sparql-expression.vala"
			return;
#line 2644 "tracker-sparql-expression.c"
		}
	}
#line 247 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 248 "tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error0_);
#line 248 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 248 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 248 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 248 "tracker-sparql-expression.vala"
				return;
#line 2659 "tracker-sparql-expression.c"
			} else {
#line 248 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 248 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 248 "tracker-sparql-expression.vala"
				return;
#line 2667 "tracker-sparql-expression.c"
			}
		}
#line 249 "tracker-sparql-expression.vala"
		g_string_append (sql, " ASC");
#line 2672 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 250 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error0_);
#line 250 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 250 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 250 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 250 "tracker-sparql-expression.vala"
				return;
#line 2685 "tracker-sparql-expression.c"
			} else {
#line 250 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 250 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 250 "tracker-sparql-expression.vala"
				return;
#line 2693 "tracker-sparql-expression.c"
			}
		}
#line 250 "tracker-sparql-expression.vala"
		if (_tmp1_) {
#line 251 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error0_);
#line 251 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 251 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 251 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 251 "tracker-sparql-expression.vala"
					return;
#line 2708 "tracker-sparql-expression.c"
				} else {
#line 251 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 251 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 251 "tracker-sparql-expression.vala"
					return;
#line 2716 "tracker-sparql-expression.c"
				}
			}
#line 252 "tracker-sparql-expression.vala"
			g_string_append (sql, " DESC");
#line 2721 "tracker-sparql-expression.c"
		} else {
#line 254 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error0_);
#line 254 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 254 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 254 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 254 "tracker-sparql-expression.vala"
					return;
#line 2733 "tracker-sparql-expression.c"
				} else {
#line 254 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 254 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 254 "tracker-sparql-expression.vala"
					return;
#line 2741 "tracker-sparql-expression.c"
				}
			}
		}
	}
}

static void
tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self,
                                                GString* sql,
                                                GError** error)
{
	GError* _inner_error0_ = NULL;
#line 258 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 258 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 259 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error0_);
#line 259 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 259 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 259 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 259 "tracker-sparql-expression.vala"
			return;
#line 2768 "tracker-sparql-expression.c"
		} else {
#line 259 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 259 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 259 "tracker-sparql-expression.vala"
			return;
#line 2776 "tracker-sparql-expression.c"
		}
	}
#line 260 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 260 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 260 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 260 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 260 "tracker-sparql-expression.vala"
			return;
#line 2789 "tracker-sparql-expression.c"
		} else {
#line 260 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 260 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 260 "tracker-sparql-expression.vala"
			return;
#line 2797 "tracker-sparql-expression.c"
		}
	}
#line 261 "tracker-sparql-expression.vala"
	g_string_append (sql, "(");
#line 262 "tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 262 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 262 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 262 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 262 "tracker-sparql-expression.vala"
			return;
#line 2812 "tracker-sparql-expression.c"
		} else {
#line 262 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 262 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 262 "tracker-sparql-expression.vala"
			return;
#line 2820 "tracker-sparql-expression.c"
		}
	}
#line 263 "tracker-sparql-expression.vala"
	g_string_append (sql, " IS NOT NULL)");
#line 264 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 264 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 264 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 264 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 264 "tracker-sparql-expression.vala"
			return;
#line 2835 "tracker-sparql-expression.c"
		} else {
#line 264 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 264 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 264 "tracker-sparql-expression.vala"
			return;
#line 2843 "tracker-sparql-expression.c"
		}
	}
}

static TrackerPropertyType
tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self,
                                             GString* sql,
                                             GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	GError* _inner_error0_ = NULL;
#line 267 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 267 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 268 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IF, &_inner_error0_);
#line 268 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 268 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 268 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 268 "tracker-sparql-expression.vala"
			return 0;
#line 2870 "tracker-sparql-expression.c"
		} else {
#line 268 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 268 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 268 "tracker-sparql-expression.vala"
			return 0;
#line 2878 "tracker-sparql-expression.c"
		}
	}
#line 269 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 269 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 269 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 269 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 269 "tracker-sparql-expression.vala"
			return 0;
#line 2891 "tracker-sparql-expression.c"
		} else {
#line 269 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 269 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 269 "tracker-sparql-expression.vala"
			return 0;
#line 2899 "tracker-sparql-expression.c"
		}
	}
#line 272 "tracker-sparql-expression.vala"
	g_string_append (sql, "(CASE ");
#line 273 "tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 273 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 273 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 273 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 273 "tracker-sparql-expression.vala"
			return 0;
#line 2914 "tracker-sparql-expression.c"
		} else {
#line 273 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 273 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 273 "tracker-sparql-expression.vala"
			return 0;
#line 2922 "tracker-sparql-expression.c"
		}
	}
#line 276 "tracker-sparql-expression.vala"
	g_string_append (sql, " WHEN 1 THEN ");
#line 277 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 277 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 277 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 277 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 277 "tracker-sparql-expression.vala"
			return 0;
#line 2937 "tracker-sparql-expression.c"
		} else {
#line 277 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 277 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 277 "tracker-sparql-expression.vala"
			return 0;
#line 2945 "tracker-sparql-expression.c"
		}
	}
#line 278 "tracker-sparql-expression.vala"
	type = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 278 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 278 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 278 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 278 "tracker-sparql-expression.vala"
			return 0;
#line 2958 "tracker-sparql-expression.c"
		} else {
#line 278 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 278 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 278 "tracker-sparql-expression.vala"
			return 0;
#line 2966 "tracker-sparql-expression.c"
		}
	}
#line 281 "tracker-sparql-expression.vala"
	g_string_append (sql, " WHEN 0 THEN ");
#line 282 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 282 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 282 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 282 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 282 "tracker-sparql-expression.vala"
			return 0;
#line 2981 "tracker-sparql-expression.c"
		} else {
#line 282 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 282 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 282 "tracker-sparql-expression.vala"
			return 0;
#line 2989 "tracker-sparql-expression.c"
		}
	}
#line 283 "tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 283 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 283 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 283 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 283 "tracker-sparql-expression.vala"
			return 0;
#line 3002 "tracker-sparql-expression.c"
		} else {
#line 283 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 283 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 283 "tracker-sparql-expression.vala"
			return 0;
#line 3010 "tracker-sparql-expression.c"
		}
	}
#line 285 "tracker-sparql-expression.vala"
	g_string_append (sql, " ELSE NULL END)");
#line 287 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 287 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 287 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 287 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 287 "tracker-sparql-expression.vala"
			return 0;
#line 3025 "tracker-sparql-expression.c"
		} else {
#line 287 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 287 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 287 "tracker-sparql-expression.vala"
			return 0;
#line 3033 "tracker-sparql-expression.c"
		}
	}
#line 289 "tracker-sparql-expression.vala"
	result = type;
#line 289 "tracker-sparql-expression.vala"
	return result;
#line 3040 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self,
                                           GString* sql,
                                           GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 292 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 292 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 293 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error0_);
#line 293 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 293 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 293 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 293 "tracker-sparql-expression.vala"
			return;
#line 3068 "tracker-sparql-expression.c"
		} else {
#line 293 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 293 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 293 "tracker-sparql-expression.vala"
			return;
#line 3076 "tracker-sparql-expression.c"
		}
	}
#line 294 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 294 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 294 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 294 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 294 "tracker-sparql-expression.vala"
			return;
#line 3089 "tracker-sparql-expression.c"
		} else {
#line 294 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 294 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 294 "tracker-sparql-expression.vala"
			return;
#line 3097 "tracker-sparql-expression.c"
		}
	}
#line 295 "tracker-sparql-expression.vala"
	g_string_append (sql, "SparqlRegex(");
#line 296 "tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 296 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 296 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 296 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 296 "tracker-sparql-expression.vala"
			return;
#line 3112 "tracker-sparql-expression.c"
		} else {
#line 296 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 296 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 296 "tracker-sparql-expression.vala"
			return;
#line 3120 "tracker-sparql-expression.c"
		}
	}
#line 297 "tracker-sparql-expression.vala"
	g_string_append (sql, ", ");
#line 298 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 298 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 298 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 298 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 298 "tracker-sparql-expression.vala"
			return;
#line 3135 "tracker-sparql-expression.c"
		} else {
#line 298 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 298 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 298 "tracker-sparql-expression.vala"
			return;
#line 3143 "tracker-sparql-expression.c"
		}
	}
#line 302 "tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 302 "tracker-sparql-expression.vala"
	_tmp0_ = _tmp1_;
#line 302 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 302 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 302 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 302 "tracker-sparql-expression.vala"
			return;
#line 3158 "tracker-sparql-expression.c"
		} else {
#line 302 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 302 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 302 "tracker-sparql-expression.vala"
			return;
#line 3166 "tracker-sparql-expression.c"
		}
	}
#line 302 "tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp0_);
#line 302 "tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 302 "tracker-sparql-expression.vala"
	g_string_append (sql, _tmp3_);
#line 302 "tracker-sparql-expression.vala"
	_g_free0 (_tmp3_);
#line 303 "tracker-sparql-expression.vala"
	g_string_append (sql, ", ");
#line 304 "tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 304 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 304 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 304 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 304 "tracker-sparql-expression.vala"
			_g_free0 (_tmp0_);
#line 304 "tracker-sparql-expression.vala"
			return;
#line 3191 "tracker-sparql-expression.c"
		} else {
#line 304 "tracker-sparql-expression.vala"
			_g_free0 (_tmp0_);
#line 304 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 304 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 304 "tracker-sparql-expression.vala"
			return;
#line 3201 "tracker-sparql-expression.c"
		}
	}
#line 304 "tracker-sparql-expression.vala"
	if (_tmp4_) {
#line 3206 "tracker-sparql-expression.c"
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 307 "tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 307 "tracker-sparql-expression.vala"
		_tmp5_ = _tmp6_;
#line 307 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 307 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 307 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 307 "tracker-sparql-expression.vala"
				_g_free0 (_tmp0_);
#line 307 "tracker-sparql-expression.vala"
				return;
#line 3225 "tracker-sparql-expression.c"
			} else {
#line 307 "tracker-sparql-expression.vala"
				_g_free0 (_tmp0_);
#line 307 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 307 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 307 "tracker-sparql-expression.vala"
				return;
#line 3235 "tracker-sparql-expression.c"
			}
		}
#line 307 "tracker-sparql-expression.vala"
		_tmp7_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp5_);
#line 307 "tracker-sparql-expression.vala"
		_tmp8_ = _tmp7_;
#line 307 "tracker-sparql-expression.vala"
		g_string_append (sql, _tmp8_);
#line 307 "tracker-sparql-expression.vala"
		_g_free0 (_tmp8_);
#line 304 "tracker-sparql-expression.vala"
		_g_free0 (_tmp5_);
#line 3248 "tracker-sparql-expression.c"
	} else {
#line 309 "tracker-sparql-expression.vala"
		g_string_append (sql, "''");
#line 3252 "tracker-sparql-expression.c"
	}
#line 311 "tracker-sparql-expression.vala"
	g_string_append (sql, ")");
#line 312 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 312 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 312 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 312 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 312 "tracker-sparql-expression.vala"
			_g_free0 (_tmp0_);
#line 312 "tracker-sparql-expression.vala"
			return;
#line 3268 "tracker-sparql-expression.c"
		} else {
#line 312 "tracker-sparql-expression.vala"
			_g_free0 (_tmp0_);
#line 312 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 312 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 312 "tracker-sparql-expression.vala"
			return;
#line 3278 "tracker-sparql-expression.c"
		}
	}
#line 292 "tracker-sparql-expression.vala"
	_g_free0 (_tmp0_);
#line 3283 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self,
                                            GString* sql,
                                            GError** error)
{
	TrackerSparqlPattern* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 315 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 315 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 316 "tracker-sparql-expression.vala"
	g_string_append (sql, "(");
#line 317 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_get_pattern (self);
#line 317 "tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 317 "tracker-sparql-expression.vala"
	tracker_sparql_pattern_translate_exists (_tmp1_, sql, &_inner_error0_);
#line 317 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 317 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 317 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 317 "tracker-sparql-expression.vala"
			return;
#line 3314 "tracker-sparql-expression.c"
		} else {
#line 317 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 317 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 317 "tracker-sparql-expression.vala"
			return;
#line 3322 "tracker-sparql-expression.c"
		}
	}
#line 318 "tracker-sparql-expression.vala"
	g_string_append (sql, ")");
#line 3327 "tracker-sparql-expression.c"
}

void
tracker_sparql_expression_append_expression_as_string (GString* sql,
                                                       const gchar* expression,
                                                       TrackerPropertyType type)
{
	glong begin = 0L;
#line 321 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 321 "tracker-sparql-expression.vala"
	g_return_if_fail (expression != NULL);
#line 322 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 323 "tracker-sparql-expression.vala"
	g_string_append (sql, expression);
#line 324 "tracker-sparql-expression.vala"
	tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
#line 3346 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_convert_expression_to_string (GString* sql,
                                                        TrackerPropertyType type,
                                                        glong begin)
{
#line 327 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 328 "tracker-sparql-expression.vala"
	switch (type) {
#line 328 "tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_STRING:
#line 328 "tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_INTEGER:
#line 3362 "tracker-sparql-expression.c"
		{
#line 334 "tracker-sparql-expression.vala"
			break;
#line 3366 "tracker-sparql-expression.c"
		}
#line 328 "tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_RESOURCE:
#line 3370 "tracker-sparql-expression.c"
		{
#line 337 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
#line 338 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 339 "tracker-sparql-expression.vala"
			break;
#line 3378 "tracker-sparql-expression.c"
		}
#line 328 "tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 3382 "tracker-sparql-expression.c"
		{
#line 342 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "CASE ");
#line 343 "tracker-sparql-expression.vala"
			g_string_append (sql, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 344 "tracker-sparql-expression.vala"
			break;
#line 3390 "tracker-sparql-expression.c"
		}
#line 328 "tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATE:
#line 3394 "tracker-sparql-expression.c"
		{
#line 347 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "strftime (\"%Y-%m-%d\", ");
#line 348 "tracker-sparql-expression.vala"
			g_string_append (sql, ", \"unixepoch\")");
#line 349 "tracker-sparql-expression.vala"
			break;
#line 3402 "tracker-sparql-expression.c"
		}
#line 328 "tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATETIME:
#line 3406 "tracker-sparql-expression.c"
		{
#line 352 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "SparqlFormatTime (");
#line 353 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 354 "tracker-sparql-expression.vala"
			break;
#line 3414 "tracker-sparql-expression.c"
		}
		default:
		{
#line 357 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "CAST (");
#line 358 "tracker-sparql-expression.vala"
			g_string_append (sql, " AS TEXT)");
#line 359 "tracker-sparql-expression.vala"
			break;
#line 3424 "tracker-sparql-expression.c"
		}
	}
}

static void
tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self,
                                                          GString* sql,
                                                          GError** error)
{
	GError* _inner_error0_ = NULL;
#line 363 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 363 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 364 "tracker-sparql-expression.vala"
	switch (tracker_sparql_expression_current (self)) {
#line 364 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 364 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 364 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 3447 "tracker-sparql-expression.c"
		{
			TrackerSparqlLiteralBinding* binding = NULL;
			TrackerSparqlLiteralBinding* _tmp0_;
			gboolean is_var = FALSE;
			gchar* _tmp1_ = NULL;
			TrackerSparqlPattern* _tmp2_;
			TrackerSparqlPattern* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gchar* _tmp5_;
			TrackerSparqlLiteralBinding* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
#line 369 "tracker-sparql-expression.vala"
			_tmp0_ = tracker_sparql_literal_binding_new ();
#line 369 "tracker-sparql-expression.vala"
			binding = _tmp0_;
#line 371 "tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 371 "tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 371 "tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_pattern_parse_var_or_term (_tmp3_, NULL, &_tmp4_, &_inner_error0_);
#line 371 "tracker-sparql-expression.vala"
			is_var = _tmp4_;
#line 371 "tracker-sparql-expression.vala"
			_tmp1_ = _tmp5_;
#line 371 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 371 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 371 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 371 "tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 371 "tracker-sparql-expression.vala"
					return;
#line 3484 "tracker-sparql-expression.c"
				} else {
#line 371 "tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 371 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 371 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 371 "tracker-sparql-expression.vala"
					return;
#line 3494 "tracker-sparql-expression.c"
				}
			}
#line 371 "tracker-sparql-expression.vala"
			_tmp6_ = binding;
#line 371 "tracker-sparql-expression.vala"
			_tmp7_ = _tmp1_;
#line 371 "tracker-sparql-expression.vala"
			_tmp1_ = NULL;
#line 371 "tracker-sparql-expression.vala"
			_g_free0 (_tmp6_->literal);
#line 371 "tracker-sparql-expression.vala"
			_tmp6_->literal = _tmp7_;
#line 372 "tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 372 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 372 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 372 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 372 "tracker-sparql-expression.vala"
					_g_free0 (_tmp1_);
#line 372 "tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 372 "tracker-sparql-expression.vala"
					return;
#line 3521 "tracker-sparql-expression.c"
				} else {
#line 372 "tracker-sparql-expression.vala"
					_g_free0 (_tmp1_);
#line 372 "tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 372 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 372 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 372 "tracker-sparql-expression.vala"
					return;
#line 3533 "tracker-sparql-expression.c"
				}
			}
#line 372 "tracker-sparql-expression.vala"
			if (_tmp8_) {
#line 3538 "tracker-sparql-expression.c"
				glong begin = 0L;
				TrackerPropertyType type = 0;
				TrackerSparqlLiteralBinding* _tmp9_;
				const gchar* _tmp10_;
				TrackerPropertyType _tmp11_;
#line 374 "tracker-sparql-expression.vala"
				begin = (glong) sql->len;
#line 375 "tracker-sparql-expression.vala"
				_tmp9_ = binding;
#line 375 "tracker-sparql-expression.vala"
				_tmp10_ = _tmp9_->literal;
#line 375 "tracker-sparql-expression.vala"
				type = tracker_sparql_expression_translate_function (self, sql, _tmp10_, &_inner_error0_);
#line 375 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 375 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 375 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 375 "tracker-sparql-expression.vala"
						_g_free0 (_tmp1_);
#line 375 "tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 375 "tracker-sparql-expression.vala"
						return;
#line 3564 "tracker-sparql-expression.c"
					} else {
#line 375 "tracker-sparql-expression.vala"
						_g_free0 (_tmp1_);
#line 375 "tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 375 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 375 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 375 "tracker-sparql-expression.vala"
						return;
#line 3576 "tracker-sparql-expression.c"
					}
				}
#line 376 "tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 376 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 376 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 376 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 376 "tracker-sparql-expression.vala"
						_g_free0 (_tmp1_);
#line 376 "tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 376 "tracker-sparql-expression.vala"
						return;
#line 3593 "tracker-sparql-expression.c"
					} else {
#line 376 "tracker-sparql-expression.vala"
						_g_free0 (_tmp1_);
#line 376 "tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 376 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 376 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 376 "tracker-sparql-expression.vala"
						return;
#line 3605 "tracker-sparql-expression.c"
					}
				}
#line 377 "tracker-sparql-expression.vala"
				_tmp11_ = type;
#line 377 "tracker-sparql-expression.vala"
				tracker_sparql_expression_convert_expression_to_string (sql, _tmp11_, begin);
#line 3612 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlQuery* _tmp12_;
				TrackerSparqlLiteralBinding* _tmp13_;
				TrackerSparqlLiteralBinding* _tmp14_;
#line 379 "tracker-sparql-expression.vala"
				g_string_append (sql, "?");
#line 380 "tracker-sparql-expression.vala"
				_tmp12_ = self->priv->query;
#line 380 "tracker-sparql-expression.vala"
				_tmp13_ = binding;
#line 380 "tracker-sparql-expression.vala"
				_tmp14_ = _g_object_ref0 (_tmp13_);
#line 380 "tracker-sparql-expression.vala"
				_tmp12_->bindings = g_list_append (_tmp12_->bindings, _tmp14_);
#line 3627 "tracker-sparql-expression.c"
			}
#line 382 "tracker-sparql-expression.vala"
			_g_free0 (_tmp1_);
#line 382 "tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 382 "tracker-sparql-expression.vala"
			break;
#line 3635 "tracker-sparql-expression.c"
		}
		default:
		{
			glong begin = 0L;
			TrackerPropertyType type = 0;
			TrackerPropertyType _tmp15_;
#line 384 "tracker-sparql-expression.vala"
			begin = (glong) sql->len;
#line 385 "tracker-sparql-expression.vala"
			type = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 385 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 385 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 385 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 385 "tracker-sparql-expression.vala"
					return;
#line 3654 "tracker-sparql-expression.c"
				} else {
#line 385 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 385 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 385 "tracker-sparql-expression.vala"
					return;
#line 3662 "tracker-sparql-expression.c"
				}
			}
#line 386 "tracker-sparql-expression.vala"
			_tmp15_ = type;
#line 386 "tracker-sparql-expression.vala"
			tracker_sparql_expression_convert_expression_to_string (sql, _tmp15_, begin);
#line 387 "tracker-sparql-expression.vala"
			break;
#line 3671 "tracker-sparql-expression.c"
		}
	}
}

static void
tracker_sparql_expression_translate_str (TrackerSparqlExpression* self,
                                         GString* sql,
                                         GError** error)
{
	GError* _inner_error0_ = NULL;
#line 391 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 391 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 392 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error0_);
#line 392 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 392 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 392 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 392 "tracker-sparql-expression.vala"
			return;
#line 3696 "tracker-sparql-expression.c"
		} else {
#line 392 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 392 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 392 "tracker-sparql-expression.vala"
			return;
#line 3704 "tracker-sparql-expression.c"
		}
	}
#line 393 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 393 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 393 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 393 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 393 "tracker-sparql-expression.vala"
			return;
#line 3717 "tracker-sparql-expression.c"
		} else {
#line 393 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 393 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 393 "tracker-sparql-expression.vala"
			return;
#line 3725 "tracker-sparql-expression.c"
		}
	}
#line 395 "tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 395 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 395 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 395 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 395 "tracker-sparql-expression.vala"
			return;
#line 3738 "tracker-sparql-expression.c"
		} else {
#line 395 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 395 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 395 "tracker-sparql-expression.vala"
			return;
#line 3746 "tracker-sparql-expression.c"
		}
	}
#line 397 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 397 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 397 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 397 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 397 "tracker-sparql-expression.vala"
			return;
#line 3759 "tracker-sparql-expression.c"
		} else {
#line 397 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 397 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 397 "tracker-sparql-expression.vala"
			return;
#line 3767 "tracker-sparql-expression.c"
		}
	}
}

static void
tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self,
                                           GString* sql,
                                           GError** error)
{
	gboolean _tmp0_ = FALSE;
	TrackerSparqlLiteralBinding* new_binding = NULL;
	TrackerSparqlLiteralBinding* _tmp1_;
	TrackerSparqlLiteralBinding* _tmp2_;
	TrackerSparqlQuery* _tmp13_;
	TrackerSparqlLiteralBinding* _tmp14_;
	TrackerSparqlLiteralBinding* _tmp15_;
	GError* _inner_error0_ = NULL;
#line 400 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 400 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 401 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error0_);
#line 401 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 401 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 401 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 401 "tracker-sparql-expression.vala"
			return;
#line 3799 "tracker-sparql-expression.c"
		} else {
#line 401 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 401 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 401 "tracker-sparql-expression.vala"
			return;
#line 3807 "tracker-sparql-expression.c"
		}
	}
#line 401 "tracker-sparql-expression.vala"
	if (!_tmp0_) {
#line 402 "tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error0_);
#line 402 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 402 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 402 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 402 "tracker-sparql-expression.vala"
				return;
#line 3822 "tracker-sparql-expression.c"
			} else {
#line 402 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 402 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 402 "tracker-sparql-expression.vala"
				return;
#line 3830 "tracker-sparql-expression.c"
			}
		}
	}
#line 405 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 405 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 405 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 405 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 405 "tracker-sparql-expression.vala"
			return;
#line 3844 "tracker-sparql-expression.c"
		} else {
#line 405 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 405 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 405 "tracker-sparql-expression.vala"
			return;
#line 3852 "tracker-sparql-expression.c"
		}
	}
#line 407 "tracker-sparql-expression.vala"
	g_string_append (sql, "?");
#line 408 "tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_literal_binding_new ();
#line 408 "tracker-sparql-expression.vala"
	new_binding = _tmp1_;
#line 409 "tracker-sparql-expression.vala"
	_tmp2_ = new_binding;
#line 409 "tracker-sparql-expression.vala"
	((TrackerSparqlDataBinding*) _tmp2_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 411 "tracker-sparql-expression.vala"
	if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 3867 "tracker-sparql-expression.c"
		TrackerSparqlLiteralBinding* _tmp3_;
		gchar* _tmp4_;
#line 412 "tracker-sparql-expression.vala"
		_tmp3_ = new_binding;
#line 412 "tracker-sparql-expression.vala"
		_tmp4_ = g_strdup ("1");
#line 412 "tracker-sparql-expression.vala"
		_g_free0 (_tmp3_->literal);
#line 412 "tracker-sparql-expression.vala"
		_tmp3_->literal = _tmp4_;
#line 413 "tracker-sparql-expression.vala"
		tracker_sparql_expression_next (self, &_inner_error0_);
#line 413 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 413 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 413 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 413 "tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 413 "tracker-sparql-expression.vala"
				return;
#line 3890 "tracker-sparql-expression.c"
			} else {
#line 413 "tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 413 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 413 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 413 "tracker-sparql-expression.vala"
				return;
#line 3900 "tracker-sparql-expression.c"
			}
		}
	} else {
		TrackerPropertyType _tmp5_ = 0;
		GString* _tmp6_;
		GString* _tmp7_;
		TrackerPropertyType _tmp8_;
#line 414 "tracker-sparql-expression.vala"
		_tmp6_ = g_string_new ("");
#line 414 "tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 414 "tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_translate_expression (self, _tmp7_, &_inner_error0_);
#line 414 "tracker-sparql-expression.vala"
		_g_string_free0 (_tmp7_);
#line 414 "tracker-sparql-expression.vala"
		_tmp5_ = _tmp8_;
#line 414 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 414 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 414 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 414 "tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 414 "tracker-sparql-expression.vala"
				return;
#line 3928 "tracker-sparql-expression.c"
			} else {
#line 414 "tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 414 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 414 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 414 "tracker-sparql-expression.vala"
				return;
#line 3938 "tracker-sparql-expression.c"
			}
		}
#line 414 "tracker-sparql-expression.vala"
		if (_tmp5_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 3943 "tracker-sparql-expression.c"
			TrackerSparqlLiteralBinding* _tmp9_;
			gchar* _tmp10_;
#line 415 "tracker-sparql-expression.vala"
			_tmp9_ = new_binding;
#line 415 "tracker-sparql-expression.vala"
			_tmp10_ = g_strdup ("1");
#line 415 "tracker-sparql-expression.vala"
			_g_free0 (_tmp9_->literal);
#line 415 "tracker-sparql-expression.vala"
			_tmp9_->literal = _tmp10_;
#line 3954 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlLiteralBinding* _tmp11_;
			gchar* _tmp12_;
#line 417 "tracker-sparql-expression.vala"
			_tmp11_ = new_binding;
#line 417 "tracker-sparql-expression.vala"
			_tmp12_ = g_strdup ("0");
#line 417 "tracker-sparql-expression.vala"
			_g_free0 (_tmp11_->literal);
#line 417 "tracker-sparql-expression.vala"
			_tmp11_->literal = _tmp12_;
#line 3966 "tracker-sparql-expression.c"
		}
	}
#line 420 "tracker-sparql-expression.vala"
	_tmp13_ = self->priv->query;
#line 420 "tracker-sparql-expression.vala"
	_tmp14_ = new_binding;
#line 420 "tracker-sparql-expression.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 420 "tracker-sparql-expression.vala"
	_tmp13_->bindings = g_list_append (_tmp13_->bindings, _tmp15_);
#line 422 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 422 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 422 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 422 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 422 "tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 422 "tracker-sparql-expression.vala"
			return;
#line 3989 "tracker-sparql-expression.c"
		} else {
#line 422 "tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 422 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 422 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 422 "tracker-sparql-expression.vala"
			return;
#line 3999 "tracker-sparql-expression.c"
		}
	}
#line 400 "tracker-sparql-expression.vala"
	_g_object_unref0 (new_binding);
#line 4004 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self,
                                              GString* sql,
                                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 425 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 425 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 426 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error0_);
#line 426 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 426 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 426 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 426 "tracker-sparql-expression.vala"
			return;
#line 4028 "tracker-sparql-expression.c"
		} else {
#line 426 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 426 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 426 "tracker-sparql-expression.vala"
			return;
#line 4036 "tracker-sparql-expression.c"
		}
	}
#line 427 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 427 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 427 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 427 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 427 "tracker-sparql-expression.vala"
			return;
#line 4049 "tracker-sparql-expression.c"
		} else {
#line 427 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 427 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 427 "tracker-sparql-expression.vala"
			return;
#line 4057 "tracker-sparql-expression.c"
		}
	}
#line 429 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error0_);
#line 429 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 429 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 429 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 429 "tracker-sparql-expression.vala"
			return;
#line 4070 "tracker-sparql-expression.c"
		} else {
#line 429 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 429 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 429 "tracker-sparql-expression.vala"
			return;
#line 4078 "tracker-sparql-expression.c"
		}
	}
#line 429 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 4083 "tracker-sparql-expression.c"
		gchar* variable_name = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		TrackerSparqlVariable* variable = NULL;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		const gchar* _tmp7_;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* _tmp9_;
		TrackerSparqlVariable* _tmp10_;
		TrackerSparqlVariableBinding* _tmp11_;
		gboolean _tmp19_ = FALSE;
		TrackerSparqlVariable* _tmp20_;
		TrackerSparqlVariableBinding* _tmp21_;
		TrackerPropertyType _tmp22_;
		TrackerSparqlLiteralBinding* new_binding = NULL;
		TrackerSparqlLiteralBinding* _tmp27_;
		TrackerSparqlLiteralBinding* _tmp28_;
		TrackerSparqlVariable* _tmp29_;
		TrackerSparqlVariableBinding* _tmp30_;
		TrackerClass* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		TrackerSparqlQuery* _tmp35_;
		TrackerSparqlLiteralBinding* _tmp36_;
		TrackerSparqlLiteralBinding* _tmp37_;
#line 430 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_get_last_string (self, 0);
#line 430 "tracker-sparql-expression.vala"
		_tmp2_ = _tmp1_;
#line 430 "tracker-sparql-expression.vala"
		_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
#line 430 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 430 "tracker-sparql-expression.vala"
		_g_free0 (_tmp2_);
#line 430 "tracker-sparql-expression.vala"
		variable_name = _tmp4_;
#line 431 "tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_expression_get_context (self);
#line 431 "tracker-sparql-expression.vala"
		_tmp6_ = _tmp5_;
#line 431 "tracker-sparql-expression.vala"
		_tmp7_ = variable_name;
#line 431 "tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_context_get_variable (_tmp6_, _tmp7_);
#line 431 "tracker-sparql-expression.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 431 "tracker-sparql-expression.vala"
		variable = _tmp9_;
#line 433 "tracker-sparql-expression.vala"
		_tmp10_ = variable;
#line 433 "tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_->binding;
#line 433 "tracker-sparql-expression.vala"
		if (_tmp11_ == NULL) {
#line 4143 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GError* _tmp17_;
			GError* _tmp18_;
#line 434 "tracker-sparql-expression.vala"
			_tmp12_ = variable;
#line 434 "tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_variable_get_name (_tmp12_);
#line 434 "tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 434 "tracker-sparql-expression.vala"
			_tmp15_ = g_strdup_printf ("`%s' is not a valid variable", _tmp14_);
#line 434 "tracker-sparql-expression.vala"
			_tmp16_ = _tmp15_;
#line 434 "tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_expression_get_error (self, _tmp16_);
#line 434 "tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 434 "tracker-sparql-expression.vala"
			_g_free0 (_tmp16_);
#line 434 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp18_;
#line 434 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 434 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 434 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 434 "tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 434 "tracker-sparql-expression.vala"
				return;
#line 4179 "tracker-sparql-expression.c"
			} else {
#line 434 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 434 "tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 434 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 434 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 434 "tracker-sparql-expression.vala"
				return;
#line 4191 "tracker-sparql-expression.c"
			}
		}
#line 437 "tracker-sparql-expression.vala"
		_tmp20_ = variable;
#line 437 "tracker-sparql-expression.vala"
		_tmp21_ = _tmp20_->binding;
#line 437 "tracker-sparql-expression.vala"
		_tmp22_ = ((TrackerSparqlDataBinding*) _tmp21_)->data_type;
#line 437 "tracker-sparql-expression.vala"
		if (_tmp22_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 437 "tracker-sparql-expression.vala"
			_tmp19_ = TRUE;
#line 4204 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlVariable* _tmp23_;
			TrackerSparqlVariableBinding* _tmp24_;
			TrackerClass* _tmp25_;
#line 437 "tracker-sparql-expression.vala"
			_tmp23_ = variable;
#line 437 "tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_->binding;
#line 437 "tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_->type;
#line 437 "tracker-sparql-expression.vala"
			_tmp19_ = _tmp25_ == NULL;
#line 4217 "tracker-sparql-expression.c"
		}
#line 437 "tracker-sparql-expression.vala"
		if (_tmp19_) {
#line 4221 "tracker-sparql-expression.c"
			GError* _tmp26_;
#line 438 "tracker-sparql-expression.vala"
			_tmp26_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 438 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp26_;
#line 438 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 438 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 438 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 438 "tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 438 "tracker-sparql-expression.vala"
				return;
#line 4237 "tracker-sparql-expression.c"
			} else {
#line 438 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 438 "tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 438 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 438 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 438 "tracker-sparql-expression.vala"
				return;
#line 4249 "tracker-sparql-expression.c"
			}
		}
#line 441 "tracker-sparql-expression.vala"
		g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 443 "tracker-sparql-expression.vala"
		_tmp27_ = tracker_sparql_literal_binding_new ();
#line 443 "tracker-sparql-expression.vala"
		new_binding = _tmp27_;
#line 444 "tracker-sparql-expression.vala"
		_tmp28_ = new_binding;
#line 444 "tracker-sparql-expression.vala"
		_tmp29_ = variable;
#line 444 "tracker-sparql-expression.vala"
		_tmp30_ = _tmp29_->binding;
#line 444 "tracker-sparql-expression.vala"
		_tmp31_ = _tmp30_->type;
#line 444 "tracker-sparql-expression.vala"
		_tmp32_ = tracker_class_get_uri (_tmp31_);
#line 444 "tracker-sparql-expression.vala"
		_tmp33_ = _tmp32_;
#line 444 "tracker-sparql-expression.vala"
		_tmp34_ = g_strdup (_tmp33_);
#line 444 "tracker-sparql-expression.vala"
		_g_free0 (_tmp28_->literal);
#line 444 "tracker-sparql-expression.vala"
		_tmp28_->literal = _tmp34_;
#line 445 "tracker-sparql-expression.vala"
		_tmp35_ = self->priv->query;
#line 445 "tracker-sparql-expression.vala"
		_tmp36_ = new_binding;
#line 445 "tracker-sparql-expression.vala"
		_tmp37_ = _g_object_ref0 (_tmp36_);
#line 445 "tracker-sparql-expression.vala"
		_tmp35_->bindings = g_list_append (_tmp35_->bindings, _tmp37_);
#line 429 "tracker-sparql-expression.vala"
		_g_object_unref0 (new_binding);
#line 429 "tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 429 "tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 4290 "tracker-sparql-expression.c"
	} else {
		GError* _tmp38_;
#line 448 "tracker-sparql-expression.vala"
		_tmp38_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 448 "tracker-sparql-expression.vala"
		_inner_error0_ = _tmp38_;
#line 448 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 448 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 448 "tracker-sparql-expression.vala"
			return;
#line 4303 "tracker-sparql-expression.c"
		} else {
#line 448 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 448 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 448 "tracker-sparql-expression.vala"
			return;
#line 4311 "tracker-sparql-expression.c"
		}
	}
#line 451 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 451 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 451 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 451 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 451 "tracker-sparql-expression.vala"
			return;
#line 4324 "tracker-sparql-expression.c"
		} else {
#line 451 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 451 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 451 "tracker-sparql-expression.vala"
			return;
#line 4332 "tracker-sparql-expression.c"
		}
	}
}

static void
tracker_sparql_expression_translate_date (TrackerSparqlExpression* self,
                                          GString* sql,
                                          const gchar* format,
                                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 454 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 454 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 454 "tracker-sparql-expression.vala"
	g_return_if_fail (format != NULL);
#line 455 "tracker-sparql-expression.vala"
	g_string_append_printf (sql, "strftime (\"%s\", ", format);
#line 457 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error0_);
#line 457 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 457 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 457 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 457 "tracker-sparql-expression.vala"
			return;
#line 4363 "tracker-sparql-expression.c"
		} else {
#line 457 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 457 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 457 "tracker-sparql-expression.vala"
			return;
#line 4371 "tracker-sparql-expression.c"
		}
	}
#line 457 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 4376 "tracker-sparql-expression.c"
		gchar* variable_name = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		TrackerSparqlVariable* variable = NULL;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		const gchar* _tmp7_;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* _tmp9_;
		TrackerSparqlVariable* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 458 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_get_last_string (self, 0);
#line 458 "tracker-sparql-expression.vala"
		_tmp2_ = _tmp1_;
#line 458 "tracker-sparql-expression.vala"
		_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
#line 458 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 458 "tracker-sparql-expression.vala"
		_g_free0 (_tmp2_);
#line 458 "tracker-sparql-expression.vala"
		variable_name = _tmp4_;
#line 459 "tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_expression_get_context (self);
#line 459 "tracker-sparql-expression.vala"
		_tmp6_ = _tmp5_;
#line 459 "tracker-sparql-expression.vala"
		_tmp7_ = variable_name;
#line 459 "tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_context_get_variable (_tmp6_, _tmp7_);
#line 459 "tracker-sparql-expression.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 459 "tracker-sparql-expression.vala"
		variable = _tmp9_;
#line 460 "tracker-sparql-expression.vala"
		_tmp10_ = variable;
#line 460 "tracker-sparql-expression.vala"
		_tmp11_ = tracker_sparql_variable_get_extra_sql_expression (_tmp10_, "localDate");
#line 460 "tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_;
#line 460 "tracker-sparql-expression.vala"
		g_string_append (sql, _tmp12_);
#line 460 "tracker-sparql-expression.vala"
		_g_free0 (_tmp12_);
#line 461 "tracker-sparql-expression.vala"
		g_string_append (sql, " * 24 * 3600");
#line 457 "tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 457 "tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 4431 "tracker-sparql-expression.c"
	} else {
#line 463 "tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 463 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 463 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 463 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 463 "tracker-sparql-expression.vala"
				return;
#line 4443 "tracker-sparql-expression.c"
			} else {
#line 463 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 463 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 463 "tracker-sparql-expression.vala"
				return;
#line 4451 "tracker-sparql-expression.c"
			}
		}
	}
#line 466 "tracker-sparql-expression.vala"
	g_string_append (sql, ", \"unixepoch\")");
#line 4457 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_translate_time (TrackerSparqlExpression* self,
                                          GString* sql,
                                          TrackerSparqlExpressionTimeFormatType type,
                                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 469 "tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 469 "tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 470 "tracker-sparql-expression.vala"
	g_string_append (sql, "(");
#line 471 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error0_);
#line 471 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 471 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 471 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 471 "tracker-sparql-expression.vala"
			return;
#line 4484 "tracker-sparql-expression.c"
		} else {
#line 471 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 471 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 471 "tracker-sparql-expression.vala"
			return;
#line 4492 "tracker-sparql-expression.c"
		}
	}
#line 471 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 4497 "tracker-sparql-expression.c"
		gchar* variable_name = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		TrackerSparqlVariable* variable = NULL;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		const gchar* _tmp7_;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* _tmp9_;
		TrackerSparqlVariable* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 472 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_get_last_string (self, 0);
#line 472 "tracker-sparql-expression.vala"
		_tmp2_ = _tmp1_;
#line 472 "tracker-sparql-expression.vala"
		_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
#line 472 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 472 "tracker-sparql-expression.vala"
		_g_free0 (_tmp2_);
#line 472 "tracker-sparql-expression.vala"
		variable_name = _tmp4_;
#line 473 "tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_expression_get_context (self);
#line 473 "tracker-sparql-expression.vala"
		_tmp6_ = _tmp5_;
#line 473 "tracker-sparql-expression.vala"
		_tmp7_ = variable_name;
#line 473 "tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_context_get_variable (_tmp6_, _tmp7_);
#line 473 "tracker-sparql-expression.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 473 "tracker-sparql-expression.vala"
		variable = _tmp9_;
#line 474 "tracker-sparql-expression.vala"
		_tmp10_ = variable;
#line 474 "tracker-sparql-expression.vala"
		_tmp11_ = tracker_sparql_variable_get_extra_sql_expression (_tmp10_, "localTime");
#line 474 "tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_;
#line 474 "tracker-sparql-expression.vala"
		g_string_append (sql, _tmp12_);
#line 474 "tracker-sparql-expression.vala"
		_g_free0 (_tmp12_);
#line 471 "tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 471 "tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 4550 "tracker-sparql-expression.c"
	} else {
#line 476 "tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 476 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 476 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 476 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 476 "tracker-sparql-expression.vala"
				return;
#line 4562 "tracker-sparql-expression.c"
			} else {
#line 476 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 476 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 476 "tracker-sparql-expression.vala"
				return;
#line 4570 "tracker-sparql-expression.c"
			}
		}
	}
#line 479 "tracker-sparql-expression.vala"
	switch (type) {
#line 479 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_SECONDS:
#line 4578 "tracker-sparql-expression.c"
		{
#line 481 "tracker-sparql-expression.vala"
			g_string_append (sql, "% 60");
#line 482 "tracker-sparql-expression.vala"
			break;
#line 4584 "tracker-sparql-expression.c"
		}
#line 479 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_MINUTES:
#line 4588 "tracker-sparql-expression.c"
		{
#line 484 "tracker-sparql-expression.vala"
			g_string_append (sql, " / 60 % 60");
#line 485 "tracker-sparql-expression.vala"
			break;
#line 4594 "tracker-sparql-expression.c"
		}
#line 479 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_HOURS:
#line 4598 "tracker-sparql-expression.c"
		{
#line 487 "tracker-sparql-expression.vala"
			g_string_append (sql, " / 3600 % 24");
#line 488 "tracker-sparql-expression.vala"
			break;
#line 4604 "tracker-sparql-expression.c"
		}
		default:
#line 479 "tracker-sparql-expression.vala"
		break;
#line 4609 "tracker-sparql-expression.c"
	}
#line 490 "tracker-sparql-expression.vala"
	g_string_append (sql, ")");
#line 4613 "tracker-sparql-expression.c"
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1019 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1019 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1020 "glib-2.0.vapi"
	_tmp1_ = str;
#line 1020 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 1021 "glib-2.0.vapi"
	result = str;
#line 1021 "glib-2.0.vapi"
	return result;
#line 4635 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_function (TrackerSparqlExpression* self,
                                              GString* sql,
                                              const gchar* uri,
                                              GError** error)
{
	TrackerPropertyType result = 0;
	GError* _inner_error0_ = NULL;
#line 493 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 493 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 493 "tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 494 "tracker-sparql-expression.vala"
	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
#line 496 "tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 496 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 496 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 496 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 496 "tracker-sparql-expression.vala"
				return 0;
#line 4664 "tracker-sparql-expression.c"
			} else {
#line 496 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 496 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 496 "tracker-sparql-expression.vala"
				return 0;
#line 4672 "tracker-sparql-expression.c"
			}
		}
#line 498 "tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_STRING;
#line 498 "tracker-sparql-expression.vala"
		return result;
#line 4679 "tracker-sparql-expression.c"
	} else {
#line 499 "tracker-sparql-expression.vala"
		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 501 "tracker-sparql-expression.vala"
			g_string_append (sql, "CAST (");
#line 502 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 502 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 502 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 502 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 502 "tracker-sparql-expression.vala"
					return 0;
#line 4695 "tracker-sparql-expression.c"
				} else {
#line 502 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 502 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 502 "tracker-sparql-expression.vala"
					return 0;
#line 4703 "tracker-sparql-expression.c"
				}
			}
#line 503 "tracker-sparql-expression.vala"
			g_string_append (sql, " AS INTEGER)");
#line 505 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 505 "tracker-sparql-expression.vala"
			return result;
#line 4712 "tracker-sparql-expression.c"
		} else {
#line 506 "tracker-sparql-expression.vala"
			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 508 "tracker-sparql-expression.vala"
				g_string_append (sql, "CAST (");
#line 509 "tracker-sparql-expression.vala"
				tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 509 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 509 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 509 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 509 "tracker-sparql-expression.vala"
						return 0;
#line 4728 "tracker-sparql-expression.c"
					} else {
#line 509 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 509 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 509 "tracker-sparql-expression.vala"
						return 0;
#line 4736 "tracker-sparql-expression.c"
					}
				}
#line 510 "tracker-sparql-expression.vala"
				g_string_append (sql, " AS REAL)");
#line 512 "tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 512 "tracker-sparql-expression.vala"
				return result;
#line 4745 "tracker-sparql-expression.c"
			} else {
#line 513 "tracker-sparql-expression.vala"
				if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "case-fold") == 0) {
#line 515 "tracker-sparql-expression.vala"
					g_string_append (sql, "SparqlCaseFold (");
#line 516 "tracker-sparql-expression.vala"
					tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 516 "tracker-sparql-expression.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 516 "tracker-sparql-expression.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 516 "tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error0_);
#line 516 "tracker-sparql-expression.vala"
							return 0;
#line 4761 "tracker-sparql-expression.c"
						} else {
#line 516 "tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 516 "tracker-sparql-expression.vala"
							g_clear_error (&_inner_error0_);
#line 516 "tracker-sparql-expression.vala"
							return 0;
#line 4769 "tracker-sparql-expression.c"
						}
					}
#line 517 "tracker-sparql-expression.vala"
					g_string_append (sql, ")");
#line 518 "tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 518 "tracker-sparql-expression.vala"
					return result;
#line 4778 "tracker-sparql-expression.c"
				} else {
#line 519 "tracker-sparql-expression.vala"
					if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "ascii-lower-case") == 0) {
#line 521 "tracker-sparql-expression.vala"
						g_string_append (sql, "lower (");
#line 522 "tracker-sparql-expression.vala"
						tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 522 "tracker-sparql-expression.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 522 "tracker-sparql-expression.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 522 "tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error0_);
#line 522 "tracker-sparql-expression.vala"
								return 0;
#line 4794 "tracker-sparql-expression.c"
							} else {
#line 522 "tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 522 "tracker-sparql-expression.vala"
								g_clear_error (&_inner_error0_);
#line 522 "tracker-sparql-expression.vala"
								return 0;
#line 4802 "tracker-sparql-expression.c"
							}
						}
#line 523 "tracker-sparql-expression.vala"
						g_string_append (sql, ")");
#line 524 "tracker-sparql-expression.vala"
						result = TRACKER_PROPERTY_TYPE_STRING;
#line 524 "tracker-sparql-expression.vala"
						return result;
#line 4811 "tracker-sparql-expression.c"
					} else {
#line 525 "tracker-sparql-expression.vala"
						if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "title-order") == 0) {
#line 526 "tracker-sparql-expression.vala"
							tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 526 "tracker-sparql-expression.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 526 "tracker-sparql-expression.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 526 "tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error0_);
#line 526 "tracker-sparql-expression.vala"
									return 0;
#line 4825 "tracker-sparql-expression.c"
								} else {
#line 526 "tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 526 "tracker-sparql-expression.vala"
									g_clear_error (&_inner_error0_);
#line 526 "tracker-sparql-expression.vala"
									return 0;
#line 4833 "tracker-sparql-expression.c"
								}
							}
#line 527 "tracker-sparql-expression.vala"
							g_string_append_printf (sql, " COLLATE %s", TRACKER_TITLE_COLLATION_NAME);
#line 528 "tracker-sparql-expression.vala"
							result = TRACKER_PROPERTY_TYPE_STRING;
#line 528 "tracker-sparql-expression.vala"
							return result;
#line 4842 "tracker-sparql-expression.c"
						} else {
#line 529 "tracker-sparql-expression.vala"
							if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
#line 531 "tracker-sparql-expression.vala"
								g_string_append (sql, "SparqlLowerCase (");
#line 532 "tracker-sparql-expression.vala"
								tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 532 "tracker-sparql-expression.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 532 "tracker-sparql-expression.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 532 "tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error0_);
#line 532 "tracker-sparql-expression.vala"
										return 0;
#line 4858 "tracker-sparql-expression.c"
									} else {
#line 532 "tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 532 "tracker-sparql-expression.vala"
										g_clear_error (&_inner_error0_);
#line 532 "tracker-sparql-expression.vala"
										return 0;
#line 4866 "tracker-sparql-expression.c"
									}
								}
#line 533 "tracker-sparql-expression.vala"
								g_string_append (sql, ")");
#line 534 "tracker-sparql-expression.vala"
								result = TRACKER_PROPERTY_TYPE_STRING;
#line 534 "tracker-sparql-expression.vala"
								return result;
#line 4875 "tracker-sparql-expression.c"
							} else {
#line 535 "tracker-sparql-expression.vala"
								if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "upper-case") == 0) {
#line 536 "tracker-sparql-expression.vala"
									g_string_append (sql, "SparqlUpperCase (");
#line 537 "tracker-sparql-expression.vala"
									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 537 "tracker-sparql-expression.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 537 "tracker-sparql-expression.vala"
										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 537 "tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error0_);
#line 537 "tracker-sparql-expression.vala"
											return 0;
#line 4891 "tracker-sparql-expression.c"
										} else {
#line 537 "tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 537 "tracker-sparql-expression.vala"
											g_clear_error (&_inner_error0_);
#line 537 "tracker-sparql-expression.vala"
											return 0;
#line 4899 "tracker-sparql-expression.c"
										}
									}
#line 538 "tracker-sparql-expression.vala"
									g_string_append (sql, ")");
#line 539 "tracker-sparql-expression.vala"
									result = TRACKER_PROPERTY_TYPE_STRING;
#line 539 "tracker-sparql-expression.vala"
									return result;
#line 4908 "tracker-sparql-expression.c"
								} else {
#line 540 "tracker-sparql-expression.vala"
									if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "normalize") == 0) {
#line 542 "tracker-sparql-expression.vala"
										g_string_append (sql, "SparqlNormalize (");
#line 543 "tracker-sparql-expression.vala"
										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 543 "tracker-sparql-expression.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 543 "tracker-sparql-expression.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 543 "tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error0_);
#line 543 "tracker-sparql-expression.vala"
												return 0;
#line 4924 "tracker-sparql-expression.c"
											} else {
#line 543 "tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 543 "tracker-sparql-expression.vala"
												g_clear_error (&_inner_error0_);
#line 543 "tracker-sparql-expression.vala"
												return 0;
#line 4932 "tracker-sparql-expression.c"
											}
										}
#line 544 "tracker-sparql-expression.vala"
										g_string_append (sql, ", ");
#line 545 "tracker-sparql-expression.vala"
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 545 "tracker-sparql-expression.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 545 "tracker-sparql-expression.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 545 "tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error0_);
#line 545 "tracker-sparql-expression.vala"
												return 0;
#line 4947 "tracker-sparql-expression.c"
											} else {
#line 545 "tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 545 "tracker-sparql-expression.vala"
												g_clear_error (&_inner_error0_);
#line 545 "tracker-sparql-expression.vala"
												return 0;
#line 4955 "tracker-sparql-expression.c"
											}
										}
#line 546 "tracker-sparql-expression.vala"
										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 546 "tracker-sparql-expression.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 546 "tracker-sparql-expression.vala"
											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 546 "tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error0_);
#line 546 "tracker-sparql-expression.vala"
												return 0;
#line 4968 "tracker-sparql-expression.c"
											} else {
#line 546 "tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 546 "tracker-sparql-expression.vala"
												g_clear_error (&_inner_error0_);
#line 546 "tracker-sparql-expression.vala"
												return 0;
#line 4976 "tracker-sparql-expression.c"
											}
										}
#line 547 "tracker-sparql-expression.vala"
										g_string_append (sql, ")");
#line 548 "tracker-sparql-expression.vala"
										result = TRACKER_PROPERTY_TYPE_STRING;
#line 548 "tracker-sparql-expression.vala"
										return result;
#line 4985 "tracker-sparql-expression.c"
									} else {
#line 549 "tracker-sparql-expression.vala"
										if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "unaccent") == 0) {
#line 551 "tracker-sparql-expression.vala"
											g_string_append (sql, "SparqlUnaccent (");
#line 552 "tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 552 "tracker-sparql-expression.vala"
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 552 "tracker-sparql-expression.vala"
												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 552 "tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error0_);
#line 552 "tracker-sparql-expression.vala"
													return 0;
#line 5001 "tracker-sparql-expression.c"
												} else {
#line 552 "tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 552 "tracker-sparql-expression.vala"
													g_clear_error (&_inner_error0_);
#line 552 "tracker-sparql-expression.vala"
													return 0;
#line 5009 "tracker-sparql-expression.c"
												}
											}
#line 553 "tracker-sparql-expression.vala"
											g_string_append (sql, ")");
#line 554 "tracker-sparql-expression.vala"
											result = TRACKER_PROPERTY_TYPE_STRING;
#line 554 "tracker-sparql-expression.vala"
											return result;
#line 5018 "tracker-sparql-expression.c"
										} else {
#line 555 "tracker-sparql-expression.vala"
											if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
#line 5022 "tracker-sparql-expression.c"
												TrackerSparqlLiteralBinding* binding = NULL;
												TrackerSparqlLiteralBinding* _tmp0_;
												gchar* _tmp1_ = NULL;
												gchar* _tmp2_;
												TrackerSparqlLiteralBinding* _tmp3_;
												gchar* _tmp4_;
												TrackerSparqlQuery* _tmp5_;
												TrackerSparqlLiteralBinding* _tmp6_;
												TrackerSparqlLiteralBinding* _tmp7_;
#line 557 "tracker-sparql-expression.vala"
												g_string_append (sql, "(");
#line 558 "tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 558 "tracker-sparql-expression.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 558 "tracker-sparql-expression.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 558 "tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error0_);
#line 558 "tracker-sparql-expression.vala"
														return 0;
#line 5044 "tracker-sparql-expression.c"
													} else {
#line 558 "tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 558 "tracker-sparql-expression.vala"
														g_clear_error (&_inner_error0_);
#line 558 "tracker-sparql-expression.vala"
														return 0;
#line 5052 "tracker-sparql-expression.c"
													}
												}
#line 559 "tracker-sparql-expression.vala"
												g_string_append (sql, " GLOB ");
#line 560 "tracker-sparql-expression.vala"
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 560 "tracker-sparql-expression.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 560 "tracker-sparql-expression.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 560 "tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error0_);
#line 560 "tracker-sparql-expression.vala"
														return 0;
#line 5067 "tracker-sparql-expression.c"
													} else {
#line 560 "tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 560 "tracker-sparql-expression.vala"
														g_clear_error (&_inner_error0_);
#line 560 "tracker-sparql-expression.vala"
														return 0;
#line 5075 "tracker-sparql-expression.c"
													}
												}
#line 562 "tracker-sparql-expression.vala"
												g_string_append (sql, "?");
#line 563 "tracker-sparql-expression.vala"
												_tmp0_ = tracker_sparql_literal_binding_new ();
#line 563 "tracker-sparql-expression.vala"
												binding = _tmp0_;
#line 564 "tracker-sparql-expression.vala"
												_tmp2_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 564 "tracker-sparql-expression.vala"
												_tmp1_ = _tmp2_;
#line 564 "tracker-sparql-expression.vala"
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 564 "tracker-sparql-expression.vala"
													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 564 "tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error0_);
#line 564 "tracker-sparql-expression.vala"
														_g_object_unref0 (binding);
#line 564 "tracker-sparql-expression.vala"
														return 0;
#line 5098 "tracker-sparql-expression.c"
													} else {
#line 564 "tracker-sparql-expression.vala"
														_g_object_unref0 (binding);
#line 564 "tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 564 "tracker-sparql-expression.vala"
														g_clear_error (&_inner_error0_);
#line 564 "tracker-sparql-expression.vala"
														return 0;
#line 5108 "tracker-sparql-expression.c"
													}
												}
#line 564 "tracker-sparql-expression.vala"
												_tmp3_ = binding;
#line 564 "tracker-sparql-expression.vala"
												_tmp4_ = g_strdup_printf ("*%s*", _tmp1_);
#line 564 "tracker-sparql-expression.vala"
												_g_free0 (_tmp3_->literal);
#line 564 "tracker-sparql-expression.vala"
												_tmp3_->literal = _tmp4_;
#line 565 "tracker-sparql-expression.vala"
												_tmp5_ = self->priv->query;
#line 565 "tracker-sparql-expression.vala"
												_tmp6_ = binding;
#line 565 "tracker-sparql-expression.vala"
												_tmp7_ = _g_object_ref0 (_tmp6_);
#line 565 "tracker-sparql-expression.vala"
												_tmp5_->bindings = g_list_append (_tmp5_->bindings, _tmp7_);
#line 567 "tracker-sparql-expression.vala"
												g_string_append (sql, ")");
#line 569 "tracker-sparql-expression.vala"
												result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 569 "tracker-sparql-expression.vala"
												_g_free0 (_tmp1_);
#line 569 "tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 569 "tracker-sparql-expression.vala"
												return result;
#line 5137 "tracker-sparql-expression.c"
											} else {
#line 570 "tracker-sparql-expression.vala"
												if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
#line 5141 "tracker-sparql-expression.c"
													gchar* prefix = NULL;
													gchar* _tmp8_;
													TrackerSparqlLiteralBinding* binding = NULL;
													TrackerSparqlLiteralBinding* _tmp9_;
													TrackerSparqlLiteralBinding* _tmp10_;
													const gchar* _tmp11_;
													gchar* _tmp12_;
													TrackerSparqlQuery* _tmp13_;
													TrackerSparqlLiteralBinding* _tmp14_;
													TrackerSparqlLiteralBinding* _tmp15_;
													TrackerSparqlLiteralBinding* _tmp16_;
													TrackerSparqlLiteralBinding* _tmp17_;
													const gchar* _tmp18_;
													gchar* _tmp19_;
													gchar* _tmp20_;
													gchar* _tmp21_;
													TrackerSparqlQuery* _tmp22_;
													TrackerSparqlLiteralBinding* _tmp23_;
													TrackerSparqlLiteralBinding* _tmp24_;
#line 574 "tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 574 "tracker-sparql-expression.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 574 "tracker-sparql-expression.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 574 "tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error0_);
#line 574 "tracker-sparql-expression.vala"
															return 0;
#line 5171 "tracker-sparql-expression.c"
														} else {
#line 574 "tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 574 "tracker-sparql-expression.vala"
															g_clear_error (&_inner_error0_);
#line 574 "tracker-sparql-expression.vala"
															return 0;
#line 5179 "tracker-sparql-expression.c"
														}
													}
#line 575 "tracker-sparql-expression.vala"
													g_string_append (sql, " BETWEEN ");
#line 577 "tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 577 "tracker-sparql-expression.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 577 "tracker-sparql-expression.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 577 "tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error0_);
#line 577 "tracker-sparql-expression.vala"
															return 0;
#line 5194 "tracker-sparql-expression.c"
														} else {
#line 577 "tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 577 "tracker-sparql-expression.vala"
															g_clear_error (&_inner_error0_);
#line 577 "tracker-sparql-expression.vala"
															return 0;
#line 5202 "tracker-sparql-expression.c"
														}
													}
#line 578 "tracker-sparql-expression.vala"
													_tmp8_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 578 "tracker-sparql-expression.vala"
													prefix = _tmp8_;
#line 578 "tracker-sparql-expression.vala"
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 578 "tracker-sparql-expression.vala"
														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 578 "tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error0_);
#line 578 "tracker-sparql-expression.vala"
															return 0;
#line 5217 "tracker-sparql-expression.c"
														} else {
#line 578 "tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 578 "tracker-sparql-expression.vala"
															g_clear_error (&_inner_error0_);
#line 578 "tracker-sparql-expression.vala"
															return 0;
#line 5225 "tracker-sparql-expression.c"
														}
													}
#line 580 "tracker-sparql-expression.vala"
													g_string_append (sql, "?");
#line 581 "tracker-sparql-expression.vala"
													_tmp9_ = tracker_sparql_literal_binding_new ();
#line 581 "tracker-sparql-expression.vala"
													binding = _tmp9_;
#line 582 "tracker-sparql-expression.vala"
													_tmp10_ = binding;
#line 582 "tracker-sparql-expression.vala"
													_tmp11_ = prefix;
#line 582 "tracker-sparql-expression.vala"
													_tmp12_ = g_strdup (_tmp11_);
#line 582 "tracker-sparql-expression.vala"
													_g_free0 (_tmp10_->literal);
#line 582 "tracker-sparql-expression.vala"
													_tmp10_->literal = _tmp12_;
#line 583 "tracker-sparql-expression.vala"
													_tmp13_ = self->priv->query;
#line 583 "tracker-sparql-expression.vala"
													_tmp14_ = binding;
#line 583 "tracker-sparql-expression.vala"
													_tmp15_ = _g_object_ref0 (_tmp14_);
#line 583 "tracker-sparql-expression.vala"
													_tmp13_->bindings = g_list_append (_tmp13_->bindings, _tmp15_);
#line 585 "tracker-sparql-expression.vala"
													g_string_append (sql, " AND ");
#line 587 "tracker-sparql-expression.vala"
													g_string_append (sql, "?");
#line 588 "tracker-sparql-expression.vala"
													_tmp16_ = tracker_sparql_literal_binding_new ();
#line 588 "tracker-sparql-expression.vala"
													_g_object_unref0 (binding);
#line 588 "tracker-sparql-expression.vala"
													binding = _tmp16_;
#line 589 "tracker-sparql-expression.vala"
													_tmp17_ = binding;
#line 589 "tracker-sparql-expression.vala"
													_tmp18_ = prefix;
#line 589 "tracker-sparql-expression.vala"
													_tmp19_ = g_unichar_to_string (TRACKER_COLLATION_LAST_CHAR);
#line 589 "tracker-sparql-expression.vala"
													_tmp20_ = _tmp19_;
#line 589 "tracker-sparql-expression.vala"
													_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
#line 589 "tracker-sparql-expression.vala"
													_g_free0 (_tmp17_->literal);
#line 589 "tracker-sparql-expression.vala"
													_tmp17_->literal = _tmp21_;
#line 589 "tracker-sparql-expression.vala"
													_g_free0 (_tmp20_);
#line 590 "tracker-sparql-expression.vala"
													_tmp22_ = self->priv->query;
#line 590 "tracker-sparql-expression.vala"
													_tmp23_ = binding;
#line 590 "tracker-sparql-expression.vala"
													_tmp24_ = _g_object_ref0 (_tmp23_);
#line 590 "tracker-sparql-expression.vala"
													_tmp22_->bindings = g_list_append (_tmp22_->bindings, _tmp24_);
#line 592 "tracker-sparql-expression.vala"
													result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 592 "tracker-sparql-expression.vala"
													_g_object_unref0 (binding);
#line 592 "tracker-sparql-expression.vala"
													_g_free0 (prefix);
#line 592 "tracker-sparql-expression.vala"
													return result;
#line 5294 "tracker-sparql-expression.c"
												} else {
#line 593 "tracker-sparql-expression.vala"
													if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
#line 5298 "tracker-sparql-expression.c"
														TrackerSparqlLiteralBinding* binding = NULL;
														TrackerSparqlLiteralBinding* _tmp25_;
														gchar* _tmp26_ = NULL;
														gchar* _tmp27_;
														TrackerSparqlLiteralBinding* _tmp28_;
														gchar* _tmp29_;
														TrackerSparqlQuery* _tmp30_;
														TrackerSparqlLiteralBinding* _tmp31_;
														TrackerSparqlLiteralBinding* _tmp32_;
#line 595 "tracker-sparql-expression.vala"
														g_string_append (sql, "(");
#line 596 "tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 596 "tracker-sparql-expression.vala"
														if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 596 "tracker-sparql-expression.vala"
															if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 596 "tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error0_);
#line 596 "tracker-sparql-expression.vala"
																return 0;
#line 5320 "tracker-sparql-expression.c"
															} else {
#line 596 "tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 596 "tracker-sparql-expression.vala"
																g_clear_error (&_inner_error0_);
#line 596 "tracker-sparql-expression.vala"
																return 0;
#line 5328 "tracker-sparql-expression.c"
															}
														}
#line 597 "tracker-sparql-expression.vala"
														g_string_append (sql, " GLOB ");
#line 598 "tracker-sparql-expression.vala"
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 598 "tracker-sparql-expression.vala"
														if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 598 "tracker-sparql-expression.vala"
															if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 598 "tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error0_);
#line 598 "tracker-sparql-expression.vala"
																return 0;
#line 5343 "tracker-sparql-expression.c"
															} else {
#line 598 "tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 598 "tracker-sparql-expression.vala"
																g_clear_error (&_inner_error0_);
#line 598 "tracker-sparql-expression.vala"
																return 0;
#line 5351 "tracker-sparql-expression.c"
															}
														}
#line 600 "tracker-sparql-expression.vala"
														g_string_append (sql, "?");
#line 601 "tracker-sparql-expression.vala"
														_tmp25_ = tracker_sparql_literal_binding_new ();
#line 601 "tracker-sparql-expression.vala"
														binding = _tmp25_;
#line 602 "tracker-sparql-expression.vala"
														_tmp27_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 602 "tracker-sparql-expression.vala"
														_tmp26_ = _tmp27_;
#line 602 "tracker-sparql-expression.vala"
														if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 602 "tracker-sparql-expression.vala"
															if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 602 "tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error0_);
#line 602 "tracker-sparql-expression.vala"
																_g_object_unref0 (binding);
#line 602 "tracker-sparql-expression.vala"
																return 0;
#line 5374 "tracker-sparql-expression.c"
															} else {
#line 602 "tracker-sparql-expression.vala"
																_g_object_unref0 (binding);
#line 602 "tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 602 "tracker-sparql-expression.vala"
																g_clear_error (&_inner_error0_);
#line 602 "tracker-sparql-expression.vala"
																return 0;
#line 5384 "tracker-sparql-expression.c"
															}
														}
#line 602 "tracker-sparql-expression.vala"
														_tmp28_ = binding;
#line 602 "tracker-sparql-expression.vala"
														_tmp29_ = g_strdup_printf ("*%s", _tmp26_);
#line 602 "tracker-sparql-expression.vala"
														_g_free0 (_tmp28_->literal);
#line 602 "tracker-sparql-expression.vala"
														_tmp28_->literal = _tmp29_;
#line 603 "tracker-sparql-expression.vala"
														_tmp30_ = self->priv->query;
#line 603 "tracker-sparql-expression.vala"
														_tmp31_ = binding;
#line 603 "tracker-sparql-expression.vala"
														_tmp32_ = _g_object_ref0 (_tmp31_);
#line 603 "tracker-sparql-expression.vala"
														_tmp30_->bindings = g_list_append (_tmp30_->bindings, _tmp32_);
#line 605 "tracker-sparql-expression.vala"
														g_string_append (sql, ")");
#line 607 "tracker-sparql-expression.vala"
														result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 607 "tracker-sparql-expression.vala"
														_g_free0 (_tmp26_);
#line 607 "tracker-sparql-expression.vala"
														_g_object_unref0 (binding);
#line 607 "tracker-sparql-expression.vala"
														return result;
#line 5413 "tracker-sparql-expression.c"
													} else {
#line 608 "tracker-sparql-expression.vala"
														if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
#line 5417 "tracker-sparql-expression.c"
															gboolean _tmp33_ = FALSE;
#line 609 "tracker-sparql-expression.vala"
															g_string_append (sql, "substr(");
#line 610 "tracker-sparql-expression.vala"
															tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 610 "tracker-sparql-expression.vala"
															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 610 "tracker-sparql-expression.vala"
																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 610 "tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error0_);
#line 610 "tracker-sparql-expression.vala"
																	return 0;
#line 5431 "tracker-sparql-expression.c"
																} else {
#line 610 "tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 610 "tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error0_);
#line 610 "tracker-sparql-expression.vala"
																	return 0;
#line 5439 "tracker-sparql-expression.c"
																}
															}
#line 612 "tracker-sparql-expression.vala"
															g_string_append (sql, ", ");
#line 613 "tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 613 "tracker-sparql-expression.vala"
															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 613 "tracker-sparql-expression.vala"
																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 613 "tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error0_);
#line 613 "tracker-sparql-expression.vala"
																	return 0;
#line 5454 "tracker-sparql-expression.c"
																} else {
#line 613 "tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 613 "tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error0_);
#line 613 "tracker-sparql-expression.vala"
																	return 0;
#line 5462 "tracker-sparql-expression.c"
																}
															}
#line 614 "tracker-sparql-expression.vala"
															tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 614 "tracker-sparql-expression.vala"
															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 614 "tracker-sparql-expression.vala"
																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 614 "tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error0_);
#line 614 "tracker-sparql-expression.vala"
																	return 0;
#line 5475 "tracker-sparql-expression.c"
																} else {
#line 614 "tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 614 "tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error0_);
#line 614 "tracker-sparql-expression.vala"
																	return 0;
#line 5483 "tracker-sparql-expression.c"
																}
															}
#line 616 "tracker-sparql-expression.vala"
															_tmp33_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 616 "tracker-sparql-expression.vala"
															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 616 "tracker-sparql-expression.vala"
																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error0_);
#line 616 "tracker-sparql-expression.vala"
																	return 0;
#line 5496 "tracker-sparql-expression.c"
																} else {
#line 616 "tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 616 "tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error0_);
#line 616 "tracker-sparql-expression.vala"
																	return 0;
#line 5504 "tracker-sparql-expression.c"
																}
															}
#line 616 "tracker-sparql-expression.vala"
															if (_tmp33_) {
#line 617 "tracker-sparql-expression.vala"
																g_string_append (sql, ", ");
#line 618 "tracker-sparql-expression.vala"
																tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 618 "tracker-sparql-expression.vala"
																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 618 "tracker-sparql-expression.vala"
																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 618 "tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error0_);
#line 618 "tracker-sparql-expression.vala"
																		return 0;
#line 5521 "tracker-sparql-expression.c"
																	} else {
#line 618 "tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 618 "tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error0_);
#line 618 "tracker-sparql-expression.vala"
																		return 0;
#line 5529 "tracker-sparql-expression.c"
																	}
																}
															}
#line 621 "tracker-sparql-expression.vala"
															g_string_append (sql, ")");
#line 623 "tracker-sparql-expression.vala"
															result = TRACKER_PROPERTY_TYPE_STRING;
#line 623 "tracker-sparql-expression.vala"
															return result;
#line 5539 "tracker-sparql-expression.c"
														} else {
#line 624 "tracker-sparql-expression.vala"
															if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
#line 625 "tracker-sparql-expression.vala"
																tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 625 "tracker-sparql-expression.vala"
																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 625 "tracker-sparql-expression.vala"
																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 625 "tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error0_);
#line 625 "tracker-sparql-expression.vala"
																		return 0;
#line 5553 "tracker-sparql-expression.c"
																	} else {
#line 625 "tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 625 "tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error0_);
#line 625 "tracker-sparql-expression.vala"
																		return 0;
#line 5561 "tracker-sparql-expression.c"
																	}
																}
#line 626 "tracker-sparql-expression.vala"
																g_string_append (sql, "||");
#line 627 "tracker-sparql-expression.vala"
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 627 "tracker-sparql-expression.vala"
																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 627 "tracker-sparql-expression.vala"
																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 627 "tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error0_);
#line 627 "tracker-sparql-expression.vala"
																		return 0;
#line 5576 "tracker-sparql-expression.c"
																	} else {
#line 627 "tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 627 "tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error0_);
#line 627 "tracker-sparql-expression.vala"
																		return 0;
#line 5584 "tracker-sparql-expression.c"
																	}
																}
#line 628 "tracker-sparql-expression.vala"
																tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 628 "tracker-sparql-expression.vala"
																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 628 "tracker-sparql-expression.vala"
																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 628 "tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error0_);
#line 628 "tracker-sparql-expression.vala"
																		return 0;
#line 5597 "tracker-sparql-expression.c"
																	} else {
#line 628 "tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 628 "tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error0_);
#line 628 "tracker-sparql-expression.vala"
																		return 0;
#line 5605 "tracker-sparql-expression.c"
																	}
																}
#line 629 "tracker-sparql-expression.vala"
																while (TRUE) {
#line 5610 "tracker-sparql-expression.c"
																	gboolean _tmp34_ = FALSE;
#line 629 "tracker-sparql-expression.vala"
																	_tmp34_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 629 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 629 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 629 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 629 "tracker-sparql-expression.vala"
																			return 0;
#line 5622 "tracker-sparql-expression.c"
																		} else {
#line 629 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 629 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 629 "tracker-sparql-expression.vala"
																			return 0;
#line 5630 "tracker-sparql-expression.c"
																		}
																	}
#line 629 "tracker-sparql-expression.vala"
																	if (!_tmp34_) {
#line 629 "tracker-sparql-expression.vala"
																		break;
#line 5637 "tracker-sparql-expression.c"
																	}
#line 630 "tracker-sparql-expression.vala"
																	g_string_append (sql, "||");
#line 631 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 631 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 631 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 631 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 631 "tracker-sparql-expression.vala"
																			return 0;
#line 5651 "tracker-sparql-expression.c"
																		} else {
#line 631 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 631 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 631 "tracker-sparql-expression.vala"
																			return 0;
#line 5659 "tracker-sparql-expression.c"
																		}
																	}
																}
#line 634 "tracker-sparql-expression.vala"
																result = TRACKER_PROPERTY_TYPE_STRING;
#line 634 "tracker-sparql-expression.vala"
																return result;
#line 5667 "tracker-sparql-expression.c"
															} else {
#line 635 "tracker-sparql-expression.vala"
																if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
#line 636 "tracker-sparql-expression.vala"
																	g_string_append (sql, "SparqlStringJoin(");
#line 637 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 637 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 637 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 637 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 637 "tracker-sparql-expression.vala"
																			return 0;
#line 5683 "tracker-sparql-expression.c"
																		} else {
#line 637 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 637 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 637 "tracker-sparql-expression.vala"
																			return 0;
#line 5691 "tracker-sparql-expression.c"
																		}
																	}
#line 639 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 639 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 639 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 639 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 639 "tracker-sparql-expression.vala"
																			return 0;
#line 5704 "tracker-sparql-expression.c"
																		} else {
#line 639 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 639 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 639 "tracker-sparql-expression.vala"
																			return 0;
#line 5712 "tracker-sparql-expression.c"
																		}
																	}
#line 640 "tracker-sparql-expression.vala"
																	g_string_append (sql, ", ");
#line 641 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 641 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 641 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 641 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 641 "tracker-sparql-expression.vala"
																			return 0;
#line 5727 "tracker-sparql-expression.c"
																		} else {
#line 641 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 641 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 641 "tracker-sparql-expression.vala"
																			return 0;
#line 5735 "tracker-sparql-expression.c"
																		}
																	}
#line 642 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 642 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 642 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 642 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 642 "tracker-sparql-expression.vala"
																			return 0;
#line 5748 "tracker-sparql-expression.c"
																		} else {
#line 642 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 642 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 642 "tracker-sparql-expression.vala"
																			return 0;
#line 5756 "tracker-sparql-expression.c"
																		}
																	}
#line 643 "tracker-sparql-expression.vala"
																	while (TRUE) {
#line 5761 "tracker-sparql-expression.c"
																		gboolean _tmp35_ = FALSE;
#line 643 "tracker-sparql-expression.vala"
																		_tmp35_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 643 "tracker-sparql-expression.vala"
																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 643 "tracker-sparql-expression.vala"
																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 643 "tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error0_);
#line 643 "tracker-sparql-expression.vala"
																				return 0;
#line 5773 "tracker-sparql-expression.c"
																			} else {
#line 643 "tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 643 "tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error0_);
#line 643 "tracker-sparql-expression.vala"
																				return 0;
#line 5781 "tracker-sparql-expression.c"
																			}
																		}
#line 643 "tracker-sparql-expression.vala"
																		if (!_tmp35_) {
#line 643 "tracker-sparql-expression.vala"
																			break;
#line 5788 "tracker-sparql-expression.c"
																		}
#line 644 "tracker-sparql-expression.vala"
																		g_string_append (sql, ", ");
#line 645 "tracker-sparql-expression.vala"
																		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 645 "tracker-sparql-expression.vala"
																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 645 "tracker-sparql-expression.vala"
																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 645 "tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error0_);
#line 645 "tracker-sparql-expression.vala"
																				return 0;
#line 5802 "tracker-sparql-expression.c"
																			} else {
#line 645 "tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 645 "tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error0_);
#line 645 "tracker-sparql-expression.vala"
																				return 0;
#line 5810 "tracker-sparql-expression.c"
																			}
																		}
																	}
#line 648 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 648 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 648 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 648 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 648 "tracker-sparql-expression.vala"
																			return 0;
#line 5824 "tracker-sparql-expression.c"
																		} else {
#line 648 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 648 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 648 "tracker-sparql-expression.vala"
																			return 0;
#line 5832 "tracker-sparql-expression.c"
																		}
																	}
#line 649 "tracker-sparql-expression.vala"
																	g_string_append (sql, ",");
#line 650 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 650 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 650 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 650 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 650 "tracker-sparql-expression.vala"
																			return 0;
#line 5847 "tracker-sparql-expression.c"
																		} else {
#line 650 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 650 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 650 "tracker-sparql-expression.vala"
																			return 0;
#line 5855 "tracker-sparql-expression.c"
																		}
																	}
#line 651 "tracker-sparql-expression.vala"
																	tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 651 "tracker-sparql-expression.vala"
																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 651 "tracker-sparql-expression.vala"
																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 651 "tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error0_);
#line 651 "tracker-sparql-expression.vala"
																			return 0;
#line 5868 "tracker-sparql-expression.c"
																		} else {
#line 651 "tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 651 "tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error0_);
#line 651 "tracker-sparql-expression.vala"
																			return 0;
#line 5876 "tracker-sparql-expression.c"
																		}
																	}
#line 652 "tracker-sparql-expression.vala"
																	g_string_append (sql, ")");
#line 654 "tracker-sparql-expression.vala"
																	result = TRACKER_PROPERTY_TYPE_STRING;
#line 654 "tracker-sparql-expression.vala"
																	return result;
#line 5885 "tracker-sparql-expression.c"
																} else {
#line 655 "tracker-sparql-expression.vala"
																	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
#line 656 "tracker-sparql-expression.vala"
																		tracker_sparql_expression_translate_date (self, sql, "%Y", &_inner_error0_);
#line 656 "tracker-sparql-expression.vala"
																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 656 "tracker-sparql-expression.vala"
																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 656 "tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error0_);
#line 656 "tracker-sparql-expression.vala"
																				return 0;
#line 5899 "tracker-sparql-expression.c"
																			} else {
#line 656 "tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 656 "tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error0_);
#line 656 "tracker-sparql-expression.vala"
																				return 0;
#line 5907 "tracker-sparql-expression.c"
																			}
																		}
#line 657 "tracker-sparql-expression.vala"
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 657 "tracker-sparql-expression.vala"
																		return result;
#line 5914 "tracker-sparql-expression.c"
																	} else {
#line 658 "tracker-sparql-expression.vala"
																		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
#line 659 "tracker-sparql-expression.vala"
																			tracker_sparql_expression_translate_date (self, sql, "%m", &_inner_error0_);
#line 659 "tracker-sparql-expression.vala"
																			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 659 "tracker-sparql-expression.vala"
																				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 659 "tracker-sparql-expression.vala"
																					g_propagate_error (error, _inner_error0_);
#line 659 "tracker-sparql-expression.vala"
																					return 0;
#line 5928 "tracker-sparql-expression.c"
																				} else {
#line 659 "tracker-sparql-expression.vala"
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 659 "tracker-sparql-expression.vala"
																					g_clear_error (&_inner_error0_);
#line 659 "tracker-sparql-expression.vala"
																					return 0;
#line 5936 "tracker-sparql-expression.c"
																				}
																			}
#line 660 "tracker-sparql-expression.vala"
																			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 660 "tracker-sparql-expression.vala"
																			return result;
#line 5943 "tracker-sparql-expression.c"
																		} else {
#line 661 "tracker-sparql-expression.vala"
																			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
#line 662 "tracker-sparql-expression.vala"
																				tracker_sparql_expression_translate_date (self, sql, "%d", &_inner_error0_);
#line 662 "tracker-sparql-expression.vala"
																				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 662 "tracker-sparql-expression.vala"
																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 662 "tracker-sparql-expression.vala"
																						g_propagate_error (error, _inner_error0_);
#line 662 "tracker-sparql-expression.vala"
																						return 0;
#line 5957 "tracker-sparql-expression.c"
																					} else {
#line 662 "tracker-sparql-expression.vala"
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 662 "tracker-sparql-expression.vala"
																						g_clear_error (&_inner_error0_);
#line 662 "tracker-sparql-expression.vala"
																						return 0;
#line 5965 "tracker-sparql-expression.c"
																					}
																				}
#line 663 "tracker-sparql-expression.vala"
																				result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 663 "tracker-sparql-expression.vala"
																				return result;
#line 5972 "tracker-sparql-expression.c"
																			} else {
#line 664 "tracker-sparql-expression.vala"
																				if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
#line 665 "tracker-sparql-expression.vala"
																					tracker_sparql_expression_translate_time (self, sql, TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_HOURS, &_inner_error0_);
#line 665 "tracker-sparql-expression.vala"
																					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 665 "tracker-sparql-expression.vala"
																						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 665 "tracker-sparql-expression.vala"
																							g_propagate_error (error, _inner_error0_);
#line 665 "tracker-sparql-expression.vala"
																							return 0;
#line 5986 "tracker-sparql-expression.c"
																						} else {
#line 665 "tracker-sparql-expression.vala"
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 665 "tracker-sparql-expression.vala"
																							g_clear_error (&_inner_error0_);
#line 665 "tracker-sparql-expression.vala"
																							return 0;
#line 5994 "tracker-sparql-expression.c"
																						}
																					}
#line 666 "tracker-sparql-expression.vala"
																					result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 666 "tracker-sparql-expression.vala"
																					return result;
#line 6001 "tracker-sparql-expression.c"
																				} else {
#line 667 "tracker-sparql-expression.vala"
																					if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
#line 668 "tracker-sparql-expression.vala"
																						tracker_sparql_expression_translate_time (self, sql, TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_MINUTES, &_inner_error0_);
#line 668 "tracker-sparql-expression.vala"
																						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 668 "tracker-sparql-expression.vala"
																							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 668 "tracker-sparql-expression.vala"
																								g_propagate_error (error, _inner_error0_);
#line 668 "tracker-sparql-expression.vala"
																								return 0;
#line 6015 "tracker-sparql-expression.c"
																							} else {
#line 668 "tracker-sparql-expression.vala"
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 668 "tracker-sparql-expression.vala"
																								g_clear_error (&_inner_error0_);
#line 668 "tracker-sparql-expression.vala"
																								return 0;
#line 6023 "tracker-sparql-expression.c"
																							}
																						}
#line 669 "tracker-sparql-expression.vala"
																						result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 669 "tracker-sparql-expression.vala"
																						return result;
#line 6030 "tracker-sparql-expression.c"
																					} else {
#line 670 "tracker-sparql-expression.vala"
																						if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
#line 671 "tracker-sparql-expression.vala"
																							tracker_sparql_expression_translate_time (self, sql, TRACKER_SPARQL_EXPRESSION_TIME_FORMAT_TYPE_SECONDS, &_inner_error0_);
#line 671 "tracker-sparql-expression.vala"
																							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 671 "tracker-sparql-expression.vala"
																								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 671 "tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error0_);
#line 671 "tracker-sparql-expression.vala"
																									return 0;
#line 6044 "tracker-sparql-expression.c"
																								} else {
#line 671 "tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 671 "tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error0_);
#line 671 "tracker-sparql-expression.vala"
																									return 0;
#line 6052 "tracker-sparql-expression.c"
																								}
																							}
#line 672 "tracker-sparql-expression.vala"
																							result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 672 "tracker-sparql-expression.vala"
																							return result;
#line 6059 "tracker-sparql-expression.c"
																						} else {
#line 673 "tracker-sparql-expression.vala"
																							if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
#line 6063 "tracker-sparql-expression.c"
																								gchar* variable_name = NULL;
																								gchar* _tmp36_;
																								gchar* _tmp37_;
																								gchar* _tmp38_;
																								gchar* _tmp39_;
																								TrackerSparqlVariable* variable = NULL;
																								TrackerSparqlContext* _tmp40_;
																								TrackerSparqlContext* _tmp41_;
																								const gchar* _tmp42_;
																								TrackerSparqlVariable* _tmp43_;
																								TrackerSparqlVariable* _tmp44_;
																								TrackerSparqlVariable* _tmp45_;
																								gchar* _tmp46_;
																								gchar* _tmp47_;
																								TrackerSparqlVariable* _tmp48_;
																								gchar* _tmp49_;
																								gchar* _tmp50_;
																								TrackerSparqlVariable* _tmp51_;
																								const gchar* _tmp52_;
																								const gchar* _tmp53_;
#line 674 "tracker-sparql-expression.vala"
																								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error0_);
#line 674 "tracker-sparql-expression.vala"
																								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 674 "tracker-sparql-expression.vala"
																									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 674 "tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error0_);
#line 674 "tracker-sparql-expression.vala"
																										return 0;
#line 6094 "tracker-sparql-expression.c"
																									} else {
#line 674 "tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 674 "tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error0_);
#line 674 "tracker-sparql-expression.vala"
																										return 0;
#line 6102 "tracker-sparql-expression.c"
																									}
																								}
#line 675 "tracker-sparql-expression.vala"
																								_tmp36_ = tracker_sparql_expression_get_last_string (self, 0);
#line 675 "tracker-sparql-expression.vala"
																								_tmp37_ = _tmp36_;
#line 675 "tracker-sparql-expression.vala"
																								_tmp38_ = string_substring (_tmp37_, (glong) 1, (glong) -1);
#line 675 "tracker-sparql-expression.vala"
																								_tmp39_ = _tmp38_;
#line 675 "tracker-sparql-expression.vala"
																								_g_free0 (_tmp37_);
#line 675 "tracker-sparql-expression.vala"
																								variable_name = _tmp39_;
#line 676 "tracker-sparql-expression.vala"
																								_tmp40_ = tracker_sparql_expression_get_context (self);
#line 676 "tracker-sparql-expression.vala"
																								_tmp41_ = _tmp40_;
#line 676 "tracker-sparql-expression.vala"
																								_tmp42_ = variable_name;
#line 676 "tracker-sparql-expression.vala"
																								_tmp43_ = tracker_sparql_context_get_variable (_tmp41_, _tmp42_);
#line 676 "tracker-sparql-expression.vala"
																								_tmp44_ = _g_object_ref0 (_tmp43_);
#line 676 "tracker-sparql-expression.vala"
																								variable = _tmp44_;
#line 678 "tracker-sparql-expression.vala"
																								g_string_append (sql, "(");
#line 679 "tracker-sparql-expression.vala"
																								_tmp45_ = variable;
#line 679 "tracker-sparql-expression.vala"
																								_tmp46_ = tracker_sparql_variable_get_extra_sql_expression (_tmp45_, "localDate");
#line 679 "tracker-sparql-expression.vala"
																								_tmp47_ = _tmp46_;
#line 679 "tracker-sparql-expression.vala"
																								g_string_append (sql, _tmp47_);
#line 679 "tracker-sparql-expression.vala"
																								_g_free0 (_tmp47_);
#line 680 "tracker-sparql-expression.vala"
																								g_string_append (sql, " * 24 * 3600 + ");
#line 681 "tracker-sparql-expression.vala"
																								_tmp48_ = variable;
#line 681 "tracker-sparql-expression.vala"
																								_tmp49_ = tracker_sparql_variable_get_extra_sql_expression (_tmp48_, "localTime");
#line 681 "tracker-sparql-expression.vala"
																								_tmp50_ = _tmp49_;
#line 681 "tracker-sparql-expression.vala"
																								g_string_append (sql, _tmp50_);
#line 681 "tracker-sparql-expression.vala"
																								_g_free0 (_tmp50_);
#line 682 "tracker-sparql-expression.vala"
																								g_string_append (sql, "- ");
#line 683 "tracker-sparql-expression.vala"
																								g_string_append (sql, "CAST (");
#line 684 "tracker-sparql-expression.vala"
																								_tmp51_ = variable;
#line 684 "tracker-sparql-expression.vala"
																								_tmp52_ = tracker_sparql_variable_get_sql_expression (_tmp51_);
#line 684 "tracker-sparql-expression.vala"
																								_tmp53_ = _tmp52_;
#line 684 "tracker-sparql-expression.vala"
																								g_string_append (sql, _tmp53_);
#line 685 "tracker-sparql-expression.vala"
																								g_string_append (sql, " AS INTEGER)");
#line 686 "tracker-sparql-expression.vala"
																								g_string_append (sql, ")");
#line 688 "tracker-sparql-expression.vala"
																								result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 688 "tracker-sparql-expression.vala"
																								_g_object_unref0 (variable);
#line 688 "tracker-sparql-expression.vala"
																								_g_free0 (variable_name);
#line 688 "tracker-sparql-expression.vala"
																								return result;
#line 6177 "tracker-sparql-expression.c"
																							} else {
#line 689 "tracker-sparql-expression.vala"
																								if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "replace") == 0) {
#line 6181 "tracker-sparql-expression.c"
																									gboolean _tmp54_ = FALSE;
#line 690 "tracker-sparql-expression.vala"
																									g_string_append (sql, "SparqlReplace(");
#line 691 "tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 691 "tracker-sparql-expression.vala"
																									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 691 "tracker-sparql-expression.vala"
																										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 691 "tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error0_);
#line 691 "tracker-sparql-expression.vala"
																											return 0;
#line 6195 "tracker-sparql-expression.c"
																										} else {
#line 691 "tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 691 "tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error0_);
#line 691 "tracker-sparql-expression.vala"
																											return 0;
#line 6203 "tracker-sparql-expression.c"
																										}
																									}
#line 692 "tracker-sparql-expression.vala"
																									g_string_append (sql, ", ");
#line 694 "tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 694 "tracker-sparql-expression.vala"
																									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 694 "tracker-sparql-expression.vala"
																										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 694 "tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error0_);
#line 694 "tracker-sparql-expression.vala"
																											return 0;
#line 6218 "tracker-sparql-expression.c"
																										} else {
#line 694 "tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 694 "tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error0_);
#line 694 "tracker-sparql-expression.vala"
																											return 0;
#line 6226 "tracker-sparql-expression.c"
																										}
																									}
#line 695 "tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 695 "tracker-sparql-expression.vala"
																									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 695 "tracker-sparql-expression.vala"
																										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 695 "tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error0_);
#line 695 "tracker-sparql-expression.vala"
																											return 0;
#line 6239 "tracker-sparql-expression.c"
																										} else {
#line 695 "tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 695 "tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error0_);
#line 695 "tracker-sparql-expression.vala"
																											return 0;
#line 6247 "tracker-sparql-expression.c"
																										}
																									}
#line 696 "tracker-sparql-expression.vala"
																									g_string_append (sql, ", ");
#line 698 "tracker-sparql-expression.vala"
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 698 "tracker-sparql-expression.vala"
																									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 698 "tracker-sparql-expression.vala"
																										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 698 "tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error0_);
#line 698 "tracker-sparql-expression.vala"
																											return 0;
#line 6262 "tracker-sparql-expression.c"
																										} else {
#line 698 "tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 698 "tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error0_);
#line 698 "tracker-sparql-expression.vala"
																											return 0;
#line 6270 "tracker-sparql-expression.c"
																										}
																									}
#line 699 "tracker-sparql-expression.vala"
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 699 "tracker-sparql-expression.vala"
																									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 699 "tracker-sparql-expression.vala"
																										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 699 "tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error0_);
#line 699 "tracker-sparql-expression.vala"
																											return 0;
#line 6283 "tracker-sparql-expression.c"
																										} else {
#line 699 "tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 699 "tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error0_);
#line 699 "tracker-sparql-expression.vala"
																											return 0;
#line 6291 "tracker-sparql-expression.c"
																										}
																									}
#line 701 "tracker-sparql-expression.vala"
																									_tmp54_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 701 "tracker-sparql-expression.vala"
																									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 701 "tracker-sparql-expression.vala"
																										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 701 "tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error0_);
#line 701 "tracker-sparql-expression.vala"
																											return 0;
#line 6304 "tracker-sparql-expression.c"
																										} else {
#line 701 "tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 701 "tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error0_);
#line 701 "tracker-sparql-expression.vala"
																											return 0;
#line 6312 "tracker-sparql-expression.c"
																										}
																									}
#line 701 "tracker-sparql-expression.vala"
																									if (_tmp54_) {
#line 6317 "tracker-sparql-expression.c"
																										gchar* _tmp55_ = NULL;
																										gchar* _tmp56_;
																										gchar* _tmp57_;
																										gchar* _tmp58_;
#line 702 "tracker-sparql-expression.vala"
																										g_string_append (sql, ", ");
#line 703 "tracker-sparql-expression.vala"
																										_tmp56_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 703 "tracker-sparql-expression.vala"
																										_tmp55_ = _tmp56_;
#line 703 "tracker-sparql-expression.vala"
																										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 703 "tracker-sparql-expression.vala"
																											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 703 "tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error0_);
#line 703 "tracker-sparql-expression.vala"
																												return 0;
#line 6336 "tracker-sparql-expression.c"
																											} else {
#line 703 "tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 703 "tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error0_);
#line 703 "tracker-sparql-expression.vala"
																												return 0;
#line 6344 "tracker-sparql-expression.c"
																											}
																										}
#line 703 "tracker-sparql-expression.vala"
																										_tmp57_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp55_);
#line 703 "tracker-sparql-expression.vala"
																										_tmp58_ = _tmp57_;
#line 703 "tracker-sparql-expression.vala"
																										g_string_append (sql, _tmp58_);
#line 703 "tracker-sparql-expression.vala"
																										_g_free0 (_tmp58_);
#line 701 "tracker-sparql-expression.vala"
																										_g_free0 (_tmp55_);
#line 6357 "tracker-sparql-expression.c"
																									}
#line 705 "tracker-sparql-expression.vala"
																									g_string_append (sql, ")");
#line 706 "tracker-sparql-expression.vala"
																									result = TRACKER_PROPERTY_TYPE_STRING;
#line 706 "tracker-sparql-expression.vala"
																									return result;
#line 6365 "tracker-sparql-expression.c"
																								} else {
#line 707 "tracker-sparql-expression.vala"
																									if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
#line 6369 "tracker-sparql-expression.c"
																										gboolean is_var = FALSE;
																										gchar* v = NULL;
																										TrackerSparqlPattern* _tmp59_;
																										TrackerSparqlPattern* _tmp60_;
																										gboolean _tmp61_ = FALSE;
																										gchar* _tmp62_;
																										const gchar* _tmp63_;
#line 709 "tracker-sparql-expression.vala"
																										_tmp59_ = tracker_sparql_expression_get_pattern (self);
#line 709 "tracker-sparql-expression.vala"
																										_tmp60_ = _tmp59_;
#line 709 "tracker-sparql-expression.vala"
																										_tmp62_ = tracker_sparql_pattern_parse_var_or_term (_tmp60_, NULL, &_tmp61_, &_inner_error0_);
#line 709 "tracker-sparql-expression.vala"
																										is_var = _tmp61_;
#line 709 "tracker-sparql-expression.vala"
																										v = _tmp62_;
#line 709 "tracker-sparql-expression.vala"
																										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 709 "tracker-sparql-expression.vala"
																											if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 709 "tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error0_);
#line 709 "tracker-sparql-expression.vala"
																												return 0;
#line 6395 "tracker-sparql-expression.c"
																											} else {
#line 709 "tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 709 "tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error0_);
#line 709 "tracker-sparql-expression.vala"
																												return 0;
#line 6403 "tracker-sparql-expression.c"
																											}
																										}
#line 710 "tracker-sparql-expression.vala"
																										_tmp63_ = v;
#line 710 "tracker-sparql-expression.vala"
																										g_string_append_printf (sql, "\"%s_u_rank\"", _tmp63_);
#line 712 "tracker-sparql-expression.vala"
																										result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 712 "tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 712 "tracker-sparql-expression.vala"
																										return result;
#line 6416 "tracker-sparql-expression.c"
																									} else {
#line 713 "tracker-sparql-expression.vala"
																										if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
#line 6420 "tracker-sparql-expression.c"
																											gboolean is_var = FALSE;
																											gchar* v = NULL;
																											TrackerSparqlPattern* _tmp64_;
																											TrackerSparqlPattern* _tmp65_;
																											gboolean _tmp66_ = FALSE;
																											gchar* _tmp67_;
																											TrackerSparqlVariable* variable = NULL;
																											TrackerSparqlContext* _tmp68_;
																											TrackerSparqlContext* _tmp69_;
																											const gchar* _tmp70_;
																											TrackerSparqlVariable* _tmp71_;
																											TrackerSparqlVariable* _tmp72_;
																											TrackerSparqlVariable* _tmp73_;
																											const gchar* _tmp74_;
																											const gchar* _tmp75_;
																											gchar* _tmp76_;
#line 715 "tracker-sparql-expression.vala"
																											_tmp64_ = tracker_sparql_expression_get_pattern (self);
#line 715 "tracker-sparql-expression.vala"
																											_tmp65_ = _tmp64_;
#line 715 "tracker-sparql-expression.vala"
																											_tmp67_ = tracker_sparql_pattern_parse_var_or_term (_tmp65_, NULL, &_tmp66_, &_inner_error0_);
#line 715 "tracker-sparql-expression.vala"
																											is_var = _tmp66_;
#line 715 "tracker-sparql-expression.vala"
																											v = _tmp67_;
#line 715 "tracker-sparql-expression.vala"
																											if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 715 "tracker-sparql-expression.vala"
																												if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 715 "tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error0_);
#line 715 "tracker-sparql-expression.vala"
																													return 0;
#line 6455 "tracker-sparql-expression.c"
																												} else {
#line 715 "tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 715 "tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error0_);
#line 715 "tracker-sparql-expression.vala"
																													return 0;
#line 6463 "tracker-sparql-expression.c"
																												}
																											}
#line 716 "tracker-sparql-expression.vala"
																											_tmp68_ = tracker_sparql_expression_get_context (self);
#line 716 "tracker-sparql-expression.vala"
																											_tmp69_ = _tmp68_;
#line 716 "tracker-sparql-expression.vala"
																											_tmp70_ = v;
#line 716 "tracker-sparql-expression.vala"
																											_tmp71_ = tracker_sparql_context_get_variable (_tmp69_, _tmp70_);
#line 716 "tracker-sparql-expression.vala"
																											_tmp72_ = _g_object_ref0 (_tmp71_);
#line 716 "tracker-sparql-expression.vala"
																											variable = _tmp72_;
#line 718 "tracker-sparql-expression.vala"
																											_tmp73_ = variable;
#line 718 "tracker-sparql-expression.vala"
																											_tmp74_ = tracker_sparql_variable_get_sql_expression (_tmp73_);
#line 718 "tracker-sparql-expression.vala"
																											_tmp75_ = _tmp74_;
#line 718 "tracker-sparql-expression.vala"
																											g_string_append (sql, _tmp75_);
#line 719 "tracker-sparql-expression.vala"
																											_tmp76_ = g_strdup ("tracker_offsets(\"fts5\")");
#line 719 "tracker-sparql-expression.vala"
																											_g_free0 (self->priv->fts_sql);
#line 719 "tracker-sparql-expression.vala"
																											self->priv->fts_sql = _tmp76_;
#line 720 "tracker-sparql-expression.vala"
																											result = TRACKER_PROPERTY_TYPE_STRING;
#line 720 "tracker-sparql-expression.vala"
																											_g_object_unref0 (variable);
#line 720 "tracker-sparql-expression.vala"
																											_g_free0 (v);
#line 720 "tracker-sparql-expression.vala"
																											return result;
#line 6500 "tracker-sparql-expression.c"
																										} else {
#line 721 "tracker-sparql-expression.vala"
																											if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "snippet") == 0) {
#line 6504 "tracker-sparql-expression.c"
																												gboolean is_var = FALSE;
																												gchar* v = NULL;
																												TrackerSparqlPattern* _tmp77_;
																												TrackerSparqlPattern* _tmp78_;
																												gboolean _tmp79_ = FALSE;
																												gchar* _tmp80_;
																												TrackerSparqlVariable* variable = NULL;
																												TrackerSparqlContext* _tmp81_;
																												TrackerSparqlContext* _tmp82_;
																												const gchar* _tmp83_;
																												TrackerSparqlVariable* _tmp84_;
																												TrackerSparqlVariable* _tmp85_;
																												GString* fts = NULL;
																												GString* _tmp86_;
																												GString* _tmp87_;
																												GString* _tmp88_;
																												gboolean _tmp89_ = FALSE;
																												gboolean _tmp95_ = FALSE;
																												gboolean _tmp99_ = FALSE;
																												GString* _tmp103_;
																												GString* _tmp104_;
																												const gchar* _tmp105_;
																												gchar* _tmp106_;
																												TrackerSparqlVariable* _tmp107_;
																												const gchar* _tmp108_;
																												const gchar* _tmp109_;
#line 724 "tracker-sparql-expression.vala"
																												_tmp77_ = tracker_sparql_expression_get_pattern (self);
#line 724 "tracker-sparql-expression.vala"
																												_tmp78_ = _tmp77_;
#line 724 "tracker-sparql-expression.vala"
																												_tmp80_ = tracker_sparql_pattern_parse_var_or_term (_tmp78_, NULL, &_tmp79_, &_inner_error0_);
#line 724 "tracker-sparql-expression.vala"
																												is_var = _tmp79_;
#line 724 "tracker-sparql-expression.vala"
																												v = _tmp80_;
#line 724 "tracker-sparql-expression.vala"
																												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 724 "tracker-sparql-expression.vala"
																													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 724 "tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error0_);
#line 724 "tracker-sparql-expression.vala"
																														return 0;
#line 6549 "tracker-sparql-expression.c"
																													} else {
#line 724 "tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 724 "tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error0_);
#line 724 "tracker-sparql-expression.vala"
																														return 0;
#line 6557 "tracker-sparql-expression.c"
																													}
																												}
#line 725 "tracker-sparql-expression.vala"
																												_tmp81_ = tracker_sparql_expression_get_context (self);
#line 725 "tracker-sparql-expression.vala"
																												_tmp82_ = _tmp81_;
#line 725 "tracker-sparql-expression.vala"
																												_tmp83_ = v;
#line 725 "tracker-sparql-expression.vala"
																												_tmp84_ = tracker_sparql_context_get_variable (_tmp82_, _tmp83_);
#line 725 "tracker-sparql-expression.vala"
																												_tmp85_ = _g_object_ref0 (_tmp84_);
#line 725 "tracker-sparql-expression.vala"
																												variable = _tmp85_;
#line 726 "tracker-sparql-expression.vala"
																												_tmp86_ = g_string_new ("");
#line 726 "tracker-sparql-expression.vala"
																												fts = _tmp86_;
#line 728 "tracker-sparql-expression.vala"
																												_tmp87_ = fts;
#line 728 "tracker-sparql-expression.vala"
																												g_string_append_printf (_tmp87_, "snippet(\"fts5\"");
#line 731 "tracker-sparql-expression.vala"
																												_tmp88_ = fts;
#line 731 "tracker-sparql-expression.vala"
																												g_string_append (_tmp88_, ", -1");
#line 734 "tracker-sparql-expression.vala"
																												_tmp89_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 734 "tracker-sparql-expression.vala"
																												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 734 "tracker-sparql-expression.vala"
																													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 734 "tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error0_);
#line 734 "tracker-sparql-expression.vala"
																														_g_string_free0 (fts);
#line 734 "tracker-sparql-expression.vala"
																														_g_object_unref0 (variable);
#line 734 "tracker-sparql-expression.vala"
																														_g_free0 (v);
#line 734 "tracker-sparql-expression.vala"
																														return 0;
#line 6600 "tracker-sparql-expression.c"
																													} else {
#line 734 "tracker-sparql-expression.vala"
																														_g_string_free0 (fts);
#line 734 "tracker-sparql-expression.vala"
																														_g_object_unref0 (variable);
#line 734 "tracker-sparql-expression.vala"
																														_g_free0 (v);
#line 734 "tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 734 "tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error0_);
#line 734 "tracker-sparql-expression.vala"
																														return 0;
#line 6614 "tracker-sparql-expression.c"
																													}
																												}
#line 734 "tracker-sparql-expression.vala"
																												if (_tmp89_) {
#line 6619 "tracker-sparql-expression.c"
																													GString* _tmp90_;
																													GString* _tmp91_;
																													GString* _tmp92_;
																													GString* _tmp93_;
#line 735 "tracker-sparql-expression.vala"
																													_tmp90_ = fts;
#line 735 "tracker-sparql-expression.vala"
																													g_string_append (_tmp90_, ", ");
#line 736 "tracker-sparql-expression.vala"
																													_tmp91_ = fts;
#line 736 "tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp91_, &_inner_error0_);
#line 736 "tracker-sparql-expression.vala"
																													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 736 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 736 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 736 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 736 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 736 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 736 "tracker-sparql-expression.vala"
																															return 0;
#line 6646 "tracker-sparql-expression.c"
																														} else {
#line 736 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 736 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 736 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 736 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 736 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 736 "tracker-sparql-expression.vala"
																															return 0;
#line 6660 "tracker-sparql-expression.c"
																														}
																													}
#line 739 "tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 739 "tracker-sparql-expression.vala"
																													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 739 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 739 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 739 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 739 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 739 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 739 "tracker-sparql-expression.vala"
																															return 0;
#line 6679 "tracker-sparql-expression.c"
																														} else {
#line 739 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 739 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 739 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 739 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 739 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 739 "tracker-sparql-expression.vala"
																															return 0;
#line 6693 "tracker-sparql-expression.c"
																														}
																													}
#line 740 "tracker-sparql-expression.vala"
																													_tmp92_ = fts;
#line 740 "tracker-sparql-expression.vala"
																													g_string_append (_tmp92_, ", ");
#line 741 "tracker-sparql-expression.vala"
																													_tmp93_ = fts;
#line 741 "tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp93_, &_inner_error0_);
#line 741 "tracker-sparql-expression.vala"
																													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 741 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 741 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 741 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 741 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 741 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 741 "tracker-sparql-expression.vala"
																															return 0;
#line 6718 "tracker-sparql-expression.c"
																														} else {
#line 741 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 741 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 741 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 741 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 741 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 741 "tracker-sparql-expression.vala"
																															return 0;
#line 6732 "tracker-sparql-expression.c"
																														}
																													}
																												} else {
																													GString* _tmp94_;
#line 743 "tracker-sparql-expression.vala"
																													_tmp94_ = fts;
#line 743 "tracker-sparql-expression.vala"
																													g_string_append (_tmp94_, ",'',''");
#line 6741 "tracker-sparql-expression.c"
																												}
#line 747 "tracker-sparql-expression.vala"
																												_tmp95_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 747 "tracker-sparql-expression.vala"
																												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 747 "tracker-sparql-expression.vala"
																													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 747 "tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error0_);
#line 747 "tracker-sparql-expression.vala"
																														_g_string_free0 (fts);
#line 747 "tracker-sparql-expression.vala"
																														_g_object_unref0 (variable);
#line 747 "tracker-sparql-expression.vala"
																														_g_free0 (v);
#line 747 "tracker-sparql-expression.vala"
																														return 0;
#line 6759 "tracker-sparql-expression.c"
																													} else {
#line 747 "tracker-sparql-expression.vala"
																														_g_string_free0 (fts);
#line 747 "tracker-sparql-expression.vala"
																														_g_object_unref0 (variable);
#line 747 "tracker-sparql-expression.vala"
																														_g_free0 (v);
#line 747 "tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 747 "tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error0_);
#line 747 "tracker-sparql-expression.vala"
																														return 0;
#line 6773 "tracker-sparql-expression.c"
																													}
																												}
#line 747 "tracker-sparql-expression.vala"
																												if (_tmp95_) {
#line 6778 "tracker-sparql-expression.c"
																													GString* _tmp96_;
																													GString* _tmp97_;
#line 748 "tracker-sparql-expression.vala"
																													_tmp96_ = fts;
#line 748 "tracker-sparql-expression.vala"
																													g_string_append (_tmp96_, ", ");
#line 749 "tracker-sparql-expression.vala"
																													_tmp97_ = fts;
#line 749 "tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp97_, &_inner_error0_);
#line 749 "tracker-sparql-expression.vala"
																													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 749 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 749 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 749 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 749 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 749 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 749 "tracker-sparql-expression.vala"
																															return 0;
#line 6803 "tracker-sparql-expression.c"
																														} else {
#line 749 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 749 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 749 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 749 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 749 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 749 "tracker-sparql-expression.vala"
																															return 0;
#line 6817 "tracker-sparql-expression.c"
																														}
																													}
																												} else {
																													GString* _tmp98_;
#line 751 "tracker-sparql-expression.vala"
																													_tmp98_ = fts;
#line 751 "tracker-sparql-expression.vala"
																													g_string_append (_tmp98_, ", '...'");
#line 6826 "tracker-sparql-expression.c"
																												}
#line 755 "tracker-sparql-expression.vala"
																												_tmp99_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 755 "tracker-sparql-expression.vala"
																												if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 755 "tracker-sparql-expression.vala"
																													if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 755 "tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error0_);
#line 755 "tracker-sparql-expression.vala"
																														_g_string_free0 (fts);
#line 755 "tracker-sparql-expression.vala"
																														_g_object_unref0 (variable);
#line 755 "tracker-sparql-expression.vala"
																														_g_free0 (v);
#line 755 "tracker-sparql-expression.vala"
																														return 0;
#line 6844 "tracker-sparql-expression.c"
																													} else {
#line 755 "tracker-sparql-expression.vala"
																														_g_string_free0 (fts);
#line 755 "tracker-sparql-expression.vala"
																														_g_object_unref0 (variable);
#line 755 "tracker-sparql-expression.vala"
																														_g_free0 (v);
#line 755 "tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 755 "tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error0_);
#line 755 "tracker-sparql-expression.vala"
																														return 0;
#line 6858 "tracker-sparql-expression.c"
																													}
																												}
#line 755 "tracker-sparql-expression.vala"
																												if (_tmp99_) {
#line 6863 "tracker-sparql-expression.c"
																													GString* _tmp100_;
																													GString* _tmp101_;
#line 756 "tracker-sparql-expression.vala"
																													_tmp100_ = fts;
#line 756 "tracker-sparql-expression.vala"
																													g_string_append (_tmp100_, ", ");
#line 757 "tracker-sparql-expression.vala"
																													_tmp101_ = fts;
#line 757 "tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp101_, &_inner_error0_);
#line 757 "tracker-sparql-expression.vala"
																													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 757 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 757 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 757 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 757 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 757 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 757 "tracker-sparql-expression.vala"
																															return 0;
#line 6888 "tracker-sparql-expression.c"
																														} else {
#line 757 "tracker-sparql-expression.vala"
																															_g_string_free0 (fts);
#line 757 "tracker-sparql-expression.vala"
																															_g_object_unref0 (variable);
#line 757 "tracker-sparql-expression.vala"
																															_g_free0 (v);
#line 757 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 757 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 757 "tracker-sparql-expression.vala"
																															return 0;
#line 6902 "tracker-sparql-expression.c"
																														}
																													}
																												} else {
																													GString* _tmp102_;
#line 759 "tracker-sparql-expression.vala"
																													_tmp102_ = fts;
#line 759 "tracker-sparql-expression.vala"
																													g_string_append (_tmp102_, ", 5");
#line 6911 "tracker-sparql-expression.c"
																												}
#line 762 "tracker-sparql-expression.vala"
																												_tmp103_ = fts;
#line 762 "tracker-sparql-expression.vala"
																												g_string_append (_tmp103_, ")");
#line 764 "tracker-sparql-expression.vala"
																												_tmp104_ = fts;
#line 764 "tracker-sparql-expression.vala"
																												_tmp105_ = _tmp104_->str;
#line 764 "tracker-sparql-expression.vala"
																												_tmp106_ = g_strdup (_tmp105_);
#line 764 "tracker-sparql-expression.vala"
																												_g_free0 (self->priv->fts_sql);
#line 764 "tracker-sparql-expression.vala"
																												self->priv->fts_sql = _tmp106_;
#line 765 "tracker-sparql-expression.vala"
																												_tmp107_ = variable;
#line 765 "tracker-sparql-expression.vala"
																												_tmp108_ = tracker_sparql_variable_get_sql_expression (_tmp107_);
#line 765 "tracker-sparql-expression.vala"
																												_tmp109_ = _tmp108_;
#line 765 "tracker-sparql-expression.vala"
																												g_string_append (sql, _tmp109_);
#line 766 "tracker-sparql-expression.vala"
																												result = TRACKER_PROPERTY_TYPE_STRING;
#line 766 "tracker-sparql-expression.vala"
																												_g_string_free0 (fts);
#line 766 "tracker-sparql-expression.vala"
																												_g_object_unref0 (variable);
#line 766 "tracker-sparql-expression.vala"
																												_g_free0 (v);
#line 766 "tracker-sparql-expression.vala"
																												return result;
#line 6945 "tracker-sparql-expression.c"
																											} else {
#line 767 "tracker-sparql-expression.vala"
																												if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
#line 6949 "tracker-sparql-expression.c"
																													TrackerPropertyType type = 0;
																													TrackerPropertyType _tmp110_;
#line 768 "tracker-sparql-expression.vala"
																													type = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 768 "tracker-sparql-expression.vala"
																													if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 768 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 768 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 768 "tracker-sparql-expression.vala"
																															return 0;
#line 6962 "tracker-sparql-expression.c"
																														} else {
#line 768 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 768 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 768 "tracker-sparql-expression.vala"
																															return 0;
#line 6970 "tracker-sparql-expression.c"
																														}
																													}
#line 769 "tracker-sparql-expression.vala"
																													_tmp110_ = type;
#line 769 "tracker-sparql-expression.vala"
																													if (_tmp110_ != TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 6977 "tracker-sparql-expression.c"
																														GError* _tmp111_;
#line 770 "tracker-sparql-expression.vala"
																														_tmp111_ = tracker_sparql_expression_get_error (self, "expected resource");
#line 770 "tracker-sparql-expression.vala"
																														_inner_error0_ = _tmp111_;
#line 770 "tracker-sparql-expression.vala"
																														if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 770 "tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error0_);
#line 770 "tracker-sparql-expression.vala"
																															return 0;
#line 6989 "tracker-sparql-expression.c"
																														} else {
#line 770 "tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 770 "tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error0_);
#line 770 "tracker-sparql-expression.vala"
																															return 0;
#line 6997 "tracker-sparql-expression.c"
																														}
																													}
#line 773 "tracker-sparql-expression.vala"
																													result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 773 "tracker-sparql-expression.vala"
																													return result;
#line 7004 "tracker-sparql-expression.c"
																												} else {
#line 774 "tracker-sparql-expression.vala"
																													if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
#line 7008 "tracker-sparql-expression.c"
																														TrackerPropertyType type = 0;
																														TrackerPropertyType _tmp112_;
#line 775 "tracker-sparql-expression.vala"
																														type = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 775 "tracker-sparql-expression.vala"
																														if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 775 "tracker-sparql-expression.vala"
																															if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 775 "tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error0_);
#line 775 "tracker-sparql-expression.vala"
																																return 0;
#line 7021 "tracker-sparql-expression.c"
																															} else {
#line 775 "tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 775 "tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error0_);
#line 775 "tracker-sparql-expression.vala"
																																return 0;
#line 7029 "tracker-sparql-expression.c"
																															}
																														}
#line 776 "tracker-sparql-expression.vala"
																														_tmp112_ = type;
#line 776 "tracker-sparql-expression.vala"
																														if (_tmp112_ != TRACKER_PROPERTY_TYPE_INTEGER) {
#line 7036 "tracker-sparql-expression.c"
																															GError* _tmp113_;
#line 777 "tracker-sparql-expression.vala"
																															_tmp113_ = tracker_sparql_expression_get_error (self, "expected integer ID");
#line 777 "tracker-sparql-expression.vala"
																															_inner_error0_ = _tmp113_;
#line 777 "tracker-sparql-expression.vala"
																															if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 777 "tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error0_);
#line 777 "tracker-sparql-expression.vala"
																																return 0;
#line 7048 "tracker-sparql-expression.c"
																															} else {
#line 777 "tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 777 "tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error0_);
#line 777 "tracker-sparql-expression.vala"
																																return 0;
#line 7056 "tracker-sparql-expression.c"
																															}
																														}
#line 780 "tracker-sparql-expression.vala"
																														result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 780 "tracker-sparql-expression.vala"
																														return result;
#line 7063 "tracker-sparql-expression.c"
																													} else {
#line 781 "tracker-sparql-expression.vala"
																														if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
#line 782 "tracker-sparql-expression.vala"
																															g_string_append (sql, "SparqlCartesianDistance(");
#line 783 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 783 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 783 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 783 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 783 "tracker-sparql-expression.vala"
																																	return 0;
#line 7079 "tracker-sparql-expression.c"
																																} else {
#line 783 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 783 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 783 "tracker-sparql-expression.vala"
																																	return 0;
#line 7087 "tracker-sparql-expression.c"
																																}
																															}
#line 784 "tracker-sparql-expression.vala"
																															g_string_append (sql, ", ");
#line 785 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 785 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 785 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 785 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 785 "tracker-sparql-expression.vala"
																																	return 0;
#line 7102 "tracker-sparql-expression.c"
																																} else {
#line 785 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 785 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 785 "tracker-sparql-expression.vala"
																																	return 0;
#line 7110 "tracker-sparql-expression.c"
																																}
																															}
#line 786 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 786 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 786 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 786 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 786 "tracker-sparql-expression.vala"
																																	return 0;
#line 7123 "tracker-sparql-expression.c"
																																} else {
#line 786 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 786 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 786 "tracker-sparql-expression.vala"
																																	return 0;
#line 7131 "tracker-sparql-expression.c"
																																}
																															}
#line 787 "tracker-sparql-expression.vala"
																															g_string_append (sql, ", ");
#line 788 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 788 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 788 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 788 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 788 "tracker-sparql-expression.vala"
																																	return 0;
#line 7146 "tracker-sparql-expression.c"
																																} else {
#line 788 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 788 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 788 "tracker-sparql-expression.vala"
																																	return 0;
#line 7154 "tracker-sparql-expression.c"
																																}
																															}
#line 789 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 789 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 789 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 789 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 789 "tracker-sparql-expression.vala"
																																	return 0;
#line 7167 "tracker-sparql-expression.c"
																																} else {
#line 789 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 789 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 789 "tracker-sparql-expression.vala"
																																	return 0;
#line 7175 "tracker-sparql-expression.c"
																																}
																															}
#line 790 "tracker-sparql-expression.vala"
																															g_string_append (sql, ", ");
#line 791 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 791 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 791 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 791 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 791 "tracker-sparql-expression.vala"
																																	return 0;
#line 7190 "tracker-sparql-expression.c"
																																} else {
#line 791 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 791 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 791 "tracker-sparql-expression.vala"
																																	return 0;
#line 7198 "tracker-sparql-expression.c"
																																}
																															}
#line 792 "tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 792 "tracker-sparql-expression.vala"
																															if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 792 "tracker-sparql-expression.vala"
																																if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 792 "tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error0_);
#line 792 "tracker-sparql-expression.vala"
																																	return 0;
#line 7211 "tracker-sparql-expression.c"
																																} else {
#line 792 "tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 792 "tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error0_);
#line 792 "tracker-sparql-expression.vala"
																																	return 0;
#line 7219 "tracker-sparql-expression.c"
																																}
																															}
#line 793 "tracker-sparql-expression.vala"
																															g_string_append (sql, ")");
#line 795 "tracker-sparql-expression.vala"
																															result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 795 "tracker-sparql-expression.vala"
																															return result;
#line 7228 "tracker-sparql-expression.c"
																														} else {
#line 796 "tracker-sparql-expression.vala"
																															if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
#line 797 "tracker-sparql-expression.vala"
																																g_string_append (sql, "SparqlHaversineDistance(");
#line 798 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 798 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 798 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 798 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 798 "tracker-sparql-expression.vala"
																																		return 0;
#line 7244 "tracker-sparql-expression.c"
																																	} else {
#line 798 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 798 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 798 "tracker-sparql-expression.vala"
																																		return 0;
#line 7252 "tracker-sparql-expression.c"
																																	}
																																}
#line 799 "tracker-sparql-expression.vala"
																																g_string_append (sql, ", ");
#line 800 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 800 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 800 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 800 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 800 "tracker-sparql-expression.vala"
																																		return 0;
#line 7267 "tracker-sparql-expression.c"
																																	} else {
#line 800 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 800 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 800 "tracker-sparql-expression.vala"
																																		return 0;
#line 7275 "tracker-sparql-expression.c"
																																	}
																																}
#line 801 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 801 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 801 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 801 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 801 "tracker-sparql-expression.vala"
																																		return 0;
#line 7288 "tracker-sparql-expression.c"
																																	} else {
#line 801 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 801 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 801 "tracker-sparql-expression.vala"
																																		return 0;
#line 7296 "tracker-sparql-expression.c"
																																	}
																																}
#line 802 "tracker-sparql-expression.vala"
																																g_string_append (sql, ", ");
#line 803 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 803 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 803 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 803 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 803 "tracker-sparql-expression.vala"
																																		return 0;
#line 7311 "tracker-sparql-expression.c"
																																	} else {
#line 803 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 803 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 803 "tracker-sparql-expression.vala"
																																		return 0;
#line 7319 "tracker-sparql-expression.c"
																																	}
																																}
#line 804 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 804 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 804 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 804 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 804 "tracker-sparql-expression.vala"
																																		return 0;
#line 7332 "tracker-sparql-expression.c"
																																	} else {
#line 804 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 804 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 804 "tracker-sparql-expression.vala"
																																		return 0;
#line 7340 "tracker-sparql-expression.c"
																																	}
																																}
#line 805 "tracker-sparql-expression.vala"
																																g_string_append (sql, ", ");
#line 806 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 806 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 806 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 806 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 806 "tracker-sparql-expression.vala"
																																		return 0;
#line 7355 "tracker-sparql-expression.c"
																																	} else {
#line 806 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 806 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 806 "tracker-sparql-expression.vala"
																																		return 0;
#line 7363 "tracker-sparql-expression.c"
																																	}
																																}
#line 807 "tracker-sparql-expression.vala"
																																tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 807 "tracker-sparql-expression.vala"
																																if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 807 "tracker-sparql-expression.vala"
																																	if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 807 "tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error0_);
#line 807 "tracker-sparql-expression.vala"
																																		return 0;
#line 7376 "tracker-sparql-expression.c"
																																	} else {
#line 807 "tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 807 "tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error0_);
#line 807 "tracker-sparql-expression.vala"
																																		return 0;
#line 7384 "tracker-sparql-expression.c"
																																	}
																																}
#line 808 "tracker-sparql-expression.vala"
																																g_string_append (sql, ")");
#line 810 "tracker-sparql-expression.vala"
																																result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 810 "tracker-sparql-expression.vala"
																																return result;
#line 7393 "tracker-sparql-expression.c"
																															} else {
#line 811 "tracker-sparql-expression.vala"
																																if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
#line 812 "tracker-sparql-expression.vala"
																																	g_string_append (sql, "COALESCE(");
#line 813 "tracker-sparql-expression.vala"
																																	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 813 "tracker-sparql-expression.vala"
																																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 813 "tracker-sparql-expression.vala"
																																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 813 "tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error0_);
#line 813 "tracker-sparql-expression.vala"
																																			return 0;
#line 7409 "tracker-sparql-expression.c"
																																		} else {
#line 813 "tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 813 "tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error0_);
#line 813 "tracker-sparql-expression.vala"
																																			return 0;
#line 7417 "tracker-sparql-expression.c"
																																		}
																																	}
#line 814 "tracker-sparql-expression.vala"
																																	g_string_append (sql, ", ");
#line 815 "tracker-sparql-expression.vala"
																																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 815 "tracker-sparql-expression.vala"
																																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 815 "tracker-sparql-expression.vala"
																																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 815 "tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error0_);
#line 815 "tracker-sparql-expression.vala"
																																			return 0;
#line 7432 "tracker-sparql-expression.c"
																																		} else {
#line 815 "tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 815 "tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error0_);
#line 815 "tracker-sparql-expression.vala"
																																			return 0;
#line 7440 "tracker-sparql-expression.c"
																																		}
																																	}
#line 816 "tracker-sparql-expression.vala"
																																	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 816 "tracker-sparql-expression.vala"
																																	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 816 "tracker-sparql-expression.vala"
																																		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 816 "tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error0_);
#line 816 "tracker-sparql-expression.vala"
																																			return 0;
#line 7453 "tracker-sparql-expression.c"
																																		} else {
#line 816 "tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 816 "tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error0_);
#line 816 "tracker-sparql-expression.vala"
																																			return 0;
#line 7461 "tracker-sparql-expression.c"
																																		}
																																	}
#line 817 "tracker-sparql-expression.vala"
																																	while (TRUE) {
#line 7466 "tracker-sparql-expression.c"
																																		gboolean _tmp114_ = FALSE;
#line 817 "tracker-sparql-expression.vala"
																																		_tmp114_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 817 "tracker-sparql-expression.vala"
																																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 817 "tracker-sparql-expression.vala"
																																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 817 "tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error0_);
#line 817 "tracker-sparql-expression.vala"
																																				return 0;
#line 7478 "tracker-sparql-expression.c"
																																			} else {
#line 817 "tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 817 "tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error0_);
#line 817 "tracker-sparql-expression.vala"
																																				return 0;
#line 7486 "tracker-sparql-expression.c"
																																			}
																																		}
#line 817 "tracker-sparql-expression.vala"
																																		if (!_tmp114_) {
#line 817 "tracker-sparql-expression.vala"
																																			break;
#line 7493 "tracker-sparql-expression.c"
																																		}
#line 818 "tracker-sparql-expression.vala"
																																		g_string_append (sql, ", ");
#line 819 "tracker-sparql-expression.vala"
																																		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 819 "tracker-sparql-expression.vala"
																																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 819 "tracker-sparql-expression.vala"
																																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 819 "tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error0_);
#line 819 "tracker-sparql-expression.vala"
																																				return 0;
#line 7507 "tracker-sparql-expression.c"
																																			} else {
#line 819 "tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 819 "tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error0_);
#line 819 "tracker-sparql-expression.vala"
																																				return 0;
#line 7515 "tracker-sparql-expression.c"
																																			}
																																		}
																																	}
#line 821 "tracker-sparql-expression.vala"
																																	g_string_append (sql, ")");
#line 823 "tracker-sparql-expression.vala"
																																	result = TRACKER_PROPERTY_TYPE_STRING;
#line 823 "tracker-sparql-expression.vala"
																																	return result;
#line 7525 "tracker-sparql-expression.c"
																																} else {
#line 824 "tracker-sparql-expression.vala"
																																	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
#line 825 "tracker-sparql-expression.vala"
																																		g_string_append (sql, "SparqlUriIsParent(");
#line 826 "tracker-sparql-expression.vala"
																																		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 826 "tracker-sparql-expression.vala"
																																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 826 "tracker-sparql-expression.vala"
																																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 826 "tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error0_);
#line 826 "tracker-sparql-expression.vala"
																																				return 0;
#line 7541 "tracker-sparql-expression.c"
																																			} else {
#line 826 "tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 826 "tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error0_);
#line 826 "tracker-sparql-expression.vala"
																																				return 0;
#line 7549 "tracker-sparql-expression.c"
																																			}
																																		}
#line 827 "tracker-sparql-expression.vala"
																																		g_string_append (sql, ", ");
#line 828 "tracker-sparql-expression.vala"
																																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 828 "tracker-sparql-expression.vala"
																																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 828 "tracker-sparql-expression.vala"
																																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 828 "tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error0_);
#line 828 "tracker-sparql-expression.vala"
																																				return 0;
#line 7564 "tracker-sparql-expression.c"
																																			} else {
#line 828 "tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 828 "tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error0_);
#line 828 "tracker-sparql-expression.vala"
																																				return 0;
#line 7572 "tracker-sparql-expression.c"
																																			}
																																		}
#line 830 "tracker-sparql-expression.vala"
																																		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 830 "tracker-sparql-expression.vala"
																																		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 830 "tracker-sparql-expression.vala"
																																			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 830 "tracker-sparql-expression.vala"
																																				g_propagate_error (error, _inner_error0_);
#line 830 "tracker-sparql-expression.vala"
																																				return 0;
#line 7585 "tracker-sparql-expression.c"
																																			} else {
#line 830 "tracker-sparql-expression.vala"
																																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 830 "tracker-sparql-expression.vala"
																																				g_clear_error (&_inner_error0_);
#line 830 "tracker-sparql-expression.vala"
																																				return 0;
#line 7593 "tracker-sparql-expression.c"
																																			}
																																		}
#line 831 "tracker-sparql-expression.vala"
																																		g_string_append (sql, ")");
#line 833 "tracker-sparql-expression.vala"
																																		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 833 "tracker-sparql-expression.vala"
																																		return result;
#line 7602 "tracker-sparql-expression.c"
																																	} else {
#line 834 "tracker-sparql-expression.vala"
																																		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
#line 835 "tracker-sparql-expression.vala"
																																			g_string_append (sql, "SparqlUriIsDescendant(");
#line 836 "tracker-sparql-expression.vala"
																																			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 836 "tracker-sparql-expression.vala"
																																			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 836 "tracker-sparql-expression.vala"
																																				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 836 "tracker-sparql-expression.vala"
																																					g_propagate_error (error, _inner_error0_);
#line 836 "tracker-sparql-expression.vala"
																																					return 0;
#line 7618 "tracker-sparql-expression.c"
																																				} else {
#line 836 "tracker-sparql-expression.vala"
																																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 836 "tracker-sparql-expression.vala"
																																					g_clear_error (&_inner_error0_);
#line 836 "tracker-sparql-expression.vala"
																																					return 0;
#line 7626 "tracker-sparql-expression.c"
																																				}
																																			}
#line 837 "tracker-sparql-expression.vala"
																																			g_string_append (sql, ", ");
#line 838 "tracker-sparql-expression.vala"
																																			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 838 "tracker-sparql-expression.vala"
																																			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 838 "tracker-sparql-expression.vala"
																																				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 838 "tracker-sparql-expression.vala"
																																					g_propagate_error (error, _inner_error0_);
#line 838 "tracker-sparql-expression.vala"
																																					return 0;
#line 7641 "tracker-sparql-expression.c"
																																				} else {
#line 838 "tracker-sparql-expression.vala"
																																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 838 "tracker-sparql-expression.vala"
																																					g_clear_error (&_inner_error0_);
#line 838 "tracker-sparql-expression.vala"
																																					return 0;
#line 7649 "tracker-sparql-expression.c"
																																				}
																																			}
#line 840 "tracker-sparql-expression.vala"
																																			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 840 "tracker-sparql-expression.vala"
																																			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 840 "tracker-sparql-expression.vala"
																																				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 840 "tracker-sparql-expression.vala"
																																					g_propagate_error (error, _inner_error0_);
#line 840 "tracker-sparql-expression.vala"
																																					return 0;
#line 7662 "tracker-sparql-expression.c"
																																				} else {
#line 840 "tracker-sparql-expression.vala"
																																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 840 "tracker-sparql-expression.vala"
																																					g_clear_error (&_inner_error0_);
#line 840 "tracker-sparql-expression.vala"
																																					return 0;
#line 7670 "tracker-sparql-expression.c"
																																				}
																																			}
#line 841 "tracker-sparql-expression.vala"
																																			while (TRUE) {
#line 7675 "tracker-sparql-expression.c"
																																				gboolean _tmp115_ = FALSE;
#line 841 "tracker-sparql-expression.vala"
																																				_tmp115_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 841 "tracker-sparql-expression.vala"
																																				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 841 "tracker-sparql-expression.vala"
																																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 841 "tracker-sparql-expression.vala"
																																						g_propagate_error (error, _inner_error0_);
#line 841 "tracker-sparql-expression.vala"
																																						return 0;
#line 7687 "tracker-sparql-expression.c"
																																					} else {
#line 841 "tracker-sparql-expression.vala"
																																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 841 "tracker-sparql-expression.vala"
																																						g_clear_error (&_inner_error0_);
#line 841 "tracker-sparql-expression.vala"
																																						return 0;
#line 7695 "tracker-sparql-expression.c"
																																					}
																																				}
#line 841 "tracker-sparql-expression.vala"
																																				if (!_tmp115_) {
#line 841 "tracker-sparql-expression.vala"
																																					break;
#line 7702 "tracker-sparql-expression.c"
																																				}
#line 842 "tracker-sparql-expression.vala"
																																				g_string_append (sql, ", ");
#line 843 "tracker-sparql-expression.vala"
																																				tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 843 "tracker-sparql-expression.vala"
																																				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 843 "tracker-sparql-expression.vala"
																																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 843 "tracker-sparql-expression.vala"
																																						g_propagate_error (error, _inner_error0_);
#line 843 "tracker-sparql-expression.vala"
																																						return 0;
#line 7716 "tracker-sparql-expression.c"
																																					} else {
#line 843 "tracker-sparql-expression.vala"
																																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 843 "tracker-sparql-expression.vala"
																																						g_clear_error (&_inner_error0_);
#line 843 "tracker-sparql-expression.vala"
																																						return 0;
#line 7724 "tracker-sparql-expression.c"
																																					}
																																				}
																																			}
#line 845 "tracker-sparql-expression.vala"
																																			g_string_append (sql, ")");
#line 847 "tracker-sparql-expression.vala"
																																			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 847 "tracker-sparql-expression.vala"
																																			return result;
#line 7734 "tracker-sparql-expression.c"
																																		} else {
#line 848 "tracker-sparql-expression.vala"
																																			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
#line 849 "tracker-sparql-expression.vala"
																																				g_string_append (sql, "SparqlStringFromFilename(");
#line 850 "tracker-sparql-expression.vala"
																																				tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 850 "tracker-sparql-expression.vala"
																																				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 850 "tracker-sparql-expression.vala"
																																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 850 "tracker-sparql-expression.vala"
																																						g_propagate_error (error, _inner_error0_);
#line 850 "tracker-sparql-expression.vala"
																																						return 0;
#line 7750 "tracker-sparql-expression.c"
																																					} else {
#line 850 "tracker-sparql-expression.vala"
																																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 850 "tracker-sparql-expression.vala"
																																						g_clear_error (&_inner_error0_);
#line 850 "tracker-sparql-expression.vala"
																																						return 0;
#line 7758 "tracker-sparql-expression.c"
																																					}
																																				}
#line 851 "tracker-sparql-expression.vala"
																																				g_string_append (sql, ")");
#line 853 "tracker-sparql-expression.vala"
																																				result = TRACKER_PROPERTY_TYPE_STRING;
#line 853 "tracker-sparql-expression.vala"
																																				return result;
#line 7767 "tracker-sparql-expression.c"
																																			} else {
																																				TrackerOntologies* ontologies = NULL;
																																				TrackerDataManager* _tmp116_;
																																				TrackerOntologies* _tmp117_;
																																				TrackerOntologies* _tmp118_;
																																				TrackerProperty* prop = NULL;
																																				TrackerOntologies* _tmp119_;
																																				TrackerProperty* _tmp120_;
																																				TrackerProperty* _tmp121_;
																																				TrackerProperty* _tmp122_;
																																				GString* expr = NULL;
																																				GString* _tmp124_;
																																				GString* _tmp125_;
																																				gchar* value_separator = NULL;
																																				gchar* _tmp126_;
																																				gchar* graph_separator = NULL;
																																				gboolean _tmp127_ = FALSE;
																																				TrackerProperty* _tmp135_;
																																				gboolean _tmp136_;
																																				gboolean _tmp137_;
#line 856 "tracker-sparql-expression.vala"
																																				_tmp116_ = self->priv->manager;
#line 856 "tracker-sparql-expression.vala"
																																				_tmp117_ = tracker_data_manager_get_ontologies (_tmp116_);
#line 856 "tracker-sparql-expression.vala"
																																				_tmp118_ = _g_object_ref0 (_tmp117_);
#line 856 "tracker-sparql-expression.vala"
																																				ontologies = _tmp118_;
#line 857 "tracker-sparql-expression.vala"
																																				_tmp119_ = ontologies;
#line 857 "tracker-sparql-expression.vala"
																																				_tmp120_ = tracker_ontologies_get_property_by_uri (_tmp119_, uri);
#line 857 "tracker-sparql-expression.vala"
																																				_tmp121_ = _g_object_ref0 (_tmp120_);
#line 857 "tracker-sparql-expression.vala"
																																				prop = _tmp121_;
#line 858 "tracker-sparql-expression.vala"
																																				_tmp122_ = prop;
#line 858 "tracker-sparql-expression.vala"
																																				if (_tmp122_ == NULL) {
#line 7808 "tracker-sparql-expression.c"
																																					GError* _tmp123_;
#line 859 "tracker-sparql-expression.vala"
																																					_tmp123_ = tracker_sparql_expression_get_error (self, "Unknown function");
#line 859 "tracker-sparql-expression.vala"
																																					_inner_error0_ = _tmp123_;
#line 859 "tracker-sparql-expression.vala"
																																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 859 "tracker-sparql-expression.vala"
																																						g_propagate_error (error, _inner_error0_);
#line 859 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 859 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 859 "tracker-sparql-expression.vala"
																																						return 0;
#line 7824 "tracker-sparql-expression.c"
																																					} else {
#line 859 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 859 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 859 "tracker-sparql-expression.vala"
																																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 859 "tracker-sparql-expression.vala"
																																						g_clear_error (&_inner_error0_);
#line 859 "tracker-sparql-expression.vala"
																																						return 0;
#line 7836 "tracker-sparql-expression.c"
																																					}
																																				}
#line 862 "tracker-sparql-expression.vala"
																																				_tmp124_ = g_string_new ("");
#line 862 "tracker-sparql-expression.vala"
																																				expr = _tmp124_;
#line 863 "tracker-sparql-expression.vala"
																																				_tmp125_ = expr;
#line 863 "tracker-sparql-expression.vala"
																																				tracker_sparql_expression_translate_expression (self, _tmp125_, &_inner_error0_);
#line 863 "tracker-sparql-expression.vala"
																																				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 863 "tracker-sparql-expression.vala"
																																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 863 "tracker-sparql-expression.vala"
																																						g_propagate_error (error, _inner_error0_);
#line 863 "tracker-sparql-expression.vala"
																																						_g_string_free0 (expr);
#line 863 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 863 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 863 "tracker-sparql-expression.vala"
																																						return 0;
#line 7861 "tracker-sparql-expression.c"
																																					} else {
#line 863 "tracker-sparql-expression.vala"
																																						_g_string_free0 (expr);
#line 863 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 863 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 863 "tracker-sparql-expression.vala"
																																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 863 "tracker-sparql-expression.vala"
																																						g_clear_error (&_inner_error0_);
#line 863 "tracker-sparql-expression.vala"
																																						return 0;
#line 7875 "tracker-sparql-expression.c"
																																					}
																																				}
#line 865 "tracker-sparql-expression.vala"
																																				_tmp126_ = g_strdup (",");
#line 865 "tracker-sparql-expression.vala"
																																				value_separator = _tmp126_;
#line 866 "tracker-sparql-expression.vala"
																																				graph_separator = NULL;
#line 868 "tracker-sparql-expression.vala"
																																				_tmp127_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 868 "tracker-sparql-expression.vala"
																																				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 868 "tracker-sparql-expression.vala"
																																					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 868 "tracker-sparql-expression.vala"
																																						g_propagate_error (error, _inner_error0_);
#line 868 "tracker-sparql-expression.vala"
																																						_g_free0 (graph_separator);
#line 868 "tracker-sparql-expression.vala"
																																						_g_free0 (value_separator);
#line 868 "tracker-sparql-expression.vala"
																																						_g_string_free0 (expr);
#line 868 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 868 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 868 "tracker-sparql-expression.vala"
																																						return 0;
#line 7904 "tracker-sparql-expression.c"
																																					} else {
#line 868 "tracker-sparql-expression.vala"
																																						_g_free0 (graph_separator);
#line 868 "tracker-sparql-expression.vala"
																																						_g_free0 (value_separator);
#line 868 "tracker-sparql-expression.vala"
																																						_g_string_free0 (expr);
#line 868 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 868 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 868 "tracker-sparql-expression.vala"
																																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 868 "tracker-sparql-expression.vala"
																																						g_clear_error (&_inner_error0_);
#line 868 "tracker-sparql-expression.vala"
																																						return 0;
#line 7922 "tracker-sparql-expression.c"
																																					}
																																				}
#line 868 "tracker-sparql-expression.vala"
																																				if (_tmp127_) {
#line 7927 "tracker-sparql-expression.c"
																																					gchar* _tmp128_ = NULL;
																																					gchar* _tmp129_;
																																					gchar* _tmp130_;
																																					gboolean _tmp131_ = FALSE;
#line 869 "tracker-sparql-expression.vala"
																																					_tmp129_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 869 "tracker-sparql-expression.vala"
																																					_tmp128_ = _tmp129_;
#line 869 "tracker-sparql-expression.vala"
																																					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 869 "tracker-sparql-expression.vala"
																																						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 869 "tracker-sparql-expression.vala"
																																							g_propagate_error (error, _inner_error0_);
#line 869 "tracker-sparql-expression.vala"
																																							_g_free0 (graph_separator);
#line 869 "tracker-sparql-expression.vala"
																																							_g_free0 (value_separator);
#line 869 "tracker-sparql-expression.vala"
																																							_g_string_free0 (expr);
#line 869 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (prop);
#line 869 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (ontologies);
#line 869 "tracker-sparql-expression.vala"
																																							return 0;
#line 7954 "tracker-sparql-expression.c"
																																						} else {
#line 869 "tracker-sparql-expression.vala"
																																							_g_free0 (graph_separator);
#line 869 "tracker-sparql-expression.vala"
																																							_g_free0 (value_separator);
#line 869 "tracker-sparql-expression.vala"
																																							_g_string_free0 (expr);
#line 869 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (prop);
#line 869 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (ontologies);
#line 869 "tracker-sparql-expression.vala"
																																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 869 "tracker-sparql-expression.vala"
																																							g_clear_error (&_inner_error0_);
#line 869 "tracker-sparql-expression.vala"
																																							return 0;
#line 7972 "tracker-sparql-expression.c"
																																						}
																																					}
#line 869 "tracker-sparql-expression.vala"
																																					_tmp130_ = _tmp128_;
#line 869 "tracker-sparql-expression.vala"
																																					_tmp128_ = NULL;
#line 869 "tracker-sparql-expression.vala"
																																					_g_free0 (value_separator);
#line 869 "tracker-sparql-expression.vala"
																																					value_separator = _tmp130_;
#line 871 "tracker-sparql-expression.vala"
																																					_tmp131_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 871 "tracker-sparql-expression.vala"
																																					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 871 "tracker-sparql-expression.vala"
																																						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 871 "tracker-sparql-expression.vala"
																																							g_propagate_error (error, _inner_error0_);
#line 871 "tracker-sparql-expression.vala"
																																							_g_free0 (_tmp128_);
#line 871 "tracker-sparql-expression.vala"
																																							_g_free0 (graph_separator);
#line 871 "tracker-sparql-expression.vala"
																																							_g_free0 (value_separator);
#line 871 "tracker-sparql-expression.vala"
																																							_g_string_free0 (expr);
#line 871 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (prop);
#line 871 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (ontologies);
#line 871 "tracker-sparql-expression.vala"
																																							return 0;
#line 8005 "tracker-sparql-expression.c"
																																						} else {
#line 871 "tracker-sparql-expression.vala"
																																							_g_free0 (_tmp128_);
#line 871 "tracker-sparql-expression.vala"
																																							_g_free0 (graph_separator);
#line 871 "tracker-sparql-expression.vala"
																																							_g_free0 (value_separator);
#line 871 "tracker-sparql-expression.vala"
																																							_g_string_free0 (expr);
#line 871 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (prop);
#line 871 "tracker-sparql-expression.vala"
																																							_g_object_unref0 (ontologies);
#line 871 "tracker-sparql-expression.vala"
																																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 871 "tracker-sparql-expression.vala"
																																							g_clear_error (&_inner_error0_);
#line 871 "tracker-sparql-expression.vala"
																																							return 0;
#line 8025 "tracker-sparql-expression.c"
																																						}
																																					}
#line 871 "tracker-sparql-expression.vala"
																																					if (_tmp131_) {
#line 8030 "tracker-sparql-expression.c"
																																						gchar* _tmp132_ = NULL;
																																						gchar* _tmp133_;
																																						gchar* _tmp134_;
#line 872 "tracker-sparql-expression.vala"
																																						_tmp133_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 872 "tracker-sparql-expression.vala"
																																						_tmp132_ = _tmp133_;
#line 872 "tracker-sparql-expression.vala"
																																						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 872 "tracker-sparql-expression.vala"
																																							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 872 "tracker-sparql-expression.vala"
																																								g_propagate_error (error, _inner_error0_);
#line 872 "tracker-sparql-expression.vala"
																																								_g_free0 (_tmp128_);
#line 872 "tracker-sparql-expression.vala"
																																								_g_free0 (graph_separator);
#line 872 "tracker-sparql-expression.vala"
																																								_g_free0 (value_separator);
#line 872 "tracker-sparql-expression.vala"
																																								_g_string_free0 (expr);
#line 872 "tracker-sparql-expression.vala"
																																								_g_object_unref0 (prop);
#line 872 "tracker-sparql-expression.vala"
																																								_g_object_unref0 (ontologies);
#line 872 "tracker-sparql-expression.vala"
																																								return 0;
#line 8058 "tracker-sparql-expression.c"
																																							} else {
#line 872 "tracker-sparql-expression.vala"
																																								_g_free0 (_tmp128_);
#line 872 "tracker-sparql-expression.vala"
																																								_g_free0 (graph_separator);
#line 872 "tracker-sparql-expression.vala"
																																								_g_free0 (value_separator);
#line 872 "tracker-sparql-expression.vala"
																																								_g_string_free0 (expr);
#line 872 "tracker-sparql-expression.vala"
																																								_g_object_unref0 (prop);
#line 872 "tracker-sparql-expression.vala"
																																								_g_object_unref0 (ontologies);
#line 872 "tracker-sparql-expression.vala"
																																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 872 "tracker-sparql-expression.vala"
																																								g_clear_error (&_inner_error0_);
#line 872 "tracker-sparql-expression.vala"
																																								return 0;
#line 8078 "tracker-sparql-expression.c"
																																							}
																																						}
#line 872 "tracker-sparql-expression.vala"
																																						_tmp134_ = _tmp132_;
#line 872 "tracker-sparql-expression.vala"
																																						_tmp132_ = NULL;
#line 872 "tracker-sparql-expression.vala"
																																						_g_free0 (graph_separator);
#line 872 "tracker-sparql-expression.vala"
																																						graph_separator = _tmp134_;
#line 871 "tracker-sparql-expression.vala"
																																						_g_free0 (_tmp132_);
#line 8091 "tracker-sparql-expression.c"
																																					}
#line 868 "tracker-sparql-expression.vala"
																																					_g_free0 (_tmp128_);
#line 8095 "tracker-sparql-expression.c"
																																				}
#line 876 "tracker-sparql-expression.vala"
																																				_tmp135_ = prop;
#line 876 "tracker-sparql-expression.vala"
																																				_tmp136_ = tracker_property_get_multiple_values (_tmp135_);
#line 876 "tracker-sparql-expression.vala"
																																				_tmp137_ = _tmp136_;
#line 876 "tracker-sparql-expression.vala"
																																				if (_tmp137_) {
#line 8105 "tracker-sparql-expression.c"
																																					glong begin = 0L;
																																					TrackerProperty* _tmp138_;
																																					const gchar* _tmp139_;
																																					const gchar* _tmp140_;
																																					TrackerProperty* _tmp141_;
																																					TrackerPropertyType _tmp142_;
																																					TrackerPropertyType _tmp143_;
																																					const gchar* _tmp144_;
																																					const gchar* _tmp151_;
																																					gchar* _tmp152_;
																																					gchar* _tmp153_;
																																					TrackerProperty* _tmp154_;
																																					const gchar* _tmp155_;
																																					const gchar* _tmp156_;
																																					GString* _tmp157_;
																																					const gchar* _tmp158_;
#line 878 "tracker-sparql-expression.vala"
																																					g_string_append (sql, "(SELECT GROUP_CONCAT(");
#line 879 "tracker-sparql-expression.vala"
																																					begin = (glong) sql->len;
#line 880 "tracker-sparql-expression.vala"
																																					_tmp138_ = prop;
#line 880 "tracker-sparql-expression.vala"
																																					_tmp139_ = tracker_property_get_name (_tmp138_);
#line 880 "tracker-sparql-expression.vala"
																																					_tmp140_ = _tmp139_;
#line 880 "tracker-sparql-expression.vala"
																																					g_string_append_printf (sql, "\"%s\"", _tmp140_);
#line 881 "tracker-sparql-expression.vala"
																																					_tmp141_ = prop;
#line 881 "tracker-sparql-expression.vala"
																																					_tmp142_ = tracker_property_get_data_type (_tmp141_);
#line 881 "tracker-sparql-expression.vala"
																																					_tmp143_ = _tmp142_;
#line 881 "tracker-sparql-expression.vala"
																																					tracker_sparql_expression_convert_expression_to_string (sql, _tmp143_, begin);
#line 882 "tracker-sparql-expression.vala"
																																					_tmp144_ = graph_separator;
#line 882 "tracker-sparql-expression.vala"
																																					if (_tmp144_ != NULL) {
#line 8146 "tracker-sparql-expression.c"
																																						const gchar* _tmp145_;
																																						gchar* _tmp146_;
																																						gchar* _tmp147_;
																																						TrackerProperty* _tmp148_;
																																						const gchar* _tmp149_;
																																						const gchar* _tmp150_;
#line 883 "tracker-sparql-expression.vala"
																																						_tmp145_ = graph_separator;
#line 883 "tracker-sparql-expression.vala"
																																						_tmp146_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp145_);
#line 883 "tracker-sparql-expression.vala"
																																						_tmp147_ = _tmp146_;
#line 883 "tracker-sparql-expression.vala"
																																						_tmp148_ = prop;
#line 883 "tracker-sparql-expression.vala"
																																						_tmp149_ = tracker_property_get_name (_tmp148_);
#line 883 "tracker-sparql-expression.vala"
																																						_tmp150_ = _tmp149_;
#line 883 "tracker-sparql-expression.vala"
																																						g_string_append_printf (sql, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp147_, _tmp150_);
#line 883 "tracker-sparql-expression.vala"
																																						_g_free0 (_tmp147_);
#line 8169 "tracker-sparql-expression.c"
																																					}
#line 885 "tracker-sparql-expression.vala"
																																					_tmp151_ = value_separator;
#line 885 "tracker-sparql-expression.vala"
																																					_tmp152_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp151_);
#line 885 "tracker-sparql-expression.vala"
																																					_tmp153_ = _tmp152_;
#line 885 "tracker-sparql-expression.vala"
																																					g_string_append_printf (sql, ",%s)", _tmp153_);
#line 885 "tracker-sparql-expression.vala"
																																					_g_free0 (_tmp153_);
#line 886 "tracker-sparql-expression.vala"
																																					_tmp154_ = prop;
#line 886 "tracker-sparql-expression.vala"
																																					_tmp155_ = tracker_property_get_table_name (_tmp154_);
#line 886 "tracker-sparql-expression.vala"
																																					_tmp156_ = _tmp155_;
#line 886 "tracker-sparql-expression.vala"
																																					_tmp157_ = expr;
#line 886 "tracker-sparql-expression.vala"
																																					_tmp158_ = _tmp157_->str;
#line 886 "tracker-sparql-expression.vala"
																																					g_string_append_printf (sql, " FROM \"%s\" WHERE ID = %s)", _tmp156_, _tmp158_);
#line 888 "tracker-sparql-expression.vala"
																																					result = TRACKER_PROPERTY_TYPE_STRING;
#line 888 "tracker-sparql-expression.vala"
																																					_g_free0 (graph_separator);
#line 888 "tracker-sparql-expression.vala"
																																					_g_free0 (value_separator);
#line 888 "tracker-sparql-expression.vala"
																																					_g_string_free0 (expr);
#line 888 "tracker-sparql-expression.vala"
																																					_g_object_unref0 (prop);
#line 888 "tracker-sparql-expression.vala"
																																					_g_object_unref0 (ontologies);
#line 888 "tracker-sparql-expression.vala"
																																					return result;
#line 8207 "tracker-sparql-expression.c"
																																				} else {
																																					const gchar* _tmp159_;
#line 891 "tracker-sparql-expression.vala"
																																					_tmp159_ = graph_separator;
#line 891 "tracker-sparql-expression.vala"
																																					if (_tmp159_ == NULL) {
#line 8214 "tracker-sparql-expression.c"
																																						TrackerProperty* _tmp160_;
																																						const gchar* _tmp161_;
																																						const gchar* _tmp162_;
																																						TrackerProperty* _tmp163_;
																																						const gchar* _tmp164_;
																																						const gchar* _tmp165_;
																																						GString* _tmp166_;
																																						const gchar* _tmp167_;
																																						TrackerProperty* _tmp168_;
																																						TrackerPropertyType _tmp169_;
																																						TrackerPropertyType _tmp170_;
																																						TrackerProperty* _tmp171_;
																																						TrackerPropertyType _tmp172_;
																																						TrackerPropertyType _tmp173_;
#line 892 "tracker-sparql-expression.vala"
																																						_tmp160_ = prop;
#line 892 "tracker-sparql-expression.vala"
																																						_tmp161_ = tracker_property_get_name (_tmp160_);
#line 892 "tracker-sparql-expression.vala"
																																						_tmp162_ = _tmp161_;
#line 892 "tracker-sparql-expression.vala"
																																						_tmp163_ = prop;
#line 892 "tracker-sparql-expression.vala"
																																						_tmp164_ = tracker_property_get_table_name (_tmp163_);
#line 892 "tracker-sparql-expression.vala"
																																						_tmp165_ = _tmp164_;
#line 892 "tracker-sparql-expression.vala"
																																						_tmp166_ = expr;
#line 892 "tracker-sparql-expression.vala"
																																						_tmp167_ = _tmp166_->str;
#line 892 "tracker-sparql-expression.vala"
																																						g_string_append_printf (sql, "(SELECT \"%s\" FROM \"%s\" WHERE ID = %s)", _tmp162_, _tmp165_, _tmp167_);
#line 894 "tracker-sparql-expression.vala"
																																						_tmp168_ = prop;
#line 894 "tracker-sparql-expression.vala"
																																						_tmp169_ = tracker_property_get_data_type (_tmp168_);
#line 894 "tracker-sparql-expression.vala"
																																						_tmp170_ = _tmp169_;
#line 894 "tracker-sparql-expression.vala"
																																						if (_tmp170_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 895 "tracker-sparql-expression.vala"
																																							tracker_sparql_expression_append_collate (self, sql);
#line 8257 "tracker-sparql-expression.c"
																																						}
#line 898 "tracker-sparql-expression.vala"
																																						_tmp171_ = prop;
#line 898 "tracker-sparql-expression.vala"
																																						_tmp172_ = tracker_property_get_data_type (_tmp171_);
#line 898 "tracker-sparql-expression.vala"
																																						_tmp173_ = _tmp172_;
#line 898 "tracker-sparql-expression.vala"
																																						result = _tmp173_;
#line 898 "tracker-sparql-expression.vala"
																																						_g_free0 (graph_separator);
#line 898 "tracker-sparql-expression.vala"
																																						_g_free0 (value_separator);
#line 898 "tracker-sparql-expression.vala"
																																						_g_string_free0 (expr);
#line 898 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 898 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 898 "tracker-sparql-expression.vala"
																																						return result;
#line 8279 "tracker-sparql-expression.c"
																																					} else {
																																						glong begin = 0L;
																																						TrackerProperty* _tmp174_;
																																						const gchar* _tmp175_;
																																						const gchar* _tmp176_;
																																						TrackerProperty* _tmp177_;
																																						TrackerPropertyType _tmp178_;
																																						TrackerPropertyType _tmp179_;
																																						const gchar* _tmp180_;
																																						gchar* _tmp181_;
																																						gchar* _tmp182_;
																																						TrackerProperty* _tmp183_;
																																						const gchar* _tmp184_;
																																						const gchar* _tmp185_;
																																						TrackerProperty* _tmp186_;
																																						const gchar* _tmp187_;
																																						const gchar* _tmp188_;
																																						GString* _tmp189_;
																																						const gchar* _tmp190_;
#line 900 "tracker-sparql-expression.vala"
																																						g_string_append (sql, "(SELECT ");
#line 901 "tracker-sparql-expression.vala"
																																						begin = (glong) sql->len;
#line 902 "tracker-sparql-expression.vala"
																																						_tmp174_ = prop;
#line 902 "tracker-sparql-expression.vala"
																																						_tmp175_ = tracker_property_get_name (_tmp174_);
#line 902 "tracker-sparql-expression.vala"
																																						_tmp176_ = _tmp175_;
#line 902 "tracker-sparql-expression.vala"
																																						g_string_append_printf (sql, "\"%s\"", _tmp176_);
#line 903 "tracker-sparql-expression.vala"
																																						_tmp177_ = prop;
#line 903 "tracker-sparql-expression.vala"
																																						_tmp178_ = tracker_property_get_data_type (_tmp177_);
#line 903 "tracker-sparql-expression.vala"
																																						_tmp179_ = _tmp178_;
#line 903 "tracker-sparql-expression.vala"
																																						tracker_sparql_expression_convert_expression_to_string (sql, _tmp179_, begin);
#line 904 "tracker-sparql-expression.vala"
																																						_tmp180_ = graph_separator;
#line 904 "tracker-sparql-expression.vala"
																																						_tmp181_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp180_);
#line 904 "tracker-sparql-expression.vala"
																																						_tmp182_ = _tmp181_;
#line 904 "tracker-sparql-expression.vala"
																																						_tmp183_ = prop;
#line 904 "tracker-sparql-expression.vala"
																																						_tmp184_ = tracker_property_get_name (_tmp183_);
#line 904 "tracker-sparql-expression.vala"
																																						_tmp185_ = _tmp184_;
#line 904 "tracker-sparql-expression.vala"
																																						g_string_append_printf (sql, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp182_, _tmp185_);
#line 904 "tracker-sparql-expression.vala"
																																						_g_free0 (_tmp182_);
#line 905 "tracker-sparql-expression.vala"
																																						_tmp186_ = prop;
#line 905 "tracker-sparql-expression.vala"
																																						_tmp187_ = tracker_property_get_table_name (_tmp186_);
#line 905 "tracker-sparql-expression.vala"
																																						_tmp188_ = _tmp187_;
#line 905 "tracker-sparql-expression.vala"
																																						_tmp189_ = expr;
#line 905 "tracker-sparql-expression.vala"
																																						_tmp190_ = _tmp189_->str;
#line 905 "tracker-sparql-expression.vala"
																																						g_string_append_printf (sql, " FROM \"%s\" WHERE ID = %s)", _tmp188_, _tmp190_);
#line 907 "tracker-sparql-expression.vala"
																																						result = TRACKER_PROPERTY_TYPE_STRING;
#line 907 "tracker-sparql-expression.vala"
																																						_g_free0 (graph_separator);
#line 907 "tracker-sparql-expression.vala"
																																						_g_free0 (value_separator);
#line 907 "tracker-sparql-expression.vala"
																																						_g_string_free0 (expr);
#line 907 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (prop);
#line 907 "tracker-sparql-expression.vala"
																																						_g_object_unref0 (ontologies);
#line 907 "tracker-sparql-expression.vala"
																																						return result;
#line 8361 "tracker-sparql-expression.c"
																																					}
																																				}
#line 848 "tracker-sparql-expression.vala"
																																				_g_free0 (graph_separator);
#line 848 "tracker-sparql-expression.vala"
																																				_g_free0 (value_separator);
#line 848 "tracker-sparql-expression.vala"
																																				_g_string_free0 (expr);
#line 848 "tracker-sparql-expression.vala"
																																				_g_object_unref0 (prop);
#line 848 "tracker-sparql-expression.vala"
																																				_g_object_unref0 (ontologies);
#line 8374 "tracker-sparql-expression.c"
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static TrackerPropertyType
tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self,
                                          GError** error)
{
	TrackerPropertyType result = 0;
	gchar* type_iri = NULL;
	TrackerPropertyType type = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
#line 913 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 917 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error0_);
#line 917 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 917 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 917 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 917 "tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 917 "tracker-sparql-expression.vala"
			return 0;
#line 8436 "tracker-sparql-expression.c"
		} else {
#line 917 "tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 917 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 917 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 917 "tracker-sparql-expression.vala"
			return 0;
#line 8446 "tracker-sparql-expression.c"
		}
	}
#line 917 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 8451 "tracker-sparql-expression.c"
		gchar* _tmp1_;
#line 918 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_get_last_string (self, 1);
#line 918 "tracker-sparql-expression.vala"
		_g_free0 (type_iri);
#line 918 "tracker-sparql-expression.vala"
		type_iri = _tmp1_;
#line 8459 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 919 "tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error0_);
#line 919 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 919 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 919 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 919 "tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 919 "tracker-sparql-expression.vala"
				return 0;
#line 8474 "tracker-sparql-expression.c"
			} else {
#line 919 "tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 919 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 919 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 919 "tracker-sparql-expression.vala"
				return 0;
#line 8484 "tracker-sparql-expression.c"
			}
		}
#line 919 "tracker-sparql-expression.vala"
		if (_tmp2_) {
#line 8489 "tracker-sparql-expression.c"
			gchar* ns = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			TrackerSparqlQuery* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
#line 920 "tracker-sparql-expression.vala"
			_tmp3_ = tracker_sparql_expression_get_last_string (self, 0);
#line 920 "tracker-sparql-expression.vala"
			ns = _tmp3_;
#line 921 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 921 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 921 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 921 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 921 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 921 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 921 "tracker-sparql-expression.vala"
					return 0;
#line 8520 "tracker-sparql-expression.c"
				} else {
#line 921 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 921 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 921 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 921 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 921 "tracker-sparql-expression.vala"
					return 0;
#line 8532 "tracker-sparql-expression.c"
				}
			}
#line 922 "tracker-sparql-expression.vala"
			_tmp5_ = self->priv->query;
#line 922 "tracker-sparql-expression.vala"
			_tmp6_ = ns;
#line 922 "tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_last_string (self, 0);
#line 922 "tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 922 "tracker-sparql-expression.vala"
			_tmp9_ = string_substring (_tmp8_, (glong) 1, (glong) -1);
#line 922 "tracker-sparql-expression.vala"
			_tmp10_ = _tmp9_;
#line 922 "tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_query_resolve_prefixed_name (_tmp5_, _tmp6_, _tmp10_, &_inner_error0_);
#line 922 "tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 922 "tracker-sparql-expression.vala"
			_g_free0 (_tmp10_);
#line 922 "tracker-sparql-expression.vala"
			_g_free0 (_tmp8_);
#line 922 "tracker-sparql-expression.vala"
			_tmp4_ = _tmp12_;
#line 922 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 922 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 922 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 922 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 922 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 922 "tracker-sparql-expression.vala"
					return 0;
#line 8569 "tracker-sparql-expression.c"
				} else {
#line 922 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 922 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 922 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 922 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 922 "tracker-sparql-expression.vala"
					return 0;
#line 8581 "tracker-sparql-expression.c"
				}
			}
#line 922 "tracker-sparql-expression.vala"
			_tmp13_ = _tmp4_;
#line 922 "tracker-sparql-expression.vala"
			_tmp4_ = NULL;
#line 922 "tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 922 "tracker-sparql-expression.vala"
			type_iri = _tmp13_;
#line 919 "tracker-sparql-expression.vala"
			_g_free0 (_tmp4_);
#line 919 "tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 8596 "tracker-sparql-expression.c"
		} else {
			gchar* _tmp14_ = NULL;
			TrackerSparqlQuery* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 924 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 924 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 924 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 924 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 924 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 924 "tracker-sparql-expression.vala"
					return 0;
#line 8619 "tracker-sparql-expression.c"
				} else {
#line 924 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 924 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 924 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 924 "tracker-sparql-expression.vala"
					return 0;
#line 8629 "tracker-sparql-expression.c"
				}
			}
#line 925 "tracker-sparql-expression.vala"
			_tmp15_ = self->priv->query;
#line 925 "tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_last_string (self, 0);
#line 925 "tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 925 "tracker-sparql-expression.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) -1);
#line 925 "tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 925 "tracker-sparql-expression.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (_tmp15_, "", _tmp19_, &_inner_error0_);
#line 925 "tracker-sparql-expression.vala"
			_tmp21_ = _tmp20_;
#line 925 "tracker-sparql-expression.vala"
			_g_free0 (_tmp19_);
#line 925 "tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 925 "tracker-sparql-expression.vala"
			_tmp14_ = _tmp21_;
#line 925 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 925 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 925 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 925 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 925 "tracker-sparql-expression.vala"
					return 0;
#line 8662 "tracker-sparql-expression.c"
				} else {
#line 925 "tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 925 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 925 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 925 "tracker-sparql-expression.vala"
					return 0;
#line 8672 "tracker-sparql-expression.c"
				}
			}
#line 925 "tracker-sparql-expression.vala"
			_tmp22_ = _tmp14_;
#line 925 "tracker-sparql-expression.vala"
			_tmp14_ = NULL;
#line 925 "tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 925 "tracker-sparql-expression.vala"
			type_iri = _tmp22_;
#line 919 "tracker-sparql-expression.vala"
			_g_free0 (_tmp14_);
#line 8685 "tracker-sparql-expression.c"
		}
	}
#line 928 "tracker-sparql-expression.vala"
	_tmp23_ = type_iri;
#line 928 "tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp23_, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
#line 929 "tracker-sparql-expression.vala"
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 8694 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
#line 930 "tracker-sparql-expression.vala"
		_tmp36_ = type_iri;
#line 930 "tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp36_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 930 "tracker-sparql-expression.vala"
			_tmp35_ = TRUE;
#line 8715 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp37_;
#line 931 "tracker-sparql-expression.vala"
			_tmp37_ = type_iri;
#line 931 "tracker-sparql-expression.vala"
			_tmp35_ = g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
#line 8722 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp35_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp34_ = TRUE;
#line 8728 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp38_;
#line 932 "tracker-sparql-expression.vala"
			_tmp38_ = type_iri;
#line 932 "tracker-sparql-expression.vala"
			_tmp34_ = g_strcmp0 (_tmp38_, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
#line 8735 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp34_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp33_ = TRUE;
#line 8741 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp39_;
#line 933 "tracker-sparql-expression.vala"
			_tmp39_ = type_iri;
#line 933 "tracker-sparql-expression.vala"
			_tmp33_ = g_strcmp0 (_tmp39_, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
#line 8748 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp33_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp32_ = TRUE;
#line 8754 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp40_;
#line 934 "tracker-sparql-expression.vala"
			_tmp40_ = type_iri;
#line 934 "tracker-sparql-expression.vala"
			_tmp32_ = g_strcmp0 (_tmp40_, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
#line 8761 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp32_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp31_ = TRUE;
#line 8767 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp41_;
#line 935 "tracker-sparql-expression.vala"
			_tmp41_ = type_iri;
#line 935 "tracker-sparql-expression.vala"
			_tmp31_ = g_strcmp0 (_tmp41_, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
#line 8774 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp31_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp30_ = TRUE;
#line 8780 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp42_;
#line 936 "tracker-sparql-expression.vala"
			_tmp42_ = type_iri;
#line 936 "tracker-sparql-expression.vala"
			_tmp30_ = g_strcmp0 (_tmp42_, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
#line 8787 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp30_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp29_ = TRUE;
#line 8793 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp43_;
#line 937 "tracker-sparql-expression.vala"
			_tmp43_ = type_iri;
#line 937 "tracker-sparql-expression.vala"
			_tmp29_ = g_strcmp0 (_tmp43_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
#line 8800 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp29_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp28_ = TRUE;
#line 8806 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp44_;
#line 938 "tracker-sparql-expression.vala"
			_tmp44_ = type_iri;
#line 938 "tracker-sparql-expression.vala"
			_tmp28_ = g_strcmp0 (_tmp44_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
#line 8813 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp28_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp27_ = TRUE;
#line 8819 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp45_;
#line 939 "tracker-sparql-expression.vala"
			_tmp45_ = type_iri;
#line 939 "tracker-sparql-expression.vala"
			_tmp27_ = g_strcmp0 (_tmp45_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
#line 8826 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp27_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp26_ = TRUE;
#line 8832 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp46_;
#line 940 "tracker-sparql-expression.vala"
			_tmp46_ = type_iri;
#line 940 "tracker-sparql-expression.vala"
			_tmp26_ = g_strcmp0 (_tmp46_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
#line 8839 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp26_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp25_ = TRUE;
#line 8845 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp47_;
#line 941 "tracker-sparql-expression.vala"
			_tmp47_ = type_iri;
#line 941 "tracker-sparql-expression.vala"
			_tmp25_ = g_strcmp0 (_tmp47_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
#line 8852 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp25_) {
#line 930 "tracker-sparql-expression.vala"
			_tmp24_ = TRUE;
#line 8858 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp48_;
#line 942 "tracker-sparql-expression.vala"
			_tmp48_ = type_iri;
#line 942 "tracker-sparql-expression.vala"
			_tmp24_ = g_strcmp0 (_tmp48_, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
#line 8865 "tracker-sparql-expression.c"
		}
#line 930 "tracker-sparql-expression.vala"
		if (_tmp24_) {
#line 943 "tracker-sparql-expression.vala"
			type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 8871 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp49_;
#line 944 "tracker-sparql-expression.vala"
			_tmp49_ = type_iri;
#line 944 "tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp49_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 945 "tracker-sparql-expression.vala"
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 8880 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp50_;
#line 946 "tracker-sparql-expression.vala"
				_tmp50_ = type_iri;
#line 946 "tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp50_, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
#line 947 "tracker-sparql-expression.vala"
					type = TRACKER_PROPERTY_TYPE_DATE;
#line 8889 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp51_;
#line 948 "tracker-sparql-expression.vala"
					_tmp51_ = type_iri;
#line 948 "tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp51_, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
#line 949 "tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 8898 "tracker-sparql-expression.c"
					} else {
#line 951 "tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_STRING;
#line 8902 "tracker-sparql-expression.c"
					}
				}
			}
		}
	}
#line 954 "tracker-sparql-expression.vala"
	result = type;
#line 954 "tracker-sparql-expression.vala"
	_g_free0 (type_iri);
#line 954 "tracker-sparql-expression.vala"
	return result;
#line 8914 "tracker-sparql-expression.c"
}

gchar*
tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self,
                                                TrackerPropertyType* type,
                                                GError** error)
{
	TrackerPropertyType _vala_type = 0;
	gchar* result = NULL;
	GError* _inner_error0_ = NULL;
#line 957 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 958 "tracker-sparql-expression.vala"
	_vala_type = TRACKER_PROPERTY_TYPE_STRING;
#line 960 "tracker-sparql-expression.vala"
	tracker_sparql_expression_next (self, &_inner_error0_);
#line 960 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 960 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 960 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 960 "tracker-sparql-expression.vala"
			return NULL;
#line 8939 "tracker-sparql-expression.c"
		} else {
#line 960 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 960 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 960 "tracker-sparql-expression.vala"
			return NULL;
#line 8947 "tracker-sparql-expression.c"
		}
	}
#line 961 "tracker-sparql-expression.vala"
	switch (tracker_sparql_expression_last (self)) {
#line 961 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 961 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 8956 "tracker-sparql-expression.c"
		{
			GString* sb = NULL;
			GString* _tmp0_;
			gchar* s = NULL;
			gchar* _tmp1_;
			const gchar* p = NULL;
			const gchar* _tmp2_;
			const gchar* end = NULL;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gboolean _tmp44_ = FALSE;
			GString* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
#line 964 "tracker-sparql-expression.vala"
			_tmp0_ = g_string_new ("");
#line 964 "tracker-sparql-expression.vala"
			sb = _tmp0_;
#line 966 "tracker-sparql-expression.vala"
			_tmp1_ = tracker_sparql_expression_get_last_string (self, 1);
#line 966 "tracker-sparql-expression.vala"
			s = _tmp1_;
#line 967 "tracker-sparql-expression.vala"
			_tmp2_ = s;
#line 967 "tracker-sparql-expression.vala"
			p = _tmp2_;
#line 968 "tracker-sparql-expression.vala"
			_tmp3_ = p;
#line 968 "tracker-sparql-expression.vala"
			_tmp4_ = s;
#line 968 "tracker-sparql-expression.vala"
			_tmp5_ = strlen (_tmp4_);
#line 968 "tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 968 "tracker-sparql-expression.vala"
			end = _tmp3_ + _tmp6_;
#line 969 "tracker-sparql-expression.vala"
			while (TRUE) {
#line 8997 "tracker-sparql-expression.c"
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* q = NULL;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
#line 969 "tracker-sparql-expression.vala"
				_tmp7_ = p;
#line 969 "tracker-sparql-expression.vala"
				_tmp8_ = end;
#line 969 "tracker-sparql-expression.vala"
				if (!(((glong) _tmp7_) < ((glong) _tmp8_))) {
#line 969 "tracker-sparql-expression.vala"
					break;
#line 9012 "tracker-sparql-expression.c"
				}
#line 970 "tracker-sparql-expression.vala"
				_tmp9_ = p;
#line 970 "tracker-sparql-expression.vala"
				_tmp10_ = strchr (_tmp9_, (gint) '\\');
#line 970 "tracker-sparql-expression.vala"
				q = _tmp10_;
#line 971 "tracker-sparql-expression.vala"
				_tmp11_ = q;
#line 971 "tracker-sparql-expression.vala"
				if (_tmp11_ == NULL) {
#line 9024 "tracker-sparql-expression.c"
					GString* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
#line 972 "tracker-sparql-expression.vala"
					_tmp12_ = sb;
#line 972 "tracker-sparql-expression.vala"
					_tmp13_ = p;
#line 972 "tracker-sparql-expression.vala"
					_tmp14_ = end;
#line 972 "tracker-sparql-expression.vala"
					_tmp15_ = p;
#line 972 "tracker-sparql-expression.vala"
					g_string_append_len (_tmp12_, _tmp13_, (gssize) ((glong) (_tmp14_ - _tmp15_)));
#line 973 "tracker-sparql-expression.vala"
					_tmp16_ = end;
#line 973 "tracker-sparql-expression.vala"
					p = _tmp16_;
#line 9044 "tracker-sparql-expression.c"
				} else {
					GString* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar _tmp23_;
					const gchar* _tmp43_;
#line 975 "tracker-sparql-expression.vala"
					_tmp17_ = sb;
#line 975 "tracker-sparql-expression.vala"
					_tmp18_ = p;
#line 975 "tracker-sparql-expression.vala"
					_tmp19_ = q;
#line 975 "tracker-sparql-expression.vala"
					_tmp20_ = p;
#line 975 "tracker-sparql-expression.vala"
					g_string_append_len (_tmp17_, _tmp18_, (gssize) ((glong) (_tmp19_ - _tmp20_)));
#line 976 "tracker-sparql-expression.vala"
					_tmp21_ = q;
#line 976 "tracker-sparql-expression.vala"
					p = _tmp21_ + 1;
#line 977 "tracker-sparql-expression.vala"
					_tmp22_ = p;
#line 977 "tracker-sparql-expression.vala"
					_tmp23_ = ((gchar*) _tmp22_)[0];
#line 977 "tracker-sparql-expression.vala"
					switch (_tmp23_) {
#line 977 "tracker-sparql-expression.vala"
						case '\'':
#line 977 "tracker-sparql-expression.vala"
						case '"':
#line 977 "tracker-sparql-expression.vala"
						case '\\':
#line 9080 "tracker-sparql-expression.c"
						{
							GString* _tmp24_;
							const gchar* _tmp25_;
							gchar _tmp26_;
#line 981 "tracker-sparql-expression.vala"
							_tmp24_ = sb;
#line 981 "tracker-sparql-expression.vala"
							_tmp25_ = p;
#line 981 "tracker-sparql-expression.vala"
							_tmp26_ = ((gchar*) _tmp25_)[0];
#line 981 "tracker-sparql-expression.vala"
							g_string_append_c (_tmp24_, _tmp26_);
#line 982 "tracker-sparql-expression.vala"
							break;
#line 9095 "tracker-sparql-expression.c"
						}
#line 977 "tracker-sparql-expression.vala"
						case 'b':
#line 9099 "tracker-sparql-expression.c"
						{
							GString* _tmp27_;
#line 984 "tracker-sparql-expression.vala"
							_tmp27_ = sb;
#line 984 "tracker-sparql-expression.vala"
							g_string_append_c (_tmp27_, '\b');
#line 985 "tracker-sparql-expression.vala"
							break;
#line 9108 "tracker-sparql-expression.c"
						}
#line 977 "tracker-sparql-expression.vala"
						case 'f':
#line 9112 "tracker-sparql-expression.c"
						{
							GString* _tmp28_;
#line 987 "tracker-sparql-expression.vala"
							_tmp28_ = sb;
#line 987 "tracker-sparql-expression.vala"
							g_string_append_c (_tmp28_, '\f');
#line 988 "tracker-sparql-expression.vala"
							break;
#line 9121 "tracker-sparql-expression.c"
						}
#line 977 "tracker-sparql-expression.vala"
						case 'n':
#line 9125 "tracker-sparql-expression.c"
						{
							GString* _tmp29_;
#line 990 "tracker-sparql-expression.vala"
							_tmp29_ = sb;
#line 990 "tracker-sparql-expression.vala"
							g_string_append_c (_tmp29_, '\n');
#line 991 "tracker-sparql-expression.vala"
							break;
#line 9134 "tracker-sparql-expression.c"
						}
#line 977 "tracker-sparql-expression.vala"
						case 'r':
#line 9138 "tracker-sparql-expression.c"
						{
							GString* _tmp30_;
#line 993 "tracker-sparql-expression.vala"
							_tmp30_ = sb;
#line 993 "tracker-sparql-expression.vala"
							g_string_append_c (_tmp30_, '\r');
#line 994 "tracker-sparql-expression.vala"
							break;
#line 9147 "tracker-sparql-expression.c"
						}
#line 977 "tracker-sparql-expression.vala"
						case 't':
#line 9151 "tracker-sparql-expression.c"
						{
							GString* _tmp31_;
#line 996 "tracker-sparql-expression.vala"
							_tmp31_ = sb;
#line 996 "tracker-sparql-expression.vala"
							g_string_append_c (_tmp31_, '\t');
#line 997 "tracker-sparql-expression.vala"
							break;
#line 9160 "tracker-sparql-expression.c"
						}
#line 977 "tracker-sparql-expression.vala"
						case 'u':
#line 9164 "tracker-sparql-expression.c"
						{
							gchar* ptr = NULL;
							const gchar* _tmp32_;
							gunichar c = 0U;
							gchar* _tmp33_;
							gchar _tmp34_;
							gchar* _tmp35_;
							gchar _tmp36_;
							gchar* _tmp37_;
							gchar _tmp38_;
							gchar* _tmp39_;
							gchar _tmp40_;
							GString* _tmp41_;
							const gchar* _tmp42_;
#line 999 "tracker-sparql-expression.vala"
							_tmp32_ = p;
#line 999 "tracker-sparql-expression.vala"
							ptr = ((gchar*) _tmp32_) + 1;
#line 1000 "tracker-sparql-expression.vala"
							_tmp33_ = ptr;
#line 1000 "tracker-sparql-expression.vala"
							_tmp34_ = _tmp33_[0];
#line 1000 "tracker-sparql-expression.vala"
							_tmp35_ = ptr;
#line 1000 "tracker-sparql-expression.vala"
							_tmp36_ = _tmp35_[1];
#line 1000 "tracker-sparql-expression.vala"
							_tmp37_ = ptr;
#line 1000 "tracker-sparql-expression.vala"
							_tmp38_ = _tmp37_[2];
#line 1000 "tracker-sparql-expression.vala"
							_tmp39_ = ptr;
#line 1000 "tracker-sparql-expression.vala"
							_tmp40_ = _tmp39_[3];
#line 1000 "tracker-sparql-expression.vala"
							c = (((((((gunichar) g_ascii_xdigit_value (_tmp34_)) * 16) + g_ascii_xdigit_value (_tmp36_)) * 16) + g_ascii_xdigit_value (_tmp38_)) * 16) + g_ascii_xdigit_value (_tmp40_);
#line 1001 "tracker-sparql-expression.vala"
							_tmp41_ = sb;
#line 1001 "tracker-sparql-expression.vala"
							g_string_append_unichar (_tmp41_, c);
#line 1002 "tracker-sparql-expression.vala"
							_tmp42_ = p;
#line 1002 "tracker-sparql-expression.vala"
							p = _tmp42_ + 4;
#line 1003 "tracker-sparql-expression.vala"
							break;
#line 9211 "tracker-sparql-expression.c"
						}
						default:
#line 977 "tracker-sparql-expression.vala"
						break;
#line 9216 "tracker-sparql-expression.c"
					}
#line 1005 "tracker-sparql-expression.vala"
					_tmp43_ = p;
#line 1005 "tracker-sparql-expression.vala"
					p = _tmp43_ + 1;
#line 9222 "tracker-sparql-expression.c"
				}
			}
#line 1009 "tracker-sparql-expression.vala"
			_tmp44_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error0_);
#line 1009 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1009 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1009 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1009 "tracker-sparql-expression.vala"
					_g_free0 (s);
#line 1009 "tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 1009 "tracker-sparql-expression.vala"
					return NULL;
#line 9239 "tracker-sparql-expression.c"
				} else {
#line 1009 "tracker-sparql-expression.vala"
					_g_free0 (s);
#line 1009 "tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 1009 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1009 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1009 "tracker-sparql-expression.vala"
					return NULL;
#line 9251 "tracker-sparql-expression.c"
				}
			}
#line 1009 "tracker-sparql-expression.vala"
			if (_tmp44_) {
#line 9256 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp45_ = 0;
#line 1011 "tracker-sparql-expression.vala"
				_tmp45_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error0_);
#line 1011 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1011 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1011 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1011 "tracker-sparql-expression.vala"
						_g_free0 (s);
#line 1011 "tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 1011 "tracker-sparql-expression.vala"
						return NULL;
#line 9272 "tracker-sparql-expression.c"
					} else {
#line 1011 "tracker-sparql-expression.vala"
						_g_free0 (s);
#line 1011 "tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 1011 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1011 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1011 "tracker-sparql-expression.vala"
						return NULL;
#line 9284 "tracker-sparql-expression.c"
					}
				}
#line 1011 "tracker-sparql-expression.vala"
				_vala_type = _tmp45_;
#line 9289 "tracker-sparql-expression.c"
			}
#line 1014 "tracker-sparql-expression.vala"
			_tmp46_ = sb;
#line 1014 "tracker-sparql-expression.vala"
			_tmp47_ = _tmp46_->str;
#line 1014 "tracker-sparql-expression.vala"
			_tmp48_ = g_strdup (_tmp47_);
#line 1014 "tracker-sparql-expression.vala"
			result = _tmp48_;
#line 1014 "tracker-sparql-expression.vala"
			_g_free0 (s);
#line 1014 "tracker-sparql-expression.vala"
			_g_string_free0 (sb);
#line 1014 "tracker-sparql-expression.vala"
			if (type) {
#line 1014 "tracker-sparql-expression.vala"
				*type = _vala_type;
#line 9307 "tracker-sparql-expression.c"
			}
#line 1014 "tracker-sparql-expression.vala"
			return result;
#line 9311 "tracker-sparql-expression.c"
		}
#line 961 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 961 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 9317 "tracker-sparql-expression.c"
		{
			gchar* _result_ = NULL;
			gchar* _tmp49_;
			gboolean _tmp50_ = FALSE;
#line 1017 "tracker-sparql-expression.vala"
			_tmp49_ = tracker_sparql_expression_get_last_string (self, 3);
#line 1017 "tracker-sparql-expression.vala"
			_result_ = _tmp49_;
#line 1019 "tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error0_);
#line 1019 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1019 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1019 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1019 "tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 1019 "tracker-sparql-expression.vala"
					return NULL;
#line 9338 "tracker-sparql-expression.c"
				} else {
#line 1019 "tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 1019 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1019 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1019 "tracker-sparql-expression.vala"
					return NULL;
#line 9348 "tracker-sparql-expression.c"
				}
			}
#line 1019 "tracker-sparql-expression.vala"
			if (_tmp50_) {
#line 9353 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp51_ = 0;
#line 1021 "tracker-sparql-expression.vala"
				_tmp51_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error0_);
#line 1021 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1021 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1021 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1021 "tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 1021 "tracker-sparql-expression.vala"
						return NULL;
#line 9367 "tracker-sparql-expression.c"
					} else {
#line 1021 "tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 1021 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1021 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1021 "tracker-sparql-expression.vala"
						return NULL;
#line 9377 "tracker-sparql-expression.c"
					}
				}
#line 1021 "tracker-sparql-expression.vala"
				_vala_type = _tmp51_;
#line 9382 "tracker-sparql-expression.c"
			}
#line 1024 "tracker-sparql-expression.vala"
			result = _result_;
#line 1024 "tracker-sparql-expression.vala"
			if (type) {
#line 1024 "tracker-sparql-expression.vala"
				*type = _vala_type;
#line 9390 "tracker-sparql-expression.c"
			}
#line 1024 "tracker-sparql-expression.vala"
			return result;
#line 9394 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp52_;
#line 1026 "tracker-sparql-expression.vala"
			_tmp52_ = tracker_sparql_expression_get_error (self, "expected string literal");
#line 1026 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp52_;
#line 1026 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1026 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1026 "tracker-sparql-expression.vala"
				return NULL;
#line 9409 "tracker-sparql-expression.c"
			} else {
#line 1026 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1026 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1026 "tracker-sparql-expression.vala"
				return NULL;
#line 9417 "tracker-sparql-expression.c"
			}
		}
	}
#line 957 "tracker-sparql-expression.vala"
	if (type) {
#line 957 "tracker-sparql-expression.vala"
		*type = _vala_type;
#line 9425 "tracker-sparql-expression.c"
	}
}

static TrackerPropertyType
tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self,
                                                    GString* sql,
                                                    const gchar* uri,
                                                    GError** error)
{
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 1030 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1030 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1030 "tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 1031 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1031 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1031 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1031 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1031 "tracker-sparql-expression.vala"
			return 0;
#line 9454 "tracker-sparql-expression.c"
		} else {
#line 1031 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1031 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1031 "tracker-sparql-expression.vala"
			return 0;
#line 9462 "tracker-sparql-expression.c"
		}
	}
#line 1031 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 9467 "tracker-sparql-expression.c"
		TrackerPropertyType _result_ = 0;
#line 1033 "tracker-sparql-expression.vala"
		_result_ = tracker_sparql_expression_translate_function (self, sql, uri, &_inner_error0_);
#line 1033 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1033 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1033 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1033 "tracker-sparql-expression.vala"
				return 0;
#line 9479 "tracker-sparql-expression.c"
			} else {
#line 1033 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1033 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1033 "tracker-sparql-expression.vala"
				return 0;
#line 9487 "tracker-sparql-expression.c"
			}
		}
#line 1034 "tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1034 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1034 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1034 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1034 "tracker-sparql-expression.vala"
				return 0;
#line 9500 "tracker-sparql-expression.c"
			} else {
#line 1034 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1034 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1034 "tracker-sparql-expression.vala"
				return 0;
#line 9508 "tracker-sparql-expression.c"
			}
		}
#line 1035 "tracker-sparql-expression.vala"
		result = _result_;
#line 1035 "tracker-sparql-expression.vala"
		return result;
#line 9515 "tracker-sparql-expression.c"
	} else {
		TrackerSparqlLiteralBinding* binding = NULL;
		TrackerSparqlLiteralBinding* _tmp1_;
		TrackerSparqlLiteralBinding* _tmp2_;
		gchar* _tmp3_;
		TrackerSparqlQuery* _tmp4_;
		TrackerSparqlLiteralBinding* _tmp5_;
		TrackerSparqlLiteralBinding* _tmp6_;
#line 1038 "tracker-sparql-expression.vala"
		g_string_append (sql, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
#line 1039 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_literal_binding_new ();
#line 1039 "tracker-sparql-expression.vala"
		binding = _tmp1_;
#line 1040 "tracker-sparql-expression.vala"
		_tmp2_ = binding;
#line 1040 "tracker-sparql-expression.vala"
		_tmp3_ = g_strdup (uri);
#line 1040 "tracker-sparql-expression.vala"
		_g_free0 (_tmp2_->literal);
#line 1040 "tracker-sparql-expression.vala"
		_tmp2_->literal = _tmp3_;
#line 1041 "tracker-sparql-expression.vala"
		_tmp4_ = self->priv->query;
#line 1041 "tracker-sparql-expression.vala"
		_tmp5_ = binding;
#line 1041 "tracker-sparql-expression.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 1041 "tracker-sparql-expression.vala"
		_tmp4_->bindings = g_list_append (_tmp4_->bindings, _tmp6_);
#line 1042 "tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1042 "tracker-sparql-expression.vala"
		_g_object_unref0 (binding);
#line 1042 "tracker-sparql-expression.vala"
		return result;
#line 9552 "tracker-sparql-expression.c"
	}
}

static TrackerPropertyType
tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self,
                                                        GString* sql,
                                                        GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	GError* _inner_error0_ = NULL;
#line 1046 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1046 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1049 "tracker-sparql-expression.vala"
	switch (tracker_sparql_expression_current (self)) {
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 9572 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp0_ = 0;
#line 1051 "tracker-sparql-expression.vala"
			_tmp0_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error0_);
#line 1051 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1051 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1051 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1051 "tracker-sparql-expression.vala"
					return 0;
#line 9585 "tracker-sparql-expression.c"
				} else {
#line 1051 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1051 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1051 "tracker-sparql-expression.vala"
					return 0;
#line 9593 "tracker-sparql-expression.c"
				}
			}
#line 1051 "tracker-sparql-expression.vala"
			result = _tmp0_;
#line 1051 "tracker-sparql-expression.vala"
			return result;
#line 9600 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 9604 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp1_ = 0;
			gchar* _tmp2_;
			gchar* _tmp3_;
			TrackerPropertyType _tmp4_;
#line 1053 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1053 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1053 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1053 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1053 "tracker-sparql-expression.vala"
					return 0;
#line 9620 "tracker-sparql-expression.c"
				} else {
#line 1053 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1053 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1053 "tracker-sparql-expression.vala"
					return 0;
#line 9628 "tracker-sparql-expression.c"
				}
			}
#line 1054 "tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 1054 "tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1054 "tracker-sparql-expression.vala"
			_tmp4_ = tracker_sparql_expression_translate_uri_expression (self, sql, _tmp3_, &_inner_error0_);
#line 1054 "tracker-sparql-expression.vala"
			_g_free0 (_tmp3_);
#line 1054 "tracker-sparql-expression.vala"
			_tmp1_ = _tmp4_;
#line 1054 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1054 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1054 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1054 "tracker-sparql-expression.vala"
					return 0;
#line 9649 "tracker-sparql-expression.c"
				} else {
#line 1054 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1054 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1054 "tracker-sparql-expression.vala"
					return 0;
#line 9657 "tracker-sparql-expression.c"
				}
			}
#line 1054 "tracker-sparql-expression.vala"
			result = _tmp1_;
#line 1054 "tracker-sparql-expression.vala"
			return result;
#line 9664 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 9670 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
#line 1057 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1057 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1057 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1057 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1057 "tracker-sparql-expression.vala"
					return 0;
#line 9685 "tracker-sparql-expression.c"
				} else {
#line 1057 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1057 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1057 "tracker-sparql-expression.vala"
					return 0;
#line 9693 "tracker-sparql-expression.c"
				}
			}
#line 1059 "tracker-sparql-expression.vala"
			_tmp5_ = self->priv->query;
#line 1059 "tracker-sparql-expression.vala"
			_tmp6_ = tracker_sparql_query_get_no_cache (_tmp5_);
#line 1059 "tracker-sparql-expression.vala"
			_tmp7_ = _tmp6_;
#line 1059 "tracker-sparql-expression.vala"
			if (_tmp7_) {
#line 9704 "tracker-sparql-expression.c"
				gchar* _tmp8_;
				gchar* _tmp9_;
#line 1060 "tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1060 "tracker-sparql-expression.vala"
				_tmp9_ = _tmp8_;
#line 1060 "tracker-sparql-expression.vala"
				g_string_append (sql, _tmp9_);
#line 1060 "tracker-sparql-expression.vala"
				_g_free0 (_tmp9_);
#line 9715 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp10_;
				TrackerSparqlLiteralBinding* _tmp11_;
				gchar* _tmp12_;
				TrackerSparqlQuery* _tmp13_;
				TrackerSparqlLiteralBinding* _tmp14_;
				TrackerSparqlLiteralBinding* _tmp15_;
#line 1062 "tracker-sparql-expression.vala"
				g_string_append (sql, "?");
#line 1064 "tracker-sparql-expression.vala"
				_tmp10_ = tracker_sparql_literal_binding_new ();
#line 1064 "tracker-sparql-expression.vala"
				binding = _tmp10_;
#line 1065 "tracker-sparql-expression.vala"
				_tmp11_ = binding;
#line 1065 "tracker-sparql-expression.vala"
				_tmp12_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1065 "tracker-sparql-expression.vala"
				_g_free0 (_tmp11_->literal);
#line 1065 "tracker-sparql-expression.vala"
				_tmp11_->literal = _tmp12_;
#line 1066 "tracker-sparql-expression.vala"
				_tmp13_ = self->priv->query;
#line 1066 "tracker-sparql-expression.vala"
				_tmp14_ = binding;
#line 1066 "tracker-sparql-expression.vala"
				_tmp15_ = _g_object_ref0 (_tmp14_);
#line 1066 "tracker-sparql-expression.vala"
				_tmp13_->bindings = g_list_append (_tmp13_->bindings, _tmp15_);
#line 1059 "tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9748 "tracker-sparql-expression.c"
			}
#line 1069 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 1069 "tracker-sparql-expression.vala"
			return result;
#line 9754 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 9758 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
#line 1071 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1071 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1071 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1071 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1071 "tracker-sparql-expression.vala"
					return 0;
#line 9773 "tracker-sparql-expression.c"
				} else {
#line 1071 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1071 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1071 "tracker-sparql-expression.vala"
					return 0;
#line 9781 "tracker-sparql-expression.c"
				}
			}
#line 1073 "tracker-sparql-expression.vala"
			_tmp16_ = self->priv->query;
#line 1073 "tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_query_get_no_cache (_tmp16_);
#line 1073 "tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 1073 "tracker-sparql-expression.vala"
			if (_tmp18_) {
#line 1074 "tracker-sparql-expression.vala"
				g_string_append (sql, "1");
#line 9794 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp19_;
				TrackerSparqlLiteralBinding* _tmp20_;
				gchar* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
				TrackerSparqlQuery* _tmp23_;
				TrackerSparqlLiteralBinding* _tmp24_;
				TrackerSparqlLiteralBinding* _tmp25_;
#line 1076 "tracker-sparql-expression.vala"
				g_string_append (sql, "?");
#line 1078 "tracker-sparql-expression.vala"
				_tmp19_ = tracker_sparql_literal_binding_new ();
#line 1078 "tracker-sparql-expression.vala"
				binding = _tmp19_;
#line 1079 "tracker-sparql-expression.vala"
				_tmp20_ = binding;
#line 1079 "tracker-sparql-expression.vala"
				_tmp21_ = g_strdup ("1");
#line 1079 "tracker-sparql-expression.vala"
				_g_free0 (_tmp20_->literal);
#line 1079 "tracker-sparql-expression.vala"
				_tmp20_->literal = _tmp21_;
#line 1080 "tracker-sparql-expression.vala"
				_tmp22_ = binding;
#line 1080 "tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp22_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1081 "tracker-sparql-expression.vala"
				_tmp23_ = self->priv->query;
#line 1081 "tracker-sparql-expression.vala"
				_tmp24_ = binding;
#line 1081 "tracker-sparql-expression.vala"
				_tmp25_ = _g_object_ref0 (_tmp24_);
#line 1081 "tracker-sparql-expression.vala"
				_tmp23_->bindings = g_list_append (_tmp23_->bindings, _tmp25_);
#line 1073 "tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9832 "tracker-sparql-expression.c"
			}
#line 1084 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1084 "tracker-sparql-expression.vala"
			return result;
#line 9838 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 9842 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp26_;
			gboolean _tmp27_;
			gboolean _tmp28_;
#line 1086 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1086 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1086 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1086 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1086 "tracker-sparql-expression.vala"
					return 0;
#line 9857 "tracker-sparql-expression.c"
				} else {
#line 1086 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1086 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1086 "tracker-sparql-expression.vala"
					return 0;
#line 9865 "tracker-sparql-expression.c"
				}
			}
#line 1088 "tracker-sparql-expression.vala"
			_tmp26_ = self->priv->query;
#line 1088 "tracker-sparql-expression.vala"
			_tmp27_ = tracker_sparql_query_get_no_cache (_tmp26_);
#line 1088 "tracker-sparql-expression.vala"
			_tmp28_ = _tmp27_;
#line 1088 "tracker-sparql-expression.vala"
			if (_tmp28_) {
#line 1089 "tracker-sparql-expression.vala"
				g_string_append (sql, "0");
#line 9878 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp29_;
				TrackerSparqlLiteralBinding* _tmp30_;
				gchar* _tmp31_;
				TrackerSparqlLiteralBinding* _tmp32_;
				TrackerSparqlQuery* _tmp33_;
				TrackerSparqlLiteralBinding* _tmp34_;
				TrackerSparqlLiteralBinding* _tmp35_;
#line 1091 "tracker-sparql-expression.vala"
				g_string_append (sql, "?");
#line 1093 "tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_literal_binding_new ();
#line 1093 "tracker-sparql-expression.vala"
				binding = _tmp29_;
#line 1094 "tracker-sparql-expression.vala"
				_tmp30_ = binding;
#line 1094 "tracker-sparql-expression.vala"
				_tmp31_ = g_strdup ("0");
#line 1094 "tracker-sparql-expression.vala"
				_g_free0 (_tmp30_->literal);
#line 1094 "tracker-sparql-expression.vala"
				_tmp30_->literal = _tmp31_;
#line 1095 "tracker-sparql-expression.vala"
				_tmp32_ = binding;
#line 1095 "tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp32_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1096 "tracker-sparql-expression.vala"
				_tmp33_ = self->priv->query;
#line 1096 "tracker-sparql-expression.vala"
				_tmp34_ = binding;
#line 1096 "tracker-sparql-expression.vala"
				_tmp35_ = _g_object_ref0 (_tmp34_);
#line 1096 "tracker-sparql-expression.vala"
				_tmp33_->bindings = g_list_append (_tmp33_->bindings, _tmp35_);
#line 1088 "tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9916 "tracker-sparql-expression.c"
			}
#line 1099 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1099 "tracker-sparql-expression.vala"
			return result;
#line 9922 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 9932 "tracker-sparql-expression.c"
		{
			gchar* literal = NULL;
			TrackerPropertyType _tmp36_ = 0;
			gchar* _tmp37_;
			TrackerPropertyType _tmp38_;
#line 1104 "tracker-sparql-expression.vala"
			_tmp37_ = tracker_sparql_expression_parse_string_literal (self, &_tmp36_, &_inner_error0_);
#line 1104 "tracker-sparql-expression.vala"
			type = _tmp36_;
#line 1104 "tracker-sparql-expression.vala"
			literal = _tmp37_;
#line 1104 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1104 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1104 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1104 "tracker-sparql-expression.vala"
					return 0;
#line 9952 "tracker-sparql-expression.c"
				} else {
#line 1104 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1104 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1104 "tracker-sparql-expression.vala"
					return 0;
#line 9960 "tracker-sparql-expression.c"
				}
			}
#line 1106 "tracker-sparql-expression.vala"
			_tmp38_ = type;
#line 1106 "tracker-sparql-expression.vala"
			switch (_tmp38_) {
#line 1106 "tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_INTEGER:
#line 1106 "tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 1106 "tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DOUBLE:
#line 1106 "tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATE:
#line 1106 "tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATETIME:
#line 9977 "tracker-sparql-expression.c"
				{
					TrackerSparqlQuery* _tmp39_;
					gboolean _tmp40_;
					gboolean _tmp41_;
#line 1112 "tracker-sparql-expression.vala"
					_tmp39_ = self->priv->query;
#line 1112 "tracker-sparql-expression.vala"
					_tmp40_ = tracker_sparql_query_get_no_cache (_tmp39_);
#line 1112 "tracker-sparql-expression.vala"
					_tmp41_ = _tmp40_;
#line 1112 "tracker-sparql-expression.vala"
					if (_tmp41_) {
#line 9990 "tracker-sparql-expression.c"
						const gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
#line 1113 "tracker-sparql-expression.vala"
						_tmp42_ = literal;
#line 1113 "tracker-sparql-expression.vala"
						_tmp43_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp42_);
#line 1113 "tracker-sparql-expression.vala"
						_tmp44_ = _tmp43_;
#line 1113 "tracker-sparql-expression.vala"
						g_string_append (sql, _tmp44_);
#line 1113 "tracker-sparql-expression.vala"
						_g_free0 (_tmp44_);
#line 10004 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* binding = NULL;
						TrackerSparqlLiteralBinding* _tmp45_;
						TrackerSparqlLiteralBinding* _tmp46_;
						const gchar* _tmp47_;
						gchar* _tmp48_;
						TrackerSparqlLiteralBinding* _tmp49_;
						TrackerPropertyType _tmp50_;
						TrackerSparqlQuery* _tmp51_;
						TrackerSparqlLiteralBinding* _tmp52_;
						TrackerSparqlLiteralBinding* _tmp53_;
#line 1115 "tracker-sparql-expression.vala"
						_tmp45_ = tracker_sparql_literal_binding_new ();
#line 1115 "tracker-sparql-expression.vala"
						binding = _tmp45_;
#line 1116 "tracker-sparql-expression.vala"
						_tmp46_ = binding;
#line 1116 "tracker-sparql-expression.vala"
						_tmp47_ = literal;
#line 1116 "tracker-sparql-expression.vala"
						_tmp48_ = g_strdup (_tmp47_);
#line 1116 "tracker-sparql-expression.vala"
						_g_free0 (_tmp46_->literal);
#line 1116 "tracker-sparql-expression.vala"
						_tmp46_->literal = _tmp48_;
#line 1117 "tracker-sparql-expression.vala"
						_tmp49_ = binding;
#line 1117 "tracker-sparql-expression.vala"
						_tmp50_ = type;
#line 1117 "tracker-sparql-expression.vala"
						((TrackerSparqlDataBinding*) _tmp49_)->data_type = _tmp50_;
#line 1118 "tracker-sparql-expression.vala"
						_tmp51_ = self->priv->query;
#line 1118 "tracker-sparql-expression.vala"
						_tmp52_ = binding;
#line 1118 "tracker-sparql-expression.vala"
						_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1118 "tracker-sparql-expression.vala"
						_tmp51_->bindings = g_list_append (_tmp51_->bindings, _tmp53_);
#line 1119 "tracker-sparql-expression.vala"
						g_string_append (sql, "?");
#line 1112 "tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 10048 "tracker-sparql-expression.c"
					}
#line 1121 "tracker-sparql-expression.vala"
					result = type;
#line 1121 "tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1121 "tracker-sparql-expression.vala"
					return result;
#line 10056 "tracker-sparql-expression.c"
				}
				default:
				{
					TrackerSparqlQuery* _tmp54_;
					gboolean _tmp55_;
					gboolean _tmp56_;
#line 1123 "tracker-sparql-expression.vala"
					_tmp54_ = self->priv->query;
#line 1123 "tracker-sparql-expression.vala"
					_tmp55_ = tracker_sparql_query_get_no_cache (_tmp54_);
#line 1123 "tracker-sparql-expression.vala"
					_tmp56_ = _tmp55_;
#line 1123 "tracker-sparql-expression.vala"
					if (_tmp56_) {
#line 10071 "tracker-sparql-expression.c"
						const gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
#line 1124 "tracker-sparql-expression.vala"
						_tmp57_ = literal;
#line 1124 "tracker-sparql-expression.vala"
						_tmp58_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp57_);
#line 1124 "tracker-sparql-expression.vala"
						_tmp59_ = _tmp58_;
#line 1124 "tracker-sparql-expression.vala"
						g_string_append (sql, _tmp59_);
#line 1124 "tracker-sparql-expression.vala"
						_g_free0 (_tmp59_);
#line 10085 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* binding = NULL;
						TrackerSparqlLiteralBinding* _tmp60_;
						TrackerSparqlLiteralBinding* _tmp61_;
						const gchar* _tmp62_;
						gchar* _tmp63_;
						TrackerSparqlQuery* _tmp64_;
						TrackerSparqlLiteralBinding* _tmp65_;
						TrackerSparqlLiteralBinding* _tmp66_;
#line 1126 "tracker-sparql-expression.vala"
						_tmp60_ = tracker_sparql_literal_binding_new ();
#line 1126 "tracker-sparql-expression.vala"
						binding = _tmp60_;
#line 1127 "tracker-sparql-expression.vala"
						_tmp61_ = binding;
#line 1127 "tracker-sparql-expression.vala"
						_tmp62_ = literal;
#line 1127 "tracker-sparql-expression.vala"
						_tmp63_ = g_strdup (_tmp62_);
#line 1127 "tracker-sparql-expression.vala"
						_g_free0 (_tmp61_->literal);
#line 1127 "tracker-sparql-expression.vala"
						_tmp61_->literal = _tmp63_;
#line 1128 "tracker-sparql-expression.vala"
						_tmp64_ = self->priv->query;
#line 1128 "tracker-sparql-expression.vala"
						_tmp65_ = binding;
#line 1128 "tracker-sparql-expression.vala"
						_tmp66_ = _g_object_ref0 (_tmp65_);
#line 1128 "tracker-sparql-expression.vala"
						_tmp64_->bindings = g_list_append (_tmp64_->bindings, _tmp66_);
#line 1129 "tracker-sparql-expression.vala"
						g_string_append (sql, "?");
#line 1123 "tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 10121 "tracker-sparql-expression.c"
					}
#line 1131 "tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, sql);
#line 1132 "tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 1132 "tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1132 "tracker-sparql-expression.vala"
					return result;
#line 10131 "tracker-sparql-expression.c"
				}
			}
#line 1049 "tracker-sparql-expression.vala"
			_g_free0 (literal);
#line 10136 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 10140 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp67_;
			gboolean _tmp68_;
			gboolean _tmp69_;
#line 1135 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1135 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1135 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1135 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1135 "tracker-sparql-expression.vala"
					return 0;
#line 10155 "tracker-sparql-expression.c"
				} else {
#line 1135 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1135 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1135 "tracker-sparql-expression.vala"
					return 0;
#line 10163 "tracker-sparql-expression.c"
				}
			}
#line 1137 "tracker-sparql-expression.vala"
			_tmp67_ = self->priv->query;
#line 1137 "tracker-sparql-expression.vala"
			_tmp68_ = tracker_sparql_query_get_no_cache (_tmp67_);
#line 1137 "tracker-sparql-expression.vala"
			_tmp69_ = _tmp68_;
#line 1137 "tracker-sparql-expression.vala"
			if (_tmp69_) {
#line 10174 "tracker-sparql-expression.c"
				gchar* _tmp70_;
				gchar* _tmp71_;
#line 1138 "tracker-sparql-expression.vala"
				_tmp70_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1138 "tracker-sparql-expression.vala"
				_tmp71_ = _tmp70_;
#line 1138 "tracker-sparql-expression.vala"
				g_string_append (sql, _tmp71_);
#line 1138 "tracker-sparql-expression.vala"
				_g_free0 (_tmp71_);
#line 10185 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp72_;
				TrackerSparqlLiteralBinding* _tmp73_;
				gchar* _tmp74_;
				TrackerSparqlLiteralBinding* _tmp75_;
				TrackerSparqlQuery* _tmp76_;
				TrackerSparqlLiteralBinding* _tmp77_;
				TrackerSparqlLiteralBinding* _tmp78_;
#line 1140 "tracker-sparql-expression.vala"
				g_string_append (sql, "?");
#line 1142 "tracker-sparql-expression.vala"
				_tmp72_ = tracker_sparql_literal_binding_new ();
#line 1142 "tracker-sparql-expression.vala"
				binding = _tmp72_;
#line 1143 "tracker-sparql-expression.vala"
				_tmp73_ = binding;
#line 1143 "tracker-sparql-expression.vala"
				_tmp74_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1143 "tracker-sparql-expression.vala"
				_g_free0 (_tmp73_->literal);
#line 1143 "tracker-sparql-expression.vala"
				_tmp73_->literal = _tmp74_;
#line 1144 "tracker-sparql-expression.vala"
				_tmp75_ = binding;
#line 1144 "tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp75_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1145 "tracker-sparql-expression.vala"
				_tmp76_ = self->priv->query;
#line 1145 "tracker-sparql-expression.vala"
				_tmp77_ = binding;
#line 1145 "tracker-sparql-expression.vala"
				_tmp78_ = _g_object_ref0 (_tmp77_);
#line 1145 "tracker-sparql-expression.vala"
				_tmp76_->bindings = g_list_append (_tmp76_->bindings, _tmp78_);
#line 1137 "tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10223 "tracker-sparql-expression.c"
			}
#line 1148 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1148 "tracker-sparql-expression.vala"
			return result;
#line 10229 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 10233 "tracker-sparql-expression.c"
		{
			gchar* variable_name = NULL;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			TrackerSparqlVariable* variable = NULL;
			TrackerSparqlContext* _tmp83_;
			TrackerSparqlContext* _tmp84_;
			const gchar* _tmp85_;
			TrackerSparqlVariable* _tmp86_;
			TrackerSparqlVariable* _tmp87_;
			gboolean _tmp88_ = FALSE;
			TrackerSparqlContext* _tmp89_;
			TrackerSparqlContext* _tmp90_;
			TrackerSparqlVariable* _tmp100_;
			TrackerSparqlVariableBinding* _tmp101_;
#line 1150 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1150 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1150 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1150 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1150 "tracker-sparql-expression.vala"
					return 0;
#line 10261 "tracker-sparql-expression.c"
				} else {
#line 1150 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1150 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1150 "tracker-sparql-expression.vala"
					return 0;
#line 10269 "tracker-sparql-expression.c"
				}
			}
#line 1151 "tracker-sparql-expression.vala"
			_tmp79_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1151 "tracker-sparql-expression.vala"
			_tmp80_ = _tmp79_;
#line 1151 "tracker-sparql-expression.vala"
			_tmp81_ = string_substring (_tmp80_, (glong) 1, (glong) -1);
#line 1151 "tracker-sparql-expression.vala"
			_tmp82_ = _tmp81_;
#line 1151 "tracker-sparql-expression.vala"
			_g_free0 (_tmp80_);
#line 1151 "tracker-sparql-expression.vala"
			variable_name = _tmp82_;
#line 1152 "tracker-sparql-expression.vala"
			_tmp83_ = tracker_sparql_expression_get_context (self);
#line 1152 "tracker-sparql-expression.vala"
			_tmp84_ = _tmp83_;
#line 1152 "tracker-sparql-expression.vala"
			_tmp85_ = variable_name;
#line 1152 "tracker-sparql-expression.vala"
			_tmp86_ = tracker_sparql_context_get_variable (_tmp84_, _tmp85_);
#line 1152 "tracker-sparql-expression.vala"
			_tmp87_ = _g_object_ref0 (_tmp86_);
#line 1152 "tracker-sparql-expression.vala"
			variable = _tmp87_;
#line 1154 "tracker-sparql-expression.vala"
			_tmp89_ = tracker_sparql_expression_get_context (self);
#line 1154 "tracker-sparql-expression.vala"
			_tmp90_ = _tmp89_;
#line 1154 "tracker-sparql-expression.vala"
			if (_tmp90_->need_binding_expression) {
#line 10302 "tracker-sparql-expression.c"
				TrackerSparqlVariable* _tmp91_;
				TrackerSparqlVariableBinding* _tmp92_;
#line 1154 "tracker-sparql-expression.vala"
				_tmp91_ = variable;
#line 1154 "tracker-sparql-expression.vala"
				_tmp92_ = _tmp91_->binding;
#line 1154 "tracker-sparql-expression.vala"
				_tmp88_ = _tmp92_ != NULL;
#line 10311 "tracker-sparql-expression.c"
			} else {
#line 1154 "tracker-sparql-expression.vala"
				_tmp88_ = FALSE;
#line 10315 "tracker-sparql-expression.c"
			}
#line 1154 "tracker-sparql-expression.vala"
			if (_tmp88_) {
#line 10319 "tracker-sparql-expression.c"
				TrackerSparqlVariable* _tmp93_;
				TrackerSparqlVariableBinding* _tmp94_;
				const gchar* _tmp95_;
				const gchar* _tmp96_;
#line 1155 "tracker-sparql-expression.vala"
				_tmp93_ = variable;
#line 1155 "tracker-sparql-expression.vala"
				_tmp94_ = _tmp93_->binding;
#line 1155 "tracker-sparql-expression.vala"
				_tmp95_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp94_);
#line 1155 "tracker-sparql-expression.vala"
				_tmp96_ = _tmp95_;
#line 1155 "tracker-sparql-expression.vala"
				g_string_append (sql, _tmp96_);
#line 10334 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlVariable* _tmp97_;
				const gchar* _tmp98_;
				const gchar* _tmp99_;
#line 1157 "tracker-sparql-expression.vala"
				_tmp97_ = variable;
#line 1157 "tracker-sparql-expression.vala"
				_tmp98_ = tracker_sparql_variable_get_sql_expression (_tmp97_);
#line 1157 "tracker-sparql-expression.vala"
				_tmp99_ = _tmp98_;
#line 1157 "tracker-sparql-expression.vala"
				g_string_append (sql, _tmp99_);
#line 10347 "tracker-sparql-expression.c"
			}
#line 1160 "tracker-sparql-expression.vala"
			_tmp100_ = variable;
#line 1160 "tracker-sparql-expression.vala"
			_tmp101_ = _tmp100_->binding;
#line 1160 "tracker-sparql-expression.vala"
			if (_tmp101_ == NULL) {
#line 1161 "tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 1161 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1161 "tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1161 "tracker-sparql-expression.vala"
				return result;
#line 10363 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlVariable* _tmp102_;
				TrackerSparqlVariableBinding* _tmp103_;
				TrackerPropertyType _tmp104_;
				TrackerSparqlVariable* _tmp105_;
				TrackerSparqlVariableBinding* _tmp106_;
				TrackerPropertyType _tmp107_;
#line 1163 "tracker-sparql-expression.vala"
				_tmp102_ = variable;
#line 1163 "tracker-sparql-expression.vala"
				_tmp103_ = _tmp102_->binding;
#line 1163 "tracker-sparql-expression.vala"
				_tmp104_ = ((TrackerSparqlDataBinding*) _tmp103_)->data_type;
#line 1163 "tracker-sparql-expression.vala"
				if (_tmp104_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1164 "tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, sql);
#line 10381 "tracker-sparql-expression.c"
				}
#line 1166 "tracker-sparql-expression.vala"
				_tmp105_ = variable;
#line 1166 "tracker-sparql-expression.vala"
				_tmp106_ = _tmp105_->binding;
#line 1166 "tracker-sparql-expression.vala"
				_tmp107_ = ((TrackerSparqlDataBinding*) _tmp106_)->data_type;
#line 1166 "tracker-sparql-expression.vala"
				result = _tmp107_;
#line 1166 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1166 "tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1166 "tracker-sparql-expression.vala"
				return result;
#line 10397 "tracker-sparql-expression.c"
			}
#line 1049 "tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 1049 "tracker-sparql-expression.vala"
			_g_free0 (variable_name);
#line 10403 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 10407 "tracker-sparql-expression.c"
		{
#line 1169 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_str (self, sql, &_inner_error0_);
#line 1169 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1169 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1169 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1169 "tracker-sparql-expression.vala"
					return 0;
#line 10419 "tracker-sparql-expression.c"
				} else {
#line 1169 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1169 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1169 "tracker-sparql-expression.vala"
					return 0;
#line 10427 "tracker-sparql-expression.c"
				}
			}
#line 1170 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1170 "tracker-sparql-expression.vala"
			return result;
#line 10434 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 10438 "tracker-sparql-expression.c"
		{
#line 1172 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1172 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1172 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1172 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1172 "tracker-sparql-expression.vala"
					return 0;
#line 10450 "tracker-sparql-expression.c"
				} else {
#line 1172 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1172 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1172 "tracker-sparql-expression.vala"
					return 0;
#line 10458 "tracker-sparql-expression.c"
				}
			}
#line 1173 "tracker-sparql-expression.vala"
			g_string_append (sql, "''");
#line 1174 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1174 "tracker-sparql-expression.vala"
			return result;
#line 10467 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 10471 "tracker-sparql-expression.c"
		{
#line 1176 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1176 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1176 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1176 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1176 "tracker-sparql-expression.vala"
					return 0;
#line 10483 "tracker-sparql-expression.c"
				} else {
#line 1176 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1176 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1176 "tracker-sparql-expression.vala"
					return 0;
#line 10491 "tracker-sparql-expression.c"
				}
			}
#line 1177 "tracker-sparql-expression.vala"
			g_string_append (sql, "0");
#line 1178 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1178 "tracker-sparql-expression.vala"
			return result;
#line 10500 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 10504 "tracker-sparql-expression.c"
		{
#line 1180 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_datatype (self, sql, &_inner_error0_);
#line 1180 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1180 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1180 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1180 "tracker-sparql-expression.vala"
					return 0;
#line 10516 "tracker-sparql-expression.c"
				} else {
#line 1180 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1180 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1180 "tracker-sparql-expression.vala"
					return 0;
#line 10524 "tracker-sparql-expression.c"
				}
			}
#line 1181 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1181 "tracker-sparql-expression.vala"
			return result;
#line 10531 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 10535 "tracker-sparql-expression.c"
		{
#line 1183 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_bound_call (self, sql, &_inner_error0_);
#line 1183 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1183 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1183 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1183 "tracker-sparql-expression.vala"
					return 0;
#line 10547 "tracker-sparql-expression.c"
				} else {
#line 1183 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1183 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1183 "tracker-sparql-expression.vala"
					return 0;
#line 10555 "tracker-sparql-expression.c"
				}
			}
#line 1184 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1184 "tracker-sparql-expression.vala"
			return result;
#line 10562 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 10566 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1186 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1186 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1186 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1186 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1186 "tracker-sparql-expression.vala"
					return 0;
#line 10579 "tracker-sparql-expression.c"
				} else {
#line 1186 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1186 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1186 "tracker-sparql-expression.vala"
					return 0;
#line 10587 "tracker-sparql-expression.c"
				}
			}
#line 1187 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1187 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1187 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1187 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1187 "tracker-sparql-expression.vala"
					return 0;
#line 10600 "tracker-sparql-expression.c"
				} else {
#line 1187 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1187 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1187 "tracker-sparql-expression.vala"
					return 0;
#line 10608 "tracker-sparql-expression.c"
				}
			}
#line 1188 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce", &_inner_error0_);
#line 1188 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1188 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1188 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1188 "tracker-sparql-expression.vala"
					return 0;
#line 10621 "tracker-sparql-expression.c"
				} else {
#line 1188 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1188 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1188 "tracker-sparql-expression.vala"
					return 0;
#line 10629 "tracker-sparql-expression.c"
				}
			}
#line 1189 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1189 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1189 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1189 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1189 "tracker-sparql-expression.vala"
					return 0;
#line 10642 "tracker-sparql-expression.c"
				} else {
#line 1189 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1189 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1189 "tracker-sparql-expression.vala"
					return 0;
#line 10650 "tracker-sparql-expression.c"
				}
			}
#line 1190 "tracker-sparql-expression.vala"
			result = _result_;
#line 1190 "tracker-sparql-expression.vala"
			return result;
#line 10657 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONCAT:
#line 10661 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1192 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1192 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1192 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1192 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1192 "tracker-sparql-expression.vala"
					return 0;
#line 10674 "tracker-sparql-expression.c"
				} else {
#line 1192 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1192 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1192 "tracker-sparql-expression.vala"
					return 0;
#line 10682 "tracker-sparql-expression.c"
				}
			}
#line 1193 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1193 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1193 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1193 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1193 "tracker-sparql-expression.vala"
					return 0;
#line 10695 "tracker-sparql-expression.c"
				} else {
#line 1193 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1193 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1193 "tracker-sparql-expression.vala"
					return 0;
#line 10703 "tracker-sparql-expression.c"
				}
			}
#line 1194 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "concat", &_inner_error0_);
#line 1194 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1194 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1194 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1194 "tracker-sparql-expression.vala"
					return 0;
#line 10716 "tracker-sparql-expression.c"
				} else {
#line 1194 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1194 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1194 "tracker-sparql-expression.vala"
					return 0;
#line 10724 "tracker-sparql-expression.c"
				}
			}
#line 1195 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1195 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1195 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1195 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1195 "tracker-sparql-expression.vala"
					return 0;
#line 10737 "tracker-sparql-expression.c"
				} else {
#line 1195 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1195 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1195 "tracker-sparql-expression.vala"
					return 0;
#line 10745 "tracker-sparql-expression.c"
				}
			}
#line 1196 "tracker-sparql-expression.vala"
			result = _result_;
#line 1196 "tracker-sparql-expression.vala"
			return result;
#line 10752 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONTAINS:
#line 10756 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1198 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1198 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1198 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1198 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1198 "tracker-sparql-expression.vala"
					return 0;
#line 10769 "tracker-sparql-expression.c"
				} else {
#line 1198 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1198 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1198 "tracker-sparql-expression.vala"
					return 0;
#line 10777 "tracker-sparql-expression.c"
				}
			}
#line 1199 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1199 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1199 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1199 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1199 "tracker-sparql-expression.vala"
					return 0;
#line 10790 "tracker-sparql-expression.c"
				} else {
#line 1199 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1199 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1199 "tracker-sparql-expression.vala"
					return 0;
#line 10798 "tracker-sparql-expression.c"
				}
			}
#line 1200 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "contains", &_inner_error0_);
#line 1200 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1200 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1200 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1200 "tracker-sparql-expression.vala"
					return 0;
#line 10811 "tracker-sparql-expression.c"
				} else {
#line 1200 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1200 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1200 "tracker-sparql-expression.vala"
					return 0;
#line 10819 "tracker-sparql-expression.c"
				}
			}
#line 1201 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1201 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1201 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1201 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1201 "tracker-sparql-expression.vala"
					return 0;
#line 10832 "tracker-sparql-expression.c"
				} else {
#line 1201 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1201 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1201 "tracker-sparql-expression.vala"
					return 0;
#line 10840 "tracker-sparql-expression.c"
				}
			}
#line 1202 "tracker-sparql-expression.vala"
			result = _result_;
#line 1202 "tracker-sparql-expression.vala"
			return result;
#line 10847 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI:
#line 10851 "tracker-sparql-expression.c"
		{
#line 1204 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1204 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1204 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1204 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1204 "tracker-sparql-expression.vala"
					return 0;
#line 10863 "tracker-sparql-expression.c"
				} else {
#line 1204 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1204 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1204 "tracker-sparql-expression.vala"
					return 0;
#line 10871 "tracker-sparql-expression.c"
				}
			}
#line 1205 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1205 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1205 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1205 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1205 "tracker-sparql-expression.vala"
					return 0;
#line 10884 "tracker-sparql-expression.c"
				} else {
#line 1205 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1205 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1205 "tracker-sparql-expression.vala"
					return 0;
#line 10892 "tracker-sparql-expression.c"
				}
			}
#line 1206 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlEncodeForUri (");
#line 1207 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 1207 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1207 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1207 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1207 "tracker-sparql-expression.vala"
					return 0;
#line 10907 "tracker-sparql-expression.c"
				} else {
#line 1207 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1207 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1207 "tracker-sparql-expression.vala"
					return 0;
#line 10915 "tracker-sparql-expression.c"
				}
			}
#line 1208 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1209 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1209 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1209 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1209 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1209 "tracker-sparql-expression.vala"
					return 0;
#line 10930 "tracker-sparql-expression.c"
				} else {
#line 1209 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1209 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1209 "tracker-sparql-expression.vala"
					return 0;
#line 10938 "tracker-sparql-expression.c"
				}
			}
#line 1210 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1210 "tracker-sparql-expression.vala"
			return result;
#line 10945 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 10949 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp108_ = 0;
#line 1212 "tracker-sparql-expression.vala"
			_tmp108_ = tracker_sparql_expression_translate_if_call (self, sql, &_inner_error0_);
#line 1212 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1212 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1212 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1212 "tracker-sparql-expression.vala"
					return 0;
#line 10962 "tracker-sparql-expression.c"
				} else {
#line 1212 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1212 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1212 "tracker-sparql-expression.vala"
					return 0;
#line 10970 "tracker-sparql-expression.c"
				}
			}
#line 1212 "tracker-sparql-expression.vala"
			result = _tmp108_;
#line 1212 "tracker-sparql-expression.vala"
			return result;
#line 10977 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 10981 "tracker-sparql-expression.c"
		{
#line 1214 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1214 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1214 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1214 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1214 "tracker-sparql-expression.vala"
					return 0;
#line 10993 "tracker-sparql-expression.c"
				} else {
#line 1214 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1214 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1214 "tracker-sparql-expression.vala"
					return 0;
#line 11001 "tracker-sparql-expression.c"
				}
			}
#line 1215 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1215 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1215 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1215 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1215 "tracker-sparql-expression.vala"
					return 0;
#line 11014 "tracker-sparql-expression.c"
				} else {
#line 1215 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1215 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1215 "tracker-sparql-expression.vala"
					return 0;
#line 11022 "tracker-sparql-expression.c"
				}
			}
#line 1216 "tracker-sparql-expression.vala"
			g_string_append (sql, "(");
#line 1217 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 1217 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1217 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1217 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1217 "tracker-sparql-expression.vala"
					return 0;
#line 11037 "tracker-sparql-expression.c"
				} else {
#line 1217 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1217 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1217 "tracker-sparql-expression.vala"
					return 0;
#line 11045 "tracker-sparql-expression.c"
				}
			}
#line 1218 "tracker-sparql-expression.vala"
			g_string_append (sql, " = ");
#line 1219 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 1219 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1219 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1219 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1219 "tracker-sparql-expression.vala"
					return 0;
#line 11060 "tracker-sparql-expression.c"
				} else {
#line 1219 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1219 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1219 "tracker-sparql-expression.vala"
					return 0;
#line 11068 "tracker-sparql-expression.c"
				}
			}
#line 1220 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 1220 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1220 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1220 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1220 "tracker-sparql-expression.vala"
					return 0;
#line 11081 "tracker-sparql-expression.c"
				} else {
#line 1220 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1220 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1220 "tracker-sparql-expression.vala"
					return 0;
#line 11089 "tracker-sparql-expression.c"
				}
			}
#line 1221 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1222 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1222 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1222 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1222 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1222 "tracker-sparql-expression.vala"
					return 0;
#line 11104 "tracker-sparql-expression.c"
				} else {
#line 1222 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1222 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1222 "tracker-sparql-expression.vala"
					return 0;
#line 11112 "tracker-sparql-expression.c"
				}
			}
#line 1223 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1223 "tracker-sparql-expression.vala"
			return result;
#line 11119 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 11125 "tracker-sparql-expression.c"
		{
#line 1226 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_isuri (self, sql, &_inner_error0_);
#line 1226 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1226 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1226 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1226 "tracker-sparql-expression.vala"
					return 0;
#line 11137 "tracker-sparql-expression.c"
				} else {
#line 1226 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1226 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1226 "tracker-sparql-expression.vala"
					return 0;
#line 11145 "tracker-sparql-expression.c"
				}
			}
#line 1227 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1227 "tracker-sparql-expression.vala"
			return result;
#line 11152 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 11156 "tracker-sparql-expression.c"
		{
#line 1229 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1229 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1229 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1229 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1229 "tracker-sparql-expression.vala"
					return 0;
#line 11168 "tracker-sparql-expression.c"
				} else {
#line 1229 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1229 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1229 "tracker-sparql-expression.vala"
					return 0;
#line 11176 "tracker-sparql-expression.c"
				}
			}
#line 1230 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1230 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1230 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1230 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1230 "tracker-sparql-expression.vala"
					return 0;
#line 11189 "tracker-sparql-expression.c"
				} else {
#line 1230 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1230 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1230 "tracker-sparql-expression.vala"
					return 0;
#line 11197 "tracker-sparql-expression.c"
				}
			}
#line 1231 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1231 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1231 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1231 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1231 "tracker-sparql-expression.vala"
					return 0;
#line 11210 "tracker-sparql-expression.c"
				} else {
#line 1231 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1231 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1231 "tracker-sparql-expression.vala"
					return 0;
#line 11218 "tracker-sparql-expression.c"
				}
			}
#line 1233 "tracker-sparql-expression.vala"
			g_string_append (sql, "0");
#line 1234 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1234 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1234 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1234 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1234 "tracker-sparql-expression.vala"
					return 0;
#line 11233 "tracker-sparql-expression.c"
				} else {
#line 1234 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1234 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1234 "tracker-sparql-expression.vala"
					return 0;
#line 11241 "tracker-sparql-expression.c"
				}
			}
#line 1235 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1235 "tracker-sparql-expression.vala"
			return result;
#line 11248 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 11252 "tracker-sparql-expression.c"
		{
#line 1237 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1237 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1237 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1237 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1237 "tracker-sparql-expression.vala"
					return 0;
#line 11264 "tracker-sparql-expression.c"
				} else {
#line 1237 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1237 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1237 "tracker-sparql-expression.vala"
					return 0;
#line 11272 "tracker-sparql-expression.c"
				}
			}
#line 1238 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1238 "tracker-sparql-expression.vala"
			return result;
#line 11279 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LCASE:
#line 11283 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1240 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1240 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1240 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1240 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1240 "tracker-sparql-expression.vala"
					return 0;
#line 11296 "tracker-sparql-expression.c"
				} else {
#line 1240 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1240 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1240 "tracker-sparql-expression.vala"
					return 0;
#line 11304 "tracker-sparql-expression.c"
				}
			}
#line 1241 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1241 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1241 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1241 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1241 "tracker-sparql-expression.vala"
					return 0;
#line 11317 "tracker-sparql-expression.c"
				} else {
#line 1241 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1241 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1241 "tracker-sparql-expression.vala"
					return 0;
#line 11325 "tracker-sparql-expression.c"
				}
			}
#line 1242 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case", &_inner_error0_);
#line 1242 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1242 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1242 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1242 "tracker-sparql-expression.vala"
					return 0;
#line 11338 "tracker-sparql-expression.c"
				} else {
#line 1242 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1242 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1242 "tracker-sparql-expression.vala"
					return 0;
#line 11346 "tracker-sparql-expression.c"
				}
			}
#line 1243 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1243 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1243 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1243 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1243 "tracker-sparql-expression.vala"
					return 0;
#line 11359 "tracker-sparql-expression.c"
				} else {
#line 1243 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1243 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1243 "tracker-sparql-expression.vala"
					return 0;
#line 11367 "tracker-sparql-expression.c"
				}
			}
#line 1244 "tracker-sparql-expression.vala"
			result = _result_;
#line 1244 "tracker-sparql-expression.vala"
			return result;
#line 11374 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UCASE:
#line 11378 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1246 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1246 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1246 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1246 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1246 "tracker-sparql-expression.vala"
					return 0;
#line 11391 "tracker-sparql-expression.c"
				} else {
#line 1246 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1246 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1246 "tracker-sparql-expression.vala"
					return 0;
#line 11399 "tracker-sparql-expression.c"
				}
			}
#line 1247 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1247 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1247 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1247 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1247 "tracker-sparql-expression.vala"
					return 0;
#line 11412 "tracker-sparql-expression.c"
				} else {
#line 1247 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1247 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1247 "tracker-sparql-expression.vala"
					return 0;
#line 11420 "tracker-sparql-expression.c"
				}
			}
#line 1248 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "upper-case", &_inner_error0_);
#line 1248 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1248 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1248 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1248 "tracker-sparql-expression.vala"
					return 0;
#line 11433 "tracker-sparql-expression.c"
				} else {
#line 1248 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1248 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1248 "tracker-sparql-expression.vala"
					return 0;
#line 11441 "tracker-sparql-expression.c"
				}
			}
#line 1249 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1249 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1249 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1249 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1249 "tracker-sparql-expression.vala"
					return 0;
#line 11454 "tracker-sparql-expression.c"
				} else {
#line 1249 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1249 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1249 "tracker-sparql-expression.vala"
					return 0;
#line 11462 "tracker-sparql-expression.c"
				}
			}
#line 1250 "tracker-sparql-expression.vala"
			result = _result_;
#line 1250 "tracker-sparql-expression.vala"
			return result;
#line 11469 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRLEN:
#line 11473 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp109_ = 0;
#line 1252 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1252 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1252 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1252 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1252 "tracker-sparql-expression.vala"
					return 0;
#line 11486 "tracker-sparql-expression.c"
				} else {
#line 1252 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1252 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1252 "tracker-sparql-expression.vala"
					return 0;
#line 11494 "tracker-sparql-expression.c"
				}
			}
#line 1253 "tracker-sparql-expression.vala"
			g_string_append (sql, "LENGTH(");
#line 1254 "tracker-sparql-expression.vala"
			_tmp109_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1254 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1254 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1254 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1254 "tracker-sparql-expression.vala"
					return 0;
#line 11509 "tracker-sparql-expression.c"
				} else {
#line 1254 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1254 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1254 "tracker-sparql-expression.vala"
					return 0;
#line 11517 "tracker-sparql-expression.c"
				}
			}
#line 1254 "tracker-sparql-expression.vala"
			type = _tmp109_;
#line 1255 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1256 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1256 "tracker-sparql-expression.vala"
			return result;
#line 11528 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS:
#line 11532 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1258 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1258 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1258 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1258 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1258 "tracker-sparql-expression.vala"
					return 0;
#line 11545 "tracker-sparql-expression.c"
				} else {
#line 1258 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1258 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1258 "tracker-sparql-expression.vala"
					return 0;
#line 11553 "tracker-sparql-expression.c"
				}
			}
#line 1259 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1259 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1259 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1259 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1259 "tracker-sparql-expression.vala"
					return 0;
#line 11566 "tracker-sparql-expression.c"
				} else {
#line 1259 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1259 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1259 "tracker-sparql-expression.vala"
					return 0;
#line 11574 "tracker-sparql-expression.c"
				}
			}
#line 1260 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with", &_inner_error0_);
#line 1260 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1260 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1260 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1260 "tracker-sparql-expression.vala"
					return 0;
#line 11587 "tracker-sparql-expression.c"
				} else {
#line 1260 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1260 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1260 "tracker-sparql-expression.vala"
					return 0;
#line 11595 "tracker-sparql-expression.c"
				}
			}
#line 1261 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1261 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1261 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1261 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1261 "tracker-sparql-expression.vala"
					return 0;
#line 11608 "tracker-sparql-expression.c"
				} else {
#line 1261 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1261 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1261 "tracker-sparql-expression.vala"
					return 0;
#line 11616 "tracker-sparql-expression.c"
				}
			}
#line 1262 "tracker-sparql-expression.vala"
			result = _result_;
#line 1262 "tracker-sparql-expression.vala"
			return result;
#line 11623 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRENDS:
#line 11627 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1264 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1264 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1264 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1264 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1264 "tracker-sparql-expression.vala"
					return 0;
#line 11640 "tracker-sparql-expression.c"
				} else {
#line 1264 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1264 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1264 "tracker-sparql-expression.vala"
					return 0;
#line 11648 "tracker-sparql-expression.c"
				}
			}
#line 1265 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1265 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1265 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1265 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1265 "tracker-sparql-expression.vala"
					return 0;
#line 11661 "tracker-sparql-expression.c"
				} else {
#line 1265 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1265 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1265 "tracker-sparql-expression.vala"
					return 0;
#line 11669 "tracker-sparql-expression.c"
				}
			}
#line 1266 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with", &_inner_error0_);
#line 1266 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1266 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1266 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1266 "tracker-sparql-expression.vala"
					return 0;
#line 11682 "tracker-sparql-expression.c"
				} else {
#line 1266 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1266 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1266 "tracker-sparql-expression.vala"
					return 0;
#line 11690 "tracker-sparql-expression.c"
				}
			}
#line 1267 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1267 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1267 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1267 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1267 "tracker-sparql-expression.vala"
					return 0;
#line 11703 "tracker-sparql-expression.c"
				} else {
#line 1267 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1267 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1267 "tracker-sparql-expression.vala"
					return 0;
#line 11711 "tracker-sparql-expression.c"
				}
			}
#line 1268 "tracker-sparql-expression.vala"
			result = _result_;
#line 1268 "tracker-sparql-expression.vala"
			return result;
#line 11718 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUBSTR:
#line 11722 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1270 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1270 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1270 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1270 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1270 "tracker-sparql-expression.vala"
					return 0;
#line 11735 "tracker-sparql-expression.c"
				} else {
#line 1270 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1270 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1270 "tracker-sparql-expression.vala"
					return 0;
#line 11743 "tracker-sparql-expression.c"
				}
			}
#line 1271 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1271 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1271 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1271 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1271 "tracker-sparql-expression.vala"
					return 0;
#line 11756 "tracker-sparql-expression.c"
				} else {
#line 1271 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1271 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1271 "tracker-sparql-expression.vala"
					return 0;
#line 11764 "tracker-sparql-expression.c"
				}
			}
#line 1272 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "substring", &_inner_error0_);
#line 1272 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1272 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1272 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1272 "tracker-sparql-expression.vala"
					return 0;
#line 11777 "tracker-sparql-expression.c"
				} else {
#line 1272 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1272 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1272 "tracker-sparql-expression.vala"
					return 0;
#line 11785 "tracker-sparql-expression.c"
				}
			}
#line 1273 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1273 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1273 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1273 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1273 "tracker-sparql-expression.vala"
					return 0;
#line 11798 "tracker-sparql-expression.c"
				} else {
#line 1273 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1273 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1273 "tracker-sparql-expression.vala"
					return 0;
#line 11806 "tracker-sparql-expression.c"
				}
			}
#line 1274 "tracker-sparql-expression.vala"
			result = _result_;
#line 1274 "tracker-sparql-expression.vala"
			return result;
#line 11813 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE:
#line 11817 "tracker-sparql-expression.c"
		{
#line 1276 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1276 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1276 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1276 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1276 "tracker-sparql-expression.vala"
					return 0;
#line 11829 "tracker-sparql-expression.c"
				} else {
#line 1276 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1276 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1276 "tracker-sparql-expression.vala"
					return 0;
#line 11837 "tracker-sparql-expression.c"
				}
			}
#line 1277 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1277 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1277 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1277 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1277 "tracker-sparql-expression.vala"
					return 0;
#line 11850 "tracker-sparql-expression.c"
				} else {
#line 1277 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1277 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1277 "tracker-sparql-expression.vala"
					return 0;
#line 11858 "tracker-sparql-expression.c"
				}
			}
#line 1278 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlStringBefore (");
#line 1279 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 1279 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1279 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1279 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1279 "tracker-sparql-expression.vala"
					return 0;
#line 11873 "tracker-sparql-expression.c"
				} else {
#line 1279 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1279 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1279 "tracker-sparql-expression.vala"
					return 0;
#line 11881 "tracker-sparql-expression.c"
				}
			}
#line 1280 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 1280 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1280 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1280 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1280 "tracker-sparql-expression.vala"
					return 0;
#line 11894 "tracker-sparql-expression.c"
				} else {
#line 1280 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1280 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1280 "tracker-sparql-expression.vala"
					return 0;
#line 11902 "tracker-sparql-expression.c"
				}
			}
#line 1281 "tracker-sparql-expression.vala"
			g_string_append (sql, ",");
#line 1282 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 1282 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1282 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1282 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1282 "tracker-sparql-expression.vala"
					return 0;
#line 11917 "tracker-sparql-expression.c"
				} else {
#line 1282 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1282 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1282 "tracker-sparql-expression.vala"
					return 0;
#line 11925 "tracker-sparql-expression.c"
				}
			}
#line 1283 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1284 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1284 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1284 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1284 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1284 "tracker-sparql-expression.vala"
					return 0;
#line 11940 "tracker-sparql-expression.c"
				} else {
#line 1284 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1284 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1284 "tracker-sparql-expression.vala"
					return 0;
#line 11948 "tracker-sparql-expression.c"
				}
			}
#line 1285 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1285 "tracker-sparql-expression.vala"
			return result;
#line 11955 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRAFTER:
#line 11959 "tracker-sparql-expression.c"
		{
#line 1287 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1287 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1287 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1287 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1287 "tracker-sparql-expression.vala"
					return 0;
#line 11971 "tracker-sparql-expression.c"
				} else {
#line 1287 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1287 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1287 "tracker-sparql-expression.vala"
					return 0;
#line 11979 "tracker-sparql-expression.c"
				}
			}
#line 1288 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1288 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1288 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1288 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1288 "tracker-sparql-expression.vala"
					return 0;
#line 11992 "tracker-sparql-expression.c"
				} else {
#line 1288 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1288 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1288 "tracker-sparql-expression.vala"
					return 0;
#line 12000 "tracker-sparql-expression.c"
				}
			}
#line 1289 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlStringAfter (");
#line 1290 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 1290 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1290 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1290 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1290 "tracker-sparql-expression.vala"
					return 0;
#line 12015 "tracker-sparql-expression.c"
				} else {
#line 1290 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1290 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1290 "tracker-sparql-expression.vala"
					return 0;
#line 12023 "tracker-sparql-expression.c"
				}
			}
#line 1291 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 1291 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1291 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1291 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1291 "tracker-sparql-expression.vala"
					return 0;
#line 12036 "tracker-sparql-expression.c"
				} else {
#line 1291 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1291 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1291 "tracker-sparql-expression.vala"
					return 0;
#line 12044 "tracker-sparql-expression.c"
				}
			}
#line 1292 "tracker-sparql-expression.vala"
			g_string_append (sql, ",");
#line 1293 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 1293 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1293 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1293 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1293 "tracker-sparql-expression.vala"
					return 0;
#line 12059 "tracker-sparql-expression.c"
				} else {
#line 1293 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1293 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1293 "tracker-sparql-expression.vala"
					return 0;
#line 12067 "tracker-sparql-expression.c"
				}
			}
#line 1294 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1295 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1295 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1295 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1295 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1295 "tracker-sparql-expression.vala"
					return 0;
#line 12082 "tracker-sparql-expression.c"
				} else {
#line 1295 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1295 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1295 "tracker-sparql-expression.vala"
					return 0;
#line 12090 "tracker-sparql-expression.c"
				}
			}
#line 1296 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1296 "tracker-sparql-expression.vala"
			return result;
#line 12097 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 12101 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp110_;
#line 1298 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_regex (self, sql, &_inner_error0_);
#line 1298 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1298 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1298 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1298 "tracker-sparql-expression.vala"
					return 0;
#line 12114 "tracker-sparql-expression.c"
				} else {
#line 1298 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1298 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1298 "tracker-sparql-expression.vala"
					return 0;
#line 12122 "tracker-sparql-expression.c"
				}
			}
#line 1299 "tracker-sparql-expression.vala"
			_tmp110_ = self->priv->query;
#line 1299 "tracker-sparql-expression.vala"
			tracker_sparql_query_set_no_cache (_tmp110_, TRUE);
#line 1300 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1300 "tracker-sparql-expression.vala"
			return result;
#line 12133 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 12139 "tracker-sparql-expression.c"
		{
#line 1303 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_exists (self, sql, &_inner_error0_);
#line 1303 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1303 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1303 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1303 "tracker-sparql-expression.vala"
					return 0;
#line 12151 "tracker-sparql-expression.c"
				} else {
#line 1303 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1303 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1303 "tracker-sparql-expression.vala"
					return 0;
#line 12159 "tracker-sparql-expression.c"
				}
			}
#line 1304 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1304 "tracker-sparql-expression.vala"
			return result;
#line 12166 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 12170 "tracker-sparql-expression.c"
		{
#line 1306 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1306 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1306 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1306 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1306 "tracker-sparql-expression.vala"
					return 0;
#line 12182 "tracker-sparql-expression.c"
				} else {
#line 1306 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1306 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1306 "tracker-sparql-expression.vala"
					return 0;
#line 12190 "tracker-sparql-expression.c"
				}
			}
#line 1307 "tracker-sparql-expression.vala"
			g_string_append (sql, "COUNT(");
#line 1308 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1308 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1308 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1308 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1308 "tracker-sparql-expression.vala"
					return 0;
#line 12205 "tracker-sparql-expression.c"
				} else {
#line 1308 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1308 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1308 "tracker-sparql-expression.vala"
					return 0;
#line 12213 "tracker-sparql-expression.c"
				}
			}
#line 1309 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1310 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1310 "tracker-sparql-expression.vala"
			return result;
#line 12222 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 12226 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp111_ = 0;
#line 1312 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1312 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1312 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1312 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1312 "tracker-sparql-expression.vala"
					return 0;
#line 12239 "tracker-sparql-expression.c"
				} else {
#line 1312 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1312 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1312 "tracker-sparql-expression.vala"
					return 0;
#line 12247 "tracker-sparql-expression.c"
				}
			}
#line 1313 "tracker-sparql-expression.vala"
			g_string_append (sql, "SUM(");
#line 1314 "tracker-sparql-expression.vala"
			_tmp111_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1314 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1314 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1314 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1314 "tracker-sparql-expression.vala"
					return 0;
#line 12262 "tracker-sparql-expression.c"
				} else {
#line 1314 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1314 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1314 "tracker-sparql-expression.vala"
					return 0;
#line 12270 "tracker-sparql-expression.c"
				}
			}
#line 1314 "tracker-sparql-expression.vala"
			type = _tmp111_;
#line 1315 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1316 "tracker-sparql-expression.vala"
			result = type;
#line 1316 "tracker-sparql-expression.vala"
			return result;
#line 12281 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 12285 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp112_ = 0;
#line 1318 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1318 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1318 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1318 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1318 "tracker-sparql-expression.vala"
					return 0;
#line 12298 "tracker-sparql-expression.c"
				} else {
#line 1318 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1318 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1318 "tracker-sparql-expression.vala"
					return 0;
#line 12306 "tracker-sparql-expression.c"
				}
			}
#line 1319 "tracker-sparql-expression.vala"
			g_string_append (sql, "AVG(");
#line 1320 "tracker-sparql-expression.vala"
			_tmp112_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1320 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1320 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1320 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1320 "tracker-sparql-expression.vala"
					return 0;
#line 12321 "tracker-sparql-expression.c"
				} else {
#line 1320 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1320 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1320 "tracker-sparql-expression.vala"
					return 0;
#line 12329 "tracker-sparql-expression.c"
				}
			}
#line 1320 "tracker-sparql-expression.vala"
			type = _tmp112_;
#line 1321 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1322 "tracker-sparql-expression.vala"
			result = type;
#line 1322 "tracker-sparql-expression.vala"
			return result;
#line 12340 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 12344 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp113_ = 0;
#line 1324 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1324 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1324 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1324 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1324 "tracker-sparql-expression.vala"
					return 0;
#line 12357 "tracker-sparql-expression.c"
				} else {
#line 1324 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1324 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1324 "tracker-sparql-expression.vala"
					return 0;
#line 12365 "tracker-sparql-expression.c"
				}
			}
#line 1325 "tracker-sparql-expression.vala"
			g_string_append (sql, "MIN(");
#line 1326 "tracker-sparql-expression.vala"
			_tmp113_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1326 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1326 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1326 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1326 "tracker-sparql-expression.vala"
					return 0;
#line 12380 "tracker-sparql-expression.c"
				} else {
#line 1326 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1326 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1326 "tracker-sparql-expression.vala"
					return 0;
#line 12388 "tracker-sparql-expression.c"
				}
			}
#line 1326 "tracker-sparql-expression.vala"
			type = _tmp113_;
#line 1327 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1328 "tracker-sparql-expression.vala"
			result = type;
#line 1328 "tracker-sparql-expression.vala"
			return result;
#line 12399 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 12403 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp114_ = 0;
#line 1330 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1330 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1330 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1330 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1330 "tracker-sparql-expression.vala"
					return 0;
#line 12416 "tracker-sparql-expression.c"
				} else {
#line 1330 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1330 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1330 "tracker-sparql-expression.vala"
					return 0;
#line 12424 "tracker-sparql-expression.c"
				}
			}
#line 1331 "tracker-sparql-expression.vala"
			g_string_append (sql, "MAX(");
#line 1332 "tracker-sparql-expression.vala"
			_tmp114_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1332 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1332 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1332 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1332 "tracker-sparql-expression.vala"
					return 0;
#line 12439 "tracker-sparql-expression.c"
				} else {
#line 1332 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1332 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1332 "tracker-sparql-expression.vala"
					return 0;
#line 12447 "tracker-sparql-expression.c"
				}
			}
#line 1332 "tracker-sparql-expression.vala"
			type = _tmp114_;
#line 1333 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1334 "tracker-sparql-expression.vala"
			result = type;
#line 1334 "tracker-sparql-expression.vala"
			return result;
#line 12458 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ABS:
#line 12462 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp115_ = 0;
#line 1336 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1336 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1336 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1336 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1336 "tracker-sparql-expression.vala"
					return 0;
#line 12475 "tracker-sparql-expression.c"
				} else {
#line 1336 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1336 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1336 "tracker-sparql-expression.vala"
					return 0;
#line 12483 "tracker-sparql-expression.c"
				}
			}
#line 1337 "tracker-sparql-expression.vala"
			g_string_append (sql, "ABS(");
#line 1338 "tracker-sparql-expression.vala"
			_tmp115_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1338 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1338 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1338 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1338 "tracker-sparql-expression.vala"
					return 0;
#line 12498 "tracker-sparql-expression.c"
				} else {
#line 1338 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1338 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1338 "tracker-sparql-expression.vala"
					return 0;
#line 12506 "tracker-sparql-expression.c"
				}
			}
#line 1338 "tracker-sparql-expression.vala"
			type = _tmp115_;
#line 1339 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1340 "tracker-sparql-expression.vala"
			result = type;
#line 1340 "tracker-sparql-expression.vala"
			return result;
#line 12517 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ROUND:
#line 12521 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp116_ = 0;
#line 1342 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1342 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1342 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1342 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1342 "tracker-sparql-expression.vala"
					return 0;
#line 12534 "tracker-sparql-expression.c"
				} else {
#line 1342 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1342 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1342 "tracker-sparql-expression.vala"
					return 0;
#line 12542 "tracker-sparql-expression.c"
				}
			}
#line 1343 "tracker-sparql-expression.vala"
			g_string_append (sql, "ROUND(");
#line 1344 "tracker-sparql-expression.vala"
			_tmp116_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1344 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1344 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1344 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1344 "tracker-sparql-expression.vala"
					return 0;
#line 12557 "tracker-sparql-expression.c"
				} else {
#line 1344 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1344 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1344 "tracker-sparql-expression.vala"
					return 0;
#line 12565 "tracker-sparql-expression.c"
				}
			}
#line 1344 "tracker-sparql-expression.vala"
			type = _tmp116_;
#line 1345 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1346 "tracker-sparql-expression.vala"
			result = type;
#line 1346 "tracker-sparql-expression.vala"
			return result;
#line 12576 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CEIL:
#line 12580 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp117_ = 0;
#line 1348 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1348 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1348 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1348 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1348 "tracker-sparql-expression.vala"
					return 0;
#line 12593 "tracker-sparql-expression.c"
				} else {
#line 1348 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1348 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1348 "tracker-sparql-expression.vala"
					return 0;
#line 12601 "tracker-sparql-expression.c"
				}
			}
#line 1349 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlCeil(");
#line 1350 "tracker-sparql-expression.vala"
			_tmp117_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1350 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1350 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1350 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1350 "tracker-sparql-expression.vala"
					return 0;
#line 12616 "tracker-sparql-expression.c"
				} else {
#line 1350 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1350 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1350 "tracker-sparql-expression.vala"
					return 0;
#line 12624 "tracker-sparql-expression.c"
				}
			}
#line 1350 "tracker-sparql-expression.vala"
			type = _tmp117_;
#line 1351 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1352 "tracker-sparql-expression.vala"
			result = type;
#line 1352 "tracker-sparql-expression.vala"
			return result;
#line 12635 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FLOOR:
#line 12639 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp118_ = 0;
#line 1354 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1354 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1354 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1354 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1354 "tracker-sparql-expression.vala"
					return 0;
#line 12652 "tracker-sparql-expression.c"
				} else {
#line 1354 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1354 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1354 "tracker-sparql-expression.vala"
					return 0;
#line 12660 "tracker-sparql-expression.c"
				}
			}
#line 1355 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlFloor(");
#line 1356 "tracker-sparql-expression.vala"
			_tmp118_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1356 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1356 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1356 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1356 "tracker-sparql-expression.vala"
					return 0;
#line 12675 "tracker-sparql-expression.c"
				} else {
#line 1356 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1356 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1356 "tracker-sparql-expression.vala"
					return 0;
#line 12683 "tracker-sparql-expression.c"
				}
			}
#line 1356 "tracker-sparql-expression.vala"
			type = _tmp118_;
#line 1357 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1358 "tracker-sparql-expression.vala"
			result = type;
#line 1358 "tracker-sparql-expression.vala"
			return result;
#line 12694 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_RAND:
#line 12698 "tracker-sparql-expression.c"
		{
#line 1360 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1360 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1360 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1360 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1360 "tracker-sparql-expression.vala"
					return 0;
#line 12710 "tracker-sparql-expression.c"
				} else {
#line 1360 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1360 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1360 "tracker-sparql-expression.vala"
					return 0;
#line 12718 "tracker-sparql-expression.c"
				}
			}
#line 1361 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1361 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1361 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1361 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1361 "tracker-sparql-expression.vala"
					return 0;
#line 12731 "tracker-sparql-expression.c"
				} else {
#line 1361 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1361 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1361 "tracker-sparql-expression.vala"
					return 0;
#line 12739 "tracker-sparql-expression.c"
				}
			}
#line 1362 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1362 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1362 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1362 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1362 "tracker-sparql-expression.vala"
					return 0;
#line 12752 "tracker-sparql-expression.c"
				} else {
#line 1362 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1362 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1362 "tracker-sparql-expression.vala"
					return 0;
#line 12760 "tracker-sparql-expression.c"
				}
			}
#line 1363 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlRand()");
#line 1364 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 1364 "tracker-sparql-expression.vala"
			return result;
#line 12769 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOW:
#line 12773 "tracker-sparql-expression.c"
		{
#line 1366 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1366 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1366 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1366 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1366 "tracker-sparql-expression.vala"
					return 0;
#line 12785 "tracker-sparql-expression.c"
				} else {
#line 1366 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1366 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1366 "tracker-sparql-expression.vala"
					return 0;
#line 12793 "tracker-sparql-expression.c"
				}
			}
#line 1367 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1367 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1367 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1367 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1367 "tracker-sparql-expression.vala"
					return 0;
#line 12806 "tracker-sparql-expression.c"
				} else {
#line 1367 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1367 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1367 "tracker-sparql-expression.vala"
					return 0;
#line 12814 "tracker-sparql-expression.c"
				}
			}
#line 1368 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1368 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1368 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1368 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1368 "tracker-sparql-expression.vala"
					return 0;
#line 12827 "tracker-sparql-expression.c"
				} else {
#line 1368 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1368 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1368 "tracker-sparql-expression.vala"
					return 0;
#line 12835 "tracker-sparql-expression.c"
				}
			}
#line 1369 "tracker-sparql-expression.vala"
			g_string_append (sql, "strftime('%s', 'now')");
#line 1370 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DATETIME;
#line 1370 "tracker-sparql-expression.vala"
			return result;
#line 12844 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SECONDS:
#line 12848 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1372 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1372 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1372 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1372 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1372 "tracker-sparql-expression.vala"
					return 0;
#line 12861 "tracker-sparql-expression.c"
				} else {
#line 1372 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1372 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1372 "tracker-sparql-expression.vala"
					return 0;
#line 12869 "tracker-sparql-expression.c"
				}
			}
#line 1373 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1373 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1373 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1373 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1373 "tracker-sparql-expression.vala"
					return 0;
#line 12882 "tracker-sparql-expression.c"
				} else {
#line 1373 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1373 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1373 "tracker-sparql-expression.vala"
					return 0;
#line 12890 "tracker-sparql-expression.c"
				}
			}
#line 1374 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime", &_inner_error0_);
#line 1374 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1374 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1374 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1374 "tracker-sparql-expression.vala"
					return 0;
#line 12903 "tracker-sparql-expression.c"
				} else {
#line 1374 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1374 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1374 "tracker-sparql-expression.vala"
					return 0;
#line 12911 "tracker-sparql-expression.c"
				}
			}
#line 1375 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1375 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1375 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1375 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1375 "tracker-sparql-expression.vala"
					return 0;
#line 12924 "tracker-sparql-expression.c"
				} else {
#line 1375 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1375 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1375 "tracker-sparql-expression.vala"
					return 0;
#line 12932 "tracker-sparql-expression.c"
				}
			}
#line 1376 "tracker-sparql-expression.vala"
			result = _result_;
#line 1376 "tracker-sparql-expression.vala"
			return result;
#line 12939 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUTES:
#line 12943 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1378 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1378 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1378 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1378 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1378 "tracker-sparql-expression.vala"
					return 0;
#line 12956 "tracker-sparql-expression.c"
				} else {
#line 1378 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1378 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1378 "tracker-sparql-expression.vala"
					return 0;
#line 12964 "tracker-sparql-expression.c"
				}
			}
#line 1379 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1379 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1379 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1379 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1379 "tracker-sparql-expression.vala"
					return 0;
#line 12977 "tracker-sparql-expression.c"
				} else {
#line 1379 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1379 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1379 "tracker-sparql-expression.vala"
					return 0;
#line 12985 "tracker-sparql-expression.c"
				}
			}
#line 1380 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime", &_inner_error0_);
#line 1380 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1380 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1380 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1380 "tracker-sparql-expression.vala"
					return 0;
#line 12998 "tracker-sparql-expression.c"
				} else {
#line 1380 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1380 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1380 "tracker-sparql-expression.vala"
					return 0;
#line 13006 "tracker-sparql-expression.c"
				}
			}
#line 1381 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1381 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1381 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1381 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1381 "tracker-sparql-expression.vala"
					return 0;
#line 13019 "tracker-sparql-expression.c"
				} else {
#line 1381 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1381 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1381 "tracker-sparql-expression.vala"
					return 0;
#line 13027 "tracker-sparql-expression.c"
				}
			}
#line 1382 "tracker-sparql-expression.vala"
			result = _result_;
#line 1382 "tracker-sparql-expression.vala"
			return result;
#line 13034 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HOURS:
#line 13038 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1384 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1384 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1384 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1384 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1384 "tracker-sparql-expression.vala"
					return 0;
#line 13051 "tracker-sparql-expression.c"
				} else {
#line 1384 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1384 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1384 "tracker-sparql-expression.vala"
					return 0;
#line 13059 "tracker-sparql-expression.c"
				}
			}
#line 1385 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1385 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1385 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1385 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1385 "tracker-sparql-expression.vala"
					return 0;
#line 13072 "tracker-sparql-expression.c"
				} else {
#line 1385 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1385 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1385 "tracker-sparql-expression.vala"
					return 0;
#line 13080 "tracker-sparql-expression.c"
				}
			}
#line 1386 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime", &_inner_error0_);
#line 1386 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1386 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1386 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1386 "tracker-sparql-expression.vala"
					return 0;
#line 13093 "tracker-sparql-expression.c"
				} else {
#line 1386 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1386 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1386 "tracker-sparql-expression.vala"
					return 0;
#line 13101 "tracker-sparql-expression.c"
				}
			}
#line 1387 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1387 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1387 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1387 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1387 "tracker-sparql-expression.vala"
					return 0;
#line 13114 "tracker-sparql-expression.c"
				} else {
#line 1387 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1387 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1387 "tracker-sparql-expression.vala"
					return 0;
#line 13122 "tracker-sparql-expression.c"
				}
			}
#line 1388 "tracker-sparql-expression.vala"
			result = _result_;
#line 1388 "tracker-sparql-expression.vala"
			return result;
#line 13129 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DAY:
#line 13133 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1390 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1390 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1390 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1390 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1390 "tracker-sparql-expression.vala"
					return 0;
#line 13146 "tracker-sparql-expression.c"
				} else {
#line 1390 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1390 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1390 "tracker-sparql-expression.vala"
					return 0;
#line 13154 "tracker-sparql-expression.c"
				}
			}
#line 1391 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1391 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1391 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1391 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1391 "tracker-sparql-expression.vala"
					return 0;
#line 13167 "tracker-sparql-expression.c"
				} else {
#line 1391 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1391 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1391 "tracker-sparql-expression.vala"
					return 0;
#line 13175 "tracker-sparql-expression.c"
				}
			}
#line 1392 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime", &_inner_error0_);
#line 1392 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1392 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1392 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1392 "tracker-sparql-expression.vala"
					return 0;
#line 13188 "tracker-sparql-expression.c"
				} else {
#line 1392 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1392 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1392 "tracker-sparql-expression.vala"
					return 0;
#line 13196 "tracker-sparql-expression.c"
				}
			}
#line 1393 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1393 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1393 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1393 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1393 "tracker-sparql-expression.vala"
					return 0;
#line 13209 "tracker-sparql-expression.c"
				} else {
#line 1393 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1393 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1393 "tracker-sparql-expression.vala"
					return 0;
#line 13217 "tracker-sparql-expression.c"
				}
			}
#line 1394 "tracker-sparql-expression.vala"
			result = _result_;
#line 1394 "tracker-sparql-expression.vala"
			return result;
#line 13224 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MONTH:
#line 13228 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1396 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1396 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1396 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1396 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1396 "tracker-sparql-expression.vala"
					return 0;
#line 13241 "tracker-sparql-expression.c"
				} else {
#line 1396 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1396 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1396 "tracker-sparql-expression.vala"
					return 0;
#line 13249 "tracker-sparql-expression.c"
				}
			}
#line 1397 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1397 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1397 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1397 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1397 "tracker-sparql-expression.vala"
					return 0;
#line 13262 "tracker-sparql-expression.c"
				} else {
#line 1397 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1397 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1397 "tracker-sparql-expression.vala"
					return 0;
#line 13270 "tracker-sparql-expression.c"
				}
			}
#line 1398 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime", &_inner_error0_);
#line 1398 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1398 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1398 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1398 "tracker-sparql-expression.vala"
					return 0;
#line 13283 "tracker-sparql-expression.c"
				} else {
#line 1398 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1398 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1398 "tracker-sparql-expression.vala"
					return 0;
#line 13291 "tracker-sparql-expression.c"
				}
			}
#line 1399 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1399 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1399 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1399 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1399 "tracker-sparql-expression.vala"
					return 0;
#line 13304 "tracker-sparql-expression.c"
				} else {
#line 1399 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1399 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1399 "tracker-sparql-expression.vala"
					return 0;
#line 13312 "tracker-sparql-expression.c"
				}
			}
#line 1400 "tracker-sparql-expression.vala"
			result = _result_;
#line 1400 "tracker-sparql-expression.vala"
			return result;
#line 13319 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_YEAR:
#line 13323 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _result_ = 0;
#line 1402 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1402 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1402 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1402 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1402 "tracker-sparql-expression.vala"
					return 0;
#line 13336 "tracker-sparql-expression.c"
				} else {
#line 1402 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1402 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1402 "tracker-sparql-expression.vala"
					return 0;
#line 13344 "tracker-sparql-expression.c"
				}
			}
#line 1403 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1403 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1403 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1403 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1403 "tracker-sparql-expression.vala"
					return 0;
#line 13357 "tracker-sparql-expression.c"
				} else {
#line 1403 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1403 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1403 "tracker-sparql-expression.vala"
					return 0;
#line 13365 "tracker-sparql-expression.c"
				}
			}
#line 1404 "tracker-sparql-expression.vala"
			_result_ = tracker_sparql_expression_translate_function (self, sql, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime", &_inner_error0_);
#line 1404 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1404 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1404 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1404 "tracker-sparql-expression.vala"
					return 0;
#line 13378 "tracker-sparql-expression.c"
				} else {
#line 1404 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1404 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1404 "tracker-sparql-expression.vala"
					return 0;
#line 13386 "tracker-sparql-expression.c"
				}
			}
#line 1405 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1405 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1405 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1405 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1405 "tracker-sparql-expression.vala"
					return 0;
#line 13399 "tracker-sparql-expression.c"
				} else {
#line 1405 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1405 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1405 "tracker-sparql-expression.vala"
					return 0;
#line 13407 "tracker-sparql-expression.c"
				}
			}
#line 1406 "tracker-sparql-expression.vala"
			result = _result_;
#line 1406 "tracker-sparql-expression.vala"
			return result;
#line 13414 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MD5:
#line 13418 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp119_ = 0;
#line 1408 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1408 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1408 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1408 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1408 "tracker-sparql-expression.vala"
					return 0;
#line 13431 "tracker-sparql-expression.c"
				} else {
#line 1408 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1408 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1408 "tracker-sparql-expression.vala"
					return 0;
#line 13439 "tracker-sparql-expression.c"
				}
			}
#line 1409 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlChecksum(");
#line 1410 "tracker-sparql-expression.vala"
			_tmp119_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1410 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1410 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1410 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1410 "tracker-sparql-expression.vala"
					return 0;
#line 13454 "tracker-sparql-expression.c"
				} else {
#line 1410 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1410 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1410 "tracker-sparql-expression.vala"
					return 0;
#line 13462 "tracker-sparql-expression.c"
				}
			}
#line 1410 "tracker-sparql-expression.vala"
			type = _tmp119_;
#line 1411 "tracker-sparql-expression.vala"
			g_string_append (sql, ", \"md5\")");
#line 1412 "tracker-sparql-expression.vala"
			result = type;
#line 1412 "tracker-sparql-expression.vala"
			return result;
#line 13473 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA1:
#line 13477 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp120_ = 0;
#line 1414 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1414 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1414 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1414 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1414 "tracker-sparql-expression.vala"
					return 0;
#line 13490 "tracker-sparql-expression.c"
				} else {
#line 1414 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1414 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1414 "tracker-sparql-expression.vala"
					return 0;
#line 13498 "tracker-sparql-expression.c"
				}
			}
#line 1415 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlChecksum(");
#line 1416 "tracker-sparql-expression.vala"
			_tmp120_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1416 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1416 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1416 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1416 "tracker-sparql-expression.vala"
					return 0;
#line 13513 "tracker-sparql-expression.c"
				} else {
#line 1416 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1416 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1416 "tracker-sparql-expression.vala"
					return 0;
#line 13521 "tracker-sparql-expression.c"
				}
			}
#line 1416 "tracker-sparql-expression.vala"
			type = _tmp120_;
#line 1417 "tracker-sparql-expression.vala"
			g_string_append (sql, ", \"sha1\")");
#line 1418 "tracker-sparql-expression.vala"
			result = type;
#line 1418 "tracker-sparql-expression.vala"
			return result;
#line 13532 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA256:
#line 13536 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp121_ = 0;
#line 1420 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1420 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1420 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1420 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1420 "tracker-sparql-expression.vala"
					return 0;
#line 13549 "tracker-sparql-expression.c"
				} else {
#line 1420 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1420 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1420 "tracker-sparql-expression.vala"
					return 0;
#line 13557 "tracker-sparql-expression.c"
				}
			}
#line 1421 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlChecksum(");
#line 1422 "tracker-sparql-expression.vala"
			_tmp121_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1422 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1422 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1422 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1422 "tracker-sparql-expression.vala"
					return 0;
#line 13572 "tracker-sparql-expression.c"
				} else {
#line 1422 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1422 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1422 "tracker-sparql-expression.vala"
					return 0;
#line 13580 "tracker-sparql-expression.c"
				}
			}
#line 1422 "tracker-sparql-expression.vala"
			type = _tmp121_;
#line 1423 "tracker-sparql-expression.vala"
			g_string_append (sql, ", \"sha256\")");
#line 1424 "tracker-sparql-expression.vala"
			result = type;
#line 1424 "tracker-sparql-expression.vala"
			return result;
#line 13591 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA512:
#line 13595 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp122_ = 0;
#line 1426 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1426 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1426 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1426 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1426 "tracker-sparql-expression.vala"
					return 0;
#line 13608 "tracker-sparql-expression.c"
				} else {
#line 1426 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1426 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1426 "tracker-sparql-expression.vala"
					return 0;
#line 13616 "tracker-sparql-expression.c"
				}
			}
#line 1427 "tracker-sparql-expression.vala"
			g_string_append (sql, "SparqlChecksum(");
#line 1428 "tracker-sparql-expression.vala"
			_tmp122_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error0_);
#line 1428 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1428 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1428 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1428 "tracker-sparql-expression.vala"
					return 0;
#line 13631 "tracker-sparql-expression.c"
				} else {
#line 1428 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1428 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1428 "tracker-sparql-expression.vala"
					return 0;
#line 13639 "tracker-sparql-expression.c"
				}
			}
#line 1428 "tracker-sparql-expression.vala"
			type = _tmp122_;
#line 1429 "tracker-sparql-expression.vala"
			g_string_append (sql, ", \"sha512\")");
#line 1430 "tracker-sparql-expression.vala"
			result = type;
#line 1430 "tracker-sparql-expression.vala"
			return result;
#line 13650 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 13654 "tracker-sparql-expression.c"
		{
			gchar* _tmp123_ = NULL;
			gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
#line 1432 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1432 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1432 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1432 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1432 "tracker-sparql-expression.vala"
					return 0;
#line 13670 "tracker-sparql-expression.c"
				} else {
#line 1432 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1432 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1432 "tracker-sparql-expression.vala"
					return 0;
#line 13678 "tracker-sparql-expression.c"
				}
			}
#line 1433 "tracker-sparql-expression.vala"
			g_string_append (sql, "GROUP_CONCAT(");
#line 1434 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1434 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1434 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1434 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1434 "tracker-sparql-expression.vala"
					return 0;
#line 13693 "tracker-sparql-expression.c"
				} else {
#line 1434 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1434 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1434 "tracker-sparql-expression.vala"
					return 0;
#line 13701 "tracker-sparql-expression.c"
				}
			}
#line 1435 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error0_);
#line 1435 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1435 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1435 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1435 "tracker-sparql-expression.vala"
					return 0;
#line 13714 "tracker-sparql-expression.c"
				} else {
#line 1435 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1435 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1435 "tracker-sparql-expression.vala"
					return 0;
#line 13722 "tracker-sparql-expression.c"
				}
			}
#line 1436 "tracker-sparql-expression.vala"
			g_string_append (sql, ", ");
#line 1437 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 1437 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1437 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1437 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1437 "tracker-sparql-expression.vala"
					return 0;
#line 13737 "tracker-sparql-expression.c"
				} else {
#line 1437 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1437 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1437 "tracker-sparql-expression.vala"
					return 0;
#line 13745 "tracker-sparql-expression.c"
				}
			}
#line 1438 "tracker-sparql-expression.vala"
			_tmp124_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error0_);
#line 1438 "tracker-sparql-expression.vala"
			_tmp123_ = _tmp124_;
#line 1438 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1438 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1438 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1438 "tracker-sparql-expression.vala"
					return 0;
#line 13760 "tracker-sparql-expression.c"
				} else {
#line 1438 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1438 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1438 "tracker-sparql-expression.vala"
					return 0;
#line 13768 "tracker-sparql-expression.c"
				}
			}
#line 1438 "tracker-sparql-expression.vala"
			_tmp125_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp123_);
#line 1438 "tracker-sparql-expression.vala"
			_tmp126_ = _tmp125_;
#line 1438 "tracker-sparql-expression.vala"
			g_string_append (sql, _tmp126_);
#line 1438 "tracker-sparql-expression.vala"
			_g_free0 (_tmp126_);
#line 1439 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 1440 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1440 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1440 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1440 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1440 "tracker-sparql-expression.vala"
					_g_free0 (_tmp123_);
#line 1440 "tracker-sparql-expression.vala"
					return 0;
#line 13793 "tracker-sparql-expression.c"
				} else {
#line 1440 "tracker-sparql-expression.vala"
					_g_free0 (_tmp123_);
#line 1440 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1440 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1440 "tracker-sparql-expression.vala"
					return 0;
#line 13803 "tracker-sparql-expression.c"
				}
			}
#line 1441 "tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1441 "tracker-sparql-expression.vala"
			_g_free0 (_tmp123_);
#line 1441 "tracker-sparql-expression.vala"
			return result;
#line 13812 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 13816 "tracker-sparql-expression.c"
		{
			gchar* ns = NULL;
			gchar* _tmp127_;
			gchar* uri = NULL;
			TrackerSparqlQuery* _tmp128_;
			const gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			TrackerPropertyType _tmp136_ = 0;
			const gchar* _tmp137_;
#line 1443 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1443 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1443 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1443 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1443 "tracker-sparql-expression.vala"
					return 0;
#line 13841 "tracker-sparql-expression.c"
				} else {
#line 1443 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1443 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1443 "tracker-sparql-expression.vala"
					return 0;
#line 13849 "tracker-sparql-expression.c"
				}
			}
#line 1444 "tracker-sparql-expression.vala"
			_tmp127_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1444 "tracker-sparql-expression.vala"
			ns = _tmp127_;
#line 1445 "tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error0_);
#line 1445 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1445 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1445 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1445 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1445 "tracker-sparql-expression.vala"
					return 0;
#line 13868 "tracker-sparql-expression.c"
				} else {
#line 1445 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1445 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1445 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1445 "tracker-sparql-expression.vala"
					return 0;
#line 13878 "tracker-sparql-expression.c"
				}
			}
#line 1446 "tracker-sparql-expression.vala"
			_tmp128_ = self->priv->query;
#line 1446 "tracker-sparql-expression.vala"
			_tmp129_ = ns;
#line 1446 "tracker-sparql-expression.vala"
			_tmp130_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1446 "tracker-sparql-expression.vala"
			_tmp131_ = _tmp130_;
#line 1446 "tracker-sparql-expression.vala"
			_tmp132_ = string_substring (_tmp131_, (glong) 1, (glong) -1);
#line 1446 "tracker-sparql-expression.vala"
			_tmp133_ = _tmp132_;
#line 1446 "tracker-sparql-expression.vala"
			_tmp134_ = tracker_sparql_query_resolve_prefixed_name (_tmp128_, _tmp129_, _tmp133_, &_inner_error0_);
#line 1446 "tracker-sparql-expression.vala"
			_tmp135_ = _tmp134_;
#line 1446 "tracker-sparql-expression.vala"
			_g_free0 (_tmp133_);
#line 1446 "tracker-sparql-expression.vala"
			_g_free0 (_tmp131_);
#line 1446 "tracker-sparql-expression.vala"
			uri = _tmp135_;
#line 1446 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1446 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1446 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1446 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1446 "tracker-sparql-expression.vala"
					return 0;
#line 13913 "tracker-sparql-expression.c"
				} else {
#line 1446 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1446 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1446 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1446 "tracker-sparql-expression.vala"
					return 0;
#line 13923 "tracker-sparql-expression.c"
				}
			}
#line 1447 "tracker-sparql-expression.vala"
			_tmp137_ = uri;
#line 1447 "tracker-sparql-expression.vala"
			_tmp136_ = tracker_sparql_expression_translate_uri_expression (self, sql, _tmp137_, &_inner_error0_);
#line 1447 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1447 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1447 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1447 "tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1447 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1447 "tracker-sparql-expression.vala"
					return 0;
#line 13942 "tracker-sparql-expression.c"
				} else {
#line 1447 "tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1447 "tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1447 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1447 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1447 "tracker-sparql-expression.vala"
					return 0;
#line 13954 "tracker-sparql-expression.c"
				}
			}
#line 1447 "tracker-sparql-expression.vala"
			result = _tmp136_;
#line 1447 "tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1447 "tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 1447 "tracker-sparql-expression.vala"
			return result;
#line 13965 "tracker-sparql-expression.c"
		}
#line 1049 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 13969 "tracker-sparql-expression.c"
		{
			gchar* uri = NULL;
			TrackerSparqlQuery* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			TrackerPropertyType _tmp145_ = 0;
			const gchar* _tmp146_;
#line 1449 "tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error0_);
#line 1449 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1449 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1449 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1449 "tracker-sparql-expression.vala"
					return 0;
#line 13991 "tracker-sparql-expression.c"
				} else {
#line 1449 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1449 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1449 "tracker-sparql-expression.vala"
					return 0;
#line 13999 "tracker-sparql-expression.c"
				}
			}
#line 1450 "tracker-sparql-expression.vala"
			_tmp138_ = self->priv->query;
#line 1450 "tracker-sparql-expression.vala"
			_tmp139_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1450 "tracker-sparql-expression.vala"
			_tmp140_ = _tmp139_;
#line 1450 "tracker-sparql-expression.vala"
			_tmp141_ = string_substring (_tmp140_, (glong) 1, (glong) -1);
#line 1450 "tracker-sparql-expression.vala"
			_tmp142_ = _tmp141_;
#line 1450 "tracker-sparql-expression.vala"
			_tmp143_ = tracker_sparql_query_resolve_prefixed_name (_tmp138_, "", _tmp142_, &_inner_error0_);
#line 1450 "tracker-sparql-expression.vala"
			_tmp144_ = _tmp143_;
#line 1450 "tracker-sparql-expression.vala"
			_g_free0 (_tmp142_);
#line 1450 "tracker-sparql-expression.vala"
			_g_free0 (_tmp140_);
#line 1450 "tracker-sparql-expression.vala"
			uri = _tmp144_;
#line 1450 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1450 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1450 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1450 "tracker-sparql-expression.vala"
					return 0;
#line 14030 "tracker-sparql-expression.c"
				} else {
#line 1450 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1450 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1450 "tracker-sparql-expression.vala"
					return 0;
#line 14038 "tracker-sparql-expression.c"
				}
			}
#line 1451 "tracker-sparql-expression.vala"
			_tmp146_ = uri;
#line 1451 "tracker-sparql-expression.vala"
			_tmp145_ = tracker_sparql_expression_translate_uri_expression (self, sql, _tmp146_, &_inner_error0_);
#line 1451 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1451 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1451 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1451 "tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1451 "tracker-sparql-expression.vala"
					return 0;
#line 14055 "tracker-sparql-expression.c"
				} else {
#line 1451 "tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1451 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1451 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1451 "tracker-sparql-expression.vala"
					return 0;
#line 14065 "tracker-sparql-expression.c"
				}
			}
#line 1451 "tracker-sparql-expression.vala"
			result = _tmp145_;
#line 1451 "tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1451 "tracker-sparql-expression.vala"
			return result;
#line 14074 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp147_;
#line 1453 "tracker-sparql-expression.vala"
			_tmp147_ = tracker_sparql_expression_get_error (self, "expected primary expression");
#line 1453 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp147_;
#line 1453 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1453 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1453 "tracker-sparql-expression.vala"
				return 0;
#line 14089 "tracker-sparql-expression.c"
			} else {
#line 1453 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1453 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1453 "tracker-sparql-expression.vala"
				return 0;
#line 14097 "tracker-sparql-expression.c"
			}
		}
	}
}

static TrackerPropertyType
tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self,
                                                      GString* sql,
                                                      GError** error)
{
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	TrackerPropertyType _tmp6_ = 0;
	GError* _inner_error0_ = NULL;
#line 1457 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1457 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1458 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error0_);
#line 1458 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1458 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1458 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1458 "tracker-sparql-expression.vala"
			return 0;
#line 14126 "tracker-sparql-expression.c"
		} else {
#line 1458 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1458 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1458 "tracker-sparql-expression.vala"
			return 0;
#line 14134 "tracker-sparql-expression.c"
		}
	}
#line 1458 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 14139 "tracker-sparql-expression.c"
		TrackerPropertyType optype = 0;
		TrackerPropertyType _tmp1_;
#line 1459 "tracker-sparql-expression.vala"
		g_string_append (sql, "NOT (");
#line 1460 "tracker-sparql-expression.vala"
		optype = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 1460 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1460 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1460 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1460 "tracker-sparql-expression.vala"
				return 0;
#line 14154 "tracker-sparql-expression.c"
			} else {
#line 1460 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1460 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1460 "tracker-sparql-expression.vala"
				return 0;
#line 14162 "tracker-sparql-expression.c"
			}
		}
#line 1461 "tracker-sparql-expression.vala"
		g_string_append (sql, ")");
#line 1462 "tracker-sparql-expression.vala"
		_tmp1_ = optype;
#line 1462 "tracker-sparql-expression.vala"
		if (_tmp1_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14171 "tracker-sparql-expression.c"
			GError* _tmp2_;
#line 1463 "tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1463 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp2_;
#line 1463 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1463 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1463 "tracker-sparql-expression.vala"
				return 0;
#line 14183 "tracker-sparql-expression.c"
			} else {
#line 1463 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1463 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1463 "tracker-sparql-expression.vala"
				return 0;
#line 14191 "tracker-sparql-expression.c"
			}
		}
#line 1465 "tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1465 "tracker-sparql-expression.vala"
		return result;
#line 14198 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp3_ = FALSE;
#line 1466 "tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error0_);
#line 1466 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1466 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1466 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1466 "tracker-sparql-expression.vala"
				return 0;
#line 14211 "tracker-sparql-expression.c"
			} else {
#line 1466 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1466 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1466 "tracker-sparql-expression.vala"
				return 0;
#line 14219 "tracker-sparql-expression.c"
			}
		}
#line 1466 "tracker-sparql-expression.vala"
		if (_tmp3_) {
#line 14224 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp4_ = 0;
#line 1467 "tracker-sparql-expression.vala"
			_tmp4_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 1467 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1467 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1467 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1467 "tracker-sparql-expression.vala"
					return 0;
#line 14236 "tracker-sparql-expression.c"
				} else {
#line 1467 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1467 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1467 "tracker-sparql-expression.vala"
					return 0;
#line 14244 "tracker-sparql-expression.c"
				}
			}
#line 1467 "tracker-sparql-expression.vala"
			result = _tmp4_;
#line 1467 "tracker-sparql-expression.vala"
			return result;
#line 14251 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 1468 "tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error0_);
#line 1468 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1468 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1468 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1468 "tracker-sparql-expression.vala"
					return 0;
#line 14264 "tracker-sparql-expression.c"
				} else {
#line 1468 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1468 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1468 "tracker-sparql-expression.vala"
					return 0;
#line 14272 "tracker-sparql-expression.c"
				}
			}
#line 1468 "tracker-sparql-expression.vala"
			if (_tmp5_) {
#line 14277 "tracker-sparql-expression.c"
				TrackerPropertyType optype = 0;
#line 1469 "tracker-sparql-expression.vala"
				g_string_append (sql, "-(");
#line 1470 "tracker-sparql-expression.vala"
				optype = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 1470 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1470 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1470 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1470 "tracker-sparql-expression.vala"
						return 0;
#line 14291 "tracker-sparql-expression.c"
					} else {
#line 1470 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1470 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1470 "tracker-sparql-expression.vala"
						return 0;
#line 14299 "tracker-sparql-expression.c"
					}
				}
#line 1471 "tracker-sparql-expression.vala"
				g_string_append (sql, ")");
#line 1472 "tracker-sparql-expression.vala"
				result = optype;
#line 1472 "tracker-sparql-expression.vala"
				return result;
#line 14308 "tracker-sparql-expression.c"
			}
		}
	}
#line 1474 "tracker-sparql-expression.vala"
	_tmp6_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 1474 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1474 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1474 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1474 "tracker-sparql-expression.vala"
			return 0;
#line 14322 "tracker-sparql-expression.c"
		} else {
#line 1474 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1474 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1474 "tracker-sparql-expression.vala"
			return 0;
#line 14330 "tracker-sparql-expression.c"
		}
	}
#line 1474 "tracker-sparql-expression.vala"
	result = _tmp6_;
#line 1474 "tracker-sparql-expression.vala"
	return result;
#line 14337 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self,
                                                               GString* sql,
                                                               GError** error)
{
	TrackerPropertyType result = 0;
	glong begin = 0L;
	TrackerPropertyType optype = 0;
	GError* _inner_error0_ = NULL;
#line 1477 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1477 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1478 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 1479 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error0_);
#line 1479 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1479 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1479 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1479 "tracker-sparql-expression.vala"
			return 0;
#line 14365 "tracker-sparql-expression.c"
		} else {
#line 1479 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1479 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1479 "tracker-sparql-expression.vala"
			return 0;
#line 14373 "tracker-sparql-expression.c"
		}
	}
#line 1480 "tracker-sparql-expression.vala"
	while (TRUE) {
#line 14378 "tracker-sparql-expression.c"
		gboolean _tmp0_ = FALSE;
#line 1481 "tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error0_);
#line 1481 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1481 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1481 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1481 "tracker-sparql-expression.vala"
				return 0;
#line 14390 "tracker-sparql-expression.c"
			} else {
#line 1481 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1481 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1481 "tracker-sparql-expression.vala"
				return 0;
#line 14398 "tracker-sparql-expression.c"
			}
		}
#line 1481 "tracker-sparql-expression.vala"
		if (_tmp0_) {
#line 14403 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp1_;
			TrackerPropertyType _tmp3_ = 0;
#line 1482 "tracker-sparql-expression.vala"
			_tmp1_ = optype;
#line 1482 "tracker-sparql-expression.vala"
			if (!tracker_sparql_expression_maybe_numeric (self, _tmp1_)) {
#line 14410 "tracker-sparql-expression.c"
				GError* _tmp2_;
#line 1483 "tracker-sparql-expression.vala"
				_tmp2_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1483 "tracker-sparql-expression.vala"
				_inner_error0_ = _tmp2_;
#line 1483 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1483 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1483 "tracker-sparql-expression.vala"
					return 0;
#line 14422 "tracker-sparql-expression.c"
				} else {
#line 1483 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1483 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1483 "tracker-sparql-expression.vala"
					return 0;
#line 14430 "tracker-sparql-expression.c"
				}
			}
#line 1485 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "(");
#line 1486 "tracker-sparql-expression.vala"
			g_string_append (sql, " * ");
#line 1487 "tracker-sparql-expression.vala"
			_tmp3_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error0_);
#line 1487 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1487 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1487 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1487 "tracker-sparql-expression.vala"
					return 0;
#line 14447 "tracker-sparql-expression.c"
				} else {
#line 1487 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1487 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1487 "tracker-sparql-expression.vala"
					return 0;
#line 14455 "tracker-sparql-expression.c"
				}
			}
#line 1487 "tracker-sparql-expression.vala"
			if (!tracker_sparql_expression_maybe_numeric (self, _tmp3_)) {
#line 14460 "tracker-sparql-expression.c"
				GError* _tmp4_;
#line 1488 "tracker-sparql-expression.vala"
				_tmp4_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1488 "tracker-sparql-expression.vala"
				_inner_error0_ = _tmp4_;
#line 1488 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1488 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1488 "tracker-sparql-expression.vala"
					return 0;
#line 14472 "tracker-sparql-expression.c"
				} else {
#line 1488 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1488 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1488 "tracker-sparql-expression.vala"
					return 0;
#line 14480 "tracker-sparql-expression.c"
				}
			}
#line 1490 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 14485 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 1491 "tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error0_);
#line 1491 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1491 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1491 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1491 "tracker-sparql-expression.vala"
					return 0;
#line 14498 "tracker-sparql-expression.c"
				} else {
#line 1491 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1491 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1491 "tracker-sparql-expression.vala"
					return 0;
#line 14506 "tracker-sparql-expression.c"
				}
			}
#line 1491 "tracker-sparql-expression.vala"
			if (_tmp5_) {
#line 14511 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp6_;
				TrackerPropertyType _tmp8_ = 0;
#line 1492 "tracker-sparql-expression.vala"
				_tmp6_ = optype;
#line 1492 "tracker-sparql-expression.vala"
				if (!tracker_sparql_expression_maybe_numeric (self, _tmp6_)) {
#line 14518 "tracker-sparql-expression.c"
					GError* _tmp7_;
#line 1493 "tracker-sparql-expression.vala"
					_tmp7_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1493 "tracker-sparql-expression.vala"
					_inner_error0_ = _tmp7_;
#line 1493 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1493 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1493 "tracker-sparql-expression.vala"
						return 0;
#line 14530 "tracker-sparql-expression.c"
					} else {
#line 1493 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1493 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1493 "tracker-sparql-expression.vala"
						return 0;
#line 14538 "tracker-sparql-expression.c"
					}
				}
#line 1495 "tracker-sparql-expression.vala"
				g_string_insert (sql, (gssize) begin, "(");
#line 1496 "tracker-sparql-expression.vala"
				g_string_append (sql, " / ");
#line 1497 "tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error0_);
#line 1497 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1497 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1497 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1497 "tracker-sparql-expression.vala"
						return 0;
#line 14555 "tracker-sparql-expression.c"
					} else {
#line 1497 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1497 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1497 "tracker-sparql-expression.vala"
						return 0;
#line 14563 "tracker-sparql-expression.c"
					}
				}
#line 1497 "tracker-sparql-expression.vala"
				if (!tracker_sparql_expression_maybe_numeric (self, _tmp8_)) {
#line 14568 "tracker-sparql-expression.c"
					GError* _tmp9_;
#line 1498 "tracker-sparql-expression.vala"
					_tmp9_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1498 "tracker-sparql-expression.vala"
					_inner_error0_ = _tmp9_;
#line 1498 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1498 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1498 "tracker-sparql-expression.vala"
						return 0;
#line 14580 "tracker-sparql-expression.c"
					} else {
#line 1498 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1498 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1498 "tracker-sparql-expression.vala"
						return 0;
#line 14588 "tracker-sparql-expression.c"
					}
				}
#line 1500 "tracker-sparql-expression.vala"
				g_string_append (sql, ")");
#line 14593 "tracker-sparql-expression.c"
			} else {
#line 1502 "tracker-sparql-expression.vala"
				break;
#line 14597 "tracker-sparql-expression.c"
			}
		}
	}
#line 1505 "tracker-sparql-expression.vala"
	result = optype;
#line 1505 "tracker-sparql-expression.vala"
	return result;
#line 14605 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self,
                                                         GString* sql,
                                                         GError** error)
{
	TrackerPropertyType result = 0;
	glong begin = 0L;
	TrackerPropertyType optype = 0;
	GError* _inner_error0_ = NULL;
#line 1508 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1508 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1509 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 1510 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error0_);
#line 1510 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1510 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1510 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1510 "tracker-sparql-expression.vala"
			return 0;
#line 14633 "tracker-sparql-expression.c"
		} else {
#line 1510 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1510 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1510 "tracker-sparql-expression.vala"
			return 0;
#line 14641 "tracker-sparql-expression.c"
		}
	}
#line 1511 "tracker-sparql-expression.vala"
	while (TRUE) {
#line 14646 "tracker-sparql-expression.c"
		gboolean _tmp0_ = FALSE;
#line 1512 "tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error0_);
#line 1512 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1512 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1512 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1512 "tracker-sparql-expression.vala"
				return 0;
#line 14658 "tracker-sparql-expression.c"
			} else {
#line 1512 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1512 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1512 "tracker-sparql-expression.vala"
				return 0;
#line 14666 "tracker-sparql-expression.c"
			}
		}
#line 1512 "tracker-sparql-expression.vala"
		if (_tmp0_) {
#line 14671 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp1_;
			TrackerPropertyType _tmp3_ = 0;
#line 1513 "tracker-sparql-expression.vala"
			_tmp1_ = optype;
#line 1513 "tracker-sparql-expression.vala"
			if (!tracker_sparql_expression_maybe_numeric (self, _tmp1_)) {
#line 14678 "tracker-sparql-expression.c"
				GError* _tmp2_;
#line 1514 "tracker-sparql-expression.vala"
				_tmp2_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1514 "tracker-sparql-expression.vala"
				_inner_error0_ = _tmp2_;
#line 1514 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1514 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1514 "tracker-sparql-expression.vala"
					return 0;
#line 14690 "tracker-sparql-expression.c"
				} else {
#line 1514 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1514 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1514 "tracker-sparql-expression.vala"
					return 0;
#line 14698 "tracker-sparql-expression.c"
				}
			}
#line 1516 "tracker-sparql-expression.vala"
			g_string_insert (sql, (gssize) begin, "(");
#line 1517 "tracker-sparql-expression.vala"
			g_string_append (sql, " + ");
#line 1518 "tracker-sparql-expression.vala"
			_tmp3_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error0_);
#line 1518 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1518 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1518 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1518 "tracker-sparql-expression.vala"
					return 0;
#line 14715 "tracker-sparql-expression.c"
				} else {
#line 1518 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1518 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1518 "tracker-sparql-expression.vala"
					return 0;
#line 14723 "tracker-sparql-expression.c"
				}
			}
#line 1518 "tracker-sparql-expression.vala"
			if (!tracker_sparql_expression_maybe_numeric (self, _tmp3_)) {
#line 14728 "tracker-sparql-expression.c"
				GError* _tmp4_;
#line 1519 "tracker-sparql-expression.vala"
				_tmp4_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1519 "tracker-sparql-expression.vala"
				_inner_error0_ = _tmp4_;
#line 1519 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1519 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1519 "tracker-sparql-expression.vala"
					return 0;
#line 14740 "tracker-sparql-expression.c"
				} else {
#line 1519 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1519 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1519 "tracker-sparql-expression.vala"
					return 0;
#line 14748 "tracker-sparql-expression.c"
				}
			}
#line 1521 "tracker-sparql-expression.vala"
			g_string_append (sql, ")");
#line 14753 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 1522 "tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error0_);
#line 1522 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1522 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1522 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1522 "tracker-sparql-expression.vala"
					return 0;
#line 14766 "tracker-sparql-expression.c"
				} else {
#line 1522 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1522 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1522 "tracker-sparql-expression.vala"
					return 0;
#line 14774 "tracker-sparql-expression.c"
				}
			}
#line 1522 "tracker-sparql-expression.vala"
			if (_tmp5_) {
#line 14779 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp6_;
				TrackerPropertyType _tmp8_ = 0;
#line 1523 "tracker-sparql-expression.vala"
				_tmp6_ = optype;
#line 1523 "tracker-sparql-expression.vala"
				if (!tracker_sparql_expression_maybe_numeric (self, _tmp6_)) {
#line 14786 "tracker-sparql-expression.c"
					GError* _tmp7_;
#line 1524 "tracker-sparql-expression.vala"
					_tmp7_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1524 "tracker-sparql-expression.vala"
					_inner_error0_ = _tmp7_;
#line 1524 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1524 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1524 "tracker-sparql-expression.vala"
						return 0;
#line 14798 "tracker-sparql-expression.c"
					} else {
#line 1524 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1524 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1524 "tracker-sparql-expression.vala"
						return 0;
#line 14806 "tracker-sparql-expression.c"
					}
				}
#line 1526 "tracker-sparql-expression.vala"
				g_string_insert (sql, (gssize) begin, "(");
#line 1527 "tracker-sparql-expression.vala"
				g_string_append (sql, " - ");
#line 1528 "tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error0_);
#line 1528 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1528 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1528 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1528 "tracker-sparql-expression.vala"
						return 0;
#line 14823 "tracker-sparql-expression.c"
					} else {
#line 1528 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1528 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1528 "tracker-sparql-expression.vala"
						return 0;
#line 14831 "tracker-sparql-expression.c"
					}
				}
#line 1528 "tracker-sparql-expression.vala"
				if (!tracker_sparql_expression_maybe_numeric (self, _tmp8_)) {
#line 14836 "tracker-sparql-expression.c"
					GError* _tmp9_;
#line 1529 "tracker-sparql-expression.vala"
					_tmp9_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1529 "tracker-sparql-expression.vala"
					_inner_error0_ = _tmp9_;
#line 1529 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1529 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1529 "tracker-sparql-expression.vala"
						return 0;
#line 14848 "tracker-sparql-expression.c"
					} else {
#line 1529 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1529 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1529 "tracker-sparql-expression.vala"
						return 0;
#line 14856 "tracker-sparql-expression.c"
					}
				}
#line 1531 "tracker-sparql-expression.vala"
				g_string_append (sql, ")");
#line 14861 "tracker-sparql-expression.c"
			} else {
#line 1533 "tracker-sparql-expression.vala"
				break;
#line 14865 "tracker-sparql-expression.c"
			}
		}
	}
#line 1536 "tracker-sparql-expression.vala"
	result = optype;
#line 1536 "tracker-sparql-expression.vala"
	return result;
#line 14873 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self,
                                                        GString* sql,
                                                        GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
#line 1539 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1539 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1540 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_translate_additive_expression (self, sql, &_inner_error0_);
#line 1540 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1540 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1540 "tracker-sparql-expression.vala"
			return 0;
#line 14898 "tracker-sparql-expression.c"
		} else {
#line 1540 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1540 "tracker-sparql-expression.vala"
			return 0;
#line 14906 "tracker-sparql-expression.c"
		}
	}
#line 1540 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 1540 "tracker-sparql-expression.vala"
	return result;
#line 14913 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self,
                                                         GString* sql,
                                                         glong begin,
                                                         guint n_bindings,
                                                         TrackerPropertyType op1type,
                                                         const gchar* operator,
                                                         GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType op2type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 1543 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1543 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1543 "tracker-sparql-expression.vala"
	g_return_val_if_fail (operator != NULL, 0);
#line 1544 "tracker-sparql-expression.vala"
	g_string_insert (sql, (gssize) begin, "(");
#line 1545 "tracker-sparql-expression.vala"
	g_string_append (sql, operator);
#line 1546 "tracker-sparql-expression.vala"
	op2type = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error0_);
#line 1546 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1546 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1546 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1546 "tracker-sparql-expression.vala"
			return 0;
#line 14950 "tracker-sparql-expression.c"
		} else {
#line 1546 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1546 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1546 "tracker-sparql-expression.vala"
			return 0;
#line 14958 "tracker-sparql-expression.c"
		}
	}
#line 1547 "tracker-sparql-expression.vala"
	g_string_append (sql, ")");
#line 1548 "tracker-sparql-expression.vala"
	if (op1type == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 1548 "tracker-sparql-expression.vala"
		_tmp1_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 14967 "tracker-sparql-expression.c"
	} else {
#line 1548 "tracker-sparql-expression.vala"
		_tmp1_ = FALSE;
#line 14971 "tracker-sparql-expression.c"
	}
#line 1548 "tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 1548 "tracker-sparql-expression.vala"
		_tmp0_ = TRUE;
#line 14977 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 1549 "tracker-sparql-expression.vala"
		if (op1type == TRACKER_PROPERTY_TYPE_STRING) {
#line 1549 "tracker-sparql-expression.vala"
			_tmp2_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
#line 14984 "tracker-sparql-expression.c"
		} else {
#line 1549 "tracker-sparql-expression.vala"
			_tmp2_ = FALSE;
#line 14988 "tracker-sparql-expression.c"
		}
#line 1549 "tracker-sparql-expression.vala"
		_tmp0_ = _tmp2_;
#line 14992 "tracker-sparql-expression.c"
	}
#line 1548 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 14996 "tracker-sparql-expression.c"
		TrackerSparqlQuery* _tmp3_;
		GList* _tmp4_;
#line 1551 "tracker-sparql-expression.vala"
		_tmp3_ = self->priv->query;
#line 1551 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_->bindings;
#line 1551 "tracker-sparql-expression.vala"
		if (g_list_length (_tmp4_) == (n_bindings + 1)) {
#line 15005 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp5_;
			GList* _tmp6_;
			GList* _tmp7_;
			gconstpointer _tmp8_;
#line 1553 "tracker-sparql-expression.vala"
			_tmp5_ = self->priv->query;
#line 1553 "tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_->bindings;
#line 1553 "tracker-sparql-expression.vala"
			_tmp7_ = g_list_last (_tmp6_);
#line 1553 "tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_->data;
#line 1553 "tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp8_))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 15020 "tracker-sparql-expression.c"
		}
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 1555 "tracker-sparql-expression.vala"
		if (op1type == TRACKER_PROPERTY_TYPE_DATE) {
#line 1555 "tracker-sparql-expression.vala"
			_tmp10_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 15029 "tracker-sparql-expression.c"
		} else {
#line 1555 "tracker-sparql-expression.vala"
			_tmp10_ = FALSE;
#line 15033 "tracker-sparql-expression.c"
		}
#line 1555 "tracker-sparql-expression.vala"
		if (_tmp10_) {
#line 1555 "tracker-sparql-expression.vala"
			_tmp9_ = TRUE;
#line 15039 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp11_ = FALSE;
#line 1556 "tracker-sparql-expression.vala"
			if (op1type == TRACKER_PROPERTY_TYPE_STRING) {
#line 1556 "tracker-sparql-expression.vala"
				_tmp11_ = op2type == TRACKER_PROPERTY_TYPE_DATE;
#line 15046 "tracker-sparql-expression.c"
			} else {
#line 1556 "tracker-sparql-expression.vala"
				_tmp11_ = FALSE;
#line 15050 "tracker-sparql-expression.c"
			}
#line 1556 "tracker-sparql-expression.vala"
			_tmp9_ = _tmp11_;
#line 15054 "tracker-sparql-expression.c"
		}
#line 1555 "tracker-sparql-expression.vala"
		if (_tmp9_) {
#line 15058 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp12_;
			GList* _tmp13_;
#line 1558 "tracker-sparql-expression.vala"
			_tmp12_ = self->priv->query;
#line 1558 "tracker-sparql-expression.vala"
			_tmp13_ = _tmp12_->bindings;
#line 1558 "tracker-sparql-expression.vala"
			if (g_list_length (_tmp13_) == (n_bindings + 1)) {
#line 15067 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp14_;
				GList* _tmp15_;
				GList* _tmp16_;
				gconstpointer _tmp17_;
#line 1560 "tracker-sparql-expression.vala"
				_tmp14_ = self->priv->query;
#line 1560 "tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_->bindings;
#line 1560 "tracker-sparql-expression.vala"
				_tmp16_ = g_list_last (_tmp15_);
#line 1560 "tracker-sparql-expression.vala"
				_tmp17_ = _tmp16_->data;
#line 1560 "tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp17_))->data_type = TRACKER_PROPERTY_TYPE_DATE;
#line 15082 "tracker-sparql-expression.c"
			}
		}
	}
#line 1563 "tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1563 "tracker-sparql-expression.vala"
	return result;
#line 15090 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_in (TrackerSparqlExpression* self,
                                        GString* sql,
                                        gboolean not,
                                        GError** error)
{
	TrackerPropertyType result = 0;
	gint in_variable_count = 0;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 1566 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1566 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1568 "tracker-sparql-expression.vala"
	in_variable_count = 0;
#line 1570 "tracker-sparql-expression.vala"
	if (not) {
#line 1571 "tracker-sparql-expression.vala"
		g_string_append (sql, " NOT");
#line 15113 "tracker-sparql-expression.c"
	}
#line 1574 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1574 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1574 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1574 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1574 "tracker-sparql-expression.vala"
			return 0;
#line 15125 "tracker-sparql-expression.c"
		} else {
#line 1574 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1574 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1574 "tracker-sparql-expression.vala"
			return 0;
#line 15133 "tracker-sparql-expression.c"
		}
	}
#line 1575 "tracker-sparql-expression.vala"
	g_string_append (sql, " IN (");
#line 1576 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1576 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1576 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1576 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1576 "tracker-sparql-expression.vala"
			return 0;
#line 15148 "tracker-sparql-expression.c"
		} else {
#line 1576 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1576 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1576 "tracker-sparql-expression.vala"
			return 0;
#line 15156 "tracker-sparql-expression.c"
		}
	}
#line 1576 "tracker-sparql-expression.vala"
	if (!_tmp0_) {
#line 15161 "tracker-sparql-expression.c"
		gint _tmp1_;
#line 1577 "tracker-sparql-expression.vala"
		_tmp1_ = in_variable_count;
#line 1577 "tracker-sparql-expression.vala"
		in_variable_count = _tmp1_ + 1;
#line 1578 "tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 1578 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1578 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1578 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1578 "tracker-sparql-expression.vala"
				return 0;
#line 15177 "tracker-sparql-expression.c"
			} else {
#line 1578 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1578 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1578 "tracker-sparql-expression.vala"
				return 0;
#line 15185 "tracker-sparql-expression.c"
			}
		}
#line 1579 "tracker-sparql-expression.vala"
		while (TRUE) {
#line 15190 "tracker-sparql-expression.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
			gboolean _tmp4_ = FALSE;
#line 1579 "tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error0_);
#line 1579 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1579 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1579 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1579 "tracker-sparql-expression.vala"
					return 0;
#line 15204 "tracker-sparql-expression.c"
				} else {
#line 1579 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1579 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1579 "tracker-sparql-expression.vala"
					return 0;
#line 15212 "tracker-sparql-expression.c"
				}
			}
#line 1579 "tracker-sparql-expression.vala"
			if (!_tmp2_) {
#line 1579 "tracker-sparql-expression.vala"
				break;
#line 15219 "tracker-sparql-expression.c"
			}
#line 1580 "tracker-sparql-expression.vala"
			g_string_append (sql, ", ");
#line 1582 "tracker-sparql-expression.vala"
			_tmp3_ = in_variable_count;
#line 1582 "tracker-sparql-expression.vala"
			in_variable_count = _tmp3_ + 1;
#line 1584 "tracker-sparql-expression.vala"
			if (in_variable_count > TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN) {
#line 15229 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
#line 1584 "tracker-sparql-expression.vala"
				_tmp5_ = self->priv->query;
#line 1584 "tracker-sparql-expression.vala"
				_tmp6_ = tracker_sparql_query_get_no_cache (_tmp5_);
#line 1584 "tracker-sparql-expression.vala"
				_tmp7_ = _tmp6_;
#line 1584 "tracker-sparql-expression.vala"
				_tmp4_ = !_tmp7_;
#line 15241 "tracker-sparql-expression.c"
			} else {
#line 1584 "tracker-sparql-expression.vala"
				_tmp4_ = FALSE;
#line 15245 "tracker-sparql-expression.c"
			}
#line 1584 "tracker-sparql-expression.vala"
			if (_tmp4_) {
#line 15249 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp8_;
#line 1585 "tracker-sparql-expression.vala"
				_tmp8_ = self->priv->query;
#line 1585 "tracker-sparql-expression.vala"
				tracker_sparql_query_set_no_cache (_tmp8_, TRUE);
#line 15255 "tracker-sparql-expression.c"
			}
#line 1588 "tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 1588 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1588 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1588 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1588 "tracker-sparql-expression.vala"
					return 0;
#line 15267 "tracker-sparql-expression.c"
				} else {
#line 1588 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1588 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1588 "tracker-sparql-expression.vala"
					return 0;
#line 15275 "tracker-sparql-expression.c"
				}
			}
		}
#line 1590 "tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1590 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1590 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1590 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1590 "tracker-sparql-expression.vala"
				return 0;
#line 15289 "tracker-sparql-expression.c"
			} else {
#line 1590 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1590 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1590 "tracker-sparql-expression.vala"
				return 0;
#line 15297 "tracker-sparql-expression.c"
			}
		}
	}
#line 1592 "tracker-sparql-expression.vala"
	g_string_append (sql, ")");
#line 1594 "tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1594 "tracker-sparql-expression.vala"
	return result;
#line 15307 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self,
                                                           GString* sql,
                                                           GError** error)
{
	TrackerPropertyType result = 0;
	glong begin = 0L;
	guint n_bindings = 0U;
	TrackerSparqlQuery* _tmp0_;
	GList* _tmp1_;
	TrackerPropertyType optype = 0;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 1597 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1597 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1598 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 1600 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 1600 "tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->bindings;
#line 1600 "tracker-sparql-expression.vala"
	n_bindings = g_list_length (_tmp1_);
#line 1601 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error0_);
#line 1601 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1601 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1601 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1601 "tracker-sparql-expression.vala"
			return 0;
#line 15345 "tracker-sparql-expression.c"
		} else {
#line 1601 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1601 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1601 "tracker-sparql-expression.vala"
			return 0;
#line 15353 "tracker-sparql-expression.c"
		}
	}
#line 1602 "tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error0_);
#line 1602 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1602 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1602 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1602 "tracker-sparql-expression.vala"
			return 0;
#line 15366 "tracker-sparql-expression.c"
		} else {
#line 1602 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1602 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1602 "tracker-sparql-expression.vala"
			return 0;
#line 15374 "tracker-sparql-expression.c"
		}
	}
#line 1602 "tracker-sparql-expression.vala"
	if (_tmp2_) {
#line 15379 "tracker-sparql-expression.c"
		TrackerPropertyType _tmp3_ = 0;
		TrackerPropertyType _tmp4_;
#line 1603 "tracker-sparql-expression.vala"
		_tmp4_ = optype;
#line 1603 "tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, _tmp4_, " >= ", &_inner_error0_);
#line 1603 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1603 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1603 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1603 "tracker-sparql-expression.vala"
				return 0;
#line 15394 "tracker-sparql-expression.c"
			} else {
#line 1603 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1603 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1603 "tracker-sparql-expression.vala"
				return 0;
#line 15402 "tracker-sparql-expression.c"
			}
		}
#line 1603 "tracker-sparql-expression.vala"
		result = _tmp3_;
#line 1603 "tracker-sparql-expression.vala"
		return result;
#line 15409 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp5_ = FALSE;
#line 1604 "tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error0_);
#line 1604 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1604 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1604 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1604 "tracker-sparql-expression.vala"
				return 0;
#line 15422 "tracker-sparql-expression.c"
			} else {
#line 1604 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1604 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1604 "tracker-sparql-expression.vala"
				return 0;
#line 15430 "tracker-sparql-expression.c"
			}
		}
#line 1604 "tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 15435 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_ = 0;
			TrackerPropertyType _tmp7_;
#line 1605 "tracker-sparql-expression.vala"
			_tmp7_ = optype;
#line 1605 "tracker-sparql-expression.vala"
			_tmp6_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, _tmp7_, " = ", &_inner_error0_);
#line 1605 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1605 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1605 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1605 "tracker-sparql-expression.vala"
					return 0;
#line 15450 "tracker-sparql-expression.c"
				} else {
#line 1605 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1605 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1605 "tracker-sparql-expression.vala"
					return 0;
#line 15458 "tracker-sparql-expression.c"
				}
			}
#line 1605 "tracker-sparql-expression.vala"
			result = _tmp6_;
#line 1605 "tracker-sparql-expression.vala"
			return result;
#line 15465 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp8_ = FALSE;
#line 1606 "tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error0_);
#line 1606 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1606 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1606 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1606 "tracker-sparql-expression.vala"
					return 0;
#line 15478 "tracker-sparql-expression.c"
				} else {
#line 1606 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1606 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1606 "tracker-sparql-expression.vala"
					return 0;
#line 15486 "tracker-sparql-expression.c"
				}
			}
#line 1606 "tracker-sparql-expression.vala"
			if (_tmp8_) {
#line 15491 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp9_ = 0;
				TrackerPropertyType _tmp10_;
#line 1607 "tracker-sparql-expression.vala"
				_tmp10_ = optype;
#line 1607 "tracker-sparql-expression.vala"
				_tmp9_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, _tmp10_, " <> ", &_inner_error0_);
#line 1607 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1607 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1607 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1607 "tracker-sparql-expression.vala"
						return 0;
#line 15506 "tracker-sparql-expression.c"
					} else {
#line 1607 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1607 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1607 "tracker-sparql-expression.vala"
						return 0;
#line 15514 "tracker-sparql-expression.c"
					}
				}
#line 1607 "tracker-sparql-expression.vala"
				result = _tmp9_;
#line 1607 "tracker-sparql-expression.vala"
				return result;
#line 15521 "tracker-sparql-expression.c"
			} else {
				gboolean _tmp11_ = FALSE;
#line 1608 "tracker-sparql-expression.vala"
				_tmp11_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error0_);
#line 1608 "tracker-sparql-expression.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1608 "tracker-sparql-expression.vala"
					if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1608 "tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error0_);
#line 1608 "tracker-sparql-expression.vala"
						return 0;
#line 15534 "tracker-sparql-expression.c"
					} else {
#line 1608 "tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1608 "tracker-sparql-expression.vala"
						g_clear_error (&_inner_error0_);
#line 1608 "tracker-sparql-expression.vala"
						return 0;
#line 15542 "tracker-sparql-expression.c"
					}
				}
#line 1608 "tracker-sparql-expression.vala"
				if (_tmp11_) {
#line 15547 "tracker-sparql-expression.c"
					TrackerPropertyType _tmp12_ = 0;
					TrackerPropertyType _tmp13_;
#line 1609 "tracker-sparql-expression.vala"
					_tmp13_ = optype;
#line 1609 "tracker-sparql-expression.vala"
					_tmp12_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, _tmp13_, " < ", &_inner_error0_);
#line 1609 "tracker-sparql-expression.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1609 "tracker-sparql-expression.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1609 "tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error0_);
#line 1609 "tracker-sparql-expression.vala"
							return 0;
#line 15562 "tracker-sparql-expression.c"
						} else {
#line 1609 "tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1609 "tracker-sparql-expression.vala"
							g_clear_error (&_inner_error0_);
#line 1609 "tracker-sparql-expression.vala"
							return 0;
#line 15570 "tracker-sparql-expression.c"
						}
					}
#line 1609 "tracker-sparql-expression.vala"
					result = _tmp12_;
#line 1609 "tracker-sparql-expression.vala"
					return result;
#line 15577 "tracker-sparql-expression.c"
				} else {
					gboolean _tmp14_ = FALSE;
#line 1610 "tracker-sparql-expression.vala"
					_tmp14_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error0_);
#line 1610 "tracker-sparql-expression.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1610 "tracker-sparql-expression.vala"
						if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1610 "tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error0_);
#line 1610 "tracker-sparql-expression.vala"
							return 0;
#line 15590 "tracker-sparql-expression.c"
						} else {
#line 1610 "tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1610 "tracker-sparql-expression.vala"
							g_clear_error (&_inner_error0_);
#line 1610 "tracker-sparql-expression.vala"
							return 0;
#line 15598 "tracker-sparql-expression.c"
						}
					}
#line 1610 "tracker-sparql-expression.vala"
					if (_tmp14_) {
#line 15603 "tracker-sparql-expression.c"
						TrackerPropertyType _tmp15_ = 0;
						TrackerPropertyType _tmp16_;
#line 1611 "tracker-sparql-expression.vala"
						_tmp16_ = optype;
#line 1611 "tracker-sparql-expression.vala"
						_tmp15_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, _tmp16_, " <= ", &_inner_error0_);
#line 1611 "tracker-sparql-expression.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1611 "tracker-sparql-expression.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1611 "tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error0_);
#line 1611 "tracker-sparql-expression.vala"
								return 0;
#line 15618 "tracker-sparql-expression.c"
							} else {
#line 1611 "tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1611 "tracker-sparql-expression.vala"
								g_clear_error (&_inner_error0_);
#line 1611 "tracker-sparql-expression.vala"
								return 0;
#line 15626 "tracker-sparql-expression.c"
							}
						}
#line 1611 "tracker-sparql-expression.vala"
						result = _tmp15_;
#line 1611 "tracker-sparql-expression.vala"
						return result;
#line 15633 "tracker-sparql-expression.c"
					} else {
						gboolean _tmp17_ = FALSE;
#line 1612 "tracker-sparql-expression.vala"
						_tmp17_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error0_);
#line 1612 "tracker-sparql-expression.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1612 "tracker-sparql-expression.vala"
							if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1612 "tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error0_);
#line 1612 "tracker-sparql-expression.vala"
								return 0;
#line 15646 "tracker-sparql-expression.c"
							} else {
#line 1612 "tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1612 "tracker-sparql-expression.vala"
								g_clear_error (&_inner_error0_);
#line 1612 "tracker-sparql-expression.vala"
								return 0;
#line 15654 "tracker-sparql-expression.c"
							}
						}
#line 1612 "tracker-sparql-expression.vala"
						if (_tmp17_) {
#line 15659 "tracker-sparql-expression.c"
							TrackerPropertyType _tmp18_ = 0;
							TrackerPropertyType _tmp19_;
#line 1613 "tracker-sparql-expression.vala"
							_tmp19_ = optype;
#line 1613 "tracker-sparql-expression.vala"
							_tmp18_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, _tmp19_, " > ", &_inner_error0_);
#line 1613 "tracker-sparql-expression.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1613 "tracker-sparql-expression.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1613 "tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error0_);
#line 1613 "tracker-sparql-expression.vala"
									return 0;
#line 15674 "tracker-sparql-expression.c"
								} else {
#line 1613 "tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1613 "tracker-sparql-expression.vala"
									g_clear_error (&_inner_error0_);
#line 1613 "tracker-sparql-expression.vala"
									return 0;
#line 15682 "tracker-sparql-expression.c"
								}
							}
#line 1613 "tracker-sparql-expression.vala"
							result = _tmp18_;
#line 1613 "tracker-sparql-expression.vala"
							return result;
#line 15689 "tracker-sparql-expression.c"
						} else {
							gboolean _tmp20_ = FALSE;
#line 1614 "tracker-sparql-expression.vala"
							_tmp20_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error0_);
#line 1614 "tracker-sparql-expression.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1614 "tracker-sparql-expression.vala"
								if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1614 "tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error0_);
#line 1614 "tracker-sparql-expression.vala"
									return 0;
#line 15702 "tracker-sparql-expression.c"
								} else {
#line 1614 "tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1614 "tracker-sparql-expression.vala"
									g_clear_error (&_inner_error0_);
#line 1614 "tracker-sparql-expression.vala"
									return 0;
#line 15710 "tracker-sparql-expression.c"
								}
							}
#line 1614 "tracker-sparql-expression.vala"
							if (_tmp20_) {
#line 15715 "tracker-sparql-expression.c"
								TrackerPropertyType _tmp21_ = 0;
#line 1615 "tracker-sparql-expression.vala"
								_tmp21_ = tracker_sparql_expression_translate_in (self, sql, FALSE, &_inner_error0_);
#line 1615 "tracker-sparql-expression.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1615 "tracker-sparql-expression.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1615 "tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error0_);
#line 1615 "tracker-sparql-expression.vala"
										return 0;
#line 15727 "tracker-sparql-expression.c"
									} else {
#line 1615 "tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1615 "tracker-sparql-expression.vala"
										g_clear_error (&_inner_error0_);
#line 1615 "tracker-sparql-expression.vala"
										return 0;
#line 15735 "tracker-sparql-expression.c"
									}
								}
#line 1615 "tracker-sparql-expression.vala"
								result = _tmp21_;
#line 1615 "tracker-sparql-expression.vala"
								return result;
#line 15742 "tracker-sparql-expression.c"
							} else {
								gboolean _tmp22_ = FALSE;
#line 1616 "tracker-sparql-expression.vala"
								_tmp22_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error0_);
#line 1616 "tracker-sparql-expression.vala"
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1616 "tracker-sparql-expression.vala"
									if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1616 "tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error0_);
#line 1616 "tracker-sparql-expression.vala"
										return 0;
#line 15755 "tracker-sparql-expression.c"
									} else {
#line 1616 "tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1616 "tracker-sparql-expression.vala"
										g_clear_error (&_inner_error0_);
#line 1616 "tracker-sparql-expression.vala"
										return 0;
#line 15763 "tracker-sparql-expression.c"
									}
								}
#line 1616 "tracker-sparql-expression.vala"
								if (_tmp22_) {
#line 15768 "tracker-sparql-expression.c"
									TrackerPropertyType _tmp23_ = 0;
#line 1617 "tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error0_);
#line 1617 "tracker-sparql-expression.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1617 "tracker-sparql-expression.vala"
										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1617 "tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error0_);
#line 1617 "tracker-sparql-expression.vala"
											return 0;
#line 15780 "tracker-sparql-expression.c"
										} else {
#line 1617 "tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1617 "tracker-sparql-expression.vala"
											g_clear_error (&_inner_error0_);
#line 1617 "tracker-sparql-expression.vala"
											return 0;
#line 15788 "tracker-sparql-expression.c"
										}
									}
#line 1618 "tracker-sparql-expression.vala"
									_tmp23_ = tracker_sparql_expression_translate_in (self, sql, TRUE, &_inner_error0_);
#line 1618 "tracker-sparql-expression.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1618 "tracker-sparql-expression.vala"
										if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1618 "tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error0_);
#line 1618 "tracker-sparql-expression.vala"
											return 0;
#line 15801 "tracker-sparql-expression.c"
										} else {
#line 1618 "tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1618 "tracker-sparql-expression.vala"
											g_clear_error (&_inner_error0_);
#line 1618 "tracker-sparql-expression.vala"
											return 0;
#line 15809 "tracker-sparql-expression.c"
										}
									}
#line 1618 "tracker-sparql-expression.vala"
									result = _tmp23_;
#line 1618 "tracker-sparql-expression.vala"
									return result;
#line 15816 "tracker-sparql-expression.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 1620 "tracker-sparql-expression.vala"
	result = optype;
#line 1620 "tracker-sparql-expression.vala"
	return result;
#line 15829 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self,
                                                   GString* sql,
                                                   GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
#line 1623 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1623 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1624 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_translate_relational_expression (self, sql, &_inner_error0_);
#line 1624 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1624 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1624 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1624 "tracker-sparql-expression.vala"
			return 0;
#line 15854 "tracker-sparql-expression.c"
		} else {
#line 1624 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1624 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1624 "tracker-sparql-expression.vala"
			return 0;
#line 15862 "tracker-sparql-expression.c"
		}
	}
#line 1624 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 1624 "tracker-sparql-expression.vala"
	return result;
#line 15869 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self,
                                                                GString* sql,
                                                                GError** error)
{
	TrackerPropertyType result = 0;
	glong begin = 0L;
	TrackerPropertyType optype = 0;
	GError* _inner_error0_ = NULL;
#line 1627 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1627 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1628 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 1629 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error0_);
#line 1629 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1629 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1629 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1629 "tracker-sparql-expression.vala"
			return 0;
#line 15897 "tracker-sparql-expression.c"
		} else {
#line 1629 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1629 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1629 "tracker-sparql-expression.vala"
			return 0;
#line 15905 "tracker-sparql-expression.c"
		}
	}
#line 1630 "tracker-sparql-expression.vala"
	while (TRUE) {
#line 15910 "tracker-sparql-expression.c"
		gboolean _tmp0_ = FALSE;
		TrackerPropertyType _tmp1_;
		TrackerPropertyType _tmp3_ = 0;
		TrackerPropertyType _tmp4_;
#line 1630 "tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error0_);
#line 1630 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1630 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1630 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1630 "tracker-sparql-expression.vala"
				return 0;
#line 15925 "tracker-sparql-expression.c"
			} else {
#line 1630 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1630 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1630 "tracker-sparql-expression.vala"
				return 0;
#line 15933 "tracker-sparql-expression.c"
			}
		}
#line 1630 "tracker-sparql-expression.vala"
		if (!_tmp0_) {
#line 1630 "tracker-sparql-expression.vala"
			break;
#line 15940 "tracker-sparql-expression.c"
		}
#line 1631 "tracker-sparql-expression.vala"
		_tmp1_ = optype;
#line 1631 "tracker-sparql-expression.vala"
		if (_tmp1_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 15946 "tracker-sparql-expression.c"
			GError* _tmp2_;
#line 1632 "tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1632 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp2_;
#line 1632 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1632 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1632 "tracker-sparql-expression.vala"
				return 0;
#line 15958 "tracker-sparql-expression.c"
			} else {
#line 1632 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1632 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1632 "tracker-sparql-expression.vala"
				return 0;
#line 15966 "tracker-sparql-expression.c"
			}
		}
#line 1634 "tracker-sparql-expression.vala"
		g_string_insert (sql, (gssize) begin, "(");
#line 1635 "tracker-sparql-expression.vala"
		g_string_append (sql, " AND ");
#line 1636 "tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error0_);
#line 1636 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1636 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1636 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1636 "tracker-sparql-expression.vala"
				return 0;
#line 15983 "tracker-sparql-expression.c"
			} else {
#line 1636 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1636 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1636 "tracker-sparql-expression.vala"
				return 0;
#line 15991 "tracker-sparql-expression.c"
			}
		}
#line 1636 "tracker-sparql-expression.vala"
		optype = _tmp3_;
#line 1637 "tracker-sparql-expression.vala"
		g_string_append (sql, ")");
#line 1638 "tracker-sparql-expression.vala"
		_tmp4_ = optype;
#line 1638 "tracker-sparql-expression.vala"
		if (_tmp4_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 16002 "tracker-sparql-expression.c"
			GError* _tmp5_;
#line 1639 "tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1639 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp5_;
#line 1639 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1639 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1639 "tracker-sparql-expression.vala"
				return 0;
#line 16014 "tracker-sparql-expression.c"
			} else {
#line 1639 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1639 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1639 "tracker-sparql-expression.vala"
				return 0;
#line 16022 "tracker-sparql-expression.c"
			}
		}
	}
#line 1642 "tracker-sparql-expression.vala"
	result = optype;
#line 1642 "tracker-sparql-expression.vala"
	return result;
#line 16030 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self,
                                                               GString* sql,
                                                               GError** error)
{
	TrackerPropertyType result = 0;
	glong begin = 0L;
	TrackerPropertyType optype = 0;
	GError* _inner_error0_ = NULL;
#line 1645 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1645 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1646 "tracker-sparql-expression.vala"
	begin = (glong) sql->len;
#line 1647 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error0_);
#line 1647 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1647 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1647 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1647 "tracker-sparql-expression.vala"
			return 0;
#line 16058 "tracker-sparql-expression.c"
		} else {
#line 1647 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1647 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1647 "tracker-sparql-expression.vala"
			return 0;
#line 16066 "tracker-sparql-expression.c"
		}
	}
#line 1648 "tracker-sparql-expression.vala"
	while (TRUE) {
#line 16071 "tracker-sparql-expression.c"
		gboolean _tmp0_ = FALSE;
		TrackerPropertyType _tmp1_;
		TrackerPropertyType _tmp3_ = 0;
		TrackerPropertyType _tmp4_;
#line 1648 "tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error0_);
#line 1648 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1648 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1648 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1648 "tracker-sparql-expression.vala"
				return 0;
#line 16086 "tracker-sparql-expression.c"
			} else {
#line 1648 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1648 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1648 "tracker-sparql-expression.vala"
				return 0;
#line 16094 "tracker-sparql-expression.c"
			}
		}
#line 1648 "tracker-sparql-expression.vala"
		if (!_tmp0_) {
#line 1648 "tracker-sparql-expression.vala"
			break;
#line 16101 "tracker-sparql-expression.c"
		}
#line 1649 "tracker-sparql-expression.vala"
		_tmp1_ = optype;
#line 1649 "tracker-sparql-expression.vala"
		if (_tmp1_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 16107 "tracker-sparql-expression.c"
			GError* _tmp2_;
#line 1650 "tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1650 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp2_;
#line 1650 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1650 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1650 "tracker-sparql-expression.vala"
				return 0;
#line 16119 "tracker-sparql-expression.c"
			} else {
#line 1650 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1650 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1650 "tracker-sparql-expression.vala"
				return 0;
#line 16127 "tracker-sparql-expression.c"
			}
		}
#line 1652 "tracker-sparql-expression.vala"
		g_string_insert (sql, (gssize) begin, "(");
#line 1653 "tracker-sparql-expression.vala"
		g_string_append (sql, " OR ");
#line 1654 "tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error0_);
#line 1654 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1654 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1654 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1654 "tracker-sparql-expression.vala"
				return 0;
#line 16144 "tracker-sparql-expression.c"
			} else {
#line 1654 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1654 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1654 "tracker-sparql-expression.vala"
				return 0;
#line 16152 "tracker-sparql-expression.c"
			}
		}
#line 1654 "tracker-sparql-expression.vala"
		optype = _tmp3_;
#line 1655 "tracker-sparql-expression.vala"
		g_string_append (sql, ")");
#line 1656 "tracker-sparql-expression.vala"
		_tmp4_ = optype;
#line 1656 "tracker-sparql-expression.vala"
		if (_tmp4_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 16163 "tracker-sparql-expression.c"
			GError* _tmp5_;
#line 1657 "tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1657 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp5_;
#line 1657 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1657 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1657 "tracker-sparql-expression.vala"
				return 0;
#line 16175 "tracker-sparql-expression.c"
			} else {
#line 1657 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1657 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1657 "tracker-sparql-expression.vala"
				return 0;
#line 16183 "tracker-sparql-expression.c"
			}
		}
	}
#line 1660 "tracker-sparql-expression.vala"
	result = optype;
#line 1660 "tracker-sparql-expression.vala"
	return result;
#line 16191 "tracker-sparql-expression.c"
}

TrackerPropertyType
tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self,
                                                GString* sql,
                                                GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
#line 1663 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1663 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1664 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_translate_conditional_or_expression (self, sql, &_inner_error0_);
#line 1664 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1664 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1664 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1664 "tracker-sparql-expression.vala"
			return 0;
#line 16216 "tracker-sparql-expression.c"
		} else {
#line 1664 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1664 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1664 "tracker-sparql-expression.vala"
			return 0;
#line 16224 "tracker-sparql-expression.c"
		}
	}
#line 1664 "tracker-sparql-expression.vala"
	result = _tmp0_;
#line 1664 "tracker-sparql-expression.vala"
	return result;
#line 16231 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self,
                                                           GString* sql,
                                                           GError** error)
{
	TrackerPropertyType result = 0;
	TrackerPropertyType optype = 0;
	GError* _inner_error0_ = NULL;
#line 1667 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1667 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1668 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1668 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1668 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1668 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1668 "tracker-sparql-expression.vala"
			return 0;
#line 16256 "tracker-sparql-expression.c"
		} else {
#line 1668 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1668 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1668 "tracker-sparql-expression.vala"
			return 0;
#line 16264 "tracker-sparql-expression.c"
		}
	}
#line 1670 "tracker-sparql-expression.vala"
	if (tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 16269 "tracker-sparql-expression.c"
		TrackerSparqlSelectContext* select_context = NULL;
		TrackerSparqlPattern* _tmp0_;
		TrackerSparqlPattern* _tmp1_;
		TrackerSparqlSelectContext* _tmp2_;
		TrackerSparqlSelectContext* _tmp3_;
		TrackerPropertyType _tmp4_;
#line 1673 "tracker-sparql-expression.vala"
		g_string_append (sql, "(");
#line 1674 "tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_get_pattern (self);
#line 1674 "tracker-sparql-expression.vala"
		_tmp1_ = _tmp0_;
#line 1674 "tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_pattern_translate_select (_tmp1_, sql, TRUE, TRUE, &_inner_error0_);
#line 1674 "tracker-sparql-expression.vala"
		select_context = _tmp2_;
#line 1674 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1674 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1674 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1674 "tracker-sparql-expression.vala"
				return 0;
#line 16294 "tracker-sparql-expression.c"
			} else {
#line 1674 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1674 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1674 "tracker-sparql-expression.vala"
				return 0;
#line 16302 "tracker-sparql-expression.c"
			}
		}
#line 1675 "tracker-sparql-expression.vala"
		g_string_append (sql, ")");
#line 1677 "tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1677 "tracker-sparql-expression.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1677 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1677 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1677 "tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1677 "tracker-sparql-expression.vala"
				return 0;
#line 16319 "tracker-sparql-expression.c"
			} else {
#line 1677 "tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1677 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1677 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1677 "tracker-sparql-expression.vala"
				return 0;
#line 16329 "tracker-sparql-expression.c"
			}
		}
#line 1678 "tracker-sparql-expression.vala"
		_tmp3_ = select_context;
#line 1678 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_->type;
#line 1678 "tracker-sparql-expression.vala"
		result = _tmp4_;
#line 1678 "tracker-sparql-expression.vala"
		_tracker_sparql_context_unref0 (select_context);
#line 1678 "tracker-sparql-expression.vala"
		return result;
#line 16342 "tracker-sparql-expression.c"
	}
#line 1681 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 1681 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1681 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1681 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1681 "tracker-sparql-expression.vala"
			return 0;
#line 16354 "tracker-sparql-expression.c"
		} else {
#line 1681 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1681 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1681 "tracker-sparql-expression.vala"
			return 0;
#line 16362 "tracker-sparql-expression.c"
		}
	}
#line 1682 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1682 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1682 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1682 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1682 "tracker-sparql-expression.vala"
			return 0;
#line 16375 "tracker-sparql-expression.c"
		} else {
#line 1682 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1682 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1682 "tracker-sparql-expression.vala"
			return 0;
#line 16383 "tracker-sparql-expression.c"
		}
	}
#line 1683 "tracker-sparql-expression.vala"
	result = optype;
#line 1683 "tracker-sparql-expression.vala"
	return result;
#line 16390 "tracker-sparql-expression.c"
}

static TrackerPropertyType
tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self,
                                                          GString* sql,
                                                          GError** error)
{
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean is_var = FALSE;
	TrackerPropertyType optype = 0;
	GError* _inner_error0_ = NULL;
#line 1686 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1686 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1687 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error0_);
#line 1687 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1687 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1687 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1687 "tracker-sparql-expression.vala"
			return 0;
#line 16417 "tracker-sparql-expression.c"
		} else {
#line 1687 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1687 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1687 "tracker-sparql-expression.vala"
			return 0;
#line 16425 "tracker-sparql-expression.c"
		}
	}
#line 1688 "tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error0_);
#line 1688 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1688 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1688 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1688 "tracker-sparql-expression.vala"
			return 0;
#line 16438 "tracker-sparql-expression.c"
		} else {
#line 1688 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1688 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1688 "tracker-sparql-expression.vala"
			return 0;
#line 16446 "tracker-sparql-expression.c"
		}
	}
#line 1688 "tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 1689 "tracker-sparql-expression.vala"
		g_string_append (sql, "DISTINCT ");
#line 16453 "tracker-sparql-expression.c"
	}
#line 1692 "tracker-sparql-expression.vala"
	is_var = tracker_sparql_expression_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR;
#line 1693 "tracker-sparql-expression.vala"
	optype = tracker_sparql_expression_translate_expression (self, sql, &_inner_error0_);
#line 1693 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1693 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1693 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1693 "tracker-sparql-expression.vala"
			return 0;
#line 16467 "tracker-sparql-expression.c"
		} else {
#line 1693 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1693 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1693 "tracker-sparql-expression.vala"
			return 0;
#line 16475 "tracker-sparql-expression.c"
		}
	}
#line 1695 "tracker-sparql-expression.vala"
	if (is_var) {
#line 16480 "tracker-sparql-expression.c"
		TrackerSparqlVariable* variable = NULL;
		TrackerSparqlContext* _tmp1_;
		TrackerSparqlContext* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		TrackerSparqlVariable* _tmp7_;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* _tmp9_;
		TrackerSparqlVariable* _tmp10_;
		TrackerSparqlVariableBinding* _tmp11_;
#line 1696 "tracker-sparql-expression.vala"
		_tmp1_ = tracker_sparql_expression_get_context (self);
#line 1696 "tracker-sparql-expression.vala"
		_tmp2_ = _tmp1_;
#line 1696 "tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1696 "tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 1696 "tracker-sparql-expression.vala"
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
#line 1696 "tracker-sparql-expression.vala"
		_tmp6_ = _tmp5_;
#line 1696 "tracker-sparql-expression.vala"
		_tmp7_ = tracker_sparql_context_get_variable (_tmp2_, _tmp6_);
#line 1696 "tracker-sparql-expression.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 1696 "tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 1696 "tracker-sparql-expression.vala"
		_g_free0 (_tmp6_);
#line 1696 "tracker-sparql-expression.vala"
		_g_free0 (_tmp4_);
#line 1696 "tracker-sparql-expression.vala"
		variable = _tmp9_;
#line 1697 "tracker-sparql-expression.vala"
		_tmp10_ = variable;
#line 1697 "tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_->binding;
#line 1697 "tracker-sparql-expression.vala"
		if (_tmp11_ == NULL) {
#line 16523 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GError* _tmp17_;
			GError* _tmp18_;
#line 1698 "tracker-sparql-expression.vala"
			_tmp12_ = variable;
#line 1698 "tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_variable_get_name (_tmp12_);
#line 1698 "tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1698 "tracker-sparql-expression.vala"
			_tmp15_ = g_strdup_printf ("use of undefined variable `%s'", _tmp14_);
#line 1698 "tracker-sparql-expression.vala"
			_tmp16_ = _tmp15_;
#line 1698 "tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_expression_get_error (self, _tmp16_);
#line 1698 "tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 1698 "tracker-sparql-expression.vala"
			_g_free0 (_tmp16_);
#line 1698 "tracker-sparql-expression.vala"
			_inner_error0_ = _tmp18_;
#line 1698 "tracker-sparql-expression.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1698 "tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error0_);
#line 1698 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1698 "tracker-sparql-expression.vala"
				return 0;
#line 16557 "tracker-sparql-expression.c"
			} else {
#line 1698 "tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1698 "tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1698 "tracker-sparql-expression.vala"
				g_clear_error (&_inner_error0_);
#line 1698 "tracker-sparql-expression.vala"
				return 0;
#line 16567 "tracker-sparql-expression.c"
			}
		}
#line 1695 "tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 16572 "tracker-sparql-expression.c"
	}
#line 1702 "tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error0_);
#line 1702 "tracker-sparql-expression.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1702 "tracker-sparql-expression.vala"
		if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1702 "tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error0_);
#line 1702 "tracker-sparql-expression.vala"
			return 0;
#line 16584 "tracker-sparql-expression.c"
		} else {
#line 1702 "tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1702 "tracker-sparql-expression.vala"
			g_clear_error (&_inner_error0_);
#line 1702 "tracker-sparql-expression.vala"
			return 0;
#line 16592 "tracker-sparql-expression.c"
		}
	}
#line 1703 "tracker-sparql-expression.vala"
	result = optype;
#line 1703 "tracker-sparql-expression.vala"
	return result;
#line 16599 "tracker-sparql-expression.c"
}

TrackerPropertyType
tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self,
                                                GString* sql,
                                                GError** error)
{
	TrackerPropertyType result = 0;
	GError* _inner_error0_ = NULL;
#line 1706 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1706 "tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1707 "tracker-sparql-expression.vala"
	switch (tracker_sparql_expression_current (self)) {
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1707 "tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 16643 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp0_ = 0;
#line 1722 "tracker-sparql-expression.vala"
			_tmp0_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error0_);
#line 1722 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1722 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1722 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1722 "tracker-sparql-expression.vala"
					return 0;
#line 16656 "tracker-sparql-expression.c"
				} else {
#line 1722 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1722 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1722 "tracker-sparql-expression.vala"
					return 0;
#line 16664 "tracker-sparql-expression.c"
				}
			}
#line 1722 "tracker-sparql-expression.vala"
			result = _tmp0_;
#line 1722 "tracker-sparql-expression.vala"
			return result;
#line 16671 "tracker-sparql-expression.c"
		}
		default:
		{
			TrackerPropertyType _tmp1_ = 0;
#line 1724 "tracker-sparql-expression.vala"
			_tmp1_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error0_);
#line 1724 "tracker-sparql-expression.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1724 "tracker-sparql-expression.vala"
				if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1724 "tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error0_);
#line 1724 "tracker-sparql-expression.vala"
					return 0;
#line 16686 "tracker-sparql-expression.c"
				} else {
#line 1724 "tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1724 "tracker-sparql-expression.vala"
					g_clear_error (&_inner_error0_);
#line 1724 "tracker-sparql-expression.vala"
					return 0;
#line 16694 "tracker-sparql-expression.c"
				}
			}
#line 1724 "tracker-sparql-expression.vala"
			result = _tmp1_;
#line 1724 "tracker-sparql-expression.vala"
			return result;
#line 16701 "tracker-sparql-expression.c"
		}
	}
}

static TrackerSparqlContext*
tracker_sparql_expression_get_context (TrackerSparqlExpression* self)
{
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 45 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 45 "tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->context;
#line 45 "tracker-sparql-expression.vala"
	result = _tmp1_;
#line 45 "tracker-sparql-expression.vala"
	return result;
#line 16722 "tracker-sparql-expression.c"
}

static TrackerSparqlPattern*
tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self)
{
	TrackerSparqlPattern* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
#line 49 "tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 49 "tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->pattern;
#line 49 "tracker-sparql-expression.vala"
	result = _tmp1_;
#line 49 "tracker-sparql-expression.vala"
	return result;
#line 16741 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass,
                                      gpointer klass_data)
{
#line 20 "tracker-sparql-expression.vala"
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
#line 20 "tracker-sparql-expression.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlExpression_private_offset);
#line 20 "tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
#line 20 "tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
#line 16756 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_instance_init (TrackerSparqlExpression * self,
                                         gpointer klass)
{
#line 20 "tracker-sparql-expression.vala"
	self->priv = tracker_sparql_expression_get_instance_private (self);
#line 16765 "tracker-sparql-expression.c"
}

static void
tracker_sparql_expression_finalize (GObject * obj)
{
	TrackerSparqlExpression * self;
#line 20 "tracker-sparql-expression.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression);
#line 35 "tracker-sparql-expression.vala"
	_g_free0 (self->priv->fts_sql);
#line 37 "tracker-sparql-expression.vala"
	_g_object_unref0 (self->priv->manager);
#line 20 "tracker-sparql-expression.vala"
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
#line 16780 "tracker-sparql-expression.c"
}

GType
tracker_sparql_expression_get_type (void)
{
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		TrackerSparqlExpression_private_offset = g_type_add_instance_private (tracker_sparql_expression_type_id, sizeof (TrackerSparqlExpressionPrivate));
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}

static void
_vala_tracker_sparql_expression_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	TrackerSparqlExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression);
#line 20 "tracker-sparql-expression.vala"
	switch (property_id) {
#line 16807 "tracker-sparql-expression.c"
		default:
#line 20 "tracker-sparql-expression.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "tracker-sparql-expression.vala"
		break;
#line 16813 "tracker-sparql-expression.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

