/* valaccodeparenthesizedexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEPARENTHESIZEDEXPRESSION_H__
#define __VALACCODEPARENTHESIZEDEXPRESSION_H__
typedef struct _ValaCCodeParenthesizedExpression ValaCCodeParenthesizedExpression;
typedef struct _ValaCCodeParenthesizedExpressionClass ValaCCodeParenthesizedExpressionClass;
typedef struct _ValaCCodeParenthesizedExpressionPrivate ValaCCodeParenthesizedExpressionPrivate;

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION (vala_ccode_parenthesized_expression_get_type ())
#define VALA_CCODE_PARENTHESIZED_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION, ValaCCodeParenthesizedExpression))
#define VALA_CCODE_PARENTHESIZED_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION, ValaCCodeParenthesizedExpressionClass))
#define VALA_IS_CCODE_PARENTHESIZED_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION))
#define VALA_IS_CCODE_PARENTHESIZED_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION))
#define VALA_CCODE_PARENTHESIZED_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION, ValaCCodeParenthesizedExpressionClass))


/**
 * Represents a parenthesized expression in the C code.
 */
struct _ValaCCodeParenthesizedExpression {
	ValaCCodeExpression parent;
	ValaCCodeParenthesizedExpressionPrivate * priv;
};
struct _ValaCCodeParenthesizedExpressionClass {
	ValaCCodeExpressionClass parent;
};

ValaCCodeParenthesizedExpression* vala_ccode_parenthesized_expression_new (ValaCCodeExpression* expr);
ValaCCodeExpression* vala_ccode_parenthesized_expression_get_inner (ValaCCodeParenthesizedExpression* self);
void vala_ccode_parenthesized_expression_set_inner (ValaCCodeParenthesizedExpression* self, ValaCCodeExpression* value);
GType vala_ccode_parenthesized_expression_get_type ();

G_END_DECLS

#endif
