/* valacodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacodegenerator.h"
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefunction.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <vala/valaliteral.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valalockable.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodedeclaration.h>
#include <vala/valaarray.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valareport.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valatypeparameter.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valainvokable.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valapointer.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <gobject/valacodegenerator.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valainterfaceregisterfunction.h>

struct _ValaCodeGeneratorPrivate {
	gboolean _memory_management;
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaTypeReference* current_return_type;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_dispose_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeBlock* block;
	GList* temp_vars;
	GList* temp_ref_vars;
	GHashTable* user_marshal_list;
	GHashTable* predefined_marshal_list;
	GHashTable* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	ValaTypeReference* bool_type;
	ValaTypeReference* char_type;
	ValaTypeReference* unichar_type;
	ValaTypeReference* short_type;
	ValaTypeReference* ushort_type;
	ValaTypeReference* int_type;
	ValaTypeReference* uint_type;
	ValaTypeReference* long_type;
	ValaTypeReference* ulong_type;
	ValaTypeReference* int64_type;
	ValaTypeReference* uint64_type;
	ValaTypeReference* string_type;
	ValaTypeReference* float_type;
	ValaTypeReference* double_type;
	ValaDataType* list_type;
	ValaDataType* slist_type;
	ValaTypeReference* mutex_type;
	ValaDataType* type_module_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
};
#define VALA_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorPrivate))
enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY,
	VALA_CODE_GENERATOR_MEMORY_MANAGEMENT
};
static void vala_code_generator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_code_generator_real_visit_flags (ValaCodeVisitor* base, ValaFlags* fl);
static void vala_code_generator_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv);
static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b);
static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st);
static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name);
static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership);
static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type);
static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GList* temp_vars);
static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GList* temp_vars);
static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaStatement* stmt);
static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym);
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr);
static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim);
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface);
static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl);
static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference);
static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl);
static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop);
static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type);
static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface);
static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaCodeNode* node);
static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim);
static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix);
static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig);
static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename);
static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_code_generator_get_define_for_filename (const char* filename);
static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_code_generator_parent_class = NULL;
static void vala_code_generator_dispose (GObject * obj);


ValaCodeGenerator* vala_code_generator_new (gboolean manage_memory)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCodeGenerator * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "memory-management", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, manage_memory), __params_it++);
	self = g_object_newv (VALA_TYPE_CODE_GENERATOR, __params_it - __params, __params);
	return self;
}


/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context)
{
	ValaCodeContext* __temp0;
	ValaSymbol* __temp1;
	ValaTypeReference* __temp2;
	ValaSymbol* __temp3;
	ValaTypeReference* __temp4;
	ValaSymbol* __temp5;
	ValaTypeReference* __temp6;
	ValaSymbol* __temp7;
	ValaTypeReference* __temp8;
	ValaSymbol* __temp9;
	ValaTypeReference* __temp10;
	ValaSymbol* __temp11;
	ValaTypeReference* __temp12;
	ValaSymbol* __temp13;
	ValaTypeReference* __temp14;
	ValaSymbol* __temp15;
	ValaTypeReference* __temp16;
	ValaSymbol* __temp17;
	ValaTypeReference* __temp18;
	ValaSymbol* __temp19;
	ValaTypeReference* __temp20;
	ValaSymbol* __temp21;
	ValaTypeReference* __temp22;
	ValaSymbol* __temp23;
	ValaTypeReference* __temp24;
	ValaSymbol* __temp25;
	ValaTypeReference* __temp26;
	ValaSymbol* __temp27;
	ValaTypeReference* __temp28;
	ValaSymbol* __temp29;
	ValaSymbol* glib_ns;
	ValaDataType* __temp32;
	ValaDataType* __temp31;
	ValaSymbol* __temp30;
	ValaDataType* __temp35;
	ValaDataType* __temp34;
	ValaSymbol* __temp33;
	ValaTypeReference* __temp36;
	ValaSymbol* __temp37;
	ValaDataType* __temp40;
	ValaDataType* __temp39;
	ValaSymbol* __temp38;
	GList* source_files;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	__temp0 = NULL;
	self->priv->context = (__temp0 = g_object_ref (context), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), __temp0);
	vala_code_context_find_header_cycles (context);
	__temp1 = NULL;
	self->priv->root_symbol = (__temp1 = vala_code_context_get_root (context), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp1);
	__temp2 = NULL;
	self->priv->bool_type = (__temp2 = vala_type_reference_new (), (self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL))), __temp2);
	__temp3 = NULL;
	(vala_type_reference_set_data_type (self->priv->bool_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp3 = vala_symbol_lookup (self->priv->root_symbol, "bool"))))), vala_type_reference_get_data_type (self->priv->bool_type));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	__temp4 = NULL;
	self->priv->char_type = (__temp4 = vala_type_reference_new (), (self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL))), __temp4);
	__temp5 = NULL;
	(vala_type_reference_set_data_type (self->priv->char_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp5 = vala_symbol_lookup (self->priv->root_symbol, "char"))))), vala_type_reference_get_data_type (self->priv->char_type));
	(__temp5 == NULL ? NULL : (__temp5 = (g_object_unref (__temp5), NULL)));
	__temp6 = NULL;
	self->priv->unichar_type = (__temp6 = vala_type_reference_new (), (self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL))), __temp6);
	__temp7 = NULL;
	(vala_type_reference_set_data_type (self->priv->unichar_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp7 = vala_symbol_lookup (self->priv->root_symbol, "unichar"))))), vala_type_reference_get_data_type (self->priv->unichar_type));
	(__temp7 == NULL ? NULL : (__temp7 = (g_object_unref (__temp7), NULL)));
	__temp8 = NULL;
	self->priv->short_type = (__temp8 = vala_type_reference_new (), (self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL))), __temp8);
	__temp9 = NULL;
	(vala_type_reference_set_data_type (self->priv->short_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp9 = vala_symbol_lookup (self->priv->root_symbol, "short"))))), vala_type_reference_get_data_type (self->priv->short_type));
	(__temp9 == NULL ? NULL : (__temp9 = (g_object_unref (__temp9), NULL)));
	__temp10 = NULL;
	self->priv->ushort_type = (__temp10 = vala_type_reference_new (), (self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL))), __temp10);
	__temp11 = NULL;
	(vala_type_reference_set_data_type (self->priv->ushort_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp11 = vala_symbol_lookup (self->priv->root_symbol, "ushort"))))), vala_type_reference_get_data_type (self->priv->ushort_type));
	(__temp11 == NULL ? NULL : (__temp11 = (g_object_unref (__temp11), NULL)));
	__temp12 = NULL;
	self->priv->int_type = (__temp12 = vala_type_reference_new (), (self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL))), __temp12);
	__temp13 = NULL;
	(vala_type_reference_set_data_type (self->priv->int_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp13 = vala_symbol_lookup (self->priv->root_symbol, "int"))))), vala_type_reference_get_data_type (self->priv->int_type));
	(__temp13 == NULL ? NULL : (__temp13 = (g_object_unref (__temp13), NULL)));
	__temp14 = NULL;
	self->priv->uint_type = (__temp14 = vala_type_reference_new (), (self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL))), __temp14);
	__temp15 = NULL;
	(vala_type_reference_set_data_type (self->priv->uint_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp15 = vala_symbol_lookup (self->priv->root_symbol, "uint"))))), vala_type_reference_get_data_type (self->priv->uint_type));
	(__temp15 == NULL ? NULL : (__temp15 = (g_object_unref (__temp15), NULL)));
	__temp16 = NULL;
	self->priv->long_type = (__temp16 = vala_type_reference_new (), (self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL))), __temp16);
	__temp17 = NULL;
	(vala_type_reference_set_data_type (self->priv->long_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp17 = vala_symbol_lookup (self->priv->root_symbol, "long"))))), vala_type_reference_get_data_type (self->priv->long_type));
	(__temp17 == NULL ? NULL : (__temp17 = (g_object_unref (__temp17), NULL)));
	__temp18 = NULL;
	self->priv->ulong_type = (__temp18 = vala_type_reference_new (), (self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL))), __temp18);
	__temp19 = NULL;
	(vala_type_reference_set_data_type (self->priv->ulong_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp19 = vala_symbol_lookup (self->priv->root_symbol, "ulong"))))), vala_type_reference_get_data_type (self->priv->ulong_type));
	(__temp19 == NULL ? NULL : (__temp19 = (g_object_unref (__temp19), NULL)));
	__temp20 = NULL;
	self->priv->int64_type = (__temp20 = vala_type_reference_new (), (self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL))), __temp20);
	__temp21 = NULL;
	(vala_type_reference_set_data_type (self->priv->int64_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp21 = vala_symbol_lookup (self->priv->root_symbol, "int64"))))), vala_type_reference_get_data_type (self->priv->int64_type));
	(__temp21 == NULL ? NULL : (__temp21 = (g_object_unref (__temp21), NULL)));
	__temp22 = NULL;
	self->priv->uint64_type = (__temp22 = vala_type_reference_new (), (self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL))), __temp22);
	__temp23 = NULL;
	(vala_type_reference_set_data_type (self->priv->uint64_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp23 = vala_symbol_lookup (self->priv->root_symbol, "uint64"))))), vala_type_reference_get_data_type (self->priv->uint64_type));
	(__temp23 == NULL ? NULL : (__temp23 = (g_object_unref (__temp23), NULL)));
	__temp24 = NULL;
	self->priv->float_type = (__temp24 = vala_type_reference_new (), (self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL))), __temp24);
	__temp25 = NULL;
	(vala_type_reference_set_data_type (self->priv->float_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp25 = vala_symbol_lookup (self->priv->root_symbol, "float"))))), vala_type_reference_get_data_type (self->priv->float_type));
	(__temp25 == NULL ? NULL : (__temp25 = (g_object_unref (__temp25), NULL)));
	__temp26 = NULL;
	self->priv->double_type = (__temp26 = vala_type_reference_new (), (self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL))), __temp26);
	__temp27 = NULL;
	(vala_type_reference_set_data_type (self->priv->double_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp27 = vala_symbol_lookup (self->priv->root_symbol, "double"))))), vala_type_reference_get_data_type (self->priv->double_type));
	(__temp27 == NULL ? NULL : (__temp27 = (g_object_unref (__temp27), NULL)));
	__temp28 = NULL;
	self->priv->string_type = (__temp28 = vala_type_reference_new (), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL))), __temp28);
	__temp29 = NULL;
	(vala_type_reference_set_data_type (self->priv->string_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp29 = vala_symbol_lookup (self->priv->root_symbol, "string"))))), vala_type_reference_get_data_type (self->priv->string_type));
	(__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL)));
	glib_ns = vala_symbol_lookup (self->priv->root_symbol, "GLib");
	__temp32 = NULL;
	__temp31 = NULL;
	__temp30 = NULL;
	self->priv->list_type = (__temp32 = (__temp31 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp30 = vala_symbol_lookup (glib_ns, "List")))), (__temp31 == NULL ? NULL : g_object_ref (__temp31))), (self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL))), __temp32);
	(__temp30 == NULL ? NULL : (__temp30 = (g_object_unref (__temp30), NULL)));
	__temp35 = NULL;
	__temp34 = NULL;
	__temp33 = NULL;
	self->priv->slist_type = (__temp35 = (__temp34 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp33 = vala_symbol_lookup (glib_ns, "SList")))), (__temp34 == NULL ? NULL : g_object_ref (__temp34))), (self->priv->slist_type == NULL ? NULL : (self->priv->slist_type = (g_object_unref (self->priv->slist_type), NULL))), __temp35);
	(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
	__temp36 = NULL;
	self->priv->mutex_type = (__temp36 = vala_type_reference_new (), (self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL))), __temp36);
	__temp37 = NULL;
	(vala_type_reference_set_data_type (self->priv->mutex_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp37 = vala_symbol_lookup (glib_ns, "Mutex"))))), vala_type_reference_get_data_type (self->priv->mutex_type));
	(__temp37 == NULL ? NULL : (__temp37 = (g_object_unref (__temp37), NULL)));
	__temp40 = NULL;
	__temp39 = NULL;
	__temp38 = NULL;
	self->priv->type_module_type = (__temp40 = (__temp39 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp38 = vala_symbol_lookup (glib_ns, "TypeModule")))), (__temp39 == NULL ? NULL : g_object_ref (__temp39))), (self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL))), __temp40);
	(__temp38 == NULL ? NULL : (__temp38 = (g_object_unref (__temp38), NULL)));
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* __temp41;
		__temp41 = NULL;
		self->priv->module_init_fragment = (__temp41 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL))), __temp41);
		{
			GList* __temp44;
			GList* parameter_it;
			__temp44 = NULL;
			__temp44 = vala_invokable_get_parameters (VALA_INVOKABLE (vala_code_context_get_module_init_method (context)));
			for (parameter_it = __temp44; parameter_it != NULL; parameter_it = parameter_it->next) {
				ValaFormalParameter* parameter;
				parameter = parameter_it->data;
				{
					if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->priv->type_module_type) {
						char* __temp43;
						const char* __temp42;
						self->priv->in_plugin = TRUE;
						__temp43 = NULL;
						__temp42 = NULL;
						self->priv->module_init_param_name = (__temp43 = (__temp42 = vala_formal_parameter_get_name (parameter), (__temp42 == NULL ? NULL : g_strdup (__temp42))), (self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL)), __temp43);
						break;
					}
				}
			}
			(__temp44 == NULL ? NULL : (__temp44 = (g_list_free (__temp44), NULL)));
		}
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GList* __temp45;
		GList* file_it;
		__temp45 = NULL;
		__temp45 = source_files;
		for (file_it = __temp45; file_it != NULL; file_it = file_it->next) {
			ValaSourceFile* file;
			file = file_it->data;
			{
				if (!vala_source_file_get_pkg (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
			}
		}
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_list_free (source_files), NULL)));
}


static void vala_code_generator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	vala_code_node_accept_children (VALA_CODE_NODE (ns), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaCodeGenerator * self;
	ValaCCodeEnum* __temp46;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	__temp46 = NULL;
	self->priv->cenum = (__temp46 = vala_ccode_enum_new (vala_data_type_get_cname (VALA_DATA_TYPE (en), FALSE)), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp46);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en))) != NULL) {
		ValaCCodeComment* __temp47;
		__temp47 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp47 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en)))))));
		(__temp47 == NULL ? NULL : (__temp47 = (g_object_unref (__temp47), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev)
{
	ValaCodeGenerator * self;
	char* val;
	char* __temp51;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_enum_value_get_value (ev))) {
		ValaLiteral* __temp48;
		ValaLiteral* lit;
		__temp48 = NULL;
		lit = (__temp48 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_enum_value_get_value (ev)))), (__temp48 == NULL ? NULL : g_object_ref (__temp48)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp50;
			const char* __temp49;
			__temp50 = NULL;
			__temp49 = NULL;
			val = (__temp50 = (__temp49 = vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit))), (__temp49 == NULL ? NULL : g_strdup (__temp49))), (val = (g_free (val), NULL)), __temp50);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	__temp51 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp51 = vala_enum_value_get_cname (ev)), val);
	(__temp51 = (g_free (__temp51), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_flags (ValaCodeVisitor* base, ValaFlags* fl)
{
	ValaCodeGenerator * self;
	ValaCCodeEnum* __temp52;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FLAGS (fl));
	__temp52 = NULL;
	self->priv->cenum = (__temp52 = vala_ccode_enum_new (vala_data_type_get_cname (VALA_DATA_TYPE (fl), FALSE)), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp52);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (fl))) != NULL) {
		ValaCCodeComment* __temp53;
		__temp53 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp53 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (fl)))))));
		(__temp53 == NULL ? NULL : (__temp53 = (g_object_unref (__temp53), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (fl), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv)
{
	ValaCodeGenerator * self;
	char* val;
	char* __temp57;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FLAGS_VALUE (fv));
	val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_flags_value_get_value (fv))) {
		ValaLiteral* __temp54;
		ValaLiteral* lit;
		__temp54 = NULL;
		lit = (__temp54 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_flags_value_get_value (fv)))), (__temp54 == NULL ? NULL : g_object_ref (__temp54)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp56;
			const char* __temp55;
			__temp56 = NULL;
			__temp55 = NULL;
			val = (__temp56 = (__temp55 = vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit))), (__temp55 == NULL ? NULL : g_strdup (__temp55))), (val = (g_free (val), NULL)), __temp56);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	__temp57 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp57 = vala_flags_value_get_cname (fv)), val);
	(__temp57 = (g_free (__temp57), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionDeclarator* cfundecl;
	ValaCCodeTypeDefinition* ctypedef;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	cfundecl = vala_ccode_function_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cb), FALSE));
	{
		GList* __temp58;
		GList* param_it;
		__temp58 = NULL;
		__temp58 = vala_callback_get_parameters (cb);
		for (param_it = __temp58; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
			}
		}
		(__temp58 == NULL ? NULL : (__temp58 = (g_list_free (__temp58), NULL)));
	}
	ctypedef = vala_ccode_type_definition_new (vala_type_reference_get_cname (vala_callback_get_return_type (cb), FALSE, FALSE), VALA_CCODE_DECLARATOR (cfundecl));
	if (VALA_DATA_TYPE (cb)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* __temp60;
		char* __temp59;
		ValaCCodeExpressionStatement* __temp61;
		ValaCCodeFunctionCall* fc;
		ValaCCodeMemberAccess* __temp62;
		ValaCCodeIdentifier* __temp63;
		__temp60 = NULL;
		__temp59 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_priv_struct, (__temp59 = vala_type_reference_get_cname (self->priv->mutex_type, FALSE, FALSE)), (__temp60 = vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m)))));
		(__temp60 = (g_free (__temp60), NULL));
		(__temp59 = (g_free (__temp59), NULL));
		__temp61 = NULL;
		vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m))))), VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (vala_struct_get_default_construction_method ((VALA_STRUCT (vala_type_reference_get_data_type (self->priv->mutex_type))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp61 == NULL ? NULL : (__temp61 = (g_object_unref (__temp61), NULL)));
		fc = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("VALA_FREE_CHECKED")));
		__temp62 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp62 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m)))))));
		(__temp62 == NULL ? NULL : (__temp62 = (g_object_unref (__temp62), NULL)));
		__temp63 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp63 = vala_ccode_identifier_new (vala_data_type_get_free_function (vala_type_reference_get_data_type (self->priv->mutex_type))))));
		(__temp63 == NULL ? NULL : (__temp63 = (g_object_unref (__temp63), NULL)));
		if (self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp64;
			__temp64 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp64 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(__temp64 == NULL ? NULL : (__temp64 = (g_object_unref (__temp64), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c)))))) {
		ValaDataType* __temp65;
		ValaDataType* t;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* __temp68;
		char* __temp67;
		__temp65 = NULL;
		t = (__temp65 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))))), (__temp65 == NULL ? NULL : g_object_ref (__temp65)));
		cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_const_cname (vala_constant_get_type_reference (c)));
		arr = g_strdup ("");
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_constant_get_type_reference (c)))) {
			char* __temp66;
			__temp66 = NULL;
			arr = (__temp66 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), __temp66);
		}
		__temp68 = NULL;
		__temp67 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp68 = vala_ccode_variable_declarator_new_with_initializer (g_strdup_printf ("%s%s", (__temp67 = vala_constant_get_cname (c)), arr), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))))));
		(__temp68 == NULL ? NULL : (__temp68 = (g_object_unref (__temp68), NULL)));
		(__temp67 = (g_free (__temp67), NULL));
		(vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl_));
		if (c->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		} else {
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		}
		(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		(arr = (g_free (arr), NULL));
	}
}


static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	lhs = NULL;
	st = NULL;
	if (f->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		ValaCCodeStruct* __temp70;
		ValaCCodeStruct* __temp69;
		__temp70 = NULL;
		__temp69 = NULL;
		st = (__temp70 = (__temp69 = self->priv->instance_struct, (__temp69 == NULL ? NULL : g_object_ref (__temp69))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp70);
		if (vala_field_get_instance (f)) {
			ValaCCodeExpression* __temp71;
			__temp71 = NULL;
			lhs = (__temp71 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), vala_field_get_cname (f))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp71);
		}
	} else {
		if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_instance (f)) {
				ValaCCodeStruct* __temp73;
				ValaCCodeStruct* __temp72;
				ValaCCodeExpression* __temp74;
				__temp73 = NULL;
				__temp72 = NULL;
				st = (__temp73 = (__temp72 = self->priv->instance_priv_struct, (__temp72 == NULL ? NULL : g_object_ref (__temp72))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp73);
				__temp74 = NULL;
				lhs = (__temp74 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_field_get_cname (f))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp74);
			} else {
				if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))) {
					ValaDataType* __temp75;
					ValaDataType* t;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* var_decl;
					__temp75 = NULL;
					t = (__temp75 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f))))), (__temp75 == NULL ? NULL : g_object_ref (__temp75)));
					cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE));
					var_decl = vala_ccode_variable_declarator_new (vala_field_get_cname (f));
					if (vala_field_get_initializer (f) != NULL) {
						(vala_ccode_variable_declarator_set_initializer (var_decl, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f))))), vala_ccode_variable_declarator_get_initializer (var_decl));
					}
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
					(vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl_));
					vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
					(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
				}
			}
		}
	}
	if (vala_field_get_instance (f)) {
		char* __temp77;
		char* __temp76;
		__temp77 = NULL;
		__temp76 = NULL;
		vala_ccode_struct_add_field (st, (__temp76 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE)), (__temp77 = vala_field_get_cname (f)));
		(__temp77 = (g_free (__temp77), NULL));
		(__temp76 = (g_free (__temp76), NULL));
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f)) {
			ValaArray* __temp78;
			ValaArray* arr;
			/* create fields to store array dimensions*/
			__temp78 = NULL;
			arr = (__temp78 = VALA_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))), (__temp78 == NULL ? NULL : g_object_ref (__temp78)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaTypeReference* len_type;
					char* __temp80;
					char* __temp79;
					len_type = vala_type_reference_new ();
					(vala_type_reference_set_data_type (len_type, vala_type_reference_get_data_type (self->priv->int_type)), vala_type_reference_get_data_type (len_type));
					__temp80 = NULL;
					__temp79 = NULL;
					vala_ccode_struct_add_field (st, (__temp79 = vala_type_reference_get_cname (len_type, FALSE, FALSE)), (__temp80 = vala_code_generator_get_array_length_cname (self, vala_field_get_name (f), dim)));
					(__temp80 = (g_free (__temp80), NULL));
					(__temp79 = (g_free (__temp79), NULL));
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpressionStatement* __temp81;
			__temp81 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp81 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
			(__temp81 == NULL ? NULL : (__temp81 = (g_object_unref (__temp81), NULL)));
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* array_len_lhs;
				GList* sizes;
				ValaExpression* __temp82;
				ValaExpression* size;
				ValaCCodeExpressionStatement* __temp83;
				ma = vala_member_access_new_simple (vala_field_get_name (f), NULL);
				(vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), vala_code_node_get_symbol (VALA_CODE_NODE (f))), vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)));
				array_len_lhs = vala_code_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), 1);
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				__temp82 = NULL;
				size = (__temp82 = VALA_EXPRESSION (sizes->data), (__temp82 == NULL ? NULL : g_object_ref (__temp82)));
				__temp83 = NULL;
				vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp83 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp83 == NULL ? NULL : (__temp83 = (g_object_unref (__temp83), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(array_len_lhs = (g_object_unref (array_len_lhs), NULL));
				(sizes == NULL ? NULL : (sizes = (g_list_free (sizes), NULL)));
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
			}
		}
		if (vala_type_reference_get_takes_ownership (vala_field_get_type_reference (f)) && self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp84;
			__temp84 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp84 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f))))));
			(__temp84 == NULL ? NULL : (__temp84 = (g_object_unref (__temp84), NULL)));
		}
	}
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
}


static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		ValaCCodeFormalParameter* __temp85;
		__temp85 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((__temp85 = vala_ccode_formal_parameter_new (vala_formal_parameter_get_name (p), vala_type_reference_get_cname (vala_formal_parameter_get_type_reference (p), FALSE, !vala_type_reference_get_takes_ownership (vala_formal_parameter_get_type_reference (p))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (p)));
		(__temp85 == NULL ? NULL : (__temp85 = (g_object_unref (__temp85), NULL)));
	}
}


static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaCodeGenerator * self;
	char* __temp86;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
	__temp86 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp86 = vala_property_get_upper_case_cname (prop)), NULL);
	(__temp86 = (g_free (__temp86), NULL));
}


static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaCodeGenerator * self;
	ValaProperty* __temp87;
	ValaProperty* prop;
	ValaTypeReference* __temp91;
	ValaDataType* __temp92;
	ValaDataType* t;
	ValaTypeReference* this_type;
	ValaCCodeFormalParameter* cselfparam;
	ValaCCodeFormalParameter* cvalueparam;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	__temp87 = NULL;
	prop = (__temp87 = VALA_PROPERTY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc))))), (__temp87 == NULL ? NULL : g_object_ref (__temp87)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaTypeReference* __temp89;
		ValaTypeReference* __temp88;
		__temp89 = NULL;
		__temp88 = NULL;
		self->priv->current_return_type = (__temp89 = (__temp88 = vala_property_get_type_reference (prop), (__temp88 == NULL ? NULL : g_object_ref (__temp88))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp89);
	} else {
		ValaTypeReference* __temp90;
		/* void*/
		__temp90 = NULL;
		self->priv->current_return_type = (__temp90 = vala_type_reference_new (), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp90);
	}
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
	__temp91 = NULL;
	self->priv->current_return_type = (__temp91 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp91);
	__temp92 = NULL;
	t = (__temp92 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))))), (__temp92 == NULL ? NULL : g_object_ref (__temp92)));
	this_type = vala_type_reference_new ();
	(vala_type_reference_set_data_type (this_type, t), vala_type_reference_get_data_type (this_type));
	cselfparam = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE));
	cvalueparam = vala_ccode_formal_parameter_new ("value", vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, TRUE));
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeFunction* __temp97;
		ValaCCodeBlock* block;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp94;
			char* __temp93;
			__temp94 = NULL;
			__temp93 = NULL;
			self->priv->function = (__temp94 = vala_ccode_function_new (g_strdup_printf ("%s_get_%s", (__temp93 = vala_data_type_get_lower_case_cname (t, NULL)), vala_property_get_name (prop)), vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp94);
			(__temp93 = (g_free (__temp93), NULL));
		} else {
			ValaCCodeFunction* __temp96;
			char* __temp95;
			__temp96 = NULL;
			__temp95 = NULL;
			self->priv->function = (__temp96 = vala_ccode_function_new (g_strdup_printf ("%s_set_%s", (__temp95 = vala_data_type_get_lower_case_cname (t, NULL)), vala_property_get_name (prop)), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp96);
			(__temp95 = (g_free (__temp95), NULL));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		__temp97 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp97 = vala_ccode_function_copy (self->priv->function))));
		(__temp97 = (g_object_unref (__temp97), NULL));
		block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		(vala_ccode_function_set_block (self->priv->function, block), vala_ccode_function_get_block (self->priv->function));
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeDeclaration* decl;
			ValaCCodeVariableDeclarator* __temp98;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* __temp99;
			ValaCCodeConstant* __temp100;
			ValaCCodeUnaryExpression* __temp101;
			ValaCCodeConstant* __temp102;
			ValaCCodeExpressionStatement* __temp103;
			ValaCCodeReturnStatement* __temp104;
			/* declare temporary variable to save the property value*/
			decl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE));
			__temp98 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp98 = vala_ccode_variable_declarator_new ("value"))));
			(__temp98 == NULL ? NULL : (__temp98 = (g_object_unref (__temp98), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_get")));
			ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
			__temp99 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp99 = vala_ccode_identifier_new ("self"))));
			(__temp99 == NULL ? NULL : (__temp99 = (g_object_unref (__temp99), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			__temp100 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp100 = vala_property_get_canonical_cconstant (prop))));
			(__temp100 = (g_object_unref (__temp100), NULL));
			__temp101 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp101 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("value"))))));
			(__temp101 == NULL ? NULL : (__temp101 = (g_object_unref (__temp101), NULL)));
			__temp102 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp102 = vala_ccode_constant_new ("NULL"))));
			(__temp102 == NULL ? NULL : (__temp102 = (g_object_unref (__temp102), NULL)));
			__temp103 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp103 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp103 == NULL ? NULL : (__temp103 = (g_object_unref (__temp103), NULL)));
			__temp104 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp104 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("value"))))));
			(__temp104 == NULL ? NULL : (__temp104 = (g_object_unref (__temp104), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeFunctionCall* ccall;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* __temp105;
			ValaCCodeConstant* __temp106;
			ValaCCodeIdentifier* __temp107;
			ValaCCodeConstant* __temp108;
			ValaCCodeExpressionStatement* __temp109;
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_set")));
			ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
			__temp105 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp105 = vala_ccode_identifier_new ("self"))));
			(__temp105 == NULL ? NULL : (__temp105 = (g_object_unref (__temp105), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			__temp106 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp106 = vala_property_get_canonical_cconstant (prop))));
			(__temp106 = (g_object_unref (__temp106), NULL));
			__temp107 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp107 = vala_ccode_identifier_new ("value"))));
			(__temp107 == NULL ? NULL : (__temp107 = (g_object_unref (__temp107), NULL)));
			__temp108 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp108 = vala_ccode_constant_new ("NULL"))));
			(__temp108 == NULL ? NULL : (__temp108 = (g_object_unref (__temp108), NULL)));
			__temp109 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp109 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp109 == NULL ? NULL : (__temp109 = (g_object_unref (__temp109), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* prefix;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		prefix = vala_data_type_get_lower_case_cname (t, NULL);
		if (is_virtual) {
			char* __temp110;
			__temp110 = NULL;
			prefix = (__temp110 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp110);
		}
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp111;
			__temp111 = NULL;
			self->priv->function = (__temp111 = vala_ccode_function_new (g_strdup_printf ("%s_get_%s", prefix, vala_property_get_name (prop)), vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp111);
		} else {
			ValaCCodeFunction* __temp112;
			__temp112 = NULL;
			self->priv->function = (__temp112 = vala_ccode_function_new (g_strdup_printf ("%s_set_%s", prefix, vala_property_get_name (prop)), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp112);
		}
		if (is_virtual) {
			(vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_function_get_modifiers (self->priv->function));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!is_virtual) {
			ValaCCodeFunction* __temp113;
			__temp113 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp113 = vala_ccode_function_copy (self->priv->function))));
			(__temp113 = (g_object_unref (__temp113), NULL));
		}
		if (vala_property_accessor_get_body (acc) != NULL) {
			ValaCCodeStatement* __temp114;
			(vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_accessor_get_body (acc))))), vala_ccode_function_get_block (self->priv->function));
			__temp114 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp114 = vala_code_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(__temp114 == NULL ? NULL : (__temp114 = (g_object_unref (__temp114), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(prefix = (g_free (prefix), NULL));
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaCodeGenerator * self;
	ValaClass* __temp115;
	ValaClass* cl;
	ValaCCodeFunction* __temp117;
	char* __temp116;
	ValaCCodeFormalParameter* __temp118;
	ValaCCodeFormalParameter* __temp119;
	ValaCCodeFormalParameter* __temp120;
	ValaCCodeFunction* __temp121;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp122;
	ValaCCodeDeclaration* __temp124;
	char* __temp123;
	ValaCCodeVariableDeclarator* __temp125;
	ValaCCodeDeclaration* __temp126;
	ValaCCodeVariableDeclarator* __temp127;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp128;
	char* __temp129;
	ValaCCodeFunctionCall* __temp130;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* __temp131;
	ValaCCodeFunctionCall* __temp132;
	ValaCCodeIdentifier* __temp133;
	ValaCCodeFunctionCall* __temp134;
	ValaCCodeExpressionStatement* __temp135;
	ValaCCodeFunctionCall* __temp136;
	ValaCCodeIdentifier* __temp137;
	ValaCCodeIdentifier* __temp138;
	ValaCCodeIdentifier* __temp139;
	ValaCCodeExpressionStatement* __temp140;
	ValaCCodeFunctionCall* __temp141;
	ValaCCodeIdentifier* __temp142;
	ValaCCodeDeclaration* __temp144;
	char* __temp143;
	ValaCCodeVariableDeclarator* __temp145;
	ValaCCodeReturnStatement* __temp146;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	__temp115 = NULL;
	cl = (__temp115 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))))), (__temp115 == NULL ? NULL : g_object_ref (__temp115)));
	__temp117 = NULL;
	__temp116 = NULL;
	self->priv->function = (__temp117 = vala_ccode_function_new (g_strdup_printf ("%s_constructor", (__temp116 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "GObject *"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp117);
	(__temp116 = (g_free (__temp116), NULL));
	(vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (self->priv->function));
	__temp118 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp118 = vala_ccode_formal_parameter_new ("type", "GType")));
	(__temp118 == NULL ? NULL : (__temp118 = (g_object_unref (__temp118), NULL)));
	__temp119 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp119 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
	(__temp119 == NULL ? NULL : (__temp119 = (g_object_unref (__temp119), NULL)));
	__temp120 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp120 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
	(__temp120 == NULL ? NULL : (__temp120 = (g_object_unref (__temp120), NULL)));
	__temp121 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp121 = vala_ccode_function_copy (self->priv->function))));
	(__temp121 = (g_object_unref (__temp121), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GObject *");
	__temp122 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp122 = vala_ccode_variable_declarator_new ("obj"))));
	(__temp122 == NULL ? NULL : (__temp122 = (g_object_unref (__temp122), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp124 = NULL;
	__temp123 = NULL;
	cdecl_ = (__temp124 = vala_ccode_declaration_new (g_strdup_printf ("%sClass *", (__temp123 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp124);
	(__temp123 = (g_free (__temp123), NULL));
	__temp125 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp125 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp125 == NULL ? NULL : (__temp125 = (g_object_unref (__temp125), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp126 = NULL;
	cdecl_ = (__temp126 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp126);
	__temp127 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp127 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp127 == NULL ? NULL : (__temp127 = (g_object_unref (__temp127), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek")));
	__temp128 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp128 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")))));
	(__temp128 == NULL ? NULL : (__temp128 = (g_object_unref (__temp128), NULL)));
	__temp129 = NULL;
	__temp130 = NULL;
	ccast = (__temp130 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp129 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp129 = (g_free (__temp129), NULL)), __temp130);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp131 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp131 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp131 == NULL ? NULL : (__temp131 = (g_object_unref (__temp131), NULL)));
	__temp132 = NULL;
	ccall = (__temp132 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp132);
	__temp133 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp133 = vala_ccode_identifier_new ("klass"))));
	(__temp133 == NULL ? NULL : (__temp133 = (g_object_unref (__temp133), NULL)));
	__temp134 = NULL;
	ccast = (__temp134 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp134);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp135 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp135 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp135 == NULL ? NULL : (__temp135 = (g_object_unref (__temp135), NULL)));
	__temp136 = NULL;
	ccall = (__temp136 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), "constructor"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp136);
	__temp137 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp137 = vala_ccode_identifier_new ("type"))));
	(__temp137 == NULL ? NULL : (__temp137 = (g_object_unref (__temp137), NULL)));
	__temp138 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp138 = vala_ccode_identifier_new ("n_construct_properties"))));
	(__temp138 == NULL ? NULL : (__temp138 = (g_object_unref (__temp138), NULL)));
	__temp139 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp139 = vala_ccode_identifier_new ("construct_properties"))));
	(__temp139 == NULL ? NULL : (__temp139 = (g_object_unref (__temp139), NULL)));
	__temp140 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp140 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("obj")), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp140 == NULL ? NULL : (__temp140 = (g_object_unref (__temp140), NULL)));
	__temp141 = NULL;
	ccall = (__temp141 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp141);
	__temp142 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp142 = vala_ccode_identifier_new ("obj"))));
	(__temp142 == NULL ? NULL : (__temp142 = (g_object_unref (__temp142), NULL)));
	__temp144 = NULL;
	__temp143 = NULL;
	cdecl_ = (__temp144 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp143 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp144);
	(__temp143 = (g_free (__temp143), NULL));
	__temp145 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp145 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp145 == NULL ? NULL : (__temp145 = (g_object_unref (__temp145), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c))));
	__temp146 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp146 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("obj"))))));
	(__temp146 == NULL ? NULL : (__temp146 = (g_object_unref (__temp146), NULL)));
	(vala_ccode_function_set_block (self->priv->function, cblock), vala_ccode_function_get_block (self->priv->function));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c))) != NULL) {
		ValaCCodeComment* __temp147;
		__temp147 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp147 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c)))))));
		(__temp147 == NULL ? NULL : (__temp147 = (g_object_unref (__temp147), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp149;
	ValaSymbol* __temp148;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	__temp149 = NULL;
	__temp148 = NULL;
	self->priv->current_symbol = (__temp149 = (__temp148 = vala_code_node_get_symbol (VALA_CODE_NODE (b)), (__temp148 == NULL ? NULL : g_object_ref (__temp148))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp149);
}


static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b)
{
	ValaClass* __temp150;
	ValaClass* cl;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* __temp151;
	ValaCCodeConstant* __temp152;
	ValaCCodeConstant* __temp153;
	ValaCCodeVariableDeclarator* cdecl_;
	char* __temp154;
	ValaCCodeDeclaration* __temp155;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	__temp150 = NULL;
	cl = (__temp150 = VALA_CLASS (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp150 == NULL ? NULL : g_object_ref (__temp150)));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_newv")));
	__temp151 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp151 = vala_ccode_constant_new (vala_data_type_get_type_id (VALA_DATA_TYPE (cl))))));
	(__temp151 == NULL ? NULL : (__temp151 = (g_object_unref (__temp151), NULL)));
	__temp152 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp152 = vala_ccode_constant_new ("__params_it - __params"))));
	(__temp152 == NULL ? NULL : (__temp152 = (g_object_unref (__temp152), NULL)));
	__temp153 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp153 = vala_ccode_constant_new ("__params"))));
	(__temp153 == NULL ? NULL : (__temp153 = (g_object_unref (__temp153), NULL)));
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	(vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall)), vala_ccode_variable_declarator_get_initializer (cdecl_));
	__temp154 = NULL;
	__temp155 = NULL;
	cdeclaration = (__temp155 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp154 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp154 = (g_free (__temp154), NULL)), __temp155);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	GList* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* __temp165;
	ValaSymbol* __temp164;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp156;
		GList* decl_it;
		__temp156 = NULL;
		__temp156 = local_vars;
		for (decl_it = __temp156; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				(vala_symbol_set_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl)), FALSE), vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))));
			}
		}
	}
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	{
		GList* __temp160;
		GList* stmt_it;
		__temp160 = NULL;
		__temp160 = vala_block_get_statements (b);
		for (stmt_it = __temp160; stmt_it != NULL; stmt_it = stmt_it->next) {
			ValaStatement* stmt;
			stmt = stmt_it->data;
			{
				ValaSourceReference* __temp157;
				ValaSourceReference* src;
				__temp157 = NULL;
				src = (__temp157 = vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), (__temp157 == NULL ? NULL : g_object_ref (__temp157)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* __temp158;
					__temp158 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp158 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(__temp158 == NULL ? NULL : (__temp158 = (g_object_unref (__temp158), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))) {
					{
						GList* __temp159;
						GList* cstmt_it;
						__temp159 = NULL;
						__temp159 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))));
						for (cstmt_it = __temp159; cstmt_it != NULL; cstmt_it = cstmt_it->next) {
							ValaCCodeStatement* cstmt;
							cstmt = cstmt_it->data;
							{
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
							}
						}
						(__temp159 == NULL ? NULL : (__temp159 = (g_list_free (__temp159), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))));
				}
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(__temp160 == NULL ? NULL : (__temp160 = (g_list_free (__temp160), NULL)));
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GList* __temp163;
			GList* decl_it;
			__temp163 = NULL;
			__temp163 = local_vars;
			for (decl_it = __temp163; decl_it != NULL; decl_it = decl_it->next) {
				ValaVariableDeclarator* decl;
				decl = decl_it->data;
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaCCodeExpressionStatement* __temp162;
						ValaCCodeIdentifier* __temp161;
						__temp162 = NULL;
						__temp161 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp162 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp161 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))), vala_variable_declarator_get_type_reference (decl))))));
						(__temp162 == NULL ? NULL : (__temp162 = (g_object_unref (__temp162), NULL)));
						(__temp161 == NULL ? NULL : (__temp161 = (g_object_unref (__temp161), NULL)));
					}
				}
			}
		}
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (b)));
	__temp165 = NULL;
	__temp164 = NULL;
	self->priv->current_symbol = (__temp165 = (__temp164 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp164 == NULL ? NULL : g_object_ref (__temp164))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp165);
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeEmptyStatement* __temp166;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EMPTY_STATEMENT (stmt));
	__temp166 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp166 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp166 == NULL ? NULL : (__temp166 = (g_object_unref (__temp166), NULL)));
}


static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_STRUCT (st), FALSE);
	{
		GList* __temp168;
		GList* f_it;
		__temp168 = NULL;
		__temp168 = vala_struct_get_fields (st);
		for (f_it = __temp168; f_it != NULL; f_it = f_it->next) {
			ValaField* f;
			f = f_it->data;
			{
				if (vala_field_get_instance (f)) {
					return TRUE;
				}
			}
		}
		(__temp168 == NULL ? NULL : (__temp168 = (g_list_free (__temp168), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	GList* __temp184;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (stmt));
	/* split declaration statement as var declarators
	 * might have different types */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GList* __temp182;
		GList* decl_it;
		__temp182 = NULL;
		__temp182 = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		for (decl_it = __temp182; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeDeclaration* cdecl_;
				cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))));
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				/* try to initialize uninitialized variables */
				if (vala_variable_declarator_get_initializer (decl) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
						ValaCCodeConstant* __temp170;
						__temp170 = NULL;
						(vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((__temp170 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl))))));
						(__temp170 == NULL ? NULL : (__temp170 = (g_object_unref (__temp170), NULL)));
					} else {
						char* __temp171;
						gboolean __temp172;
						__temp171 = NULL;
						if ((__temp172 = (__temp171 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) != NULL, (__temp171 = (g_free (__temp171), NULL)), __temp172)) {
							ValaCCodeConstant* __temp173;
							__temp173 = NULL;
							(vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((__temp173 = vala_ccode_constant_new (vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))))), vala_ccode_variable_declarator_get_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl))))));
							(__temp173 == NULL ? NULL : (__temp173 = (g_object_unref (__temp173), NULL)));
						} else {
							if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_code_generator_struct_has_instance_fields (self, VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))) {
								ValaStruct* __temp174;
								ValaStruct* st;
								ValaCCodeFunctionCall* czero;
								ValaCCodeUnaryExpression* __temp175;
								ValaCCodeConstant* __temp176;
								ValaCCodeIdentifier* __temp178;
								char* __temp177;
								ValaCCodeExpressionStatement* __temp179;
								__temp174 = NULL;
								st = (__temp174 = VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp174 == NULL ? NULL : g_object_ref (__temp174)));
								/* memset needs string.h */
								self->priv->string_h_needed = TRUE;
								czero = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("memset")));
								__temp175 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp175 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))))));
								(__temp175 == NULL ? NULL : (__temp175 = (g_object_unref (__temp175), NULL)));
								__temp176 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp176 = vala_ccode_constant_new ("0"))));
								(__temp176 == NULL ? NULL : (__temp176 = (g_object_unref (__temp176), NULL)));
								__temp178 = NULL;
								__temp177 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp178 = vala_ccode_identifier_new (g_strdup_printf ("sizeof (%s)", (__temp177 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, FALSE)))))));
								(__temp178 == NULL ? NULL : (__temp178 = (g_object_unref (__temp178), NULL)));
								(__temp177 = (g_free (__temp177), NULL));
								__temp179 = NULL;
								vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp179 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(__temp179 == NULL ? NULL : (__temp179 = (g_object_unref (__temp179), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							} else {
								char* __temp181;
								char* __temp180;
								__temp181 = NULL;
								__temp180 = NULL;
								vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (decl)), (__temp181 = g_strdup_printf ("unable to initialize a variable of type `%s'", (__temp180 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))))))));
								(__temp181 = (g_free (__temp181), NULL));
								(__temp180 = (g_free (__temp180), NULL));
							}
						}
					}
				}
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		(__temp182 == NULL ? NULL : (__temp182 = (g_list_free (__temp182), NULL)));
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp183;
		GList* decl_it;
		__temp183 = NULL;
		__temp183 = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		for (decl_it = __temp183; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				if (vala_variable_declarator_get_initializer (decl) != NULL) {
					vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_variable_declarator_get_initializer (decl)->temp_vars);
				}
			}
		}
		(__temp183 == NULL ? NULL : (__temp183 = (g_list_free (__temp183), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), self->priv->temp_vars);
	__temp184 = NULL;
	self->priv->temp_vars = (__temp184 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp184);
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->c_keywords, name))) {
		return g_strconcat (name, "_", NULL);
	} else {
		return g_strdup (name);
	}
}


static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* rhs;
	ValaCCodeVariableDeclarator* __temp200;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (decl));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
		ValaArray* __temp187;
		ValaArray* arr;
		/* create variables to store array dimensions*/
		__temp187 = NULL;
		arr = (__temp187 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp187 == NULL ? NULL : g_object_ref (__temp187)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				ValaVariableDeclarator* len_decl;
				ValaTypeReference* __temp188;
				ValaVariableDeclarator* __temp189;
				len_decl = vala_variable_declarator_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim), NULL, NULL);
				__temp188 = NULL;
				(vala_variable_declarator_set_type_reference (len_decl, (__temp188 = vala_type_reference_new ())), vala_variable_declarator_get_type_reference (len_decl));
				(__temp188 == NULL ? NULL : (__temp188 = (g_object_unref (__temp188), NULL)));
				(vala_type_reference_set_data_type (vala_variable_declarator_get_type_reference (len_decl), vala_type_reference_get_data_type (self->priv->int_type)), vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (len_decl)));
				__temp189 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp189 = len_decl, (__temp189 == NULL ? NULL : g_object_ref (__temp189))));
				(len_decl == NULL ? NULL : (len_decl = (g_object_unref (len_decl), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	rhs = NULL;
	if (vala_variable_declarator_get_initializer (decl) != NULL) {
		ValaCCodeExpression* __temp191;
		ValaCCodeExpression* __temp190;
		__temp191 = NULL;
		__temp190 = NULL;
		rhs = (__temp191 = (__temp190 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)))), (__temp190 == NULL ? NULL : g_object_ref (__temp190))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp191);
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) {
			ValaCCodeExpression* __temp192;
			/* FIXME: use C cast if debugging disabled*/
			__temp192 = NULL;
			rhs = (__temp192 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp192);
		}
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaVariableDeclarator* __temp193;
			ValaCCodeAssignment* __temp194;
			ValaCCodeIdentifier* lhs_array_len;
			ValaCCodeExpression* rhs_array_len;
			ValaCCodeAssignment* __temp195;
			ValaCCodeIdentifier* __temp196;
			ValaCCodeExpression* __temp198;
			ValaCCodeCommaExpression* __temp197;
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE);
			__temp193 = NULL;
			self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp193 = temp_decl, (__temp193 == NULL ? NULL : g_object_ref (__temp193))));
			__temp194 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp194 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp194 == NULL ? NULL : (__temp194 = (g_object_unref (__temp194), NULL)));
			lhs_array_len = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), 1));
			rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_variable_declarator_get_initializer (decl), 1);
			__temp195 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp195 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp195 == NULL ? NULL : (__temp195 = (g_object_unref (__temp195), NULL)));
			__temp196 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp196 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
			(__temp196 == NULL ? NULL : (__temp196 = (g_object_unref (__temp196), NULL)));
			__temp198 = NULL;
			__temp197 = NULL;
			rhs = (__temp198 = VALA_CCODE_EXPRESSION ((__temp197 = ccomma, (__temp197 == NULL ? NULL : g_object_ref (__temp197)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp198);
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
			(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
		}
	} else {
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeExpression* __temp199;
			__temp199 = NULL;
			rhs = (__temp199 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp199);
		}
	}
	__temp200 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE ((__temp200 = vala_ccode_variable_declarator_new_with_initializer (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl)), rhs)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)));
	(__temp200 == NULL ? NULL : (__temp200 = (g_object_unref (__temp200), NULL)));
	(vala_symbol_set_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl)), TRUE), vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))));
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	if (vala_expression_get_expected_type (VALA_EXPRESSION (list)) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_expected_type (VALA_EXPRESSION (list))))) {
	} else {
		ValaCCodeInitializerList* clist;
		/* TODO */
		clist = g_object_new (VALA_TYPE_CCODE_INITIALIZER_LIST, NULL);
		{
			GList* __temp201;
			GList* expr_it;
			__temp201 = NULL;
			__temp201 = vala_initializer_list_get_initializers (list);
			for (expr_it = __temp201; expr_it != NULL; expr_it = expr_it->next) {
				ValaExpression* expr;
				expr = expr_it->data;
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
				}
			}
			(__temp201 == NULL ? NULL : (__temp201 = (g_list_free (__temp201), NULL)));
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist)), vala_code_node_get_ccodenode (VALA_CODE_NODE (list)));
		(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	}
}


static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership)
{
	ValaVariableDeclarator* decl;
	ValaTypeReference* __temp202;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	decl = vala_variable_declarator_new (g_strdup_printf ("__temp%d", self->priv->next_temp_var_id), NULL, NULL);
	__temp202 = NULL;
	(vala_variable_declarator_set_type_reference (decl, (__temp202 = vala_type_reference_copy (type))), vala_variable_declarator_get_type_reference (decl));
	(__temp202 = (g_object_unref (__temp202), NULL));
	(vala_type_reference_set_is_ref (vala_variable_declarator_get_type_reference (decl), FALSE), vala_type_reference_get_is_ref (vala_variable_declarator_get_type_reference (decl)));
	(vala_type_reference_set_is_out (vala_variable_declarator_get_type_reference (decl), FALSE), vala_type_reference_get_is_out (vala_variable_declarator_get_type_reference (decl)));
	(vala_type_reference_set_takes_ownership (vala_variable_declarator_get_type_reference (decl), takes_ownership), vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl)));
	self->priv->next_temp_var_id++;
	return decl;
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* unref_function;
		ValaCCodeIdentifier* __temp206;
		unref_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* __temp204;
			__temp204 = NULL;
			unref_function = (__temp204 = vala_data_type_get_unref_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp204);
		} else {
			char* __temp205;
			__temp205 = NULL;
			unref_function = (__temp205 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp205);
		}
		__temp206 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp206 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), __temp206));
		(unref_function = (g_free (unref_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && self->priv->current_class != NULL) {
			char* __temp207;
			char* __temp208;
			char* func_name;
			ValaCCodeMemberAccess* __temp209;
			__temp207 = NULL;
			__temp208 = NULL;
			func_name = (__temp208 = g_strdup_printf ("%s_destroy_func", (__temp207 = g_utf8_strdown (vala_type_parameter_get_name (vala_type_reference_get_type_parameter (type)), -1))), (__temp207 = (g_free (__temp207), NULL)), __temp208);
			__temp209 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp209 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), func_name), (func_name = (g_free (func_name), NULL)), __temp209));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type)
{
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* __temp219;
	ValaCCodeAssignment* cassign;
	char* __temp220;
	gboolean __temp221;
	ValaCCodeConditionalExpression* __temp223;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	if (vala_type_reference_get_is_null (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
	cisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
	if (vala_type_reference_get_data_type (type) == NULL) {
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* __temp213;
		if (self->priv->current_class == NULL) {
			ValaCCodeConstant* __temp212;
			__temp212 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp212 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp212));
		}
		/* unref functions are optional for type parameters*/
		cunrefisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, vala_code_generator_get_destroy_func_expression (self, type), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		__temp213 = NULL;
		cisnull = (__temp213 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp213);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	ccall = vala_ccode_function_call_new (vala_code_generator_get_destroy_func_expression (self, type));
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	/* TODO cleanup*/
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
		char* unref_function;
		unref_function = vala_data_type_get_free_function (vala_type_reference_get_data_type (type));
		if (g_utf8_collate (unref_function, "g_list_free") == 0) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GList* __temp214;
				GList* type_arg_it;
				__temp214 = NULL;
				__temp214 = vala_type_reference_get_type_arguments (type);
				for (type_arg_it = __temp214; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg;
					type_arg = type_arg_it->data;
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					}
				}
				(__temp214 == NULL ? NULL : (__temp214 = (g_list_free (__temp214), NULL)));
			}
			if (is_ref) {
				ValaCCodeFunctionCall* cunrefcall;
				ValaCCodeConstant* __temp217;
				cunrefcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_list_foreach")));
				vala_ccode_function_call_add_argument (cunrefcall, cvar);
				if (is_class || is_interface) {
					ValaCCodeIdentifier* __temp215;
					__temp215 = NULL;
					vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp215 = vala_ccode_identifier_new ("(GFunc) g_object_unref"))));
					(__temp215 == NULL ? NULL : (__temp215 = (g_object_unref (__temp215), NULL)));
				} else {
					ValaCCodeIdentifier* __temp216;
					__temp216 = NULL;
					vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp216 = vala_ccode_identifier_new ("(GFunc) g_free"))));
					(__temp216 == NULL ? NULL : (__temp216 = (g_object_unref (__temp216), NULL)));
				}
				__temp217 = NULL;
				vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp217 = vala_ccode_constant_new ("NULL"))));
				(__temp217 == NULL ? NULL : (__temp217 = (g_object_unref (__temp217), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cunrefcall));
				(cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL)));
			}
		} else {
			if (g_utf8_collate (unref_function, "g_string_free") == 0) {
				ValaCCodeConstant* __temp218;
				__temp218 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp218 = vala_ccode_constant_new ("TRUE"))));
				(__temp218 == NULL ? NULL : (__temp218 = (g_object_unref (__temp218), NULL)));
			}
		}
		(unref_function = (g_free (unref_function), NULL));
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	__temp219 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp219 = vala_ccode_constant_new ("NULL"))));
	(__temp219 == NULL ? NULL : (__temp219 = (g_object_unref (__temp219), NULL)));
	cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	__temp220 = NULL;
	if ((__temp221 = vala_type_reference_get_non_null (type) || (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type)) && g_utf8_collate ((__temp220 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type))), "g_free") == 0), (__temp220 = (g_free (__temp220), NULL)), __temp221)) {
		ValaCCodeParenthesizedExpression* __temp222;
		__temp222 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp222 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp222));
	}
	__temp223 = NULL;
	return VALA_CCODE_EXPRESSION ((__temp223 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp223));
	(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
}


static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr)
{
	ValaCodeGenerator * self;
	GList* __temp226;
	GList* __temp229;
	ValaVariableDeclarator* full_expr_decl;
	ValaVariableDeclarator* __temp230;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* __temp231;
	ValaCCodeIdentifier* __temp235;
	GList* __temp236;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		GList* __temp224;
		GList* __temp225;
		__temp224 = NULL;
		self->priv->temp_vars = (__temp224 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp224);
		__temp225 = NULL;
		self->priv->temp_ref_vars = (__temp225 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp225);
		return;
	}
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	__temp226 = NULL;
	expr->temp_vars = (__temp226 = NULL, (expr->temp_vars == NULL ? NULL : (expr->temp_vars = (g_list_foreach (expr->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (expr->temp_vars), NULL))), __temp226);
	{
		GList* __temp228;
		GList* decl1_it;
		__temp228 = NULL;
		__temp228 = self->priv->temp_vars;
		for (decl1_it = __temp228; decl1_it != NULL; decl1_it = decl1_it->next) {
			ValaVariableDeclarator* decl1;
			decl1 = decl1_it->data;
			{
				ValaVariableDeclarator* __temp227;
				__temp227 = NULL;
				expr->temp_vars = g_list_append (expr->temp_vars, (__temp227 = decl1, (__temp227 == NULL ? NULL : g_object_ref (__temp227))));
			}
		}
	}
	__temp229 = NULL;
	self->priv->temp_vars = (__temp229 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp229);
	if (self->priv->temp_ref_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	full_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	__temp230 = NULL;
	expr->temp_vars = g_list_append (expr->temp_vars, (__temp230 = full_expr_decl, (__temp230 == NULL ? NULL : g_object_ref (__temp230))));
	expr_list = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	__temp231 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp231 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (full_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp231 == NULL ? NULL : (__temp231 = (g_object_unref (__temp231), NULL)));
	{
		GList* __temp234;
		GList* decl_it;
		__temp234 = NULL;
		__temp234 = self->priv->temp_ref_vars;
		for (decl_it = __temp234; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeExpression* __temp233;
				ValaCCodeIdentifier* __temp232;
				__temp233 = NULL;
				__temp232 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (__temp233 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp232 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))));
				(__temp233 == NULL ? NULL : (__temp233 = (g_object_unref (__temp233), NULL)));
				(__temp232 == NULL ? NULL : (__temp232 = (g_object_unref (__temp232), NULL)));
			}
		}
	}
	__temp235 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp235 = vala_ccode_identifier_new (vala_variable_declarator_get_name (full_expr_decl)))));
	(__temp235 == NULL ? NULL : (__temp235 = (g_object_unref (__temp235), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	__temp236 = NULL;
	self->priv->temp_ref_vars = (__temp236 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp236);
	(full_expr_decl == NULL ? NULL : (full_expr_decl = (g_object_unref (full_expr_decl), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GList* temp_vars)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	{
		GList* __temp238;
		GList* decl_it;
		__temp238 = NULL;
		__temp238 = temp_vars;
		for (decl_it = __temp238; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), TRUE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))));
				vardecl = vala_ccode_variable_declarator_new (vala_variable_declarator_get_name (decl));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (vardecl));
				if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					ValaCCodeConstant* __temp237;
					__temp237 = NULL;
					(vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((__temp237 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (vardecl));
					(__temp237 == NULL ? NULL : (__temp237 = (g_object_unref (__temp237), NULL)));
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
			}
		}
	}
}


static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeExpressionStatement* __temp239;
	ValaCCodeFragment* cfrag;
	GList* __temp245;
	GList* __temp246;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (stmt));
	__temp239 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp239 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp239 == NULL ? NULL : (__temp239 = (g_object_unref (__temp239), NULL)));
	/* free temporary objects */
	if (!vala_code_generator_get_memory_management (self)) {
		GList* __temp240;
		GList* __temp241;
		__temp240 = NULL;
		self->priv->temp_vars = (__temp240 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp240);
		__temp241 = NULL;
		self->priv->temp_ref_vars = (__temp241 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp241);
		return;
	}
	if (self->priv->temp_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, self->priv->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp244;
		GList* decl_it;
		__temp244 = NULL;
		__temp244 = self->priv->temp_ref_vars;
		for (decl_it = __temp244; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeExpressionStatement* __temp243;
				ValaCCodeIdentifier* __temp242;
				__temp243 = NULL;
				__temp242 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp243 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp242 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))))));
				(__temp243 == NULL ? NULL : (__temp243 = (g_object_unref (__temp243), NULL)));
				(__temp242 == NULL ? NULL : (__temp242 = (g_object_unref (__temp242), NULL)));
			}
		}
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	__temp245 = NULL;
	self->priv->temp_vars = (__temp245 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp245);
	__temp246 = NULL;
	self->priv->temp_ref_vars = (__temp246 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp246);
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GList* temp_vars)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	/* declare temporary variables */
	if (temp_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_IF_STATEMENT (stmt));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* __temp247;
		__temp247 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp247 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_false_statement (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp247 == NULL ? NULL : (__temp247 = (g_object_unref (__temp247), NULL)));
	} else {
		ValaCCodeIfStatement* __temp248;
		__temp248 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp248 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp248 == NULL ? NULL : (__temp248 = (g_object_unref (__temp248), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_if_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaVariableDeclarator* temp_decl;
	ValaVariableDeclarator* __temp249;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeExpressionStatement* __temp250;
	GList* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE);
	__temp249 = NULL;
	vala_switch_statement_get_expression (stmt)->temp_vars = g_list_prepend (vala_switch_statement_get_expression (stmt)->temp_vars, (__temp249 = temp_decl, (__temp249 == NULL ? NULL : g_object_ref (__temp249))));
	ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
	cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	cswitchblock = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp250 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((__temp250 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(__temp250 == NULL ? NULL : (__temp250 = (g_object_unref (__temp250), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_switch_statement_get_expression (stmt)->temp_vars);
	default_statements = NULL;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GList* __temp262;
		GList* section_it;
		__temp262 = NULL;
		__temp262 = vala_switch_statement_get_sections (stmt);
		for (section_it = __temp262; section_it != NULL; section_it = section_it->next) {
			ValaSwitchSection* section;
			section = section_it->data;
			{
				if (vala_switch_section_has_default_label (section)) {
					GList* __temp251;
					__temp251 = NULL;
					default_statements = (__temp251 = vala_switch_section_get_statements (section), (default_statements == NULL ? NULL : (default_statements = (g_list_free (default_statements), NULL))), __temp251);
				} else {
					ValaCCodeBinaryExpression* cor;
					ValaCCodeBlock* cblock;
					ValaCCodeDoStatement* cdo;
					ValaCCodeIfStatement* cif;
					ValaCCodeIfStatement* __temp261;
					ValaCCodeIfStatement* __temp260;
					cor = NULL;
					{
						GList* __temp255;
						GList* label_it;
						__temp255 = NULL;
						__temp255 = vala_switch_section_get_labels (section);
						for (label_it = __temp255; label_it != NULL; label_it = label_it->next) {
							ValaSwitchLabel* label;
							label = label_it->data;
							{
								ValaCCodeBinaryExpression* ccmp;
								ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))));
								if (cor == NULL) {
									ValaCCodeBinaryExpression* __temp253;
									ValaCCodeBinaryExpression* __temp252;
									__temp253 = NULL;
									__temp252 = NULL;
									cor = (__temp253 = (__temp252 = ccmp, (__temp252 == NULL ? NULL : g_object_ref (__temp252))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp253);
								} else {
									ValaCCodeBinaryExpression* __temp254;
									__temp254 = NULL;
									cor = (__temp254 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp254);
								}
								(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
							}
						}
						(__temp255 == NULL ? NULL : (__temp255 = (g_list_free (__temp255), NULL)));
					}
					cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					{
						GList* __temp257;
						GList* body_stmt_it;
						__temp257 = NULL;
						__temp257 = vala_switch_section_get_statements (section);
						for (body_stmt_it = __temp257; body_stmt_it != NULL; body_stmt_it = body_stmt_it->next) {
							ValaStatement* body_stmt;
							body_stmt = body_stmt_it->data;
							{
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))) {
									{
										GList* __temp256;
										GList* cstmt_it;
										__temp256 = NULL;
										__temp256 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
										for (cstmt_it = __temp256; cstmt_it != NULL; cstmt_it = cstmt_it->next) {
											ValaCCodeStatement* cstmt;
											cstmt = cstmt_it->data;
											{
												vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											}
										}
										(__temp256 == NULL ? NULL : (__temp256 = (g_list_free (__temp256), NULL)));
									}
								} else {
									vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
								}
							}
						}
						(__temp257 == NULL ? NULL : (__temp257 = (g_list_free (__temp257), NULL)));
					}
					cdo = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")));
					cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
					if (coldif != NULL) {
						(vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif)), vala_ccode_if_statement_get_false_statement (coldif));
					} else {
						ValaCCodeStatement* __temp259;
						ValaCCodeIfStatement* __temp258;
						__temp259 = NULL;
						__temp258 = NULL;
						ctopstmt = (__temp259 = VALA_CCODE_STATEMENT ((__temp258 = cif, (__temp258 == NULL ? NULL : g_object_ref (__temp258)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp259);
					}
					__temp261 = NULL;
					__temp260 = NULL;
					coldif = (__temp261 = (__temp260 = cif, (__temp260 == NULL ? NULL : g_object_ref (__temp260))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), __temp261);
					(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
					(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
					(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
					(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
				}
			}
		}
		(__temp262 == NULL ? NULL : (__temp262 = (g_list_free (__temp262), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeDoStatement* cdo;
		cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GList* __temp263;
			GList* body_stmt_it;
			__temp263 = NULL;
			__temp263 = default_statements;
			for (body_stmt_it = __temp263; body_stmt_it != NULL; body_stmt_it = body_stmt_it->next) {
				ValaStatement* body_stmt;
				body_stmt = body_stmt_it->data;
				{
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
				}
			}
		}
		cdo = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")));
		if (coldif == NULL) {
			ValaCCodeStatement* __temp265;
			ValaCCodeDoStatement* __temp264;
			/* there is only one section and that section
			 contains a default label*/
			__temp265 = NULL;
			__temp264 = NULL;
			ctopstmt = (__temp265 = VALA_CCODE_STATEMENT ((__temp264 = cdo, (__temp264 == NULL ? NULL : g_object_ref (__temp264)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp265);
		} else {
			(vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo)), vala_ccode_if_statement_get_false_statement (coldif));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_list_free (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeWhileStatement* __temp266;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (stmt));
	__temp266 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp266 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_body (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp266 == NULL ? NULL : (__temp266 = (g_object_unref (__temp266), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_while_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeDoStatement* __temp267;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DO_STATEMENT (stmt));
	__temp267 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp267 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_condition (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp267 == NULL ? NULL : (__temp267 = (g_object_unref (__temp267), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_do_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeForStatement* cfor;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOR_STATEMENT (stmt));
	cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_body (stmt)))));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp268;
		GList* init_expr_it;
		__temp268 = NULL;
		__temp268 = vala_for_statement_get_initializer (stmt);
		for (init_expr_it = __temp268; init_expr_it != NULL; init_expr_it = init_expr_it->next) {
			ValaExpression* init_expr;
			init_expr = init_expr_it->data;
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (init_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), init_expr->temp_vars);
			}
		}
		(__temp268 == NULL ? NULL : (__temp268 = (g_list_free (__temp268), NULL)));
	}
	{
		GList* __temp269;
		GList* it_expr_it;
		__temp269 = NULL;
		__temp269 = vala_for_statement_get_iterator (stmt);
		for (it_expr_it = __temp269; it_expr_it != NULL; it_expr_it = it_expr_it->next) {
			ValaExpression* it_expr;
			it_expr = it_expr_it->data;
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (it_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), it_expr->temp_vars);
			}
		}
		(__temp269 == NULL ? NULL : (__temp269 = (g_list_free (__temp269), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_for_statement_get_condition (stmt)->temp_vars);
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBlock* cblock;
	ValaCCodeForStatement* cfor;
	ValaVariableDeclarator* collection_backup;
	ValaVariableDeclarator* __temp270;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpressionStatement* __temp271;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cfor = NULL;
	collection_backup = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), TRUE);
	__temp270 = NULL;
	vala_foreach_statement_get_collection (stmt)->temp_vars = g_list_prepend (vala_foreach_statement_get_collection (stmt)->temp_vars, (__temp270 = collection_backup, (__temp270 == NULL ? NULL : g_object_ref (__temp270))));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, vala_foreach_statement_get_collection (stmt)->temp_vars);
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	__temp271 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp271 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp271 == NULL ? NULL : (__temp271 = (g_object_unref (__temp271), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))))) {
		ValaArray* __temp272;
		ValaArray* arr;
		ValaCCodeExpression* array_len;
		__temp272 = NULL;
		arr = (__temp272 = VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))), (__temp272 == NULL ? NULL : g_object_ref (__temp272)));
		array_len = vala_code_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), 1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp273;
			ValaCCodeBlock* cbody;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp274;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp275;
			ValaCCodeAssignment* __temp276;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			citdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE));
			__temp273 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp273 = vala_ccode_variable_declarator_new (it_name))));
			(__temp273 == NULL ? NULL : (__temp273 = (g_object_unref (__temp273), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			__temp274 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp274 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("*%s", it_name)))))));
			(__temp274 == NULL ? NULL : (__temp274 = (g_object_unref (__temp274), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("*%s", it_name))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp275 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp275 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp275 == NULL ? NULL : (__temp275 = (g_object_unref (__temp275), NULL)));
			__temp276 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp276 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp276 == NULL ? NULL : (__temp276 = (g_object_unref (__temp276), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp277;
			ValaCCodeBlock* cbody;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp278;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp283;
			ValaCCodeAssignment* __temp284;
			/* the array has a length parameter */
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			__temp277 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp277 = vala_ccode_variable_declarator_new (it_name))));
			(__temp277 == NULL ? NULL : (__temp277 = (g_object_unref (__temp277), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			__temp278 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp278 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name))))))));
			(__temp278 == NULL ? NULL : (__temp278 = (g_object_unref (__temp278), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ccond_ind1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")));
			ccond_ind2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), array_len);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* __temp279;
				ccond_term1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")));
				ccond_term2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				__temp279 = NULL;
				ccond = (__temp279 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind))), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term)))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp279);
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* __temp280;
				ValaCCodeBinaryExpression* __temp282;
				ValaCCodeBinaryExpression* __temp281;
				/* assert when trying to iterate over value-type arrays of unknown length */
				cassert = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_assert")));
				vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (ccond_ind1));
				__temp280 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp280 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)))));
				(__temp280 == NULL ? NULL : (__temp280 = (g_object_unref (__temp280), NULL)));
				__temp282 = NULL;
				__temp281 = NULL;
				ccond = (__temp282 = (__temp281 = ccond_ind2, (__temp281 == NULL ? NULL : g_object_ref (__temp281))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp282);
				(cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp283 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp283 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp283 == NULL ? NULL : (__temp283 = (g_object_unref (__temp283), NULL)));
			__temp284 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp284 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp284 == NULL ? NULL : (__temp284 = (g_object_unref (__temp284), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		(array_len = (g_object_unref (array_len), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->list_type || vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->slist_type) {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp285;
			ValaCCodeBlock* cbody;
			ValaCCodeExpression* element_expr;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp291;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp292;
			ValaCCodeAssignment* __temp293;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			citdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE));
			__temp285 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp285 = vala_ccode_variable_declarator_new (it_name))));
			(__temp285 == NULL ? NULL : (__temp285 = (g_object_unref (__temp285), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			element_expr = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), "data"));
			/* cast pointer to actual type if appropriate */
			if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_foreach_statement_get_type_reference (stmt)))) {
				ValaStruct* __temp286;
				ValaStruct* st;
				__temp286 = NULL;
				st = (__temp286 = VALA_STRUCT (vala_type_reference_get_data_type (vala_foreach_statement_get_type_reference (stmt))), (__temp286 == NULL ? NULL : g_object_ref (__temp286)));
				if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeFunctionCall* cconv;
					ValaCCodeExpression* __temp288;
					ValaCCodeFunctionCall* __temp287;
					cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_UINT")));
					vala_ccode_function_call_add_argument (cconv, element_expr);
					__temp288 = NULL;
					__temp287 = NULL;
					element_expr = (__temp288 = VALA_CCODE_EXPRESSION ((__temp287 = cconv, (__temp287 == NULL ? NULL : g_object_ref (__temp287)))), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp288);
					(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
				} else {
					if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
						ValaCCodeFunctionCall* cconv;
						ValaCCodeExpression* __temp290;
						ValaCCodeFunctionCall* __temp289;
						cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_INT")));
						vala_ccode_function_call_add_argument (cconv, element_expr);
						__temp290 = NULL;
						__temp289 = NULL;
						element_expr = (__temp290 = VALA_CCODE_EXPRESSION ((__temp289 = cconv, (__temp289 == NULL ? NULL : g_object_ref (__temp289)))), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp290);
						(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
					}
				}
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
			cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			__temp291 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp291 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(__temp291 == NULL ? NULL : (__temp291 = (g_object_unref (__temp291), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp292 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp292 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp292 == NULL ? NULL : (__temp292 = (g_object_unref (__temp292), NULL)));
			__temp293 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp293 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp293 == NULL ? NULL : (__temp293 = (g_object_unref (__temp293), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
	}
	if (vala_code_generator_get_memory_management (self) && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaCCodeExpressionStatement* __temp295;
		ValaCCodeIdentifier* __temp294;
		__temp295 = NULL;
		__temp294 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp295 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp294 = vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup)))), vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))))));
		(__temp295 == NULL ? NULL : (__temp295 = (g_object_unref (__temp295), NULL)));
		(__temp294 == NULL ? NULL : (__temp294 = (g_object_unref (__temp294), NULL)));
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBreakStatement* __temp296;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BREAK_STATEMENT (stmt));
	__temp296 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp296 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp296 == NULL ? NULL : (__temp296 = (g_object_unref (__temp296), NULL)));
}


static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeContinueStatement* __temp297;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONTINUE_STATEMENT (stmt));
	__temp297 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp297 = g_object_new (VALA_TYPE_CCODE_CONTINUE_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp297 == NULL ? NULL : (__temp297 = (g_object_unref (__temp297), NULL)));
}


static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop)
{
	ValaBlock* __temp298;
	ValaBlock* b;
	GList* local_vars;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (sym == NULL || VALA_IS_SYMBOL (sym));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	__temp298 = NULL;
	b = (__temp298 = VALA_BLOCK (vala_symbol_get_node (sym)), (__temp298 == NULL ? NULL : g_object_ref (__temp298)));
	local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp301;
		GList* decl_it;
		__temp301 = NULL;
		__temp301 = local_vars;
		for (decl_it = __temp301; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				if (vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaCCodeExpressionStatement* __temp300;
					ValaCCodeIdentifier* __temp299;
					__temp300 = NULL;
					__temp299 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp300 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp299 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))), vala_variable_declarator_get_type_reference (decl))))));
					(__temp300 == NULL ? NULL : (__temp300 = (g_object_unref (__temp300), NULL)));
					(__temp299 == NULL ? NULL : (__temp299 = (g_object_unref (__temp299), NULL)));
				}
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_node (vala_symbol_get_parent_symbol (sym)))) {
		vala_code_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
}


static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaStatement* stmt)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_STATEMENT (stmt));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_local_free (self, self->priv->current_symbol, cfrag, FALSE);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop)
{
	gboolean found;
	ValaBlock* __temp302;
	ValaBlock* b;
	GList* local_vars;
	gboolean __temp306;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (ccomma == NULL || VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	__temp302 = NULL;
	b = (__temp302 = VALA_BLOCK (vala_symbol_get_node (sym)), (__temp302 == NULL ? NULL : g_object_ref (__temp302)));
	local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp305;
		GList* decl_it;
		__temp305 = NULL;
		__temp305 = local_vars;
		for (decl_it = __temp305; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				if (vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaCCodeExpression* __temp304;
					ValaCCodeIdentifier* __temp303;
					found = TRUE;
					__temp304 = NULL;
					__temp303 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp304 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp303 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))), vala_variable_declarator_get_type_reference (decl))));
					(__temp304 == NULL ? NULL : (__temp304 = (g_object_unref (__temp304), NULL)));
					(__temp303 == NULL ? NULL : (__temp303 = (g_object_unref (__temp303), NULL)));
				}
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_node (vala_symbol_get_parent_symbol (sym)))) {
		found = found || vala_code_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop);
	}
	return (__temp306 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL))), __temp306);
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
}


static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaVariableDeclarator* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* __temp307;
	ValaCCodeIdentifier* __temp308;
	ValaVariableDeclarator* __temp309;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	__temp307 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp307 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp307 == NULL ? NULL : (__temp307 = (g_object_unref (__temp307), NULL)));
	if (!vala_code_generator_append_local_free_expr (self, self->priv->current_symbol, ccomma, FALSE)) {
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	/* no local variables need to be freed */
	__temp308 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp308 = vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl)))));
	(__temp308 == NULL ? NULL : (__temp308 = (g_object_unref (__temp308), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	__temp309 = NULL;
	expr->temp_vars = g_list_append (expr->temp_vars, (__temp309 = return_expr_decl, (__temp309 == NULL ? NULL : g_object_ref (__temp309))));
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)) != NULL && VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))))) {
			ValaVariableDeclarator* __temp310;
			ValaVariableDeclarator* decl;
			__temp310 = NULL;
			decl = (__temp310 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))), (__temp310 == NULL ? NULL : g_object_ref (__temp310)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				(vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE), vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)));
				/* don't ref expression*/
				(vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE), vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)));
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* __temp311;
		__temp311 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp311 = vala_ccode_return_statement_new (NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp311 == NULL ? NULL : (__temp311 = (g_object_unref (__temp311), NULL)));
		vala_code_generator_create_local_free (self, VALA_STATEMENT (stmt));
	} else {
		ValaSymbol* return_expression_symbol;
		ValaCCodeReturnStatement* __temp316;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)) != NULL && VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))))) {
			ValaVariableDeclarator* __temp312;
			ValaVariableDeclarator* decl;
			__temp312 = NULL;
			decl = (__temp312 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))), (__temp312 == NULL ? NULL : g_object_ref (__temp312)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				ValaSymbol* __temp314;
				ValaSymbol* __temp313;
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				__temp314 = NULL;
				__temp313 = NULL;
				return_expression_symbol = (__temp314 = (__temp313 = vala_code_node_get_symbol (VALA_CODE_NODE (decl)), (__temp313 == NULL ? NULL : g_object_ref (__temp313))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), __temp314);
				(vala_symbol_set_active (return_expression_symbol, FALSE), vala_symbol_get_active (return_expression_symbol));
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
		vala_code_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		if (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt))) != vala_type_reference_get_data_type (self->priv->current_return_type)) {
			/* cast required */
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (self->priv->current_return_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (self->priv->current_return_type))) {
				ValaInstanceCast* __temp315;
				__temp315 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((__temp315 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), vala_type_reference_get_data_type (self->priv->current_return_type))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt))));
				(__temp315 == NULL ? NULL : (__temp315 = (g_object_unref (__temp315), NULL)));
			}
		}
		__temp316 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp316 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp316 == NULL ? NULL : (__temp316 = (g_object_unref (__temp316), NULL)));
		vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_return_statement_get_return_expression (stmt)->temp_vars);
		if (return_expression_symbol != NULL) {
			(vala_symbol_set_active (return_expression_symbol, TRUE), vala_symbol_get_active (return_expression_symbol));
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


/**
 * Visit operation called for lock statements.
 *
 * @param stmt a lock statement
 */
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* __temp318;
	ValaExpression* inner_node;
	ValaCCodeExpression* __temp323;
	ValaCCodeFunctionCall* __temp325;
	ValaSymbol* __temp324;
	ValaCCodeExpressionStatement* __temp326;
	ValaCCodeFunctionCall* __temp328;
	ValaSymbol* __temp327;
	ValaCCodeExpressionStatement* __temp329;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (stmt));
	cn = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	l = NULL;
	fc = NULL;
	__temp318 = NULL;
	inner_node = (__temp318 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (__temp318 == NULL ? NULL : g_object_ref (__temp318)));
	if (inner_node == NULL) {
		ValaCCodeExpression* __temp319;
		__temp319 = NULL;
		l = (__temp319 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp319);
	} else {
		if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))) != VALA_CODE_NODE (self->priv->current_class)) {
			ValaCCodeExpression* __temp320;
			__temp320 = NULL;
			l = (__temp320 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), NULL))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp320);
			vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (l)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))));
		} else {
			ValaCCodeExpression* __temp322;
			ValaCCodeExpression* __temp321;
			__temp322 = NULL;
			__temp321 = NULL;
			l = (__temp322 = (__temp321 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), (__temp321 == NULL ? NULL : g_object_ref (__temp321))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp322);
		}
	}
	__temp323 = NULL;
	l = (__temp323 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (l, "priv")), vala_code_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp323);
	__temp325 = NULL;
	__temp324 = NULL;
	fc = (__temp325 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname ((VALA_METHOD (vala_symbol_get_node ((__temp324 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->mutex_type))), "lock"))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp325);
	(__temp324 == NULL ? NULL : (__temp324 = (g_object_unref (__temp324), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	__temp326 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp326 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp326 == NULL ? NULL : (__temp326 = (g_object_unref (__temp326), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_lock_statement_get_body (stmt))));
	__temp328 = NULL;
	__temp327 = NULL;
	fc = (__temp328 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname ((VALA_METHOD (vala_symbol_get_node ((__temp327 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->mutex_type))), "unlock"))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp328);
	(__temp327 == NULL ? NULL : (__temp327 = (g_object_unref (__temp327), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	__temp329 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp329 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp329 == NULL ? NULL : (__temp329 = (g_object_unref (__temp329), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr)
{
	ValaCodeGenerator * self;
	GList* sizes;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* __temp330;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	/* FIXME: rank > 1 not supported yet */
	if (vala_array_creation_expression_get_rank (expr) > 1) {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Creating arrays with rank greater than 1 is not supported yet");
	}
	sizes = vala_array_creation_expression_get_sizes (expr);
	gnew = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
	__temp330 = NULL;
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION ((__temp330 = vala_ccode_identifier_new (vala_type_reference_get_cname (vala_array_creation_expression_get_element_type (expr), FALSE, FALSE)))));
	(__temp330 == NULL ? NULL : (__temp330 = (g_object_unref (__temp330), NULL)));
	/* FIXME: had to add Expression cast due to possible compiler bug */
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((VALA_EXPRESSION (g_list_first (sizes)->data))))));
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaVariableDeclarator* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaVariableDeclarator* __temp331;
		ValaCCodeAssignment* __temp332;
		ce = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		temp_var = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
		name_cnode = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_var));
		i = 0;
		__temp331 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp331 = temp_var, (__temp331 == NULL ? NULL : g_object_ref (__temp331))));
		/* FIXME: had to add Expression cast due to possible compiler bug */
		__temp332 = NULL;
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp332 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (gnew), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp332 == NULL ? NULL : (__temp332 = (g_object_unref (__temp332), NULL)));
		{
			GList* __temp334;
			GList* e_it;
			__temp334 = NULL;
			__temp334 = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			for (e_it = __temp334; e_it != NULL; e_it = e_it->next) {
				ValaExpression* e;
				e = e_it->data;
				{
					ValaCCodeAssignment* __temp333;
					__temp333 = NULL;
					vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp333 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("%i", i))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (e))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp333 == NULL ? NULL : (__temp333 = (g_object_unref (__temp333), NULL)));
					i++;
				}
			}
			(__temp334 == NULL ? NULL : (__temp334 = (g_list_free (__temp334), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION (name_cnode));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ce)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(ce == NULL ? NULL : (ce = (g_object_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
	} else {
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (gnew)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	}
	(sizes == NULL ? NULL : (sizes = (g_list_free (sizes), NULL)));
	(gnew == NULL ? NULL : (gnew = (g_object_unref (gnew), NULL)));
}


static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp335;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (expr));
	__temp335 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp335 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE"))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp335 == NULL ? NULL : (__temp335 = (g_object_unref (__temp335), NULL)));
}


static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* __temp336;
		__temp336 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp336 = vala_ccode_constant_new (vala_character_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp336 == NULL ? NULL : (__temp336 = (g_object_unref (__temp336), NULL)));
	} else {
		ValaCCodeConstant* __temp337;
		__temp337 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp337 = vala_ccode_constant_new (g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp337 == NULL ? NULL : (__temp337 = (g_object_unref (__temp337), NULL)));
	}
}


static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp338;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTEGER_LITERAL (expr));
	__temp338 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp338 = vala_ccode_constant_new (vala_integer_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp338 == NULL ? NULL : (__temp338 = (g_object_unref (__temp338), NULL)));
}


static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp339;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REAL_LITERAL (expr));
	__temp339 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp339 = vala_ccode_constant_new (vala_real_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp339 == NULL ? NULL : (__temp339 = (g_object_unref (__temp339), NULL)));
}


static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp340;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRING_LITERAL (expr));
	__temp340 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp340 = vala_ccode_constant_new (vala_string_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp340 == NULL ? NULL : (__temp340 = (g_object_unref (__temp340), NULL)));
}


static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp341;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_NULL_LITERAL (expr));
	__temp341 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp341 = vala_ccode_constant_new ("NULL")))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp341 == NULL ? NULL : (__temp341 = (g_object_unref (__temp341), NULL)));
}


static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LITERAL_EXPRESSION (expr));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_literal_expression_get_literal (expr)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeParenthesizedExpression* __temp342;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	__temp342 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp342 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_parenthesized_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp342 == NULL ? NULL : (__temp342 = (g_object_unref (__temp342), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim)
{
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (array_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* __temp343;
		ValaUnaryExpression* unary_expr;
		__temp343 = NULL;
		unary_expr = (__temp343 = VALA_UNARY_EXPRESSION (array_expr), (__temp343 == NULL ? NULL : g_object_ref (__temp343)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GList* size;
		ValaExpression* __temp344;
		ValaExpression* length_expr;
		ValaCCodeExpression* __temp345;
		ValaCCodeExpression* __temp346;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		__temp344 = NULL;
		length_expr = (__temp344 = g_list_nth_data (size, dim - 1), (__temp344 == NULL ? NULL : g_object_ref (__temp344)));
		__temp345 = NULL;
		__temp346 = NULL;
		return (__temp346 = (__temp345 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (length_expr))), (__temp345 == NULL ? NULL : g_object_ref (__temp345))), (size == NULL ? NULL : (size = (g_list_free (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp346);
		(size == NULL ? NULL : (size = (g_list_free (size), NULL)));
		(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* __temp347;
			ValaInvocationExpression* invocation_expr;
			GList* size;
			ValaCCodeExpression* __temp348;
			ValaCCodeExpression* __temp349;
			__temp347 = NULL;
			invocation_expr = (__temp347 = VALA_INVOCATION_EXPRESSION (array_expr), (__temp347 == NULL ? NULL : g_object_ref (__temp347)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			__temp348 = NULL;
			__temp349 = NULL;
			return (__temp349 = (__temp348 = g_list_nth_data (size, dim - 1), (__temp348 == NULL ? NULL : g_object_ref (__temp348))), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (g_list_free (size), NULL))), __temp349);
			(invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL)));
			(size == NULL ? NULL : (size = (g_list_free (size), NULL)));
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
					ValaFormalParameter* __temp350;
					ValaFormalParameter* param;
					__temp350 = NULL;
					param = (__temp350 = VALA_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp350 == NULL ? NULL : g_object_ref (__temp350)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						ValaCCodeIdentifier* length_expr;
						length_expr = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_formal_parameter_get_name (param), dim));
						if (is_out) {
							ValaCCodeUnaryExpression* __temp351;
							__temp351 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp351 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp351));
						} else {
							ValaCCodeIdentifier* __temp352;
							__temp352 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp352 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp352));
						}
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					if (VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
						ValaVariableDeclarator* __temp353;
						ValaVariableDeclarator* decl;
						ValaCCodeIdentifier* length_expr;
						__temp353 = NULL;
						decl = (__temp353 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp353 == NULL ? NULL : g_object_ref (__temp353)));
						length_expr = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim));
						if (is_out) {
							ValaCCodeUnaryExpression* __temp354;
							__temp354 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp354 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp354));
						} else {
							ValaCCodeIdentifier* __temp355;
							__temp355 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp355 = length_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), __temp355));
						}
						(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
							ValaField* __temp356;
							ValaField* field;
							__temp356 = NULL;
							field = (__temp356 = VALA_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp356 == NULL ? NULL : g_object_ref (__temp356)));
							if (!vala_field_get_no_array_length (field)) {
								char* length_cname;
								ValaMemberAccess* __temp357;
								ValaMemberAccess* ma;
								ValaCCodeExpression* pub_inst;
								ValaDataType* base_type;
								ValaCCodeExpression* length_expr;
								length_cname = vala_code_generator_get_array_length_cname (self, vala_field_get_name (field), dim);
								__temp357 = NULL;
								ma = (__temp357 = VALA_MEMBER_ACCESS (array_expr), (__temp357 == NULL ? NULL : g_object_ref (__temp357)));
								pub_inst = NULL;
								base_type = NULL;
								length_expr = NULL;
								if (vala_member_access_get_inner (ma) == NULL) {
									ValaCCodeExpression* __temp358;
									__temp358 = NULL;
									pub_inst = (__temp358 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp358);
									if (self->priv->current_type_symbol != NULL) {
										ValaDataType* __temp360;
										ValaDataType* __temp359;
										/* base type is available if this is a type method */
										__temp360 = NULL;
										__temp359 = NULL;
										base_type = (__temp360 = (__temp359 = VALA_DATA_TYPE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp359 == NULL ? NULL : g_object_ref (__temp359))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp360);
									}
								} else {
									ValaCCodeExpression* __temp362;
									ValaCCodeExpression* __temp361;
									__temp362 = NULL;
									__temp361 = NULL;
									pub_inst = (__temp362 = (__temp361 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp361 == NULL ? NULL : g_object_ref (__temp361))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp362);
									if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaDataType* __temp364;
										ValaDataType* __temp363;
										__temp364 = NULL;
										__temp363 = NULL;
										base_type = (__temp364 = (__temp363 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (__temp363 == NULL ? NULL : g_object_ref (__temp363))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp364);
									}
								}
								if (vala_field_get_instance (field)) {
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									typed_inst = NULL;
									if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))) != VALA_CODE_NODE (base_type)) {
										ValaCCodeExpression* __temp365;
										/* FIXME: use C cast if debugging disabled*/
										__temp365 = NULL;
										typed_inst = (__temp365 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))))), NULL))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp365);
										vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
									} else {
										ValaCCodeExpression* __temp367;
										ValaCCodeExpression* __temp366;
										__temp367 = NULL;
										__temp366 = NULL;
										typed_inst = (__temp367 = (__temp366 = pub_inst, (__temp366 == NULL ? NULL : g_object_ref (__temp366))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp367);
									}
									inst = NULL;
									if (field->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* __temp368;
										__temp368 = NULL;
										inst = (__temp368 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp368);
									} else {
										ValaCCodeExpression* __temp370;
										ValaCCodeExpression* __temp369;
										__temp370 = NULL;
										__temp369 = NULL;
										inst = (__temp370 = (__temp369 = typed_inst, (__temp369 == NULL ? NULL : g_object_ref (__temp369))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp370);
									}
									if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))))))) {
										ValaCCodeExpression* __temp371;
										__temp371 = NULL;
										length_expr = (__temp371 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp371);
									} else {
										ValaCCodeExpression* __temp372;
										__temp372 = NULL;
										length_expr = (__temp372 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp372);
									}
									(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* __temp373;
									__temp373 = NULL;
									length_expr = (__temp373 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp373);
								}
								if (is_out) {
									ValaCCodeUnaryExpression* __temp374;
									__temp374 = NULL;
									return VALA_CCODE_EXPRESSION ((__temp374 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp374));
								} else {
									ValaCCodeExpression* __temp375;
									__temp375 = NULL;
									return (__temp375 = length_expr, (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp375);
								}
								(length_cname = (g_free (length_cname), NULL));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
								(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						}
					}
				}
			}
		}
	}
	if (!is_out) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


/* allow arrays with unknown length even for value types
 * as else it may be impossible to bind some libraries
 * users of affected libraries should explicitly set
 * the array length as early as possible
 * by setting the virtual length field of the array
 */
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr)
{
	ValaCodeGenerator * self;
	GList* indices;
	gint rank;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (expr));
	indices = vala_element_access_get_indices (expr);
	rank = g_list_length (indices);
	if (rank == 1) {
		ValaCCodeElementAccess* __temp378;
		/* FIXME: had to add Expression cast due to possible compiler bug */
		__temp378 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp378 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((VALA_EXPRESSION (g_list_first (indices)->data))))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp378 == NULL ? NULL : (__temp378 = (g_object_unref (__temp378), NULL)));
	} else {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Arrays with more then one dimension are not supported yet");
		(indices == NULL ? NULL : (indices = (g_list_free (indices), NULL)));
		return;
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(indices == NULL ? NULL : (indices = (g_list_free (indices), NULL)));
}


static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr)
{
	ValaCodeGenerator * self;
	ValaInstanceCast* __temp379;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BASE_ACCESS (expr));
	__temp379 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp379 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp379 == NULL ? NULL : (__temp379 = (g_object_unref (__temp379), NULL)));
}


static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* __temp384;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (expr));
	ma = vala_code_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* __temp380;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaVariableDeclarator* __temp381;
		ValaCCodeAssignment* __temp382;
		ValaCCodeBinaryOperator op;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp383;
		/* property postfix expression*/
		__temp380 = NULL;
		prop = (__temp380 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))), (__temp380 == NULL ? NULL : g_object_ref (__temp380)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		/* assign current value to temp variable*/
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_property_get_type_reference (prop), TRUE);
		__temp381 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp381 = temp_decl, (__temp381 == NULL ? NULL : g_object_ref (__temp381))));
		__temp382 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp382 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp382 == NULL ? NULL : (__temp382 = (g_object_unref (__temp382), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		cexpr = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")));
		ccall = vala_code_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		__temp383 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp383 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
		(__temp383 == NULL ? NULL : (__temp383 = (g_object_unref (__temp383), NULL)));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	__temp384 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp384 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp384 == NULL ? NULL : (__temp384 = (g_object_unref (__temp384), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaMemberAccess* __temp388;
	ValaMemberAccess* ma;
	gpointer __temp390;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* __temp385;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* __temp386;
		__temp385 = NULL;
		pe = (__temp385 = VALA_PARENTHESIZED_EXPRESSION (expr), (__temp385 == NULL ? NULL : g_object_ref (__temp385)));
		__temp386 = NULL;
		return (__temp386 = vala_code_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), __temp386);
		(pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL)));
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return VALA_MEMBER_ACCESS (NULL);
	}
	__temp388 = NULL;
	ma = (__temp388 = VALA_MEMBER_ACCESS (expr), (__temp388 == NULL ? NULL : g_object_ref (__temp388)));
	if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))))) {
		return ma;
	}
	return VALA_MEMBER_ACCESS ((__temp390 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp390));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	char* ref_function;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == NULL && vala_type_reference_get_type_parameter (vala_expression_get_static_type (expr)) != NULL) {
		ValaCCodeExpression* __temp391;
		vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Missing generics support for memory management");
		__temp391 = NULL;
		return (__temp391 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), (__temp391 == NULL ? NULL : g_object_ref (__temp391)));
	}
	ref_function = NULL;
	if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)))) {
		char* __temp393;
		__temp393 = NULL;
		ref_function = (__temp393 = vala_data_type_get_ref_function (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))), (ref_function = (g_free (ref_function), NULL)), __temp393);
	} else {
		char* __temp395;
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) != vala_type_reference_get_data_type (self->priv->string_type)) {
			char* __temp394;
			/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
			__temp394 = NULL;
			vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp394 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_data_type_get_name (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))))));
			(__temp394 = (g_free (__temp394), NULL));
		}
		__temp395 = NULL;
		ref_function = (__temp395 = vala_data_type_get_dup_function (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))), (ref_function = (g_free (ref_function), NULL)), __temp395);
	}
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (ref_function)));
	if (vala_type_reference_get_non_null (vala_expression_get_static_type (expr))) {
		ValaCCodeFunctionCall* __temp396;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		__temp396 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp396 = ccall, (ref_function = (g_free (ref_function), NULL)), __temp396));
	} else {
		ValaVariableDeclarator* decl;
		ValaVariableDeclarator* __temp397;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* __temp398;
		ValaCCodeConditionalExpression* __temp402;
		ValaCCodeCommaExpression* __temp403;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), FALSE);
		__temp397 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp397 = decl, (__temp397 == NULL ? NULL : g_object_ref (__temp397))));
		ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl));
		cisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		__temp398 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp398 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp398 == NULL ? NULL : (__temp398 = (g_object_unref (__temp398), NULL)));
		if (g_utf8_collate (ref_function, "g_list_copy") == 0) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GList* __temp399;
				GList* type_arg_it;
				__temp399 = NULL;
				__temp399 = vala_type_reference_get_type_arguments (vala_expression_get_static_type (expr));
				for (type_arg_it = __temp399; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg;
					type_arg = type_arg_it->data;
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					}
				}
				(__temp399 == NULL ? NULL : (__temp399 = (g_list_free (__temp399), NULL)));
			}
			if (is_ref && (is_class || is_interface)) {
				ValaCCodeFunctionCall* crefcall;
				ValaCCodeIdentifier* __temp400;
				ValaCCodeConstant* __temp401;
				crefcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_list_foreach")));
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION (ctemp));
				__temp400 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp400 = vala_ccode_identifier_new ("(GFunc) g_object_ref"))));
				(__temp400 == NULL ? NULL : (__temp400 = (g_object_unref (__temp400), NULL)));
				__temp401 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp401 = vala_ccode_constant_new ("NULL"))));
				(__temp401 == NULL ? NULL : (__temp401 = (g_object_unref (__temp401), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (crefcall));
				(crefcall == NULL ? NULL : (crefcall = (g_object_unref (crefcall), NULL)));
			}
		}
		__temp402 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp402 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_EXPRESSION (ccall)))));
		(__temp402 == NULL ? NULL : (__temp402 = (g_object_unref (__temp402), NULL)));
		__temp403 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp403 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp403));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	}
	(ref_function = (g_free (ref_function), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_type_reference_get_floating_reference (vala_expression_get_static_type (expr))) {
		ValaCCodeFunctionCall* csink;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		csink = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_ref_sink")));
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaVariableDeclarator* decl;
		ValaVariableDeclarator* __temp404;
		ValaVariableDeclarator* __temp405;
		ValaCCodeParenthesizedExpression* __temp406;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
		__temp404 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp404 = decl, (__temp404 == NULL ? NULL : g_object_ref (__temp404))));
		__temp405 = NULL;
		self->priv->temp_ref_vars = g_list_prepend (self->priv->temp_ref_vars, (__temp405 = decl, (__temp405 == NULL ? NULL : g_object_ref (__temp405))));
		__temp406 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp406 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp406 == NULL ? NULL : (__temp406 = (g_object_unref (__temp406), NULL)));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* __temp407;
			__temp407 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp407 = vala_code_generator_get_ref_expression (self, expr)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp407 == NULL ? NULL : (__temp407 = (g_object_unref (__temp407), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	if (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)) == NULL) {
		/* no creation method*/
		if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* __temp408;
			ValaCCodeConstant* __temp409;
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_new")));
			__temp408 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp408 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))))));
			(__temp408 == NULL ? NULL : (__temp408 = (g_object_unref (__temp408), NULL)));
			__temp409 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp409 = vala_ccode_constant_new ("NULL"))));
			(__temp409 == NULL ? NULL : (__temp409 = (g_object_unref (__temp409), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->list_type || vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->slist_type) {
				ValaCCodeConstant* __temp410;
				/* NULL is an empty list*/
				__temp410 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp410 = vala_ccode_constant_new ("NULL")))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp410 == NULL ? NULL : (__temp410 = (g_object_unref (__temp410), NULL)));
			} else {
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* __temp411;
				ValaCCodeConstant* __temp412;
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
				__temp411 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp411 = vala_ccode_constant_new (vala_data_type_get_cname (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE)))));
				(__temp411 == NULL ? NULL : (__temp411 = (g_object_unref (__temp411), NULL)));
				__temp412 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp412 = vala_ccode_constant_new ("1"))));
				(__temp412 == NULL ? NULL : (__temp412 = (g_object_unref (__temp412), NULL)));
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			}
		}
	} else {
		ValaMethod* __temp413;
		ValaMethod* m;
		GList* params;
		ValaCCodeFunctionCall* ccall;
		gboolean ellipsis;
		gint i;
		GList* params_it;
		/* use creation method*/
		__temp413 = NULL;
		m = (__temp413 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp413 == NULL ? NULL : g_object_ref (__temp413)));
		params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (m))));
		if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			{
				GList* __temp416;
				GList* type_arg_it;
				__temp416 = NULL;
				__temp416 = vala_type_reference_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
				for (type_arg_it = __temp416; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg;
					type_arg = type_arg_it->data;
					{
						if (vala_type_reference_get_takes_ownership (type_arg)) {
							ValaCCodeExpression* __temp414;
							__temp414 = NULL;
							vala_ccode_function_call_add_argument (ccall, (__temp414 = vala_code_generator_get_destroy_func_expression (self, type_arg)));
							(__temp414 == NULL ? NULL : (__temp414 = (g_object_unref (__temp414), NULL)));
						} else {
							ValaCCodeConstant* __temp415;
							__temp415 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp415 = vala_ccode_constant_new ("NULL"))));
							(__temp415 == NULL ? NULL : (__temp415 = (g_object_unref (__temp415), NULL)));
						}
					}
				}
				(__temp416 == NULL ? NULL : (__temp416 = (g_list_free (__temp416), NULL)));
			}
		}
		ellipsis = FALSE;
		i = 1;
		params_it = params;
		{
			GList* __temp421;
			GList* arg_it;
			__temp421 = NULL;
			__temp421 = vala_object_creation_expression_get_argument_list (expr);
			for (arg_it = __temp421; arg_it != NULL; arg_it = arg_it->next) {
				ValaExpression* arg;
				arg = arg_it->data;
				{
					ValaCCodeExpression* __temp417;
					ValaCCodeExpression* cexpr;
					/* explicitly use strong reference as ccall gets
					 * unrefed at end of inner block
					 */
					__temp417 = NULL;
					cexpr = (__temp417 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (__temp417 == NULL ? NULL : g_object_ref (__temp417)));
					if (params_it != NULL) {
						ValaFormalParameter* __temp418;
						ValaFormalParameter* param;
						__temp418 = NULL;
						param = (__temp418 = VALA_FORMAL_PARAMETER (params_it->data), (__temp418 == NULL ? NULL : g_object_ref (__temp418)));
						ellipsis = vala_formal_parameter_get_ellipsis (param);
						if (!vala_formal_parameter_get_ellipsis (param) && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
							ValaCCodeFunctionCall* ccall;
							ValaCCodeExpression* __temp420;
							ValaCCodeFunctionCall* __temp419;
							/* FIXME: use C cast if debugging disabled*/
							ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL))));
							vala_ccode_function_call_add_argument (ccall, cexpr);
							__temp420 = NULL;
							__temp419 = NULL;
							cexpr = (__temp420 = VALA_CCODE_EXPRESSION ((__temp419 = ccall, (__temp419 == NULL ? NULL : g_object_ref (__temp419)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp420);
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
						}
						(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					}
					vala_ccode_function_call_add_argument (ccall, cexpr);
					i++;
					if (params_it != NULL) {
						params_it = params_it->next;
					}
					(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
				}
			}
			(__temp421 == NULL ? NULL : (__temp421 = (g_list_free (__temp421), NULL)));
		}
		while (params_it != NULL) {
			ValaFormalParameter* __temp422;
			ValaFormalParameter* param;
			__temp422 = NULL;
			param = (__temp422 = VALA_FORMAL_PARAMETER (params_it->data), (__temp422 == NULL ? NULL : g_object_ref (__temp422)));
			if (vala_formal_parameter_get_ellipsis (param)) {
				ellipsis = TRUE;
				break;
			}
			if (vala_formal_parameter_get_default_expression (param) == NULL) {
				char* __temp423;
				__temp423 = NULL;
				vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp423 = g_strdup_printf ("no default expression for argument %d", i)));
				(__temp423 = (g_free (__temp423), NULL));
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				return;
			}
			/* evaluate default expression here as the code
			 * generator might not have visited the formal
			 * parameter yet */
			vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
			i++;
			params_it = params_it->next;
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
		}
		if (ellipsis) {
			ValaCCodeConstant* __temp424;
			/* ensure variable argument list ends with NULL*/
			__temp424 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp424 = vala_ccode_constant_new ("NULL"))));
			(__temp424 == NULL ? NULL : (__temp424 = (g_object_unref (__temp424), NULL)));
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* __temp425;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIZEOF_EXPRESSION (expr));
	csizeof = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("sizeof")));
	__temp425 = NULL;
	vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((__temp425 = vala_ccode_identifier_new (vala_data_type_get_cname (vala_type_reference_get_data_type (vala_sizeof_expression_get_type_reference (expr)), FALSE)))));
	(__temp425 == NULL ? NULL : (__temp425 = (g_object_unref (__temp425), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csizeof)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
}


static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp426;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (expr));
	__temp426 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp426 = vala_ccode_identifier_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_typeof_expression_get_type_reference (expr))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp426 == NULL ? NULL : (__temp426 = (g_object_unref (__temp426), NULL)));
}


static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* __temp427;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_UNARY_EXPRESSION (expr));
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	__temp427 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp427 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp427 == NULL ? NULL : (__temp427 = (g_object_unref (__temp427), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (expr));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))) {
		ValaInstanceCast* __temp428;
		/* GObject cast*/
		__temp428 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp428 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp428 == NULL ? NULL : (__temp428 = (g_object_unref (__temp428), NULL)));
	} else {
		ValaCCodeCastExpression* __temp429;
		__temp429 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp429 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_type_reference_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp429 == NULL ? NULL : (__temp429 = (g_object_unref (__temp429), NULL)));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* __temp430;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (expr));
	__temp430 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp430 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_pointer_indirection_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp430 == NULL ? NULL : (__temp430 = (g_object_unref (__temp430), NULL)));
}


static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* __temp431;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (expr));
	__temp431 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp431 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_addressof_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp431 == NULL ? NULL : (__temp431 = (g_object_unref (__temp431), NULL)));
}


static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeCommaExpression* ccomma;
	ValaVariableDeclarator* temp_decl;
	ValaVariableDeclarator* __temp432;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* __temp433;
	ValaCCodeAssignment* __temp434;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
	__temp432 = NULL;
	self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp432 = temp_decl, (__temp432 == NULL ? NULL : g_object_ref (__temp432))));
	cvar = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
	__temp433 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp433 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp433 == NULL ? NULL : (__temp433 = (g_object_unref (__temp433), NULL)));
	__temp434 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp434 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp434 == NULL ? NULL : (__temp434 = (g_object_unref (__temp434), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeBinaryOperator op;
	ValaCCodeExpression* __temp435;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* __temp436;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryExpression* __temp441;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BINARY_EXPRESSION (expr));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	__temp435 = NULL;
	cleft = (__temp435 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_left (expr)))), (__temp435 == NULL ? NULL : g_object_ref (__temp435)));
	__temp436 = NULL;
	cright = (__temp436 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_right (expr)))), (__temp436 == NULL ? NULL : g_object_ref (__temp436)));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		if (vala_expression_get_static_type (vala_binary_expression_get_left (expr)) != NULL && vala_expression_get_static_type (vala_binary_expression_get_right (expr)) != NULL && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr))))) {
			ValaClass* __temp437;
			ValaClass* left_cl;
			ValaClass* __temp438;
			ValaClass* right_cl;
			__temp437 = NULL;
			left_cl = (__temp437 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (__temp437 == NULL ? NULL : g_object_ref (__temp437)));
			__temp438 = NULL;
			right_cl = (__temp438 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (__temp438 == NULL ? NULL : g_object_ref (__temp438)));
			if (left_cl != right_cl) {
				if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (left_cl), VALA_DATA_TYPE (right_cl))) {
					ValaCCodeExpression* __temp439;
					__temp439 = NULL;
					cleft = (__temp439 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_DATA_TYPE (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), __temp439);
				} else {
					if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (right_cl), VALA_DATA_TYPE (left_cl))) {
						ValaCCodeExpression* __temp440;
						__temp440 = NULL;
						cright = (__temp440 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_DATA_TYPE (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), __temp440);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		}
	}
	__temp441 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp441 = vala_ccode_binary_expression_new (op, cleft, cright)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp441 == NULL ? NULL : (__temp441 = (g_object_unref (__temp441), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* ccheck;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPE_CHECK (expr));
	ccheck = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_type_check_get_type_reference (expr)), "IS_"))));
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_type_check_get_expression (expr)))));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccheck)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConditionalExpression* __temp442;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (expr));
	__temp442 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp442 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_false_expression (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp442 == NULL ? NULL : (__temp442 = (g_object_unref (__temp442), NULL)));
}


static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp443;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (l));
	__temp443 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((__temp443 = vala_ccode_identifier_new (vala_method_get_cname (vala_lambda_expression_get_method (l)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (l)));
	(__temp443 == NULL ? NULL : (__temp443 = (g_object_unref (__temp443), NULL)));
}


static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ASSIGNMENT (a));
	ma = NULL;
	if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* __temp445;
		ValaMemberAccess* __temp444;
		__temp445 = NULL;
		__temp444 = NULL;
		ma = (__temp445 = (__temp444 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (__temp444 == NULL ? NULL : g_object_ref (__temp444))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp445);
	}
	if (vala_expression_get_symbol_reference (vala_assignment_get_left (a)) != NULL && VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a))))) {
		ValaProperty* __temp446;
		ValaProperty* prop;
		__temp446 = NULL;
		prop = (__temp446 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))), (__temp446 == NULL ? NULL : g_object_ref (__temp446)));
		if (self->priv->current_class != NULL && vala_member_access_get_inner (ma) == NULL && self->priv->in_creation_method) {
			ValaCCodeIdentifier* cpointer;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeMemberAccess* cnamemember;
			ValaCCodeAssignment* cnameassign;
			ValaCCodeUnaryExpression* gvaluearg;
			ValaCCodeFunctionCall* cvalueinit;
			ValaCCodeIdentifier* __temp447;
			ValaCCodeFunctionCall* cvalueset;
			ValaCCodeUnaryExpression* __temp448;
			/* this property is used as a construction parameter*/
			cpointer = vala_ccode_identifier_new ("__params_it");
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			/* set name in array for current parameter*/
			cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
			cnameassign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (vala_property_get_canonical_cconstant (prop)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
			gvaluearg = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")));
			/* initialize GValue in array for current parameter*/
			cvalueinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_init")));
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
			__temp447 = NULL;
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp447 = vala_ccode_identifier_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))))));
			(__temp447 == NULL ? NULL : (__temp447 = (g_object_unref (__temp447), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
			/* set GValue for current parameter*/
			cvalueset = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
			/* move pointer to next parameter in array*/
			__temp448 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp448 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
			(__temp448 == NULL ? NULL : (__temp448 = (g_object_unref (__temp448), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
			(cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL)));
			(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
			(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
			(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
		} else {
			ValaCCodeExpression* __temp449;
			ValaCCodeExpression* cexpr;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeCommaExpression* ccomma;
			__temp449 = NULL;
			cexpr = (__temp449 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))), (__temp449 == NULL ? NULL : g_object_ref (__temp449)));
			if (!vala_property_get_no_accessor_method (prop) && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a)))) {
				ValaCCodeFunctionCall* ccast;
				ValaCCodeExpression* __temp451;
				ValaCCodeFunctionCall* __temp450;
				/* cast is necessary */
				ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), NULL))));
				vala_ccode_function_call_add_argument (ccast, cexpr);
				__temp451 = NULL;
				__temp450 = NULL;
				cexpr = (__temp451 = VALA_CCODE_EXPRESSION ((__temp450 = ccast, (__temp450 == NULL ? NULL : g_object_ref (__temp450)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp451);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			if (vala_assignment_get_operator (a) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
				ValaCCodeBinaryOperator cop;
				ValaCCodeExpression* __temp452;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_BINARY_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_BINARY_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_BINARY_OPERATOR_MOD;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp452 = NULL;
				cexpr = (__temp452 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (cexpr)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp452);
			}
			ccall = vala_code_generator_get_property_set_call (self, prop, ma, cexpr);
			/* assignments are expressions, so return the current property value*/
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
			/* update property*/
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (ma))));
			/* current property value*/
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	} else {
		if (vala_expression_get_symbol_reference (vala_assignment_get_left (a)) != NULL && VALA_IS_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a))))) {
			ValaSignal* __temp453;
			ValaSignal* sig;
			ValaMethod* __temp454;
			ValaMethod* m;
			char* connect_func;
			gboolean disconnect;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeCastExpression* __temp471;
			__temp453 = NULL;
			sig = (__temp453 = VALA_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))), (__temp453 == NULL ? NULL : g_object_ref (__temp453)));
			__temp454 = NULL;
			m = (__temp454 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_right (a)))), (__temp454 == NULL ? NULL : g_object_ref (__temp454)));
			connect_func = NULL;
			disconnect = FALSE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
				char* __temp455;
				__temp455 = NULL;
				connect_func = (__temp455 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), __temp455);
				if (!vala_method_get_instance (m)) {
					char* __temp456;
					__temp456 = NULL;
					connect_func = (__temp456 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), __temp456);
				}
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
					char* __temp457;
					__temp457 = NULL;
					connect_func = (__temp457 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), __temp457);
					disconnect = TRUE;
				} else {
					(vala_code_node_set_error (VALA_CODE_NODE (a), TRUE), vala_code_node_get_error (VALA_CODE_NODE (a)));
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (a)), "Specified compound assignment type for signals not supported.");
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(connect_func = (g_free (connect_func), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					return;
				}
			}
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (connect_func)));
			if (vala_member_access_get_inner (ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
			} else {
				ValaCCodeIdentifier* __temp458;
				__temp458 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp458 = vala_ccode_identifier_new ("self"))));
				(__temp458 == NULL ? NULL : (__temp458 = (g_object_unref (__temp458), NULL)));
			}
			if (!disconnect) {
				ValaCCodeConstant* __temp459;
				__temp459 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp459 = vala_signal_get_canonical_cconstant (sig))));
				(__temp459 = (g_object_unref (__temp459), NULL));
			} else {
				ValaCCodeConstant* __temp460;
				ValaCCodeCommaExpression* ccomma;
				ValaVariableDeclarator* temp_decl;
				ValaVariableDeclarator* __temp461;
				ValaCCodeFunctionCall* parse_call;
				ValaCCodeConstant* __temp462;
				ValaDataType* __temp463;
				ValaDataType* decl_type;
				ValaCCodeIdentifier* __temp464;
				ValaCCodeUnaryExpression* __temp465;
				ValaCCodeConstant* __temp466;
				ValaCCodeConstant* __temp467;
				ValaCCodeIdentifier* __temp468;
				ValaCCodeConstant* __temp469;
				ValaCCodeConstant* __temp470;
				__temp460 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp460 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
				(__temp460 == NULL ? NULL : (__temp460 = (g_object_unref (__temp460), NULL)));
				/* get signal id*/
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->uint_type, TRUE);
				__temp461 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp461 = temp_decl, (__temp461 == NULL ? NULL : g_object_ref (__temp461))));
				parse_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_parse_name")));
				__temp462 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp462 = vala_signal_get_canonical_cconstant (sig))));
				(__temp462 = (g_object_unref (__temp462), NULL));
				__temp463 = NULL;
				decl_type = (__temp463 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (sig))))), (__temp463 == NULL ? NULL : g_object_ref (__temp463)));
				__temp464 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp464 = vala_ccode_identifier_new (vala_data_type_get_type_id (decl_type)))));
				(__temp464 == NULL ? NULL : (__temp464 = (g_object_unref (__temp464), NULL)));
				__temp465 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp465 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))))));
				(__temp465 == NULL ? NULL : (__temp465 = (g_object_unref (__temp465), NULL)));
				__temp466 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp466 = vala_ccode_constant_new ("NULL"))));
				(__temp466 == NULL ? NULL : (__temp466 = (g_object_unref (__temp466), NULL)));
				__temp467 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp467 = vala_ccode_constant_new ("FALSE"))));
				(__temp467 == NULL ? NULL : (__temp467 = (g_object_unref (__temp467), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
				__temp468 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp468 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
				(__temp468 == NULL ? NULL : (__temp468 = (g_object_unref (__temp468), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
				__temp469 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp469 = vala_ccode_constant_new ("0"))));
				(__temp469 == NULL ? NULL : (__temp469 = (g_object_unref (__temp469), NULL)));
				__temp470 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp470 = vala_ccode_constant_new ("NULL"))));
				(__temp470 == NULL ? NULL : (__temp470 = (g_object_unref (__temp470), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
				(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
			}
			__temp471 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp471 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (m))), "GCallback"))));
			(__temp471 == NULL ? NULL : (__temp471 = (g_object_unref (__temp471), NULL)));
			if (vala_method_get_instance (m)) {
				if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (a))) {
					ValaMemberAccess* __temp472;
					ValaMemberAccess* right_ma;
					__temp472 = NULL;
					right_ma = (__temp472 = VALA_MEMBER_ACCESS (vala_assignment_get_right (a)), (__temp472 == NULL ? NULL : g_object_ref (__temp472)));
					if (vala_member_access_get_inner (right_ma) != NULL) {
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (right_ma)))));
					} else {
						ValaCCodeIdentifier* __temp473;
						__temp473 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp473 = vala_ccode_identifier_new ("self"))));
						(__temp473 == NULL ? NULL : (__temp473 = (g_object_unref (__temp473), NULL)));
					}
					(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
				} else {
					if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (a))) {
						ValaCCodeIdentifier* __temp474;
						__temp474 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp474 = vala_ccode_identifier_new ("self"))));
						(__temp474 == NULL ? NULL : (__temp474 = (g_object_unref (__temp474), NULL)));
					}
				}
				if (!disconnect) {
					ValaCCodeConstant* __temp475;
					__temp475 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp475 = vala_ccode_constant_new ("0"))));
					(__temp475 == NULL ? NULL : (__temp475 = (g_object_unref (__temp475), NULL)));
				}
			} else {
				ValaCCodeConstant* __temp476;
				__temp476 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp476 = vala_ccode_constant_new ("NULL"))));
				(__temp476 == NULL ? NULL : (__temp476 = (g_object_unref (__temp476), NULL)));
			}
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(connect_func = (g_free (connect_func), NULL));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			ValaCCodeExpression* __temp477;
			ValaCCodeExpression* rhs;
			gboolean unref_old;
			gboolean array;
			ValaCCodeAssignmentOperator cop;
			ValaCCodeAssignment* __temp487;
			/* explicitly use strong reference as ccast gets
			 * unrefed at end of inner block
			 */
			__temp477 = NULL;
			rhs = (__temp477 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))), (__temp477 == NULL ? NULL : g_object_ref (__temp477)));
			if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
				ValaCCodeFunctionCall* ccast;
				ValaCCodeExpression* __temp479;
				ValaCCodeFunctionCall* __temp478;
				ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL))));
				vala_ccode_function_call_add_argument (ccast, rhs);
				__temp479 = NULL;
				__temp478 = NULL;
				rhs = (__temp479 = VALA_CCODE_EXPRESSION ((__temp478 = ccast, (__temp478 == NULL ? NULL : g_object_ref (__temp478)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp479);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			unref_old = (vala_code_generator_get_memory_management (self) && vala_type_reference_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (a))));
			array = FALSE;
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))))) {
				array = !(VALA_IS_CCODE_CONSTANT (vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1)));
			}
			if (unref_old || array) {
				ValaCCodeCommaExpression* ccomma;
				ValaVariableDeclarator* temp_decl;
				ValaVariableDeclarator* __temp480;
				ValaCCodeAssignment* __temp481;
				ValaCCodeIdentifier* __temp484;
				ValaCCodeExpression* __temp486;
				ValaCCodeCommaExpression* __temp485;
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_assignment_get_left (a)), TRUE);
				__temp480 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp480 = temp_decl, (__temp480 == NULL ? NULL : g_object_ref (__temp480))));
				__temp481 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp481 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
				(__temp481 == NULL ? NULL : (__temp481 = (g_object_unref (__temp481), NULL)));
				if (unref_old) {
					ValaCCodeExpression* __temp482;
					/* unref old value */
					__temp482 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp482 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), vala_expression_get_static_type (vala_assignment_get_left (a)))));
					(__temp482 == NULL ? NULL : (__temp482 = (g_object_unref (__temp482), NULL)));
				}
				if (array) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* __temp483;
					lhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1);
					rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_right (a), 1);
					__temp483 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp483 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp483 == NULL ? NULL : (__temp483 = (g_object_unref (__temp483), NULL)));
					(lhs_array_len = (g_object_unref (lhs_array_len), NULL));
					(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
				}
				__temp484 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp484 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
				(__temp484 == NULL ? NULL : (__temp484 = (g_object_unref (__temp484), NULL)));
				__temp486 = NULL;
				__temp485 = NULL;
				rhs = (__temp486 = VALA_CCODE_EXPRESSION ((__temp485 = ccomma, (__temp485 == NULL ? NULL : g_object_ref (__temp485)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp486);
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			}
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			__temp487 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE ((__temp487 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), rhs, cop)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(__temp487 == NULL ? NULL : (__temp487 = (g_object_unref (__temp487), NULL)));
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr)
{
	ValaClass* __temp488;
	ValaClass* cl;
	char* set_func;
	ValaProperty* base_property;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* instance;
	gboolean req_cast;
	ValaCCodeFunctionCall* __temp503;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	__temp488 = NULL;
	cl = (__temp488 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))))), (__temp488 == NULL ? NULL : g_object_ref (__temp488)));
	set_func = g_strdup ("g_object_set");
	base_property = g_object_ref (prop);
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaDataType* __temp493;
		ValaDataType* base_property_type;
		char* __temp495;
		char* __temp494;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* __temp490;
			ValaProperty* __temp489;
			__temp490 = NULL;
			__temp489 = NULL;
			base_property = (__temp490 = (__temp489 = vala_property_get_base_property (prop), (__temp489 == NULL ? NULL : g_object_ref (__temp489))), (base_property = (g_object_unref (base_property), NULL)), __temp490);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* __temp492;
				ValaProperty* __temp491;
				__temp492 = NULL;
				__temp491 = NULL;
				base_property = (__temp492 = (__temp491 = vala_property_get_base_interface_property (prop), (__temp491 == NULL ? NULL : g_object_ref (__temp491))), (base_property = (g_object_unref (base_property), NULL)), __temp492);
			}
		}
		__temp493 = NULL;
		base_property_type = (__temp493 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))))), (__temp493 == NULL ? NULL : g_object_ref (__temp493)));
		__temp495 = NULL;
		__temp494 = NULL;
		set_func = (__temp495 = g_strdup_printf ("%s_set_%s", (__temp494 = vala_data_type_get_lower_case_cname (base_property_type, NULL)), vala_property_get_name (base_property)), (set_func = (g_free (set_func), NULL)), __temp495);
		(__temp494 = (g_free (__temp494), NULL));
		(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
	}
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (set_func)));
	/* target instance is first argument */
	instance = NULL;
	req_cast = FALSE;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* __temp496;
		__temp496 = NULL;
		instance = (__temp496 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp496);
		/* require casts for inherited properties */
		req_cast = (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))) != self->priv->current_type_symbol);
	} else {
		ValaCCodeExpression* __temp498;
		ValaCCodeExpression* __temp497;
		__temp498 = NULL;
		__temp497 = NULL;
		instance = (__temp498 = (__temp497 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp497 == NULL ? NULL : g_object_ref (__temp497))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp498);
		/* require casts if the type of the used instance is
		 * different than the type which declared the property */
		req_cast = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property)))) != VALA_CODE_NODE (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
	}
	if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop)))))))) {
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpression* __temp500;
		ValaCCodeFunctionCall* __temp499;
		ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property)))))), NULL))));
		vala_ccode_function_call_add_argument (ccast, instance);
		__temp500 = NULL;
		__temp499 = NULL;
		instance = (__temp500 = VALA_CCODE_EXPRESSION ((__temp499 = ccast, (__temp499 == NULL ? NULL : g_object_ref (__temp499)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp500);
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp501;
		/* property name is second argument of g_object_set */
		__temp501 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp501 = vala_property_get_canonical_cconstant (prop))));
		(__temp501 = (g_object_unref (__temp501), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp502;
		__temp502 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp502 = vala_ccode_constant_new ("NULL"))));
		(__temp502 == NULL ? NULL : (__temp502 = (g_object_unref (__temp502), NULL)));
	}
	__temp503 = NULL;
	return (__temp503 = ccall, (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), (set_func = (g_free (set_func), NULL)), (base_property = (g_object_unref (base_property), NULL)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp503);
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(set_func = (g_free (set_func), NULL));
	(base_property = (g_object_unref (base_property), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp505;
	ValaSymbol* __temp504;
	ValaSymbol* __temp507;
	ValaSymbol* __temp506;
	ValaClass* __temp508;
	ValaCCodeStruct* __temp510;
	char* __temp509;
	ValaCCodeStruct* __temp512;
	char* __temp511;
	ValaCCodeStruct* __temp514;
	char* __temp513;
	ValaCCodeEnum* __temp515;
	char* __temp517;
	char* __temp516;
	ValaCCodeFragment* __temp518;
	ValaCCodeFragment* __temp519;
	ValaCCodeNewline* __temp520;
	char* __temp521;
	char* __temp522;
	char* macro;
	ValaCCodeMacroReplacement* __temp523;
	char* __temp526;
	char* __temp525;
	char* __temp524;
	ValaCCodeMacroReplacement* __temp528;
	char* __temp527;
	char* __temp531;
	char* __temp530;
	char* __temp529;
	ValaCCodeMacroReplacement* __temp533;
	char* __temp532;
	char* __temp535;
	char* __temp534;
	ValaCCodeMacroReplacement* __temp537;
	char* __temp536;
	char* __temp539;
	char* __temp538;
	ValaCCodeMacroReplacement* __temp541;
	char* __temp540;
	char* __temp544;
	char* __temp543;
	char* __temp542;
	ValaCCodeMacroReplacement* __temp546;
	char* __temp545;
	ValaCCodeNewline* __temp547;
	ValaCCodeTypeDefinition* __temp552;
	char* __temp551;
	char* __temp553;
	char* __temp555;
	char* __temp554;
	char* __temp557;
	char* __temp556;
	ValaSymbol* __temp573;
	ValaClass* __temp574;
	ValaCCodeFragment* __temp575;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp505 = NULL;
	__temp504 = NULL;
	self->priv->current_symbol = (__temp505 = (__temp504 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp504 == NULL ? NULL : g_object_ref (__temp504))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp505);
	__temp507 = NULL;
	__temp506 = NULL;
	self->priv->current_type_symbol = (__temp507 = (__temp506 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp506 == NULL ? NULL : g_object_ref (__temp506))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp507);
	__temp508 = NULL;
	self->priv->current_class = (__temp508 = g_object_ref (cl), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp508);
	if (vala_class_get_is_static (cl)) {
		return;
	}
	__temp510 = NULL;
	__temp509 = NULL;
	self->priv->instance_struct = (__temp510 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp509 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp510);
	(__temp509 = (g_free (__temp509), NULL));
	__temp512 = NULL;
	__temp511 = NULL;
	self->priv->type_struct = (__temp512 = vala_ccode_struct_new (g_strdup_printf ("_%sClass", (__temp511 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp512);
	(__temp511 = (g_free (__temp511), NULL));
	__temp514 = NULL;
	__temp513 = NULL;
	self->priv->instance_priv_struct = (__temp514 = vala_ccode_struct_new (g_strdup_printf ("_%sPrivate", (__temp513 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), __temp514);
	(__temp513 = (g_free (__temp513), NULL));
	__temp515 = NULL;
	self->priv->prop_enum = (__temp515 = vala_ccode_enum_new (NULL), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), __temp515);
	__temp517 = NULL;
	__temp516 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp517 = g_strdup_printf ("%s_DUMMY_PROPERTY", (__temp516 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), NULL);
	(__temp517 = (g_free (__temp517), NULL));
	(__temp516 = (g_free (__temp516), NULL));
	__temp518 = NULL;
	self->priv->instance_init_fragment = (__temp518 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), __temp518);
	__temp519 = NULL;
	self->priv->instance_dispose_fragment = (__temp519 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp519);
	__temp520 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp520 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp520 == NULL ? NULL : (__temp520 = (g_object_unref (__temp520), NULL)));
	__temp521 = NULL;
	__temp522 = NULL;
	macro = (__temp522 = g_strdup_printf ("(%s_get_type ())", (__temp521 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), (__temp521 = (g_free (__temp521), NULL)), __temp522);
	__temp523 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp523 = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"), macro))));
	(__temp523 == NULL ? NULL : (__temp523 = (g_object_unref (__temp523), NULL)));
	__temp526 = NULL;
	__temp525 = NULL;
	__temp524 = NULL;
	macro = (__temp526 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp524 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp525 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp526);
	(__temp525 = (g_free (__temp525), NULL));
	(__temp524 = (g_free (__temp524), NULL));
	__temp528 = NULL;
	__temp527 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp528 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp527 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp528 == NULL ? NULL : (__temp528 = (g_object_unref (__temp528), NULL)));
	(__temp527 = (g_free (__temp527), NULL));
	__temp531 = NULL;
	__temp530 = NULL;
	__temp529 = NULL;
	macro = (__temp531 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (__temp529 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp530 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp531);
	(__temp530 = (g_free (__temp530), NULL));
	(__temp529 = (g_free (__temp529), NULL));
	__temp533 = NULL;
	__temp532 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp533 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_CLASS(klass)", (__temp532 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp533 == NULL ? NULL : (__temp533 = (g_object_unref (__temp533), NULL)));
	(__temp532 = (g_free (__temp532), NULL));
	__temp535 = NULL;
	__temp534 = NULL;
	macro = (__temp535 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp534 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp535);
	(__temp534 = (g_free (__temp534), NULL));
	__temp537 = NULL;
	__temp536 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp537 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp536 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_"))), macro))));
	(__temp537 == NULL ? NULL : (__temp537 = (g_object_unref (__temp537), NULL)));
	(__temp536 = (g_free (__temp536), NULL));
	__temp539 = NULL;
	__temp538 = NULL;
	macro = (__temp539 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (__temp538 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp539);
	(__temp538 = (g_free (__temp538), NULL));
	__temp541 = NULL;
	__temp540 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp541 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_CLASS(klass)", (__temp540 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_"))), macro))));
	(__temp541 == NULL ? NULL : (__temp541 = (g_object_unref (__temp541), NULL)));
	(__temp540 = (g_free (__temp540), NULL));
	__temp544 = NULL;
	__temp543 = NULL;
	__temp542 = NULL;
	macro = (__temp544 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (__temp542 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp543 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp544);
	(__temp543 = (g_free (__temp543), NULL));
	(__temp542 = (g_free (__temp542), NULL));
	__temp546 = NULL;
	__temp545 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp546 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_CLASS(obj)", (__temp545 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp546 == NULL ? NULL : (__temp546 = (g_object_unref (__temp546), NULL)));
	(__temp545 = (g_free (__temp545), NULL));
	__temp547 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp547 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp547 == NULL ? NULL : (__temp547 = (g_object_unref (__temp547), NULL)));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))) == NULL) {
		ValaCCodeTypeDefinition* __temp548;
		ValaCCodeTypeDefinition* __temp550;
		char* __temp549;
		__temp548 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp548 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
		(__temp548 == NULL ? NULL : (__temp548 = (g_object_unref (__temp548), NULL)));
		__temp550 = NULL;
		__temp549 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp550 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sClass", (__temp549 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
		(__temp550 == NULL ? NULL : (__temp550 = (g_object_unref (__temp550), NULL)));
		(__temp549 = (g_free (__temp549), NULL));
	}
	__temp552 = NULL;
	__temp551 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp552 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_priv_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sPrivate", (__temp551 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
	(__temp552 == NULL ? NULL : (__temp552 = (g_object_unref (__temp552), NULL)));
	(__temp551 = (g_free (__temp551), NULL));
	__temp553 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp553 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)), "parent");
	(__temp553 = (g_free (__temp553), NULL));
	__temp555 = NULL;
	__temp554 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp555 = g_strdup_printf ("%sPrivate *", (__temp554 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), "priv");
	(__temp555 = (g_free (__temp555), NULL));
	(__temp554 = (g_free (__temp554), NULL));
	__temp557 = NULL;
	__temp556 = NULL;
	vala_ccode_struct_add_field (self->priv->type_struct, (__temp557 = g_strdup_printf ("%sClass", (__temp556 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)))), "parent");
	(__temp557 = (g_free (__temp557), NULL));
	(__temp556 = (g_free (__temp556), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl))) != NULL) {
		ValaCCodeComment* __temp558;
		__temp558 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp558 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))))));
		(__temp558 == NULL ? NULL : (__temp558 = (g_object_unref (__temp558), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
	/* only add the *Private struct if it is not empty, i.e. we actually have private data */
	if (vala_class_get_has_private_fields (cl)) {
		char* __temp561;
		char* __temp560;
		char* __temp559;
		ValaCCodeMacroReplacement* __temp563;
		char* __temp562;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->instance_priv_struct));
		__temp561 = NULL;
		__temp560 = NULL;
		__temp559 = NULL;
		macro = (__temp561 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (__temp559 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp560 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp561);
		(__temp560 = (g_free (__temp560), NULL));
		(__temp559 = (g_free (__temp559), NULL));
		__temp563 = NULL;
		__temp562 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp563 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_PRIVATE(o)", (__temp562 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
		(__temp563 == NULL ? NULL : (__temp563 = (g_object_unref (__temp563), NULL)));
		(__temp562 = (g_free (__temp562), NULL));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->prop_enum));
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	if (!vala_class_get_is_static (cl)) {
		GList* __temp565;
		gboolean __temp566;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* __temp567;
		ValaCCodeFragment* __temp568;
		if (vala_code_generator_class_has_readable_properties (self, cl)) {
			vala_code_generator_add_get_property_function (self, cl);
		}
		if (vala_code_generator_class_has_writable_properties (self, cl)) {
			vala_code_generator_add_set_property_function (self, cl);
		}
		vala_code_generator_add_class_init_function (self, cl);
		{
			GList* __temp564;
			GList* base_type_it;
			__temp564 = NULL;
			__temp564 = vala_class_get_base_types (cl);
			for (base_type_it = __temp564; base_type_it != NULL; base_type_it = base_type_it->next) {
				ValaTypeReference* base_type;
				base_type = base_type_it->data;
				{
					if (VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type))) {
						vala_code_generator_add_interface_init_function (self, cl, VALA_INTERFACE (vala_type_reference_get_data_type (base_type)));
					}
				}
			}
			(__temp564 == NULL ? NULL : (__temp564 = (g_list_free (__temp564), NULL)));
		}
		vala_code_generator_add_instance_init_function (self, cl);
		__temp565 = NULL;
		if ((__temp566 = vala_code_generator_get_memory_management (self) && (__temp565 = vala_class_get_fields (cl)) != NULL, (__temp565 == NULL ? NULL : (__temp565 = (g_list_free (__temp565), NULL))), __temp566)) {
			vala_code_generator_add_dispose_function (self, cl);
		}
		type_fun = vala_class_register_function_new (cl);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), self->priv->in_plugin);
		__temp567 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp567 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp567 = (g_object_unref (__temp567), NULL));
		__temp568 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp568 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp568 = (g_object_unref (__temp568), NULL));
		if (self->priv->in_plugin) {
			char* __temp569;
			ValaCCodeFunctionCall* __temp570;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* __temp571;
			ValaCCodeExpressionStatement* __temp572;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			__temp569 = NULL;
			__temp570 = NULL;
			register_call = (__temp570 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_register_type", (__temp569 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp569 = (g_free (__temp569), NULL)), __temp570);
			__temp571 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((__temp571 = vala_ccode_identifier_new (self->priv->module_init_param_name))));
			(__temp571 == NULL ? NULL : (__temp571 = (g_object_unref (__temp571), NULL)));
			__temp572 = NULL;
			vala_ccode_fragment_append (self->priv->module_init_fragment, VALA_CCODE_NODE ((__temp572 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(__temp572 == NULL ? NULL : (__temp572 = (g_object_unref (__temp572), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	__temp573 = NULL;
	self->priv->current_type_symbol = (__temp573 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp573);
	__temp574 = NULL;
	self->priv->current_class = (__temp574 = NULL, (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp574);
	__temp575 = NULL;
	self->priv->instance_dispose_fragment = (__temp575 = NULL, (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp575);
	(macro = (g_free (macro), NULL));
}


static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp576;
	ValaCCodeFunction* __temp577;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* __temp579;
	char* __temp578;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* __temp580;
	ValaCCodeVariableDeclarator* __temp581;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* __temp582;
	ValaCCodeFunctionCall* __temp583;
	ValaCCodeIdentifier* __temp584;
	char* __temp585;
	ValaCCodeAssignment* __temp586;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* __temp587;
	ValaCCodeFunctionCall* __temp593;
	ValaCCodeIdentifier* __temp594;
	GList* __temp602;
	gboolean __temp603;
	GList* methods;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp576 = NULL;
	__temp577 = NULL;
	class_init = (__temp577 = vala_ccode_function_new (g_strdup_printf ("%s_class_init", (__temp576 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp576 = (g_free (__temp576), NULL)), __temp577);
	__temp579 = NULL;
	__temp578 = NULL;
	vala_ccode_function_add_parameter (class_init, (__temp579 = vala_ccode_formal_parameter_new ("klass", g_strdup_printf ("%sClass *", (__temp578 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
	(__temp579 == NULL ? NULL : (__temp579 = (g_object_unref (__temp579), NULL)));
	(__temp578 = (g_free (__temp578), NULL));
	(vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (class_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (class_init, init_block), vala_ccode_function_get_block (class_init));
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	__temp580 = NULL;
	__temp581 = NULL;
	parent_var_decl = (__temp581 = vala_ccode_variable_declarator_new (g_strdup_printf ("%s_parent_class", (__temp580 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)))), (__temp580 = (g_free (__temp580), NULL)), __temp581);
	__temp582 = NULL;
	(vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp582 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (parent_var_decl));
	(__temp582 == NULL ? NULL : (__temp582 = (g_object_unref (__temp582), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	(vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (parent_decl));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	__temp583 = NULL;
	ccall = (__temp583 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp583);
	__temp584 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp584 = vala_ccode_identifier_new ("klass"))));
	(__temp584 == NULL ? NULL : (__temp584 = (g_object_unref (__temp584), NULL)));
	__temp585 = NULL;
	__temp586 = NULL;
	parent_assignment = (__temp586 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_parent_class", (__temp585 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp585 = (g_free (__temp585), NULL)), __temp586);
	__temp587 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp587 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp587 == NULL ? NULL : (__temp587 = (g_object_unref (__temp587), NULL)));
	/* add struct for private fields */
	if (vala_class_get_has_private_fields (cl)) {
		ValaCCodeFunctionCall* __temp588;
		ValaCCodeIdentifier* __temp589;
		ValaCCodeConstant* __temp591;
		char* __temp590;
		ValaCCodeExpressionStatement* __temp592;
		__temp588 = NULL;
		ccall = (__temp588 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_add_private"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp588);
		__temp589 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp589 = vala_ccode_identifier_new ("klass"))));
		(__temp589 == NULL ? NULL : (__temp589 = (g_object_unref (__temp589), NULL)));
		__temp591 = NULL;
		__temp590 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp591 = vala_ccode_constant_new (g_strdup_printf ("sizeof (%sPrivate)", (__temp590 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
		(__temp591 == NULL ? NULL : (__temp591 = (g_object_unref (__temp591), NULL)));
		(__temp590 = (g_free (__temp590), NULL));
		__temp592 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp592 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(__temp592 == NULL ? NULL : (__temp592 = (g_object_unref (__temp592), NULL)));
	}
	/* set property handlers */
	__temp593 = NULL;
	ccall = (__temp593 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp593);
	__temp594 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp594 = vala_ccode_identifier_new ("klass"))));
	(__temp594 == NULL ? NULL : (__temp594 = (g_object_unref (__temp594), NULL)));
	if (vala_code_generator_class_has_readable_properties (self, cl)) {
		ValaCCodeExpressionStatement* __temp596;
		char* __temp595;
		__temp596 = NULL;
		__temp595 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp596 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_property", (__temp595 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp596 == NULL ? NULL : (__temp596 = (g_object_unref (__temp596), NULL)));
		(__temp595 = (g_free (__temp595), NULL));
	}
	if (vala_code_generator_class_has_writable_properties (self, cl)) {
		ValaCCodeExpressionStatement* __temp598;
		char* __temp597;
		__temp598 = NULL;
		__temp597 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp598 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_set_property", (__temp597 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp598 == NULL ? NULL : (__temp598 = (g_object_unref (__temp598), NULL)));
		(__temp597 = (g_free (__temp597), NULL));
	}
	/* set constructor */
	if (vala_class_get_constructor (cl) != NULL) {
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* __temp599;
		ValaCCodeExpressionStatement* __temp601;
		char* __temp600;
		ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS")));
		__temp599 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp599 = vala_ccode_identifier_new ("klass"))));
		(__temp599 == NULL ? NULL : (__temp599 = (g_object_unref (__temp599), NULL)));
		__temp601 = NULL;
		__temp600 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp601 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_constructor", (__temp600 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp601 == NULL ? NULL : (__temp601 = (g_object_unref (__temp601), NULL)));
		(__temp600 = (g_free (__temp600), NULL));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* set dispose function */
	__temp602 = NULL;
	if ((__temp603 = vala_code_generator_get_memory_management (self) && (__temp602 = vala_class_get_fields (cl)) != NULL, (__temp602 == NULL ? NULL : (__temp602 = (g_list_free (__temp602), NULL))), __temp603)) {
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* __temp604;
		ValaCCodeExpressionStatement* __temp606;
		char* __temp605;
		ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS")));
		__temp604 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp604 = vala_ccode_identifier_new ("klass"))));
		(__temp604 == NULL ? NULL : (__temp604 = (g_object_unref (__temp604), NULL)));
		__temp606 = NULL;
		__temp605 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp606 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_dispose", (__temp605 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp606 == NULL ? NULL : (__temp606 = (g_object_unref (__temp606), NULL)));
		(__temp605 = (g_free (__temp605), NULL));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* connect overridden methods */
	methods = vala_class_get_methods (cl);
	{
		GList* __temp612;
		GList* m_it;
		__temp612 = NULL;
		__temp612 = methods;
		for (m_it = __temp612; m_it != NULL; m_it = m_it->next) {
			ValaMethod* m;
			m = m_it->data;
			{
				ValaCodeNode* __temp607;
				ValaCodeNode* base_type;
				char* __temp608;
				ValaCCodeFunctionCall* __temp609;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* __temp610;
				ValaCCodeExpressionStatement* __temp611;
				if (vala_method_get_base_method (m) == NULL) {
					continue;
				}
				__temp607 = NULL;
				base_type = (__temp607 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m))))), (__temp607 == NULL ? NULL : g_object_ref (__temp607)));
				__temp608 = NULL;
				__temp609 = NULL;
				ccast = (__temp609 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp608 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE ((VALA_CLASS (base_type))), NULL)))))), (__temp608 = (g_free (__temp608), NULL)), __temp609);
				__temp610 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp610 = vala_ccode_identifier_new ("klass"))));
				(__temp610 == NULL ? NULL : (__temp610 = (g_object_unref (__temp610), NULL)));
				__temp611 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp611 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_name (m))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp611 == NULL ? NULL : (__temp611 = (g_object_unref (__temp611), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
	}
	{
		GList* __temp625;
		GList* type_param_it;
		__temp625 = NULL;
		__temp625 = vala_class_get_type_parameters (cl);
		for (type_param_it = __temp625; type_param_it != NULL; type_param_it = type_param_it->next) {
			ValaTypeParameter* type_param;
			type_param = type_param_it->data;
			{
				char* __temp613;
				char* __temp614;
				char* func_name;
				char* __temp615;
				ValaCCodeConstant* __temp616;
				ValaCCodeConstant* func_name_constant;
				char* __temp618;
				char* __temp617;
				char* __temp619;
				char* enum_value;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeConstant* __temp620;
				ValaCCodeFunctionCall* cspec;
				ValaCCodeConstant* __temp621;
				ValaCCodeConstant* __temp622;
				ValaCCodeConstant* __temp623;
				ValaCCodeExpressionStatement* __temp624;
				/* create destroy_func properties for generic types */
				__temp613 = NULL;
				__temp614 = NULL;
				func_name = (__temp614 = g_strdup_printf ("%s_destroy_func", (__temp613 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp613 = (g_free (__temp613), NULL)), __temp614);
				__temp615 = NULL;
				__temp616 = NULL;
				func_name_constant = (__temp616 = vala_ccode_constant_new (g_strdup_printf ("\"%s-destroy-func\"", (__temp615 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1)))), (__temp615 = (g_free (__temp615), NULL)), __temp616);
				__temp618 = NULL;
				__temp617 = NULL;
				__temp619 = NULL;
				enum_value = (__temp619 = g_utf8_strup ((__temp618 = g_strdup_printf ("%s_%s", (__temp617 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), func_name)), -1), (__temp618 = (g_free (__temp618), NULL)), (__temp617 = (g_free (__temp617), NULL)), __temp619);
				cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_install_property")));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				__temp620 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp620 = vala_ccode_constant_new (enum_value))));
				(__temp620 == NULL ? NULL : (__temp620 = (g_object_unref (__temp620), NULL)));
				cspec = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_param_spec_pointer")));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				__temp621 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp621 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp621 == NULL ? NULL : (__temp621 = (g_object_unref (__temp621), NULL)));
				__temp622 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp622 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp622 == NULL ? NULL : (__temp622 = (g_object_unref (__temp622), NULL)));
				__temp623 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp623 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
				(__temp623 == NULL ? NULL : (__temp623 = (g_object_unref (__temp623), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				__temp624 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp624 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp624 == NULL ? NULL : (__temp624 = (g_object_unref (__temp624), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GDestroyNotify", func_name);
				(func_name = (g_free (func_name), NULL));
				(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
				(enum_value = (g_free (enum_value), NULL));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
			}
		}
		(__temp625 == NULL ? NULL : (__temp625 = (g_list_free (__temp625), NULL)));
	}
	/* create properties */
	props = vala_class_get_properties (cl);
	{
		GList* __temp632;
		GList* prop_it;
		__temp632 = NULL;
		__temp632 = props;
		for (prop_it = __temp632; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* __temp626;
					ValaCCodeConstant* __temp627;
					ValaCCodeExpressionStatement* __temp628;
					cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_override_property")));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					__temp626 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp626 = vala_ccode_constant_new (vala_property_get_upper_case_cname (prop)))));
					(__temp626 == NULL ? NULL : (__temp626 = (g_object_unref (__temp626), NULL)));
					__temp627 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp627 = vala_property_get_canonical_cconstant (prop))));
					(__temp627 = (g_object_unref (__temp627), NULL));
					__temp628 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp628 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp628 == NULL ? NULL : (__temp628 = (g_object_unref (__temp628), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				} else {
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* __temp629;
					ValaCCodeFunctionCall* __temp630;
					ValaCCodeExpressionStatement* __temp631;
					cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_install_property")));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					__temp629 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp629 = vala_ccode_constant_new (vala_property_get_upper_case_cname (prop)))));
					(__temp629 == NULL ? NULL : (__temp629 = (g_object_unref (__temp629), NULL)));
					__temp630 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp630 = vala_code_generator_get_param_spec (self, prop))));
					(__temp630 = (g_object_unref (__temp630), NULL));
					__temp631 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp631 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp631 == NULL ? NULL : (__temp631 = (g_object_unref (__temp631), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				}
			}
		}
	}
	{
		GList* __temp634;
		GList* sig_it;
		__temp634 = NULL;
		__temp634 = vala_class_get_signals (cl);
		for (sig_it = __temp634; sig_it != NULL; sig_it = sig_it->next) {
			ValaSignal* sig;
			sig = sig_it->data;
			{
				ValaCCodeExpressionStatement* __temp633;
				/* create signals */
				__temp633 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp633 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (cl)))))));
				(__temp633 == NULL ? NULL : (__temp633 = (g_object_unref (__temp633), NULL)));
			}
		}
		(__temp634 == NULL ? NULL : (__temp634 = (g_list_free (__temp634), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(methods == NULL ? NULL : (methods = (g_list_free (methods), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface)
{
	char* __temp636;
	char* __temp635;
	ValaCCodeFunction* __temp637;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* __temp639;
	char* __temp638;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* __temp641;
	char* __temp640;
	char* __temp642;
	char* parent_iface_var;
	char* __temp643;
	ValaCCodeDeclaration* __temp644;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* __temp645;
	ValaCCodeFunctionCall* __temp646;
	ValaCCodeIdentifier* __temp647;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* __temp648;
	GList* methods;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp636 = NULL;
	__temp635 = NULL;
	__temp637 = NULL;
	iface_init = (__temp637 = vala_ccode_function_new (g_strdup_printf ("%s_%s_interface_init", (__temp635 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), (__temp636 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), "void"), (__temp636 = (g_free (__temp636), NULL)), (__temp635 = (g_free (__temp635), NULL)), __temp637);
	__temp639 = NULL;
	__temp638 = NULL;
	vala_ccode_function_add_parameter (iface_init, (__temp639 = vala_ccode_formal_parameter_new ("iface", g_strdup_printf ("%s *", (__temp638 = vala_interface_get_type_cname (iface))))));
	(__temp639 == NULL ? NULL : (__temp639 = (g_object_unref (__temp639), NULL)));
	(__temp638 = (g_free (__temp638), NULL));
	(vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (iface_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (iface_init, init_block), vala_ccode_function_get_block (iface_init));
	ccall = NULL;
	/* save pointer to parent vtable */
	__temp641 = NULL;
	__temp640 = NULL;
	__temp642 = NULL;
	parent_iface_var = (__temp642 = g_strdup_printf ("%s_%s_parent_iface", (__temp640 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), (__temp641 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), (__temp641 = (g_free (__temp641), NULL)), (__temp640 = (g_free (__temp640), NULL)), __temp642);
	__temp643 = NULL;
	__temp644 = NULL;
	parent_decl = (__temp644 = vala_ccode_declaration_new (g_strconcat ((__temp643 = vala_interface_get_type_cname (iface)), "*", NULL)), (__temp643 = (g_free (__temp643), NULL)), __temp644);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	__temp645 = NULL;
	(vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp645 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (parent_var_decl));
	(__temp645 == NULL ? NULL : (__temp645 = (g_object_unref (__temp645), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	(vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (parent_decl));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	__temp646 = NULL;
	ccall = (__temp646 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_interface_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp646);
	__temp647 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp647 = vala_ccode_identifier_new ("iface"))));
	(__temp647 == NULL ? NULL : (__temp647 = (g_object_unref (__temp647), NULL)));
	parent_assignment = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (parent_iface_var)), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	__temp648 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp648 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp648 == NULL ? NULL : (__temp648 = (g_object_unref (__temp648), NULL)));
	methods = vala_class_get_methods (cl);
	{
		GList* __temp651;
		GList* m_it;
		__temp651 = NULL;
		__temp651 = methods;
		for (m_it = __temp651; m_it != NULL; m_it = m_it->next) {
			ValaMethod* m;
			m = m_it->data;
			{
				ValaCodeNode* __temp649;
				ValaCodeNode* base_type;
				ValaCCodeIdentifier* ciface;
				ValaCCodeExpressionStatement* __temp650;
				if (vala_method_get_base_interface_method (m) == NULL) {
					continue;
				}
				__temp649 = NULL;
				base_type = (__temp649 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m))))), (__temp649 == NULL ? NULL : g_object_ref (__temp649)));
				if (base_type != VALA_CODE_NODE (iface)) {
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				__temp650 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp650 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_name (m))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp650 == NULL ? NULL : (__temp650 = (g_object_unref (__temp650), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
			}
		}
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_iface_var = (g_free (parent_iface_var), NULL));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(methods == NULL ? NULL : (methods = (g_list_free (methods), NULL)));
}


static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp652;
	ValaCCodeFunction* __temp653;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* __temp655;
	char* __temp654;
	ValaCCodeBlock* init_block;
	ValaSymbol* init_sym;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp652 = NULL;
	__temp653 = NULL;
	instance_init = (__temp653 = vala_ccode_function_new (g_strdup_printf ("%s_init", (__temp652 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp652 = (g_free (__temp652), NULL)), __temp653);
	__temp655 = NULL;
	__temp654 = NULL;
	vala_ccode_function_add_parameter (instance_init, (__temp655 = vala_ccode_formal_parameter_new ("self", g_strdup_printf ("%s *", (__temp654 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
	(__temp655 == NULL ? NULL : (__temp655 = (g_object_unref (__temp655), NULL)));
	(__temp654 = (g_free (__temp654), NULL));
	(vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (instance_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (instance_init, init_block), vala_ccode_function_get_block (instance_init));
	if (vala_class_get_has_private_fields (cl)) {
		char* __temp656;
		ValaCCodeFunctionCall* __temp657;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp658;
		ValaCCodeExpressionStatement* __temp659;
		__temp656 = NULL;
		__temp657 = NULL;
		ccall = (__temp657 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_PRIVATE", (__temp656 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp656 = (g_free (__temp656), NULL)), __temp657);
		__temp658 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp658 = vala_ccode_identifier_new ("self"))));
		(__temp658 == NULL ? NULL : (__temp658 = (g_object_unref (__temp658), NULL)));
		__temp659 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp659 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp659 == NULL ? NULL : (__temp659 = (g_object_unref (__temp659), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->instance_init_fragment));
	init_sym = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (cl)), "init");
	if (init_sym != NULL) {
		ValaMethod* __temp660;
		ValaMethod* init_fun;
		__temp660 = NULL;
		init_fun = (__temp660 = VALA_METHOD (vala_symbol_get_node (init_sym)), (__temp660 == NULL ? NULL : g_object_ref (__temp660)));
		vala_ccode_block_add_statement (init_block, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (init_fun))));
		(init_fun == NULL ? NULL : (init_fun = (g_object_unref (init_fun), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(init_sym == NULL ? NULL : (init_sym = (g_object_unref (init_sym), NULL)));
}


static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl)
{
	ValaCCodeFunction* __temp662;
	char* __temp661;
	ValaCCodeFormalParameter* __temp663;
	ValaCCodeFunction* __temp664;
	ValaCCodeBlock* cblock;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp665;
	char* __temp666;
	ValaCCodeDeclaration* __temp667;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp668;
	ValaCCodeDeclaration* __temp670;
	char* __temp669;
	ValaCCodeVariableDeclarator* __temp671;
	ValaCCodeDeclaration* __temp672;
	ValaCCodeVariableDeclarator* __temp673;
	ValaCCodeFunctionCall* __temp674;
	ValaCCodeIdentifier* __temp675;
	char* __temp676;
	ValaCCodeFunctionCall* __temp677;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* __temp678;
	ValaCCodeFunctionCall* __temp679;
	ValaCCodeIdentifier* __temp680;
	ValaCCodeFunctionCall* __temp681;
	ValaCCodeExpressionStatement* __temp682;
	ValaCCodeFunctionCall* __temp683;
	ValaCCodeIdentifier* __temp684;
	ValaCCodeExpressionStatement* __temp685;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp662 = NULL;
	__temp661 = NULL;
	self->priv->function = (__temp662 = vala_ccode_function_new (g_strdup_printf ("%s_dispose", (__temp661 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp662);
	(__temp661 = (g_free (__temp661), NULL));
	(vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (self->priv->function));
	__temp663 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp663 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(__temp663 == NULL ? NULL : (__temp663 = (g_object_unref (__temp663), NULL)));
	__temp664 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp664 = vala_ccode_function_copy (self->priv->function))));
	(__temp664 = (g_object_unref (__temp664), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	__temp665 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp665 = vala_ccode_identifier_new ("obj"))));
	(__temp665 == NULL ? NULL : (__temp665 = (g_object_unref (__temp665), NULL)));
	__temp666 = NULL;
	__temp667 = NULL;
	cdecl_ = (__temp667 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp666 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp666 = (g_free (__temp666), NULL)), __temp667);
	__temp668 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp668 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp668 == NULL ? NULL : (__temp668 = (g_object_unref (__temp668), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
	__temp670 = NULL;
	__temp669 = NULL;
	cdecl_ = (__temp670 = vala_ccode_declaration_new (g_strdup_printf ("%sClass *", (__temp669 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp670);
	(__temp669 = (g_free (__temp669), NULL));
	__temp671 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp671 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp671 == NULL ? NULL : (__temp671 = (g_object_unref (__temp671), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp672 = NULL;
	cdecl_ = (__temp672 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp672);
	__temp673 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp673 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp673 == NULL ? NULL : (__temp673 = (g_object_unref (__temp673), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp674 = NULL;
	ccall = (__temp674 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp674);
	__temp675 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp675 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")))));
	(__temp675 == NULL ? NULL : (__temp675 = (g_object_unref (__temp675), NULL)));
	__temp676 = NULL;
	__temp677 = NULL;
	ccast = (__temp677 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp676 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp676 = (g_free (__temp676), NULL)), __temp677);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp678 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp678 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp678 == NULL ? NULL : (__temp678 = (g_object_unref (__temp678), NULL)));
	__temp679 = NULL;
	ccall = (__temp679 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp679);
	__temp680 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp680 = vala_ccode_identifier_new ("klass"))));
	(__temp680 == NULL ? NULL : (__temp680 = (g_object_unref (__temp680), NULL)));
	__temp681 = NULL;
	ccast = (__temp681 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp681);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp682 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp682 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp682 == NULL ? NULL : (__temp682 = (g_object_unref (__temp682), NULL)));
	__temp683 = NULL;
	ccall = (__temp683 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), "dispose"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp683);
	__temp684 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp684 = vala_ccode_identifier_new ("obj"))));
	(__temp684 == NULL ? NULL : (__temp684 = (g_object_unref (__temp684), NULL)));
	__temp685 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp685 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(__temp685 == NULL ? NULL : (__temp685 = (g_object_unref (__temp685), NULL)));
	(vala_ccode_function_set_block (self->priv->function, cblock), vala_ccode_function_get_block (self->priv->function));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (type_reference)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_reference))) {
		return vala_ccode_identifier_new ("g_value_set_object");
	} else {
		if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->string_type)) {
			return vala_ccode_identifier_new ("g_value_set_string");
		} else {
			if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (type_reference))) {
				return vala_ccode_identifier_new ("g_value_set_int");
			} else {
				if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					return vala_ccode_identifier_new ("g_value_set_uint");
				} else {
					if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->long_type)) {
						return vala_ccode_identifier_new ("g_value_set_long");
					} else {
						if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							return vala_ccode_identifier_new ("g_value_set_ulong");
						} else {
							if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								return vala_ccode_identifier_new ("g_value_set_boolean");
							} else {
								if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->float_type)) {
									return vala_ccode_identifier_new ("g_value_set_float");
								} else {
									if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->double_type)) {
										return vala_ccode_identifier_new ("g_value_set_double");
									} else {
										return vala_ccode_identifier_new ("g_value_set_pointer");
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GList* __temp697;
		GList* prop_it;
		__temp697 = NULL;
		__temp697 = vala_class_get_properties (cl);
		for (prop_it = __temp697; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				if (vala_property_get_get_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					return TRUE;
				}
			}
		}
		(__temp697 == NULL ? NULL : (__temp697 = (g_list_free (__temp697), NULL)));
	}
	return FALSE;
}


static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GList* __temp700;
		GList* prop_it;
		__temp700 = NULL;
		__temp700 = vala_class_get_properties (cl);
		for (prop_it = __temp700; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				if (vala_property_get_set_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					return TRUE;
				}
			}
		}
		(__temp700 == NULL ? NULL : (__temp700 = (g_list_free (__temp700), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp702;
	ValaCCodeFunction* __temp703;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* __temp704;
	ValaCCodeFormalParameter* __temp705;
	ValaCCodeFormalParameter* __temp706;
	ValaCCodeFormalParameter* __temp707;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp708;
	char* __temp709;
	ValaCCodeDeclaration* __temp710;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp711;
	ValaCCodeSwitchStatement* cswitch;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp702 = NULL;
	__temp703 = NULL;
	get_prop = (__temp703 = vala_ccode_function_new (g_strdup_printf ("%s_get_property", (__temp702 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp702 = (g_free (__temp702), NULL)), __temp703);
	(vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (get_prop));
	__temp704 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp704 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp704 == NULL ? NULL : (__temp704 = (g_object_unref (__temp704), NULL)));
	__temp705 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp705 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp705 == NULL ? NULL : (__temp705 = (g_object_unref (__temp705), NULL)));
	__temp706 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp706 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(__temp706 == NULL ? NULL : (__temp706 = (g_object_unref (__temp706), NULL)));
	__temp707 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp707 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp707 == NULL ? NULL : (__temp707 = (g_object_unref (__temp707), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	__temp708 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp708 = vala_ccode_identifier_new ("object"))));
	(__temp708 == NULL ? NULL : (__temp708 = (g_object_unref (__temp708), NULL)));
	__temp709 = NULL;
	__temp710 = NULL;
	cdecl_ = (__temp710 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp709 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp709 = (g_free (__temp709), NULL)), __temp710);
	__temp711 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp711 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp711 == NULL ? NULL : (__temp711 = (g_object_unref (__temp711), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("property_id")));
	props = vala_class_get_properties (cl);
	{
		GList* __temp718;
		GList* prop_it;
		__temp718 = NULL;
		__temp718 = props;
		for (prop_it = __temp718; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp713;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* __temp714;
				ValaCCodeIdentifier* __temp715;
				ValaCCodeExpressionStatement* __temp716;
				ValaCCodeBreakStatement* __temp717;
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL);
				if (is_virtual) {
					char* __temp712;
					__temp712 = NULL;
					prefix = (__temp712 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp712);
				}
				ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_property_get_upper_case_cname (prop))));
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_%s", prefix, vala_property_get_name (prop)))));
				__temp713 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp713 = vala_ccode_identifier_new ("self"))));
				(__temp713 == NULL ? NULL : (__temp713 = (g_object_unref (__temp713), NULL)));
				csetcall = vala_ccode_function_call_new (NULL);
				__temp714 = NULL;
				(vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((__temp714 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))))), vala_ccode_function_call_get_call (csetcall));
				(__temp714 = (g_object_unref (__temp714), NULL));
				__temp715 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((__temp715 = vala_ccode_identifier_new ("value"))));
				(__temp715 == NULL ? NULL : (__temp715 = (g_object_unref (__temp715), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				__temp716 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp716 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(__temp716 == NULL ? NULL : (__temp716 = (g_object_unref (__temp716), NULL)));
				__temp717 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp717 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp717 == NULL ? NULL : (__temp717 = (g_object_unref (__temp717), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	(vala_ccode_function_set_block (get_prop, block), vala_ccode_function_get_block (get_prop));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp719;
	ValaCCodeFunction* __temp720;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* __temp721;
	ValaCCodeFormalParameter* __temp722;
	ValaCCodeFormalParameter* __temp723;
	ValaCCodeFormalParameter* __temp724;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp725;
	char* __temp726;
	ValaCCodeDeclaration* __temp727;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp728;
	ValaCCodeSwitchStatement* cswitch;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp719 = NULL;
	__temp720 = NULL;
	set_prop = (__temp720 = vala_ccode_function_new (g_strdup_printf ("%s_set_property", (__temp719 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp719 = (g_free (__temp719), NULL)), __temp720);
	(vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (set_prop));
	__temp721 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp721 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp721 == NULL ? NULL : (__temp721 = (g_object_unref (__temp721), NULL)));
	__temp722 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp722 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp722 == NULL ? NULL : (__temp722 = (g_object_unref (__temp722), NULL)));
	__temp723 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp723 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(__temp723 == NULL ? NULL : (__temp723 = (g_object_unref (__temp723), NULL)));
	__temp724 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp724 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp724 == NULL ? NULL : (__temp724 = (g_object_unref (__temp724), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	__temp725 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp725 = vala_ccode_identifier_new ("object"))));
	(__temp725 == NULL ? NULL : (__temp725 = (g_object_unref (__temp725), NULL)));
	__temp726 = NULL;
	__temp727 = NULL;
	cdecl_ = (__temp727 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp726 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp726 = (g_free (__temp726), NULL)), __temp727);
	__temp728 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp728 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp728 == NULL ? NULL : (__temp728 = (g_object_unref (__temp728), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("property_id")));
	props = vala_class_get_properties (cl);
	{
		GList* __temp744;
		GList* prop_it;
		__temp744 = NULL;
		__temp744 = props;
		for (prop_it = __temp744; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp730;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* __temp741;
				ValaCCodeExpressionStatement* __temp742;
				ValaCCodeBreakStatement* __temp743;
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL);
				if (is_virtual) {
					char* __temp729;
					__temp729 = NULL;
					prefix = (__temp729 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp729);
				}
				ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_property_get_upper_case_cname (prop))));
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_set_%s", prefix, vala_property_get_name (prop)))));
				__temp730 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp730 = vala_ccode_identifier_new ("self"))));
				(__temp730 == NULL ? NULL : (__temp730 = (g_object_unref (__temp730), NULL)));
				cgetcall = vala_ccode_function_call_new (NULL);
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
					ValaCCodeIdentifier* __temp731;
					__temp731 = NULL;
					(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp731 = vala_ccode_identifier_new ("g_value_get_object")))), vala_ccode_function_call_get_call (cgetcall));
					(__temp731 == NULL ? NULL : (__temp731 = (g_object_unref (__temp731), NULL)));
				} else {
					if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "string") == 0) {
						ValaCCodeIdentifier* __temp732;
						__temp732 = NULL;
						(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp732 = vala_ccode_identifier_new ("g_value_get_string")))), vala_ccode_function_call_get_call (cgetcall));
						(__temp732 == NULL ? NULL : (__temp732 = (g_object_unref (__temp732), NULL)));
					} else {
						if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "int") == 0 || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
							ValaCCodeIdentifier* __temp733;
							__temp733 = NULL;
							(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp733 = vala_ccode_identifier_new ("g_value_get_int")))), vala_ccode_function_call_get_call (cgetcall));
							(__temp733 == NULL ? NULL : (__temp733 = (g_object_unref (__temp733), NULL)));
						} else {
							if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "uint") == 0) {
								ValaCCodeIdentifier* __temp734;
								__temp734 = NULL;
								(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp734 = vala_ccode_identifier_new ("g_value_get_uint")))), vala_ccode_function_call_get_call (cgetcall));
								(__temp734 == NULL ? NULL : (__temp734 = (g_object_unref (__temp734), NULL)));
							} else {
								if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "long") == 0) {
									ValaCCodeIdentifier* __temp735;
									__temp735 = NULL;
									(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp735 = vala_ccode_identifier_new ("g_value_get_long")))), vala_ccode_function_call_get_call (cgetcall));
									(__temp735 == NULL ? NULL : (__temp735 = (g_object_unref (__temp735), NULL)));
								} else {
									if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "ulong") == 0) {
										ValaCCodeIdentifier* __temp736;
										__temp736 = NULL;
										(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp736 = vala_ccode_identifier_new ("g_value_get_ulong")))), vala_ccode_function_call_get_call (cgetcall));
										(__temp736 == NULL ? NULL : (__temp736 = (g_object_unref (__temp736), NULL)));
									} else {
										if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "bool") == 0) {
											ValaCCodeIdentifier* __temp737;
											__temp737 = NULL;
											(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp737 = vala_ccode_identifier_new ("g_value_get_boolean")))), vala_ccode_function_call_get_call (cgetcall));
											(__temp737 == NULL ? NULL : (__temp737 = (g_object_unref (__temp737), NULL)));
										} else {
											if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "float") == 0) {
												ValaCCodeIdentifier* __temp738;
												__temp738 = NULL;
												(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp738 = vala_ccode_identifier_new ("g_value_get_float")))), vala_ccode_function_call_get_call (cgetcall));
												(__temp738 == NULL ? NULL : (__temp738 = (g_object_unref (__temp738), NULL)));
											} else {
												if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "double") == 0) {
													ValaCCodeIdentifier* __temp739;
													__temp739 = NULL;
													(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp739 = vala_ccode_identifier_new ("g_value_get_double")))), vala_ccode_function_call_get_call (cgetcall));
													(__temp739 == NULL ? NULL : (__temp739 = (g_object_unref (__temp739), NULL)));
												} else {
													ValaCCodeIdentifier* __temp740;
													__temp740 = NULL;
													(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp740 = vala_ccode_identifier_new ("g_value_get_pointer")))), vala_ccode_function_call_get_call (cgetcall));
													(__temp740 == NULL ? NULL : (__temp740 = (g_object_unref (__temp740), NULL)));
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp741 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp741 = vala_ccode_identifier_new ("value"))));
				(__temp741 == NULL ? NULL : (__temp741 = (g_object_unref (__temp741), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				__temp742 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp742 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(__temp742 == NULL ? NULL : (__temp742 = (g_object_unref (__temp742), NULL)));
				__temp743 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp743 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp743 == NULL ? NULL : (__temp743 = (g_object_unref (__temp743), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	{
		GList* __temp753;
		GList* type_param_it;
		__temp753 = NULL;
		__temp753 = vala_class_get_type_parameters (cl);
		for (type_param_it = __temp753; type_param_it != NULL; type_param_it = type_param_it->next) {
			ValaTypeParameter* type_param;
			type_param = type_param_it->data;
			{
				char* __temp745;
				char* __temp746;
				char* func_name;
				char* __temp748;
				char* __temp747;
				char* __temp749;
				char* enum_value;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* __temp750;
				ValaCCodeExpressionStatement* __temp751;
				ValaCCodeBreakStatement* __temp752;
				/* destroy func properties for generic types */
				__temp745 = NULL;
				__temp746 = NULL;
				func_name = (__temp746 = g_strdup_printf ("%s_destroy_func", (__temp745 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp745 = (g_free (__temp745), NULL)), __temp746);
				__temp748 = NULL;
				__temp747 = NULL;
				__temp749 = NULL;
				enum_value = (__temp749 = g_utf8_strup ((__temp748 = g_strdup_printf ("%s_%s", (__temp747 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), func_name)), -1), (__temp748 = (g_free (__temp748), NULL)), (__temp747 = (g_free (__temp747), NULL)), __temp749);
				ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (enum_value)));
				cfield = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), func_name);
				cgetcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_get_pointer")));
				__temp750 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp750 = vala_ccode_identifier_new ("value"))));
				(__temp750 == NULL ? NULL : (__temp750 = (g_object_unref (__temp750), NULL)));
				__temp751 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp751 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp751 == NULL ? NULL : (__temp751 = (g_object_unref (__temp751), NULL)));
				__temp752 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp752 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp752 == NULL ? NULL : (__temp752 = (g_object_unref (__temp752), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(__temp753 == NULL ? NULL : (__temp753 = (g_list_free (__temp753), NULL)));
	}
	(vala_ccode_function_set_block (set_prop, block), vala_ccode_function_get_block (set_prop));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp755;
	ValaSymbol* __temp754;
	ValaSymbol* __temp757;
	ValaSymbol* __temp756;
	ValaSymbol* __temp785;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp755 = NULL;
	__temp754 = NULL;
	self->priv->current_symbol = (__temp755 = (__temp754 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp754 == NULL ? NULL : g_object_ref (__temp754))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp755);
	__temp757 = NULL;
	__temp756 = NULL;
	self->priv->current_type_symbol = (__temp757 = (__temp756 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp756 == NULL ? NULL : g_object_ref (__temp756))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp757);
	if (!vala_interface_get_is_static (iface)) {
		ValaCCodeStruct* __temp759;
		char* __temp758;
		ValaCCodeNewline* __temp760;
		char* __temp761;
		char* __temp762;
		char* macro;
		ValaCCodeMacroReplacement* __temp763;
		char* __temp766;
		char* __temp765;
		char* __temp764;
		ValaCCodeMacroReplacement* __temp768;
		char* __temp767;
		char* __temp770;
		char* __temp769;
		ValaCCodeMacroReplacement* __temp772;
		char* __temp771;
		char* __temp775;
		char* __temp774;
		char* __temp773;
		ValaCCodeMacroReplacement* __temp777;
		char* __temp776;
		ValaCCodeNewline* __temp778;
		__temp759 = NULL;
		__temp758 = NULL;
		self->priv->type_struct = (__temp759 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp758 = vala_interface_get_type_cname (iface)))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp759);
		(__temp758 = (g_free (__temp758), NULL));
		__temp760 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp760 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(__temp760 == NULL ? NULL : (__temp760 = (g_object_unref (__temp760), NULL)));
		__temp761 = NULL;
		__temp762 = NULL;
		macro = (__temp762 = g_strdup_printf ("(%s_get_type ())", (__temp761 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), (__temp761 = (g_free (__temp761), NULL)), __temp762);
		__temp763 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp763 = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"), macro))));
		(__temp763 == NULL ? NULL : (__temp763 = (g_object_unref (__temp763), NULL)));
		__temp766 = NULL;
		__temp765 = NULL;
		__temp764 = NULL;
		macro = (__temp766 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp764 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp765 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), (macro = (g_free (macro), NULL)), __temp766);
		(__temp765 = (g_free (__temp765), NULL));
		(__temp764 = (g_free (__temp764), NULL));
		__temp768 = NULL;
		__temp767 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp768 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp767 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL))), macro))));
		(__temp768 == NULL ? NULL : (__temp768 = (g_object_unref (__temp768), NULL)));
		(__temp767 = (g_free (__temp767), NULL));
		__temp770 = NULL;
		__temp769 = NULL;
		macro = (__temp770 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp769 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp770);
		(__temp769 = (g_free (__temp769), NULL));
		__temp772 = NULL;
		__temp771 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp772 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp771 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "IS_"))), macro))));
		(__temp772 == NULL ? NULL : (__temp772 = (g_object_unref (__temp772), NULL)));
		(__temp771 = (g_free (__temp771), NULL));
		__temp775 = NULL;
		__temp774 = NULL;
		__temp773 = NULL;
		macro = (__temp775 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (__temp773 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp774 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), __temp775);
		(__temp774 = (g_free (__temp774), NULL));
		(__temp773 = (g_free (__temp773), NULL));
		__temp777 = NULL;
		__temp776 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp777 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_INTERFACE(obj)", (__temp776 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL))), macro))));
		(__temp777 == NULL ? NULL : (__temp777 = (g_object_unref (__temp777), NULL)));
		(__temp776 = (g_free (__temp776), NULL));
		__temp778 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp778 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(__temp778 == NULL ? NULL : (__temp778 = (g_object_unref (__temp778), NULL)));
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))) == NULL) {
			ValaCCodeTypeDefinition* __temp780;
			char* __temp779;
			ValaCCodeTypeDefinition* __temp781;
			__temp780 = NULL;
			__temp779 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp780 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp779 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
			(__temp780 == NULL ? NULL : (__temp780 = (g_object_unref (__temp780), NULL)));
			(__temp779 = (g_free (__temp779), NULL));
			__temp781 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp781 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_interface_get_type_cname (iface)))))));
			(__temp781 == NULL ? NULL : (__temp781 = (g_object_unref (__temp781), NULL)));
		}
		vala_ccode_struct_add_field (self->priv->type_struct, "GTypeInterface", "parent");
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface))) != NULL) {
			ValaCCodeComment* __temp782;
			__temp782 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp782 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))))));
			(__temp782 == NULL ? NULL : (__temp782 = (g_object_unref (__temp782), NULL)));
		}
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
		(macro = (g_free (macro), NULL));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	if (!vala_interface_get_is_static (iface)) {
		ValaInterfaceRegisterFunction* type_fun;
		ValaCCodeFragment* __temp783;
		ValaCCodeFragment* __temp784;
		vala_code_generator_add_interface_base_init_function (self, iface);
		type_fun = vala_interface_register_function_new (iface);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), FALSE);
		__temp783 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp783 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp783 = (g_object_unref (__temp783), NULL));
		__temp784 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp784 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp784 = (g_object_unref (__temp784), NULL));
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	__temp785 = NULL;
	self->priv->current_type_symbol = (__temp785 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp785);
}


static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop)
{
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* __temp786;
	ValaCCodeConstant* __temp787;
	ValaCCodeConstant* __temp788;
	char* pflags;
	ValaCCodeConstant* __temp824;
	ValaCCodeFunctionCall* __temp825;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	__temp786 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp786 = vala_property_get_canonical_cconstant (prop))));
	(__temp786 = (g_object_unref (__temp786), NULL));
	__temp787 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp787 = vala_ccode_constant_new ("\"foo\""))));
	(__temp787 == NULL ? NULL : (__temp787 = (g_object_unref (__temp787), NULL)));
	__temp788 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp788 = vala_ccode_constant_new ("\"bar\""))));
	(__temp788 == NULL ? NULL : (__temp788 = (g_object_unref (__temp788), NULL)));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* __temp789;
		ValaCCodeIdentifier* __temp790;
		__temp789 = NULL;
		(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp789 = vala_ccode_identifier_new ("g_param_spec_object")))), vala_ccode_function_call_get_call (cspec));
		(__temp789 == NULL ? NULL : (__temp789 = (g_object_unref (__temp789), NULL)));
		__temp790 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp790 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), "TYPE_")))));
		(__temp790 == NULL ? NULL : (__temp790 = (g_object_unref (__temp790), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->string_type)) {
			ValaCCodeIdentifier* __temp791;
			ValaCCodeConstant* __temp792;
			__temp791 = NULL;
			(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp791 = vala_ccode_identifier_new ("g_param_spec_string")))), vala_ccode_function_call_get_call (cspec));
			(__temp791 == NULL ? NULL : (__temp791 = (g_object_unref (__temp791), NULL)));
			__temp792 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp792 = vala_ccode_constant_new ("NULL"))));
			(__temp792 == NULL ? NULL : (__temp792 = (g_object_unref (__temp792), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeIdentifier* __temp793;
				ValaCCodeConstant* __temp794;
				ValaCCodeConstant* __temp795;
				ValaCCodeConstant* __temp796;
				__temp793 = NULL;
				(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp793 = vala_ccode_identifier_new ("g_param_spec_int")))), vala_ccode_function_call_get_call (cspec));
				(__temp793 == NULL ? NULL : (__temp793 = (g_object_unref (__temp793), NULL)));
				__temp794 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp794 = vala_ccode_constant_new ("G_MININT"))));
				(__temp794 == NULL ? NULL : (__temp794 = (g_object_unref (__temp794), NULL)));
				__temp795 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp795 = vala_ccode_constant_new ("G_MAXINT"))));
				(__temp795 == NULL ? NULL : (__temp795 = (g_object_unref (__temp795), NULL)));
				__temp796 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp796 = vala_ccode_constant_new ("0"))));
				(__temp796 == NULL ? NULL : (__temp796 = (g_object_unref (__temp796), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeIdentifier* __temp797;
					ValaCCodeConstant* __temp798;
					ValaCCodeConstant* __temp799;
					ValaCCodeConstant* __temp800;
					__temp797 = NULL;
					(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp797 = vala_ccode_identifier_new ("g_param_spec_uint")))), vala_ccode_function_call_get_call (cspec));
					(__temp797 == NULL ? NULL : (__temp797 = (g_object_unref (__temp797), NULL)));
					__temp798 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp798 = vala_ccode_constant_new ("0"))));
					(__temp798 == NULL ? NULL : (__temp798 = (g_object_unref (__temp798), NULL)));
					__temp799 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp799 = vala_ccode_constant_new ("G_MAXUINT"))));
					(__temp799 == NULL ? NULL : (__temp799 = (g_object_unref (__temp799), NULL)));
					__temp800 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp800 = vala_ccode_constant_new ("0U"))));
					(__temp800 == NULL ? NULL : (__temp800 = (g_object_unref (__temp800), NULL)));
				} else {
					if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->long_type)) {
						ValaCCodeIdentifier* __temp801;
						ValaCCodeConstant* __temp802;
						ValaCCodeConstant* __temp803;
						ValaCCodeConstant* __temp804;
						__temp801 = NULL;
						(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp801 = vala_ccode_identifier_new ("g_param_spec_long")))), vala_ccode_function_call_get_call (cspec));
						(__temp801 == NULL ? NULL : (__temp801 = (g_object_unref (__temp801), NULL)));
						__temp802 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp802 = vala_ccode_constant_new ("G_MINLONG"))));
						(__temp802 == NULL ? NULL : (__temp802 = (g_object_unref (__temp802), NULL)));
						__temp803 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp803 = vala_ccode_constant_new ("G_MAXLONG"))));
						(__temp803 == NULL ? NULL : (__temp803 = (g_object_unref (__temp803), NULL)));
						__temp804 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp804 = vala_ccode_constant_new ("0L"))));
						(__temp804 == NULL ? NULL : (__temp804 = (g_object_unref (__temp804), NULL)));
					} else {
						if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							ValaCCodeIdentifier* __temp805;
							ValaCCodeConstant* __temp806;
							ValaCCodeConstant* __temp807;
							ValaCCodeConstant* __temp808;
							__temp805 = NULL;
							(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp805 = vala_ccode_identifier_new ("g_param_spec_ulong")))), vala_ccode_function_call_get_call (cspec));
							(__temp805 == NULL ? NULL : (__temp805 = (g_object_unref (__temp805), NULL)));
							__temp806 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp806 = vala_ccode_constant_new ("0"))));
							(__temp806 == NULL ? NULL : (__temp806 = (g_object_unref (__temp806), NULL)));
							__temp807 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp807 = vala_ccode_constant_new ("G_MAXULONG"))));
							(__temp807 == NULL ? NULL : (__temp807 = (g_object_unref (__temp807), NULL)));
							__temp808 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp808 = vala_ccode_constant_new ("0UL"))));
							(__temp808 == NULL ? NULL : (__temp808 = (g_object_unref (__temp808), NULL)));
						} else {
							if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								ValaCCodeIdentifier* __temp809;
								ValaCCodeConstant* __temp810;
								__temp809 = NULL;
								(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp809 = vala_ccode_identifier_new ("g_param_spec_boolean")))), vala_ccode_function_call_get_call (cspec));
								(__temp809 == NULL ? NULL : (__temp809 = (g_object_unref (__temp809), NULL)));
								__temp810 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp810 = vala_ccode_constant_new ("FALSE"))));
								(__temp810 == NULL ? NULL : (__temp810 = (g_object_unref (__temp810), NULL)));
							} else {
								if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->float_type)) {
									ValaCCodeIdentifier* __temp811;
									ValaCCodeConstant* __temp812;
									ValaCCodeConstant* __temp813;
									ValaCCodeConstant* __temp814;
									__temp811 = NULL;
									(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp811 = vala_ccode_identifier_new ("g_param_spec_float")))), vala_ccode_function_call_get_call (cspec));
									(__temp811 == NULL ? NULL : (__temp811 = (g_object_unref (__temp811), NULL)));
									__temp812 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp812 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
									(__temp812 == NULL ? NULL : (__temp812 = (g_object_unref (__temp812), NULL)));
									__temp813 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp813 = vala_ccode_constant_new ("G_MAXFLOAT"))));
									(__temp813 == NULL ? NULL : (__temp813 = (g_object_unref (__temp813), NULL)));
									__temp814 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp814 = vala_ccode_constant_new ("0.0F"))));
									(__temp814 == NULL ? NULL : (__temp814 = (g_object_unref (__temp814), NULL)));
								} else {
									if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->double_type)) {
										ValaCCodeIdentifier* __temp815;
										ValaCCodeConstant* __temp816;
										ValaCCodeConstant* __temp817;
										ValaCCodeConstant* __temp818;
										__temp815 = NULL;
										(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp815 = vala_ccode_identifier_new ("g_param_spec_double")))), vala_ccode_function_call_get_call (cspec));
										(__temp815 == NULL ? NULL : (__temp815 = (g_object_unref (__temp815), NULL)));
										__temp816 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp816 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
										(__temp816 == NULL ? NULL : (__temp816 = (g_object_unref (__temp816), NULL)));
										__temp817 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp817 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
										(__temp817 == NULL ? NULL : (__temp817 = (g_object_unref (__temp817), NULL)));
										__temp818 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp818 = vala_ccode_constant_new ("0.0"))));
										(__temp818 == NULL ? NULL : (__temp818 = (g_object_unref (__temp818), NULL)));
									} else {
										ValaCCodeIdentifier* __temp819;
										__temp819 = NULL;
										(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp819 = vala_ccode_identifier_new ("g_param_spec_pointer")))), vala_ccode_function_call_get_call (cspec));
										(__temp819 == NULL ? NULL : (__temp819 = (g_object_unref (__temp819), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* __temp820;
		__temp820 = NULL;
		pflags = (__temp820 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), __temp820);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* __temp821;
		__temp821 = NULL;
		pflags = (__temp821 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), __temp821);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* __temp822;
				__temp822 = NULL;
				pflags = (__temp822 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), __temp822);
			} else {
				char* __temp823;
				__temp823 = NULL;
				pflags = (__temp823 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), __temp823);
			}
		}
	}
	__temp824 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp824 = vala_ccode_constant_new (pflags))));
	(__temp824 == NULL ? NULL : (__temp824 = (g_object_unref (__temp824), NULL)));
	__temp825 = NULL;
	return (__temp825 = cspec, (pflags = (g_free (pflags), NULL)), __temp825);
	(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
	(pflags = (g_free (pflags), NULL));
}


static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type)
{
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* __temp826;
	ValaCCodeIdentifier* __temp827;
	ValaCCodeConstant* __temp828;
	ValaCCodeConstant* __temp829;
	ValaCCodeConstant* __temp830;
	ValaCCodeConstant* __temp831;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GList* params;
	guint params_len;
	ValaCCodeConstant* __temp835;
	ValaCCodeFunctionCall* __temp839;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	csignew = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_new")));
	__temp826 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp826 = vala_ccode_constant_new (g_strdup_printf ("\"%s\"", vala_signal_get_name (sig))))));
	(__temp826 == NULL ? NULL : (__temp826 = (g_object_unref (__temp826), NULL)));
	__temp827 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp827 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (type, "TYPE_")))));
	(__temp827 == NULL ? NULL : (__temp827 = (g_object_unref (__temp827), NULL)));
	__temp828 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp828 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(__temp828 == NULL ? NULL : (__temp828 = (g_object_unref (__temp828), NULL)));
	__temp829 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp829 = vala_ccode_constant_new ("0"))));
	(__temp829 == NULL ? NULL : (__temp829 = (g_object_unref (__temp829), NULL)));
	__temp830 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp830 = vala_ccode_constant_new ("NULL"))));
	(__temp830 == NULL ? NULL : (__temp830 = (g_object_unref (__temp830), NULL)));
	__temp831 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp831 = vala_ccode_constant_new ("NULL"))));
	(__temp831 == NULL ? NULL : (__temp831 = (g_object_unref (__temp831), NULL)));
	marshaller = vala_code_generator_get_signal_marshaller_function (self, sig, NULL);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	params_len = g_list_length (params);
	if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* __temp832;
		__temp832 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp832 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(__temp832 == NULL ? NULL : (__temp832 = (g_object_unref (__temp832), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
			ValaCCodeConstant* __temp833;
			__temp833 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp833 = vala_ccode_constant_new ("G_TYPE_NONE"))));
			(__temp833 == NULL ? NULL : (__temp833 = (g_object_unref (__temp833), NULL)));
		} else {
			ValaCCodeConstant* __temp834;
			__temp834 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp834 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))));
			(__temp834 == NULL ? NULL : (__temp834 = (g_object_unref (__temp834), NULL)));
		}
	}
	__temp835 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp835 = vala_ccode_constant_new (g_strdup_printf ("%d", params_len)))));
	(__temp835 == NULL ? NULL : (__temp835 = (g_object_unref (__temp835), NULL)));
	{
		GList* __temp838;
		GList* param_it;
		__temp838 = NULL;
		__temp838 = params;
		for (param_it = __temp838; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL) {
					ValaCCodeConstant* __temp836;
					__temp836 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp836 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(__temp836 == NULL ? NULL : (__temp836 = (g_object_unref (__temp836), NULL)));
				} else {
					ValaCCodeConstant* __temp837;
					__temp837 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp837 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))))));
					(__temp837 == NULL ? NULL : (__temp837 = (g_object_unref (__temp837), NULL)));
				}
			}
		}
	}
	(vala_ccode_identifier_set_name (marshal_arg, marshaller), vala_ccode_identifier_get_name (marshal_arg));
	__temp839 = NULL;
	return (__temp839 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp839);
	(csignew == NULL ? NULL : (csignew = (g_object_unref (csignew), NULL)));
	(marshaller = (g_free (marshaller), NULL));
	(marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface)
{
	char* __temp840;
	ValaCCodeFunction* __temp841;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* __temp843;
	char* __temp842;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* __temp844;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* __temp845;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* __temp846;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp840 = NULL;
	__temp841 = NULL;
	base_init = (__temp841 = vala_ccode_function_new (g_strdup_printf ("%s_base_init", (__temp840 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), "void"), (__temp840 = (g_free (__temp840), NULL)), __temp841);
	__temp843 = NULL;
	__temp842 = NULL;
	vala_ccode_function_add_parameter (base_init, (__temp843 = vala_ccode_formal_parameter_new ("iface", g_strdup_printf ("%sIface *", (__temp842 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))))));
	(__temp843 == NULL ? NULL : (__temp843 = (g_object_unref (__temp843), NULL)));
	(__temp842 = (g_free (__temp842), NULL));
	(vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (base_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	/* make sure not to run the initialization code twice */
	__temp844 = NULL;
	(vala_ccode_function_set_block (base_init, (__temp844 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL))), vala_ccode_function_get_block (base_init));
	(__temp844 == NULL ? NULL : (__temp844 = (g_object_unref (__temp844), NULL)));
	decl = vala_ccode_declaration_new (vala_type_reference_get_cname (self->priv->bool_type, FALSE, FALSE));
	(vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_declaration_get_modifiers (decl));
	__temp845 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp845 = vala_ccode_variable_declarator_new_with_initializer ("initialized", VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("FALSE"))))));
	(__temp845 == NULL ? NULL : (__temp845 = (g_object_unref (__temp845), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (decl));
	cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("initialized")))), VALA_CCODE_STATEMENT (init_block), NULL);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (cif));
	__temp846 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp846 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("initialized")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp846 == NULL ? NULL : (__temp846 = (g_object_unref (__temp846), NULL)));
	/* create properties */
	props = vala_interface_get_properties (iface);
	{
		GList* __temp850;
		GList* prop_it;
		__temp850 = NULL;
		__temp850 = props;
		for (prop_it = __temp850; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				ValaCCodeFunctionCall* cinst;
				ValaCCodeIdentifier* __temp847;
				ValaCCodeFunctionCall* __temp848;
				ValaCCodeExpressionStatement* __temp849;
				cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_interface_install_property")));
				__temp847 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp847 = vala_ccode_identifier_new ("iface"))));
				(__temp847 == NULL ? NULL : (__temp847 = (g_object_unref (__temp847), NULL)));
				__temp848 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp848 = vala_code_generator_get_param_spec (self, prop))));
				(__temp848 = (g_object_unref (__temp848), NULL));
				__temp849 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp849 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp849 == NULL ? NULL : (__temp849 = (g_object_unref (__temp849), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
			}
		}
	}
	{
		GList* __temp852;
		GList* sig_it;
		__temp852 = NULL;
		__temp852 = vala_interface_get_signals (iface);
		for (sig_it = __temp852; sig_it != NULL; sig_it = sig_it->next) {
			ValaSignal* sig;
			sig = sig_it->data;
			{
				ValaCCodeExpressionStatement* __temp851;
				/* create signals */
				__temp851 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp851 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (iface)))))));
				(__temp851 == NULL ? NULL : (__temp851 = (g_object_unref (__temp851), NULL)));
			}
		}
		(__temp852 == NULL ? NULL : (__temp852 = (g_list_free (__temp852), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (base_init));
	(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GList* params;
	ValaMemberAccess* __temp853;
	ValaMemberAccess* ma;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	GList* params_it;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (expr));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "unsupported method invocation");
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		return;
	}
	__temp853 = NULL;
	ma = (__temp853 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (__temp853 == NULL ? NULL : g_object_ref (__temp853)));
	if (VALA_IS_INVOKABLE (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))))) {
		ValaInvokable* __temp854;
		ValaInvokable* i;
		GList* __temp855;
		__temp854 = NULL;
		i = (__temp854 = VALA_INVOKABLE (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))), (__temp854 == NULL ? NULL : g_object_ref (__temp854)));
		__temp855 = NULL;
		params = (__temp855 = vala_invokable_get_parameters (i), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp855);
		if (VALA_IS_METHOD (i)) {
			ValaMethod* __temp857;
			ValaMethod* __temp856;
			__temp857 = NULL;
			__temp856 = NULL;
			m = (__temp857 = (__temp856 = VALA_METHOD (i), (__temp856 == NULL ? NULL : g_object_ref (__temp856))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), __temp857);
		} else {
			if (VALA_IS_SIGNAL (i)) {
				ValaCCodeFunctionCall* __temp859;
				ValaCCodeFunctionCall* __temp858;
				__temp859 = NULL;
				__temp858 = NULL;
				ccall = (__temp859 = (__temp858 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (__temp858 == NULL ? NULL : g_object_ref (__temp858))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp859);
			}
		}
		(i == NULL ? NULL : (i = (g_object_unref (i), NULL)));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArray* __temp860;
		ValaArray* array;
		ValaCCodeIdentifier* __temp861;
		__temp860 = NULL;
		array = (__temp860 = VALA_ARRAY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp860 == NULL ? NULL : g_object_ref (__temp860)));
		__temp861 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp861 = vala_ccode_identifier_new (vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE)))));
		(__temp861 == NULL ? NULL : (__temp861 = (g_object_unref (__temp861), NULL)));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	}
	/* explicitly use strong reference as ccall gets unrefed
	 * at end of inner block
	 */
	instance = NULL;
	if (m != NULL && vala_method_get_instance (m)) {
		ValaMethod* __temp862;
		ValaMethod* base_method;
		gboolean req_cast;
		__temp862 = NULL;
		base_method = (__temp862 = m, (__temp862 == NULL ? NULL : g_object_ref (__temp862)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaMethod* __temp864;
			ValaMethod* __temp863;
			__temp864 = NULL;
			__temp863 = NULL;
			base_method = (__temp864 = (__temp863 = vala_method_get_base_interface_method (m), (__temp863 == NULL ? NULL : g_object_ref (__temp863))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp864);
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* __temp866;
				ValaMethod* __temp865;
				__temp866 = NULL;
				__temp865 = NULL;
				base_method = (__temp866 = (__temp865 = vala_method_get_base_method (m), (__temp865 == NULL ? NULL : g_object_ref (__temp865))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp866);
			}
		}
		req_cast = FALSE;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* __temp867;
			__temp867 = NULL;
			instance = (__temp867 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp867);
			/* require casts for overriden and inherited methods */
			req_cast = vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL || (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))) != self->priv->current_type_symbol);
		} else {
			ValaCCodeExpression* __temp869;
			ValaCCodeExpression* __temp868;
			__temp869 = NULL;
			__temp868 = NULL;
			instance = (__temp869 = (__temp868 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp868 == NULL ? NULL : g_object_ref (__temp868))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp869);
			/* reqiure casts if the type of the used instance is
			 * different than the type which declared the method */
			req_cast = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_method)))) != VALA_CODE_NODE (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
		}
		if (vala_method_get_instance_by_reference (m) && (vala_member_access_get_inner (ma) != NULL || vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))) != self->priv->current_type_symbol)) {
			ValaCCodeExpression* __temp870;
			__temp870 = NULL;
			instance = (__temp870 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp870);
		}
		if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))))) {
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* __temp872;
			ValaCCodeFunctionCall* __temp871;
			/* FIXME: use C cast if debugging disabled*/
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_method)))))), NULL))));
			vala_ccode_function_call_add_argument (ccall, instance);
			__temp872 = NULL;
			__temp871 = NULL;
			instance = (__temp872 = VALA_CCODE_EXPRESSION ((__temp871 = ccall, (__temp871 == NULL ? NULL : g_object_ref (__temp871)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp872);
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_call_add_argument (ccall, instance);
		}
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
	}
	ellipsis = FALSE;
	i = 1;
	params_it = params;
	{
		GList* __temp883;
		GList* arg_it;
		__temp883 = NULL;
		__temp883 = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = __temp883; arg_it != NULL; arg_it = arg_it->next) {
			ValaExpression* arg;
			arg = arg_it->data;
			{
				ValaCCodeExpression* __temp873;
				ValaCCodeExpression* cexpr;
				/* explicitly use strong reference as ccall gets
				 * unrefed at end of inner block
				 */
				__temp873 = NULL;
				cexpr = (__temp873 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (__temp873 == NULL ? NULL : g_object_ref (__temp873)));
				if (params_it != NULL) {
					ValaFormalParameter* __temp874;
					ValaFormalParameter* param;
					__temp874 = NULL;
					param = (__temp874 = VALA_FORMAL_PARAMETER (params_it->data), (__temp874 == NULL ? NULL : g_object_ref (__temp874)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL) {
							if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaArray* __temp875;
								ValaArray* arr;
								__temp875 = NULL;
								arr = (__temp875 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp875 == NULL ? NULL : g_object_ref (__temp875)));
								{
									gint dim;
									dim = 0;
									for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
										ValaCCodeExpression* __temp876;
										__temp876 = NULL;
										vala_ccode_function_call_add_argument (ccall, (__temp876 = vala_code_generator_get_array_length_cexpression (self, arg, dim)));
										(__temp876 = (g_object_unref (__temp876), NULL));
									}
								}
								(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
							}
							if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* __temp878;
								ValaCCodeFunctionCall* __temp877;
								/* FIXME: use C cast if debugging disabled*/
								ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL))));
								vala_ccode_function_call_add_argument (ccall, cexpr);
								__temp878 = NULL;
								__temp877 = NULL;
								cexpr = (__temp878 = VALA_CCODE_EXPRESSION ((__temp877 = ccall, (__temp877 == NULL ? NULL : g_object_ref (__temp877)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp878);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
						} else {
							if (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaCCodeExpression* __temp879;
								__temp879 = NULL;
								cexpr = (__temp879 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, vala_data_type_get_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), FALSE))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp879);
							} else {
								if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg)))) {
									ValaStruct* __temp880;
									ValaStruct* st;
									/* convert integer to pointer if this is a generic method parameter */
									__temp880 = NULL;
									st = (__temp880 = VALA_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg))), (__temp880 == NULL ? NULL : g_object_ref (__temp880)));
									if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
										ValaCCodeFunctionCall* cconv;
										ValaCCodeExpression* __temp882;
										ValaCCodeFunctionCall* __temp881;
										cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GINT_TO_POINTER")));
										vala_ccode_function_call_add_argument (cconv, cexpr);
										__temp882 = NULL;
										__temp881 = NULL;
										cexpr = (__temp882 = VALA_CCODE_EXPRESSION ((__temp881 = cconv, (__temp881 == NULL ? NULL : g_object_ref (__temp881)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp882);
										(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
									}
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								}
							}
						}
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
				vala_ccode_function_call_add_argument (ccall, cexpr);
				i++;
				if (params_it != NULL) {
					params_it = params_it->next;
				}
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			}
		}
		(__temp883 == NULL ? NULL : (__temp883 = (g_list_free (__temp883), NULL)));
	}
	while (params_it != NULL) {
		ValaFormalParameter* __temp884;
		ValaFormalParameter* param;
		__temp884 = NULL;
		param = (__temp884 = VALA_FORMAL_PARAMETER (params_it->data), (__temp884 == NULL ? NULL : g_object_ref (__temp884)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* __temp885;
			__temp885 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp885 = g_strdup_printf ("no default expression for argument %d", i)));
			(__temp885 = (g_free (__temp885), NULL));
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
			ValaArray* __temp886;
			ValaArray* arr;
			__temp886 = NULL;
			arr = (__temp886 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp886 == NULL ? NULL : g_object_ref (__temp886)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* __temp887;
					__temp887 = NULL;
					vala_ccode_function_call_add_argument (ccall, (__temp887 = vala_code_generator_get_array_length_cexpression (self, vala_formal_parameter_get_default_expression (param), dim)));
					(__temp887 = (g_object_unref (__temp887), NULL));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		params_it = params_it->next;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
		ValaArray* __temp888;
		ValaArray* arr;
		__temp888 = NULL;
		arr = (__temp888 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (__temp888 == NULL ? NULL : g_object_ref (__temp888)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaVariableDeclarator* temp_decl;
					ValaCCodeIdentifier* temp_ref;
					ValaVariableDeclarator* __temp889;
					ValaCCodeUnaryExpression* __temp890;
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
					temp_ref = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
					__temp889 = NULL;
					self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp889 = temp_decl, (__temp889 == NULL ? NULL : g_object_ref (__temp889))));
					__temp890 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp890 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(__temp890 == NULL ? NULL : (__temp890 = (g_object_unref (__temp890), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* __temp891;
					__temp891 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((__temp891 = vala_ccode_constant_new ("-1"))));
					(__temp891 == NULL ? NULL : (__temp891 = (g_object_unref (__temp891), NULL)));
				}
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_call_add_argument (ccall, instance);
	} else {
		if (ellipsis) {
			/* ensure variable argument list ends with NULL
			 * except when using printf-style arguments */
			if (m == NULL || !vala_method_get_printf_format (m)) {
				ValaCCodeConstant* __temp892;
				__temp892 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp892 = vala_ccode_constant_new ("NULL"))));
				(__temp892 == NULL ? NULL : (__temp892 = (g_object_unref (__temp892), NULL)));
			}
		}
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* __temp893;
		__temp893 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp893 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp893 == NULL ? NULL : (__temp893 = (g_object_unref (__temp893), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_type_reference_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))) != NULL) {
			if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))))) {
				ValaStruct* __temp894;
				ValaStruct* st;
				__temp894 = NULL;
				st = (__temp894 = VALA_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr)))), (__temp894 == NULL ? NULL : g_object_ref (__temp894)));
				if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeFunctionCall* cconv;
					ValaCCodeFunctionCall* __temp896;
					ValaCCodeFunctionCall* __temp895;
					cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_UINT")));
					vala_ccode_function_call_add_argument (cconv, VALA_CCODE_EXPRESSION (ccall));
					__temp896 = NULL;
					__temp895 = NULL;
					ccall = (__temp896 = (__temp895 = cconv, (__temp895 == NULL ? NULL : g_object_ref (__temp895))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp896);
					(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
				} else {
					if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
						ValaCCodeFunctionCall* cconv;
						ValaCCodeFunctionCall* __temp898;
						ValaCCodeFunctionCall* __temp897;
						cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_INT")));
						vala_ccode_function_call_add_argument (cconv, VALA_CCODE_EXPRESSION (ccall));
						__temp898 = NULL;
						__temp897 = NULL;
						ccall = (__temp898 = (__temp897 = cconv, (__temp897 == NULL ? NULL : g_object_ref (__temp897))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp898);
						(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
					}
				}
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaCCodeExpression* __temp900;
		GList* __temp899;
		ValaCCodeExpression* __temp901;
		ValaCCodeExpression* new_size;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaVariableDeclarator* __temp902;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* __temp903;
		ValaCCodeExpression* celems;
		char* __temp904;
		ValaCCodeIdentifier* __temp905;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* __temp906;
		ValaCCodeConstant* __temp907;
		ValaCCodeBinaryExpression* __temp908;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* __temp909;
		ValaCCodeConditionalExpression* __temp910;
		ValaCCodeAssignment* __temp911;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		__temp900 = NULL;
		__temp899 = NULL;
		__temp901 = NULL;
		new_size = (__temp901 = (__temp900 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((VALA_CODE_NODE ((__temp899 = vala_invocation_expression_get_argument_list (expr))->data)))), (__temp900 == NULL ? NULL : g_object_ref (__temp900))), (__temp899 == NULL ? NULL : (__temp899 = (g_list_free (__temp899), NULL))), __temp901);
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
		temp_ref = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
		__temp902 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp902 = temp_decl, (__temp902 == NULL ? NULL : g_object_ref (__temp902))));
		/* memset needs string.h */
		self->priv->string_h_needed = TRUE;
		clen = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1);
		__temp903 = NULL;
		celems = (__temp903 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp903 == NULL ? NULL : g_object_ref (__temp903)));
		__temp904 = NULL;
		__temp905 = NULL;
		csizeof = (__temp905 = vala_ccode_identifier_new (g_strdup_printf ("sizeof (%s)", (__temp904 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), FALSE)))), (__temp904 = (g_free (__temp904), NULL)), __temp905);
		cdelta = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)));
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		czero = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("memset")));
		__temp906 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp906 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(__temp906 == NULL ? NULL : (__temp906 = (g_object_unref (__temp906), NULL)));
		__temp907 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp907 = vala_ccode_constant_new ("0"))));
		(__temp907 == NULL ? NULL : (__temp907 = (g_object_unref (__temp907), NULL)));
		__temp908 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp908 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(__temp908 == NULL ? NULL : (__temp908 = (g_object_unref (__temp908), NULL)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		__temp909 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp909 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp909 == NULL ? NULL : (__temp909 = (g_object_unref (__temp909), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		__temp910 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp910 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp910 == NULL ? NULL : (__temp910 = (g_object_unref (__temp910), NULL)));
		__temp911 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp911 = vala_ccode_assignment_new (vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp911 == NULL ? NULL : (__temp911 = (g_object_unref (__temp911), NULL)));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen = (g_object_unref (clen), NULL));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
		ValaMethod* __temp912;
		ValaMethod* m;
		__temp912 = NULL;
		m = (__temp912 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp912 == NULL ? NULL : g_object_ref (__temp912)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaInterface* __temp913;
				ValaInterface* base_iface;
				char* __temp915;
				char* __temp914;
				char* __temp916;
				char* parent_iface_var;
				ValaCCodeMemberAccess* __temp917;
				__temp913 = NULL;
				base_iface = (__temp913 = VALA_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m)))))), (__temp913 == NULL ? NULL : g_object_ref (__temp913)));
				__temp915 = NULL;
				__temp914 = NULL;
				__temp916 = NULL;
				parent_iface_var = (__temp916 = g_strdup_printf ("%s_%s_parent_iface", (__temp914 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (self->priv->current_class), NULL)), (__temp915 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (base_iface), NULL))), (__temp915 = (g_free (__temp915), NULL)), (__temp914 = (g_free (__temp914), NULL)), __temp916);
				__temp917 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp917 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (parent_iface_var)), vala_method_get_name (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp917 == NULL ? NULL : (__temp917 = (g_object_unref (__temp917), NULL)));
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
			} else {
				if (vala_method_get_base_method (m) != NULL) {
					ValaClass* __temp918;
					ValaClass* base_class;
					char* __temp919;
					ValaCCodeFunctionCall* __temp920;
					ValaCCodeFunctionCall* vcast;
					ValaCCodeIdentifier* __temp922;
					char* __temp921;
					ValaCCodeMemberAccess* __temp923;
					__temp918 = NULL;
					base_class = (__temp918 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m)))))), (__temp918 == NULL ? NULL : g_object_ref (__temp918)));
					__temp919 = NULL;
					__temp920 = NULL;
					vcast = (__temp920 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp919 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (base_class), NULL)))))), (__temp919 = (g_free (__temp919), NULL)), __temp920);
					__temp922 = NULL;
					__temp921 = NULL;
					vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp922 = vala_ccode_identifier_new (g_strdup_printf ("%s_parent_class", (__temp921 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (self->priv->current_class), NULL)))))));
					(__temp922 == NULL ? NULL : (__temp922 = (g_object_unref (__temp922), NULL)));
					(__temp921 = (g_free (__temp921), NULL));
					__temp923 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp923 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_name (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp923 == NULL ? NULL : (__temp923 = (g_object_unref (__temp923), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				}
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaCCodeIdentifier* __temp924;
			__temp924 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp924 = vala_ccode_identifier_new (vala_method_get_cname (vala_method_get_base_interface_method (m)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp924 == NULL ? NULL : (__temp924 = (g_object_unref (__temp924), NULL)));
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaCCodeIdentifier* __temp925;
				__temp925 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp925 = vala_ccode_identifier_new (vala_method_get_cname (vala_method_get_base_method (m)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp925 == NULL ? NULL : (__temp925 = (g_object_unref (__temp925), NULL)));
			} else {
				ValaCCodeIdentifier* __temp926;
				__temp926 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp926 = vala_ccode_identifier_new (vala_method_get_cname (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp926 == NULL ? NULL : (__temp926 = (g_object_unref (__temp926), NULL)));
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
			ValaCCodeExpression* __temp927;
			__temp927 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp927 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (expr), 1)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp927 = (g_object_unref (__temp927), NULL));
		} else {
			if (VALA_IS_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
				ValaField* __temp928;
				ValaField* f;
				__temp928 = NULL;
				f = (__temp928 = VALA_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp928 == NULL ? NULL : g_object_ref (__temp928)));
				if (vala_field_get_instance (f)) {
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* inst;
					typed_inst = NULL;
					if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))) != VALA_CODE_NODE (base_type)) {
						ValaCCodeExpression* __temp929;
						/* FIXME: use C cast if debugging disabled*/
						__temp929 = NULL;
						typed_inst = (__temp929 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))), NULL))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp929);
						vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
					} else {
						ValaCCodeExpression* __temp931;
						ValaCCodeExpression* __temp930;
						__temp931 = NULL;
						__temp930 = NULL;
						typed_inst = (__temp931 = (__temp930 = pub_inst, (__temp930 == NULL ? NULL : g_object_ref (__temp930))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp931);
					}
					inst = NULL;
					if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* __temp932;
						__temp932 = NULL;
						inst = (__temp932 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp932);
					} else {
						ValaCCodeExpression* __temp934;
						ValaCCodeExpression* __temp933;
						__temp934 = NULL;
						__temp933 = NULL;
						inst = (__temp934 = (__temp933 = typed_inst, (__temp933 == NULL ? NULL : g_object_ref (__temp933))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp934);
					}
					if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))))) {
						ValaCCodeMemberAccess* __temp935;
						__temp935 = NULL;
						(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp935 = vala_ccode_member_access_new_pointer (inst, vala_field_get_cname (f))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
						(__temp935 == NULL ? NULL : (__temp935 = (g_object_unref (__temp935), NULL)));
					} else {
						ValaCCodeMemberAccess* __temp936;
						__temp936 = NULL;
						(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp936 = vala_ccode_member_access_new (inst, vala_field_get_cname (f), FALSE)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
						(__temp936 == NULL ? NULL : (__temp936 = (g_object_unref (__temp936), NULL)));
					}
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* __temp937;
					__temp937 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp937 = vala_ccode_identifier_new (vala_field_get_cname (f))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp937 == NULL ? NULL : (__temp937 = (g_object_unref (__temp937), NULL)));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
					ValaConstant* __temp938;
					ValaConstant* c;
					ValaCCodeIdentifier* __temp939;
					__temp938 = NULL;
					c = (__temp938 = VALA_CONSTANT (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp938 == NULL ? NULL : g_object_ref (__temp938)));
					__temp939 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp939 = vala_ccode_identifier_new (vala_constant_get_cname (c))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp939 == NULL ? NULL : (__temp939 = (g_object_unref (__temp939), NULL)));
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
						ValaProperty* __temp940;
						ValaProperty* prop;
						__temp940 = NULL;
						prop = (__temp940 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp940 == NULL ? NULL : g_object_ref (__temp940)));
						if (!vala_property_get_no_accessor_method (prop)) {
							ValaProperty* __temp941;
							ValaProperty* base_property;
							ValaDataType* __temp946;
							ValaDataType* base_property_type;
							char* __temp947;
							ValaCCodeFunctionCall* __temp948;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeExpression* __temp949;
							ValaCCodeExpression* typed_pub_inst;
							__temp941 = NULL;
							base_property = (__temp941 = prop, (__temp941 == NULL ? NULL : g_object_ref (__temp941)));
							if (vala_property_get_base_property (prop) != NULL) {
								ValaProperty* __temp943;
								ValaProperty* __temp942;
								__temp943 = NULL;
								__temp942 = NULL;
								base_property = (__temp943 = (__temp942 = vala_property_get_base_property (prop), (__temp942 == NULL ? NULL : g_object_ref (__temp942))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp943);
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaProperty* __temp945;
									ValaProperty* __temp944;
									__temp945 = NULL;
									__temp944 = NULL;
									base_property = (__temp945 = (__temp944 = vala_property_get_base_interface_property (prop), (__temp944 == NULL ? NULL : g_object_ref (__temp944))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp945);
								}
							}
							__temp946 = NULL;
							base_property_type = (__temp946 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))))), (__temp946 == NULL ? NULL : g_object_ref (__temp946)));
							__temp947 = NULL;
							__temp948 = NULL;
							ccall = (__temp948 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_%s", (__temp947 = vala_data_type_get_lower_case_cname (base_property_type, NULL)), vala_property_get_name (base_property))))), (__temp947 = (g_free (__temp947), NULL)), __temp948);
							__temp949 = NULL;
							typed_pub_inst = (__temp949 = pub_inst, (__temp949 == NULL ? NULL : g_object_ref (__temp949)));
							/* cast if necessary */
							if (base_property_type != base_type) {
								ValaCCodeFunctionCall* ccast;
								ValaCCodeExpression* __temp951;
								ValaCCodeFunctionCall* __temp950;
								/* FIXME: use C cast if debugging disabled*/
								ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (base_property_type, NULL))));
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								__temp951 = NULL;
								__temp950 = NULL;
								typed_pub_inst = (__temp951 = VALA_CCODE_EXPRESSION ((__temp950 = ccast, (__temp950 == NULL ? NULL : g_object_ref (__temp950)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp951);
								(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							}
							vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
							(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
						} else {
							ValaCCodeFunctionCall* ccall;
							ValaCCodeFunctionCall* ccast;
							ValaCCodeConstant* __temp952;
							ValaVariableDeclarator* temp_decl;
							ValaVariableDeclarator* __temp953;
							ValaCCodeIdentifier* ctemp;
							ValaCCodeUnaryExpression* __temp954;
							ValaCCodeConstant* __temp955;
							ValaCCodeCommaExpression* ccomma;
							ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_get")));
							ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
							vala_ccode_function_call_add_argument (ccast, pub_inst);
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
							/* property name is second argument of g_object_get*/
							__temp952 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp952 = vala_property_get_canonical_cconstant (prop))));
							(__temp952 = (g_object_unref (__temp952), NULL));
							/* we need a temporary variable to save the property value*/
							temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
							__temp953 = NULL;
							self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp953 = temp_decl, (__temp953 == NULL ? NULL : g_object_ref (__temp953))));
							ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
							__temp954 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp954 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
							(__temp954 == NULL ? NULL : (__temp954 = (g_object_unref (__temp954), NULL)));
							__temp955 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp955 = vala_ccode_constant_new ("NULL"))));
							(__temp955 == NULL ? NULL : (__temp955 = (g_object_unref (__temp955), NULL)));
							ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
							(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
							ValaEnumValue* __temp956;
							ValaEnumValue* ev;
							ValaCCodeConstant* __temp957;
							__temp956 = NULL;
							ev = (__temp956 = VALA_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp956 == NULL ? NULL : g_object_ref (__temp956)));
							__temp957 = NULL;
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp957 = vala_ccode_constant_new (vala_enum_value_get_cname (ev))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(__temp957 == NULL ? NULL : (__temp957 = (g_object_unref (__temp957), NULL)));
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
								ValaVariableDeclarator* __temp958;
								ValaVariableDeclarator* decl;
								ValaCCodeIdentifier* __temp959;
								__temp958 = NULL;
								decl = (__temp958 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp958 == NULL ? NULL : g_object_ref (__temp958)));
								__temp959 = NULL;
								(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp959 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
								(__temp959 == NULL ? NULL : (__temp959 = (g_object_unref (__temp959), NULL)));
								(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
									ValaFormalParameter* __temp960;
									ValaFormalParameter* p;
									__temp960 = NULL;
									p = (__temp960 = VALA_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp960 == NULL ? NULL : g_object_ref (__temp960)));
									if (g_utf8_collate (vala_formal_parameter_get_name (p), "this") == 0) {
										(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
									} else {
										if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (p)) || vala_type_reference_get_is_ref (vala_formal_parameter_get_type_reference (p))) {
											ValaCCodeIdentifier* __temp961;
											__temp961 = NULL;
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp961 = vala_ccode_identifier_new (g_strdup_printf ("(*%s)", vala_formal_parameter_get_name (p)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(__temp961 == NULL ? NULL : (__temp961 = (g_object_unref (__temp961), NULL)));
										} else {
											ValaCCodeIdentifier* __temp962;
											__temp962 = NULL;
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp962 = vala_ccode_identifier_new (vala_formal_parameter_get_name (p))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(__temp962 == NULL ? NULL : (__temp962 = (g_object_unref (__temp962), NULL)));
										}
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
										ValaSignal* __temp963;
										ValaSignal* sig;
										ValaDataType* __temp964;
										ValaDataType* cl;
										__temp963 = NULL;
										sig = (__temp963 = VALA_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp963 == NULL ? NULL : g_object_ref (__temp963)));
										__temp964 = NULL;
										cl = (__temp964 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (sig))))), (__temp964 == NULL ? NULL : g_object_ref (__temp964)));
										if (vala_signal_get_has_emitter (sig)) {
											char* __temp965;
											ValaCCodeFunctionCall* __temp966;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeExpression* __temp967;
											ValaCCodeExpression* typed_pub_inst;
											__temp965 = NULL;
											__temp966 = NULL;
											ccall = (__temp966 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_%s", (__temp965 = vala_data_type_get_lower_case_cname (cl, NULL)), vala_signal_get_name (sig))))), (__temp965 = (g_free (__temp965), NULL)), __temp966);
											/* explicitly use strong reference as ccast
											 * gets unrefed at the end of the inner block
											 */
											__temp967 = NULL;
											typed_pub_inst = (__temp967 = pub_inst, (__temp967 == NULL ? NULL : g_object_ref (__temp967)));
											/* cast if necessary */
											if (cl != base_type) {
												ValaCCodeFunctionCall* ccast;
												ValaCCodeExpression* __temp969;
												ValaCCodeFunctionCall* __temp968;
												/* FIXME: use C cast if debugging disabled*/
												ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (cl, NULL))));
												vala_ccode_function_call_add_argument (ccast, pub_inst);
												__temp969 = NULL;
												__temp968 = NULL;
												typed_pub_inst = (__temp969 = VALA_CCODE_EXPRESSION ((__temp968 = ccast, (__temp968 == NULL ? NULL : g_object_ref (__temp968)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp969);
												(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
											}
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeFunctionCall* ccall;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* __temp970;
											ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_emit_by_name")));
											/* FIXME: use C cast if debugging disabled*/
											ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											__temp970 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp970 = vala_signal_get_canonical_cconstant (sig))));
											(__temp970 = (g_object_unref (__temp970), NULL));
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* __temp971;
		__temp971 = NULL;
		pub_inst = (__temp971 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp971);
		if (self->priv->current_type_symbol != NULL) {
			ValaDataType* __temp973;
			ValaDataType* __temp972;
			/* base type is available if this is a type method */
			__temp973 = NULL;
			__temp972 = NULL;
			base_type = (__temp973 = (__temp972 = VALA_DATA_TYPE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp972 == NULL ? NULL : g_object_ref (__temp972))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp973);
			if (!vala_data_type_is_reference_type (base_type)) {
				ValaCCodeExpression* __temp974;
				__temp974 = NULL;
				pub_inst = (__temp974 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp974);
			}
		}
	} else {
		ValaCCodeExpression* __temp976;
		ValaCCodeExpression* __temp975;
		__temp976 = NULL;
		__temp975 = NULL;
		pub_inst = (__temp976 = (__temp975 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)))), (__temp975 == NULL ? NULL : g_object_ref (__temp975))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp976);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* __temp978;
			ValaDataType* __temp977;
			__temp978 = NULL;
			__temp977 = NULL;
			base_type = (__temp978 = (__temp977 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (expr))), (__temp977 == NULL ? NULL : g_object_ref (__temp977))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp978);
		}
	}
	vala_code_generator_process_cmember (self, expr, pub_inst, base_type);
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp980;
	ValaSymbol* __temp979;
	ValaTypeReference* __temp982;
	ValaTypeReference* __temp981;
	ValaSymbol* __temp984;
	ValaSymbol* __temp983;
	ValaTypeReference* __temp985;
	ValaCCodeFunction* __temp990;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFormalParameter* instance_param;
	GList* params;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	__temp980 = NULL;
	__temp979 = NULL;
	self->priv->current_symbol = (__temp980 = (__temp979 = vala_code_node_get_symbol (VALA_CODE_NODE (m)), (__temp979 == NULL ? NULL : g_object_ref (__temp979))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp980);
	__temp982 = NULL;
	__temp981 = NULL;
	self->priv->current_return_type = (__temp982 = (__temp981 = vala_method_get_return_type (m), (__temp981 == NULL ? NULL : g_object_ref (__temp981))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp982);
	if (VALA_IS_CREATION_METHOD (m)) {
		self->priv->in_creation_method = TRUE;
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (self->priv->current_class != NULL && vala_method_get_body (m) != NULL) {
			vala_code_generator_add_object_creation (self, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
		}
		self->priv->in_creation_method = FALSE;
	}
	__temp984 = NULL;
	__temp983 = NULL;
	self->priv->current_symbol = (__temp984 = (__temp983 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp983 == NULL ? NULL : g_object_ref (__temp983))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp984);
	__temp985 = NULL;
	self->priv->current_return_type = (__temp985 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp985);
	if (self->priv->current_type_symbol != NULL && VALA_IS_INTERFACE (vala_symbol_get_node (self->priv->current_type_symbol))) {
		ValaInterface* __temp986;
		ValaInterface* iface;
		__temp986 = NULL;
		iface = (__temp986 = VALA_INTERFACE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp986 == NULL ? NULL : g_object_ref (__temp986)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	if (vala_symbol_get_parent_symbol (self->priv->current_symbol) != NULL && VALA_IS_METHOD (vala_symbol_get_node (vala_symbol_get_parent_symbol (self->priv->current_symbol)))) {
		ValaMethod* __temp987;
		ValaMethod* up_method;
		ValaTypeReference* __temp989;
		ValaTypeReference* __temp988;
		/* lambda expressions produce nested methods */
		__temp987 = NULL;
		up_method = (__temp987 = VALA_METHOD (vala_symbol_get_node (vala_symbol_get_parent_symbol (self->priv->current_symbol))), (__temp987 == NULL ? NULL : g_object_ref (__temp987)));
		__temp989 = NULL;
		__temp988 = NULL;
		self->priv->current_return_type = (__temp989 = (__temp988 = vala_method_get_return_type (up_method), (__temp988 == NULL ? NULL : g_object_ref (__temp988))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp989);
		(up_method == NULL ? NULL : (up_method = (g_object_unref (up_method), NULL)));
	}
	__temp990 = NULL;
	self->priv->function = (__temp990 = vala_ccode_function_new (vala_method_get_real_cname (m), vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp990);
	vdeclarator = NULL;
	instance_param = NULL;
	if (vala_method_get_instance (m)) {
		ValaTypeReference* this_type;
		ValaDataType* __temp991;
		this_type = vala_type_reference_new ();
		__temp991 = NULL;
		(vala_type_reference_set_data_type (this_type, (__temp991 = vala_code_generator_find_parent_type (self, VALA_CODE_NODE (m)))), vala_type_reference_get_data_type (this_type));
		(__temp991 == NULL ? NULL : (__temp991 = (g_object_unref (__temp991), NULL)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaTypeReference* base_type;
			ValaCCodeFormalParameter* __temp992;
			base_type = vala_type_reference_new ();
			(vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m))))))), vala_type_reference_get_data_type (base_type));
			__temp992 = NULL;
			instance_param = (__temp992 = vala_ccode_formal_parameter_new ("base", vala_type_reference_get_cname (base_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp992);
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaTypeReference* base_type;
				ValaCCodeFormalParameter* __temp993;
				base_type = vala_type_reference_new ();
				(vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m))))))), vala_type_reference_get_data_type (base_type));
				__temp993 = NULL;
				instance_param = (__temp993 = vala_ccode_formal_parameter_new ("base", vala_type_reference_get_cname (base_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp993);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (vala_method_get_instance_by_reference (m)) {
					ValaCCodeFormalParameter* __temp994;
					__temp994 = NULL;
					instance_param = (__temp994 = vala_ccode_formal_parameter_new ("*self", vala_type_reference_get_cname (this_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp994);
				} else {
					ValaCCodeFormalParameter* __temp995;
					__temp995 = NULL;
					instance_param = (__temp995 = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp995);
				}
			}
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_add_parameter (self->priv->function, instance_param);
		}
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* __temp996;
			vdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE));
			__temp996 = NULL;
			vdeclarator = (__temp996 = vala_ccode_function_declarator_new (vala_method_get_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), __temp996);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (self->priv->type_struct, vdecl);
			vala_ccode_function_declarator_add_parameter (vdeclarator, instance_param);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m) && self->priv->current_class != NULL) {
		{
			GList* __temp999;
			GList* type_param_it;
			__temp999 = NULL;
			__temp999 = vala_class_get_type_parameters (self->priv->current_class);
			for (type_param_it = __temp999; type_param_it != NULL; type_param_it = type_param_it->next) {
				ValaTypeParameter* type_param;
				type_param = type_param_it->data;
				{
					char* __temp997;
					ValaCCodeFormalParameter* __temp998;
					ValaCCodeFormalParameter* cparam;
					/* memory management for generic types*/
					__temp997 = NULL;
					__temp998 = NULL;
					cparam = (__temp998 = vala_ccode_formal_parameter_new (g_strdup_printf ("%s_destroy_func", (__temp997 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), "GDestroyNotify"), (__temp997 = (g_free (__temp997), NULL)), __temp998);
					vala_ccode_function_add_parameter (self->priv->function, cparam);
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(__temp999 == NULL ? NULL : (__temp999 = (g_list_free (__temp999), NULL)));
		}
	}
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	{
		GList* __temp1002;
		GList* param_it;
		__temp1002 = NULL;
		__temp1002 = params;
		for (param_it = __temp1002; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
					ValaArray* __temp1000;
					ValaArray* arr;
					char* length_ctype;
					__temp1000 = NULL;
					arr = (__temp1000 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1000 == NULL ? NULL : g_object_ref (__temp1000)));
					length_ctype = g_strdup ("int");
					if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
						char* __temp1001;
						__temp1001 = NULL;
						length_ctype = (__temp1001 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), __temp1001);
					}
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							ValaCCodeFormalParameter* cparam;
							cparam = vala_ccode_formal_parameter_new (vala_code_generator_get_array_length_cname (self, vala_formal_parameter_get_name (param), dim), length_ctype);
							vala_ccode_function_add_parameter (self->priv->function, cparam);
							if (vdeclarator != NULL) {
								vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					(length_ctype = (g_free (length_ctype), NULL));
				}
				vala_ccode_function_add_parameter (self->priv->function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				}
			}
		}
	}
	if (vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_add_parameter (self->priv->function, instance_param);
	}
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (m->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* __temp1003;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			__temp1003 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1003 = vala_ccode_function_copy (self->priv->function))));
			(__temp1003 = (g_object_unref (__temp1003), NULL));
		} else {
			ValaCCodeFunction* __temp1004;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			(vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_function_get_modifiers (self->priv->function));
			__temp1004 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1004 = vala_ccode_function_copy (self->priv->function))));
			(__temp1004 = (g_object_unref (__temp1004), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			(vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m))))), vala_ccode_function_get_block (self->priv->function));
			cinit = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))) {
				ValaClass* __temp1005;
				ValaClass* cl;
				__temp1005 = NULL;
				cl = (__temp1005 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1005 == NULL ? NULL : g_object_ref (__temp1005)));
				if (vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL) {
					ValaCCodeFunctionCall* ccall;
					ValaCCodeIdentifier* __temp1006;
					char* __temp1007;
					ValaCCodeDeclaration* __temp1008;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* __temp1009;
					ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
					__temp1006 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1006 = vala_ccode_identifier_new ("base"))));
					(__temp1006 == NULL ? NULL : (__temp1006 = (g_object_unref (__temp1006), NULL)));
					__temp1007 = NULL;
					__temp1008 = NULL;
					cdecl_ = (__temp1008 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp1007 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp1007 = (g_free (__temp1007), NULL)), __temp1008);
					__temp1009 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1009 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp1009 == NULL ? NULL : (__temp1009 = (g_object_unref (__temp1009), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* __temp1010;
						__temp1010 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp1010 = vala_code_generator_create_method_type_check_statement (self, m, VALA_DATA_TYPE (cl), TRUE, "self"))));
						(__temp1010 == NULL ? NULL : (__temp1010 = (g_object_unref (__temp1010), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GList* __temp1012;
				GList* param_it;
				__temp1012 = NULL;
				__temp1012 = vala_invokable_get_parameters (VALA_INVOKABLE (m));
				for (param_it = __temp1012; param_it != NULL; param_it = param_it->next) {
					ValaFormalParameter* param;
					param = param_it->data;
					{
						ValaDataType* __temp1011;
						ValaDataType* t;
						__temp1011 = NULL;
						t = (__temp1011 = vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), (__temp1011 == NULL ? NULL : g_object_ref (__temp1011)));
						if (t != NULL && vala_data_type_is_reference_type (t) && !vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
							ValaCCodeStatement* type_check;
							type_check = vala_code_generator_create_method_type_check_statement (self, m, t, vala_type_reference_get_non_null (vala_formal_parameter_get_type_reference (param)), vala_formal_parameter_get_name (param));
							if (type_check != NULL) {
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
							}
							(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
						}
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(__temp1012 == NULL ? NULL : (__temp1012 = (g_list_free (__temp1012), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* __temp1013;
				__temp1013 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp1013 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(__temp1013 == NULL ? NULL : (__temp1013 = (g_object_unref (__temp1013), NULL)));
			}
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (self->priv->current_class != NULL) {
					gint n_params;
					GList* __temp1014;
					ValaCCodeFunctionCall* cparamsinit;
					ValaCCodeIdentifier* __temp1015;
					ValaCCodeConstant* __temp1016;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* __temp1017;
					ValaCCodeDeclaration* __temp1018;
					ValaCCodeVariableDeclarator* __temp1019;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					__temp1014 = NULL;
					n_params = n_params + (((gint) g_list_length ((__temp1014 = vala_class_get_type_parameters (self->priv->current_class)))));
					(__temp1014 == NULL ? NULL : (__temp1014 = (g_list_free (__temp1014), NULL)));
					/* declare construction parameter array*/
					cparamsinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
					__temp1015 = NULL;
					vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp1015 = vala_ccode_identifier_new ("GParameter"))));
					(__temp1015 == NULL ? NULL : (__temp1015 = (g_object_unref (__temp1015), NULL)));
					__temp1016 = NULL;
					vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp1016 = vala_ccode_constant_new (g_strdup_printf ("%i", n_params)))));
					(__temp1016 == NULL ? NULL : (__temp1016 = (g_object_unref (__temp1016), NULL)));
					cdecl_ = vala_ccode_declaration_new ("GParameter *");
					__temp1017 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1017 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
					(__temp1017 == NULL ? NULL : (__temp1017 = (g_object_unref (__temp1017), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					__temp1018 = NULL;
					cdecl_ = (__temp1018 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp1018);
					__temp1019 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1019 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("__params"))))));
					(__temp1019 == NULL ? NULL : (__temp1019 = (g_object_unref (__temp1019), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					{
						GList* __temp1029;
						GList* type_param_it;
						__temp1029 = NULL;
						__temp1029 = vala_class_get_type_parameters (self->priv->current_class);
						for (type_param_it = __temp1029; type_param_it != NULL; type_param_it = type_param_it->next) {
							ValaTypeParameter* type_param;
							type_param = type_param_it->data;
							{
								char* __temp1020;
								char* __temp1021;
								char* func_name;
								char* __temp1022;
								ValaCCodeConstant* __temp1023;
								ValaCCodeConstant* func_name_constant;
								ValaCCodeIdentifier* cpointer;
								ValaCCodeCommaExpression* ccomma;
								ValaCCodeMemberAccess* cnamemember;
								ValaCCodeAssignment* __temp1024;
								ValaCCodeUnaryExpression* gvaluearg;
								ValaCCodeFunctionCall* cvalueinit;
								ValaCCodeIdentifier* __temp1025;
								ValaCCodeFunctionCall* cvalueset;
								ValaCCodeIdentifier* __temp1026;
								ValaCCodeUnaryExpression* __temp1027;
								ValaCCodeExpressionStatement* __temp1028;
								/* destroy func properties for generic types */
								__temp1020 = NULL;
								__temp1021 = NULL;
								func_name = (__temp1021 = g_strdup_printf ("%s_destroy_func", (__temp1020 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp1020 = (g_free (__temp1020), NULL)), __temp1021);
								__temp1022 = NULL;
								__temp1023 = NULL;
								func_name_constant = (__temp1023 = vala_ccode_constant_new (g_strdup_printf ("\"%s-destroy-func\"", (__temp1022 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1)))), (__temp1022 = (g_free (__temp1022), NULL)), __temp1023);
								/* this property is used as a construction parameter*/
								cpointer = vala_ccode_identifier_new ("__params_it");
								ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
								/* set name in array for current parameter*/
								cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
								__temp1024 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1024 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (func_name_constant), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(__temp1024 == NULL ? NULL : (__temp1024 = (g_object_unref (__temp1024), NULL)));
								gvaluearg = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")));
								/* initialize GValue in array for current parameter*/
								cvalueinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_init")));
								vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
								__temp1025 = NULL;
								vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp1025 = vala_ccode_identifier_new ("G_TYPE_POINTER"))));
								(__temp1025 == NULL ? NULL : (__temp1025 = (g_object_unref (__temp1025), NULL)));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
								/* set GValue for current parameter*/
								cvalueset = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_set_pointer")));
								vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
								__temp1026 = NULL;
								vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION ((__temp1026 = vala_ccode_identifier_new (func_name))));
								(__temp1026 == NULL ? NULL : (__temp1026 = (g_object_unref (__temp1026), NULL)));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
								/* move pointer to next parameter in array*/
								__temp1027 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1027 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
								(__temp1027 == NULL ? NULL : (__temp1027 = (g_object_unref (__temp1027), NULL)));
								__temp1028 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp1028 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccomma)))));
								(__temp1028 == NULL ? NULL : (__temp1028 = (g_object_unref (__temp1028), NULL)));
								(func_name = (g_free (func_name), NULL));
								(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
								(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
								(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
								(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
								(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
								(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
							}
						}
						(__temp1029 == NULL ? NULL : (__temp1029 = (g_list_free (__temp1029), NULL)));
					}
					(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					ValaStruct* __temp1030;
					ValaStruct* st;
					char* __temp1031;
					ValaCCodeDeclaration* __temp1032;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeFunctionCall* ccall;
					ValaCCodeConstant* __temp1033;
					ValaCCodeConstant* __temp1034;
					ValaCCodeVariableDeclarator* __temp1035;
					__temp1030 = NULL;
					st = (__temp1030 = VALA_STRUCT (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1030 == NULL ? NULL : g_object_ref (__temp1030)));
					__temp1031 = NULL;
					__temp1032 = NULL;
					cdecl_ = (__temp1032 = vala_ccode_declaration_new (g_strconcat ((__temp1031 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL)), (__temp1031 = (g_free (__temp1031), NULL)), __temp1032);
					ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
					__temp1033 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1033 = vala_ccode_constant_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))));
					(__temp1033 == NULL ? NULL : (__temp1033 = (g_object_unref (__temp1033), NULL)));
					__temp1034 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1034 = vala_ccode_constant_new ("1"))));
					(__temp1034 == NULL ? NULL : (__temp1034 = (g_object_unref (__temp1034), NULL)));
					__temp1035 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1035 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp1035 == NULL ? NULL : (__temp1035 = (g_object_unref (__temp1035), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				}
			}
			if (vala_code_context_get_module_init_method (self->priv->context) == m && self->priv->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (self->priv->module_init_fragment));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		ValaCCodeFunction* vfunc;
		ValaTypeReference* this_type;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* __temp1042;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* __temp1043;
		GList* params;
		ValaCCodeFunction* __temp1048;
		vfunc = vala_ccode_function_new (vala_method_get_cname (m), vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE));
		this_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (this_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))), vala_type_reference_get_data_type (this_type));
		cparam = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE));
		vala_ccode_function_add_parameter (vfunc, cparam);
		vblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))) {
			ValaInterface* __temp1036;
			ValaInterface* iface;
			ValaCCodeFunctionCall* __temp1038;
			char* __temp1037;
			__temp1036 = NULL;
			iface = (__temp1036 = VALA_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1036 == NULL ? NULL : g_object_ref (__temp1036)));
			__temp1038 = NULL;
			__temp1037 = NULL;
			vcast = (__temp1038 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_INTERFACE", (__temp1037 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp1038);
			(__temp1037 = (g_free (__temp1037), NULL));
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* __temp1039;
			ValaClass* cl;
			ValaCCodeFunctionCall* __temp1041;
			char* __temp1040;
			__temp1039 = NULL;
			cl = (__temp1039 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1039 == NULL ? NULL : g_object_ref (__temp1039)));
			__temp1041 = NULL;
			__temp1040 = NULL;
			vcast = (__temp1041 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_CLASS", (__temp1040 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp1041);
			(__temp1040 = (g_free (__temp1040), NULL));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		__temp1042 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp1042 = vala_ccode_identifier_new ("self"))));
		(__temp1042 == NULL ? NULL : (__temp1042 = (g_object_unref (__temp1042), NULL)));
		vcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_name (m))));
		__temp1043 = NULL;
		vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp1043 = vala_ccode_identifier_new ("self"))));
		(__temp1043 == NULL ? NULL : (__temp1043 = (g_object_unref (__temp1043), NULL)));
		params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		{
			GList* __temp1045;
			GList* param_it;
			__temp1045 = NULL;
			__temp1045 = params;
			for (param_it = __temp1045; param_it != NULL; param_it = param_it->next) {
				ValaFormalParameter* param;
				param = param_it->data;
				{
					ValaCCodeIdentifier* __temp1044;
					vala_ccode_function_add_parameter (vfunc, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					__temp1044 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp1044 = vala_ccode_identifier_new (vala_formal_parameter_get_name (param)))));
					(__temp1044 == NULL ? NULL : (__temp1044 = (g_object_unref (__temp1044), NULL)));
				}
			}
		}
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
			ValaCCodeExpressionStatement* __temp1046;
			__temp1046 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp1046 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp1046 == NULL ? NULL : (__temp1046 = (g_object_unref (__temp1046), NULL)));
		} else {
			ValaCCodeReturnStatement* __temp1047;
			/* pass method return value */
			__temp1047 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp1047 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp1047 == NULL ? NULL : (__temp1047 = (g_object_unref (__temp1047), NULL)));
		}
		__temp1048 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1048 = vala_ccode_function_copy (vfunc))));
		(__temp1048 = (g_object_unref (__temp1048), NULL));
		(vala_ccode_function_set_block (vfunc, vblock), vala_ccode_function_get_block (vfunc));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeReturnStatement* creturn;
		ValaCCodeIdentifier* __temp1049;
		creturn = vala_ccode_return_statement_new (NULL);
		__temp1049 = NULL;
		(vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((__temp1049 = vala_ccode_identifier_new ("self")))), vala_ccode_return_statement_get_return_expression (creturn));
		(__temp1049 == NULL ? NULL : (__temp1049 = (g_object_unref (__temp1049), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (creturn));
		(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_code_generator_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* __temp1050;
		ValaCCodeFormalParameter* __temp1051;
		ValaCCodeBlock* main_block;
		ValaCCodeExpressionStatement* __temp1052;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		__temp1050 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp1050 = vala_ccode_formal_parameter_new ("argc", "int")));
		(__temp1050 == NULL ? NULL : (__temp1050 = (g_object_unref (__temp1050), NULL)));
		__temp1051 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp1051 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(__temp1051 == NULL ? NULL : (__temp1051 = (g_object_unref (__temp1051), NULL)));
		main_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		__temp1052 = NULL;
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1052 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_init"))))))));
		(__temp1052 == NULL ? NULL : (__temp1052 = (g_object_unref (__temp1052), NULL)));
		main_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_ccode_function_get_name (self->priv->function))));
		if (args_parameter) {
			ValaCCodeIdentifier* __temp1053;
			ValaCCodeIdentifier* __temp1054;
			__temp1053 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp1053 = vala_ccode_identifier_new ("argc"))));
			(__temp1053 == NULL ? NULL : (__temp1053 = (g_object_unref (__temp1053), NULL)));
			__temp1054 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp1054 = vala_ccode_identifier_new ("argv"))));
			(__temp1054 == NULL ? NULL : (__temp1054 = (g_object_unref (__temp1054), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* __temp1055;
			__temp1055 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1055 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp1055 == NULL ? NULL : (__temp1055 = (g_object_unref (__temp1055), NULL)));
		} else {
			ValaCCodeExpressionStatement* __temp1056;
			ValaCCodeReturnStatement* __temp1057;
			/* method returns void, always use 0 as exit code*/
			__temp1056 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1056 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp1056 == NULL ? NULL : (__temp1056 = (g_object_unref (__temp1056), NULL)));
			__temp1057 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1057 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
			(__temp1057 == NULL ? NULL : (__temp1057 = (g_object_unref (__temp1057), NULL)));
		}
		(vala_ccode_function_set_block (cmain, main_block), vala_ccode_function_get_block (cmain));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (m), vala_type_reference_get_data_type (vala_method_get_return_type (m)), t, non_null, var_name);
}


static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (getter) {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), t, non_null, var_name);
	} else {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), NULL, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name)
{
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* __temp1072;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if (VALA_IS_CLASS (t) || VALA_IS_INTERFACE (t)) {
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* __temp1061;
		ValaCCodeFunctionCall* __temp1062;
		ValaCCodeExpression* cexpr;
		ctype_check = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (t, "IS_"))));
		__temp1061 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((__temp1061 = vala_ccode_identifier_new (var_name))));
		(__temp1061 == NULL ? NULL : (__temp1061 = (g_object_unref (__temp1061), NULL)));
		__temp1062 = NULL;
		cexpr = VALA_CCODE_EXPRESSION ((__temp1062 = ctype_check, (__temp1062 == NULL ? NULL : g_object_ref (__temp1062))));
		if (!non_null) {
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* __temp1063;
			cnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (var_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			__temp1063 = NULL;
			cexpr = (__temp1063 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1063);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer __temp1064;
			return VALA_CCODE_STATEMENT ((__temp1064 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1064));
		} else {
			ValaCCodeBinaryExpression* cnonnull;
			cnonnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (var_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (ret_type == NULL) {
		ValaCCodeIdentifier* __temp1065;
		/* void function */
		__temp1065 = NULL;
		(vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp1065 = vala_ccode_identifier_new ("g_return_if_fail")))), vala_ccode_function_call_get_call (ccheck));
		(__temp1065 == NULL ? NULL : (__temp1065 = (g_object_unref (__temp1065), NULL)));
	} else {
		ValaCCodeIdentifier* __temp1066;
		__temp1066 = NULL;
		(vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp1066 = vala_ccode_identifier_new ("g_return_val_if_fail")))), vala_ccode_function_call_get_call (ccheck));
		(__temp1066 == NULL ? NULL : (__temp1066 = (g_object_unref (__temp1066), NULL)));
		if (vala_data_type_is_reference_type (ret_type) || VALA_IS_POINTER (ret_type)) {
			ValaCCodeConstant* __temp1067;
			__temp1067 = NULL;
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION ((__temp1067 = vala_ccode_constant_new ("NULL"))));
			(__temp1067 == NULL ? NULL : (__temp1067 = (g_object_unref (__temp1067), NULL)));
		} else {
			char* __temp1068;
			gboolean __temp1069;
			__temp1068 = NULL;
			if ((__temp1069 = (__temp1068 = vala_data_type_get_default_value (ret_type)) != NULL, (__temp1068 = (g_free (__temp1068), NULL)), __temp1069)) {
				ValaCCodeConstant* __temp1070;
				__temp1070 = NULL;
				vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION ((__temp1070 = vala_ccode_constant_new (vala_data_type_get_default_value (ret_type)))));
				(__temp1070 == NULL ? NULL : (__temp1070 = (g_object_unref (__temp1070), NULL)));
			} else {
				ValaCCodeExpressionStatement* __temp1071;
				vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
				__temp1071 = NULL;
				return VALA_CCODE_STATEMENT ((__temp1071 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1071));
			}
		}
	}
	__temp1072 = NULL;
	return VALA_CCODE_STATEMENT ((__temp1072 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1072));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaCodeNode* node)
{
	ValaSymbol* __temp1073;
	ValaSymbol* sym;
	gpointer __temp1078;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (node == NULL || VALA_IS_CODE_NODE (node), NULL);
	__temp1073 = NULL;
	sym = (__temp1073 = vala_code_node_get_symbol (node), (__temp1073 == NULL ? NULL : g_object_ref (__temp1073)));
	while (sym != NULL) {
		ValaSymbol* __temp1077;
		ValaSymbol* __temp1076;
		if (VALA_IS_DATA_TYPE (vala_symbol_get_node (sym))) {
			ValaDataType* __temp1074;
			ValaDataType* __temp1075;
			__temp1074 = NULL;
			__temp1075 = NULL;
			return (__temp1075 = (__temp1074 = VALA_DATA_TYPE (vala_symbol_get_node (sym)), (__temp1074 == NULL ? NULL : g_object_ref (__temp1074))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp1075);
		}
		__temp1077 = NULL;
		__temp1076 = NULL;
		sym = (__temp1077 = (__temp1076 = vala_symbol_get_parent_symbol (sym), (__temp1076 == NULL ? NULL : g_object_ref (__temp1076))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp1077);
	}
	return VALA_DATA_TYPE ((__temp1078 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp1078));
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_code_visitor_visit_method (VALA_CODE_VISITOR (self), VALA_METHOD (m));
}


static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter)
{
	GList* params;
	ValaFormalParameter* __temp1085;
	ValaFormalParameter* param;
	ValaArray* __temp1088;
	ValaArray* array_type;
	gboolean __temp1090;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_method_get_name (m) == NULL || g_utf8_collate (vala_method_get_name (m), "main") != 0) {
		return FALSE;
	}
	/* method must be called "main"*/
	if (vala_method_get_instance (m)) {
		return FALSE;
	}
	/* method must be static*/
	if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == vala_type_reference_get_data_type (self->priv->int_type)) {
			(*return_value) = TRUE;
		} else {
			return FALSE;
		}
	}
	/* return type must be void or int*/
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	if (g_list_length (params) == 0) {
		gboolean __temp1083;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (__temp1083 = TRUE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1083);
	}
	if (g_list_length (params) > 1) {
		gboolean __temp1084;
		return (__temp1084 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1084);
	}
	/* method must not have more than one parameter*/
	__temp1085 = NULL;
	param = (__temp1085 = VALA_FORMAL_PARAMETER (params->data), (__temp1085 == NULL ? NULL : g_object_ref (__temp1085)));
	if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
		gboolean __temp1086;
		return (__temp1086 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1086);
	}
	/* parameter must not be an out parameter*/
	if (!(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) {
		gboolean __temp1087;
		return (__temp1087 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1087);
	}
	/* parameter must be an array*/
	__temp1088 = NULL;
	array_type = (__temp1088 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1088 == NULL ? NULL : g_object_ref (__temp1088)));
	if (vala_array_get_element_type (array_type) != vala_type_reference_get_data_type (self->priv->string_type)) {
		gboolean __temp1089;
		return (__temp1089 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp1089);
	}
	/* parameter must be an array of strings*/
	(*args_parameter) = TRUE;
	return (__temp1090 = TRUE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp1090);
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup (("POINTER"));
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup (("VOID"));
		} else {
			return vala_data_type_get_marshaller_type_name (vala_type_reference_get_data_type (t));
		}
	}
}


static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix)
{
	char* signature;
	char* ret;
	GList* params;
	char* __temp1095;
	char* __temp1094;
	char* __temp1100;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = vala_code_generator_get_signal_signature (self, sig);
	ret = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	if (prefix == NULL) {
		/* FIXME remove equality check with cast in next revision*/
		if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->predefined_marshal_list, signature)) != ((gboolean) NULL)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	__temp1095 = NULL;
	__temp1094 = NULL;
	ret = (__temp1095 = g_strdup_printf ("%s_%s_", prefix, (__temp1094 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (ret = (g_free (ret), NULL)), __temp1095);
	(__temp1094 = (g_free (__temp1094), NULL));
	if (params == NULL) {
		char* __temp1096;
		__temp1096 = NULL;
		ret = (__temp1096 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), __temp1096);
	} else {
		{
			GList* __temp1099;
			GList* p_it;
			__temp1099 = NULL;
			__temp1099 = params;
			for (p_it = __temp1099; p_it != NULL; p_it = p_it->next) {
				ValaFormalParameter* p;
				p = p_it->data;
				{
					char* __temp1098;
					char* __temp1097;
					__temp1098 = NULL;
					__temp1097 = NULL;
					ret = (__temp1098 = g_strdup_printf ("%s_%s", ret, (__temp1097 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (ret = (g_free (ret), NULL)), __temp1098);
					(__temp1097 = (g_free (__temp1097), NULL));
				}
			}
		}
	}
	__temp1100 = NULL;
	return (__temp1100 = ret, (signature = (g_free (signature), NULL)), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1100);
	(signature = (g_free (signature), NULL));
	(ret = (g_free (ret), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup ("void");
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (t)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (t))) {
				return g_strdup ("GObject *");
			} else {
				if (VALA_IS_STRUCT (vala_type_reference_get_data_type (t))) {
					if (vala_data_type_is_reference_type (VALA_DATA_TYPE ((VALA_STRUCT (vala_type_reference_get_data_type (t)))))) {
						return g_strdup ("gpointer");
					} else {
						return vala_data_type_get_cname (vala_type_reference_get_data_type (t), FALSE);
					}
				} else {
					if (VALA_IS_ENUM (vala_type_reference_get_data_type (t))) {
						return g_strdup ("gint");
					} else {
						if (VALA_IS_FLAGS (vala_type_reference_get_data_type (t))) {
							return g_strdup ("guint");
						} else {
							if (VALA_IS_ARRAY (vala_type_reference_get_data_type (t))) {
								return g_strdup ("gpointer");
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig)
{
	char* signature;
	GList* params;
	char* __temp1111;
	char* __temp1110;
	char* __temp1118;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	__temp1111 = NULL;
	__temp1110 = NULL;
	signature = (__temp1111 = g_strdup_printf ("%s:", (__temp1110 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (signature = (g_free (signature), NULL)), __temp1111);
	(__temp1110 = (g_free (__temp1110), NULL));
	if (params == NULL) {
		char* __temp1112;
		__temp1112 = NULL;
		signature = (__temp1112 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), __temp1112);
	} else {
		gboolean first;
		first = TRUE;
		{
			GList* __temp1117;
			GList* p_it;
			__temp1117 = NULL;
			__temp1117 = params;
			for (p_it = __temp1117; p_it != NULL; p_it = p_it->next) {
				ValaFormalParameter* p;
				p = p_it->data;
				{
					if (first) {
						char* __temp1114;
						char* __temp1113;
						__temp1114 = NULL;
						__temp1113 = NULL;
						signature = (__temp1114 = g_strconcat (signature, (__temp1113 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p))), NULL), (signature = (g_free (signature), NULL)), __temp1114);
						(__temp1113 = (g_free (__temp1113), NULL));
						first = FALSE;
					} else {
						char* __temp1116;
						char* __temp1115;
						__temp1116 = NULL;
						__temp1115 = NULL;
						signature = (__temp1116 = g_strdup_printf ("%s,%s", signature, (__temp1115 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (signature = (g_free (signature), NULL)), __temp1116);
						(__temp1115 = (g_free (__temp1115), NULL));
					}
				}
			}
		}
	}
	__temp1118 = NULL;
	return (__temp1118 = signature, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1118);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaCodeGenerator * self;
	char* signature;
	GList* params;
	gint n_params;
	gint i;
	char* __temp1119;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* __temp1120;
	ValaCCodeFormalParameter* __temp1121;
	ValaCCodeFormalParameter* __temp1122;
	ValaCCodeFormalParameter* __temp1123;
	ValaCCodeFormalParameter* __temp1124;
	ValaCCodeFormalParameter* __temp1125;
	ValaCCodeFunction* __temp1126;
	ValaCCodeBlock* marshaller_body;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* __temp1127;
	ValaCCodeFormalParameter* __temp1130;
	ValaCCodeTypeDefinition* __temp1131;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* __temp1132;
	ValaCCodeDeclaration* __temp1133;
	ValaCCodeVariableDeclarator* __temp1134;
	ValaCCodeDeclaration* __temp1135;
	ValaCCodeVariableDeclarator* __temp1136;
	ValaCCodeVariableDeclarator* __temp1137;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* __temp1143;
	ValaCCodeBinaryExpression* __temp1144;
	ValaCCodeExpressionStatement* __temp1145;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* param;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* __temp1146;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* __temp1147;
	ValaCCodeExpressionStatement* __temp1148;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* __temp1149;
	ValaCCodeExpressionStatement* __temp1150;
	ValaCCodeIfStatement* __temp1151;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* __temp1152;
	ValaCCodeFunctionCall* __temp1153;
	ValaCCodeIdentifier* __temp1154;
	ValaCCodeIdentifier* __temp1159;
	const char* __temp1169;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	__temp1119 = NULL;
	signature = (__temp1119 = vala_code_generator_get_signal_signature (self, sig), (signature = (g_free (signature), NULL)), __temp1119);
	/* FIXME remove equality checks with cast in next revision*/
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->predefined_marshal_list, signature)) != ((gboolean) NULL) || GPOINTER_TO_INT (g_hash_table_lookup (self->priv->user_marshal_list, signature)) != ((gboolean) NULL)) {
		(signature = (g_free (signature), NULL));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		return;
	}
	signal_marshaller = vala_ccode_function_new (vala_code_generator_get_signal_marshaller_function (self, sig, NULL), "void");
	(vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (signal_marshaller));
	__temp1120 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1120 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(__temp1120 == NULL ? NULL : (__temp1120 = (g_object_unref (__temp1120), NULL)));
	__temp1121 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1121 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(__temp1121 == NULL ? NULL : (__temp1121 = (g_object_unref (__temp1121), NULL)));
	__temp1122 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1122 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(__temp1122 == NULL ? NULL : (__temp1122 = (g_object_unref (__temp1122), NULL)));
	__temp1123 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1123 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(__temp1123 == NULL ? NULL : (__temp1123 = (g_object_unref (__temp1123), NULL)));
	__temp1124 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1124 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(__temp1124 == NULL ? NULL : (__temp1124 = (g_object_unref (__temp1124), NULL)));
	__temp1125 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1125 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(__temp1125 == NULL ? NULL : (__temp1125 = (g_object_unref (__temp1125), NULL)));
	__temp1126 = NULL;
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_declaration, VALA_CCODE_NODE ((__temp1126 = vala_ccode_function_copy (signal_marshaller))));
	(__temp1126 = (g_object_unref (__temp1126), NULL));
	marshaller_body = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	callback_decl = vala_ccode_function_declarator_new (vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"));
	__temp1127 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1127 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(__temp1127 == NULL ? NULL : (__temp1127 = (g_object_unref (__temp1127), NULL)));
	n_params = 1;
	{
		GList* __temp1129;
		GList* p_it;
		__temp1129 = NULL;
		__temp1129 = params;
		for (p_it = __temp1129; p_it != NULL; p_it = p_it->next) {
			ValaFormalParameter* p;
			p = p_it->data;
			{
				ValaCCodeFormalParameter* __temp1128;
				__temp1128 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1128 = vala_ccode_formal_parameter_new (g_strdup_printf ("arg_%d", n_params), vala_code_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p)))));
				(__temp1128 == NULL ? NULL : (__temp1128 = (g_object_unref (__temp1128), NULL)));
				n_params++;
			}
		}
	}
	__temp1130 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1130 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(__temp1130 == NULL ? NULL : (__temp1130 = (g_object_unref (__temp1130), NULL)));
	__temp1131 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1131 = vala_ccode_type_definition_new (vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig)), VALA_CCODE_DECLARATOR (callback_decl)))));
	(__temp1131 == NULL ? NULL : (__temp1131 = (g_object_unref (__temp1131), NULL)));
	var_decl = vala_ccode_declaration_new (vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"));
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	__temp1132 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1132 = vala_ccode_variable_declarator_new ("callback"))));
	(__temp1132 == NULL ? NULL : (__temp1132 = (g_object_unref (__temp1132), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	__temp1133 = NULL;
	var_decl = (__temp1133 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1133);
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	__temp1134 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1134 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("closure")), "GCClosure *"))))));
	(__temp1134 == NULL ? NULL : (__temp1134 = (g_object_unref (__temp1134), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	__temp1135 = NULL;
	var_decl = (__temp1135 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1135);
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	__temp1136 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1136 = vala_ccode_variable_declarator_new ("data1"))));
	(__temp1136 == NULL ? NULL : (__temp1136 = (g_object_unref (__temp1136), NULL)));
	__temp1137 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1137 = vala_ccode_variable_declarator_new ("data2"))));
	(__temp1137 == NULL ? NULL : (__temp1137 = (g_object_unref (__temp1137), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	fc = NULL;
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeDeclaration* __temp1138;
		ValaCCodeVariableDeclarator* __temp1139;
		ValaCCodeFunctionCall* __temp1140;
		ValaCCodeBinaryExpression* __temp1141;
		ValaCCodeExpressionStatement* __temp1142;
		__temp1138 = NULL;
		var_decl = (__temp1138 = vala_ccode_declaration_new (vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1138);
		__temp1139 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1139 = vala_ccode_variable_declarator_new ("v_return"))));
		(__temp1139 == NULL ? NULL : (__temp1139 = (g_object_unref (__temp1139), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		__temp1140 = NULL;
		fc = (__temp1140 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1140);
		__temp1141 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1141 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("return_value")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp1141 == NULL ? NULL : (__temp1141 = (g_object_unref (__temp1141), NULL)));
		__temp1142 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1142 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp1142 == NULL ? NULL : (__temp1142 = (g_object_unref (__temp1142), NULL)));
	}
	__temp1143 = NULL;
	fc = (__temp1143 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1143);
	__temp1144 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1144 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("n_param_values")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("%i", n_params)))))));
	(__temp1144 == NULL ? NULL : (__temp1144 = (g_object_unref (__temp1144), NULL)));
	__temp1145 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1145 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp1145 == NULL ? NULL : (__temp1145 = (g_object_unref (__temp1145), NULL)));
	data = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("closure")), "data", TRUE);
	param = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("param_values")), "data[0]", TRUE)), "v_pointer", FALSE);
	cond = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")));
	__temp1146 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp1146 = vala_ccode_identifier_new ("closure"))));
	(__temp1146 == NULL ? NULL : (__temp1146 = (g_object_unref (__temp1146), NULL)));
	true_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1147 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp1147 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data1")), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1147 == NULL ? NULL : (__temp1147 = (g_object_unref (__temp1147), NULL)));
	__temp1148 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp1148 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data2")), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1148 == NULL ? NULL : (__temp1148 = (g_object_unref (__temp1148), NULL)));
	false_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1149 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp1149 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data1")), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1149 == NULL ? NULL : (__temp1149 = (g_object_unref (__temp1149), NULL)));
	__temp1150 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp1150 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data2")), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1150 == NULL ? NULL : (__temp1150 = (g_object_unref (__temp1150), NULL)));
	__temp1151 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1151 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(__temp1151 == NULL ? NULL : (__temp1151 = (g_object_unref (__temp1151), NULL)));
	c_assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("callback")), VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("marshal_data")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("marshal_data")), VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("cc")), "callback", TRUE)))), vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	__temp1152 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1152 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(__temp1152 == NULL ? NULL : (__temp1152 = (g_object_unref (__temp1152), NULL)));
	__temp1153 = NULL;
	fc = (__temp1153 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("callback"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1153);
	__temp1154 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1154 = vala_ccode_identifier_new ("data1"))));
	(__temp1154 == NULL ? NULL : (__temp1154 = (g_object_unref (__temp1154), NULL)));
	i = 1;
	{
		GList* __temp1158;
		GList* p_it;
		__temp1158 = NULL;
		__temp1158 = params;
		for (p_it = __temp1158; p_it != NULL; p_it = p_it->next) {
			ValaFormalParameter* p;
			p = p_it->data;
			{
				char* get_value_function;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* __temp1157;
				get_value_function = NULL;
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL) {
					char* __temp1155;
					__temp1155 = NULL;
					get_value_function = (__temp1155 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), __temp1155);
				} else {
					char* __temp1156;
					__temp1156 = NULL;
					get_value_function = (__temp1156 = vala_data_type_get_get_value_function (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), __temp1156);
				}
				inner_fc = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (get_value_function)));
				__temp1157 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((__temp1157 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("param_values")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%i", i)))))));
				(__temp1157 == NULL ? NULL : (__temp1157 = (g_object_unref (__temp1157), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(get_value_function = (g_free (get_value_function), NULL));
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
	}
	__temp1159 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1159 = vala_ccode_identifier_new ("data2"))));
	(__temp1159 == NULL ? NULL : (__temp1159 = (g_object_unref (__temp1159), NULL)));
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeExpressionStatement* __temp1160;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* __temp1165;
		ValaCCodeIdentifier* __temp1166;
		ValaCCodeExpressionStatement* __temp1167;
		__temp1160 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1160 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("v_return")), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp1160 == NULL ? NULL : (__temp1160 = (g_object_unref (__temp1160), NULL)));
		set_fc = NULL;
		if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
			ValaCCodeFunctionCall* __temp1161;
			__temp1161 = NULL;
			set_fc = (__temp1161 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1161);
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))) {
				ValaCCodeFunctionCall* __temp1162;
				__temp1162 = NULL;
				set_fc = (__temp1162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_take_object"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1162);
			} else {
				if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaCCodeFunctionCall* __temp1163;
					__temp1163 = NULL;
					set_fc = (__temp1163 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_take_string"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1163);
				} else {
					ValaCCodeFunctionCall* __temp1164;
					__temp1164 = NULL;
					set_fc = (__temp1164 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_set_value_function (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1164);
				}
			}
		}
		__temp1165 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp1165 = vala_ccode_identifier_new ("return_value"))));
		(__temp1165 == NULL ? NULL : (__temp1165 = (g_object_unref (__temp1165), NULL)));
		__temp1166 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp1166 = vala_ccode_identifier_new ("v_return"))));
		(__temp1166 == NULL ? NULL : (__temp1166 = (g_object_unref (__temp1166), NULL)));
		__temp1167 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1167 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(__temp1167 == NULL ? NULL : (__temp1167 = (g_object_unref (__temp1167), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* __temp1168;
		__temp1168 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1168 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp1168 == NULL ? NULL : (__temp1168 = (g_object_unref (__temp1168), NULL)));
	}
	(vala_ccode_function_set_block (signal_marshaller, marshaller_body), vala_ccode_function_get_block (signal_marshaller));
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	__temp1169 = NULL;
	g_hash_table_insert (self->priv->user_marshal_list, (__temp1169 = signature, (__temp1169 == NULL ? NULL : g_strdup (__temp1169))), GINT_TO_POINTER (TRUE));
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->context) == NULL);
}


static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* __temp1171;
	ValaCCodeFragment* __temp1172;
	ValaCCodeFragment* __temp1173;
	ValaCCodeFragment* __temp1174;
	ValaCCodeFragment* __temp1175;
	ValaCCodeFragment* __temp1176;
	ValaCCodeFragment* __temp1177;
	ValaCCodeFragment* __temp1178;
	ValaCCodeFragment* __temp1179;
	ValaCCodeFragment* __temp1180;
	GHashTable* __temp1181;
	ValaCCodeIncludeDirective* __temp1182;
	ValaCCodeIncludeDirective* __temp1183;
	ValaCCodeIncludeDirective* __temp1184;
	GList* used_includes;
	char* __temp1185;
	ValaCCodeMacroReplacement* __temp1210;
	ValaCCodeMacroReplacement* __temp1211;
	char* __temp1212;
	char* __temp1213;
	char* header_define;
	ValaCCodeComment* comment;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* __temp1216;
	ValaCCodeNewline* __temp1217;
	ValaCCodeIdentifier* __temp1218;
	ValaCCodeNewline* __temp1219;
	ValaCCodeNewline* __temp1220;
	ValaCCodeNewline* __temp1221;
	ValaCCodeNewline* __temp1222;
	ValaCCodeNewline* __temp1223;
	ValaCCodeIdentifier* __temp1224;
	ValaCCodeNewline* __temp1225;
	ValaCCodeNewline* __temp1226;
	ValaCCodeWriter* __temp1227;
	ValaCCodeFragment* __temp1228;
	ValaCCodeFragment* __temp1229;
	ValaCCodeFragment* __temp1230;
	ValaCCodeFragment* __temp1231;
	ValaCCodeFragment* __temp1232;
	ValaCCodeFragment* __temp1233;
	ValaCCodeFragment* __temp1234;
	ValaCCodeFragment* __temp1235;
	ValaCCodeFragment* __temp1236;
	ValaCCodeFragment* __temp1237;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	__temp1171 = NULL;
	self->priv->header_begin = (__temp1171 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp1171);
	__temp1172 = NULL;
	self->priv->header_type_declaration = (__temp1172 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp1172);
	__temp1173 = NULL;
	self->priv->header_type_definition = (__temp1173 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp1173);
	__temp1174 = NULL;
	self->priv->header_type_member_declaration = (__temp1174 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp1174);
	__temp1175 = NULL;
	self->priv->source_begin = (__temp1175 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp1175);
	__temp1176 = NULL;
	self->priv->source_include_directives = (__temp1176 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp1176);
	__temp1177 = NULL;
	self->priv->source_type_member_declaration = (__temp1177 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp1177);
	__temp1178 = NULL;
	self->priv->source_type_member_definition = (__temp1178 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp1178);
	__temp1179 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp1179 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp1179);
	__temp1180 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp1180 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp1180);
	__temp1181 = NULL;
	self->priv->user_marshal_list = (__temp1181 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->user_marshal_list == NULL ? NULL : (self->priv->user_marshal_list = (g_hash_table_unref (self->priv->user_marshal_list), NULL))), __temp1181);
	self->priv->next_temp_var_id = 0;
	self->priv->string_h_needed = FALSE;
	__temp1182 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1182 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(__temp1182 == NULL ? NULL : (__temp1182 = (g_object_unref (__temp1182), NULL)));
	__temp1183 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1183 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(__temp1183 == NULL ? NULL : (__temp1183 = (g_object_unref (__temp1183), NULL)));
	__temp1184 = NULL;
	vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1184 = vala_ccode_include_directive_new (vala_source_file_get_cheader_filename (source_file), TRUE))));
	(__temp1184 == NULL ? NULL : (__temp1184 = (g_object_unref (__temp1184), NULL)));
	used_includes = NULL;
	used_includes = g_list_append (used_includes, "glib.h");
	used_includes = g_list_append (used_includes, "glib-object.h");
	__temp1185 = NULL;
	used_includes = g_list_append (used_includes, (__temp1185 = vala_source_file_get_cheader_filename (source_file)));
	(__temp1185 = (g_free (__temp1185), NULL));
	{
		GList* __temp1187;
		GList* filename1_it;
		__temp1187 = NULL;
		__temp1187 = vala_source_file_get_header_external_includes (source_file);
		for (filename1_it = __temp1187; filename1_it != NULL; filename1_it = filename1_it->next) {
			char* filename1;
			filename1 = filename1_it->data;
			{
				if (g_list_find_custom (used_includes, filename1, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1186;
					__temp1186 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1186 = vala_ccode_include_directive_new (filename1, FALSE))));
					(__temp1186 == NULL ? NULL : (__temp1186 = (g_object_unref (__temp1186), NULL)));
					used_includes = g_list_append (used_includes, filename1);
				}
			}
		}
	}
	{
		GList* __temp1189;
		GList* filename2_it;
		__temp1189 = NULL;
		__temp1189 = vala_source_file_get_header_internal_includes (source_file);
		for (filename2_it = __temp1189; filename2_it != NULL; filename2_it = filename2_it->next) {
			char* filename2;
			filename2 = filename2_it->data;
			{
				if (g_list_find_custom (used_includes, filename2, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1188;
					__temp1188 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1188 = vala_code_generator_get_internal_include (self, filename2))));
					(__temp1188 == NULL ? NULL : (__temp1188 = (g_object_unref (__temp1188), NULL)));
					used_includes = g_list_append (used_includes, filename2);
				}
			}
		}
	}
	{
		GList* __temp1191;
		GList* filename3_it;
		__temp1191 = NULL;
		__temp1191 = vala_source_file_get_source_external_includes (source_file);
		for (filename3_it = __temp1191; filename3_it != NULL; filename3_it = filename3_it->next) {
			char* filename3;
			filename3 = filename3_it->data;
			{
				if (g_list_find_custom (used_includes, filename3, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1190;
					__temp1190 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1190 = vala_ccode_include_directive_new (filename3, FALSE))));
					(__temp1190 == NULL ? NULL : (__temp1190 = (g_object_unref (__temp1190), NULL)));
					used_includes = g_list_append (used_includes, filename3);
				}
			}
		}
	}
	{
		GList* __temp1193;
		GList* filename4_it;
		__temp1193 = NULL;
		__temp1193 = vala_source_file_get_source_internal_includes (source_file);
		for (filename4_it = __temp1193; filename4_it != NULL; filename4_it = filename4_it->next) {
			char* filename4;
			filename4 = filename4_it->data;
			{
				if (g_list_find_custom (used_includes, filename4, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1192;
					__temp1192 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1192 = vala_code_generator_get_internal_include (self, filename4))));
					(__temp1192 == NULL ? NULL : (__temp1192 = (g_object_unref (__temp1192), NULL)));
					used_includes = g_list_append (used_includes, filename4);
				}
			}
		}
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GList* __temp1209;
			GList* cycle_file_it;
			__temp1209 = NULL;
			__temp1209 = vala_source_file_get_cycle (source_file)->files;
			for (cycle_file_it = __temp1209; cycle_file_it != NULL; cycle_file_it = cycle_file_it->next) {
				ValaSourceFile* cycle_file;
				cycle_file = cycle_file_it->data;
				{
					GList* namespaces;
					namespaces = vala_source_file_get_namespaces (cycle_file);
					{
						GList* __temp1208;
						GList* ns_it;
						__temp1208 = NULL;
						__temp1208 = namespaces;
						for (ns_it = __temp1208; ns_it != NULL; ns_it = ns_it->next) {
							ValaNamespace* ns;
							ns = ns_it->data;
							{
								GList* structs;
								GList* classes;
								GList* ifaces;
								structs = vala_namespace_get_structs (ns);
								{
									GList* __temp1196;
									GList* st_it;
									__temp1196 = NULL;
									__temp1196 = structs;
									for (st_it = __temp1196; st_it != NULL; st_it = st_it->next) {
										ValaStruct* st;
										st = st_it->data;
										{
											ValaCCodeTypeDefinition* __temp1195;
											char* __temp1194;
											__temp1195 = NULL;
											__temp1194 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1195 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1194 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))));
											(__temp1195 == NULL ? NULL : (__temp1195 = (g_object_unref (__temp1195), NULL)));
											(__temp1194 = (g_free (__temp1194), NULL));
										}
									}
								}
								classes = vala_namespace_get_classes (ns);
								{
									GList* __temp1202;
									GList* cl_it;
									__temp1202 = NULL;
									__temp1202 = classes;
									for (cl_it = __temp1202; cl_it != NULL; cl_it = cl_it->next) {
										ValaClass* cl;
										cl = cl_it->data;
										{
											ValaCCodeTypeDefinition* __temp1198;
											char* __temp1197;
											ValaCCodeTypeDefinition* __temp1201;
											char* __temp1200;
											char* __temp1199;
											__temp1198 = NULL;
											__temp1197 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1198 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1197 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
											(__temp1198 == NULL ? NULL : (__temp1198 = (g_object_unref (__temp1198), NULL)));
											(__temp1197 = (g_free (__temp1197), NULL));
											__temp1201 = NULL;
											__temp1200 = NULL;
											__temp1199 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1201 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%sClass", (__temp1199 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sClass", (__temp1200 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
											(__temp1201 == NULL ? NULL : (__temp1201 = (g_object_unref (__temp1201), NULL)));
											(__temp1200 = (g_free (__temp1200), NULL));
											(__temp1199 = (g_free (__temp1199), NULL));
										}
									}
								}
								ifaces = vala_namespace_get_interfaces (ns);
								{
									GList* __temp1207;
									GList* iface_it;
									__temp1207 = NULL;
									__temp1207 = ifaces;
									for (iface_it = __temp1207; iface_it != NULL; iface_it = iface_it->next) {
										ValaInterface* iface;
										iface = iface_it->data;
										{
											ValaCCodeTypeDefinition* __temp1204;
											char* __temp1203;
											ValaCCodeTypeDefinition* __temp1206;
											char* __temp1205;
											__temp1204 = NULL;
											__temp1203 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1204 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1203 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
											(__temp1204 == NULL ? NULL : (__temp1204 = (g_object_unref (__temp1204), NULL)));
											(__temp1203 = (g_free (__temp1203), NULL));
											__temp1206 = NULL;
											__temp1205 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1206 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1205 = vala_interface_get_type_cname (iface))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_interface_get_type_cname (iface)))))));
											(__temp1206 == NULL ? NULL : (__temp1206 = (g_object_unref (__temp1206), NULL)));
											(__temp1205 = (g_free (__temp1205), NULL));
										}
									}
								}
								(structs == NULL ? NULL : (structs = (g_list_free (structs), NULL)));
								(classes == NULL ? NULL : (classes = (g_list_free (classes), NULL)));
								(ifaces == NULL ? NULL : (ifaces = (g_list_free (ifaces), NULL)));
							}
						}
					}
					(namespaces == NULL ? NULL : (namespaces = (g_list_free (namespaces), NULL)));
				}
			}
		}
	}
	/* generate hardcoded "well-known" macros */
	__temp1210 = NULL;
	vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp1210 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
	(__temp1210 == NULL ? NULL : (__temp1210 = (g_object_unref (__temp1210), NULL)));
	__temp1211 = NULL;
	vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp1211 = vala_ccode_macro_replacement_new ("VALA_FREE_UNCHECKED(o,f)", "((o) = (f (o), NULL))"))));
	(__temp1211 == NULL ? NULL : (__temp1211 = (g_object_unref (__temp1211), NULL)));
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
	__temp1212 = NULL;
	__temp1213 = NULL;
	header_define = (__temp1213 = vala_code_generator_get_define_for_filename ((__temp1212 = vala_source_file_get_cheader_filename (source_file))), (__temp1212 = (g_free (__temp1212), NULL)), __temp1213);
	if (self->priv->string_h_needed) {
		ValaCCodeIncludeDirective* __temp1214;
		__temp1214 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1214 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(__temp1214 == NULL ? NULL : (__temp1214 = (g_object_unref (__temp1214), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* __temp1215;
		__temp1215 = NULL;
		comment = (__temp1215 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), __temp1215);
	}
	writer = vala_ccode_writer_new (vala_source_file_get_cheader_filename (source_file));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	__temp1216 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1216 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1216 == NULL ? NULL : (__temp1216 = (g_object_unref (__temp1216), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_begin));
	__temp1217 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1217 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1217 == NULL ? NULL : (__temp1217 = (g_object_unref (__temp1217), NULL)));
	__temp1218 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1218 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(__temp1218 == NULL ? NULL : (__temp1218 = (g_object_unref (__temp1218), NULL)));
	__temp1219 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1219 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1219 == NULL ? NULL : (__temp1219 = (g_object_unref (__temp1219), NULL)));
	__temp1220 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1220 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1220 == NULL ? NULL : (__temp1220 = (g_object_unref (__temp1220), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_declaration));
	__temp1221 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1221 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1221 == NULL ? NULL : (__temp1221 = (g_object_unref (__temp1221), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_definition));
	__temp1222 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1222 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1222 == NULL ? NULL : (__temp1222 = (g_object_unref (__temp1222), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_member_declaration));
	__temp1223 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1223 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1223 == NULL ? NULL : (__temp1223 = (g_object_unref (__temp1223), NULL)));
	__temp1224 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1224 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(__temp1224 == NULL ? NULL : (__temp1224 = (g_object_unref (__temp1224), NULL)));
	__temp1225 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1225 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1225 == NULL ? NULL : (__temp1225 = (g_object_unref (__temp1225), NULL)));
	__temp1226 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1226 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1226 == NULL ? NULL : (__temp1226 = (g_object_unref (__temp1226), NULL)));
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (once), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	__temp1227 = NULL;
	writer = (__temp1227 = vala_ccode_writer_new (vala_source_file_get_csource_filename (source_file)), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), __temp1227);
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	__temp1228 = NULL;
	self->priv->header_begin = (__temp1228 = NULL, (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp1228);
	__temp1229 = NULL;
	self->priv->header_type_declaration = (__temp1229 = NULL, (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp1229);
	__temp1230 = NULL;
	self->priv->header_type_definition = (__temp1230 = NULL, (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp1230);
	__temp1231 = NULL;
	self->priv->header_type_member_declaration = (__temp1231 = NULL, (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp1231);
	__temp1232 = NULL;
	self->priv->source_begin = (__temp1232 = NULL, (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp1232);
	__temp1233 = NULL;
	self->priv->source_include_directives = (__temp1233 = NULL, (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp1233);
	__temp1234 = NULL;
	self->priv->source_type_member_declaration = (__temp1234 = NULL, (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp1234);
	__temp1235 = NULL;
	self->priv->source_type_member_definition = (__temp1235 = NULL, (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp1235);
	__temp1236 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp1236 = NULL, (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp1236);
	__temp1237 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp1237 = NULL, (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp1237);
	(used_includes == NULL ? NULL : (used_includes = (g_list_free (used_includes), NULL)));
	(header_define = (g_free (header_define), NULL));
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static char* vala_code_generator_get_define_for_filename (const char* filename)
{
	GString* define;
	char* i;
	const char* __temp1240;
	char* __temp1241;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	i = g_strdup (filename);
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* __temp1239;
		const char* __temp1238;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		__temp1239 = NULL;
		__temp1238 = NULL;
		i = (__temp1239 = (__temp1238 = g_utf8_next_char (i), (__temp1238 == NULL ? NULL : g_strdup (__temp1238))), (i = (g_free (i), NULL)), __temp1239);
	}
	g_string_append (define, "__");
	__temp1240 = NULL;
	__temp1241 = NULL;
	return (__temp1241 = (__temp1240 = define->str, (__temp1240 == NULL ? NULL : g_strdup (__temp1240))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), __temp1241);
	(define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL)));
	(i = (g_free (i), NULL));
}


static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp1243;
	ValaSymbol* __temp1242;
	ValaCCodeStruct* __temp1245;
	char* __temp1244;
	ValaSymbol* __temp1249;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	__temp1243 = NULL;
	__temp1242 = NULL;
	self->priv->current_type_symbol = (__temp1243 = (__temp1242 = vala_code_node_get_symbol (VALA_CODE_NODE (st)), (__temp1242 == NULL ? NULL : g_object_ref (__temp1242))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1243);
	__temp1245 = NULL;
	__temp1244 = NULL;
	self->priv->instance_struct = (__temp1245 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp1244 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp1245);
	(__temp1244 = (g_free (__temp1244), NULL));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))) == NULL) {
		ValaCCodeTypeDefinition* __temp1247;
		char* __temp1246;
		__temp1247 = NULL;
		__temp1246 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1247 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1246 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))));
		(__temp1247 == NULL ? NULL : (__temp1247 = (g_object_unref (__temp1247), NULL)));
		(__temp1246 = (g_free (__temp1246), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st))) != NULL) {
		ValaCCodeComment* __temp1248;
		__temp1248 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp1248 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))))));
		(__temp1248 == NULL ? NULL : (__temp1248 = (g_object_unref (__temp1248), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	__temp1249 = NULL;
	self->priv->current_type_symbol = (__temp1249 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1249);
}


gboolean vala_code_generator_get_memory_management (ValaCodeGenerator* self)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	return self->priv->_memory_management;
}


void vala_code_generator_set_memory_management (ValaCodeGenerator* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	self->priv->_memory_management = value;
}


static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	ValaCodeGenerator * self;
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_CODE_GENERATOR (obj);
	{
		GHashTable* __temp1251;
		GHashTable* __temp1252;
		__temp1251 = NULL;
		self->priv->predefined_marshal_list = (__temp1251 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->predefined_marshal_list == NULL ? NULL : (self->priv->predefined_marshal_list = (g_hash_table_unref (self->priv->predefined_marshal_list), NULL))), __temp1251);
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:VOID"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:BOOLEAN"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:CHAR"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UCHAR"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:INT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UINT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:LONG"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:ULONG"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:ENUM"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:FLAGS"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:FLOAT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:DOUBLE"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:STRING"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:OBJECT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("STRING:OBJECT,POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UINT,POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("BOOLEAN:FLAGS"), GINT_TO_POINTER (TRUE));
		__temp1252 = NULL;
		self->priv->c_keywords = (__temp1252 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_hash_table_unref (self->priv->c_keywords), NULL))), __temp1252);
		/* C99 keywords*/
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("_Bool"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("_Complex"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("_Imaginary"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("auto"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("break"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("case"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("char"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("const"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("continue"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("default"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("do"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("double"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("else"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("enum"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("extern"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("float"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("for"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("goto"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("if"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("inline"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("int"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("long"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("register"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("restrict"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("return"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("short"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("signed"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("sizeof"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("static"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("struct"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("switch"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("typedef"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("union"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("unsigned"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("void"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("volatile"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("while"), GINT_TO_POINTER (TRUE));
		/* MSVC keywords*/
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("cdecl"), GINT_TO_POINTER (TRUE));
	}
	return obj;
}


static void vala_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		g_value_set_boolean (value, vala_code_generator_get_memory_management (self));
		break;
	}
}


static void vala_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		vala_code_generator_set_memory_management (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass)
{
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_code_generator_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_code_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_code_generator_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_code_generator_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_code_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_code_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_flags = vala_code_generator_real_visit_flags;
	VALA_CODE_VISITOR_CLASS (klass)->visit_flags_value = vala_code_generator_real_visit_flags_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_code_generator_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_code_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_code_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_code_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_code_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_code_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_code_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_code_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_code_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_block = vala_code_generator_real_visit_begin_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_block = vala_code_generator_real_visit_end_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_code_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_code_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_code_generator_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_initializer_list = vala_code_generator_real_visit_end_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_code_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_code_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_code_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_code_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_code_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_code_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_code_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_foreach_statement = vala_code_generator_real_visit_end_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_code_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_code_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_return_statement = vala_code_generator_real_visit_begin_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_return_statement = vala_code_generator_real_visit_end_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_code_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_array_creation_expression = vala_code_generator_real_visit_end_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_code_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_code_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_code_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_code_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_code_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_code_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_literal_expression = vala_code_generator_real_visit_literal_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_code_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_code_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_code_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_code_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_object_creation_expression = vala_code_generator_real_visit_end_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_code_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_code_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_code_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_code_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_code_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_code_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_code_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_code_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_code_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_code_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_lambda_expression = vala_code_generator_real_visit_end_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_assignment = vala_code_generator_real_visit_end_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_code_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_code_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_invocation_expression = vala_code_generator_real_visit_end_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_code_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_code_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_code_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_code_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_code_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_code_generator_real_visit_struct;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_GENERATOR_MEMORY_MANAGEMENT, g_param_spec_boolean ("memory-management", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_code_generator_init (ValaCodeGenerator * self)
{
	self->priv = VALA_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->next_temp_var_id = 0;
	self->priv->in_creation_method = FALSE;
	self->priv->in_plugin = FALSE;
}


static void vala_code_generator_dispose (GObject * obj)
{
	ValaCodeGenerator * self;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CODE_GENERATOR (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL)));
	(self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL)));
	(self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL)));
	(self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL)));
	(self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL)));
	(self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL)));
	(self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL)));
	(self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL)));
	(self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL)));
	(self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL)));
	(self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL)));
	(self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL)));
	(self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL)));
	(self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL)));
	(self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL)));
	(self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL)));
	(self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL)));
	(self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL)));
	(self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL)));
	(self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL)));
	(self->priv->block == NULL ? NULL : (self->priv->block = (g_object_unref (self->priv->block), NULL)));
	(self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL)));
	(self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL)));
	(self->priv->user_marshal_list == NULL ? NULL : (self->priv->user_marshal_list = (g_hash_table_unref (self->priv->user_marshal_list), NULL)));
	(self->priv->predefined_marshal_list == NULL ? NULL : (self->priv->predefined_marshal_list = (g_hash_table_unref (self->priv->predefined_marshal_list), NULL)));
	(self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_hash_table_unref (self->priv->c_keywords), NULL)));
	(self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL)));
	(self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL)));
	(self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL)));
	(self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL)));
	(self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL)));
	(self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL)));
	(self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL)));
	(self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL)));
	(self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL)));
	(self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL)));
	(self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL)));
	(self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL)));
	(self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL)));
	(self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL)));
	(self->priv->slist_type == NULL ? NULL : (self->priv->slist_type = (g_object_unref (self->priv->slist_type), NULL)));
	(self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL)));
	(self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL)));
	(self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL));
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_code_generator_get_type ()
{
	static GType vala_code_generator_type_id = 0;
	if (G_UNLIKELY (vala_code_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_init };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




