/* valablock.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALABLOCK_H__
#define __VALABLOCK_H__
typedef struct _ValaBlockPrivate ValaBlockPrivate;

#include <glib.h>
#include <glib-object.h>
#include <vala/valastatement.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))


/**
 * Represents a source code block.
 */
struct _ValaBlock {
	ValaStatement parent;
	ValaBlockPrivate * priv;
};
struct _ValaBlockClass {
	ValaStatementClass parent;
};

ValaBlock* vala_block_new (ValaSourceReference* source);
void vala_block_add_statement (ValaBlock* self, ValaStatement* stmt);
GList* vala_block_get_statements (ValaBlock* self);
void vala_block_add_local_variable (ValaBlock* self, ValaVariableDeclarator* decl);
GList* vala_block_get_local_variables (ValaBlock* self);
gboolean vala_block_get_contains_jump_statement (ValaBlock* self);
void vala_block_set_contains_jump_statement (ValaBlock* self, gboolean value);
GType vala_block_get_type ();

G_END_DECLS

#endif
