/* valasymbolbuilder.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */

#ifndef __VALASYMBOLBUILDER_H__
#define __VALASYMBOLBUILDER_H__
typedef struct _ValaSymbolBuilder ValaSymbolBuilder;
typedef struct _ValaSymbolBuilderClass ValaSymbolBuilderClass;
typedef struct _ValaSymbolBuilderPrivate ValaSymbolBuilderPrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valanamespace.h>
#include <vala/valasymbol.h>
#include <vala/valacodenode.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valaflags.h>
#include <vala/valaflagsvalue.h>
#include <vala/valacallback.h>
#include <vala/valaconstant.h>
#include <vala/valafield.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valasignal.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valablock.h>
#include <vala/valatypeparameter.h>

G_BEGIN_DECLS


#define VALA_TYPE_SYMBOL_BUILDER (vala_symbol_builder_get_type ())
#define VALA_SYMBOL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL_BUILDER, ValaSymbolBuilder))
#define VALA_SYMBOL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL_BUILDER, ValaSymbolBuilderClass))
#define VALA_IS_SYMBOL_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL_BUILDER))
#define VALA_IS_SYMBOL_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL_BUILDER))
#define VALA_SYMBOL_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL_BUILDER, ValaSymbolBuilderClass))


/**
 * Code visitor building the symbol tree.
 */
struct _ValaSymbolBuilder {
	ValaCodeVisitor parent;
	ValaSymbolBuilderPrivate * priv;
};
struct _ValaSymbolBuilderClass {
	ValaCodeVisitorClass parent;
};

void vala_symbol_builder_build (ValaSymbolBuilder* self, ValaCodeContext* context);
GType vala_symbol_builder_get_type ();

G_END_DECLS

#endif
