/* valaforeachstatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALAFOREACHSTATEMENT_H__
#define __VALAFOREACHSTATEMENT_H__
typedef struct _ValaForeachStatementPrivate ValaForeachStatementPrivate;

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valastatement.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))


/**
 * Represents a foreach statement in the source code. Foreach statements iterate
 * over the elements of a collection.
 */
struct _ValaForeachStatement {
	ValaStatement parent;
	ValaForeachStatementPrivate * priv;
};
struct _ValaForeachStatementClass {
	ValaStatementClass parent;
};

ValaForeachStatement* vala_foreach_statement_new (ValaTypeReference* type, const char* id, ValaExpression* col, ValaStatement* _body, ValaSourceReference* source);
ValaTypeReference* vala_foreach_statement_get_type_reference (ValaForeachStatement* self);
void vala_foreach_statement_set_type_reference (ValaForeachStatement* self, ValaTypeReference* value);
char* vala_foreach_statement_get_variable_name (ValaForeachStatement* self);
void vala_foreach_statement_set_variable_name (ValaForeachStatement* self, const char* value);
ValaExpression* vala_foreach_statement_get_collection (ValaForeachStatement* self);
void vala_foreach_statement_set_collection (ValaForeachStatement* self, ValaExpression* value);
ValaStatement* vala_foreach_statement_get_body (ValaForeachStatement* self);
void vala_foreach_statement_set_body (ValaForeachStatement* self, ValaStatement* value);
ValaVariableDeclarator* vala_foreach_statement_get_variable_declarator (ValaForeachStatement* self);
void vala_foreach_statement_set_variable_declarator (ValaForeachStatement* self, ValaVariableDeclarator* value);
GType vala_foreach_statement_get_type ();

G_END_DECLS

#endif
