/* valaccodeforstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccodeforstatement.h"
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodenode.h>

struct _ValaCCodeForStatementPrivate {
	ValaCCodeExpression* _condition;
	ValaCCodeStatement* _body;
	GeeList* initializer;
	GeeList* iterator;
};
#define VALA_CCODE_FOR_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FOR_STATEMENT, ValaCCodeForStatementPrivate))
enum  {
	VALA_CCODE_FOR_STATEMENT_DUMMY_PROPERTY,
	VALA_CCODE_FOR_STATEMENT_CONDITION,
	VALA_CCODE_FOR_STATEMENT_BODY
};
static void vala_ccode_for_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_for_statement_parent_class = NULL;
static void vala_ccode_for_statement_dispose (GObject * obj);


ValaCCodeForStatement* vala_ccode_for_statement_new (ValaCCodeExpression* condition, ValaCCodeStatement* body)
{
	ValaCCodeForStatement * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (condition), NULL);
	g_return_val_if_fail (body == NULL || VALA_IS_CCODE_STATEMENT (body), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_FOR_STATEMENT, 0, NULL);
	vala_ccode_for_statement_set_condition (self, condition);
	vala_ccode_for_statement_set_body (self, body);
	return self;
}


/**
 * Appends the specified expression to the list of initializers.
 *
 * @param expr an initializer expression
 */
void vala_ccode_for_statement_add_initializer (ValaCCodeForStatement* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->initializer), expr);
}


/**
 * Appends the specified expression to the iterator.
 *
 * @param expr an iterator expression
 */
void vala_ccode_for_statement_add_iterator (ValaCCodeForStatement* self, ValaCCodeExpression* expr)
{
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->iterator), expr);
}


static void vala_ccode_for_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeForStatement * self;
	gboolean first;
	self = ((ValaCCodeForStatement*) base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	first = FALSE;
	vala_ccode_writer_write_indent (writer);
	vala_ccode_writer_write_string (writer, "for (");
	first = TRUE;
	{
		GeeList* init_expr_collection;
		GeeIterator* init_expr_it;
		init_expr_collection = self->priv->initializer;
		init_expr_it = gee_iterable_iterator (GEE_ITERABLE (init_expr_collection));
		while (gee_iterator_next (init_expr_it)) {
			ValaCCodeExpression* init_expr;
			init_expr = gee_iterator_get (init_expr_it);
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (init_expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (init_expr), writer);
				}
				(init_expr == NULL ? NULL : (init_expr = (g_object_unref (init_expr), NULL)));
			}
		}
		(init_expr_it == NULL ? NULL : (init_expr_it = (g_object_unref (init_expr_it), NULL)));
	}
	vala_ccode_writer_write_string (writer, "; ");
	if (vala_ccode_for_statement_get_condition (self) != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_for_statement_get_condition (self)), writer);
	}
	vala_ccode_writer_write_string (writer, "; ");
	first = TRUE;
	{
		GeeList* it_expr_collection;
		GeeIterator* it_expr_it;
		it_expr_collection = self->priv->iterator;
		it_expr_it = gee_iterable_iterator (GEE_ITERABLE (it_expr_collection));
		while (gee_iterator_next (it_expr_it)) {
			ValaCCodeExpression* it_expr;
			it_expr = gee_iterator_get (it_expr_it);
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (it_expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (it_expr), writer);
				}
				(it_expr == NULL ? NULL : (it_expr = (g_object_unref (it_expr), NULL)));
			}
		}
		(it_expr_it == NULL ? NULL : (it_expr_it = (g_object_unref (it_expr_it), NULL)));
	}
	vala_ccode_writer_write_string (writer, ")");
	vala_ccode_node_write (VALA_CCODE_NODE (vala_ccode_for_statement_get_body (self)), writer);
}


ValaCCodeExpression* vala_ccode_for_statement_get_condition (ValaCCodeForStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_ccode_for_statement_set_condition (ValaCCodeForStatement* self, ValaCCodeExpression* value)
{
	ValaCCodeExpression* __temp1;
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	__temp1 = NULL;
	self->priv->_condition = (__temp1 = g_object_ref (value), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL))), __temp1);
}


ValaCCodeStatement* vala_ccode_for_statement_get_body (ValaCCodeForStatement* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_ccode_for_statement_set_body (ValaCCodeForStatement* self, ValaCCodeStatement* value)
{
	ValaCCodeStatement* __temp4;
	ValaCCodeStatement* __temp3;
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	__temp4 = NULL;
	__temp3 = NULL;
	self->priv->_body = (__temp4 = (__temp3 = value, (__temp3 == NULL ? NULL : g_object_ref (__temp3))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp4);
}


static void vala_ccode_for_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeForStatement * self;
	self = VALA_CCODE_FOR_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_FOR_STATEMENT_CONDITION:
		g_value_set_object (value, vala_ccode_for_statement_get_condition (self));
		break;
		case VALA_CCODE_FOR_STATEMENT_BODY:
		g_value_set_object (value, vala_ccode_for_statement_get_body (self));
		break;
	}
}


static void vala_ccode_for_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeForStatement * self;
	self = VALA_CCODE_FOR_STATEMENT (object);
	switch (property_id) {
		case VALA_CCODE_FOR_STATEMENT_CONDITION:
		vala_ccode_for_statement_set_condition (self, g_value_get_object (value));
		break;
		case VALA_CCODE_FOR_STATEMENT_BODY:
		vala_ccode_for_statement_set_body (self, g_value_get_object (value));
		break;
	}
}


static void vala_ccode_for_statement_class_init (ValaCCodeForStatementClass * klass)
{
	vala_ccode_for_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeForStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_for_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_for_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_for_statement_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_for_statement_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FOR_STATEMENT_CONDITION, g_param_spec_object ("condition", "foo", "bar", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_FOR_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_CCODE_STATEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_for_statement_init (ValaCCodeForStatement * self)
{
	self->priv = VALA_CCODE_FOR_STATEMENT_GET_PRIVATE (self);
	self->priv->initializer = GEE_LIST (gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal));
	self->priv->iterator = GEE_LIST (gee_array_list_new (g_object_ref, g_object_unref, g_direct_equal));
}


static void vala_ccode_for_statement_dispose (GObject * obj)
{
	ValaCCodeForStatement * self;
	ValaCCodeForStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_CCODE_FOR_STATEMENT (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (g_object_unref (self->priv->_condition), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->initializer == NULL ? NULL : (self->priv->initializer = (g_object_unref (self->priv->initializer), NULL)));
	(self->priv->iterator == NULL ? NULL : (self->priv->iterator = (g_object_unref (self->priv->iterator), NULL)));
	klass = VALA_CCODE_FOR_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_FOR_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_for_statement_get_type (void)
{
	static GType vala_ccode_for_statement_type_id = 0;
	if (G_UNLIKELY (vala_ccode_for_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeForStatement), 0, (GInstanceInitFunc) vala_ccode_for_statement_init };
		vala_ccode_for_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeForStatement", &g_define_type_info, 0);
	}
	return vala_ccode_for_statement_type_id;
}




