/* collection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "collection.h"



gboolean gee_collection_contains (GeeCollection* self, gpointer item)
{
	return GEE_COLLECTION_GET_INTERFACE (self)->contains (self, item);
}


gboolean gee_collection_add (GeeCollection* self, gpointer item)
{
	return GEE_COLLECTION_GET_INTERFACE (self)->add (self, item);
}


gboolean gee_collection_remove (GeeCollection* self, gpointer item)
{
	return GEE_COLLECTION_GET_INTERFACE (self)->remove (self, item);
}


void gee_collection_clear (GeeCollection* self)
{
	GEE_COLLECTION_GET_INTERFACE (self)->clear (self);
}


gint gee_collection_get_size (GeeCollection* self)
{
	gint value;
	g_object_get (G_OBJECT (self), "size", &value, NULL);
	return value;
}


static void gee_collection_base_init (GeeCollectionIface * iface)
{
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_int ("size", "foo", "bar", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gee_collection_get_type (void)
{
	static GType gee_collection_type_id = 0;
	if (G_UNLIKELY (gee_collection_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeCollectionIface), (GBaseInitFunc) gee_collection_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL };
		gee_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeCollection", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_collection_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gee_collection_type_id, GEE_TYPE_ITERABLE);
	}
	return gee_collection_type_id;
}




