/* valaccodeexpressionbinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEEXPRESSIONBINDING_H__
#define __GOBJECT_VALACCODEEXPRESSIONBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodeexpression.h>
#include <gobject/valaccodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_EXPRESSION_BINDING (vala_ccode_expression_binding_get_type ())
#define VALA_CCODE_EXPRESSION_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_EXPRESSION_BINDING, ValaCCodeExpressionBinding))
#define VALA_CCODE_EXPRESSION_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_EXPRESSION_BINDING, ValaCCodeExpressionBindingClass))
#define VALA_IS_CCODE_EXPRESSION_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_EXPRESSION_BINDING))
#define VALA_IS_CCODE_EXPRESSION_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_EXPRESSION_BINDING))
#define VALA_CCODE_EXPRESSION_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_EXPRESSION_BINDING, ValaCCodeExpressionBindingClass))

typedef struct _ValaCCodeExpressionBinding ValaCCodeExpressionBinding;
typedef struct _ValaCCodeExpressionBindingClass ValaCCodeExpressionBindingClass;
typedef struct _ValaCCodeExpressionBindingPrivate ValaCCodeExpressionBindingPrivate;

/**
 * The link between an expression and generated code.
 */
struct _ValaCCodeExpressionBinding {
	ValaCCodeBinding parent;
	ValaCCodeExpressionBindingPrivate * priv;
};
struct _ValaCCodeExpressionBindingClass {
	ValaCCodeBindingClass parent;
};

ValaCCodeExpression* vala_ccode_expression_binding_get_codenode (ValaCCodeExpressionBinding* self);
void vala_ccode_expression_binding_set_codenode (ValaCCodeExpressionBinding* self, ValaCCodeExpression* value);
GType vala_ccode_expression_binding_get_type (void);

G_END_DECLS

#endif
