/* valatypecheck.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALATYPECHECK_H__
#define __VALA_VALATYPECHECK_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_TYPE_CHECK (vala_type_check_get_type ())
#define VALA_TYPE_CHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPE_CHECK, ValaTypeCheck))
#define VALA_TYPE_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPE_CHECK, ValaTypeCheckClass))
#define VALA_IS_TYPE_CHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPE_CHECK))
#define VALA_IS_TYPE_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPE_CHECK))
#define VALA_TYPE_CHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPE_CHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheckPrivate ValaTypeCheckPrivate;

/**
 * Represents a type check (`is') expression in the source code.
 */
struct _ValaTypeCheck {
	ValaExpression parent;
	ValaTypeCheckPrivate * priv;
};
struct _ValaTypeCheckClass {
	ValaExpressionClass parent;
};

ValaTypeCheck* vala_type_check_new (ValaExpression* expr, ValaTypeReference* type, ValaSourceReference* source);
ValaExpression* vala_type_check_get_expression (ValaTypeCheck* self);
void vala_type_check_set_expression (ValaTypeCheck* self, ValaExpression* value);
ValaTypeReference* vala_type_check_get_type_reference (ValaTypeCheck* self);
void vala_type_check_set_type_reference (ValaTypeCheck* self, ValaTypeReference* value);
GType vala_type_check_get_type (void);

G_END_DECLS

#endif
