/* valaccodewriter.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEWRITER_H__
#define __CCODE_VALACCODEWRITER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriterPrivate ValaCCodeWriterPrivate;

/**
 * Represents a writer to write C source files.
 */
struct _ValaCCodeWriter {
	GObject parent;
	ValaCCodeWriterPrivate * priv;
};
struct _ValaCCodeWriterClass {
	GObjectClass parent;
};

ValaCCodeWriter* vala_ccode_writer_new (const char* _filename);
void vala_ccode_writer_close (ValaCCodeWriter* self);
void vala_ccode_writer_write_indent (ValaCCodeWriter* self, ValaCCodeLineDirective* line);
void vala_ccode_writer_write_string (ValaCCodeWriter* self, const char* s);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
void vala_ccode_writer_write_begin_block (ValaCCodeWriter* self);
void vala_ccode_writer_write_end_block (ValaCCodeWriter* self);
void vala_ccode_writer_write_comment (ValaCCodeWriter* self, const char* text);
char* vala_ccode_writer_get_filename (ValaCCodeWriter* self);
void vala_ccode_writer_set_filename (ValaCCodeWriter* self, const char* value);
gboolean vala_ccode_writer_get_line_directives (ValaCCodeWriter* self);
void vala_ccode_writer_set_line_directives (ValaCCodeWriter* self, gboolean value);
gboolean vala_ccode_writer_get_bol (ValaCCodeWriter* self);
GType vala_ccode_writer_get_type (void);

G_END_DECLS

#endif
