/* valatypeofexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatypeofexpression.h>
#include <vala/valatypereference.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaTypeofExpressionPrivate {
	ValaTypeReference* _type_reference;
};
#define VALA_TYPEOF_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionPrivate))
enum  {
	VALA_TYPEOF_EXPRESSION_DUMMY_PROPERTY,
	VALA_TYPEOF_EXPRESSION_TYPE_REFERENCE
};
static void vala_typeof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_typeof_expression_parent_class = NULL;
static void vala_typeof_expression_dispose (GObject * obj);


/**
 * Creates a new typeof expression.
 *
 * @param type   a data type
 * @param source reference to source code
 * @return       newly created typeof expression
 */
ValaTypeofExpression* vala_typeof_expression_new (ValaTypeReference* type, ValaSourceReference* source) {
	GParameter * __params;
	GParameter * __params_it;
	ValaTypeofExpression * self;
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type), __params_it++);
	self = g_object_newv (VALA_TYPE_TYPEOF_EXPRESSION, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_typeof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTypeofExpression * self;
	self = VALA_TYPEOF_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_typeof_expression_get_type_reference (self)), visitor);
	vala_code_visitor_visit_typeof_expression (visitor, self);
}


ValaTypeReference* vala_typeof_expression_get_type_reference (ValaTypeofExpression* self) {
	g_return_val_if_fail (VALA_IS_TYPEOF_EXPRESSION (self), NULL);
	return self->priv->_type_reference;
}


void vala_typeof_expression_set_type_reference (ValaTypeofExpression* self, ValaTypeReference* value) {
	ValaTypeReference* _tmp1;
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (self));
	_tmp1 = NULL;
	self->priv->_type_reference = (_tmp1 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), _tmp1);
}


static void vala_typeof_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaTypeofExpression * self;
	self = VALA_TYPEOF_EXPRESSION (object);
	switch (property_id) {
		case VALA_TYPEOF_EXPRESSION_TYPE_REFERENCE:
		g_value_set_object (value, vala_typeof_expression_get_type_reference (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_typeof_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaTypeofExpression * self;
	self = VALA_TYPEOF_EXPRESSION (object);
	switch (property_id) {
		case VALA_TYPEOF_EXPRESSION_TYPE_REFERENCE:
		vala_typeof_expression_set_type_reference (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_typeof_expression_class_init (ValaTypeofExpressionClass * klass) {
	vala_typeof_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeofExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_typeof_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_typeof_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_typeof_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_typeof_expression_real_accept;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPEOF_EXPRESSION_TYPE_REFERENCE, g_param_spec_object ("type-reference", "type-reference", "type-reference", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_typeof_expression_init (ValaTypeofExpression * self) {
	self->priv = VALA_TYPEOF_EXPRESSION_GET_PRIVATE (self);
}


static void vala_typeof_expression_dispose (GObject * obj) {
	ValaTypeofExpression * self;
	self = VALA_TYPEOF_EXPRESSION (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	G_OBJECT_CLASS (vala_typeof_expression_parent_class)->dispose (obj);
}


GType vala_typeof_expression_get_type (void) {
	static GType vala_typeof_expression_type_id = 0;
	if (G_UNLIKELY (vala_typeof_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeofExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeof_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeofExpression), 0, (GInstanceInitFunc) vala_typeof_expression_init };
		vala_typeof_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTypeofExpression", &g_define_type_info, 0);
	}
	return vala_typeof_expression_type_id;
}




