/* valaccodestruct.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodestruct.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>




struct _ValaCCodeStructPrivate {
	char* _name;
	GeeList* declarations;
};

#define VALA_CCODE_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructPrivate))
enum  {
	VALA_CCODE_STRUCT_DUMMY_PROPERTY,
	VALA_CCODE_STRUCT_NAME
};
static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_struct_parent_class = NULL;
static void vala_ccode_struct_dispose (GObject * obj);



ValaCCodeStruct* vala_ccode_struct_new (const char* name) {
	ValaCCodeStruct * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (VALA_TYPE_CCODE_STRUCT, 0, NULL);
	vala_ccode_struct_set_name (self, name);
	return self;
}


/**
 * Adds the specified declaration as member to this struct.
 *
 * @param decl a variable declaration
 */
void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl) {
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (decl));
	gee_collection_add (GEE_COLLECTION (self->priv->declarations), decl);
}


/**
 * Adds a variable with the specified type and name to this struct.
 *
 * @param type_name field type
 * @param name      member name
 */
void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name) {
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp0;
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	g_return_if_fail (type_name != NULL);
	g_return_if_fail (name != NULL);
	decl = vala_ccode_declaration_new (type_name);
	_tmp0 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((_tmp0 = vala_ccode_variable_declarator_new (name))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	vala_ccode_struct_add_declaration (self, decl);
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "struct ");
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_begin_block (writer);
	{
		GeeList* decl_collection;
		int decl_it;
		decl_collection = self->priv->declarations;
		for (decl_it = 0; decl_it < gee_collection_get_size (GEE_COLLECTION (decl_collection)); decl_it = decl_it + 1) {
			ValaCCodeDeclaration* decl;
			decl = ((ValaCCodeDeclaration*) (gee_list_get (GEE_LIST (decl_collection), decl_it)));
			{
				vala_ccode_node_write_declaration (VALA_CCODE_NODE (decl), writer);
				(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			}
		}
	}
	vala_ccode_writer_write_end_block (writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_struct_get_name (ValaCCodeStruct* self) {
	g_return_val_if_fail (VALA_IS_CCODE_STRUCT (self), NULL);
	return self->priv->_name;
}


void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


static void vala_ccode_struct_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (object);
	switch (property_id) {
		case VALA_CCODE_STRUCT_NAME:
		g_value_set_string (value, vala_ccode_struct_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_struct_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (object);
	switch (property_id) {
		case VALA_CCODE_STRUCT_NAME:
		vala_ccode_struct_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_struct_class_init (ValaCCodeStructClass * klass) {
	vala_ccode_struct_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeStructPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_struct_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_struct_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_struct_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_struct_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_STRUCT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_struct_instance_init (ValaCCodeStruct * self) {
	self->priv = VALA_CCODE_STRUCT_GET_PRIVATE (self);
	self->priv->declarations = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_DECLARATION, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
}


static void vala_ccode_struct_dispose (GObject * obj) {
	ValaCCodeStruct * self;
	self = VALA_CCODE_STRUCT (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->declarations == NULL ? NULL : (self->priv->declarations = (g_object_unref (self->priv->declarations), NULL)));
	G_OBJECT_CLASS (vala_ccode_struct_parent_class)->dispose (obj);
}


GType vala_ccode_struct_get_type (void) {
	static GType vala_ccode_struct_type_id = 0;
	if (G_UNLIKELY (vala_ccode_struct_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStruct), 0, (GInstanceInitFunc) vala_ccode_struct_instance_init };
		vala_ccode_struct_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeStruct", &g_define_type_info, 0);
	}
	return vala_ccode_struct_type_id;
}




