/* valaccodeenum.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeenum.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeEnumPrivate {
	char* _name;
	GeeList* values;
};

#define VALA_CCODE_ENUM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ENUM, ValaCCodeEnumPrivate))
enum  {
	VALA_CCODE_ENUM_DUMMY_PROPERTY,
	VALA_CCODE_ENUM_NAME
};
static void vala_ccode_enum_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_enum_parent_class = NULL;
static void vala_ccode_enum_finalize (GObject * obj);



ValaCCodeEnum* vala_ccode_enum_new (const char* name) {
	ValaCCodeEnum * self;
	self = g_object_newv (VALA_TYPE_CCODE_ENUM, 0, NULL);
	vala_ccode_enum_set_name (self, name);
	return self;
}


/**
 * Adds the specified value to this enum.
 *
 * @param name  enum value name
 * @param value optional numerical value
 */
void vala_ccode_enum_add_value (ValaCCodeEnum* self, ValaCCodeEnumValue* value) {
	g_return_if_fail (VALA_IS_CCODE_ENUM (self));
	g_return_if_fail (VALA_IS_CCODE_ENUM_VALUE (value));
	gee_collection_add (GEE_COLLECTION (self->priv->values), value);
}


static void vala_ccode_enum_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeEnum * self;
	gboolean first;
	self = VALA_CCODE_ENUM (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (self->priv->_name != NULL) {
		vala_ccode_writer_write_string (writer, "typedef ");
	}
	vala_ccode_writer_write_string (writer, "enum ");
	vala_ccode_writer_write_begin_block (writer);
	first = TRUE;
	{
		GeeList* value_collection;
		int value_it;
		value_collection = self->priv->values;
		for (value_it = 0; value_it < gee_collection_get_size (GEE_COLLECTION (value_collection)); value_it = value_it + 1) {
			ValaCCodeEnumValue* value;
			value = ((ValaCCodeEnumValue*) (gee_list_get (GEE_LIST (value_collection), value_it)));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ",");
					vala_ccode_writer_write_newline (writer);
				}
				vala_ccode_writer_write_indent (writer, NULL);
				vala_ccode_node_write (VALA_CCODE_NODE (value), writer);
				first = FALSE;
				(value == NULL ? NULL : (value = (g_object_unref (value), NULL)));
			}
		}
	}
	if (!first) {
		vala_ccode_writer_write_newline (writer);
	}
	vala_ccode_writer_write_end_block (writer);
	if (self->priv->_name != NULL) {
		vala_ccode_writer_write_string (writer, " ");
		vala_ccode_writer_write_string (writer, self->priv->_name);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_enum_get_name (ValaCCodeEnum* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ENUM (self), NULL);
	return self->priv->_name;
}


void vala_ccode_enum_set_name (ValaCCodeEnum* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ENUM (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
	g_object_notify (((GObject *) (self)), "name");
}


static void vala_ccode_enum_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeEnum * self;
	self = VALA_CCODE_ENUM (object);
	switch (property_id) {
		case VALA_CCODE_ENUM_NAME:
		g_value_set_string (value, vala_ccode_enum_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_enum_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeEnum * self;
	self = VALA_CCODE_ENUM (object);
	switch (property_id) {
		case VALA_CCODE_ENUM_NAME:
		vala_ccode_enum_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_enum_class_init (ValaCCodeEnumClass * klass) {
	vala_ccode_enum_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeEnumPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_enum_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_enum_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_enum_finalize;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_enum_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ENUM_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_enum_instance_init (ValaCCodeEnum * self) {
	self->priv = VALA_CCODE_ENUM_GET_PRIVATE (self);
	self->priv->values = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_ENUM_VALUE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
}


static void vala_ccode_enum_finalize (GObject * obj) {
	ValaCCodeEnum * self;
	self = VALA_CCODE_ENUM (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->values == NULL ? NULL : (self->priv->values = (g_object_unref (self->priv->values), NULL)));
	G_OBJECT_CLASS (vala_ccode_enum_parent_class)->finalize (obj);
}


GType vala_ccode_enum_get_type (void) {
	static GType vala_ccode_enum_type_id = 0;
	if (vala_ccode_enum_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeEnum), 0, (GInstanceInitFunc) vala_ccode_enum_instance_init };
		vala_ccode_enum_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeEnum", &g_define_type_info, 0);
	}
	return vala_ccode_enum_type_id;
}




