/* valainterfacetype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valainterfacetype.h>
#include <vala/valacodenode.h>




struct _ValaInterfaceTypePrivate {
	ValaInterface* _interface_symbol;
};

#define VALA_INTERFACE_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE_TYPE, ValaInterfaceTypePrivate))
enum  {
	VALA_INTERFACE_TYPE_DUMMY_PROPERTY,
	VALA_INTERFACE_TYPE_INTERFACE_SYMBOL
};
static ValaDataType* vala_interface_type_real_copy (ValaDataType* base);
static char* vala_interface_type_real_get_cname (ValaDataType* base);
static gpointer vala_interface_type_parent_class = NULL;
static void vala_interface_type_finalize (GObject * obj);



ValaInterfaceType* vala_interface_type_new (ValaInterface* interface_symbol) {
	ValaInterfaceType * self;
	g_return_val_if_fail (VALA_IS_INTERFACE (interface_symbol), NULL);
	self = g_object_newv (VALA_TYPE_INTERFACE_TYPE, 0, NULL);
	vala_interface_type_set_interface_symbol (self, interface_symbol);
	return self;
}


static ValaDataType* vala_interface_type_real_copy (ValaDataType* base) {
	ValaInterfaceType * self;
	ValaInterfaceType* result;
	self = VALA_INTERFACE_TYPE (base);
	result = vala_interface_type_new (self->priv->_interface_symbol);
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_value_owned (VALA_DATA_TYPE (result), vala_data_type_get_value_owned (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_dynamic (VALA_DATA_TYPE (result), vala_data_type_get_is_dynamic (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaDataType* arg;
			arg = ((ValaDataType*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (g_object_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (g_object_unref (arg_collection), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static char* vala_interface_type_real_get_cname (ValaDataType* base) {
	ValaInterfaceType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_INTERFACE_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%sIface*", (_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_interface_symbol), FALSE))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


ValaInterface* vala_interface_type_get_interface_symbol (ValaInterfaceType* self) {
	g_return_val_if_fail (VALA_IS_INTERFACE_TYPE (self), NULL);
	return self->priv->_interface_symbol;
}


void vala_interface_type_set_interface_symbol (ValaInterfaceType* self, ValaInterface* value) {
	g_return_if_fail (VALA_IS_INTERFACE_TYPE (self));
	self->priv->_interface_symbol = value;
	g_object_notify (((GObject *) (self)), "interface-symbol");
}


static void vala_interface_type_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (object);
	switch (property_id) {
		case VALA_INTERFACE_TYPE_INTERFACE_SYMBOL:
		g_value_set_object (value, vala_interface_type_get_interface_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_interface_type_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (object);
	switch (property_id) {
		case VALA_INTERFACE_TYPE_INTERFACE_SYMBOL:
		vala_interface_type_set_interface_symbol (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_interface_type_class_init (ValaInterfaceTypeClass * klass) {
	vala_interface_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaInterfaceTypePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_interface_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_interface_type_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_interface_type_finalize;
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_interface_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_interface_type_real_get_cname;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_INTERFACE_TYPE_INTERFACE_SYMBOL, g_param_spec_object ("interface-symbol", "interface-symbol", "interface-symbol", VALA_TYPE_INTERFACE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_interface_type_instance_init (ValaInterfaceType * self) {
	self->priv = VALA_INTERFACE_TYPE_GET_PRIVATE (self);
}


static void vala_interface_type_finalize (GObject * obj) {
	ValaInterfaceType * self;
	self = VALA_INTERFACE_TYPE (obj);
	G_OBJECT_CLASS (vala_interface_type_parent_class)->finalize (obj);
}


GType vala_interface_type_get_type (void) {
	static GType vala_interface_type_type_id = 0;
	if (vala_interface_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterfaceType), 0, (GInstanceInitFunc) vala_interface_type_instance_init };
		vala_interface_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaInterfaceType", &g_define_type_info, 0);
	}
	return vala_interface_type_type_id;
}




