/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_diagnostic_colors;
static gboolean vala_compiler_disable_diagnostic_colors = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_0_PROPERTY
};
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[57] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_ = NULL;
			ValaReport* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_ = NULL;
			ValaCodeContext* _tmp22_ = NULL;
			ValaReport* _tmp23_ = NULL;
			ValaReport* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_ = NULL;
			ValaCodeContext* _tmp28_ = NULL;
			ValaReport* _tmp29_ = NULL;
			ValaReport* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			ValaCodeContext* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			ValaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaCodeContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	ValaCodeContext* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	ValaCodeContext* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	ValaCodeContext* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	ValaCodeContext* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	ValaCodeContext* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaCodeContext* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ValaCodeContext* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp45_ = NULL;
	ValaReport* _tmp46_ = NULL;
	ValaReport* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	ValaCodeContext* _tmp49_ = NULL;
	ValaReport* _tmp50_ = NULL;
	ValaReport* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	ValaCodeContext* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	ValaCodeContext* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	ValaCodeContext* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaCodeContext* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	ValaCodeContext* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_ = NULL;
	ValaCodeContext* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	ValaCodeContext* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	ValaCodeContext* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	ValaCodeContext* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	ValaCodeContext* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	const gchar* _tmp80_ = NULL;
	const gchar* _tmp82_ = NULL;
	const gchar* _tmp90_ = NULL;
	ValaCodeContext* _tmp99_ = NULL;
	gchar** _tmp100_ = NULL;
	gint _tmp100__length1 = 0;
	gchar** _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	ValaCodeContext* _tmp102_ = NULL;
	gboolean _tmp103_ = FALSE;
	ValaCodeContext* _tmp104_ = NULL;
	gchar** _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	gchar** _tmp106_ = NULL;
	gint _tmp106__length1 = 0;
	ValaCodeContext* _tmp107_ = NULL;
	gchar** _tmp108_ = NULL;
	gint _tmp108__length1 = 0;
	gchar** _tmp109_ = NULL;
	gint _tmp109__length1 = 0;
	ValaCodeContext* _tmp110_ = NULL;
	gboolean _tmp111_ = FALSE;
	ValaCodeContext* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	ValaCodeContext* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	ValaCodeContext* _tmp116_ = NULL;
	gboolean _tmp117_ = FALSE;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp121_ = FALSE;
	gboolean _tmp122_ = FALSE;
	const gchar* _tmp123_ = NULL;
	gboolean _tmp131_ = FALSE;
	const gchar* _tmp132_ = NULL;
	ValaCodeContext* _tmp133_ = NULL;
	gboolean _tmp134_ = FALSE;
	ValaCodeContext* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	ValaCodeContext* _tmp137_ = NULL;
	gboolean _tmp138_ = FALSE;
	const gchar* _tmp139_ = NULL;
	ValaCodeContext* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	gchar** _tmp145_ = NULL;
	gint _tmp145__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp157_ = FALSE;
	const gchar* _tmp158_ = NULL;
	ValaCodeContext* _tmp161_ = NULL;
	gint _tmp162_ = 0;
	ValaCodeContext* _tmp163_ = NULL;
	gint _tmp164_ = 0;
	ValaCodeContext* _tmp165_ = NULL;
	gint _tmp166_ = 0;
	gint _tmp167_ = 0;
	gboolean _tmp176_ = FALSE;
	gchar** _tmp179_ = NULL;
	gint _tmp179__length1 = 0;
	gchar** _tmp184_ = NULL;
	gint _tmp184__length1 = 0;
	ValaCodeContext* _tmp195_ = NULL;
	gchar** _tmp196_ = NULL;
	gint _tmp196__length1 = 0;
	gchar** _tmp197_ = NULL;
	gint _tmp197__length1 = 0;
	ValaCodeContext* _tmp198_ = NULL;
	gchar** _tmp199_ = NULL;
	gint _tmp199__length1 = 0;
	gchar** _tmp200_ = NULL;
	gint _tmp200__length1 = 0;
	gboolean _tmp201_ = FALSE;
	ValaCodeContext* _tmp202_ = NULL;
	ValaReport* _tmp203_ = NULL;
	ValaReport* _tmp204_ = NULL;
	gint _tmp205_ = 0;
	ValaCodeContext* _tmp213_ = NULL;
	ValaGDBusServerModule* _tmp214_ = NULL;
	ValaGDBusServerModule* _tmp215_ = NULL;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp216_ = NULL;
	gint _tmp216__length1 = 0;
	gboolean _tmp226_ = FALSE;
	gboolean _tmp227_ = FALSE;
	gboolean _tmp231_ = FALSE;
	ValaCodeContext* _tmp232_ = NULL;
	ValaReport* _tmp233_ = NULL;
	ValaReport* _tmp234_ = NULL;
	gint _tmp235_ = 0;
	ValaParser* parser = NULL;
	ValaParser* _tmp243_ = NULL;
	ValaParser* _tmp244_ = NULL;
	ValaCodeContext* _tmp245_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp246_ = NULL;
	ValaGenieParser* _tmp247_ = NULL;
	ValaCodeContext* _tmp248_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp249_ = NULL;
	ValaGirParser* _tmp250_ = NULL;
	ValaCodeContext* _tmp251_ = NULL;
	gboolean _tmp252_ = FALSE;
	ValaCodeContext* _tmp253_ = NULL;
	ValaReport* _tmp254_ = NULL;
	ValaReport* _tmp255_ = NULL;
	gint _tmp256_ = 0;
	const gchar* _tmp264_ = NULL;
	ValaCodeContext* _tmp270_ = NULL;
	gboolean _tmp271_ = FALSE;
	ValaCodeContext* _tmp272_ = NULL;
	ValaReport* _tmp273_ = NULL;
	ValaReport* _tmp274_ = NULL;
	gint _tmp275_ = 0;
	gboolean _tmp283_ = FALSE;
	gboolean _tmp284_ = FALSE;
	gboolean _tmp285_ = FALSE;
	const gchar* _tmp293_ = NULL;
	gboolean _tmp298_ = FALSE;
	ValaCodeContext* _tmp299_ = NULL;
	ValaReport* _tmp300_ = NULL;
	ValaReport* _tmp301_ = NULL;
	gint _tmp302_ = 0;
	ValaCodeContext* _tmp310_ = NULL;
	ValaCodeGenerator* _tmp311_ = NULL;
	ValaCodeGenerator* _tmp312_ = NULL;
	ValaCodeContext* _tmp313_ = NULL;
	gboolean _tmp314_ = FALSE;
	ValaCodeContext* _tmp315_ = NULL;
	ValaReport* _tmp316_ = NULL;
	ValaReport* _tmp317_ = NULL;
	gint _tmp318_ = 0;
	gboolean _tmp326_ = FALSE;
	const gchar* _tmp327_ = NULL;
	const gchar* _tmp331_ = NULL;
	const gchar* _tmp385_ = NULL;
	const gchar* _tmp399_ = NULL;
	const gchar* _tmp444_ = NULL;
	gboolean _tmp447_ = FALSE;
	ValaCodeContext* _tmp448_ = NULL;
	ValaReport* _tmp449_ = NULL;
	ValaReport* _tmp450_ = NULL;
	gint _tmp451_ = 0;
	gboolean _tmp459_ = FALSE;
	gint _tmp476_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_diagnostic_colors;
	if (_tmp2_ == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_ = NULL;
			ValaReport* _tmp6_ = NULL;
			ValaReport* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			vala_report_set_colors (_tmp7_, _tmp8_);
		} else {
			ValaCodeContext* _tmp9_ = NULL;
			ValaReport* _tmp10_ = NULL;
			ValaReport* _tmp11_ = NULL;
			_tmp9_ = self->priv->context;
			_tmp10_ = vala_code_context_get_report (_tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_set_colors (_tmp11_, VALA_COMPILER_DEFAULT_COLORS);
		}
	}
	_tmp14_ = vala_compiler_ccode_only;
	if (!_tmp14_) {
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_compile_only;
		_tmp13_ = !_tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = vala_compiler_output;
		_tmp12_ = _tmp16_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		_tmp19_ = string_last_index_of_char (_tmp18_, (gunichar) '.', 0);
		if (_tmp19_ != -1) {
			gint dot = 0;
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			const gchar* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp20_ = vala_compiler_sources;
			_tmp20__length1 = _vala_array_length (vala_compiler_sources);
			_tmp21_ = _tmp20_[0];
			_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
			dot = _tmp22_;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = dot;
			_tmp26_ = string_substring (_tmp24_, (glong) 0, (glong) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_path_get_basename (_tmp27_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp28_;
			_g_free0 (_tmp27_);
		}
	}
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp29_, !_tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp37_, _tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_code_context_get_report (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp47_, !_tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_code_context_get_report (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp51_, !_tmp52_);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp55_, !_tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp57_, _tmp58_);
	_tmp60_ = vala_compiler_ccode_only;
	if (_tmp60_) {
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		_tmp61_ = vala_compiler_cc_options;
		_tmp61__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp59_ = _tmp61_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp62_ = self->priv->context;
	_tmp63_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp62_, _tmp63_);
	_tmp64_ = self->priv->context;
	_tmp65_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp64_, _tmp65_);
	_tmp67_ = vala_compiler_header_filename;
	if (_tmp67_ == NULL) {
		gboolean _tmp68_ = FALSE;
		_tmp68_ = vala_compiler_use_header;
		_tmp66_ = _tmp68_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp69_ = self->priv->context;
	_tmp70_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp69_, _tmp70_);
	_tmp71_ = self->priv->context;
	_tmp72_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp71_, _tmp72_);
	_tmp73_ = self->priv->context;
	_tmp74_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp73_, _tmp74_);
	_tmp75_ = self->priv->context;
	_tmp76_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp75_, _tmp76_);
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_compiler_output;
	vala_code_context_set_output (_tmp77_, _tmp78_);
	_tmp80_ = vala_compiler_output;
	if (_tmp80_ != NULL) {
		gboolean _tmp81_ = FALSE;
		_tmp81_ = vala_compiler_ccode_only;
		_tmp79_ = _tmp81_;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp82_ = vala_compiler_basedir;
	if (_tmp82_ == NULL) {
		ValaCodeContext* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		_tmp83_ = self->priv->context;
		_tmp84_ = vala_code_context_realpath (".");
		_tmp85_ = _tmp84_;
		vala_code_context_set_basedir (_tmp83_, _tmp85_);
		_g_free0 (_tmp85_);
	} else {
		ValaCodeContext* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		_tmp86_ = self->priv->context;
		_tmp87_ = vala_compiler_basedir;
		_tmp88_ = vala_code_context_realpath (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_context_set_basedir (_tmp86_, _tmp89_);
		_g_free0 (_tmp89_);
	}
	_tmp90_ = vala_compiler_directory;
	if (_tmp90_ != NULL) {
		ValaCodeContext* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		_tmp91_ = self->priv->context;
		_tmp92_ = vala_compiler_directory;
		_tmp93_ = vala_code_context_realpath (_tmp92_);
		_tmp94_ = _tmp93_;
		vala_code_context_set_directory (_tmp91_, _tmp94_);
		_g_free0 (_tmp94_);
	} else {
		ValaCodeContext* _tmp95_ = NULL;
		ValaCodeContext* _tmp96_ = NULL;
		const gchar* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		_tmp95_ = self->priv->context;
		_tmp96_ = self->priv->context;
		_tmp97_ = vala_code_context_get_basedir (_tmp96_);
		_tmp98_ = _tmp97_;
		vala_code_context_set_directory (_tmp95_, _tmp98_);
	}
	_tmp99_ = self->priv->context;
	_tmp100_ = vala_compiler_vapi_directories;
	_tmp100__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp101_ = (_tmp100_ != NULL) ? _vala_array_dup1 (_tmp100_, _tmp100__length1) : ((gpointer) _tmp100_);
	_tmp101__length1 = _tmp100__length1;
	_tmp99_->vapi_directories = (_vala_array_free (_tmp99_->vapi_directories, _tmp99_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp99_->vapi_directories = _tmp101_;
	_tmp99_->vapi_directories_length1 = _tmp101__length1;
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp102_, _tmp103_);
	_tmp104_ = self->priv->context;
	_tmp105_ = vala_compiler_gir_directories;
	_tmp105__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp106_ = (_tmp105_ != NULL) ? _vala_array_dup2 (_tmp105_, _tmp105__length1) : ((gpointer) _tmp105_);
	_tmp106__length1 = _tmp105__length1;
	_tmp104_->gir_directories = (_vala_array_free (_tmp104_->gir_directories, _tmp104_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp104_->gir_directories = _tmp106_;
	_tmp104_->gir_directories_length1 = _tmp106__length1;
	_tmp107_ = self->priv->context;
	_tmp108_ = vala_compiler_metadata_directories;
	_tmp108__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp109_ = (_tmp108_ != NULL) ? _vala_array_dup3 (_tmp108_, _tmp108__length1) : ((gpointer) _tmp108_);
	_tmp109__length1 = _tmp108__length1;
	_tmp107_->metadata_directories = (_vala_array_free (_tmp107_->metadata_directories, _tmp107_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp107_->metadata_directories = _tmp109_;
	_tmp107_->metadata_directories_length1 = _tmp109__length1;
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp112_, _tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp114_, _tmp115_);
	_tmp116_ = self->priv->context;
	_tmp117_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp116_, _tmp117_);
	_tmp119_ = vala_compiler_ccode_only;
	if (_tmp119_) {
		gboolean _tmp120_ = FALSE;
		_tmp120_ = vala_compiler_save_temps;
		_tmp118_ = _tmp120_;
	} else {
		_tmp118_ = FALSE;
	}
	if (_tmp118_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp123_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp123_, "gobject-2.0") == 0) {
		_tmp122_ = TRUE;
	} else {
		const gchar* _tmp124_ = NULL;
		_tmp124_ = vala_compiler_profile;
		_tmp122_ = g_strcmp0 (_tmp124_, "gobject") == 0;
	}
	if (_tmp122_) {
		_tmp121_ = TRUE;
	} else {
		const gchar* _tmp125_ = NULL;
		_tmp125_ = vala_compiler_profile;
		_tmp121_ = _tmp125_ == NULL;
	}
	if (_tmp121_) {
		ValaCodeContext* _tmp126_ = NULL;
		ValaCodeContext* _tmp127_ = NULL;
		_tmp126_ = self->priv->context;
		vala_code_context_set_profile (_tmp126_, VALA_PROFILE_GOBJECT);
		_tmp127_ = self->priv->context;
		vala_code_context_add_define (_tmp127_, "GOBJECT");
	} else {
		const gchar* _tmp128_ = NULL;
		gchar* _tmp129_ = NULL;
		gchar* _tmp130_ = NULL;
		_tmp128_ = vala_compiler_profile;
		_tmp129_ = g_strdup_printf ("Unknown profile %s", _tmp128_);
		_tmp130_ = _tmp129_;
		vala_report_error (NULL, _tmp130_);
		_g_free0 (_tmp130_);
	}
	_tmp131_ = vala_compiler_nostdpkg;
	_tmp132_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp131_ | (_tmp132_ != NULL);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp133_, _tmp134_);
	_tmp135_ = self->priv->context;
	_tmp136_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp135_, _tmp136_);
	_tmp137_ = self->priv->context;
	_tmp138_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp137_, _tmp138_);
	_tmp139_ = vala_compiler_pkg_config_command;
	if (_tmp139_ == NULL) {
		const gchar* _tmp140_ = NULL;
		const gchar* _tmp141_ = NULL;
		gchar* _tmp142_ = NULL;
		_tmp141_ = g_getenv ("PKG_CONFIG");
		_tmp140_ = _tmp141_;
		if (_tmp140_ == NULL) {
			_tmp140_ = "pkg-config";
		}
		_tmp142_ = g_strdup (_tmp140_);
		_g_free0 (vala_compiler_pkg_config_command);
		vala_compiler_pkg_config_command = _tmp142_;
	}
	_tmp143_ = self->priv->context;
	_tmp144_ = vala_compiler_pkg_config_command;
	vala_code_context_set_pkg_config_command (_tmp143_, _tmp144_);
	_tmp145_ = vala_compiler_defines;
	_tmp145__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp145_ != NULL) {
		gchar** _tmp146_ = NULL;
		gint _tmp146__length1 = 0;
		_tmp146_ = vala_compiler_defines;
		_tmp146__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp146_;
			define_collection_length1 = _tmp146__length1;
			for (define_it = 0; define_it < _tmp146__length1; define_it = define_it + 1) {
				gchar* _tmp147_ = NULL;
				gchar* define = NULL;
				_tmp147_ = g_strdup (define_collection[define_it]);
				define = _tmp147_;
				{
					ValaCodeContext* _tmp148_ = NULL;
					const gchar* _tmp149_ = NULL;
					_tmp148_ = self->priv->context;
					_tmp149_ = define;
					vala_code_context_add_define (_tmp148_, _tmp149_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp150_ = FALSE;
			_tmp150_ = TRUE;
			while (TRUE) {
				gint _tmp152_ = 0;
				ValaCodeContext* _tmp153_ = NULL;
				gint _tmp154_ = 0;
				gchar* _tmp155_ = NULL;
				gchar* _tmp156_ = NULL;
				if (!_tmp150_) {
					gint _tmp151_ = 0;
					_tmp151_ = i;
					i = _tmp151_ + 2;
				}
				_tmp150_ = FALSE;
				_tmp152_ = i;
				if (!(_tmp152_ <= 34)) {
					break;
				}
				_tmp153_ = self->priv->context;
				_tmp154_ = i;
				_tmp155_ = g_strdup_printf ("VALA_0_%d", _tmp154_);
				_tmp156_ = _tmp155_;
				vala_code_context_add_define (_tmp153_, _tmp156_);
				_g_free0 (_tmp156_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 32;
	_tmp158_ = vala_compiler_target_glib;
	if (_tmp158_ != NULL) {
		const gchar* _tmp159_ = NULL;
		gint _tmp160_ = 0;
		_tmp159_ = vala_compiler_target_glib;
		_tmp160_ = sscanf (_tmp159_, "%d.%d", &glib_major, &glib_minor);
		_tmp157_ = _tmp160_ != 2;
	} else {
		_tmp157_ = FALSE;
	}
	if (_tmp157_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp161_ = self->priv->context;
	_tmp162_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp161_, _tmp162_);
	_tmp163_ = self->priv->context;
	_tmp164_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp163_, _tmp164_);
	_tmp165_ = self->priv->context;
	_tmp166_ = vala_code_context_get_target_glib_major (_tmp165_);
	_tmp167_ = _tmp166_;
	if (_tmp167_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp168_ = FALSE;
			_tmp168_ = TRUE;
			while (TRUE) {
				gint _tmp170_ = 0;
				gint _tmp171_ = 0;
				ValaCodeContext* _tmp172_ = NULL;
				gint _tmp173_ = 0;
				gchar* _tmp174_ = NULL;
				gchar* _tmp175_ = NULL;
				if (!_tmp168_) {
					gint _tmp169_ = 0;
					_tmp169_ = i;
					i = _tmp169_ + 2;
				}
				_tmp168_ = FALSE;
				_tmp170_ = i;
				_tmp171_ = glib_minor;
				if (!(_tmp170_ <= _tmp171_)) {
					break;
				}
				_tmp172_ = self->priv->context;
				_tmp173_ = i;
				_tmp174_ = g_strdup_printf ("GLIB_2_%d", _tmp173_);
				_tmp175_ = _tmp174_;
				vala_code_context_add_define (_tmp172_, _tmp175_);
				_g_free0 (_tmp175_);
			}
		}
	}
	_tmp176_ = vala_compiler_nostdpkg;
	if (!_tmp176_) {
		ValaCodeContext* _tmp177_ = NULL;
		ValaCodeContext* _tmp178_ = NULL;
		_tmp177_ = self->priv->context;
		vala_code_context_add_external_package (_tmp177_, "glib-2.0");
		_tmp178_ = self->priv->context;
		vala_code_context_add_external_package (_tmp178_, "gobject-2.0");
	}
	_tmp179_ = vala_compiler_packages;
	_tmp179__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp179_ != NULL) {
		gchar** _tmp180_ = NULL;
		gint _tmp180__length1 = 0;
		_tmp180_ = vala_compiler_packages;
		_tmp180__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp180_;
			package_collection_length1 = _tmp180__length1;
			for (package_it = 0; package_it < _tmp180__length1; package_it = package_it + 1) {
				gchar* _tmp181_ = NULL;
				gchar* package = NULL;
				_tmp181_ = g_strdup (package_collection[package_it]);
				package = _tmp181_;
				{
					ValaCodeContext* _tmp182_ = NULL;
					const gchar* _tmp183_ = NULL;
					_tmp182_ = self->priv->context;
					_tmp183_ = package;
					vala_code_context_add_external_package (_tmp182_, _tmp183_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp184_ = vala_compiler_fast_vapis;
	_tmp184__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp184_ != NULL) {
		gchar** _tmp185_ = NULL;
		gint _tmp185__length1 = 0;
		ValaCodeContext* _tmp194_ = NULL;
		_tmp185_ = vala_compiler_fast_vapis;
		_tmp185__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp185_;
			vapi_collection_length1 = _tmp185__length1;
			for (vapi_it = 0; vapi_it < _tmp185__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp186_ = NULL;
				gchar* vapi = NULL;
				_tmp186_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp186_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp187_ = NULL;
					gchar* _tmp188_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp189_ = NULL;
					const gchar* _tmp190_ = NULL;
					ValaSourceFile* _tmp191_ = NULL;
					ValaCodeContext* _tmp192_ = NULL;
					ValaSourceFile* _tmp193_ = NULL;
					_tmp187_ = vapi;
					_tmp188_ = vala_code_context_realpath (_tmp187_);
					rpath = _tmp188_;
					_tmp189_ = self->priv->context;
					_tmp190_ = rpath;
					_tmp191_ = vala_source_file_new (_tmp189_, VALA_SOURCE_FILE_TYPE_FAST, _tmp190_, NULL, FALSE);
					source_file = _tmp191_;
					_tmp192_ = self->priv->context;
					_tmp193_ = source_file;
					vala_code_context_add_source_file (_tmp192_, _tmp193_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp194_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp194_, TRUE);
	}
	_tmp195_ = self->priv->context;
	_tmp196_ = vala_compiler_gresources;
	_tmp196__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp197_ = (_tmp196_ != NULL) ? _vala_array_dup4 (_tmp196_, _tmp196__length1) : ((gpointer) _tmp196_);
	_tmp197__length1 = _tmp196__length1;
	_tmp195_->gresources = (_vala_array_free (_tmp195_->gresources, _tmp195_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp195_->gresources = _tmp197_;
	_tmp195_->gresources_length1 = _tmp197__length1;
	_tmp198_ = self->priv->context;
	_tmp199_ = vala_compiler_gresources_directories;
	_tmp199__length1 = _vala_array_length (vala_compiler_gresources_directories);
	_tmp200_ = (_tmp199_ != NULL) ? _vala_array_dup5 (_tmp199_, _tmp199__length1) : ((gpointer) _tmp199_);
	_tmp200__length1 = _tmp199__length1;
	_tmp198_->gresources_directories = (_vala_array_free (_tmp198_->gresources_directories, _tmp198_->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp198_->gresources_directories = _tmp200_;
	_tmp198_->gresources_directories_length1 = _tmp200__length1;
	_tmp202_ = self->priv->context;
	_tmp203_ = vala_code_context_get_report (_tmp202_);
	_tmp204_ = _tmp203_;
	_tmp205_ = vala_report_get_errors (_tmp204_);
	if (_tmp205_ > 0) {
		_tmp201_ = TRUE;
	} else {
		gboolean _tmp206_ = FALSE;
		gboolean _tmp207_ = FALSE;
		_tmp207_ = vala_compiler_fatal_warnings;
		if (_tmp207_) {
			ValaCodeContext* _tmp208_ = NULL;
			ValaReport* _tmp209_ = NULL;
			ValaReport* _tmp210_ = NULL;
			gint _tmp211_ = 0;
			_tmp208_ = self->priv->context;
			_tmp209_ = vala_code_context_get_report (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_report_get_warnings (_tmp210_);
			_tmp206_ = _tmp211_ > 0;
		} else {
			_tmp206_ = FALSE;
		}
		_tmp201_ = _tmp206_;
	}
	if (_tmp201_) {
		gint _tmp212_ = 0;
		_tmp212_ = vala_compiler_quit (self);
		result = _tmp212_;
		return result;
	}
	_tmp213_ = self->priv->context;
	_tmp214_ = vala_gd_bus_server_module_new ();
	_tmp215_ = _tmp214_;
	vala_code_context_set_codegen (_tmp213_, (ValaCodeGenerator*) _tmp215_);
	_vala_code_visitor_unref0 (_tmp215_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp216_ = vala_compiler_sources;
	_tmp216__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp216_;
		source_collection_length1 = _tmp216__length1;
		for (source_it = 0; source_it < _tmp216__length1; source_it = source_it + 1) {
			gchar* _tmp217_ = NULL;
			gchar* source = NULL;
			_tmp217_ = g_strdup (source_collection[source_it]);
			source = _tmp217_;
			{
				ValaCodeContext* _tmp218_ = NULL;
				const gchar* _tmp219_ = NULL;
				gboolean _tmp220_ = FALSE;
				gboolean _tmp221_ = FALSE;
				_tmp218_ = self->priv->context;
				_tmp219_ = source;
				_tmp220_ = vala_compiler_run_output;
				_tmp221_ = vala_code_context_add_source_filename (_tmp218_, _tmp219_, _tmp220_, TRUE);
				if (_tmp221_) {
					const gchar* _tmp222_ = NULL;
					gboolean _tmp223_ = FALSE;
					_tmp222_ = source;
					_tmp223_ = g_str_has_suffix (_tmp222_, ".c");
					if (_tmp223_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp224_ = NULL;
						gboolean _tmp225_ = FALSE;
						_tmp224_ = source;
						_tmp225_ = g_str_has_suffix (_tmp224_, ".h");
						if (_tmp225_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp227_ = vala_compiler_ccode_only;
	if (_tmp227_) {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_ = FALSE;
		_tmp229_ = has_c_files;
		if (_tmp229_) {
			_tmp228_ = TRUE;
		} else {
			gboolean _tmp230_ = FALSE;
			_tmp230_ = has_h_files;
			_tmp228_ = _tmp230_;
		}
		_tmp226_ = _tmp228_;
	} else {
		_tmp226_ = FALSE;
	}
	if (_tmp226_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp232_ = self->priv->context;
	_tmp233_ = vala_code_context_get_report (_tmp232_);
	_tmp234_ = _tmp233_;
	_tmp235_ = vala_report_get_errors (_tmp234_);
	if (_tmp235_ > 0) {
		_tmp231_ = TRUE;
	} else {
		gboolean _tmp236_ = FALSE;
		gboolean _tmp237_ = FALSE;
		_tmp237_ = vala_compiler_fatal_warnings;
		if (_tmp237_) {
			ValaCodeContext* _tmp238_ = NULL;
			ValaReport* _tmp239_ = NULL;
			ValaReport* _tmp240_ = NULL;
			gint _tmp241_ = 0;
			_tmp238_ = self->priv->context;
			_tmp239_ = vala_code_context_get_report (_tmp238_);
			_tmp240_ = _tmp239_;
			_tmp241_ = vala_report_get_warnings (_tmp240_);
			_tmp236_ = _tmp241_ > 0;
		} else {
			_tmp236_ = FALSE;
		}
		_tmp231_ = _tmp236_;
	}
	if (_tmp231_) {
		gint _tmp242_ = 0;
		_tmp242_ = vala_compiler_quit (self);
		result = _tmp242_;
		return result;
	}
	_tmp243_ = vala_parser_new ();
	parser = _tmp243_;
	_tmp244_ = parser;
	_tmp245_ = self->priv->context;
	vala_parser_parse (_tmp244_, _tmp245_);
	_tmp246_ = vala_genie_parser_new ();
	genie_parser = _tmp246_;
	_tmp247_ = genie_parser;
	_tmp248_ = self->priv->context;
	vala_genie_parser_parse (_tmp247_, _tmp248_);
	_tmp249_ = vala_gir_parser_new ();
	gir_parser = _tmp249_;
	_tmp250_ = gir_parser;
	_tmp251_ = self->priv->context;
	vala_gir_parser_parse (_tmp250_, _tmp251_);
	_tmp253_ = self->priv->context;
	_tmp254_ = vala_code_context_get_report (_tmp253_);
	_tmp255_ = _tmp254_;
	_tmp256_ = vala_report_get_errors (_tmp255_);
	if (_tmp256_ > 0) {
		_tmp252_ = TRUE;
	} else {
		gboolean _tmp257_ = FALSE;
		gboolean _tmp258_ = FALSE;
		_tmp258_ = vala_compiler_fatal_warnings;
		if (_tmp258_) {
			ValaCodeContext* _tmp259_ = NULL;
			ValaReport* _tmp260_ = NULL;
			ValaReport* _tmp261_ = NULL;
			gint _tmp262_ = 0;
			_tmp259_ = self->priv->context;
			_tmp260_ = vala_code_context_get_report (_tmp259_);
			_tmp261_ = _tmp260_;
			_tmp262_ = vala_report_get_warnings (_tmp261_);
			_tmp257_ = _tmp262_ > 0;
		} else {
			_tmp257_ = FALSE;
		}
		_tmp252_ = _tmp257_;
	}
	if (_tmp252_) {
		gint _tmp263_ = 0;
		_tmp263_ = vala_compiler_quit (self);
		result = _tmp263_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp264_ = vala_compiler_fast_vapi_filename;
	if (_tmp264_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp265_ = NULL;
		ValaCodeWriter* _tmp266_ = NULL;
		ValaCodeContext* _tmp267_ = NULL;
		const gchar* _tmp268_ = NULL;
		gint _tmp269_ = 0;
		_tmp265_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp265_;
		_tmp266_ = interface_writer;
		_tmp267_ = self->priv->context;
		_tmp268_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp266_, _tmp267_, _tmp268_);
		_tmp269_ = vala_compiler_quit (self);
		result = _tmp269_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp270_ = self->priv->context;
	vala_code_context_check (_tmp270_);
	_tmp272_ = self->priv->context;
	_tmp273_ = vala_code_context_get_report (_tmp272_);
	_tmp274_ = _tmp273_;
	_tmp275_ = vala_report_get_errors (_tmp274_);
	if (_tmp275_ > 0) {
		_tmp271_ = TRUE;
	} else {
		gboolean _tmp276_ = FALSE;
		gboolean _tmp277_ = FALSE;
		_tmp277_ = vala_compiler_fatal_warnings;
		if (_tmp277_) {
			ValaCodeContext* _tmp278_ = NULL;
			ValaReport* _tmp279_ = NULL;
			ValaReport* _tmp280_ = NULL;
			gint _tmp281_ = 0;
			_tmp278_ = self->priv->context;
			_tmp279_ = vala_code_context_get_report (_tmp278_);
			_tmp280_ = _tmp279_;
			_tmp281_ = vala_report_get_warnings (_tmp280_);
			_tmp276_ = _tmp281_ > 0;
		} else {
			_tmp276_ = FALSE;
		}
		_tmp271_ = _tmp276_;
	}
	if (_tmp271_) {
		gint _tmp282_ = 0;
		_tmp282_ = vala_compiler_quit (self);
		result = _tmp282_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp285_ = vala_compiler_ccode_only;
	if (!_tmp285_) {
		gboolean _tmp286_ = FALSE;
		_tmp286_ = vala_compiler_compile_only;
		_tmp284_ = !_tmp286_;
	} else {
		_tmp284_ = FALSE;
	}
	if (_tmp284_) {
		const gchar* _tmp287_ = NULL;
		_tmp287_ = vala_compiler_library;
		_tmp283_ = _tmp287_ == NULL;
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		gboolean _tmp288_ = FALSE;
		gboolean _tmp289_ = FALSE;
		_tmp289_ = has_c_files;
		if (!_tmp289_) {
			ValaCodeContext* _tmp290_ = NULL;
			ValaMethod* _tmp291_ = NULL;
			ValaMethod* _tmp292_ = NULL;
			_tmp290_ = self->priv->context;
			_tmp291_ = vala_code_context_get_entry_point (_tmp290_);
			_tmp292_ = _tmp291_;
			_tmp288_ = _tmp292_ == NULL;
		} else {
			_tmp288_ = FALSE;
		}
		if (_tmp288_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp293_ = vala_compiler_dump_tree;
	if (_tmp293_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp294_ = NULL;
		ValaCodeWriter* _tmp295_ = NULL;
		ValaCodeContext* _tmp296_ = NULL;
		const gchar* _tmp297_ = NULL;
		_tmp294_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp294_;
		_tmp295_ = code_writer;
		_tmp296_ = self->priv->context;
		_tmp297_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp295_, _tmp296_, _tmp297_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp299_ = self->priv->context;
	_tmp300_ = vala_code_context_get_report (_tmp299_);
	_tmp301_ = _tmp300_;
	_tmp302_ = vala_report_get_errors (_tmp301_);
	if (_tmp302_ > 0) {
		_tmp298_ = TRUE;
	} else {
		gboolean _tmp303_ = FALSE;
		gboolean _tmp304_ = FALSE;
		_tmp304_ = vala_compiler_fatal_warnings;
		if (_tmp304_) {
			ValaCodeContext* _tmp305_ = NULL;
			ValaReport* _tmp306_ = NULL;
			ValaReport* _tmp307_ = NULL;
			gint _tmp308_ = 0;
			_tmp305_ = self->priv->context;
			_tmp306_ = vala_code_context_get_report (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_report_get_warnings (_tmp307_);
			_tmp303_ = _tmp308_ > 0;
		} else {
			_tmp303_ = FALSE;
		}
		_tmp298_ = _tmp303_;
	}
	if (_tmp298_) {
		gint _tmp309_ = 0;
		_tmp309_ = vala_compiler_quit (self);
		result = _tmp309_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp310_ = self->priv->context;
	_tmp311_ = vala_code_context_get_codegen (_tmp310_);
	_tmp312_ = _tmp311_;
	_tmp313_ = self->priv->context;
	vala_code_generator_emit (_tmp312_, _tmp313_);
	_tmp315_ = self->priv->context;
	_tmp316_ = vala_code_context_get_report (_tmp315_);
	_tmp317_ = _tmp316_;
	_tmp318_ = vala_report_get_errors (_tmp317_);
	if (_tmp318_ > 0) {
		_tmp314_ = TRUE;
	} else {
		gboolean _tmp319_ = FALSE;
		gboolean _tmp320_ = FALSE;
		_tmp320_ = vala_compiler_fatal_warnings;
		if (_tmp320_) {
			ValaCodeContext* _tmp321_ = NULL;
			ValaReport* _tmp322_ = NULL;
			ValaReport* _tmp323_ = NULL;
			gint _tmp324_ = 0;
			_tmp321_ = self->priv->context;
			_tmp322_ = vala_code_context_get_report (_tmp321_);
			_tmp323_ = _tmp322_;
			_tmp324_ = vala_report_get_warnings (_tmp323_);
			_tmp319_ = _tmp324_ > 0;
		} else {
			_tmp319_ = FALSE;
		}
		_tmp314_ = _tmp319_;
	}
	if (_tmp314_) {
		gint _tmp325_ = 0;
		_tmp325_ = vala_compiler_quit (self);
		result = _tmp325_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp327_ = vala_compiler_vapi_filename;
	if (_tmp327_ == NULL) {
		const gchar* _tmp328_ = NULL;
		_tmp328_ = vala_compiler_library;
		_tmp326_ = _tmp328_ != NULL;
	} else {
		_tmp326_ = FALSE;
	}
	if (_tmp326_) {
		const gchar* _tmp329_ = NULL;
		gchar* _tmp330_ = NULL;
		_tmp329_ = vala_compiler_library;
		_tmp330_ = g_strdup_printf ("%s.vapi", _tmp329_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp330_;
	}
	_tmp331_ = vala_compiler_library;
	if (_tmp331_ != NULL) {
		const gchar* _tmp332_ = NULL;
		_tmp332_ = vala_compiler_gir;
		if (_tmp332_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp333_ = NULL;
			gchar* _tmp334_ = NULL;
			glong gir_len = 0L;
			const gchar* _tmp335_ = NULL;
			gint _tmp336_ = 0;
			gint _tmp337_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp338_ = NULL;
			gint _tmp339_ = 0;
			gboolean _tmp340_ = FALSE;
			gint _tmp341_ = 0;
			_tmp333_ = vala_compiler_gir;
			_tmp334_ = g_path_get_basename (_tmp333_);
			gir_base = _tmp334_;
			_tmp335_ = gir_base;
			_tmp336_ = strlen (_tmp335_);
			_tmp337_ = _tmp336_;
			gir_len = (glong) _tmp337_;
			_tmp338_ = gir_base;
			_tmp339_ = string_last_index_of_char (_tmp338_, (gunichar) '-', 0);
			last_hyphen = _tmp339_;
			_tmp341_ = last_hyphen;
			if (_tmp341_ == -1) {
				_tmp340_ = TRUE;
			} else {
				const gchar* _tmp342_ = NULL;
				gboolean _tmp343_ = FALSE;
				_tmp342_ = gir_base;
				_tmp343_ = g_str_has_suffix (_tmp342_, ".gir");
				_tmp340_ = !_tmp343_;
			}
			if (_tmp340_) {
				const gchar* _tmp344_ = NULL;
				gchar* _tmp345_ = NULL;
				gchar* _tmp346_ = NULL;
				_tmp344_ = vala_compiler_gir;
				_tmp345_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp344_);
				_tmp346_ = _tmp345_;
				vala_report_error (NULL, _tmp346_);
				_g_free0 (_tmp346_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp347_ = NULL;
				gint _tmp348_ = 0;
				gchar* _tmp349_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp350_ = NULL;
				gint _tmp351_ = 0;
				glong _tmp352_ = 0L;
				gint _tmp353_ = 0;
				gchar* _tmp354_ = NULL;
				const gchar* _tmp355_ = NULL;
				gboolean _tmp356_ = FALSE;
				gboolean _tmp357_ = FALSE;
				gboolean _tmp358_ = FALSE;
				const gchar* _tmp359_ = NULL;
				_tmp347_ = gir_base;
				_tmp348_ = last_hyphen;
				_tmp349_ = string_substring (_tmp347_, (glong) 0, (glong) _tmp348_);
				gir_namespace = _tmp349_;
				_tmp350_ = gir_base;
				_tmp351_ = last_hyphen;
				_tmp352_ = gir_len;
				_tmp353_ = last_hyphen;
				_tmp354_ = string_substring (_tmp350_, (glong) (_tmp351_ + 1), (_tmp352_ - _tmp353_) - 5);
				gir_version = _tmp354_;
				_tmp355_ = gir_version;
				g_strcanon (_tmp355_, "0123456789.", '?');
				_tmp359_ = gir_namespace;
				if (g_strcmp0 (_tmp359_, "") == 0) {
					_tmp358_ = TRUE;
				} else {
					const gchar* _tmp360_ = NULL;
					_tmp360_ = gir_version;
					_tmp358_ = g_strcmp0 (_tmp360_, "") == 0;
				}
				if (_tmp358_) {
					_tmp357_ = TRUE;
				} else {
					const gchar* _tmp361_ = NULL;
					gchar _tmp362_ = '\0';
					gboolean _tmp363_ = FALSE;
					_tmp361_ = gir_version;
					_tmp362_ = string_get (_tmp361_, (glong) 0);
					_tmp363_ = g_ascii_isdigit (_tmp362_);
					_tmp357_ = !_tmp363_;
				}
				if (_tmp357_) {
					_tmp356_ = TRUE;
				} else {
					const gchar* _tmp364_ = NULL;
					gboolean _tmp365_ = FALSE;
					_tmp364_ = gir_version;
					_tmp365_ = string_contains (_tmp364_, "?");
					_tmp356_ = _tmp365_;
				}
				if (_tmp356_) {
					const gchar* _tmp366_ = NULL;
					gchar* _tmp367_ = NULL;
					gchar* _tmp368_ = NULL;
					_tmp366_ = vala_compiler_gir;
					_tmp367_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp366_);
					_tmp368_ = _tmp367_;
					vala_report_error (NULL, _tmp368_);
					_g_free0 (_tmp368_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp369_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp370_ = NULL;
					const gchar* _tmp371_ = NULL;
					ValaGIRWriter* _tmp376_ = NULL;
					ValaCodeContext* _tmp377_ = NULL;
					const gchar* _tmp378_ = NULL;
					const gchar* _tmp379_ = NULL;
					const gchar* _tmp380_ = NULL;
					const gchar* _tmp381_ = NULL;
					const gchar* _tmp382_ = NULL;
					const gchar* _tmp383_ = NULL;
					_tmp369_ = vala_gir_writer_new ();
					gir_writer = _tmp369_;
					_tmp370_ = g_strdup (".");
					gir_directory = _tmp370_;
					_tmp371_ = vala_compiler_directory;
					if (_tmp371_ != NULL) {
						ValaCodeContext* _tmp372_ = NULL;
						const gchar* _tmp373_ = NULL;
						const gchar* _tmp374_ = NULL;
						gchar* _tmp375_ = NULL;
						_tmp372_ = self->priv->context;
						_tmp373_ = vala_code_context_get_directory (_tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_strdup (_tmp374_);
						_g_free0 (gir_directory);
						gir_directory = _tmp375_;
					}
					_tmp376_ = gir_writer;
					_tmp377_ = self->priv->context;
					_tmp378_ = gir_directory;
					_tmp379_ = vala_compiler_gir;
					_tmp380_ = gir_namespace;
					_tmp381_ = gir_version;
					_tmp382_ = vala_compiler_library;
					_tmp383_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp376_, _tmp377_, _tmp378_, _tmp379_, _tmp380_, _tmp381_, _tmp382_, _tmp383_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	} else {
		const gchar* _tmp384_ = NULL;
		_tmp384_ = vala_compiler_gir;
		if (_tmp384_ != NULL) {
			vala_report_warning (NULL, "--gir has no effect without --library");
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
	}
	_tmp385_ = vala_compiler_vapi_filename;
	if (_tmp385_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp386_ = NULL;
		gboolean _tmp387_ = FALSE;
		const gchar* _tmp388_ = NULL;
		ValaCodeWriter* _tmp396_ = NULL;
		ValaCodeContext* _tmp397_ = NULL;
		const gchar* _tmp398_ = NULL;
		_tmp386_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp386_;
		_tmp388_ = vala_compiler_directory;
		if (_tmp388_ != NULL) {
			const gchar* _tmp389_ = NULL;
			gboolean _tmp390_ = FALSE;
			_tmp389_ = vala_compiler_vapi_filename;
			_tmp390_ = g_path_is_absolute (_tmp389_);
			_tmp387_ = !_tmp390_;
		} else {
			_tmp387_ = FALSE;
		}
		if (_tmp387_) {
			ValaCodeContext* _tmp391_ = NULL;
			const gchar* _tmp392_ = NULL;
			const gchar* _tmp393_ = NULL;
			const gchar* _tmp394_ = NULL;
			gchar* _tmp395_ = NULL;
			_tmp391_ = self->priv->context;
			_tmp392_ = vala_code_context_get_directory (_tmp391_);
			_tmp393_ = _tmp392_;
			_tmp394_ = vala_compiler_vapi_filename;
			_tmp395_ = g_strdup_printf ("%s%c%s", _tmp393_, (gint) G_DIR_SEPARATOR, _tmp394_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp395_;
		}
		_tmp396_ = interface_writer;
		_tmp397_ = self->priv->context;
		_tmp398_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp396_, _tmp397_, _tmp398_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp399_ = vala_compiler_internal_vapi_filename;
	if (_tmp399_ != NULL) {
		gboolean _tmp400_ = FALSE;
		const gchar* _tmp401_ = NULL;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp404_ = NULL;
		ValaCodeContext* _tmp405_ = NULL;
		const gchar* _tmp406_ = NULL;
		const gchar* _tmp407_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp430_ = NULL;
		gchar* _tmp431_ = NULL;
		gboolean _tmp432_ = FALSE;
		const gchar* _tmp433_ = NULL;
		ValaCodeWriter* _tmp441_ = NULL;
		ValaCodeContext* _tmp442_ = NULL;
		const gchar* _tmp443_ = NULL;
		_tmp401_ = vala_compiler_internal_header_filename;
		if (_tmp401_ == NULL) {
			_tmp400_ = TRUE;
		} else {
			const gchar* _tmp402_ = NULL;
			_tmp402_ = vala_compiler_header_filename;
			_tmp400_ = _tmp402_ == NULL;
		}
		if (_tmp400_) {
			gint _tmp403_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp403_ = vala_compiler_quit (self);
			result = _tmp403_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp404_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp404_;
		_tmp405_ = self->priv->context;
		_tmp406_ = vala_code_context_get_includedir (_tmp405_);
		_tmp407_ = _tmp406_;
		if (_tmp407_ != NULL) {
			gchar* prefixed_header_filename = NULL;
			ValaCodeContext* _tmp408_ = NULL;
			const gchar* _tmp409_ = NULL;
			const gchar* _tmp410_ = NULL;
			const gchar* _tmp411_ = NULL;
			gchar* _tmp412_ = NULL;
			gchar* _tmp413_ = NULL;
			gchar* _tmp414_ = NULL;
			gchar* _tmp415_ = NULL;
			gchar* prefixed_internal_header_filename = NULL;
			ValaCodeContext* _tmp416_ = NULL;
			const gchar* _tmp417_ = NULL;
			const gchar* _tmp418_ = NULL;
			const gchar* _tmp419_ = NULL;
			gchar* _tmp420_ = NULL;
			gchar* _tmp421_ = NULL;
			gchar* _tmp422_ = NULL;
			gchar* _tmp423_ = NULL;
			ValaCodeWriter* _tmp424_ = NULL;
			const gchar* _tmp425_ = NULL;
			const gchar* _tmp426_ = NULL;
			_tmp408_ = self->priv->context;
			_tmp409_ = vala_code_context_get_includedir (_tmp408_);
			_tmp410_ = _tmp409_;
			_tmp411_ = vala_compiler_header_filename;
			_tmp412_ = g_path_get_basename (_tmp411_);
			_tmp413_ = _tmp412_;
			_tmp414_ = g_build_path ("/", _tmp410_, _tmp413_, NULL);
			_tmp415_ = _tmp414_;
			_g_free0 (_tmp413_);
			prefixed_header_filename = _tmp415_;
			_tmp416_ = self->priv->context;
			_tmp417_ = vala_code_context_get_includedir (_tmp416_);
			_tmp418_ = _tmp417_;
			_tmp419_ = vala_compiler_internal_header_filename;
			_tmp420_ = g_path_get_basename (_tmp419_);
			_tmp421_ = _tmp420_;
			_tmp422_ = g_build_path ("/", _tmp418_, _tmp421_, NULL);
			_tmp423_ = _tmp422_;
			_g_free0 (_tmp421_);
			prefixed_internal_header_filename = _tmp423_;
			_tmp424_ = interface_writer;
			_tmp425_ = prefixed_header_filename;
			_tmp426_ = prefixed_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp424_, _tmp425_, _tmp426_);
			_g_free0 (prefixed_internal_header_filename);
			_g_free0 (prefixed_header_filename);
		} else {
			ValaCodeWriter* _tmp427_ = NULL;
			const gchar* _tmp428_ = NULL;
			const gchar* _tmp429_ = NULL;
			_tmp427_ = interface_writer;
			_tmp428_ = vala_compiler_header_filename;
			_tmp429_ = vala_compiler_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp427_, _tmp428_, _tmp429_);
		}
		_tmp430_ = vala_compiler_internal_vapi_filename;
		_tmp431_ = g_strdup (_tmp430_);
		vapi_filename = _tmp431_;
		_tmp433_ = vala_compiler_directory;
		if (_tmp433_ != NULL) {
			const gchar* _tmp434_ = NULL;
			gboolean _tmp435_ = FALSE;
			_tmp434_ = vapi_filename;
			_tmp435_ = g_path_is_absolute (_tmp434_);
			_tmp432_ = !_tmp435_;
		} else {
			_tmp432_ = FALSE;
		}
		if (_tmp432_) {
			ValaCodeContext* _tmp436_ = NULL;
			const gchar* _tmp437_ = NULL;
			const gchar* _tmp438_ = NULL;
			const gchar* _tmp439_ = NULL;
			gchar* _tmp440_ = NULL;
			_tmp436_ = self->priv->context;
			_tmp437_ = vala_code_context_get_directory (_tmp436_);
			_tmp438_ = _tmp437_;
			_tmp439_ = vapi_filename;
			_tmp440_ = g_strdup_printf ("%s%c%s", _tmp438_, (gint) G_DIR_SEPARATOR, _tmp439_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp440_;
		}
		_tmp441_ = interface_writer;
		_tmp442_ = self->priv->context;
		_tmp443_ = vapi_filename;
		vala_code_writer_write_file (_tmp441_, _tmp442_, _tmp443_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp444_ = vala_compiler_dependencies;
	if (_tmp444_ != NULL) {
		ValaCodeContext* _tmp445_ = NULL;
		const gchar* _tmp446_ = NULL;
		_tmp445_ = self->priv->context;
		_tmp446_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp445_, _tmp446_);
	}
	_tmp448_ = self->priv->context;
	_tmp449_ = vala_code_context_get_report (_tmp448_);
	_tmp450_ = _tmp449_;
	_tmp451_ = vala_report_get_errors (_tmp450_);
	if (_tmp451_ > 0) {
		_tmp447_ = TRUE;
	} else {
		gboolean _tmp452_ = FALSE;
		gboolean _tmp453_ = FALSE;
		_tmp453_ = vala_compiler_fatal_warnings;
		if (_tmp453_) {
			ValaCodeContext* _tmp454_ = NULL;
			ValaReport* _tmp455_ = NULL;
			ValaReport* _tmp456_ = NULL;
			gint _tmp457_ = 0;
			_tmp454_ = self->priv->context;
			_tmp455_ = vala_code_context_get_report (_tmp454_);
			_tmp456_ = _tmp455_;
			_tmp457_ = vala_report_get_warnings (_tmp456_);
			_tmp452_ = _tmp457_ > 0;
		} else {
			_tmp452_ = FALSE;
		}
		_tmp447_ = _tmp452_;
	}
	if (_tmp447_) {
		gint _tmp458_ = 0;
		_tmp458_ = vala_compiler_quit (self);
		result = _tmp458_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp459_ = vala_compiler_ccode_only;
	if (!_tmp459_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp460_ = NULL;
		gboolean _tmp461_ = FALSE;
		const gchar* _tmp462_ = NULL;
		gchar** _tmp466_ = NULL;
		gint _tmp466__length1 = 0;
		_tmp460_ = vala_ccode_compiler_new ();
		ccompiler = _tmp460_;
		_tmp462_ = vala_compiler_cc_command;
		if (_tmp462_ == NULL) {
			const gchar* _tmp463_ = NULL;
			_tmp463_ = g_getenv ("CC");
			_tmp461_ = _tmp463_ != NULL;
		} else {
			_tmp461_ = FALSE;
		}
		if (_tmp461_) {
			const gchar* _tmp464_ = NULL;
			gchar* _tmp465_ = NULL;
			_tmp464_ = g_getenv ("CC");
			_tmp465_ = g_strdup (_tmp464_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp465_;
		}
		_tmp466_ = vala_compiler_cc_options;
		_tmp466__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp466_ == NULL) {
			ValaCCodeCompiler* _tmp467_ = NULL;
			ValaCodeContext* _tmp468_ = NULL;
			const gchar* _tmp469_ = NULL;
			gchar** _tmp470_ = NULL;
			gchar** _tmp471_ = NULL;
			gint _tmp471__length1 = 0;
			_tmp467_ = ccompiler;
			_tmp468_ = self->priv->context;
			_tmp469_ = vala_compiler_cc_command;
			_tmp470_ = g_new0 (gchar*, 0 + 1);
			_tmp471_ = _tmp470_;
			_tmp471__length1 = 0;
			vala_ccode_compiler_compile (_tmp467_, _tmp468_, _tmp469_, _tmp471_, 0);
			_tmp471_ = (_vala_array_free (_tmp471_, _tmp471__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp472_ = NULL;
			ValaCodeContext* _tmp473_ = NULL;
			const gchar* _tmp474_ = NULL;
			gchar** _tmp475_ = NULL;
			gint _tmp475__length1 = 0;
			_tmp472_ = ccompiler;
			_tmp473_ = self->priv->context;
			_tmp474_ = vala_compiler_cc_command;
			_tmp475_ = vala_compiler_cc_options;
			_tmp475__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp472_, _tmp473_, _tmp474_, _tmp475_, _tmp475__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp476_ = vala_compiler_quit (self);
	result = _tmp476_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp32_ = FALSE;
	gchar** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp39_ = 0;
	const gchar* _tmp40_ = NULL;
	gchar** _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gint _tmp43_ = 0;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar** _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar** _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gint _tmp49_ = 0;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp57_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	const gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	gint _tmp87_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp31_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			GOptionContext* _tmp17_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp19_ = NULL;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp14_ = 0;
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp14_;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp20_ = 0;
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp20_;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp21_ = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = stdout;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			fprintf (_tmp21_, "%s\n", _tmp23_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp24_ = NULL;
			GError* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			FILE* _tmp27_ = NULL;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			const gchar* _tmp29_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = stdout;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			fprintf (_tmp24_, "%s\n", _tmp26_);
			_tmp27_ = stdout;
			_tmp28_ = args;
			_tmp28__length1 = args_length1;
			_tmp29_ = _tmp28_[0];
			fprintf (_tmp27_, "Run '%s --help' to see a full list of available command line options.\n", _tmp29_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp30_ = 0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp30_;
		}
		_tmp31_ = i;
		i = _tmp31_ + 1;
	}
	_tmp32_ = vala_compiler_version;
	if (_tmp32_) {
		FILE* _tmp33_ = NULL;
		_tmp33_ = stdout;
		fprintf (_tmp33_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp34_ = FALSE;
		_tmp34_ = vala_compiler_api_version;
		if (_tmp34_) {
			FILE* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp35_ = stdout;
			_tmp36_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) -1);
			_tmp37_ = _tmp36_;
			fprintf (_tmp35_, "%s\n", _tmp37_);
			_g_free0 (_tmp37_);
			result = 0;
			return result;
		}
	}
	_tmp38_ = args;
	_tmp38__length1 = args_length1;
	_tmp39_ = i;
	_tmp40_ = _tmp38_[_tmp39_];
	if (_tmp40_ == NULL) {
		FILE* _tmp41_ = NULL;
		_tmp41_ = stderr;
		fprintf (_tmp41_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp42_ = args;
	_tmp42__length1 = args_length1;
	_tmp43_ = i;
	_tmp44_ = _tmp42_[_tmp43_];
	_tmp45_ = g_strdup (_tmp44_);
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp46_;
	_tmp47_ = g_get_tmp_dir ();
	_tmp48_ = args;
	_tmp48__length1 = args_length1;
	_tmp49_ = i;
	_tmp50_ = _tmp48_[_tmp49_];
	_tmp51_ = g_path_get_basename (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp47_, _tmp52_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp53_;
	_g_free0 (_tmp52_);
	_tmp54_ = vala_compiler_output;
	_tmp55_ = g_mkstemp (_tmp54_);
	outputfd = _tmp55_;
	_tmp56_ = outputfd;
	if (_tmp56_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp57_ = vala_compiler_new ();
	compiler = _tmp57_;
	_tmp58_ = compiler;
	_tmp59_ = vala_compiler_run (_tmp58_);
	ret = _tmp59_;
	_tmp60_ = ret;
	if (_tmp60_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp61_ = outputfd;
	close (_tmp61_);
	_tmp62_ = vala_compiler_output;
	_tmp63_ = g_chmod (_tmp62_, 0700);
	if (_tmp63_ != 0) {
		const gchar* _tmp64_ = NULL;
		_tmp64_ = vala_compiler_output;
		g_unlink (_tmp64_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp65_ = vala_compiler_output;
	_tmp66_ = g_strdup (_tmp65_);
	_tmp67_ = g_new0 (gchar*, 1 + 1);
	_tmp67_[0] = _tmp66_;
	target_args = _tmp67_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp68_ = 0;
		gchar** _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		gchar** _tmp70_ = NULL;
		gint _tmp70__length1 = 0;
		gchar** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		gint _tmp72_ = 0;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		_tmp68_ = i;
		_tmp69_ = args;
		_tmp69__length1 = args_length1;
		if (!(_tmp68_ < _tmp69__length1)) {
			break;
		}
		_tmp70_ = target_args;
		_tmp70__length1 = target_args_length1;
		_tmp71_ = args;
		_tmp71__length1 = args_length1;
		_tmp72_ = i;
		_tmp73_ = _tmp71_[_tmp72_];
		_tmp74_ = g_strdup (_tmp73_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp74_);
		_tmp75_ = i;
		i = _tmp75_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp76_ = NULL;
		gchar** _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		GPid _tmp78_ = 0;
		const gchar* _tmp80_ = NULL;
		GPid _tmp81_ = 0;
		GMainLoop* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp76_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp76_;
		_data1_->child_status = 0;
		_tmp77_ = target_args;
		_tmp77__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp77_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp78_, &_inner_error_);
		pid = _tmp78_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp79_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp79_;
		}
		_tmp80_ = vala_compiler_output;
		g_unlink (_tmp80_);
		_tmp81_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp81_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp82_ = _data1_->loop;
		g_main_loop_run (_tmp82_);
		_tmp83_ = _data1_->child_status;
		result = _tmp83_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp84_ = NULL;
		GError* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp84_ = stdout;
		_tmp85_ = e;
		_tmp86_ = _tmp85_->message;
		fprintf (_tmp84_, "%s\n", _tmp86_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp87_;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp34_ = NULL;
	ValaCompiler* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_ = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp16_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp16_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		FILE* _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp23_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp23_;
	}
	_tmp24_ = vala_compiler_version;
	if (_tmp24_) {
		FILE* _tmp25_ = NULL;
		_tmp25_ = stdout;
		fprintf (_tmp25_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_api_version;
		if (_tmp26_) {
			FILE* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			_tmp27_ = stdout;
			_tmp28_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) -1);
			_tmp29_ = _tmp28_;
			fprintf (_tmp27_, "%s\n", _tmp29_);
			_g_free0 (_tmp29_);
			result = 0;
			return result;
		}
	}
	_tmp31_ = vala_compiler_sources;
	_tmp31__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp31_ == NULL) {
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		_tmp32_ = vala_compiler_fast_vapis;
		_tmp32__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp30_ = _tmp32_ == NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		FILE* _tmp33_ = NULL;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = vala_compiler_new ();
	compiler = _tmp34_;
	_tmp35_ = compiler;
	_tmp36_ = vala_compiler_run (_tmp35_);
	result = _tmp36_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



