/* valacodecontext.c generated by valac, the Vala compiler
 * generated from valacodecontext.vala, do not modify */

/* valacodecontext.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())

#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SYMBOL_RESOLVER (vala_symbol_resolver_get_type ())
#define VALA_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolver))
#define VALA_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverClass))
#define VALA_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL_RESOLVER))
#define VALA_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL_RESOLVER))
#define VALA_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL_RESOLVER, ValaSymbolResolverClass))

typedef struct _ValaSymbolResolver ValaSymbolResolver;
typedef struct _ValaSymbolResolverClass ValaSymbolResolverClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_FLOW_ANALYZER (vala_flow_analyzer_get_type ())
#define VALA_FLOW_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer))
#define VALA_FLOW_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerClass))
#define VALA_IS_FLOW_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FLOW_ANALYZER))
#define VALA_IS_FLOW_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FLOW_ANALYZER))
#define VALA_FLOW_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerClass))

typedef struct _ValaFlowAnalyzer ValaFlowAnalyzer;
typedef struct _ValaFlowAnalyzerClass ValaFlowAnalyzerClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_USED_ATTR (vala_used_attr_get_type ())
#define VALA_USED_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USED_ATTR, ValaUsedAttr))
#define VALA_USED_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USED_ATTR, ValaUsedAttrClass))
#define VALA_IS_USED_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USED_ATTR))
#define VALA_IS_USED_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USED_ATTR))
#define VALA_USED_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USED_ATTR, ValaUsedAttrClass))

typedef struct _ValaUsedAttr ValaUsedAttr;
typedef struct _ValaUsedAttrClass ValaUsedAttrClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE_TYPE (vala_source_file_type_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_UNRESOLVED_SYMBOL (vala_unresolved_symbol_get_type ())
#define VALA_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol))
#define VALA_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))
#define VALA_IS_UNRESOLVED_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_IS_UNRESOLVED_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNRESOLVED_SYMBOL))
#define VALA_UNRESOLVED_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbolClass))

typedef struct _ValaUnresolvedSymbol ValaUnresolvedSymbol;
typedef struct _ValaUnresolvedSymbolClass ValaUnresolvedSymbolClass;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _ValaParamSpecCodeContext ValaParamSpecCodeContext;

struct _ValaCodeContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeContextPrivate * priv;
	gchar** vapi_directories;
	gint vapi_directories_length1;
	gchar** gir_directories;
	gint gir_directories_length1;
	gchar** metadata_directories;
	gint metadata_directories_length1;
	gchar** gresources;
	gint gresources_length1;
	gchar** gresources_directories;
	gint gresources_directories_length1;
};

struct _ValaCodeContextClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeContext *self);
};

typedef enum  {
	VALA_PROFILE_GOBJECT
} ValaProfile;

struct _ValaCodeContextPrivate {
	gboolean _assert;
	gboolean _checking;
	gboolean _deprecated;
	gboolean _hide_internal;
	gboolean _since_check;
	gboolean _experimental;
	gboolean _experimental_non_null;
	gboolean _gobject_tracing;
	gboolean _ccode_only;
	gchar* _pkg_config_command;
	gchar* _header_filename;
	gchar* _internal_header_filename;
	gboolean _use_header;
	gchar* _includedir;
	gchar* _symbols_filename;
	gboolean _compile_only;
	gchar* _output;
	gchar* _basedir;
	gchar* _directory;
	gboolean _debug;
	gint _optlevel;
	gboolean _thread;
	gboolean _mem_profiler;
	ValaMethod* _module_init_method;
	gboolean _save_temps;
	ValaProfile _profile;
	gint _target_glib_major;
	gint _target_glib_minor;
	gboolean _verbose_mode;
	gboolean _version_header;
	gboolean _nostdpkg;
	gboolean _use_fast_vapi;
	gboolean _vapi_comments;
	ValaReport* _report;
	ValaMethod* _entry_point;
	gchar* _entry_point_name;
	gboolean _run_output;
	ValaList* source_files;
	ValaList* c_source_files;
	ValaNamespace* _root;
	ValaList* packages;
	ValaSet* defines;
	ValaSymbolResolver* _resolver;
	ValaSemanticAnalyzer* _analyzer;
	ValaFlowAnalyzer* _flow_analyzer;
	ValaCodeGenerator* _codegen;
	ValaUsedAttr* _used_attr;
};

typedef enum  {
	VALA_SOURCE_FILE_TYPE_NONE,
	VALA_SOURCE_FILE_TYPE_SOURCE,
	VALA_SOURCE_FILE_TYPE_PACKAGE,
	VALA_SOURCE_FILE_TYPE_FAST
} ValaSourceFileType;

struct _ValaParamSpecCodeContext {
	GParamSpec parent_instance;
};


static gpointer vala_code_context_parent_class = NULL;
static GStaticPrivate vala_code_context_context_stack_key;
static GStaticPrivate vala_code_context_context_stack_key = G_STATIC_PRIVATE_INIT;

gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_profile_get_type (void) G_GNUC_CONST;
GType vala_report_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_symbol_resolver_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_flow_analyzer_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_used_attr_get_type (void) G_GNUC_CONST;
#define VALA_CODE_CONTEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_CONTEXT, ValaCodeContextPrivate))
enum  {
	VALA_CODE_CONTEXT_0_PROPERTY
};
ValaReport* vala_report_new (void);
ValaReport* vala_report_construct (GType object_type);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaNamespace* vala_namespace_new (const gchar* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference);
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor);
gint vala_code_context_get_target_glib_major (ValaCodeContext* self);
gint vala_code_context_get_target_glib_minor (ValaCodeContext* self);
ValaCodeContext* vala_code_context_new (void);
ValaCodeContext* vala_code_context_construct (GType object_type);
ValaSymbolResolver* vala_symbol_resolver_new (void);
ValaSymbolResolver* vala_symbol_resolver_construct (GType object_type);
static void vala_code_context_set_resolver (ValaCodeContext* self, ValaSymbolResolver* value);
ValaSemanticAnalyzer* vala_semantic_analyzer_new (void);
ValaSemanticAnalyzer* vala_semantic_analyzer_construct (GType object_type);
static void vala_code_context_set_analyzer (ValaCodeContext* self, ValaSemanticAnalyzer* value);
ValaFlowAnalyzer* vala_flow_analyzer_new (void);
ValaFlowAnalyzer* vala_flow_analyzer_construct (GType object_type);
static void vala_code_context_set_flow_analyzer (ValaCodeContext* self, ValaFlowAnalyzer* value);
ValaUsedAttr* vala_used_attr_new (void);
ValaUsedAttr* vala_used_attr_construct (GType object_type);
void vala_code_context_set_used_attr (ValaCodeContext* self, ValaUsedAttr* value);
ValaCodeContext* vala_code_context_get (void);
void vala_code_context_push (ValaCodeContext* context);
void vala_code_context_pop (void);
ValaList* vala_code_context_get_source_files (ValaCodeContext* self);
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_add_c_source_file (ValaCodeContext* self, const gchar* file);
ValaList* vala_code_context_get_packages (ValaCodeContext* self);
gboolean vala_code_context_has_package (ValaCodeContext* self, const gchar* pkg);
void vala_code_context_add_package (ValaCodeContext* self, const gchar* pkg);
gboolean vala_code_context_add_external_package (ValaCodeContext* self, const gchar* pkg);
gchar* vala_code_context_get_vapi_path (ValaCodeContext* self, const gchar* pkg);
gchar* vala_code_context_get_gir_path (ValaCodeContext* self, const gchar* gir);
void vala_report_error (ValaSourceReference* source, const gchar* message);
GType vala_source_file_type_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_file_new (ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content, gboolean cmdline);
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, ValaSourceFileType type, const gchar* filename, const gchar* content, gboolean cmdline);
gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self);
gboolean vala_code_context_add_packages_from_file (ValaCodeContext* self, const gchar* filename);
gboolean vala_code_context_add_source_filename (ValaCodeContext* self, const gchar* filename, gboolean is_source, gboolean cmdline);
gchar* vala_code_context_realpath (const gchar* name);
void vala_source_file_set_relative_filename (ValaSourceFile* self, const gchar* value);
GType vala_using_directive_get_type (void) G_GNUC_CONST;
GType vala_unresolved_symbol_get_type (void) G_GNUC_CONST;
ValaUnresolvedSymbol* vala_unresolved_symbol_new (ValaUnresolvedSymbol* inner, const gchar* name, ValaSourceReference* source_reference);
ValaUnresolvedSymbol* vala_unresolved_symbol_construct (GType object_type, ValaUnresolvedSymbol* inner, const gchar* name, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_new (ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
ValaUsingDirective* vala_using_directive_construct (GType object_type, ValaSymbol* namespace_symbol, ValaSourceReference* source_reference);
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_context_check (ValaCodeContext* self);
ValaSymbolResolver* vala_code_context_get_resolver (ValaCodeContext* self);
void vala_symbol_resolver_resolve (ValaSymbolResolver* self, ValaCodeContext* context);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
gint vala_report_get_errors (ValaReport* self);
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
void vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self, ValaCodeContext* context);
ValaFlowAnalyzer* vala_code_context_get_flow_analyzer (ValaCodeContext* self);
void vala_flow_analyzer_analyze (ValaFlowAnalyzer* self, ValaCodeContext* context);
ValaUsedAttr* vala_code_context_get_used_attr (ValaCodeContext* self);
void vala_used_attr_check_unused (ValaUsedAttr* self, ValaCodeContext* context);
void vala_code_context_add_define (ValaCodeContext* self, const gchar* define);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gchar* vala_code_context_get_file_path (ValaCodeContext* self, const gchar* basename, const gchar* versioned_data_dir, const gchar* data_dir, gchar** directories, int directories_length1);
gchar* vala_code_context_get_gresource_path (ValaCodeContext* self, const gchar* gresource, const gchar* resource);
gchar* vala_code_context_get_metadata_path (ValaCodeContext* self, const gchar* gir_filename);
void vala_code_context_write_dependencies (ValaCodeContext* self, const gchar* filename);
ValaSourceFileType vala_source_file_get_file_type (ValaSourceFile* self);
gboolean vala_source_file_get_used (ValaSourceFile* self);
const gchar* vala_source_file_get_filename (ValaSourceFile* self);
static gboolean vala_code_context_ends_with_dir_separator (const gchar* s);
gboolean vala_code_context_pkg_config_exists (ValaCodeContext* self, const gchar* package_name);
const gchar* vala_code_context_get_pkg_config_command (ValaCodeContext* self);
gchar* vala_code_context_pkg_config_modversion (ValaCodeContext* self, const gchar* package_name);
gchar* vala_code_context_pkg_config_compile_flags (ValaCodeContext* self, const gchar* package_name);
gboolean vala_code_context_get_compile_only (ValaCodeContext* self);
gboolean vala_code_context_get_assert (ValaCodeContext* self);
void vala_code_context_set_assert (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_checking (ValaCodeContext* self);
void vala_code_context_set_checking (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_hide_internal (ValaCodeContext* self);
void vala_code_context_set_hide_internal (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_since_check (ValaCodeContext* self);
void vala_code_context_set_since_check (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental (ValaCodeContext* self);
void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self);
void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_gobject_tracing (ValaCodeContext* self);
void vala_code_context_set_gobject_tracing (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value);
void vala_code_context_set_pkg_config_command (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_header_filename (ValaCodeContext* self);
void vala_code_context_set_header_filename (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_internal_header_filename (ValaCodeContext* self);
void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_use_header (ValaCodeContext* self);
void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value);
const gchar* vala_code_context_get_includedir (ValaCodeContext* self);
void vala_code_context_set_includedir (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_symbols_filename (ValaCodeContext* self);
void vala_code_context_set_symbols_filename (ValaCodeContext* self, const gchar* value);
void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value);
const gchar* vala_code_context_get_output (ValaCodeContext* self);
void vala_code_context_set_output (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_basedir (ValaCodeContext* self);
void vala_code_context_set_basedir (ValaCodeContext* self, const gchar* value);
const gchar* vala_code_context_get_directory (ValaCodeContext* self);
void vala_code_context_set_directory (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_debug (ValaCodeContext* self);
void vala_code_context_set_debug (ValaCodeContext* self, gboolean value);
gint vala_code_context_get_optlevel (ValaCodeContext* self);
void vala_code_context_set_optlevel (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_thread (ValaCodeContext* self);
void vala_code_context_set_thread (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_mem_profiler (ValaCodeContext* self);
void vala_code_context_set_mem_profiler (ValaCodeContext* self, gboolean value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
gboolean vala_code_context_get_save_temps (ValaCodeContext* self);
void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value);
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value);
void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value);
void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value);
void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_version_header (ValaCodeContext* self);
void vala_code_context_set_version_header (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_nostdpkg (ValaCodeContext* self);
void vala_code_context_set_nostdpkg (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_use_fast_vapi (ValaCodeContext* self);
void vala_code_context_set_use_fast_vapi (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_vapi_comments (ValaCodeContext* self);
void vala_code_context_set_vapi_comments (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value);
ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self);
void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value);
const gchar* vala_code_context_get_entry_point_name (ValaCodeContext* self);
void vala_code_context_set_entry_point_name (ValaCodeContext* self, const gchar* value);
gboolean vala_code_context_get_run_output (ValaCodeContext* self);
void vala_code_context_set_run_output (ValaCodeContext* self, gboolean value);
ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self);
void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value);
static void vala_code_context_finalize (ValaCodeContext* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Returns true if the target version of glib is greater than or 
 * equal to the specified version.
 */
gboolean vala_code_context_require_glib_version (ValaCodeContext* self, gint major, gint minor) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_target_glib_major;
	_tmp2_ = major;
	if (_tmp1_ > _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->_target_glib_major;
		_tmp5_ = major;
		if (_tmp4_ == _tmp5_) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp6_ = self->priv->_target_glib_minor;
			_tmp7_ = minor;
			_tmp3_ = _tmp6_ >= _tmp7_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}


ValaCodeContext* vala_code_context_construct (GType object_type) {
	ValaCodeContext* self = NULL;
	ValaSymbolResolver* _tmp0_ = NULL;
	ValaSymbolResolver* _tmp1_ = NULL;
	ValaSemanticAnalyzer* _tmp2_ = NULL;
	ValaSemanticAnalyzer* _tmp3_ = NULL;
	ValaFlowAnalyzer* _tmp4_ = NULL;
	ValaFlowAnalyzer* _tmp5_ = NULL;
	ValaUsedAttr* _tmp6_ = NULL;
	ValaUsedAttr* _tmp7_ = NULL;
	self = (ValaCodeContext*) g_type_create_instance (object_type);
	_tmp0_ = vala_symbol_resolver_new ();
	_tmp1_ = _tmp0_;
	vala_code_context_set_resolver (self, _tmp1_);
	_vala_code_visitor_unref0 (_tmp1_);
	_tmp2_ = vala_semantic_analyzer_new ();
	_tmp3_ = _tmp2_;
	vala_code_context_set_analyzer (self, _tmp3_);
	_vala_code_visitor_unref0 (_tmp3_);
	_tmp4_ = vala_flow_analyzer_new ();
	_tmp5_ = _tmp4_;
	vala_code_context_set_flow_analyzer (self, _tmp5_);
	_vala_code_visitor_unref0 (_tmp5_);
	_tmp6_ = vala_used_attr_new ();
	_tmp7_ = _tmp6_;
	vala_code_context_set_used_attr (self, _tmp7_);
	_vala_code_visitor_unref0 (_tmp7_);
	return self;
}


ValaCodeContext* vala_code_context_new (void) {
	return vala_code_context_construct (VALA_TYPE_CODE_CONTEXT);
}


/**
 * Return the topmost context from the context stack.
 */
ValaCodeContext* vala_code_context_get (void) {
	ValaCodeContext* result = NULL;
	ValaList* context_stack = NULL;
	void* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gpointer _tmp3_ = NULL;
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) context_stack);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_list_get (context_stack, _tmp2_ - 1);
	result = (ValaCodeContext*) _tmp3_;
	return result;
}


/**
 * Push the specified context to the context stack.
 */
void vala_code_context_push (ValaCodeContext* context) {
	ValaArrayList* context_stack = NULL;
	void* _tmp0_ = NULL;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp5_ = NULL;
	ValaCodeContext* _tmp6_ = NULL;
	g_return_if_fail (context != NULL);
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp1_ = context_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_ = NULL;
		ValaArrayList* _tmp3_ = NULL;
		ValaArrayList* _tmp4_ = NULL;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_CONTEXT, (GBoxedCopyFunc) vala_code_context_ref, (GDestroyNotify) vala_code_context_unref, _tmp2_);
		context_stack = _tmp3_;
		_tmp4_ = context_stack;
		g_static_private_set (&vala_code_context_context_stack_key, _tmp4_, NULL);
	}
	_tmp5_ = context_stack;
	_tmp6_ = context;
	vala_collection_add ((ValaCollection*) _tmp5_, _tmp6_);
}


/**
 * Remove the topmost context from the context stack.
 */
void vala_code_context_pop (void) {
	ValaList* context_stack = NULL;
	void* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) context_stack);
	_tmp2_ = _tmp1_;
	vala_list_remove_at (context_stack, _tmp2_ - 1);
}


/**
 * Returns a copy of the list of source files.
 *
 * @return list of source files
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_code_context_get_source_files (ValaCodeContext* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->source_files;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of C source files.
 *
 * @return list of C source files
 */
ValaList* vala_code_context_get_c_source_files (ValaCodeContext* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->c_source_files;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified file to the list of source files.
 *
 * @param file a source file
 */
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file) {
	ValaList* _tmp0_ = NULL;
	ValaSourceFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->source_files;
	_tmp1_ = file;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
}


/**
 * Adds the specified file to the list of C source files.
 *
 * @param file a C source file
 */
void vala_code_context_add_c_source_file (ValaCodeContext* self, const gchar* file) {
	ValaList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->c_source_files;
	_tmp1_ = file;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
}


/**
 * Returns a copy of the list of used packages.
 *
 * @return list of used packages
 */
ValaList* vala_code_context_get_packages (ValaCodeContext* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_ = NULL;
	ValaList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->packages;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns whether the specified package is being used.
 *
 * @param pkg a package name
 * @return    true if the specified package is being used
 */
gboolean vala_code_context_has_package (ValaCodeContext* self, const gchar* pkg) {
	gboolean result = FALSE;
	ValaList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = self->priv->packages;
	_tmp1_ = pkg;
	_tmp2_ = vala_collection_contains ((ValaCollection*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * Adds the specified package to the list of used packages.
 *
 * @param pkg a package name
 */
void vala_code_context_add_package (ValaCodeContext* self, const gchar* pkg) {
	ValaList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = self->priv->packages;
	_tmp1_ = pkg;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
}


/**
 * Pull the specified package into the context.
 * The method is tolerant if the package has been already loaded.
 *
 * @param pkg a package name
 * @return false if the package could not be loaded
 *
 */
gboolean vala_code_context_add_external_package (ValaCodeContext* self, const gchar* pkg) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* path = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	ValaSourceFile* _tmp13_ = NULL;
	ValaSourceFile* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gchar* deps_filename = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = pkg;
	_tmp1_ = vala_code_context_has_package (self, _tmp0_);
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = pkg;
	_tmp3_ = vala_code_context_get_vapi_path (self, _tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = pkg;
		_tmp6_ = vala_code_context_get_gir_path (self, _tmp5_);
		_g_free0 (path);
		path = _tmp6_;
	}
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = pkg;
		_tmp9_ = g_strdup_printf ("Package `%s' not found in specified Vala API directories or GObject-In" \
"trospection GIR directories", _tmp8_);
		_tmp10_ = _tmp9_;
		vala_report_error (NULL, _tmp10_);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_free0 (path);
		return result;
	}
	_tmp11_ = pkg;
	vala_code_context_add_package (self, _tmp11_);
	_tmp12_ = path;
	_tmp13_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp12_, NULL, FALSE);
	_tmp14_ = _tmp13_;
	vala_code_context_add_source_file (self, _tmp14_);
	_vala_source_file_unref0 (_tmp14_);
	_tmp15_ = self->priv->_verbose_mode;
	if (_tmp15_) {
		FILE* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = path;
		fprintf (_tmp16_, "Loaded package `%s'\n", _tmp17_);
	}
	_tmp18_ = path;
	_tmp19_ = g_path_get_dirname (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = pkg;
	_tmp22_ = g_strconcat (_tmp21_, ".deps", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_build_path ("/", _tmp20_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	deps_filename = _tmp25_;
	_tmp26_ = deps_filename;
	_tmp27_ = vala_code_context_add_packages_from_file (self, _tmp26_);
	if (!_tmp27_) {
		result = FALSE;
		_g_free0 (deps_filename);
		_g_free0 (path);
		return result;
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_g_free0 (path);
	return result;
}


/**
 * Read the given filename and pull in packages.
 * The method is tolerant if the file does not exist.
 *
 * @param filename a filename
 * @return false if an error occurs while reading the file or if a package could not be added
 */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


gboolean vala_code_context_add_packages_from_file (ValaCodeContext* self, const gchar* filename) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	{
		gchar* contents = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		_tmp2_ = filename;
		g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			_g_free0 (contents);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_tmp5_ = contents;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp7_;
			package_collection_length1 = _vala_array_length (_tmp6_);
			for (package_it = 0; package_it < _vala_array_length (_tmp6_); package_it = package_it + 1) {
				gchar* _tmp8_ = NULL;
				gchar* package = NULL;
				_tmp8_ = g_strdup (package_collection[package_it]);
				package = _tmp8_;
				{
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					_tmp9_ = package;
					_tmp10_ = string_strip (_tmp9_);
					_g_free0 (package);
					package = _tmp10_;
					_tmp11_ = package;
					if (g_strcmp0 (_tmp11_, "") != 0) {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = package;
						vala_code_context_add_external_package (self, _tmp12_);
					}
					_g_free0 (package);
				}
			}
			package_collection = (_vala_array_free (package_collection, package_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (contents);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strdup_printf ("Unable to read dependency file: %s", _tmp14_);
		_tmp16_ = _tmp15_;
		vala_report_error (NULL, _tmp16_);
		_g_free0 (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp17_;
	}
	result = TRUE;
	return result;
}


/**
 * Add the specified source file to the context. Only .vala, .vapi, .gs,
 * and .c extensions are supported.
 *
 * @param filename a filename
 * @param is_source true to force adding the file as .vala or .gs
 * @param cmdline true if the file came from the command line.
 * @return false if the file is not recognized or the file does not exist
 */
gboolean vala_code_context_add_source_filename (ValaCodeContext* self, const gchar* filename, gboolean is_source, gboolean cmdline) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* rpath = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	if (!_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = filename;
		_tmp3_ = g_strdup_printf ("%s not found", _tmp2_);
		_tmp4_ = _tmp3_;
		vala_report_error (NULL, _tmp4_);
		_g_free0 (_tmp4_);
		result = FALSE;
		return result;
	}
	_tmp5_ = filename;
	_tmp6_ = vala_code_context_realpath (_tmp5_);
	rpath = _tmp6_;
	_tmp9_ = is_source;
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = filename;
		_tmp11_ = g_str_has_suffix (_tmp10_, ".vala");
		_tmp8_ = _tmp11_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = filename;
		_tmp13_ = g_str_has_suffix (_tmp12_, ".gs");
		_tmp7_ = _tmp13_;
	}
	if (_tmp7_) {
		ValaSourceFile* source_file = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		ValaSourceFile* _tmp16_ = NULL;
		ValaSourceFile* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		ValaUsingDirective* ns_ref = NULL;
		ValaUnresolvedSymbol* _tmp19_ = NULL;
		ValaUnresolvedSymbol* _tmp20_ = NULL;
		ValaUsingDirective* _tmp21_ = NULL;
		ValaUsingDirective* _tmp22_ = NULL;
		ValaSourceFile* _tmp23_ = NULL;
		ValaUsingDirective* _tmp24_ = NULL;
		ValaNamespace* _tmp25_ = NULL;
		ValaNamespace* _tmp26_ = NULL;
		ValaUsingDirective* _tmp27_ = NULL;
		ValaSourceFile* _tmp28_ = NULL;
		_tmp14_ = rpath;
		_tmp15_ = cmdline;
		_tmp16_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp14_, NULL, _tmp15_);
		source_file = _tmp16_;
		_tmp17_ = source_file;
		_tmp18_ = filename;
		vala_source_file_set_relative_filename (_tmp17_, _tmp18_);
		_tmp19_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_using_directive_new ((ValaSymbol*) _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_vala_code_node_unref0 (_tmp20_);
		ns_ref = _tmp22_;
		_tmp23_ = source_file;
		_tmp24_ = ns_ref;
		vala_source_file_add_using_directive (_tmp23_, _tmp24_);
		_tmp25_ = vala_code_context_get_root (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = ns_ref;
		vala_namespace_add_using_directive (_tmp26_, _tmp27_);
		_tmp28_ = source_file;
		vala_code_context_add_source_file (self, _tmp28_);
		_vala_code_node_unref0 (ns_ref);
		_vala_source_file_unref0 (source_file);
	} else {
		gboolean _tmp29_ = FALSE;
		const gchar* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		_tmp30_ = filename;
		_tmp31_ = g_str_has_suffix (_tmp30_, ".vapi");
		if (_tmp31_) {
			_tmp29_ = TRUE;
		} else {
			const gchar* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			_tmp32_ = filename;
			_tmp33_ = g_str_has_suffix (_tmp32_, ".gir");
			_tmp29_ = _tmp33_;
		}
		if (_tmp29_) {
			ValaSourceFile* source_file = NULL;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			ValaSourceFile* _tmp36_ = NULL;
			ValaSourceFile* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			ValaSourceFile* _tmp39_ = NULL;
			_tmp34_ = rpath;
			_tmp35_ = cmdline;
			_tmp36_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp34_, NULL, _tmp35_);
			source_file = _tmp36_;
			_tmp37_ = source_file;
			_tmp38_ = filename;
			vala_source_file_set_relative_filename (_tmp37_, _tmp38_);
			_tmp39_ = source_file;
			vala_code_context_add_source_file (self, _tmp39_);
			_vala_source_file_unref0 (source_file);
		} else {
			const gchar* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			_tmp40_ = filename;
			_tmp41_ = g_str_has_suffix (_tmp40_, ".c");
			if (_tmp41_) {
				const gchar* _tmp42_ = NULL;
				_tmp42_ = rpath;
				vala_code_context_add_c_source_file (self, _tmp42_);
			} else {
				const gchar* _tmp43_ = NULL;
				gboolean _tmp44_ = FALSE;
				_tmp43_ = filename;
				_tmp44_ = g_str_has_suffix (_tmp43_, ".h");
				if (_tmp44_) {
				} else {
					const gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					_tmp45_ = filename;
					_tmp46_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c" \
" files are supported.", _tmp45_);
					_tmp47_ = _tmp46_;
					vala_report_error (NULL, _tmp47_);
					_g_free0 (_tmp47_);
					result = FALSE;
					_g_free0 (rpath);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (rpath);
	return result;
}


/**
 * Visits the complete code tree file by file.
 * It is possible to add new source files while visiting the tree.
 *
 * @param visitor the visitor to be called when traversing
 */
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor) {
	ValaNamespace* _tmp0_ = NULL;
	ValaNamespace* _tmp1_ = NULL;
	ValaCodeVisitor* _tmp2_ = NULL;
	gint index = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_code_context_get_root (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	index = 0;
	while (TRUE) {
		gint _tmp3_ = 0;
		ValaList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		ValaSourceFile* source_file = NULL;
		ValaList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gpointer _tmp9_ = NULL;
		ValaSourceFile* _tmp10_ = NULL;
		ValaCodeVisitor* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp3_ = index;
		_tmp4_ = self->priv->source_files;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (!(_tmp3_ < _tmp6_)) {
			break;
		}
		_tmp7_ = self->priv->source_files;
		_tmp8_ = index;
		_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
		source_file = (ValaSourceFile*) _tmp9_;
		_tmp10_ = source_file;
		_tmp11_ = visitor;
		vala_source_file_accept (_tmp10_, _tmp11_);
		_tmp12_ = index;
		index = _tmp12_ + 1;
		_vala_source_file_unref0 (source_file);
	}
}


/**
 * Resolve and analyze.
 */
void vala_code_context_check (ValaCodeContext* self) {
	ValaSymbolResolver* _tmp0_ = NULL;
	ValaReport* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ValaSemanticAnalyzer* _tmp3_ = NULL;
	ValaReport* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	ValaFlowAnalyzer* _tmp6_ = NULL;
	ValaReport* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	ValaUsedAttr* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_resolver;
	vala_symbol_resolver_resolve (_tmp0_, self);
	_tmp1_ = self->priv->_report;
	_tmp2_ = vala_report_get_errors (_tmp1_);
	if (_tmp2_ > 0) {
		return;
	}
	_tmp3_ = self->priv->_analyzer;
	vala_semantic_analyzer_analyze (_tmp3_, self);
	_tmp4_ = self->priv->_report;
	_tmp5_ = vala_report_get_errors (_tmp4_);
	if (_tmp5_ > 0) {
		return;
	}
	_tmp6_ = self->priv->_flow_analyzer;
	vala_flow_analyzer_analyze (_tmp6_, self);
	_tmp7_ = self->priv->_report;
	_tmp8_ = vala_report_get_errors (_tmp7_);
	if (_tmp8_ > 0) {
		return;
	}
	_tmp9_ = self->priv->_used_attr;
	vala_used_attr_check_unused (_tmp9_, self);
}


void vala_code_context_add_define (ValaCodeContext* self, const gchar* define) {
	ValaSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (define != NULL);
	_tmp0_ = self->priv->defines;
	_tmp1_ = define;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
}


gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define) {
	gboolean result = FALSE;
	ValaSet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (define != NULL, FALSE);
	_tmp0_ = self->priv->defines;
	_tmp1_ = define;
	_tmp2_ = vala_collection_contains ((ValaCollection*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gchar* vala_code_context_get_vapi_path (ValaCodeContext* self, const gchar* pkg) {
	gchar* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	_tmp0_ = pkg;
	_tmp1_ = g_strconcat (_tmp0_, ".vapi", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->vapi_directories;
	_tmp3__length1 = self->vapi_directories_length1;
	_tmp4_ = vala_code_context_get_file_path (self, _tmp2_, "vala" PACKAGE_SUFFIX "/vapi", "vala/vapi", _tmp3_, _tmp3__length1);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	path = _tmp5_;
	_tmp6_ = path;
	if (_tmp6_ == NULL) {
		gchar* filename = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp7_ = pkg;
		_tmp8_ = g_strconcat (_tmp7_, ".vapi", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_build_path ("/", PACKAGE_DATADIR, "vapi", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		filename = _tmp11_;
		_tmp12_ = filename;
		_tmp13_ = g_file_test (_tmp12_, G_FILE_TEST_EXISTS);
		if (_tmp13_) {
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp14_ = filename;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (path);
			path = _tmp15_;
		}
		_g_free0 (filename);
	}
	result = path;
	return result;
}


gchar* vala_code_context_get_gir_path (ValaCodeContext* self, const gchar* gir) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir != NULL, NULL);
	_tmp0_ = gir;
	_tmp1_ = g_strconcat (_tmp0_, ".gir", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->gir_directories;
	_tmp3__length1 = self->gir_directories_length1;
	_tmp4_ = vala_code_context_get_file_path (self, _tmp2_, "gir-1.0", NULL, _tmp3_, _tmp3__length1);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


gchar* vala_code_context_get_gresource_path (ValaCodeContext* self, const gchar* gresource, const gchar* resource) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gresource != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = resource;
	_tmp1_ = gresource;
	_tmp2_ = g_path_get_dirname (_tmp1_);
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = vala_code_context_get_file_path (self, _tmp0_, NULL, NULL, _tmp4_, 1);
	_tmp6_ = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	filename = _tmp6_;
	_tmp7_ = filename;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gchar* _tmp10_ = NULL;
		_tmp8_ = resource;
		_tmp9_ = self->gresources_directories;
		_tmp9__length1 = self->gresources_directories_length1;
		_tmp10_ = vala_code_context_get_file_path (self, _tmp8_, NULL, NULL, _tmp9_, _tmp9__length1);
		_g_free0 (filename);
		filename = _tmp10_;
	}
	result = filename;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* vala_code_context_get_metadata_path (ValaCodeContext* self, const gchar* gir_filename) {
	gchar* result = NULL;
	gchar* basename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* metadata_basename = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* metadata_filename = NULL;
	const gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_filename != NULL, NULL);
	_tmp0_ = gir_filename;
	_tmp1_ = g_path_get_basename (_tmp0_);
	basename = _tmp1_;
	_tmp2_ = basename;
	_tmp3_ = basename;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (".gir");
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp5_ - _tmp7_));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s.metadata", _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	metadata_basename = _tmp11_;
	_tmp12_ = metadata_basename;
	_tmp13_ = self->metadata_directories;
	_tmp13__length1 = self->metadata_directories_length1;
	_tmp14_ = vala_code_context_get_file_path (self, _tmp12_, NULL, NULL, _tmp13_, _tmp13__length1);
	metadata_filename = _tmp14_;
	_tmp15_ = metadata_filename;
	if (_tmp15_ != NULL) {
		result = metadata_filename;
		_g_free0 (metadata_basename);
		_g_free0 (basename);
		return result;
	}
	_tmp16_ = gir_filename;
	_tmp17_ = g_path_get_dirname (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = metadata_basename;
	_tmp20_ = g_build_path ("/", _tmp18_, _tmp19_, NULL);
	_g_free0 (metadata_filename);
	metadata_filename = _tmp20_;
	_g_free0 (_tmp18_);
	_tmp21_ = metadata_filename;
	_tmp22_ = g_file_test (_tmp21_, G_FILE_TEST_EXISTS);
	if (_tmp22_) {
		result = metadata_filename;
		_g_free0 (metadata_basename);
		_g_free0 (basename);
		return result;
	}
	result = NULL;
	_g_free0 (metadata_filename);
	_g_free0 (metadata_basename);
	_g_free0 (basename);
	return result;
}


static gchar* vala_code_context_get_file_path (ValaCodeContext* self, const gchar* basename, const gchar* versioned_data_dir, const gchar* data_dir, gchar** directories, int directories_length1) {
	gchar* result = NULL;
	gchar* filename = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	filename = NULL;
	_tmp0_ = directories;
	_tmp0__length1 = directories_length1;
	if (_tmp0_ != NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp1_ = directories;
		_tmp1__length1 = directories_length1;
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp1_;
			dir_collection_length1 = _tmp1__length1;
			for (dir_it = 0; dir_it < _tmp1__length1; dir_it = dir_it + 1) {
				gchar* _tmp2_ = NULL;
				gchar* dir = NULL;
				_tmp2_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp2_;
				{
					const gchar* _tmp3_ = NULL;
					const gchar* _tmp4_ = NULL;
					gchar* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					gboolean _tmp7_ = FALSE;
					_tmp3_ = dir;
					_tmp4_ = basename;
					_tmp5_ = g_build_path ("/", _tmp3_, _tmp4_, NULL);
					_g_free0 (filename);
					filename = _tmp5_;
					_tmp6_ = filename;
					_tmp7_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
					if (_tmp7_) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	_tmp8_ = data_dir;
	if (_tmp8_ != NULL) {
		gchar** _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		_tmp10_ = _tmp9_ = g_get_system_data_dirs ();
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp10_;
			dir_collection_length1 = _vala_array_length (_tmp9_);
			for (dir_it = 0; dir_it < _vala_array_length (_tmp9_); dir_it = dir_it + 1) {
				gchar* _tmp11_ = NULL;
				gchar* dir = NULL;
				_tmp11_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp11_;
				{
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					_tmp12_ = dir;
					_tmp13_ = data_dir;
					_tmp14_ = basename;
					_tmp15_ = g_build_path ("/", _tmp12_, _tmp13_, _tmp14_, NULL);
					_g_free0 (filename);
					filename = _tmp15_;
					_tmp16_ = filename;
					_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_EXISTS);
					if (_tmp17_) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	_tmp18_ = versioned_data_dir;
	if (_tmp18_ != NULL) {
		gchar** _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		_tmp20_ = _tmp19_ = g_get_system_data_dirs ();
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp20_;
			dir_collection_length1 = _vala_array_length (_tmp19_);
			for (dir_it = 0; dir_it < _vala_array_length (_tmp19_); dir_it = dir_it + 1) {
				gchar* _tmp21_ = NULL;
				gchar* dir = NULL;
				_tmp21_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp21_;
				{
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					_tmp22_ = dir;
					_tmp23_ = versioned_data_dir;
					_tmp24_ = basename;
					_tmp25_ = g_build_path ("/", _tmp22_, _tmp23_, _tmp24_, NULL);
					_g_free0 (filename);
					filename = _tmp25_;
					_tmp26_ = filename;
					_tmp27_ = g_file_test (_tmp26_, G_FILE_TEST_EXISTS);
					if (_tmp27_) {
						result = filename;
						_g_free0 (dir);
						return result;
					}
					_g_free0 (dir);
				}
			}
		}
	}
	result = NULL;
	_g_free0 (filename);
	return result;
}


void vala_code_context_write_dependencies (ValaCodeContext* self, const gchar* filename) {
	FILE* stream = NULL;
	const gchar* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	FILE* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	FILE* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	_tmp1_ = g_fopen (_tmp0_, "w");
	stream = _tmp1_;
	_tmp2_ = stream;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = filename;
		_tmp4_ = g_strdup_printf ("unable to open `%s' for writing", _tmp3_);
		_tmp5_ = _tmp4_;
		vala_report_error (NULL, _tmp5_);
		_g_free0 (_tmp5_);
		_fclose0 (stream);
		return;
	}
	_tmp6_ = stream;
	_tmp7_ = filename;
	fprintf (_tmp6_, "%s:", _tmp7_);
	{
		ValaList* _src_list = NULL;
		ValaList* _tmp8_ = NULL;
		ValaList* _tmp9_ = NULL;
		gint _src_size = 0;
		ValaList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _src_index = 0;
		_tmp8_ = self->priv->source_files;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_src_list = _tmp9_;
		_tmp10_ = _src_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_src_size = _tmp12_;
		_src_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			ValaSourceFile* src = NULL;
			ValaList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			ValaSourceFile* _tmp20_ = NULL;
			ValaSourceFileType _tmp21_ = 0;
			ValaSourceFileType _tmp22_ = 0;
			_tmp13_ = _src_index;
			_src_index = _tmp13_ + 1;
			_tmp14_ = _src_index;
			_tmp15_ = _src_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _src_list;
			_tmp17_ = _src_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			src = (ValaSourceFile*) _tmp18_;
			_tmp20_ = src;
			_tmp21_ = vala_source_file_get_file_type (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ == VALA_SOURCE_FILE_TYPE_FAST) {
				ValaSourceFile* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				_tmp23_ = src;
				_tmp24_ = vala_source_file_get_used (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp19_ = _tmp25_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				FILE* _tmp26_ = NULL;
				ValaSourceFile* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				_tmp26_ = stream;
				_tmp27_ = src;
				_tmp28_ = vala_source_file_get_filename (_tmp27_);
				_tmp29_ = _tmp28_;
				fprintf (_tmp26_, " %s", _tmp29_);
			}
			_vala_source_file_unref0 (src);
		}
		_vala_iterable_unref0 (_src_list);
	}
	_tmp30_ = stream;
	fprintf (_tmp30_, "\n\n");
	_fclose0 (stream);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean vala_code_context_ends_with_dir_separator (const gchar* s) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gunichar _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = s;
	_tmp1_ = s;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get_char (_tmp0_, (glong) (_tmp3_ - 1));
	_tmp5_ = G_IS_DIR_SEPARATOR (_tmp4_);
	result = _tmp5_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp2_ = str_array;
	_tmp2__length1 = str_array_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		if (_tmp4__length1 > 0) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			_tmp6_ = str_array;
			_tmp6__length1 = str_array_length1;
			if (_tmp6__length1 == -1) {
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				const gchar* _tmp8_ = NULL;
				_tmp7_ = str_array;
				_tmp7__length1 = str_array_length1;
				_tmp8_ = _tmp7_[0];
				_tmp5_ = _tmp8_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* vala_code_context_realpath (const gchar* name) {
	gchar* result = NULL;
	gchar* rpath = NULL;
	const gchar* start = NULL;
	const gchar* end = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	glong root_len = 0L;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_ = NULL;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	glong _tmp71_ = 0L;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (!_tmp1_) {
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = g_get_current_dir ();
		_g_free0 (rpath);
		rpath = _tmp2_;
		_tmp3_ = name;
		end = _tmp3_;
		_tmp4_ = end;
		start = _tmp4_;
	} else {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp5_ = name;
		_tmp6_ = g_path_skip_root (_tmp5_);
		end = _tmp6_;
		_tmp7_ = end;
		start = _tmp7_;
		_tmp8_ = name;
		_tmp9_ = start;
		_tmp10_ = name;
		_tmp11_ = string_substring (_tmp8_, (glong) 0, (glong) ((gint) (((gchar*) _tmp9_) - ((gchar*) _tmp10_))));
		_g_free0 (rpath);
		rpath = _tmp11_;
	}
	_tmp12_ = rpath;
	_tmp13_ = g_path_skip_root (_tmp12_);
	_tmp14_ = rpath;
	root_len = (glong) (((gchar*) _tmp13_) - ((gchar*) _tmp14_));
	{
		gboolean _tmp15_ = FALSE;
		_tmp15_ = TRUE;
		while (TRUE) {
			const gchar* _tmp17_ = NULL;
			gunichar _tmp18_ = 0U;
			glong len = 0L;
			glong _tmp35_ = 0L;
			if (!_tmp15_) {
				const gchar* _tmp16_ = NULL;
				_tmp16_ = end;
				start = _tmp16_;
			}
			_tmp15_ = FALSE;
			_tmp17_ = start;
			_tmp18_ = string_get_char (_tmp17_, (glong) 0);
			if (!(_tmp18_ != ((gunichar) 0))) {
				break;
			}
			while (TRUE) {
				const gchar* _tmp19_ = NULL;
				gunichar _tmp20_ = 0U;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				_tmp19_ = start;
				_tmp20_ = string_get_char (_tmp19_, (glong) 0);
				_tmp21_ = G_IS_DIR_SEPARATOR (_tmp20_);
				if (!_tmp21_) {
					break;
				}
				_tmp22_ = start;
				_tmp23_ = g_utf8_next_char (_tmp22_);
				start = _tmp23_;
			}
			len = (glong) 0;
			{
				const gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				_tmp24_ = start;
				end = _tmp24_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp28_ = FALSE;
					const gchar* _tmp29_ = NULL;
					gunichar _tmp30_ = 0U;
					glong _tmp34_ = 0L;
					if (!_tmp25_) {
						const gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						_tmp26_ = end;
						_tmp27_ = g_utf8_next_char (_tmp26_);
						end = _tmp27_;
					}
					_tmp25_ = FALSE;
					_tmp29_ = end;
					_tmp30_ = string_get_char (_tmp29_, (glong) 0);
					if (_tmp30_ != ((gunichar) 0)) {
						const gchar* _tmp31_ = NULL;
						gunichar _tmp32_ = 0U;
						gboolean _tmp33_ = FALSE;
						_tmp31_ = end;
						_tmp32_ = string_get_char (_tmp31_, (glong) 0);
						_tmp33_ = G_IS_DIR_SEPARATOR (_tmp32_);
						_tmp28_ = !_tmp33_;
					} else {
						_tmp28_ = FALSE;
					}
					if (!_tmp28_) {
						break;
					}
					_tmp34_ = len;
					len = _tmp34_ + 1;
				}
			}
			_tmp35_ = len;
			if (_tmp35_ == ((glong) 0)) {
				break;
			} else {
				gboolean _tmp36_ = FALSE;
				glong _tmp37_ = 0L;
				_tmp37_ = len;
				if (_tmp37_ == ((glong) 1)) {
					const gchar* _tmp38_ = NULL;
					gunichar _tmp39_ = 0U;
					_tmp38_ = start;
					_tmp39_ = string_get_char (_tmp38_, (glong) 0);
					_tmp36_ = _tmp39_ == ((gunichar) '.');
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
				} else {
					gboolean _tmp40_ = FALSE;
					glong _tmp41_ = 0L;
					_tmp41_ = len;
					if (_tmp41_ == ((glong) 2)) {
						const gchar* _tmp42_ = NULL;
						gboolean _tmp43_ = FALSE;
						_tmp42_ = start;
						_tmp43_ = g_str_has_prefix (_tmp42_, "..");
						_tmp40_ = _tmp43_;
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						const gchar* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						glong _tmp47_ = 0L;
						_tmp44_ = rpath;
						_tmp45_ = strlen (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = root_len;
						if (((glong) _tmp46_) > _tmp47_) {
							{
								gboolean _tmp48_ = FALSE;
								_tmp48_ = TRUE;
								while (TRUE) {
									const gchar* _tmp51_ = NULL;
									const gchar* _tmp52_ = NULL;
									gint _tmp53_ = 0;
									gint _tmp54_ = 0;
									gchar* _tmp55_ = NULL;
									if (!_tmp48_) {
										const gchar* _tmp49_ = NULL;
										gboolean _tmp50_ = FALSE;
										_tmp49_ = rpath;
										_tmp50_ = vala_code_context_ends_with_dir_separator (_tmp49_);
										if (!(!_tmp50_)) {
											break;
										}
									}
									_tmp48_ = FALSE;
									_tmp51_ = rpath;
									_tmp52_ = rpath;
									_tmp53_ = strlen (_tmp52_);
									_tmp54_ = _tmp53_;
									_tmp55_ = string_substring (_tmp51_, (glong) 0, (glong) (_tmp54_ - 1));
									_g_free0 (rpath);
									rpath = _tmp55_;
								}
							}
						}
					} else {
						const gchar* _tmp56_ = NULL;
						gboolean _tmp57_ = FALSE;
						const gchar* _tmp60_ = NULL;
						const gchar* _tmp61_ = NULL;
						const gchar* _tmp62_ = NULL;
						const gchar* _tmp63_ = NULL;
						gchar* _tmp64_ = NULL;
						gchar* _tmp65_ = NULL;
						gchar* _tmp66_ = NULL;
						_tmp56_ = rpath;
						_tmp57_ = vala_code_context_ends_with_dir_separator (_tmp56_);
						if (!_tmp57_) {
							const gchar* _tmp58_ = NULL;
							gchar* _tmp59_ = NULL;
							_tmp58_ = rpath;
							_tmp59_ = g_strconcat (_tmp58_, G_DIR_SEPARATOR_S, NULL);
							_g_free0 (rpath);
							rpath = _tmp59_;
						}
						_tmp60_ = rpath;
						_tmp61_ = start;
						_tmp62_ = end;
						_tmp63_ = start;
						_tmp64_ = string_substring (_tmp61_, (glong) 0, (glong) (((gchar*) _tmp62_) - ((gchar*) _tmp63_)));
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strconcat (_tmp60_, _tmp65_, NULL);
						_g_free0 (rpath);
						rpath = _tmp66_;
						_g_free0 (_tmp65_);
					}
				}
			}
		}
	}
	_tmp68_ = rpath;
	_tmp69_ = strlen (_tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = root_len;
	if (((glong) _tmp70_) > _tmp71_) {
		const gchar* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		_tmp72_ = rpath;
		_tmp73_ = vala_code_context_ends_with_dir_separator (_tmp72_);
		_tmp67_ = _tmp73_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		const gchar* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		gint _tmp76_ = 0;
		gint _tmp77_ = 0;
		gchar* _tmp78_ = NULL;
		_tmp74_ = rpath;
		_tmp75_ = rpath;
		_tmp76_ = strlen (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = string_substring (_tmp74_, (glong) 0, (glong) (_tmp77_ - 1));
		_g_free0 (rpath);
		rpath = _tmp78_;
	}
	if (G_DIR_SEPARATOR != '/') {
		gchar** components = NULL;
		const gchar* _tmp79_ = NULL;
		gchar** _tmp80_ = NULL;
		gchar** _tmp81_ = NULL;
		gint components_length1 = 0;
		gint _components_size_ = 0;
		gchar** _tmp82_ = NULL;
		gint _tmp82__length1 = 0;
		gchar* _tmp83_ = NULL;
		_tmp79_ = rpath;
		_tmp81_ = _tmp80_ = g_strsplit (_tmp79_, "\\", 0);
		components = _tmp81_;
		components_length1 = _vala_array_length (_tmp80_);
		_components_size_ = components_length1;
		_tmp82_ = components;
		_tmp82__length1 = components_length1;
		_tmp83_ = _vala_g_strjoinv ("/", _tmp82_, _tmp82__length1);
		_g_free0 (rpath);
		rpath = _tmp83_;
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


gboolean vala_code_context_pkg_config_exists (ValaCodeContext* self, const gchar* package_name) {
	gboolean result = FALSE;
	gchar* pc = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint exit_status = 0;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (package_name != NULL, FALSE);
	_tmp0_ = self->priv->_pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --exists ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = package_name;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	pc = _tmp5_;
	{
		gint _tmp6_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp6_, &_inner_error_);
		exit_status = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp7_;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		vala_report_error (NULL, _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally1:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp10_;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


gchar* vala_code_context_pkg_config_modversion (ValaCodeContext* self, const gchar* package_name) {
	gchar* result = NULL;
	gchar* pc = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* output = NULL;
	gint exit_status = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (package_name != NULL, NULL);
	_tmp0_ = self->priv->_pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --silence-errors --modversion ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = package_name;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	pc = _tmp5_;
	output = NULL;
	{
		gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		g_spawn_command_line_sync (pc, &_tmp6_, NULL, &_tmp7_, &_inner_error_);
		_g_free0 (output);
		output = _tmp6_;
		exit_status = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch2_g_spawn_error;
			}
			_g_free0 (output);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (exit_status != 0) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp8_ = output;
			_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) -1);
			_g_free0 (output);
			output = _tmp9_;
			_tmp10_ = output;
			if (g_strcmp0 (_tmp10_, "") == 0) {
				_g_free0 (output);
				output = NULL;
			}
		}
	}
	goto __finally2;
	__catch2_g_spawn_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_free0 (output);
		output = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (output);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = output;
	_g_free0 (pc);
	return result;
}


gchar* vala_code_context_pkg_config_compile_flags (ValaCodeContext* self, const gchar* package_name) {
	gchar* result = NULL;
	gchar* pc = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* output = NULL;
	gint exit_status = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (package_name != NULL, NULL);
	_tmp0_ = self->priv->_pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --cflags", NULL);
	pc = _tmp1_;
	_tmp2_ = self->priv->_compile_only;
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = pc;
		_tmp4_ = g_strconcat (_tmp3_, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
	}
	_tmp5_ = pc;
	_tmp6_ = package_name;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_g_free0 (pc);
	pc = _tmp7_;
	output = NULL;
	{
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp8_ = pc;
		g_spawn_command_line_sync (_tmp8_, &_tmp9_, NULL, &_tmp10_, &_inner_error_);
		_g_free0 (output);
		output = _tmp9_;
		exit_status = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_g_free0 (output);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = exit_status;
		if (_tmp11_ != 0) {
			const gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp12_ = self->priv->_pkg_config_command;
			_tmp13_ = exit_status;
			_tmp14_ = g_strdup_printf ("%s exited with status %d", _tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (NULL, _tmp15_);
			_g_free0 (_tmp15_);
			result = NULL;
			_g_free0 (output);
			_g_free0 (pc);
			return result;
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		vala_report_error (NULL, _tmp17_);
		_g_free0 (output);
		output = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (output);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = output;
	_g_free0 (pc);
	return result;
}


gboolean vala_code_context_get_assert (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_assert;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_assert (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_assert = _tmp0_;
}


gboolean vala_code_context_get_checking (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_checking;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_checking (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_checking = _tmp0_;
}


gboolean vala_code_context_get_deprecated (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_deprecated;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_deprecated (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_deprecated = _tmp0_;
}


gboolean vala_code_context_get_hide_internal (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hide_internal;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_hide_internal (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hide_internal = _tmp0_;
}


gboolean vala_code_context_get_since_check (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_since_check;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_since_check (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_since_check = _tmp0_;
}


gboolean vala_code_context_get_experimental (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_experimental;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_experimental (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_experimental = _tmp0_;
}


gboolean vala_code_context_get_experimental_non_null (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_experimental_non_null;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_experimental_non_null (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_experimental_non_null = _tmp0_;
}


gboolean vala_code_context_get_gobject_tracing (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_gobject_tracing;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_gobject_tracing (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_gobject_tracing = _tmp0_;
}


gboolean vala_code_context_get_ccode_only (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ccode_only;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ccode_only = _tmp0_;
}


const gchar* vala_code_context_get_pkg_config_command (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pkg_config_command;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_pkg_config_command (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_pkg_config_command);
	self->priv->_pkg_config_command = _tmp1_;
}


const gchar* vala_code_context_get_header_filename (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_filename;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_header_filename (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_header_filename);
	self->priv->_header_filename = _tmp1_;
}


const gchar* vala_code_context_get_internal_header_filename (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_internal_header_filename;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_internal_header_filename (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_internal_header_filename);
	self->priv->_internal_header_filename = _tmp1_;
}


gboolean vala_code_context_get_use_header (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_use_header;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_use_header (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_use_header = _tmp0_;
}


const gchar* vala_code_context_get_includedir (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_includedir;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_includedir (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_includedir);
	self->priv->_includedir = _tmp1_;
}


const gchar* vala_code_context_get_symbols_filename (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbols_filename;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_symbols_filename (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_symbols_filename);
	self->priv->_symbols_filename = _tmp1_;
}


gboolean vala_code_context_get_compile_only (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_compile_only;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_compile_only = _tmp0_;
}


const gchar* vala_code_context_get_output (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_output;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_output (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_output);
	self->priv->_output = _tmp1_;
}


const gchar* vala_code_context_get_basedir (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basedir;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_basedir (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_basedir);
	self->priv->_basedir = _tmp1_;
}


const gchar* vala_code_context_get_directory (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_directory (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_directory);
	self->priv->_directory = _tmp1_;
}


gboolean vala_code_context_get_debug (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_debug;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_debug (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_debug = _tmp0_;
}


gint vala_code_context_get_optlevel (ValaCodeContext* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_optlevel;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_optlevel (ValaCodeContext* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_optlevel = _tmp0_;
}


gboolean vala_code_context_get_thread (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_thread;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_thread (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_thread = _tmp0_;
}


gboolean vala_code_context_get_mem_profiler (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_mem_profiler;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_mem_profiler (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_mem_profiler = _tmp0_;
}


ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_module_init_method;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_ = NULL;
	ValaMethod* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	self->priv->_module_init_method = _tmp1_;
}


gboolean vala_code_context_get_save_temps (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_save_temps;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_save_temps = _tmp0_;
}


ValaProfile vala_code_context_get_profile (ValaCodeContext* self) {
	ValaProfile result;
	ValaProfile _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_profile;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_profile (ValaCodeContext* self, ValaProfile value) {
	ValaProfile _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_profile = _tmp0_;
}


gint vala_code_context_get_target_glib_major (ValaCodeContext* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_target_glib_major;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_target_glib_major (ValaCodeContext* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_target_glib_major = _tmp0_;
}


gint vala_code_context_get_target_glib_minor (ValaCodeContext* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_target_glib_minor;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_target_glib_minor (ValaCodeContext* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_target_glib_minor = _tmp0_;
}


gboolean vala_code_context_get_verbose_mode (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_verbose_mode;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_verbose_mode (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_verbose_mode = _tmp0_;
}


gboolean vala_code_context_get_version_header (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_version_header;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_version_header (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_version_header = _tmp0_;
}


gboolean vala_code_context_get_nostdpkg (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_nostdpkg;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_nostdpkg (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_nostdpkg = _tmp0_;
}


gboolean vala_code_context_get_use_fast_vapi (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_use_fast_vapi;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_use_fast_vapi (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_use_fast_vapi = _tmp0_;
}


gboolean vala_code_context_get_vapi_comments (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_vapi_comments;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_vapi_comments (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_vapi_comments = _tmp0_;
}


gboolean vala_code_context_get_save_csources (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_save_temps;
	result = _tmp0_;
	return result;
}


ValaReport* vala_code_context_get_report (ValaCodeContext* self) {
	ValaReport* result;
	ValaReport* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_report;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void vala_code_context_set_report (ValaCodeContext* self, ValaReport* value) {
	ValaReport* _tmp0_ = NULL;
	ValaReport* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_report);
	self->priv->_report = _tmp1_;
}


ValaMethod* vala_code_context_get_entry_point (ValaCodeContext* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_point;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_entry_point (ValaCodeContext* self, ValaMethod* value) {
	ValaMethod* _tmp0_ = NULL;
	ValaMethod* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_entry_point);
	self->priv->_entry_point = _tmp1_;
}


const gchar* vala_code_context_get_entry_point_name (ValaCodeContext* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_point_name;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_entry_point_name (ValaCodeContext* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_entry_point_name);
	self->priv->_entry_point_name = _tmp1_;
}


gboolean vala_code_context_get_run_output (ValaCodeContext* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_run_output;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_run_output (ValaCodeContext* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_run_output = _tmp0_;
}


ValaNamespace* vala_code_context_get_root (ValaCodeContext* self) {
	ValaNamespace* result;
	ValaNamespace* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root;
	result = _tmp0_;
	return result;
}


ValaSymbolResolver* vala_code_context_get_resolver (ValaCodeContext* self) {
	ValaSymbolResolver* result;
	ValaSymbolResolver* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_resolver;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_visitor_ref0 (gpointer self) {
	return self ? vala_code_visitor_ref (self) : NULL;
}


static void vala_code_context_set_resolver (ValaCodeContext* self, ValaSymbolResolver* value) {
	ValaSymbolResolver* _tmp0_ = NULL;
	ValaSymbolResolver* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_visitor_ref0 (_tmp0_);
	_vala_code_visitor_unref0 (self->priv->_resolver);
	self->priv->_resolver = _tmp1_;
}


ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self) {
	ValaSemanticAnalyzer* result;
	ValaSemanticAnalyzer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_analyzer;
	result = _tmp0_;
	return result;
}


static void vala_code_context_set_analyzer (ValaCodeContext* self, ValaSemanticAnalyzer* value) {
	ValaSemanticAnalyzer* _tmp0_ = NULL;
	ValaSemanticAnalyzer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_visitor_ref0 (_tmp0_);
	_vala_code_visitor_unref0 (self->priv->_analyzer);
	self->priv->_analyzer = _tmp1_;
}


ValaFlowAnalyzer* vala_code_context_get_flow_analyzer (ValaCodeContext* self) {
	ValaFlowAnalyzer* result;
	ValaFlowAnalyzer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_flow_analyzer;
	result = _tmp0_;
	return result;
}


static void vala_code_context_set_flow_analyzer (ValaCodeContext* self, ValaFlowAnalyzer* value) {
	ValaFlowAnalyzer* _tmp0_ = NULL;
	ValaFlowAnalyzer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_visitor_ref0 (_tmp0_);
	_vala_code_visitor_unref0 (self->priv->_flow_analyzer);
	self->priv->_flow_analyzer = _tmp1_;
}


ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self) {
	ValaCodeGenerator* result;
	ValaCodeGenerator* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_codegen;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value) {
	ValaCodeGenerator* _tmp0_ = NULL;
	ValaCodeGenerator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_visitor_ref0 (_tmp0_);
	_vala_code_visitor_unref0 (self->priv->_codegen);
	self->priv->_codegen = _tmp1_;
}


ValaUsedAttr* vala_code_context_get_used_attr (ValaCodeContext* self) {
	ValaUsedAttr* result;
	ValaUsedAttr* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_used_attr;
	result = _tmp0_;
	return result;
}


void vala_code_context_set_used_attr (ValaCodeContext* self, ValaUsedAttr* value) {
	ValaUsedAttr* _tmp0_ = NULL;
	ValaUsedAttr* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_visitor_ref0 (_tmp0_);
	_vala_code_visitor_unref0 (self->priv->_used_attr);
	self->priv->_used_attr = _tmp1_;
}


static void vala_value_code_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_context_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


void vala_value_take_code_context (GValue* value, gpointer v_object) {
	ValaCodeContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}


static void vala_code_context_class_init (ValaCodeContextClass * klass) {
	vala_code_context_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeContextClass *) klass)->finalize = vala_code_context_finalize;
	g_type_class_add_private (klass, sizeof (ValaCodeContextPrivate));
	g_static_private_init (&vala_code_context_context_stack_key);
	vala_code_context_context_stack_key = vala_code_context_context_stack_key;
}


static void vala_code_context_instance_init (ValaCodeContext * self) {
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	ValaReport* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	ValaArrayList* _tmp8_ = NULL;
	GEqualFunc _tmp9_ = NULL;
	ValaArrayList* _tmp10_ = NULL;
	ValaNamespace* _tmp11_ = NULL;
	GEqualFunc _tmp12_ = NULL;
	ValaArrayList* _tmp13_ = NULL;
	GHashFunc _tmp14_ = NULL;
	GEqualFunc _tmp15_ = NULL;
	ValaHashSet* _tmp16_ = NULL;
	self->priv = VALA_CODE_CONTEXT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("pkg-config");
	self->priv->_pkg_config_command = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->vapi_directories = _tmp1_;
	self->vapi_directories_length1 = 0;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->gir_directories = _tmp2_;
	self->gir_directories_length1 = 0;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->metadata_directories = _tmp3_;
	self->metadata_directories_length1 = 0;
	_tmp4_ = vala_report_new ();
	self->priv->_report = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	self->gresources = _tmp5_;
	self->gresources_length1 = 0;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	self->gresources_directories = _tmp6_;
	self->gresources_directories_length1 = 0;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, (GDestroyNotify) vala_source_file_unref, _tmp7_);
	self->priv->source_files = (ValaList*) _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp9_);
	self->priv->c_source_files = (ValaList*) _tmp10_;
	_tmp11_ = vala_namespace_new (NULL, NULL);
	self->priv->_root = _tmp11_;
	_tmp12_ = g_str_equal;
	_tmp13_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp12_);
	self->priv->packages = (ValaList*) _tmp13_;
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp14_, _tmp15_);
	self->priv->defines = (ValaSet*) _tmp16_;
	self->ref_count = 1;
}


static void vala_code_context_finalize (ValaCodeContext* obj) {
	ValaCodeContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CODE_CONTEXT, ValaCodeContext);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_pkg_config_command);
	_g_free0 (self->priv->_header_filename);
	_g_free0 (self->priv->_internal_header_filename);
	_g_free0 (self->priv->_includedir);
	_g_free0 (self->priv->_symbols_filename);
	_g_free0 (self->priv->_output);
	_g_free0 (self->priv->_basedir);
	_g_free0 (self->priv->_directory);
	self->vapi_directories = (_vala_array_free (self->vapi_directories, self->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->gir_directories = (_vala_array_free (self->gir_directories, self->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->metadata_directories = (_vala_array_free (self->metadata_directories, self->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	_g_object_unref0 (self->priv->_report);
	_vala_code_node_unref0 (self->priv->_entry_point);
	_g_free0 (self->priv->_entry_point_name);
	self->gresources = (_vala_array_free (self->gresources, self->gresources_length1, (GDestroyNotify) g_free), NULL);
	self->gresources_directories = (_vala_array_free (self->gresources_directories, self->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->source_files);
	_vala_iterable_unref0 (self->priv->c_source_files);
	_vala_code_node_unref0 (self->priv->_root);
	_vala_iterable_unref0 (self->priv->packages);
	_vala_iterable_unref0 (self->priv->defines);
	_vala_code_visitor_unref0 (self->priv->_resolver);
	_vala_code_visitor_unref0 (self->priv->_analyzer);
	_vala_code_visitor_unref0 (self->priv->_flow_analyzer);
	_vala_code_visitor_unref0 (self->priv->_codegen);
	_vala_code_visitor_unref0 (self->priv->_used_attr);
}


/**
 * The root of the code tree.
 */
GType vala_code_context_get_type (void) {
	static volatile gsize vala_code_context_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_context_init, vala_value_code_context_free_value, vala_value_code_context_copy_value, vala_value_code_context_peek_pointer, "p", vala_value_code_context_collect_value, "p", vala_value_code_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeContext), 0, (GInstanceInitFunc) vala_code_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_code_context_type_id;
		vala_code_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_code_context_type_id__volatile, vala_code_context_type_id);
	}
	return vala_code_context_type_id__volatile;
}


gpointer vala_code_context_ref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_context_unref (gpointer instance) {
	ValaCodeContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



