/* valaversionattribute.c generated by valac, the Vala compiler
 * generated from valaversionattribute.vala, do not modify */

/* valaversionattribute.vala
 *
 * Copyright (C) 2013  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_VERSION_ATTRIBUTE (vala_version_attribute_get_type ())
#define VALA_VERSION_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VERSION_ATTRIBUTE, ValaVersionAttribute))
#define VALA_VERSION_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VERSION_ATTRIBUTE, ValaVersionAttributeClass))
#define VALA_IS_VERSION_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VERSION_ATTRIBUTE))
#define VALA_IS_VERSION_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VERSION_ATTRIBUTE))
#define VALA_VERSION_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VERSION_ATTRIBUTE, ValaVersionAttributeClass))

typedef struct _ValaVersionAttribute ValaVersionAttribute;
typedef struct _ValaVersionAttributeClass ValaVersionAttributeClass;
typedef struct _ValaVersionAttributePrivate ValaVersionAttributePrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
typedef struct _ValaParamSpecVersionAttribute ValaParamSpecVersionAttribute;

struct _ValaVersionAttribute {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVersionAttributePrivate * priv;
};

struct _ValaVersionAttributeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVersionAttribute *self);
};

struct _ValaVersionAttributePrivate {
	ValaSymbol* symbol;
	gboolean* _deprecated;
	gboolean* _experimental;
};

struct _ValaParamSpecVersionAttribute {
	GParamSpec parent_instance;
};


static gpointer vala_version_attribute_parent_class = NULL;

gpointer vala_version_attribute_ref (gpointer instance);
void vala_version_attribute_unref (gpointer instance);
GParamSpec* vala_param_spec_version_attribute (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_version_attribute (GValue* value, gpointer v_object);
void vala_value_take_version_attribute (GValue* value, gpointer v_object);
gpointer vala_value_get_version_attribute (const GValue* value);
GType vala_version_attribute_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
#define VALA_VERSION_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VERSION_ATTRIBUTE, ValaVersionAttributePrivate))
enum  {
	VALA_VERSION_ATTRIBUTE_0_PROPERTY
};
ValaVersionAttribute* vala_version_attribute_new (ValaSymbol* symbol);
ValaVersionAttribute* vala_version_attribute_construct (GType object_type, ValaSymbol* symbol);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gboolean vala_version_attribute_check (ValaVersionAttribute* self, ValaSourceReference* source_ref);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_version_attribute_get_deprecated (ValaVersionAttribute* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
const gchar* vala_source_file_get_installed_version (ValaSourceFile* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
gchar* vala_version_attribute_get_deprecated_since (ValaVersionAttribute* self);
gint vala_version_attribute_cmp_versions (const gchar* v1str, const gchar* v2str);
gchar* vala_version_attribute_get_replacement (ValaVersionAttribute* self);
void vala_report_deprecated (ValaSourceReference* source, const gchar* message);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
gchar* vala_version_attribute_get_since (ValaVersionAttribute* self);
gboolean vala_code_context_get_since_check (ValaCodeContext* self);
const gchar* vala_source_file_get_filename (ValaSourceFile* self);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gboolean vala_version_attribute_get_experimental (ValaVersionAttribute* self);
gboolean vala_code_context_get_experimental (ValaCodeContext* self);
gchar* vala_version_attribute_get_experimental_until (ValaVersionAttribute* self);
void vala_report_experimental (ValaSourceReference* source, const gchar* message);
gboolean vala_code_node_get_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean default_value);
gchar* vala_code_node_get_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* default_value);
GType vala_attribute_get_type (void) G_GNUC_CONST;
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const gchar* name);
static gboolean* _bool_dup (gboolean* self);
void vala_version_attribute_set_deprecated (ValaVersionAttribute* self, gboolean value);
void vala_code_node_set_attribute_bool (ValaCodeNode* self, const gchar* attribute, const gchar* argument, gboolean value, ValaSourceReference* source_reference);
void vala_version_attribute_set_deprecated_since (ValaVersionAttribute* self, const gchar* value);
void vala_code_node_set_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* value, ValaSourceReference* source_reference);
void vala_version_attribute_set_replacement (ValaVersionAttribute* self, const gchar* value);
void vala_version_attribute_set_experimental (ValaVersionAttribute* self, gboolean value);
void vala_version_attribute_set_experimental_until (ValaVersionAttribute* self, const gchar* value);
void vala_version_attribute_set_since (ValaVersionAttribute* self, const gchar* value);
static void vala_version_attribute_finalize (ValaVersionAttribute * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Constructs a new VersionAttribute.
 *
 * @param symbol the owner
 * @return a new VersionAttribute
 * @see Vala.Symbol
 */
ValaVersionAttribute* vala_version_attribute_construct (GType object_type, ValaSymbol* symbol) {
	ValaVersionAttribute* self = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (ValaVersionAttribute*) g_type_create_instance (object_type);
	_tmp0_ = symbol;
	self->priv->symbol = _tmp0_;
	return self;
}


ValaVersionAttribute* vala_version_attribute_new (ValaSymbol* symbol) {
	return vala_version_attribute_construct (VALA_TYPE_VERSION_ATTRIBUTE, symbol);
}


/**
 * Check to see if the symbol is experimental, deprecated or not available
 * and emit a warning if it is.
 */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gboolean vala_version_attribute_check (ValaVersionAttribute* self, ValaSourceReference* source_ref) {
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp57_ = FALSE;
	ValaSymbol* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp111_ = FALSE;
	ValaSymbol* _tmp112_;
	gboolean _tmp113_;
	gboolean _tmp114_;
	g_return_val_if_fail (self != NULL, FALSE);
	_result_ = FALSE;
	_tmp1_ = self->priv->symbol;
	_tmp2_ = vala_symbol_get_external_package (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = vala_version_attribute_get_deprecated (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* package_version = NULL;
		ValaSymbol* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaSourceFile* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		ValaCodeContext* _tmp15_;
		ValaCodeContext* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp6_ = self->priv->symbol;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_source_reference_get_file (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_file_get_installed_version (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		package_version = _tmp13_;
		_tmp15_ = vala_code_context_get ();
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_context_get_deprecated (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = !_tmp18_;
		_vala_code_context_unref0 (_tmp16_);
		if (_tmp19_) {
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			const gchar* _tmp22_;
			_tmp22_ = package_version;
			if (_tmp22_ == NULL) {
				_tmp21_ = TRUE;
			} else {
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp23_ = vala_version_attribute_get_deprecated_since (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				_tmp21_ = _tmp25_ == NULL;
				_g_free0 (_tmp25_);
			}
			if (_tmp21_) {
				_tmp20_ = TRUE;
			} else {
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gint _tmp30_;
				_tmp26_ = package_version;
				_tmp27_ = vala_version_attribute_get_deprecated_since (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_version_attribute_cmp_versions (_tmp26_, _tmp29_);
				_tmp20_ = _tmp30_ >= 0;
				_g_free0 (_tmp29_);
			}
			_tmp14_ = _tmp20_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gboolean _tmp35_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gboolean _tmp45_;
			ValaSourceReference* _tmp51_;
			ValaSymbol* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp32_ = vala_version_attribute_get_deprecated_since (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_ == NULL;
			_g_free0 (_tmp34_);
			if (_tmp35_) {
				gchar* _tmp36_;
				_tmp36_ = g_strdup ("is deprecated");
				_g_free0 (_tmp31_);
				_tmp31_ = _tmp36_;
			} else {
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp37_ = vala_version_attribute_get_deprecated_since (self);
				_tmp38_ = _tmp37_;
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup_printf ("has been deprecated since %s", _tmp39_);
				_g_free0 (_tmp31_);
				_tmp31_ = _tmp40_;
				_g_free0 (_tmp39_);
			}
			_tmp42_ = vala_version_attribute_get_replacement (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = _tmp43_;
			_tmp45_ = _tmp44_ == NULL;
			_g_free0 (_tmp44_);
			if (_tmp45_) {
				gchar* _tmp46_;
				_tmp46_ = g_strdup ("");
				_g_free0 (_tmp41_);
				_tmp41_ = _tmp46_;
			} else {
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp47_ = vala_version_attribute_get_replacement (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf (". Use %s", _tmp49_);
				_g_free0 (_tmp41_);
				_tmp41_ = _tmp50_;
				_g_free0 (_tmp49_);
			}
			_tmp51_ = source_ref;
			_tmp52_ = self->priv->symbol;
			_tmp53_ = vala_symbol_get_full_name (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strdup_printf ("%s %s%s", _tmp54_, _tmp31_, _tmp41_);
			_tmp56_ = _tmp55_;
			vala_report_deprecated (_tmp51_, _tmp56_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp54_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp31_);
		}
		_result_ = TRUE;
		_g_free0 (package_version);
	}
	_tmp58_ = self->priv->symbol;
	_tmp59_ = vala_symbol_get_external_package (_tmp58_);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp61_ = vala_version_attribute_get_since (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = _tmp62_;
		_tmp57_ = _tmp63_ != NULL;
		_g_free0 (_tmp63_);
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		gchar* package_version = NULL;
		ValaSymbol* _tmp64_;
		ValaSourceReference* _tmp65_;
		ValaSourceReference* _tmp66_;
		ValaSourceFile* _tmp67_;
		ValaSourceFile* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_ = FALSE;
		ValaCodeContext* _tmp74_;
		ValaCodeContext* _tmp75_;
		gboolean _tmp76_;
		gboolean _tmp77_;
		gboolean _tmp78_;
		_tmp64_ = self->priv->symbol;
		_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_source_reference_get_file (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_source_file_get_installed_version (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strdup (_tmp70_);
		package_version = _tmp71_;
		_tmp74_ = vala_code_context_get ();
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_code_context_get_since_check (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = _tmp77_;
		_vala_code_context_unref0 (_tmp75_);
		if (_tmp78_) {
			const gchar* _tmp79_;
			_tmp79_ = package_version;
			_tmp73_ = _tmp79_ != NULL;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gint _tmp84_;
			_tmp80_ = package_version;
			_tmp81_ = vala_version_attribute_get_since (self);
			_tmp82_ = _tmp81_;
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_version_attribute_cmp_versions (_tmp80_, _tmp83_);
			_tmp72_ = _tmp84_ < 0;
			_g_free0 (_tmp83_);
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			const gchar* filename = NULL;
			ValaSymbol* _tmp85_;
			ValaSourceReference* _tmp86_;
			ValaSourceReference* _tmp87_;
			ValaSourceFile* _tmp88_;
			ValaSourceFile* _tmp89_;
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			gchar* pkg = NULL;
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			gint _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			ValaSourceReference* _tmp99_;
			ValaSymbol* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			const gchar* _tmp103_;
			const gchar* _tmp104_;
			const gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			_tmp85_ = self->priv->symbol;
			_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_source_reference_get_file (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = vala_source_file_get_filename (_tmp89_);
			_tmp91_ = _tmp90_;
			filename = _tmp91_;
			_tmp92_ = filename;
			_tmp93_ = filename;
			_tmp94_ = string_last_index_of_char (_tmp93_, (gunichar) '.', 0);
			_tmp95_ = string_slice (_tmp92_, (glong) 0, (glong) _tmp94_);
			_tmp96_ = _tmp95_;
			_tmp97_ = g_path_get_basename (_tmp96_);
			_tmp98_ = _tmp97_;
			_g_free0 (_tmp96_);
			pkg = _tmp98_;
			_tmp99_ = source_ref;
			_tmp100_ = self->priv->symbol;
			_tmp101_ = vala_symbol_get_full_name (_tmp100_);
			_tmp102_ = _tmp101_;
			_tmp103_ = pkg;
			_tmp104_ = package_version;
			_tmp105_ = pkg;
			_tmp106_ = vala_version_attribute_get_since (self);
			_tmp107_ = _tmp106_;
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strdup_printf ("%s is not available in %s %s. Use %s >= %s", _tmp102_, _tmp103_, _tmp104_, _tmp105_, _tmp108_);
			_tmp110_ = _tmp109_;
			vala_report_error (_tmp99_, _tmp110_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp108_);
			_g_free0 (_tmp102_);
			_g_free0 (pkg);
		}
		_result_ = TRUE;
		_g_free0 (package_version);
	}
	_tmp112_ = self->priv->symbol;
	_tmp113_ = vala_symbol_get_external_package (_tmp112_);
	_tmp114_ = _tmp113_;
	if (_tmp114_) {
		gboolean _tmp115_;
		gboolean _tmp116_;
		_tmp115_ = vala_version_attribute_get_experimental (self);
		_tmp116_ = _tmp115_;
		_tmp111_ = _tmp116_;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		ValaCodeContext* _tmp117_;
		ValaCodeContext* _tmp118_;
		gboolean _tmp119_;
		gboolean _tmp120_;
		gboolean _tmp121_;
		_tmp117_ = vala_code_context_get ();
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_code_context_get_experimental (_tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = !_tmp120_;
		_vala_code_context_unref0 (_tmp118_);
		if (_tmp121_) {
			gchar* package_version = NULL;
			ValaSymbol* _tmp122_;
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			ValaSourceFile* _tmp125_;
			ValaSourceFile* _tmp126_;
			const gchar* _tmp127_;
			const gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* experimental_until = NULL;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gboolean _tmp132_ = FALSE;
			gboolean _tmp133_ = FALSE;
			const gchar* _tmp134_;
			_tmp122_ = self->priv->symbol;
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_source_reference_get_file (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_source_file_get_installed_version (_tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = g_strdup (_tmp128_);
			package_version = _tmp129_;
			_tmp130_ = vala_version_attribute_get_experimental_until (self);
			_tmp131_ = _tmp130_;
			experimental_until = _tmp131_;
			_tmp134_ = experimental_until;
			if (_tmp134_ == NULL) {
				_tmp133_ = TRUE;
			} else {
				const gchar* _tmp135_;
				_tmp135_ = package_version;
				_tmp133_ = _tmp135_ == NULL;
			}
			if (_tmp133_) {
				_tmp132_ = TRUE;
			} else {
				const gchar* _tmp136_;
				const gchar* _tmp137_;
				gint _tmp138_;
				_tmp136_ = package_version;
				_tmp137_ = experimental_until;
				_tmp138_ = vala_version_attribute_cmp_versions (_tmp136_, _tmp137_);
				_tmp132_ = _tmp138_ < 0;
			}
			if (_tmp132_) {
				gchar* _tmp139_ = NULL;
				const gchar* _tmp140_;
				ValaSourceReference* _tmp144_;
				ValaSymbol* _tmp145_;
				gchar* _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				_tmp140_ = experimental_until;
				if (_tmp140_ != NULL) {
					const gchar* _tmp141_;
					gchar* _tmp142_;
					_tmp141_ = experimental_until;
					_tmp142_ = g_strdup_printf (" until %s", _tmp141_);
					_g_free0 (_tmp139_);
					_tmp139_ = _tmp142_;
				} else {
					gchar* _tmp143_;
					_tmp143_ = g_strdup ("");
					_g_free0 (_tmp139_);
					_tmp139_ = _tmp143_;
				}
				_tmp144_ = source_ref;
				_tmp145_ = self->priv->symbol;
				_tmp146_ = vala_symbol_get_full_name (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = g_strdup_printf ("%s is experimental%s", _tmp147_, _tmp139_);
				_tmp149_ = _tmp148_;
				vala_report_experimental (_tmp144_, _tmp149_);
				_g_free0 (_tmp149_);
				_g_free0 (_tmp147_);
				_g_free0 (_tmp139_);
			}
			_g_free0 (experimental_until);
			_g_free0 (package_version);
		}
		_result_ = TRUE;
	}
	result = _result_;
	return result;
}


/**
 * A simple version comparison function.
 *
 * @param v1str a version number
 * @param v2str a version number
 * @return an integer less than, equal to, or greater than zero, if v1str is <, == or > than v2str
 * @see GLib.CompareFunc
 */
gint vala_version_attribute_cmp_versions (const gchar* v1str, const gchar* v2str) {
	gint result = 0;
	gchar** v1arr = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint v1arr_length1;
	gint _v1arr_size_;
	gchar** v2arr = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint v2arr_length1;
	gint _v2arr_size_;
	gint i = 0;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_;
	const gchar* _tmp32_;
	gboolean _tmp36_ = FALSE;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gint _tmp38_;
	const gchar* _tmp39_;
	g_return_val_if_fail (v1str != NULL, 0);
	g_return_val_if_fail (v2str != NULL, 0);
	_tmp0_ = v1str;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	v1arr = _tmp2_;
	v1arr_length1 = _vala_array_length (_tmp1_);
	_v1arr_size_ = v1arr_length1;
	_tmp3_ = v2str;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ".", 0);
	v2arr = _tmp5_;
	v2arr_length1 = _vala_array_length (_tmp4_);
	_v2arr_size_ = v2arr_length1;
	i = 0;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		const gchar* _tmp9_;
		gint v1num = 0;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint v2num = 0;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gint _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gboolean _tmp21_ = FALSE;
		gint _tmp22_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp7_ = v1arr;
		_tmp7__length1 = v1arr_length1;
		_tmp8_ = i;
		_tmp9_ = _tmp7_[_tmp8_];
		if (_tmp9_ != NULL) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = v2arr;
			_tmp10__length1 = v2arr_length1;
			_tmp11_ = i;
			_tmp12_ = _tmp10_[_tmp11_];
			_tmp6_ = _tmp12_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp13_ = v1arr;
		_tmp13__length1 = v1arr_length1;
		_tmp14_ = i;
		_tmp15_ = _tmp13_[_tmp14_];
		_tmp16_ = atoi (_tmp15_);
		v1num = _tmp16_;
		_tmp17_ = v2arr;
		_tmp17__length1 = v2arr_length1;
		_tmp18_ = i;
		_tmp19_ = _tmp17_[_tmp18_];
		_tmp20_ = atoi (_tmp19_);
		v2num = _tmp20_;
		_tmp22_ = v1num;
		if (_tmp22_ < 0) {
			_tmp21_ = TRUE;
		} else {
			gint _tmp23_;
			_tmp23_ = v2num;
			_tmp21_ = _tmp23_ < 0;
		}
		if (_tmp21_) {
			result = 0;
			v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
			v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp24_ = v1num;
		_tmp25_ = v2num;
		if (_tmp24_ > _tmp25_) {
			result = 1;
			v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
			v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp26_ = v1num;
		_tmp27_ = v2num;
		if (_tmp26_ < _tmp27_) {
			result = -1;
			v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
			v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp28_ = i;
		i = _tmp28_ + 1;
	}
	_tmp30_ = v1arr;
	_tmp30__length1 = v1arr_length1;
	_tmp31_ = i;
	_tmp32_ = _tmp30_[_tmp31_];
	if (_tmp32_ != NULL) {
		gchar** _tmp33_;
		gint _tmp33__length1;
		gint _tmp34_;
		const gchar* _tmp35_;
		_tmp33_ = v2arr;
		_tmp33__length1 = v2arr_length1;
		_tmp34_ = i;
		_tmp35_ = _tmp33_[_tmp34_];
		_tmp29_ = _tmp35_ == NULL;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		result = 1;
		v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
		v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp37_ = v1arr;
	_tmp37__length1 = v1arr_length1;
	_tmp38_ = i;
	_tmp39_ = _tmp37_[_tmp38_];
	if (_tmp39_ == NULL) {
		gchar** _tmp40_;
		gint _tmp40__length1;
		gint _tmp41_;
		const gchar* _tmp42_;
		_tmp40_ = v2arr;
		_tmp40__length1 = v2arr_length1;
		_tmp41_ = i;
		_tmp42_ = _tmp40_[_tmp41_];
		_tmp36_ = _tmp42_ != NULL;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		result = -1;
		v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
		v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = 0;
	v2arr = (_vala_array_free (v2arr, v2arr_length1, (GDestroyNotify) g_free), NULL);
	v1arr = (_vala_array_free (v1arr, v1arr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_version_attribute_get_deprecated (ValaVersionAttribute* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_deprecated;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		ValaSymbol* _tmp4_;
		gboolean _tmp5_;
		gboolean* _tmp15_;
		_tmp4_ = self->priv->symbol;
		_tmp5_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp4_, "Version", "deprecated", FALSE);
		if (_tmp5_) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->symbol;
			_tmp7_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp6_, "Version", "deprecated_since", NULL);
			_tmp8_ = _tmp7_;
			_tmp3_ = _tmp8_ != NULL;
			_g_free0 (_tmp8_);
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			ValaSymbol* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = self->priv->symbol;
			_tmp10_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp9_, "Version", "replacement", NULL);
			_tmp11_ = _tmp10_;
			_tmp2_ = _tmp11_ != NULL;
			_g_free0 (_tmp11_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp12_;
			ValaAttribute* _tmp13_;
			ValaAttribute* _tmp14_;
			_tmp12_ = self->priv->symbol;
			_tmp13_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp12_, "Deprecated");
			_tmp14_ = _tmp13_;
			_tmp1_ = _tmp14_ != NULL;
			_vala_code_node_unref0 (_tmp14_);
		}
		_tmp15_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_deprecated);
		self->priv->_deprecated = _tmp15_;
	}
	_tmp16_ = self->priv->_deprecated;
	result = *_tmp16_;
	return result;
}


void vala_version_attribute_set_deprecated (ValaVersionAttribute* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	ValaSymbol* _tmp2_;
	gboolean* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_deprecated);
	self->priv->_deprecated = _tmp1_;
	_tmp2_ = self->priv->symbol;
	_tmp3_ = self->priv->_deprecated;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp2_, "Version", "deprecated", *_tmp3_, NULL);
}


gchar* vala_version_attribute_get_deprecated_since (ValaVersionAttribute* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->symbol;
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp1_, "Version", "deprecated_since", NULL);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		ValaSymbol* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->symbol;
		_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "Deprecated", "since", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}


void vala_version_attribute_set_deprecated_since (ValaVersionAttribute* self, const gchar* value) {
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = value;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "deprecated_since", _tmp1_, NULL);
}


gchar* vala_version_attribute_get_replacement (ValaVersionAttribute* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	ValaSymbol* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->symbol;
	_tmp2_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp1_, "Version", "replacement", NULL);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		ValaSymbol* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->symbol;
		_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "Deprecated", "replacement", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}


void vala_version_attribute_set_replacement (ValaVersionAttribute* self, const gchar* value) {
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = value;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "replacement", _tmp1_, NULL);
}


gboolean vala_version_attribute_get_experimental (ValaVersionAttribute* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_experimental;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaSymbol* _tmp3_;
		gboolean _tmp4_;
		gboolean* _tmp11_;
		_tmp3_ = self->priv->symbol;
		_tmp4_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp3_, "Version", "experimental", FALSE);
		if (_tmp4_) {
			_tmp2_ = TRUE;
		} else {
			ValaSymbol* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->symbol;
			_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "Version", "experimental_until", NULL);
			_tmp7_ = _tmp6_;
			_tmp2_ = _tmp7_ != NULL;
			_g_free0 (_tmp7_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			ValaAttribute* _tmp9_;
			ValaAttribute* _tmp10_;
			_tmp8_ = self->priv->symbol;
			_tmp9_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp8_, "Experimental");
			_tmp10_ = _tmp9_;
			_tmp1_ = _tmp10_ != NULL;
			_vala_code_node_unref0 (_tmp10_);
		}
		_tmp11_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_experimental);
		self->priv->_experimental = _tmp11_;
	}
	_tmp12_ = self->priv->_experimental;
	result = *_tmp12_;
	return result;
}


void vala_version_attribute_set_experimental (ValaVersionAttribute* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	ValaSymbol* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_experimental);
	self->priv->_experimental = _tmp1_;
	_tmp2_ = self->priv->symbol;
	_tmp3_ = value;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp2_, "Version", "experimental", _tmp3_, NULL);
}


gchar* vala_version_attribute_get_experimental_until (ValaVersionAttribute* self) {
	gchar* result;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "experimental_until", NULL);
	result = _tmp1_;
	return result;
}


void vala_version_attribute_set_experimental_until (ValaVersionAttribute* self, const gchar* value) {
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = value;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "experimental_until", _tmp1_, NULL);
}


gchar* vala_version_attribute_get_since (ValaVersionAttribute* self) {
	gchar* result;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "since", NULL);
	result = _tmp1_;
	return result;
}


void vala_version_attribute_set_since (ValaVersionAttribute* self, const gchar* value) {
	ValaSymbol* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->symbol;
	_tmp1_ = value;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp0_, "Version", "since", _tmp1_, NULL);
}


static void vala_value_version_attribute_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_version_attribute_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_version_attribute_unref (value->data[0].v_pointer);
	}
}


static void vala_value_version_attribute_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_version_attribute_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_version_attribute_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_version_attribute_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaVersionAttribute * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_version_attribute_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_version_attribute_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaVersionAttribute ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_version_attribute_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_version_attribute (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecVersionAttribute* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VERSION_ATTRIBUTE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_version_attribute (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VERSION_ATTRIBUTE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_version_attribute (GValue* value, gpointer v_object) {
	ValaVersionAttribute * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VERSION_ATTRIBUTE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VERSION_ATTRIBUTE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_version_attribute_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_version_attribute_unref (old);
	}
}


void vala_value_take_version_attribute (GValue* value, gpointer v_object) {
	ValaVersionAttribute * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VERSION_ATTRIBUTE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VERSION_ATTRIBUTE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_version_attribute_unref (old);
	}
}


static void vala_version_attribute_class_init (ValaVersionAttributeClass * klass) {
	vala_version_attribute_parent_class = g_type_class_peek_parent (klass);
	((ValaVersionAttributeClass *) klass)->finalize = vala_version_attribute_finalize;
	g_type_class_add_private (klass, sizeof (ValaVersionAttributePrivate));
}


static void vala_version_attribute_instance_init (ValaVersionAttribute * self) {
	self->priv = VALA_VERSION_ATTRIBUTE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_version_attribute_finalize (ValaVersionAttribute * obj) {
	ValaVersionAttribute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VERSION_ATTRIBUTE, ValaVersionAttribute);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_deprecated);
	_g_free0 (self->priv->_experimental);
}


/**
 * Represents a [Version] attribute
 */
GType vala_version_attribute_get_type (void) {
	static volatile gsize vala_version_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&vala_version_attribute_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_version_attribute_init, vala_value_version_attribute_free_value, vala_value_version_attribute_copy_value, vala_value_version_attribute_peek_pointer, "p", vala_value_version_attribute_collect_value, "p", vala_value_version_attribute_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaVersionAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_version_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVersionAttribute), 0, (GInstanceInitFunc) vala_version_attribute_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_version_attribute_type_id;
		vala_version_attribute_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVersionAttribute", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_version_attribute_type_id__volatile, vala_version_attribute_type_id);
	}
	return vala_version_attribute_type_id__volatile;
}


gpointer vala_version_attribute_ref (gpointer instance) {
	ValaVersionAttribute * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_version_attribute_unref (gpointer instance) {
	ValaVersionAttribute * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VERSION_ATTRIBUTE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



