/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY,
	VALA_CREATION_METHOD_LAST_PROPERTY
};
static GParamSpec* vala_creation_method_properties[VALA_CREATION_METHOD_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};


static gpointer vala_creation_method_parent_class = NULL;

#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);


/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_construct (GType object_type, const gchar* class_name, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaCreationMethod* self = NULL;
	const gchar* _tmp0_;
	ValaVoidType* _tmp1_;
	ValaVoidType* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaComment* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = name;
	_tmp1_ = vala_void_type_new (NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = source_reference;
	_tmp4_ = comment;
	self = (ValaCreationMethod*) vala_method_construct (object_type, _tmp0_, (ValaDataType*) _tmp2_, _tmp3_, _tmp4_);
	_vala_code_node_unref0 (_tmp2_);
	_tmp5_ = class_name;
	vala_creation_method_set_class_name (self, _tmp5_);
	return self;
}


ValaCreationMethod* vala_creation_method_new (const gchar* class_name, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_creation_method (_tmp0_, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaCodeVisitor* _tmp11_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, _tmp11_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp12_;
		gint _error_type_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _error_type_index = 0;
		_tmp12_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp12_;
		_tmp13_ = _error_type_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_error_type_size = _tmp15_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaDataType* _tmp22_;
			ValaCodeVisitor* _tmp23_;
			_tmp16_ = _error_type_index;
			_error_type_index = _tmp16_ + 1;
			_tmp17_ = _error_type_index;
			_tmp18_ = _error_type_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _error_type_list;
			_tmp20_ = _error_type_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			error_type = (ValaDataType*) _tmp21_;
			_tmp22_ = error_type;
			_tmp23_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, _tmp23_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp24_;
		gint _precondition_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _precondition_index = 0;
		_tmp24_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp24_;
		_tmp25_ = _precondition_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_precondition_size = _tmp27_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaExpression* _tmp34_;
			ValaCodeVisitor* _tmp35_;
			_tmp28_ = _precondition_index;
			_precondition_index = _tmp28_ + 1;
			_tmp29_ = _precondition_index;
			_tmp30_ = _precondition_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _precondition_list;
			_tmp32_ = _precondition_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			precondition = (ValaExpression*) _tmp33_;
			_tmp34_ = precondition;
			_tmp35_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp34_, _tmp35_);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp36_;
		gint _postcondition_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _postcondition_index = 0;
		_tmp36_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp36_;
		_tmp37_ = _postcondition_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_postcondition_size = _tmp39_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			ValaExpression* _tmp46_;
			ValaCodeVisitor* _tmp47_;
			_tmp40_ = _postcondition_index;
			_postcondition_index = _tmp40_ + 1;
			_tmp41_ = _postcondition_index;
			_tmp42_ = _postcondition_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _postcondition_list;
			_tmp44_ = _postcondition_index;
			_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
			postcondition = (ValaExpression*) _tmp45_;
			_tmp46_ = postcondition;
			_tmp47_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp46_, _tmp47_);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp48_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp49_ = _tmp48_;
	if (_tmp49_ != NULL) {
		ValaBlock* _tmp50_;
		ValaBlock* _tmp51_;
		ValaCodeVisitor* _tmp52_;
		_tmp50_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp51_ = _tmp50_;
		_tmp52_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp51_, _tmp52_);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_creation_method_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaCreationMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp23_;
	ValaSemanticAnalyzer* _tmp24_;
	ValaSemanticAnalyzer* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSourceFile* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSourceReference* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaCodeContext* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	ValaSemanticAnalyzer* _tmp46_;
	ValaBlock* _tmp95_;
	ValaBlock* _tmp96_;
	ValaCodeContext* _tmp232_;
	ValaSemanticAnalyzer* _tmp233_;
	ValaSemanticAnalyzer* _tmp234_;
	ValaSourceFile* _tmp235_;
	ValaCodeContext* _tmp236_;
	ValaSemanticAnalyzer* _tmp237_;
	ValaSemanticAnalyzer* _tmp238_;
	ValaSymbol* _tmp239_;
	gboolean _tmp240_ = FALSE;
	gboolean _tmp241_ = FALSE;
	gboolean _tmp242_;
	gboolean _tmp243_;
	ValaBlock* _tmp254_;
	ValaBlock* _tmp255_;
	gboolean _tmp294_;
	gboolean _tmp295_;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaCodeContext* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSemanticAnalyzer* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = context;
		_tmp14_ = vala_code_context_get_analyzer (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_semantic_analyzer_get_current_symbol (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_full_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->_class_name;
		_tmp21_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		vala_report_error (_tmp12_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp23_ = context;
	_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_current_source_file (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_source_file_ref0 (_tmp27_);
	old_source_file = _tmp28_;
	_tmp29_ = context;
	_tmp30_ = vala_code_context_get_analyzer (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_semantic_analyzer_get_current_symbol (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _vala_code_node_ref0 (_tmp33_);
	old_symbol = _tmp34_;
	_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		ValaCodeContext* _tmp37_;
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp37_ = context;
		_tmp38_ = vala_code_context_get_analyzer (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = context;
	_tmp45_ = vala_code_context_get_analyzer (_tmp44_);
	_tmp46_ = _tmp45_;
	vala_semantic_analyzer_set_current_symbol (_tmp46_, (ValaSymbol*) self);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp47_;
		gint _param_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _param_index = 0;
		_tmp47_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp47_;
		_tmp48_ = _param_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_param_size = _tmp50_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			ValaParameter* param = NULL;
			ValaList* _tmp54_;
			gint _tmp55_;
			gpointer _tmp56_;
			ValaParameter* _tmp57_;
			ValaCodeContext* _tmp58_;
			_tmp51_ = _param_index;
			_param_index = _tmp51_ + 1;
			_tmp52_ = _param_index;
			_tmp53_ = _param_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _param_list;
			_tmp55_ = _param_index;
			_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
			param = (ValaParameter*) _tmp56_;
			_tmp57_ = param;
			_tmp58_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp57_, _tmp58_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp59_;
		gint _error_type_size = 0;
		ValaList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _error_type_index = 0;
		_tmp59_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp59_;
		_tmp60_ = _error_type_list;
		_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_error_type_size = _tmp62_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_;
			ValaDataType* _tmp69_;
			ValaCodeContext* _tmp70_;
			_tmp63_ = _error_type_index;
			_error_type_index = _tmp63_ + 1;
			_tmp64_ = _error_type_index;
			_tmp65_ = _error_type_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _error_type_list;
			_tmp67_ = _error_type_index;
			_tmp68_ = vala_list_get (_tmp66_, _tmp67_);
			error_type = (ValaDataType*) _tmp68_;
			_tmp69_ = error_type;
			_tmp70_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp69_, _tmp70_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp71_;
		gint _precondition_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _precondition_index = 0;
		_tmp71_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp71_;
		_tmp72_ = _precondition_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_precondition_size = _tmp74_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp78_;
			gint _tmp79_;
			gpointer _tmp80_;
			ValaExpression* _tmp81_;
			ValaCodeContext* _tmp82_;
			_tmp75_ = _precondition_index;
			_precondition_index = _tmp75_ + 1;
			_tmp76_ = _precondition_index;
			_tmp77_ = _precondition_size;
			if (!(_tmp76_ < _tmp77_)) {
				break;
			}
			_tmp78_ = _precondition_list;
			_tmp79_ = _precondition_index;
			_tmp80_ = vala_list_get (_tmp78_, _tmp79_);
			precondition = (ValaExpression*) _tmp80_;
			_tmp81_ = precondition;
			_tmp82_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp81_, _tmp82_);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp83_;
		gint _postcondition_size = 0;
		ValaList* _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		gint _postcondition_index = 0;
		_tmp83_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp83_;
		_tmp84_ = _postcondition_list;
		_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
		_tmp86_ = _tmp85_;
		_postcondition_size = _tmp86_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp87_;
			gint _tmp88_;
			gint _tmp89_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp90_;
			gint _tmp91_;
			gpointer _tmp92_;
			ValaExpression* _tmp93_;
			ValaCodeContext* _tmp94_;
			_tmp87_ = _postcondition_index;
			_postcondition_index = _tmp87_ + 1;
			_tmp88_ = _postcondition_index;
			_tmp89_ = _postcondition_size;
			if (!(_tmp88_ < _tmp89_)) {
				break;
			}
			_tmp90_ = _postcondition_list;
			_tmp91_ = _postcondition_index;
			_tmp92_ = vala_list_get (_tmp90_, _tmp91_);
			postcondition = (ValaExpression*) _tmp92_;
			_tmp93_ = postcondition;
			_tmp94_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp93_, _tmp94_);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp96_ = _tmp95_;
	if (_tmp96_ != NULL) {
		ValaBlock* _tmp97_;
		ValaBlock* _tmp98_;
		ValaCodeContext* _tmp99_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaClass* _tmp102_;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		gboolean _tmp105_;
		_tmp97_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp98_, _tmp99_);
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp101_) : NULL);
		cl = _tmp102_;
		_tmp105_ = self->priv->_chain_up;
		if (!_tmp105_) {
			ValaClass* _tmp106_;
			_tmp106_ = cl;
			_tmp104_ = _tmp106_ != NULL;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaClass* _tmp107_;
			ValaClass* _tmp108_;
			ValaClass* _tmp109_;
			_tmp107_ = cl;
			_tmp108_ = vala_class_get_base_class (_tmp107_);
			_tmp109_ = _tmp108_;
			_tmp103_ = _tmp109_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			gboolean _tmp110_ = FALSE;
			ValaClass* _tmp111_;
			ValaClass* _tmp112_;
			ValaClass* _tmp113_;
			ValaCreationMethod* _tmp114_;
			ValaCreationMethod* _tmp115_;
			_tmp111_ = cl;
			_tmp112_ = vala_class_get_base_class (_tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_class_get_default_construction_method (_tmp113_);
			_tmp115_ = _tmp114_;
			if (_tmp115_ != NULL) {
				ValaClass* _tmp116_;
				ValaClass* _tmp117_;
				ValaClass* _tmp118_;
				ValaCreationMethod* _tmp119_;
				ValaCreationMethod* _tmp120_;
				gboolean _tmp121_;
				gboolean _tmp122_;
				_tmp116_ = cl;
				_tmp117_ = vala_class_get_base_class (_tmp116_);
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_class_get_default_construction_method (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp120_);
				_tmp122_ = _tmp121_;
				_tmp110_ = !_tmp122_;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaBlock* old_insert_block = NULL;
				ValaCodeContext* _tmp123_;
				ValaSemanticAnalyzer* _tmp124_;
				ValaSemanticAnalyzer* _tmp125_;
				ValaBlock* _tmp126_;
				ValaBlock* _tmp127_;
				ValaCodeContext* _tmp128_;
				ValaSemanticAnalyzer* _tmp129_;
				ValaSemanticAnalyzer* _tmp130_;
				ValaBlock* _tmp131_;
				ValaBlock* _tmp132_;
				ValaCodeContext* _tmp133_;
				ValaSemanticAnalyzer* _tmp134_;
				ValaSemanticAnalyzer* _tmp135_;
				ValaBlock* _tmp136_;
				ValaBlock* _tmp137_;
				ValaBlock* _tmp138_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp139_;
				ValaSourceReference* _tmp140_;
				ValaMemberAccess* _tmp141_;
				ValaMemberAccess* _tmp142_;
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaMemberAccess* _tmp145_;
				ValaMemberAccess* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaMethodCall* _tmp149_;
				ValaMethodCall* _tmp150_;
				ValaSourceReference* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaExpressionStatement* _tmp153_;
				ValaExpressionStatement* _tmp154_;
				ValaBlock* _tmp155_;
				ValaBlock* _tmp156_;
				ValaExpressionStatement* _tmp157_;
				ValaExpressionStatement* _tmp158_;
				ValaCodeContext* _tmp159_;
				ValaCodeContext* _tmp160_;
				ValaSemanticAnalyzer* _tmp161_;
				ValaSemanticAnalyzer* _tmp162_;
				ValaCodeContext* _tmp163_;
				ValaSemanticAnalyzer* _tmp164_;
				ValaSemanticAnalyzer* _tmp165_;
				ValaBlock* _tmp166_;
				ValaBlock* _tmp167_;
				_tmp123_ = context;
				_tmp124_ = vala_code_context_get_analyzer (_tmp123_);
				_tmp125_ = _tmp124_;
				_tmp126_ = _tmp125_->insert_block;
				_tmp127_ = _vala_code_node_ref0 (_tmp126_);
				old_insert_block = _tmp127_;
				_tmp128_ = context;
				_tmp129_ = vala_code_context_get_analyzer (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp132_ = _tmp131_;
				vala_semantic_analyzer_set_current_symbol (_tmp130_, (ValaSymbol*) _tmp132_);
				_tmp133_ = context;
				_tmp134_ = vala_code_context_get_analyzer (_tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp137_ = _tmp136_;
				_tmp138_ = _vala_code_node_ref0 (_tmp137_);
				_vala_code_node_unref0 (_tmp135_->insert_block);
				_tmp135_->insert_block = _tmp138_;
				_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_member_access_new_simple ("GLib", _tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_member_access_new ((ValaExpression*) _tmp142_, "Object", _tmp144_);
				_tmp146_ = _tmp145_;
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				_tmp149_ = vala_method_call_new ((ValaExpression*) _tmp146_, _tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = vala_expression_statement_new ((ValaExpression*) _tmp150_, _tmp152_);
				_tmp154_ = _tmp153_;
				_vala_code_node_unref0 (_tmp150_);
				_vala_code_node_unref0 (_tmp146_);
				_vala_code_node_unref0 (_tmp142_);
				stmt = _tmp154_;
				_tmp155_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp156_ = _tmp155_;
				_tmp157_ = stmt;
				vala_block_insert_statement (_tmp156_, 0, (ValaStatement*) _tmp157_);
				_tmp158_ = stmt;
				_tmp159_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp158_, _tmp159_);
				_tmp160_ = context;
				_tmp161_ = vala_code_context_get_analyzer (_tmp160_);
				_tmp162_ = _tmp161_;
				vala_semantic_analyzer_set_current_symbol (_tmp162_, (ValaSymbol*) self);
				_tmp163_ = context;
				_tmp164_ = vala_code_context_get_analyzer (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = old_insert_block;
				_tmp167_ = _vala_code_node_ref0 (_tmp166_);
				_vala_code_node_unref0 (_tmp165_->insert_block);
				_tmp165_->insert_block = _tmp167_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp168_ = FALSE;
				ValaClass* _tmp169_;
				ValaClass* _tmp170_;
				ValaClass* _tmp171_;
				ValaCreationMethod* _tmp172_;
				ValaCreationMethod* _tmp173_;
				_tmp169_ = cl;
				_tmp170_ = vala_class_get_base_class (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_class_get_default_construction_method (_tmp171_);
				_tmp173_ = _tmp172_;
				if (_tmp173_ == NULL) {
					_tmp168_ = TRUE;
				} else {
					ValaClass* _tmp174_;
					ValaClass* _tmp175_;
					ValaClass* _tmp176_;
					ValaCreationMethod* _tmp177_;
					ValaCreationMethod* _tmp178_;
					ValaSymbolAccessibility _tmp179_;
					ValaSymbolAccessibility _tmp180_;
					_tmp174_ = cl;
					_tmp175_ = vala_class_get_base_class (_tmp174_);
					_tmp176_ = _tmp175_;
					_tmp177_ = vala_class_get_default_construction_method (_tmp176_);
					_tmp178_ = _tmp177_;
					_tmp179_ = vala_symbol_get_access ((ValaSymbol*) _tmp178_);
					_tmp180_ = _tmp179_;
					_tmp168_ = _tmp180_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp168_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					vala_report_error (_tmp182_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp183_;
					ValaClass* _tmp184_;
					ValaClass* _tmp185_;
					ValaCreationMethod* _tmp186_;
					ValaCreationMethod* _tmp187_;
					gint _tmp188_;
					_tmp183_ = cl;
					_tmp184_ = vala_class_get_base_class (_tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_class_get_default_construction_method (_tmp185_);
					_tmp187_ = _tmp186_;
					_tmp188_ = vala_method_get_required_arguments ((ValaMethod*) _tmp187_);
					if (_tmp188_ > 0) {
						ValaSourceReference* _tmp189_;
						ValaSourceReference* _tmp190_;
						_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp190_ = _tmp189_;
						vala_report_error (_tmp190_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaCodeContext* _tmp191_;
						ValaSemanticAnalyzer* _tmp192_;
						ValaSemanticAnalyzer* _tmp193_;
						ValaBlock* _tmp194_;
						ValaBlock* _tmp195_;
						ValaCodeContext* _tmp196_;
						ValaSemanticAnalyzer* _tmp197_;
						ValaSemanticAnalyzer* _tmp198_;
						ValaBlock* _tmp199_;
						ValaBlock* _tmp200_;
						ValaCodeContext* _tmp201_;
						ValaSemanticAnalyzer* _tmp202_;
						ValaSemanticAnalyzer* _tmp203_;
						ValaBlock* _tmp204_;
						ValaBlock* _tmp205_;
						ValaBlock* _tmp206_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp207_;
						ValaSourceReference* _tmp208_;
						ValaBaseAccess* _tmp209_;
						ValaBaseAccess* _tmp210_;
						ValaSourceReference* _tmp211_;
						ValaSourceReference* _tmp212_;
						ValaMethodCall* _tmp213_;
						ValaMethodCall* _tmp214_;
						ValaSourceReference* _tmp215_;
						ValaSourceReference* _tmp216_;
						ValaExpressionStatement* _tmp217_;
						ValaExpressionStatement* _tmp218_;
						ValaBlock* _tmp219_;
						ValaBlock* _tmp220_;
						ValaExpressionStatement* _tmp221_;
						ValaExpressionStatement* _tmp222_;
						ValaCodeContext* _tmp223_;
						ValaCodeContext* _tmp224_;
						ValaSemanticAnalyzer* _tmp225_;
						ValaSemanticAnalyzer* _tmp226_;
						ValaCodeContext* _tmp227_;
						ValaSemanticAnalyzer* _tmp228_;
						ValaSemanticAnalyzer* _tmp229_;
						ValaBlock* _tmp230_;
						ValaBlock* _tmp231_;
						_tmp191_ = context;
						_tmp192_ = vala_code_context_get_analyzer (_tmp191_);
						_tmp193_ = _tmp192_;
						_tmp194_ = _tmp193_->insert_block;
						_tmp195_ = _vala_code_node_ref0 (_tmp194_);
						old_insert_block = _tmp195_;
						_tmp196_ = context;
						_tmp197_ = vala_code_context_get_analyzer (_tmp196_);
						_tmp198_ = _tmp197_;
						_tmp199_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp200_ = _tmp199_;
						vala_semantic_analyzer_set_current_symbol (_tmp198_, (ValaSymbol*) _tmp200_);
						_tmp201_ = context;
						_tmp202_ = vala_code_context_get_analyzer (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp205_ = _tmp204_;
						_tmp206_ = _vala_code_node_ref0 (_tmp205_);
						_vala_code_node_unref0 (_tmp203_->insert_block);
						_tmp203_->insert_block = _tmp206_;
						_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_base_access_new (_tmp208_);
						_tmp210_ = _tmp209_;
						_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp212_ = _tmp211_;
						_tmp213_ = vala_method_call_new ((ValaExpression*) _tmp210_, _tmp212_);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp216_ = _tmp215_;
						_tmp217_ = vala_expression_statement_new ((ValaExpression*) _tmp214_, _tmp216_);
						_tmp218_ = _tmp217_;
						_vala_code_node_unref0 (_tmp214_);
						_vala_code_node_unref0 (_tmp210_);
						stmt = _tmp218_;
						_tmp219_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp220_ = _tmp219_;
						_tmp221_ = stmt;
						vala_block_insert_statement (_tmp220_, 0, (ValaStatement*) _tmp221_);
						_tmp222_ = stmt;
						_tmp223_ = context;
						vala_code_node_check ((ValaCodeNode*) _tmp222_, _tmp223_);
						_tmp224_ = context;
						_tmp225_ = vala_code_context_get_analyzer (_tmp224_);
						_tmp226_ = _tmp225_;
						vala_semantic_analyzer_set_current_symbol (_tmp226_, (ValaSymbol*) self);
						_tmp227_ = context;
						_tmp228_ = vala_code_context_get_analyzer (_tmp227_);
						_tmp229_ = _tmp228_;
						_tmp230_ = old_insert_block;
						_tmp231_ = _vala_code_node_ref0 (_tmp230_);
						_vala_code_node_unref0 (_tmp229_->insert_block);
						_tmp229_->insert_block = _tmp231_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp232_ = context;
	_tmp233_ = vala_code_context_get_analyzer (_tmp232_);
	_tmp234_ = _tmp233_;
	_tmp235_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp234_, _tmp235_);
	_tmp236_ = context;
	_tmp237_ = vala_code_context_get_analyzer (_tmp236_);
	_tmp238_ = _tmp237_;
	_tmp239_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp238_, _tmp239_);
	_tmp242_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp243_ = _tmp242_;
	if (_tmp243_) {
		_tmp241_ = TRUE;
	} else {
		gboolean _tmp244_;
		gboolean _tmp245_;
		_tmp244_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp245_ = _tmp244_;
		_tmp241_ = _tmp245_;
	}
	if (_tmp241_) {
		_tmp240_ = TRUE;
	} else {
		gboolean _tmp246_;
		gboolean _tmp247_;
		_tmp246_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp247_ = _tmp246_;
		_tmp240_ = _tmp247_;
	}
	if (_tmp240_) {
		ValaSourceReference* _tmp248_;
		ValaSourceReference* _tmp249_;
		gchar* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp251_ = _tmp250_;
		_tmp252_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp251_);
		_tmp253_ = _tmp252_;
		vala_report_error (_tmp249_, _tmp253_);
		_g_free0 (_tmp253_);
		_g_free0 (_tmp251_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp254_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp255_ = _tmp254_;
	if (_tmp255_ != NULL) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp256_;
			ValaBlock* _tmp257_;
			ValaList* _tmp258_;
			gint _body_error_type_size = 0;
			ValaList* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gint _body_error_type_index = 0;
			_tmp256_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp257_);
			_body_error_type_list = _tmp258_;
			_tmp259_ = _body_error_type_list;
			_tmp260_ = vala_collection_get_size ((ValaCollection*) _tmp259_);
			_tmp261_ = _tmp260_;
			_body_error_type_size = _tmp261_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp262_;
				gint _tmp263_;
				gint _tmp264_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp265_;
				gint _tmp266_;
				gpointer _tmp267_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp281_ = FALSE;
				gboolean _tmp282_;
				_tmp262_ = _body_error_type_index;
				_body_error_type_index = _tmp262_ + 1;
				_tmp263_ = _body_error_type_index;
				_tmp264_ = _body_error_type_size;
				if (!(_tmp263_ < _tmp264_)) {
					break;
				}
				_tmp265_ = _body_error_type_list;
				_tmp266_ = _body_error_type_index;
				_tmp267_ = vala_list_get (_tmp265_, _tmp266_);
				body_error_type = (ValaDataType*) _tmp267_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp268_;
					gint _method_error_type_size = 0;
					ValaList* _tmp269_;
					gint _tmp270_;
					gint _tmp271_;
					gint _method_error_type_index = 0;
					_tmp268_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp268_;
					_tmp269_ = _method_error_type_list;
					_tmp270_ = vala_collection_get_size ((ValaCollection*) _tmp269_);
					_tmp271_ = _tmp270_;
					_method_error_type_size = _tmp271_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp272_;
						gint _tmp273_;
						gint _tmp274_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp275_;
						gint _tmp276_;
						gpointer _tmp277_;
						ValaDataType* _tmp278_;
						ValaDataType* _tmp279_;
						gboolean _tmp280_;
						_tmp272_ = _method_error_type_index;
						_method_error_type_index = _tmp272_ + 1;
						_tmp273_ = _method_error_type_index;
						_tmp274_ = _method_error_type_size;
						if (!(_tmp273_ < _tmp274_)) {
							break;
						}
						_tmp275_ = _method_error_type_list;
						_tmp276_ = _method_error_type_index;
						_tmp277_ = vala_list_get (_tmp275_, _tmp276_);
						method_error_type = (ValaDataType*) _tmp277_;
						_tmp278_ = body_error_type;
						_tmp279_ = method_error_type;
						_tmp280_ = vala_data_type_compatible (_tmp278_, _tmp279_);
						if (_tmp280_) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp282_ = can_propagate_error;
				if (!_tmp282_) {
					ValaDataType* _tmp283_;
					gboolean _tmp284_;
					gboolean _tmp285_;
					_tmp283_ = body_error_type;
					_tmp284_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp283_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp285_ = _tmp284_;
					_tmp281_ = !_tmp285_;
				} else {
					_tmp281_ = FALSE;
				}
				if (_tmp281_) {
					ValaDataType* _tmp286_;
					ValaSourceReference* _tmp287_;
					ValaSourceReference* _tmp288_;
					ValaDataType* _tmp289_;
					gchar* _tmp290_;
					gchar* _tmp291_;
					gchar* _tmp292_;
					gchar* _tmp293_;
					_tmp286_ = body_error_type;
					_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = body_error_type;
					_tmp290_ = vala_code_node_to_string ((ValaCodeNode*) _tmp289_);
					_tmp291_ = _tmp290_;
					_tmp292_ = g_strdup_printf ("unhandled error `%s'", _tmp291_);
					_tmp293_ = _tmp292_;
					vala_report_warning (_tmp288_, _tmp293_);
					_g_free0 (_tmp293_);
					_g_free0 (_tmp291_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp294_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp295_ = _tmp294_;
	result = !_tmp295_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


const gchar* vala_creation_method_get_class_name (ValaCreationMethod* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}


void vala_creation_method_set_class_name (ValaCreationMethod* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp1_;
}


gboolean vala_creation_method_get_chain_up (ValaCreationMethod* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_chain_up;
	result = _tmp0_;
	return result;
}


void vala_creation_method_set_chain_up (ValaCreationMethod* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_chain_up = _tmp0_;
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass) {
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_creation_method_real_check;
}


static void vala_creation_method_instance_init (ValaCreationMethod * self) {
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_finalize (ValaCodeNode * obj) {
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}


/**
 * Represents a type creation method.
 */
GType vala_creation_method_get_type (void) {
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}



