/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
enum  {
	VALA_COMPILER_0_PROPERTY,
	VALA_COMPILER_NUM_PROPERTIES
};
static GParamSpec* vala_compiler_properties[VALA_COMPILER_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_parse_color (const gchar* option_name, const gchar* val, void* data, GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[58] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gboolean vala_compiler_option_parse_color (const gchar* option_name, const gchar* val, void* data, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string (NULL)))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				GError* _tmp5_;
				_tmp4_ = val;
				_tmp5_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", _tmp4_);
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == G_OPTION_ERROR) {
					gboolean _tmp6_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp6_;
				} else {
					gboolean _tmp7_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp7_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gint _tmp4_;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_;
	ValaReport* _tmp11_;
	ValaReport* _tmp12_;
	gint _tmp13_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_;
		ValaReport* _tmp6_;
		ValaReport* _tmp7_;
		gint _tmp8_;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			gint _tmp19_;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_;
			ValaCodeContext* _tmp22_;
			ValaReport* _tmp23_;
			ValaReport* _tmp24_;
			gint _tmp25_;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_;
			ValaCodeContext* _tmp28_;
			ValaReport* _tmp29_;
			ValaReport* _tmp30_;
			gint _tmp31_;
			ValaCodeContext* _tmp32_;
			ValaReport* _tmp33_;
			ValaReport* _tmp34_;
			gint _tmp35_;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	ValaReportColored _tmp3_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	ValaCodeContext* _tmp32_;
	gboolean _tmp33_;
	ValaCodeContext* _tmp34_;
	gboolean _tmp35_;
	ValaCodeContext* _tmp36_;
	gboolean _tmp37_;
	ValaCodeContext* _tmp38_;
	gboolean _tmp39_;
	ValaCodeContext* _tmp40_;
	gboolean _tmp41_;
	ValaCodeContext* _tmp42_;
	gboolean _tmp43_;
	ValaCodeContext* _tmp44_;
	gboolean _tmp45_;
	ValaCodeContext* _tmp46_;
	gboolean _tmp47_;
	ValaCodeContext* _tmp48_;
	ValaReport* _tmp49_;
	ValaReport* _tmp50_;
	gboolean _tmp51_;
	ValaCodeContext* _tmp52_;
	ValaReport* _tmp53_;
	ValaReport* _tmp54_;
	gboolean _tmp55_;
	ValaCodeContext* _tmp56_;
	gboolean _tmp57_;
	ValaCodeContext* _tmp58_;
	gboolean _tmp59_;
	ValaCodeContext* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_;
	ValaCodeContext* _tmp65_;
	gboolean _tmp66_;
	ValaCodeContext* _tmp67_;
	const gchar* _tmp68_;
	gboolean _tmp69_ = FALSE;
	const gchar* _tmp70_;
	ValaCodeContext* _tmp72_;
	gboolean _tmp73_;
	ValaCodeContext* _tmp74_;
	const gchar* _tmp75_;
	ValaCodeContext* _tmp76_;
	const gchar* _tmp77_;
	ValaCodeContext* _tmp78_;
	const gchar* _tmp79_;
	ValaCodeContext* _tmp80_;
	const gchar* _tmp81_;
	gboolean _tmp82_ = FALSE;
	const gchar* _tmp83_;
	const gchar* _tmp85_;
	const gchar* _tmp93_;
	ValaCodeContext* _tmp102_;
	gchar** _tmp103_;
	gint _tmp103__length1;
	gchar** _tmp104_;
	gint _tmp104__length1;
	ValaCodeContext* _tmp105_;
	gboolean _tmp106_;
	ValaCodeContext* _tmp107_;
	gchar** _tmp108_;
	gint _tmp108__length1;
	gchar** _tmp109_;
	gint _tmp109__length1;
	ValaCodeContext* _tmp110_;
	gchar** _tmp111_;
	gint _tmp111__length1;
	gchar** _tmp112_;
	gint _tmp112__length1;
	ValaCodeContext* _tmp113_;
	gboolean _tmp114_;
	ValaCodeContext* _tmp115_;
	gboolean _tmp116_;
	ValaCodeContext* _tmp117_;
	gboolean _tmp118_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_;
	gboolean _tmp122_ = FALSE;
	gboolean _tmp123_ = FALSE;
	const gchar* _tmp124_;
	gboolean _tmp132_;
	const gchar* _tmp133_;
	ValaCodeContext* _tmp134_;
	gboolean _tmp135_;
	ValaCodeContext* _tmp136_;
	const gchar* _tmp137_;
	ValaCodeContext* _tmp138_;
	gboolean _tmp139_;
	gchar** _tmp140_;
	gint _tmp140__length1;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp152_ = FALSE;
	const gchar* _tmp153_;
	ValaCodeContext* _tmp156_;
	gint _tmp157_;
	ValaCodeContext* _tmp158_;
	gint _tmp159_;
	ValaCodeContext* _tmp160_;
	gint _tmp161_;
	gint _tmp162_;
	gboolean _tmp171_;
	gchar** _tmp174_;
	gint _tmp174__length1;
	gchar** _tmp179_;
	gint _tmp179__length1;
	ValaCodeContext* _tmp190_;
	gchar** _tmp191_;
	gint _tmp191__length1;
	gchar** _tmp192_;
	gint _tmp192__length1;
	ValaCodeContext* _tmp193_;
	gchar** _tmp194_;
	gint _tmp194__length1;
	gchar** _tmp195_;
	gint _tmp195__length1;
	gboolean _tmp196_ = FALSE;
	ValaCodeContext* _tmp197_;
	ValaReport* _tmp198_;
	ValaReport* _tmp199_;
	gint _tmp200_;
	ValaCodeContext* _tmp208_;
	ValaGDBusServerModule* _tmp209_;
	ValaGDBusServerModule* _tmp210_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp211_;
	gint _tmp211__length1;
	gboolean _tmp221_ = FALSE;
	gboolean _tmp222_;
	gboolean _tmp226_ = FALSE;
	ValaCodeContext* _tmp227_;
	ValaReport* _tmp228_;
	ValaReport* _tmp229_;
	gint _tmp230_;
	ValaParser* parser = NULL;
	ValaParser* _tmp238_;
	ValaParser* _tmp239_;
	ValaCodeContext* _tmp240_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp241_;
	ValaGenieParser* _tmp242_;
	ValaCodeContext* _tmp243_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp244_;
	ValaGirParser* _tmp245_;
	ValaCodeContext* _tmp246_;
	gboolean _tmp247_ = FALSE;
	ValaCodeContext* _tmp248_;
	ValaReport* _tmp249_;
	ValaReport* _tmp250_;
	gint _tmp251_;
	const gchar* _tmp259_;
	ValaCodeContext* _tmp265_;
	gboolean _tmp266_ = FALSE;
	ValaCodeContext* _tmp267_;
	ValaReport* _tmp268_;
	ValaReport* _tmp269_;
	gint _tmp270_;
	gboolean _tmp278_ = FALSE;
	gboolean _tmp279_ = FALSE;
	gboolean _tmp280_;
	const gchar* _tmp288_;
	gboolean _tmp293_ = FALSE;
	ValaCodeContext* _tmp294_;
	ValaReport* _tmp295_;
	ValaReport* _tmp296_;
	gint _tmp297_;
	ValaCodeContext* _tmp305_;
	ValaCodeGenerator* _tmp306_;
	ValaCodeGenerator* _tmp307_;
	ValaCodeContext* _tmp308_;
	gboolean _tmp309_ = FALSE;
	ValaCodeContext* _tmp310_;
	ValaReport* _tmp311_;
	ValaReport* _tmp312_;
	gint _tmp313_;
	gboolean _tmp321_ = FALSE;
	const gchar* _tmp322_;
	const gchar* _tmp326_;
	const gchar* _tmp379_;
	const gchar* _tmp393_;
	const gchar* _tmp416_;
	gboolean _tmp419_ = FALSE;
	ValaCodeContext* _tmp420_;
	ValaReport* _tmp421_;
	ValaReport* _tmp422_;
	gint _tmp423_;
	gboolean _tmp431_;
	gint _tmp455_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_colored_output;
	if (_tmp2_) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp3_ = vala_compiler_colored_output;
	if (_tmp3_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp4_;
		_tmp5_ = env_colors;
		if (_tmp5_ != NULL) {
			ValaCodeContext* _tmp6_;
			ValaReport* _tmp7_;
			ValaReport* _tmp8_;
			const gchar* _tmp9_;
			ValaReportColored _tmp10_;
			_tmp6_ = self->priv->context;
			_tmp7_ = vala_code_context_get_report (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = env_colors;
			_tmp10_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp8_, _tmp9_, _tmp10_);
		} else {
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			ValaReportColored _tmp14_;
			_tmp11_ = self->priv->context;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp13_, VALA_COMPILER_DEFAULT_COLORS, _tmp14_);
		}
	}
	_tmp17_ = vala_compiler_ccode_only;
	if (!_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = vala_compiler_compile_only;
		_tmp16_ = !_tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_;
		_tmp19_ = vala_compiler_output;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gint _tmp22_;
		_tmp20_ = vala_compiler_sources;
		_tmp20__length1 = _vala_array_length (vala_compiler_sources);
		_tmp21_ = _tmp20_[0];
		_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
		if (_tmp22_ != -1) {
			gint dot = 0;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gint _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			const gchar* _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = string_last_index_of_char (_tmp24_, (gunichar) '.', 0);
			dot = _tmp25_;
			_tmp26_ = vala_compiler_sources;
			_tmp26__length1 = _vala_array_length (vala_compiler_sources);
			_tmp27_ = _tmp26_[0];
			_tmp28_ = dot;
			_tmp29_ = string_substring (_tmp27_, (glong) 0, (glong) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_path_get_basename (_tmp30_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp31_;
			_g_free0 (_tmp30_);
		}
	}
	_tmp32_ = self->priv->context;
	_tmp33_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp32_, !_tmp33_);
	_tmp34_ = self->priv->context;
	_tmp35_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->context;
	_tmp37_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp36_, _tmp37_);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp38_, !_tmp39_);
	_tmp40_ = self->priv->context;
	_tmp41_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->context;
	_tmp43_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->context;
	_tmp45_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->context;
	_tmp47_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp46_, _tmp47_);
	_tmp48_ = self->priv->context;
	_tmp49_ = vala_code_context_get_report (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp50_, !_tmp51_);
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_code_context_get_report (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp54_, !_tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp56_, _tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp58_, !_tmp59_);
	_tmp60_ = self->priv->context;
	_tmp61_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp60_, _tmp61_);
	_tmp63_ = vala_compiler_ccode_only;
	if (_tmp63_) {
		gchar** _tmp64_;
		gint _tmp64__length1;
		_tmp64_ = vala_compiler_cc_options;
		_tmp64__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp62_ = _tmp64_ != NULL;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp65_ = self->priv->context;
	_tmp66_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->context;
	_tmp68_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp67_, _tmp68_);
	_tmp70_ = vala_compiler_header_filename;
	if (_tmp70_ == NULL) {
		gboolean _tmp71_;
		_tmp71_ = vala_compiler_use_header;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp72_ = self->priv->context;
	_tmp73_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp74_, _tmp75_);
	_tmp76_ = self->priv->context;
	_tmp77_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->context;
	_tmp79_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp78_, _tmp79_);
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_compiler_output;
	vala_code_context_set_output (_tmp80_, _tmp81_);
	_tmp83_ = vala_compiler_output;
	if (_tmp83_ != NULL) {
		gboolean _tmp84_;
		_tmp84_ = vala_compiler_ccode_only;
		_tmp82_ = _tmp84_;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp85_ = vala_compiler_basedir;
	if (_tmp85_ == NULL) {
		ValaCodeContext* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		_tmp86_ = self->priv->context;
		_tmp87_ = vala_code_context_realpath (".");
		_tmp88_ = _tmp87_;
		vala_code_context_set_basedir (_tmp86_, _tmp88_);
		_g_free0 (_tmp88_);
	} else {
		ValaCodeContext* _tmp89_;
		const gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		_tmp89_ = self->priv->context;
		_tmp90_ = vala_compiler_basedir;
		_tmp91_ = vala_code_context_realpath (_tmp90_);
		_tmp92_ = _tmp91_;
		vala_code_context_set_basedir (_tmp89_, _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp93_ = vala_compiler_directory;
	if (_tmp93_ != NULL) {
		ValaCodeContext* _tmp94_;
		const gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		_tmp94_ = self->priv->context;
		_tmp95_ = vala_compiler_directory;
		_tmp96_ = vala_code_context_realpath (_tmp95_);
		_tmp97_ = _tmp96_;
		vala_code_context_set_directory (_tmp94_, _tmp97_);
		_g_free0 (_tmp97_);
	} else {
		ValaCodeContext* _tmp98_;
		ValaCodeContext* _tmp99_;
		const gchar* _tmp100_;
		const gchar* _tmp101_;
		_tmp98_ = self->priv->context;
		_tmp99_ = self->priv->context;
		_tmp100_ = vala_code_context_get_basedir (_tmp99_);
		_tmp101_ = _tmp100_;
		vala_code_context_set_directory (_tmp98_, _tmp101_);
	}
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_directories;
	_tmp103__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp104_ = (_tmp103_ != NULL) ? _vala_array_dup1 (_tmp103_, _tmp103__length1) : ((gpointer) _tmp103_);
	_tmp104__length1 = _tmp103__length1;
	_tmp102_->vapi_directories = (_vala_array_free (_tmp102_->vapi_directories, _tmp102_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp102_->vapi_directories = _tmp104_;
	_tmp102_->vapi_directories_length1 = _tmp104__length1;
	_tmp105_ = self->priv->context;
	_tmp106_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp105_, _tmp106_);
	_tmp107_ = self->priv->context;
	_tmp108_ = vala_compiler_gir_directories;
	_tmp108__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp109_ = (_tmp108_ != NULL) ? _vala_array_dup2 (_tmp108_, _tmp108__length1) : ((gpointer) _tmp108_);
	_tmp109__length1 = _tmp108__length1;
	_tmp107_->gir_directories = (_vala_array_free (_tmp107_->gir_directories, _tmp107_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp107_->gir_directories = _tmp109_;
	_tmp107_->gir_directories_length1 = _tmp109__length1;
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_metadata_directories;
	_tmp111__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp112_ = (_tmp111_ != NULL) ? _vala_array_dup3 (_tmp111_, _tmp111__length1) : ((gpointer) _tmp111_);
	_tmp112__length1 = _tmp111__length1;
	_tmp110_->metadata_directories = (_vala_array_free (_tmp110_->metadata_directories, _tmp110_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp110_->metadata_directories = _tmp112_;
	_tmp110_->metadata_directories_length1 = _tmp112__length1;
	_tmp113_ = self->priv->context;
	_tmp114_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp113_, _tmp114_);
	_tmp115_ = self->priv->context;
	_tmp116_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp115_, _tmp116_);
	_tmp117_ = self->priv->context;
	_tmp118_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp117_, _tmp118_);
	_tmp120_ = vala_compiler_ccode_only;
	if (_tmp120_) {
		gboolean _tmp121_;
		_tmp121_ = vala_compiler_save_temps;
		_tmp119_ = _tmp121_;
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp124_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp124_, "gobject-2.0") == 0) {
		_tmp123_ = TRUE;
	} else {
		const gchar* _tmp125_;
		_tmp125_ = vala_compiler_profile;
		_tmp123_ = g_strcmp0 (_tmp125_, "gobject") == 0;
	}
	if (_tmp123_) {
		_tmp122_ = TRUE;
	} else {
		const gchar* _tmp126_;
		_tmp126_ = vala_compiler_profile;
		_tmp122_ = _tmp126_ == NULL;
	}
	if (_tmp122_) {
		ValaCodeContext* _tmp127_;
		ValaCodeContext* _tmp128_;
		_tmp127_ = self->priv->context;
		vala_code_context_set_profile (_tmp127_, VALA_PROFILE_GOBJECT);
		_tmp128_ = self->priv->context;
		vala_code_context_add_define (_tmp128_, "GOBJECT");
	} else {
		const gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		_tmp129_ = vala_compiler_profile;
		_tmp130_ = g_strdup_printf ("Unknown profile %s", _tmp129_);
		_tmp131_ = _tmp130_;
		vala_report_error (NULL, _tmp131_);
		_g_free0 (_tmp131_);
	}
	_tmp132_ = vala_compiler_nostdpkg;
	_tmp133_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp132_ | (_tmp133_ != NULL);
	_tmp134_ = self->priv->context;
	_tmp135_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp134_, _tmp135_);
	_tmp136_ = self->priv->context;
	_tmp137_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp136_, _tmp137_);
	_tmp138_ = self->priv->context;
	_tmp139_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp138_, _tmp139_);
	_tmp140_ = vala_compiler_defines;
	_tmp140__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp140_ != NULL) {
		gchar** _tmp141_;
		gint _tmp141__length1;
		_tmp141_ = vala_compiler_defines;
		_tmp141__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp141_;
			define_collection_length1 = _tmp141__length1;
			for (define_it = 0; define_it < _tmp141__length1; define_it = define_it + 1) {
				gchar* _tmp142_;
				gchar* define = NULL;
				_tmp142_ = g_strdup (define_collection[define_it]);
				define = _tmp142_;
				{
					ValaCodeContext* _tmp143_;
					const gchar* _tmp144_;
					_tmp143_ = self->priv->context;
					_tmp144_ = define;
					vala_code_context_add_define (_tmp143_, _tmp144_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp145_ = FALSE;
			_tmp145_ = TRUE;
			while (TRUE) {
				gint _tmp147_;
				ValaCodeContext* _tmp148_;
				gint _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				if (!_tmp145_) {
					gint _tmp146_;
					_tmp146_ = i;
					i = _tmp146_ + 2;
				}
				_tmp145_ = FALSE;
				_tmp147_ = i;
				if (!(_tmp147_ <= 38)) {
					break;
				}
				_tmp148_ = self->priv->context;
				_tmp149_ = i;
				_tmp150_ = g_strdup_printf ("VALA_0_%d", _tmp149_);
				_tmp151_ = _tmp150_;
				vala_code_context_add_define (_tmp148_, _tmp151_);
				_g_free0 (_tmp151_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 40;
	_tmp153_ = vala_compiler_target_glib;
	if (_tmp153_ != NULL) {
		const gchar* _tmp154_;
		gint _tmp155_;
		_tmp154_ = vala_compiler_target_glib;
		_tmp155_ = sscanf (_tmp154_, "%d.%d", &glib_major, &glib_minor);
		_tmp152_ = _tmp155_ != 2;
	} else {
		_tmp152_ = FALSE;
	}
	if (_tmp152_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp156_ = self->priv->context;
	_tmp157_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp156_, _tmp157_);
	_tmp158_ = self->priv->context;
	_tmp159_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp158_, _tmp159_);
	_tmp160_ = self->priv->context;
	_tmp161_ = vala_code_context_get_target_glib_major (_tmp160_);
	_tmp162_ = _tmp161_;
	if (_tmp162_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp163_ = FALSE;
			_tmp163_ = TRUE;
			while (TRUE) {
				gint _tmp165_;
				gint _tmp166_;
				ValaCodeContext* _tmp167_;
				gint _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				if (!_tmp163_) {
					gint _tmp164_;
					_tmp164_ = i;
					i = _tmp164_ + 2;
				}
				_tmp163_ = FALSE;
				_tmp165_ = i;
				_tmp166_ = glib_minor;
				if (!(_tmp165_ <= _tmp166_)) {
					break;
				}
				_tmp167_ = self->priv->context;
				_tmp168_ = i;
				_tmp169_ = g_strdup_printf ("GLIB_2_%d", _tmp168_);
				_tmp170_ = _tmp169_;
				vala_code_context_add_define (_tmp167_, _tmp170_);
				_g_free0 (_tmp170_);
			}
		}
	}
	_tmp171_ = vala_compiler_nostdpkg;
	if (!_tmp171_) {
		ValaCodeContext* _tmp172_;
		ValaCodeContext* _tmp173_;
		_tmp172_ = self->priv->context;
		vala_code_context_add_external_package (_tmp172_, "glib-2.0");
		_tmp173_ = self->priv->context;
		vala_code_context_add_external_package (_tmp173_, "gobject-2.0");
	}
	_tmp174_ = vala_compiler_packages;
	_tmp174__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp174_ != NULL) {
		gchar** _tmp175_;
		gint _tmp175__length1;
		_tmp175_ = vala_compiler_packages;
		_tmp175__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp175_;
			package_collection_length1 = _tmp175__length1;
			for (package_it = 0; package_it < _tmp175__length1; package_it = package_it + 1) {
				gchar* _tmp176_;
				gchar* package = NULL;
				_tmp176_ = g_strdup (package_collection[package_it]);
				package = _tmp176_;
				{
					ValaCodeContext* _tmp177_;
					const gchar* _tmp178_;
					_tmp177_ = self->priv->context;
					_tmp178_ = package;
					vala_code_context_add_external_package (_tmp177_, _tmp178_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp179_ = vala_compiler_fast_vapis;
	_tmp179__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp179_ != NULL) {
		gchar** _tmp180_;
		gint _tmp180__length1;
		ValaCodeContext* _tmp189_;
		_tmp180_ = vala_compiler_fast_vapis;
		_tmp180__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp180_;
			vapi_collection_length1 = _tmp180__length1;
			for (vapi_it = 0; vapi_it < _tmp180__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp181_;
				gchar* vapi = NULL;
				_tmp181_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp181_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp182_;
					gchar* _tmp183_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp184_;
					const gchar* _tmp185_;
					ValaSourceFile* _tmp186_;
					ValaCodeContext* _tmp187_;
					ValaSourceFile* _tmp188_;
					_tmp182_ = vapi;
					_tmp183_ = vala_code_context_realpath (_tmp182_);
					rpath = _tmp183_;
					_tmp184_ = self->priv->context;
					_tmp185_ = rpath;
					_tmp186_ = vala_source_file_new (_tmp184_, VALA_SOURCE_FILE_TYPE_FAST, _tmp185_, NULL, FALSE);
					source_file = _tmp186_;
					_tmp187_ = self->priv->context;
					_tmp188_ = source_file;
					vala_code_context_add_source_file (_tmp187_, _tmp188_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp189_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp189_, TRUE);
	}
	_tmp190_ = self->priv->context;
	_tmp191_ = vala_compiler_gresources;
	_tmp191__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp192_ = (_tmp191_ != NULL) ? _vala_array_dup4 (_tmp191_, _tmp191__length1) : ((gpointer) _tmp191_);
	_tmp192__length1 = _tmp191__length1;
	_tmp190_->gresources = (_vala_array_free (_tmp190_->gresources, _tmp190_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp190_->gresources = _tmp192_;
	_tmp190_->gresources_length1 = _tmp192__length1;
	_tmp193_ = self->priv->context;
	_tmp194_ = vala_compiler_gresources_directories;
	_tmp194__length1 = _vala_array_length (vala_compiler_gresources_directories);
	_tmp195_ = (_tmp194_ != NULL) ? _vala_array_dup5 (_tmp194_, _tmp194__length1) : ((gpointer) _tmp194_);
	_tmp195__length1 = _tmp194__length1;
	_tmp193_->gresources_directories = (_vala_array_free (_tmp193_->gresources_directories, _tmp193_->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp193_->gresources_directories = _tmp195_;
	_tmp193_->gresources_directories_length1 = _tmp195__length1;
	_tmp197_ = self->priv->context;
	_tmp198_ = vala_code_context_get_report (_tmp197_);
	_tmp199_ = _tmp198_;
	_tmp200_ = vala_report_get_errors (_tmp199_);
	if (_tmp200_ > 0) {
		_tmp196_ = TRUE;
	} else {
		gboolean _tmp201_ = FALSE;
		gboolean _tmp202_;
		_tmp202_ = vala_compiler_fatal_warnings;
		if (_tmp202_) {
			ValaCodeContext* _tmp203_;
			ValaReport* _tmp204_;
			ValaReport* _tmp205_;
			gint _tmp206_;
			_tmp203_ = self->priv->context;
			_tmp204_ = vala_code_context_get_report (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_report_get_warnings (_tmp205_);
			_tmp201_ = _tmp206_ > 0;
		} else {
			_tmp201_ = FALSE;
		}
		_tmp196_ = _tmp201_;
	}
	if (_tmp196_) {
		gint _tmp207_;
		_tmp207_ = vala_compiler_quit (self);
		result = _tmp207_;
		return result;
	}
	_tmp208_ = self->priv->context;
	_tmp209_ = vala_gd_bus_server_module_new ();
	_tmp210_ = _tmp209_;
	vala_code_context_set_codegen (_tmp208_, (ValaCodeGenerator*) _tmp210_);
	_vala_code_visitor_unref0 (_tmp210_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp211_ = vala_compiler_sources;
	_tmp211__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp211_;
		source_collection_length1 = _tmp211__length1;
		for (source_it = 0; source_it < _tmp211__length1; source_it = source_it + 1) {
			gchar* _tmp212_;
			gchar* source = NULL;
			_tmp212_ = g_strdup (source_collection[source_it]);
			source = _tmp212_;
			{
				ValaCodeContext* _tmp213_;
				const gchar* _tmp214_;
				gboolean _tmp215_;
				gboolean _tmp216_;
				_tmp213_ = self->priv->context;
				_tmp214_ = source;
				_tmp215_ = vala_compiler_run_output;
				_tmp216_ = vala_code_context_add_source_filename (_tmp213_, _tmp214_, _tmp215_, TRUE);
				if (_tmp216_) {
					const gchar* _tmp217_;
					gboolean _tmp218_;
					_tmp217_ = source;
					_tmp218_ = g_str_has_suffix (_tmp217_, ".c");
					if (_tmp218_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp219_;
						gboolean _tmp220_;
						_tmp219_ = source;
						_tmp220_ = g_str_has_suffix (_tmp219_, ".h");
						if (_tmp220_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp222_ = vala_compiler_ccode_only;
	if (_tmp222_) {
		gboolean _tmp223_ = FALSE;
		gboolean _tmp224_;
		_tmp224_ = has_c_files;
		if (_tmp224_) {
			_tmp223_ = TRUE;
		} else {
			gboolean _tmp225_;
			_tmp225_ = has_h_files;
			_tmp223_ = _tmp225_;
		}
		_tmp221_ = _tmp223_;
	} else {
		_tmp221_ = FALSE;
	}
	if (_tmp221_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp227_ = self->priv->context;
	_tmp228_ = vala_code_context_get_report (_tmp227_);
	_tmp229_ = _tmp228_;
	_tmp230_ = vala_report_get_errors (_tmp229_);
	if (_tmp230_ > 0) {
		_tmp226_ = TRUE;
	} else {
		gboolean _tmp231_ = FALSE;
		gboolean _tmp232_;
		_tmp232_ = vala_compiler_fatal_warnings;
		if (_tmp232_) {
			ValaCodeContext* _tmp233_;
			ValaReport* _tmp234_;
			ValaReport* _tmp235_;
			gint _tmp236_;
			_tmp233_ = self->priv->context;
			_tmp234_ = vala_code_context_get_report (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp236_ = vala_report_get_warnings (_tmp235_);
			_tmp231_ = _tmp236_ > 0;
		} else {
			_tmp231_ = FALSE;
		}
		_tmp226_ = _tmp231_;
	}
	if (_tmp226_) {
		gint _tmp237_;
		_tmp237_ = vala_compiler_quit (self);
		result = _tmp237_;
		return result;
	}
	_tmp238_ = vala_parser_new ();
	parser = _tmp238_;
	_tmp239_ = parser;
	_tmp240_ = self->priv->context;
	vala_parser_parse (_tmp239_, _tmp240_);
	_tmp241_ = vala_genie_parser_new ();
	genie_parser = _tmp241_;
	_tmp242_ = genie_parser;
	_tmp243_ = self->priv->context;
	vala_genie_parser_parse (_tmp242_, _tmp243_);
	_tmp244_ = vala_gir_parser_new ();
	gir_parser = _tmp244_;
	_tmp245_ = gir_parser;
	_tmp246_ = self->priv->context;
	vala_gir_parser_parse (_tmp245_, _tmp246_);
	_tmp248_ = self->priv->context;
	_tmp249_ = vala_code_context_get_report (_tmp248_);
	_tmp250_ = _tmp249_;
	_tmp251_ = vala_report_get_errors (_tmp250_);
	if (_tmp251_ > 0) {
		_tmp247_ = TRUE;
	} else {
		gboolean _tmp252_ = FALSE;
		gboolean _tmp253_;
		_tmp253_ = vala_compiler_fatal_warnings;
		if (_tmp253_) {
			ValaCodeContext* _tmp254_;
			ValaReport* _tmp255_;
			ValaReport* _tmp256_;
			gint _tmp257_;
			_tmp254_ = self->priv->context;
			_tmp255_ = vala_code_context_get_report (_tmp254_);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_report_get_warnings (_tmp256_);
			_tmp252_ = _tmp257_ > 0;
		} else {
			_tmp252_ = FALSE;
		}
		_tmp247_ = _tmp252_;
	}
	if (_tmp247_) {
		gint _tmp258_;
		_tmp258_ = vala_compiler_quit (self);
		result = _tmp258_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp259_ = vala_compiler_fast_vapi_filename;
	if (_tmp259_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp260_;
		ValaCodeWriter* _tmp261_;
		ValaCodeContext* _tmp262_;
		const gchar* _tmp263_;
		gint _tmp264_;
		_tmp260_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp260_;
		_tmp261_ = interface_writer;
		_tmp262_ = self->priv->context;
		_tmp263_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp261_, _tmp262_, _tmp263_);
		_tmp264_ = vala_compiler_quit (self);
		result = _tmp264_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp265_ = self->priv->context;
	vala_code_context_check (_tmp265_);
	_tmp267_ = self->priv->context;
	_tmp268_ = vala_code_context_get_report (_tmp267_);
	_tmp269_ = _tmp268_;
	_tmp270_ = vala_report_get_errors (_tmp269_);
	if (_tmp270_ > 0) {
		_tmp266_ = TRUE;
	} else {
		gboolean _tmp271_ = FALSE;
		gboolean _tmp272_;
		_tmp272_ = vala_compiler_fatal_warnings;
		if (_tmp272_) {
			ValaCodeContext* _tmp273_;
			ValaReport* _tmp274_;
			ValaReport* _tmp275_;
			gint _tmp276_;
			_tmp273_ = self->priv->context;
			_tmp274_ = vala_code_context_get_report (_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp276_ = vala_report_get_warnings (_tmp275_);
			_tmp271_ = _tmp276_ > 0;
		} else {
			_tmp271_ = FALSE;
		}
		_tmp266_ = _tmp271_;
	}
	if (_tmp266_) {
		gint _tmp277_;
		_tmp277_ = vala_compiler_quit (self);
		result = _tmp277_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp280_ = vala_compiler_ccode_only;
	if (!_tmp280_) {
		gboolean _tmp281_;
		_tmp281_ = vala_compiler_compile_only;
		_tmp279_ = !_tmp281_;
	} else {
		_tmp279_ = FALSE;
	}
	if (_tmp279_) {
		const gchar* _tmp282_;
		_tmp282_ = vala_compiler_library;
		_tmp278_ = _tmp282_ == NULL;
	} else {
		_tmp278_ = FALSE;
	}
	if (_tmp278_) {
		gboolean _tmp283_ = FALSE;
		gboolean _tmp284_;
		_tmp284_ = has_c_files;
		if (!_tmp284_) {
			ValaCodeContext* _tmp285_;
			ValaMethod* _tmp286_;
			ValaMethod* _tmp287_;
			_tmp285_ = self->priv->context;
			_tmp286_ = vala_code_context_get_entry_point (_tmp285_);
			_tmp287_ = _tmp286_;
			_tmp283_ = _tmp287_ == NULL;
		} else {
			_tmp283_ = FALSE;
		}
		if (_tmp283_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp288_ = vala_compiler_dump_tree;
	if (_tmp288_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp289_;
		ValaCodeWriter* _tmp290_;
		ValaCodeContext* _tmp291_;
		const gchar* _tmp292_;
		_tmp289_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp289_;
		_tmp290_ = code_writer;
		_tmp291_ = self->priv->context;
		_tmp292_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp290_, _tmp291_, _tmp292_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp294_ = self->priv->context;
	_tmp295_ = vala_code_context_get_report (_tmp294_);
	_tmp296_ = _tmp295_;
	_tmp297_ = vala_report_get_errors (_tmp296_);
	if (_tmp297_ > 0) {
		_tmp293_ = TRUE;
	} else {
		gboolean _tmp298_ = FALSE;
		gboolean _tmp299_;
		_tmp299_ = vala_compiler_fatal_warnings;
		if (_tmp299_) {
			ValaCodeContext* _tmp300_;
			ValaReport* _tmp301_;
			ValaReport* _tmp302_;
			gint _tmp303_;
			_tmp300_ = self->priv->context;
			_tmp301_ = vala_code_context_get_report (_tmp300_);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_report_get_warnings (_tmp302_);
			_tmp298_ = _tmp303_ > 0;
		} else {
			_tmp298_ = FALSE;
		}
		_tmp293_ = _tmp298_;
	}
	if (_tmp293_) {
		gint _tmp304_;
		_tmp304_ = vala_compiler_quit (self);
		result = _tmp304_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp305_ = self->priv->context;
	_tmp306_ = vala_code_context_get_codegen (_tmp305_);
	_tmp307_ = _tmp306_;
	_tmp308_ = self->priv->context;
	vala_code_generator_emit (_tmp307_, _tmp308_);
	_tmp310_ = self->priv->context;
	_tmp311_ = vala_code_context_get_report (_tmp310_);
	_tmp312_ = _tmp311_;
	_tmp313_ = vala_report_get_errors (_tmp312_);
	if (_tmp313_ > 0) {
		_tmp309_ = TRUE;
	} else {
		gboolean _tmp314_ = FALSE;
		gboolean _tmp315_;
		_tmp315_ = vala_compiler_fatal_warnings;
		if (_tmp315_) {
			ValaCodeContext* _tmp316_;
			ValaReport* _tmp317_;
			ValaReport* _tmp318_;
			gint _tmp319_;
			_tmp316_ = self->priv->context;
			_tmp317_ = vala_code_context_get_report (_tmp316_);
			_tmp318_ = _tmp317_;
			_tmp319_ = vala_report_get_warnings (_tmp318_);
			_tmp314_ = _tmp319_ > 0;
		} else {
			_tmp314_ = FALSE;
		}
		_tmp309_ = _tmp314_;
	}
	if (_tmp309_) {
		gint _tmp320_;
		_tmp320_ = vala_compiler_quit (self);
		result = _tmp320_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp322_ = vala_compiler_vapi_filename;
	if (_tmp322_ == NULL) {
		const gchar* _tmp323_;
		_tmp323_ = vala_compiler_library;
		_tmp321_ = _tmp323_ != NULL;
	} else {
		_tmp321_ = FALSE;
	}
	if (_tmp321_) {
		const gchar* _tmp324_;
		gchar* _tmp325_;
		_tmp324_ = vala_compiler_library;
		_tmp325_ = g_strdup_printf ("%s.vapi", _tmp324_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp325_;
	}
	_tmp326_ = vala_compiler_library;
	if (_tmp326_ != NULL) {
		const gchar* _tmp327_;
		_tmp327_ = vala_compiler_gir;
		if (_tmp327_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp328_;
			gchar* _tmp329_;
			glong gir_len = 0L;
			const gchar* _tmp330_;
			gint _tmp331_;
			gint _tmp332_;
			gint last_hyphen = 0;
			const gchar* _tmp333_;
			gint _tmp334_;
			gboolean _tmp335_ = FALSE;
			gint _tmp336_;
			_tmp328_ = vala_compiler_gir;
			_tmp329_ = g_path_get_basename (_tmp328_);
			gir_base = _tmp329_;
			_tmp330_ = gir_base;
			_tmp331_ = strlen (_tmp330_);
			_tmp332_ = _tmp331_;
			gir_len = (glong) _tmp332_;
			_tmp333_ = gir_base;
			_tmp334_ = string_last_index_of_char (_tmp333_, (gunichar) '-', 0);
			last_hyphen = _tmp334_;
			_tmp336_ = last_hyphen;
			if (_tmp336_ == -1) {
				_tmp335_ = TRUE;
			} else {
				const gchar* _tmp337_;
				gboolean _tmp338_;
				_tmp337_ = gir_base;
				_tmp338_ = g_str_has_suffix (_tmp337_, ".gir");
				_tmp335_ = !_tmp338_;
			}
			if (_tmp335_) {
				const gchar* _tmp339_;
				gchar* _tmp340_;
				gchar* _tmp341_;
				_tmp339_ = vala_compiler_gir;
				_tmp340_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp339_);
				_tmp341_ = _tmp340_;
				vala_report_error (NULL, _tmp341_);
				_g_free0 (_tmp341_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp342_;
				gint _tmp343_;
				gchar* _tmp344_;
				gchar* gir_version = NULL;
				const gchar* _tmp345_;
				gint _tmp346_;
				glong _tmp347_;
				gint _tmp348_;
				gchar* _tmp349_;
				const gchar* _tmp350_;
				gboolean _tmp351_ = FALSE;
				gboolean _tmp352_ = FALSE;
				gboolean _tmp353_ = FALSE;
				const gchar* _tmp354_;
				_tmp342_ = gir_base;
				_tmp343_ = last_hyphen;
				_tmp344_ = string_substring (_tmp342_, (glong) 0, (glong) _tmp343_);
				gir_namespace = _tmp344_;
				_tmp345_ = gir_base;
				_tmp346_ = last_hyphen;
				_tmp347_ = gir_len;
				_tmp348_ = last_hyphen;
				_tmp349_ = string_substring (_tmp345_, (glong) (_tmp346_ + 1), (_tmp347_ - _tmp348_) - 5);
				gir_version = _tmp349_;
				_tmp350_ = gir_version;
				g_strcanon (_tmp350_, "0123456789.", '?');
				_tmp354_ = gir_namespace;
				if (g_strcmp0 (_tmp354_, "") == 0) {
					_tmp353_ = TRUE;
				} else {
					const gchar* _tmp355_;
					_tmp355_ = gir_version;
					_tmp353_ = g_strcmp0 (_tmp355_, "") == 0;
				}
				if (_tmp353_) {
					_tmp352_ = TRUE;
				} else {
					const gchar* _tmp356_;
					gchar _tmp357_;
					gboolean _tmp358_;
					_tmp356_ = gir_version;
					_tmp357_ = string_get (_tmp356_, (glong) 0);
					_tmp358_ = g_ascii_isdigit (_tmp357_);
					_tmp352_ = !_tmp358_;
				}
				if (_tmp352_) {
					_tmp351_ = TRUE;
				} else {
					const gchar* _tmp359_;
					gboolean _tmp360_;
					_tmp359_ = gir_version;
					_tmp360_ = string_contains (_tmp359_, "?");
					_tmp351_ = _tmp360_;
				}
				if (_tmp351_) {
					const gchar* _tmp361_;
					gchar* _tmp362_;
					gchar* _tmp363_;
					_tmp361_ = vala_compiler_gir;
					_tmp362_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp361_);
					_tmp363_ = _tmp362_;
					vala_report_error (NULL, _tmp363_);
					_g_free0 (_tmp363_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp364_;
					gchar* gir_directory = NULL;
					gchar* _tmp365_;
					const gchar* _tmp366_;
					ValaGIRWriter* _tmp371_;
					ValaCodeContext* _tmp372_;
					const gchar* _tmp373_;
					const gchar* _tmp374_;
					const gchar* _tmp375_;
					const gchar* _tmp376_;
					const gchar* _tmp377_;
					const gchar* _tmp378_;
					_tmp364_ = vala_gir_writer_new ();
					gir_writer = _tmp364_;
					_tmp365_ = g_strdup (".");
					gir_directory = _tmp365_;
					_tmp366_ = vala_compiler_directory;
					if (_tmp366_ != NULL) {
						ValaCodeContext* _tmp367_;
						const gchar* _tmp368_;
						const gchar* _tmp369_;
						gchar* _tmp370_;
						_tmp367_ = self->priv->context;
						_tmp368_ = vala_code_context_get_directory (_tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = g_strdup (_tmp369_);
						_g_free0 (gir_directory);
						gir_directory = _tmp370_;
					}
					_tmp371_ = gir_writer;
					_tmp372_ = self->priv->context;
					_tmp373_ = gir_directory;
					_tmp374_ = vala_compiler_gir;
					_tmp375_ = gir_namespace;
					_tmp376_ = gir_version;
					_tmp377_ = vala_compiler_library;
					_tmp378_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp371_, _tmp372_, _tmp373_, _tmp374_, _tmp375_, _tmp376_, _tmp377_, _tmp378_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp379_ = vala_compiler_vapi_filename;
	if (_tmp379_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp380_;
		gboolean _tmp381_ = FALSE;
		const gchar* _tmp382_;
		ValaCodeWriter* _tmp390_;
		ValaCodeContext* _tmp391_;
		const gchar* _tmp392_;
		_tmp380_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp380_;
		_tmp382_ = vala_compiler_directory;
		if (_tmp382_ != NULL) {
			const gchar* _tmp383_;
			gboolean _tmp384_;
			_tmp383_ = vala_compiler_vapi_filename;
			_tmp384_ = g_path_is_absolute (_tmp383_);
			_tmp381_ = !_tmp384_;
		} else {
			_tmp381_ = FALSE;
		}
		if (_tmp381_) {
			ValaCodeContext* _tmp385_;
			const gchar* _tmp386_;
			const gchar* _tmp387_;
			const gchar* _tmp388_;
			gchar* _tmp389_;
			_tmp385_ = self->priv->context;
			_tmp386_ = vala_code_context_get_directory (_tmp385_);
			_tmp387_ = _tmp386_;
			_tmp388_ = vala_compiler_vapi_filename;
			_tmp389_ = g_strdup_printf ("%s%c%s", _tmp387_, (gint) G_DIR_SEPARATOR, _tmp388_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp389_;
		}
		_tmp390_ = interface_writer;
		_tmp391_ = self->priv->context;
		_tmp392_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp390_, _tmp391_, _tmp392_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp393_ = vala_compiler_internal_vapi_filename;
	if (_tmp393_ != NULL) {
		gboolean _tmp394_ = FALSE;
		const gchar* _tmp395_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp398_;
		ValaCodeWriter* _tmp399_;
		const gchar* _tmp400_;
		const gchar* _tmp401_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp402_;
		gchar* _tmp403_;
		gboolean _tmp404_ = FALSE;
		const gchar* _tmp405_;
		ValaCodeWriter* _tmp413_;
		ValaCodeContext* _tmp414_;
		const gchar* _tmp415_;
		_tmp395_ = vala_compiler_internal_header_filename;
		if (_tmp395_ == NULL) {
			_tmp394_ = TRUE;
		} else {
			const gchar* _tmp396_;
			_tmp396_ = vala_compiler_header_filename;
			_tmp394_ = _tmp396_ == NULL;
		}
		if (_tmp394_) {
			gint _tmp397_;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp397_ = vala_compiler_quit (self);
			result = _tmp397_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp398_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp398_;
		_tmp399_ = interface_writer;
		_tmp400_ = vala_compiler_header_filename;
		_tmp401_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp399_, _tmp400_, _tmp401_);
		_tmp402_ = vala_compiler_internal_vapi_filename;
		_tmp403_ = g_strdup (_tmp402_);
		vapi_filename = _tmp403_;
		_tmp405_ = vala_compiler_directory;
		if (_tmp405_ != NULL) {
			const gchar* _tmp406_;
			gboolean _tmp407_;
			_tmp406_ = vapi_filename;
			_tmp407_ = g_path_is_absolute (_tmp406_);
			_tmp404_ = !_tmp407_;
		} else {
			_tmp404_ = FALSE;
		}
		if (_tmp404_) {
			ValaCodeContext* _tmp408_;
			const gchar* _tmp409_;
			const gchar* _tmp410_;
			const gchar* _tmp411_;
			gchar* _tmp412_;
			_tmp408_ = self->priv->context;
			_tmp409_ = vala_code_context_get_directory (_tmp408_);
			_tmp410_ = _tmp409_;
			_tmp411_ = vapi_filename;
			_tmp412_ = g_strdup_printf ("%s%c%s", _tmp410_, (gint) G_DIR_SEPARATOR, _tmp411_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp412_;
		}
		_tmp413_ = interface_writer;
		_tmp414_ = self->priv->context;
		_tmp415_ = vapi_filename;
		vala_code_writer_write_file (_tmp413_, _tmp414_, _tmp415_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp416_ = vala_compiler_dependencies;
	if (_tmp416_ != NULL) {
		ValaCodeContext* _tmp417_;
		const gchar* _tmp418_;
		_tmp417_ = self->priv->context;
		_tmp418_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp417_, _tmp418_);
	}
	_tmp420_ = self->priv->context;
	_tmp421_ = vala_code_context_get_report (_tmp420_);
	_tmp422_ = _tmp421_;
	_tmp423_ = vala_report_get_errors (_tmp422_);
	if (_tmp423_ > 0) {
		_tmp419_ = TRUE;
	} else {
		gboolean _tmp424_ = FALSE;
		gboolean _tmp425_;
		_tmp425_ = vala_compiler_fatal_warnings;
		if (_tmp425_) {
			ValaCodeContext* _tmp426_;
			ValaReport* _tmp427_;
			ValaReport* _tmp428_;
			gint _tmp429_;
			_tmp426_ = self->priv->context;
			_tmp427_ = vala_code_context_get_report (_tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_report_get_warnings (_tmp428_);
			_tmp424_ = _tmp429_ > 0;
		} else {
			_tmp424_ = FALSE;
		}
		_tmp419_ = _tmp424_;
	}
	if (_tmp419_) {
		gint _tmp430_;
		_tmp430_ = vala_compiler_quit (self);
		result = _tmp430_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp431_ = vala_compiler_ccode_only;
	if (!_tmp431_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp432_;
		gboolean _tmp433_ = FALSE;
		const gchar* _tmp434_;
		gboolean _tmp438_ = FALSE;
		const gchar* _tmp439_;
		gchar** _tmp443_;
		gint _tmp443__length1;
		_tmp432_ = vala_ccode_compiler_new ();
		ccompiler = _tmp432_;
		_tmp434_ = vala_compiler_cc_command;
		if (_tmp434_ == NULL) {
			const gchar* _tmp435_;
			_tmp435_ = g_getenv ("CC");
			_tmp433_ = _tmp435_ != NULL;
		} else {
			_tmp433_ = FALSE;
		}
		if (_tmp433_) {
			const gchar* _tmp436_;
			gchar* _tmp437_;
			_tmp436_ = g_getenv ("CC");
			_tmp437_ = g_strdup (_tmp436_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp437_;
		}
		_tmp439_ = vala_compiler_pkg_config_command;
		if (_tmp439_ == NULL) {
			const gchar* _tmp440_;
			_tmp440_ = g_getenv ("PKG_CONFIG");
			_tmp438_ = _tmp440_ != NULL;
		} else {
			_tmp438_ = FALSE;
		}
		if (_tmp438_) {
			const gchar* _tmp441_;
			gchar* _tmp442_;
			_tmp441_ = g_getenv ("PKG_CONFIG");
			_tmp442_ = g_strdup (_tmp441_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp442_;
		}
		_tmp443_ = vala_compiler_cc_options;
		_tmp443__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp443_ == NULL) {
			ValaCCodeCompiler* _tmp444_;
			ValaCodeContext* _tmp445_;
			const gchar* _tmp446_;
			gchar** _tmp447_;
			gchar** _tmp448_;
			gint _tmp448__length1;
			const gchar* _tmp449_;
			_tmp444_ = ccompiler;
			_tmp445_ = self->priv->context;
			_tmp446_ = vala_compiler_cc_command;
			_tmp447_ = g_new0 (gchar*, 0 + 1);
			_tmp448_ = _tmp447_;
			_tmp448__length1 = 0;
			_tmp449_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp444_, _tmp445_, _tmp446_, _tmp448_, 0, _tmp449_);
			_tmp448_ = (_vala_array_free (_tmp448_, _tmp448__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp450_;
			ValaCodeContext* _tmp451_;
			const gchar* _tmp452_;
			gchar** _tmp453_;
			gint _tmp453__length1;
			const gchar* _tmp454_;
			_tmp450_ = ccompiler;
			_tmp451_ = self->priv->context;
			_tmp452_ = vala_compiler_cc_command;
			_tmp453_ = vala_compiler_cc_options;
			_tmp453__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp454_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp450_, _tmp451_, _tmp452_, _tmp453_, _tmp453__length1, _tmp454_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp455_ = vala_compiler_quit (self);
	result = _tmp455_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp32_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gint _tmp37_;
	const gchar* _tmp38_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	const gchar* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gint _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gint outputfd = 0;
	const gchar* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp55_;
	gint ret = 0;
	ValaCompiler* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	const gchar* _tmp60_;
	gint _tmp61_;
	gchar** target_args = NULL;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar** _tmp65_;
	gint target_args_length1;
	gint _target_args_size_;
	gint _tmp85_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp31_;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_ = NULL;
			gint _tmp13_;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp15_;
			GOptionContext* _tmp16_;
			GOptionContext* _tmp17_;
			gchar** temp_args = NULL;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gint temp_args_length1;
			gint _temp_args_size_;
			GOptionContext* _tmp19_;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp14_ = 0;
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp14_;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp20_ = 0;
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp20_;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = stdout;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			fprintf (_tmp21_, "%s\n", _tmp23_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp24_;
			GError* _tmp25_;
			const gchar* _tmp26_;
			FILE* _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = stdout;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			fprintf (_tmp24_, "%s\n", _tmp26_);
			_tmp27_ = stdout;
			_tmp28_ = args;
			_tmp28__length1 = args_length1;
			_tmp29_ = _tmp28_[0];
			fprintf (_tmp27_, "Run '%s --help' to see a full list of available command line options.\n", _tmp29_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp30_ = 0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp30_;
		}
		_tmp31_ = i;
		i = _tmp31_ + 1;
	}
	_tmp32_ = vala_compiler_version;
	if (_tmp32_) {
		FILE* _tmp33_;
		_tmp33_ = stdout;
		fprintf (_tmp33_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp34_;
		_tmp34_ = vala_compiler_api_version;
		if (_tmp34_) {
			FILE* _tmp35_;
			_tmp35_ = stdout;
			fprintf (_tmp35_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp36_ = args;
	_tmp36__length1 = args_length1;
	_tmp37_ = i;
	_tmp38_ = _tmp36_[_tmp37_];
	if (_tmp38_ == NULL) {
		FILE* _tmp39_;
		_tmp39_ = stderr;
		fprintf (_tmp39_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_strdup (_tmp42_);
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp44_;
	_tmp45_ = g_get_tmp_dir ();
	_tmp46_ = args;
	_tmp46__length1 = args_length1;
	_tmp47_ = i;
	_tmp48_ = _tmp46_[_tmp47_];
	_tmp49_ = g_path_get_basename (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp45_, _tmp50_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp51_;
	_g_free0 (_tmp50_);
	_tmp52_ = vala_compiler_output;
	_tmp53_ = g_mkstemp (_tmp52_);
	outputfd = _tmp53_;
	_tmp54_ = outputfd;
	if (_tmp54_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp55_ = vala_compiler_new ();
	compiler = _tmp55_;
	_tmp56_ = compiler;
	_tmp57_ = vala_compiler_run (_tmp56_);
	ret = _tmp57_;
	_tmp58_ = ret;
	if (_tmp58_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp59_ = outputfd;
	close (_tmp59_);
	_tmp60_ = vala_compiler_output;
	_tmp61_ = g_chmod (_tmp60_, 0700);
	if (_tmp61_ != 0) {
		const gchar* _tmp62_;
		_tmp62_ = vala_compiler_output;
		g_unlink (_tmp62_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp63_ = vala_compiler_output;
	_tmp64_ = g_strdup (_tmp63_);
	_tmp65_ = g_new0 (gchar*, 1 + 1);
	_tmp65_[0] = _tmp64_;
	target_args = _tmp65_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp66_;
		gchar** _tmp67_;
		gint _tmp67__length1;
		gchar** _tmp68_;
		gint _tmp68__length1;
		gchar** _tmp69_;
		gint _tmp69__length1;
		gint _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		gint _tmp73_;
		_tmp66_ = i;
		_tmp67_ = args;
		_tmp67__length1 = args_length1;
		if (!(_tmp66_ < _tmp67__length1)) {
			break;
		}
		_tmp68_ = target_args;
		_tmp68__length1 = target_args_length1;
		_tmp69_ = args;
		_tmp69__length1 = args_length1;
		_tmp70_ = i;
		_tmp71_ = _tmp69_[_tmp70_];
		_tmp72_ = g_strdup (_tmp71_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp72_);
		_tmp73_ = i;
		i = _tmp73_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp74_;
		gchar** _tmp75_;
		gint _tmp75__length1;
		GPid _tmp76_ = 0;
		const gchar* _tmp78_;
		GPid _tmp79_;
		GMainLoop* _tmp80_;
		gint _tmp81_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp74_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp74_;
		_data1_->child_status = 0;
		_tmp75_ = target_args;
		_tmp75__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp75_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp76_, &_inner_error_);
		pid = _tmp76_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp77_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp77_;
		}
		_tmp78_ = vala_compiler_output;
		g_unlink (_tmp78_);
		_tmp79_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp79_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp80_ = _data1_->loop;
		g_main_loop_run (_tmp80_);
		_tmp81_ = _data1_->child_status;
		result = _tmp81_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp82_;
		GError* _tmp83_;
		const gchar* _tmp84_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp82_ = stdout;
		_tmp83_ = e;
		_tmp84_ = _tmp83_->message;
		fprintf (_tmp82_, "%s\n", _tmp84_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp85_;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp24_;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_;
	gint _tmp29__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_;
	ValaCompiler* _tmp33_;
	gint _tmp34_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_;
		GOptionContext* _tmp13_;
		GOptionContext* _tmp14_;
		GOptionContext* _tmp15_;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp16_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp16_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp23_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp23_;
	}
	_tmp24_ = vala_compiler_version;
	if (_tmp24_) {
		FILE* _tmp25_;
		_tmp25_ = stdout;
		fprintf (_tmp25_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp26_;
		_tmp26_ = vala_compiler_api_version;
		if (_tmp26_) {
			FILE* _tmp27_;
			_tmp27_ = stdout;
			fprintf (_tmp27_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	return vala_compiler_main (argv, argc);
}


G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler * obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance) {
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



