/* timsort.c generated by valac, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include "valagee.h"
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_TIM_SORT (vala_tim_sort_get_type ())
#define VALA_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TIM_SORT, ValaTimSort))
#define VALA_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TIM_SORT, ValaTimSortClass))
#define VALA_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TIM_SORT))
#define VALA_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TIM_SORT))
#define VALA_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TIM_SORT, ValaTimSortClass))

typedef struct _ValaTimSort ValaTimSort;
typedef struct _ValaTimSortClass ValaTimSortClass;
typedef struct _ValaTimSortPrivate ValaTimSortPrivate;
typedef struct _ValaTimSortSlice ValaTimSortSlice;
enum  {
	VALA_TIM_SORT_0_PROPERTY,
	VALA_TIM_SORT_NUM_PROPERTIES
};
static GParamSpec* vala_tim_sort_properties[VALA_TIM_SORT_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
#define _vala_tim_sort_unref0(var) ((var == NULL) ? NULL : (var = (vala_tim_sort_unref (var), NULL)))
#define _vala_tim_sort_slice_free0(var) ((var == NULL) ? NULL : (var = (vala_tim_sort_slice_free (var), NULL)))
typedef struct _ValaParamSpecTimSort ValaParamSpecTimSort;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaTimSort {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTimSortPrivate * priv;
};

struct _ValaTimSortClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTimSort *self);
};

struct _ValaTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	ValaList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	ValaTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareDataFunc compare;
	gpointer compare_target;
};

struct _ValaTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

typedef gboolean (*ValaTimSortLowerFunc) (gconstpointer left, gconstpointer right, void* user_data);
struct _ValaParamSpecTimSort {
	GParamSpec parent_instance;
};


static gpointer vala_tim_sort_parent_class = NULL;

G_GNUC_INTERNAL gpointer vala_tim_sort_ref (gpointer instance);
G_GNUC_INTERNAL void vala_tim_sort_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_tim_sort (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_tim_sort (GValue* value, gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_tim_sort (GValue* value, gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_tim_sort (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_tim_sort_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_tim_sort_slice_free (ValaTimSortSlice * self);
#define VALA_TIM_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TIM_SORT, ValaTimSortPrivate))
#define VALA_TIM_SORT_MINIMUM_GALLOP 7
G_GNUC_INTERNAL void vala_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaList* list, GCompareDataFunc compare, void* compare_target);
static void vala_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaArrayList* list, GCompareDataFunc compare, void* compare_target);
static void vala_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaList* list, GCompareDataFunc compare, void* compare_target);
G_GNUC_INTERNAL ValaTimSort* vala_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
G_GNUC_INTERNAL ValaTimSort* vala_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void vala_tim_sort_do_sort (ValaTimSort* self);
static ValaTimSortSlice* vala_tim_sort_slice_new (void** list, gint index, gint length);
static gint vala_tim_sort_compute_minimum_run_length (ValaTimSort* self, gint length);
static ValaTimSortSlice* vala_tim_sort_compute_longest_run (ValaTimSort* self, ValaTimSortSlice* a, gboolean* descending);
static void vala_tim_sort_slice_reverse (ValaTimSortSlice* self);
static void vala_tim_sort_insertion_sort (ValaTimSort* self, ValaTimSortSlice* a, gint offset);
static inline void vala_tim_sort_slice_shorten_start (ValaTimSortSlice* self, gint n);
static void _vala_array_add1 (ValaTimSortSlice** * array, int* length, int* size, ValaTimSortSlice* value);
static void vala_tim_sort_merge_collapse (ValaTimSort* self);
static void vala_tim_sort_merge_force_collapse (ValaTimSort* self);
static inline gboolean vala_tim_sort_lower_than (ValaTimSort* self, gconstpointer left, gconstpointer right);
static inline gboolean vala_tim_sort_lower_than_or_equal_to (ValaTimSort* self, gconstpointer left, gconstpointer right);
static void vala_tim_sort_merge_at (ValaTimSort* self, gint index);
static gint vala_tim_sort_gallop_rightmost (ValaTimSort* self, gconstpointer key, ValaTimSortSlice* a, gint hint);
static inline void* vala_tim_sort_slice_peek_first (ValaTimSortSlice* self);
static gint vala_tim_sort_gallop_leftmost (ValaTimSort* self, gconstpointer key, ValaTimSortSlice* a, gint hint);
static inline void* vala_tim_sort_slice_peek_last (ValaTimSortSlice* self);
static void vala_tim_sort_merge_low (ValaTimSort* self, ValaTimSortSlice* a, ValaTimSortSlice* b);
static void vala_tim_sort_merge_high (ValaTimSort* self, ValaTimSortSlice* a, ValaTimSortSlice* b);
static void vala_tim_sort_slice_copy (ValaTimSortSlice* self);
static inline void* vala_tim_sort_slice_pop_first (ValaTimSortSlice* self);
static inline void vala_tim_sort_slice_merge_in (ValaTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void* vala_tim_sort_slice_pop_last (ValaTimSortSlice* self);
static inline void vala_tim_sort_slice_merge_in_reversed (ValaTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void vala_tim_sort_slice_shorten_end (ValaTimSortSlice* self, gint n);
static void vala_tim_sort_slice_instance_init (ValaTimSortSlice * self);
static inline void vala_tim_sort_slice_swap (ValaTimSortSlice* self, gint i, gint j);
static void vala_tim_sort_finalize (ValaTimSort * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


G_GNUC_INTERNAL void vala_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaList* list, GCompareDataFunc compare, void* compare_target) {
	ValaList* _tmp0_;
	g_return_if_fail (list != NULL);
	_tmp0_ = list;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ARRAY_LIST)) {
		ValaList* _tmp1_;
		GCompareDataFunc _tmp2_;
		void* _tmp2__target;
		_tmp1_ = list;
		_tmp2_ = compare;
		_tmp2__target = compare_target;
		vala_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ARRAY_LIST, ValaArrayList), _tmp2_, _tmp2__target);
	} else {
		ValaList* _tmp3_;
		GCompareDataFunc _tmp4_;
		void* _tmp4__target;
		_tmp3_ = list;
		_tmp4_ = compare;
		_tmp4__target = compare_target;
		vala_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp3_, _tmp4_, _tmp4__target);
	}
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vala_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaList* list, GCompareDataFunc compare, void* compare_target) {
	ValaTimSort* helper = NULL;
	ValaTimSort* _tmp0_;
	ValaTimSort* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValaTimSort* _tmp4_;
	ValaList* _tmp5_;
	gint _tmp6_;
	gpointer* _tmp7_;
	ValaTimSort* _tmp8_;
	ValaTimSort* _tmp9_;
	gpointer* _tmp10_;
	gint _tmp10__length1;
	ValaTimSort* _tmp11_;
	ValaTimSort* _tmp12_;
	ValaList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	ValaTimSort* _tmp16_;
	GCompareDataFunc _tmp17_;
	void* _tmp17__target;
	ValaTimSort* _tmp18_;
	ValaList* _tmp19_;
	ValaTimSort* _tmp20_;
	gpointer* _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = helper;
	_tmp2_ = list;
	_tmp3_ = _vala_iterable_ref0 (_tmp2_);
	_vala_iterable_unref0 (_tmp1_->priv->list_collection);
	_tmp1_->priv->list_collection = _tmp3_;
	_tmp4_ = helper;
	_tmp5_ = list;
	_tmp7_ = vala_collection_to_array ((ValaCollection*) _tmp5_, &_tmp6_);
	_tmp4_->priv->array = (_vala_array_free (_tmp4_->priv->array, _tmp4_->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL);
	_tmp4_->priv->array = _tmp7_;
	_tmp4_->priv->array_length1 = _tmp6_;
	_tmp4_->priv->_array_size_ = _tmp4_->priv->array_length1;
	_tmp8_ = helper;
	_tmp9_ = helper;
	_tmp10_ = _tmp9_->priv->array;
	_tmp10__length1 = _tmp9_->priv->array_length1;
	_tmp8_->priv->list = _tmp10_;
	_tmp11_ = helper;
	_tmp11_->priv->index = 0;
	_tmp12_ = helper;
	_tmp13_ = list;
	_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp12_->priv->size = _tmp15_;
	_tmp16_ = helper;
	_tmp17_ = compare;
	_tmp17__target = compare_target;
	_tmp16_->priv->compare = _tmp17_;
	_tmp16_->priv->compare_target = _tmp17__target;
	_tmp18_ = helper;
	vala_tim_sort_do_sort (_tmp18_);
	_tmp19_ = list;
	vala_collection_clear ((ValaCollection*) _tmp19_);
	_tmp20_ = helper;
	_tmp21_ = _tmp20_->priv->array;
	_tmp21__length1 = _tmp20_->priv->array_length1;
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp21_;
		item_collection_length1 = _tmp21__length1;
		for (item_it = 0; item_it < _tmp21__length1; item_it = item_it + 1) {
			gpointer _tmp22_;
			gpointer item = NULL;
			_tmp22_ = ((item_collection[item_it] != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item_collection[item_it]) : ((gpointer) item_collection[item_it]);
			item = _tmp22_;
			{
				ValaList* _tmp23_;
				gconstpointer _tmp24_;
				_tmp23_ = list;
				_tmp24_ = item;
				vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
				_g_destroy_func0 (item);
			}
		}
	}
	_vala_tim_sort_unref0 (helper);
}


static void vala_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaArrayList* list, GCompareDataFunc compare, void* compare_target) {
	ValaTimSort* helper = NULL;
	ValaTimSort* _tmp0_;
	ValaArrayList* _tmp1_;
	ValaList* _tmp2_;
	ValaArrayList* _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	ValaArrayList* _tmp5_;
	gint _tmp6_;
	GCompareDataFunc _tmp7_;
	void* _tmp7__target;
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = list;
	_tmp2_ = _vala_iterable_ref0 ((ValaList*) _tmp1_);
	_vala_iterable_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp2_;
	_tmp3_ = list;
	_tmp4_ = _tmp3_->_items;
	_tmp4__length1 = _tmp3_->_items_length1;
	helper->priv->list = _tmp4_;
	helper->priv->index = 0;
	_tmp5_ = list;
	_tmp6_ = _tmp5_->_size;
	helper->priv->size = _tmp6_;
	_tmp7_ = compare;
	_tmp7__target = compare_target;
	helper->priv->compare = _tmp7_;
	helper->priv->compare_target = _tmp7__target;
	vala_tim_sort_do_sort (helper);
	_vala_tim_sort_unref0 (helper);
}


static void _vala_array_add1 (ValaTimSortSlice** * array, int* length, int* size, ValaTimSortSlice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaTimSortSlice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void vala_tim_sort_do_sort (ValaTimSort* self) {
	gint _tmp0_;
	ValaTimSortSlice** _tmp1_;
	ValaTimSortSlice* remaining = NULL;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaTimSortSlice* _tmp5_;
	gint minimum_length = 0;
	ValaTimSortSlice* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValaTimSortSlice* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	ValaTimSortSlice** _tmp36_;
	gint _tmp36__length1;
	ValaTimSortSlice** _tmp37_;
	gint _tmp37__length1;
	ValaTimSortSlice* _tmp38_;
	gint _tmp39_;
	ValaTimSortSlice** _tmp40_;
	gint _tmp40__length1;
	ValaTimSortSlice* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size;
	if (_tmp0_ < 2) {
		return;
	}
	_tmp1_ = g_new0 (ValaTimSortSlice*, 0 + 1);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) vala_tim_sort_slice_free), NULL);
	self->priv->pending = _tmp1_;
	self->priv->pending_length1 = 0;
	self->priv->_pending_size_ = self->priv->pending_length1;
	self->priv->minimum_gallop = VALA_TIM_SORT_MINIMUM_GALLOP;
	_tmp2_ = self->priv->list;
	_tmp3_ = self->priv->index;
	_tmp4_ = self->priv->size;
	_tmp5_ = vala_tim_sort_slice_new (_tmp2_, _tmp3_, _tmp4_);
	remaining = _tmp5_;
	_tmp6_ = remaining;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = vala_tim_sort_compute_minimum_run_length (self, _tmp7_);
	minimum_length = _tmp8_;
	while (TRUE) {
		ValaTimSortSlice* _tmp9_;
		gint _tmp10_;
		gboolean descending = FALSE;
		ValaTimSortSlice* run = NULL;
		ValaTimSortSlice* _tmp11_;
		gboolean _tmp12_ = FALSE;
		ValaTimSortSlice* _tmp13_;
		gboolean _tmp14_;
		ValaTimSortSlice* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ValaTimSortSlice* _tmp28_;
		ValaTimSortSlice* _tmp29_;
		gint _tmp30_;
		ValaTimSortSlice** _tmp31_;
		gint _tmp31__length1;
		ValaTimSortSlice* _tmp32_;
		_tmp9_ = remaining;
		_tmp10_ = _tmp9_->length;
		if (!(_tmp10_ > 0)) {
			break;
		}
		_tmp11_ = remaining;
		_tmp13_ = vala_tim_sort_compute_longest_run (self, _tmp11_, &_tmp12_);
		descending = _tmp12_;
		run = _tmp13_;
		_tmp14_ = descending;
		if (_tmp14_) {
			ValaTimSortSlice* _tmp15_;
			_tmp15_ = run;
			vala_tim_sort_slice_reverse (_tmp15_);
		}
		_tmp16_ = run;
		_tmp17_ = _tmp16_->length;
		_tmp18_ = minimum_length;
		if (_tmp17_ < _tmp18_) {
			gint sorted_count = 0;
			ValaTimSortSlice* _tmp19_;
			gint _tmp20_;
			ValaTimSortSlice* _tmp21_;
			gint _tmp22_;
			ValaTimSortSlice* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			ValaTimSortSlice* _tmp26_;
			gint _tmp27_;
			_tmp19_ = run;
			_tmp20_ = _tmp19_->length;
			sorted_count = _tmp20_;
			_tmp21_ = run;
			_tmp22_ = minimum_length;
			_tmp23_ = remaining;
			_tmp24_ = _tmp23_->length;
			_tmp25_ = MIN (_tmp22_, _tmp24_);
			_tmp21_->length = _tmp25_;
			_tmp26_ = run;
			_tmp27_ = sorted_count;
			vala_tim_sort_insertion_sort (self, _tmp26_, _tmp27_);
		}
		_tmp28_ = remaining;
		_tmp29_ = run;
		_tmp30_ = _tmp29_->length;
		vala_tim_sort_slice_shorten_start (_tmp28_, _tmp30_);
		_tmp31_ = self->priv->pending;
		_tmp31__length1 = self->priv->pending_length1;
		_tmp32_ = run;
		run = NULL;
		_vala_array_add1 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, _tmp32_);
		vala_tim_sort_merge_collapse (self);
		_vala_tim_sort_slice_free0 (run);
	}
	_tmp33_ = remaining;
	_tmp34_ = _tmp33_->index;
	_tmp35_ = self->priv->size;
	_vala_assert (_tmp34_ == _tmp35_, "remaining.index == size");
	vala_tim_sort_merge_force_collapse (self);
	_tmp36_ = self->priv->pending;
	_tmp36__length1 = self->priv->pending_length1;
	_vala_assert (_tmp36__length1 == 1, "pending.length == 1");
	_tmp37_ = self->priv->pending;
	_tmp37__length1 = self->priv->pending_length1;
	_tmp38_ = _tmp37_[0];
	_tmp39_ = _tmp38_->index;
	_vala_assert (_tmp39_ == 0, "pending[0].index == 0");
	_tmp40_ = self->priv->pending;
	_tmp40__length1 = self->priv->pending_length1;
	_tmp41_ = _tmp40_[0];
	_tmp42_ = _tmp41_->length;
	_tmp43_ = self->priv->size;
	_vala_assert (_tmp42_ == _tmp43_, "pending[0].length == size");
	_vala_tim_sort_slice_free0 (remaining);
}


static inline gboolean vala_tim_sort_lower_than (ValaTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	_tmp1_ = left;
	_tmp2_ = right;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	result = _tmp3_ < 0;
	return result;
}


static inline gboolean vala_tim_sort_lower_than_or_equal_to (ValaTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	_tmp1_ = left;
	_tmp2_ = right;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	result = _tmp3_ <= 0;
	return result;
}


static gint vala_tim_sort_compute_minimum_run_length (ValaTimSort* self, gint length) {
	gint result = 0;
	gint run_length = 0;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	run_length = 0;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = length;
		if (!(_tmp0_ >= 64)) {
			break;
		}
		_tmp1_ = run_length;
		_tmp2_ = length;
		run_length = _tmp1_ | (_tmp2_ & 1);
		_tmp3_ = length;
		length = _tmp3_ >> 1;
	}
	_tmp4_ = length;
	_tmp5_ = run_length;
	result = _tmp4_ + _tmp5_;
	return result;
}


static ValaTimSortSlice* vala_tim_sort_compute_longest_run (ValaTimSort* self, ValaTimSortSlice* a, gboolean* descending) {
	gboolean _vala_descending = FALSE;
	ValaTimSortSlice* result = NULL;
	gint run_length = 0;
	ValaTimSortSlice* _tmp0_;
	gint _tmp1_;
	ValaTimSortSlice* _tmp53_;
	void** _tmp54_;
	ValaTimSortSlice* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	ValaTimSortSlice* _tmp58_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	if (_tmp1_ <= 1) {
		ValaTimSortSlice* _tmp2_;
		gint _tmp3_;
		_tmp2_ = a;
		_tmp3_ = _tmp2_->length;
		run_length = _tmp3_;
		_vala_descending = FALSE;
	} else {
		ValaTimSortSlice* _tmp4_;
		void** _tmp5_;
		ValaTimSortSlice* _tmp6_;
		gint _tmp7_;
		void* _tmp8_;
		ValaTimSortSlice* _tmp9_;
		void** _tmp10_;
		ValaTimSortSlice* _tmp11_;
		gint _tmp12_;
		void* _tmp13_;
		gboolean _tmp14_;
		run_length = 2;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->list;
		_tmp6_ = a;
		_tmp7_ = _tmp6_->index;
		_tmp8_ = _tmp5_[_tmp7_ + 1];
		_tmp9_ = a;
		_tmp10_ = _tmp9_->list;
		_tmp11_ = a;
		_tmp12_ = _tmp11_->index;
		_tmp13_ = _tmp10_[_tmp12_];
		_tmp14_ = vala_tim_sort_lower_than (self, _tmp8_, _tmp13_);
		if (_tmp14_) {
			_vala_descending = TRUE;
			{
				gint i = 0;
				ValaTimSortSlice* _tmp15_;
				gint _tmp16_;
				_tmp15_ = a;
				_tmp16_ = _tmp15_->index;
				i = _tmp16_ + 2;
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						gint _tmp19_;
						ValaTimSortSlice* _tmp20_;
						gint _tmp21_;
						ValaTimSortSlice* _tmp22_;
						gint _tmp23_;
						ValaTimSortSlice* _tmp24_;
						void** _tmp25_;
						gint _tmp26_;
						void* _tmp27_;
						ValaTimSortSlice* _tmp28_;
						void** _tmp29_;
						gint _tmp30_;
						void* _tmp31_;
						gboolean _tmp32_;
						if (!_tmp17_) {
							gint _tmp18_;
							_tmp18_ = i;
							i = _tmp18_ + 1;
						}
						_tmp17_ = FALSE;
						_tmp19_ = i;
						_tmp20_ = a;
						_tmp21_ = _tmp20_->index;
						_tmp22_ = a;
						_tmp23_ = _tmp22_->length;
						if (!(_tmp19_ < (_tmp21_ + _tmp23_))) {
							break;
						}
						_tmp24_ = a;
						_tmp25_ = _tmp24_->list;
						_tmp26_ = i;
						_tmp27_ = _tmp25_[_tmp26_];
						_tmp28_ = a;
						_tmp29_ = _tmp28_->list;
						_tmp30_ = i;
						_tmp31_ = _tmp29_[_tmp30_ - 1];
						_tmp32_ = vala_tim_sort_lower_than (self, _tmp27_, _tmp31_);
						if (_tmp32_) {
							gint _tmp33_;
							_tmp33_ = run_length;
							run_length = _tmp33_ + 1;
						} else {
							break;
						}
					}
				}
			}
		} else {
			_vala_descending = FALSE;
			{
				gint i = 0;
				ValaTimSortSlice* _tmp34_;
				gint _tmp35_;
				_tmp34_ = a;
				_tmp35_ = _tmp34_->index;
				i = _tmp35_ + 2;
				{
					gboolean _tmp36_ = FALSE;
					_tmp36_ = TRUE;
					while (TRUE) {
						gint _tmp38_;
						ValaTimSortSlice* _tmp39_;
						gint _tmp40_;
						ValaTimSortSlice* _tmp41_;
						gint _tmp42_;
						ValaTimSortSlice* _tmp43_;
						void** _tmp44_;
						gint _tmp45_;
						void* _tmp46_;
						ValaTimSortSlice* _tmp47_;
						void** _tmp48_;
						gint _tmp49_;
						void* _tmp50_;
						gboolean _tmp51_;
						if (!_tmp36_) {
							gint _tmp37_;
							_tmp37_ = i;
							i = _tmp37_ + 1;
						}
						_tmp36_ = FALSE;
						_tmp38_ = i;
						_tmp39_ = a;
						_tmp40_ = _tmp39_->index;
						_tmp41_ = a;
						_tmp42_ = _tmp41_->length;
						if (!(_tmp38_ < (_tmp40_ + _tmp42_))) {
							break;
						}
						_tmp43_ = a;
						_tmp44_ = _tmp43_->list;
						_tmp45_ = i;
						_tmp46_ = _tmp44_[_tmp45_];
						_tmp47_ = a;
						_tmp48_ = _tmp47_->list;
						_tmp49_ = i;
						_tmp50_ = _tmp48_[_tmp49_ - 1];
						_tmp51_ = vala_tim_sort_lower_than (self, _tmp46_, _tmp50_);
						if (_tmp51_) {
							break;
						} else {
							gint _tmp52_;
							_tmp52_ = run_length;
							run_length = _tmp52_ + 1;
						}
					}
				}
			}
		}
	}
	_tmp53_ = a;
	_tmp54_ = _tmp53_->list;
	_tmp55_ = a;
	_tmp56_ = _tmp55_->index;
	_tmp57_ = run_length;
	_tmp58_ = vala_tim_sort_slice_new (_tmp54_, _tmp56_, _tmp57_);
	result = _tmp58_;
	if (descending) {
		*descending = _vala_descending;
	}
	return result;
}


static void vala_tim_sort_insertion_sort (ValaTimSort* self, ValaTimSortSlice* a, gint offset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	{
		gint start = 0;
		ValaTimSortSlice* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = a;
		_tmp1_ = _tmp0_->index;
		_tmp2_ = offset;
		start = _tmp1_ + _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				ValaTimSortSlice* _tmp6_;
				gint _tmp7_;
				ValaTimSortSlice* _tmp8_;
				gint _tmp9_;
				gint left = 0;
				ValaTimSortSlice* _tmp10_;
				gint _tmp11_;
				gint right = 0;
				gint _tmp12_;
				void* pivot = NULL;
				ValaTimSortSlice* _tmp13_;
				void** _tmp14_;
				gint _tmp15_;
				void* _tmp16_;
				gint _tmp30_;
				gint _tmp31_;
				ValaTimSortSlice* _tmp32_;
				void** _tmp33_;
				gint _tmp34_;
				ValaTimSortSlice* _tmp35_;
				void** _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				ValaTimSortSlice* _tmp40_;
				void** _tmp41_;
				gint _tmp42_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = start;
					start = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = start;
				_tmp6_ = a;
				_tmp7_ = _tmp6_->index;
				_tmp8_ = a;
				_tmp9_ = _tmp8_->length;
				if (!(_tmp5_ < (_tmp7_ + _tmp9_))) {
					break;
				}
				_tmp10_ = a;
				_tmp11_ = _tmp10_->index;
				left = _tmp11_;
				_tmp12_ = start;
				right = _tmp12_;
				_tmp13_ = a;
				_tmp14_ = _tmp13_->list;
				_tmp15_ = right;
				_tmp16_ = _tmp14_[_tmp15_];
				pivot = _tmp16_;
				while (TRUE) {
					gint _tmp17_;
					gint _tmp18_;
					gint p = 0;
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					void* _tmp22_;
					ValaTimSortSlice* _tmp23_;
					void** _tmp24_;
					gint _tmp25_;
					void* _tmp26_;
					gboolean _tmp27_;
					_tmp17_ = left;
					_tmp18_ = right;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = left;
					_tmp20_ = right;
					_tmp21_ = left;
					p = _tmp19_ + ((_tmp20_ - _tmp21_) >> 1);
					_tmp22_ = pivot;
					_tmp23_ = a;
					_tmp24_ = _tmp23_->list;
					_tmp25_ = p;
					_tmp26_ = _tmp24_[_tmp25_];
					_tmp27_ = vala_tim_sort_lower_than (self, _tmp22_, _tmp26_);
					if (_tmp27_) {
						gint _tmp28_;
						_tmp28_ = p;
						right = _tmp28_;
					} else {
						gint _tmp29_;
						_tmp29_ = p;
						left = _tmp29_ + 1;
					}
				}
				_tmp30_ = left;
				_tmp31_ = right;
				_vala_assert (_tmp30_ == _tmp31_, "left == right");
				_tmp32_ = a;
				_tmp33_ = _tmp32_->list;
				_tmp34_ = left;
				_tmp35_ = a;
				_tmp36_ = _tmp35_->list;
				_tmp37_ = left;
				_tmp38_ = start;
				_tmp39_ = left;
				g_memmove (&_tmp33_[_tmp34_ + 1], &_tmp36_[_tmp37_], (gsize) (sizeof (gpointer) * (_tmp38_ - _tmp39_)));
				_tmp40_ = a;
				_tmp41_ = _tmp40_->list;
				_tmp42_ = left;
				_tmp43_ = pivot;
				_tmp41_[_tmp42_] = _tmp43_;
				_tmp44_ = _tmp41_[_tmp42_];
			}
		}
	}
}


static void vala_tim_sort_merge_collapse (ValaTimSort* self) {
	gint count = 0;
	ValaTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		ValaTimSortSlice** _tmp35_;
		gint _tmp35__length1;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			ValaTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			ValaTimSortSlice* _tmp6_;
			gint _tmp7_;
			ValaTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			ValaTimSortSlice* _tmp10_;
			gint _tmp11_;
			ValaTimSortSlice** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			ValaTimSortSlice* _tmp14_;
			gint _tmp15_;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 2];
			_tmp11_ = _tmp10_->length;
			_tmp12_ = self->priv->pending;
			_tmp12__length1 = self->priv->pending_length1;
			_tmp13_ = count;
			_tmp14_ = _tmp12_[_tmp13_ - 1];
			_tmp15_ = _tmp14_->length;
			_tmp2_ = _tmp7_ <= (_tmp11_ + _tmp15_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaTimSortSlice** _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			ValaTimSortSlice* _tmp18_;
			gint _tmp19_;
			ValaTimSortSlice** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			ValaTimSortSlice* _tmp22_;
			gint _tmp23_;
			_tmp16_ = self->priv->pending;
			_tmp16__length1 = self->priv->pending_length1;
			_tmp17_ = count;
			_tmp18_ = _tmp16_[_tmp17_ - 3];
			_tmp19_ = _tmp18_->length;
			_tmp20_ = self->priv->pending;
			_tmp20__length1 = self->priv->pending_length1;
			_tmp21_ = count;
			_tmp22_ = _tmp20_[_tmp21_ - 1];
			_tmp23_ = _tmp22_->length;
			if (_tmp19_ < _tmp23_) {
				gint _tmp24_;
				_tmp24_ = count;
				vala_tim_sort_merge_at (self, _tmp24_ - 3);
			} else {
				gint _tmp25_;
				_tmp25_ = count;
				vala_tim_sort_merge_at (self, _tmp25_ - 2);
			}
		} else {
			ValaTimSortSlice** _tmp26_;
			gint _tmp26__length1;
			gint _tmp27_;
			ValaTimSortSlice* _tmp28_;
			gint _tmp29_;
			ValaTimSortSlice** _tmp30_;
			gint _tmp30__length1;
			gint _tmp31_;
			ValaTimSortSlice* _tmp32_;
			gint _tmp33_;
			_tmp26_ = self->priv->pending;
			_tmp26__length1 = self->priv->pending_length1;
			_tmp27_ = count;
			_tmp28_ = _tmp26_[_tmp27_ - 2];
			_tmp29_ = _tmp28_->length;
			_tmp30_ = self->priv->pending;
			_tmp30__length1 = self->priv->pending_length1;
			_tmp31_ = count;
			_tmp32_ = _tmp30_[_tmp31_ - 1];
			_tmp33_ = _tmp32_->length;
			if (_tmp29_ <= _tmp33_) {
				gint _tmp34_;
				_tmp34_ = count;
				vala_tim_sort_merge_at (self, _tmp34_ - 2);
			} else {
				break;
			}
		}
		_tmp35_ = self->priv->pending;
		_tmp35__length1 = self->priv->pending_length1;
		count = _tmp35__length1;
	}
}


static void vala_tim_sort_merge_force_collapse (ValaTimSort* self) {
	gint count = 0;
	ValaTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_;
		ValaTimSortSlice** _tmp14_;
		gint _tmp14__length1;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			ValaTimSortSlice** _tmp4_;
			gint _tmp4__length1;
			gint _tmp5_;
			ValaTimSortSlice* _tmp6_;
			gint _tmp7_;
			ValaTimSortSlice** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			ValaTimSortSlice* _tmp10_;
			gint _tmp11_;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 1];
			_tmp11_ = _tmp10_->length;
			_tmp2_ = _tmp7_ < _tmp11_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp12_;
			_tmp12_ = count;
			vala_tim_sort_merge_at (self, _tmp12_ - 3);
		} else {
			gint _tmp13_;
			_tmp13_ = count;
			vala_tim_sort_merge_at (self, _tmp13_ - 2);
		}
		_tmp14_ = self->priv->pending;
		_tmp14__length1 = self->priv->pending_length1;
		count = _tmp14__length1;
	}
}


static void vala_tim_sort_merge_at (ValaTimSort* self, gint index) {
	ValaTimSortSlice* a = NULL;
	ValaTimSortSlice** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	ValaTimSortSlice* _tmp2_;
	ValaTimSortSlice* b = NULL;
	ValaTimSortSlice** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	ValaTimSortSlice* _tmp5_;
	ValaTimSortSlice* _tmp6_;
	gint _tmp7_;
	ValaTimSortSlice* _tmp8_;
	gint _tmp9_;
	ValaTimSortSlice* _tmp10_;
	gint _tmp11_;
	ValaTimSortSlice* _tmp12_;
	gint _tmp13_;
	ValaTimSortSlice* _tmp14_;
	gint _tmp15_;
	ValaTimSortSlice** _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	void** _tmp18_;
	ValaTimSortSlice* _tmp19_;
	gint _tmp20_;
	ValaTimSortSlice* _tmp21_;
	gint _tmp22_;
	ValaTimSortSlice* _tmp23_;
	gint _tmp24_;
	ValaTimSortSlice* _tmp25_;
	ValaTimSortSlice* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaTimSortSlice** _tmp29_;
	gint _tmp29__length1;
	gint _tmp30_;
	gint _tmp31_;
	gint sorted_count = 0;
	ValaTimSortSlice* _tmp32_;
	void* _tmp33_;
	ValaTimSortSlice* _tmp34_;
	gint _tmp35_;
	ValaTimSortSlice* _tmp36_;
	gint _tmp37_;
	ValaTimSortSlice* _tmp38_;
	gint _tmp39_;
	ValaTimSortSlice* _tmp40_;
	ValaTimSortSlice* _tmp41_;
	void* _tmp42_;
	ValaTimSortSlice* _tmp43_;
	ValaTimSortSlice* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	ValaTimSortSlice* _tmp47_;
	gint _tmp48_;
	ValaTimSortSlice* _tmp49_;
	gint _tmp50_;
	ValaTimSortSlice* _tmp51_;
	gint _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	_tmp1_ = index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp0_[_tmp1_] = NULL;
	a = _tmp2_;
	_tmp3_ = self->priv->pending;
	_tmp3__length1 = self->priv->pending_length1;
	_tmp4_ = index;
	_tmp5_ = _tmp3_[_tmp4_ + 1];
	_tmp3_[_tmp4_ + 1] = NULL;
	b = _tmp5_;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_vala_assert (_tmp7_ > 0, "a.length > 0");
	_tmp8_ = b;
	_tmp9_ = _tmp8_->length;
	_vala_assert (_tmp9_ > 0, "b.length > 0");
	_tmp10_ = a;
	_tmp11_ = _tmp10_->index;
	_tmp12_ = a;
	_tmp13_ = _tmp12_->length;
	_tmp14_ = b;
	_tmp15_ = _tmp14_->index;
	_vala_assert ((_tmp11_ + _tmp13_) == _tmp15_, "a.index + a.length == b.index");
	_tmp16_ = self->priv->pending;
	_tmp16__length1 = self->priv->pending_length1;
	_tmp17_ = index;
	_tmp18_ = self->priv->list;
	_tmp19_ = a;
	_tmp20_ = _tmp19_->index;
	_tmp21_ = a;
	_tmp22_ = _tmp21_->length;
	_tmp23_ = b;
	_tmp24_ = _tmp23_->length;
	_tmp25_ = vala_tim_sort_slice_new (_tmp18_, _tmp20_, _tmp22_ + _tmp24_);
	_vala_tim_sort_slice_free0 (_tmp16_[_tmp17_]);
	_tmp16_[_tmp17_] = _tmp25_;
	_tmp26_ = _tmp16_[_tmp17_];
	_tmp27_ = index;
	_tmp28_ = index;
	_tmp29_ = self->priv->pending;
	_tmp29__length1 = self->priv->pending_length1;
	_tmp30_ = index;
	_vala_array_move (self->priv->pending, sizeof (ValaTimSortSlice*), _tmp27_ + 2, _tmp28_ + 1, (_tmp29__length1 - _tmp30_) - 2);
	self->priv->pending_length1 = self->priv->pending_length1 - 1;
	_tmp31_ = self->priv->pending_length1;
	_tmp32_ = b;
	_tmp33_ = vala_tim_sort_slice_peek_first (_tmp32_);
	_tmp34_ = a;
	_tmp35_ = vala_tim_sort_gallop_rightmost (self, _tmp33_, _tmp34_, 0);
	sorted_count = _tmp35_;
	_tmp36_ = a;
	_tmp37_ = sorted_count;
	vala_tim_sort_slice_shorten_start (_tmp36_, _tmp37_);
	_tmp38_ = a;
	_tmp39_ = _tmp38_->length;
	if (_tmp39_ == 0) {
		_vala_tim_sort_slice_free0 (b);
		_vala_tim_sort_slice_free0 (a);
		return;
	}
	_tmp40_ = b;
	_tmp41_ = a;
	_tmp42_ = vala_tim_sort_slice_peek_last (_tmp41_);
	_tmp43_ = b;
	_tmp44_ = b;
	_tmp45_ = _tmp44_->length;
	_tmp46_ = vala_tim_sort_gallop_leftmost (self, _tmp42_, _tmp43_, _tmp45_ - 1);
	_tmp40_->length = _tmp46_;
	_tmp47_ = b;
	_tmp48_ = _tmp47_->length;
	if (_tmp48_ == 0) {
		_vala_tim_sort_slice_free0 (b);
		_vala_tim_sort_slice_free0 (a);
		return;
	}
	_tmp49_ = a;
	_tmp50_ = _tmp49_->length;
	_tmp51_ = b;
	_tmp52_ = _tmp51_->length;
	if (_tmp50_ <= _tmp52_) {
		ValaTimSortSlice* _tmp53_;
		ValaTimSortSlice* _tmp54_;
		_tmp53_ = a;
		a = NULL;
		_tmp54_ = b;
		b = NULL;
		vala_tim_sort_merge_low (self, _tmp53_, _tmp54_);
	} else {
		ValaTimSortSlice* _tmp55_;
		ValaTimSortSlice* _tmp56_;
		_tmp55_ = a;
		a = NULL;
		_tmp56_ = b;
		b = NULL;
		vala_tim_sort_merge_high (self, _tmp55_, _tmp56_);
	}
	_vala_tim_sort_slice_free0 (b);
	_vala_tim_sort_slice_free0 (a);
}


static gint vala_tim_sort_gallop_leftmost (ValaTimSort* self, gconstpointer key, ValaTimSortSlice* a, gint hint) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	ValaTimSortSlice* _tmp2_;
	gint _tmp3_;
	gint p = 0;
	ValaTimSortSlice* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint last_offset = 0;
	gint offset = 0;
	ValaTimSortSlice* _tmp7_;
	void** _tmp8_;
	gint _tmp9_;
	void* _tmp10_;
	gconstpointer _tmp11_;
	gboolean _tmp12_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	ValaTimSortSlice* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp79_;
	gint _tmp80_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_tmp0_ = hint;
	_vala_assert (0 <= _tmp0_, "0 <= hint");
	_tmp1_ = hint;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp1_ < _tmp3_, "hint < a.length");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = hint;
	p = _tmp5_ + _tmp6_;
	last_offset = 0;
	offset = 1;
	_tmp7_ = a;
	_tmp8_ = _tmp7_->list;
	_tmp9_ = p;
	_tmp10_ = _tmp8_[_tmp9_];
	_tmp11_ = key;
	_tmp12_ = vala_tim_sort_lower_than (self, _tmp10_, _tmp11_);
	if (_tmp12_) {
		gint max_offset = 0;
		ValaTimSortSlice* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp13_ = a;
		_tmp14_ = _tmp13_->length;
		_tmp15_ = hint;
		max_offset = _tmp14_ - _tmp15_;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaTimSortSlice* _tmp18_;
			void** _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			void* _tmp22_;
			gconstpointer _tmp23_;
			gboolean _tmp24_;
			_tmp16_ = offset;
			_tmp17_ = max_offset;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = a;
			_tmp19_ = _tmp18_->list;
			_tmp20_ = p;
			_tmp21_ = offset;
			_tmp22_ = _tmp19_[_tmp20_ + _tmp21_];
			_tmp23_ = key;
			_tmp24_ = vala_tim_sort_lower_than (self, _tmp22_, _tmp23_);
			if (_tmp24_) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp25_ = offset;
				last_offset = _tmp25_;
				_tmp26_ = offset;
				offset = _tmp26_ << 1;
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
			} else {
				break;
			}
		}
		_tmp28_ = offset;
		_tmp29_ = max_offset;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			_tmp30_ = max_offset;
			offset = _tmp30_;
		}
		_tmp31_ = hint;
		_tmp32_ = last_offset;
		last_offset = _tmp31_ + _tmp32_;
		_tmp33_ = hint;
		_tmp34_ = offset;
		offset = _tmp33_ + _tmp34_;
	} else {
		gint max_offset = 0;
		gint _tmp35_;
		gint _tmp48_;
		gint _tmp49_;
		gint temp_last_offset = 0;
		gint _tmp51_;
		gint temp_offset = 0;
		gint _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		_tmp35_ = hint;
		max_offset = _tmp35_ + 1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			ValaTimSortSlice* _tmp38_;
			void** _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			void* _tmp42_;
			gconstpointer _tmp43_;
			gboolean _tmp44_;
			_tmp36_ = offset;
			_tmp37_ = max_offset;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = a;
			_tmp39_ = _tmp38_->list;
			_tmp40_ = p;
			_tmp41_ = offset;
			_tmp42_ = _tmp39_[_tmp40_ - _tmp41_];
			_tmp43_ = key;
			_tmp44_ = vala_tim_sort_lower_than (self, _tmp42_, _tmp43_);
			if (_tmp44_) {
				break;
			} else {
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				_tmp45_ = offset;
				last_offset = _tmp45_;
				_tmp46_ = offset;
				offset = _tmp46_ << 1;
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
			}
		}
		_tmp48_ = offset;
		_tmp49_ = max_offset;
		if (_tmp48_ > _tmp49_) {
			gint _tmp50_;
			_tmp50_ = max_offset;
			offset = _tmp50_;
		}
		_tmp51_ = last_offset;
		temp_last_offset = _tmp51_;
		_tmp52_ = offset;
		temp_offset = _tmp52_;
		_tmp53_ = hint;
		_tmp54_ = temp_offset;
		last_offset = _tmp53_ - _tmp54_;
		_tmp55_ = hint;
		_tmp56_ = temp_last_offset;
		offset = _tmp55_ - _tmp56_;
	}
	_tmp57_ = last_offset;
	_vala_assert (-1 <= _tmp57_, "-1 <= last_offset");
	_tmp58_ = last_offset;
	_tmp59_ = offset;
	_vala_assert (_tmp58_ < _tmp59_, "last_offset < offset");
	_tmp60_ = offset;
	_tmp61_ = a;
	_tmp62_ = _tmp61_->length;
	_vala_assert (_tmp60_ <= _tmp62_, "offset <= a.length");
	_tmp63_ = last_offset;
	last_offset = _tmp63_ + 1;
	while (TRUE) {
		gint _tmp64_;
		gint _tmp65_;
		gint m = 0;
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		ValaTimSortSlice* _tmp69_;
		void** _tmp70_;
		ValaTimSortSlice* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		void* _tmp74_;
		gconstpointer _tmp75_;
		gboolean _tmp76_;
		_tmp64_ = last_offset;
		_tmp65_ = offset;
		if (!(_tmp64_ < _tmp65_)) {
			break;
		}
		_tmp66_ = last_offset;
		_tmp67_ = offset;
		_tmp68_ = last_offset;
		m = _tmp66_ + ((_tmp67_ - _tmp68_) >> 1);
		_tmp69_ = a;
		_tmp70_ = _tmp69_->list;
		_tmp71_ = a;
		_tmp72_ = _tmp71_->index;
		_tmp73_ = m;
		_tmp74_ = _tmp70_[_tmp72_ + _tmp73_];
		_tmp75_ = key;
		_tmp76_ = vala_tim_sort_lower_than (self, _tmp74_, _tmp75_);
		if (_tmp76_) {
			gint _tmp77_;
			_tmp77_ = m;
			last_offset = _tmp77_ + 1;
		} else {
			gint _tmp78_;
			_tmp78_ = m;
			offset = _tmp78_;
		}
	}
	_tmp79_ = last_offset;
	_tmp80_ = offset;
	_vala_assert (_tmp79_ == _tmp80_, "last_offset == offset");
	result = offset;
	return result;
}


static gint vala_tim_sort_gallop_rightmost (ValaTimSort* self, gconstpointer key, ValaTimSortSlice* a, gint hint) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	ValaTimSortSlice* _tmp2_;
	gint _tmp3_;
	gint p = 0;
	ValaTimSortSlice* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint last_offset = 0;
	gint offset = 0;
	ValaTimSortSlice* _tmp7_;
	void** _tmp8_;
	gint _tmp9_;
	void* _tmp10_;
	gconstpointer _tmp11_;
	gboolean _tmp12_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	ValaTimSortSlice* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp79_;
	gint _tmp80_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_tmp0_ = hint;
	_vala_assert (0 <= _tmp0_, "0 <= hint");
	_tmp1_ = hint;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp1_ < _tmp3_, "hint < a.length");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = hint;
	p = _tmp5_ + _tmp6_;
	last_offset = 0;
	offset = 1;
	_tmp7_ = a;
	_tmp8_ = _tmp7_->list;
	_tmp9_ = p;
	_tmp10_ = _tmp8_[_tmp9_];
	_tmp11_ = key;
	_tmp12_ = vala_tim_sort_lower_than_or_equal_to (self, _tmp10_, _tmp11_);
	if (_tmp12_) {
		gint max_offset = 0;
		ValaTimSortSlice* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp28_;
		gint _tmp29_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp13_ = a;
		_tmp14_ = _tmp13_->length;
		_tmp15_ = hint;
		max_offset = _tmp14_ - _tmp15_;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaTimSortSlice* _tmp18_;
			void** _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			void* _tmp22_;
			gconstpointer _tmp23_;
			gboolean _tmp24_;
			_tmp16_ = offset;
			_tmp17_ = max_offset;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = a;
			_tmp19_ = _tmp18_->list;
			_tmp20_ = p;
			_tmp21_ = offset;
			_tmp22_ = _tmp19_[_tmp20_ + _tmp21_];
			_tmp23_ = key;
			_tmp24_ = vala_tim_sort_lower_than_or_equal_to (self, _tmp22_, _tmp23_);
			if (_tmp24_) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				_tmp25_ = offset;
				last_offset = _tmp25_;
				_tmp26_ = offset;
				offset = _tmp26_ << 1;
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
			} else {
				break;
			}
		}
		_tmp28_ = offset;
		_tmp29_ = max_offset;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			_tmp30_ = max_offset;
			offset = _tmp30_;
		}
		_tmp31_ = hint;
		_tmp32_ = last_offset;
		last_offset = _tmp31_ + _tmp32_;
		_tmp33_ = hint;
		_tmp34_ = offset;
		offset = _tmp33_ + _tmp34_;
	} else {
		gint max_offset = 0;
		gint _tmp35_;
		gint _tmp48_;
		gint _tmp49_;
		gint temp_last_offset = 0;
		gint _tmp51_;
		gint temp_offset = 0;
		gint _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		_tmp35_ = hint;
		max_offset = _tmp35_ + 1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			ValaTimSortSlice* _tmp38_;
			void** _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			void* _tmp42_;
			gconstpointer _tmp43_;
			gboolean _tmp44_;
			_tmp36_ = offset;
			_tmp37_ = max_offset;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = a;
			_tmp39_ = _tmp38_->list;
			_tmp40_ = p;
			_tmp41_ = offset;
			_tmp42_ = _tmp39_[_tmp40_ - _tmp41_];
			_tmp43_ = key;
			_tmp44_ = vala_tim_sort_lower_than_or_equal_to (self, _tmp42_, _tmp43_);
			if (_tmp44_) {
				break;
			} else {
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				_tmp45_ = offset;
				last_offset = _tmp45_;
				_tmp46_ = offset;
				offset = _tmp46_ << 1;
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
			}
		}
		_tmp48_ = offset;
		_tmp49_ = max_offset;
		if (_tmp48_ > _tmp49_) {
			gint _tmp50_;
			_tmp50_ = max_offset;
			offset = _tmp50_;
		}
		_tmp51_ = last_offset;
		temp_last_offset = _tmp51_;
		_tmp52_ = offset;
		temp_offset = _tmp52_;
		_tmp53_ = hint;
		_tmp54_ = temp_offset;
		last_offset = _tmp53_ - _tmp54_;
		_tmp55_ = hint;
		_tmp56_ = temp_last_offset;
		offset = _tmp55_ - _tmp56_;
	}
	_tmp57_ = last_offset;
	_vala_assert (-1 <= _tmp57_, "-1 <= last_offset");
	_tmp58_ = last_offset;
	_tmp59_ = offset;
	_vala_assert (_tmp58_ < _tmp59_, "last_offset < offset");
	_tmp60_ = offset;
	_tmp61_ = a;
	_tmp62_ = _tmp61_->length;
	_vala_assert (_tmp60_ <= _tmp62_, "offset <= a.length");
	_tmp63_ = last_offset;
	last_offset = _tmp63_ + 1;
	while (TRUE) {
		gint _tmp64_;
		gint _tmp65_;
		gint m = 0;
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		ValaTimSortSlice* _tmp69_;
		void** _tmp70_;
		ValaTimSortSlice* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		void* _tmp74_;
		gconstpointer _tmp75_;
		gboolean _tmp76_;
		_tmp64_ = last_offset;
		_tmp65_ = offset;
		if (!(_tmp64_ < _tmp65_)) {
			break;
		}
		_tmp66_ = last_offset;
		_tmp67_ = offset;
		_tmp68_ = last_offset;
		m = _tmp66_ + ((_tmp67_ - _tmp68_) >> 1);
		_tmp69_ = a;
		_tmp70_ = _tmp69_->list;
		_tmp71_ = a;
		_tmp72_ = _tmp71_->index;
		_tmp73_ = m;
		_tmp74_ = _tmp70_[_tmp72_ + _tmp73_];
		_tmp75_ = key;
		_tmp76_ = vala_tim_sort_lower_than_or_equal_to (self, _tmp74_, _tmp75_);
		if (_tmp76_) {
			gint _tmp77_;
			_tmp77_ = m;
			last_offset = _tmp77_ + 1;
		} else {
			gint _tmp78_;
			_tmp78_ = m;
			offset = _tmp78_;
		}
	}
	_tmp79_ = last_offset;
	_tmp80_ = offset;
	_vala_assert (_tmp79_ == _tmp80_, "last_offset == offset");
	result = offset;
	return result;
}


static void vala_tim_sort_merge_low (ValaTimSort* self, ValaTimSortSlice* a, ValaTimSortSlice* b) {
	ValaTimSortSlice* _tmp0_;
	gint _tmp1_;
	ValaTimSortSlice* _tmp2_;
	gint _tmp3_;
	ValaTimSortSlice* _tmp4_;
	gint _tmp5_;
	ValaTimSortSlice* _tmp6_;
	gint _tmp7_;
	ValaTimSortSlice* _tmp8_;
	gint _tmp9_;
	gint minimum_gallop = 0;
	gint _tmp10_;
	gint dest = 0;
	ValaTimSortSlice* _tmp11_;
	gint _tmp12_;
	ValaTimSortSlice* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	_vala_assert (_tmp1_ > 0, "a.length > 0");
	_tmp2_ = b;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp3_ > 0, "b.length > 0");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->index;
	_vala_assert ((_tmp5_ + _tmp7_) == _tmp9_, "a.index + a.length == b.index");
	_tmp10_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp10_;
	_tmp11_ = a;
	_tmp12_ = _tmp11_->index;
	dest = _tmp12_;
	_tmp13_ = a;
	vala_tim_sort_slice_copy (_tmp13_);
	{
		void** _tmp14_;
		gint _tmp15_;
		ValaTimSortSlice* _tmp16_;
		void* _tmp17_;
		void* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaTimSortSlice* _tmp20_;
		gint _tmp21_;
		_tmp14_ = self->priv->list;
		_tmp15_ = dest;
		dest = _tmp15_ + 1;
		_tmp16_ = b;
		_tmp17_ = vala_tim_sort_slice_pop_first (_tmp16_);
		_tmp14_[_tmp15_] = _tmp17_;
		_tmp18_ = _tmp14_[_tmp15_];
		_tmp20_ = a;
		_tmp21_ = _tmp20_->length;
		if (_tmp21_ == 1) {
			_tmp19_ = TRUE;
		} else {
			ValaTimSortSlice* _tmp22_;
			gint _tmp23_;
			_tmp22_ = b;
			_tmp23_ = _tmp22_->length;
			_tmp19_ = _tmp23_ == 0;
		}
		if (_tmp19_) {
			{
				ValaTimSortSlice* _tmp24_;
				gint _tmp25_;
				ValaTimSortSlice* _tmp26_;
				gint _tmp27_;
				ValaTimSortSlice* _tmp28_;
				void** _tmp29_;
				ValaTimSortSlice* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValaTimSortSlice* _tmp33_;
				gint _tmp34_;
				ValaTimSortSlice* _tmp35_;
				void** _tmp36_;
				ValaTimSortSlice* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				ValaTimSortSlice* _tmp40_;
				gint _tmp41_;
				ValaTimSortSlice* _tmp42_;
				gint _tmp43_;
				_tmp24_ = a;
				_tmp25_ = _tmp24_->length;
				_vala_assert (_tmp25_ >= 0, "a.length >= 0");
				_tmp26_ = b;
				_tmp27_ = _tmp26_->length;
				_vala_assert (_tmp27_ >= 0, "b.length >= 0");
				_tmp28_ = b;
				_tmp29_ = self->priv->list;
				_tmp30_ = b;
				_tmp31_ = _tmp30_->index;
				_tmp32_ = dest;
				_tmp33_ = b;
				_tmp34_ = _tmp33_->length;
				vala_tim_sort_slice_merge_in (_tmp28_, _tmp29_, _tmp31_, _tmp32_, _tmp34_);
				_tmp35_ = a;
				_tmp36_ = self->priv->list;
				_tmp37_ = a;
				_tmp38_ = _tmp37_->index;
				_tmp39_ = dest;
				_tmp40_ = b;
				_tmp41_ = _tmp40_->length;
				_tmp42_ = a;
				_tmp43_ = _tmp42_->length;
				vala_tim_sort_slice_merge_in (_tmp35_, _tmp36_, _tmp38_, _tmp39_ + _tmp41_, _tmp43_);
			}
			_vala_tim_sort_slice_free0 (a);
			_vala_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp109_;
			gint _tmp243_;
			gint _tmp244_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				ValaTimSortSlice* _tmp44_;
				void* _tmp45_;
				ValaTimSortSlice* _tmp46_;
				void* _tmp47_;
				gboolean _tmp48_;
				_tmp44_ = b;
				_tmp45_ = vala_tim_sort_slice_peek_first (_tmp44_);
				_tmp46_ = a;
				_tmp47_ = vala_tim_sort_slice_peek_first (_tmp46_);
				_tmp48_ = vala_tim_sort_lower_than (self, _tmp45_, _tmp47_);
				if (_tmp48_) {
					void** _tmp49_;
					gint _tmp50_;
					ValaTimSortSlice* _tmp51_;
					void* _tmp52_;
					void* _tmp53_;
					ValaTimSortSlice* _tmp54_;
					gint _tmp55_;
					gint _tmp76_;
					gint _tmp77_;
					gint _tmp78_;
					_tmp49_ = self->priv->list;
					_tmp50_ = dest;
					dest = _tmp50_ + 1;
					_tmp51_ = b;
					_tmp52_ = vala_tim_sort_slice_pop_first (_tmp51_);
					_tmp49_[_tmp50_] = _tmp52_;
					_tmp53_ = _tmp49_[_tmp50_];
					_tmp54_ = b;
					_tmp55_ = _tmp54_->length;
					if (_tmp55_ == 0) {
						{
							ValaTimSortSlice* _tmp56_;
							gint _tmp57_;
							ValaTimSortSlice* _tmp58_;
							gint _tmp59_;
							ValaTimSortSlice* _tmp60_;
							void** _tmp61_;
							ValaTimSortSlice* _tmp62_;
							gint _tmp63_;
							gint _tmp64_;
							ValaTimSortSlice* _tmp65_;
							gint _tmp66_;
							ValaTimSortSlice* _tmp67_;
							void** _tmp68_;
							ValaTimSortSlice* _tmp69_;
							gint _tmp70_;
							gint _tmp71_;
							ValaTimSortSlice* _tmp72_;
							gint _tmp73_;
							ValaTimSortSlice* _tmp74_;
							gint _tmp75_;
							_tmp56_ = a;
							_tmp57_ = _tmp56_->length;
							_vala_assert (_tmp57_ >= 0, "a.length >= 0");
							_tmp58_ = b;
							_tmp59_ = _tmp58_->length;
							_vala_assert (_tmp59_ >= 0, "b.length >= 0");
							_tmp60_ = b;
							_tmp61_ = self->priv->list;
							_tmp62_ = b;
							_tmp63_ = _tmp62_->index;
							_tmp64_ = dest;
							_tmp65_ = b;
							_tmp66_ = _tmp65_->length;
							vala_tim_sort_slice_merge_in (_tmp60_, _tmp61_, _tmp63_, _tmp64_, _tmp66_);
							_tmp67_ = a;
							_tmp68_ = self->priv->list;
							_tmp69_ = a;
							_tmp70_ = _tmp69_->index;
							_tmp71_ = dest;
							_tmp72_ = b;
							_tmp73_ = _tmp72_->length;
							_tmp74_ = a;
							_tmp75_ = _tmp74_->length;
							vala_tim_sort_slice_merge_in (_tmp67_, _tmp68_, _tmp70_, _tmp71_ + _tmp73_, _tmp75_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp76_ = b_count;
					b_count = _tmp76_ + 1;
					a_count = 0;
					_tmp77_ = b_count;
					_tmp78_ = minimum_gallop;
					if (_tmp77_ >= _tmp78_) {
						break;
					}
				} else {
					void** _tmp79_;
					gint _tmp80_;
					ValaTimSortSlice* _tmp81_;
					void* _tmp82_;
					void* _tmp83_;
					ValaTimSortSlice* _tmp84_;
					gint _tmp85_;
					gint _tmp106_;
					gint _tmp107_;
					gint _tmp108_;
					_tmp79_ = self->priv->list;
					_tmp80_ = dest;
					dest = _tmp80_ + 1;
					_tmp81_ = a;
					_tmp82_ = vala_tim_sort_slice_pop_first (_tmp81_);
					_tmp79_[_tmp80_] = _tmp82_;
					_tmp83_ = _tmp79_[_tmp80_];
					_tmp84_ = a;
					_tmp85_ = _tmp84_->length;
					if (_tmp85_ == 1) {
						{
							ValaTimSortSlice* _tmp86_;
							gint _tmp87_;
							ValaTimSortSlice* _tmp88_;
							gint _tmp89_;
							ValaTimSortSlice* _tmp90_;
							void** _tmp91_;
							ValaTimSortSlice* _tmp92_;
							gint _tmp93_;
							gint _tmp94_;
							ValaTimSortSlice* _tmp95_;
							gint _tmp96_;
							ValaTimSortSlice* _tmp97_;
							void** _tmp98_;
							ValaTimSortSlice* _tmp99_;
							gint _tmp100_;
							gint _tmp101_;
							ValaTimSortSlice* _tmp102_;
							gint _tmp103_;
							ValaTimSortSlice* _tmp104_;
							gint _tmp105_;
							_tmp86_ = a;
							_tmp87_ = _tmp86_->length;
							_vala_assert (_tmp87_ >= 0, "a.length >= 0");
							_tmp88_ = b;
							_tmp89_ = _tmp88_->length;
							_vala_assert (_tmp89_ >= 0, "b.length >= 0");
							_tmp90_ = b;
							_tmp91_ = self->priv->list;
							_tmp92_ = b;
							_tmp93_ = _tmp92_->index;
							_tmp94_ = dest;
							_tmp95_ = b;
							_tmp96_ = _tmp95_->length;
							vala_tim_sort_slice_merge_in (_tmp90_, _tmp91_, _tmp93_, _tmp94_, _tmp96_);
							_tmp97_ = a;
							_tmp98_ = self->priv->list;
							_tmp99_ = a;
							_tmp100_ = _tmp99_->index;
							_tmp101_ = dest;
							_tmp102_ = b;
							_tmp103_ = _tmp102_->length;
							_tmp104_ = a;
							_tmp105_ = _tmp104_->length;
							vala_tim_sort_slice_merge_in (_tmp97_, _tmp98_, _tmp100_, _tmp101_ + _tmp103_, _tmp105_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp106_ = a_count;
					a_count = _tmp106_ + 1;
					b_count = 0;
					_tmp107_ = a_count;
					_tmp108_ = minimum_gallop;
					if (_tmp107_ >= _tmp108_) {
						break;
					}
				}
			}
			_tmp109_ = minimum_gallop;
			minimum_gallop = _tmp109_ + 1;
			while (TRUE) {
				gint _tmp110_ = 0;
				gint _tmp111_;
				gint _tmp112_;
				gint _tmp113_;
				ValaTimSortSlice* _tmp114_;
				void* _tmp115_;
				ValaTimSortSlice* _tmp116_;
				gint _tmp117_;
				ValaTimSortSlice* _tmp118_;
				void** _tmp119_;
				ValaTimSortSlice* _tmp120_;
				gint _tmp121_;
				gint _tmp122_;
				gint _tmp123_;
				gint _tmp124_;
				gint _tmp125_;
				ValaTimSortSlice* _tmp126_;
				gint _tmp127_;
				ValaTimSortSlice* _tmp128_;
				gint _tmp129_;
				void** _tmp150_;
				gint _tmp151_;
				ValaTimSortSlice* _tmp152_;
				void* _tmp153_;
				void* _tmp154_;
				ValaTimSortSlice* _tmp155_;
				gint _tmp156_;
				ValaTimSortSlice* _tmp177_;
				void* _tmp178_;
				ValaTimSortSlice* _tmp179_;
				gint _tmp180_;
				ValaTimSortSlice* _tmp181_;
				void** _tmp182_;
				ValaTimSortSlice* _tmp183_;
				gint _tmp184_;
				gint _tmp185_;
				gint _tmp186_;
				gint _tmp187_;
				gint _tmp188_;
				ValaTimSortSlice* _tmp189_;
				gint _tmp190_;
				ValaTimSortSlice* _tmp191_;
				gint _tmp192_;
				void** _tmp213_;
				gint _tmp214_;
				ValaTimSortSlice* _tmp215_;
				void* _tmp216_;
				void* _tmp217_;
				ValaTimSortSlice* _tmp218_;
				gint _tmp219_;
				gboolean _tmp240_ = FALSE;
				gint _tmp241_;
				_tmp111_ = minimum_gallop;
				if (_tmp111_ > 1) {
					_tmp110_ = 1;
				} else {
					_tmp110_ = 0;
				}
				_tmp112_ = minimum_gallop;
				minimum_gallop = _tmp112_ - _tmp110_;
				_tmp113_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp113_;
				_tmp114_ = b;
				_tmp115_ = vala_tim_sort_slice_peek_first (_tmp114_);
				_tmp116_ = a;
				_tmp117_ = vala_tim_sort_gallop_rightmost (self, _tmp115_, _tmp116_, 0);
				a_count = _tmp117_;
				_tmp118_ = a;
				_tmp119_ = self->priv->list;
				_tmp120_ = a;
				_tmp121_ = _tmp120_->index;
				_tmp122_ = dest;
				_tmp123_ = a_count;
				vala_tim_sort_slice_merge_in (_tmp118_, _tmp119_, _tmp121_, _tmp122_, _tmp123_);
				_tmp124_ = dest;
				_tmp125_ = a_count;
				dest = _tmp124_ + _tmp125_;
				_tmp126_ = a;
				_tmp127_ = a_count;
				vala_tim_sort_slice_shorten_start (_tmp126_, _tmp127_);
				_tmp128_ = a;
				_tmp129_ = _tmp128_->length;
				if (_tmp129_ <= 1) {
					{
						ValaTimSortSlice* _tmp130_;
						gint _tmp131_;
						ValaTimSortSlice* _tmp132_;
						gint _tmp133_;
						ValaTimSortSlice* _tmp134_;
						void** _tmp135_;
						ValaTimSortSlice* _tmp136_;
						gint _tmp137_;
						gint _tmp138_;
						ValaTimSortSlice* _tmp139_;
						gint _tmp140_;
						ValaTimSortSlice* _tmp141_;
						void** _tmp142_;
						ValaTimSortSlice* _tmp143_;
						gint _tmp144_;
						gint _tmp145_;
						ValaTimSortSlice* _tmp146_;
						gint _tmp147_;
						ValaTimSortSlice* _tmp148_;
						gint _tmp149_;
						_tmp130_ = a;
						_tmp131_ = _tmp130_->length;
						_vala_assert (_tmp131_ >= 0, "a.length >= 0");
						_tmp132_ = b;
						_tmp133_ = _tmp132_->length;
						_vala_assert (_tmp133_ >= 0, "b.length >= 0");
						_tmp134_ = b;
						_tmp135_ = self->priv->list;
						_tmp136_ = b;
						_tmp137_ = _tmp136_->index;
						_tmp138_ = dest;
						_tmp139_ = b;
						_tmp140_ = _tmp139_->length;
						vala_tim_sort_slice_merge_in (_tmp134_, _tmp135_, _tmp137_, _tmp138_, _tmp140_);
						_tmp141_ = a;
						_tmp142_ = self->priv->list;
						_tmp143_ = a;
						_tmp144_ = _tmp143_->index;
						_tmp145_ = dest;
						_tmp146_ = b;
						_tmp147_ = _tmp146_->length;
						_tmp148_ = a;
						_tmp149_ = _tmp148_->length;
						vala_tim_sort_slice_merge_in (_tmp141_, _tmp142_, _tmp144_, _tmp145_ + _tmp147_, _tmp149_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp150_ = self->priv->list;
				_tmp151_ = dest;
				dest = _tmp151_ + 1;
				_tmp152_ = b;
				_tmp153_ = vala_tim_sort_slice_pop_first (_tmp152_);
				_tmp150_[_tmp151_] = _tmp153_;
				_tmp154_ = _tmp150_[_tmp151_];
				_tmp155_ = b;
				_tmp156_ = _tmp155_->length;
				if (_tmp156_ == 0) {
					{
						ValaTimSortSlice* _tmp157_;
						gint _tmp158_;
						ValaTimSortSlice* _tmp159_;
						gint _tmp160_;
						ValaTimSortSlice* _tmp161_;
						void** _tmp162_;
						ValaTimSortSlice* _tmp163_;
						gint _tmp164_;
						gint _tmp165_;
						ValaTimSortSlice* _tmp166_;
						gint _tmp167_;
						ValaTimSortSlice* _tmp168_;
						void** _tmp169_;
						ValaTimSortSlice* _tmp170_;
						gint _tmp171_;
						gint _tmp172_;
						ValaTimSortSlice* _tmp173_;
						gint _tmp174_;
						ValaTimSortSlice* _tmp175_;
						gint _tmp176_;
						_tmp157_ = a;
						_tmp158_ = _tmp157_->length;
						_vala_assert (_tmp158_ >= 0, "a.length >= 0");
						_tmp159_ = b;
						_tmp160_ = _tmp159_->length;
						_vala_assert (_tmp160_ >= 0, "b.length >= 0");
						_tmp161_ = b;
						_tmp162_ = self->priv->list;
						_tmp163_ = b;
						_tmp164_ = _tmp163_->index;
						_tmp165_ = dest;
						_tmp166_ = b;
						_tmp167_ = _tmp166_->length;
						vala_tim_sort_slice_merge_in (_tmp161_, _tmp162_, _tmp164_, _tmp165_, _tmp167_);
						_tmp168_ = a;
						_tmp169_ = self->priv->list;
						_tmp170_ = a;
						_tmp171_ = _tmp170_->index;
						_tmp172_ = dest;
						_tmp173_ = b;
						_tmp174_ = _tmp173_->length;
						_tmp175_ = a;
						_tmp176_ = _tmp175_->length;
						vala_tim_sort_slice_merge_in (_tmp168_, _tmp169_, _tmp171_, _tmp172_ + _tmp174_, _tmp176_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp177_ = a;
				_tmp178_ = vala_tim_sort_slice_peek_first (_tmp177_);
				_tmp179_ = b;
				_tmp180_ = vala_tim_sort_gallop_leftmost (self, _tmp178_, _tmp179_, 0);
				b_count = _tmp180_;
				_tmp181_ = b;
				_tmp182_ = self->priv->list;
				_tmp183_ = b;
				_tmp184_ = _tmp183_->index;
				_tmp185_ = dest;
				_tmp186_ = b_count;
				vala_tim_sort_slice_merge_in (_tmp181_, _tmp182_, _tmp184_, _tmp185_, _tmp186_);
				_tmp187_ = dest;
				_tmp188_ = b_count;
				dest = _tmp187_ + _tmp188_;
				_tmp189_ = b;
				_tmp190_ = b_count;
				vala_tim_sort_slice_shorten_start (_tmp189_, _tmp190_);
				_tmp191_ = b;
				_tmp192_ = _tmp191_->length;
				if (_tmp192_ == 0) {
					{
						ValaTimSortSlice* _tmp193_;
						gint _tmp194_;
						ValaTimSortSlice* _tmp195_;
						gint _tmp196_;
						ValaTimSortSlice* _tmp197_;
						void** _tmp198_;
						ValaTimSortSlice* _tmp199_;
						gint _tmp200_;
						gint _tmp201_;
						ValaTimSortSlice* _tmp202_;
						gint _tmp203_;
						ValaTimSortSlice* _tmp204_;
						void** _tmp205_;
						ValaTimSortSlice* _tmp206_;
						gint _tmp207_;
						gint _tmp208_;
						ValaTimSortSlice* _tmp209_;
						gint _tmp210_;
						ValaTimSortSlice* _tmp211_;
						gint _tmp212_;
						_tmp193_ = a;
						_tmp194_ = _tmp193_->length;
						_vala_assert (_tmp194_ >= 0, "a.length >= 0");
						_tmp195_ = b;
						_tmp196_ = _tmp195_->length;
						_vala_assert (_tmp196_ >= 0, "b.length >= 0");
						_tmp197_ = b;
						_tmp198_ = self->priv->list;
						_tmp199_ = b;
						_tmp200_ = _tmp199_->index;
						_tmp201_ = dest;
						_tmp202_ = b;
						_tmp203_ = _tmp202_->length;
						vala_tim_sort_slice_merge_in (_tmp197_, _tmp198_, _tmp200_, _tmp201_, _tmp203_);
						_tmp204_ = a;
						_tmp205_ = self->priv->list;
						_tmp206_ = a;
						_tmp207_ = _tmp206_->index;
						_tmp208_ = dest;
						_tmp209_ = b;
						_tmp210_ = _tmp209_->length;
						_tmp211_ = a;
						_tmp212_ = _tmp211_->length;
						vala_tim_sort_slice_merge_in (_tmp204_, _tmp205_, _tmp207_, _tmp208_ + _tmp210_, _tmp212_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp213_ = self->priv->list;
				_tmp214_ = dest;
				dest = _tmp214_ + 1;
				_tmp215_ = a;
				_tmp216_ = vala_tim_sort_slice_pop_first (_tmp215_);
				_tmp213_[_tmp214_] = _tmp216_;
				_tmp217_ = _tmp213_[_tmp214_];
				_tmp218_ = a;
				_tmp219_ = _tmp218_->length;
				if (_tmp219_ == 1) {
					{
						ValaTimSortSlice* _tmp220_;
						gint _tmp221_;
						ValaTimSortSlice* _tmp222_;
						gint _tmp223_;
						ValaTimSortSlice* _tmp224_;
						void** _tmp225_;
						ValaTimSortSlice* _tmp226_;
						gint _tmp227_;
						gint _tmp228_;
						ValaTimSortSlice* _tmp229_;
						gint _tmp230_;
						ValaTimSortSlice* _tmp231_;
						void** _tmp232_;
						ValaTimSortSlice* _tmp233_;
						gint _tmp234_;
						gint _tmp235_;
						ValaTimSortSlice* _tmp236_;
						gint _tmp237_;
						ValaTimSortSlice* _tmp238_;
						gint _tmp239_;
						_tmp220_ = a;
						_tmp221_ = _tmp220_->length;
						_vala_assert (_tmp221_ >= 0, "a.length >= 0");
						_tmp222_ = b;
						_tmp223_ = _tmp222_->length;
						_vala_assert (_tmp223_ >= 0, "b.length >= 0");
						_tmp224_ = b;
						_tmp225_ = self->priv->list;
						_tmp226_ = b;
						_tmp227_ = _tmp226_->index;
						_tmp228_ = dest;
						_tmp229_ = b;
						_tmp230_ = _tmp229_->length;
						vala_tim_sort_slice_merge_in (_tmp224_, _tmp225_, _tmp227_, _tmp228_, _tmp230_);
						_tmp231_ = a;
						_tmp232_ = self->priv->list;
						_tmp233_ = a;
						_tmp234_ = _tmp233_->index;
						_tmp235_ = dest;
						_tmp236_ = b;
						_tmp237_ = _tmp236_->length;
						_tmp238_ = a;
						_tmp239_ = _tmp238_->length;
						vala_tim_sort_slice_merge_in (_tmp231_, _tmp232_, _tmp234_, _tmp235_ + _tmp237_, _tmp239_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp241_ = a_count;
				if (_tmp241_ < VALA_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp242_;
					_tmp242_ = b_count;
					_tmp240_ = _tmp242_ < VALA_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp240_ = FALSE;
				}
				if (_tmp240_) {
					break;
				}
			}
			_tmp243_ = minimum_gallop;
			minimum_gallop = _tmp243_ + 1;
			_tmp244_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp244_;
		}
	}
	__finally0:
	{
		ValaTimSortSlice* _tmp245_;
		gint _tmp246_;
		ValaTimSortSlice* _tmp247_;
		gint _tmp248_;
		ValaTimSortSlice* _tmp249_;
		void** _tmp250_;
		ValaTimSortSlice* _tmp251_;
		gint _tmp252_;
		gint _tmp253_;
		ValaTimSortSlice* _tmp254_;
		gint _tmp255_;
		ValaTimSortSlice* _tmp256_;
		void** _tmp257_;
		ValaTimSortSlice* _tmp258_;
		gint _tmp259_;
		gint _tmp260_;
		ValaTimSortSlice* _tmp261_;
		gint _tmp262_;
		ValaTimSortSlice* _tmp263_;
		gint _tmp264_;
		_tmp245_ = a;
		_tmp246_ = _tmp245_->length;
		_vala_assert (_tmp246_ >= 0, "a.length >= 0");
		_tmp247_ = b;
		_tmp248_ = _tmp247_->length;
		_vala_assert (_tmp248_ >= 0, "b.length >= 0");
		_tmp249_ = b;
		_tmp250_ = self->priv->list;
		_tmp251_ = b;
		_tmp252_ = _tmp251_->index;
		_tmp253_ = dest;
		_tmp254_ = b;
		_tmp255_ = _tmp254_->length;
		vala_tim_sort_slice_merge_in (_tmp249_, _tmp250_, _tmp252_, _tmp253_, _tmp255_);
		_tmp256_ = a;
		_tmp257_ = self->priv->list;
		_tmp258_ = a;
		_tmp259_ = _tmp258_->index;
		_tmp260_ = dest;
		_tmp261_ = b;
		_tmp262_ = _tmp261_->length;
		_tmp263_ = a;
		_tmp264_ = _tmp263_->length;
		vala_tim_sort_slice_merge_in (_tmp256_, _tmp257_, _tmp259_, _tmp260_ + _tmp262_, _tmp264_);
	}
	_vala_tim_sort_slice_free0 (a);
	_vala_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


static void vala_tim_sort_merge_high (ValaTimSort* self, ValaTimSortSlice* a, ValaTimSortSlice* b) {
	ValaTimSortSlice* _tmp0_;
	gint _tmp1_;
	ValaTimSortSlice* _tmp2_;
	gint _tmp3_;
	ValaTimSortSlice* _tmp4_;
	gint _tmp5_;
	ValaTimSortSlice* _tmp6_;
	gint _tmp7_;
	ValaTimSortSlice* _tmp8_;
	gint _tmp9_;
	gint minimum_gallop = 0;
	gint _tmp10_;
	gint dest = 0;
	ValaTimSortSlice* _tmp11_;
	gint _tmp12_;
	ValaTimSortSlice* _tmp13_;
	gint _tmp14_;
	ValaTimSortSlice* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	_vala_assert (_tmp1_ > 0, "a.length > 0");
	_tmp2_ = b;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp3_ > 0, "b.length > 0");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->index;
	_vala_assert ((_tmp5_ + _tmp7_) == _tmp9_, "a.index + a.length == b.index");
	_tmp10_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp10_;
	_tmp11_ = b;
	_tmp12_ = _tmp11_->index;
	_tmp13_ = b;
	_tmp14_ = _tmp13_->length;
	dest = _tmp12_ + _tmp14_;
	_tmp15_ = b;
	vala_tim_sort_slice_copy (_tmp15_);
	{
		void** _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ValaTimSortSlice* _tmp19_;
		void* _tmp20_;
		void* _tmp21_;
		gboolean _tmp22_ = FALSE;
		ValaTimSortSlice* _tmp23_;
		gint _tmp24_;
		_tmp16_ = self->priv->list;
		_tmp17_ = dest;
		dest = _tmp17_ - 1;
		_tmp18_ = dest;
		_tmp19_ = a;
		_tmp20_ = vala_tim_sort_slice_pop_last (_tmp19_);
		_tmp16_[_tmp18_] = _tmp20_;
		_tmp21_ = _tmp16_[_tmp18_];
		_tmp23_ = a;
		_tmp24_ = _tmp23_->length;
		if (_tmp24_ == 0) {
			_tmp22_ = TRUE;
		} else {
			ValaTimSortSlice* _tmp25_;
			gint _tmp26_;
			_tmp25_ = b;
			_tmp26_ = _tmp25_->length;
			_tmp22_ = _tmp26_ == 1;
		}
		if (_tmp22_) {
			{
				ValaTimSortSlice* _tmp27_;
				gint _tmp28_;
				ValaTimSortSlice* _tmp29_;
				gint _tmp30_;
				ValaTimSortSlice* _tmp31_;
				void** _tmp32_;
				ValaTimSortSlice* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				ValaTimSortSlice* _tmp36_;
				gint _tmp37_;
				ValaTimSortSlice* _tmp38_;
				gint _tmp39_;
				ValaTimSortSlice* _tmp40_;
				void** _tmp41_;
				ValaTimSortSlice* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				ValaTimSortSlice* _tmp45_;
				gint _tmp46_;
				ValaTimSortSlice* _tmp47_;
				gint _tmp48_;
				ValaTimSortSlice* _tmp49_;
				gint _tmp50_;
				_tmp27_ = a;
				_tmp28_ = _tmp27_->length;
				_vala_assert (_tmp28_ >= 0, "a.length >= 0");
				_tmp29_ = b;
				_tmp30_ = _tmp29_->length;
				_vala_assert (_tmp30_ >= 0, "b.length >= 0");
				_tmp31_ = a;
				_tmp32_ = self->priv->list;
				_tmp33_ = a;
				_tmp34_ = _tmp33_->index;
				_tmp35_ = dest;
				_tmp36_ = a;
				_tmp37_ = _tmp36_->length;
				_tmp38_ = a;
				_tmp39_ = _tmp38_->length;
				vala_tim_sort_slice_merge_in_reversed (_tmp31_, _tmp32_, _tmp34_, _tmp35_ - _tmp37_, _tmp39_);
				_tmp40_ = b;
				_tmp41_ = self->priv->list;
				_tmp42_ = b;
				_tmp43_ = _tmp42_->index;
				_tmp44_ = dest;
				_tmp45_ = a;
				_tmp46_ = _tmp45_->length;
				_tmp47_ = b;
				_tmp48_ = _tmp47_->length;
				_tmp49_ = b;
				_tmp50_ = _tmp49_->length;
				vala_tim_sort_slice_merge_in_reversed (_tmp40_, _tmp41_, _tmp43_, (_tmp44_ - _tmp46_) - _tmp48_, _tmp50_);
			}
			_vala_tim_sort_slice_free0 (a);
			_vala_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp126_;
			gint _tmp292_;
			gint _tmp293_;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				ValaTimSortSlice* _tmp51_;
				void* _tmp52_;
				ValaTimSortSlice* _tmp53_;
				void* _tmp54_;
				gboolean _tmp55_;
				_tmp51_ = b;
				_tmp52_ = vala_tim_sort_slice_peek_last (_tmp51_);
				_tmp53_ = a;
				_tmp54_ = vala_tim_sort_slice_peek_last (_tmp53_);
				_tmp55_ = vala_tim_sort_lower_than (self, _tmp52_, _tmp54_);
				if (_tmp55_) {
					void** _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaTimSortSlice* _tmp59_;
					void* _tmp60_;
					void* _tmp61_;
					ValaTimSortSlice* _tmp62_;
					gint _tmp63_;
					gint _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					_tmp56_ = self->priv->list;
					_tmp57_ = dest;
					dest = _tmp57_ - 1;
					_tmp58_ = dest;
					_tmp59_ = a;
					_tmp60_ = vala_tim_sort_slice_pop_last (_tmp59_);
					_tmp56_[_tmp58_] = _tmp60_;
					_tmp61_ = _tmp56_[_tmp58_];
					_tmp62_ = a;
					_tmp63_ = _tmp62_->length;
					if (_tmp63_ == 0) {
						{
							ValaTimSortSlice* _tmp64_;
							gint _tmp65_;
							ValaTimSortSlice* _tmp66_;
							gint _tmp67_;
							ValaTimSortSlice* _tmp68_;
							void** _tmp69_;
							ValaTimSortSlice* _tmp70_;
							gint _tmp71_;
							gint _tmp72_;
							ValaTimSortSlice* _tmp73_;
							gint _tmp74_;
							ValaTimSortSlice* _tmp75_;
							gint _tmp76_;
							ValaTimSortSlice* _tmp77_;
							void** _tmp78_;
							ValaTimSortSlice* _tmp79_;
							gint _tmp80_;
							gint _tmp81_;
							ValaTimSortSlice* _tmp82_;
							gint _tmp83_;
							ValaTimSortSlice* _tmp84_;
							gint _tmp85_;
							ValaTimSortSlice* _tmp86_;
							gint _tmp87_;
							_tmp64_ = a;
							_tmp65_ = _tmp64_->length;
							_vala_assert (_tmp65_ >= 0, "a.length >= 0");
							_tmp66_ = b;
							_tmp67_ = _tmp66_->length;
							_vala_assert (_tmp67_ >= 0, "b.length >= 0");
							_tmp68_ = a;
							_tmp69_ = self->priv->list;
							_tmp70_ = a;
							_tmp71_ = _tmp70_->index;
							_tmp72_ = dest;
							_tmp73_ = a;
							_tmp74_ = _tmp73_->length;
							_tmp75_ = a;
							_tmp76_ = _tmp75_->length;
							vala_tim_sort_slice_merge_in_reversed (_tmp68_, _tmp69_, _tmp71_, _tmp72_ - _tmp74_, _tmp76_);
							_tmp77_ = b;
							_tmp78_ = self->priv->list;
							_tmp79_ = b;
							_tmp80_ = _tmp79_->index;
							_tmp81_ = dest;
							_tmp82_ = a;
							_tmp83_ = _tmp82_->length;
							_tmp84_ = b;
							_tmp85_ = _tmp84_->length;
							_tmp86_ = b;
							_tmp87_ = _tmp86_->length;
							vala_tim_sort_slice_merge_in_reversed (_tmp77_, _tmp78_, _tmp80_, (_tmp81_ - _tmp83_) - _tmp85_, _tmp87_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp88_ = a_count;
					a_count = _tmp88_ + 1;
					b_count = 0;
					_tmp89_ = a_count;
					_tmp90_ = minimum_gallop;
					if (_tmp89_ >= _tmp90_) {
						break;
					}
				} else {
					void** _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					ValaTimSortSlice* _tmp94_;
					void* _tmp95_;
					void* _tmp96_;
					ValaTimSortSlice* _tmp97_;
					gint _tmp98_;
					gint _tmp123_;
					gint _tmp124_;
					gint _tmp125_;
					_tmp91_ = self->priv->list;
					_tmp92_ = dest;
					dest = _tmp92_ - 1;
					_tmp93_ = dest;
					_tmp94_ = b;
					_tmp95_ = vala_tim_sort_slice_pop_last (_tmp94_);
					_tmp91_[_tmp93_] = _tmp95_;
					_tmp96_ = _tmp91_[_tmp93_];
					_tmp97_ = b;
					_tmp98_ = _tmp97_->length;
					if (_tmp98_ == 1) {
						{
							ValaTimSortSlice* _tmp99_;
							gint _tmp100_;
							ValaTimSortSlice* _tmp101_;
							gint _tmp102_;
							ValaTimSortSlice* _tmp103_;
							void** _tmp104_;
							ValaTimSortSlice* _tmp105_;
							gint _tmp106_;
							gint _tmp107_;
							ValaTimSortSlice* _tmp108_;
							gint _tmp109_;
							ValaTimSortSlice* _tmp110_;
							gint _tmp111_;
							ValaTimSortSlice* _tmp112_;
							void** _tmp113_;
							ValaTimSortSlice* _tmp114_;
							gint _tmp115_;
							gint _tmp116_;
							ValaTimSortSlice* _tmp117_;
							gint _tmp118_;
							ValaTimSortSlice* _tmp119_;
							gint _tmp120_;
							ValaTimSortSlice* _tmp121_;
							gint _tmp122_;
							_tmp99_ = a;
							_tmp100_ = _tmp99_->length;
							_vala_assert (_tmp100_ >= 0, "a.length >= 0");
							_tmp101_ = b;
							_tmp102_ = _tmp101_->length;
							_vala_assert (_tmp102_ >= 0, "b.length >= 0");
							_tmp103_ = a;
							_tmp104_ = self->priv->list;
							_tmp105_ = a;
							_tmp106_ = _tmp105_->index;
							_tmp107_ = dest;
							_tmp108_ = a;
							_tmp109_ = _tmp108_->length;
							_tmp110_ = a;
							_tmp111_ = _tmp110_->length;
							vala_tim_sort_slice_merge_in_reversed (_tmp103_, _tmp104_, _tmp106_, _tmp107_ - _tmp109_, _tmp111_);
							_tmp112_ = b;
							_tmp113_ = self->priv->list;
							_tmp114_ = b;
							_tmp115_ = _tmp114_->index;
							_tmp116_ = dest;
							_tmp117_ = a;
							_tmp118_ = _tmp117_->length;
							_tmp119_ = b;
							_tmp120_ = _tmp119_->length;
							_tmp121_ = b;
							_tmp122_ = _tmp121_->length;
							vala_tim_sort_slice_merge_in_reversed (_tmp112_, _tmp113_, _tmp115_, (_tmp116_ - _tmp118_) - _tmp120_, _tmp122_);
						}
						_vala_tim_sort_slice_free0 (a);
						_vala_tim_sort_slice_free0 (b);
						return;
					}
					_tmp123_ = b_count;
					b_count = _tmp123_ + 1;
					a_count = 0;
					_tmp124_ = b_count;
					_tmp125_ = minimum_gallop;
					if (_tmp124_ >= _tmp125_) {
						break;
					}
				}
			}
			_tmp126_ = minimum_gallop;
			minimum_gallop = _tmp126_ + 1;
			while (TRUE) {
				gint _tmp127_ = 0;
				gint _tmp128_;
				gint _tmp129_;
				gint _tmp130_;
				gint k = 0;
				ValaTimSortSlice* _tmp131_;
				void* _tmp132_;
				ValaTimSortSlice* _tmp133_;
				ValaTimSortSlice* _tmp134_;
				gint _tmp135_;
				gint _tmp136_;
				ValaTimSortSlice* _tmp137_;
				gint _tmp138_;
				gint _tmp139_;
				ValaTimSortSlice* _tmp140_;
				void** _tmp141_;
				ValaTimSortSlice* _tmp142_;
				gint _tmp143_;
				gint _tmp144_;
				gint _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				gint _tmp148_;
				gint _tmp149_;
				ValaTimSortSlice* _tmp150_;
				gint _tmp151_;
				ValaTimSortSlice* _tmp152_;
				gint _tmp153_;
				void** _tmp178_;
				gint _tmp179_;
				gint _tmp180_;
				ValaTimSortSlice* _tmp181_;
				void* _tmp182_;
				void* _tmp183_;
				ValaTimSortSlice* _tmp184_;
				gint _tmp185_;
				ValaTimSortSlice* _tmp210_;
				void* _tmp211_;
				ValaTimSortSlice* _tmp212_;
				ValaTimSortSlice* _tmp213_;
				gint _tmp214_;
				gint _tmp215_;
				ValaTimSortSlice* _tmp216_;
				gint _tmp217_;
				gint _tmp218_;
				ValaTimSortSlice* _tmp219_;
				void** _tmp220_;
				ValaTimSortSlice* _tmp221_;
				gint _tmp222_;
				gint _tmp223_;
				gint _tmp224_;
				gint _tmp225_;
				gint _tmp226_;
				gint _tmp227_;
				gint _tmp228_;
				ValaTimSortSlice* _tmp229_;
				gint _tmp230_;
				ValaTimSortSlice* _tmp231_;
				gint _tmp232_;
				void** _tmp257_;
				gint _tmp258_;
				gint _tmp259_;
				ValaTimSortSlice* _tmp260_;
				void* _tmp261_;
				void* _tmp262_;
				ValaTimSortSlice* _tmp263_;
				gint _tmp264_;
				gboolean _tmp289_ = FALSE;
				gint _tmp290_;
				_tmp128_ = minimum_gallop;
				if (_tmp128_ > 1) {
					_tmp127_ = 1;
				} else {
					_tmp127_ = 0;
				}
				_tmp129_ = minimum_gallop;
				minimum_gallop = _tmp129_ - _tmp127_;
				_tmp130_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp130_;
				_tmp131_ = b;
				_tmp132_ = vala_tim_sort_slice_peek_last (_tmp131_);
				_tmp133_ = a;
				_tmp134_ = a;
				_tmp135_ = _tmp134_->length;
				_tmp136_ = vala_tim_sort_gallop_rightmost (self, _tmp132_, _tmp133_, _tmp135_ - 1);
				k = _tmp136_;
				_tmp137_ = a;
				_tmp138_ = _tmp137_->length;
				_tmp139_ = k;
				a_count = _tmp138_ - _tmp139_;
				_tmp140_ = a;
				_tmp141_ = self->priv->list;
				_tmp142_ = a;
				_tmp143_ = _tmp142_->index;
				_tmp144_ = k;
				_tmp145_ = dest;
				_tmp146_ = a_count;
				_tmp147_ = a_count;
				vala_tim_sort_slice_merge_in_reversed (_tmp140_, _tmp141_, _tmp143_ + _tmp144_, _tmp145_ - _tmp146_, _tmp147_);
				_tmp148_ = dest;
				_tmp149_ = a_count;
				dest = _tmp148_ - _tmp149_;
				_tmp150_ = a;
				_tmp151_ = a_count;
				vala_tim_sort_slice_shorten_end (_tmp150_, _tmp151_);
				_tmp152_ = a;
				_tmp153_ = _tmp152_->length;
				if (_tmp153_ == 0) {
					{
						ValaTimSortSlice* _tmp154_;
						gint _tmp155_;
						ValaTimSortSlice* _tmp156_;
						gint _tmp157_;
						ValaTimSortSlice* _tmp158_;
						void** _tmp159_;
						ValaTimSortSlice* _tmp160_;
						gint _tmp161_;
						gint _tmp162_;
						ValaTimSortSlice* _tmp163_;
						gint _tmp164_;
						ValaTimSortSlice* _tmp165_;
						gint _tmp166_;
						ValaTimSortSlice* _tmp167_;
						void** _tmp168_;
						ValaTimSortSlice* _tmp169_;
						gint _tmp170_;
						gint _tmp171_;
						ValaTimSortSlice* _tmp172_;
						gint _tmp173_;
						ValaTimSortSlice* _tmp174_;
						gint _tmp175_;
						ValaTimSortSlice* _tmp176_;
						gint _tmp177_;
						_tmp154_ = a;
						_tmp155_ = _tmp154_->length;
						_vala_assert (_tmp155_ >= 0, "a.length >= 0");
						_tmp156_ = b;
						_tmp157_ = _tmp156_->length;
						_vala_assert (_tmp157_ >= 0, "b.length >= 0");
						_tmp158_ = a;
						_tmp159_ = self->priv->list;
						_tmp160_ = a;
						_tmp161_ = _tmp160_->index;
						_tmp162_ = dest;
						_tmp163_ = a;
						_tmp164_ = _tmp163_->length;
						_tmp165_ = a;
						_tmp166_ = _tmp165_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp158_, _tmp159_, _tmp161_, _tmp162_ - _tmp164_, _tmp166_);
						_tmp167_ = b;
						_tmp168_ = self->priv->list;
						_tmp169_ = b;
						_tmp170_ = _tmp169_->index;
						_tmp171_ = dest;
						_tmp172_ = a;
						_tmp173_ = _tmp172_->length;
						_tmp174_ = b;
						_tmp175_ = _tmp174_->length;
						_tmp176_ = b;
						_tmp177_ = _tmp176_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp167_, _tmp168_, _tmp170_, (_tmp171_ - _tmp173_) - _tmp175_, _tmp177_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp178_ = self->priv->list;
				_tmp179_ = dest;
				dest = _tmp179_ - 1;
				_tmp180_ = dest;
				_tmp181_ = b;
				_tmp182_ = vala_tim_sort_slice_pop_last (_tmp181_);
				_tmp178_[_tmp180_] = _tmp182_;
				_tmp183_ = _tmp178_[_tmp180_];
				_tmp184_ = b;
				_tmp185_ = _tmp184_->length;
				if (_tmp185_ == 1) {
					{
						ValaTimSortSlice* _tmp186_;
						gint _tmp187_;
						ValaTimSortSlice* _tmp188_;
						gint _tmp189_;
						ValaTimSortSlice* _tmp190_;
						void** _tmp191_;
						ValaTimSortSlice* _tmp192_;
						gint _tmp193_;
						gint _tmp194_;
						ValaTimSortSlice* _tmp195_;
						gint _tmp196_;
						ValaTimSortSlice* _tmp197_;
						gint _tmp198_;
						ValaTimSortSlice* _tmp199_;
						void** _tmp200_;
						ValaTimSortSlice* _tmp201_;
						gint _tmp202_;
						gint _tmp203_;
						ValaTimSortSlice* _tmp204_;
						gint _tmp205_;
						ValaTimSortSlice* _tmp206_;
						gint _tmp207_;
						ValaTimSortSlice* _tmp208_;
						gint _tmp209_;
						_tmp186_ = a;
						_tmp187_ = _tmp186_->length;
						_vala_assert (_tmp187_ >= 0, "a.length >= 0");
						_tmp188_ = b;
						_tmp189_ = _tmp188_->length;
						_vala_assert (_tmp189_ >= 0, "b.length >= 0");
						_tmp190_ = a;
						_tmp191_ = self->priv->list;
						_tmp192_ = a;
						_tmp193_ = _tmp192_->index;
						_tmp194_ = dest;
						_tmp195_ = a;
						_tmp196_ = _tmp195_->length;
						_tmp197_ = a;
						_tmp198_ = _tmp197_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp190_, _tmp191_, _tmp193_, _tmp194_ - _tmp196_, _tmp198_);
						_tmp199_ = b;
						_tmp200_ = self->priv->list;
						_tmp201_ = b;
						_tmp202_ = _tmp201_->index;
						_tmp203_ = dest;
						_tmp204_ = a;
						_tmp205_ = _tmp204_->length;
						_tmp206_ = b;
						_tmp207_ = _tmp206_->length;
						_tmp208_ = b;
						_tmp209_ = _tmp208_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp199_, _tmp200_, _tmp202_, (_tmp203_ - _tmp205_) - _tmp207_, _tmp209_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp210_ = a;
				_tmp211_ = vala_tim_sort_slice_peek_last (_tmp210_);
				_tmp212_ = b;
				_tmp213_ = b;
				_tmp214_ = _tmp213_->length;
				_tmp215_ = vala_tim_sort_gallop_leftmost (self, _tmp211_, _tmp212_, _tmp214_ - 1);
				k = _tmp215_;
				_tmp216_ = b;
				_tmp217_ = _tmp216_->length;
				_tmp218_ = k;
				b_count = _tmp217_ - _tmp218_;
				_tmp219_ = b;
				_tmp220_ = self->priv->list;
				_tmp221_ = b;
				_tmp222_ = _tmp221_->index;
				_tmp223_ = k;
				_tmp224_ = dest;
				_tmp225_ = b_count;
				_tmp226_ = b_count;
				vala_tim_sort_slice_merge_in_reversed (_tmp219_, _tmp220_, _tmp222_ + _tmp223_, _tmp224_ - _tmp225_, _tmp226_);
				_tmp227_ = dest;
				_tmp228_ = b_count;
				dest = _tmp227_ - _tmp228_;
				_tmp229_ = b;
				_tmp230_ = b_count;
				vala_tim_sort_slice_shorten_end (_tmp229_, _tmp230_);
				_tmp231_ = b;
				_tmp232_ = _tmp231_->length;
				if (_tmp232_ <= 1) {
					{
						ValaTimSortSlice* _tmp233_;
						gint _tmp234_;
						ValaTimSortSlice* _tmp235_;
						gint _tmp236_;
						ValaTimSortSlice* _tmp237_;
						void** _tmp238_;
						ValaTimSortSlice* _tmp239_;
						gint _tmp240_;
						gint _tmp241_;
						ValaTimSortSlice* _tmp242_;
						gint _tmp243_;
						ValaTimSortSlice* _tmp244_;
						gint _tmp245_;
						ValaTimSortSlice* _tmp246_;
						void** _tmp247_;
						ValaTimSortSlice* _tmp248_;
						gint _tmp249_;
						gint _tmp250_;
						ValaTimSortSlice* _tmp251_;
						gint _tmp252_;
						ValaTimSortSlice* _tmp253_;
						gint _tmp254_;
						ValaTimSortSlice* _tmp255_;
						gint _tmp256_;
						_tmp233_ = a;
						_tmp234_ = _tmp233_->length;
						_vala_assert (_tmp234_ >= 0, "a.length >= 0");
						_tmp235_ = b;
						_tmp236_ = _tmp235_->length;
						_vala_assert (_tmp236_ >= 0, "b.length >= 0");
						_tmp237_ = a;
						_tmp238_ = self->priv->list;
						_tmp239_ = a;
						_tmp240_ = _tmp239_->index;
						_tmp241_ = dest;
						_tmp242_ = a;
						_tmp243_ = _tmp242_->length;
						_tmp244_ = a;
						_tmp245_ = _tmp244_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp237_, _tmp238_, _tmp240_, _tmp241_ - _tmp243_, _tmp245_);
						_tmp246_ = b;
						_tmp247_ = self->priv->list;
						_tmp248_ = b;
						_tmp249_ = _tmp248_->index;
						_tmp250_ = dest;
						_tmp251_ = a;
						_tmp252_ = _tmp251_->length;
						_tmp253_ = b;
						_tmp254_ = _tmp253_->length;
						_tmp255_ = b;
						_tmp256_ = _tmp255_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp246_, _tmp247_, _tmp249_, (_tmp250_ - _tmp252_) - _tmp254_, _tmp256_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp257_ = self->priv->list;
				_tmp258_ = dest;
				dest = _tmp258_ - 1;
				_tmp259_ = dest;
				_tmp260_ = a;
				_tmp261_ = vala_tim_sort_slice_pop_last (_tmp260_);
				_tmp257_[_tmp259_] = _tmp261_;
				_tmp262_ = _tmp257_[_tmp259_];
				_tmp263_ = a;
				_tmp264_ = _tmp263_->length;
				if (_tmp264_ == 0) {
					{
						ValaTimSortSlice* _tmp265_;
						gint _tmp266_;
						ValaTimSortSlice* _tmp267_;
						gint _tmp268_;
						ValaTimSortSlice* _tmp269_;
						void** _tmp270_;
						ValaTimSortSlice* _tmp271_;
						gint _tmp272_;
						gint _tmp273_;
						ValaTimSortSlice* _tmp274_;
						gint _tmp275_;
						ValaTimSortSlice* _tmp276_;
						gint _tmp277_;
						ValaTimSortSlice* _tmp278_;
						void** _tmp279_;
						ValaTimSortSlice* _tmp280_;
						gint _tmp281_;
						gint _tmp282_;
						ValaTimSortSlice* _tmp283_;
						gint _tmp284_;
						ValaTimSortSlice* _tmp285_;
						gint _tmp286_;
						ValaTimSortSlice* _tmp287_;
						gint _tmp288_;
						_tmp265_ = a;
						_tmp266_ = _tmp265_->length;
						_vala_assert (_tmp266_ >= 0, "a.length >= 0");
						_tmp267_ = b;
						_tmp268_ = _tmp267_->length;
						_vala_assert (_tmp268_ >= 0, "b.length >= 0");
						_tmp269_ = a;
						_tmp270_ = self->priv->list;
						_tmp271_ = a;
						_tmp272_ = _tmp271_->index;
						_tmp273_ = dest;
						_tmp274_ = a;
						_tmp275_ = _tmp274_->length;
						_tmp276_ = a;
						_tmp277_ = _tmp276_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp269_, _tmp270_, _tmp272_, _tmp273_ - _tmp275_, _tmp277_);
						_tmp278_ = b;
						_tmp279_ = self->priv->list;
						_tmp280_ = b;
						_tmp281_ = _tmp280_->index;
						_tmp282_ = dest;
						_tmp283_ = a;
						_tmp284_ = _tmp283_->length;
						_tmp285_ = b;
						_tmp286_ = _tmp285_->length;
						_tmp287_ = b;
						_tmp288_ = _tmp287_->length;
						vala_tim_sort_slice_merge_in_reversed (_tmp278_, _tmp279_, _tmp281_, (_tmp282_ - _tmp284_) - _tmp286_, _tmp288_);
					}
					_vala_tim_sort_slice_free0 (a);
					_vala_tim_sort_slice_free0 (b);
					return;
				}
				_tmp290_ = a_count;
				if (_tmp290_ < VALA_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp291_;
					_tmp291_ = b_count;
					_tmp289_ = _tmp291_ < VALA_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp289_ = FALSE;
				}
				if (_tmp289_) {
					break;
				}
			}
			_tmp292_ = minimum_gallop;
			minimum_gallop = _tmp292_ + 1;
			_tmp293_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp293_;
		}
	}
	__finally1:
	{
		ValaTimSortSlice* _tmp294_;
		gint _tmp295_;
		ValaTimSortSlice* _tmp296_;
		gint _tmp297_;
		ValaTimSortSlice* _tmp298_;
		void** _tmp299_;
		ValaTimSortSlice* _tmp300_;
		gint _tmp301_;
		gint _tmp302_;
		ValaTimSortSlice* _tmp303_;
		gint _tmp304_;
		ValaTimSortSlice* _tmp305_;
		gint _tmp306_;
		ValaTimSortSlice* _tmp307_;
		void** _tmp308_;
		ValaTimSortSlice* _tmp309_;
		gint _tmp310_;
		gint _tmp311_;
		ValaTimSortSlice* _tmp312_;
		gint _tmp313_;
		ValaTimSortSlice* _tmp314_;
		gint _tmp315_;
		ValaTimSortSlice* _tmp316_;
		gint _tmp317_;
		_tmp294_ = a;
		_tmp295_ = _tmp294_->length;
		_vala_assert (_tmp295_ >= 0, "a.length >= 0");
		_tmp296_ = b;
		_tmp297_ = _tmp296_->length;
		_vala_assert (_tmp297_ >= 0, "b.length >= 0");
		_tmp298_ = a;
		_tmp299_ = self->priv->list;
		_tmp300_ = a;
		_tmp301_ = _tmp300_->index;
		_tmp302_ = dest;
		_tmp303_ = a;
		_tmp304_ = _tmp303_->length;
		_tmp305_ = a;
		_tmp306_ = _tmp305_->length;
		vala_tim_sort_slice_merge_in_reversed (_tmp298_, _tmp299_, _tmp301_, _tmp302_ - _tmp304_, _tmp306_);
		_tmp307_ = b;
		_tmp308_ = self->priv->list;
		_tmp309_ = b;
		_tmp310_ = _tmp309_->index;
		_tmp311_ = dest;
		_tmp312_ = a;
		_tmp313_ = _tmp312_->length;
		_tmp314_ = b;
		_tmp315_ = _tmp314_->length;
		_tmp316_ = b;
		_tmp317_ = _tmp316_->length;
		vala_tim_sort_slice_merge_in_reversed (_tmp307_, _tmp308_, _tmp310_, (_tmp311_ - _tmp313_) - _tmp315_, _tmp317_);
	}
	_vala_tim_sort_slice_free0 (a);
	_vala_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


G_GNUC_INTERNAL ValaTimSort* vala_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	ValaTimSort* self = NULL;
	self = (ValaTimSort*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


G_GNUC_INTERNAL ValaTimSort* vala_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return vala_tim_sort_construct (VALA_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
}


static ValaTimSortSlice* vala_tim_sort_slice_new (void** list, gint index, gint length) {
	ValaTimSortSlice* self;
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = g_slice_new0 (ValaTimSortSlice);
	vala_tim_sort_slice_instance_init (self);
	_tmp0_ = list;
	self->list = _tmp0_;
	_tmp1_ = index;
	self->index = _tmp1_;
	_tmp2_ = length;
	self->length = _tmp2_;
	return self;
}


static void vala_tim_sort_slice_copy (ValaTimSortSlice* self) {
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	void** _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = g_memdup (&_tmp0_[_tmp1_], ((guint) sizeof (gpointer)) * _tmp2_);
	self->new_list = _tmp3_;
	_tmp4_ = self->new_list;
	self->list = _tmp4_;
	self->index = 0;
}


static inline void vala_tim_sort_slice_merge_in (ValaTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	void** _tmp0_;
	gint _tmp1_;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dest_array;
	_tmp1_ = dest_index;
	_tmp2_ = self->list;
	_tmp3_ = index;
	_tmp4_ = count;
	g_memmove (&_tmp0_[_tmp1_], &_tmp2_[_tmp3_], (gsize) (sizeof (gpointer) * _tmp4_));
}


static inline void vala_tim_sort_slice_merge_in_reversed (ValaTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	void** _tmp0_;
	gint _tmp1_;
	void** _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dest_array;
	_tmp1_ = dest_index;
	_tmp2_ = self->list;
	_tmp3_ = index;
	_tmp4_ = count;
	g_memmove (&_tmp0_[_tmp1_], &_tmp2_[_tmp3_], (gsize) (sizeof (gpointer) * _tmp4_));
}


static inline void vala_tim_sort_slice_shorten_start (ValaTimSortSlice* self, gint n) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	_tmp1_ = n;
	self->index = _tmp0_ + _tmp1_;
	_tmp2_ = self->length;
	_tmp3_ = n;
	self->length = _tmp2_ - _tmp3_;
}


static inline void vala_tim_sort_slice_shorten_end (ValaTimSortSlice* self, gint n) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->length;
	_tmp1_ = n;
	self->length = _tmp0_ - _tmp1_;
}


static inline void* vala_tim_sort_slice_pop_first (ValaTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	self->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}


static inline void* vala_tim_sort_slice_pop_last (ValaTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_;
	void** _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	void* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	_tmp3_ = self->length;
	_tmp4_ = _tmp1_[_tmp2_ + _tmp3_];
	result = _tmp4_;
	return result;
}


static inline void* vala_tim_sort_slice_peek_first (ValaTimSortSlice* self) {
	void* result = NULL;
	void** _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = _tmp0_[_tmp1_];
	result = _tmp2_;
	return result;
}


static inline void* vala_tim_sort_slice_peek_last (ValaTimSortSlice* self) {
	void* result = NULL;
	void** _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = _tmp0_[(_tmp1_ + _tmp2_) - 1];
	result = _tmp3_;
	return result;
}


static void vala_tim_sort_slice_reverse (ValaTimSortSlice* self) {
	gint low = 0;
	gint _tmp0_;
	gint high = 0;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	low = _tmp0_;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	high = (_tmp1_ + _tmp2_) - 1;
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = low;
		_tmp4_ = high;
		if (!(_tmp3_ < _tmp4_)) {
			break;
		}
		_tmp5_ = low;
		low = _tmp5_ + 1;
		_tmp6_ = high;
		high = _tmp6_ - 1;
		vala_tim_sort_slice_swap (self, _tmp5_, _tmp6_);
	}
}


static inline void vala_tim_sort_slice_swap (ValaTimSortSlice* self, gint i, gint j) {
	void* temp = NULL;
	void** _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	void** _tmp3_;
	gint _tmp4_;
	void** _tmp5_;
	gint _tmp6_;
	void* _tmp7_;
	void* _tmp8_;
	void** _tmp9_;
	gint _tmp10_;
	void* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = i;
	_tmp2_ = _tmp0_[_tmp1_];
	temp = _tmp2_;
	_tmp3_ = self->list;
	_tmp4_ = i;
	_tmp5_ = self->list;
	_tmp6_ = j;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp3_[_tmp4_] = _tmp7_;
	_tmp8_ = _tmp3_[_tmp4_];
	_tmp9_ = self->list;
	_tmp10_ = j;
	_tmp9_[_tmp10_] = temp;
	_tmp11_ = _tmp9_[_tmp10_];
}


static void vala_tim_sort_slice_instance_init (ValaTimSortSlice * self) {
}


static void vala_tim_sort_slice_free (ValaTimSortSlice * self) {
	void** _tmp0_;
	_tmp0_ = self->new_list;
	if (_tmp0_ != NULL) {
		void** _tmp1_;
		_tmp1_ = self->new_list;
		g_free (_tmp1_);
	}
	g_slice_free (ValaTimSortSlice, self);
}


static void vala_value_tim_sort_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_tim_sort_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_tim_sort_unref (value->data[0].v_pointer);
	}
}


static void vala_value_tim_sort_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_tim_sort_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_tim_sort_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_tim_sort_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaTimSort * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_tim_sort_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_tim_sort_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaTimSort ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_tim_sort_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec* vala_param_spec_tim_sort (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecTimSort* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_TIM_SORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer vala_value_get_tim_sort (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TIM_SORT), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void vala_value_set_tim_sort (GValue* value, gpointer v_object) {
	ValaTimSort * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TIM_SORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TIM_SORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_tim_sort_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_tim_sort_unref (old);
	}
}


G_GNUC_INTERNAL void vala_value_take_tim_sort (GValue* value, gpointer v_object) {
	ValaTimSort * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_TIM_SORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_TIM_SORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_tim_sort_unref (old);
	}
}


static void vala_tim_sort_class_init (ValaTimSortClass * klass) {
	vala_tim_sort_parent_class = g_type_class_peek_parent (klass);
	((ValaTimSortClass *) klass)->finalize = vala_tim_sort_finalize;
	g_type_class_add_private (klass, sizeof (ValaTimSortPrivate));
}


static void vala_tim_sort_instance_init (ValaTimSort * self) {
	self->priv = VALA_TIM_SORT_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_tim_sort_finalize (ValaTimSort * obj) {
	ValaTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TIM_SORT, ValaTimSort);
	g_signal_handlers_destroy (self);
	_vala_iterable_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) vala_tim_sort_slice_free), NULL);
}


/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 * [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 * [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
G_GNUC_INTERNAL GType vala_tim_sort_get_type (void) {
	static volatile gsize vala_tim_sort_type_id__volatile = 0;
	if (g_once_init_enter (&vala_tim_sort_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_tim_sort_init, vala_value_tim_sort_free_value, vala_value_tim_sort_copy_value, vala_value_tim_sort_peek_pointer, "p", vala_value_tim_sort_collect_value, "p", vala_value_tim_sort_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTimSort), 0, (GInstanceInitFunc) vala_tim_sort_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_tim_sort_type_id;
		vala_tim_sort_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaTimSort", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_tim_sort_type_id__volatile, vala_tim_sort_type_id);
	}
	return vala_tim_sort_type_id__volatile;
}


G_GNUC_INTERNAL gpointer vala_tim_sort_ref (gpointer instance) {
	ValaTimSort * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void vala_tim_sort_unref (gpointer instance) {
	ValaTimSort * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_TIM_SORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



