/* valaenumvalue.c generated by valac, the Vala compiler
 * generated from valaenumvalue.vala, do not modify */

/* valaenumvalue.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_ENUM_VALUE_0_PROPERTY,
	VALA_ENUM_VALUE_NUM_PROPERTIES
};
static GParamSpec* vala_enum_value_properties[VALA_ENUM_VALUE_NUM_PROPERTIES];


static gpointer vala_enum_value_parent_class = NULL;

static void vala_enum_value_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_enum_value_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_enum_value_real_check (ValaCodeNode* base, ValaCodeContext* context);


/**
 * Creates a new enum value with the specified numerical representation.
 *
 * @param name  enum value name
 * @param value numerical representation
 * @return      newly created enum value
 */
ValaEnumValue* vala_enum_value_construct (GType object_type, const gchar* name, ValaExpression* value, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaEnumValue* self = NULL;
	const gchar* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaComment* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = value;
	_tmp2_ = source_reference;
	_tmp3_ = comment;
	self = (ValaEnumValue*) vala_constant_construct (object_type, _tmp0_, NULL, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


ValaEnumValue* vala_enum_value_new (const gchar* name, ValaExpression* value, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_enum_value_construct (VALA_TYPE_ENUM_VALUE, name, value, source_reference, comment);
}


static void vala_enum_value_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaEnumValue * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaEnumValue*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_enum_value (_tmp0_, self);
}


static void vala_enum_value_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaEnumValue * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaEnumValue*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_constant_get_value ((ValaConstant*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		_tmp2_ = vala_constant_get_value ((ValaConstant*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
}


static gboolean vala_enum_value_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaEnumValue * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	self = (ValaEnumValue*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_constant_get_value ((ValaConstant*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaCodeContext* _tmp8_;
		_tmp6_ = vala_constant_get_value ((ValaConstant*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, _tmp8_);
	}
	_tmp9_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	result = !_tmp10_;
	return result;
}


static void vala_enum_value_class_init (ValaEnumValueClass * klass) {
	vala_enum_value_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_enum_value_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_enum_value_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_enum_value_real_check;
}


static void vala_enum_value_instance_init (ValaEnumValue * self) {
}


/**
 * Represents an enum member in the source code.
 */
GType vala_enum_value_get_type (void) {
	static volatile gsize vala_enum_value_type_id__volatile = 0;
	if (g_once_init_enter (&vala_enum_value_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaEnumValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_enum_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaEnumValue), 0, (GInstanceInitFunc) vala_enum_value_instance_init, NULL };
		GType vala_enum_value_type_id;
		vala_enum_value_type_id = g_type_register_static (VALA_TYPE_CONSTANT, "ValaEnumValue", &g_define_type_info, 0);
		g_once_init_leave (&vala_enum_value_type_id__volatile, vala_enum_value_type_id);
	}
	return vala_enum_value_type_id__volatile;
}



