/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
enum  {
	VALA_COMPILER_0_PROPERTY,
	VALA_COMPILER_NUM_PROPERTIES
};
static GParamSpec* vala_compiler_properties[VALA_COMPILER_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args;
static gchar* vala_compiler_run_args = NULL;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, 
                                      const gchar* nick, 
                                      const gchar* blurb, 
                                      GType object_type, 
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, 
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, 
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_parse_color (const gchar* option_name, 
                                           const gchar* val, 
                                           void* data, 
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gint vala_compiler_run_source (gchar** args, 
                               int args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array, 
                       int* length, 
                       int* size, 
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, 
                  GPid pid, 
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid, 
                                     gint status, 
                                     gpointer self);
static gint vala_compiler_main (gchar** args, 
                         int args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[59] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executeable", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gboolean
vala_compiler_option_parse_color (const gchar* option_name, 
                                  const gchar* val, 
                                  void* data, 
                                  GError** error)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error_ = _tmp3_;
				if (_inner_error_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gint
vala_compiler_quit (ValaCompiler* self)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		_tmp12_ = vala_compiler_fatal_warnings;
		if (!_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp13_;
			ValaReport* _tmp14_;
			ValaReport* _tmp15_;
			_tmp13_ = self->priv->context;
			_tmp14_ = vala_code_context_get_report (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = vala_report_get_warnings (_tmp15_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp16_;
		_tmp16_ = vala_compiler_quiet_mode;
		if (!_tmp16_) {
			FILE* _tmp17_;
			ValaCodeContext* _tmp18_;
			ValaReport* _tmp19_;
			ValaReport* _tmp20_;
			_tmp17_ = stdout;
			_tmp18_ = self->priv->context;
			_tmp19_ = vala_code_context_get_report (_tmp18_);
			_tmp20_ = _tmp19_;
			fprintf (_tmp17_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp20_));
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp21_;
		_tmp21_ = vala_compiler_quiet_mode;
		if (!_tmp21_) {
			FILE* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			ValaCodeContext* _tmp26_;
			ValaReport* _tmp27_;
			ValaReport* _tmp28_;
			_tmp22_ = stdout;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->context;
			_tmp27_ = vala_code_context_get_report (_tmp26_);
			_tmp28_ = _tmp27_;
			fprintf (_tmp22_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp25_), vala_report_get_warnings (_tmp28_));
		}
		result = 1;
		return result;
	}
}


static gint
string_last_index_of_char (const gchar* self, 
                           gunichar c, 
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
string_contains (const gchar* self, 
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint
vala_compiler_run (ValaCompiler* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	ValaReportColored _tmp3_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	ValaCodeContext* _tmp30_;
	gboolean _tmp31_;
	ValaCodeContext* _tmp32_;
	gboolean _tmp33_;
	ValaCodeContext* _tmp34_;
	gboolean _tmp35_;
	ValaCodeContext* _tmp36_;
	gboolean _tmp37_;
	ValaCodeContext* _tmp38_;
	gboolean _tmp39_;
	ValaCodeContext* _tmp40_;
	gboolean _tmp41_;
	ValaCodeContext* _tmp42_;
	gboolean _tmp43_;
	ValaCodeContext* _tmp44_;
	gboolean _tmp45_;
	ValaCodeContext* _tmp46_;
	ValaReport* _tmp47_;
	ValaReport* _tmp48_;
	gboolean _tmp49_;
	ValaCodeContext* _tmp50_;
	ValaReport* _tmp51_;
	ValaReport* _tmp52_;
	gboolean _tmp53_;
	ValaCodeContext* _tmp54_;
	gboolean _tmp55_;
	ValaCodeContext* _tmp56_;
	gboolean _tmp57_;
	ValaCodeContext* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_;
	ValaCodeContext* _tmp63_;
	gboolean _tmp64_;
	ValaCodeContext* _tmp65_;
	const gchar* _tmp66_;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_;
	ValaCodeContext* _tmp70_;
	gboolean _tmp71_;
	ValaCodeContext* _tmp72_;
	const gchar* _tmp73_;
	ValaCodeContext* _tmp74_;
	const gchar* _tmp75_;
	ValaCodeContext* _tmp76_;
	const gchar* _tmp77_;
	ValaCodeContext* _tmp78_;
	const gchar* _tmp79_;
	gboolean _tmp80_ = FALSE;
	const gchar* _tmp81_;
	const gchar* _tmp83_;
	const gchar* _tmp91_;
	ValaCodeContext* _tmp100_;
	gchar** _tmp101_;
	gint _tmp101__length1;
	ValaCodeContext* _tmp102_;
	gboolean _tmp103_;
	ValaCodeContext* _tmp104_;
	gchar** _tmp105_;
	gint _tmp105__length1;
	ValaCodeContext* _tmp106_;
	gchar** _tmp107_;
	gint _tmp107__length1;
	ValaCodeContext* _tmp108_;
	gboolean _tmp109_;
	ValaCodeContext* _tmp110_;
	gboolean _tmp111_;
	ValaCodeContext* _tmp112_;
	gboolean _tmp113_;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_;
	gboolean _tmp117_ = FALSE;
	gboolean _tmp118_ = FALSE;
	const gchar* _tmp119_;
	gboolean _tmp127_;
	const gchar* _tmp128_;
	ValaCodeContext* _tmp129_;
	gboolean _tmp130_;
	ValaCodeContext* _tmp131_;
	const gchar* _tmp132_;
	ValaCodeContext* _tmp133_;
	gboolean _tmp134_;
	gchar** _tmp135_;
	gint _tmp135__length1;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp147_ = FALSE;
	const gchar* _tmp148_;
	ValaCodeContext* _tmp150_;
	gint _tmp151_;
	ValaCodeContext* _tmp152_;
	gint _tmp153_;
	ValaCodeContext* _tmp154_;
	gint _tmp155_;
	gint _tmp156_;
	gboolean _tmp165_;
	gchar** _tmp168_;
	gint _tmp168__length1;
	gchar** _tmp173_;
	gint _tmp173__length1;
	ValaCodeContext* _tmp184_;
	gchar** _tmp185_;
	gint _tmp185__length1;
	ValaCodeContext* _tmp186_;
	gchar** _tmp187_;
	gint _tmp187__length1;
	gboolean _tmp188_ = FALSE;
	ValaCodeContext* _tmp189_;
	ValaReport* _tmp190_;
	ValaReport* _tmp191_;
	ValaCodeContext* _tmp197_;
	ValaGDBusServerModule* _tmp198_;
	ValaGDBusServerModule* _tmp199_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp200_;
	gint _tmp200__length1;
	gboolean _tmp207_ = FALSE;
	gboolean _tmp208_;
	gboolean _tmp212_ = FALSE;
	ValaCodeContext* _tmp213_;
	ValaReport* _tmp214_;
	ValaReport* _tmp215_;
	ValaParser* parser = NULL;
	ValaParser* _tmp221_;
	ValaParser* _tmp222_;
	ValaCodeContext* _tmp223_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp224_;
	ValaGenieParser* _tmp225_;
	ValaCodeContext* _tmp226_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp227_;
	ValaGirParser* _tmp228_;
	ValaCodeContext* _tmp229_;
	gboolean _tmp230_ = FALSE;
	ValaCodeContext* _tmp231_;
	ValaReport* _tmp232_;
	ValaReport* _tmp233_;
	const gchar* _tmp239_;
	ValaCodeContext* _tmp244_;
	gboolean _tmp245_ = FALSE;
	ValaCodeContext* _tmp246_;
	ValaReport* _tmp247_;
	ValaReport* _tmp248_;
	gboolean _tmp254_ = FALSE;
	gboolean _tmp255_ = FALSE;
	gboolean _tmp256_;
	const gchar* _tmp264_;
	gboolean _tmp269_ = FALSE;
	ValaCodeContext* _tmp270_;
	ValaReport* _tmp271_;
	ValaReport* _tmp272_;
	ValaCodeContext* _tmp278_;
	ValaCodeGenerator* _tmp279_;
	ValaCodeGenerator* _tmp280_;
	ValaCodeContext* _tmp281_;
	gboolean _tmp282_ = FALSE;
	ValaCodeContext* _tmp283_;
	ValaReport* _tmp284_;
	ValaReport* _tmp285_;
	gboolean _tmp291_ = FALSE;
	const gchar* _tmp292_;
	const gchar* _tmp296_;
	const gchar* _tmp344_;
	const gchar* _tmp357_;
	const gchar* _tmp378_;
	gboolean _tmp381_ = FALSE;
	ValaCodeContext* _tmp382_;
	ValaReport* _tmp383_;
	ValaReport* _tmp384_;
	gboolean _tmp390_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_colored_output;
	if (_tmp2_) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp3_ = vala_compiler_colored_output;
	if (_tmp3_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp4_;
		_tmp5_ = env_colors;
		if (_tmp5_ != NULL) {
			ValaCodeContext* _tmp6_;
			ValaReport* _tmp7_;
			ValaReport* _tmp8_;
			const gchar* _tmp9_;
			ValaReportColored _tmp10_;
			_tmp6_ = self->priv->context;
			_tmp7_ = vala_code_context_get_report (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = env_colors;
			_tmp10_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp8_, _tmp9_, _tmp10_);
		} else {
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			ValaReportColored _tmp14_;
			_tmp11_ = self->priv->context;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp13_, VALA_COMPILER_DEFAULT_COLORS, _tmp14_);
		}
	}
	_tmp17_ = vala_compiler_ccode_only;
	if (!_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = vala_compiler_compile_only;
		_tmp16_ = !_tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_;
		_tmp19_ = vala_compiler_output;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		_tmp20_ = vala_compiler_sources;
		_tmp20__length1 = _vala_array_length (vala_compiler_sources);
		_tmp21_ = _tmp20_[0];
		if (string_last_index_of_char (_tmp21_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gint _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp22_ = vala_compiler_sources;
			_tmp22__length1 = _vala_array_length (vala_compiler_sources);
			_tmp23_ = _tmp22_[0];
			dot = string_last_index_of_char (_tmp23_, (gunichar) '.', 0);
			_tmp24_ = vala_compiler_sources;
			_tmp24__length1 = _vala_array_length (vala_compiler_sources);
			_tmp25_ = _tmp24_[0];
			_tmp26_ = dot;
			_tmp27_ = string_substring (_tmp25_, (glong) 0, (glong) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_path_get_basename (_tmp28_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp29_;
			_g_free0 (_tmp28_);
		}
	}
	_tmp30_ = self->priv->context;
	_tmp31_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp30_, !_tmp31_);
	_tmp32_ = self->priv->context;
	_tmp33_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp32_, _tmp33_);
	_tmp34_ = self->priv->context;
	_tmp35_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->context;
	_tmp37_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp36_, !_tmp37_);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->context;
	_tmp41_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->context;
	_tmp43_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->context;
	_tmp45_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->context;
	_tmp47_ = vala_code_context_get_report (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp48_, !_tmp49_);
	_tmp50_ = self->priv->context;
	_tmp51_ = vala_code_context_get_report (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp52_, !_tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp56_, !_tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp58_, _tmp59_);
	_tmp61_ = vala_compiler_ccode_only;
	if (_tmp61_) {
		gchar** _tmp62_;
		gint _tmp62__length1;
		_tmp62_ = vala_compiler_cc_options;
		_tmp62__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp60_ = _tmp62_ != NULL;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->context;
	_tmp66_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp65_, _tmp66_);
	_tmp68_ = vala_compiler_header_filename;
	if (_tmp68_ == NULL) {
		gboolean _tmp69_;
		_tmp69_ = vala_compiler_use_header;
		_tmp67_ = _tmp69_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp70_ = self->priv->context;
	_tmp71_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp70_, _tmp71_);
	_tmp72_ = self->priv->context;
	_tmp73_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp74_, _tmp75_);
	_tmp76_ = self->priv->context;
	_tmp77_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->context;
	_tmp79_ = vala_compiler_output;
	vala_code_context_set_output (_tmp78_, _tmp79_);
	_tmp81_ = vala_compiler_output;
	if (_tmp81_ != NULL) {
		gboolean _tmp82_;
		_tmp82_ = vala_compiler_ccode_only;
		_tmp80_ = _tmp82_;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp83_ = vala_compiler_basedir;
	if (_tmp83_ == NULL) {
		ValaCodeContext* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		_tmp84_ = self->priv->context;
		_tmp85_ = vala_code_context_realpath (".");
		_tmp86_ = _tmp85_;
		vala_code_context_set_basedir (_tmp84_, _tmp86_);
		_g_free0 (_tmp86_);
	} else {
		ValaCodeContext* _tmp87_;
		const gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp87_ = self->priv->context;
		_tmp88_ = vala_compiler_basedir;
		_tmp89_ = vala_code_context_realpath (_tmp88_);
		_tmp90_ = _tmp89_;
		vala_code_context_set_basedir (_tmp87_, _tmp90_);
		_g_free0 (_tmp90_);
	}
	_tmp91_ = vala_compiler_directory;
	if (_tmp91_ != NULL) {
		ValaCodeContext* _tmp92_;
		const gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp92_ = self->priv->context;
		_tmp93_ = vala_compiler_directory;
		_tmp94_ = vala_code_context_realpath (_tmp93_);
		_tmp95_ = _tmp94_;
		vala_code_context_set_directory (_tmp92_, _tmp95_);
		_g_free0 (_tmp95_);
	} else {
		ValaCodeContext* _tmp96_;
		ValaCodeContext* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		_tmp96_ = self->priv->context;
		_tmp97_ = self->priv->context;
		_tmp98_ = vala_code_context_get_basedir (_tmp97_);
		_tmp99_ = _tmp98_;
		vala_code_context_set_directory (_tmp96_, _tmp99_);
	}
	_tmp100_ = self->priv->context;
	_tmp101_ = vala_compiler_vapi_directories;
	_tmp101__length1 = _vala_array_length (vala_compiler_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp100_, _tmp101_, _tmp101__length1);
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp102_, _tmp103_);
	_tmp104_ = self->priv->context;
	_tmp105_ = vala_compiler_gir_directories;
	_tmp105__length1 = _vala_array_length (vala_compiler_gir_directories);
	vala_code_context_set_gir_directories (_tmp104_, _tmp105_, _tmp105__length1);
	_tmp106_ = self->priv->context;
	_tmp107_ = vala_compiler_metadata_directories;
	_tmp107__length1 = _vala_array_length (vala_compiler_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp106_, _tmp107_, _tmp107__length1);
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp108_, _tmp109_);
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp112_, _tmp113_);
	_tmp115_ = vala_compiler_ccode_only;
	if (_tmp115_) {
		gboolean _tmp116_;
		_tmp116_ = vala_compiler_save_temps;
		_tmp114_ = _tmp116_;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp119_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp119_, "gobject-2.0") == 0) {
		_tmp118_ = TRUE;
	} else {
		const gchar* _tmp120_;
		_tmp120_ = vala_compiler_profile;
		_tmp118_ = g_strcmp0 (_tmp120_, "gobject") == 0;
	}
	if (_tmp118_) {
		_tmp117_ = TRUE;
	} else {
		const gchar* _tmp121_;
		_tmp121_ = vala_compiler_profile;
		_tmp117_ = _tmp121_ == NULL;
	}
	if (_tmp117_) {
		ValaCodeContext* _tmp122_;
		ValaCodeContext* _tmp123_;
		_tmp122_ = self->priv->context;
		vala_code_context_set_profile (_tmp122_, VALA_PROFILE_GOBJECT);
		_tmp123_ = self->priv->context;
		vala_code_context_add_define (_tmp123_, "GOBJECT");
	} else {
		const gchar* _tmp124_;
		gchar* _tmp125_;
		gchar* _tmp126_;
		_tmp124_ = vala_compiler_profile;
		_tmp125_ = g_strdup_printf ("Unknown profile %s", _tmp124_);
		_tmp126_ = _tmp125_;
		vala_report_error (NULL, _tmp126_);
		_g_free0 (_tmp126_);
	}
	_tmp127_ = vala_compiler_nostdpkg;
	_tmp128_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp127_ | (_tmp128_ != NULL);
	_tmp129_ = self->priv->context;
	_tmp130_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp129_, _tmp130_);
	_tmp131_ = self->priv->context;
	_tmp132_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp131_, _tmp132_);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp133_, _tmp134_);
	_tmp135_ = vala_compiler_defines;
	_tmp135__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp135_ != NULL) {
		gchar** _tmp136_;
		gint _tmp136__length1;
		_tmp136_ = vala_compiler_defines;
		_tmp136__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp136_;
			define_collection_length1 = _tmp136__length1;
			for (define_it = 0; define_it < _tmp136__length1; define_it = define_it + 1) {
				gchar* _tmp137_;
				gchar* define = NULL;
				_tmp137_ = g_strdup (define_collection[define_it]);
				define = _tmp137_;
				{
					ValaCodeContext* _tmp138_;
					const gchar* _tmp139_;
					_tmp138_ = self->priv->context;
					_tmp139_ = define;
					vala_code_context_add_define (_tmp138_, _tmp139_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp140_ = FALSE;
			_tmp140_ = TRUE;
			while (TRUE) {
				gint _tmp142_;
				ValaCodeContext* _tmp143_;
				gint _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				if (!_tmp140_) {
					gint _tmp141_;
					_tmp141_ = i;
					i = _tmp141_ + 2;
				}
				_tmp140_ = FALSE;
				_tmp142_ = i;
				if (!(_tmp142_ <= 40)) {
					break;
				}
				_tmp143_ = self->priv->context;
				_tmp144_ = i;
				_tmp145_ = g_strdup_printf ("VALA_0_%d", _tmp144_);
				_tmp146_ = _tmp145_;
				vala_code_context_add_define (_tmp143_, _tmp146_);
				_g_free0 (_tmp146_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 40;
	_tmp148_ = vala_compiler_target_glib;
	if (_tmp148_ != NULL) {
		const gchar* _tmp149_;
		_tmp149_ = vala_compiler_target_glib;
		_tmp147_ = sscanf (_tmp149_, "%d.%d", &glib_major, &glib_minor) != 2;
	} else {
		_tmp147_ = FALSE;
	}
	if (_tmp147_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp150_ = self->priv->context;
	_tmp151_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp150_, _tmp151_);
	_tmp152_ = self->priv->context;
	_tmp153_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp152_, _tmp153_);
	_tmp154_ = self->priv->context;
	_tmp155_ = vala_code_context_get_target_glib_major (_tmp154_);
	_tmp156_ = _tmp155_;
	if (_tmp156_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp157_ = FALSE;
			_tmp157_ = TRUE;
			while (TRUE) {
				gint _tmp159_;
				gint _tmp160_;
				ValaCodeContext* _tmp161_;
				gint _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				if (!_tmp157_) {
					gint _tmp158_;
					_tmp158_ = i;
					i = _tmp158_ + 2;
				}
				_tmp157_ = FALSE;
				_tmp159_ = i;
				_tmp160_ = glib_minor;
				if (!(_tmp159_ <= _tmp160_)) {
					break;
				}
				_tmp161_ = self->priv->context;
				_tmp162_ = i;
				_tmp163_ = g_strdup_printf ("GLIB_2_%d", _tmp162_);
				_tmp164_ = _tmp163_;
				vala_code_context_add_define (_tmp161_, _tmp164_);
				_g_free0 (_tmp164_);
			}
		}
	}
	_tmp165_ = vala_compiler_nostdpkg;
	if (!_tmp165_) {
		ValaCodeContext* _tmp166_;
		ValaCodeContext* _tmp167_;
		_tmp166_ = self->priv->context;
		vala_code_context_add_external_package (_tmp166_, "glib-2.0");
		_tmp167_ = self->priv->context;
		vala_code_context_add_external_package (_tmp167_, "gobject-2.0");
	}
	_tmp168_ = vala_compiler_packages;
	_tmp168__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp168_ != NULL) {
		gchar** _tmp169_;
		gint _tmp169__length1;
		_tmp169_ = vala_compiler_packages;
		_tmp169__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp169_;
			package_collection_length1 = _tmp169__length1;
			for (package_it = 0; package_it < _tmp169__length1; package_it = package_it + 1) {
				gchar* _tmp170_;
				gchar* package = NULL;
				_tmp170_ = g_strdup (package_collection[package_it]);
				package = _tmp170_;
				{
					ValaCodeContext* _tmp171_;
					const gchar* _tmp172_;
					_tmp171_ = self->priv->context;
					_tmp172_ = package;
					vala_code_context_add_external_package (_tmp171_, _tmp172_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp173_ = vala_compiler_fast_vapis;
	_tmp173__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp173_ != NULL) {
		gchar** _tmp174_;
		gint _tmp174__length1;
		ValaCodeContext* _tmp183_;
		_tmp174_ = vala_compiler_fast_vapis;
		_tmp174__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp174_;
			vapi_collection_length1 = _tmp174__length1;
			for (vapi_it = 0; vapi_it < _tmp174__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp175_;
				gchar* vapi = NULL;
				_tmp175_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp175_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp176_;
					gchar* _tmp177_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp178_;
					const gchar* _tmp179_;
					ValaSourceFile* _tmp180_;
					ValaCodeContext* _tmp181_;
					ValaSourceFile* _tmp182_;
					_tmp176_ = vapi;
					_tmp177_ = vala_code_context_realpath (_tmp176_);
					rpath = _tmp177_;
					_tmp178_ = self->priv->context;
					_tmp179_ = rpath;
					_tmp180_ = vala_source_file_new (_tmp178_, VALA_SOURCE_FILE_TYPE_FAST, _tmp179_, NULL, FALSE);
					source_file = _tmp180_;
					_tmp181_ = self->priv->context;
					_tmp182_ = source_file;
					vala_code_context_add_source_file (_tmp181_, _tmp182_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp183_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp183_, TRUE);
	}
	_tmp184_ = self->priv->context;
	_tmp185_ = vala_compiler_gresources;
	_tmp185__length1 = _vala_array_length (vala_compiler_gresources);
	vala_code_context_set_gresources (_tmp184_, _tmp185_, _tmp185__length1);
	_tmp186_ = self->priv->context;
	_tmp187_ = vala_compiler_gresources_directories;
	_tmp187__length1 = _vala_array_length (vala_compiler_gresources_directories);
	vala_code_context_set_gresources_directories (_tmp186_, _tmp187_, _tmp187__length1);
	_tmp189_ = self->priv->context;
	_tmp190_ = vala_code_context_get_report (_tmp189_);
	_tmp191_ = _tmp190_;
	if (vala_report_get_errors (_tmp191_) > 0) {
		_tmp188_ = TRUE;
	} else {
		gboolean _tmp192_ = FALSE;
		gboolean _tmp193_;
		_tmp193_ = vala_compiler_fatal_warnings;
		if (_tmp193_) {
			ValaCodeContext* _tmp194_;
			ValaReport* _tmp195_;
			ValaReport* _tmp196_;
			_tmp194_ = self->priv->context;
			_tmp195_ = vala_code_context_get_report (_tmp194_);
			_tmp196_ = _tmp195_;
			_tmp192_ = vala_report_get_warnings (_tmp196_) > 0;
		} else {
			_tmp192_ = FALSE;
		}
		_tmp188_ = _tmp192_;
	}
	if (_tmp188_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp197_ = self->priv->context;
	_tmp198_ = vala_gd_bus_server_module_new ();
	_tmp199_ = _tmp198_;
	vala_code_context_set_codegen (_tmp197_, (ValaCodeGenerator*) _tmp199_);
	_vala_code_visitor_unref0 (_tmp199_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp200_ = vala_compiler_sources;
	_tmp200__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp200_;
		source_collection_length1 = _tmp200__length1;
		for (source_it = 0; source_it < _tmp200__length1; source_it = source_it + 1) {
			gchar* _tmp201_;
			gchar* source = NULL;
			_tmp201_ = g_strdup (source_collection[source_it]);
			source = _tmp201_;
			{
				ValaCodeContext* _tmp202_;
				const gchar* _tmp203_;
				gboolean _tmp204_;
				_tmp202_ = self->priv->context;
				_tmp203_ = source;
				_tmp204_ = vala_compiler_run_output;
				if (vala_code_context_add_source_filename (_tmp202_, _tmp203_, _tmp204_, TRUE)) {
					const gchar* _tmp205_;
					_tmp205_ = source;
					if (g_str_has_suffix (_tmp205_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp206_;
						_tmp206_ = source;
						if (g_str_has_suffix (_tmp206_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp208_ = vala_compiler_ccode_only;
	if (_tmp208_) {
		gboolean _tmp209_ = FALSE;
		gboolean _tmp210_;
		_tmp210_ = has_c_files;
		if (_tmp210_) {
			_tmp209_ = TRUE;
		} else {
			gboolean _tmp211_;
			_tmp211_ = has_h_files;
			_tmp209_ = _tmp211_;
		}
		_tmp207_ = _tmp209_;
	} else {
		_tmp207_ = FALSE;
	}
	if (_tmp207_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp213_ = self->priv->context;
	_tmp214_ = vala_code_context_get_report (_tmp213_);
	_tmp215_ = _tmp214_;
	if (vala_report_get_errors (_tmp215_) > 0) {
		_tmp212_ = TRUE;
	} else {
		gboolean _tmp216_ = FALSE;
		gboolean _tmp217_;
		_tmp217_ = vala_compiler_fatal_warnings;
		if (_tmp217_) {
			ValaCodeContext* _tmp218_;
			ValaReport* _tmp219_;
			ValaReport* _tmp220_;
			_tmp218_ = self->priv->context;
			_tmp219_ = vala_code_context_get_report (_tmp218_);
			_tmp220_ = _tmp219_;
			_tmp216_ = vala_report_get_warnings (_tmp220_) > 0;
		} else {
			_tmp216_ = FALSE;
		}
		_tmp212_ = _tmp216_;
	}
	if (_tmp212_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp221_ = vala_parser_new ();
	parser = _tmp221_;
	_tmp222_ = parser;
	_tmp223_ = self->priv->context;
	vala_parser_parse (_tmp222_, _tmp223_);
	_tmp224_ = vala_genie_parser_new ();
	genie_parser = _tmp224_;
	_tmp225_ = genie_parser;
	_tmp226_ = self->priv->context;
	vala_genie_parser_parse (_tmp225_, _tmp226_);
	_tmp227_ = vala_gir_parser_new ();
	gir_parser = _tmp227_;
	_tmp228_ = gir_parser;
	_tmp229_ = self->priv->context;
	vala_gir_parser_parse (_tmp228_, _tmp229_);
	_tmp231_ = self->priv->context;
	_tmp232_ = vala_code_context_get_report (_tmp231_);
	_tmp233_ = _tmp232_;
	if (vala_report_get_errors (_tmp233_) > 0) {
		_tmp230_ = TRUE;
	} else {
		gboolean _tmp234_ = FALSE;
		gboolean _tmp235_;
		_tmp235_ = vala_compiler_fatal_warnings;
		if (_tmp235_) {
			ValaCodeContext* _tmp236_;
			ValaReport* _tmp237_;
			ValaReport* _tmp238_;
			_tmp236_ = self->priv->context;
			_tmp237_ = vala_code_context_get_report (_tmp236_);
			_tmp238_ = _tmp237_;
			_tmp234_ = vala_report_get_warnings (_tmp238_) > 0;
		} else {
			_tmp234_ = FALSE;
		}
		_tmp230_ = _tmp234_;
	}
	if (_tmp230_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp239_ = vala_compiler_fast_vapi_filename;
	if (_tmp239_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp240_;
		ValaCodeWriter* _tmp241_;
		ValaCodeContext* _tmp242_;
		const gchar* _tmp243_;
		_tmp240_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp240_;
		_tmp241_ = interface_writer;
		_tmp242_ = self->priv->context;
		_tmp243_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp241_, _tmp242_, _tmp243_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp244_ = self->priv->context;
	vala_code_context_check (_tmp244_);
	_tmp246_ = self->priv->context;
	_tmp247_ = vala_code_context_get_report (_tmp246_);
	_tmp248_ = _tmp247_;
	if (vala_report_get_errors (_tmp248_) > 0) {
		_tmp245_ = TRUE;
	} else {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_;
		_tmp250_ = vala_compiler_fatal_warnings;
		if (_tmp250_) {
			ValaCodeContext* _tmp251_;
			ValaReport* _tmp252_;
			ValaReport* _tmp253_;
			_tmp251_ = self->priv->context;
			_tmp252_ = vala_code_context_get_report (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp249_ = vala_report_get_warnings (_tmp253_) > 0;
		} else {
			_tmp249_ = FALSE;
		}
		_tmp245_ = _tmp249_;
	}
	if (_tmp245_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp256_ = vala_compiler_ccode_only;
	if (!_tmp256_) {
		gboolean _tmp257_;
		_tmp257_ = vala_compiler_compile_only;
		_tmp255_ = !_tmp257_;
	} else {
		_tmp255_ = FALSE;
	}
	if (_tmp255_) {
		const gchar* _tmp258_;
		_tmp258_ = vala_compiler_library;
		_tmp254_ = _tmp258_ == NULL;
	} else {
		_tmp254_ = FALSE;
	}
	if (_tmp254_) {
		gboolean _tmp259_ = FALSE;
		gboolean _tmp260_;
		_tmp260_ = has_c_files;
		if (!_tmp260_) {
			ValaCodeContext* _tmp261_;
			ValaMethod* _tmp262_;
			ValaMethod* _tmp263_;
			_tmp261_ = self->priv->context;
			_tmp262_ = vala_code_context_get_entry_point (_tmp261_);
			_tmp263_ = _tmp262_;
			_tmp259_ = _tmp263_ == NULL;
		} else {
			_tmp259_ = FALSE;
		}
		if (_tmp259_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp264_ = vala_compiler_dump_tree;
	if (_tmp264_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp265_;
		ValaCodeWriter* _tmp266_;
		ValaCodeContext* _tmp267_;
		const gchar* _tmp268_;
		_tmp265_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp265_;
		_tmp266_ = code_writer;
		_tmp267_ = self->priv->context;
		_tmp268_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp266_, _tmp267_, _tmp268_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp270_ = self->priv->context;
	_tmp271_ = vala_code_context_get_report (_tmp270_);
	_tmp272_ = _tmp271_;
	if (vala_report_get_errors (_tmp272_) > 0) {
		_tmp269_ = TRUE;
	} else {
		gboolean _tmp273_ = FALSE;
		gboolean _tmp274_;
		_tmp274_ = vala_compiler_fatal_warnings;
		if (_tmp274_) {
			ValaCodeContext* _tmp275_;
			ValaReport* _tmp276_;
			ValaReport* _tmp277_;
			_tmp275_ = self->priv->context;
			_tmp276_ = vala_code_context_get_report (_tmp275_);
			_tmp277_ = _tmp276_;
			_tmp273_ = vala_report_get_warnings (_tmp277_) > 0;
		} else {
			_tmp273_ = FALSE;
		}
		_tmp269_ = _tmp273_;
	}
	if (_tmp269_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp278_ = self->priv->context;
	_tmp279_ = vala_code_context_get_codegen (_tmp278_);
	_tmp280_ = _tmp279_;
	_tmp281_ = self->priv->context;
	vala_code_generator_emit (_tmp280_, _tmp281_);
	_tmp283_ = self->priv->context;
	_tmp284_ = vala_code_context_get_report (_tmp283_);
	_tmp285_ = _tmp284_;
	if (vala_report_get_errors (_tmp285_) > 0) {
		_tmp282_ = TRUE;
	} else {
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_;
		_tmp287_ = vala_compiler_fatal_warnings;
		if (_tmp287_) {
			ValaCodeContext* _tmp288_;
			ValaReport* _tmp289_;
			ValaReport* _tmp290_;
			_tmp288_ = self->priv->context;
			_tmp289_ = vala_code_context_get_report (_tmp288_);
			_tmp290_ = _tmp289_;
			_tmp286_ = vala_report_get_warnings (_tmp290_) > 0;
		} else {
			_tmp286_ = FALSE;
		}
		_tmp282_ = _tmp286_;
	}
	if (_tmp282_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp292_ = vala_compiler_vapi_filename;
	if (_tmp292_ == NULL) {
		const gchar* _tmp293_;
		_tmp293_ = vala_compiler_library;
		_tmp291_ = _tmp293_ != NULL;
	} else {
		_tmp291_ = FALSE;
	}
	if (_tmp291_) {
		const gchar* _tmp294_;
		gchar* _tmp295_;
		_tmp294_ = vala_compiler_library;
		_tmp295_ = g_strdup_printf ("%s.vapi", _tmp294_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp295_;
	}
	_tmp296_ = vala_compiler_library;
	if (_tmp296_ != NULL) {
		const gchar* _tmp297_;
		_tmp297_ = vala_compiler_gir;
		if (_tmp297_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp298_;
			gchar* _tmp299_;
			glong gir_len = 0L;
			const gchar* _tmp300_;
			gint _tmp301_;
			gint _tmp302_;
			gint last_hyphen = 0;
			const gchar* _tmp303_;
			gboolean _tmp304_ = FALSE;
			gint _tmp305_;
			_tmp298_ = vala_compiler_gir;
			_tmp299_ = g_path_get_basename (_tmp298_);
			gir_base = _tmp299_;
			_tmp300_ = gir_base;
			_tmp301_ = strlen (_tmp300_);
			_tmp302_ = _tmp301_;
			gir_len = (glong) _tmp302_;
			_tmp303_ = gir_base;
			last_hyphen = string_last_index_of_char (_tmp303_, (gunichar) '-', 0);
			_tmp305_ = last_hyphen;
			if (_tmp305_ == -1) {
				_tmp304_ = TRUE;
			} else {
				const gchar* _tmp306_;
				_tmp306_ = gir_base;
				_tmp304_ = !g_str_has_suffix (_tmp306_, ".gir");
			}
			if (_tmp304_) {
				const gchar* _tmp307_;
				gchar* _tmp308_;
				gchar* _tmp309_;
				_tmp307_ = vala_compiler_gir;
				_tmp308_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp307_);
				_tmp309_ = _tmp308_;
				vala_report_error (NULL, _tmp309_);
				_g_free0 (_tmp309_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp310_;
				gint _tmp311_;
				gchar* _tmp312_;
				gchar* gir_version = NULL;
				const gchar* _tmp313_;
				gint _tmp314_;
				glong _tmp315_;
				gint _tmp316_;
				gchar* _tmp317_;
				const gchar* _tmp318_;
				gboolean _tmp319_ = FALSE;
				gboolean _tmp320_ = FALSE;
				gboolean _tmp321_ = FALSE;
				const gchar* _tmp322_;
				_tmp310_ = gir_base;
				_tmp311_ = last_hyphen;
				_tmp312_ = string_substring (_tmp310_, (glong) 0, (glong) _tmp311_);
				gir_namespace = _tmp312_;
				_tmp313_ = gir_base;
				_tmp314_ = last_hyphen;
				_tmp315_ = gir_len;
				_tmp316_ = last_hyphen;
				_tmp317_ = string_substring (_tmp313_, (glong) (_tmp314_ + 1), (_tmp315_ - _tmp316_) - 5);
				gir_version = _tmp317_;
				_tmp318_ = gir_version;
				g_strcanon (_tmp318_, "0123456789.", '?');
				_tmp322_ = gir_namespace;
				if (g_strcmp0 (_tmp322_, "") == 0) {
					_tmp321_ = TRUE;
				} else {
					const gchar* _tmp323_;
					_tmp323_ = gir_version;
					_tmp321_ = g_strcmp0 (_tmp323_, "") == 0;
				}
				if (_tmp321_) {
					_tmp320_ = TRUE;
				} else {
					const gchar* _tmp324_;
					_tmp324_ = gir_version;
					_tmp320_ = !g_ascii_isdigit (string_get (_tmp324_, (glong) 0));
				}
				if (_tmp320_) {
					_tmp319_ = TRUE;
				} else {
					const gchar* _tmp325_;
					_tmp325_ = gir_version;
					_tmp319_ = string_contains (_tmp325_, "?");
				}
				if (_tmp319_) {
					const gchar* _tmp326_;
					gchar* _tmp327_;
					gchar* _tmp328_;
					_tmp326_ = vala_compiler_gir;
					_tmp327_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp326_);
					_tmp328_ = _tmp327_;
					vala_report_error (NULL, _tmp328_);
					_g_free0 (_tmp328_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp329_;
					gchar* gir_directory = NULL;
					gchar* _tmp330_;
					const gchar* _tmp331_;
					ValaGIRWriter* _tmp336_;
					ValaCodeContext* _tmp337_;
					const gchar* _tmp338_;
					const gchar* _tmp339_;
					const gchar* _tmp340_;
					const gchar* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					_tmp329_ = vala_gir_writer_new ();
					gir_writer = _tmp329_;
					_tmp330_ = g_strdup (".");
					gir_directory = _tmp330_;
					_tmp331_ = vala_compiler_directory;
					if (_tmp331_ != NULL) {
						ValaCodeContext* _tmp332_;
						const gchar* _tmp333_;
						const gchar* _tmp334_;
						gchar* _tmp335_;
						_tmp332_ = self->priv->context;
						_tmp333_ = vala_code_context_get_directory (_tmp332_);
						_tmp334_ = _tmp333_;
						_tmp335_ = g_strdup (_tmp334_);
						_g_free0 (gir_directory);
						gir_directory = _tmp335_;
					}
					_tmp336_ = gir_writer;
					_tmp337_ = self->priv->context;
					_tmp338_ = gir_directory;
					_tmp339_ = vala_compiler_gir;
					_tmp340_ = gir_namespace;
					_tmp341_ = gir_version;
					_tmp342_ = vala_compiler_library;
					_tmp343_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp336_, _tmp337_, _tmp338_, _tmp339_, _tmp340_, _tmp341_, _tmp342_, _tmp343_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp344_ = vala_compiler_vapi_filename;
	if (_tmp344_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp345_;
		gboolean _tmp346_ = FALSE;
		const gchar* _tmp347_;
		ValaCodeWriter* _tmp354_;
		ValaCodeContext* _tmp355_;
		const gchar* _tmp356_;
		_tmp345_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp345_;
		_tmp347_ = vala_compiler_directory;
		if (_tmp347_ != NULL) {
			const gchar* _tmp348_;
			_tmp348_ = vala_compiler_vapi_filename;
			_tmp346_ = !g_path_is_absolute (_tmp348_);
		} else {
			_tmp346_ = FALSE;
		}
		if (_tmp346_) {
			ValaCodeContext* _tmp349_;
			const gchar* _tmp350_;
			const gchar* _tmp351_;
			const gchar* _tmp352_;
			gchar* _tmp353_;
			_tmp349_ = self->priv->context;
			_tmp350_ = vala_code_context_get_directory (_tmp349_);
			_tmp351_ = _tmp350_;
			_tmp352_ = vala_compiler_vapi_filename;
			_tmp353_ = g_strdup_printf ("%s%c%s", _tmp351_, (gint) G_DIR_SEPARATOR, _tmp352_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp353_;
		}
		_tmp354_ = interface_writer;
		_tmp355_ = self->priv->context;
		_tmp356_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp354_, _tmp355_, _tmp356_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp357_ = vala_compiler_internal_vapi_filename;
	if (_tmp357_ != NULL) {
		gboolean _tmp358_ = FALSE;
		const gchar* _tmp359_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp361_;
		ValaCodeWriter* _tmp362_;
		const gchar* _tmp363_;
		const gchar* _tmp364_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp365_;
		gchar* _tmp366_;
		gboolean _tmp367_ = FALSE;
		const gchar* _tmp368_;
		ValaCodeWriter* _tmp375_;
		ValaCodeContext* _tmp376_;
		const gchar* _tmp377_;
		_tmp359_ = vala_compiler_internal_header_filename;
		if (_tmp359_ == NULL) {
			_tmp358_ = TRUE;
		} else {
			const gchar* _tmp360_;
			_tmp360_ = vala_compiler_header_filename;
			_tmp358_ = _tmp360_ == NULL;
		}
		if (_tmp358_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp361_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp361_;
		_tmp362_ = interface_writer;
		_tmp363_ = vala_compiler_header_filename;
		_tmp364_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp362_, _tmp363_, _tmp364_);
		_tmp365_ = vala_compiler_internal_vapi_filename;
		_tmp366_ = g_strdup (_tmp365_);
		vapi_filename = _tmp366_;
		_tmp368_ = vala_compiler_directory;
		if (_tmp368_ != NULL) {
			const gchar* _tmp369_;
			_tmp369_ = vapi_filename;
			_tmp367_ = !g_path_is_absolute (_tmp369_);
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCodeContext* _tmp370_;
			const gchar* _tmp371_;
			const gchar* _tmp372_;
			const gchar* _tmp373_;
			gchar* _tmp374_;
			_tmp370_ = self->priv->context;
			_tmp371_ = vala_code_context_get_directory (_tmp370_);
			_tmp372_ = _tmp371_;
			_tmp373_ = vapi_filename;
			_tmp374_ = g_strdup_printf ("%s%c%s", _tmp372_, (gint) G_DIR_SEPARATOR, _tmp373_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp374_;
		}
		_tmp375_ = interface_writer;
		_tmp376_ = self->priv->context;
		_tmp377_ = vapi_filename;
		vala_code_writer_write_file (_tmp375_, _tmp376_, _tmp377_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp378_ = vala_compiler_dependencies;
	if (_tmp378_ != NULL) {
		ValaCodeContext* _tmp379_;
		const gchar* _tmp380_;
		_tmp379_ = self->priv->context;
		_tmp380_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp379_, _tmp380_);
	}
	_tmp382_ = self->priv->context;
	_tmp383_ = vala_code_context_get_report (_tmp382_);
	_tmp384_ = _tmp383_;
	if (vala_report_get_errors (_tmp384_) > 0) {
		_tmp381_ = TRUE;
	} else {
		gboolean _tmp385_ = FALSE;
		gboolean _tmp386_;
		_tmp386_ = vala_compiler_fatal_warnings;
		if (_tmp386_) {
			ValaCodeContext* _tmp387_;
			ValaReport* _tmp388_;
			ValaReport* _tmp389_;
			_tmp387_ = self->priv->context;
			_tmp388_ = vala_code_context_get_report (_tmp387_);
			_tmp389_ = _tmp388_;
			_tmp385_ = vala_report_get_warnings (_tmp389_) > 0;
		} else {
			_tmp385_ = FALSE;
		}
		_tmp381_ = _tmp385_;
	}
	if (_tmp381_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp390_ = vala_compiler_ccode_only;
	if (!_tmp390_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp391_;
		gboolean _tmp392_ = FALSE;
		const gchar* _tmp393_;
		gboolean _tmp397_ = FALSE;
		const gchar* _tmp398_;
		gchar** _tmp402_;
		gint _tmp402__length1;
		_tmp391_ = vala_ccode_compiler_new ();
		ccompiler = _tmp391_;
		_tmp393_ = vala_compiler_cc_command;
		if (_tmp393_ == NULL) {
			const gchar* _tmp394_;
			_tmp394_ = g_getenv ("CC");
			_tmp392_ = _tmp394_ != NULL;
		} else {
			_tmp392_ = FALSE;
		}
		if (_tmp392_) {
			const gchar* _tmp395_;
			gchar* _tmp396_;
			_tmp395_ = g_getenv ("CC");
			_tmp396_ = g_strdup (_tmp395_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp396_;
		}
		_tmp398_ = vala_compiler_pkg_config_command;
		if (_tmp398_ == NULL) {
			const gchar* _tmp399_;
			_tmp399_ = g_getenv ("PKG_CONFIG");
			_tmp397_ = _tmp399_ != NULL;
		} else {
			_tmp397_ = FALSE;
		}
		if (_tmp397_) {
			const gchar* _tmp400_;
			gchar* _tmp401_;
			_tmp400_ = g_getenv ("PKG_CONFIG");
			_tmp401_ = g_strdup (_tmp400_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp401_;
		}
		_tmp402_ = vala_compiler_cc_options;
		_tmp402__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp402_ == NULL) {
			ValaCCodeCompiler* _tmp403_;
			ValaCodeContext* _tmp404_;
			const gchar* _tmp405_;
			gchar** _tmp406_;
			gchar** _tmp407_;
			gint _tmp407__length1;
			const gchar* _tmp408_;
			_tmp403_ = ccompiler;
			_tmp404_ = self->priv->context;
			_tmp405_ = vala_compiler_cc_command;
			_tmp406_ = g_new0 (gchar*, 0 + 1);
			_tmp407_ = _tmp406_;
			_tmp407__length1 = 0;
			_tmp408_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp403_, _tmp404_, _tmp405_, _tmp407_, 0, _tmp408_);
			_tmp407_ = (_vala_array_free (_tmp407_, _tmp407__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp409_;
			ValaCodeContext* _tmp410_;
			const gchar* _tmp411_;
			gchar** _tmp412_;
			gint _tmp412__length1;
			const gchar* _tmp413_;
			_tmp409_ = ccompiler;
			_tmp410_ = self->priv->context;
			_tmp411_ = vala_compiler_cc_command;
			_tmp412_ = vala_compiler_cc_options;
			_tmp412__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp413_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp409_, _tmp410_, _tmp411_, _tmp412_, _tmp412__length1, _tmp413_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void
_vala_array_add1 (gchar** * array, 
                  int* length, 
                  int* size, 
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
___lambda4_ (Block1Data* _data1_, 
             GPid pid, 
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}


static void
____lambda4__gchild_watch_func (GPid pid, 
                                gint status, 
                                gpointer self)
{
	___lambda4_ (self, pid, status);
}


static gint
vala_compiler_run_source (gchar** args, 
                          int args_length1)
{
	gint result = 0;
	gboolean _tmp11_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint outputfd = 0;
	const gchar* _tmp23_;
	gint _tmp24_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp25_;
	gint ret = 0;
	ValaCompiler* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	const gchar* _tmp29_;
	gchar** target_args = NULL;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gint target_args_length1;
	gint _target_args_size_;
	gchar** target_run_args = NULL;
	const gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint target_run_args_length1;
	gint _target_run_args_size_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gint _tmp53_ = 0;
	GError * _inner_error_ = NULL;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp4_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp10_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	_tmp11_ = vala_compiler_version;
	if (_tmp11_) {
		FILE* _tmp12_;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp13_;
		_tmp13_ = vala_compiler_api_version;
		if (_tmp13_) {
			FILE* _tmp14_;
			_tmp14_ = stdout;
			fprintf (_tmp14_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp15_ = vala_compiler_sources;
	_tmp15__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp15_ == NULL) {
		FILE* _tmp16_;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp17_ = g_get_tmp_dir ();
	_tmp18_ = vala_compiler_sources;
	_tmp18__length1 = _vala_array_length (vala_compiler_sources);
	_tmp19_ = _tmp18_[0];
	_tmp20_ = g_path_get_basename (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp17_, _tmp21_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp23_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp23_);
	_tmp24_ = outputfd;
	if (_tmp24_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp25_ = vala_compiler_new ();
	compiler = _tmp25_;
	_tmp26_ = compiler;
	ret = vala_compiler_run (_tmp26_);
	_tmp27_ = ret;
	if (_tmp27_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp28_ = outputfd;
	close (_tmp28_);
	_tmp29_ = vala_compiler_output;
	if (g_chmod (_tmp29_, 0700) != 0) {
		const gchar* _tmp30_;
		_tmp30_ = vala_compiler_output;
		g_unlink (_tmp30_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp31_ = vala_compiler_output;
	_tmp32_ = g_strdup (_tmp31_);
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	target_args = _tmp33_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp34_ = vala_compiler_run_args;
	_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, " ", 0);
	target_run_args = _tmp36_;
	target_run_args_length1 = _vala_array_length (_tmp35_);
	_target_run_args_size_ = target_run_args_length1;
	_tmp37_ = target_run_args;
	_tmp37__length1 = target_run_args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp37_;
		arg_collection_length1 = _tmp37__length1;
		for (arg_it = 0; arg_it < _tmp37__length1; arg_it = arg_it + 1) {
			gchar* _tmp38_;
			gchar* arg = NULL;
			_tmp38_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp38_;
			{
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp39_ = target_args;
				_tmp39__length1 = target_args_length1;
				_tmp40_ = arg;
				_tmp41_ = g_strdup (_tmp40_);
				_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp41_);
				_g_free0 (arg);
			}
		}
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		GPid _tmp44_ = 0;
		const gchar* _tmp46_;
		GPid _tmp47_;
		GMainLoop* _tmp48_;
		gint _tmp49_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp42_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp42_;
		_data1_->child_status = 0;
		_tmp43_ = target_args;
		_tmp43__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp43_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp44_, &_inner_error_);
		pid = _tmp44_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp45_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp45_;
		}
		_tmp46_ = vala_compiler_output;
		g_unlink (_tmp46_);
		_tmp47_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp47_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp48_ = _data1_->loop;
		g_main_loop_run (_tmp48_);
		_tmp49_ = _data1_->child_status;
		result = _tmp49_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = stdout;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		fprintf (_tmp50_, "%s\n", _tmp52_);
		result = 1;
		_g_error_free0 (e);
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp53_;
}


static gint
vala_compiler_main (gchar** args, 
                    int args_length1)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp19_;
	gboolean _tmp23_ = FALSE;
	gchar** _tmp24_;
	gint _tmp24__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp27_;
	ValaCompiler* _tmp28_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "vala") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = args[0];
		_tmp6_ = g_path_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp7_);
	}
	if (_tmp0_) {
		result = vala_compiler_run_source (args, args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp8_;
		GOptionContext* _tmp9_;
		GOptionContext* _tmp10_;
		GOptionContext* _tmp11_;
		_tmp8_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp8_;
		_tmp9_ = opt_context;
		g_option_context_set_help_enabled (_tmp9_, TRUE);
		_tmp10_ = opt_context;
		g_option_context_add_main_entries (_tmp10_, VALA_COMPILER_options, NULL);
		_tmp11_ = opt_context;
		g_option_context_parse (_tmp11_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp12_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp12_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		FILE* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "%s\n", _tmp15_);
		_tmp16_ = stdout;
		_tmp17_ = args[0];
		fprintf (_tmp16_, "Run '%s --help' to see a full list of available command line options.\n", _tmp17_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp18_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	_tmp19_ = vala_compiler_version;
	if (_tmp19_) {
		FILE* _tmp20_;
		_tmp20_ = stdout;
		fprintf (_tmp20_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp21_;
		_tmp21_ = vala_compiler_api_version;
		if (_tmp21_) {
			FILE* _tmp22_;
			_tmp22_ = stdout;
			fprintf (_tmp22_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp24_ = vala_compiler_sources;
	_tmp24__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp24_ == NULL) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp25_ = vala_compiler_fast_vapis;
		_tmp25__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp23_ = _tmp25_ == NULL;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		FILE* _tmp26_;
		_tmp26_ = stderr;
		fprintf (_tmp26_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp27_ = vala_compiler_new ();
	compiler = _tmp27_;
	_tmp28_ = compiler;
	result = vala_compiler_run (_tmp28_);
	_vala_compiler_unref0 (compiler);
	return result;
}


int
main (int argc, 
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}


G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_compiler_copy_value (const GValue* src_value, 
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_compiler_collect_value (GValue* value, 
                                   guint n_collect_values, 
                                   GTypeCValue* collect_values, 
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_compiler_lcopy_value (const GValue* value, 
                                 guint n_collect_values, 
                                 GTypeCValue* collect_values, 
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name, 
                          const gchar* nick, 
                          const gchar* blurb, 
                          GType object_type, 
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value, 
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value, 
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void
vala_compiler_class_init (ValaCompilerClass * klass)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void
vala_compiler_instance_init (ValaCompiler * self)
{
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



