/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_METHOD_CALL_0_PROPERTY,
	VALA_METHOD_CALL_NUM_PROPERTIES
};
static GParamSpec* vala_method_call_properties[VALA_METHOD_CALL_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};


static gpointer vala_method_call_parent_class = NULL;

#define VALA_METHOD_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_CALL, ValaMethodCallPrivate))
static void vala_method_call_real_accept (ValaCodeNode* base, 
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base, 
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base, 
                                               ValaExpression* old_node, 
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base, 
                                              ValaSymbol* sym);
static gboolean vala_method_call_real_check (ValaCodeNode* base, 
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self, 
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self, 
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self, 
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base, 
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base, 
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base, 
                                               ValaCollection* collection);
static void vala_method_call_finalize (ValaCodeNode * obj);


/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type, 
                            ValaExpression* call, 
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}


ValaMethodCall*
vala_method_call_new (ValaExpression* call, 
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self, 
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_method_call_real_accept (ValaCodeNode* base, 
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_method_call_real_accept_children (ValaCodeNode* base, 
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* expr = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _expr_index;
			_expr_index = _tmp7_ + 1;
			_tmp8_ = _expr_index;
			_tmp9_ = _expr_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _expr_list;
			_tmp11_ = _expr_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			expr = (ValaExpression*) _tmp12_;
			_tmp13_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_method_call_real_replace_expression (ValaCodeNode* base, 
                                          ValaExpression* old_node, 
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	_tmp4_ = index;
	if (_tmp4_ >= 0) {
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) new_node);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaList* _tmp7_;
		gint _tmp8_;
		_tmp7_ = self->priv->argument_list;
		_tmp8_ = index;
		vala_list_set (_tmp7_, _tmp8_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}


static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_method_call_real_is_accessible (ValaExpression* base, 
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp12_ = vala_method_call_get_call (self);
	_tmp13_ = _tmp12_;
	result = vala_expression_is_accessible (_tmp13_, sym);
	return result;
}


static gboolean
vala_method_call_real_check (ValaCodeNode* base, 
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	gboolean gobject_chainup = FALSE;
	ValaExpression* _tmp114_;
	ValaExpression* _tmp115_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaClass* _tmp120_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp239_ = FALSE;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	gboolean _tmp314_ = FALSE;
	gboolean _tmp315_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp330_;
	ValaDataType* _tmp331_;
	ValaList* params = NULL;
	ValaDataType* _tmp332_;
	ValaList* _tmp333_;
	ValaDataType* _tmp334_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp407_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp408_;
	ValaIterator* _tmp409_;
	gboolean _tmp461_ = FALSE;
	ValaDataType* _tmp462_;
	gboolean _tmp487_ = FALSE;
	ValaDataType* _tmp488_;
	ValaDataType* _tmp563_;
	ValaDataType* _tmp574_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	ValaList* _tmp580_;
	ValaDataType* _tmp581_;
	ValaDataType* _tmp582_;
	gboolean may_throw = FALSE;
	ValaDataType* _tmp583_;
	ValaSemanticAnalyzer* _tmp889_;
	ValaSemanticAnalyzer* _tmp890_;
	ValaDataType* _tmp891_;
	ValaList* _tmp892_;
	ValaList* _tmp893_;
	ValaList* _tmp894_;
	gboolean _tmp895_;
	gboolean _tmp896_ = FALSE;
	gboolean _tmp897_ = FALSE;
	ValaCreationMethod* _tmp898_;
	gboolean _tmp927_;
	gboolean _tmp980_;
	gboolean _tmp981_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				ValaAttribute* _tmp99_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp99_ = _tmp98_;
				_tmp91_ = _tmp99_ != NULL;
				_vala_code_node_unref0 (_tmp99_);
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp100_;
				ValaList* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp100_ = vala_method_call_get_argument_list (self);
				args = _tmp100_;
				_tmp101_ = args;
				_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
				_tmp103_ = _tmp102_;
				if (_tmp103_ == 1) {
					ValaList* _tmp104_;
					gpointer _tmp105_;
					ValaExpression* _tmp106_;
					ValaSourceReference* _tmp107_;
					ValaSourceReference* _tmp108_;
					_tmp104_ = args;
					_tmp105_ = vala_list_get (_tmp104_, 0);
					_tmp106_ = (ValaExpression*) _tmp105_;
					_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
					_tmp108_ = _tmp107_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp108_);
					_vala_code_node_unref0 (_tmp106_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp109_ = vala_method_call_get_call (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_expression_get_value_type (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = _vala_code_node_ref0 (_tmp112_);
	mtype = _tmp113_;
	_tmp114_ = vala_method_call_get_call (self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_expression_get_symbol_reference (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = _tmp119_->object_type;
	gobject_chainup = _tmp117_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_SYMBOL, ValaSymbol);
	_tmp121_ = gobject_chainup;
	vala_method_call_set_is_chainup (self, _tmp121_);
	_tmp122_ = gobject_chainup;
	if (!_tmp122_) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_CLASS);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				gboolean _tmp214_;
				_tmp214_ = gobject_chainup;
				if (_tmp214_) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaSymbol* _tmp217_;
					ValaClass* _tmp218_;
					gboolean _tmp219_ = FALSE;
					ValaClass* _tmp220_;
					ValaExpression* _tmp227_;
					ValaExpression* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaSemanticAnalyzer* _tmp230_;
					ValaClass* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaObjectType* _tmp233_;
					ValaExpression* _tmp234_;
					ValaExpression* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					ValaDataType* _tmp238_;
					_tmp215_ = cm;
					_tmp216_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp217_) : NULL);
					cl = _tmp218_;
					_tmp220_ = cl;
					if (_tmp220_ == NULL) {
						_tmp219_ = TRUE;
					} else {
						ValaClass* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaSemanticAnalyzer* _tmp223_;
						ValaClass* _tmp224_;
						_tmp221_ = cl;
						_tmp222_ = vala_code_context_get_analyzer (context);
						_tmp223_ = _tmp222_;
						_tmp224_ = _tmp223_->object_type;
						_tmp219_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp221_, (ValaTypeSymbol*) _tmp224_);
					}
					if (_tmp219_) {
						ValaSourceReference* _tmp225_;
						ValaSourceReference* _tmp226_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp226_ = _tmp225_;
						vala_report_error (_tmp226_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp227_ = vala_method_call_get_call (self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_code_context_get_analyzer (context);
					_tmp230_ = _tmp229_;
					_tmp231_ = _tmp230_->object_type;
					_tmp232_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp231_);
					_tmp233_ = _tmp232_;
					vala_expression_set_value_type (_tmp228_, (ValaDataType*) _tmp233_);
					_vala_code_node_unref0 (_tmp233_);
					_tmp234_ = vala_method_call_get_call (self);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_expression_get_value_type (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _vala_code_node_ref0 (_tmp237_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp238_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp240_ = vala_method_call_get_call (self);
	_tmp241_ = _tmp240_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp241_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp242_ = FALSE;
		gboolean _tmp243_ = FALSE;
		ValaExpression* _tmp244_;
		ValaExpression* _tmp245_;
		ValaSymbol* _tmp246_;
		ValaSymbol* _tmp247_;
		_tmp244_ = vala_method_call_get_call (self);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_expression_get_symbol_reference (_tmp245_);
		_tmp247_ = _tmp246_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			ValaSymbol* _tmp253_;
			_tmp248_ = vala_method_call_get_call (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp252_ = vala_symbol_get_parent_symbol (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp243_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp253_, VALA_TYPE_STRUCT);
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			_tmp242_ = TRUE;
		} else {
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			ValaSymbol* _tmp256_;
			ValaSymbol* _tmp257_;
			_tmp254_ = vala_method_call_get_call (self);
			_tmp255_ = _tmp254_;
			_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_STRUCT);
		}
		_tmp239_ = _tmp242_;
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp258_;
		ValaExpression* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaSymbol* _tmp261_;
		ValaStruct* _tmp262_;
		gboolean _tmp263_ = FALSE;
		gboolean _tmp264_ = FALSE;
		ValaStruct* _tmp265_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp281_;
		ValaObjectCreationExpression* _tmp294_;
		ValaDataType* _tmp295_;
		ValaDataType* _tmp296_;
		ValaSemanticAnalyzer* _tmp297_;
		ValaSemanticAnalyzer* _tmp298_;
		ValaCodeNode* _tmp299_;
		ValaCodeNode* _tmp300_;
		ValaObjectCreationExpression* _tmp301_;
		ValaObjectCreationExpression* _tmp302_;
		_tmp258_ = vala_method_call_get_call (self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp261_) : NULL);
		st = _tmp262_;
		_tmp265_ = st;
		if (_tmp265_ != NULL) {
			ValaStruct* _tmp266_;
			ValaMethod* _tmp267_;
			ValaMethod* _tmp268_;
			_tmp266_ = st;
			_tmp267_ = vala_struct_get_default_construction_method (_tmp266_);
			_tmp268_ = _tmp267_;
			_tmp264_ = _tmp268_ == NULL;
		} else {
			_tmp264_ = FALSE;
		}
		if (_tmp264_) {
			gboolean _tmp269_ = FALSE;
			gboolean _tmp270_ = FALSE;
			ValaStruct* _tmp271_;
			_tmp271_ = st;
			if (vala_struct_is_boolean_type (_tmp271_)) {
				_tmp270_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp270_ = vala_struct_is_integer_type (_tmp272_);
			}
			if (_tmp270_) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp273_;
				_tmp273_ = st;
				_tmp269_ = vala_struct_is_floating_type (_tmp273_);
			}
			_tmp263_ = _tmp269_;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			ValaSourceReference* _tmp274_;
			ValaSourceReference* _tmp275_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp275_ = _tmp274_;
			vala_report_error (_tmp275_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp276_ = vala_method_call_get_call (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp279_);
		struct_creation_expression = _tmp280_;
		_tmp281_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp281_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp282_;
			gint _arg_size = 0;
			ValaList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _arg_index = 0;
			_tmp282_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp282_;
			_tmp283_ = _arg_list;
			_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_arg_size = _tmp285_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp286_;
				gint _tmp287_;
				gint _tmp288_;
				ValaExpression* arg = NULL;
				ValaList* _tmp289_;
				gint _tmp290_;
				gpointer _tmp291_;
				ValaObjectCreationExpression* _tmp292_;
				ValaExpression* _tmp293_;
				_tmp286_ = _arg_index;
				_arg_index = _tmp286_ + 1;
				_tmp287_ = _arg_index;
				_tmp288_ = _arg_size;
				if (!(_tmp287_ < _tmp288_)) {
					break;
				}
				_tmp289_ = _arg_list;
				_tmp290_ = _arg_index;
				_tmp291_ = vala_list_get (_tmp289_, _tmp290_);
				arg = (ValaExpression*) _tmp291_;
				_tmp292_ = struct_creation_expression;
				_tmp293_ = arg;
				vala_object_creation_expression_add_argument (_tmp292_, _tmp293_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp294_ = struct_creation_expression;
		_tmp295_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp296_ = _tmp295_;
		vala_expression_set_target_type ((ValaExpression*) _tmp294_, _tmp296_);
		_tmp297_ = vala_code_context_get_analyzer (context);
		_tmp298_ = _tmp297_;
		vala_semantic_analyzer_add_replaced_node (_tmp298_, (ValaCodeNode*) self);
		_tmp299_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp300_ = _tmp299_;
		_tmp301_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp300_, (ValaExpression*) self, (ValaExpression*) _tmp301_);
		_tmp302_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp302_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp303_ = FALSE;
		gboolean _tmp304_ = FALSE;
		gboolean _tmp305_;
		_tmp305_ = self->priv->_is_chainup;
		if (!_tmp305_) {
			ValaExpression* _tmp306_;
			ValaExpression* _tmp307_;
			_tmp306_ = vala_method_call_get_call (self);
			_tmp307_ = _tmp306_;
			_tmp304_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp307_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp304_ = FALSE;
		}
		if (_tmp304_) {
			ValaExpression* _tmp308_;
			ValaExpression* _tmp309_;
			ValaSymbol* _tmp310_;
			ValaSymbol* _tmp311_;
			_tmp308_ = vala_method_call_get_call (self);
			_tmp309_ = _tmp308_;
			_tmp310_ = vala_expression_get_symbol_reference (_tmp309_);
			_tmp311_ = _tmp310_;
			_tmp303_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp311_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp303_ = FALSE;
		}
		if (_tmp303_) {
			ValaSourceReference* _tmp312_;
			ValaSourceReference* _tmp313_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp313_ = _tmp312_;
			vala_report_error (_tmp313_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp315_ = self->priv->_is_chainup;
	if (!_tmp315_) {
		ValaDataType* _tmp316_;
		_tmp316_ = mtype;
		_tmp314_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp314_ = FALSE;
	}
	if (_tmp314_) {
		ValaSourceReference* _tmp317_;
		ValaSourceReference* _tmp318_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp318_ = _tmp317_;
		vala_report_error (_tmp318_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp319_ = FALSE;
		ValaDataType* _tmp320_;
		_tmp320_ = mtype;
		if (_tmp320_ != NULL) {
			ValaDataType* _tmp321_;
			_tmp321_ = mtype;
			_tmp319_ = vala_data_type_is_invokable (_tmp321_);
		} else {
			_tmp319_ = FALSE;
		}
		if (_tmp319_) {
		} else {
			ValaExpression* _tmp322_;
			ValaExpression* _tmp323_;
			ValaSymbol* _tmp324_;
			ValaSymbol* _tmp325_;
			_tmp322_ = vala_method_call_get_call (self);
			_tmp323_ = _tmp322_;
			_tmp324_ = vala_expression_get_symbol_reference (_tmp323_);
			_tmp325_ = _tmp324_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp325_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp326_;
				ValaSourceReference* _tmp327_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp327_ = _tmp326_;
				vala_report_error (_tmp327_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp328_;
				ValaSourceReference* _tmp329_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp328_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp329_ = _tmp328_;
				vala_report_error (_tmp329_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp330_ = mtype;
	_tmp331_ = vala_data_type_get_return_type (_tmp330_);
	ret_type = _tmp331_;
	_tmp332_ = mtype;
	_tmp333_ = vala_data_type_get_parameters (_tmp332_);
	params = _tmp333_;
	_tmp334_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp334_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp335_;
		ValaMethod* _tmp336_;
		ValaMethod* _tmp337_;
		ValaMethod* _tmp338_;
		gboolean _tmp339_ = FALSE;
		ValaMethod* _tmp340_;
		ValaMethod* _tmp377_;
		_tmp335_ = mtype;
		_tmp336_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp337_ = _tmp336_;
		_tmp338_ = _vala_code_node_ref0 (_tmp337_);
		m = _tmp338_;
		_tmp340_ = m;
		if (_tmp340_ != NULL) {
			ValaMethod* _tmp341_;
			gboolean _tmp342_;
			gboolean _tmp343_;
			_tmp341_ = m;
			_tmp342_ = vala_method_get_coroutine (_tmp341_);
			_tmp343_ = _tmp342_;
			_tmp339_ = _tmp343_;
		} else {
			_tmp339_ = FALSE;
		}
		if (_tmp339_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp344_;
			ValaExpression* _tmp345_;
			ValaMemberAccess* _tmp346_;
			gboolean _tmp347_;
			_tmp344_ = vala_method_call_get_call (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp345_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp346_;
			_tmp347_ = self->priv->_is_yield_expression;
			if (!_tmp347_) {
				ValaMemberAccess* _tmp348_;
				const gchar* _tmp349_;
				const gchar* _tmp350_;
				_tmp348_ = ma;
				_tmp349_ = vala_member_access_get_member_name (_tmp348_);
				_tmp350_ = _tmp349_;
				if (g_strcmp0 (_tmp350_, "end") != 0) {
					ValaMemberAccess* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					ValaMethod* _tmp357_;
					ValaList* _tmp358_;
					ValaVoidType* _tmp359_;
					_tmp351_ = ma;
					_tmp352_ = vala_member_access_get_member_name (_tmp351_);
					_tmp353_ = _tmp352_;
					if (g_strcmp0 (_tmp353_, "begin") != 0) {
						ValaMemberAccess* _tmp354_;
						ValaSourceReference* _tmp355_;
						ValaSourceReference* _tmp356_;
						_tmp354_ = ma;
						_tmp355_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp354_);
						_tmp356_ = _tmp355_;
						vala_report_deprecated (_tmp356_, "implicit .begin is deprecated");
					}
					_tmp357_ = m;
					_tmp358_ = vala_method_get_async_begin_parameters (_tmp357_);
					_vala_iterable_unref0 (params);
					params = _tmp358_;
					_tmp359_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp359_;
				} else {
					ValaMethod* _tmp360_;
					ValaList* _tmp361_;
					_tmp360_ = m;
					_tmp361_ = vala_method_get_async_end_parameters (_tmp360_);
					_vala_iterable_unref0 (params);
					params = _tmp361_;
				}
			} else {
				gboolean _tmp362_ = FALSE;
				ValaMemberAccess* _tmp363_;
				const gchar* _tmp364_;
				const gchar* _tmp365_;
				_tmp363_ = ma;
				_tmp364_ = vala_member_access_get_member_name (_tmp363_);
				_tmp365_ = _tmp364_;
				if (g_strcmp0 (_tmp365_, "begin") == 0) {
					_tmp362_ = TRUE;
				} else {
					ValaMemberAccess* _tmp366_;
					const gchar* _tmp367_;
					const gchar* _tmp368_;
					_tmp366_ = ma;
					_tmp367_ = vala_member_access_get_member_name (_tmp366_);
					_tmp368_ = _tmp367_;
					_tmp362_ = g_strcmp0 (_tmp368_, "end") == 0;
				}
				if (_tmp362_) {
					ValaMemberAccess* _tmp369_;
					ValaSourceReference* _tmp370_;
					ValaSourceReference* _tmp371_;
					ValaMemberAccess* _tmp372_;
					const gchar* _tmp373_;
					const gchar* _tmp374_;
					gchar* _tmp375_;
					gchar* _tmp376_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp369_ = ma;
					_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = ma;
					_tmp373_ = vala_member_access_get_member_name (_tmp372_);
					_tmp374_ = _tmp373_;
					_tmp375_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp374_);
					_tmp376_ = _tmp375_;
					vala_report_error (_tmp371_, _tmp376_);
					_g_free0 (_tmp376_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp377_ = m;
		if (_tmp377_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp378_;
			ValaExpression* _tmp379_;
			ValaMemberAccess* _tmp380_;
			gint n_type_params = 0;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			ValaList* _tmp383_;
			gint _tmp384_;
			gint _tmp385_;
			gint _tmp386_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp387_;
			ValaList* _tmp388_;
			ValaList* _tmp389_;
			gint _tmp390_;
			gint _tmp391_;
			gint _tmp392_;
			gboolean _tmp393_ = FALSE;
			gint _tmp394_;
			_tmp378_ = vala_method_call_get_call (self);
			_tmp379_ = _tmp378_;
			_tmp380_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp379_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_type_parameters (_tmp381_);
			_tmp383_ = _tmp382_;
			_tmp384_ = vala_collection_get_size ((ValaCollection*) _tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = _tmp385_;
			_vala_iterable_unref0 (_tmp383_);
			n_type_params = _tmp386_;
			_tmp387_ = ma;
			_tmp388_ = vala_member_access_get_type_arguments (_tmp387_);
			_tmp389_ = _tmp388_;
			_tmp390_ = vala_collection_get_size ((ValaCollection*) _tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = _tmp391_;
			_vala_iterable_unref0 (_tmp389_);
			n_type_args = _tmp392_;
			_tmp394_ = n_type_args;
			if (_tmp394_ > 0) {
				gint _tmp395_;
				gint _tmp396_;
				_tmp395_ = n_type_args;
				_tmp396_ = n_type_params;
				_tmp393_ = _tmp395_ < _tmp396_;
			} else {
				_tmp393_ = FALSE;
			}
			if (_tmp393_) {
				ValaMemberAccess* _tmp397_;
				ValaSourceReference* _tmp398_;
				ValaSourceReference* _tmp399_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp397_ = ma;
				_tmp398_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp397_);
				_tmp399_ = _tmp398_;
				vala_report_error (_tmp399_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp400_ = FALSE;
				gint _tmp401_;
				_tmp401_ = n_type_args;
				if (_tmp401_ > 0) {
					gint _tmp402_;
					gint _tmp403_;
					_tmp402_ = n_type_args;
					_tmp403_ = n_type_params;
					_tmp400_ = _tmp402_ > _tmp403_;
				} else {
					_tmp400_ = FALSE;
				}
				if (_tmp400_) {
					ValaMemberAccess* _tmp404_;
					ValaSourceReference* _tmp405_;
					ValaSourceReference* _tmp406_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp404_ = ma;
					_tmp405_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp404_);
					_tmp406_ = _tmp405_;
					vala_report_error (_tmp406_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp407_ = vala_method_call_get_argument_list (self);
	args = _tmp407_;
	_tmp408_ = args;
	_tmp409_ = vala_iterable_iterator ((ValaIterable*) _tmp408_);
	arg_it = _tmp409_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp410_;
		ValaList* _tmp411_;
		gint _param_size = 0;
		ValaList* _tmp412_;
		gint _tmp413_;
		gint _tmp414_;
		gint _param_index = 0;
		_tmp410_ = params;
		_tmp411_ = _vala_iterable_ref0 (_tmp410_);
		_param_list = _tmp411_;
		_tmp412_ = _param_list;
		_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
		_tmp414_ = _tmp413_;
		_param_size = _tmp414_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp415_;
			gint _tmp416_;
			gint _tmp417_;
			ValaParameter* param = NULL;
			ValaList* _tmp418_;
			gint _tmp419_;
			gpointer _tmp420_;
			ValaParameter* _tmp421_;
			gboolean _tmp422_;
			gboolean _tmp423_;
			ValaParameter* _tmp424_;
			gboolean _tmp425_;
			gboolean _tmp426_;
			ValaIterator* _tmp444_;
			_tmp415_ = _param_index;
			_param_index = _tmp415_ + 1;
			_tmp416_ = _param_index;
			_tmp417_ = _param_size;
			if (!(_tmp416_ < _tmp417_)) {
				break;
			}
			_tmp418_ = _param_list;
			_tmp419_ = _param_index;
			_tmp420_ = vala_list_get (_tmp418_, _tmp419_);
			param = (ValaParameter*) _tmp420_;
			_tmp421_ = param;
			_tmp422_ = vala_parameter_get_ellipsis (_tmp421_);
			_tmp423_ = _tmp422_;
			if (_tmp423_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp424_ = param;
			_tmp425_ = vala_parameter_get_params_array (_tmp424_);
			_tmp426_ = _tmp425_;
			if (_tmp426_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				ValaArrayType* _tmp430_;
				_tmp427_ = param;
				_tmp428_ = vala_variable_get_variable_type ((ValaVariable*) _tmp427_);
				_tmp429_ = _tmp428_;
				_tmp430_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp429_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp430_;
				while (TRUE) {
					ValaIterator* _tmp431_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp432_;
					gpointer _tmp433_;
					ValaExpression* _tmp434_;
					ValaArrayType* _tmp435_;
					ValaDataType* _tmp436_;
					ValaDataType* _tmp437_;
					ValaExpression* _tmp438_;
					ValaDataType* _tmp439_;
					ValaDataType* _tmp440_;
					ValaArrayType* _tmp441_;
					gboolean _tmp442_;
					gboolean _tmp443_;
					_tmp431_ = arg_it;
					if (!vala_iterator_next (_tmp431_)) {
						break;
					}
					_tmp432_ = arg_it;
					_tmp433_ = vala_iterator_get (_tmp432_);
					arg = (ValaExpression*) _tmp433_;
					_tmp434_ = arg;
					_tmp435_ = array_type;
					_tmp436_ = vala_array_type_get_element_type (_tmp435_);
					_tmp437_ = _tmp436_;
					vala_expression_set_target_type (_tmp434_, _tmp437_);
					_tmp438_ = arg;
					_tmp439_ = vala_expression_get_target_type (_tmp438_);
					_tmp440_ = _tmp439_;
					_tmp441_ = array_type;
					_tmp442_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp441_);
					_tmp443_ = _tmp442_;
					vala_data_type_set_value_owned (_tmp440_, _tmp443_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp444_ = arg_it;
			if (vala_iterator_next (_tmp444_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp445_;
				gpointer _tmp446_;
				ValaExpression* _tmp447_;
				ValaParameter* _tmp448_;
				ValaDataType* _tmp449_;
				ValaDataType* _tmp450_;
				ValaExpression* _tmp451_;
				ValaExpression* _tmp452_;
				ValaDataType* _tmp453_;
				ValaDataType* _tmp454_;
				ValaDataType* _tmp455_;
				ValaList* _tmp456_;
				ValaDataType* _tmp457_;
				ValaDataType* _tmp458_;
				ValaExpression* _tmp459_;
				ValaExpression* _tmp460_;
				_tmp445_ = arg_it;
				_tmp446_ = vala_iterator_get (_tmp445_);
				arg = (ValaExpression*) _tmp446_;
				_tmp447_ = arg;
				_tmp448_ = param;
				_tmp449_ = vala_variable_get_variable_type ((ValaVariable*) _tmp448_);
				_tmp450_ = _tmp449_;
				vala_expression_set_formal_target_type (_tmp447_, _tmp450_);
				_tmp451_ = arg;
				_tmp452_ = arg;
				_tmp453_ = vala_expression_get_formal_target_type (_tmp452_);
				_tmp454_ = _tmp453_;
				_tmp455_ = target_object_type;
				_tmp456_ = method_type_args;
				_tmp457_ = vala_data_type_get_actual_type (_tmp454_, _tmp455_, _tmp456_, (ValaCodeNode*) self);
				_tmp458_ = _tmp457_;
				vala_expression_set_target_type (_tmp451_, _tmp458_);
				_vala_code_node_unref0 (_tmp458_);
				_tmp459_ = arg;
				_tmp460_ = _vala_code_node_ref0 (_tmp459_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp460_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp462_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp462_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp463_;
		ValaMethod* _tmp464_;
		ValaMethod* _tmp465_;
		ValaAttribute* _tmp466_;
		ValaAttribute* _tmp467_;
		_tmp463_ = mtype;
		_tmp464_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp463_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp465_ = _tmp464_;
		_tmp466_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp465_, "Print");
		_tmp467_ = _tmp466_;
		_tmp461_ = _tmp467_ != NULL;
		_vala_code_node_unref0 (_tmp467_);
	} else {
		_tmp461_ = FALSE;
	}
	if (_tmp461_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp468_;
		ValaSourceReference* _tmp469_;
		ValaTemplate* _tmp470_;
		ValaList* _tmp485_;
		ValaTemplate* _tmp486_;
		_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_template_new (_tmp469_);
		template = _tmp470_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp471_;
			ValaList* _tmp472_;
			gint _arg_size = 0;
			ValaList* _tmp473_;
			gint _tmp474_;
			gint _tmp475_;
			gint _arg_index = 0;
			_tmp471_ = self->priv->argument_list;
			_tmp472_ = _vala_iterable_ref0 (_tmp471_);
			_arg_list = _tmp472_;
			_tmp473_ = _arg_list;
			_tmp474_ = vala_collection_get_size ((ValaCollection*) _tmp473_);
			_tmp475_ = _tmp474_;
			_arg_size = _tmp475_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp476_;
				gint _tmp477_;
				gint _tmp478_;
				ValaExpression* arg = NULL;
				ValaList* _tmp479_;
				gint _tmp480_;
				gpointer _tmp481_;
				ValaExpression* _tmp482_;
				ValaTemplate* _tmp483_;
				ValaExpression* _tmp484_;
				_tmp476_ = _arg_index;
				_arg_index = _tmp476_ + 1;
				_tmp477_ = _arg_index;
				_tmp478_ = _arg_size;
				if (!(_tmp477_ < _tmp478_)) {
					break;
				}
				_tmp479_ = _arg_list;
				_tmp480_ = _arg_index;
				_tmp481_ = vala_list_get (_tmp479_, _tmp480_);
				arg = (ValaExpression*) _tmp481_;
				_tmp482_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp482_, NULL);
				_tmp483_ = template;
				_tmp484_ = arg;
				vala_template_add_expression (_tmp483_, _tmp484_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp485_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp485_);
		_tmp486_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp486_);
		_vala_code_node_unref0 (template);
	}
	_tmp488_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp488_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp489_;
		ValaMethod* _tmp490_;
		ValaMethod* _tmp491_;
		gboolean _tmp492_;
		gboolean _tmp493_;
		_tmp489_ = mtype;
		_tmp490_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp491_ = _tmp490_;
		_tmp492_ = vala_method_get_printf_format (_tmp491_);
		_tmp493_ = _tmp492_;
		_tmp487_ = _tmp493_;
	} else {
		_tmp487_ = FALSE;
	}
	if (_tmp487_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp494_;
		ValaStringLiteral* _tmp543_;
		format_literal = NULL;
		_tmp494_ = last_arg;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp494_, VALA_TYPE_NULL_LITERAL)) {
		} else {
			ValaExpression* _tmp495_;
			_tmp495_ = last_arg;
			if (_tmp495_ != NULL) {
				ValaExpression* _tmp496_;
				ValaStringLiteral* _tmp497_;
				gboolean _tmp498_ = FALSE;
				ValaStringLiteral* _tmp499_;
				_tmp496_ = last_arg;
				_tmp497_ = vala_string_literal_get_format_literal (_tmp496_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp497_;
				_tmp499_ = format_literal;
				if (_tmp499_ == NULL) {
					ValaList* _tmp500_;
					gint _tmp501_;
					gint _tmp502_;
					ValaList* _tmp503_;
					gint _tmp504_;
					gint _tmp505_;
					_tmp500_ = args;
					_tmp501_ = vala_collection_get_size ((ValaCollection*) _tmp500_);
					_tmp502_ = _tmp501_;
					_tmp503_ = params;
					_tmp504_ = vala_collection_get_size ((ValaCollection*) _tmp503_);
					_tmp505_ = _tmp504_;
					_tmp498_ = _tmp502_ == (_tmp505_ - 1);
				} else {
					_tmp498_ = FALSE;
				}
				if (_tmp498_) {
					ValaStringLiteral* _tmp506_;
					ValaStringLiteral* _tmp507_;
					ValaSemanticAnalyzer* _tmp508_;
					ValaSemanticAnalyzer* _tmp509_;
					ValaDataType* _tmp510_;
					ValaDataType* _tmp511_;
					ValaDataType* _tmp512_;
					ValaList* _tmp513_;
					ValaList* _tmp514_;
					gint _tmp515_;
					gint _tmp516_;
					ValaStringLiteral* _tmp517_;
					ValaList* _tmp518_;
					ValaIterator* _tmp519_;
					_tmp506_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp506_;
					_tmp507_ = format_literal;
					_tmp508_ = vala_code_context_get_analyzer (context);
					_tmp509_ = _tmp508_;
					_tmp510_ = _tmp509_->string_type;
					_tmp511_ = vala_data_type_copy (_tmp510_);
					_tmp512_ = _tmp511_;
					vala_expression_set_target_type ((ValaExpression*) _tmp507_, _tmp512_);
					_vala_code_node_unref0 (_tmp512_);
					_tmp513_ = self->priv->argument_list;
					_tmp514_ = args;
					_tmp515_ = vala_collection_get_size ((ValaCollection*) _tmp514_);
					_tmp516_ = _tmp515_;
					_tmp517_ = format_literal;
					vala_list_insert (_tmp513_, _tmp516_ - 1, (ValaExpression*) _tmp517_);
					_tmp518_ = self->priv->argument_list;
					_tmp519_ = vala_iterable_iterator ((ValaIterable*) _tmp518_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp519_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp520_;
						ValaList* _tmp521_;
						gint _param_size = 0;
						ValaList* _tmp522_;
						gint _tmp523_;
						gint _tmp524_;
						gint _param_index = 0;
						_tmp520_ = params;
						_tmp521_ = _vala_iterable_ref0 (_tmp520_);
						_param_list = _tmp521_;
						_tmp522_ = _param_list;
						_tmp523_ = vala_collection_get_size ((ValaCollection*) _tmp522_);
						_tmp524_ = _tmp523_;
						_param_size = _tmp524_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp525_;
							gint _tmp526_;
							gint _tmp527_;
							ValaParameter* param = NULL;
							ValaList* _tmp528_;
							gint _tmp529_;
							gpointer _tmp530_;
							ValaParameter* _tmp531_;
							gboolean _tmp532_;
							gboolean _tmp533_;
							ValaIterator* _tmp534_;
							_tmp525_ = _param_index;
							_param_index = _tmp525_ + 1;
							_tmp526_ = _param_index;
							_tmp527_ = _param_size;
							if (!(_tmp526_ < _tmp527_)) {
								break;
							}
							_tmp528_ = _param_list;
							_tmp529_ = _param_index;
							_tmp530_ = vala_list_get (_tmp528_, _tmp529_);
							param = (ValaParameter*) _tmp530_;
							_tmp531_ = param;
							_tmp532_ = vala_parameter_get_ellipsis (_tmp531_);
							_tmp533_ = _tmp532_;
							if (_tmp533_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp534_ = arg_it;
							vala_iterator_next (_tmp534_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp535_;
				ValaExpression* _tmp536_;
				ValaMemberAccess* _tmp537_;
				ValaMemberAccess* _tmp538_;
				_tmp535_ = vala_method_call_get_call (self);
				_tmp536_ = _tmp535_;
				_tmp537_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp536_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp536_) : NULL);
				ma = _tmp537_;
				_tmp538_ = ma;
				if (_tmp538_ != NULL) {
					ValaMemberAccess* _tmp539_;
					ValaExpression* _tmp540_;
					ValaExpression* _tmp541_;
					ValaStringLiteral* _tmp542_;
					_tmp539_ = ma;
					_tmp540_ = vala_member_access_get_inner (_tmp539_);
					_tmp541_ = _tmp540_;
					_tmp542_ = vala_string_literal_get_format_literal (_tmp541_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp542_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp543_ = format_literal;
		if (_tmp543_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp544_;
			gchar* _tmp545_;
			ValaSemanticAnalyzer* _tmp546_;
			ValaSemanticAnalyzer* _tmp547_;
			const gchar* _tmp548_;
			ValaIterator* _tmp549_;
			ValaSourceReference* _tmp550_;
			ValaSourceReference* _tmp551_;
			_tmp544_ = format_literal;
			_tmp545_ = vala_string_literal_eval (_tmp544_);
			format = _tmp545_;
			_tmp546_ = vala_code_context_get_analyzer (context);
			_tmp547_ = _tmp546_;
			_tmp548_ = format;
			_tmp549_ = arg_it;
			_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp551_ = _tmp550_;
			if (!vala_semantic_analyzer_check_print_format (_tmp547_, _tmp548_, _tmp549_, _tmp551_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp552_;
		gint _arg_size = 0;
		ValaList* _tmp553_;
		gint _tmp554_;
		gint _tmp555_;
		gint _arg_index = 0;
		_tmp552_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp552_;
		_tmp553_ = _arg_list;
		_tmp554_ = vala_collection_get_size ((ValaCollection*) _tmp553_);
		_tmp555_ = _tmp554_;
		_arg_size = _tmp555_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp556_;
			gint _tmp557_;
			gint _tmp558_;
			ValaExpression* arg = NULL;
			ValaList* _tmp559_;
			gint _tmp560_;
			gpointer _tmp561_;
			ValaExpression* _tmp562_;
			_tmp556_ = _arg_index;
			_arg_index = _tmp556_ + 1;
			_tmp557_ = _arg_index;
			_tmp558_ = _arg_size;
			if (!(_tmp557_ < _tmp558_)) {
				break;
			}
			_tmp559_ = _arg_list;
			_tmp560_ = _arg_index;
			_tmp561_ = vala_list_get (_tmp559_, _tmp560_);
			arg = (ValaExpression*) _tmp561_;
			_tmp562_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp562_, context);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp563_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp563_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp564_ = FALSE;
		gboolean _tmp565_ = FALSE;
		ValaCodeNode* _tmp566_;
		ValaCodeNode* _tmp567_;
		_tmp566_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp567_ = _tmp566_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp567_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp568_;
			ValaCodeNode* _tmp569_;
			_tmp568_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp569_ = _tmp568_;
			_tmp565_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp569_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp565_ = FALSE;
		}
		if (_tmp565_) {
			ValaCodeNode* _tmp570_;
			ValaCodeNode* _tmp571_;
			_tmp570_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp571_ = _tmp570_;
			_tmp564_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp571_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp564_ = FALSE;
		}
		if (_tmp564_) {
			ValaSourceReference* _tmp572_;
			ValaSourceReference* _tmp573_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp573_ = _tmp572_;
			vala_report_error (_tmp573_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp574_ = ret_type;
	_tmp575_ = vala_data_type_copy (_tmp574_);
	_tmp576_ = _tmp575_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp576_);
	_vala_code_node_unref0 (_tmp576_);
	_tmp577_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp578_ = _tmp577_;
	_tmp579_ = target_object_type;
	_tmp580_ = method_type_args;
	_tmp581_ = vala_data_type_get_actual_type (_tmp578_, _tmp579_, _tmp580_, (ValaCodeNode*) self);
	_tmp582_ = _tmp581_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp582_);
	_vala_code_node_unref0 (_tmp582_);
	may_throw = FALSE;
	_tmp583_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp583_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp584_;
		ValaMethod* _tmp585_;
		ValaMethod* _tmp586_;
		ValaMethod* _tmp587_;
		gboolean _tmp588_;
		gboolean _tmp607_ = FALSE;
		gboolean _tmp608_ = FALSE;
		gboolean _tmp609_ = FALSE;
		ValaMethod* _tmp610_;
		ValaMethod* _tmp636_;
		gboolean _tmp637_;
		gboolean _tmp638_;
		ValaMethod* _tmp641_;
		gboolean _tmp642_;
		gboolean _tmp643_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp648_;
		ValaSymbol* _tmp649_;
		ValaSymbol* _tmp650_;
		ValaDynamicSignal* _tmp651_;
		gboolean _tmp652_ = FALSE;
		ValaDynamicSignal* _tmp653_;
		gboolean _tmp700_ = FALSE;
		ValaMethod* _tmp701_;
		gboolean _tmp826_ = FALSE;
		ValaMethod* _tmp827_;
		_tmp584_ = mtype;
		_tmp585_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp584_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp586_ = _tmp585_;
		_tmp587_ = _vala_code_node_ref0 (_tmp586_);
		m = _tmp587_;
		_tmp588_ = self->priv->_is_yield_expression;
		if (_tmp588_) {
			ValaMethod* _tmp589_;
			gboolean _tmp590_;
			gboolean _tmp591_;
			gboolean _tmp594_ = FALSE;
			ValaSemanticAnalyzer* _tmp595_;
			ValaSemanticAnalyzer* _tmp596_;
			ValaMethod* _tmp597_;
			ValaMethod* _tmp598_;
			_tmp589_ = m;
			_tmp590_ = vala_method_get_coroutine (_tmp589_);
			_tmp591_ = _tmp590_;
			if (!_tmp591_) {
				ValaSourceReference* _tmp592_;
				ValaSourceReference* _tmp593_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp593_ = _tmp592_;
				vala_report_error (_tmp593_, "yield expression requires async method");
			}
			_tmp595_ = vala_code_context_get_analyzer (context);
			_tmp596_ = _tmp595_;
			_tmp597_ = vala_semantic_analyzer_get_current_method (_tmp596_);
			_tmp598_ = _tmp597_;
			if (_tmp598_ == NULL) {
				_tmp594_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp599_;
				ValaSemanticAnalyzer* _tmp600_;
				ValaMethod* _tmp601_;
				ValaMethod* _tmp602_;
				gboolean _tmp603_;
				gboolean _tmp604_;
				_tmp599_ = vala_code_context_get_analyzer (context);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_semantic_analyzer_get_current_method (_tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_method_get_coroutine (_tmp602_);
				_tmp604_ = _tmp603_;
				_tmp594_ = !_tmp604_;
			}
			if (_tmp594_) {
				ValaSourceReference* _tmp605_;
				ValaSourceReference* _tmp606_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp605_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp606_ = _tmp605_;
				vala_report_error (_tmp606_, "yield expression not available outside async method");
			}
		}
		_tmp610_ = m;
		if (_tmp610_ != NULL) {
			ValaMethod* _tmp611_;
			gboolean _tmp612_;
			gboolean _tmp613_;
			_tmp611_ = m;
			_tmp612_ = vala_method_get_coroutine (_tmp611_);
			_tmp613_ = _tmp612_;
			_tmp609_ = _tmp613_;
		} else {
			_tmp609_ = FALSE;
		}
		if (_tmp609_) {
			gboolean _tmp614_;
			_tmp614_ = self->priv->_is_yield_expression;
			_tmp608_ = !_tmp614_;
		} else {
			_tmp608_ = FALSE;
		}
		if (_tmp608_) {
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			const gchar* _tmp617_;
			const gchar* _tmp618_;
			_tmp615_ = vala_method_call_get_call (self);
			_tmp616_ = _tmp615_;
			_tmp617_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp616_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp618_ = _tmp617_;
			_tmp607_ = g_strcmp0 (_tmp618_, "end") != 0;
		} else {
			_tmp607_ = FALSE;
		}
		if (_tmp607_) {
		} else {
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp619_;
				ValaList* _tmp620_;
				gint _error_type_size = 0;
				ValaList* _tmp621_;
				gint _tmp622_;
				gint _tmp623_;
				gint _error_type_index = 0;
				_tmp619_ = m;
				_tmp620_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp619_);
				_error_type_list = _tmp620_;
				_tmp621_ = _error_type_list;
				_tmp622_ = vala_collection_get_size ((ValaCollection*) _tmp621_);
				_tmp623_ = _tmp622_;
				_error_type_size = _tmp623_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp624_;
					gint _tmp625_;
					gint _tmp626_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp627_;
					gint _tmp628_;
					gpointer _tmp629_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp630_;
					ValaDataType* _tmp631_;
					ValaDataType* _tmp632_;
					ValaSourceReference* _tmp633_;
					ValaSourceReference* _tmp634_;
					ValaDataType* _tmp635_;
					_tmp624_ = _error_type_index;
					_error_type_index = _tmp624_ + 1;
					_tmp625_ = _error_type_index;
					_tmp626_ = _error_type_size;
					if (!(_tmp625_ < _tmp626_)) {
						break;
					}
					_tmp627_ = _error_type_list;
					_tmp628_ = _error_type_index;
					_tmp629_ = vala_list_get (_tmp627_, _tmp628_);
					error_type = (ValaDataType*) _tmp629_;
					may_throw = TRUE;
					_tmp630_ = error_type;
					_tmp631_ = vala_data_type_copy (_tmp630_);
					call_error_type = _tmp631_;
					_tmp632_ = call_error_type;
					_tmp633_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp634_ = _tmp633_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp632_, _tmp634_);
					_tmp635_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp635_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
		}
		_tmp636_ = m;
		_tmp637_ = vala_method_get_returns_floating_reference (_tmp636_);
		_tmp638_ = _tmp637_;
		if (_tmp638_) {
			ValaDataType* _tmp639_;
			ValaDataType* _tmp640_;
			_tmp639_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp640_ = _tmp639_;
			vala_data_type_set_floating_reference (_tmp640_, TRUE);
		}
		_tmp641_ = m;
		_tmp642_ = vala_method_get_returns_modified_pointer (_tmp641_);
		_tmp643_ = _tmp642_;
		if (_tmp643_) {
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			ValaExpression* _tmp646_;
			ValaExpression* _tmp647_;
			_tmp644_ = vala_method_call_get_call (self);
			_tmp645_ = _tmp644_;
			_tmp646_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp645_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp647_ = _tmp646_;
			vala_expression_set_lvalue (_tmp647_, TRUE);
		}
		_tmp648_ = m;
		_tmp649_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp648_);
		_tmp650_ = _tmp649_;
		_tmp651_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp650_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp650_) : NULL);
		dynamic_sig = _tmp651_;
		_tmp653_ = dynamic_sig;
		if (_tmp653_ != NULL) {
			ValaDynamicSignal* _tmp654_;
			ValaExpression* _tmp655_;
			ValaExpression* _tmp656_;
			_tmp654_ = dynamic_sig;
			_tmp655_ = vala_dynamic_signal_get_handler (_tmp654_);
			_tmp656_ = _tmp655_;
			_tmp652_ = _tmp656_ != NULL;
		} else {
			_tmp652_ = FALSE;
		}
		if (_tmp652_) {
			ValaDynamicSignal* _tmp657_;
			ValaDynamicSignal* _tmp658_;
			ValaExpression* _tmp659_;
			ValaExpression* _tmp660_;
			ValaDataType* _tmp661_;
			ValaDataType* _tmp662_;
			ValaDataType* _tmp663_;
			ValaDataType* _tmp664_;
			ValaDataType* _tmp665_;
			ValaDataType* _tmp666_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp687_;
			ValaExpression* _tmp688_;
			ValaExpression* _tmp689_;
			ValaDynamicSignal* _tmp690_;
			ValaDynamicSignal* _tmp691_;
			ValaSymbol* _tmp692_;
			ValaSymbol* _tmp693_;
			ValaObjectType* _tmp694_;
			ValaObjectType* _tmp695_;
			ValaDelegate* _tmp696_;
			ValaDelegate* _tmp697_;
			ValaDelegateType* _tmp698_;
			ValaDelegateType* _tmp699_;
			_tmp657_ = dynamic_sig;
			_tmp658_ = dynamic_sig;
			_tmp659_ = vala_dynamic_signal_get_handler (_tmp658_);
			_tmp660_ = _tmp659_;
			_tmp661_ = vala_expression_get_value_type (_tmp660_);
			_tmp662_ = _tmp661_;
			_tmp663_ = vala_data_type_get_return_type (_tmp662_);
			_tmp664_ = _tmp663_;
			_tmp665_ = vala_data_type_copy (_tmp664_);
			_tmp666_ = _tmp665_;
			vala_callable_set_return_type ((ValaCallable*) _tmp657_, _tmp666_);
			_vala_code_node_unref0 (_tmp666_);
			_vala_code_node_unref0 (_tmp664_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp667_;
				ValaExpression* _tmp668_;
				ValaExpression* _tmp669_;
				ValaDataType* _tmp670_;
				ValaDataType* _tmp671_;
				ValaList* _tmp672_;
				gint _param_size = 0;
				ValaList* _tmp673_;
				gint _tmp674_;
				gint _tmp675_;
				gint _param_index = 0;
				_tmp667_ = dynamic_sig;
				_tmp668_ = vala_dynamic_signal_get_handler (_tmp667_);
				_tmp669_ = _tmp668_;
				_tmp670_ = vala_expression_get_value_type (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_data_type_get_parameters (_tmp671_);
				_param_list = _tmp672_;
				_tmp673_ = _param_list;
				_tmp674_ = vala_collection_get_size ((ValaCollection*) _tmp673_);
				_tmp675_ = _tmp674_;
				_param_size = _tmp675_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp676_;
					gint _tmp677_;
					gint _tmp678_;
					ValaParameter* param = NULL;
					ValaList* _tmp679_;
					gint _tmp680_;
					gpointer _tmp681_;
					gboolean _tmp682_;
					_tmp676_ = _param_index;
					_param_index = _tmp676_ + 1;
					_tmp677_ = _param_index;
					_tmp678_ = _param_size;
					if (!(_tmp677_ < _tmp678_)) {
						break;
					}
					_tmp679_ = _param_list;
					_tmp680_ = _param_index;
					_tmp681_ = vala_list_get (_tmp679_, _tmp680_);
					param = (ValaParameter*) _tmp681_;
					_tmp682_ = first;
					if (_tmp682_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp683_;
						ValaParameter* _tmp684_;
						ValaParameter* _tmp685_;
						ValaParameter* _tmp686_;
						_tmp683_ = dynamic_sig;
						_tmp684_ = param;
						_tmp685_ = vala_parameter_copy (_tmp684_);
						_tmp686_ = _tmp685_;
						vala_callable_add_parameter ((ValaCallable*) _tmp683_, _tmp686_);
						_vala_code_node_unref0 (_tmp686_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp687_ = dynamic_sig;
			_tmp688_ = vala_dynamic_signal_get_handler (_tmp687_);
			_tmp689_ = _tmp688_;
			_tmp690_ = dynamic_sig;
			_tmp691_ = dynamic_sig;
			_tmp692_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp691_);
			_tmp693_ = _tmp692_;
			_tmp694_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp693_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp695_ = _tmp694_;
			_tmp696_ = vala_signal_get_delegate ((ValaSignal*) _tmp690_, (ValaDataType*) _tmp695_, (ValaCodeNode*) self);
			_tmp697_ = _tmp696_;
			_tmp698_ = vala_delegate_type_new (_tmp697_);
			_tmp699_ = _tmp698_;
			vala_expression_set_target_type (_tmp689_, (ValaDataType*) _tmp699_);
			_vala_code_node_unref0 (_tmp699_);
			_vala_code_node_unref0 (_tmp697_);
			_vala_code_node_unref0 (_tmp695_);
		}
		_tmp701_ = m;
		if (_tmp701_ != NULL) {
			ValaMethod* _tmp702_;
			ValaList* _tmp703_;
			ValaList* _tmp704_;
			gint _tmp705_;
			gint _tmp706_;
			_tmp702_ = m;
			_tmp703_ = vala_method_get_type_parameters (_tmp702_);
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_collection_get_size ((ValaCollection*) _tmp704_);
			_tmp706_ = _tmp705_;
			_tmp700_ = _tmp706_ > 0;
			_vala_iterable_unref0 (_tmp704_);
		} else {
			_tmp700_ = FALSE;
		}
		if (_tmp700_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp707_;
			ValaExpression* _tmp708_;
			ValaMemberAccess* _tmp709_;
			ValaMemberAccess* _tmp710_;
			ValaList* _tmp711_;
			ValaList* _tmp712_;
			gint _tmp713_;
			gint _tmp714_;
			gboolean _tmp715_;
			_tmp707_ = vala_method_call_get_call (self);
			_tmp708_ = _tmp707_;
			_tmp709_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp708_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp709_;
			_tmp710_ = ma;
			_tmp711_ = vala_member_access_get_type_arguments (_tmp710_);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_collection_get_size ((ValaCollection*) _tmp712_);
			_tmp714_ = _tmp713_;
			_tmp715_ = _tmp714_ == 0;
			_vala_iterable_unref0 (_tmp712_);
			if (_tmp715_) {
				ValaList* _tmp789_;
				ValaIterator* _tmp790_;
				ValaDataType* _tmp820_;
				ValaDataType* _tmp821_;
				ValaDataType* _tmp822_;
				ValaList* _tmp823_;
				ValaDataType* _tmp824_;
				ValaDataType* _tmp825_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp716_;
					ValaList* _tmp717_;
					gint _type_param_size = 0;
					ValaList* _tmp718_;
					gint _tmp719_;
					gint _tmp720_;
					gint _type_param_index = 0;
					_tmp716_ = m;
					_tmp717_ = vala_method_get_type_parameters (_tmp716_);
					_type_param_list = _tmp717_;
					_tmp718_ = _type_param_list;
					_tmp719_ = vala_collection_get_size ((ValaCollection*) _tmp718_);
					_tmp720_ = _tmp719_;
					_type_param_size = _tmp720_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp721_;
						gint _tmp722_;
						gint _tmp723_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp724_;
						gint _tmp725_;
						gpointer _tmp726_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp727_;
						ValaIterator* _tmp728_;
						gboolean _tmp767_ = FALSE;
						ValaDataType* _tmp768_;
						ValaDataType* _tmp778_;
						ValaMemberAccess* _tmp787_;
						ValaDataType* _tmp788_;
						_tmp721_ = _type_param_index;
						_type_param_index = _tmp721_ + 1;
						_tmp722_ = _type_param_index;
						_tmp723_ = _type_param_size;
						if (!(_tmp722_ < _tmp723_)) {
							break;
						}
						_tmp724_ = _type_param_list;
						_tmp725_ = _type_param_index;
						_tmp726_ = vala_list_get (_tmp724_, _tmp725_);
						type_param = (ValaTypeParameter*) _tmp726_;
						type_arg = NULL;
						_tmp727_ = args;
						_tmp728_ = vala_iterable_iterator ((ValaIterable*) _tmp727_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp728_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp729_;
							ValaList* _tmp730_;
							gint _param_size = 0;
							ValaList* _tmp731_;
							gint _tmp732_;
							gint _tmp733_;
							gint _param_index = 0;
							_tmp729_ = params;
							_tmp730_ = _vala_iterable_ref0 (_tmp729_);
							_param_list = _tmp730_;
							_tmp731_ = _param_list;
							_tmp732_ = vala_collection_get_size ((ValaCollection*) _tmp731_);
							_tmp733_ = _tmp732_;
							_param_size = _tmp733_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp734_;
								gint _tmp735_;
								gint _tmp736_;
								ValaParameter* param = NULL;
								ValaList* _tmp737_;
								gint _tmp738_;
								gpointer _tmp739_;
								gboolean _tmp740_ = FALSE;
								ValaParameter* _tmp741_;
								gboolean _tmp742_;
								gboolean _tmp743_;
								ValaIterator* _tmp747_;
								_tmp734_ = _param_index;
								_param_index = _tmp734_ + 1;
								_tmp735_ = _param_index;
								_tmp736_ = _param_size;
								if (!(_tmp735_ < _tmp736_)) {
									break;
								}
								_tmp737_ = _param_list;
								_tmp738_ = _param_index;
								_tmp739_ = vala_list_get (_tmp737_, _tmp738_);
								param = (ValaParameter*) _tmp739_;
								_tmp741_ = param;
								_tmp742_ = vala_parameter_get_ellipsis (_tmp741_);
								_tmp743_ = _tmp742_;
								if (_tmp743_) {
									_tmp740_ = TRUE;
								} else {
									ValaParameter* _tmp744_;
									gboolean _tmp745_;
									gboolean _tmp746_;
									_tmp744_ = param;
									_tmp745_ = vala_parameter_get_params_array (_tmp744_);
									_tmp746_ = _tmp745_;
									_tmp740_ = _tmp746_;
								}
								if (_tmp740_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp747_ = arg_it;
								if (vala_iterator_next (_tmp747_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp748_;
									gpointer _tmp749_;
									ValaParameter* _tmp750_;
									ValaDataType* _tmp751_;
									ValaDataType* _tmp752_;
									ValaTypeParameter* _tmp753_;
									ValaExpression* _tmp754_;
									ValaDataType* _tmp755_;
									ValaDataType* _tmp756_;
									ValaDataType* _tmp757_;
									ValaDataType* _tmp758_;
									ValaExpression* _tmp759_;
									ValaExpression* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									ValaDataType* _tmp763_;
									ValaList* _tmp764_;
									ValaDataType* _tmp765_;
									ValaDataType* _tmp766_;
									_tmp748_ = arg_it;
									_tmp749_ = vala_iterator_get (_tmp748_);
									arg = (ValaExpression*) _tmp749_;
									_tmp750_ = param;
									_tmp751_ = vala_variable_get_variable_type ((ValaVariable*) _tmp750_);
									_tmp752_ = _tmp751_;
									_tmp753_ = type_param;
									_tmp754_ = arg;
									_tmp755_ = vala_expression_get_value_type (_tmp754_);
									_tmp756_ = _tmp755_;
									_tmp757_ = vala_data_type_infer_type_argument (_tmp752_, _tmp753_, _tmp756_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp757_;
									_tmp758_ = type_arg;
									if (_tmp758_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp759_ = arg;
									_tmp760_ = arg;
									_tmp761_ = vala_expression_get_formal_target_type (_tmp760_);
									_tmp762_ = _tmp761_;
									_tmp763_ = target_object_type;
									_tmp764_ = method_type_args;
									_tmp765_ = vala_data_type_get_actual_type (_tmp762_, _tmp763_, _tmp764_, (ValaCodeNode*) self);
									_tmp766_ = _tmp765_;
									vala_expression_set_target_type (_tmp759_, _tmp766_);
									_vala_code_node_unref0 (_tmp766_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp768_ = type_arg;
						if (_tmp768_ == NULL) {
							ValaDataType* _tmp769_;
							ValaDataType* _tmp770_;
							_tmp769_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp770_ = _tmp769_;
							_tmp767_ = _tmp770_ != NULL;
						} else {
							_tmp767_ = FALSE;
						}
						if (_tmp767_) {
							ValaMethod* _tmp771_;
							ValaDataType* _tmp772_;
							ValaDataType* _tmp773_;
							ValaTypeParameter* _tmp774_;
							ValaDataType* _tmp775_;
							ValaDataType* _tmp776_;
							ValaDataType* _tmp777_;
							_tmp771_ = m;
							_tmp772_ = vala_callable_get_return_type ((ValaCallable*) _tmp771_);
							_tmp773_ = _tmp772_;
							_tmp774_ = type_param;
							_tmp775_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp776_ = _tmp775_;
							_tmp777_ = vala_data_type_infer_type_argument (_tmp773_, _tmp774_, _tmp776_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp777_;
						}
						_tmp778_ = type_arg;
						if (_tmp778_ == NULL) {
							ValaMemberAccess* _tmp779_;
							ValaSourceReference* _tmp780_;
							ValaSourceReference* _tmp781_;
							ValaTypeParameter* _tmp782_;
							gchar* _tmp783_;
							gchar* _tmp784_;
							gchar* _tmp785_;
							gchar* _tmp786_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp779_ = ma;
							_tmp780_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp779_);
							_tmp781_ = _tmp780_;
							_tmp782_ = type_param;
							_tmp783_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp782_);
							_tmp784_ = _tmp783_;
							_tmp785_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp784_);
							_tmp786_ = _tmp785_;
							vala_report_error (_tmp781_, _tmp786_);
							_g_free0 (_tmp786_);
							_g_free0 (_tmp784_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp787_ = ma;
						_tmp788_ = type_arg;
						vala_member_access_add_type_argument (_tmp787_, _tmp788_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp789_ = args;
				_tmp790_ = vala_iterable_iterator ((ValaIterable*) _tmp789_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp790_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp791_;
					ValaList* _tmp792_;
					gint _param_size = 0;
					ValaList* _tmp793_;
					gint _tmp794_;
					gint _tmp795_;
					gint _param_index = 0;
					_tmp791_ = params;
					_tmp792_ = _vala_iterable_ref0 (_tmp791_);
					_param_list = _tmp792_;
					_tmp793_ = _param_list;
					_tmp794_ = vala_collection_get_size ((ValaCollection*) _tmp793_);
					_tmp795_ = _tmp794_;
					_param_size = _tmp795_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp796_;
						gint _tmp797_;
						gint _tmp798_;
						ValaParameter* param = NULL;
						ValaList* _tmp799_;
						gint _tmp800_;
						gpointer _tmp801_;
						gboolean _tmp802_ = FALSE;
						ValaParameter* _tmp803_;
						gboolean _tmp804_;
						gboolean _tmp805_;
						ValaIterator* _tmp809_;
						_tmp796_ = _param_index;
						_param_index = _tmp796_ + 1;
						_tmp797_ = _param_index;
						_tmp798_ = _param_size;
						if (!(_tmp797_ < _tmp798_)) {
							break;
						}
						_tmp799_ = _param_list;
						_tmp800_ = _param_index;
						_tmp801_ = vala_list_get (_tmp799_, _tmp800_);
						param = (ValaParameter*) _tmp801_;
						_tmp803_ = param;
						_tmp804_ = vala_parameter_get_ellipsis (_tmp803_);
						_tmp805_ = _tmp804_;
						if (_tmp805_) {
							_tmp802_ = TRUE;
						} else {
							ValaParameter* _tmp806_;
							gboolean _tmp807_;
							gboolean _tmp808_;
							_tmp806_ = param;
							_tmp807_ = vala_parameter_get_params_array (_tmp806_);
							_tmp808_ = _tmp807_;
							_tmp802_ = _tmp808_;
						}
						if (_tmp802_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp809_ = arg_it;
						if (vala_iterator_next (_tmp809_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp810_;
							gpointer _tmp811_;
							ValaExpression* _tmp812_;
							ValaExpression* _tmp813_;
							ValaDataType* _tmp814_;
							ValaDataType* _tmp815_;
							ValaDataType* _tmp816_;
							ValaList* _tmp817_;
							ValaDataType* _tmp818_;
							ValaDataType* _tmp819_;
							_tmp810_ = arg_it;
							_tmp811_ = vala_iterator_get (_tmp810_);
							arg = (ValaExpression*) _tmp811_;
							_tmp812_ = arg;
							_tmp813_ = arg;
							_tmp814_ = vala_expression_get_formal_target_type (_tmp813_);
							_tmp815_ = _tmp814_;
							_tmp816_ = target_object_type;
							_tmp817_ = method_type_args;
							_tmp818_ = vala_data_type_get_actual_type (_tmp815_, _tmp816_, _tmp817_, (ValaCodeNode*) self);
							_tmp819_ = _tmp818_;
							vala_expression_set_target_type (_tmp812_, _tmp819_);
							_vala_code_node_unref0 (_tmp819_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp820_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp821_ = _tmp820_;
				_tmp822_ = target_object_type;
				_tmp823_ = method_type_args;
				_tmp824_ = vala_data_type_get_actual_type (_tmp821_, _tmp822_, _tmp823_, (ValaCodeNode*) self);
				_tmp825_ = _tmp824_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp825_);
				_vala_code_node_unref0 (_tmp825_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp827_ = m;
		if (_tmp827_ != NULL) {
			ValaMethod* _tmp828_;
			gboolean _tmp829_;
			gboolean _tmp830_;
			_tmp828_ = m;
			_tmp829_ = vala_method_get_coroutine (_tmp828_);
			_tmp830_ = _tmp829_;
			_tmp826_ = _tmp830_;
		} else {
			_tmp826_ = FALSE;
		}
		if (_tmp826_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp831_;
			ValaExpression* _tmp832_;
			ValaMemberAccess* _tmp833_;
			ValaMemberAccess* _tmp834_;
			const gchar* _tmp835_;
			const gchar* _tmp836_;
			_tmp831_ = vala_method_call_get_call (self);
			_tmp832_ = _tmp831_;
			_tmp833_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp832_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp833_;
			_tmp834_ = ma;
			_tmp835_ = vala_member_access_get_member_name (_tmp834_);
			_tmp836_ = _tmp835_;
			if (g_strcmp0 (_tmp836_, "end") == 0) {
				ValaMethod* _tmp837_;
				ValaMethod* _tmp838_;
				ValaMethod* _tmp839_;
				ValaMethodType* _tmp840_;
				_tmp837_ = m;
				_tmp838_ = vala_method_get_end_method (_tmp837_);
				_tmp839_ = _tmp838_;
				_tmp840_ = vala_method_type_new (_tmp839_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp840_;
				_vala_code_node_unref0 (_tmp839_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp841_;
		_tmp841_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp841_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp842_;
			ValaObjectTypeSymbol* _tmp843_;
			ValaObjectTypeSymbol* _tmp844_;
			ValaClass* _tmp845_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp846_;
			ValaCreationMethod* _tmp847_;
			ValaCreationMethod* _tmp848_;
			ValaCreationMethod* _tmp849_;
			_tmp842_ = mtype;
			_tmp843_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp842_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp844_ = _tmp843_;
			_tmp845_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp844_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp845_;
			_tmp846_ = cl;
			_tmp847_ = vala_class_get_default_construction_method (_tmp846_);
			_tmp848_ = _tmp847_;
			_tmp849_ = _vala_code_node_ref0 (_tmp848_);
			m = _tmp849_;
			{
				ValaList* _error_type_list = NULL;
				ValaCreationMethod* _tmp850_;
				ValaList* _tmp851_;
				gint _error_type_size = 0;
				ValaList* _tmp852_;
				gint _tmp853_;
				gint _tmp854_;
				gint _error_type_index = 0;
				_tmp850_ = m;
				_tmp851_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp850_);
				_error_type_list = _tmp851_;
				_tmp852_ = _error_type_list;
				_tmp853_ = vala_collection_get_size ((ValaCollection*) _tmp852_);
				_tmp854_ = _tmp853_;
				_error_type_size = _tmp854_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp855_;
					gint _tmp856_;
					gint _tmp857_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp858_;
					gint _tmp859_;
					gpointer _tmp860_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp861_;
					ValaDataType* _tmp862_;
					ValaDataType* _tmp863_;
					ValaSourceReference* _tmp864_;
					ValaSourceReference* _tmp865_;
					ValaDataType* _tmp866_;
					_tmp855_ = _error_type_index;
					_error_type_index = _tmp855_ + 1;
					_tmp856_ = _error_type_index;
					_tmp857_ = _error_type_size;
					if (!(_tmp856_ < _tmp857_)) {
						break;
					}
					_tmp858_ = _error_type_list;
					_tmp859_ = _error_type_index;
					_tmp860_ = vala_list_get (_tmp858_, _tmp859_);
					error_type = (ValaDataType*) _tmp860_;
					may_throw = TRUE;
					_tmp861_ = error_type;
					_tmp862_ = vala_data_type_copy (_tmp861_);
					call_error_type = _tmp862_;
					_tmp863_ = call_error_type;
					_tmp864_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp865_ = _tmp864_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp863_, _tmp865_);
					_tmp866_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp866_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp867_;
			_tmp867_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp867_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp868_;
				ValaDelegate* _tmp869_;
				ValaDelegate* _tmp870_;
				ValaDelegate* _tmp871_;
				_tmp868_ = mtype;
				_tmp869_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp868_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp870_ = _tmp869_;
				_tmp871_ = _vala_code_node_ref0 (_tmp870_);
				d = _tmp871_;
				{
					ValaList* _error_type_list = NULL;
					ValaDelegate* _tmp872_;
					ValaList* _tmp873_;
					gint _error_type_size = 0;
					ValaList* _tmp874_;
					gint _tmp875_;
					gint _tmp876_;
					gint _error_type_index = 0;
					_tmp872_ = d;
					_tmp873_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp872_);
					_error_type_list = _tmp873_;
					_tmp874_ = _error_type_list;
					_tmp875_ = vala_collection_get_size ((ValaCollection*) _tmp874_);
					_tmp876_ = _tmp875_;
					_error_type_size = _tmp876_;
					_error_type_index = -1;
					while (TRUE) {
						gint _tmp877_;
						gint _tmp878_;
						gint _tmp879_;
						ValaDataType* error_type = NULL;
						ValaList* _tmp880_;
						gint _tmp881_;
						gpointer _tmp882_;
						ValaDataType* call_error_type = NULL;
						ValaDataType* _tmp883_;
						ValaDataType* _tmp884_;
						ValaDataType* _tmp885_;
						ValaSourceReference* _tmp886_;
						ValaSourceReference* _tmp887_;
						ValaDataType* _tmp888_;
						_tmp877_ = _error_type_index;
						_error_type_index = _tmp877_ + 1;
						_tmp878_ = _error_type_index;
						_tmp879_ = _error_type_size;
						if (!(_tmp878_ < _tmp879_)) {
							break;
						}
						_tmp880_ = _error_type_list;
						_tmp881_ = _error_type_index;
						_tmp882_ = vala_list_get (_tmp880_, _tmp881_);
						error_type = (ValaDataType*) _tmp882_;
						may_throw = TRUE;
						_tmp883_ = error_type;
						_tmp884_ = vala_data_type_copy (_tmp883_);
						call_error_type = _tmp884_;
						_tmp885_ = call_error_type;
						_tmp886_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp887_ = _tmp886_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp885_, _tmp887_);
						_tmp888_ = call_error_type;
						vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp888_);
						_vala_code_node_unref0 (call_error_type);
						_vala_code_node_unref0 (error_type);
					}
					_vala_iterable_unref0 (_error_type_list);
				}
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp889_ = vala_code_context_get_analyzer (context);
	_tmp890_ = _tmp889_;
	_tmp891_ = mtype;
	_tmp892_ = params;
	_tmp893_ = vala_method_call_get_argument_list (self);
	_tmp894_ = _tmp893_;
	_tmp895_ = !vala_semantic_analyzer_check_arguments (_tmp890_, (ValaExpression*) self, _tmp891_, _tmp892_, _tmp894_);
	_vala_iterable_unref0 (_tmp894_);
	if (_tmp895_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp898_ = base_cm;
	if (_tmp898_ != NULL) {
		ValaCreationMethod* _tmp899_;
		_tmp899_ = base_cm;
		_tmp897_ = vala_method_is_variadic ((ValaMethod*) _tmp899_);
	} else {
		_tmp897_ = FALSE;
	}
	if (_tmp897_) {
		ValaList* _tmp900_;
		gint _tmp901_;
		gint _tmp902_;
		ValaCreationMethod* _tmp903_;
		ValaList* _tmp904_;
		ValaList* _tmp905_;
		gint _tmp906_;
		gint _tmp907_;
		_tmp900_ = args;
		_tmp901_ = vala_collection_get_size ((ValaCollection*) _tmp900_);
		_tmp902_ = _tmp901_;
		_tmp903_ = base_cm;
		_tmp904_ = vala_callable_get_parameters ((ValaCallable*) _tmp903_);
		_tmp905_ = _tmp904_;
		_tmp906_ = vala_collection_get_size ((ValaCollection*) _tmp905_);
		_tmp907_ = _tmp906_;
		_tmp896_ = _tmp902_ == _tmp907_;
		_vala_iterable_unref0 (_tmp905_);
	} else {
		_tmp896_ = FALSE;
	}
	if (_tmp896_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp908_;
		ValaList* _tmp909_;
		gint _tmp910_;
		gint _tmp911_;
		gpointer _tmp912_;
		gboolean _tmp913_ = FALSE;
		ValaExpression* _tmp914_;
		ValaDataType* _tmp915_;
		ValaDataType* _tmp916_;
		_tmp908_ = args;
		_tmp909_ = args;
		_tmp910_ = vala_collection_get_size ((ValaCollection*) _tmp909_);
		_tmp911_ = _tmp910_;
		_tmp912_ = vala_list_get (_tmp908_, _tmp911_ - 1);
		this_last_arg = (ValaExpression*) _tmp912_;
		_tmp914_ = this_last_arg;
		_tmp915_ = vala_expression_get_value_type (_tmp914_);
		_tmp916_ = _tmp915_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp916_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp917_;
			ValaDataType* _tmp918_;
			ValaDataType* _tmp919_;
			ValaTypeSymbol* _tmp920_;
			ValaTypeSymbol* _tmp921_;
			ValaSemanticAnalyzer* _tmp922_;
			ValaSemanticAnalyzer* _tmp923_;
			ValaDataType* _tmp924_;
			ValaTypeSymbol* _tmp925_;
			ValaTypeSymbol* _tmp926_;
			_tmp917_ = this_last_arg;
			_tmp918_ = vala_expression_get_value_type (_tmp917_);
			_tmp919_ = _tmp918_;
			_tmp920_ = vala_data_type_get_data_type (_tmp919_);
			_tmp921_ = _tmp920_;
			_tmp922_ = vala_code_context_get_analyzer (context);
			_tmp923_ = _tmp922_;
			_tmp924_ = _tmp923_->va_list_type;
			_tmp925_ = vala_data_type_get_data_type (_tmp924_);
			_tmp926_ = _tmp925_;
			_tmp913_ = _tmp921_ == _tmp926_;
		} else {
			_tmp913_ = FALSE;
		}
		if (_tmp913_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp927_ = may_throw;
	if (_tmp927_) {
		gboolean _tmp928_ = FALSE;
		ValaCodeNode* _tmp929_;
		ValaCodeNode* _tmp930_;
		_tmp929_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp930_ = _tmp929_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp930_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp928_ = TRUE;
		} else {
			ValaCodeNode* _tmp931_;
			ValaCodeNode* _tmp932_;
			_tmp931_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp932_ = _tmp931_;
			_tmp928_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp932_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp928_) {
		} else {
			ValaSemanticAnalyzer* _tmp933_;
			ValaSemanticAnalyzer* _tmp934_;
			ValaSymbol* _tmp935_;
			ValaSymbol* _tmp936_;
			_tmp933_ = vala_code_context_get_analyzer (context);
			_tmp934_ = _tmp933_;
			_tmp935_ = vala_semantic_analyzer_get_current_symbol (_tmp934_);
			_tmp936_ = _tmp935_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp936_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp937_;
				ValaSourceReference* _tmp938_;
				_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp938_ = _tmp937_;
				vala_report_error (_tmp938_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp939_;
				ValaCodeNode* _tmp940_;
				ValaCodeNode* _tmp941_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp942_;
				ValaDataType* _tmp943_;
				ValaDataType* _tmp944_;
				ValaDataType* _tmp945_;
				gchar* _tmp946_;
				gchar* _tmp947_;
				ValaSourceReference* _tmp948_;
				ValaSourceReference* _tmp949_;
				ValaLocalVariable* _tmp950_;
				ValaLocalVariable* _tmp951_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp952_;
				ValaSourceReference* _tmp953_;
				ValaSourceReference* _tmp954_;
				ValaDeclarationStatement* _tmp955_;
				ValaSemanticAnalyzer* _tmp956_;
				ValaSemanticAnalyzer* _tmp957_;
				ValaBlock* _tmp958_;
				ValaDeclarationStatement* _tmp959_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp960_;
				ValaDataType* _tmp961_;
				ValaDataType* _tmp962_;
				ValaExpression* _tmp963_;
				ValaLocalVariable* _tmp964_;
				ValaDeclarationStatement* _tmp965_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp966_;
				ValaSemanticAnalyzer* _tmp967_;
				ValaSymbol* _tmp968_;
				ValaSymbol* _tmp969_;
				ValaBlock* _tmp970_;
				ValaBlock* _tmp971_;
				ValaLocalVariable* _tmp972_;
				ValaSemanticAnalyzer* _tmp973_;
				ValaSemanticAnalyzer* _tmp974_;
				ValaBlock* _tmp975_;
				ValaLocalVariable* _tmp976_;
				ValaCodeNode* _tmp977_;
				ValaExpression* _tmp978_;
				ValaExpression* _tmp979_;
				_tmp939_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp940_ = _tmp939_;
				_tmp941_ = _vala_code_node_ref0 (_tmp940_);
				old_parent_node = _tmp941_;
				_tmp942_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp943_ = _tmp942_;
				_tmp944_ = vala_data_type_copy (_tmp943_);
				_tmp945_ = _tmp944_;
				_tmp946_ = vala_code_node_get_temp_name ();
				_tmp947_ = _tmp946_;
				_tmp948_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp949_ = _tmp948_;
				_tmp950_ = vala_local_variable_new (_tmp945_, _tmp947_, NULL, _tmp949_);
				_tmp951_ = _tmp950_;
				_g_free0 (_tmp947_);
				_vala_code_node_unref0 (_tmp945_);
				local = _tmp951_;
				_tmp952_ = local;
				_tmp953_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp954_ = _tmp953_;
				_tmp955_ = vala_declaration_statement_new ((ValaSymbol*) _tmp952_, _tmp954_);
				decl = _tmp955_;
				_tmp956_ = vala_code_context_get_analyzer (context);
				_tmp957_ = _tmp956_;
				_tmp958_ = _tmp957_->insert_block;
				_tmp959_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp958_, (ValaStatement*) _tmp959_);
				_tmp960_ = local;
				_tmp961_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp962_ = _tmp961_;
				_tmp963_ = vala_semantic_analyzer_create_temp_access (_tmp960_, _tmp962_);
				temp_access = _tmp963_;
				_tmp964_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp964_, (ValaExpression*) self);
				_tmp965_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp965_, context);
				_tmp966_ = vala_code_context_get_analyzer (context);
				_tmp967_ = _tmp966_;
				_tmp968_ = vala_semantic_analyzer_get_current_symbol (_tmp967_);
				_tmp969_ = _tmp968_;
				_tmp970_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp969_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp970_;
				_tmp971_ = block;
				_tmp972_ = local;
				vala_block_remove_local_variable (_tmp971_, _tmp972_);
				_tmp973_ = vala_code_context_get_analyzer (context);
				_tmp974_ = _tmp973_;
				_tmp975_ = _tmp974_->insert_block;
				_tmp976_ = local;
				vala_block_add_local_variable (_tmp975_, _tmp976_);
				_tmp977_ = old_parent_node;
				_tmp978_ = temp_access;
				vala_code_node_replace_expression (_tmp977_, (ValaExpression*) self, _tmp978_);
				_tmp979_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp979_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp980_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp981_ = _tmp980_;
	result = !_tmp981_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}


static void
vala_method_call_real_emit (ValaCodeNode* base, 
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaExpression* expr = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaExpression* _tmp31_;
			_tmp25_ = _expr_index;
			_expr_index = _tmp25_ + 1;
			_tmp26_ = _expr_index;
			_tmp27_ = _expr_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _expr_list;
			_tmp29_ = _expr_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			expr = (ValaExpression*) _tmp30_;
			_tmp31_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp31_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}


static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base, 
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_method_call_real_get_used_variables (ValaCodeNode* base, 
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		_tmp10_ = format_arg;
		if (_tmp10_ >= 0) {
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp11_ = format_arg;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp9_ = _tmp11_ < _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaStringLiteral* _tmp19_;
			ValaStringLiteral* _tmp20_;
			_tmp15_ = self->priv->argument_list;
			_tmp16_ = format_arg;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_tmp19_ = vala_string_literal_get_format_literal (_tmp18_);
			_tmp20_ = _tmp19_;
			_vala_code_node_unref0 (_tmp18_);
			result = _tmp20_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}


ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_call (ValaMethodCall* self, 
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_is_yield_expression (ValaMethodCall* self, 
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_assert;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_assert (ValaMethodCall* self, 
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}


gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_constructv_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self, 
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}


gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_chainup (ValaMethodCall* self, 
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}


static void
vala_method_call_class_init (ValaMethodCallClass * klass)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodCallPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_call_real_get_used_variables;
}


static void
vala_method_call_instance_init (ValaMethodCall * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_CALL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}


static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}



