/* valatypeofexpression.c generated by valac, the Vala compiler
 * generated from valatypeofexpression.vala, do not modify */

/* valatypeofexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

enum  {
	VALA_TYPEOF_EXPRESSION_0_PROPERTY,
	VALA_TYPEOF_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* vala_typeof_expression_properties[VALA_TYPEOF_EXPRESSION_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaTypeofExpressionPrivate {
	ValaDataType* _data_type;
};


static gpointer vala_typeof_expression_parent_class = NULL;

#define VALA_TYPEOF_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionPrivate))
static void vala_typeof_expression_real_accept (ValaCodeNode* base, 
                                         ValaCodeVisitor* visitor);
static void vala_typeof_expression_real_accept_children (ValaCodeNode* base, 
                                                  ValaCodeVisitor* visitor);
static gboolean vala_typeof_expression_real_is_pure (ValaExpression* base);
static void vala_typeof_expression_real_replace_type (ValaCodeNode* base, 
                                               ValaDataType* old_type, 
                                               ValaDataType* new_type);
static gboolean vala_typeof_expression_real_check (ValaCodeNode* base, 
                                            ValaCodeContext* context);
static void vala_typeof_expression_real_emit (ValaCodeNode* base, 
                                       ValaCodeGenerator* codegen);
static void vala_typeof_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new typeof expression.
 *
 * @param type   a data type
 * @param source reference to source code
 * @return       newly created typeof expression
 */
ValaTypeofExpression*
vala_typeof_expression_construct (GType object_type, 
                                  ValaDataType* type, 
                                  ValaSourceReference* source)
{
	ValaTypeofExpression* self = NULL;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaTypeofExpression*) vala_expression_construct (object_type);
	vala_typeof_expression_set_type_reference (self, type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaTypeofExpression*
vala_typeof_expression_new (ValaDataType* type, 
                            ValaSourceReference* source)
{
	return vala_typeof_expression_construct (VALA_TYPE_TYPEOF_EXPRESSION, type, source);
}


static void
vala_typeof_expression_real_accept (ValaCodeNode* base, 
                                    ValaCodeVisitor* visitor)
{
	ValaTypeofExpression * self;
	self = (ValaTypeofExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_typeof_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_typeof_expression_real_accept_children (ValaCodeNode* base, 
                                             ValaCodeVisitor* visitor)
{
	ValaTypeofExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaTypeofExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_typeof_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}


static gboolean
vala_typeof_expression_real_is_pure (ValaExpression* base)
{
	ValaTypeofExpression * self;
	gboolean result = FALSE;
	self = (ValaTypeofExpression*) base;
	result = TRUE;
	return result;
}


static void
vala_typeof_expression_real_replace_type (ValaCodeNode* base, 
                                          ValaDataType* old_type, 
                                          ValaDataType* new_type)
{
	ValaTypeofExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaTypeofExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_typeof_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_typeof_expression_set_type_reference (self, new_type);
	}
}


static gboolean
vala_typeof_expression_real_check (ValaCodeNode* base, 
                                   ValaCodeContext* context)
{
	ValaTypeofExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaList* _tmp11_;
	ValaList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	self = (ValaTypeofExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_typeof_expression_get_type_reference (self);
	_tmp5_ = _tmp4_;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->type_type;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp8_);
	_tmp9_ = vala_typeof_expression_get_type_reference (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_data_type_get_type_arguments (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ > 0;
	_vala_iterable_unref0 (_tmp12_);
	if (_tmp15_) {
		ValaDataType* _tmp16_;
		ValaSourceReference* _tmp17_;
		ValaSourceReference* _tmp18_;
		_tmp16_ = self->priv->_data_type;
		_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
		_tmp18_ = _tmp17_;
		vala_report_warning (_tmp18_, "Type argument list without effect");
	}
	_tmp19_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp20_ = _tmp19_;
	result = !_tmp20_;
	return result;
}


static void
vala_typeof_expression_real_emit (ValaCodeNode* base, 
                                  ValaCodeGenerator* codegen)
{
	ValaTypeofExpression * self;
	self = (ValaTypeofExpression*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_typeof_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


ValaDataType*
vala_typeof_expression_get_type_reference (ValaTypeofExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


void
vala_typeof_expression_set_type_reference (ValaTypeofExpression* self, 
                                           ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_typeof_expression_class_init (ValaTypeofExpressionClass * klass)
{
	vala_typeof_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_typeof_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeofExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_typeof_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_typeof_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_typeof_expression_real_is_pure;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_typeof_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_typeof_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_typeof_expression_real_emit;
}


static void
vala_typeof_expression_instance_init (ValaTypeofExpression * self)
{
	self->priv = VALA_TYPEOF_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_typeof_expression_finalize (ValaCodeNode * obj)
{
	ValaTypeofExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_typeof_expression_parent_class)->finalize (obj);
}


/**
 * Represents a typeof expression in the source code.
 */
GType
vala_typeof_expression_get_type (void)
{
	static volatile gsize vala_typeof_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_typeof_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeofExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeof_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeofExpression), 0, (GInstanceInitFunc) vala_typeof_expression_instance_init, NULL };
		GType vala_typeof_expression_type_id;
		vala_typeof_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTypeofExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_typeof_expression_type_id__volatile, vala_typeof_expression_type_id);
	}
	return vala_typeof_expression_type_id__volatile;
}



