/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};


static gpointer vala_initializer_list_parent_class = NULL;

#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);


/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			if (!vala_expression_is_constant (_tmp11_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			if (!vala_expression_is_pure (_tmp11_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->initializers;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->initializers;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->initializers;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_node);
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_ = FALSE;
	gboolean _tmp197_;
	gboolean _tmp204_;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			ValaCodeNode* _tmp15_;
			ValaCodeNode* _tmp16_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp12_;
			_tmp15_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp16_ = _tmp15_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_ARRAY_CREATION_EXPRESSION)) {
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				_tmp17_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				_tmp14_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_CONSTANT);
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				ValaCodeNode* _tmp19_;
				ValaCodeNode* _tmp20_;
				_tmp19_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp20_ = _tmp19_;
				_tmp13_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_INITIALIZER_LIST);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp21_;
				ValaCodeNode* _tmp22_;
				ValaCodeNode* _tmp23_;
				ValaArrayCreationExpression* array_creation = NULL;
				ValaArrayType* _tmp24_;
				ValaDataType* _tmp25_;
				ValaDataType* _tmp26_;
				ValaDataType* _tmp27_;
				ValaDataType* _tmp28_;
				ValaArrayType* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaArrayCreationExpression* _tmp34_;
				ValaArrayCreationExpression* _tmp35_;
				ValaArrayCreationExpression* _tmp36_;
				ValaDataType* _tmp37_;
				ValaDataType* _tmp38_;
				ValaCodeNode* _tmp39_;
				ValaArrayCreationExpression* _tmp40_;
				ValaArrayCreationExpression* _tmp41_;
				_tmp21_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp22_ = _tmp21_;
				_tmp23_ = _vala_code_node_ref0 (_tmp22_);
				old_parent_node = _tmp23_;
				_tmp24_ = array_type;
				_tmp25_ = vala_array_type_get_element_type (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_data_type_copy (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = array_type;
				_tmp30_ = vala_array_type_get_rank (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_array_creation_expression_new (_tmp28_, _tmp31_, self, _tmp33_);
				_tmp35_ = _tmp34_;
				_vala_code_node_unref0 (_tmp28_);
				array_creation = _tmp35_;
				_tmp36_ = array_creation;
				_tmp37_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp38_ = _tmp37_;
				vala_expression_set_target_type ((ValaExpression*) _tmp36_, _tmp38_);
				_tmp39_ = old_parent_node;
				_tmp40_ = array_creation;
				vala_code_node_replace_expression (_tmp39_, (ValaExpression*) self, (ValaExpression*) _tmp40_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp41_ = array_creation;
				result = vala_code_node_check ((ValaCodeNode*) _tmp41_, context);
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp42_ = array_type;
			_tmp43_ = vala_array_type_get_rank (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ > 1) {
				ValaArrayType* inner_array_type = NULL;
				ValaArrayType* _tmp45_;
				ValaDataType* _tmp46_;
				ValaArrayType* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				ValaArrayType* _tmp50_;
				ValaDataType* _tmp51_;
				_tmp45_ = array_type;
				_tmp46_ = vala_data_type_copy ((ValaDataType*) _tmp45_);
				inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp47_ = inner_array_type;
				_tmp48_ = vala_array_type_get_rank (_tmp47_);
				_tmp49_ = _tmp48_;
				vala_array_type_set_rank (_tmp47_, _tmp49_ - 1);
				_tmp50_ = inner_array_type;
				_tmp51_ = _vala_code_node_ref0 ((ValaDataType*) _tmp50_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp51_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp52_;
				ValaDataType* _tmp53_;
				ValaDataType* _tmp54_;
				ValaDataType* _tmp55_;
				_tmp52_ = array_type;
				_tmp53_ = vala_array_type_get_element_type (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_data_type_copy (_tmp54_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp55_;
			}
			{
				ValaList* _e_list = NULL;
				ValaList* _tmp56_;
				gint _e_size = 0;
				ValaList* _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				gint _e_index = 0;
				_tmp56_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp56_;
				_tmp57_ = _e_list;
				_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
				_tmp59_ = _tmp58_;
				_e_size = _tmp59_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					ValaExpression* e = NULL;
					ValaList* _tmp63_;
					gint _tmp64_;
					gpointer _tmp65_;
					ValaExpression* _tmp66_;
					ValaDataType* _tmp67_;
					_tmp60_ = _e_index;
					_e_index = _tmp60_ + 1;
					_tmp61_ = _e_index;
					_tmp62_ = _e_size;
					if (!(_tmp61_ < _tmp62_)) {
						break;
					}
					_tmp63_ = _e_list;
					_tmp64_ = _e_index;
					_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
					e = (ValaExpression*) _tmp65_;
					_tmp66_ = e;
					_tmp67_ = inner_target_type;
					vala_expression_set_target_type (_tmp66_, _tmp67_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp68_;
			ValaDataType* _tmp69_;
			ValaTypeSymbol* _tmp70_;
			ValaTypeSymbol* _tmp71_;
			_tmp68_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_data_type_get_data_type (_tmp69_);
			_tmp71_ = _tmp70_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_STRUCT)) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp72_;
				ValaDataType* _tmp73_;
				ValaTypeSymbol* _tmp74_;
				ValaTypeSymbol* _tmp75_;
				ValaStruct* _tmp76_;
				ValaIterator* field_it = NULL;
				ValaStruct* _tmp84_;
				ValaList* _tmp85_;
				ValaList* _tmp86_;
				ValaIterator* _tmp87_;
				ValaIterator* _tmp88_;
				_tmp72_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_data_type_get_data_type (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp76_;
				while (TRUE) {
					ValaStruct* _tmp77_;
					ValaStruct* _tmp78_;
					ValaStruct* _tmp79_;
					ValaStruct* _tmp80_;
					ValaStruct* _tmp81_;
					ValaStruct* _tmp82_;
					ValaStruct* _tmp83_;
					_tmp77_ = st;
					_tmp78_ = vala_struct_get_base_struct (_tmp77_);
					_tmp79_ = _tmp78_;
					if (!(_tmp79_ != NULL)) {
						break;
					}
					_tmp80_ = st;
					_tmp81_ = vala_struct_get_base_struct (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = _vala_code_node_ref0 (_tmp82_);
					_vala_code_node_unref0 (st);
					st = _tmp83_;
				}
				_tmp84_ = st;
				_tmp85_ = vala_struct_get_fields (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_iterable_iterator ((ValaIterable*) _tmp86_);
				_tmp88_ = _tmp87_;
				_vala_iterable_unref0 (_tmp86_);
				field_it = _tmp88_;
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp89_;
					gint _e_size = 0;
					ValaList* _tmp90_;
					gint _tmp91_;
					gint _tmp92_;
					gint _e_index = 0;
					_tmp89_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp89_;
					_tmp90_ = _e_list;
					_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
					_tmp92_ = _tmp91_;
					_e_size = _tmp92_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp93_;
						gint _tmp94_;
						gint _tmp95_;
						ValaExpression* e = NULL;
						ValaList* _tmp96_;
						gint _tmp97_;
						gpointer _tmp98_;
						ValaField* field = NULL;
						ValaExpression* _tmp115_;
						ValaField* _tmp116_;
						ValaDataType* _tmp117_;
						ValaDataType* _tmp118_;
						ValaDataType* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaDataType* _tmp122_;
						gboolean _tmp123_;
						gboolean _tmp124_;
						_tmp93_ = _e_index;
						_e_index = _tmp93_ + 1;
						_tmp94_ = _e_index;
						_tmp95_ = _e_size;
						if (!(_tmp94_ < _tmp95_)) {
							break;
						}
						_tmp96_ = _e_list;
						_tmp97_ = _e_index;
						_tmp98_ = vala_list_get (_tmp96_, _tmp97_);
						e = (ValaExpression*) _tmp98_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp99_;
							ValaIterator* _tmp100_;
							ValaIterator* _tmp110_;
							gpointer _tmp111_;
							ValaField* _tmp112_;
							ValaMemberBinding _tmp113_;
							ValaMemberBinding _tmp114_;
							_tmp99_ = field;
							if (!(_tmp99_ == NULL)) {
								break;
							}
							_tmp100_ = field_it;
							if (!vala_iterator_next (_tmp100_)) {
								ValaExpression* _tmp101_;
								ValaSourceReference* _tmp102_;
								ValaSourceReference* _tmp103_;
								ValaDataType* _tmp104_;
								ValaDataType* _tmp105_;
								gchar* _tmp106_;
								gchar* _tmp107_;
								gchar* _tmp108_;
								gchar* _tmp109_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp101_ = e;
								_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
								_tmp103_ = _tmp102_;
								_tmp104_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp105_ = _tmp104_;
								_tmp106_ = vala_code_node_to_string ((ValaCodeNode*) _tmp105_);
								_tmp107_ = _tmp106_;
								_tmp108_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp107_);
								_tmp109_ = _tmp108_;
								vala_report_error (_tmp103_, _tmp109_);
								_g_free0 (_tmp109_);
								_g_free0 (_tmp107_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp110_ = field_it;
							_tmp111_ = vala_iterator_get (_tmp110_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp111_;
							_tmp112_ = field;
							_tmp113_ = vala_field_get_binding (_tmp112_);
							_tmp114_ = _tmp113_;
							if (_tmp114_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						_tmp115_ = e;
						_tmp116_ = field;
						_tmp117_ = vala_variable_get_variable_type ((ValaVariable*) _tmp116_);
						_tmp118_ = _tmp117_;
						_tmp119_ = vala_data_type_copy (_tmp118_);
						_tmp120_ = _tmp119_;
						vala_expression_set_target_type (_tmp115_, _tmp120_);
						_vala_code_node_unref0 (_tmp120_);
						_tmp121_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp122_ = _tmp121_;
						_tmp123_ = vala_data_type_get_value_owned (_tmp122_);
						_tmp124_ = _tmp123_;
						if (!_tmp124_) {
							ValaExpression* _tmp125_;
							ValaDataType* _tmp126_;
							ValaDataType* _tmp127_;
							_tmp125_ = e;
							_tmp126_ = vala_expression_get_target_type (_tmp125_);
							_tmp127_ = _tmp126_;
							vala_data_type_set_value_owned (_tmp127_, FALSE);
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp128_;
				ValaSourceReference* _tmp129_;
				ValaDataType* _tmp130_;
				ValaDataType* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_code_node_to_string ((ValaCodeNode*) _tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp133_);
				_tmp135_ = _tmp134_;
				vala_report_error (_tmp129_, _tmp135_);
				_g_free0 (_tmp135_);
				_g_free0 (_tmp133_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp136_;
		ValaList* _tmp137_;
		gint _expr_size = 0;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _expr_index = 0;
		_tmp136_ = self->priv->initializers;
		_tmp137_ = _vala_iterable_ref0 (_tmp136_);
		_expr_list = _tmp137_;
		_tmp138_ = _expr_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_expr_size = _tmp140_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaExpression* expr = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			ValaExpression* _tmp147_;
			_tmp141_ = _expr_index;
			_expr_index = _tmp141_ + 1;
			_tmp142_ = _expr_index;
			_tmp143_ = _expr_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _expr_list;
			_tmp145_ = _expr_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			expr = (ValaExpression*) _tmp146_;
			_tmp147_ = expr;
			vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp148_;
		gint _e_size = 0;
		ValaList* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _e_index = 0;
		_tmp148_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp148_;
		_tmp149_ = _e_list;
		_tmp150_ = vala_collection_get_size ((ValaCollection*) _tmp149_);
		_tmp151_ = _tmp150_;
		_e_size = _tmp151_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			ValaExpression* e = NULL;
			ValaList* _tmp155_;
			gint _tmp156_;
			gpointer _tmp157_;
			ValaExpression* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp164_;
			ValaUnaryExpression* _tmp165_;
			gboolean _tmp166_ = FALSE;
			ValaUnaryExpression* _tmp167_;
			_tmp152_ = _e_index;
			_e_index = _tmp152_ + 1;
			_tmp153_ = _e_index;
			_tmp154_ = _e_size;
			if (!(_tmp153_ < _tmp154_)) {
				break;
			}
			_tmp155_ = _e_list;
			_tmp156_ = _e_index;
			_tmp157_ = vala_list_get (_tmp155_, _tmp156_);
			e = (ValaExpression*) _tmp157_;
			_tmp158_ = e;
			_tmp159_ = vala_expression_get_value_type (_tmp158_);
			_tmp160_ = _tmp159_;
			if (_tmp160_ == NULL) {
				ValaExpression* _tmp161_;
				ValaSourceReference* _tmp162_;
				ValaSourceReference* _tmp163_;
				_error_ = TRUE;
				_tmp161_ = e;
				_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp161_);
				_tmp163_ = _tmp162_;
				vala_report_error (_tmp163_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp164_ = e;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp164_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp164_) : NULL);
			unary = _tmp165_;
			_tmp167_ = unary;
			if (_tmp167_ != NULL) {
				gboolean _tmp168_ = FALSE;
				ValaUnaryExpression* _tmp169_;
				ValaUnaryOperator _tmp170_;
				ValaUnaryOperator _tmp171_;
				_tmp169_ = unary;
				_tmp170_ = vala_unary_expression_get_operator (_tmp169_);
				_tmp171_ = _tmp170_;
				if (_tmp171_ == VALA_UNARY_OPERATOR_REF) {
					_tmp168_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp172_;
					ValaUnaryOperator _tmp173_;
					ValaUnaryOperator _tmp174_;
					_tmp172_ = unary;
					_tmp173_ = vala_unary_expression_get_operator (_tmp172_);
					_tmp174_ = _tmp173_;
					_tmp168_ = _tmp174_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp166_ = _tmp168_;
			} else {
				_tmp166_ = FALSE;
			}
			if (_tmp166_) {
			} else {
				ValaExpression* _tmp175_;
				ValaDataType* _tmp176_;
				ValaDataType* _tmp177_;
				ValaExpression* _tmp178_;
				ValaDataType* _tmp179_;
				ValaDataType* _tmp180_;
				_tmp175_ = e;
				_tmp176_ = vala_expression_get_value_type (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = e;
				_tmp179_ = vala_expression_get_target_type (_tmp178_);
				_tmp180_ = _tmp179_;
				if (!vala_data_type_compatible (_tmp177_, _tmp180_)) {
					ValaExpression* _tmp181_;
					ValaExpression* _tmp182_;
					ValaSourceReference* _tmp183_;
					ValaSourceReference* _tmp184_;
					ValaExpression* _tmp185_;
					ValaDataType* _tmp186_;
					ValaDataType* _tmp187_;
					gchar* _tmp188_;
					gchar* _tmp189_;
					ValaExpression* _tmp190_;
					ValaDataType* _tmp191_;
					ValaDataType* _tmp192_;
					gchar* _tmp193_;
					gchar* _tmp194_;
					gchar* _tmp195_;
					gchar* _tmp196_;
					_error_ = TRUE;
					_tmp181_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp181_, TRUE);
					_tmp182_ = e;
					_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp182_);
					_tmp184_ = _tmp183_;
					_tmp185_ = e;
					_tmp186_ = vala_expression_get_target_type (_tmp185_);
					_tmp187_ = _tmp186_;
					_tmp188_ = vala_code_node_to_string ((ValaCodeNode*) _tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = e;
					_tmp191_ = vala_expression_get_value_type (_tmp190_);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_code_node_to_string ((ValaCodeNode*) _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp189_, _tmp194_);
					_tmp196_ = _tmp195_;
					vala_report_error (_tmp184_, _tmp196_);
					_g_free0 (_tmp196_);
					_g_free0 (_tmp194_);
					_g_free0 (_tmp189_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp197_ = _error_;
	if (!_tmp197_) {
		ValaDataType* _tmp198_;
		ValaDataType* _tmp199_;
		ValaDataType* _tmp200_;
		ValaDataType* _tmp201_;
		ValaDataType* _tmp202_;
		ValaDataType* _tmp203_;
		_tmp198_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp199_ = _tmp198_;
		_tmp200_ = vala_data_type_copy (_tmp199_);
		_tmp201_ = _tmp200_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp201_);
		_vala_code_node_unref0 (_tmp201_);
		_tmp202_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp203_ = _tmp202_;
		vala_data_type_set_nullable (_tmp203_, FALSE);
	}
	_tmp204_ = _error_;
	result = !_tmp204_;
	return result;
}


static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void
vala_initializer_list_class_init (ValaInitializerListClass * klass)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression *)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}


static void
vala_initializer_list_instance_init (ValaInitializerList * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}


static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}



