/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

static gboolean vala_ccode_compiler_package_exists (const gchar* package_name,
                                             const gchar* pkg_config_command);
static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);


ValaCCodeCompiler*
vala_ccode_compiler_construct (GType object_type)
{
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler*
vala_ccode_compiler_new (void)
{
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


static gboolean
vala_ccode_compiler_package_exists (const gchar* package_name,
                                    const gchar* pkg_config_command)
{
	gboolean result = FALSE;
	gchar* pc = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint exit_status = 0;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (package_name != NULL, FALSE);
	_tmp0_ = g_strconcat (pkg_config_command, " --exists ", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, package_name, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	pc = _tmp3_;
	{
		gint _tmp4_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp4_, &_inner_error_);
		exit_status = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp5_;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		vala_report_error (NULL, _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally3:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp8_;
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void
vala_ccode_compiler_compile (ValaCCodeCompiler* self,
                             ValaCodeContext* context,
                             const gchar* cc_command,
                             gchar** cc_options,
                             int cc_options_length1,
                             const gchar* pkg_config_command)
{
	gboolean use_pkgconfig = FALSE;
	gchar* pc = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* pkgflags = NULL;
	gchar* _tmp23_;
	gboolean _tmp24_;
	gchar* cmdline = NULL;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	ValaList* source_files = NULL;
	ValaList* _tmp68_;
	ValaList* c_source_files = NULL;
	ValaList* _tmp92_;
	const gchar* _tmp111_;
	const gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gboolean _tmp126_;
	gboolean _tmp127_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	use_pkgconfig = FALSE;
	if (pkg_config_command == NULL) {
		pkg_config_command = "pkg-config";
	}
	_tmp0_ = g_strconcat (pkg_config_command, " --cflags", NULL);
	pc = _tmp0_;
	_tmp1_ = vala_code_context_get_compile_only (context);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = pc;
		_tmp4_ = g_strconcat (_tmp3_, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
	}
	use_pkgconfig = TRUE;
	_tmp5_ = pc;
	_tmp6_ = g_strconcat (_tmp5_, " gobject-2.0", NULL);
	_g_free0 (pc);
	pc = _tmp6_;
	{
		ValaList* _pkg_list = NULL;
		ValaList* _tmp7_;
		gint _pkg_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _pkg_index = 0;
		_tmp7_ = vala_code_context_get_packages (context);
		_pkg_list = _tmp7_;
		_tmp8_ = _pkg_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_pkg_size = _tmp10_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gchar* pkg = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			const gchar* _tmp17_;
			_tmp11_ = _pkg_index;
			_pkg_index = _tmp11_ + 1;
			_tmp12_ = _pkg_index;
			_tmp13_ = _pkg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _pkg_list;
			_tmp15_ = _pkg_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			pkg = (gchar*) _tmp16_;
			_tmp17_ = pkg;
			if (vala_ccode_compiler_package_exists (_tmp17_, pkg_config_command)) {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				use_pkgconfig = TRUE;
				_tmp18_ = pc;
				_tmp19_ = pkg;
				_tmp20_ = g_strconcat (" ", _tmp19_, NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
				_g_free0 (pc);
				pc = _tmp22_;
				_g_free0 (_tmp21_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp23_ = g_strdup ("");
	pkgflags = _tmp23_;
	_tmp24_ = use_pkgconfig;
	if (_tmp24_) {
		{
			gint exit_status = 0;
			const gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_;
			_tmp25_ = pc;
			g_spawn_command_line_sync (_tmp25_, &_tmp26_, NULL, &_tmp27_, &_inner_error_);
			_g_free0 (pkgflags);
			pkgflags = _tmp26_;
			exit_status = _tmp27_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch4_g_spawn_error;
				}
				_g_free0 (pkgflags);
				_g_free0 (pc);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp28_ = exit_status;
			if (_tmp28_ != 0) {
				gint _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = exit_status;
				_tmp30_ = g_strdup_printf ("pkg-config exited with status %d", _tmp29_);
				_tmp31_ = _tmp30_;
				vala_report_error (NULL, _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (pkgflags);
				_g_free0 (pc);
				return;
			}
		}
		goto __finally4;
		__catch4_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			vala_report_error (NULL, _tmp33_);
			_g_error_free0 (e);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp34_ = g_strdup (cc_command);
	cmdline = _tmp34_;
	_tmp35_ = vala_code_context_get_debug (context);
	_tmp36_ = _tmp35_;
	if (_tmp36_) {
		const gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp37_ = cmdline;
		_tmp38_ = g_strconcat (_tmp37_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp38_;
	}
	_tmp39_ = vala_code_context_get_compile_only (context);
	_tmp40_ = _tmp39_;
	if (_tmp40_) {
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp41_ = cmdline;
		_tmp42_ = g_strconcat (_tmp41_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp42_;
	} else {
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		_tmp43_ = vala_code_context_get_output (context);
		_tmp44_ = _tmp43_;
		if (_tmp44_ != NULL) {
			gchar* output = NULL;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp45_ = vala_code_context_get_output (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup (_tmp46_);
			output = _tmp47_;
			_tmp50_ = vala_code_context_get_directory (context);
			_tmp51_ = _tmp50_;
			if (_tmp51_ != NULL) {
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				_tmp52_ = vala_code_context_get_directory (context);
				_tmp53_ = _tmp52_;
				_tmp49_ = g_strcmp0 (_tmp53_, "") != 0;
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				_tmp54_ = vala_code_context_get_output (context);
				_tmp55_ = _tmp54_;
				_tmp48_ = !g_path_is_absolute (_tmp55_);
			} else {
				_tmp48_ = FALSE;
			}
			if (_tmp48_) {
				const gchar* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				gchar* _tmp60_;
				_tmp56_ = vala_code_context_get_directory (context);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_code_context_get_output (context);
				_tmp59_ = _tmp58_;
				_tmp60_ = g_strdup_printf ("%s%c%s", _tmp57_, (gint) G_DIR_SEPARATOR, _tmp59_);
				_g_free0 (output);
				output = _tmp60_;
			}
			_tmp61_ = cmdline;
			_tmp62_ = output;
			_tmp63_ = g_shell_quote (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strconcat (" -o ", _tmp64_, NULL);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strconcat (_tmp61_, _tmp66_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp67_;
			_g_free0 (_tmp66_);
			_g_free0 (_tmp64_);
			_g_free0 (output);
		}
	}
	_tmp68_ = vala_code_context_get_source_files (context);
	source_files = _tmp68_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp69_;
		ValaList* _tmp70_;
		gint _file_size = 0;
		ValaList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _file_index = 0;
		_tmp69_ = source_files;
		_tmp70_ = _vala_iterable_ref0 (_tmp69_);
		_file_list = _tmp70_;
		_tmp71_ = _file_list;
		_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_file_size = _tmp73_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp77_;
			gint _tmp78_;
			gpointer _tmp79_;
			ValaSourceFile* _tmp80_;
			ValaSourceFileType _tmp81_;
			ValaSourceFileType _tmp82_;
			_tmp74_ = _file_index;
			_file_index = _tmp74_ + 1;
			_tmp75_ = _file_index;
			_tmp76_ = _file_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _file_list;
			_tmp78_ = _file_index;
			_tmp79_ = vala_list_get (_tmp77_, _tmp78_);
			file = (ValaSourceFile*) _tmp79_;
			_tmp80_ = file;
			_tmp81_ = vala_source_file_get_file_type (_tmp80_);
			_tmp82_ = _tmp81_;
			if (_tmp82_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp83_;
				ValaSourceFile* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				_tmp83_ = cmdline;
				_tmp84_ = file;
				_tmp85_ = vala_source_file_get_csource_filename (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = g_shell_quote (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = g_strconcat (" ", _tmp88_, NULL);
				_tmp90_ = _tmp89_;
				_tmp91_ = g_strconcat (_tmp83_, _tmp90_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp91_;
				_g_free0 (_tmp90_);
				_g_free0 (_tmp88_);
				_g_free0 (_tmp86_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp92_ = vala_code_context_get_c_source_files (context);
	c_source_files = _tmp92_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp93_;
		ValaList* _tmp94_;
		gint _file_size = 0;
		ValaList* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _file_index = 0;
		_tmp93_ = c_source_files;
		_tmp94_ = _vala_iterable_ref0 (_tmp93_);
		_file_list = _tmp94_;
		_tmp95_ = _file_list;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		_file_size = _tmp97_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp98_;
			gint _tmp99_;
			gint _tmp100_;
			gchar* file = NULL;
			ValaList* _tmp101_;
			gint _tmp102_;
			gpointer _tmp103_;
			const gchar* _tmp104_;
			const gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			_tmp98_ = _file_index;
			_file_index = _tmp98_ + 1;
			_tmp99_ = _file_index;
			_tmp100_ = _file_size;
			if (!(_tmp99_ < _tmp100_)) {
				break;
			}
			_tmp101_ = _file_list;
			_tmp102_ = _file_index;
			_tmp103_ = vala_list_get (_tmp101_, _tmp102_);
			file = (gchar*) _tmp103_;
			_tmp104_ = cmdline;
			_tmp105_ = file;
			_tmp106_ = g_shell_quote (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp108_ = g_strconcat (" ", _tmp107_, NULL);
			_tmp109_ = _tmp108_;
			_tmp110_ = g_strconcat (_tmp104_, _tmp109_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp110_;
			_g_free0 (_tmp109_);
			_g_free0 (_tmp107_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp111_ = cmdline;
	_tmp112_ = pkgflags;
	_tmp113_ = string_strip (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = g_strconcat (" ", _tmp114_, NULL);
	_tmp116_ = _tmp115_;
	_tmp117_ = g_strconcat (_tmp111_, _tmp116_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp117_;
	_g_free0 (_tmp116_);
	_g_free0 (_tmp114_);
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_options_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp118_;
			gchar* cc_option = NULL;
			_tmp118_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp118_;
			{
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_;
				_tmp119_ = cmdline;
				_tmp120_ = cc_option;
				_tmp121_ = g_shell_quote (_tmp120_);
				_tmp122_ = _tmp121_;
				_tmp123_ = g_strconcat (" ", _tmp122_, NULL);
				_tmp124_ = _tmp123_;
				_tmp125_ = g_strconcat (_tmp119_, _tmp124_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp125_;
				_g_free0 (_tmp124_);
				_g_free0 (_tmp122_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp126_ = vala_code_context_get_verbose_mode (context);
	_tmp127_ = _tmp126_;
	if (_tmp127_) {
		FILE* _tmp128_;
		const gchar* _tmp129_;
		_tmp128_ = stdout;
		_tmp129_ = cmdline;
		fprintf (_tmp128_, "%s\n", _tmp129_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp130_;
		gint _tmp131_ = 0;
		gint _tmp132_;
		_tmp130_ = cmdline;
		g_spawn_command_line_sync (_tmp130_, NULL, NULL, &_tmp131_, &_inner_error_);
		exit_status = _tmp131_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch5_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp132_ = exit_status;
		if (_tmp132_ != 0) {
			gint _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			_tmp133_ = exit_status;
			_tmp134_ = g_strdup_printf ("cc exited with status %d", _tmp133_);
			_tmp135_ = _tmp134_;
			vala_report_error (NULL, _tmp135_);
			_g_free0 (_tmp135_);
		}
	}
	goto __finally5;
	__catch5_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp136_;
		const gchar* _tmp137_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp136_ = e;
		_tmp137_ = _tmp136_->message;
		vala_report_error (NULL, _tmp137_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp138_;
		ValaList* _tmp139_;
		gint _file_size = 0;
		ValaList* _tmp140_;
		gint _tmp141_;
		gint _tmp142_;
		gint _file_index = 0;
		_tmp138_ = source_files;
		_tmp139_ = _vala_iterable_ref0 (_tmp138_);
		_file_list = _tmp139_;
		_tmp140_ = _file_list;
		_tmp141_ = vala_collection_get_size ((ValaCollection*) _tmp140_);
		_tmp142_ = _tmp141_;
		_file_size = _tmp142_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp146_;
			gint _tmp147_;
			gpointer _tmp148_;
			ValaSourceFile* _tmp149_;
			ValaSourceFileType _tmp150_;
			ValaSourceFileType _tmp151_;
			_tmp143_ = _file_index;
			_file_index = _tmp143_ + 1;
			_tmp144_ = _file_index;
			_tmp145_ = _file_size;
			if (!(_tmp144_ < _tmp145_)) {
				break;
			}
			_tmp146_ = _file_list;
			_tmp147_ = _file_index;
			_tmp148_ = vala_list_get (_tmp146_, _tmp147_);
			file = (ValaSourceFile*) _tmp148_;
			_tmp149_ = file;
			_tmp150_ = vala_source_file_get_file_type (_tmp149_);
			_tmp151_ = _tmp150_;
			if (_tmp151_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gboolean _tmp152_;
				gboolean _tmp153_;
				_tmp152_ = vala_code_context_get_save_csources (context);
				_tmp153_ = _tmp152_;
				if (!_tmp153_) {
					ValaSourceFile* _tmp154_;
					gchar* _tmp155_;
					gchar* _tmp156_;
					_tmp154_ = file;
					_tmp155_ = vala_source_file_get_csource_filename (_tmp154_);
					_tmp156_ = _tmp155_;
					g_unlink (_tmp156_);
					_g_free0 (_tmp156_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void
vala_value_ccode_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_ccode_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_ccode_compiler_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_ccode_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_ccode_compiler_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_ccode_compiler_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_ccode_compiler (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_ccode_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_ccode_compiler (GValue* value,
                               gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void
vala_value_take_ccode_compiler (GValue* value,
                                gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void
vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass)
{
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}


static void
vala_ccode_compiler_instance_init (ValaCCodeCompiler * self)
{
	self->ref_count = 1;
}


static void
vala_ccode_compiler_finalize (ValaCCodeCompiler * obj)
{
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}


/**
 * Interface to the C compiler.
 */
GType
vala_ccode_compiler_get_type (void)
{
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer
vala_ccode_compiler_ref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_ccode_compiler_unref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



