/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gboolean vala_compiler_abi_stability;
static gboolean vala_compiler_abi_stability = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args;
static gchar* vala_compiler_run_args = NULL;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_parse_color (const gchar* option_name,
                                           const gchar* val,
                                           void* data,
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gint vala_compiler_run_source (gchar** args,
                               int args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_,
                  GPid pid,
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid,
                                     gint status,
                                     gpointer self);
static gint vala_compiler_main (gchar** args,
                         int args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[60] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executeable", NULL}, {"abi-stability", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_abi_stability, "Enable support for ABI stability", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gboolean
vala_compiler_option_parse_color (const gchar* option_name,
                                  const gchar* val,
                                  void* data,
                                  GError** error)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error_ = _tmp3_;
				if (_inner_error_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gint
vala_compiler_quit (ValaCompiler* self)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		_tmp12_ = vala_compiler_fatal_warnings;
		if (!_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp13_;
			ValaReport* _tmp14_;
			ValaReport* _tmp15_;
			_tmp13_ = self->priv->context;
			_tmp14_ = vala_code_context_get_report (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = vala_report_get_warnings (_tmp15_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp16_;
		_tmp16_ = vala_compiler_quiet_mode;
		if (!_tmp16_) {
			FILE* _tmp17_;
			ValaCodeContext* _tmp18_;
			ValaReport* _tmp19_;
			ValaReport* _tmp20_;
			_tmp17_ = stdout;
			_tmp18_ = self->priv->context;
			_tmp19_ = vala_code_context_get_report (_tmp18_);
			_tmp20_ = _tmp19_;
			fprintf (_tmp17_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp20_));
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp21_;
		_tmp21_ = vala_compiler_quiet_mode;
		if (!_tmp21_) {
			FILE* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			ValaCodeContext* _tmp26_;
			ValaReport* _tmp27_;
			ValaReport* _tmp28_;
			_tmp22_ = stdout;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->context;
			_tmp27_ = vala_code_context_get_report (_tmp26_);
			_tmp28_ = _tmp27_;
			fprintf (_tmp22_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp25_), vala_report_get_warnings (_tmp28_));
		}
		result = 1;
		return result;
	}
}


static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint
vala_compiler_run (ValaCompiler* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	ValaReportColored _tmp3_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	ValaCodeContext* _tmp30_;
	gboolean _tmp31_;
	ValaCodeContext* _tmp32_;
	gboolean _tmp33_;
	ValaCodeContext* _tmp34_;
	gboolean _tmp35_;
	ValaCodeContext* _tmp36_;
	gboolean _tmp37_;
	ValaCodeContext* _tmp38_;
	gboolean _tmp39_;
	ValaCodeContext* _tmp40_;
	gboolean _tmp41_;
	ValaCodeContext* _tmp42_;
	gboolean _tmp43_;
	ValaCodeContext* _tmp44_;
	gboolean _tmp45_;
	ValaCodeContext* _tmp46_;
	ValaReport* _tmp47_;
	ValaReport* _tmp48_;
	gboolean _tmp49_;
	ValaCodeContext* _tmp50_;
	ValaReport* _tmp51_;
	ValaReport* _tmp52_;
	gboolean _tmp53_;
	ValaCodeContext* _tmp54_;
	gboolean _tmp55_;
	ValaCodeContext* _tmp56_;
	gboolean _tmp57_;
	ValaCodeContext* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_;
	ValaCodeContext* _tmp63_;
	gboolean _tmp64_;
	ValaCodeContext* _tmp65_;
	gboolean _tmp66_;
	ValaCodeContext* _tmp67_;
	const gchar* _tmp68_;
	gboolean _tmp69_ = FALSE;
	const gchar* _tmp70_;
	ValaCodeContext* _tmp72_;
	gboolean _tmp73_;
	ValaCodeContext* _tmp74_;
	const gchar* _tmp75_;
	ValaCodeContext* _tmp76_;
	const gchar* _tmp77_;
	ValaCodeContext* _tmp78_;
	const gchar* _tmp79_;
	ValaCodeContext* _tmp80_;
	const gchar* _tmp81_;
	gboolean _tmp82_ = FALSE;
	const gchar* _tmp83_;
	const gchar* _tmp85_;
	const gchar* _tmp93_;
	ValaCodeContext* _tmp102_;
	gchar** _tmp103_;
	gint _tmp103__length1;
	ValaCodeContext* _tmp104_;
	gboolean _tmp105_;
	ValaCodeContext* _tmp106_;
	gchar** _tmp107_;
	gint _tmp107__length1;
	ValaCodeContext* _tmp108_;
	gchar** _tmp109_;
	gint _tmp109__length1;
	ValaCodeContext* _tmp110_;
	gboolean _tmp111_;
	ValaCodeContext* _tmp112_;
	gboolean _tmp113_;
	ValaCodeContext* _tmp114_;
	gboolean _tmp115_;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp117_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	const gchar* _tmp121_;
	gboolean _tmp129_;
	const gchar* _tmp130_;
	ValaCodeContext* _tmp131_;
	gboolean _tmp132_;
	ValaCodeContext* _tmp133_;
	const gchar* _tmp134_;
	ValaCodeContext* _tmp135_;
	gboolean _tmp136_;
	gchar** _tmp137_;
	gint _tmp137__length1;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp149_ = FALSE;
	const gchar* _tmp150_;
	ValaCodeContext* _tmp152_;
	gint _tmp153_;
	ValaCodeContext* _tmp154_;
	gint _tmp155_;
	ValaCodeContext* _tmp156_;
	gint _tmp157_;
	gint _tmp158_;
	gboolean _tmp167_;
	gchar** _tmp170_;
	gint _tmp170__length1;
	gchar** _tmp175_;
	gint _tmp175__length1;
	ValaCodeContext* _tmp186_;
	gchar** _tmp187_;
	gint _tmp187__length1;
	ValaCodeContext* _tmp188_;
	gchar** _tmp189_;
	gint _tmp189__length1;
	gboolean _tmp190_ = FALSE;
	ValaCodeContext* _tmp191_;
	ValaReport* _tmp192_;
	ValaReport* _tmp193_;
	ValaCodeContext* _tmp199_;
	ValaGDBusServerModule* _tmp200_;
	ValaGDBusServerModule* _tmp201_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp202_;
	gint _tmp202__length1;
	gboolean _tmp209_ = FALSE;
	gboolean _tmp210_;
	gboolean _tmp214_ = FALSE;
	ValaCodeContext* _tmp215_;
	ValaReport* _tmp216_;
	ValaReport* _tmp217_;
	ValaParser* parser = NULL;
	ValaParser* _tmp223_;
	ValaParser* _tmp224_;
	ValaCodeContext* _tmp225_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp226_;
	ValaGenieParser* _tmp227_;
	ValaCodeContext* _tmp228_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp229_;
	ValaGirParser* _tmp230_;
	ValaCodeContext* _tmp231_;
	gboolean _tmp232_ = FALSE;
	ValaCodeContext* _tmp233_;
	ValaReport* _tmp234_;
	ValaReport* _tmp235_;
	const gchar* _tmp241_;
	ValaCodeContext* _tmp246_;
	gboolean _tmp247_ = FALSE;
	ValaCodeContext* _tmp248_;
	ValaReport* _tmp249_;
	ValaReport* _tmp250_;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp257_ = FALSE;
	gboolean _tmp258_;
	const gchar* _tmp266_;
	gboolean _tmp271_ = FALSE;
	ValaCodeContext* _tmp272_;
	ValaReport* _tmp273_;
	ValaReport* _tmp274_;
	ValaCodeContext* _tmp280_;
	ValaCodeGenerator* _tmp281_;
	ValaCodeGenerator* _tmp282_;
	ValaCodeContext* _tmp283_;
	gboolean _tmp284_ = FALSE;
	ValaCodeContext* _tmp285_;
	ValaReport* _tmp286_;
	ValaReport* _tmp287_;
	gboolean _tmp293_ = FALSE;
	const gchar* _tmp294_;
	const gchar* _tmp298_;
	const gchar* _tmp346_;
	const gchar* _tmp359_;
	const gchar* _tmp380_;
	gboolean _tmp383_ = FALSE;
	ValaCodeContext* _tmp384_;
	ValaReport* _tmp385_;
	ValaReport* _tmp386_;
	gboolean _tmp392_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_colored_output;
	if (_tmp2_) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp3_ = vala_compiler_colored_output;
	if (_tmp3_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp4_;
		_tmp5_ = env_colors;
		if (_tmp5_ != NULL) {
			ValaCodeContext* _tmp6_;
			ValaReport* _tmp7_;
			ValaReport* _tmp8_;
			const gchar* _tmp9_;
			ValaReportColored _tmp10_;
			_tmp6_ = self->priv->context;
			_tmp7_ = vala_code_context_get_report (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = env_colors;
			_tmp10_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp8_, _tmp9_, _tmp10_);
		} else {
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			ValaReportColored _tmp14_;
			_tmp11_ = self->priv->context;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp13_, VALA_COMPILER_DEFAULT_COLORS, _tmp14_);
		}
	}
	_tmp17_ = vala_compiler_ccode_only;
	if (!_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = vala_compiler_compile_only;
		_tmp16_ = !_tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp19_;
		_tmp19_ = vala_compiler_output;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		_tmp20_ = vala_compiler_sources;
		_tmp20__length1 = _vala_array_length (vala_compiler_sources);
		_tmp21_ = _tmp20_[0];
		if (string_last_index_of_char (_tmp21_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gint _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp22_ = vala_compiler_sources;
			_tmp22__length1 = _vala_array_length (vala_compiler_sources);
			_tmp23_ = _tmp22_[0];
			dot = string_last_index_of_char (_tmp23_, (gunichar) '.', 0);
			_tmp24_ = vala_compiler_sources;
			_tmp24__length1 = _vala_array_length (vala_compiler_sources);
			_tmp25_ = _tmp24_[0];
			_tmp26_ = dot;
			_tmp27_ = string_substring (_tmp25_, (glong) 0, (glong) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_path_get_basename (_tmp28_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp29_;
			_g_free0 (_tmp28_);
		}
	}
	_tmp30_ = self->priv->context;
	_tmp31_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp30_, !_tmp31_);
	_tmp32_ = self->priv->context;
	_tmp33_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp32_, _tmp33_);
	_tmp34_ = self->priv->context;
	_tmp35_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->context;
	_tmp37_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp36_, !_tmp37_);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->context;
	_tmp41_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->context;
	_tmp43_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->context;
	_tmp45_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->context;
	_tmp47_ = vala_code_context_get_report (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp48_, !_tmp49_);
	_tmp50_ = self->priv->context;
	_tmp51_ = vala_code_context_get_report (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp52_, !_tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp56_, !_tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp58_, _tmp59_);
	_tmp61_ = vala_compiler_ccode_only;
	if (_tmp61_) {
		gchar** _tmp62_;
		gint _tmp62__length1;
		_tmp62_ = vala_compiler_cc_options;
		_tmp62__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp60_ = _tmp62_ != NULL;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_abi_stability;
	vala_code_context_set_abi_stability (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->context;
	_tmp66_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->context;
	_tmp68_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp67_, _tmp68_);
	_tmp70_ = vala_compiler_header_filename;
	if (_tmp70_ == NULL) {
		gboolean _tmp71_;
		_tmp71_ = vala_compiler_use_header;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp72_ = self->priv->context;
	_tmp73_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp74_, _tmp75_);
	_tmp76_ = self->priv->context;
	_tmp77_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->context;
	_tmp79_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp78_, _tmp79_);
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_compiler_output;
	vala_code_context_set_output (_tmp80_, _tmp81_);
	_tmp83_ = vala_compiler_output;
	if (_tmp83_ != NULL) {
		gboolean _tmp84_;
		_tmp84_ = vala_compiler_ccode_only;
		_tmp82_ = _tmp84_;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp85_ = vala_compiler_basedir;
	if (_tmp85_ == NULL) {
		ValaCodeContext* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		_tmp86_ = self->priv->context;
		_tmp87_ = vala_code_context_realpath (".");
		_tmp88_ = _tmp87_;
		vala_code_context_set_basedir (_tmp86_, _tmp88_);
		_g_free0 (_tmp88_);
	} else {
		ValaCodeContext* _tmp89_;
		const gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		_tmp89_ = self->priv->context;
		_tmp90_ = vala_compiler_basedir;
		_tmp91_ = vala_code_context_realpath (_tmp90_);
		_tmp92_ = _tmp91_;
		vala_code_context_set_basedir (_tmp89_, _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp93_ = vala_compiler_directory;
	if (_tmp93_ != NULL) {
		ValaCodeContext* _tmp94_;
		const gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		_tmp94_ = self->priv->context;
		_tmp95_ = vala_compiler_directory;
		_tmp96_ = vala_code_context_realpath (_tmp95_);
		_tmp97_ = _tmp96_;
		vala_code_context_set_directory (_tmp94_, _tmp97_);
		_g_free0 (_tmp97_);
	} else {
		ValaCodeContext* _tmp98_;
		ValaCodeContext* _tmp99_;
		const gchar* _tmp100_;
		const gchar* _tmp101_;
		_tmp98_ = self->priv->context;
		_tmp99_ = self->priv->context;
		_tmp100_ = vala_code_context_get_basedir (_tmp99_);
		_tmp101_ = _tmp100_;
		vala_code_context_set_directory (_tmp98_, _tmp101_);
	}
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_directories;
	_tmp103__length1 = _vala_array_length (vala_compiler_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp102_, _tmp103_, _tmp103__length1);
	_tmp104_ = self->priv->context;
	_tmp105_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp104_, _tmp105_);
	_tmp106_ = self->priv->context;
	_tmp107_ = vala_compiler_gir_directories;
	_tmp107__length1 = _vala_array_length (vala_compiler_gir_directories);
	vala_code_context_set_gir_directories (_tmp106_, _tmp107_, _tmp107__length1);
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_compiler_metadata_directories;
	_tmp109__length1 = _vala_array_length (vala_compiler_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp108_, _tmp109_, _tmp109__length1);
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp112_, _tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp114_, _tmp115_);
	_tmp117_ = vala_compiler_ccode_only;
	if (_tmp117_) {
		gboolean _tmp118_;
		_tmp118_ = vala_compiler_save_temps;
		_tmp116_ = _tmp118_;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp121_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp121_, "gobject-2.0") == 0) {
		_tmp120_ = TRUE;
	} else {
		const gchar* _tmp122_;
		_tmp122_ = vala_compiler_profile;
		_tmp120_ = g_strcmp0 (_tmp122_, "gobject") == 0;
	}
	if (_tmp120_) {
		_tmp119_ = TRUE;
	} else {
		const gchar* _tmp123_;
		_tmp123_ = vala_compiler_profile;
		_tmp119_ = _tmp123_ == NULL;
	}
	if (_tmp119_) {
		ValaCodeContext* _tmp124_;
		ValaCodeContext* _tmp125_;
		_tmp124_ = self->priv->context;
		vala_code_context_set_profile (_tmp124_, VALA_PROFILE_GOBJECT);
		_tmp125_ = self->priv->context;
		vala_code_context_add_define (_tmp125_, "GOBJECT");
	} else {
		const gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		_tmp126_ = vala_compiler_profile;
		_tmp127_ = g_strdup_printf ("Unknown profile %s", _tmp126_);
		_tmp128_ = _tmp127_;
		vala_report_error (NULL, _tmp128_);
		_g_free0 (_tmp128_);
	}
	_tmp129_ = vala_compiler_nostdpkg;
	_tmp130_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp129_ | (_tmp130_ != NULL);
	_tmp131_ = self->priv->context;
	_tmp132_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp131_, _tmp132_);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp133_, _tmp134_);
	_tmp135_ = self->priv->context;
	_tmp136_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp135_, _tmp136_);
	_tmp137_ = vala_compiler_defines;
	_tmp137__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp137_ != NULL) {
		gchar** _tmp138_;
		gint _tmp138__length1;
		_tmp138_ = vala_compiler_defines;
		_tmp138__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp138_;
			define_collection_length1 = _tmp138__length1;
			for (define_it = 0; define_it < _tmp138__length1; define_it = define_it + 1) {
				gchar* _tmp139_;
				gchar* define = NULL;
				_tmp139_ = g_strdup (define_collection[define_it]);
				define = _tmp139_;
				{
					ValaCodeContext* _tmp140_;
					const gchar* _tmp141_;
					_tmp140_ = self->priv->context;
					_tmp141_ = define;
					vala_code_context_add_define (_tmp140_, _tmp141_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp142_ = FALSE;
			_tmp142_ = TRUE;
			while (TRUE) {
				gint _tmp144_;
				ValaCodeContext* _tmp145_;
				gint _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				if (!_tmp142_) {
					gint _tmp143_;
					_tmp143_ = i;
					i = _tmp143_ + 2;
				}
				_tmp142_ = FALSE;
				_tmp144_ = i;
				if (!(_tmp144_ <= 40)) {
					break;
				}
				_tmp145_ = self->priv->context;
				_tmp146_ = i;
				_tmp147_ = g_strdup_printf ("VALA_0_%d", _tmp146_);
				_tmp148_ = _tmp147_;
				vala_code_context_add_define (_tmp145_, _tmp148_);
				_g_free0 (_tmp148_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 40;
	_tmp150_ = vala_compiler_target_glib;
	if (_tmp150_ != NULL) {
		const gchar* _tmp151_;
		_tmp151_ = vala_compiler_target_glib;
		_tmp149_ = sscanf (_tmp151_, "%d.%d", &glib_major, &glib_minor) != 2;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp152_ = self->priv->context;
	_tmp153_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp152_, _tmp153_);
	_tmp154_ = self->priv->context;
	_tmp155_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp154_, _tmp155_);
	_tmp156_ = self->priv->context;
	_tmp157_ = vala_code_context_get_target_glib_major (_tmp156_);
	_tmp158_ = _tmp157_;
	if (_tmp158_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp159_ = FALSE;
			_tmp159_ = TRUE;
			while (TRUE) {
				gint _tmp161_;
				gint _tmp162_;
				ValaCodeContext* _tmp163_;
				gint _tmp164_;
				gchar* _tmp165_;
				gchar* _tmp166_;
				if (!_tmp159_) {
					gint _tmp160_;
					_tmp160_ = i;
					i = _tmp160_ + 2;
				}
				_tmp159_ = FALSE;
				_tmp161_ = i;
				_tmp162_ = glib_minor;
				if (!(_tmp161_ <= _tmp162_)) {
					break;
				}
				_tmp163_ = self->priv->context;
				_tmp164_ = i;
				_tmp165_ = g_strdup_printf ("GLIB_2_%d", _tmp164_);
				_tmp166_ = _tmp165_;
				vala_code_context_add_define (_tmp163_, _tmp166_);
				_g_free0 (_tmp166_);
			}
		}
	}
	_tmp167_ = vala_compiler_nostdpkg;
	if (!_tmp167_) {
		ValaCodeContext* _tmp168_;
		ValaCodeContext* _tmp169_;
		_tmp168_ = self->priv->context;
		vala_code_context_add_external_package (_tmp168_, "glib-2.0");
		_tmp169_ = self->priv->context;
		vala_code_context_add_external_package (_tmp169_, "gobject-2.0");
	}
	_tmp170_ = vala_compiler_packages;
	_tmp170__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp170_ != NULL) {
		gchar** _tmp171_;
		gint _tmp171__length1;
		_tmp171_ = vala_compiler_packages;
		_tmp171__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp171_;
			package_collection_length1 = _tmp171__length1;
			for (package_it = 0; package_it < _tmp171__length1; package_it = package_it + 1) {
				gchar* _tmp172_;
				gchar* package = NULL;
				_tmp172_ = g_strdup (package_collection[package_it]);
				package = _tmp172_;
				{
					ValaCodeContext* _tmp173_;
					const gchar* _tmp174_;
					_tmp173_ = self->priv->context;
					_tmp174_ = package;
					vala_code_context_add_external_package (_tmp173_, _tmp174_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp175_ = vala_compiler_fast_vapis;
	_tmp175__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp175_ != NULL) {
		gchar** _tmp176_;
		gint _tmp176__length1;
		ValaCodeContext* _tmp185_;
		_tmp176_ = vala_compiler_fast_vapis;
		_tmp176__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp176_;
			vapi_collection_length1 = _tmp176__length1;
			for (vapi_it = 0; vapi_it < _tmp176__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp177_;
				gchar* vapi = NULL;
				_tmp177_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp177_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp178_;
					gchar* _tmp179_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp180_;
					const gchar* _tmp181_;
					ValaSourceFile* _tmp182_;
					ValaCodeContext* _tmp183_;
					ValaSourceFile* _tmp184_;
					_tmp178_ = vapi;
					_tmp179_ = vala_code_context_realpath (_tmp178_);
					rpath = _tmp179_;
					_tmp180_ = self->priv->context;
					_tmp181_ = rpath;
					_tmp182_ = vala_source_file_new (_tmp180_, VALA_SOURCE_FILE_TYPE_FAST, _tmp181_, NULL, FALSE);
					source_file = _tmp182_;
					_tmp183_ = self->priv->context;
					_tmp184_ = source_file;
					vala_code_context_add_source_file (_tmp183_, _tmp184_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp185_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp185_, TRUE);
	}
	_tmp186_ = self->priv->context;
	_tmp187_ = vala_compiler_gresources;
	_tmp187__length1 = _vala_array_length (vala_compiler_gresources);
	vala_code_context_set_gresources (_tmp186_, _tmp187_, _tmp187__length1);
	_tmp188_ = self->priv->context;
	_tmp189_ = vala_compiler_gresources_directories;
	_tmp189__length1 = _vala_array_length (vala_compiler_gresources_directories);
	vala_code_context_set_gresources_directories (_tmp188_, _tmp189_, _tmp189__length1);
	_tmp191_ = self->priv->context;
	_tmp192_ = vala_code_context_get_report (_tmp191_);
	_tmp193_ = _tmp192_;
	if (vala_report_get_errors (_tmp193_) > 0) {
		_tmp190_ = TRUE;
	} else {
		gboolean _tmp194_ = FALSE;
		gboolean _tmp195_;
		_tmp195_ = vala_compiler_fatal_warnings;
		if (_tmp195_) {
			ValaCodeContext* _tmp196_;
			ValaReport* _tmp197_;
			ValaReport* _tmp198_;
			_tmp196_ = self->priv->context;
			_tmp197_ = vala_code_context_get_report (_tmp196_);
			_tmp198_ = _tmp197_;
			_tmp194_ = vala_report_get_warnings (_tmp198_) > 0;
		} else {
			_tmp194_ = FALSE;
		}
		_tmp190_ = _tmp194_;
	}
	if (_tmp190_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp199_ = self->priv->context;
	_tmp200_ = vala_gd_bus_server_module_new ();
	_tmp201_ = _tmp200_;
	vala_code_context_set_codegen (_tmp199_, (ValaCodeGenerator*) _tmp201_);
	_vala_code_visitor_unref0 (_tmp201_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp202_ = vala_compiler_sources;
	_tmp202__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp202_;
		source_collection_length1 = _tmp202__length1;
		for (source_it = 0; source_it < _tmp202__length1; source_it = source_it + 1) {
			gchar* _tmp203_;
			gchar* source = NULL;
			_tmp203_ = g_strdup (source_collection[source_it]);
			source = _tmp203_;
			{
				ValaCodeContext* _tmp204_;
				const gchar* _tmp205_;
				gboolean _tmp206_;
				_tmp204_ = self->priv->context;
				_tmp205_ = source;
				_tmp206_ = vala_compiler_run_output;
				if (vala_code_context_add_source_filename (_tmp204_, _tmp205_, _tmp206_, TRUE)) {
					const gchar* _tmp207_;
					_tmp207_ = source;
					if (g_str_has_suffix (_tmp207_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp208_;
						_tmp208_ = source;
						if (g_str_has_suffix (_tmp208_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp210_ = vala_compiler_ccode_only;
	if (_tmp210_) {
		gboolean _tmp211_ = FALSE;
		gboolean _tmp212_;
		_tmp212_ = has_c_files;
		if (_tmp212_) {
			_tmp211_ = TRUE;
		} else {
			gboolean _tmp213_;
			_tmp213_ = has_h_files;
			_tmp211_ = _tmp213_;
		}
		_tmp209_ = _tmp211_;
	} else {
		_tmp209_ = FALSE;
	}
	if (_tmp209_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp215_ = self->priv->context;
	_tmp216_ = vala_code_context_get_report (_tmp215_);
	_tmp217_ = _tmp216_;
	if (vala_report_get_errors (_tmp217_) > 0) {
		_tmp214_ = TRUE;
	} else {
		gboolean _tmp218_ = FALSE;
		gboolean _tmp219_;
		_tmp219_ = vala_compiler_fatal_warnings;
		if (_tmp219_) {
			ValaCodeContext* _tmp220_;
			ValaReport* _tmp221_;
			ValaReport* _tmp222_;
			_tmp220_ = self->priv->context;
			_tmp221_ = vala_code_context_get_report (_tmp220_);
			_tmp222_ = _tmp221_;
			_tmp218_ = vala_report_get_warnings (_tmp222_) > 0;
		} else {
			_tmp218_ = FALSE;
		}
		_tmp214_ = _tmp218_;
	}
	if (_tmp214_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp223_ = vala_parser_new ();
	parser = _tmp223_;
	_tmp224_ = parser;
	_tmp225_ = self->priv->context;
	vala_parser_parse (_tmp224_, _tmp225_);
	_tmp226_ = vala_genie_parser_new ();
	genie_parser = _tmp226_;
	_tmp227_ = genie_parser;
	_tmp228_ = self->priv->context;
	vala_genie_parser_parse (_tmp227_, _tmp228_);
	_tmp229_ = vala_gir_parser_new ();
	gir_parser = _tmp229_;
	_tmp230_ = gir_parser;
	_tmp231_ = self->priv->context;
	vala_gir_parser_parse (_tmp230_, _tmp231_);
	_tmp233_ = self->priv->context;
	_tmp234_ = vala_code_context_get_report (_tmp233_);
	_tmp235_ = _tmp234_;
	if (vala_report_get_errors (_tmp235_) > 0) {
		_tmp232_ = TRUE;
	} else {
		gboolean _tmp236_ = FALSE;
		gboolean _tmp237_;
		_tmp237_ = vala_compiler_fatal_warnings;
		if (_tmp237_) {
			ValaCodeContext* _tmp238_;
			ValaReport* _tmp239_;
			ValaReport* _tmp240_;
			_tmp238_ = self->priv->context;
			_tmp239_ = vala_code_context_get_report (_tmp238_);
			_tmp240_ = _tmp239_;
			_tmp236_ = vala_report_get_warnings (_tmp240_) > 0;
		} else {
			_tmp236_ = FALSE;
		}
		_tmp232_ = _tmp236_;
	}
	if (_tmp232_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp241_ = vala_compiler_fast_vapi_filename;
	if (_tmp241_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp242_;
		ValaCodeWriter* _tmp243_;
		ValaCodeContext* _tmp244_;
		const gchar* _tmp245_;
		_tmp242_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp242_;
		_tmp243_ = interface_writer;
		_tmp244_ = self->priv->context;
		_tmp245_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp243_, _tmp244_, _tmp245_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp246_ = self->priv->context;
	vala_code_context_check (_tmp246_);
	_tmp248_ = self->priv->context;
	_tmp249_ = vala_code_context_get_report (_tmp248_);
	_tmp250_ = _tmp249_;
	if (vala_report_get_errors (_tmp250_) > 0) {
		_tmp247_ = TRUE;
	} else {
		gboolean _tmp251_ = FALSE;
		gboolean _tmp252_;
		_tmp252_ = vala_compiler_fatal_warnings;
		if (_tmp252_) {
			ValaCodeContext* _tmp253_;
			ValaReport* _tmp254_;
			ValaReport* _tmp255_;
			_tmp253_ = self->priv->context;
			_tmp254_ = vala_code_context_get_report (_tmp253_);
			_tmp255_ = _tmp254_;
			_tmp251_ = vala_report_get_warnings (_tmp255_) > 0;
		} else {
			_tmp251_ = FALSE;
		}
		_tmp247_ = _tmp251_;
	}
	if (_tmp247_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp258_ = vala_compiler_ccode_only;
	if (!_tmp258_) {
		gboolean _tmp259_;
		_tmp259_ = vala_compiler_compile_only;
		_tmp257_ = !_tmp259_;
	} else {
		_tmp257_ = FALSE;
	}
	if (_tmp257_) {
		const gchar* _tmp260_;
		_tmp260_ = vala_compiler_library;
		_tmp256_ = _tmp260_ == NULL;
	} else {
		_tmp256_ = FALSE;
	}
	if (_tmp256_) {
		gboolean _tmp261_ = FALSE;
		gboolean _tmp262_;
		_tmp262_ = has_c_files;
		if (!_tmp262_) {
			ValaCodeContext* _tmp263_;
			ValaMethod* _tmp264_;
			ValaMethod* _tmp265_;
			_tmp263_ = self->priv->context;
			_tmp264_ = vala_code_context_get_entry_point (_tmp263_);
			_tmp265_ = _tmp264_;
			_tmp261_ = _tmp265_ == NULL;
		} else {
			_tmp261_ = FALSE;
		}
		if (_tmp261_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp266_ = vala_compiler_dump_tree;
	if (_tmp266_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp267_;
		ValaCodeWriter* _tmp268_;
		ValaCodeContext* _tmp269_;
		const gchar* _tmp270_;
		_tmp267_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp267_;
		_tmp268_ = code_writer;
		_tmp269_ = self->priv->context;
		_tmp270_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp268_, _tmp269_, _tmp270_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp272_ = self->priv->context;
	_tmp273_ = vala_code_context_get_report (_tmp272_);
	_tmp274_ = _tmp273_;
	if (vala_report_get_errors (_tmp274_) > 0) {
		_tmp271_ = TRUE;
	} else {
		gboolean _tmp275_ = FALSE;
		gboolean _tmp276_;
		_tmp276_ = vala_compiler_fatal_warnings;
		if (_tmp276_) {
			ValaCodeContext* _tmp277_;
			ValaReport* _tmp278_;
			ValaReport* _tmp279_;
			_tmp277_ = self->priv->context;
			_tmp278_ = vala_code_context_get_report (_tmp277_);
			_tmp279_ = _tmp278_;
			_tmp275_ = vala_report_get_warnings (_tmp279_) > 0;
		} else {
			_tmp275_ = FALSE;
		}
		_tmp271_ = _tmp275_;
	}
	if (_tmp271_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp280_ = self->priv->context;
	_tmp281_ = vala_code_context_get_codegen (_tmp280_);
	_tmp282_ = _tmp281_;
	_tmp283_ = self->priv->context;
	vala_code_generator_emit (_tmp282_, _tmp283_);
	_tmp285_ = self->priv->context;
	_tmp286_ = vala_code_context_get_report (_tmp285_);
	_tmp287_ = _tmp286_;
	if (vala_report_get_errors (_tmp287_) > 0) {
		_tmp284_ = TRUE;
	} else {
		gboolean _tmp288_ = FALSE;
		gboolean _tmp289_;
		_tmp289_ = vala_compiler_fatal_warnings;
		if (_tmp289_) {
			ValaCodeContext* _tmp290_;
			ValaReport* _tmp291_;
			ValaReport* _tmp292_;
			_tmp290_ = self->priv->context;
			_tmp291_ = vala_code_context_get_report (_tmp290_);
			_tmp292_ = _tmp291_;
			_tmp288_ = vala_report_get_warnings (_tmp292_) > 0;
		} else {
			_tmp288_ = FALSE;
		}
		_tmp284_ = _tmp288_;
	}
	if (_tmp284_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp294_ = vala_compiler_vapi_filename;
	if (_tmp294_ == NULL) {
		const gchar* _tmp295_;
		_tmp295_ = vala_compiler_library;
		_tmp293_ = _tmp295_ != NULL;
	} else {
		_tmp293_ = FALSE;
	}
	if (_tmp293_) {
		const gchar* _tmp296_;
		gchar* _tmp297_;
		_tmp296_ = vala_compiler_library;
		_tmp297_ = g_strdup_printf ("%s.vapi", _tmp296_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp297_;
	}
	_tmp298_ = vala_compiler_library;
	if (_tmp298_ != NULL) {
		const gchar* _tmp299_;
		_tmp299_ = vala_compiler_gir;
		if (_tmp299_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp300_;
			gchar* _tmp301_;
			glong gir_len = 0L;
			const gchar* _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			gint last_hyphen = 0;
			const gchar* _tmp305_;
			gboolean _tmp306_ = FALSE;
			gint _tmp307_;
			_tmp300_ = vala_compiler_gir;
			_tmp301_ = g_path_get_basename (_tmp300_);
			gir_base = _tmp301_;
			_tmp302_ = gir_base;
			_tmp303_ = strlen (_tmp302_);
			_tmp304_ = _tmp303_;
			gir_len = (glong) _tmp304_;
			_tmp305_ = gir_base;
			last_hyphen = string_last_index_of_char (_tmp305_, (gunichar) '-', 0);
			_tmp307_ = last_hyphen;
			if (_tmp307_ == -1) {
				_tmp306_ = TRUE;
			} else {
				const gchar* _tmp308_;
				_tmp308_ = gir_base;
				_tmp306_ = !g_str_has_suffix (_tmp308_, ".gir");
			}
			if (_tmp306_) {
				const gchar* _tmp309_;
				gchar* _tmp310_;
				gchar* _tmp311_;
				_tmp309_ = vala_compiler_gir;
				_tmp310_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp309_);
				_tmp311_ = _tmp310_;
				vala_report_error (NULL, _tmp311_);
				_g_free0 (_tmp311_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp312_;
				gint _tmp313_;
				gchar* _tmp314_;
				gchar* gir_version = NULL;
				const gchar* _tmp315_;
				gint _tmp316_;
				glong _tmp317_;
				gint _tmp318_;
				gchar* _tmp319_;
				const gchar* _tmp320_;
				gboolean _tmp321_ = FALSE;
				gboolean _tmp322_ = FALSE;
				gboolean _tmp323_ = FALSE;
				const gchar* _tmp324_;
				_tmp312_ = gir_base;
				_tmp313_ = last_hyphen;
				_tmp314_ = string_substring (_tmp312_, (glong) 0, (glong) _tmp313_);
				gir_namespace = _tmp314_;
				_tmp315_ = gir_base;
				_tmp316_ = last_hyphen;
				_tmp317_ = gir_len;
				_tmp318_ = last_hyphen;
				_tmp319_ = string_substring (_tmp315_, (glong) (_tmp316_ + 1), (_tmp317_ - _tmp318_) - 5);
				gir_version = _tmp319_;
				_tmp320_ = gir_version;
				g_strcanon (_tmp320_, "0123456789.", '?');
				_tmp324_ = gir_namespace;
				if (g_strcmp0 (_tmp324_, "") == 0) {
					_tmp323_ = TRUE;
				} else {
					const gchar* _tmp325_;
					_tmp325_ = gir_version;
					_tmp323_ = g_strcmp0 (_tmp325_, "") == 0;
				}
				if (_tmp323_) {
					_tmp322_ = TRUE;
				} else {
					const gchar* _tmp326_;
					_tmp326_ = gir_version;
					_tmp322_ = !g_ascii_isdigit (string_get (_tmp326_, (glong) 0));
				}
				if (_tmp322_) {
					_tmp321_ = TRUE;
				} else {
					const gchar* _tmp327_;
					_tmp327_ = gir_version;
					_tmp321_ = string_contains (_tmp327_, "?");
				}
				if (_tmp321_) {
					const gchar* _tmp328_;
					gchar* _tmp329_;
					gchar* _tmp330_;
					_tmp328_ = vala_compiler_gir;
					_tmp329_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp328_);
					_tmp330_ = _tmp329_;
					vala_report_error (NULL, _tmp330_);
					_g_free0 (_tmp330_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp331_;
					gchar* gir_directory = NULL;
					gchar* _tmp332_;
					const gchar* _tmp333_;
					ValaGIRWriter* _tmp338_;
					ValaCodeContext* _tmp339_;
					const gchar* _tmp340_;
					const gchar* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					const gchar* _tmp344_;
					const gchar* _tmp345_;
					_tmp331_ = vala_gir_writer_new ();
					gir_writer = _tmp331_;
					_tmp332_ = g_strdup (".");
					gir_directory = _tmp332_;
					_tmp333_ = vala_compiler_directory;
					if (_tmp333_ != NULL) {
						ValaCodeContext* _tmp334_;
						const gchar* _tmp335_;
						const gchar* _tmp336_;
						gchar* _tmp337_;
						_tmp334_ = self->priv->context;
						_tmp335_ = vala_code_context_get_directory (_tmp334_);
						_tmp336_ = _tmp335_;
						_tmp337_ = g_strdup (_tmp336_);
						_g_free0 (gir_directory);
						gir_directory = _tmp337_;
					}
					_tmp338_ = gir_writer;
					_tmp339_ = self->priv->context;
					_tmp340_ = gir_directory;
					_tmp341_ = vala_compiler_gir;
					_tmp342_ = gir_namespace;
					_tmp343_ = gir_version;
					_tmp344_ = vala_compiler_library;
					_tmp345_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp338_, _tmp339_, _tmp340_, _tmp341_, _tmp342_, _tmp343_, _tmp344_, _tmp345_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp346_ = vala_compiler_vapi_filename;
	if (_tmp346_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp347_;
		gboolean _tmp348_ = FALSE;
		const gchar* _tmp349_;
		ValaCodeWriter* _tmp356_;
		ValaCodeContext* _tmp357_;
		const gchar* _tmp358_;
		_tmp347_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp347_;
		_tmp349_ = vala_compiler_directory;
		if (_tmp349_ != NULL) {
			const gchar* _tmp350_;
			_tmp350_ = vala_compiler_vapi_filename;
			_tmp348_ = !g_path_is_absolute (_tmp350_);
		} else {
			_tmp348_ = FALSE;
		}
		if (_tmp348_) {
			ValaCodeContext* _tmp351_;
			const gchar* _tmp352_;
			const gchar* _tmp353_;
			const gchar* _tmp354_;
			gchar* _tmp355_;
			_tmp351_ = self->priv->context;
			_tmp352_ = vala_code_context_get_directory (_tmp351_);
			_tmp353_ = _tmp352_;
			_tmp354_ = vala_compiler_vapi_filename;
			_tmp355_ = g_strdup_printf ("%s%c%s", _tmp353_, (gint) G_DIR_SEPARATOR, _tmp354_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp355_;
		}
		_tmp356_ = interface_writer;
		_tmp357_ = self->priv->context;
		_tmp358_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp356_, _tmp357_, _tmp358_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp359_ = vala_compiler_internal_vapi_filename;
	if (_tmp359_ != NULL) {
		gboolean _tmp360_ = FALSE;
		const gchar* _tmp361_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp363_;
		ValaCodeWriter* _tmp364_;
		const gchar* _tmp365_;
		const gchar* _tmp366_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp367_;
		gchar* _tmp368_;
		gboolean _tmp369_ = FALSE;
		const gchar* _tmp370_;
		ValaCodeWriter* _tmp377_;
		ValaCodeContext* _tmp378_;
		const gchar* _tmp379_;
		_tmp361_ = vala_compiler_internal_header_filename;
		if (_tmp361_ == NULL) {
			_tmp360_ = TRUE;
		} else {
			const gchar* _tmp362_;
			_tmp362_ = vala_compiler_header_filename;
			_tmp360_ = _tmp362_ == NULL;
		}
		if (_tmp360_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp363_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp363_;
		_tmp364_ = interface_writer;
		_tmp365_ = vala_compiler_header_filename;
		_tmp366_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp364_, _tmp365_, _tmp366_);
		_tmp367_ = vala_compiler_internal_vapi_filename;
		_tmp368_ = g_strdup (_tmp367_);
		vapi_filename = _tmp368_;
		_tmp370_ = vala_compiler_directory;
		if (_tmp370_ != NULL) {
			const gchar* _tmp371_;
			_tmp371_ = vapi_filename;
			_tmp369_ = !g_path_is_absolute (_tmp371_);
		} else {
			_tmp369_ = FALSE;
		}
		if (_tmp369_) {
			ValaCodeContext* _tmp372_;
			const gchar* _tmp373_;
			const gchar* _tmp374_;
			const gchar* _tmp375_;
			gchar* _tmp376_;
			_tmp372_ = self->priv->context;
			_tmp373_ = vala_code_context_get_directory (_tmp372_);
			_tmp374_ = _tmp373_;
			_tmp375_ = vapi_filename;
			_tmp376_ = g_strdup_printf ("%s%c%s", _tmp374_, (gint) G_DIR_SEPARATOR, _tmp375_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp376_;
		}
		_tmp377_ = interface_writer;
		_tmp378_ = self->priv->context;
		_tmp379_ = vapi_filename;
		vala_code_writer_write_file (_tmp377_, _tmp378_, _tmp379_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp380_ = vala_compiler_dependencies;
	if (_tmp380_ != NULL) {
		ValaCodeContext* _tmp381_;
		const gchar* _tmp382_;
		_tmp381_ = self->priv->context;
		_tmp382_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp381_, _tmp382_);
	}
	_tmp384_ = self->priv->context;
	_tmp385_ = vala_code_context_get_report (_tmp384_);
	_tmp386_ = _tmp385_;
	if (vala_report_get_errors (_tmp386_) > 0) {
		_tmp383_ = TRUE;
	} else {
		gboolean _tmp387_ = FALSE;
		gboolean _tmp388_;
		_tmp388_ = vala_compiler_fatal_warnings;
		if (_tmp388_) {
			ValaCodeContext* _tmp389_;
			ValaReport* _tmp390_;
			ValaReport* _tmp391_;
			_tmp389_ = self->priv->context;
			_tmp390_ = vala_code_context_get_report (_tmp389_);
			_tmp391_ = _tmp390_;
			_tmp387_ = vala_report_get_warnings (_tmp391_) > 0;
		} else {
			_tmp387_ = FALSE;
		}
		_tmp383_ = _tmp387_;
	}
	if (_tmp383_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp392_ = vala_compiler_ccode_only;
	if (!_tmp392_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp393_;
		gboolean _tmp394_ = FALSE;
		const gchar* _tmp395_;
		gboolean _tmp399_ = FALSE;
		const gchar* _tmp400_;
		gchar** _tmp404_;
		gint _tmp404__length1;
		_tmp393_ = vala_ccode_compiler_new ();
		ccompiler = _tmp393_;
		_tmp395_ = vala_compiler_cc_command;
		if (_tmp395_ == NULL) {
			const gchar* _tmp396_;
			_tmp396_ = g_getenv ("CC");
			_tmp394_ = _tmp396_ != NULL;
		} else {
			_tmp394_ = FALSE;
		}
		if (_tmp394_) {
			const gchar* _tmp397_;
			gchar* _tmp398_;
			_tmp397_ = g_getenv ("CC");
			_tmp398_ = g_strdup (_tmp397_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp398_;
		}
		_tmp400_ = vala_compiler_pkg_config_command;
		if (_tmp400_ == NULL) {
			const gchar* _tmp401_;
			_tmp401_ = g_getenv ("PKG_CONFIG");
			_tmp399_ = _tmp401_ != NULL;
		} else {
			_tmp399_ = FALSE;
		}
		if (_tmp399_) {
			const gchar* _tmp402_;
			gchar* _tmp403_;
			_tmp402_ = g_getenv ("PKG_CONFIG");
			_tmp403_ = g_strdup (_tmp402_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp403_;
		}
		_tmp404_ = vala_compiler_cc_options;
		_tmp404__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp404_ == NULL) {
			ValaCCodeCompiler* _tmp405_;
			ValaCodeContext* _tmp406_;
			const gchar* _tmp407_;
			gchar** _tmp408_;
			gchar** _tmp409_;
			gint _tmp409__length1;
			const gchar* _tmp410_;
			_tmp405_ = ccompiler;
			_tmp406_ = self->priv->context;
			_tmp407_ = vala_compiler_cc_command;
			_tmp408_ = g_new0 (gchar*, 0 + 1);
			_tmp409_ = _tmp408_;
			_tmp409__length1 = 0;
			_tmp410_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp405_, _tmp406_, _tmp407_, _tmp409_, 0, _tmp410_);
			_tmp409_ = (_vala_array_free (_tmp409_, _tmp409__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp411_;
			ValaCodeContext* _tmp412_;
			const gchar* _tmp413_;
			gchar** _tmp414_;
			gint _tmp414__length1;
			const gchar* _tmp415_;
			_tmp411_ = ccompiler;
			_tmp412_ = self->priv->context;
			_tmp413_ = vala_compiler_cc_command;
			_tmp414_ = vala_compiler_cc_options;
			_tmp414__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp415_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp411_, _tmp412_, _tmp413_, _tmp414_, _tmp414__length1, _tmp415_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
___lambda4_ (Block1Data* _data1_,
             GPid pid,
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}


static void
____lambda4__gchild_watch_func (GPid pid,
                                gint status,
                                gpointer self)
{
	___lambda4_ (self, pid, status);
}


static gint
vala_compiler_run_source (gchar** args,
                          int args_length1)
{
	gint result = 0;
	gboolean _tmp11_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint outputfd = 0;
	const gchar* _tmp23_;
	gint _tmp24_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp25_;
	gint ret = 0;
	ValaCompiler* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	const gchar* _tmp29_;
	gchar** target_args = NULL;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gint target_args_length1;
	gint _target_args_size_;
	gchar** target_run_args = NULL;
	const gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint target_run_args_length1;
	gint _target_run_args_size_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	gint _tmp53_ = 0;
	GError * _inner_error_ = NULL;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp4_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp10_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	_tmp11_ = vala_compiler_version;
	if (_tmp11_) {
		FILE* _tmp12_;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp13_;
		_tmp13_ = vala_compiler_api_version;
		if (_tmp13_) {
			FILE* _tmp14_;
			_tmp14_ = stdout;
			fprintf (_tmp14_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp15_ = vala_compiler_sources;
	_tmp15__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp15_ == NULL) {
		FILE* _tmp16_;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp17_ = g_get_tmp_dir ();
	_tmp18_ = vala_compiler_sources;
	_tmp18__length1 = _vala_array_length (vala_compiler_sources);
	_tmp19_ = _tmp18_[0];
	_tmp20_ = g_path_get_basename (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp17_, _tmp21_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp23_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp23_);
	_tmp24_ = outputfd;
	if (_tmp24_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp25_ = vala_compiler_new ();
	compiler = _tmp25_;
	_tmp26_ = compiler;
	ret = vala_compiler_run (_tmp26_);
	_tmp27_ = ret;
	if (_tmp27_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp28_ = outputfd;
	close (_tmp28_);
	_tmp29_ = vala_compiler_output;
	if (g_chmod (_tmp29_, 0700) != 0) {
		const gchar* _tmp30_;
		_tmp30_ = vala_compiler_output;
		g_unlink (_tmp30_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp31_ = vala_compiler_output;
	_tmp32_ = g_strdup (_tmp31_);
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	target_args = _tmp33_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp34_ = vala_compiler_run_args;
	_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, " ", 0);
	target_run_args = _tmp36_;
	target_run_args_length1 = _vala_array_length (_tmp35_);
	_target_run_args_size_ = target_run_args_length1;
	_tmp37_ = target_run_args;
	_tmp37__length1 = target_run_args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp37_;
		arg_collection_length1 = _tmp37__length1;
		for (arg_it = 0; arg_it < _tmp37__length1; arg_it = arg_it + 1) {
			gchar* _tmp38_;
			gchar* arg = NULL;
			_tmp38_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp38_;
			{
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp39_ = target_args;
				_tmp39__length1 = target_args_length1;
				_tmp40_ = arg;
				_tmp41_ = g_strdup (_tmp40_);
				_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp41_);
				_g_free0 (arg);
			}
		}
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		GPid _tmp44_ = 0;
		const gchar* _tmp46_;
		GPid _tmp47_;
		GMainLoop* _tmp48_;
		gint _tmp49_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp42_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp42_;
		_data1_->child_status = 0;
		_tmp43_ = target_args;
		_tmp43__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp43_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp44_, &_inner_error_);
		pid = _tmp44_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp45_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp45_;
		}
		_tmp46_ = vala_compiler_output;
		g_unlink (_tmp46_);
		_tmp47_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp47_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp48_ = _data1_->loop;
		g_main_loop_run (_tmp48_);
		_tmp49_ = _data1_->child_status;
		result = _tmp49_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = stdout;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		fprintf (_tmp50_, "%s\n", _tmp52_);
		result = 1;
		_g_error_free0 (e);
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp53_;
}


static gint
vala_compiler_main (gchar** args,
                    int args_length1)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp19_;
	gboolean _tmp23_ = FALSE;
	gchar** _tmp24_;
	gint _tmp24__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp27_;
	ValaCompiler* _tmp28_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "vala") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = args[0];
		_tmp6_ = g_path_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp7_);
	}
	if (_tmp0_) {
		result = vala_compiler_run_source (args, args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp8_;
		GOptionContext* _tmp9_;
		GOptionContext* _tmp10_;
		GOptionContext* _tmp11_;
		_tmp8_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp8_;
		_tmp9_ = opt_context;
		g_option_context_set_help_enabled (_tmp9_, TRUE);
		_tmp10_ = opt_context;
		g_option_context_add_main_entries (_tmp10_, VALA_COMPILER_options, NULL);
		_tmp11_ = opt_context;
		g_option_context_parse (_tmp11_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp12_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp12_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		FILE* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "%s\n", _tmp15_);
		_tmp16_ = stdout;
		_tmp17_ = args[0];
		fprintf (_tmp16_, "Run '%s --help' to see a full list of available command line options.\n", _tmp17_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp18_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	_tmp19_ = vala_compiler_version;
	if (_tmp19_) {
		FILE* _tmp20_;
		_tmp20_ = stdout;
		fprintf (_tmp20_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp21_;
		_tmp21_ = vala_compiler_api_version;
		if (_tmp21_) {
			FILE* _tmp22_;
			_tmp22_ = stdout;
			fprintf (_tmp22_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp24_ = vala_compiler_sources;
	_tmp24__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp24_ == NULL) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp25_ = vala_compiler_fast_vapis;
		_tmp25__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp23_ = _tmp25_ == NULL;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		FILE* _tmp26_;
		_tmp26_ = stderr;
		fprintf (_tmp26_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp27_ = vala_compiler_new ();
	compiler = _tmp27_;
	_tmp28_ = compiler;
	result = vala_compiler_run (_tmp28_);
	_vala_compiler_unref0 (compiler);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}


G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_compiler_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_compiler_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_compiler_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value,
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value,
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void
vala_compiler_class_init (ValaCompilerClass * klass)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void
vala_compiler_instance_init (ValaCompiler * self)
{
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



