/* valaccodeenumvalue.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeenumvalue.h>




struct _ValaCCodeEnumValuePrivate {
	char* _name;
	ValaCCodeExpression* _value;
};

#define VALA_CCODE_ENUM_VALUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ENUM_VALUE, ValaCCodeEnumValuePrivate))
enum  {
	VALA_CCODE_ENUM_VALUE_DUMMY_PROPERTY
};
static void vala_ccode_enum_value_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_enum_value_parent_class = NULL;
static void vala_ccode_enum_value_finalize (ValaCCodeNode* obj);



ValaCCodeEnumValue* vala_ccode_enum_value_construct (GType object_type, const char* name, ValaCCodeExpression* value) {
	ValaCCodeEnumValue* self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value == NULL || VALA_IS_CCODE_EXPRESSION (value), NULL);
	self = ((ValaCCodeEnumValue*) (g_type_create_instance (object_type)));
	vala_ccode_enum_value_set_name (self, name);
	vala_ccode_enum_value_set_value (self, value);
	return self;
}


ValaCCodeEnumValue* vala_ccode_enum_value_new (const char* name, ValaCCodeExpression* value) {
	return vala_ccode_enum_value_construct (VALA_TYPE_CCODE_ENUM_VALUE, name, value);
}


static void vala_ccode_enum_value_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeEnumValue * self;
	self = VALA_CCODE_ENUM_VALUE (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, self->priv->_name);
	if (self->priv->_value != NULL) {
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_value), writer);
	}
}


const char* vala_ccode_enum_value_get_name (ValaCCodeEnumValue* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ENUM_VALUE (self), NULL);
	return self->priv->_name;
}


void vala_ccode_enum_value_set_name (ValaCCodeEnumValue* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ENUM_VALUE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


ValaCCodeExpression* vala_ccode_enum_value_get_value (ValaCCodeEnumValue* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ENUM_VALUE (self), NULL);
	return self->priv->_value;
}


void vala_ccode_enum_value_set_value (ValaCCodeEnumValue* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ENUM_VALUE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_value == NULL ? NULL : (self->priv->_value = (vala_ccode_node_unref (self->priv->_value), NULL))), _tmp2);
}


static void vala_ccode_enum_value_class_init (ValaCCodeEnumValueClass * klass) {
	vala_ccode_enum_value_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_enum_value_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeEnumValuePrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_enum_value_real_write;
}


static void vala_ccode_enum_value_instance_init (ValaCCodeEnumValue * self) {
	self->priv = VALA_CCODE_ENUM_VALUE_GET_PRIVATE (self);
}


static void vala_ccode_enum_value_finalize (ValaCCodeNode* obj) {
	ValaCCodeEnumValue * self;
	self = VALA_CCODE_ENUM_VALUE (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_value == NULL ? NULL : (self->priv->_value = (vala_ccode_node_unref (self->priv->_value), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_enum_value_parent_class)->finalize (obj);
}


GType vala_ccode_enum_value_get_type (void) {
	static GType vala_ccode_enum_value_type_id = 0;
	if (vala_ccode_enum_value_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeEnumValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_enum_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeEnumValue), 0, (GInstanceInitFunc) vala_ccode_enum_value_instance_init, NULL };
		vala_ccode_enum_value_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeEnumValue", &g_define_type_info, 0);
	}
	return vala_ccode_enum_value_type_id;
}




