/* valaccodeformalparameter.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeformalparameter.h>




struct _ValaCCodeFormalParameterPrivate {
	char* _name;
	char* _type_name;
	gboolean _ellipsis;
};

#define VALA_CCODE_FORMAL_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FORMAL_PARAMETER, ValaCCodeFormalParameterPrivate))
enum  {
	VALA_CCODE_FORMAL_PARAMETER_DUMMY_PROPERTY
};
static void vala_ccode_formal_parameter_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_formal_parameter_parent_class = NULL;
static void vala_ccode_formal_parameter_finalize (ValaCCodeNode* obj);



ValaCCodeFormalParameter* vala_ccode_formal_parameter_construct (GType object_type, const char* n, const char* type) {
	ValaCCodeFormalParameter* self;
	g_return_val_if_fail (n != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	self = ((ValaCCodeFormalParameter*) (g_type_create_instance (object_type)));
	vala_ccode_formal_parameter_set_name (self, n);
	vala_ccode_formal_parameter_set_type_name (self, type);
	return self;
}


ValaCCodeFormalParameter* vala_ccode_formal_parameter_new (const char* n, const char* type) {
	return vala_ccode_formal_parameter_construct (VALA_TYPE_CCODE_FORMAL_PARAMETER, n, type);
}


ValaCCodeFormalParameter* vala_ccode_formal_parameter_construct_with_ellipsis (GType object_type) {
	ValaCCodeFormalParameter* self;
	self = ((ValaCCodeFormalParameter*) (g_type_create_instance (object_type)));
	vala_ccode_formal_parameter_set_ellipsis (self, TRUE);
	return self;
}


ValaCCodeFormalParameter* vala_ccode_formal_parameter_new_with_ellipsis (void) {
	return vala_ccode_formal_parameter_construct_with_ellipsis (VALA_TYPE_CCODE_FORMAL_PARAMETER);
}


static void vala_ccode_formal_parameter_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFormalParameter * self;
	self = VALA_CCODE_FORMAL_PARAMETER (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (!self->priv->_ellipsis) {
		vala_ccode_writer_write_string (writer, self->priv->_type_name);
		vala_ccode_writer_write_string (writer, " ");
		vala_ccode_writer_write_string (writer, self->priv->_name);
	} else {
		vala_ccode_writer_write_string (writer, "...");
	}
}


const char* vala_ccode_formal_parameter_get_name (ValaCCodeFormalParameter* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self), NULL);
	return self->priv->_name;
}


void vala_ccode_formal_parameter_set_name (ValaCCodeFormalParameter* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


const char* vala_ccode_formal_parameter_get_type_name (ValaCCodeFormalParameter* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self), NULL);
	return self->priv->_type_name;
}


void vala_ccode_formal_parameter_set_type_name (ValaCCodeFormalParameter* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp2);
}


gboolean vala_ccode_formal_parameter_get_ellipsis (ValaCCodeFormalParameter* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self), FALSE);
	return self->priv->_ellipsis;
}


void vala_ccode_formal_parameter_set_ellipsis (ValaCCodeFormalParameter* self, gboolean value) {
	g_return_if_fail (VALA_IS_CCODE_FORMAL_PARAMETER (self));
	self->priv->_ellipsis = value;
}


static void vala_ccode_formal_parameter_class_init (ValaCCodeFormalParameterClass * klass) {
	vala_ccode_formal_parameter_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_formal_parameter_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFormalParameterPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_formal_parameter_real_write;
}


static void vala_ccode_formal_parameter_instance_init (ValaCCodeFormalParameter * self) {
	self->priv = VALA_CCODE_FORMAL_PARAMETER_GET_PRIVATE (self);
}


static void vala_ccode_formal_parameter_finalize (ValaCCodeNode* obj) {
	ValaCCodeFormalParameter * self;
	self = VALA_CCODE_FORMAL_PARAMETER (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	self->priv->_type_name = (g_free (self->priv->_type_name), NULL);
	VALA_CCODE_NODE_CLASS (vala_ccode_formal_parameter_parent_class)->finalize (obj);
}


GType vala_ccode_formal_parameter_get_type (void) {
	static GType vala_ccode_formal_parameter_type_id = 0;
	if (vala_ccode_formal_parameter_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFormalParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_formal_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFormalParameter), 0, (GInstanceInitFunc) vala_ccode_formal_parameter_instance_init, NULL };
		vala_ccode_formal_parameter_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeFormalParameter", &g_define_type_info, 0);
	}
	return vala_ccode_formal_parameter_type_id;
}




