/* valaccodeswitchstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeswitchstatement.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeSwitchStatementPrivate {
	ValaCCodeExpression* _expression;
	GeeList* case_statements;
	GeeList* default_statements;
};

#define VALA_CCODE_SWITCH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_SWITCH_STATEMENT, ValaCCodeSwitchStatementPrivate))
enum  {
	VALA_CCODE_SWITCH_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_switch_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_switch_statement_parent_class = NULL;
static void vala_ccode_switch_statement_finalize (ValaCCodeNode* obj);



ValaCCodeSwitchStatement* vala_ccode_switch_statement_construct (GType object_type, ValaCCodeExpression* expression) {
	ValaCCodeSwitchStatement* self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expression), NULL);
	self = ((ValaCCodeSwitchStatement*) (g_type_create_instance (object_type)));
	vala_ccode_switch_statement_set_expression (self, expression);
	return self;
}


ValaCCodeSwitchStatement* vala_ccode_switch_statement_new (ValaCCodeExpression* expression) {
	return vala_ccode_switch_statement_construct (VALA_TYPE_CCODE_SWITCH_STATEMENT, expression);
}


/**
 * Adds the specified case statement to the list of switch sections.
 *
 * @param case_stmt a case statement
 */
void vala_ccode_switch_statement_add_case (ValaCCodeSwitchStatement* self, ValaCCodeCaseStatement* case_stmt) {
	g_return_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (case_stmt));
	gee_collection_add (GEE_COLLECTION (self->priv->case_statements), case_stmt);
}


/**
 * Append the specified statement to the default clause.
 *
 * @param stmt a statement
 */
void vala_ccode_switch_statement_add_default_statement (ValaCCodeSwitchStatement* self, ValaCCodeStatement* stmt) {
	g_return_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_STATEMENT (stmt));
	gee_collection_add (GEE_COLLECTION (self->priv->default_statements), stmt);
}


static void vala_ccode_switch_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeSwitchStatement * self;
	self = VALA_CCODE_SWITCH_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "switch (");
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_expression), writer);
	vala_ccode_writer_write_string (writer, ")");
	vala_ccode_writer_write_begin_block (writer);
	{
		GeeList* case_stmt_collection;
		int case_stmt_it;
		case_stmt_collection = self->priv->case_statements;
		for (case_stmt_it = 0; case_stmt_it < gee_collection_get_size (GEE_COLLECTION (case_stmt_collection)); case_stmt_it = case_stmt_it + 1) {
			ValaCCodeCaseStatement* case_stmt;
			case_stmt = ((ValaCCodeCaseStatement*) (gee_list_get (GEE_LIST (case_stmt_collection), case_stmt_it)));
			{
				vala_ccode_node_write (VALA_CCODE_NODE (case_stmt), writer);
				(case_stmt == NULL ? NULL : (case_stmt = (vala_ccode_node_unref (case_stmt), NULL)));
			}
		}
	}
	if (gee_collection_get_size (GEE_COLLECTION (self->priv->default_statements)) > 0) {
		vala_ccode_writer_write_indent (writer, NULL);
		vala_ccode_writer_write_string (writer, "default:");
		vala_ccode_writer_write_newline (writer);
		{
			GeeList* stmt_collection;
			int stmt_it;
			stmt_collection = self->priv->default_statements;
			for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
				ValaCCodeStatement* stmt;
				stmt = ((ValaCCodeStatement*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)));
				{
					vala_ccode_node_write (VALA_CCODE_NODE (stmt), writer);
					(stmt == NULL ? NULL : (stmt = (vala_ccode_node_unref (stmt), NULL)));
				}
			}
		}
	}
	vala_ccode_writer_write_end_block (writer);
}


ValaCCodeExpression* vala_ccode_switch_statement_get_expression (ValaCCodeSwitchStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_ccode_switch_statement_set_expression (ValaCCodeSwitchStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_SWITCH_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_ccode_node_unref (self->priv->_expression), NULL))), _tmp2);
}


static void vala_ccode_switch_statement_class_init (ValaCCodeSwitchStatementClass * klass) {
	vala_ccode_switch_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_switch_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeSwitchStatementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_switch_statement_real_write;
}


static void vala_ccode_switch_statement_instance_init (ValaCCodeSwitchStatement * self) {
	self->priv = VALA_CCODE_SWITCH_STATEMENT_GET_PRIVATE (self);
	self->priv->case_statements = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_CASE_STATEMENT, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
	self->priv->default_statements = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_STATEMENT, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
}


static void vala_ccode_switch_statement_finalize (ValaCCodeNode* obj) {
	ValaCCodeSwitchStatement * self;
	self = VALA_CCODE_SWITCH_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_ccode_node_unref (self->priv->_expression), NULL)));
	(self->priv->case_statements == NULL ? NULL : (self->priv->case_statements = (gee_collection_object_unref (self->priv->case_statements), NULL)));
	(self->priv->default_statements == NULL ? NULL : (self->priv->default_statements = (gee_collection_object_unref (self->priv->default_statements), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_switch_statement_parent_class)->finalize (obj);
}


GType vala_ccode_switch_statement_get_type (void) {
	static GType vala_ccode_switch_statement_type_id = 0;
	if (vala_ccode_switch_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeSwitchStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_switch_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeSwitchStatement), 0, (GInstanceInitFunc) vala_ccode_switch_statement_instance_init, NULL };
		vala_ccode_switch_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeSwitchStatement", &g_define_type_info, 0);
	}
	return vala_ccode_switch_statement_type_id;
}




