/* valaccodeinvocationexpressionbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeinvocationexpressionbinding.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamethod.h>
#include <gee/list.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <vala/valaobjecttype.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashmap.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraytype.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <vala/valaarraymovemethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <vala/valastruct.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valatypesymbol.h>
#include <vala/valadynamicmethod.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaformalparameter.h>
#include <vala/valasourcereference.h>
#include <vala/valacreationmethod.h>
#include <ccode/valaccodecastexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/arraylist.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valavoidtype.h>
#include <vala/valareport.h>
#include <vala/valapointertype.h>
#include <vala/valasignal.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodedynamicmethodbinding.h>




struct _ValaCCodeInvocationExpressionBindingPrivate {
	ValaInvocationExpression* _invocation_expression;
};

#define VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, ValaCCodeInvocationExpressionBindingPrivate))
enum  {
	VALA_CCODE_INVOCATION_EXPRESSION_BINDING_DUMMY_PROPERTY
};
static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_invocation_expression_binding_parent_class = NULL;
static void vala_ccode_invocation_expression_binding_finalize (ValaCodeBinding* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_construct (GType object_type, ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression) {
	ValaCCodeInvocationExpressionBinding* self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_INVOCATION_EXPRESSION (invocation_expression), NULL);
	self = ((ValaCCodeInvocationExpressionBinding*) (g_type_create_instance (object_type)));
	vala_ccode_invocation_expression_binding_set_invocation_expression (self, invocation_expression);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


ValaCCodeInvocationExpressionBinding* vala_ccode_invocation_expression_binding_new (ValaCCodeGenerator* codegen, ValaInvocationExpression* invocation_expression) {
	return vala_ccode_invocation_expression_binding_construct (VALA_TYPE_CCODE_INVOCATION_EXPRESSION_BINDING, codegen, invocation_expression);
}


static void vala_ccode_invocation_expression_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeInvocationExpressionBinding * self;
	ValaInvocationExpression* _tmp0;
	ValaInvocationExpression* expr;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp2;
	ValaExpression* _tmp1;
	ValaMemberAccess* ma;
	ValaDataType* _tmp3;
	ValaDataType* itype;
	GeeList* _tmp4;
	ValaCCodeExpression* _tmp16;
	ValaCCodeExpression* ccall_expr;
	GeeHashMap* carg_map;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	ValaDataType* _tmp132;
	gboolean _tmp133;
	gint last_pos;
	gint min_pos;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_invocation_expression, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	vala_code_node_accept_children (VALA_CODE_NODE (expr), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	ma = (_tmp2 = (_tmp1 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp1) ? ((ValaMemberAccess*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	_tmp3 = NULL;
	itype = (_tmp3 = vala_expression_get_value_type (vala_invocation_expression_get_call (expr)), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	_tmp4 = NULL;
	params = (_tmp4 = vala_data_type_get_parameters (itype), (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp4);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp6;
		ValaMethod* _tmp5;
		g_assert (ma != NULL);
		_tmp6 = NULL;
		_tmp5 = NULL;
		m = (_tmp6 = (_tmp5 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (itype))), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), _tmp6);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaCCodeFunctionCall* _tmp8;
			ValaCCodeFunctionCall* _tmp7;
			_tmp8 = NULL;
			_tmp7 = NULL;
			ccall = (_tmp8 = (_tmp7 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (_tmp7 == NULL ? NULL : vala_ccode_node_ref (_tmp7))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp8);
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp9;
				ValaClass* cl;
				ValaMethod* _tmp11;
				ValaMethod* _tmp10;
				ValaCCodeFunctionCall* _tmp14;
				ValaCCodeIdentifier* _tmp13;
				char* _tmp12;
				ValaCCodeIdentifier* _tmp15;
				/* constructor*/
				_tmp9 = NULL;
				cl = (_tmp9 = VALA_CLASS (vala_object_type_get_type_symbol ((VALA_OBJECT_TYPE (itype)))), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
				_tmp11 = NULL;
				_tmp10 = NULL;
				m = (_tmp11 = (_tmp10 = vala_class_get_default_construction_method (cl), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), _tmp11);
				_tmp14 = NULL;
				_tmp13 = NULL;
				_tmp12 = NULL;
				ccall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = vala_method_get_real_cname (m)))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp14);
				(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
				_tmp12 = (g_free (_tmp12), NULL);
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("object_type"))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
				(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			}
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp16 = NULL;
	ccall_expr = (_tmp16 = VALA_CCODE_EXPRESSION (ccall), (_tmp16 == NULL ? NULL : vala_ccode_node_ref (_tmp16)));
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp17;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp19;
		char* _tmp18;
		_tmp17 = NULL;
		array_type = (_tmp17 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp17 == NULL ? NULL : vala_code_node_ref (_tmp17)));
		_tmp19 = NULL;
		_tmp18 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (0)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ((_tmp18 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
		_tmp18 = (g_free (_tmp18), NULL);
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp21;
		ValaCCodeExpression* _tmp20;
		ValaStruct* _tmp23;
		ValaSymbol* _tmp22;
		ValaStruct* st;
		_tmp21 = NULL;
		_tmp20 = NULL;
		instance = (_tmp21 = (_tmp20 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp20 == NULL ? NULL : vala_ccode_node_ref (_tmp20))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp21);
		_tmp23 = NULL;
		_tmp22 = NULL;
		st = (_tmp23 = (_tmp22 = vala_symbol_get_parent_symbol (VALA_SYMBOL (m)), (VALA_IS_STRUCT (_tmp22) ? ((ValaStruct*) (_tmp22)) : NULL)), (_tmp23 == NULL ? NULL : vala_code_node_ref (_tmp23)));
		if (st != NULL && !vala_struct_is_simple_type (st)) {
			ValaCCodeUnaryExpression* _tmp25;
			ValaCCodeExpression* _tmp24;
			ValaCCodeUnaryExpression* unary;
			/* we need to pass struct instance by reference*/
			_tmp25 = NULL;
			_tmp24 = NULL;
			unary = (_tmp25 = (_tmp24 = instance, (VALA_IS_CCODE_UNARY_EXPRESSION (_tmp24) ? ((ValaCCodeUnaryExpression*) (_tmp24)) : NULL)), (_tmp25 == NULL ? NULL : vala_ccode_node_ref (_tmp25)));
			if (unary != NULL && vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
				ValaCCodeExpression* _tmp27;
				ValaCCodeExpression* _tmp26;
				/* *expr => expr*/
				_tmp27 = NULL;
				_tmp26 = NULL;
				instance = (_tmp27 = (_tmp26 = vala_ccode_unary_expression_get_inner (unary), (_tmp26 == NULL ? NULL : vala_ccode_node_ref (_tmp26))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp27);
			} else {
				if (VALA_IS_CCODE_IDENTIFIER (instance) || VALA_IS_CCODE_MEMBER_ACCESS (instance)) {
					ValaCCodeExpression* _tmp28;
					_tmp28 = NULL;
					instance = (_tmp28 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp28);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp30;
					ValaCCodeIdentifier* _tmp29;
					ValaCCodeUnaryExpression* _tmp32;
					ValaCCodeIdentifier* _tmp31;
					ValaCCodeExpression* _tmp34;
					ValaCCodeExpression* _tmp33;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp30 = NULL;
					_tmp29 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
					(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
					_tmp32 = NULL;
					_tmp31 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)))))))));
					(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
					(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
					_tmp34 = NULL;
					_tmp33 = NULL;
					instance = (_tmp34 = (_tmp33 = VALA_CCODE_EXPRESSION (ccomma), (_tmp33 == NULL ? NULL : vala_ccode_node_ref (_tmp33))), (instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL))), _tmp34);
					(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
				}
			}
			(unary == NULL ? NULL : (unary = (vala_ccode_node_unref (unary), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
	} else {
		if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			ValaClass* _tmp35;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp38;
			char* _tmp37;
			char* _tmp36;
			ValaCCodeFunctionCall* _tmp39;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			ValaMemberAccess* _tmp41;
			ValaExpression* _tmp40;
			ValaMemberAccess* ma;
			_tmp35 = NULL;
			cl = (_tmp35 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (m))), (_tmp35 == NULL ? NULL : vala_code_node_ref (_tmp35)));
			_tmp38 = NULL;
			_tmp37 = NULL;
			_tmp36 = NULL;
			_tmp39 = NULL;
			cast = (_tmp39 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ((_tmp37 = g_strconcat ((_tmp36 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)), "_CLASS", NULL)))))), (_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL))), (_tmp37 = (g_free (_tmp37), NULL)), (_tmp36 = (g_free (_tmp36), NULL)), _tmp39);
			klass = NULL;
			_tmp41 = NULL;
			_tmp40 = NULL;
			ma = (_tmp41 = (_tmp40 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp40) ? ((ValaMemberAccess*) (_tmp40)) : NULL)), (_tmp41 == NULL ? NULL : vala_code_node_ref (_tmp41)));
			if (vala_member_access_get_inner (ma) == NULL) {
				if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp42;
					/* Accessing the method from a static or class constructor*/
					_tmp42 = NULL;
					klass = (_tmp42 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp42);
				} else {
					ValaCCodeIdentifier* _tmp43;
					ValaCCodeFunctionCall* _tmp44;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp45;
					ValaCCodeExpression* _tmp47;
					ValaCCodeExpression* _tmp46;
					/* Accessing the method from within an instance method*/
					_tmp43 = NULL;
					_tmp44 = NULL;
					k = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS")))), (_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL))), _tmp44);
					_tmp45 = NULL;
					vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("self"))));
					(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
					_tmp47 = NULL;
					_tmp46 = NULL;
					klass = (_tmp47 = (_tmp46 = VALA_CCODE_EXPRESSION (k), (_tmp46 == NULL ? NULL : vala_ccode_node_ref (_tmp46))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp47);
					(k == NULL ? NULL : (k = (vala_ccode_node_unref (k), NULL)));
				}
			} else {
				ValaCCodeIdentifier* _tmp48;
				ValaCCodeFunctionCall* _tmp49;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp51;
				ValaCCodeExpression* _tmp50;
				/* Accessing the method of an instance*/
				_tmp48 = NULL;
				_tmp49 = NULL;
				k = (_tmp49 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS")))), (_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL))), _tmp49);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
				_tmp51 = NULL;
				_tmp50 = NULL;
				klass = (_tmp51 = (_tmp50 = VALA_CCODE_EXPRESSION (k), (_tmp50 == NULL ? NULL : vala_ccode_node_ref (_tmp50))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp51);
				(k == NULL ? NULL : (k = (vala_ccode_node_unref (k), NULL)));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cinstance_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION (cast));
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			(cast == NULL ? NULL : (cast = (vala_ccode_node_unref (cast), NULL)));
			(klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)));
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp52;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp53;
		ValaCCodeFunctionCall* _tmp54;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp56;
		char* _tmp55;
		_tmp52 = NULL;
		array_type = (_tmp52 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp52 == NULL ? NULL : vala_code_node_ref (_tmp52)));
		_tmp53 = NULL;
		_tmp54 = NULL;
		csizeof = (_tmp54 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_identifier_new ("sizeof")))), (_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL))), _tmp54);
		_tmp56 = NULL;
		_tmp55 = NULL;
		vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ((_tmp55 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
		(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
		_tmp55 = (g_free (_tmp55), NULL);
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), 0.1, FALSE)), VALA_CCODE_EXPRESSION (csizeof));
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL)));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			ValaCCodeDynamicMethodBinding* _tmp65;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* arg_collection;
				int arg_it;
				arg_collection = vala_invocation_expression_get_argument_list (expr);
				for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
					ValaExpression* arg;
					arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
					{
						ValaUnaryExpression* _tmp58;
						ValaExpression* _tmp57;
						ValaUnaryExpression* unary;
						_tmp58 = NULL;
						_tmp57 = NULL;
						unary = (_tmp58 = (_tmp57 = arg, (VALA_IS_UNARY_EXPRESSION (_tmp57) ? ((ValaUnaryExpression*) (_tmp57)) : NULL)), (_tmp58 == NULL ? NULL : vala_code_node_ref (_tmp58)));
						if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
							char* _tmp59;
							ValaFormalParameter* _tmp60;
							ValaFormalParameter* param;
							/* out argument*/
							_tmp59 = NULL;
							_tmp60 = NULL;
							param = (_tmp60 = vala_formal_parameter_new ((_tmp59 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp59 = (g_free (_tmp59), NULL)), _tmp60);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
							vala_method_add_parameter (m, param);
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						} else {
							if (unary != NULL && vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
								char* _tmp61;
								ValaFormalParameter* _tmp62;
								ValaFormalParameter* param;
								/* ref argument*/
								_tmp61 = NULL;
								_tmp62 = NULL;
								param = (_tmp62 = vala_formal_parameter_new ((_tmp61 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), (_tmp61 = (g_free (_tmp61), NULL)), _tmp62);
								vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
								vala_method_add_parameter (m, param);
								(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
							} else {
								ValaFormalParameter* _tmp64;
								char* _tmp63;
								/* in argument*/
								_tmp64 = NULL;
								_tmp63 = NULL;
								vala_method_add_parameter (m, (_tmp64 = vala_formal_parameter_new ((_tmp63 = g_strdup_printf ("param%d", param_nr)), vala_expression_get_value_type (arg), NULL)));
								(_tmp64 == NULL ? NULL : (_tmp64 = (vala_code_node_unref (_tmp64), NULL)));
								_tmp63 = (g_free (_tmp63), NULL);
							}
						}
						param_nr++;
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
						(unary == NULL ? NULL : (unary = (vala_code_node_unref (unary), NULL)));
					}
				}
				(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
			}
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_method_get_parameters (m);
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						vala_code_node_accept (VALA_CODE_NODE (param), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
			}
			_tmp65 = NULL;
			vala_ccode_dynamic_method_binding_generate_wrapper ((_tmp65 = vala_ccode_generator_dynamic_method_binding (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DYNAMIC_METHOD (m))));
			(_tmp65 == NULL ? NULL : (_tmp65 = (vala_code_binding_unref (_tmp65), NULL)));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp70;
				ValaCCodeCastExpression* _tmp69;
				char* _tmp68;
				char* _tmp67;
				ValaCCodeIdentifier* _tmp66;
				_tmp70 = NULL;
				_tmp69 = NULL;
				_tmp68 = NULL;
				_tmp67 = NULL;
				_tmp66 = NULL;
				ccall_expr = (_tmp70 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("self"))), VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (ccall), (_tmp68 = g_strconcat ((_tmp67 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), FALSE)), "*", NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp70);
				(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
				_tmp68 = (g_free (_tmp68), NULL);
				_tmp67 = (g_free (_tmp67), NULL);
				(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator (GEE_ITERABLE (params));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaCCodeExpression* _tmp71;
				ValaCCodeExpression* cexpr;
				GeeList* extra_args;
				_tmp71 = NULL;
				cexpr = (_tmp71 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (_tmp71 == NULL ? NULL : vala_ccode_node_ref (_tmp71)));
				extra_args = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
				if (gee_iterator_next (params_it)) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						gboolean multiple_cargs;
						ValaCCodeExpression* _tmp87;
						/* if the vala argument expands to multiple C arguments,
						 we have to make sure that the C arguments don't depend
						 on each other as there is no guaranteed argument
						 evaluation order
						 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
						multiple_cargs = FALSE;
						if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaArrayType* _tmp72;
							ValaArrayType* array_type;
							_tmp72 = NULL;
							array_type = (_tmp72 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp72 == NULL ? NULL : vala_code_node_ref (_tmp72)));
							{
								gint dim;
								dim = 1;
								for (; dim <= vala_array_type_get_rank (array_type); dim++) {
									ValaCCodeExpression* _tmp73;
									_tmp73 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp73 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg, dim)));
									(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
								}
							}
							multiple_cargs = TRUE;
							(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
						} else {
							if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaDelegateType* _tmp74;
								ValaDelegateType* deleg_type;
								ValaDelegate* _tmp75;
								ValaDelegate* d;
								_tmp74 = NULL;
								deleg_type = (_tmp74 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp74 == NULL ? NULL : vala_code_node_ref (_tmp74)));
								_tmp75 = NULL;
								d = (_tmp75 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp75 == NULL ? NULL : vala_code_node_ref (_tmp75)));
								if (vala_delegate_get_has_target (d)) {
									ValaCCodeExpression* delegate_target;
									delegate_target = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg);
									if (vala_data_type_get_value_owned (VALA_DATA_TYPE (deleg_type))) {
										ValaCCodeExpression* delegate_target_destroy_notify;
										ValaMethod* _tmp77;
										ValaSymbol* _tmp76;
										ValaMethod* delegate_method;
										ValaMemberAccess* _tmp79;
										ValaExpression* _tmp78;
										ValaMemberAccess* ma;
										delegate_target_destroy_notify = NULL;
										_tmp77 = NULL;
										_tmp76 = NULL;
										delegate_method = (_tmp77 = (_tmp76 = vala_expression_get_symbol_reference (arg), (VALA_IS_METHOD (_tmp76) ? ((ValaMethod*) (_tmp76)) : NULL)), (_tmp77 == NULL ? NULL : vala_code_node_ref (_tmp77)));
										_tmp79 = NULL;
										_tmp78 = NULL;
										ma = (_tmp79 = (_tmp78 = arg, (VALA_IS_MEMBER_ACCESS (_tmp78) ? ((ValaMemberAccess*) (_tmp78)) : NULL)), (_tmp79 == NULL ? NULL : vala_code_node_ref (_tmp79)));
										if (delegate_method != NULL && vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE && vala_member_access_get_inner (ma) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))) != NULL && vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (ma))))) {
											ValaCCodeExpression* _tmp80;
											ValaCCodeFunctionCall* _tmp81;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp83;
											ValaCCodeExpression* _tmp82;
											ValaCCodeExpression* _tmp84;
											_tmp80 = NULL;
											_tmp81 = NULL;
											ref_call = (_tmp81 = vala_ccode_function_call_new ((_tmp80 = vala_ccode_generator_get_dup_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_code_node_get_source_reference (VALA_CODE_NODE (arg))))), (_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL))), _tmp81);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp83 = NULL;
											_tmp82 = NULL;
											delegate_target = (_tmp83 = (_tmp82 = VALA_CCODE_EXPRESSION (ref_call), (_tmp82 == NULL ? NULL : vala_ccode_node_ref (_tmp82))), (delegate_target == NULL ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL))), _tmp83);
											_tmp84 = NULL;
											delegate_target_destroy_notify = (_tmp84 = vala_ccode_generator_get_destroy_func_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_member_access_get_inner (ma))), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL))), _tmp84);
											(ref_call == NULL ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL)));
										} else {
											ValaCCodeExpression* _tmp85;
											_tmp85 = NULL;
											delegate_target_destroy_notify = (_tmp85 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL))), _tmp85);
										}
										gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
										(delegate_target_destroy_notify == NULL ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)));
										(delegate_method == NULL ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL)));
										(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
									}
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
									multiple_cargs = TRUE;
									(delegate_target == NULL ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)));
								}
								(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
								(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
							} else {
								if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaCCodeExpression* _tmp86;
									_tmp86 = NULL;
									gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (_tmp86 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), arg)));
									(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
									multiple_cargs = TRUE;
								}
							}
						}
						_tmp87 = NULL;
						cexpr = (_tmp87 = vala_ccode_generator_handle_struct_argument (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), param, arg, cexpr), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp87);
						if (multiple_cargs && VALA_IS_INVOCATION_EXPRESSION (arg)) {
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_decl;
							ValaCCodeAssignment* _tmp89;
							ValaCCodeIdentifier* _tmp88;
							ValaCCodeExpression* _tmp90;
							ValaCCodeExpression* _tmp92;
							ValaCCodeExpression* _tmp91;
							/* if vala argument is invocation expression
							 the auxiliary C argument(s) will depend on the main C argument
							 (tmp = arg1, call (tmp, arg2, arg3,...))*/
							ccomma = vala_ccode_comma_expression_new ();
							temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg), TRUE, NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
							_tmp89 = NULL;
							_tmp88 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl))))), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp89 == NULL ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)));
							(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
							_tmp90 = NULL;
							cexpr = (_tmp90 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp90);
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							_tmp92 = NULL;
							_tmp91 = NULL;
							ccall_expr = (_tmp92 = (_tmp91 = VALA_CCODE_EXPRESSION (ccomma), (_tmp91 == NULL ? NULL : vala_ccode_node_ref (_tmp91))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp92);
							(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
						}
						/* unref old value for non-null non-weak ref/out arguments
						 disabled for arrays for now as that requires special handling
						 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN && vala_ccode_generator_requires_destroy (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (arg)) && (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT || !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param))) && !(VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) {
							ValaUnaryExpression* _tmp93;
							ValaUnaryExpression* unary;
							ValaCCodeCommaExpression* ccomma;
							ValaLocalVariable* temp_var;
							ValaCCodeExpression* _tmp95;
							ValaCCodeIdentifier* _tmp94;
							ValaLocalVariable* ret_temp_var;
							ValaCCodeCommaExpression* cassign_comma;
							ValaLocalVariable* assign_temp_var;
							ValaCCodeAssignment* _tmp106;
							ValaCCodeExpression* _tmp105;
							ValaCCodeIdentifier* _tmp104;
							ValaCCodeIdentifier* _tmp103;
							ValaCCodeExpression* _tmp107;
							ValaCCodeIdentifier* _tmp108;
							ValaCCodeAssignment* _tmp109;
							ValaCCodeExpression* _tmp112;
							ValaCCodeExpression* _tmp111;
							_tmp93 = NULL;
							unary = (_tmp93 = VALA_UNARY_EXPRESSION (arg), (_tmp93 == NULL ? NULL : vala_code_node_ref (_tmp93)));
							ccomma = vala_ccode_comma_expression_new ();
							temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
							_tmp95 = NULL;
							_tmp94 = NULL;
							cexpr = (_tmp95 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp95);
							(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
								ValaCCodeCommaExpression* crefcomma;
								ValaCCodeAssignment* _tmp97;
								ValaCCodeIdentifier* _tmp96;
								ValaCCodeExpression* _tmp99;
								ValaCCodeExpression* _tmp98;
								crefcomma = vala_ccode_comma_expression_new ();
								_tmp97 = NULL;
								_tmp96 = NULL;
								vala_ccode_comma_expression_append_expression (crefcomma, VALA_CCODE_EXPRESSION ((_tmp97 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp97 == NULL ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL)));
								(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
								vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
								_tmp99 = NULL;
								_tmp98 = NULL;
								cexpr = (_tmp99 = (_tmp98 = VALA_CCODE_EXPRESSION (crefcomma), (_tmp98 == NULL ? NULL : vala_ccode_node_ref (_tmp98))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp99);
								(crefcomma == NULL ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL)));
							}
							/* call function*/
							ret_temp_var = NULL;
							if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
								vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
							} else {
								ValaLocalVariable* _tmp100;
								ValaCCodeAssignment* _tmp102;
								ValaCCodeIdentifier* _tmp101;
								_tmp100 = NULL;
								ret_temp_var = (_tmp100 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_return_type (m), TRUE, NULL), (ret_temp_var == NULL ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL))), _tmp100);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, ret_temp_var);
								_tmp102 = NULL;
								_tmp101 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
								(_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)));
							}
							cassign_comma = vala_ccode_comma_expression_new ();
							assign_temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
							gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, assign_temp_var);
							_tmp106 = NULL;
							_tmp105 = NULL;
							_tmp104 = NULL;
							_tmp103 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp106 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))), (_tmp105 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var))))), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp106 == NULL ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL)));
							(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
							(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
							(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
							/* unref old value*/
							_tmp107 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, (_tmp107 = vala_ccode_generator_get_unref_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), vala_expression_get_value_type (arg), arg)));
							(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
							_tmp108 = NULL;
							vala_ccode_comma_expression_append_expression (cassign_comma, VALA_CCODE_EXPRESSION ((_tmp108 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (assign_temp_var))))));
							(_tmp108 == NULL ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL)));
							/* assign new value*/
							_tmp109 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (unary)))), VALA_CCODE_EXPRESSION (cassign_comma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
							(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
							/* return value*/
							if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
								ValaCCodeIdentifier* _tmp110;
								_tmp110 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (ret_temp_var))))));
								(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
							}
							_tmp112 = NULL;
							_tmp111 = NULL;
							ccall_expr = (_tmp112 = (_tmp111 = VALA_CCODE_EXPRESSION (ccomma), (_tmp111 == NULL ? NULL : vala_ccode_node_ref (_tmp111))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp112);
							(unary == NULL ? NULL : (unary = (vala_code_node_unref (unary), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
							(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
							(ret_temp_var == NULL ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)));
							(cassign_comma == NULL ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL)));
							(assign_temp_var == NULL ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL)));
						}
						if (vala_formal_parameter_get_ctype (param) != NULL) {
							ValaCCodeExpression* _tmp113;
							_tmp113 = NULL;
							cexpr = (_tmp113 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp113);
						}
					}
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), ellipsis);
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				} else {
					/* default argument position*/
					arg_pos = vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (i)), ellipsis);
				}
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (arg_pos), cexpr);
				i++;
				(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
				(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
				(extra_args == NULL ? NULL : (extra_args = (gee_collection_object_unref (extra_args), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
	}
	while (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		param = ((ValaFormalParameter*) (gee_iterator_get (params_it)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* _tmp114;
			_tmp114 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (_tmp114 = g_strdup_printf ("no default expression for argument %d", i)));
			_tmp114 = (g_free (_tmp114), NULL);
			(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
			(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			(itype == NULL ? NULL : (itype = (vala_code_node_unref (itype), NULL)));
			(ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)));
			(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
			(instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)));
			(params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_parameter_type (param) != NULL && VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			ValaArrayType* _tmp115;
			ValaArrayType* array_type;
			_tmp115 = NULL;
			array_type = (_tmp115 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp115 == NULL ? NULL : vala_code_node_ref (_tmp115)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* _tmp116;
					_tmp116 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_carray_length_parameter_position (param) + 0.01 * dim, FALSE)), (_tmp116 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_default_expression (param), dim)));
					(_tmp116 == NULL ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		}
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m))) {
		ValaArrayType* _tmp117;
		ValaArrayType* array_type;
		_tmp117 = NULL;
		array_type = (_tmp117 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp117 == NULL ? NULL : vala_code_node_ref (_tmp117)));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* temp_ref;
					ValaCCodeUnaryExpression* _tmp118;
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
					temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					_tmp118 = NULL;
					gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_carray_length_parameter_position (m) + 0.01 * dim, FALSE)), VALA_CCODE_EXPRESSION ((_tmp118 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(_tmp118 == NULL ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* _tmp119;
					_tmp119 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((_tmp119 = vala_ccode_constant_new ("-1"))));
					(_tmp119 == NULL ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL)));
				}
			}
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (m != NULL && VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m))) {
			ValaDelegateType* _tmp120;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp121;
			ValaDelegate* d;
			_tmp120 = NULL;
			deleg_type = (_tmp120 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp120 == NULL ? NULL : vala_code_node_ref (_tmp120)));
			_tmp121 = NULL;
			d = (_tmp121 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp121 == NULL ? NULL : vala_code_node_ref (_tmp121)));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp123;
				ValaVoidType* _tmp122;
				ValaLocalVariable* _tmp124;
				ValaLocalVariable* temp_var;
				ValaCCodeIdentifier* temp_ref;
				ValaCCodeUnaryExpression* _tmp125;
				_tmp123 = NULL;
				_tmp122 = NULL;
				_tmp124 = NULL;
				temp_var = (_tmp124 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_DATA_TYPE ((_tmp123 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp122 = vala_void_type_new ())), NULL))), TRUE, NULL), (_tmp123 == NULL ? NULL : (_tmp123 = (vala_code_node_unref (_tmp123), NULL))), (_tmp122 == NULL ? NULL : (_tmp122 = (vala_code_node_unref (_tmp122), NULL))), _tmp124);
				temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
				gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
				_tmp125 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_method_get_cdelegate_target_parameter_position (m), FALSE)), VALA_CCODE_EXPRESSION ((_tmp125 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
				(_tmp125 == NULL ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL)));
				vala_invocation_expression_set_delegate_target (expr, VALA_CCODE_EXPRESSION (temp_ref));
				(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
				(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
		}
	}
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (expr))) {
		ValaCCodeUnaryExpression* _tmp127;
		ValaCCodeIdentifier* _tmp126;
		/* method can fail*/
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_method_inner_error = TRUE;
		/* add &inner_error before the ellipsis arguments*/
		_tmp127 = NULL;
		_tmp126 = NULL;
		gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-2)), FALSE)), VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_identifier_new ("inner_error")))))));
		(_tmp127 == NULL ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)));
		(_tmp126 == NULL ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL)));
	}
	if (ellipsis) {
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (!vala_method_get_printf_format (m) && _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0) {
			ValaCCodeConstant* _tmp128;
			_tmp128 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_constant_new (vala_method_get_sentinel (m)))));
			(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp129;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp130;
			ValaDelegate* d;
			_tmp129 = NULL;
			deleg_type = (_tmp129 = VALA_DELEGATE_TYPE (itype), (_tmp129 == NULL ? NULL : vala_code_node_ref (_tmp129)));
			_tmp130 = NULL;
			d = (_tmp130 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp130 == NULL ? NULL : vala_code_node_ref (_tmp130)));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp131;
				_tmp131 = NULL;
				gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_delegate_get_cinstance_parameter_position (d), FALSE)), (_tmp131 = vala_ccode_generator_get_delegate_target_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_invocation_expression_get_call (expr))));
				(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
			}
			(deleg_type == NULL ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL)));
			(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
		}
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	_tmp132 = NULL;
	if ((_tmp133 = VALA_IS_SIGNAL_TYPE (itype) && !(VALA_IS_VOID_TYPE ((_tmp132 = vala_data_type_get_return_type (itype)))), (_tmp132 == NULL ? NULL : (_tmp132 = (vala_code_node_unref (_tmp132), NULL))), _tmp133)) {
		ValaSignal* _tmp134;
		ValaSignal* sig;
		_tmp134 = NULL;
		sig = (_tmp134 = vala_signal_type_get_signal_symbol ((VALA_SIGNAL_TYPE (itype))), (_tmp134 == NULL ? NULL : vala_code_node_ref (_tmp134)));
		if (!vala_signal_get_has_emitter (sig)) {
			ValaDataType* _tmp135;
			ValaLocalVariable* _tmp136;
			ValaLocalVariable* temp_var;
			ValaCCodeIdentifier* temp_ref;
			ValaCCodeUnaryExpression* _tmp137;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeExpression* _tmp139;
			ValaCCodeExpression* _tmp138;
			_tmp135 = NULL;
			_tmp136 = NULL;
			temp_var = (_tmp136 = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp135 = vala_data_type_get_return_type (itype)), TRUE, NULL), (_tmp135 == NULL ? NULL : (_tmp135 = (vala_code_node_unref (_tmp135), NULL))), _tmp136);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
			_tmp137 = NULL;
			gee_map_set (GEE_MAP (carg_map), GINT_TO_POINTER (vala_ccode_generator_get_param_pos (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ((double) (-1)), TRUE)), VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp137 == NULL ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp139 = NULL;
			_tmp138 = NULL;
			ccall_expr = (_tmp139 = (_tmp138 = VALA_CCODE_EXPRESSION (ccomma), (_tmp138 == NULL ? NULL : vala_ccode_node_ref (_tmp138))), (ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL))), _tmp139);
			(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		}
		(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
	}
	/* append C arguments in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeExpression* _tmp140;
		min_pos = -1;
		{
			GeeSet* pos_collection;
			GeeIterator* pos_it;
			pos_collection = gee_map_get_keys (GEE_MAP (carg_map));
			pos_it = gee_iterable_iterator (GEE_ITERABLE (pos_collection));
			while (gee_iterator_next (pos_it)) {
				gint pos;
				pos = GPOINTER_TO_INT (gee_iterator_get (pos_it));
				{
					if (pos > last_pos && (min_pos == -1 || pos < min_pos)) {
						min_pos = pos;
					}
				}
			}
			(pos_it == NULL ? NULL : (pos_it = (gee_collection_object_unref (pos_it), NULL)));
			(pos_collection == NULL ? NULL : (pos_collection = (gee_collection_object_unref (pos_collection), NULL)));
		}
		if (min_pos == -1) {
			break;
		}
		_tmp140 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp140 = ((ValaCCodeExpression*) (gee_map_get (GEE_MAP (carg_map), GINT_TO_POINTER (min_pos))))));
		(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
		last_pos = min_pos;
	}
	if (m != NULL && vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* _tmp141;
		_tmp141 = NULL;
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp141 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp141 == NULL ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_data_type_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_data_type_get_data_type (vala_expression_get_value_type (VALA_EXPRESSION (expr))) != NULL) {
			ValaCCodeExpression* _tmp142;
			_tmp142 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp142 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), ccall_expr, vala_expression_get_value_type (VALA_EXPRESSION (expr))))));
			(_tmp142 == NULL ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL)));
		} else {
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall_expr));
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp143;
		GeeIterator* _tmp144;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp146;
		ValaExpression* _tmp145;
		ValaCCodeExpression* _tmp147;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp148;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp149;
		ValaArrayType* array_type;
		char* _tmp151;
		char* _tmp150;
		ValaCCodeIdentifier* _tmp152;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* _tmp153;
		ValaCCodeParenthesizedExpression* _tmp154;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp155;
		ValaCCodeFunctionCall* _tmp156;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp157;
		ValaCCodeConstant* _tmp158;
		ValaCCodeBinaryExpression* _tmp159;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp160;
		ValaCCodeConditionalExpression* _tmp162;
		ValaCCodeConstant* _tmp161;
		ValaCCodeAssignment* _tmp164;
		ValaCCodeExpression* _tmp163;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp143 = NULL;
		_tmp144 = NULL;
		arg_it = (_tmp144 = gee_iterable_iterator (GEE_ITERABLE ((_tmp143 = vala_invocation_expression_get_argument_list (expr)))), (_tmp143 == NULL ? NULL : (_tmp143 = (gee_collection_object_unref (_tmp143), NULL))), _tmp144);
		gee_iterator_next (arg_it);
		_tmp146 = NULL;
		_tmp145 = NULL;
		_tmp147 = NULL;
		new_size = (_tmp147 = (_tmp146 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp145 = ((ValaExpression*) (gee_iterator_get (arg_it))))))), (_tmp146 == NULL ? NULL : vala_ccode_node_ref (_tmp146))), (_tmp145 == NULL ? NULL : (_tmp145 = (vala_code_node_unref (_tmp145), NULL))), _tmp147);
		temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->int_type, TRUE, NULL);
		temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
		gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
		/* memset needs string.h */
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_h_needed = TRUE;
		clen = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1);
		_tmp148 = NULL;
		celems = (_tmp148 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (_tmp148 == NULL ? NULL : vala_ccode_node_ref (_tmp148)));
		_tmp149 = NULL;
		array_type = (_tmp149 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp149 == NULL ? NULL : vala_code_node_ref (_tmp149)));
		_tmp151 = NULL;
		_tmp150 = NULL;
		_tmp152 = NULL;
		csizeof = (_tmp152 = vala_ccode_identifier_new ((_tmp151 = g_strdup_printf ("sizeof (%s)", (_tmp150 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))), (_tmp151 = (g_free (_tmp151), NULL)), (_tmp150 = (g_free (_tmp150), NULL)), _tmp152);
		_tmp153 = NULL;
		_tmp154 = NULL;
		cdelta = (_tmp154 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION ((_tmp153 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)))), (_tmp153 == NULL ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL))), _tmp154);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		_tmp155 = NULL;
		_tmp156 = NULL;
		czero = (_tmp156 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp155 = vala_ccode_identifier_new ("memset")))), (_tmp155 == NULL ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL))), _tmp156);
		_tmp157 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(_tmp157 == NULL ? NULL : (_tmp157 = (vala_ccode_node_unref (_tmp157), NULL)));
		_tmp158 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_constant_new ("0"))));
		(_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL)));
		_tmp159 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((_tmp159 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(_tmp159 == NULL ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL)));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp160 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		_tmp162 = NULL;
		_tmp161 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_constant_new ("NULL")))))));
		(_tmp162 == NULL ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)));
		(_tmp161 == NULL ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL)));
		_tmp164 = NULL;
		_tmp163 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_assignment_new ((_tmp163 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (ma), 1)), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(_tmp164 == NULL ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)));
		(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
		vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
		(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
		(new_size == NULL ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
		(clen == NULL ? NULL : (clen = (vala_ccode_node_unref (clen), NULL)));
		(celems == NULL ? NULL : (celems = (vala_ccode_node_unref (celems), NULL)));
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (vala_ccode_node_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
	} else {
		if (m == vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->substring_method) {
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			GeeList* args;
			ValaCCodeIdentifier* _tmp165;
			ValaCCodeFunctionCall* _tmp166;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeExpression* _tmp167;
			ValaCCodeExpression* _tmp168;
			ValaCCodeIdentifier* _tmp169;
			ValaCCodeFunctionCall* _tmp170;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeExpression* _tmp171;
			ValaCCodeIdentifier* _tmp172;
			ValaCCodeFunctionCall* _tmp173;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* _tmp174;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp175;
			temp_decl = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type, TRUE, NULL);
			temp_ref = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_decl)));
			gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_decl);
			args = vala_ccode_function_call_get_arguments (ccall);
			_tmp165 = NULL;
			_tmp166 = NULL;
			coffsetcall = (_tmp166 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp165 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL))), _tmp166);
			/* full string*/
			_tmp167 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp167 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 0)))));
			(_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL)));
			/* offset*/
			_tmp168 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall, (_tmp168 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 1)))));
			(_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL)));
			_tmp169 = NULL;
			_tmp170 = NULL;
			coffsetcall2 = (_tmp170 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp169 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp169 == NULL ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL))), _tmp170);
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			_tmp171 = NULL;
			vala_ccode_function_call_add_argument (coffsetcall2, (_tmp171 = ((ValaCCodeExpression*) (gee_list_get (((GeeList*) (args)), 2)))));
			(_tmp171 == NULL ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL)));
			_tmp172 = NULL;
			_tmp173 = NULL;
			cndupcall = (_tmp173 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp172 = vala_ccode_identifier_new ("g_strndup")))), (_tmp172 == NULL ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL))), _tmp173);
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			_tmp174 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((_tmp174 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(_tmp174 == NULL ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL)));
			ccomma = vala_ccode_comma_expression_new ();
			_tmp175 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(_tmp175 == NULL ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
			(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (vala_ccode_node_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (vala_ccode_node_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (vala_ccode_node_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		}
	}
	(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
	(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	(itype == NULL ? NULL : (itype = (vala_code_node_unref (itype), NULL)));
	(ccall_expr == NULL ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)));
	(carg_map == NULL ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)));
	(instance == NULL ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)));
	(params_it == NULL ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL)));
}


ValaInvocationExpression* vala_ccode_invocation_expression_binding_get_invocation_expression (ValaCCodeInvocationExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self), NULL);
	return self->priv->_invocation_expression;
}


void vala_ccode_invocation_expression_binding_set_invocation_expression (ValaCCodeInvocationExpressionBinding* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_INVOCATION_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (vala_code_node_unref (self->priv->_invocation_expression), NULL))), _tmp2);
}


static void vala_ccode_invocation_expression_binding_class_init (ValaCCodeInvocationExpressionBindingClass * klass) {
	vala_ccode_invocation_expression_binding_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_BINDING_CLASS (klass)->finalize = vala_ccode_invocation_expression_binding_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeInvocationExpressionBindingPrivate));
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_invocation_expression_binding_real_emit;
}


static void vala_ccode_invocation_expression_binding_instance_init (ValaCCodeInvocationExpressionBinding * self) {
	self->priv = VALA_CCODE_INVOCATION_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_invocation_expression_binding_finalize (ValaCodeBinding* obj) {
	ValaCCodeInvocationExpressionBinding * self;
	self = VALA_CCODE_INVOCATION_EXPRESSION_BINDING (obj);
	(self->priv->_invocation_expression == NULL ? NULL : (self->priv->_invocation_expression = (vala_code_node_unref (self->priv->_invocation_expression), NULL)));
	VALA_CODE_BINDING_CLASS (vala_ccode_invocation_expression_binding_parent_class)->finalize (obj);
}


GType vala_ccode_invocation_expression_binding_get_type (void) {
	static GType vala_ccode_invocation_expression_binding_type_id = 0;
	if (vala_ccode_invocation_expression_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeInvocationExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_invocation_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeInvocationExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_invocation_expression_binding_instance_init, NULL };
		vala_ccode_invocation_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeInvocationExpressionBinding", &g_define_type_info, 0);
	}
	return vala_ccode_invocation_expression_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




