/* valaparenthesizedexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaparenthesizedexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaParenthesizedExpressionPrivate {
	ValaExpression* _inner;
};

#define VALA_PARENTHESIZED_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARENTHESIZED_EXPRESSION, ValaParenthesizedExpressionPrivate))
enum  {
	VALA_PARENTHESIZED_EXPRESSION_DUMMY_PROPERTY
};
static void vala_parenthesized_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_parenthesized_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_parenthesized_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_parenthesized_expression_real_is_pure (ValaExpression* base);
static gpointer vala_parenthesized_expression_parent_class = NULL;
static void vala_parenthesized_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new parenthesized expression.
 *
 * @param inner  an expression
 * @param source reference to source code
 * @return       newly created parenthesized expression
 */
ValaParenthesizedExpression* vala_parenthesized_expression_construct (GType object_type, ValaExpression* _inner, ValaSourceReference* source) {
	ValaParenthesizedExpression* self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (_inner), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = ((ValaParenthesizedExpression*) (g_type_create_instance (object_type)));
	vala_parenthesized_expression_set_inner (self, _inner);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


ValaParenthesizedExpression* vala_parenthesized_expression_new (ValaExpression* _inner, ValaSourceReference* source) {
	return vala_parenthesized_expression_construct (VALA_TYPE_PARENTHESIZED_EXPRESSION, _inner, source);
}


static void vala_parenthesized_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParenthesizedExpression * self;
	self = VALA_PARENTHESIZED_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_parenthesized_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, VALA_EXPRESSION (self));
}


static void vala_parenthesized_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParenthesizedExpression * self;
	self = VALA_PARENTHESIZED_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_parenthesized_expression_get_inner (self)), visitor);
}


static void vala_parenthesized_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaParenthesizedExpression * self;
	self = VALA_PARENTHESIZED_EXPRESSION (base);
	g_return_if_fail (VALA_IS_EXPRESSION (old_node));
	g_return_if_fail (VALA_IS_EXPRESSION (new_node));
	if (vala_parenthesized_expression_get_inner (self) == old_node) {
		vala_parenthesized_expression_set_inner (self, new_node);
	}
}


static gboolean vala_parenthesized_expression_real_is_pure (ValaExpression* base) {
	ValaParenthesizedExpression * self;
	self = VALA_PARENTHESIZED_EXPRESSION (base);
	return vala_expression_is_pure (vala_parenthesized_expression_get_inner (self));
}


ValaExpression* vala_parenthesized_expression_get_inner (ValaParenthesizedExpression* self) {
	g_return_val_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_parenthesized_expression_set_inner (ValaParenthesizedExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_inner), VALA_CODE_NODE (self));
}


static void vala_parenthesized_expression_class_init (ValaParenthesizedExpressionClass * klass) {
	vala_parenthesized_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_parenthesized_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaParenthesizedExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_parenthesized_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_parenthesized_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_parenthesized_expression_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_parenthesized_expression_real_is_pure;
}


static void vala_parenthesized_expression_instance_init (ValaParenthesizedExpression * self) {
	self->priv = VALA_PARENTHESIZED_EXPRESSION_GET_PRIVATE (self);
}


static void vala_parenthesized_expression_finalize (ValaCodeNode* obj) {
	ValaParenthesizedExpression * self;
	self = VALA_PARENTHESIZED_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)));
	VALA_CODE_NODE_CLASS (vala_parenthesized_expression_parent_class)->finalize (obj);
}


GType vala_parenthesized_expression_get_type (void) {
	static GType vala_parenthesized_expression_type_id = 0;
	if (vala_parenthesized_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParenthesizedExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parenthesized_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParenthesizedExpression), 0, (GInstanceInitFunc) vala_parenthesized_expression_instance_init, NULL };
		vala_parenthesized_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaParenthesizedExpression", &g_define_type_info, 0);
	}
	return vala_parenthesized_expression_type_id;
}




