/* valaswitchlabel.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaswitchlabel.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaSwitchLabelPrivate {
	ValaExpression* _expression;
};

#define VALA_SWITCH_LABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelPrivate))
enum  {
	VALA_SWITCH_LABEL_DUMMY_PROPERTY
};
static void vala_switch_label_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_switch_label_parent_class = NULL;
static void vala_switch_label_finalize (ValaCodeNode* obj);



/**
 * Creates a new switch case label.
 *
 * @param expr   label expression
 * @param source reference to source code
 * @return       newly created switch case label
 */
ValaSwitchLabel* vala_switch_label_construct (GType object_type, ValaExpression* expr, ValaSourceReference* source) {
	ValaSwitchLabel* self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = ((ValaSwitchLabel*) (g_type_create_instance (object_type)));
	vala_switch_label_set_expression (self, expr);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


ValaSwitchLabel* vala_switch_label_new (ValaExpression* expr, ValaSourceReference* source) {
	return vala_switch_label_construct (VALA_TYPE_SWITCH_LABEL, expr, source);
}


/**
 * Creates a new switch default label.
 *
 * @param source reference to source code
 * @return       newly created switch default label
 */
ValaSwitchLabel* vala_switch_label_construct_with_default (GType object_type, ValaSourceReference* source) {
	ValaSwitchLabel* self;
	g_return_val_if_fail (source == NULL || VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = ((ValaSwitchLabel*) (g_type_create_instance (object_type)));
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


ValaSwitchLabel* vala_switch_label_new_with_default (ValaSourceReference* source) {
	return vala_switch_label_construct_with_default (VALA_TYPE_SWITCH_LABEL, source);
}


static void vala_switch_label_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchLabel * self;
	self = VALA_SWITCH_LABEL (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (self->priv->_expression != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (self->priv->_expression), visitor);
		vala_code_visitor_visit_end_full_expression (visitor, self->priv->_expression);
	}
	vala_code_visitor_visit_switch_label (visitor, self);
}


ValaExpression* vala_switch_label_get_expression (ValaSwitchLabel* self) {
	g_return_val_if_fail (VALA_IS_SWITCH_LABEL (self), NULL);
	return self->priv->_expression;
}


void vala_switch_label_set_expression (ValaSwitchLabel* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_SWITCH_LABEL (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_code_node_unref (self->priv->_expression), NULL))), _tmp2);
}


static void vala_switch_label_class_init (ValaSwitchLabelClass * klass) {
	vala_switch_label_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_switch_label_finalize;
	g_type_class_add_private (klass, sizeof (ValaSwitchLabelPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_switch_label_real_accept;
}


static void vala_switch_label_instance_init (ValaSwitchLabel * self) {
	self->priv = VALA_SWITCH_LABEL_GET_PRIVATE (self);
}


static void vala_switch_label_finalize (ValaCodeNode* obj) {
	ValaSwitchLabel * self;
	self = VALA_SWITCH_LABEL (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_code_node_unref (self->priv->_expression), NULL)));
	VALA_CODE_NODE_CLASS (vala_switch_label_parent_class)->finalize (obj);
}


GType vala_switch_label_get_type (void) {
	static GType vala_switch_label_type_id = 0;
	if (vala_switch_label_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchLabel), 0, (GInstanceInitFunc) vala_switch_label_instance_init, NULL };
		vala_switch_label_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchLabel", &g_define_type_info, 0);
	}
	return vala_switch_label_type_id;
}




