/* valasymbol.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASYMBOL_H__
#define __VALA_VALASYMBOL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/list.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

/**
 * Represents a node in the symbol tree.
 */
struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeList* (*get_cheader_filenames) (ValaSymbol* self);
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;


gboolean vala_symbol_is_internal_symbol (ValaSymbol* self);
void vala_symbol_init (ValaSymbol* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
GeeList* vala_symbol_get_cheader_filenames (ValaSymbol* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
char* vala_symbol_lower_case_to_camel_case (const char* lower_case);
ValaScope* vala_symbol_get_top_accessible_scope (ValaSymbol* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
ValaScope* vala_symbol_get_owner (ValaSymbol* self);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
gboolean vala_symbol_get_active (ValaSymbol* self);
void vala_symbol_set_active (ValaSymbol* self, gboolean value);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
void vala_symbol_set_external (ValaSymbol* self, gboolean value);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
GType vala_symbol_get_type (void);
GType vala_symbol_accessibility_get_type (void);


G_END_DECLS

#endif
