/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_compiler_parent_class = NULL;

static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);


ValaCCodeCompiler*
vala_ccode_compiler_construct (GType object_type)
{
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeCompiler*
vala_ccode_compiler_new (void)
{
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}


/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void
vala_ccode_compiler_compile (ValaCCodeCompiler* self,
                             ValaCodeContext* context,
                             const gchar* cc_command,
                             gchar** cc_options,
                             int cc_options_length1)
{
	gchar* pc = NULL;
	gchar* _tmp0_;
	gchar* pkgflags = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* cmdline = NULL;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	ValaList* source_files = NULL;
	ValaList* _tmp54_;
	ValaList* c_source_files = NULL;
	ValaList* _tmp78_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gboolean _tmp112_;
	gboolean _tmp113_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_strdup (" gobject-2.0");
	pc = _tmp0_;
	{
		ValaList* _pkg_list = NULL;
		ValaList* _tmp1_;
		gint _pkg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pkg_index = 0;
		_tmp1_ = vala_code_context_get_packages (context);
		_pkg_list = _tmp1_;
		_tmp2_ = _pkg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pkg_size = _tmp4_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* pkg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			const gchar* _tmp11_;
			_tmp5_ = _pkg_index;
			_pkg_index = _tmp5_ + 1;
			_tmp6_ = _pkg_index;
			_tmp7_ = _pkg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pkg_list;
			_tmp9_ = _pkg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			pkg = (gchar*) _tmp10_;
			_tmp11_ = pkg;
			if (vala_code_context_pkg_config_exists (context, _tmp11_)) {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp12_ = pc;
				_tmp13_ = pkg;
				_tmp14_ = g_strconcat (" ", _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
				_g_free0 (pc);
				pc = _tmp16_;
				_g_free0 (_tmp15_);
			}
			_g_free0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	_tmp17_ = pc;
	_tmp18_ = vala_code_context_pkg_config_compile_flags (context, _tmp17_);
	pkgflags = _tmp18_;
	_tmp19_ = pkgflags;
	if (_tmp19_ == NULL) {
		_g_free0 (pkgflags);
		_g_free0 (pc);
		return;
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp20_ = g_strdup (cc_command);
	cmdline = _tmp20_;
	_tmp21_ = vala_code_context_get_debug (context);
	_tmp22_ = _tmp21_;
	if (_tmp22_) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = cmdline;
		_tmp24_ = g_strconcat (_tmp23_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp24_;
	}
	_tmp25_ = vala_code_context_get_compile_only (context);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = cmdline;
		_tmp28_ = g_strconcat (_tmp27_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp28_;
	} else {
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = vala_code_context_get_output (context);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			gchar* output = NULL;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_ = FALSE;
			gboolean _tmp35_ = FALSE;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp31_ = vala_code_context_get_output (context);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup (_tmp32_);
			output = _tmp33_;
			_tmp36_ = vala_code_context_get_directory (context);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				_tmp38_ = vala_code_context_get_directory (context);
				_tmp39_ = _tmp38_;
				_tmp35_ = g_strcmp0 (_tmp39_, "") != 0;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp40_ = vala_code_context_get_output (context);
				_tmp41_ = _tmp40_;
				_tmp34_ = !g_path_is_absolute (_tmp41_);
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				_tmp42_ = vala_code_context_get_directory (context);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_code_context_get_output (context);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strdup_printf ("%s%c%s", _tmp43_, (gint) G_DIR_SEPARATOR, _tmp45_);
				_g_free0 (output);
				output = _tmp46_;
			}
			_tmp47_ = cmdline;
			_tmp48_ = output;
			_tmp49_ = g_shell_quote (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (" -o ", _tmp50_, NULL);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strconcat (_tmp47_, _tmp52_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp53_;
			_g_free0 (_tmp52_);
			_g_free0 (_tmp50_);
			_g_free0 (output);
		}
	}
	_tmp54_ = vala_code_context_get_source_files (context);
	source_files = _tmp54_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp55_;
		ValaList* _tmp56_;
		gint _file_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _file_index = 0;
		_tmp55_ = source_files;
		_tmp56_ = _vala_iterable_ref0 (_tmp55_);
		_file_list = _tmp56_;
		_tmp57_ = _file_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_file_size = _tmp59_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaSourceFile* _tmp66_;
			ValaSourceFileType _tmp67_;
			ValaSourceFileType _tmp68_;
			_tmp60_ = _file_index;
			_file_index = _tmp60_ + 1;
			_tmp61_ = _file_index;
			_tmp62_ = _file_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _file_list;
			_tmp64_ = _file_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			file = (ValaSourceFile*) _tmp65_;
			_tmp66_ = file;
			_tmp67_ = vala_source_file_get_file_type (_tmp66_);
			_tmp68_ = _tmp67_;
			if (_tmp68_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp69_;
				ValaSourceFile* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp69_ = cmdline;
				_tmp70_ = file;
				_tmp71_ = vala_source_file_get_csource_filename (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_shell_quote (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strconcat (" ", _tmp74_, NULL);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_strconcat (_tmp69_, _tmp76_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp77_;
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp72_);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp78_ = vala_code_context_get_c_source_files (context);
	c_source_files = _tmp78_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp79_;
		ValaList* _tmp80_;
		gint _file_size = 0;
		ValaList* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		gint _file_index = 0;
		_tmp79_ = c_source_files;
		_tmp80_ = _vala_iterable_ref0 (_tmp79_);
		_file_list = _tmp80_;
		_tmp81_ = _file_list;
		_tmp82_ = vala_collection_get_size ((ValaCollection*) _tmp81_);
		_tmp83_ = _tmp82_;
		_file_size = _tmp83_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gchar* file = NULL;
			ValaList* _tmp87_;
			gint _tmp88_;
			gpointer _tmp89_;
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			_tmp84_ = _file_index;
			_file_index = _tmp84_ + 1;
			_tmp85_ = _file_index;
			_tmp86_ = _file_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _file_list;
			_tmp88_ = _file_index;
			_tmp89_ = vala_list_get (_tmp87_, _tmp88_);
			file = (gchar*) _tmp89_;
			_tmp90_ = cmdline;
			_tmp91_ = file;
			_tmp92_ = g_shell_quote (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = g_strconcat (" ", _tmp93_, NULL);
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strconcat (_tmp90_, _tmp95_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp96_;
			_g_free0 (_tmp95_);
			_g_free0 (_tmp93_);
			_g_free0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp97_ = cmdline;
	_tmp98_ = pkgflags;
	_tmp99_ = string_strip (_tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = g_strconcat (" ", _tmp100_, NULL);
	_tmp102_ = _tmp101_;
	_tmp103_ = g_strconcat (_tmp97_, _tmp102_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp103_;
	_g_free0 (_tmp102_);
	_g_free0 (_tmp100_);
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_options_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp104_;
			gchar* cc_option = NULL;
			_tmp104_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp104_;
			{
				const gchar* _tmp105_;
				const gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				_tmp105_ = cmdline;
				_tmp106_ = cc_option;
				_tmp107_ = g_shell_quote (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = g_strconcat (" ", _tmp108_, NULL);
				_tmp110_ = _tmp109_;
				_tmp111_ = g_strconcat (_tmp105_, _tmp110_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp111_;
				_g_free0 (_tmp110_);
				_g_free0 (_tmp108_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp112_ = vala_code_context_get_verbose_mode (context);
	_tmp113_ = _tmp112_;
	if (_tmp113_) {
		FILE* _tmp114_;
		const gchar* _tmp115_;
		_tmp114_ = stdout;
		_tmp115_ = cmdline;
		fprintf (_tmp114_, "%s\n", _tmp115_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp116_;
		gint _tmp117_ = 0;
		gint _tmp118_;
		_tmp116_ = cmdline;
		g_spawn_command_line_sync (_tmp116_, NULL, NULL, &_tmp117_, &_inner_error0_);
		exit_status = _tmp117_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp118_ = exit_status;
		if (_tmp118_ != 0) {
			gint _tmp119_;
			gchar* _tmp120_;
			gchar* _tmp121_;
			_tmp119_ = exit_status;
			_tmp120_ = g_strdup_printf ("cc exited with status %d", _tmp119_);
			_tmp121_ = _tmp120_;
			vala_report_error (NULL, _tmp121_);
			_g_free0 (_tmp121_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp122_;
		const gchar* _tmp123_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp122_ = e;
		_tmp123_ = _tmp122_->message;
		vala_report_error (NULL, _tmp123_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp124_;
		ValaList* _tmp125_;
		gint _file_size = 0;
		ValaList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _file_index = 0;
		_tmp124_ = source_files;
		_tmp125_ = _vala_iterable_ref0 (_tmp124_);
		_file_list = _tmp125_;
		_tmp126_ = _file_list;
		_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
		_tmp128_ = _tmp127_;
		_file_size = _tmp128_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp132_;
			gint _tmp133_;
			gpointer _tmp134_;
			ValaSourceFile* _tmp135_;
			ValaSourceFileType _tmp136_;
			ValaSourceFileType _tmp137_;
			_tmp129_ = _file_index;
			_file_index = _tmp129_ + 1;
			_tmp130_ = _file_index;
			_tmp131_ = _file_size;
			if (!(_tmp130_ < _tmp131_)) {
				break;
			}
			_tmp132_ = _file_list;
			_tmp133_ = _file_index;
			_tmp134_ = vala_list_get (_tmp132_, _tmp133_);
			file = (ValaSourceFile*) _tmp134_;
			_tmp135_ = file;
			_tmp136_ = vala_source_file_get_file_type (_tmp135_);
			_tmp137_ = _tmp136_;
			if (_tmp137_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				gboolean _tmp138_;
				gboolean _tmp139_;
				_tmp138_ = vala_code_context_get_save_csources (context);
				_tmp139_ = _tmp138_;
				if (!_tmp139_) {
					ValaSourceFile* _tmp140_;
					gchar* _tmp141_;
					gchar* _tmp142_;
					_tmp140_ = file;
					_tmp141_ = vala_source_file_get_csource_filename (_tmp140_);
					_tmp142_ = _tmp141_;
					g_unlink (_tmp142_);
					_g_free0 (_tmp142_);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}


static void
vala_value_ccode_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_ccode_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_ccode_compiler_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_ccode_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_ccode_compiler_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_ccode_compiler_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_ccode_compiler (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_ccode_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_ccode_compiler (GValue* value,
                               gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


void
vala_value_take_ccode_compiler (GValue* value,
                                gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}


static void
vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass)
{
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}


static void
vala_ccode_compiler_instance_init (ValaCCodeCompiler * self)
{
	self->ref_count = 1;
}


static void
vala_ccode_compiler_finalize (ValaCCodeCompiler * obj)
{
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}


/**
 * Interface to the C compiler.
 */
GType
vala_ccode_compiler_get_type (void)
{
	static volatile gsize vala_ccode_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_compiler_type_id__volatile, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__volatile;
}


gpointer
vala_ccode_compiler_ref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_ccode_compiler_unref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



