/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp283_ = FALSE;
	ValaMethod* _tmp284_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp455_;
	ValaCCodeExpression* _tmp456_;
	ValaMethod* _tmp457_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp481_ = FALSE;
	ValaMethod* _tmp482_;
	gboolean _tmp638_ = FALSE;
	ValaMethod* _tmp639_;
	ValaMethod* _tmp691_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp887_;
	ValaIterator* _tmp888_;
	ValaIterator* _tmp1282_;
	gboolean _tmp1292_ = FALSE;
	gboolean _tmp1293_ = FALSE;
	ValaMethod* _tmp1294_;
	gboolean _tmp1419_ = FALSE;
	ValaDelegate* _tmp1420_;
	gboolean _tmp1517_ = FALSE;
	ValaMethod* _tmp1518_;
	gboolean _tmp1534_;
	gboolean _tmp1535_;
	gboolean _tmp1550_;
	ValaDataType* _tmp1575_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1599_;
	ValaDataType* _tmp1600_;
	ValaDataType* _tmp1601_;
	gboolean _tmp1602_;
	gboolean _tmp1603_ = FALSE;
	ValaDataType* _tmp1604_;
	ValaCCodeFunctionCall* _tmp1633_;
	ValaCCodeFunctionCall* _tmp1634_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1635_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1650_;
	ValaCCodeFunctionCall* _tmp1651_;
	ValaCCodeFunctionCall* _tmp1675_;
	gboolean _tmp1699_;
	gboolean _tmp1700_;
	gboolean _tmp1726_;
	gboolean _tmp1727_;
	gboolean _tmp1757_;
	gboolean _tmp1763_ = FALSE;
	gboolean _tmp1764_ = FALSE;
	ValaMethod* _tmp1765_;
	gboolean _tmp1803_ = FALSE;
	gboolean _tmp1804_ = FALSE;
	ValaMethod* _tmp1805_;
	ValaMethod* _tmp1824_;
	gboolean _tmp1941_ = FALSE;
	ValaCodeNode* _tmp1942_;
	ValaCodeNode* _tmp1943_;
	ValaList* _tmp2019_;
	ValaIterator* _tmp2020_;
	gboolean _tmp2098_ = FALSE;
	gboolean _tmp2099_ = FALSE;
	ValaMethod* _tmp2100_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaMethod* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeIdentifier* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					ValaCCodeMemberAccess* _tmp282_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = m;
					_tmp279_ = vala_ccode_identifier_new ("_data_");
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp280_, "_res_");
					_tmp282_ = _tmp281_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp278_), FALSE)), (ValaCCodeExpression*) _tmp282_);
					_vala_ccode_node_unref0 (_tmp282_);
					_vala_ccode_node_unref0 (_tmp280_);
				}
			}
		}
	}
	_tmp284_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp284_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp285_;
		ValaSymbol* _tmp286_;
		ValaSymbol* _tmp287_;
		_tmp285_ = m;
		_tmp286_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp285_);
		_tmp287_ = _tmp286_;
		_tmp283_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp287_, VALA_TYPE_CLASS);
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		ValaMethod* _tmp288_;
		ValaSymbol* _tmp289_;
		ValaSymbol* _tmp290_;
		gboolean _tmp291_;
		gboolean _tmp292_;
		ValaClass* _tmp296_;
		ValaClass* _tmp297_;
		gboolean _tmp298_;
		gboolean _tmp299_;
		_tmp288_ = m;
		_tmp289_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_CLASS, ValaClass));
		_tmp292_ = _tmp291_;
		if (!_tmp292_) {
			ValaCCodeFunctionCall* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			ValaCCodeExpression* _tmp295_;
			_tmp293_ = ccall;
			_tmp294_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp293_, _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
		}
		_tmp296_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp297_ = _tmp296_;
		_tmp298_ = vala_class_get_is_compact (_tmp297_);
		_tmp299_ = _tmp298_;
		if (!_tmp299_) {
			ValaClass* _tmp300_;
			ValaClass* _tmp301_;
			ValaMethod* _tmp302_;
			ValaSymbol* _tmp303_;
			ValaSymbol* _tmp304_;
			_tmp300_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = m;
			_tmp303_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp302_);
			_tmp304_ = _tmp303_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp304_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp305_;
					ValaClass* _tmp306_;
					ValaList* _tmp307_;
					gint _base_type_size = 0;
					ValaList* _tmp308_;
					gint _tmp309_;
					gint _tmp310_;
					gint _base_type_index = 0;
					_tmp305_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_class_get_base_types (_tmp306_);
					_base_type_list = _tmp307_;
					_tmp308_ = _base_type_list;
					_tmp309_ = vala_collection_get_size ((ValaCollection*) _tmp308_);
					_tmp310_ = _tmp309_;
					_base_type_size = _tmp310_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp311_;
						gint _tmp312_;
						gint _tmp313_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp314_;
						gint _tmp315_;
						gpointer _tmp316_;
						ValaDataType* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						ValaTypeSymbol* _tmp319_;
						_tmp311_ = _base_type_index;
						_base_type_index = _tmp311_ + 1;
						_tmp312_ = _base_type_index;
						_tmp313_ = _base_type_size;
						if (!(_tmp312_ < _tmp313_)) {
							break;
						}
						_tmp314_ = _base_type_list;
						_tmp315_ = _base_type_index;
						_tmp316_ = vala_list_get (_tmp314_, _tmp315_);
						base_type = (ValaDataType*) _tmp316_;
						_tmp317_ = base_type;
						_tmp318_ = vala_data_type_get_data_type (_tmp317_);
						_tmp319_ = _tmp318_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp320_;
							gchar* _tmp321_;
							gchar* _tmp322_;
							gboolean _tmp323_;
							ValaHashMap* _tmp328_;
							ValaDataType* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							ValaList* _tmp332_;
							type_parameters = NULL;
							_tmp320_ = m;
							_tmp321_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp320_);
							_tmp322_ = _tmp321_;
							_tmp323_ = g_strcmp0 (_tmp322_, "g_object_new") == 0;
							_g_free0 (_tmp322_);
							if (_tmp323_) {
								ValaDataType* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaTypeSymbol* _tmp326_;
								ValaList* _tmp327_;
								_tmp324_ = base_type;
								_tmp325_ = vala_data_type_get_data_type (_tmp324_);
								_tmp326_ = _tmp325_;
								_tmp327_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp327_;
							}
							_tmp328_ = in_arg_map;
							_tmp329_ = base_type;
							_tmp330_ = vala_data_type_get_type_arguments (_tmp329_);
							_tmp331_ = _tmp330_;
							_tmp332_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp328_, _tmp331_, (ValaCodeNode*) expr, TRUE, _tmp332_);
							_vala_iterable_unref0 (_tmp331_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaSymbol* _tmp335_;
				ValaClass* _tmp336_;
				type_param_index = 0;
				_tmp333_ = m;
				_tmp334_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp333_);
				_tmp335_ = _tmp334_;
				_tmp336_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp336_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp337_;
					ValaList* _tmp338_;
					gint _type_param_size = 0;
					ValaList* _tmp339_;
					gint _tmp340_;
					gint _tmp341_;
					gint _type_param_index = 0;
					_tmp337_ = cl;
					_tmp338_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp337_);
					_type_param_list = _tmp338_;
					_tmp339_ = _type_param_list;
					_tmp340_ = vala_collection_get_size ((ValaCollection*) _tmp339_);
					_tmp341_ = _tmp340_;
					_type_param_size = _tmp341_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp342_;
						gint _tmp343_;
						gint _tmp344_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp345_;
						gint _tmp346_;
						gpointer _tmp347_;
						ValaHashMap* _tmp348_;
						gint _tmp349_;
						ValaTypeParameter* _tmp350_;
						const gchar* _tmp351_;
						const gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaCCodeIdentifier* _tmp358_;
						ValaHashMap* _tmp359_;
						gint _tmp360_;
						ValaTypeParameter* _tmp361_;
						const gchar* _tmp362_;
						const gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						ValaHashMap* _tmp370_;
						gint _tmp371_;
						ValaTypeParameter* _tmp372_;
						const gchar* _tmp373_;
						const gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						gchar* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						ValaCCodeIdentifier* _tmp380_;
						gint _tmp381_;
						_tmp342_ = _type_param_index;
						_type_param_index = _tmp342_ + 1;
						_tmp343_ = _type_param_index;
						_tmp344_ = _type_param_size;
						if (!(_tmp343_ < _tmp344_)) {
							break;
						}
						_tmp345_ = _type_param_list;
						_tmp346_ = _type_param_index;
						_tmp347_ = vala_list_get (_tmp345_, _tmp346_);
						type_param = (ValaTypeParameter*) _tmp347_;
						_tmp348_ = in_arg_map;
						_tmp349_ = type_param_index;
						_tmp350_ = type_param;
						_tmp351_ = vala_symbol_get_name ((ValaSymbol*) _tmp350_);
						_tmp352_ = _tmp351_;
						_tmp353_ = g_utf8_strdown (_tmp352_, (gssize) -1);
						_tmp354_ = _tmp353_;
						_tmp355_ = g_strdup_printf ("%s_type", _tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_ccode_identifier_new (_tmp356_);
						_tmp358_ = _tmp357_;
						vala_map_set ((ValaMap*) _tmp348_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp349_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp358_);
						_vala_ccode_node_unref0 (_tmp358_);
						_g_free0 (_tmp356_);
						_g_free0 (_tmp354_);
						_tmp359_ = in_arg_map;
						_tmp360_ = type_param_index;
						_tmp361_ = type_param;
						_tmp362_ = vala_symbol_get_name ((ValaSymbol*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = g_utf8_strdown (_tmp363_, (gssize) -1);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_strdup_printf ("%s_dup_func", _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_ccode_identifier_new (_tmp367_);
						_tmp369_ = _tmp368_;
						vala_map_set ((ValaMap*) _tmp359_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp360_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp369_);
						_vala_ccode_node_unref0 (_tmp369_);
						_g_free0 (_tmp367_);
						_g_free0 (_tmp365_);
						_tmp370_ = in_arg_map;
						_tmp371_ = type_param_index;
						_tmp372_ = type_param;
						_tmp373_ = vala_symbol_get_name ((ValaSymbol*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_utf8_strdown (_tmp374_, (gssize) -1);
						_tmp376_ = _tmp375_;
						_tmp377_ = g_strdup_printf ("%s_destroy_func", _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_ccode_identifier_new (_tmp378_);
						_tmp380_ = _tmp379_;
						vala_map_set ((ValaMap*) _tmp370_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp371_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp380_);
						_vala_ccode_node_unref0 (_tmp380_);
						_g_free0 (_tmp378_);
						_g_free0 (_tmp376_);
						_tmp381_ = type_param_index;
						type_param_index = _tmp381_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			ValaClass* _tmp386_;
			_tmp382_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp383_ = _tmp382_;
			_tmp384_ = vala_class_get_base_class (_tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp385_ == _tmp386_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp387_;
				ValaClass* _tmp388_;
				gchar* _tmp389_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				ValaCCodeDeclaration* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				const gchar* _tmp396_;
				gchar* _tmp397_;
				gchar* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeConstant* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeVariableDeclarator* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeFunction* _tmp404_;
				ValaCCodeDeclaration* _tmp405_;
				ValaCCodeFunctionCall* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeIdentifier* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeUnaryExpression* _tmp410_;
				ValaCCodeCastExpression* _tmp411_;
				ValaCCodeCastExpression* _tmp412_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeFunctionCall* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaCCodeFunctionCall* _tmp417_;
				ValaClass* _tmp418_;
				ValaClass* _tmp419_;
				gchar* _tmp420_;
				gchar* _tmp421_;
				ValaCCodeIdentifier* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeFunctionCall* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				_tmp387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp388_ = _tmp387_;
				_tmp389_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp388_, NULL);
				class_prefix = _tmp389_;
				_tmp390_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp390_;
				_tmp391_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp391_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp392_ = funcs;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = class_prefix;
				_tmp397_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp393_, _tmp394_, _tmp395_, _tmp396_);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_ccode_constant_new (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp400_, NULL);
				_tmp402_ = _tmp401_;
				vala_ccode_declaration_add_declarator (_tmp392_, (ValaCCodeDeclarator*) _tmp402_);
				_vala_ccode_node_unref0 (_tmp402_);
				_vala_ccode_node_unref0 (_tmp400_);
				_g_free0 (_tmp398_);
				_tmp403_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp404_ = _tmp403_;
				_tmp405_ = funcs;
				vala_ccode_function_add_statement (_tmp404_, (ValaCCodeNode*) _tmp405_);
				_tmp406_ = ccall;
				_tmp407_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp408_ = _tmp407_;
				_tmp409_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp410_, "GSourceFuncs *");
				_tmp412_ = _tmp411_;
				vala_ccode_function_call_add_argument (_tmp406_, (ValaCCodeExpression*) _tmp412_);
				_vala_ccode_node_unref0 (_tmp412_);
				_vala_ccode_node_unref0 (_tmp410_);
				_vala_ccode_node_unref0 (_tmp408_);
				_tmp413_ = vala_ccode_identifier_new ("sizeof");
				_tmp414_ = _tmp413_;
				_tmp415_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp414_);
				_tmp416_ = _tmp415_;
				_vala_ccode_node_unref0 (_tmp414_);
				csizeof = _tmp416_;
				_tmp417_ = csizeof;
				_tmp418_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_get_ccode_name ((ValaCodeNode*) _tmp419_);
				_tmp421_ = _tmp420_;
				_tmp422_ = vala_ccode_identifier_new (_tmp421_);
				_tmp423_ = _tmp422_;
				vala_ccode_function_call_add_argument (_tmp417_, (ValaCCodeExpression*) _tmp423_);
				_vala_ccode_node_unref0 (_tmp423_);
				_g_free0 (_tmp421_);
				_tmp424_ = ccall;
				_tmp425_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp424_, (ValaCCodeExpression*) _tmp425_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp426_ = FALSE;
		ValaMethod* _tmp427_;
		_tmp427_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp428_;
			ValaSymbol* _tmp429_;
			ValaSymbol* _tmp430_;
			_tmp428_ = m;
			_tmp429_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp428_);
			_tmp430_ = _tmp429_;
			_tmp426_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp430_, VALA_TYPE_STRUCT);
		} else {
			_tmp426_ = FALSE;
		}
		if (_tmp426_) {
			ValaCCodeFunctionCall* _tmp431_;
			ValaCCodeExpression* _tmp432_;
			ValaCCodeExpression* _tmp433_;
			_tmp431_ = ccall;
			_tmp432_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp433_ = _tmp432_;
			vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
			_vala_ccode_node_unref0 (_tmp433_);
		} else {
			gboolean _tmp434_ = FALSE;
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			gboolean _tmp437_ = FALSE;
			ValaMethod* _tmp438_;
			_tmp438_ = m;
			if (_tmp438_ != NULL) {
				ValaMethod* _tmp439_;
				ValaList* _tmp440_;
				ValaList* _tmp441_;
				gint _tmp442_;
				gint _tmp443_;
				_tmp439_ = m;
				_tmp440_ = vala_method_get_type_parameters (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_collection_get_size ((ValaCollection*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp437_ = _tmp443_ > 0;
				_vala_iterable_unref0 (_tmp441_);
			} else {
				_tmp437_ = FALSE;
			}
			if (_tmp437_) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp436_ = !vala_get_ccode_has_generic_type_parameter (_tmp444_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp435_ = !vala_get_ccode_simple_generics (_tmp445_);
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				gboolean _tmp446_ = FALSE;
				ValaCCodeFunctionCall* _tmp447_;
				ValaCCodeFunctionCall* _tmp448_;
				_tmp447_ = ccall;
				_tmp448_ = finish_call;
				if (_tmp447_ != _tmp448_) {
					_tmp446_ = TRUE;
				} else {
					gboolean _tmp449_;
					gboolean _tmp450_;
					_tmp449_ = vala_method_call_get_is_yield_expression (expr);
					_tmp450_ = _tmp449_;
					_tmp446_ = _tmp450_;
				}
				_tmp434_ = _tmp446_;
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaHashMap* _tmp451_;
				ValaMemberAccess* _tmp452_;
				ValaList* _tmp453_;
				ValaList* _tmp454_;
				_tmp451_ = in_arg_map;
				_tmp452_ = ma;
				_tmp453_ = vala_member_access_get_type_arguments (_tmp452_);
				_tmp454_ = _tmp453_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp451_, _tmp454_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp454_);
			}
		}
	}
	_tmp455_ = ccall;
	_tmp456_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp455_);
	ccall_expr = _tmp456_;
	_tmp457_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp457_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp458_;
		ValaExpression* _tmp459_;
		ValaExpression* _tmp460_;
		ValaDataType* _tmp461_;
		ValaDataType* _tmp462_;
		ValaArrayType* _tmp463_;
		ValaHashMap* _tmp464_;
		ValaArrayType* _tmp465_;
		ValaDataType* _tmp466_;
		ValaDataType* _tmp467_;
		gchar* _tmp468_;
		gchar* _tmp469_;
		ValaCCodeIdentifier* _tmp470_;
		ValaCCodeIdentifier* _tmp471_;
		_tmp458_ = ma;
		_tmp459_ = vala_member_access_get_inner (_tmp458_);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_expression_get_value_type (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp463_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp463_;
		_tmp464_ = in_arg_map;
		_tmp465_ = array_type;
		_tmp466_ = vala_array_type_get_element_type (_tmp465_);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_get_ccode_name ((ValaCodeNode*) _tmp467_);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_ccode_identifier_new (_tmp469_);
		_tmp471_ = _tmp470_;
		vala_map_set ((ValaMap*) _tmp464_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp471_);
		_vala_ccode_node_unref0 (_tmp471_);
		_g_free0 (_tmp469_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp472_;
		_tmp472_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp472_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp473_;
			_tmp473_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp473_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp474_;
				ValaExpression* _tmp475_;
				ValaExpression* _tmp476_;
				ValaTargetValue* _tmp477_;
				ValaTargetValue* _tmp478_;
				ValaTargetValue* _tmp479_;
				ValaTargetValue* _tmp480_;
				_tmp474_ = ma;
				_tmp475_ = vala_member_access_get_inner (_tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = vala_expression_get_target_value (_tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp478_, (ValaCodeNode*) expr);
				_tmp480_ = _tmp479_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp480_);
				_vala_target_value_unref0 (_tmp480_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp482_ = m;
	if (_tmp482_ != NULL) {
		ValaMethod* _tmp483_;
		gboolean _tmp484_;
		gboolean _tmp485_;
		_tmp483_ = m;
		_tmp484_ = vala_method_get_is_async_callback (_tmp483_);
		_tmp485_ = _tmp484_;
		_tmp481_ = _tmp485_;
	} else {
		_tmp481_ = FALSE;
	}
	if (_tmp481_) {
		ValaMethod* _tmp486_;
		ValaMethod* _tmp487_;
		gboolean _tmp488_;
		gboolean _tmp489_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		ValaHashMap* _tmp506_;
		ValaMethod* _tmp507_;
		ValaCCodeExpression* _tmp508_;
		_tmp486_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp487_ = _tmp486_;
		_tmp488_ = vala_method_get_closure (_tmp487_);
		_tmp489_ = _tmp488_;
		if (_tmp489_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp490_;
			ValaSymbol* _tmp491_;
			ValaSymbol* _tmp492_;
			ValaBlock* _tmp493_;
			ValaBlock* _tmp494_;
			ValaBlock* _tmp495_;
			ValaBlock* _tmp496_;
			gchar* _tmp497_;
			gchar* _tmp498_;
			ValaCCodeExpression* _tmp499_;
			ValaCCodeExpression* _tmp500_;
			ValaCCodeMemberAccess* _tmp501_;
			_tmp490_ = m;
			_tmp491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp490_);
			_tmp492_ = _tmp491_;
			_tmp493_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp492_, VALA_TYPE_METHOD, ValaMethod));
			_tmp494_ = _tmp493_;
			_tmp495_ = _vala_code_node_ref0 (_tmp494_);
			block = _tmp495_;
			_tmp496_ = block;
			_tmp497_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp496_));
			_tmp498_ = _tmp497_;
			_tmp499_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp498_);
			_tmp500_ = _tmp499_;
			_tmp501_ = vala_ccode_member_access_new_pointer (_tmp500_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp501_;
			_vala_ccode_node_unref0 (_tmp500_);
			_g_free0 (_tmp498_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp502_;
			_tmp502_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp502_;
		}
		_tmp503_ = in_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
		_tmp506_ = out_arg_map;
		_tmp507_ = m;
		_tmp508_ = instance;
		vala_map_set ((ValaMap*) _tmp506_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp507_), FALSE)), _tmp508_);
	} else {
		gboolean _tmp509_ = FALSE;
		gboolean _tmp510_ = FALSE;
		ValaMethod* _tmp511_;
		_tmp511_ = m;
		if (_tmp511_ != NULL) {
			ValaMethod* _tmp512_;
			ValaMemberBinding _tmp513_;
			ValaMemberBinding _tmp514_;
			_tmp512_ = m;
			_tmp513_ = vala_method_get_binding (_tmp512_);
			_tmp514_ = _tmp513_;
			_tmp510_ = _tmp514_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp510_ = FALSE;
		}
		if (_tmp510_) {
			ValaMethod* _tmp515_;
			_tmp515_ = m;
			_tmp509_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp515_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp509_ = FALSE;
		}
		if (_tmp509_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp516_;
			ValaExpression* _tmp517_;
			ValaExpression* _tmp518_;
			ValaTargetValue* _tmp519_;
			ValaTargetValue* _tmp520_;
			ValaTargetValue* _tmp521_;
			gboolean _tmp522_ = FALSE;
			gboolean _tmp523_ = FALSE;
			ValaMemberAccess* _tmp524_;
			const gchar* _tmp525_;
			const gchar* _tmp526_;
			ValaTargetValue* _tmp548_;
			ValaCCodeExpression* _tmp549_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp550_;
			ValaSymbol* _tmp551_;
			ValaSymbol* _tmp552_;
			ValaStruct* _tmp553_;
			gboolean _tmp554_ = FALSE;
			ValaStruct* _tmp555_;
			gboolean _tmp564_;
			gboolean _tmp565_;
			_tmp516_ = ma;
			_tmp517_ = vala_member_access_get_inner (_tmp516_);
			_tmp518_ = _tmp517_;
			_tmp519_ = vala_expression_get_target_value (_tmp518_);
			_tmp520_ = _tmp519_;
			_tmp521_ = _vala_target_value_ref0 (_tmp520_);
			instance_value = _tmp521_;
			_tmp524_ = ma;
			_tmp525_ = vala_member_access_get_member_name (_tmp524_);
			_tmp526_ = _tmp525_;
			if (g_strcmp0 (_tmp526_, "begin") == 0) {
				_tmp523_ = TRUE;
			} else {
				ValaMemberAccess* _tmp527_;
				const gchar* _tmp528_;
				const gchar* _tmp529_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_member_name (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp523_ = g_strcmp0 (_tmp529_, "end") == 0;
			}
			if (_tmp523_) {
				ValaMemberAccess* _tmp530_;
				ValaExpression* _tmp531_;
				ValaExpression* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				ValaMemberAccess* _tmp535_;
				ValaSymbol* _tmp536_;
				ValaSymbol* _tmp537_;
				_tmp530_ = ma;
				_tmp531_ = vala_member_access_get_inner (_tmp530_);
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_expression_get_symbol_reference (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = ma;
				_tmp536_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp535_);
				_tmp537_ = _tmp536_;
				_tmp522_ = _tmp534_ == _tmp537_;
			} else {
				_tmp522_ = FALSE;
			}
			if (_tmp522_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp538_;
				ValaExpression* _tmp539_;
				ValaExpression* _tmp540_;
				ValaMemberAccess* _tmp541_;
				ValaMemberAccess* _tmp542_;
				ValaExpression* _tmp543_;
				ValaExpression* _tmp544_;
				ValaTargetValue* _tmp545_;
				ValaTargetValue* _tmp546_;
				ValaTargetValue* _tmp547_;
				_tmp538_ = ma;
				_tmp539_ = vala_member_access_get_inner (_tmp538_);
				_tmp540_ = _tmp539_;
				_tmp541_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp540_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp541_;
				_tmp542_ = inner_ma;
				_tmp543_ = vala_member_access_get_inner (_tmp542_);
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_expression_get_target_value (_tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = _vala_target_value_ref0 (_tmp546_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp547_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp548_ = instance_value;
			_tmp549_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp548_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp549_;
			_tmp550_ = m;
			_tmp551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp550_);
			_tmp552_ = _tmp551_;
			_tmp553_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp552_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp552_) : NULL);
			st = _tmp553_;
			_tmp555_ = st;
			if (_tmp555_ != NULL) {
				ValaStruct* _tmp556_;
				_tmp556_ = st;
				_tmp554_ = !vala_struct_is_simple_type (_tmp556_);
			} else {
				_tmp554_ = FALSE;
			}
			if (_tmp554_) {
				ValaTargetValue* _tmp557_;
				ValaTargetValue* _tmp560_;
				ValaCCodeExpression* _tmp561_;
				ValaCCodeExpression* _tmp562_;
				ValaCCodeUnaryExpression* _tmp563_;
				_tmp557_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp557_)) {
					ValaTargetValue* _tmp558_;
					ValaTargetValue* _tmp559_;
					_tmp558_ = instance_value;
					_tmp559_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp558_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp559_;
				}
				_tmp560_ = instance_value;
				_tmp561_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp560_);
				_tmp562_ = _tmp561_;
				_tmp563_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp562_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp563_;
				_vala_ccode_node_unref0 (_tmp562_);
			}
			_tmp564_ = vala_method_call_get_is_yield_expression (expr);
			_tmp565_ = _tmp564_;
			if (_tmp565_) {
				ValaHashMap* _tmp566_;
				ValaMethod* _tmp567_;
				ValaCCodeExpression* _tmp568_;
				ValaMethod* _tmp569_;
				_tmp566_ = in_arg_map;
				_tmp567_ = m;
				_tmp568_ = instance;
				vala_map_set ((ValaMap*) _tmp566_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp567_), FALSE)), _tmp568_);
				_tmp569_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp569_)) {
					ValaHashMap* _tmp570_;
					ValaMethod* _tmp571_;
					ValaCCodeExpression* _tmp572_;
					_tmp570_ = out_arg_map;
					_tmp571_ = m;
					_tmp572_ = instance;
					vala_map_set ((ValaMap*) _tmp570_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp571_), FALSE)), _tmp572_);
				}
			} else {
				gboolean _tmp573_ = FALSE;
				ValaMemberAccess* _tmp574_;
				const gchar* _tmp575_;
				const gchar* _tmp576_;
				_tmp574_ = ma;
				_tmp575_ = vala_member_access_get_member_name (_tmp574_);
				_tmp576_ = _tmp575_;
				if (g_strcmp0 (_tmp576_, "end") != 0) {
					_tmp573_ = TRUE;
				} else {
					ValaMethod* _tmp577_;
					_tmp577_ = m;
					_tmp573_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp577_);
				}
				if (_tmp573_) {
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					ValaHashMap* _tmp581_;
					ValaMethod* _tmp582_;
					ValaCCodeExpression* _tmp583_;
					_tmp578_ = out_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
					_tmp581_ = in_arg_map;
					_tmp582_ = m;
					_tmp583_ = instance;
					vala_map_set ((ValaMap*) _tmp581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp582_), FALSE)), _tmp583_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp584_ = FALSE;
			ValaMethod* _tmp585_;
			_tmp585_ = m;
			if (_tmp585_ != NULL) {
				ValaMethod* _tmp586_;
				ValaMemberBinding _tmp587_;
				ValaMemberBinding _tmp588_;
				_tmp586_ = m;
				_tmp587_ = vala_method_get_binding (_tmp586_);
				_tmp588_ = _tmp587_;
				_tmp584_ = _tmp588_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp584_ = FALSE;
			}
			if (_tmp584_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp589_;
				ValaSymbol* _tmp590_;
				ValaSymbol* _tmp591_;
				ValaClass* _tmp592_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp593_;
				gchar* _tmp594_;
				gchar* _tmp595_;
				gchar* _tmp596_;
				gchar* _tmp597_;
				ValaCCodeIdentifier* _tmp598_;
				ValaCCodeIdentifier* _tmp599_;
				ValaCCodeFunctionCall* _tmp600_;
				ValaCCodeFunctionCall* _tmp601_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp602_;
				ValaExpression* _tmp603_;
				ValaExpression* _tmp604_;
				ValaCCodeFunctionCall* _tmp630_;
				ValaCCodeExpression* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				ValaHashMap* _tmp635_;
				ValaMethod* _tmp636_;
				ValaCCodeFunctionCall* _tmp637_;
				_tmp589_ = m;
				_tmp590_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp589_);
				_tmp591_ = _tmp590_;
				_tmp592_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp591_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp592_;
				_tmp593_ = cl;
				_tmp594_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp593_, NULL);
				_tmp595_ = _tmp594_;
				_tmp596_ = g_strconcat (_tmp595_, "_CLASS", NULL);
				_tmp597_ = _tmp596_;
				_tmp598_ = vala_ccode_identifier_new (_tmp597_);
				_tmp599_ = _tmp598_;
				_tmp600_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp599_);
				_tmp601_ = _tmp600_;
				_vala_ccode_node_unref0 (_tmp599_);
				_g_free0 (_tmp597_);
				_g_free0 (_tmp595_);
				cast = _tmp601_;
				_tmp602_ = ma;
				_tmp603_ = vala_member_access_get_inner (_tmp602_);
				_tmp604_ = _tmp603_;
				if (_tmp604_ == NULL) {
					ValaDataType* _tmp605_;
					ValaDataType* _tmp606_;
					gboolean _tmp607_;
					_tmp605_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp606_ = _tmp605_;
					_tmp607_ = _tmp606_ == NULL;
					_vala_code_node_unref0 (_tmp606_);
					if (_tmp607_) {
						ValaCCodeIdentifier* _tmp608_;
						_tmp608_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp608_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp609_;
						ValaCCodeIdentifier* _tmp610_;
						ValaCCodeFunctionCall* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						ValaCCodeExpression* _tmp615_;
						ValaCCodeFunctionCall* _tmp616_;
						ValaCCodeExpression* _tmp617_;
						_tmp609_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp610_ = _tmp609_;
						_tmp611_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp610_);
						_tmp612_ = _tmp611_;
						_vala_ccode_node_unref0 (_tmp610_);
						k = _tmp612_;
						_tmp613_ = k;
						_tmp614_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp615_ = _tmp614_;
						vala_ccode_function_call_add_argument (_tmp613_, _tmp615_);
						_vala_ccode_node_unref0 (_tmp615_);
						_tmp616_ = k;
						_tmp617_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp616_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp617_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp618_;
					ValaCCodeIdentifier* _tmp619_;
					ValaCCodeFunctionCall* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaMemberAccess* _tmp623_;
					ValaExpression* _tmp624_;
					ValaExpression* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					ValaCCodeExpression* _tmp627_;
					ValaCCodeFunctionCall* _tmp628_;
					ValaCCodeExpression* _tmp629_;
					_tmp618_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp619_);
					_tmp621_ = _tmp620_;
					_vala_ccode_node_unref0 (_tmp619_);
					k = _tmp621_;
					_tmp622_ = k;
					_tmp623_ = ma;
					_tmp624_ = vala_member_access_get_inner (_tmp623_);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp625_);
					_tmp627_ = _tmp626_;
					vala_ccode_function_call_add_argument (_tmp622_, _tmp627_);
					_vala_ccode_node_unref0 (_tmp627_);
					_tmp628_ = k;
					_tmp629_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp628_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp629_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp630_ = cast;
				_tmp631_ = klass;
				vala_ccode_function_call_add_argument (_tmp630_, _tmp631_);
				_tmp632_ = in_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_tmp635_ = out_arg_map;
				_tmp636_ = m;
				_tmp637_ = cast;
				vala_map_set ((ValaMap*) _tmp635_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp636_), FALSE)), (ValaCCodeExpression*) _tmp637_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp639_ = m;
	if (_tmp639_ != NULL) {
		ValaMethod* _tmp640_;
		_tmp640_ = m;
		_tmp638_ = vala_get_ccode_has_generic_type_parameter (_tmp640_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaMethod* _tmp641_;
		ValaList* _tmp642_;
		ValaList* _tmp643_;
		gint _tmp644_;
		gint _tmp645_;
		gboolean _tmp646_;
		_tmp641_ = m;
		_tmp642_ = vala_method_get_type_parameters (_tmp641_);
		_tmp643_ = _tmp642_;
		_tmp644_ = vala_collection_get_size ((ValaCollection*) _tmp643_);
		_tmp645_ = _tmp644_;
		_tmp646_ = _tmp645_ > 0;
		_vala_iterable_unref0 (_tmp643_);
		if (_tmp646_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp647_;
				ValaList* _tmp648_;
				gint _type_arg_size = 0;
				ValaList* _tmp649_;
				gint _tmp650_;
				gint _tmp651_;
				gint _type_arg_index = 0;
				_tmp647_ = ma;
				_tmp648_ = vala_member_access_get_type_arguments (_tmp647_);
				_type_arg_list = _tmp648_;
				_tmp649_ = _type_arg_list;
				_tmp650_ = vala_collection_get_size ((ValaCollection*) _tmp649_);
				_tmp651_ = _tmp650_;
				_type_arg_size = _tmp651_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp652_;
					gint _tmp653_;
					gint _tmp654_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp655_;
					gint _tmp656_;
					gpointer _tmp657_;
					ValaHashMap* _tmp658_;
					ValaMethod* _tmp659_;
					gint _tmp660_;
					ValaDataType* _tmp661_;
					gchar* _tmp662_;
					gchar* _tmp663_;
					ValaCCodeIdentifier* _tmp664_;
					ValaCCodeIdentifier* _tmp665_;
					gint _tmp666_;
					_tmp652_ = _type_arg_index;
					_type_arg_index = _tmp652_ + 1;
					_tmp653_ = _type_arg_index;
					_tmp654_ = _type_arg_size;
					if (!(_tmp653_ < _tmp654_)) {
						break;
					}
					_tmp655_ = _type_arg_list;
					_tmp656_ = _type_arg_index;
					_tmp657_ = vala_list_get (_tmp655_, _tmp656_);
					type_arg = (ValaDataType*) _tmp657_;
					_tmp658_ = in_arg_map;
					_tmp659_ = m;
					_tmp660_ = type_param_index;
					_tmp661_ = type_arg;
					_tmp662_ = vala_get_ccode_name ((ValaCodeNode*) _tmp661_);
					_tmp663_ = _tmp662_;
					_tmp664_ = vala_ccode_identifier_new (_tmp663_);
					_tmp665_ = _tmp664_;
					vala_map_set ((ValaMap*) _tmp658_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp659_) + (0.01 * _tmp660_), FALSE)), (ValaCCodeExpression*) _tmp665_);
					_vala_ccode_node_unref0 (_tmp665_);
					_g_free0 (_tmp663_);
					_tmp666_ = type_param_index;
					type_param_index = _tmp666_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp667_;
				ValaExpression* _tmp668_;
				ValaExpression* _tmp669_;
				ValaDataType* _tmp670_;
				ValaDataType* _tmp671_;
				ValaList* _tmp672_;
				gint _type_arg_size = 0;
				ValaList* _tmp673_;
				gint _tmp674_;
				gint _tmp675_;
				gint _type_arg_index = 0;
				_tmp667_ = ma;
				_tmp668_ = vala_member_access_get_inner (_tmp667_);
				_tmp669_ = _tmp668_;
				_tmp670_ = vala_expression_get_value_type (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_data_type_get_type_arguments (_tmp671_);
				_type_arg_list = _tmp672_;
				_tmp673_ = _type_arg_list;
				_tmp674_ = vala_collection_get_size ((ValaCollection*) _tmp673_);
				_tmp675_ = _tmp674_;
				_type_arg_size = _tmp675_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp676_;
					gint _tmp677_;
					gint _tmp678_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp679_;
					gint _tmp680_;
					gpointer _tmp681_;
					ValaHashMap* _tmp682_;
					ValaMethod* _tmp683_;
					gint _tmp684_;
					ValaDataType* _tmp685_;
					gchar* _tmp686_;
					gchar* _tmp687_;
					ValaCCodeIdentifier* _tmp688_;
					ValaCCodeIdentifier* _tmp689_;
					gint _tmp690_;
					_tmp676_ = _type_arg_index;
					_type_arg_index = _tmp676_ + 1;
					_tmp677_ = _type_arg_index;
					_tmp678_ = _type_arg_size;
					if (!(_tmp677_ < _tmp678_)) {
						break;
					}
					_tmp679_ = _type_arg_list;
					_tmp680_ = _type_arg_index;
					_tmp681_ = vala_list_get (_tmp679_, _tmp680_);
					type_arg = (ValaDataType*) _tmp681_;
					_tmp682_ = in_arg_map;
					_tmp683_ = m;
					_tmp684_ = type_param_index;
					_tmp685_ = type_arg;
					_tmp686_ = vala_get_ccode_name ((ValaCodeNode*) _tmp685_);
					_tmp687_ = _tmp686_;
					_tmp688_ = vala_ccode_identifier_new (_tmp687_);
					_tmp689_ = _tmp688_;
					vala_map_set ((ValaMap*) _tmp682_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp683_) + (0.01 * _tmp684_), FALSE)), (ValaCCodeExpression*) _tmp689_);
					_vala_ccode_node_unref0 (_tmp689_);
					_g_free0 (_tmp687_);
					_tmp690_ = type_param_index;
					type_param_index = _tmp690_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp691_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp691_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp692_;
		ValaExpression* _tmp693_;
		ValaExpression* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		ValaArrayType* _tmp697_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp698_;
		ValaCCodeIdentifier* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaCCodeFunctionCall* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		ValaArrayType* _tmp703_;
		ValaDataType* _tmp704_;
		ValaDataType* _tmp705_;
		gchar* _tmp706_;
		gchar* _tmp707_;
		ValaCCodeIdentifier* _tmp708_;
		ValaCCodeIdentifier* _tmp709_;
		ValaHashMap* _tmp710_;
		ValaCCodeFunctionCall* _tmp711_;
		_tmp692_ = ma;
		_tmp693_ = vala_member_access_get_inner (_tmp692_);
		_tmp694_ = _tmp693_;
		_tmp695_ = vala_expression_get_value_type (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp697_;
		_tmp698_ = vala_ccode_identifier_new ("sizeof");
		_tmp699_ = _tmp698_;
		_tmp700_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp699_);
		_tmp701_ = _tmp700_;
		_vala_ccode_node_unref0 (_tmp699_);
		csizeof = _tmp701_;
		_tmp702_ = csizeof;
		_tmp703_ = array_type;
		_tmp704_ = vala_array_type_get_element_type (_tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_get_ccode_name ((ValaCodeNode*) _tmp705_);
		_tmp707_ = _tmp706_;
		_tmp708_ = vala_ccode_identifier_new (_tmp707_);
		_tmp709_ = _tmp708_;
		vala_ccode_function_call_add_argument (_tmp702_, (ValaCCodeExpression*) _tmp709_);
		_vala_ccode_node_unref0 (_tmp709_);
		_g_free0 (_tmp707_);
		_tmp710_ = in_arg_map;
		_tmp711_ = csizeof;
		vala_map_set ((ValaMap*) _tmp710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp711_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp712_;
		_tmp712_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp712_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp713_;
			gint param_nr = 0;
			ValaMethod* _tmp784_;
			_tmp713_ = m;
			vala_method_clear_parameters (_tmp713_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp714_;
				gint _arg_size = 0;
				ValaList* _tmp715_;
				gint _tmp716_;
				gint _tmp717_;
				gint _arg_index = 0;
				_tmp714_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp714_;
				_tmp715_ = _arg_list;
				_tmp716_ = vala_collection_get_size ((ValaCollection*) _tmp715_);
				_tmp717_ = _tmp716_;
				_arg_size = _tmp717_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp718_;
					gint _tmp719_;
					gint _tmp720_;
					ValaExpression* arg = NULL;
					ValaList* _tmp721_;
					gint _tmp722_;
					gpointer _tmp723_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp724_;
					ValaUnaryExpression* _tmp725_;
					gboolean _tmp726_ = FALSE;
					ValaUnaryExpression* _tmp727_;
					gint _tmp771_;
					_tmp718_ = _arg_index;
					_arg_index = _tmp718_ + 1;
					_tmp719_ = _arg_index;
					_tmp720_ = _arg_size;
					if (!(_tmp719_ < _tmp720_)) {
						break;
					}
					_tmp721_ = _arg_list;
					_tmp722_ = _arg_index;
					_tmp723_ = vala_list_get (_tmp721_, _tmp722_);
					arg = (ValaExpression*) _tmp723_;
					_tmp724_ = arg;
					_tmp725_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp724_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp724_) : NULL);
					unary = _tmp725_;
					_tmp727_ = unary;
					if (_tmp727_ != NULL) {
						ValaUnaryExpression* _tmp728_;
						ValaUnaryOperator _tmp729_;
						ValaUnaryOperator _tmp730_;
						_tmp728_ = unary;
						_tmp729_ = vala_unary_expression_get_operator (_tmp728_);
						_tmp730_ = _tmp729_;
						_tmp726_ = _tmp730_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp726_ = FALSE;
					}
					if (_tmp726_) {
						ValaParameter* param = NULL;
						gint _tmp731_;
						gchar* _tmp732_;
						gchar* _tmp733_;
						ValaUnaryExpression* _tmp734_;
						ValaExpression* _tmp735_;
						ValaExpression* _tmp736_;
						ValaDataType* _tmp737_;
						ValaDataType* _tmp738_;
						ValaParameter* _tmp739_;
						ValaParameter* _tmp740_;
						ValaParameter* _tmp741_;
						ValaMethod* _tmp742_;
						ValaParameter* _tmp743_;
						_tmp731_ = param_nr;
						_tmp732_ = g_strdup_printf ("param%d", _tmp731_);
						_tmp733_ = _tmp732_;
						_tmp734_ = unary;
						_tmp735_ = vala_unary_expression_get_inner (_tmp734_);
						_tmp736_ = _tmp735_;
						_tmp737_ = vala_expression_get_value_type (_tmp736_);
						_tmp738_ = _tmp737_;
						_tmp739_ = vala_parameter_new (_tmp733_, _tmp738_, NULL);
						_tmp740_ = _tmp739_;
						_g_free0 (_tmp733_);
						param = _tmp740_;
						_tmp741_ = param;
						vala_parameter_set_direction (_tmp741_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp742_ = m;
						_tmp743_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp742_, _tmp743_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp744_ = FALSE;
						ValaUnaryExpression* _tmp745_;
						_tmp745_ = unary;
						if (_tmp745_ != NULL) {
							ValaUnaryExpression* _tmp746_;
							ValaUnaryOperator _tmp747_;
							ValaUnaryOperator _tmp748_;
							_tmp746_ = unary;
							_tmp747_ = vala_unary_expression_get_operator (_tmp746_);
							_tmp748_ = _tmp747_;
							_tmp744_ = _tmp748_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp744_ = FALSE;
						}
						if (_tmp744_) {
							ValaParameter* param = NULL;
							gint _tmp749_;
							gchar* _tmp750_;
							gchar* _tmp751_;
							ValaUnaryExpression* _tmp752_;
							ValaExpression* _tmp753_;
							ValaExpression* _tmp754_;
							ValaDataType* _tmp755_;
							ValaDataType* _tmp756_;
							ValaParameter* _tmp757_;
							ValaParameter* _tmp758_;
							ValaParameter* _tmp759_;
							ValaMethod* _tmp760_;
							ValaParameter* _tmp761_;
							_tmp749_ = param_nr;
							_tmp750_ = g_strdup_printf ("param%d", _tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = unary;
							_tmp753_ = vala_unary_expression_get_inner (_tmp752_);
							_tmp754_ = _tmp753_;
							_tmp755_ = vala_expression_get_value_type (_tmp754_);
							_tmp756_ = _tmp755_;
							_tmp757_ = vala_parameter_new (_tmp751_, _tmp756_, NULL);
							_tmp758_ = _tmp757_;
							_g_free0 (_tmp751_);
							param = _tmp758_;
							_tmp759_ = param;
							vala_parameter_set_direction (_tmp759_, VALA_PARAMETER_DIRECTION_REF);
							_tmp760_ = m;
							_tmp761_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp760_, _tmp761_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp762_;
							gint _tmp763_;
							gchar* _tmp764_;
							gchar* _tmp765_;
							ValaExpression* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							_tmp762_ = m;
							_tmp763_ = param_nr;
							_tmp764_ = g_strdup_printf ("param%d", _tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = arg;
							_tmp767_ = vala_expression_get_value_type (_tmp766_);
							_tmp768_ = _tmp767_;
							_tmp769_ = vala_parameter_new (_tmp765_, _tmp768_, NULL);
							_tmp770_ = _tmp769_;
							vala_callable_add_parameter ((ValaCallable*) _tmp762_, _tmp770_);
							_vala_code_node_unref0 (_tmp770_);
							_g_free0 (_tmp765_);
						}
					}
					_tmp771_ = param_nr;
					param_nr = _tmp771_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp772_;
				ValaList* _tmp773_;
				gint _param_size = 0;
				ValaList* _tmp774_;
				gint _tmp775_;
				gint _tmp776_;
				gint _param_index = 0;
				_tmp772_ = m;
				_tmp773_ = vala_callable_get_parameters ((ValaCallable*) _tmp772_);
				_param_list = _tmp773_;
				_tmp774_ = _param_list;
				_tmp775_ = vala_collection_get_size ((ValaCollection*) _tmp774_);
				_tmp776_ = _tmp775_;
				_param_size = _tmp776_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp777_;
					gint _tmp778_;
					gint _tmp779_;
					ValaParameter* param = NULL;
					ValaList* _tmp780_;
					gint _tmp781_;
					gpointer _tmp782_;
					ValaParameter* _tmp783_;
					_tmp777_ = _param_index;
					_param_index = _tmp777_ + 1;
					_tmp778_ = _param_index;
					_tmp779_ = _param_size;
					if (!(_tmp778_ < _tmp779_)) {
						break;
					}
					_tmp780_ = _param_list;
					_tmp781_ = _param_index;
					_tmp782_ = vala_list_get (_tmp780_, _tmp781_);
					param = (ValaParameter*) _tmp782_;
					_tmp783_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp783_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp784_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp784_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp785_ = FALSE;
			ValaMethod* _tmp786_;
			_tmp786_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp787_;
				ValaSymbol* _tmp788_;
				ValaSymbol* _tmp789_;
				_tmp787_ = m;
				_tmp788_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp787_);
				_tmp789_ = _tmp788_;
				_tmp785_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp789_, VALA_TYPE_CLASS);
			} else {
				_tmp785_ = FALSE;
			}
			if (_tmp785_) {
				ValaCCodeFunction* _tmp790_;
				ValaCCodeFunction* _tmp791_;
				ValaCCodeExpression* _tmp792_;
				ValaCCodeExpression* _tmp793_;
				ValaCCodeFunctionCall* _tmp794_;
				ValaClass* _tmp795_;
				ValaClass* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				ValaCCodeCastExpression* _tmp801_;
				ValaCCodeCastExpression* _tmp802_;
				ValaMethod* _tmp803_;
				ValaMethod* _tmp804_;
				ValaBlock* _tmp805_;
				ValaBlock* _tmp806_;
				gboolean _tmp807_;
				gboolean _tmp808_;
				gboolean _tmp835_ = FALSE;
				ValaClass* _tmp836_;
				ValaClass* _tmp837_;
				gboolean _tmp838_;
				gboolean _tmp839_;
				_tmp790_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = ccall;
				_tmp795_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_get_ccode_name ((ValaCodeNode*) _tmp796_);
				_tmp798_ = _tmp797_;
				_tmp799_ = g_strconcat (_tmp798_, "*", NULL);
				_tmp800_ = _tmp799_;
				_tmp801_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp794_, _tmp800_);
				_tmp802_ = _tmp801_;
				vala_ccode_function_add_assignment (_tmp791_, _tmp793_, (ValaCCodeExpression*) _tmp802_);
				_vala_ccode_node_unref0 (_tmp802_);
				_g_free0 (_tmp800_);
				_g_free0 (_tmp798_);
				_vala_ccode_node_unref0 (_tmp793_);
				_tmp803_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp804_ = _tmp803_;
				_tmp805_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp804_);
				_tmp806_ = _tmp805_;
				_tmp807_ = vala_block_get_captured (_tmp806_);
				_tmp808_ = _tmp807_;
				if (_tmp808_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp809_;
					ValaClass* _tmp810_;
					ValaObjectType* _tmp811_;
					ValaObjectType* _tmp812_;
					ValaSourceReference* _tmp813_;
					ValaSourceReference* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeExpression* _tmp816_;
					ValaCCodeFunctionCall* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					ValaCCodeExpression* _tmp820_;
					ValaCCodeExpression* _tmp821_;
					ValaCCodeFunction* _tmp822_;
					ValaCCodeFunction* _tmp823_;
					ValaMethod* _tmp824_;
					ValaMethod* _tmp825_;
					ValaBlock* _tmp826_;
					ValaBlock* _tmp827_;
					gchar* _tmp828_;
					gchar* _tmp829_;
					ValaCCodeExpression* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeMemberAccess* _tmp832_;
					ValaCCodeMemberAccess* _tmp833_;
					ValaCCodeFunctionCall* _tmp834_;
					_tmp809_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp810_);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp814_ = _tmp813_;
					_tmp815_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp812_, _tmp814_, FALSE);
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_ccode_function_call_new (_tmp816_);
					_tmp818_ = _tmp817_;
					_vala_ccode_node_unref0 (_tmp816_);
					_vala_code_node_unref0 (_tmp812_);
					ref_call = _tmp818_;
					_tmp819_ = ref_call;
					_tmp820_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp821_ = _tmp820_;
					vala_ccode_function_call_add_argument (_tmp819_, _tmp821_);
					_vala_ccode_node_unref0 (_tmp821_);
					_tmp822_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp825_);
					_tmp827_ = _tmp826_;
					_tmp828_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp827_));
					_tmp829_ = _tmp828_;
					_tmp830_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp829_);
					_tmp831_ = _tmp830_;
					_tmp832_ = vala_ccode_member_access_new_pointer (_tmp831_, "self");
					_tmp833_ = _tmp832_;
					_tmp834_ = ref_call;
					vala_ccode_function_add_assignment (_tmp823_, (ValaCCodeExpression*) _tmp833_, (ValaCCodeExpression*) _tmp834_);
					_vala_ccode_node_unref0 (_tmp833_);
					_vala_ccode_node_unref0 (_tmp831_);
					_g_free0 (_tmp829_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp836_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp837_ = _tmp836_;
				_tmp838_ = vala_class_get_is_compact (_tmp837_);
				_tmp839_ = _tmp838_;
				if (!_tmp839_) {
					ValaClass* _tmp840_;
					ValaClass* _tmp841_;
					ValaList* _tmp842_;
					ValaList* _tmp843_;
					gint _tmp844_;
					gint _tmp845_;
					_tmp840_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp841_ = _tmp840_;
					_tmp842_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp841_);
					_tmp843_ = _tmp842_;
					_tmp844_ = vala_collection_get_size ((ValaCollection*) _tmp843_);
					_tmp845_ = _tmp844_;
					_tmp835_ = _tmp845_ > 0;
					_vala_iterable_unref0 (_tmp843_);
				} else {
					_tmp835_ = FALSE;
				}
				if (_tmp835_) {
					gchar** suffices = NULL;
					gchar* _tmp846_;
					gchar* _tmp847_;
					gchar* _tmp848_;
					gchar** _tmp849_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp846_ = g_strdup ("type");
					_tmp847_ = g_strdup ("dup_func");
					_tmp848_ = g_strdup ("destroy_func");
					_tmp849_ = g_new0 (gchar*, 3 + 1);
					_tmp849_[0] = _tmp846_;
					_tmp849_[1] = _tmp847_;
					_tmp849_[2] = _tmp848_;
					suffices = _tmp849_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp850_;
						ValaClass* _tmp851_;
						ValaList* _tmp852_;
						gint _type_param_size = 0;
						ValaList* _tmp853_;
						gint _tmp854_;
						gint _tmp855_;
						gint _type_param_index = 0;
						_tmp850_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp851_ = _tmp850_;
						_tmp852_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp851_);
						_type_param_list = _tmp852_;
						_tmp853_ = _type_param_list;
						_tmp854_ = vala_collection_get_size ((ValaCollection*) _tmp853_);
						_tmp855_ = _tmp854_;
						_type_param_size = _tmp855_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp856_;
							gint _tmp857_;
							gint _tmp858_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp859_;
							gint _tmp860_;
							gpointer _tmp861_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp862_;
							ValaCCodeIdentifier* _tmp863_;
							ValaCCodeMemberAccess* _tmp864_;
							ValaCCodeMemberAccess* _tmp865_;
							gchar** _tmp866_;
							gint _tmp866__length1;
							_tmp856_ = _type_param_index;
							_type_param_index = _tmp856_ + 1;
							_tmp857_ = _type_param_index;
							_tmp858_ = _type_param_size;
							if (!(_tmp857_ < _tmp858_)) {
								break;
							}
							_tmp859_ = _type_param_list;
							_tmp860_ = _type_param_index;
							_tmp861_ = vala_list_get (_tmp859_, _tmp860_);
							type_param = (ValaTypeParameter*) _tmp861_;
							_tmp862_ = vala_ccode_identifier_new ("self");
							_tmp863_ = _tmp862_;
							_tmp864_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp863_, "priv");
							_tmp865_ = _tmp864_;
							_vala_ccode_node_unref0 (_tmp863_);
							priv_access = _tmp865_;
							_tmp866_ = suffices;
							_tmp866__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp866_;
								suffix_collection_length1 = _tmp866__length1;
								for (suffix_it = 0; suffix_it < _tmp866__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp867_;
									gchar* suffix = NULL;
									_tmp867_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp867_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp868_;
										const gchar* _tmp869_;
										const gchar* _tmp870_;
										gchar* _tmp871_;
										gchar* _tmp872_;
										const gchar* _tmp873_;
										gchar* _tmp874_;
										gchar* _tmp875_;
										ValaCCodeIdentifier* _tmp876_;
										ValaCCodeIdentifier* _tmp877_;
										ValaCCodeFunction* _tmp878_;
										ValaCCodeFunction* _tmp879_;
										ValaCCodeMemberAccess* _tmp880_;
										ValaCCodeIdentifier* _tmp881_;
										const gchar* _tmp882_;
										const gchar* _tmp883_;
										ValaCCodeMemberAccess* _tmp884_;
										ValaCCodeMemberAccess* _tmp885_;
										ValaCCodeIdentifier* _tmp886_;
										_tmp868_ = type_param;
										_tmp869_ = vala_symbol_get_name ((ValaSymbol*) _tmp868_);
										_tmp870_ = _tmp869_;
										_tmp871_ = g_utf8_strdown (_tmp870_, (gssize) -1);
										_tmp872_ = _tmp871_;
										_tmp873_ = suffix;
										_tmp874_ = g_strdup_printf ("%s_%s", _tmp872_, _tmp873_);
										_tmp875_ = _tmp874_;
										_tmp876_ = vala_ccode_identifier_new (_tmp875_);
										_tmp877_ = _tmp876_;
										_g_free0 (_tmp875_);
										_g_free0 (_tmp872_);
										param_name = _tmp877_;
										_tmp878_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp879_ = _tmp878_;
										_tmp880_ = priv_access;
										_tmp881_ = param_name;
										_tmp882_ = vala_ccode_identifier_get_name (_tmp881_);
										_tmp883_ = _tmp882_;
										_tmp884_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp880_, _tmp883_);
										_tmp885_ = _tmp884_;
										_tmp886_ = param_name;
										vala_ccode_function_add_assignment (_tmp879_, (ValaCCodeExpression*) _tmp885_, (ValaCCodeExpression*) _tmp886_);
										_vala_ccode_node_unref0 (_tmp885_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp887_ = params;
	_tmp888_ = vala_iterable_iterator ((ValaIterable*) _tmp887_);
	params_it = _tmp888_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp889_;
		gint _arg_size = 0;
		ValaList* _tmp890_;
		gint _tmp891_;
		gint _tmp892_;
		gint _arg_index = 0;
		_tmp889_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp889_;
		_tmp890_ = _arg_list;
		_tmp891_ = vala_collection_get_size ((ValaCollection*) _tmp890_);
		_tmp892_ = _tmp891_;
		_arg_size = _tmp892_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp893_;
			gint _tmp894_;
			gint _tmp895_;
			ValaExpression* arg = NULL;
			ValaList* _tmp896_;
			gint _tmp897_;
			gpointer _tmp898_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp899_;
			ValaCCodeExpression* _tmp900_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp901_;
			ValaHashMap* _tmp902_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp903_;
			gboolean _tmp913_ = FALSE;
			ValaParameter* _tmp914_;
			gdouble _tmp1252_ = 0.0;
			ValaParameter* _tmp1253_;
			gboolean _tmp1256_;
			ValaHashMap* _tmp1257_;
			gint _tmp1258_;
			ValaCCodeExpression* _tmp1259_;
			gboolean _tmp1260_ = FALSE;
			ValaExpression* _tmp1261_;
			gint _tmp1281_;
			_tmp893_ = _arg_index;
			_arg_index = _tmp893_ + 1;
			_tmp894_ = _arg_index;
			_tmp895_ = _arg_size;
			if (!(_tmp894_ < _tmp895_)) {
				break;
			}
			_tmp896_ = _arg_list;
			_tmp897_ = _arg_index;
			_tmp898_ = vala_list_get (_tmp896_, _tmp897_);
			arg = (ValaExpression*) _tmp898_;
			_tmp899_ = arg;
			_tmp900_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp899_);
			cexpr = _tmp900_;
			_tmp901_ = in_arg_map;
			_tmp902_ = _vala_map_ref0 (_tmp901_);
			carg_map = _tmp902_;
			param = NULL;
			_tmp903_ = params_it;
			if (vala_iterator_next (_tmp903_)) {
				ValaIterator* _tmp904_;
				gpointer _tmp905_;
				gboolean _tmp906_ = FALSE;
				ValaParameter* _tmp907_;
				gboolean _tmp908_;
				gboolean _tmp909_;
				_tmp904_ = params_it;
				_tmp905_ = vala_iterator_get (_tmp904_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp905_;
				_tmp907_ = param;
				_tmp908_ = vala_parameter_get_params_array (_tmp907_);
				_tmp909_ = _tmp908_;
				if (_tmp909_) {
					_tmp906_ = TRUE;
				} else {
					ValaParameter* _tmp910_;
					gboolean _tmp911_;
					gboolean _tmp912_;
					_tmp910_ = param;
					_tmp911_ = vala_parameter_get_ellipsis (_tmp910_);
					_tmp912_ = _tmp911_;
					_tmp906_ = _tmp912_;
				}
				ellipsis = _tmp906_;
			}
			_tmp914_ = param;
			if (_tmp914_ != NULL) {
				gboolean _tmp915_;
				_tmp915_ = ellipsis;
				_tmp913_ = !_tmp915_;
			} else {
				_tmp913_ = FALSE;
			}
			if (_tmp913_) {
				ValaParameter* _tmp916_;
				ValaParameterDirection _tmp917_;
				ValaParameterDirection _tmp918_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp921_;
				ValaUnaryExpression* _tmp922_;
				gboolean _tmp923_ = FALSE;
				ValaUnaryExpression* _tmp924_;
				ValaParameter* _tmp1202_;
				gchar* _tmp1203_;
				gchar* _tmp1204_;
				gboolean _tmp1205_;
				_tmp916_ = param;
				_tmp917_ = vala_parameter_get_direction (_tmp916_);
				_tmp918_ = _tmp917_;
				if (_tmp918_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp919_;
					ValaHashMap* _tmp920_;
					_tmp919_ = out_arg_map;
					_tmp920_ = _vala_map_ref0 (_tmp919_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp920_;
				}
				_tmp921_ = arg;
				_tmp922_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp921_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp921_) : NULL);
				unary = _tmp922_;
				_tmp924_ = unary;
				if (_tmp924_ == NULL) {
					_tmp923_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp925_;
					ValaUnaryOperator _tmp926_;
					ValaUnaryOperator _tmp927_;
					_tmp925_ = unary;
					_tmp926_ = vala_unary_expression_get_operator (_tmp925_);
					_tmp927_ = _tmp926_;
					_tmp923_ = _tmp927_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp923_) {
					gboolean _tmp928_ = FALSE;
					gboolean _tmp929_ = FALSE;
					ValaParameter* _tmp930_;
					ValaParameter* _tmp1072_;
					ValaExpression* _tmp1073_;
					ValaCCodeExpression* _tmp1074_;
					ValaCCodeExpression* _tmp1075_;
					_tmp930_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp930_)) {
						ValaParameter* _tmp931_;
						ValaDataType* _tmp932_;
						ValaDataType* _tmp933_;
						_tmp931_ = param;
						_tmp932_ = vala_variable_get_variable_type ((ValaVariable*) _tmp931_);
						_tmp933_ = _tmp932_;
						_tmp929_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp933_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp929_ = FALSE;
					}
					if (_tmp929_) {
						ValaParameter* _tmp934_;
						ValaDataType* _tmp935_;
						ValaDataType* _tmp936_;
						gboolean _tmp937_;
						gboolean _tmp938_;
						_tmp934_ = param;
						_tmp935_ = vala_variable_get_variable_type ((ValaVariable*) _tmp934_);
						_tmp936_ = _tmp935_;
						_tmp937_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp936_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp938_ = _tmp937_;
						_tmp928_ = !_tmp938_;
					} else {
						_tmp928_ = FALSE;
					}
					if (_tmp928_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp939_;
						ValaDataType* _tmp940_;
						ValaDataType* _tmp941_;
						ValaArrayType* _tmp942_;
						_tmp939_ = param;
						_tmp940_ = vala_variable_get_variable_type ((ValaVariable*) _tmp939_);
						_tmp941_ = _tmp940_;
						_tmp942_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp941_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp942_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp943_ = FALSE;
								_tmp943_ = TRUE;
								while (TRUE) {
									gint _tmp945_;
									ValaArrayType* _tmp946_;
									gint _tmp947_;
									gint _tmp948_;
									ValaCCodeExpression* array_length_expr = NULL;
									ValaParameter* _tmp949_;
									gchar* _tmp950_;
									gchar* _tmp951_;
									gboolean _tmp952_;
									ValaHashMap* _tmp971_;
									ValaParameter* _tmp972_;
									gint _tmp973_;
									ValaCCodeExpression* _tmp974_;
									if (!_tmp943_) {
										gint _tmp944_;
										_tmp944_ = dim;
										dim = _tmp944_ + 1;
									}
									_tmp943_ = FALSE;
									_tmp945_ = dim;
									_tmp946_ = array_type;
									_tmp947_ = vala_array_type_get_rank (_tmp946_);
									_tmp948_ = _tmp947_;
									if (!(_tmp945_ <= _tmp948_)) {
										break;
									}
									array_length_expr = NULL;
									_tmp949_ = param;
									_tmp950_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp949_);
									_tmp951_ = _tmp950_;
									_tmp952_ = _tmp951_ != NULL;
									_g_free0 (_tmp951_);
									if (_tmp952_) {
										gchar* length_ctype = NULL;
										ValaParameter* _tmp953_;
										gchar* _tmp954_;
										gboolean _tmp955_ = FALSE;
										ValaUnaryExpression* _tmp956_;
										ValaExpression* _tmp962_;
										gint _tmp963_;
										ValaCCodeExpression* _tmp964_;
										ValaCCodeExpression* _tmp965_;
										const gchar* _tmp966_;
										ValaCCodeCastExpression* _tmp967_;
										_tmp953_ = param;
										_tmp954_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp953_);
										length_ctype = _tmp954_;
										_tmp956_ = unary;
										if (_tmp956_ != NULL) {
											ValaUnaryExpression* _tmp957_;
											ValaUnaryOperator _tmp958_;
											ValaUnaryOperator _tmp959_;
											_tmp957_ = unary;
											_tmp958_ = vala_unary_expression_get_operator (_tmp957_);
											_tmp959_ = _tmp958_;
											_tmp955_ = _tmp959_ == VALA_UNARY_OPERATOR_REF;
										} else {
											_tmp955_ = FALSE;
										}
										if (_tmp955_) {
											const gchar* _tmp960_;
											gchar* _tmp961_;
											_tmp960_ = length_ctype;
											_tmp961_ = g_strdup_printf ("%s*", _tmp960_);
											_g_free0 (length_ctype);
											length_ctype = _tmp961_;
										}
										_tmp962_ = arg;
										_tmp963_ = dim;
										_tmp964_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp962_, _tmp963_);
										_tmp965_ = _tmp964_;
										_tmp966_ = length_ctype;
										_tmp967_ = vala_ccode_cast_expression_new (_tmp965_, _tmp966_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = (ValaCCodeExpression*) _tmp967_;
										_vala_ccode_node_unref0 (_tmp965_);
										_g_free0 (length_ctype);
									} else {
										ValaExpression* _tmp968_;
										gint _tmp969_;
										ValaCCodeExpression* _tmp970_;
										_tmp968_ = arg;
										_tmp969_ = dim;
										_tmp970_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp968_, _tmp969_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = _tmp970_;
									}
									_tmp971_ = carg_map;
									_tmp972_ = param;
									_tmp973_ = dim;
									_tmp974_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp971_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp972_) + (0.01 * _tmp973_), FALSE)), _tmp974_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp975_;
						ValaDataType* _tmp976_;
						ValaDataType* _tmp977_;
						_tmp975_ = param;
						_tmp976_ = vala_variable_get_variable_type ((ValaVariable*) _tmp975_);
						_tmp977_ = _tmp976_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp977_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp978_;
							ValaDataType* _tmp979_;
							ValaDataType* _tmp980_;
							ValaDelegateType* _tmp981_;
							ValaDelegateType* _tmp982_;
							ValaDelegate* _tmp983_;
							ValaDelegate* _tmp984_;
							gboolean _tmp985_;
							gboolean _tmp986_;
							_tmp978_ = param;
							_tmp979_ = vala_variable_get_variable_type ((ValaVariable*) _tmp978_);
							_tmp980_ = _tmp979_;
							_tmp981_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp980_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp981_;
							_tmp982_ = deleg_type;
							_tmp983_ = vala_delegate_type_get_delegate_symbol (_tmp982_);
							_tmp984_ = _tmp983_;
							_tmp985_ = vala_delegate_get_has_target (_tmp984_);
							_tmp986_ = _tmp985_;
							if (_tmp986_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp987_;
								ValaCCodeExpression* _tmp988_ = NULL;
								ValaCCodeExpression* _tmp989_;
								ValaCCodeExpression* _tmp990_;
								ValaParameter* _tmp991_;
								gchar* _tmp992_;
								gchar* _tmp993_;
								gboolean _tmp994_;
								_tmp987_ = arg;
								_tmp989_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp987_, &_tmp988_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp988_;
								delegate_target = _tmp989_;
								_tmp990_ = delegate_target;
								_vala_assert (_tmp990_ != NULL, "delegate_target != null");
								_tmp991_ = param;
								_tmp992_ = vala_get_ccode_type ((ValaCodeNode*) _tmp991_);
								_tmp993_ = _tmp992_;
								_tmp994_ = g_strcmp0 (_tmp993_, "GClosure*") == 0;
								_g_free0 (_tmp993_);
								if (_tmp994_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp995_;
									ValaCCodeIdentifier* _tmp996_;
									ValaCCodeFunctionCall* _tmp997_;
									ValaCCodeFunctionCall* _tmp998_;
									ValaCCodeFunctionCall* _tmp999_;
									ValaCCodeExpression* _tmp1000_;
									ValaCCodeCastExpression* _tmp1001_;
									ValaCCodeCastExpression* _tmp1002_;
									ValaCCodeFunctionCall* _tmp1003_;
									ValaCCodeExpression* _tmp1004_;
									ValaCCodeFunctionCall* _tmp1005_;
									ValaCCodeExpression* _tmp1006_;
									ValaCCodeCastExpression* _tmp1007_;
									ValaCCodeCastExpression* _tmp1008_;
									ValaCCodeExpression* _tmp1009_;
									ValaCCodeIdentifier* _tmp1010_;
									ValaCCodeIdentifier* _tmp1011_;
									ValaCCodeBinaryExpression* _tmp1012_;
									ValaCCodeBinaryExpression* _tmp1013_;
									ValaCCodeIdentifier* _tmp1014_;
									ValaCCodeIdentifier* _tmp1015_;
									ValaCCodeFunctionCall* _tmp1016_;
									ValaCCodeConditionalExpression* _tmp1017_;
									_tmp995_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp996_ = _tmp995_;
									_tmp997_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp996_);
									_tmp998_ = _tmp997_;
									_vala_ccode_node_unref0 (_tmp996_);
									closure_new = _tmp998_;
									_tmp999_ = closure_new;
									_tmp1000_ = cexpr;
									_tmp1001_ = vala_ccode_cast_expression_new (_tmp1000_, "GCallback");
									_tmp1002_ = _tmp1001_;
									vala_ccode_function_call_add_argument (_tmp999_, (ValaCCodeExpression*) _tmp1002_);
									_vala_ccode_node_unref0 (_tmp1002_);
									_tmp1003_ = closure_new;
									_tmp1004_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1003_, _tmp1004_);
									_tmp1005_ = closure_new;
									_tmp1006_ = delegate_target_destroy_notify;
									_tmp1007_ = vala_ccode_cast_expression_new (_tmp1006_, "GClosureNotify");
									_tmp1008_ = _tmp1007_;
									vala_ccode_function_call_add_argument (_tmp1005_, (ValaCCodeExpression*) _tmp1008_);
									_vala_ccode_node_unref0 (_tmp1008_);
									_tmp1009_ = cexpr;
									_tmp1010_ = vala_ccode_identifier_new ("NULL");
									_tmp1011_ = _tmp1010_;
									_tmp1012_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1009_, (ValaCCodeExpression*) _tmp1011_);
									_tmp1013_ = _tmp1012_;
									_tmp1014_ = vala_ccode_identifier_new ("NULL");
									_tmp1015_ = _tmp1014_;
									_tmp1016_ = closure_new;
									_tmp1017_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1013_, (ValaCCodeExpression*) _tmp1015_, (ValaCCodeExpression*) _tmp1016_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1017_;
									_vala_ccode_node_unref0 (_tmp1015_);
									_vala_ccode_node_unref0 (_tmp1013_);
									_vala_ccode_node_unref0 (_tmp1011_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1018_;
									ValaParameter* _tmp1019_;
									ValaCCodeExpression* _tmp1020_;
									ValaDelegateType* _tmp1021_;
									_tmp1018_ = carg_map;
									_tmp1019_ = param;
									_tmp1020_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1018_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1019_), FALSE)), _tmp1020_);
									_tmp1021_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1021_)) {
										ValaCCodeExpression* _tmp1022_;
										ValaHashMap* _tmp1023_;
										ValaParameter* _tmp1024_;
										ValaCCodeExpression* _tmp1025_;
										_tmp1022_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1022_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1023_ = carg_map;
										_tmp1024_ = param;
										_tmp1025_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1023_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1024_) + 0.01, FALSE)), _tmp1025_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1026_;
							ValaDataType* _tmp1027_;
							ValaDataType* _tmp1028_;
							_tmp1026_ = param;
							_tmp1027_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1026_);
							_tmp1028_ = _tmp1027_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1028_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1029_;
								ValaParameter* _tmp1030_;
								ValaExpression* _tmp1031_;
								ValaCCodeExpression* _tmp1032_ = NULL;
								ValaCCodeExpression* _tmp1033_;
								ValaCCodeExpression* _tmp1034_;
								_tmp1029_ = carg_map;
								_tmp1030_ = param;
								_tmp1031_ = arg;
								_tmp1033_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1031_, &_tmp1032_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1032_;
								_tmp1034_ = _tmp1033_;
								vala_map_set ((ValaMap*) _tmp1029_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1030_), FALSE)), _tmp1034_);
								_vala_ccode_node_unref0 (_tmp1034_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1035_;
								ValaDataType* _tmp1036_;
								ValaDataType* _tmp1037_;
								_tmp1035_ = param;
								_tmp1036_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1035_);
								_tmp1037_ = _tmp1036_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1037_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1038_ = FALSE;
									ValaMethod* _tmp1039_;
									_tmp1039_ = m;
									if (_tmp1039_ != NULL) {
										ValaMethod* _tmp1040_;
										_tmp1040_ = m;
										_tmp1038_ = vala_get_ccode_simple_generics (_tmp1040_);
									} else {
										_tmp1038_ = FALSE;
									}
									if (_tmp1038_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1041_;
										ValaDataType* _tmp1042_;
										ValaDataType* _tmp1043_;
										ValaGenericType* _tmp1044_;
										gint type_param_index = 0;
										ValaMethod* _tmp1045_;
										ValaGenericType* _tmp1046_;
										ValaTypeParameter* _tmp1047_;
										ValaTypeParameter* _tmp1048_;
										const gchar* _tmp1049_;
										const gchar* _tmp1050_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1051_;
										ValaList* _tmp1052_;
										ValaList* _tmp1053_;
										gint _tmp1054_;
										gpointer _tmp1055_;
										ValaDataType* _tmp1056_;
										ValaParameter* _tmp1057_;
										ValaDataType* _tmp1058_;
										ValaDataType* _tmp1059_;
										gboolean _tmp1060_;
										gboolean _tmp1061_;
										_tmp1041_ = param;
										_tmp1042_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1041_);
										_tmp1043_ = _tmp1042_;
										_tmp1044_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1043_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1044_;
										_tmp1045_ = m;
										_tmp1046_ = generic_type;
										_tmp1047_ = vala_generic_type_get_type_parameter (_tmp1046_);
										_tmp1048_ = _tmp1047_;
										_tmp1049_ = vala_symbol_get_name ((ValaSymbol*) _tmp1048_);
										_tmp1050_ = _tmp1049_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1045_, _tmp1050_);
										_tmp1051_ = ma;
										_tmp1052_ = vala_member_access_get_type_arguments (_tmp1051_);
										_tmp1053_ = _tmp1052_;
										_tmp1054_ = type_param_index;
										_tmp1055_ = vala_list_get (_tmp1053_, _tmp1054_);
										_tmp1056_ = (ValaDataType*) _tmp1055_;
										_vala_iterable_unref0 (_tmp1053_);
										type_arg = _tmp1056_;
										_tmp1057_ = param;
										_tmp1058_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1057_);
										_tmp1059_ = _tmp1058_;
										_tmp1060_ = vala_data_type_get_value_owned (_tmp1059_);
										_tmp1061_ = _tmp1060_;
										if (_tmp1061_) {
											ValaDataType* _tmp1062_;
											_tmp1062_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1062_)) {
												ValaHashMap* _tmp1063_;
												ValaParameter* _tmp1064_;
												ValaDataType* _tmp1065_;
												ValaCCodeExpression* _tmp1066_;
												ValaCCodeExpression* _tmp1067_;
												_tmp1063_ = carg_map;
												_tmp1064_ = param;
												_tmp1065_ = type_arg;
												_tmp1066_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1065_, FALSE);
												_tmp1067_ = _tmp1066_;
												vala_map_set ((ValaMap*) _tmp1063_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1064_), FALSE)), _tmp1067_);
												_vala_ccode_node_unref0 (_tmp1067_);
											} else {
												ValaHashMap* _tmp1068_;
												ValaParameter* _tmp1069_;
												ValaCCodeConstant* _tmp1070_;
												ValaCCodeConstant* _tmp1071_;
												_tmp1068_ = carg_map;
												_tmp1069_ = param;
												_tmp1070_ = vala_ccode_constant_new ("NULL");
												_tmp1071_ = _tmp1070_;
												vala_map_set ((ValaMap*) _tmp1068_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1069_), FALSE)), (ValaCCodeExpression*) _tmp1071_);
												_vala_ccode_node_unref0 (_tmp1071_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1072_ = param;
					_tmp1073_ = arg;
					_tmp1074_ = cexpr;
					_tmp1075_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1072_, _tmp1073_, _tmp1074_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1075_;
				} else {
					ValaExpression* _tmp1076_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1077_;
					ValaDataType* _tmp1078_;
					ValaDataType* _tmp1079_;
					ValaParameter* _tmp1080_;
					ValaDataType* _tmp1081_;
					ValaDataType* _tmp1082_;
					gboolean _tmp1083_;
					gboolean _tmp1084_;
					ValaLocalVariable* _tmp1085_;
					ValaLocalVariable* _tmp1086_;
					ValaExpression* _tmp1087_;
					ValaLocalVariable* _tmp1088_;
					const gchar* _tmp1089_;
					const gchar* _tmp1090_;
					ValaCCodeExpression* _tmp1091_;
					ValaCCodeExpression* _tmp1092_;
					ValaExpression* _tmp1093_;
					ValaTargetValue* _tmp1094_;
					ValaTargetValue* _tmp1095_;
					ValaExpression* _tmp1096_;
					ValaDataType* _tmp1097_;
					ValaDataType* _tmp1098_;
					ValaExpression* _tmp1099_;
					ValaCCodeExpression* _tmp1100_;
					ValaCCodeExpression* _tmp1101_;
					ValaCCodeUnaryExpression* _tmp1102_;
					gboolean _tmp1103_ = FALSE;
					gboolean _tmp1104_ = FALSE;
					ValaParameter* _tmp1105_;
					_tmp1076_ = arg;
					vala_expression_set_target_value (_tmp1076_, NULL);
					_tmp1077_ = param;
					_tmp1078_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1077_);
					_tmp1079_ = _tmp1078_;
					_tmp1080_ = param;
					_tmp1081_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1080_);
					_tmp1082_ = _tmp1081_;
					_tmp1083_ = vala_data_type_get_value_owned (_tmp1082_);
					_tmp1084_ = _tmp1083_;
					_tmp1085_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1079_, _tmp1084_, NULL, TRUE);
					temp_var = _tmp1085_;
					_tmp1086_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1086_, FALSE);
					_tmp1087_ = arg;
					_tmp1088_ = temp_var;
					_tmp1089_ = vala_symbol_get_name ((ValaSymbol*) _tmp1088_);
					_tmp1090_ = _tmp1089_;
					_tmp1091_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1090_);
					_tmp1092_ = _tmp1091_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1087_, _tmp1092_);
					_vala_ccode_node_unref0 (_tmp1092_);
					_tmp1093_ = arg;
					_tmp1094_ = vala_expression_get_target_value (_tmp1093_);
					_tmp1095_ = _tmp1094_;
					_tmp1096_ = arg;
					_tmp1097_ = vala_expression_get_target_type (_tmp1096_);
					_tmp1098_ = _tmp1097_;
					vala_target_value_set_value_type (_tmp1095_, _tmp1098_);
					_tmp1099_ = arg;
					_tmp1100_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1099_);
					_tmp1101_ = _tmp1100_;
					_tmp1102_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1101_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1102_;
					_vala_ccode_node_unref0 (_tmp1101_);
					_tmp1105_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1105_)) {
						ValaParameter* _tmp1106_;
						ValaDataType* _tmp1107_;
						ValaDataType* _tmp1108_;
						_tmp1106_ = param;
						_tmp1107_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1106_);
						_tmp1108_ = _tmp1107_;
						_tmp1104_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1108_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1104_ = FALSE;
					}
					if (_tmp1104_) {
						ValaParameter* _tmp1109_;
						ValaDataType* _tmp1110_;
						ValaDataType* _tmp1111_;
						gboolean _tmp1112_;
						gboolean _tmp1113_;
						_tmp1109_ = param;
						_tmp1110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1109_);
						_tmp1111_ = _tmp1110_;
						_tmp1112_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1111_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1113_ = _tmp1112_;
						_tmp1103_ = !_tmp1113_;
					} else {
						_tmp1103_ = FALSE;
					}
					if (_tmp1103_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1114_;
						ValaDataType* _tmp1115_;
						ValaDataType* _tmp1116_;
						ValaArrayType* _tmp1117_;
						ValaDataType* array_length_type = NULL;
						ValaDataType* _tmp1118_;
						ValaDataType* _tmp1119_;
						ValaParameter* _tmp1120_;
						gchar* _tmp1121_;
						gchar* _tmp1122_;
						gboolean _tmp1123_;
						_tmp1114_ = param;
						_tmp1115_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1114_);
						_tmp1116_ = _tmp1115_;
						_tmp1117_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1116_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1117_;
						_tmp1118_ = ((ValaCCodeBaseModule*) self)->int_type;
						_tmp1119_ = _vala_code_node_ref0 (_tmp1118_);
						array_length_type = _tmp1119_;
						_tmp1120_ = param;
						_tmp1121_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1120_);
						_tmp1122_ = _tmp1121_;
						_tmp1123_ = _tmp1122_ != NULL;
						_g_free0 (_tmp1122_);
						if (_tmp1123_) {
							ValaParameter* _tmp1124_;
							gchar* _tmp1125_;
							gchar* _tmp1126_;
							ValaCType* _tmp1127_;
							_tmp1124_ = param;
							_tmp1125_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1124_);
							_tmp1126_ = _tmp1125_;
							_tmp1127_ = vala_ctype_new (_tmp1126_, "0");
							_vala_code_node_unref0 (array_length_type);
							array_length_type = (ValaDataType*) _tmp1127_;
							_g_free0 (_tmp1126_);
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1128_ = FALSE;
								_tmp1128_ = TRUE;
								while (TRUE) {
									gint _tmp1130_;
									ValaArrayType* _tmp1131_;
									gint _tmp1132_;
									gint _tmp1133_;
									ValaLocalVariable* temp_array_length = NULL;
									ValaDataType* _tmp1134_;
									ValaLocalVariable* _tmp1135_;
									ValaLocalVariable* _tmp1136_;
									ValaExpression* _tmp1137_;
									ValaLocalVariable* _tmp1138_;
									const gchar* _tmp1139_;
									const gchar* _tmp1140_;
									ValaCCodeExpression* _tmp1141_;
									ValaCCodeExpression* _tmp1142_;
									ValaHashMap* _tmp1143_;
									ValaParameter* _tmp1144_;
									gint _tmp1145_;
									ValaExpression* _tmp1146_;
									ValaList* _tmp1147_;
									ValaList* _tmp1148_;
									gint _tmp1149_;
									gpointer _tmp1150_;
									ValaCCodeExpression* _tmp1151_;
									ValaCCodeUnaryExpression* _tmp1152_;
									ValaCCodeUnaryExpression* _tmp1153_;
									if (!_tmp1128_) {
										gint _tmp1129_;
										_tmp1129_ = dim;
										dim = _tmp1129_ + 1;
									}
									_tmp1128_ = FALSE;
									_tmp1130_ = dim;
									_tmp1131_ = array_type;
									_tmp1132_ = vala_array_type_get_rank (_tmp1131_);
									_tmp1133_ = _tmp1132_;
									if (!(_tmp1130_ <= _tmp1133_)) {
										break;
									}
									_tmp1134_ = array_length_type;
									_tmp1135_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1134_, TRUE, NULL, FALSE);
									temp_array_length = _tmp1135_;
									_tmp1136_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1136_, FALSE);
									_tmp1137_ = arg;
									_tmp1138_ = temp_array_length;
									_tmp1139_ = vala_symbol_get_name ((ValaSymbol*) _tmp1138_);
									_tmp1140_ = _tmp1139_;
									_tmp1141_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1140_);
									_tmp1142_ = _tmp1141_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1137_, _tmp1142_);
									_vala_ccode_node_unref0 (_tmp1142_);
									_tmp1143_ = carg_map;
									_tmp1144_ = param;
									_tmp1145_ = dim;
									_tmp1146_ = arg;
									_tmp1147_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1146_);
									_tmp1148_ = _tmp1147_;
									_tmp1149_ = dim;
									_tmp1150_ = vala_list_get (_tmp1148_, _tmp1149_ - 1);
									_tmp1151_ = (ValaCCodeExpression*) _tmp1150_;
									_tmp1152_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1151_);
									_tmp1153_ = _tmp1152_;
									vala_map_set ((ValaMap*) _tmp1143_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1144_) + (0.01 * _tmp1145_), FALSE)), (ValaCCodeExpression*) _tmp1153_);
									_vala_ccode_node_unref0 (_tmp1153_);
									_vala_ccode_node_unref0 (_tmp1151_);
									_vala_iterable_unref0 (_tmp1148_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_vala_code_node_unref0 (array_length_type);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1154_;
						ValaDataType* _tmp1155_;
						ValaDataType* _tmp1156_;
						_tmp1154_ = param;
						_tmp1155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1154_);
						_tmp1156_ = _tmp1155_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1156_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1157_;
							ValaDataType* _tmp1158_;
							ValaDataType* _tmp1159_;
							ValaDelegateType* _tmp1160_;
							ValaDelegateType* _tmp1161_;
							ValaDelegate* _tmp1162_;
							ValaDelegate* _tmp1163_;
							gboolean _tmp1164_;
							gboolean _tmp1165_;
							_tmp1157_ = param;
							_tmp1158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1157_);
							_tmp1159_ = _tmp1158_;
							_tmp1160_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1159_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1160_;
							_tmp1161_ = deleg_type;
							_tmp1162_ = vala_delegate_type_get_delegate_symbol (_tmp1161_);
							_tmp1163_ = _tmp1162_;
							_tmp1164_ = vala_delegate_get_has_target (_tmp1163_);
							_tmp1165_ = _tmp1164_;
							if (_tmp1165_) {
								ValaVoidType* _tmp1166_;
								ValaVoidType* _tmp1167_;
								ValaPointerType* _tmp1168_;
								ValaPointerType* _tmp1169_;
								ValaLocalVariable* _tmp1170_;
								ValaLocalVariable* _tmp1171_;
								ValaExpression* _tmp1172_;
								ValaLocalVariable* _tmp1173_;
								const gchar* _tmp1174_;
								const gchar* _tmp1175_;
								ValaCCodeExpression* _tmp1176_;
								ValaCCodeExpression* _tmp1177_;
								ValaHashMap* _tmp1178_;
								ValaParameter* _tmp1179_;
								ValaExpression* _tmp1180_;
								ValaCCodeExpression* _tmp1181_;
								ValaCCodeExpression* _tmp1182_;
								ValaCCodeUnaryExpression* _tmp1183_;
								ValaCCodeUnaryExpression* _tmp1184_;
								ValaDelegateType* _tmp1185_;
								_tmp1166_ = vala_void_type_new (NULL);
								_tmp1167_ = _tmp1166_;
								_tmp1168_ = vala_pointer_type_new ((ValaDataType*) _tmp1167_, NULL);
								_tmp1169_ = _tmp1168_;
								_tmp1170_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1169_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1170_;
								_vala_code_node_unref0 (_tmp1169_);
								_vala_code_node_unref0 (_tmp1167_);
								_tmp1171_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1171_, FALSE);
								_tmp1172_ = arg;
								_tmp1173_ = temp_var;
								_tmp1174_ = vala_symbol_get_name ((ValaSymbol*) _tmp1173_);
								_tmp1175_ = _tmp1174_;
								_tmp1176_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1175_);
								_tmp1177_ = _tmp1176_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1172_, _tmp1177_);
								_vala_ccode_node_unref0 (_tmp1177_);
								_tmp1178_ = carg_map;
								_tmp1179_ = param;
								_tmp1180_ = arg;
								_tmp1181_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1180_);
								_tmp1182_ = _tmp1181_;
								_tmp1183_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1182_);
								_tmp1184_ = _tmp1183_;
								vala_map_set ((ValaMap*) _tmp1178_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1179_), FALSE)), (ValaCCodeExpression*) _tmp1184_);
								_vala_ccode_node_unref0 (_tmp1184_);
								_vala_ccode_node_unref0 (_tmp1182_);
								_tmp1185_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1185_)) {
									ValaDataType* _tmp1186_;
									ValaLocalVariable* _tmp1187_;
									ValaLocalVariable* _tmp1188_;
									ValaExpression* _tmp1189_;
									ValaLocalVariable* _tmp1190_;
									const gchar* _tmp1191_;
									const gchar* _tmp1192_;
									ValaCCodeExpression* _tmp1193_;
									ValaCCodeExpression* _tmp1194_;
									ValaHashMap* _tmp1195_;
									ValaParameter* _tmp1196_;
									ValaExpression* _tmp1197_;
									ValaCCodeExpression* _tmp1198_;
									ValaCCodeExpression* _tmp1199_;
									ValaCCodeUnaryExpression* _tmp1200_;
									ValaCCodeUnaryExpression* _tmp1201_;
									_tmp1186_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1187_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1186_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1187_;
									_tmp1188_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1188_, FALSE);
									_tmp1189_ = arg;
									_tmp1190_ = temp_var;
									_tmp1191_ = vala_symbol_get_name ((ValaSymbol*) _tmp1190_);
									_tmp1192_ = _tmp1191_;
									_tmp1193_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1192_);
									_tmp1194_ = _tmp1193_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1189_, _tmp1194_);
									_vala_ccode_node_unref0 (_tmp1194_);
									_tmp1195_ = carg_map;
									_tmp1196_ = param;
									_tmp1197_ = arg;
									_tmp1198_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1197_);
									_tmp1199_ = _tmp1198_;
									_tmp1200_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1199_);
									_tmp1201_ = _tmp1200_;
									vala_map_set ((ValaMap*) _tmp1195_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1196_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1201_);
									_vala_ccode_node_unref0 (_tmp1201_);
									_vala_ccode_node_unref0 (_tmp1199_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1202_ = param;
				_tmp1203_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1202_);
				_tmp1204_ = _tmp1203_;
				_tmp1205_ = _tmp1204_ != NULL;
				_g_free0 (_tmp1204_);
				if (_tmp1205_) {
					ValaCCodeExpression* _tmp1206_;
					ValaParameter* _tmp1207_;
					gchar* _tmp1208_;
					gchar* _tmp1209_;
					ValaCCodeCastExpression* _tmp1210_;
					_tmp1206_ = cexpr;
					_tmp1207_ = param;
					_tmp1208_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1207_);
					_tmp1209_ = _tmp1208_;
					_tmp1210_ = vala_ccode_cast_expression_new (_tmp1206_, _tmp1209_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1210_;
					_g_free0 (_tmp1209_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1211_;
				ValaUnaryExpression* _tmp1212_;
				gboolean _tmp1213_ = FALSE;
				gboolean _tmp1214_ = FALSE;
				gboolean _tmp1215_;
				_tmp1211_ = arg;
				_tmp1212_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1211_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1211_) : NULL);
				unary = _tmp1212_;
				_tmp1215_ = ellipsis;
				if (_tmp1215_) {
					ValaUnaryExpression* _tmp1216_;
					_tmp1216_ = unary;
					_tmp1214_ = _tmp1216_ != NULL;
				} else {
					_tmp1214_ = FALSE;
				}
				if (_tmp1214_) {
					ValaUnaryExpression* _tmp1217_;
					ValaUnaryOperator _tmp1218_;
					ValaUnaryOperator _tmp1219_;
					_tmp1217_ = unary;
					_tmp1218_ = vala_unary_expression_get_operator (_tmp1217_);
					_tmp1219_ = _tmp1218_;
					_tmp1213_ = _tmp1219_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1213_ = FALSE;
				}
				if (_tmp1213_) {
					ValaHashMap* _tmp1220_;
					ValaHashMap* _tmp1221_;
					ValaExpression* _tmp1222_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1223_;
					ValaDataType* _tmp1224_;
					ValaDataType* _tmp1225_;
					ValaExpression* _tmp1226_;
					ValaDataType* _tmp1227_;
					ValaDataType* _tmp1228_;
					gboolean _tmp1229_;
					gboolean _tmp1230_;
					ValaLocalVariable* _tmp1231_;
					ValaLocalVariable* _tmp1232_;
					ValaExpression* _tmp1233_;
					ValaLocalVariable* _tmp1234_;
					const gchar* _tmp1235_;
					const gchar* _tmp1236_;
					ValaCCodeExpression* _tmp1237_;
					ValaCCodeExpression* _tmp1238_;
					ValaExpression* _tmp1239_;
					ValaTargetValue* _tmp1240_;
					ValaTargetValue* _tmp1241_;
					ValaExpression* _tmp1242_;
					ValaDataType* _tmp1243_;
					ValaDataType* _tmp1244_;
					ValaExpression* _tmp1245_;
					ValaCCodeExpression* _tmp1246_;
					ValaCCodeExpression* _tmp1247_;
					ValaCCodeUnaryExpression* _tmp1248_;
					_tmp1220_ = out_arg_map;
					_tmp1221_ = _vala_map_ref0 (_tmp1220_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1221_;
					_tmp1222_ = arg;
					vala_expression_set_target_value (_tmp1222_, NULL);
					_tmp1223_ = arg;
					_tmp1224_ = vala_expression_get_value_type (_tmp1223_);
					_tmp1225_ = _tmp1224_;
					_tmp1226_ = arg;
					_tmp1227_ = vala_expression_get_value_type (_tmp1226_);
					_tmp1228_ = _tmp1227_;
					_tmp1229_ = vala_data_type_get_value_owned (_tmp1228_);
					_tmp1230_ = _tmp1229_;
					_tmp1231_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1225_, _tmp1230_, NULL, TRUE);
					temp_var = _tmp1231_;
					_tmp1232_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1232_, FALSE);
					_tmp1233_ = arg;
					_tmp1234_ = temp_var;
					_tmp1235_ = vala_symbol_get_name ((ValaSymbol*) _tmp1234_);
					_tmp1236_ = _tmp1235_;
					_tmp1237_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1236_);
					_tmp1238_ = _tmp1237_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1233_, _tmp1238_);
					_vala_ccode_node_unref0 (_tmp1238_);
					_tmp1239_ = arg;
					_tmp1240_ = vala_expression_get_target_value (_tmp1239_);
					_tmp1241_ = _tmp1240_;
					_tmp1242_ = arg;
					_tmp1243_ = vala_expression_get_value_type (_tmp1242_);
					_tmp1244_ = _tmp1243_;
					vala_target_value_set_value_type (_tmp1241_, _tmp1244_);
					_tmp1245_ = arg;
					_tmp1246_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1245_);
					_tmp1247_ = _tmp1246_;
					_tmp1248_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1247_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1248_;
					_vala_ccode_node_unref0 (_tmp1247_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1249_;
					ValaCCodeExpression* _tmp1250_;
					ValaCCodeExpression* _tmp1251_;
					_tmp1249_ = arg;
					_tmp1250_ = cexpr;
					_tmp1251_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1249_, _tmp1250_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1251_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1253_ = param;
			if (_tmp1253_ != NULL) {
				ValaParameter* _tmp1254_;
				_tmp1254_ = param;
				_tmp1252_ = vala_get_ccode_pos (_tmp1254_);
			} else {
				gint _tmp1255_;
				_tmp1255_ = i;
				_tmp1252_ = (gdouble) _tmp1255_;
			}
			_tmp1256_ = ellipsis;
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1252_, _tmp1256_);
			_tmp1257_ = carg_map;
			_tmp1258_ = arg_pos;
			_tmp1259_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1257_, (gpointer) ((gintptr) _tmp1258_), _tmp1259_);
			_tmp1261_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1261_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1262_;
				_tmp1262_ = ellipsis;
				_tmp1260_ = _tmp1262_;
			} else {
				_tmp1260_ = FALSE;
			}
			if (_tmp1260_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1263_;
				ValaNamedArgument* _tmp1264_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1265_;
				const gchar* _tmp1266_;
				const gchar* _tmp1267_;
				gchar** _tmp1268_;
				gchar** _tmp1269_;
				gchar** _tmp1270_;
				gint _tmp1270__length1;
				gchar* _tmp1271_;
				gchar* _tmp1272_;
				ValaHashMap* _tmp1273_;
				gint _tmp1274_;
				gboolean _tmp1275_;
				const gchar* _tmp1276_;
				gchar* _tmp1277_;
				gchar* _tmp1278_;
				ValaCCodeConstant* _tmp1279_;
				ValaCCodeConstant* _tmp1280_;
				_tmp1263_ = arg;
				_tmp1264_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1263_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1264_;
				_tmp1265_ = named_arg;
				_tmp1266_ = vala_named_argument_get_name (_tmp1265_);
				_tmp1267_ = _tmp1266_;
				_tmp1269_ = _tmp1268_ = g_strsplit (_tmp1267_, "_", 0);
				_tmp1270_ = _tmp1269_;
				_tmp1270__length1 = _vala_array_length (_tmp1268_);
				_tmp1271_ = _vala_g_strjoinv ("-", _tmp1270_, _vala_array_length (_tmp1268_));
				_tmp1272_ = _tmp1271_;
				_tmp1270_ = (_vala_array_free (_tmp1270_, _tmp1270__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1272_;
				_tmp1273_ = carg_map;
				_tmp1274_ = i;
				_tmp1275_ = ellipsis;
				_tmp1276_ = name;
				_tmp1277_ = g_strdup_printf ("\"%s\"", _tmp1276_);
				_tmp1278_ = _tmp1277_;
				_tmp1279_ = vala_ccode_constant_new (_tmp1278_);
				_tmp1280_ = _tmp1279_;
				vala_map_set ((ValaMap*) _tmp1273_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1274_ - 0.1, _tmp1275_)), (ValaCCodeExpression*) _tmp1280_);
				_vala_ccode_node_unref0 (_tmp1280_);
				_g_free0 (_tmp1278_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1281_ = i;
			i = _tmp1281_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1282_ = params_it;
	if (vala_iterator_next (_tmp1282_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1283_;
		gpointer _tmp1284_;
		gboolean _tmp1285_ = FALSE;
		ValaParameter* _tmp1286_;
		gboolean _tmp1287_;
		gboolean _tmp1288_;
		_tmp1283_ = params_it;
		_tmp1284_ = vala_iterator_get (_tmp1283_);
		param = (ValaParameter*) _tmp1284_;
		_tmp1286_ = param;
		_tmp1287_ = vala_parameter_get_params_array (_tmp1286_);
		_tmp1288_ = _tmp1287_;
		if (_tmp1288_) {
			_tmp1285_ = TRUE;
		} else {
			ValaParameter* _tmp1289_;
			gboolean _tmp1290_;
			gboolean _tmp1291_;
			_tmp1289_ = param;
			_tmp1290_ = vala_parameter_get_ellipsis (_tmp1289_);
			_tmp1291_ = _tmp1290_;
			_tmp1285_ = _tmp1291_;
		}
		_vala_assert (_tmp1285_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1294_ = m;
	if (_tmp1294_ != NULL) {
		ValaMethod* _tmp1295_;
		ValaDataType* _tmp1296_;
		ValaDataType* _tmp1297_;
		_tmp1295_ = m;
		_tmp1296_ = vala_callable_get_return_type ((ValaCallable*) _tmp1295_);
		_tmp1297_ = _tmp1296_;
		_tmp1293_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1297_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1293_ = FALSE;
	}
	if (_tmp1293_) {
		ValaCCodeFunctionCall* _tmp1298_;
		ValaCCodeFunctionCall* _tmp1299_;
		_tmp1298_ = async_call;
		_tmp1299_ = ccall;
		_tmp1292_ = _tmp1298_ != _tmp1299_;
	} else {
		_tmp1292_ = FALSE;
	}
	if (_tmp1292_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1300_;
		ValaDataType* _tmp1301_;
		ValaDataType* _tmp1302_;
		ValaArrayType* _tmp1303_;
		_tmp1300_ = m;
		_tmp1301_ = vala_callable_get_return_type ((ValaCallable*) _tmp1300_);
		_tmp1302_ = _tmp1301_;
		_tmp1303_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1302_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1303_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1304_ = FALSE;
				_tmp1304_ = TRUE;
				while (TRUE) {
					gint _tmp1306_;
					ValaArrayType* _tmp1307_;
					gint _tmp1308_;
					gint _tmp1309_;
					ValaMethod* _tmp1310_;
					if (!_tmp1304_) {
						gint _tmp1305_;
						_tmp1305_ = dim;
						dim = _tmp1305_ + 1;
					}
					_tmp1304_ = FALSE;
					_tmp1306_ = dim;
					_tmp1307_ = array_type;
					_tmp1308_ = vala_array_type_get_rank (_tmp1307_);
					_tmp1309_ = _tmp1308_;
					if (!(_tmp1306_ <= _tmp1309_)) {
						break;
					}
					_tmp1310_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1310_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1311_;
						ValaDataType* _tmp1312_;
						ValaDataType* _tmp1313_;
						ValaLocalVariable* _tmp1314_;
						ValaLocalVariable* _tmp1315_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1316_;
						const gchar* _tmp1317_;
						const gchar* _tmp1318_;
						ValaCCodeExpression* _tmp1319_;
						ValaLocalVariable* _tmp1320_;
						ValaCCodeExpression* _tmp1321_;
						ValaCCodeExpression* _tmp1322_;
						ValaCCodeAssignment* _tmp1323_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1324_;
						ValaCCodeIdentifier* _tmp1325_;
						ValaCCodeFunctionCall* _tmp1326_;
						ValaCCodeFunctionCall* _tmp1327_;
						ValaCCodeFunctionCall* _tmp1328_;
						ValaCCodeExpression* _tmp1329_;
						ValaCCodeFunctionCall* _tmp1330_;
						_tmp1311_ = itype;
						_tmp1312_ = vala_data_type_get_return_type (_tmp1311_);
						_tmp1313_ = _tmp1312_;
						_tmp1314_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1313_, TRUE, NULL, FALSE);
						_tmp1315_ = _tmp1314_;
						_vala_code_node_unref0 (_tmp1313_);
						temp_var = _tmp1315_;
						_tmp1316_ = temp_var;
						_tmp1317_ = vala_symbol_get_name ((ValaSymbol*) _tmp1316_);
						_tmp1318_ = _tmp1317_;
						_tmp1319_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1318_);
						temp_ref = _tmp1319_;
						_tmp1320_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1320_, FALSE);
						_tmp1321_ = temp_ref;
						_tmp1322_ = ccall_expr;
						_tmp1323_ = vala_ccode_assignment_new (_tmp1321_, _tmp1322_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1323_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1324_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1325_ = _tmp1324_;
						_tmp1326_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1325_);
						_tmp1327_ = _tmp1326_;
						_vala_ccode_node_unref0 (_tmp1325_);
						len_call = _tmp1327_;
						_tmp1328_ = len_call;
						_tmp1329_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1328_, _tmp1329_);
						_tmp1330_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1330_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1331_;
						_tmp1331_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1331_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1332_;
							gchar* _tmp1333_;
							gchar* _tmp1334_;
							gboolean _tmp1335_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1344_;
							const gchar* _tmp1345_;
							const gchar* _tmp1346_;
							ValaCCodeExpression* _tmp1347_;
							ValaLocalVariable* _tmp1348_;
							ValaHashMap* _tmp1349_;
							ValaMethod* _tmp1350_;
							gint _tmp1351_;
							ValaCCodeExpression* _tmp1352_;
							ValaCCodeUnaryExpression* _tmp1353_;
							ValaCCodeUnaryExpression* _tmp1354_;
							ValaCCodeExpression* _tmp1355_;
							_tmp1332_ = m;
							_tmp1333_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1332_);
							_tmp1334_ = _tmp1333_;
							_tmp1335_ = _tmp1334_ == NULL;
							_g_free0 (_tmp1334_);
							if (_tmp1335_) {
								ValaDataType* _tmp1336_;
								ValaLocalVariable* _tmp1337_;
								_tmp1336_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1337_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1336_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1337_;
							} else {
								ValaMethod* _tmp1338_;
								gchar* _tmp1339_;
								gchar* _tmp1340_;
								ValaCType* _tmp1341_;
								ValaCType* _tmp1342_;
								ValaLocalVariable* _tmp1343_;
								_tmp1338_ = m;
								_tmp1339_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1338_);
								_tmp1340_ = _tmp1339_;
								_tmp1341_ = vala_ctype_new (_tmp1340_, "0");
								_tmp1342_ = _tmp1341_;
								_tmp1343_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1342_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1343_;
								_vala_code_node_unref0 (_tmp1342_);
								_g_free0 (_tmp1340_);
							}
							_tmp1344_ = temp_var;
							_tmp1345_ = vala_symbol_get_name ((ValaSymbol*) _tmp1344_);
							_tmp1346_ = _tmp1345_;
							_tmp1347_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1346_);
							temp_ref = _tmp1347_;
							_tmp1348_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1348_, FALSE);
							_tmp1349_ = out_arg_map;
							_tmp1350_ = m;
							_tmp1351_ = dim;
							_tmp1352_ = temp_ref;
							_tmp1353_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1352_);
							_tmp1354_ = _tmp1353_;
							vala_map_set ((ValaMap*) _tmp1349_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1350_) + (0.01 * _tmp1351_), FALSE)), (ValaCCodeExpression*) _tmp1354_);
							_vala_ccode_node_unref0 (_tmp1354_);
							_tmp1355_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1355_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1356_;
							gchar* _tmp1357_;
							gchar* _tmp1358_;
							gboolean _tmp1359_;
							_tmp1356_ = m;
							_tmp1357_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1356_);
							_tmp1358_ = _tmp1357_;
							_tmp1359_ = _tmp1358_ != NULL;
							_g_free0 (_tmp1358_);
							if (_tmp1359_) {
								ValaMethod* _tmp1360_;
								gchar* _tmp1361_;
								gchar* _tmp1362_;
								ValaCCodeConstant* _tmp1363_;
								ValaCCodeConstant* _tmp1364_;
								_tmp1360_ = m;
								_tmp1361_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1360_);
								_tmp1362_ = _tmp1361_;
								_tmp1363_ = vala_ccode_constant_new (_tmp1362_);
								_tmp1364_ = _tmp1363_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1364_);
								_vala_ccode_node_unref0 (_tmp1364_);
								_g_free0 (_tmp1362_);
							} else {
								ValaCCodeConstant* _tmp1365_;
								ValaCCodeConstant* _tmp1366_;
								_tmp1365_ = vala_ccode_constant_new ("-1");
								_tmp1366_ = _tmp1365_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1366_);
								_vala_ccode_node_unref0 (_tmp1366_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1367_ = FALSE;
		gboolean _tmp1368_ = FALSE;
		ValaMethod* _tmp1369_;
		_tmp1369_ = m;
		if (_tmp1369_ != NULL) {
			ValaMethod* _tmp1370_;
			ValaDataType* _tmp1371_;
			ValaDataType* _tmp1372_;
			_tmp1370_ = m;
			_tmp1371_ = vala_callable_get_return_type ((ValaCallable*) _tmp1370_);
			_tmp1372_ = _tmp1371_;
			_tmp1368_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1372_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1368_ = FALSE;
		}
		if (_tmp1368_) {
			ValaCCodeFunctionCall* _tmp1373_;
			ValaCCodeFunctionCall* _tmp1374_;
			_tmp1373_ = async_call;
			_tmp1374_ = ccall;
			_tmp1367_ = _tmp1373_ != _tmp1374_;
		} else {
			_tmp1367_ = FALSE;
		}
		if (_tmp1367_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1375_;
			ValaDataType* _tmp1376_;
			ValaDataType* _tmp1377_;
			ValaDelegateType* _tmp1378_;
			ValaDelegateType* _tmp1379_;
			ValaDelegate* _tmp1380_;
			ValaDelegate* _tmp1381_;
			gboolean _tmp1382_;
			gboolean _tmp1383_;
			_tmp1375_ = m;
			_tmp1376_ = vala_callable_get_return_type ((ValaCallable*) _tmp1375_);
			_tmp1377_ = _tmp1376_;
			_tmp1378_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1377_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1378_;
			_tmp1379_ = deleg_type;
			_tmp1380_ = vala_delegate_type_get_delegate_symbol (_tmp1379_);
			_tmp1381_ = _tmp1380_;
			_tmp1382_ = vala_delegate_get_has_target (_tmp1381_);
			_tmp1383_ = _tmp1382_;
			if (_tmp1383_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1384_;
				ValaVoidType* _tmp1385_;
				ValaPointerType* _tmp1386_;
				ValaPointerType* _tmp1387_;
				ValaLocalVariable* _tmp1388_;
				ValaLocalVariable* _tmp1389_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1390_;
				const gchar* _tmp1391_;
				const gchar* _tmp1392_;
				ValaCCodeExpression* _tmp1393_;
				ValaLocalVariable* _tmp1394_;
				ValaHashMap* _tmp1395_;
				ValaMethod* _tmp1396_;
				ValaCCodeExpression* _tmp1397_;
				ValaCCodeUnaryExpression* _tmp1398_;
				ValaCCodeUnaryExpression* _tmp1399_;
				ValaCCodeExpression* _tmp1400_;
				ValaDelegateType* _tmp1401_;
				_tmp1384_ = vala_void_type_new (NULL);
				_tmp1385_ = _tmp1384_;
				_tmp1386_ = vala_pointer_type_new ((ValaDataType*) _tmp1385_, NULL);
				_tmp1387_ = _tmp1386_;
				_tmp1388_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1387_, TRUE, NULL, TRUE);
				_tmp1389_ = _tmp1388_;
				_vala_code_node_unref0 (_tmp1387_);
				_vala_code_node_unref0 (_tmp1385_);
				temp_var = _tmp1389_;
				_tmp1390_ = temp_var;
				_tmp1391_ = vala_symbol_get_name ((ValaSymbol*) _tmp1390_);
				_tmp1392_ = _tmp1391_;
				_tmp1393_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1392_);
				temp_ref = _tmp1393_;
				_tmp1394_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1394_, FALSE);
				_tmp1395_ = out_arg_map;
				_tmp1396_ = m;
				_tmp1397_ = temp_ref;
				_tmp1398_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1397_);
				_tmp1399_ = _tmp1398_;
				vala_map_set ((ValaMap*) _tmp1395_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1396_), FALSE)), (ValaCCodeExpression*) _tmp1399_);
				_vala_ccode_node_unref0 (_tmp1399_);
				_tmp1400_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1400_);
				_tmp1401_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1401_)) {
					ValaDataType* _tmp1402_;
					ValaLocalVariable* _tmp1403_;
					ValaLocalVariable* _tmp1404_;
					const gchar* _tmp1405_;
					const gchar* _tmp1406_;
					ValaCCodeExpression* _tmp1407_;
					ValaLocalVariable* _tmp1408_;
					ValaHashMap* _tmp1409_;
					ValaMethod* _tmp1410_;
					ValaCCodeExpression* _tmp1411_;
					ValaCCodeUnaryExpression* _tmp1412_;
					ValaCCodeUnaryExpression* _tmp1413_;
					ValaCCodeExpression* _tmp1414_;
					_tmp1402_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1403_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1402_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1403_;
					_tmp1404_ = temp_var;
					_tmp1405_ = vala_symbol_get_name ((ValaSymbol*) _tmp1404_);
					_tmp1406_ = _tmp1405_;
					_tmp1407_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1406_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1407_;
					_tmp1408_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1408_, FALSE);
					_tmp1409_ = out_arg_map;
					_tmp1410_ = m;
					_tmp1411_ = temp_ref;
					_tmp1412_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1411_);
					_tmp1413_ = _tmp1412_;
					vala_map_set ((ValaMap*) _tmp1409_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1410_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1413_);
					_vala_ccode_node_unref0 (_tmp1413_);
					_tmp1414_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1414_);
				} else {
					ValaCCodeConstant* _tmp1415_;
					ValaCCodeConstant* _tmp1416_;
					_tmp1415_ = vala_ccode_constant_new ("NULL");
					_tmp1416_ = _tmp1415_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1416_);
					_vala_ccode_node_unref0 (_tmp1416_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1417_;
				ValaCCodeConstant* _tmp1418_;
				_tmp1417_ = vala_ccode_constant_new ("NULL");
				_tmp1418_ = _tmp1417_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1418_);
				_vala_ccode_node_unref0 (_tmp1418_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1420_ = deleg;
	if (_tmp1420_ != NULL) {
		ValaDelegate* _tmp1421_;
		ValaDataType* _tmp1422_;
		ValaDataType* _tmp1423_;
		_tmp1421_ = deleg;
		_tmp1422_ = vala_callable_get_return_type ((ValaCallable*) _tmp1421_);
		_tmp1423_ = _tmp1422_;
		_tmp1419_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1423_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1419_ = FALSE;
	}
	if (_tmp1419_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1424_;
		ValaDataType* _tmp1425_;
		ValaDataType* _tmp1426_;
		ValaArrayType* _tmp1427_;
		_tmp1424_ = deleg;
		_tmp1425_ = vala_callable_get_return_type ((ValaCallable*) _tmp1424_);
		_tmp1426_ = _tmp1425_;
		_tmp1427_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1426_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1427_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1428_ = FALSE;
				_tmp1428_ = TRUE;
				while (TRUE) {
					gint _tmp1430_;
					ValaArrayType* _tmp1431_;
					gint _tmp1432_;
					gint _tmp1433_;
					ValaDelegate* _tmp1434_;
					if (!_tmp1428_) {
						gint _tmp1429_;
						_tmp1429_ = dim;
						dim = _tmp1429_ + 1;
					}
					_tmp1428_ = FALSE;
					_tmp1430_ = dim;
					_tmp1431_ = array_type;
					_tmp1432_ = vala_array_type_get_rank (_tmp1431_);
					_tmp1433_ = _tmp1432_;
					if (!(_tmp1430_ <= _tmp1433_)) {
						break;
					}
					_tmp1434_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1434_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1435_;
						ValaDataType* _tmp1436_;
						ValaDataType* _tmp1437_;
						ValaLocalVariable* _tmp1438_;
						ValaLocalVariable* _tmp1439_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1440_;
						const gchar* _tmp1441_;
						const gchar* _tmp1442_;
						ValaCCodeExpression* _tmp1443_;
						ValaLocalVariable* _tmp1444_;
						ValaCCodeExpression* _tmp1445_;
						ValaCCodeExpression* _tmp1446_;
						ValaCCodeAssignment* _tmp1447_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1448_;
						ValaCCodeIdentifier* _tmp1449_;
						ValaCCodeFunctionCall* _tmp1450_;
						ValaCCodeFunctionCall* _tmp1451_;
						ValaCCodeFunctionCall* _tmp1452_;
						ValaCCodeExpression* _tmp1453_;
						ValaCCodeFunctionCall* _tmp1454_;
						_tmp1435_ = itype;
						_tmp1436_ = vala_data_type_get_return_type (_tmp1435_);
						_tmp1437_ = _tmp1436_;
						_tmp1438_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1437_, TRUE, NULL, FALSE);
						_tmp1439_ = _tmp1438_;
						_vala_code_node_unref0 (_tmp1437_);
						temp_var = _tmp1439_;
						_tmp1440_ = temp_var;
						_tmp1441_ = vala_symbol_get_name ((ValaSymbol*) _tmp1440_);
						_tmp1442_ = _tmp1441_;
						_tmp1443_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1442_);
						temp_ref = _tmp1443_;
						_tmp1444_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1444_, FALSE);
						_tmp1445_ = temp_ref;
						_tmp1446_ = ccall_expr;
						_tmp1447_ = vala_ccode_assignment_new (_tmp1445_, _tmp1446_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1447_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1448_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1449_ = _tmp1448_;
						_tmp1450_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1449_);
						_tmp1451_ = _tmp1450_;
						_vala_ccode_node_unref0 (_tmp1449_);
						len_call = _tmp1451_;
						_tmp1452_ = len_call;
						_tmp1453_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1452_, _tmp1453_);
						_tmp1454_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1454_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1455_;
						_tmp1455_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1455_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1456_;
							ValaLocalVariable* _tmp1457_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1458_;
							const gchar* _tmp1459_;
							const gchar* _tmp1460_;
							ValaCCodeExpression* _tmp1461_;
							ValaLocalVariable* _tmp1462_;
							ValaHashMap* _tmp1463_;
							ValaDelegate* _tmp1464_;
							gint _tmp1465_;
							ValaCCodeExpression* _tmp1466_;
							ValaCCodeUnaryExpression* _tmp1467_;
							ValaCCodeUnaryExpression* _tmp1468_;
							ValaCCodeExpression* _tmp1469_;
							_tmp1456_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1457_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1456_, TRUE, NULL, TRUE);
							temp_var = _tmp1457_;
							_tmp1458_ = temp_var;
							_tmp1459_ = vala_symbol_get_name ((ValaSymbol*) _tmp1458_);
							_tmp1460_ = _tmp1459_;
							_tmp1461_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1460_);
							temp_ref = _tmp1461_;
							_tmp1462_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1462_, FALSE);
							_tmp1463_ = out_arg_map;
							_tmp1464_ = deleg;
							_tmp1465_ = dim;
							_tmp1466_ = temp_ref;
							_tmp1467_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1466_);
							_tmp1468_ = _tmp1467_;
							vala_map_set ((ValaMap*) _tmp1463_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1464_) + (0.01 * _tmp1465_), FALSE)), (ValaCCodeExpression*) _tmp1468_);
							_vala_ccode_node_unref0 (_tmp1468_);
							_tmp1469_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1469_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1470_;
							ValaCCodeConstant* _tmp1471_;
							_tmp1470_ = vala_ccode_constant_new ("-1");
							_tmp1471_ = _tmp1470_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1471_);
							_vala_ccode_node_unref0 (_tmp1471_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1472_ = FALSE;
		ValaDelegate* _tmp1473_;
		_tmp1473_ = deleg;
		if (_tmp1473_ != NULL) {
			ValaDelegate* _tmp1474_;
			ValaDataType* _tmp1475_;
			ValaDataType* _tmp1476_;
			_tmp1474_ = deleg;
			_tmp1475_ = vala_callable_get_return_type ((ValaCallable*) _tmp1474_);
			_tmp1476_ = _tmp1475_;
			_tmp1472_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1476_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1472_ = FALSE;
		}
		if (_tmp1472_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1477_;
			ValaDataType* _tmp1478_;
			ValaDataType* _tmp1479_;
			ValaDelegateType* _tmp1480_;
			ValaDelegateType* _tmp1481_;
			ValaDelegate* _tmp1482_;
			ValaDelegate* _tmp1483_;
			gboolean _tmp1484_;
			gboolean _tmp1485_;
			_tmp1477_ = deleg;
			_tmp1478_ = vala_callable_get_return_type ((ValaCallable*) _tmp1477_);
			_tmp1479_ = _tmp1478_;
			_tmp1480_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1479_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1480_;
			_tmp1481_ = deleg_type;
			_tmp1482_ = vala_delegate_type_get_delegate_symbol (_tmp1481_);
			_tmp1483_ = _tmp1482_;
			_tmp1484_ = vala_delegate_get_has_target (_tmp1483_);
			_tmp1485_ = _tmp1484_;
			if (_tmp1485_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1486_;
				ValaVoidType* _tmp1487_;
				ValaPointerType* _tmp1488_;
				ValaPointerType* _tmp1489_;
				ValaLocalVariable* _tmp1490_;
				ValaLocalVariable* _tmp1491_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1492_;
				const gchar* _tmp1493_;
				const gchar* _tmp1494_;
				ValaCCodeExpression* _tmp1495_;
				ValaLocalVariable* _tmp1496_;
				ValaHashMap* _tmp1497_;
				ValaDelegate* _tmp1498_;
				ValaCCodeExpression* _tmp1499_;
				ValaCCodeUnaryExpression* _tmp1500_;
				ValaCCodeUnaryExpression* _tmp1501_;
				ValaCCodeExpression* _tmp1502_;
				ValaDelegateType* _tmp1503_;
				_tmp1486_ = vala_void_type_new (NULL);
				_tmp1487_ = _tmp1486_;
				_tmp1488_ = vala_pointer_type_new ((ValaDataType*) _tmp1487_, NULL);
				_tmp1489_ = _tmp1488_;
				_tmp1490_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1489_, TRUE, NULL, TRUE);
				_tmp1491_ = _tmp1490_;
				_vala_code_node_unref0 (_tmp1489_);
				_vala_code_node_unref0 (_tmp1487_);
				temp_var = _tmp1491_;
				_tmp1492_ = temp_var;
				_tmp1493_ = vala_symbol_get_name ((ValaSymbol*) _tmp1492_);
				_tmp1494_ = _tmp1493_;
				_tmp1495_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1494_);
				temp_ref = _tmp1495_;
				_tmp1496_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1496_, FALSE);
				_tmp1497_ = out_arg_map;
				_tmp1498_ = deleg;
				_tmp1499_ = temp_ref;
				_tmp1500_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1499_);
				_tmp1501_ = _tmp1500_;
				vala_map_set ((ValaMap*) _tmp1497_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1498_), FALSE)), (ValaCCodeExpression*) _tmp1501_);
				_vala_ccode_node_unref0 (_tmp1501_);
				_tmp1502_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1502_);
				_tmp1503_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1503_)) {
					ValaDataType* _tmp1504_;
					ValaLocalVariable* _tmp1505_;
					ValaLocalVariable* _tmp1506_;
					const gchar* _tmp1507_;
					const gchar* _tmp1508_;
					ValaCCodeExpression* _tmp1509_;
					ValaLocalVariable* _tmp1510_;
					ValaHashMap* _tmp1511_;
					ValaDelegate* _tmp1512_;
					ValaCCodeExpression* _tmp1513_;
					ValaCCodeUnaryExpression* _tmp1514_;
					ValaCCodeUnaryExpression* _tmp1515_;
					ValaCCodeExpression* _tmp1516_;
					_tmp1504_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1505_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1504_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1505_;
					_tmp1506_ = temp_var;
					_tmp1507_ = vala_symbol_get_name ((ValaSymbol*) _tmp1506_);
					_tmp1508_ = _tmp1507_;
					_tmp1509_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1508_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1509_;
					_tmp1510_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1510_, FALSE);
					_tmp1511_ = out_arg_map;
					_tmp1512_ = deleg;
					_tmp1513_ = temp_ref;
					_tmp1514_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1513_);
					_tmp1515_ = _tmp1514_;
					vala_map_set ((ValaMap*) _tmp1511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1512_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1515_);
					_vala_ccode_node_unref0 (_tmp1515_);
					_tmp1516_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1516_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1518_ = m;
	if (_tmp1518_ != NULL) {
		ValaMethod* _tmp1519_;
		gboolean _tmp1520_;
		gboolean _tmp1521_;
		_tmp1519_ = m;
		_tmp1520_ = vala_method_get_coroutine (_tmp1519_);
		_tmp1521_ = _tmp1520_;
		_tmp1517_ = _tmp1521_;
	} else {
		_tmp1517_ = FALSE;
	}
	if (_tmp1517_) {
		gboolean _tmp1522_;
		gboolean _tmp1523_;
		_tmp1522_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1523_ = _tmp1522_;
		if (_tmp1523_) {
			ValaHashMap* _tmp1524_;
			ValaMethod* _tmp1525_;
			ValaMethod* _tmp1526_;
			gchar* _tmp1527_;
			gchar* _tmp1528_;
			ValaCCodeIdentifier* _tmp1529_;
			ValaCCodeIdentifier* _tmp1530_;
			ValaHashMap* _tmp1531_;
			ValaCCodeIdentifier* _tmp1532_;
			ValaCCodeIdentifier* _tmp1533_;
			_tmp1524_ = in_arg_map;
			_tmp1525_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1526_ = _tmp1525_;
			_tmp1527_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1526_);
			_tmp1528_ = _tmp1527_;
			_tmp1529_ = vala_ccode_identifier_new (_tmp1528_);
			_tmp1530_ = _tmp1529_;
			vala_map_set ((ValaMap*) _tmp1524_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1530_);
			_vala_ccode_node_unref0 (_tmp1530_);
			_g_free0 (_tmp1528_);
			_tmp1531_ = in_arg_map;
			_tmp1532_ = vala_ccode_identifier_new ("_data_");
			_tmp1533_ = _tmp1532_;
			vala_map_set ((ValaMap*) _tmp1531_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1533_);
			_vala_ccode_node_unref0 (_tmp1533_);
		}
	}
	_tmp1534_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1535_ = _tmp1534_;
	if (_tmp1535_) {
		ValaHashMap* _tmp1536_;
		ValaCCodeExpression* _tmp1537_;
		ValaCCodeExpression* _tmp1538_;
		ValaCCodeUnaryExpression* _tmp1539_;
		ValaCCodeUnaryExpression* _tmp1540_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1536_ = out_arg_map;
		_tmp1537_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1538_ = _tmp1537_;
		_tmp1539_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1538_);
		_tmp1540_ = _tmp1539_;
		vala_map_set ((ValaMap*) _tmp1536_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1540_);
		_vala_ccode_node_unref0 (_tmp1540_);
		_vala_ccode_node_unref0 (_tmp1538_);
	} else {
		gboolean _tmp1541_ = FALSE;
		gboolean _tmp1542_ = FALSE;
		ValaMethod* _tmp1543_;
		_tmp1543_ = m;
		if (_tmp1543_ != NULL) {
			ValaMethod* _tmp1544_;
			_tmp1544_ = m;
			_tmp1542_ = vala_method_has_error_type_parameter (_tmp1544_);
		} else {
			_tmp1542_ = FALSE;
		}
		if (_tmp1542_) {
			ValaCCodeFunctionCall* _tmp1545_;
			ValaCCodeFunctionCall* _tmp1546_;
			_tmp1545_ = async_call;
			_tmp1546_ = ccall;
			_tmp1541_ = _tmp1545_ != _tmp1546_;
		} else {
			_tmp1541_ = FALSE;
		}
		if (_tmp1541_) {
			ValaHashMap* _tmp1547_;
			ValaCCodeConstant* _tmp1548_;
			ValaCCodeConstant* _tmp1549_;
			_tmp1547_ = out_arg_map;
			_tmp1548_ = vala_ccode_constant_new ("NULL");
			_tmp1549_ = _tmp1548_;
			vala_map_set ((ValaMap*) _tmp1547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1549_);
			_vala_ccode_node_unref0 (_tmp1549_);
		}
	}
	_tmp1550_ = ellipsis;
	if (_tmp1550_) {
		ValaMethod* _tmp1551_;
		_tmp1551_ = m;
		if (_tmp1551_ == NULL) {
			ValaHashMap* _tmp1552_;
			ValaCCodeConstant* _tmp1553_;
			ValaCCodeConstant* _tmp1554_;
			_tmp1552_ = in_arg_map;
			_tmp1553_ = vala_ccode_constant_new ("NULL");
			_tmp1554_ = _tmp1553_;
			vala_map_set ((ValaMap*) _tmp1552_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1554_);
			_vala_ccode_node_unref0 (_tmp1554_);
		} else {
			gboolean _tmp1555_ = FALSE;
			gboolean _tmp1556_ = FALSE;
			gboolean _tmp1557_ = FALSE;
			ValaMethod* _tmp1558_;
			gboolean _tmp1559_;
			gboolean _tmp1560_;
			_tmp1558_ = m;
			_tmp1559_ = vala_method_get_printf_format (_tmp1558_);
			_tmp1560_ = _tmp1559_;
			if (!_tmp1560_) {
				ValaMethod* _tmp1561_;
				gboolean _tmp1562_;
				gboolean _tmp1563_;
				_tmp1561_ = m;
				_tmp1562_ = vala_method_get_scanf_format (_tmp1561_);
				_tmp1563_ = _tmp1562_;
				_tmp1557_ = !_tmp1563_;
			} else {
				_tmp1557_ = FALSE;
			}
			if (_tmp1557_) {
				ValaMethod* _tmp1564_;
				gchar* _tmp1565_;
				gchar* _tmp1566_;
				_tmp1564_ = m;
				_tmp1565_ = vala_get_ccode_sentinel (_tmp1564_);
				_tmp1566_ = _tmp1565_;
				_tmp1556_ = g_strcmp0 (_tmp1566_, "") != 0;
				_g_free0 (_tmp1566_);
			} else {
				_tmp1556_ = FALSE;
			}
			if (_tmp1556_) {
				gboolean _tmp1567_;
				gboolean _tmp1568_;
				_tmp1567_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1568_ = _tmp1567_;
				_tmp1555_ = !_tmp1568_;
			} else {
				_tmp1555_ = FALSE;
			}
			if (_tmp1555_) {
				ValaHashMap* _tmp1569_;
				ValaMethod* _tmp1570_;
				gchar* _tmp1571_;
				gchar* _tmp1572_;
				ValaCCodeConstant* _tmp1573_;
				ValaCCodeConstant* _tmp1574_;
				_tmp1569_ = in_arg_map;
				_tmp1570_ = m;
				_tmp1571_ = vala_get_ccode_sentinel (_tmp1570_);
				_tmp1572_ = _tmp1571_;
				_tmp1573_ = vala_ccode_constant_new (_tmp1572_);
				_tmp1574_ = _tmp1573_;
				vala_map_set ((ValaMap*) _tmp1569_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1574_);
				_vala_ccode_node_unref0 (_tmp1574_);
				_g_free0 (_tmp1572_);
			}
		}
	}
	_tmp1575_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1575_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1576_;
		ValaDelegateType* _tmp1577_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1578_;
		ValaDelegate* _tmp1579_;
		ValaDelegate* _tmp1580_;
		ValaDelegate* _tmp1581_;
		ValaDelegate* _tmp1582_;
		gboolean _tmp1583_;
		gboolean _tmp1584_;
		_tmp1576_ = itype;
		_tmp1577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1576_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1577_;
		_tmp1578_ = deleg_type;
		_tmp1579_ = vala_delegate_type_get_delegate_symbol (_tmp1578_);
		_tmp1580_ = _tmp1579_;
		_tmp1581_ = _vala_code_node_ref0 (_tmp1580_);
		d = _tmp1581_;
		_tmp1582_ = d;
		_tmp1583_ = vala_delegate_get_has_target (_tmp1582_);
		_tmp1584_ = _tmp1583_;
		if (_tmp1584_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1585_;
			ValaDelegate* _tmp1586_;
			ValaExpression* _tmp1587_;
			ValaExpression* _tmp1588_;
			ValaCCodeExpression* _tmp1589_ = NULL;
			ValaCCodeExpression* _tmp1590_;
			ValaCCodeExpression* _tmp1591_;
			ValaHashMap* _tmp1592_;
			ValaDelegate* _tmp1593_;
			ValaExpression* _tmp1594_;
			ValaExpression* _tmp1595_;
			ValaCCodeExpression* _tmp1596_ = NULL;
			ValaCCodeExpression* _tmp1597_;
			ValaCCodeExpression* _tmp1598_;
			_tmp1585_ = in_arg_map;
			_tmp1586_ = d;
			_tmp1587_ = vala_method_call_get_call (expr);
			_tmp1588_ = _tmp1587_;
			_tmp1590_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1588_, &_tmp1589_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1589_;
			_tmp1591_ = _tmp1590_;
			vala_map_set ((ValaMap*) _tmp1585_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1586_), FALSE)), _tmp1591_);
			_vala_ccode_node_unref0 (_tmp1591_);
			_tmp1592_ = out_arg_map;
			_tmp1593_ = d;
			_tmp1594_ = vala_method_call_get_call (expr);
			_tmp1595_ = _tmp1594_;
			_tmp1597_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1595_, &_tmp1596_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1596_;
			_tmp1598_ = _tmp1597_;
			vala_map_set ((ValaMap*) _tmp1592_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1593_), FALSE)), _tmp1598_);
			_vala_ccode_node_unref0 (_tmp1598_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1599_ = itype;
	_tmp1600_ = vala_data_type_get_return_type (_tmp1599_);
	_tmp1601_ = _tmp1600_;
	_tmp1602_ = vala_data_type_is_real_non_null_struct_type (_tmp1601_);
	_vala_code_node_unref0 (_tmp1601_);
	return_result_via_out_param = _tmp1602_;
	_tmp1604_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1604_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1605_;
		ValaDataType* _tmp1606_;
		ValaDataType* _tmp1607_;
		_tmp1605_ = itype;
		_tmp1606_ = vala_data_type_get_return_type (_tmp1605_);
		_tmp1607_ = _tmp1606_;
		_tmp1603_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1607_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1607_);
	} else {
		_tmp1603_ = FALSE;
	}
	if (_tmp1603_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1608_;
		ValaSignal* _tmp1609_;
		ValaSignal* _tmp1610_;
		ValaSignal* _tmp1611_;
		gboolean _tmp1612_ = FALSE;
		gboolean _tmp1613_ = FALSE;
		ValaMemberAccess* _tmp1614_;
		_tmp1608_ = itype;
		_tmp1609_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1608_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1610_ = _tmp1609_;
		_tmp1611_ = _vala_code_node_ref0 (_tmp1610_);
		sig = _tmp1611_;
		_tmp1614_ = ma;
		if (_tmp1614_ != NULL) {
			ValaMemberAccess* _tmp1615_;
			ValaExpression* _tmp1616_;
			ValaExpression* _tmp1617_;
			_tmp1615_ = ma;
			_tmp1616_ = vala_member_access_get_inner (_tmp1615_);
			_tmp1617_ = _tmp1616_;
			_tmp1613_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1617_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1613_ = FALSE;
		}
		if (_tmp1613_) {
			ValaSignal* _tmp1618_;
			gboolean _tmp1619_;
			gboolean _tmp1620_;
			_tmp1618_ = sig;
			_tmp1619_ = vala_signal_get_is_virtual (_tmp1618_);
			_tmp1620_ = _tmp1619_;
			_tmp1612_ = _tmp1620_;
		} else {
			_tmp1612_ = FALSE;
		}
		if (_tmp1612_) {
		} else {
			gboolean _tmp1621_ = FALSE;
			ValaSignal* _tmp1622_;
			_tmp1622_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1622_)) {
				_tmp1621_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1623_;
				ValaSourceReference* _tmp1624_;
				ValaSourceReference* _tmp1625_;
				ValaSourceFile* _tmp1626_;
				ValaSourceFile* _tmp1627_;
				ValaSignal* _tmp1628_;
				ValaSourceReference* _tmp1629_;
				ValaSourceReference* _tmp1630_;
				ValaSourceFile* _tmp1631_;
				ValaSourceFile* _tmp1632_;
				_tmp1623_ = ma;
				_tmp1624_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1623_);
				_tmp1625_ = _tmp1624_;
				_tmp1626_ = vala_source_reference_get_file (_tmp1625_);
				_tmp1627_ = _tmp1626_;
				_tmp1628_ = sig;
				_tmp1629_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1628_);
				_tmp1630_ = _tmp1629_;
				_tmp1631_ = vala_source_reference_get_file (_tmp1630_);
				_tmp1632_ = _tmp1631_;
				_tmp1621_ = _tmp1627_ == _tmp1632_;
			}
			if (_tmp1621_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1633_ = async_call;
	_tmp1634_ = ccall;
	if (_tmp1633_ == _tmp1634_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1635_ = return_result_via_out_param;
	if (_tmp1635_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1636_;
		ValaDataType* _tmp1637_;
		ValaDataType* _tmp1638_;
		ValaLocalVariable* _tmp1639_;
		ValaLocalVariable* _tmp1640_;
		ValaLocalVariable* _tmp1641_;
		const gchar* _tmp1642_;
		const gchar* _tmp1643_;
		ValaCCodeExpression* _tmp1644_;
		ValaLocalVariable* _tmp1645_;
		ValaHashMap* _tmp1646_;
		ValaCCodeExpression* _tmp1647_;
		ValaCCodeUnaryExpression* _tmp1648_;
		ValaCCodeUnaryExpression* _tmp1649_;
		_tmp1636_ = itype;
		_tmp1637_ = vala_data_type_get_return_type (_tmp1636_);
		_tmp1638_ = _tmp1637_;
		_tmp1639_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1638_, TRUE, NULL, TRUE);
		_tmp1640_ = _tmp1639_;
		_vala_code_node_unref0 (_tmp1638_);
		out_param_var = _tmp1640_;
		_tmp1641_ = out_param_var;
		_tmp1642_ = vala_symbol_get_name ((ValaSymbol*) _tmp1641_);
		_tmp1643_ = _tmp1642_;
		_tmp1644_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1643_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1644_;
		_tmp1645_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1645_, FALSE);
		_tmp1646_ = out_arg_map;
		_tmp1647_ = out_param_ref;
		_tmp1648_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1647_);
		_tmp1649_ = _tmp1648_;
		vala_map_set ((ValaMap*) _tmp1646_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1649_);
		_vala_ccode_node_unref0 (_tmp1649_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1650_ = async_call;
	_tmp1651_ = ccall;
	if (_tmp1650_ != _tmp1651_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1668_;
			ValaCCodeFunctionCall* _tmp1669_;
			ValaHashMap* _tmp1670_;
			gint _tmp1671_;
			gpointer _tmp1672_;
			ValaCCodeExpression* _tmp1673_;
			gint _tmp1674_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1652_;
				ValaSet* _tmp1653_;
				ValaSet* _tmp1654_;
				ValaIterator* _tmp1655_;
				ValaIterator* _tmp1656_;
				_tmp1652_ = out_arg_map;
				_tmp1653_ = vala_map_get_keys ((ValaMap*) _tmp1652_);
				_tmp1654_ = _tmp1653_;
				_tmp1655_ = vala_iterable_iterator ((ValaIterable*) _tmp1654_);
				_tmp1656_ = _tmp1655_;
				_vala_iterable_unref0 (_tmp1654_);
				_pos_it = _tmp1656_;
				while (TRUE) {
					ValaIterator* _tmp1657_;
					gint pos = 0;
					ValaIterator* _tmp1658_;
					gpointer _tmp1659_;
					gboolean _tmp1660_ = FALSE;
					gint _tmp1661_;
					gint _tmp1662_;
					_tmp1657_ = _pos_it;
					if (!vala_iterator_next (_tmp1657_)) {
						break;
					}
					_tmp1658_ = _pos_it;
					_tmp1659_ = vala_iterator_get (_tmp1658_);
					pos = (gint) ((gintptr) _tmp1659_);
					_tmp1661_ = pos;
					_tmp1662_ = last_pos;
					if (_tmp1661_ > _tmp1662_) {
						gboolean _tmp1663_ = FALSE;
						gint _tmp1664_;
						_tmp1664_ = min_pos;
						if (_tmp1664_ == -1) {
							_tmp1663_ = TRUE;
						} else {
							gint _tmp1665_;
							gint _tmp1666_;
							_tmp1665_ = pos;
							_tmp1666_ = min_pos;
							_tmp1663_ = _tmp1665_ < _tmp1666_;
						}
						_tmp1660_ = _tmp1663_;
					} else {
						_tmp1660_ = FALSE;
					}
					if (_tmp1660_) {
						gint _tmp1667_;
						_tmp1667_ = pos;
						min_pos = _tmp1667_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1668_ = min_pos;
			if (_tmp1668_ == -1) {
				break;
			}
			_tmp1669_ = ccall;
			_tmp1670_ = out_arg_map;
			_tmp1671_ = min_pos;
			_tmp1672_ = vala_map_get ((ValaMap*) _tmp1670_, (gpointer) ((gintptr) _tmp1671_));
			_tmp1673_ = (ValaCCodeExpression*) _tmp1672_;
			vala_ccode_function_call_add_argument (_tmp1669_, _tmp1673_);
			_vala_ccode_node_unref0 (_tmp1673_);
			_tmp1674_ = min_pos;
			last_pos = _tmp1674_;
		}
	}
	_tmp1675_ = async_call;
	if (_tmp1675_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1692_;
			ValaCCodeFunctionCall* _tmp1693_;
			ValaHashMap* _tmp1694_;
			gint _tmp1695_;
			gpointer _tmp1696_;
			ValaCCodeExpression* _tmp1697_;
			gint _tmp1698_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1676_;
				ValaSet* _tmp1677_;
				ValaSet* _tmp1678_;
				ValaIterator* _tmp1679_;
				ValaIterator* _tmp1680_;
				_tmp1676_ = in_arg_map;
				_tmp1677_ = vala_map_get_keys ((ValaMap*) _tmp1676_);
				_tmp1678_ = _tmp1677_;
				_tmp1679_ = vala_iterable_iterator ((ValaIterable*) _tmp1678_);
				_tmp1680_ = _tmp1679_;
				_vala_iterable_unref0 (_tmp1678_);
				_pos_it = _tmp1680_;
				while (TRUE) {
					ValaIterator* _tmp1681_;
					gint pos = 0;
					ValaIterator* _tmp1682_;
					gpointer _tmp1683_;
					gboolean _tmp1684_ = FALSE;
					gint _tmp1685_;
					gint _tmp1686_;
					_tmp1681_ = _pos_it;
					if (!vala_iterator_next (_tmp1681_)) {
						break;
					}
					_tmp1682_ = _pos_it;
					_tmp1683_ = vala_iterator_get (_tmp1682_);
					pos = (gint) ((gintptr) _tmp1683_);
					_tmp1685_ = pos;
					_tmp1686_ = last_pos;
					if (_tmp1685_ > _tmp1686_) {
						gboolean _tmp1687_ = FALSE;
						gint _tmp1688_;
						_tmp1688_ = min_pos;
						if (_tmp1688_ == -1) {
							_tmp1687_ = TRUE;
						} else {
							gint _tmp1689_;
							gint _tmp1690_;
							_tmp1689_ = pos;
							_tmp1690_ = min_pos;
							_tmp1687_ = _tmp1689_ < _tmp1690_;
						}
						_tmp1684_ = _tmp1687_;
					} else {
						_tmp1684_ = FALSE;
					}
					if (_tmp1684_) {
						gint _tmp1691_;
						_tmp1691_ = pos;
						min_pos = _tmp1691_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1692_ = min_pos;
			if (_tmp1692_ == -1) {
				break;
			}
			_tmp1693_ = async_call;
			_tmp1694_ = in_arg_map;
			_tmp1695_ = min_pos;
			_tmp1696_ = vala_map_get ((ValaMap*) _tmp1694_, (gpointer) ((gintptr) _tmp1695_));
			_tmp1697_ = (ValaCCodeExpression*) _tmp1696_;
			vala_ccode_function_call_add_argument (_tmp1693_, _tmp1697_);
			_vala_ccode_node_unref0 (_tmp1697_);
			_tmp1698_ = min_pos;
			last_pos = _tmp1698_;
		}
	}
	_tmp1699_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1700_ = _tmp1699_;
	if (_tmp1700_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1701_;
		gint _tmp1702_;
		ValaCCodeFunction* _tmp1703_;
		ValaCCodeFunction* _tmp1704_;
		ValaCCodeIdentifier* _tmp1705_;
		ValaCCodeIdentifier* _tmp1706_;
		ValaCCodeMemberAccess* _tmp1707_;
		ValaCCodeMemberAccess* _tmp1708_;
		gint _tmp1709_;
		gchar* _tmp1710_;
		gchar* _tmp1711_;
		ValaCCodeConstant* _tmp1712_;
		ValaCCodeConstant* _tmp1713_;
		ValaCCodeFunction* _tmp1714_;
		ValaCCodeFunction* _tmp1715_;
		ValaCCodeFunctionCall* _tmp1716_;
		ValaCCodeFunction* _tmp1717_;
		ValaCCodeFunction* _tmp1718_;
		ValaCCodeConstant* _tmp1719_;
		ValaCCodeConstant* _tmp1720_;
		ValaCCodeFunction* _tmp1721_;
		ValaCCodeFunction* _tmp1722_;
		gint _tmp1723_;
		gchar* _tmp1724_;
		gchar* _tmp1725_;
		_tmp1701_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1702_ = _tmp1701_->next_coroutine_state;
		_tmp1701_->next_coroutine_state = _tmp1702_ + 1;
		state = _tmp1702_;
		_tmp1703_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1704_ = _tmp1703_;
		_tmp1705_ = vala_ccode_identifier_new ("_data_");
		_tmp1706_ = _tmp1705_;
		_tmp1707_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1706_, "_state_");
		_tmp1708_ = _tmp1707_;
		_tmp1709_ = state;
		_tmp1710_ = g_strdup_printf ("%i", _tmp1709_);
		_tmp1711_ = _tmp1710_;
		_tmp1712_ = vala_ccode_constant_new (_tmp1711_);
		_tmp1713_ = _tmp1712_;
		vala_ccode_function_add_assignment (_tmp1704_, (ValaCCodeExpression*) _tmp1708_, (ValaCCodeExpression*) _tmp1713_);
		_vala_ccode_node_unref0 (_tmp1713_);
		_g_free0 (_tmp1711_);
		_vala_ccode_node_unref0 (_tmp1708_);
		_vala_ccode_node_unref0 (_tmp1706_);
		_tmp1714_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1715_ = _tmp1714_;
		_tmp1716_ = async_call;
		vala_ccode_function_add_expression (_tmp1715_, (ValaCCodeExpression*) _tmp1716_);
		_tmp1717_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1718_ = _tmp1717_;
		_tmp1719_ = vala_ccode_constant_new ("FALSE");
		_tmp1720_ = _tmp1719_;
		vala_ccode_function_add_return (_tmp1718_, (ValaCCodeExpression*) _tmp1720_);
		_vala_ccode_node_unref0 (_tmp1720_);
		_tmp1721_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1722_ = _tmp1721_;
		_tmp1723_ = state;
		_tmp1724_ = g_strdup_printf ("_state_%d", _tmp1723_);
		_tmp1725_ = _tmp1724_;
		vala_ccode_function_add_label (_tmp1722_, _tmp1725_);
		_g_free0 (_tmp1725_);
	}
	_tmp1726_ = vala_method_call_get_is_assert (expr);
	_tmp1727_ = _tmp1726_;
	if (_tmp1727_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1728_;
		ValaSourceReference* _tmp1729_;
		ValaSourceLocation _tmp1730_ = {0};
		ValaSourceLocation _tmp1731_;
		gchar* _tmp1732_;
		ValaSourceReference* _tmp1733_;
		ValaSourceReference* _tmp1734_;
		ValaSourceLocation _tmp1735_ = {0};
		ValaSourceLocation _tmp1736_;
		gchar* _tmp1737_;
		ValaSourceReference* _tmp1738_;
		ValaSourceReference* _tmp1739_;
		ValaSourceLocation _tmp1740_ = {0};
		ValaSourceLocation _tmp1741_;
		gchar* _tmp1742_;
		gchar* _tmp1743_;
		ValaCCodeFunctionCall* _tmp1744_;
		ValaCCodeIdentifier* _tmp1745_;
		ValaCCodeIdentifier* _tmp1746_;
		ValaCCodeFunctionCall* _tmp1747_;
		const gchar* _tmp1748_;
		gchar* _tmp1749_;
		gchar* _tmp1750_;
		gchar* _tmp1751_;
		gchar* _tmp1752_;
		gchar* _tmp1753_;
		gchar* _tmp1754_;
		ValaCCodeConstant* _tmp1755_;
		ValaCCodeConstant* _tmp1756_;
		_tmp1728_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1729_ = _tmp1728_;
		vala_source_reference_get_begin (_tmp1729_, &_tmp1730_);
		_tmp1731_ = _tmp1730_;
		_tmp1732_ = _tmp1731_.pos;
		_tmp1733_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1734_ = _tmp1733_;
		vala_source_reference_get_end (_tmp1734_, &_tmp1735_);
		_tmp1736_ = _tmp1735_;
		_tmp1737_ = _tmp1736_.pos;
		_tmp1738_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1739_ = _tmp1738_;
		vala_source_reference_get_begin (_tmp1739_, &_tmp1740_);
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = _tmp1741_.pos;
		_tmp1743_ = string_substring ((const gchar*) _tmp1732_, (glong) 0, (glong) ((gint) (_tmp1737_ - _tmp1742_)));
		message = _tmp1743_;
		_tmp1744_ = ccall;
		_tmp1745_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1746_ = _tmp1745_;
		vala_ccode_function_call_set_call (_tmp1744_, (ValaCCodeExpression*) _tmp1746_);
		_vala_ccode_node_unref0 (_tmp1746_);
		_tmp1747_ = ccall;
		_tmp1748_ = message;
		_tmp1749_ = string_replace (_tmp1748_, "\n", " ");
		_tmp1750_ = _tmp1749_;
		_tmp1751_ = g_strescape (_tmp1750_, "");
		_tmp1752_ = _tmp1751_;
		_tmp1753_ = g_strdup_printf ("\"%s\"", _tmp1752_);
		_tmp1754_ = _tmp1753_;
		_tmp1755_ = vala_ccode_constant_new (_tmp1754_);
		_tmp1756_ = _tmp1755_;
		vala_ccode_function_call_add_argument (_tmp1747_, (ValaCCodeExpression*) _tmp1756_);
		_vala_ccode_node_unref0 (_tmp1756_);
		_g_free0 (_tmp1754_);
		_g_free0 (_tmp1752_);
		_g_free0 (_tmp1750_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1757_ = return_result_via_out_param;
	if (_tmp1757_) {
		ValaCCodeFunction* _tmp1758_;
		ValaCCodeFunction* _tmp1759_;
		ValaCCodeExpression* _tmp1760_;
		ValaCCodeExpression* _tmp1761_;
		ValaCCodeExpression* _tmp1762_;
		_tmp1758_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1759_, _tmp1760_);
		_tmp1761_ = out_param_ref;
		_tmp1762_ = _vala_ccode_node_ref0 (_tmp1761_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1762_;
	}
	_tmp1765_ = m;
	if (_tmp1765_ != NULL) {
		ValaMethod* _tmp1766_;
		ValaMemberBinding _tmp1767_;
		ValaMemberBinding _tmp1768_;
		_tmp1766_ = m;
		_tmp1767_ = vala_method_get_binding (_tmp1766_);
		_tmp1768_ = _tmp1767_;
		_tmp1764_ = _tmp1768_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1764_ = FALSE;
	}
	if (_tmp1764_) {
		ValaMethod* _tmp1769_;
		gboolean _tmp1770_;
		gboolean _tmp1771_;
		_tmp1769_ = m;
		_tmp1770_ = vala_method_get_returns_modified_pointer (_tmp1769_);
		_tmp1771_ = _tmp1770_;
		_tmp1763_ = _tmp1771_;
	} else {
		_tmp1763_ = FALSE;
	}
	if (_tmp1763_) {
		gboolean _tmp1772_ = FALSE;
		gboolean _tmp1773_ = FALSE;
		ValaMemberAccess* _tmp1774_;
		_tmp1774_ = ma;
		if (_tmp1774_ != NULL) {
			ValaMemberAccess* _tmp1775_;
			ValaExpression* _tmp1776_;
			ValaExpression* _tmp1777_;
			ValaSymbol* _tmp1778_;
			ValaSymbol* _tmp1779_;
			_tmp1775_ = ma;
			_tmp1776_ = vala_member_access_get_inner (_tmp1775_);
			_tmp1777_ = _tmp1776_;
			_tmp1778_ = vala_expression_get_symbol_reference (_tmp1777_);
			_tmp1779_ = _tmp1778_;
			_tmp1773_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1779_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1773_ = FALSE;
		}
		if (_tmp1773_) {
			ValaMemberAccess* _tmp1780_;
			ValaExpression* _tmp1781_;
			ValaExpression* _tmp1782_;
			_tmp1780_ = ma;
			_tmp1781_ = vala_member_access_get_inner (_tmp1780_);
			_tmp1782_ = _tmp1781_;
			_tmp1772_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1782_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1772_ = FALSE;
		}
		if (_tmp1772_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1783_;
			ValaExpression* _tmp1784_;
			ValaExpression* _tmp1785_;
			ValaSymbol* _tmp1786_;
			ValaSymbol* _tmp1787_;
			ValaProperty* _tmp1788_;
			ValaProperty* _tmp1789_;
			ValaMemberAccess* _tmp1790_;
			ValaExpression* _tmp1791_;
			ValaExpression* _tmp1792_;
			ValaExpression* _tmp1793_;
			ValaExpression* _tmp1794_;
			ValaDataType* _tmp1795_;
			ValaDataType* _tmp1796_;
			ValaCCodeExpression* _tmp1797_;
			ValaGLibValue* _tmp1798_;
			ValaGLibValue* _tmp1799_;
			_tmp1783_ = ma;
			_tmp1784_ = vala_member_access_get_inner (_tmp1783_);
			_tmp1785_ = _tmp1784_;
			_tmp1786_ = vala_expression_get_symbol_reference (_tmp1785_);
			_tmp1787_ = _tmp1786_;
			_tmp1788_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1787_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1788_;
			_tmp1789_ = prop;
			_tmp1790_ = ma;
			_tmp1791_ = vala_member_access_get_inner (_tmp1790_);
			_tmp1792_ = _tmp1791_;
			_tmp1793_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1792_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1794_ = _tmp1793_;
			_tmp1795_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1796_ = _tmp1795_;
			_tmp1797_ = ccall_expr;
			_tmp1798_ = vala_glib_value_new (_tmp1796_, _tmp1797_, FALSE);
			_tmp1799_ = _tmp1798_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1789_, _tmp1794_, (ValaTargetValue*) _tmp1799_);
			_vala_target_value_unref0 (_tmp1799_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1800_;
			ValaCCodeExpression* _tmp1801_;
			ValaCCodeAssignment* _tmp1802_;
			_tmp1800_ = instance;
			_tmp1801_ = ccall_expr;
			_tmp1802_ = vala_ccode_assignment_new (_tmp1800_, _tmp1801_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1802_;
		}
	}
	_tmp1805_ = m;
	if (_tmp1805_ != NULL) {
		ValaMethod* _tmp1806_;
		gchar* _tmp1807_;
		gchar* _tmp1808_;
		_tmp1806_ = m;
		_tmp1807_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1806_);
		_tmp1808_ = _tmp1807_;
		_tmp1804_ = _tmp1808_ != NULL;
		_g_free0 (_tmp1808_);
	} else {
		_tmp1804_ = FALSE;
	}
	if (_tmp1804_) {
		ValaMethod* _tmp1809_;
		gchar* _tmp1810_;
		gchar* _tmp1811_;
		ValaMethod* _tmp1812_;
		ValaDataType* _tmp1813_;
		ValaDataType* _tmp1814_;
		gchar* _tmp1815_;
		gchar* _tmp1816_;
		_tmp1809_ = m;
		_tmp1810_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1809_);
		_tmp1811_ = _tmp1810_;
		_tmp1812_ = m;
		_tmp1813_ = vala_callable_get_return_type ((ValaCallable*) _tmp1812_);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1803_ = g_strcmp0 (_tmp1811_, _tmp1816_) != 0;
		_g_free0 (_tmp1816_);
		_g_free0 (_tmp1811_);
	} else {
		_tmp1803_ = FALSE;
	}
	if (_tmp1803_) {
		ValaCCodeExpression* _tmp1817_;
		ValaMethod* _tmp1818_;
		ValaDataType* _tmp1819_;
		ValaDataType* _tmp1820_;
		gchar* _tmp1821_;
		gchar* _tmp1822_;
		ValaCCodeCastExpression* _tmp1823_;
		_tmp1817_ = ccall_expr;
		_tmp1818_ = m;
		_tmp1819_ = vala_callable_get_return_type ((ValaCallable*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1820_);
		_tmp1822_ = _tmp1821_;
		_tmp1823_ = vala_ccode_cast_expression_new (_tmp1817_, _tmp1822_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1823_;
		_g_free0 (_tmp1822_);
	}
	_tmp1824_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1824_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1825_;
		ValaList* _tmp1826_;
		ValaIterator* _tmp1827_;
		ValaIterator* _tmp1828_;
		ValaIterator* _tmp1829_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1830_;
		gpointer _tmp1831_;
		ValaExpression* _tmp1832_;
		ValaCCodeExpression* _tmp1833_;
		ValaCCodeExpression* _tmp1834_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1835_;
		ValaLocalVariable* _tmp1836_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1837_;
		const gchar* _tmp1838_;
		const gchar* _tmp1839_;
		ValaCCodeExpression* _tmp1840_;
		ValaLocalVariable* _tmp1841_;
		ValaCCodeFile* _tmp1842_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1843_;
		ValaExpression* _tmp1844_;
		ValaExpression* _tmp1845_;
		ValaCCodeExpression* _tmp1846_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1847_;
		ValaExpression* _tmp1848_;
		ValaExpression* _tmp1849_;
		ValaCCodeExpression* _tmp1850_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1851_;
		ValaExpression* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaDataType* _tmp1854_;
		ValaDataType* _tmp1855_;
		ValaArrayType* _tmp1856_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1857_;
		ValaDataType* _tmp1858_;
		ValaDataType* _tmp1859_;
		gchar* _tmp1860_;
		gchar* _tmp1861_;
		gchar* _tmp1862_;
		gchar* _tmp1863_;
		ValaCCodeIdentifier* _tmp1864_;
		ValaCCodeIdentifier* _tmp1865_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1866_;
		ValaCCodeExpression* _tmp1867_;
		ValaCCodeBinaryExpression* _tmp1868_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1869_;
		ValaCCodeExpression* _tmp1870_;
		ValaCCodeBinaryExpression* _tmp1871_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1872_;
		ValaCCodeIdentifier* _tmp1873_;
		ValaCCodeFunctionCall* _tmp1874_;
		ValaCCodeFunctionCall* _tmp1875_;
		ValaCCodeFunctionCall* _tmp1876_;
		ValaCCodeExpression* _tmp1877_;
		ValaCCodeExpression* _tmp1878_;
		ValaCCodeBinaryExpression* _tmp1879_;
		ValaCCodeBinaryExpression* _tmp1880_;
		ValaCCodeFunctionCall* _tmp1881_;
		ValaCCodeConstant* _tmp1882_;
		ValaCCodeConstant* _tmp1883_;
		ValaCCodeFunctionCall* _tmp1884_;
		ValaCCodeIdentifier* _tmp1885_;
		ValaCCodeBinaryExpression* _tmp1886_;
		ValaCCodeBinaryExpression* _tmp1887_;
		ValaCCodeBinaryExpression* _tmp1888_;
		ValaCCodeFunction* _tmp1889_;
		ValaCCodeFunction* _tmp1890_;
		ValaCCodeExpression* _tmp1891_;
		ValaCCodeExpression* _tmp1892_;
		ValaCCodeFunction* _tmp1893_;
		ValaCCodeFunction* _tmp1894_;
		ValaCCodeExpression* _tmp1895_;
		ValaCCodeFunction* _tmp1896_;
		ValaCCodeFunction* _tmp1897_;
		ValaCCodeBinaryExpression* _tmp1898_;
		ValaCCodeFunctionCall* _tmp1899_;
		ValaCCodeConstant* _tmp1900_;
		ValaCCodeConstant* _tmp1901_;
		ValaCCodeConditionalExpression* _tmp1902_;
		ValaCCodeConditionalExpression* _tmp1903_;
		ValaCCodeFunction* _tmp1904_;
		ValaCCodeFunction* _tmp1905_;
		ValaMemberAccess* _tmp1906_;
		ValaExpression* _tmp1907_;
		ValaExpression* _tmp1908_;
		ValaCCodeExpression* _tmp1909_;
		ValaCCodeExpression* _tmp1910_;
		ValaCCodeExpression* _tmp1911_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1912_;
		ValaExpression* _tmp1913_;
		ValaExpression* _tmp1914_;
		ValaSymbol* _tmp1915_;
		ValaSymbol* _tmp1916_;
		ValaSymbol* _tmp1917_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1918_;
		ValaLocalVariable* _tmp1919_;
		gboolean _tmp1920_ = FALSE;
		gboolean _tmp1921_ = FALSE;
		ValaSymbol* _tmp1922_;
		_tmp1825_ = vala_method_call_get_argument_list (expr);
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = vala_iterable_iterator ((ValaIterable*) _tmp1826_);
		_tmp1828_ = _tmp1827_;
		_vala_iterable_unref0 (_tmp1826_);
		arg_it = _tmp1828_;
		_tmp1829_ = arg_it;
		vala_iterator_next (_tmp1829_);
		_tmp1830_ = arg_it;
		_tmp1831_ = vala_iterator_get (_tmp1830_);
		_tmp1832_ = (ValaExpression*) _tmp1831_;
		_tmp1833_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1832_);
		_tmp1834_ = _tmp1833_;
		_vala_code_node_unref0 (_tmp1832_);
		new_size = _tmp1834_;
		_tmp1835_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1836_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1835_, TRUE, NULL, FALSE);
		temp_decl = _tmp1836_;
		_tmp1837_ = temp_decl;
		_tmp1838_ = vala_symbol_get_name ((ValaSymbol*) _tmp1837_);
		_tmp1839_ = _tmp1838_;
		_tmp1840_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1839_);
		temp_ref = _tmp1840_;
		_tmp1841_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1841_, FALSE);
		_tmp1842_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1842_, "string.h", FALSE);
		_tmp1843_ = ma;
		_tmp1844_ = vala_member_access_get_inner (_tmp1843_);
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1845_, 1);
		clen = _tmp1846_;
		_tmp1847_ = ma;
		_tmp1848_ = vala_member_access_get_inner (_tmp1847_);
		_tmp1849_ = _tmp1848_;
		_tmp1850_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1849_);
		celems = _tmp1850_;
		_tmp1851_ = ma;
		_tmp1852_ = vala_member_access_get_inner (_tmp1851_);
		_tmp1853_ = _tmp1852_;
		_tmp1854_ = vala_expression_get_value_type (_tmp1853_);
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1855_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1856_;
		_tmp1857_ = array_type;
		_tmp1858_ = vala_array_type_get_element_type (_tmp1857_);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1859_);
		_tmp1861_ = _tmp1860_;
		_tmp1862_ = g_strdup_printf ("sizeof (%s)", _tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_ccode_identifier_new (_tmp1863_);
		_tmp1865_ = _tmp1864_;
		_g_free0 (_tmp1863_);
		_g_free0 (_tmp1861_);
		csizeof = _tmp1865_;
		_tmp1866_ = temp_ref;
		_tmp1867_ = clen;
		_tmp1868_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1866_, _tmp1867_);
		cdelta = _tmp1868_;
		_tmp1869_ = temp_ref;
		_tmp1870_ = clen;
		_tmp1871_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1869_, _tmp1870_);
		ccheck = _tmp1871_;
		_tmp1872_ = vala_ccode_identifier_new ("memset");
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1873_);
		_tmp1875_ = _tmp1874_;
		_vala_ccode_node_unref0 (_tmp1873_);
		czero = _tmp1875_;
		_tmp1876_ = czero;
		_tmp1877_ = celems;
		_tmp1878_ = clen;
		_tmp1879_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1877_, _tmp1878_);
		_tmp1880_ = _tmp1879_;
		vala_ccode_function_call_add_argument (_tmp1876_, (ValaCCodeExpression*) _tmp1880_);
		_vala_ccode_node_unref0 (_tmp1880_);
		_tmp1881_ = czero;
		_tmp1882_ = vala_ccode_constant_new ("0");
		_tmp1883_ = _tmp1882_;
		vala_ccode_function_call_add_argument (_tmp1881_, (ValaCCodeExpression*) _tmp1883_);
		_vala_ccode_node_unref0 (_tmp1883_);
		_tmp1884_ = czero;
		_tmp1885_ = csizeof;
		_tmp1886_ = cdelta;
		_tmp1887_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1885_, (ValaCCodeExpression*) _tmp1886_);
		_tmp1888_ = _tmp1887_;
		vala_ccode_function_call_add_argument (_tmp1884_, (ValaCCodeExpression*) _tmp1888_);
		_vala_ccode_node_unref0 (_tmp1888_);
		_tmp1889_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1890_ = _tmp1889_;
		_tmp1891_ = temp_ref;
		_tmp1892_ = new_size;
		vala_ccode_function_add_assignment (_tmp1890_, _tmp1891_, _tmp1892_);
		_tmp1893_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1894_ = _tmp1893_;
		_tmp1895_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1894_, _tmp1895_);
		_tmp1896_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1897_ = _tmp1896_;
		_tmp1898_ = ccheck;
		_tmp1899_ = czero;
		_tmp1900_ = vala_ccode_constant_new ("NULL");
		_tmp1901_ = _tmp1900_;
		_tmp1902_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1898_, (ValaCCodeExpression*) _tmp1899_, (ValaCCodeExpression*) _tmp1901_);
		_tmp1903_ = _tmp1902_;
		vala_ccode_function_add_expression (_tmp1897_, (ValaCCodeExpression*) _tmp1903_);
		_vala_ccode_node_unref0 (_tmp1903_);
		_vala_ccode_node_unref0 (_tmp1901_);
		_tmp1904_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1905_ = _tmp1904_;
		_tmp1906_ = ma;
		_tmp1907_ = vala_member_access_get_inner (_tmp1906_);
		_tmp1908_ = _tmp1907_;
		_tmp1909_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1908_, 1);
		_tmp1910_ = _tmp1909_;
		_tmp1911_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1905_, _tmp1910_, _tmp1911_);
		_vala_ccode_node_unref0 (_tmp1910_);
		_tmp1912_ = ma;
		_tmp1913_ = vala_member_access_get_inner (_tmp1912_);
		_tmp1914_ = _tmp1913_;
		_tmp1915_ = vala_expression_get_symbol_reference (_tmp1914_);
		_tmp1916_ = _tmp1915_;
		_tmp1917_ = _vala_code_node_ref0 (_tmp1916_);
		array_var = _tmp1917_;
		_tmp1918_ = array_var;
		_tmp1919_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1918_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1918_) : NULL);
		array_local = _tmp1919_;
		_tmp1922_ = array_var;
		if (_tmp1922_ != NULL) {
			ValaSymbol* _tmp1923_;
			_tmp1923_ = array_var;
			_tmp1921_ = vala_symbol_is_internal_symbol (_tmp1923_);
		} else {
			_tmp1921_ = FALSE;
		}
		if (_tmp1921_) {
			gboolean _tmp1924_ = FALSE;
			gboolean _tmp1925_ = FALSE;
			ValaSymbol* _tmp1926_;
			_tmp1926_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1926_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1927_;
				gboolean _tmp1928_;
				gboolean _tmp1929_;
				_tmp1927_ = array_local;
				_tmp1928_ = vala_local_variable_get_captured (_tmp1927_);
				_tmp1929_ = _tmp1928_;
				_tmp1925_ = !_tmp1929_;
			} else {
				_tmp1925_ = FALSE;
			}
			if (_tmp1925_) {
				_tmp1924_ = TRUE;
			} else {
				ValaSymbol* _tmp1930_;
				_tmp1930_ = array_var;
				_tmp1924_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1930_, VALA_TYPE_FIELD);
			}
			_tmp1920_ = _tmp1924_;
		} else {
			_tmp1920_ = FALSE;
		}
		if (_tmp1920_) {
			ValaCCodeFunction* _tmp1931_;
			ValaCCodeFunction* _tmp1932_;
			ValaMemberAccess* _tmp1933_;
			ValaExpression* _tmp1934_;
			ValaExpression* _tmp1935_;
			ValaTargetValue* _tmp1936_;
			ValaTargetValue* _tmp1937_;
			ValaCCodeExpression* _tmp1938_;
			ValaCCodeExpression* _tmp1939_;
			ValaCCodeExpression* _tmp1940_;
			_tmp1931_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1932_ = _tmp1931_;
			_tmp1933_ = ma;
			_tmp1934_ = vala_member_access_get_inner (_tmp1933_);
			_tmp1935_ = _tmp1934_;
			_tmp1936_ = vala_expression_get_target_value (_tmp1935_);
			_tmp1937_ = _tmp1936_;
			_tmp1938_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1937_);
			_tmp1939_ = _tmp1938_;
			_tmp1940_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1932_, _tmp1939_, _tmp1940_);
			_vala_ccode_node_unref0 (_tmp1939_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1942_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1943_ = _tmp1942_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1943_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1944_;
		ValaDataType* _tmp1945_;
		_tmp1944_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1945_ = _tmp1944_;
		_tmp1941_ = !vala_data_type_is_disposable (_tmp1945_);
	} else {
		_tmp1941_ = FALSE;
	}
	if (_tmp1941_) {
		gboolean _tmp1946_ = FALSE;
		ValaCCodeExpression* _tmp1947_;
		_tmp1947_ = ccall_expr;
		if (_tmp1947_ != NULL) {
			gboolean _tmp1948_;
			_tmp1948_ = return_result_via_out_param;
			_tmp1946_ = !_tmp1948_;
		} else {
			_tmp1946_ = FALSE;
		}
		if (_tmp1946_) {
			ValaCCodeFunction* _tmp1949_;
			ValaCCodeFunction* _tmp1950_;
			ValaCCodeExpression* _tmp1951_;
			_tmp1949_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1950_ = _tmp1949_;
			_tmp1951_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1950_, _tmp1951_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1952_;
		ValaDataType* _tmp1953_;
		gboolean _tmp1954_ = FALSE;
		ValaDataType* _tmp1955_;
		ValaDataType* _tmp1956_;
		gboolean _tmp1983_ = FALSE;
		ValaMethod* _tmp1984_;
		_tmp1952_ = itype;
		_tmp1953_ = vala_data_type_get_return_type (_tmp1952_);
		result_type = _tmp1953_;
		_tmp1955_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1956_ = _tmp1955_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1956_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1957_;
			ValaDataType* _tmp1958_;
			_tmp1957_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1958_ = _tmp1957_;
			_tmp1954_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1958_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1954_ = FALSE;
		}
		if (_tmp1954_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1959_;
			ValaDataType* _tmp1960_;
			ValaTypeParameter* _tmp1961_;
			ValaTypeParameter* _tmp1962_;
			ValaTypeParameter* _tmp1963_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1964_;
			ValaSymbol* _tmp1965_;
			ValaSymbol* _tmp1966_;
			ValaSymbol* _tmp1967_;
			ValaSymbol* _tmp1968_;
			ValaStruct* _tmp1969_;
			gboolean _tmp1970_ = FALSE;
			ValaTypeParameter* _tmp1971_;
			ValaSymbol* _tmp1972_;
			ValaSymbol* _tmp1973_;
			ValaTypeSymbol* _tmp1974_;
			_tmp1959_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1960_ = _tmp1959_;
			_tmp1961_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1960_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1962_ = _tmp1961_;
			_tmp1963_ = _vala_code_node_ref0 (_tmp1962_);
			type_parameter = _tmp1963_;
			_tmp1964_ = type_parameter;
			_tmp1965_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1964_);
			_tmp1966_ = _tmp1965_;
			_tmp1967_ = vala_symbol_get_parent_symbol (_tmp1966_);
			_tmp1968_ = _tmp1967_;
			_tmp1969_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1968_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1968_) : NULL);
			st = _tmp1969_;
			_tmp1971_ = type_parameter;
			_tmp1972_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1971_);
			_tmp1973_ = _tmp1972_;
			_tmp1974_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1973_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1974_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1970_ = TRUE;
			} else {
				gboolean _tmp1975_ = FALSE;
				ValaStruct* _tmp1976_;
				_tmp1976_ = st;
				if (_tmp1976_ != NULL) {
					ValaStruct* _tmp1977_;
					gchar* _tmp1978_;
					gchar* _tmp1979_;
					_tmp1977_ = st;
					_tmp1978_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1977_);
					_tmp1979_ = _tmp1978_;
					_tmp1975_ = g_strcmp0 (_tmp1979_, "va_list") == 0;
					_g_free0 (_tmp1979_);
				} else {
					_tmp1975_ = FALSE;
				}
				_tmp1970_ = _tmp1975_;
			}
			if (_tmp1970_) {
				ValaDataType* _tmp1980_;
				ValaDataType* _tmp1981_;
				ValaDataType* _tmp1982_;
				_tmp1980_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1981_ = _tmp1980_;
				_tmp1982_ = _vala_code_node_ref0 (_tmp1981_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1982_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1984_ = m;
		if (_tmp1984_ != NULL) {
			ValaMethod* _tmp1985_;
			_tmp1985_ = m;
			_tmp1983_ = vala_method_get_format_arg_index (_tmp1985_) >= 0;
		} else {
			_tmp1983_ = FALSE;
		}
		if (_tmp1983_) {
			ValaCCodeExpression* _tmp1986_;
			_tmp1986_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1986_);
		} else {
			gboolean _tmp1987_ = FALSE;
			ValaMethod* _tmp1988_;
			_tmp1988_ = m;
			if (_tmp1988_ != NULL) {
				ValaMethod* _tmp1989_;
				_tmp1989_ = m;
				_tmp1987_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1989_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1987_ = FALSE;
			}
			if (_tmp1987_) {
				ValaCCodeExpression* _tmp1990_;
				_tmp1990_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1990_);
			} else {
				gboolean _tmp1991_ = FALSE;
				gboolean _tmp1992_ = FALSE;
				gboolean _tmp1993_;
				_tmp1993_ = return_result_via_out_param;
				if (!_tmp1993_) {
					_tmp1992_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp1992_ = FALSE;
				}
				if (_tmp1992_) {
					gboolean _tmp1994_ = FALSE;
					ValaDataType* _tmp1995_;
					_tmp1995_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1995_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1996_;
						_tmp1996_ = result_type;
						_tmp1994_ = !vala_data_type_is_disposable (_tmp1996_);
					} else {
						_tmp1994_ = FALSE;
					}
					_tmp1991_ = _tmp1994_;
				} else {
					_tmp1991_ = FALSE;
				}
				if (_tmp1991_) {
					ValaCCodeExpression* _tmp1997_;
					_tmp1997_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1997_);
				} else {
					gboolean _tmp1998_;
					_tmp1998_ = return_result_via_out_param;
					if (!_tmp1998_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1999_;
						ValaDataType* _tmp2000_;
						gboolean _tmp2001_;
						gboolean _tmp2002_;
						ValaLocalVariable* _tmp2003_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2004_;
						const gchar* _tmp2005_;
						const gchar* _tmp2006_;
						ValaCCodeExpression* _tmp2007_;
						ValaLocalVariable* _tmp2008_;
						ValaCCodeFunction* _tmp2009_;
						ValaCCodeFunction* _tmp2010_;
						ValaCCodeExpression* _tmp2011_;
						ValaCCodeExpression* _tmp2012_;
						ValaCCodeExpression* _tmp2013_;
						ValaTargetValue* _tmp2014_;
						ValaTargetValue* _tmp2015_;
						_tmp1999_ = result_type;
						_tmp2000_ = result_type;
						_tmp2001_ = vala_data_type_get_value_owned (_tmp2000_);
						_tmp2002_ = _tmp2001_;
						_tmp2003_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1999_, _tmp2002_, NULL, FALSE);
						temp_var = _tmp2003_;
						_tmp2004_ = temp_var;
						_tmp2005_ = vala_symbol_get_name ((ValaSymbol*) _tmp2004_);
						_tmp2006_ = _tmp2005_;
						_tmp2007_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2006_);
						temp_ref = _tmp2007_;
						_tmp2008_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2008_, FALSE);
						_tmp2009_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2010_ = _tmp2009_;
						_tmp2011_ = temp_ref;
						_tmp2012_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2010_, _tmp2011_, _tmp2012_);
						_tmp2013_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2013_);
						_tmp2014_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2015_ = _tmp2014_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2015_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2016_;
						ValaTargetValue* _tmp2017_;
						ValaTargetValue* _tmp2018_;
						_tmp2016_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2016_);
						_tmp2017_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2018_ = _tmp2017_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2018_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2019_ = params;
	_tmp2020_ = vala_iterable_iterator ((ValaIterable*) _tmp2019_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2020_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2021_;
		gint _arg_size = 0;
		ValaList* _tmp2022_;
		gint _tmp2023_;
		gint _tmp2024_;
		gint _arg_index = 0;
		_tmp2021_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2021_;
		_tmp2022_ = _arg_list;
		_tmp2023_ = vala_collection_get_size ((ValaCollection*) _tmp2022_);
		_tmp2024_ = _tmp2023_;
		_arg_size = _tmp2024_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2025_;
			gint _tmp2026_;
			gint _tmp2027_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2028_;
			gint _tmp2029_;
			gpointer _tmp2030_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2031_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2034_;
			ValaUnaryExpression* _tmp2035_;
			gboolean _tmp2036_ = FALSE;
			ValaUnaryExpression* _tmp2037_;
			ValaUnaryExpression* _tmp2041_;
			ValaExpression* _tmp2042_;
			ValaExpression* _tmp2043_;
			ValaDataType* _tmp2044_;
			ValaDataType* _tmp2045_;
			ValaUnaryExpression* _tmp2055_;
			ValaExpression* _tmp2056_;
			ValaExpression* _tmp2057_;
			ValaTargetValue* _tmp2058_;
			ValaTargetValue* _tmp2059_;
			ValaUnaryExpression* _tmp2060_;
			ValaTargetValue* _tmp2061_;
			ValaTargetValue* _tmp2062_;
			ValaUnaryExpression* _tmp2063_;
			ValaExpression* _tmp2064_;
			ValaExpression* _tmp2065_;
			ValaDataType* _tmp2066_;
			ValaDataType* _tmp2067_;
			ValaExpression* _tmp2068_;
			ValaTargetValue* _tmp2069_;
			ValaTargetValue* _tmp2070_;
			ValaSourceReference* _tmp2071_;
			ValaSourceReference* _tmp2072_;
			gboolean _tmp2073_ = FALSE;
			ValaParameter* _tmp2074_;
			_tmp2025_ = _arg_index;
			_arg_index = _tmp2025_ + 1;
			_tmp2026_ = _arg_index;
			_tmp2027_ = _arg_size;
			if (!(_tmp2026_ < _tmp2027_)) {
				break;
			}
			_tmp2028_ = _arg_list;
			_tmp2029_ = _arg_index;
			_tmp2030_ = vala_list_get (_tmp2028_, _tmp2029_);
			arg = (ValaExpression*) _tmp2030_;
			param = NULL;
			_tmp2031_ = params_it;
			if (vala_iterator_next (_tmp2031_)) {
				ValaIterator* _tmp2032_;
				gpointer _tmp2033_;
				_tmp2032_ = params_it;
				_tmp2033_ = vala_iterator_get (_tmp2032_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2033_;
			}
			_tmp2034_ = arg;
			_tmp2035_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2034_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2034_) : NULL);
			unary = _tmp2035_;
			_tmp2037_ = unary;
			if (_tmp2037_ == NULL) {
				_tmp2036_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2038_;
				ValaUnaryOperator _tmp2039_;
				ValaUnaryOperator _tmp2040_;
				_tmp2038_ = unary;
				_tmp2039_ = vala_unary_expression_get_operator (_tmp2038_);
				_tmp2040_ = _tmp2039_;
				_tmp2036_ = _tmp2040_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2036_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2041_ = unary;
			_tmp2042_ = vala_unary_expression_get_inner (_tmp2041_);
			_tmp2043_ = _tmp2042_;
			_tmp2044_ = vala_expression_get_value_type (_tmp2043_);
			_tmp2045_ = _tmp2044_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2045_)) {
				ValaCCodeFunction* _tmp2046_;
				ValaCCodeFunction* _tmp2047_;
				ValaUnaryExpression* _tmp2048_;
				ValaExpression* _tmp2049_;
				ValaExpression* _tmp2050_;
				ValaTargetValue* _tmp2051_;
				ValaTargetValue* _tmp2052_;
				ValaCCodeExpression* _tmp2053_;
				ValaCCodeExpression* _tmp2054_;
				_tmp2046_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2047_ = _tmp2046_;
				_tmp2048_ = unary;
				_tmp2049_ = vala_unary_expression_get_inner (_tmp2048_);
				_tmp2050_ = _tmp2049_;
				_tmp2051_ = vala_expression_get_target_value (_tmp2050_);
				_tmp2052_ = _tmp2051_;
				_tmp2053_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2052_, FALSE);
				_tmp2054_ = _tmp2053_;
				vala_ccode_function_add_expression (_tmp2047_, _tmp2054_);
				_vala_ccode_node_unref0 (_tmp2054_);
			}
			_tmp2055_ = unary;
			_tmp2056_ = vala_unary_expression_get_inner (_tmp2055_);
			_tmp2057_ = _tmp2056_;
			_tmp2058_ = vala_expression_get_target_value (_tmp2057_);
			_tmp2059_ = _tmp2058_;
			_tmp2060_ = unary;
			_tmp2061_ = vala_expression_get_target_value ((ValaExpression*) _tmp2060_);
			_tmp2062_ = _tmp2061_;
			_tmp2063_ = unary;
			_tmp2064_ = vala_unary_expression_get_inner (_tmp2063_);
			_tmp2065_ = _tmp2064_;
			_tmp2066_ = vala_expression_get_value_type (_tmp2065_);
			_tmp2067_ = _tmp2066_;
			_tmp2068_ = arg;
			_tmp2069_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2062_, _tmp2067_, (ValaCodeNode*) _tmp2068_);
			_tmp2070_ = _tmp2069_;
			_tmp2071_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2072_ = _tmp2071_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2059_, _tmp2070_, _tmp2072_);
			_vala_target_value_unref0 (_tmp2070_);
			_tmp2074_ = param;
			if (_tmp2074_ != NULL) {
				ValaParameter* _tmp2075_;
				_tmp2075_ = param;
				_tmp2073_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2075_);
			} else {
				_tmp2073_ = FALSE;
			}
			if (_tmp2073_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2076_;
				ValaCCodeIdentifier* _tmp2077_;
				ValaCCodeFunctionCall* _tmp2078_;
				ValaCCodeFunctionCall* _tmp2079_;
				ValaCCodeFunctionCall* _tmp2080_;
				ValaUnaryExpression* _tmp2081_;
				ValaExpression* _tmp2082_;
				ValaExpression* _tmp2083_;
				ValaTargetValue* _tmp2084_;
				ValaTargetValue* _tmp2085_;
				ValaCCodeExpression* _tmp2086_;
				ValaCCodeExpression* _tmp2087_;
				ValaCCodeFunction* _tmp2088_;
				ValaCCodeFunction* _tmp2089_;
				ValaUnaryExpression* _tmp2090_;
				ValaExpression* _tmp2091_;
				ValaExpression* _tmp2092_;
				ValaTargetValue* _tmp2093_;
				ValaTargetValue* _tmp2094_;
				ValaCCodeExpression* _tmp2095_;
				ValaCCodeExpression* _tmp2096_;
				ValaCCodeFunctionCall* _tmp2097_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2076_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2077_ = _tmp2076_;
				_tmp2078_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2077_);
				_tmp2079_ = _tmp2078_;
				_vala_ccode_node_unref0 (_tmp2077_);
				len_call = _tmp2079_;
				_tmp2080_ = len_call;
				_tmp2081_ = unary;
				_tmp2082_ = vala_unary_expression_get_inner (_tmp2081_);
				_tmp2083_ = _tmp2082_;
				_tmp2084_ = vala_expression_get_target_value (_tmp2083_);
				_tmp2085_ = _tmp2084_;
				_tmp2086_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2085_);
				_tmp2087_ = _tmp2086_;
				vala_ccode_function_call_add_argument (_tmp2080_, _tmp2087_);
				_vala_ccode_node_unref0 (_tmp2087_);
				_tmp2088_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2089_ = _tmp2088_;
				_tmp2090_ = unary;
				_tmp2091_ = vala_unary_expression_get_inner (_tmp2090_);
				_tmp2092_ = _tmp2091_;
				_tmp2093_ = vala_expression_get_target_value (_tmp2092_);
				_tmp2094_ = _tmp2093_;
				_tmp2095_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2094_, 1);
				_tmp2096_ = _tmp2095_;
				_tmp2097_ = len_call;
				vala_ccode_function_add_assignment (_tmp2089_, _tmp2096_, (ValaCCodeExpression*) _tmp2097_);
				_vala_ccode_node_unref0 (_tmp2096_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2100_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2100_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2101_;
		ValaSymbol* _tmp2102_;
		ValaSymbol* _tmp2103_;
		_tmp2101_ = m;
		_tmp2102_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2101_);
		_tmp2103_ = _tmp2102_;
		_tmp2099_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2103_, VALA_TYPE_CLASS);
	} else {
		_tmp2099_ = FALSE;
	}
	if (_tmp2099_) {
		gboolean _tmp2104_ = FALSE;
		gboolean _tmp2105_ = FALSE;
		ValaClass* _tmp2106_;
		ValaClass* _tmp2107_;
		gboolean _tmp2108_;
		gboolean _tmp2109_;
		_tmp2106_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2107_ = _tmp2106_;
		_tmp2108_ = vala_class_get_is_compact (_tmp2107_);
		_tmp2109_ = _tmp2108_;
		if (_tmp2109_) {
			ValaClass* _tmp2110_;
			ValaClass* _tmp2111_;
			ValaClass* _tmp2112_;
			ValaClass* _tmp2113_;
			_tmp2110_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2111_ = _tmp2110_;
			_tmp2112_ = vala_class_get_base_class (_tmp2111_);
			_tmp2113_ = _tmp2112_;
			_tmp2105_ = _tmp2113_ != NULL;
		} else {
			_tmp2105_ = FALSE;
		}
		if (_tmp2105_) {
			_tmp2104_ = TRUE;
		} else {
			ValaClass* _tmp2114_;
			ValaClass* _tmp2115_;
			ValaClass* _tmp2116_;
			ValaClass* _tmp2117_;
			ValaClass* _tmp2118_;
			_tmp2114_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2115_ = _tmp2114_;
			_tmp2116_ = vala_class_get_base_class (_tmp2115_);
			_tmp2117_ = _tmp2116_;
			_tmp2118_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2104_ = _tmp2117_ == _tmp2118_;
		}
		_tmp2098_ = _tmp2104_;
	} else {
		_tmp2098_ = FALSE;
	}
	if (_tmp2098_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2119_;
		ValaClass* _tmp2120_;
		gchar* _tmp2121_;
		gchar* _tmp2122_;
		gchar* _tmp2123_;
		gchar* _tmp2124_;
		ValaCCodeIdentifier* _tmp2125_;
		ValaCCodeIdentifier* _tmp2126_;
		ValaCCodeFunctionCall* _tmp2127_;
		ValaCCodeFunctionCall* _tmp2128_;
		ValaCCodeFunctionCall* _tmp2129_;
		ValaCCodeExpression* _tmp2130_;
		ValaCCodeExpression* _tmp2131_;
		ValaCCodeFunction* _tmp2132_;
		ValaCCodeFunction* _tmp2133_;
		ValaCCodeFunctionCall* _tmp2134_;
		_tmp2119_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2120_ = _tmp2119_;
		_tmp2121_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2120_, NULL);
		_tmp2122_ = _tmp2121_;
		_tmp2123_ = g_strdup_printf ("%s_instance_init", _tmp2122_);
		_tmp2124_ = _tmp2123_;
		_tmp2125_ = vala_ccode_identifier_new (_tmp2124_);
		_tmp2126_ = _tmp2125_;
		_tmp2127_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2126_);
		_tmp2128_ = _tmp2127_;
		_vala_ccode_node_unref0 (_tmp2126_);
		_g_free0 (_tmp2124_);
		_g_free0 (_tmp2122_);
		cinitcall = _tmp2128_;
		_tmp2129_ = cinitcall;
		_tmp2130_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2131_ = _tmp2130_;
		vala_ccode_function_call_add_argument (_tmp2129_, _tmp2131_);
		_vala_ccode_node_unref0 (_tmp2131_);
		_tmp2132_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2133_ = _tmp2132_;
		_tmp2134_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2133_, (ValaCCodeExpression*) _tmp2134_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaUnaryExpression* _tmp12_;
			_tmp4_ = _arg_index;
			_arg_index = _tmp4_ + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp10_) : NULL;
			_tmp12_ = unary;
			if (_tmp12_ != NULL) {
				gboolean _tmp13_ = FALSE;
				ValaUnaryExpression* _tmp14_;
				ValaUnaryOperator _tmp15_;
				ValaUnaryOperator _tmp16_;
				_tmp14_ = unary;
				_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp13_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp17_;
					ValaUnaryOperator _tmp18_;
					ValaUnaryOperator _tmp19_;
					_tmp17_ = unary;
					_tmp18_ = vala_unary_expression_get_operator (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp13_ = _tmp19_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp11_ = _tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



