/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};


static gpointer vala_initializer_list_parent_class = NULL;

#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);


/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			if (!vala_expression_is_constant (_tmp11_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			if (!vala_expression_is_pure (_tmp11_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_;
			_tmp6_ = _initializer_index;
			_initializer_index = _tmp6_ + 1;
			_tmp7_ = _initializer_index;
			_tmp8_ = _initializer_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _initializer_list;
			_tmp10_ = _initializer_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			initializer = (ValaExpression*) _tmp11_;
			_tmp12_ = first;
			if (_tmp12_) {
				GString* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = builder;
				_tmp14_ = initializer;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_string_append (_tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				first = FALSE;
			} else {
				GString* _tmp17_;
				ValaExpression* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp17_ = builder;
				_tmp18_ = initializer;
				_tmp19_ = vala_code_node_to_string ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append_printf (_tmp17_, ", %s", _tmp20_);
				_g_free0 (_tmp20_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp21_ = builder;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	result = _tmp23_;
	_g_string_free0 (builder);
	return result;
}


static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->initializers;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->initializers;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->initializers;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_ = FALSE;
	gboolean _tmp210_;
	gboolean _tmp217_;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			gboolean requires_constants_only = FALSE;
			ValaCodeNode* node = NULL;
			ValaCodeNode* _tmp13_;
			ValaCodeNode* _tmp14_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaCodeNode* _tmp22_;
			ValaCodeNode* _tmp23_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp12_;
			requires_constants_only = FALSE;
			_tmp13_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp14_ = _tmp13_;
			node = _tmp14_;
			while (TRUE) {
				ValaCodeNode* _tmp15_;
				ValaCodeNode* _tmp16_;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				ValaCodeNode* _tmp19_;
				_tmp15_ = node;
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_CONSTANT)) {
					requires_constants_only = TRUE;
					break;
				}
				_tmp17_ = node;
				_tmp18_ = vala_code_node_get_parent_node (_tmp17_);
				_tmp19_ = _tmp18_;
				node = _tmp19_;
			}
			_tmp22_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_ARRAY_CREATION_EXPRESSION)) {
				gboolean _tmp24_;
				_tmp24_ = requires_constants_only;
				_tmp21_ = !_tmp24_;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gboolean _tmp25_ = FALSE;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				_tmp26_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp27_ = _tmp26_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_INITIALIZER_LIST)) {
					_tmp25_ = TRUE;
				} else {
					ValaCodeNode* _tmp28_;
					ValaCodeNode* _tmp29_;
					ValaDataType* _tmp30_;
					ValaDataType* _tmp31_;
					ValaTypeSymbol* _tmp32_;
					ValaTypeSymbol* _tmp33_;
					_tmp28_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp29_ = _tmp28_;
					_tmp30_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_data_type_get_data_type (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_STRUCT);
				}
				_tmp20_ = _tmp25_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp34_;
				ValaCodeNode* _tmp35_;
				ValaCodeNode* _tmp36_;
				ValaArrayCreationExpression* array_creation = NULL;
				ValaArrayType* _tmp37_;
				ValaDataType* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaDataType* _tmp41_;
				ValaArrayType* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaArrayCreationExpression* _tmp47_;
				ValaArrayCreationExpression* _tmp48_;
				ValaArrayCreationExpression* _tmp49_;
				ValaDataType* _tmp50_;
				ValaDataType* _tmp51_;
				ValaCodeNode* _tmp52_;
				ValaArrayCreationExpression* _tmp53_;
				ValaArrayCreationExpression* _tmp54_;
				_tmp34_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = _vala_code_node_ref0 (_tmp35_);
				old_parent_node = _tmp36_;
				_tmp37_ = array_type;
				_tmp38_ = vala_array_type_get_element_type (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_data_type_copy (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = array_type;
				_tmp43_ = vala_array_type_get_rank (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_array_creation_expression_new (_tmp41_, _tmp44_, self, _tmp46_);
				_tmp48_ = _tmp47_;
				_vala_code_node_unref0 (_tmp41_);
				array_creation = _tmp48_;
				_tmp49_ = array_creation;
				_tmp50_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp51_ = _tmp50_;
				vala_expression_set_target_type ((ValaExpression*) _tmp49_, _tmp51_);
				_tmp52_ = old_parent_node;
				_tmp53_ = array_creation;
				vala_code_node_replace_expression (_tmp52_, (ValaExpression*) self, (ValaExpression*) _tmp53_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp54_ = array_creation;
				result = vala_code_node_check ((ValaCodeNode*) _tmp54_, context);
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp55_ = array_type;
			_tmp56_ = vala_array_type_get_rank (_tmp55_);
			_tmp57_ = _tmp56_;
			if (_tmp57_ > 1) {
				ValaArrayType* inner_array_type = NULL;
				ValaArrayType* _tmp58_;
				ValaDataType* _tmp59_;
				ValaArrayType* _tmp60_;
				gint _tmp61_;
				gint _tmp62_;
				ValaArrayType* _tmp63_;
				ValaDataType* _tmp64_;
				_tmp58_ = array_type;
				_tmp59_ = vala_data_type_copy ((ValaDataType*) _tmp58_);
				inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp60_ = inner_array_type;
				_tmp61_ = vala_array_type_get_rank (_tmp60_);
				_tmp62_ = _tmp61_;
				vala_array_type_set_rank (_tmp60_, _tmp62_ - 1);
				_tmp63_ = inner_array_type;
				_tmp64_ = _vala_code_node_ref0 ((ValaDataType*) _tmp63_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp64_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp65_;
				ValaDataType* _tmp66_;
				ValaDataType* _tmp67_;
				ValaDataType* _tmp68_;
				_tmp65_ = array_type;
				_tmp66_ = vala_array_type_get_element_type (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_data_type_copy (_tmp67_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp68_;
			}
			{
				ValaList* _e_list = NULL;
				ValaList* _tmp69_;
				gint _e_size = 0;
				ValaList* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				gint _e_index = 0;
				_tmp69_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp69_;
				_tmp70_ = _e_list;
				_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
				_tmp72_ = _tmp71_;
				_e_size = _tmp72_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp73_;
					gint _tmp74_;
					gint _tmp75_;
					ValaExpression* e = NULL;
					ValaList* _tmp76_;
					gint _tmp77_;
					gpointer _tmp78_;
					ValaExpression* _tmp79_;
					ValaDataType* _tmp80_;
					_tmp73_ = _e_index;
					_e_index = _tmp73_ + 1;
					_tmp74_ = _e_index;
					_tmp75_ = _e_size;
					if (!(_tmp74_ < _tmp75_)) {
						break;
					}
					_tmp76_ = _e_list;
					_tmp77_ = _e_index;
					_tmp78_ = vala_list_get (_tmp76_, _tmp77_);
					e = (ValaExpression*) _tmp78_;
					_tmp79_ = e;
					_tmp80_ = inner_target_type;
					vala_expression_set_target_type (_tmp79_, _tmp80_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp81_;
			ValaDataType* _tmp82_;
			ValaTypeSymbol* _tmp83_;
			ValaTypeSymbol* _tmp84_;
			_tmp81_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_data_type_get_data_type (_tmp82_);
			_tmp84_ = _tmp83_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_STRUCT)) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp85_;
				ValaDataType* _tmp86_;
				ValaTypeSymbol* _tmp87_;
				ValaTypeSymbol* _tmp88_;
				ValaStruct* _tmp89_;
				ValaIterator* field_it = NULL;
				ValaStruct* _tmp97_;
				ValaList* _tmp98_;
				ValaList* _tmp99_;
				ValaIterator* _tmp100_;
				ValaIterator* _tmp101_;
				_tmp85_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_data_type_get_data_type (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_STRUCT, ValaStruct));
				st = _tmp89_;
				while (TRUE) {
					ValaStruct* _tmp90_;
					ValaStruct* _tmp91_;
					ValaStruct* _tmp92_;
					ValaStruct* _tmp93_;
					ValaStruct* _tmp94_;
					ValaStruct* _tmp95_;
					ValaStruct* _tmp96_;
					_tmp90_ = st;
					_tmp91_ = vala_struct_get_base_struct (_tmp90_);
					_tmp92_ = _tmp91_;
					if (!(_tmp92_ != NULL)) {
						break;
					}
					_tmp93_ = st;
					_tmp94_ = vala_struct_get_base_struct (_tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = _vala_code_node_ref0 (_tmp95_);
					_vala_code_node_unref0 (st);
					st = _tmp96_;
				}
				_tmp97_ = st;
				_tmp98_ = vala_struct_get_fields (_tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = vala_iterable_iterator ((ValaIterable*) _tmp99_);
				_tmp101_ = _tmp100_;
				_vala_iterable_unref0 (_tmp99_);
				field_it = _tmp101_;
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp102_;
					gint _e_size = 0;
					ValaList* _tmp103_;
					gint _tmp104_;
					gint _tmp105_;
					gint _e_index = 0;
					_tmp102_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp102_;
					_tmp103_ = _e_list;
					_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
					_tmp105_ = _tmp104_;
					_e_size = _tmp105_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp106_;
						gint _tmp107_;
						gint _tmp108_;
						ValaExpression* e = NULL;
						ValaList* _tmp109_;
						gint _tmp110_;
						gpointer _tmp111_;
						ValaField* field = NULL;
						ValaExpression* _tmp128_;
						ValaField* _tmp129_;
						ValaDataType* _tmp130_;
						ValaDataType* _tmp131_;
						ValaDataType* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						gboolean _tmp136_;
						gboolean _tmp137_;
						_tmp106_ = _e_index;
						_e_index = _tmp106_ + 1;
						_tmp107_ = _e_index;
						_tmp108_ = _e_size;
						if (!(_tmp107_ < _tmp108_)) {
							break;
						}
						_tmp109_ = _e_list;
						_tmp110_ = _e_index;
						_tmp111_ = vala_list_get (_tmp109_, _tmp110_);
						e = (ValaExpression*) _tmp111_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp112_;
							ValaIterator* _tmp113_;
							ValaIterator* _tmp123_;
							gpointer _tmp124_;
							ValaField* _tmp125_;
							ValaMemberBinding _tmp126_;
							ValaMemberBinding _tmp127_;
							_tmp112_ = field;
							if (!(_tmp112_ == NULL)) {
								break;
							}
							_tmp113_ = field_it;
							if (!vala_iterator_next (_tmp113_)) {
								ValaExpression* _tmp114_;
								ValaSourceReference* _tmp115_;
								ValaSourceReference* _tmp116_;
								ValaDataType* _tmp117_;
								ValaDataType* _tmp118_;
								gchar* _tmp119_;
								gchar* _tmp120_;
								gchar* _tmp121_;
								gchar* _tmp122_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp114_ = e;
								_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp114_);
								_tmp116_ = _tmp115_;
								_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp118_ = _tmp117_;
								_tmp119_ = vala_code_node_to_string ((ValaCodeNode*) _tmp118_);
								_tmp120_ = _tmp119_;
								_tmp121_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp120_);
								_tmp122_ = _tmp121_;
								vala_report_error (_tmp116_, _tmp122_);
								_g_free0 (_tmp122_);
								_g_free0 (_tmp120_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp123_ = field_it;
							_tmp124_ = vala_iterator_get (_tmp123_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp124_;
							_tmp125_ = field;
							_tmp126_ = vala_field_get_binding (_tmp125_);
							_tmp127_ = _tmp126_;
							if (_tmp127_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						_tmp128_ = e;
						_tmp129_ = field;
						_tmp130_ = vala_variable_get_variable_type ((ValaVariable*) _tmp129_);
						_tmp131_ = _tmp130_;
						_tmp132_ = vala_data_type_copy (_tmp131_);
						_tmp133_ = _tmp132_;
						vala_expression_set_target_type (_tmp128_, _tmp133_);
						_vala_code_node_unref0 (_tmp133_);
						_tmp134_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp135_ = _tmp134_;
						_tmp136_ = vala_data_type_get_value_owned (_tmp135_);
						_tmp137_ = _tmp136_;
						if (!_tmp137_) {
							ValaExpression* _tmp138_;
							ValaDataType* _tmp139_;
							ValaDataType* _tmp140_;
							_tmp138_ = e;
							_tmp139_ = vala_expression_get_target_type (_tmp138_);
							_tmp140_ = _tmp139_;
							vala_data_type_set_value_owned (_tmp140_, FALSE);
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				ValaDataType* _tmp143_;
				ValaDataType* _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_code_node_to_string ((ValaCodeNode*) _tmp144_);
				_tmp146_ = _tmp145_;
				_tmp147_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp146_);
				_tmp148_ = _tmp147_;
				vala_report_error (_tmp142_, _tmp148_);
				_g_free0 (_tmp148_);
				_g_free0 (_tmp146_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp149_;
		ValaList* _tmp150_;
		gint _expr_size = 0;
		ValaList* _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		gint _expr_index = 0;
		_tmp149_ = self->priv->initializers;
		_tmp150_ = _vala_iterable_ref0 (_tmp149_);
		_expr_list = _tmp150_;
		_tmp151_ = _expr_list;
		_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
		_tmp153_ = _tmp152_;
		_expr_size = _tmp153_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			ValaExpression* expr = NULL;
			ValaList* _tmp157_;
			gint _tmp158_;
			gpointer _tmp159_;
			ValaExpression* _tmp160_;
			_tmp154_ = _expr_index;
			_expr_index = _tmp154_ + 1;
			_tmp155_ = _expr_index;
			_tmp156_ = _expr_size;
			if (!(_tmp155_ < _tmp156_)) {
				break;
			}
			_tmp157_ = _expr_list;
			_tmp158_ = _expr_index;
			_tmp159_ = vala_list_get (_tmp157_, _tmp158_);
			expr = (ValaExpression*) _tmp159_;
			_tmp160_ = expr;
			vala_code_node_check ((ValaCodeNode*) _tmp160_, context);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp161_;
		gint _e_size = 0;
		ValaList* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		gint _e_index = 0;
		_tmp161_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp161_;
		_tmp162_ = _e_list;
		_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
		_tmp164_ = _tmp163_;
		_e_size = _tmp164_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp165_;
			gint _tmp166_;
			gint _tmp167_;
			ValaExpression* e = NULL;
			ValaList* _tmp168_;
			gint _tmp169_;
			gpointer _tmp170_;
			ValaExpression* _tmp171_;
			ValaDataType* _tmp172_;
			ValaDataType* _tmp173_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp177_;
			ValaUnaryExpression* _tmp178_;
			gboolean _tmp179_ = FALSE;
			ValaUnaryExpression* _tmp180_;
			_tmp165_ = _e_index;
			_e_index = _tmp165_ + 1;
			_tmp166_ = _e_index;
			_tmp167_ = _e_size;
			if (!(_tmp166_ < _tmp167_)) {
				break;
			}
			_tmp168_ = _e_list;
			_tmp169_ = _e_index;
			_tmp170_ = vala_list_get (_tmp168_, _tmp169_);
			e = (ValaExpression*) _tmp170_;
			_tmp171_ = e;
			_tmp172_ = vala_expression_get_value_type (_tmp171_);
			_tmp173_ = _tmp172_;
			if (_tmp173_ == NULL) {
				ValaExpression* _tmp174_;
				ValaSourceReference* _tmp175_;
				ValaSourceReference* _tmp176_;
				_error_ = TRUE;
				_tmp174_ = e;
				_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp174_);
				_tmp176_ = _tmp175_;
				vala_report_error (_tmp176_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp177_ = e;
			_tmp178_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp177_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp177_) : NULL);
			unary = _tmp178_;
			_tmp180_ = unary;
			if (_tmp180_ != NULL) {
				gboolean _tmp181_ = FALSE;
				ValaUnaryExpression* _tmp182_;
				ValaUnaryOperator _tmp183_;
				ValaUnaryOperator _tmp184_;
				_tmp182_ = unary;
				_tmp183_ = vala_unary_expression_get_operator (_tmp182_);
				_tmp184_ = _tmp183_;
				if (_tmp184_ == VALA_UNARY_OPERATOR_REF) {
					_tmp181_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp185_;
					ValaUnaryOperator _tmp186_;
					ValaUnaryOperator _tmp187_;
					_tmp185_ = unary;
					_tmp186_ = vala_unary_expression_get_operator (_tmp185_);
					_tmp187_ = _tmp186_;
					_tmp181_ = _tmp187_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp179_ = _tmp181_;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
			} else {
				ValaExpression* _tmp188_;
				ValaDataType* _tmp189_;
				ValaDataType* _tmp190_;
				ValaExpression* _tmp191_;
				ValaDataType* _tmp192_;
				ValaDataType* _tmp193_;
				_tmp188_ = e;
				_tmp189_ = vala_expression_get_value_type (_tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = e;
				_tmp192_ = vala_expression_get_target_type (_tmp191_);
				_tmp193_ = _tmp192_;
				if (!vala_data_type_compatible (_tmp190_, _tmp193_)) {
					ValaExpression* _tmp194_;
					ValaExpression* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaExpression* _tmp198_;
					ValaDataType* _tmp199_;
					ValaDataType* _tmp200_;
					gchar* _tmp201_;
					gchar* _tmp202_;
					ValaExpression* _tmp203_;
					ValaDataType* _tmp204_;
					ValaDataType* _tmp205_;
					gchar* _tmp206_;
					gchar* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					_error_ = TRUE;
					_tmp194_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp194_, TRUE);
					_tmp195_ = e;
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = e;
					_tmp199_ = vala_expression_get_target_type (_tmp198_);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_code_node_to_string ((ValaCodeNode*) _tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = e;
					_tmp204_ = vala_expression_get_value_type (_tmp203_);
					_tmp205_ = _tmp204_;
					_tmp206_ = vala_code_node_to_string ((ValaCodeNode*) _tmp205_);
					_tmp207_ = _tmp206_;
					_tmp208_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp202_, _tmp207_);
					_tmp209_ = _tmp208_;
					vala_report_error (_tmp197_, _tmp209_);
					_g_free0 (_tmp209_);
					_g_free0 (_tmp207_);
					_g_free0 (_tmp202_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp210_ = _error_;
	if (!_tmp210_) {
		ValaDataType* _tmp211_;
		ValaDataType* _tmp212_;
		ValaDataType* _tmp213_;
		ValaDataType* _tmp214_;
		ValaDataType* _tmp215_;
		ValaDataType* _tmp216_;
		_tmp211_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_data_type_copy (_tmp212_);
		_tmp214_ = _tmp213_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp214_);
		_vala_code_node_unref0 (_tmp214_);
		_tmp215_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp216_ = _tmp215_;
		vala_data_type_set_nullable (_tmp216_, FALSE);
	}
	_tmp217_ = _error_;
	result = !_tmp217_;
	return result;
}


static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void
vala_initializer_list_class_init (ValaInitializerListClass * klass)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}


static void
vala_initializer_list_instance_init (ValaInitializerList * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}


static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}



