/* attributeargument.c generated by valac, the Vala compiler
 * generated from attributeargument.vala, do not modify */

/* attributeargument.vala
 *
 * Copyright (C) 2011 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

enum  {
	VALADOC_API_ATTRIBUTE_ARGUMENT_0_PROPERTY,
	VALADOC_API_ATTRIBUTE_ARGUMENT_NAME_PROPERTY,
	VALADOC_API_ATTRIBUTE_ARGUMENT_ARGUMENT_TYPE_PROPERTY,
	VALADOC_API_ATTRIBUTE_ARGUMENT_VALUE_PROPERTY,
	VALADOC_API_ATTRIBUTE_ARGUMENT_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocApiAttributeArgumentPrivate {
	ValadocApiSourceFile* file;
	gchar* _name;
	ValadocApiAttributeArgumentType _argument_type;
	gchar* _value;
};


static gpointer valadoc_api_attribute_argument_parent_class = NULL;

#define VALADOC_API_ATTRIBUTE_ARGUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, ValadocApiAttributeArgumentPrivate))
static ValadocApiAttributeArgument* valadoc_api_attribute_argument_new (ValadocApiAttribute* parent,
                                                                 ValadocApiSourceFile* file,
                                                                 const gchar* name,
                                                                 ValadocApiAttributeArgumentType type,
                                                                 const gchar* value,
                                                                 void* data);
static ValadocApiAttributeArgument* valadoc_api_attribute_argument_construct (GType object_type,
                                                                       ValadocApiAttribute* parent,
                                                                       ValadocApiSourceFile* file,
                                                                       const gchar* name,
                                                                       ValadocApiAttributeArgumentType type,
                                                                       const gchar* value,
                                                                       void* data);
static void valadoc_api_attribute_argument_set_argument_type (ValadocApiAttributeArgument* self,
                                                       ValadocApiAttributeArgumentType value);
static void valadoc_api_attribute_argument_set_value (ValadocApiAttributeArgument* self,
                                               const gchar* value);
static void valadoc_api_attribute_argument_set_name (ValadocApiAttributeArgument* self,
                                              const gchar* value);
static ValadocContentInline* valadoc_api_attribute_argument_real_build_signature (ValadocApiItem* base);
static void valadoc_api_attribute_argument_finalize (GObject * obj);
static void _vala_valadoc_api_attribute_argument_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_valadoc_api_attribute_argument_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);


GType
valadoc_api_attribute_argument_type_get_type (void)
{
	static volatile gsize valadoc_api_attribute_argument_type_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_attribute_argument_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_BOOLEAN, "VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_BOOLEAN", "boolean"}, {VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_INTEGER, "VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_INTEGER", "integer"}, {VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_DOUBLE, "VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_DOUBLE", "double"}, {VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_STRING, "VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_STRING", "string"}, {0, NULL, NULL}};
		GType valadoc_api_attribute_argument_type_type_id;
		valadoc_api_attribute_argument_type_type_id = g_enum_register_static ("ValadocApiAttributeArgumentType", values);
		g_once_init_leave (&valadoc_api_attribute_argument_type_type_id__volatile, valadoc_api_attribute_argument_type_type_id);
	}
	return valadoc_api_attribute_argument_type_type_id__volatile;
}


static gchar*
bool_to_string (gboolean self)
{
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_construct_boolean (GType object_type,
                                                  ValadocApiAttribute* parent,
                                                  ValadocApiSourceFile* file,
                                                  const gchar* name,
                                                  gboolean value,
                                                  void* data)
{
	ValadocApiAttributeArgument * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = bool_to_string (value);
	_tmp1_ = _tmp0_;
	self = (ValadocApiAttributeArgument*) valadoc_api_attribute_argument_construct (object_type, parent, file, name, VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_BOOLEAN, _tmp1_, data);
	_g_free0 (_tmp1_);
	return self;
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_new_boolean (ValadocApiAttribute* parent,
                                            ValadocApiSourceFile* file,
                                            const gchar* name,
                                            gboolean value,
                                            void* data)
{
	return valadoc_api_attribute_argument_construct_boolean (VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, parent, file, name, value, data);
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_construct_integer (GType object_type,
                                                  ValadocApiAttribute* parent,
                                                  ValadocApiSourceFile* file,
                                                  const gchar* name,
                                                  gint value,
                                                  void* data)
{
	ValadocApiAttributeArgument * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", value);
	_tmp1_ = _tmp0_;
	self = (ValadocApiAttributeArgument*) valadoc_api_attribute_argument_construct (object_type, parent, file, name, VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_INTEGER, _tmp1_, data);
	_g_free0 (_tmp1_);
	return self;
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_new_integer (ValadocApiAttribute* parent,
                                            ValadocApiSourceFile* file,
                                            const gchar* name,
                                            gint value,
                                            void* data)
{
	return valadoc_api_attribute_argument_construct_integer (VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, parent, file, name, value, data);
}


static gchar*
double_to_string (gdouble self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_construct_double (GType object_type,
                                                 ValadocApiAttribute* parent,
                                                 ValadocApiSourceFile* file,
                                                 const gchar* name,
                                                 gdouble value,
                                                 void* data)
{
	ValadocApiAttributeArgument * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = double_to_string (value);
	_tmp1_ = _tmp0_;
	self = (ValadocApiAttributeArgument*) valadoc_api_attribute_argument_construct (object_type, parent, file, name, VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_DOUBLE, _tmp1_, data);
	_g_free0 (_tmp1_);
	return self;
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_new_double (ValadocApiAttribute* parent,
                                           ValadocApiSourceFile* file,
                                           const gchar* name,
                                           gdouble value,
                                           void* data)
{
	return valadoc_api_attribute_argument_construct_double (VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, parent, file, name, value, data);
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_construct_string (GType object_type,
                                                 ValadocApiAttribute* parent,
                                                 ValadocApiSourceFile* file,
                                                 const gchar* name,
                                                 const gchar* value,
                                                 void* data)
{
	ValadocApiAttributeArgument * self = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (ValadocApiAttributeArgument*) valadoc_api_attribute_argument_construct (object_type, parent, file, name, VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_STRING, value, data);
	return self;
}


ValadocApiAttributeArgument*
valadoc_api_attribute_argument_new_string (ValadocApiAttribute* parent,
                                           ValadocApiSourceFile* file,
                                           const gchar* name,
                                           const gchar* value,
                                           void* data)
{
	return valadoc_api_attribute_argument_construct_string (VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, parent, file, name, value, data);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static ValadocApiAttributeArgument*
valadoc_api_attribute_argument_construct (GType object_type,
                                          ValadocApiAttribute* parent,
                                          ValadocApiSourceFile* file,
                                          const gchar* name,
                                          ValadocApiAttributeArgumentType type,
                                          const gchar* value,
                                          void* data)
{
	ValadocApiAttributeArgument * self = NULL;
	ValadocApiSourceFile* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (ValadocApiAttributeArgument*) valadoc_api_item_construct (object_type, data);
	valadoc_api_attribute_argument_set_argument_type (self, type);
	valadoc_api_item_set_parent ((ValadocApiItem*) self, (ValadocApiItem*) parent);
	valadoc_api_attribute_argument_set_value (self, value);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	valadoc_api_attribute_argument_set_name (self, name);
	return self;
}


static ValadocApiAttributeArgument*
valadoc_api_attribute_argument_new (ValadocApiAttribute* parent,
                                    ValadocApiSourceFile* file,
                                    const gchar* name,
                                    ValadocApiAttributeArgumentType type,
                                    const gchar* value,
                                    void* data)
{
	return valadoc_api_attribute_argument_construct (VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, parent, file, name, type, value, data);
}


ValadocApiSourceFile*
valadoc_api_attribute_argument_get_source_file (ValadocApiAttributeArgument* self)
{
	ValadocApiSourceFile* result = NULL;
	ValadocApiSourceFile* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean
bool_try_parse (const gchar* str,
                gboolean* _result_)
{
	gboolean _vala_result = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		_vala_result = TRUE;
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		if (g_strcmp0 (str, "false") == 0) {
			_vala_result = FALSE;
			result = TRUE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		} else {
			_vala_result = FALSE;
			result = FALSE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		}
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


gboolean
valadoc_api_attribute_argument_get_value_as_boolean (ValadocApiAttributeArgument* self)
{
	gboolean result = FALSE;
	ValadocApiAttributeArgumentType _tmp0_;
	gboolean tmp = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_argument_type;
	_vala_assert (_tmp0_ == VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_BOOLEAN, "argument_type == Type.BOOLEAN");
	_tmp1_ = self->priv->_value;
	_tmp3_ = bool_try_parse (_tmp1_, &_tmp2_);
	tmp = _tmp2_;
	if (_tmp3_) {
		result = tmp;
		return result;
	}
	g_assert_not_reached ();
}


static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar* * unparsed)
{
	gdouble _vala_result = 0.0;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}


gint
valadoc_api_attribute_argument_get_value_as_integer (ValadocApiAttributeArgument* self)
{
	gint result = 0;
	ValadocApiAttributeArgumentType _tmp0_;
	gdouble tmp = 0.0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gdouble _tmp4_ = 0.0;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_argument_type;
	_vala_assert (_tmp0_ == VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_INTEGER, "argument_type == Type.INTEGER");
	_tmp3_ = self->priv->_value;
	_tmp5_ = double_try_parse (_tmp3_, &_tmp4_, NULL);
	tmp = _tmp4_;
	if (_tmp5_) {
		gdouble _tmp6_;
		_tmp6_ = tmp;
		_tmp2_ = _tmp6_ >= ((gdouble) G_MININT);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gdouble _tmp7_;
		_tmp7_ = tmp;
		_tmp1_ = _tmp7_ <= ((gdouble) G_MAXINT);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gdouble _tmp8_;
		_tmp8_ = tmp;
		result = (gint) _tmp8_;
		return result;
	}
	g_assert_not_reached ();
}


gdouble
valadoc_api_attribute_argument_get_value_as_double (ValadocApiAttributeArgument* self)
{
	gdouble result = 0.0;
	ValadocApiAttributeArgumentType _tmp0_;
	gdouble tmp = 0.0;
	const gchar* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_argument_type;
	_vala_assert (_tmp0_ == VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_DOUBLE, "argument_type == Type.DOUBLE");
	_tmp1_ = self->priv->_value;
	_tmp3_ = double_try_parse (_tmp1_, &_tmp2_, NULL);
	tmp = _tmp2_;
	if (_tmp3_) {
		result = tmp;
		return result;
	}
	g_assert_not_reached ();
}


gchar*
valadoc_api_attribute_argument_get_value_as_string (ValadocApiAttributeArgument* self)
{
	gchar* result = NULL;
	ValadocApiAttributeArgumentType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_argument_type;
	_vala_assert (_tmp0_ == VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_STRING, "argument_type == Type.STRING");
	_tmp1_ = self->priv->_value;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


static ValadocContentInline*
valadoc_api_attribute_argument_real_build_signature (ValadocApiItem* base)
{
	ValadocApiAttributeArgument * self;
	ValadocContentInline* result = NULL;
	ValadocApiSignatureBuilder* builder = NULL;
	ValadocApiSignatureBuilder* _tmp0_;
	const gchar* _tmp1_;
	ValadocApiSignatureBuilder* _tmp2_;
	ValadocApiSignatureBuilder* _tmp3_;
	ValadocApiSignatureBuilder* _tmp4_;
	ValadocApiSignatureBuilder* _tmp5_;
	const gchar* _tmp6_;
	ValadocApiSignatureBuilder* _tmp7_;
	ValadocApiSignatureBuilder* _tmp8_;
	ValadocContentRun* _tmp9_;
	self = (ValadocApiAttributeArgument*) base;
	_tmp0_ = valadoc_api_signature_builder_new ();
	builder = _tmp0_;
	_tmp1_ = self->priv->_name;
	_tmp2_ = valadoc_api_signature_builder_append_attribute (builder, _tmp1_, TRUE);
	_tmp3_ = _tmp2_;
	_valadoc_api_signature_builder_unref0 (_tmp3_);
	_tmp4_ = valadoc_api_signature_builder_append_attribute (builder, "=", TRUE);
	_tmp5_ = _tmp4_;
	_valadoc_api_signature_builder_unref0 (_tmp5_);
	_tmp6_ = self->priv->_value;
	_tmp7_ = valadoc_api_signature_builder_append_literal (builder, _tmp6_, TRUE);
	_tmp8_ = _tmp7_;
	_valadoc_api_signature_builder_unref0 (_tmp8_);
	_tmp9_ = valadoc_api_signature_builder_get (builder);
	result = (ValadocContentInline*) _tmp9_;
	_valadoc_api_signature_builder_unref0 (builder);
	return result;
}


const gchar*
valadoc_api_attribute_argument_get_name (ValadocApiAttributeArgument* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_attribute_argument_set_name (ValadocApiAttributeArgument* self,
                                         const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_api_attribute_argument_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_NAME_PROPERTY]);
	}
}


ValadocApiAttributeArgumentType
valadoc_api_attribute_argument_get_argument_type (ValadocApiAttributeArgument* self)
{
	ValadocApiAttributeArgumentType result;
	ValadocApiAttributeArgumentType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_argument_type;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_attribute_argument_set_argument_type (ValadocApiAttributeArgument* self,
                                                  ValadocApiAttributeArgumentType value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_attribute_argument_get_argument_type (self) != value) {
		self->priv->_argument_type = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_ARGUMENT_TYPE_PROPERTY]);
	}
}


const gchar*
valadoc_api_attribute_argument_get_value (ValadocApiAttributeArgument* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_attribute_argument_set_value (ValadocApiAttributeArgument* self,
                                          const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_api_attribute_argument_get_value (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_VALUE_PROPERTY]);
	}
}


static void
valadoc_api_attribute_argument_class_init (ValadocApiAttributeArgumentClass * klass)
{
	valadoc_api_attribute_argument_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocApiAttributeArgumentPrivate));
	((ValadocApiItemClass *) klass)->build_signature = (ValadocContentInline* (*) (ValadocApiItem*)) valadoc_api_attribute_argument_real_build_signature;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_attribute_argument_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_attribute_argument_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_attribute_argument_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_ATTRIBUTE_ARGUMENT_NAME_PROPERTY, valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_ATTRIBUTE_ARGUMENT_ARGUMENT_TYPE_PROPERTY, valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_ARGUMENT_TYPE_PROPERTY] = g_param_spec_enum ("argument-type", "argument-type", "argument-type", VALADOC_API_ATTRIBUTE_ARGUMENT_TYPE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_ATTRIBUTE_ARGUMENT_VALUE_PROPERTY, valadoc_api_attribute_argument_properties[VALADOC_API_ATTRIBUTE_ARGUMENT_VALUE_PROPERTY] = g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_api_attribute_argument_instance_init (ValadocApiAttributeArgument * self)
{
	self->priv = VALADOC_API_ATTRIBUTE_ARGUMENT_GET_PRIVATE (self);
}


static void
valadoc_api_attribute_argument_finalize (GObject * obj)
{
	ValadocApiAttributeArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, ValadocApiAttributeArgument);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_value);
	G_OBJECT_CLASS (valadoc_api_attribute_argument_parent_class)->finalize (obj);
}


GType
valadoc_api_attribute_argument_get_type (void)
{
	static volatile gsize valadoc_api_attribute_argument_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_attribute_argument_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiAttributeArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_attribute_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiAttributeArgument), 0, (GInstanceInitFunc) valadoc_api_attribute_argument_instance_init, NULL };
		GType valadoc_api_attribute_argument_type_id;
		valadoc_api_attribute_argument_type_id = g_type_register_static (VALADOC_API_TYPE_ITEM, "ValadocApiAttributeArgument", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_api_attribute_argument_type_id__volatile, valadoc_api_attribute_argument_type_id);
	}
	return valadoc_api_attribute_argument_type_id__volatile;
}


static void
_vala_valadoc_api_attribute_argument_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	ValadocApiAttributeArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, ValadocApiAttributeArgument);
	switch (property_id) {
		case VALADOC_API_ATTRIBUTE_ARGUMENT_NAME_PROPERTY:
		g_value_set_string (value, valadoc_api_attribute_argument_get_name (self));
		break;
		case VALADOC_API_ATTRIBUTE_ARGUMENT_ARGUMENT_TYPE_PROPERTY:
		g_value_set_enum (value, valadoc_api_attribute_argument_get_argument_type (self));
		break;
		case VALADOC_API_ATTRIBUTE_ARGUMENT_VALUE_PROPERTY:
		g_value_set_string (value, valadoc_api_attribute_argument_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_api_attribute_argument_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	ValadocApiAttributeArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_ATTRIBUTE_ARGUMENT, ValadocApiAttributeArgument);
	switch (property_id) {
		case VALADOC_API_ATTRIBUTE_ARGUMENT_NAME_PROPERTY:
		valadoc_api_attribute_argument_set_name (self, g_value_get_string (value));
		break;
		case VALADOC_API_ATTRIBUTE_ARGUMENT_ARGUMENT_TYPE_PROPERTY:
		valadoc_api_attribute_argument_set_argument_type (self, g_value_get_enum (value));
		break;
		case VALADOC_API_ATTRIBUTE_ARGUMENT_VALUE_PROPERTY:
		valadoc_api_attribute_argument_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



