/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean lock_used;
};


static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base,
                                    gboolean used);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);


/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}


ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}


static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}


static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}


static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaField*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean used)
{
	ValaField * self;
	self = (ValaField*) base;
	self->priv->lock_used = used;
}


static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaSemanticAnalyzer* _tmp30_;
	ValaSemanticAnalyzer* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp44_;
	ValaDataType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	ValaArrayType* _tmp49_;
	ValaExpression* _tmp61_;
	ValaExpression* _tmp62_;
	gboolean _tmp187_ = FALSE;
	ValaMemberBinding _tmp188_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp193_;
	ValaSymbol* _tmp194_;
	gboolean _tmp203_ = FALSE;
	gboolean _tmp204_ = FALSE;
	gboolean _tmp205_;
	gboolean _tmp206_;
	ValaSemanticAnalyzer* _tmp221_;
	ValaSemanticAnalyzer* _tmp222_;
	ValaSourceFile* _tmp223_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSymbol* _tmp226_;
	gboolean _tmp227_;
	gboolean _tmp228_;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	vala_code_node_check ((ValaCodeNode*) _tmp29_, context);
	_tmp30_ = vala_code_context_get_analyzer (context);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp33_ = _tmp32_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp31_, (ValaSymbol*) self, _tmp33_)) {
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("field type `%s` is less accessible than field `%s`", _tmp39_, _tmp41_);
		_tmp43_ = _tmp42_;
		vala_report_error (_tmp35_, _tmp43_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp44_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp45_ = _tmp44_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp45_) ? ((ValaArrayType*) _tmp45_) : NULL;
	_tmp49_ = variable_array_type;
	if (_tmp49_ != NULL) {
		ValaArrayType* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp50_ = variable_array_type;
		_tmp51_ = vala_array_type_get_fixed_length (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp47_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp54_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaInitializerList* _tmp57_;
		ValaInitializerList* _tmp58_;
		_tmp55_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp58_ = _tmp57_;
		_tmp46_ = _tmp58_ == NULL;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp60_ = _tmp59_;
		vala_report_warning (_tmp60_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp67_;
		ValaExpression* _tmp68_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaExpression* _tmp75_;
		ValaExpression* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaExpression* _tmp81_;
		ValaExpression* _tmp82_;
		ValaDataType* _tmp83_;
		ValaDataType* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaArrayType* _tmp104_;
		gboolean _tmp120_ = FALSE;
		gboolean _tmp121_ = FALSE;
		ValaArrayType* _tmp122_;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		gboolean _tmp145_ = FALSE;
		ValaSymbol* _tmp146_;
		ValaSymbol* _tmp147_;
		gboolean _tmp152_ = FALSE;
		gboolean _tmp153_ = FALSE;
		ValaSymbol* _tmp154_;
		ValaSymbol* _tmp155_;
		gboolean _tmp169_ = FALSE;
		gboolean _tmp170_ = FALSE;
		gboolean _tmp171_ = FALSE;
		ValaMemberBinding _tmp172_;
		gboolean _tmp183_;
		gboolean _tmp184_;
		_tmp63_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		vala_expression_set_target_type (_tmp64_, _tmp66_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		if (VALA_IS_INITIALIZER_LIST (_tmp68_)) {
			ValaExpression* _tmp69_;
			ValaExpression* _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp72_ = _tmp71_;
			initializer_size = _tmp72_;
			is_initializer_list = TRUE;
		}
		_tmp73_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp74_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp75_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_expression_get_value_type (_tmp76_);
		_tmp78_ = _tmp77_;
		if (_tmp78_ == NULL) {
			ValaSourceReference* _tmp79_;
			ValaSourceReference* _tmp80_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp80_ = _tmp79_;
			vala_report_error (_tmp80_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp81_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_expression_get_value_type (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp86_ = _tmp85_;
		if (!vala_data_type_compatible (_tmp84_, _tmp86_)) {
			ValaSourceReference* _tmp87_;
			ValaSourceReference* _tmp88_;
			ValaExpression* _tmp89_;
			ValaExpression* _tmp90_;
			ValaDataType* _tmp91_;
			ValaDataType* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			ValaDataType* _tmp95_;
			ValaDataType* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_expression_get_value_type (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_code_node_to_string ((ValaCodeNode*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_code_node_to_string ((ValaCodeNode*) _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp94_, _tmp98_);
			_tmp100_ = _tmp99_;
			vala_report_error (_tmp88_, _tmp100_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
			_g_free0 (_tmp94_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp104_ = variable_array_type;
		if (_tmp104_ != NULL) {
			ValaArrayType* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = variable_array_type;
			_tmp106_ = vala_array_type_get_inline_allocated (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaArrayType* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			_tmp108_ = variable_array_type;
			_tmp109_ = vala_array_type_get_fixed_length (_tmp108_);
			_tmp110_ = _tmp109_;
			_tmp102_ = !_tmp110_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			gboolean _tmp111_;
			_tmp111_ = is_initializer_list;
			_tmp101_ = _tmp111_;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaArrayType* _tmp112_;
			gint _tmp113_;
			gchar* _tmp114_;
			gchar* _tmp115_;
			ValaIntegerLiteral* _tmp116_;
			ValaIntegerLiteral* _tmp117_;
			ValaArrayType* _tmp118_;
			ValaArrayType* _tmp119_;
			_tmp112_ = variable_array_type;
			_tmp113_ = initializer_size;
			_tmp114_ = g_strdup_printf ("%i", _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_integer_literal_new (_tmp115_, NULL);
			_tmp117_ = _tmp116_;
			vala_array_type_set_length (_tmp112_, (ValaExpression*) _tmp117_);
			_vala_code_node_unref0 (_tmp117_);
			_g_free0 (_tmp115_);
			_tmp118_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp118_, TRUE);
			_tmp119_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp119_, FALSE);
		}
		_tmp122_ = variable_array_type;
		if (_tmp122_ != NULL) {
			ValaArrayType* _tmp123_;
			gboolean _tmp124_;
			gboolean _tmp125_;
			_tmp123_ = variable_array_type;
			_tmp124_ = vala_array_type_get_inline_allocated (_tmp123_);
			_tmp125_ = _tmp124_;
			_tmp121_ = _tmp125_;
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			ValaExpression* _tmp126_;
			ValaExpression* _tmp127_;
			ValaDataType* _tmp128_;
			ValaDataType* _tmp129_;
			_tmp126_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_expression_get_value_type (_tmp127_);
			_tmp129_ = _tmp128_;
			_tmp120_ = !VALA_IS_ARRAY_TYPE (_tmp129_);
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			vala_report_error (_tmp131_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp132_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		if (vala_data_type_is_disposable (_tmp135_)) {
			gboolean _tmp136_ = FALSE;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			_tmp137_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp138_ = _tmp137_;
			if (!VALA_IS_POINTER_TYPE (_tmp138_)) {
				ValaDataType* _tmp139_;
				ValaDataType* _tmp140_;
				gboolean _tmp141_;
				gboolean _tmp142_;
				_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_data_type_get_value_owned (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp136_ = !_tmp142_;
			} else {
				_tmp136_ = FALSE;
			}
			if (_tmp136_) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				vala_report_error (_tmp144_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp146_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp147_ = _tmp146_;
		if (VALA_IS_NAMESPACE (_tmp147_)) {
			ValaExpression* _tmp148_;
			ValaExpression* _tmp149_;
			_tmp148_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp149_ = _tmp148_;
			_tmp145_ = !vala_expression_is_constant (_tmp149_);
		} else {
			_tmp145_ = FALSE;
		}
		if (_tmp145_) {
			ValaSourceReference* _tmp150_;
			ValaSourceReference* _tmp151_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp151_ = _tmp150_;
			vala_report_error (_tmp151_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp154_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp155_ = _tmp154_;
		if (VALA_IS_NAMESPACE (_tmp155_)) {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			_tmp156_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp157_ = _tmp156_;
			_tmp153_ = vala_expression_is_constant (_tmp157_);
		} else {
			_tmp153_ = FALSE;
		}
		if (_tmp153_) {
			ValaExpression* _tmp158_;
			ValaExpression* _tmp159_;
			_tmp158_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp159_ = _tmp158_;
			_tmp152_ = vala_expression_is_non_null (_tmp159_);
		} else {
			_tmp152_ = FALSE;
		}
		if (_tmp152_) {
			gboolean _tmp160_ = FALSE;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			_tmp161_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp162_ = _tmp161_;
			if (vala_data_type_is_disposable (_tmp162_)) {
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				gboolean _tmp165_;
				gboolean _tmp166_;
				_tmp163_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_data_type_get_value_owned (_tmp164_);
				_tmp166_ = _tmp165_;
				_tmp160_ = _tmp166_;
			} else {
				_tmp160_ = FALSE;
			}
			if (_tmp160_) {
				ValaSourceReference* _tmp167_;
				ValaSourceReference* _tmp168_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp168_ = _tmp167_;
				vala_report_error (_tmp168_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp172_ = self->priv->_binding;
		if (_tmp172_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp173_;
			ValaSymbol* _tmp174_;
			_tmp173_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp174_ = _tmp173_;
			_tmp171_ = VALA_IS_CLASS (_tmp174_);
		} else {
			_tmp171_ = FALSE;
		}
		if (_tmp171_) {
			ValaSymbol* _tmp175_;
			ValaSymbol* _tmp176_;
			gboolean _tmp177_;
			gboolean _tmp178_;
			_tmp175_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp176_, VALA_TYPE_CLASS, ValaClass));
			_tmp178_ = _tmp177_;
			_tmp170_ = _tmp178_;
		} else {
			_tmp170_ = FALSE;
		}
		if (_tmp170_) {
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			_tmp179_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp180_ = _tmp179_;
			_tmp169_ = !vala_expression_is_constant (_tmp180_);
		} else {
			_tmp169_ = FALSE;
		}
		if (_tmp169_) {
			ValaSourceReference* _tmp181_;
			ValaSourceReference* _tmp182_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp182_ = _tmp181_;
			vala_report_error (_tmp182_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp183_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp184_ = _tmp183_;
		if (_tmp184_) {
			ValaSourceReference* _tmp185_;
			ValaSourceReference* _tmp186_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp186_ = _tmp185_;
			vala_report_error (_tmp186_, "External fields cannot use initializers");
		}
	}
	_tmp188_ = self->priv->_binding;
	if (_tmp188_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp189_;
		ValaSymbol* _tmp190_;
		_tmp189_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp190_ = _tmp189_;
		_tmp187_ = VALA_IS_INTERFACE (_tmp190_);
	} else {
		_tmp187_ = FALSE;
	}
	if (_tmp187_) {
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp192_ = _tmp191_;
		vala_report_error (_tmp192_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp194_ = _tmp193_;
	if (VALA_IS_CLASS (_tmp194_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp195_;
		ValaSymbol* _tmp196_;
		ValaClass* _tmp197_;
		gboolean _tmp198_ = FALSE;
		ValaClass* _tmp199_;
		gboolean _tmp200_;
		gboolean _tmp201_;
		_tmp195_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp196_ = _tmp195_;
		_tmp197_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp196_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp197_;
		_tmp199_ = cl;
		_tmp200_ = vala_class_get_is_compact (_tmp199_);
		_tmp201_ = _tmp200_;
		if (_tmp201_) {
			ValaClass* _tmp202_;
			_tmp202_ = cl;
			_tmp198_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp202_);
		} else {
			_tmp198_ = FALSE;
		}
		if (_tmp198_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp205_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp206_ = _tmp205_;
	if (!_tmp206_) {
		gboolean _tmp207_;
		gboolean _tmp208_;
		_tmp207_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp208_ = _tmp207_;
		_tmp204_ = !_tmp208_;
	} else {
		_tmp204_ = FALSE;
	}
	if (_tmp204_) {
		ValaSymbol* _tmp209_;
		ValaSymbol* _tmp210_;
		_tmp209_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp210_ = _tmp209_;
		_tmp203_ = _tmp210_ != NULL;
		_vala_code_node_unref0 (_tmp210_);
	} else {
		_tmp203_ = FALSE;
	}
	if (_tmp203_) {
		ValaSourceReference* _tmp211_;
		ValaSourceReference* _tmp212_;
		gchar* _tmp213_;
		gchar* _tmp214_;
		ValaSymbol* _tmp215_;
		ValaSymbol* _tmp216_;
		gchar* _tmp217_;
		gchar* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp214_ = _tmp213_;
		_tmp215_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp216_ = _tmp215_;
		_tmp217_ = vala_symbol_get_full_name (_tmp216_);
		_tmp218_ = _tmp217_;
		_tmp219_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp214_, _tmp218_);
		_tmp220_ = _tmp219_;
		vala_report_warning (_tmp212_, _tmp220_);
		_g_free0 (_tmp220_);
		_g_free0 (_tmp218_);
		_vala_code_node_unref0 (_tmp216_);
		_g_free0 (_tmp214_);
	}
	_tmp221_ = vala_code_context_get_analyzer (context);
	_tmp222_ = _tmp221_;
	_tmp223_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp222_, _tmp223_);
	_tmp224_ = vala_code_context_get_analyzer (context);
	_tmp225_ = _tmp224_;
	_tmp226_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp225_, _tmp226_);
	_tmp227_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp228_ = _tmp227_;
	result = !_tmp228_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_volatile;
	result = _tmp0_;
	return result;
}


void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}


static void
vala_field_class_init (ValaFieldClass * klass)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}


static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable*)) vala_field_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable*, gboolean)) vala_field_real_set_lock_used;
}


static void
vala_field_instance_init (ValaField * self)
{
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}



