/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};


static gpointer vala_local_variable_parent_class = NULL;

#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);


/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	ValaArrayType* _tmp80_;
	gboolean _tmp92_ = FALSE;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaSemanticAnalyzer* _tmp212_;
	ValaSemanticAnalyzer* _tmp213_;
	ValaSymbol* _tmp214_;
	ValaSymbol* _tmp215_;
	ValaScope* _tmp216_;
	ValaScope* _tmp217_;
	const gchar* _tmp218_;
	const gchar* _tmp219_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp220_;
	ValaSemanticAnalyzer* _tmp221_;
	ValaSymbol* _tmp222_;
	ValaSymbol* _tmp223_;
	ValaBlock* _tmp224_;
	ValaBlock* _tmp225_;
	gboolean _tmp227_;
	gboolean _tmp228_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_VOID_TYPE (_tmp7_)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp12_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp14_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_expression_set_target_type (_tmp15_, _tmp17_);
		_tmp18_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp19_ = _tmp18_;
		if (VALA_IS_INITIALIZER_LIST (_tmp19_)) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp20_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp23_ = _tmp22_;
			initializer_size = _tmp23_;
			is_initializer_list = TRUE;
		}
		_tmp24_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		gboolean _tmp38_ = FALSE;
		ValaExpression* _tmp39_;
		ValaExpression* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		ValaDataType* _tmp73_;
		ValaDataType* _tmp74_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			vala_report_error (_tmp31_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_expression_get_value_type (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			ValaSourceReference* _tmp36_;
			ValaSourceReference* _tmp37_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp37_ = _tmp36_;
			vala_report_error (_tmp37_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp39_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_expression_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp42_)) {
			_tmp38_ = TRUE;
		} else {
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp43_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp38_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp46_);
		}
		if (_tmp38_) {
			ValaExpression* _tmp47_;
			ValaExpression* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			ValaExpression* _tmp51_;
			ValaExpression* _tmp52_;
			ValaSymbol* _tmp53_;
			ValaSymbol* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp47_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_expression_get_symbol_reference (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_symbol_get_full_name (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp56_);
			_tmp58_ = _tmp57_;
			vala_report_error (_tmp50_, _tmp58_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			result = FALSE;
			return result;
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_expression_get_value_type (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_data_type_copy (_tmp62_);
		_tmp64_ = _tmp63_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp64_);
		_vala_code_node_unref0 (_tmp64_);
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		vala_data_type_set_floating_reference (_tmp68_, FALSE);
		_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		vala_expression_set_target_type (_tmp70_, _tmp72_);
		_tmp73_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		vala_code_node_check ((ValaCodeNode*) _tmp74_, context);
	}
	_tmp75_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp76_ = _tmp75_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp76_) ? ((ValaArrayType*) _tmp76_) : NULL;
	_tmp80_ = variable_array_type;
	if (_tmp80_ != NULL) {
		ValaArrayType* _tmp81_;
		gboolean _tmp82_;
		gboolean _tmp83_;
		_tmp81_ = variable_array_type;
		_tmp82_ = vala_array_type_get_fixed_length (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp79_ = _tmp83_;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		ValaExpression* _tmp84_;
		ValaExpression* _tmp85_;
		_tmp84_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp85_ = _tmp84_;
		_tmp78_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp85_);
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaInitializerList* _tmp88_;
		ValaInitializerList* _tmp89_;
		_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp89_ = _tmp88_;
		_tmp77_ = _tmp89_ == NULL;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		ValaSourceReference* _tmp90_;
		ValaSourceReference* _tmp91_;
		_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp91_ = _tmp90_;
		vala_report_warning (_tmp91_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp93_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaExpression* _tmp95_;
		ValaExpression* _tmp96_;
		gboolean _tmp97_;
		gboolean _tmp98_;
		_tmp95_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_code_node_get_error ((ValaCodeNode*) _tmp96_);
		_tmp98_ = _tmp97_;
		_tmp92_ = !_tmp98_;
	} else {
		_tmp92_ = FALSE;
	}
	if (_tmp92_) {
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		ValaExpression* _tmp148_;
		ValaExpression* _tmp149_;
		ValaDataType* _tmp150_;
		ValaDataType* _tmp151_;
		ValaDataType* _tmp152_;
		ValaDataType* _tmp153_;
		gboolean _tmp168_ = FALSE;
		gboolean _tmp169_ = FALSE;
		gboolean _tmp170_ = FALSE;
		ValaArrayType* _tmp171_;
		gboolean _tmp187_ = FALSE;
		gboolean _tmp188_ = FALSE;
		ValaArrayType* _tmp189_;
		ValaExpression* _tmp199_;
		ValaExpression* _tmp200_;
		ValaDataType* _tmp201_;
		ValaDataType* _tmp202_;
		_tmp99_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_expression_get_value_type (_tmp100_);
		_tmp102_ = _tmp101_;
		if (_tmp102_ == NULL) {
			gboolean _tmp103_ = FALSE;
			ValaExpression* _tmp104_;
			ValaExpression* _tmp105_;
			gboolean _tmp110_ = FALSE;
			ValaExpression* _tmp111_;
			ValaExpression* _tmp112_;
			ValaSymbol* _tmp113_;
			ValaSymbol* _tmp114_;
			_tmp104_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp105_ = _tmp104_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp105_)) {
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp106_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp107_ = _tmp106_;
				_tmp103_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp107_);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSourceReference* _tmp108_;
				ValaSourceReference* _tmp109_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp109_ = _tmp108_;
				vala_report_error (_tmp109_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_expression_get_symbol_reference (_tmp112_);
			_tmp114_ = _tmp113_;
			if (VALA_IS_METHOD (_tmp114_)) {
				ValaDataType* _tmp115_;
				ValaDataType* _tmp116_;
				_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp116_ = _tmp115_;
				_tmp110_ = VALA_IS_DELEGATE_TYPE (_tmp116_);
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp117_;
				ValaExpression* _tmp118_;
				ValaSymbol* _tmp119_;
				ValaSymbol* _tmp120_;
				ValaMethod* _tmp121_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp122_;
				ValaDataType* _tmp123_;
				ValaDelegateType* _tmp124_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp125_;
				ValaDelegate* _tmp126_;
				ValaDelegate* _tmp127_;
				ValaDelegate* _tmp128_;
				ValaDelegate* _tmp129_;
				ValaMethod* _tmp130_;
				ValaDelegateType* _tmp131_;
				ValaExpression* _tmp142_;
				ValaExpression* _tmp143_;
				ValaDataType* _tmp144_;
				ValaDataType* _tmp145_;
				_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_expression_get_symbol_reference (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp121_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp121_;
				_tmp122_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp123_ = _tmp122_;
				_tmp124_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp124_;
				_tmp125_ = dt;
				_tmp126_ = vala_delegate_type_get_delegate_symbol (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = _vala_code_node_ref0 (_tmp127_);
				cb = _tmp128_;
				_tmp129_ = cb;
				_tmp130_ = m;
				_tmp131_ = dt;
				if (!vala_delegate_matches_method (_tmp129_, _tmp130_, (ValaDataType*) _tmp131_)) {
					ValaSourceReference* _tmp132_;
					ValaSourceReference* _tmp133_;
					ValaMethod* _tmp134_;
					gchar* _tmp135_;
					gchar* _tmp136_;
					ValaDelegate* _tmp137_;
					gchar* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp133_ = _tmp132_;
					_tmp134_ = m;
					_tmp135_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp134_);
					_tmp136_ = _tmp135_;
					_tmp137_ = cb;
					_tmp138_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp136_, _tmp139_);
					_tmp141_ = _tmp140_;
					vala_report_error (_tmp133_, _tmp141_);
					_g_free0 (_tmp141_);
					_g_free0 (_tmp139_);
					_g_free0 (_tmp136_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp142_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp143_ = _tmp142_;
				_tmp144_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp145_ = _tmp144_;
				vala_expression_set_value_type (_tmp143_, _tmp145_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp146_;
				ValaSourceReference* _tmp147_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp147_ = _tmp146_;
				vala_report_error (_tmp147_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp148_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_expression_get_value_type (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp153_ = _tmp152_;
		if (!vala_data_type_compatible (_tmp151_, _tmp153_)) {
			ValaSourceReference* _tmp154_;
			ValaSourceReference* _tmp155_;
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			gchar* _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
			gchar* _tmp167_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_value_type (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_code_node_to_string ((ValaCodeNode*) _tmp159_);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_code_node_to_string ((ValaCodeNode*) _tmp163_);
			_tmp165_ = _tmp164_;
			_tmp166_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp161_, _tmp165_);
			_tmp167_ = _tmp166_;
			vala_report_error (_tmp155_, _tmp167_);
			_g_free0 (_tmp167_);
			_g_free0 (_tmp165_);
			_g_free0 (_tmp161_);
			result = FALSE;
			return result;
		}
		_tmp171_ = variable_array_type;
		if (_tmp171_ != NULL) {
			ValaArrayType* _tmp172_;
			gboolean _tmp173_;
			gboolean _tmp174_;
			_tmp172_ = variable_array_type;
			_tmp173_ = vala_array_type_get_inline_allocated (_tmp172_);
			_tmp174_ = _tmp173_;
			_tmp170_ = _tmp174_;
		} else {
			_tmp170_ = FALSE;
		}
		if (_tmp170_) {
			ValaArrayType* _tmp175_;
			gboolean _tmp176_;
			gboolean _tmp177_;
			_tmp175_ = variable_array_type;
			_tmp176_ = vala_array_type_get_fixed_length (_tmp175_);
			_tmp177_ = _tmp176_;
			_tmp169_ = !_tmp177_;
		} else {
			_tmp169_ = FALSE;
		}
		if (_tmp169_) {
			gboolean _tmp178_;
			_tmp178_ = is_initializer_list;
			_tmp168_ = _tmp178_;
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaArrayType* _tmp179_;
			gint _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			ValaIntegerLiteral* _tmp183_;
			ValaIntegerLiteral* _tmp184_;
			ValaArrayType* _tmp185_;
			ValaArrayType* _tmp186_;
			_tmp179_ = variable_array_type;
			_tmp180_ = initializer_size;
			_tmp181_ = g_strdup_printf ("%i", _tmp180_);
			_tmp182_ = _tmp181_;
			_tmp183_ = vala_integer_literal_new (_tmp182_, NULL);
			_tmp184_ = _tmp183_;
			vala_array_type_set_length (_tmp179_, (ValaExpression*) _tmp184_);
			_vala_code_node_unref0 (_tmp184_);
			_g_free0 (_tmp182_);
			_tmp185_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp185_, TRUE);
			_tmp186_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp186_, FALSE);
		}
		_tmp189_ = variable_array_type;
		if (_tmp189_ != NULL) {
			ValaArrayType* _tmp190_;
			gboolean _tmp191_;
			gboolean _tmp192_;
			_tmp190_ = variable_array_type;
			_tmp191_ = vala_array_type_get_inline_allocated (_tmp190_);
			_tmp192_ = _tmp191_;
			_tmp188_ = _tmp192_;
		} else {
			_tmp188_ = FALSE;
		}
		if (_tmp188_) {
			ValaExpression* _tmp193_;
			ValaExpression* _tmp194_;
			ValaDataType* _tmp195_;
			ValaDataType* _tmp196_;
			_tmp193_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_expression_get_value_type (_tmp194_);
			_tmp196_ = _tmp195_;
			_tmp187_ = VALA_IS_ARRAY_TYPE (_tmp196_) == FALSE;
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			ValaSourceReference* _tmp197_;
			ValaSourceReference* _tmp198_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp198_ = _tmp197_;
			vala_report_error (_tmp198_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp199_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_expression_get_value_type (_tmp200_);
		_tmp202_ = _tmp201_;
		if (vala_data_type_is_disposable (_tmp202_)) {
			gboolean _tmp203_ = FALSE;
			ValaDataType* _tmp204_;
			ValaDataType* _tmp205_;
			_tmp204_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp205_ = _tmp204_;
			if (!VALA_IS_POINTER_TYPE (_tmp205_)) {
				ValaDataType* _tmp206_;
				ValaDataType* _tmp207_;
				gboolean _tmp208_;
				gboolean _tmp209_;
				_tmp206_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp207_ = _tmp206_;
				_tmp208_ = vala_data_type_get_value_owned (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp203_ = !_tmp209_;
			} else {
				_tmp203_ = FALSE;
			}
			if (_tmp203_) {
				ValaSourceReference* _tmp210_;
				ValaSourceReference* _tmp211_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp211_ = _tmp210_;
				vala_report_error (_tmp211_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp212_ = vala_code_context_get_analyzer (context);
	_tmp213_ = _tmp212_;
	_tmp214_ = vala_semantic_analyzer_get_current_symbol (_tmp213_);
	_tmp215_ = _tmp214_;
	_tmp216_ = vala_symbol_get_scope (_tmp215_);
	_tmp217_ = _tmp216_;
	_tmp218_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp219_ = _tmp218_;
	vala_scope_add (_tmp217_, _tmp219_, (ValaSymbol*) self);
	_tmp220_ = vala_code_context_get_analyzer (context);
	_tmp221_ = _tmp220_;
	_tmp222_ = vala_semantic_analyzer_get_current_symbol (_tmp221_);
	_tmp223_ = _tmp222_;
	_tmp224_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp223_) ? ((ValaBlock*) _tmp223_) : NULL);
	block = _tmp224_;
	_tmp225_ = block;
	if (_tmp225_ != NULL) {
		ValaBlock* _tmp226_;
		_tmp226_ = block;
		vala_block_add_local_variable (_tmp226_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp227_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp228_ = _tmp227_;
	result = !_tmp228_;
	_vala_code_node_unref0 (block);
	return result;
}


gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_result;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}


static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}


static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}



