/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static const gchar* vala_assignment_get_operator_string (ValaAssignment* self);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}


ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}


static const gchar*
vala_assignment_get_operator_string (ValaAssignment* self)
{
	const gchar* result = NULL;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaExpression* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_assignment_get_operator_string (self);
	_tmp4_ = self->priv->_right;
	_tmp5_ = vala_code_node_to_string ((ValaCodeNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp3_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	result = _tmp8_;
	return result;
}


static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}


static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp99_;
	ValaExpression* _tmp100_;
	ValaExpression* _tmp101_;
	ValaExpression* _tmp310_;
	ValaExpression* _tmp311_;
	gboolean _tmp312_ = FALSE;
	ValaAssignmentOperator _tmp313_;
	ValaExpression* _tmp368_;
	ValaExpression* _tmp369_;
	ValaSymbol* _tmp370_;
	ValaSymbol* _tmp371_;
	ValaExpression* _tmp862_;
	ValaExpression* _tmp863_;
	ValaDataType* _tmp864_;
	ValaDataType* _tmp865_;
	ValaExpression* _tmp874_;
	ValaExpression* _tmp875_;
	ValaList* _tmp876_;
	ValaList* _tmp877_;
	ValaExpression* _tmp878_;
	ValaExpression* _tmp879_;
	ValaList* _tmp880_;
	ValaList* _tmp881_;
	gboolean _tmp882_;
	gboolean _tmp883_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaBlock* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp85_;
		ValaSemanticAnalyzer* _tmp86_;
		ValaList* _tmp87_;
		ValaCodeNode* _tmp88_;
		ValaCodeNode* _tmp89_;
		ValaExpressionStatement* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		ValaExpressionStatement* _tmp93_;
		ValaExpression* _tmp94_;
		ValaExpression* _tmp95_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->insert_block;
		_tmp31_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp30_, (ValaStatement*) _tmp31_);
		_tmp32_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp32_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				ValaExpression* expr = NULL;
				ValaList* _tmp41_;
				gint _tmp42_;
				gpointer _tmp43_;
				ValaExpressionStatement* _tmp44_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaMemberAccess* _tmp57_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp58_;
				ValaExpression* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaElementAccess* _tmp62_;
				ValaElementAccess* _tmp63_;
				gint _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				ValaExpression* _tmp67_;
				ValaSourceReference* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaIntegerLiteral* _tmp70_;
				ValaIntegerLiteral* _tmp71_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp72_;
				ValaElementAccess* _tmp73_;
				ValaAssignmentOperator _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaAssignment* _tmp78_;
				ValaAssignment* _tmp79_;
				ValaExpression* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaExpressionStatement* _tmp83_;
				gint _tmp84_;
				_tmp38_ = _expr_index;
				_expr_index = _tmp38_ + 1;
				_tmp39_ = _expr_index;
				_tmp40_ = _expr_size;
				if (!(_tmp39_ < _tmp40_)) {
					break;
				}
				_tmp41_ = _expr_list;
				_tmp42_ = _expr_index;
				_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
				expr = (ValaExpression*) _tmp43_;
				_tmp44_ = stmt;
				if (_tmp44_ != NULL) {
					ValaSemanticAnalyzer* _tmp45_;
					ValaSemanticAnalyzer* _tmp46_;
					ValaBlock* _tmp47_;
					ValaExpressionStatement* _tmp48_;
					ValaExpressionStatement* _tmp49_;
					_tmp45_ = vala_code_context_get_analyzer (context);
					_tmp46_ = _tmp45_;
					_tmp47_ = _tmp46_->insert_block;
					_tmp48_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp47_, (ValaStatement*) _tmp48_);
					_tmp49_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp49_, context);
				}
				_tmp50_ = local;
				_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
				temp_access = _tmp57_;
				_tmp58_ = temp_access;
				_tmp59_ = expr;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_element_access_new ((ValaExpression*) _tmp58_, _tmp61_);
				ea = _tmp62_;
				_tmp63_ = ea;
				_tmp64_ = i;
				_tmp65_ = g_strdup_printf ("%i", _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = expr;
				_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_integer_literal_new (_tmp66_, _tmp69_);
				_tmp71_ = _tmp70_;
				vala_element_access_append_index (_tmp63_, (ValaExpression*) _tmp71_);
				_vala_code_node_unref0 (_tmp71_);
				_g_free0 (_tmp66_);
				_tmp72_ = expr;
				_tmp73_ = ea;
				_tmp74_ = self->priv->_operator;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_assignment_new (_tmp72_, (ValaExpression*) _tmp73_, _tmp74_, _tmp77_);
				assign = _tmp78_;
				_tmp79_ = assign;
				_tmp80_ = expr;
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = vala_expression_statement_new ((ValaExpression*) _tmp79_, _tmp82_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp83_;
				_tmp84_ = i;
				i = _tmp84_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp85_ = vala_code_context_get_analyzer (context);
		_tmp86_ = _tmp85_;
		_tmp87_ = _tmp86_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp87_, (ValaCodeNode*) self);
		_tmp88_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = stmt;
		_tmp91_ = vala_expression_statement_get_expression (_tmp90_);
		_tmp92_ = _tmp91_;
		vala_code_node_replace_expression (_tmp89_, (ValaExpression*) self, _tmp92_);
		_tmp93_ = stmt;
		_tmp94_ = vala_expression_statement_get_expression (_tmp93_);
		_tmp95_ = _tmp94_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp96_ = vala_assignment_get_left (self);
	_tmp97_ = _tmp96_;
	vala_expression_set_lvalue (_tmp97_, TRUE);
	_tmp98_ = vala_assignment_get_left (self);
	_tmp99_ = _tmp98_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp99_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp100_ = vala_assignment_get_left (self);
	_tmp101_ = _tmp100_;
	if (VALA_IS_MEMBER_ACCESS (_tmp101_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp102_;
		ValaExpression* _tmp103_;
		ValaMemberAccess* _tmp104_;
		ValaMemberAccess* _tmp105_;
		ValaSymbol* _tmp106_;
		ValaSymbol* _tmp107_;
		gboolean _tmp110_ = FALSE;
		gboolean _tmp111_ = FALSE;
		gboolean _tmp112_ = FALSE;
		ValaMemberAccess* _tmp113_;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaMemberAccess* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp146_ = FALSE;
		ValaMemberAccess* _tmp147_;
		gboolean _tmp148_;
		gboolean _tmp149_;
		ValaMemberAccess* _tmp153_;
		ValaSymbol* _tmp154_;
		ValaSymbol* _tmp155_;
		_tmp102_ = vala_assignment_get_left (self);
		_tmp103_ = _tmp102_;
		_tmp104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp104_;
		_tmp105_ = ma;
		_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp105_);
		_tmp107_ = _tmp106_;
		if (VALA_IS_CONSTANT (_tmp107_)) {
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp109_ = _tmp108_;
			vala_report_error (_tmp109_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp113_ = ma;
		_tmp114_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp113_);
		_tmp115_ = _tmp114_;
		if (VALA_IS_SIGNAL (_tmp115_)) {
			_tmp112_ = TRUE;
		} else {
			ValaMemberAccess* _tmp116_;
			ValaSymbol* _tmp117_;
			ValaSymbol* _tmp118_;
			_tmp116_ = ma;
			_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp116_);
			_tmp118_ = _tmp117_;
			_tmp112_ = VALA_IS_DYNAMIC_PROPERTY (_tmp118_);
		}
		if (!_tmp112_) {
			ValaMemberAccess* _tmp119_;
			ValaDataType* _tmp120_;
			ValaDataType* _tmp121_;
			_tmp119_ = ma;
			_tmp120_ = vala_expression_get_value_type ((ValaExpression*) _tmp119_);
			_tmp121_ = _tmp120_;
			_tmp111_ = _tmp121_ == NULL;
		} else {
			_tmp111_ = FALSE;
		}
		if (_tmp111_) {
			_tmp110_ = TRUE;
		} else {
			gboolean _tmp122_ = FALSE;
			gboolean _tmp123_ = FALSE;
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			if (_tmp126_ == NULL) {
				ValaMemberAccess* _tmp127_;
				const gchar* _tmp128_;
				const gchar* _tmp129_;
				_tmp127_ = ma;
				_tmp128_ = vala_member_access_get_member_name (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp123_ = g_strcmp0 (_tmp129_, "this") == 0;
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				ValaSemanticAnalyzer* _tmp130_;
				ValaSemanticAnalyzer* _tmp131_;
				_tmp130_ = vala_code_context_get_analyzer (context);
				_tmp131_ = _tmp130_;
				_tmp122_ = vala_semantic_analyzer_is_in_instance_method (_tmp131_);
			} else {
				_tmp122_ = FALSE;
			}
			_tmp110_ = _tmp122_;
		}
		if (_tmp110_) {
			ValaSourceReference* _tmp132_;
			ValaSourceReference* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp133_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp134_ = ma;
		_tmp135_ = vala_member_access_get_prototype_access (_tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			ValaMemberAccess* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaSymbol* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = ma;
			_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_symbol_get_full_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp143_);
			_tmp145_ = _tmp144_;
			vala_report_error (_tmp138_, _tmp145_);
			_g_free0 (_tmp145_);
			_g_free0 (_tmp143_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp147_ = ma;
		_tmp148_ = vala_code_node_get_error ((ValaCodeNode*) _tmp147_);
		_tmp149_ = _tmp148_;
		if (_tmp149_) {
			_tmp146_ = TRUE;
		} else {
			ValaMemberAccess* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbol* _tmp152_;
			_tmp150_ = ma;
			_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			_tmp146_ = _tmp152_ == NULL;
		}
		if (_tmp146_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp153_ = ma;
		_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp153_);
		_tmp155_ = _tmp154_;
		if (VALA_IS_DYNAMIC_SIGNAL (_tmp155_)) {
			gboolean _tmp156_;
			gboolean _tmp157_;
			_tmp156_ = vala_code_context_get_deprecated (context);
			_tmp157_ = _tmp156_;
			if (!_tmp157_) {
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				vala_report_warning (_tmp159_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp160_;
			ValaSymbol* _tmp161_;
			ValaSymbol* _tmp162_;
			_tmp160_ = ma;
			_tmp161_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp160_);
			_tmp162_ = _tmp161_;
			if (VALA_IS_SIGNAL (_tmp162_)) {
				gboolean _tmp163_;
				gboolean _tmp164_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSignal* _tmp170_;
				ValaExpression* _tmp171_;
				ValaExpression* _tmp172_;
				ValaSignal* _tmp173_;
				ValaMemberAccess* _tmp174_;
				ValaExpression* _tmp175_;
				ValaExpression* _tmp176_;
				ValaDataType* _tmp177_;
				ValaDataType* _tmp178_;
				ValaDelegate* _tmp179_;
				ValaDelegate* _tmp180_;
				ValaDelegateType* _tmp181_;
				ValaDelegateType* _tmp182_;
				_tmp163_ = vala_code_context_get_deprecated (context);
				_tmp164_ = _tmp163_;
				if (!_tmp164_) {
					ValaSourceReference* _tmp165_;
					ValaSourceReference* _tmp166_;
					_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp166_ = _tmp165_;
					vala_report_warning (_tmp166_, "deprecated syntax, use `connect' method instead");
				}
				_tmp167_ = ma;
				_tmp168_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp170_;
				_tmp171_ = vala_assignment_get_right (self);
				_tmp172_ = _tmp171_;
				_tmp173_ = sig;
				_tmp174_ = ma;
				_tmp175_ = vala_member_access_get_inner (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_expression_get_value_type (_tmp176_);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_signal_get_delegate (_tmp173_, _tmp178_, (ValaCodeNode*) self);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_delegate_type_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_expression_set_target_type (_tmp172_, (ValaDataType*) _tmp182_);
				_vala_code_node_unref0 (_tmp182_);
				_vala_code_node_unref0 (_tmp180_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp183_;
				ValaSymbol* _tmp184_;
				ValaSymbol* _tmp185_;
				_tmp183_ = ma;
				_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp183_);
				_tmp185_ = _tmp184_;
				if (VALA_IS_DYNAMIC_PROPERTY (_tmp185_)) {
				} else {
					ValaExpression* _tmp186_;
					ValaExpression* _tmp187_;
					ValaMemberAccess* _tmp188_;
					ValaDataType* _tmp189_;
					ValaDataType* _tmp190_;
					ValaDataType* _tmp191_;
					ValaDataType* _tmp192_;
					ValaExpression* _tmp193_;
					ValaExpression* _tmp194_;
					ValaMemberAccess* _tmp195_;
					ValaDataType* _tmp196_;
					ValaDataType* _tmp197_;
					ValaDataType* _tmp198_;
					ValaDataType* _tmp199_;
					_tmp186_ = vala_assignment_get_right (self);
					_tmp187_ = _tmp186_;
					_tmp188_ = ma;
					_tmp189_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_data_type_copy (_tmp190_);
					_tmp192_ = _tmp191_;
					vala_expression_set_formal_target_type (_tmp187_, _tmp192_);
					_vala_code_node_unref0 (_tmp192_);
					_tmp193_ = vala_assignment_get_right (self);
					_tmp194_ = _tmp193_;
					_tmp195_ = ma;
					_tmp196_ = vala_expression_get_value_type ((ValaExpression*) _tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_data_type_copy (_tmp197_);
					_tmp199_ = _tmp198_;
					vala_expression_set_target_type (_tmp194_, _tmp199_);
					_vala_code_node_unref0 (_tmp199_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp200_;
		ValaExpression* _tmp201_;
		_tmp200_ = vala_assignment_get_left (self);
		_tmp201_ = _tmp200_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp201_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp202_;
			ValaExpression* _tmp203_;
			ValaElementAccess* _tmp204_;
			ValaElementAccess* _tmp205_;
			ValaExpression* _tmp206_;
			ValaExpression* _tmp207_;
			ValaDataType* _tmp208_;
			ValaDataType* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			ValaTypeSymbol* _tmp211_;
			ValaSemanticAnalyzer* _tmp212_;
			ValaSemanticAnalyzer* _tmp213_;
			ValaDataType* _tmp214_;
			ValaTypeSymbol* _tmp215_;
			ValaTypeSymbol* _tmp216_;
			_tmp202_ = vala_assignment_get_left (self);
			_tmp203_ = _tmp202_;
			_tmp204_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp203_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp204_;
			_tmp205_ = ea;
			_tmp206_ = vala_element_access_get_container (_tmp205_);
			_tmp207_ = _tmp206_;
			_tmp208_ = vala_expression_get_value_type (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_data_type_get_data_type (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = vala_code_context_get_analyzer (context);
			_tmp213_ = _tmp212_;
			_tmp214_ = _tmp213_->string_type;
			_tmp215_ = vala_data_type_get_data_type (_tmp214_);
			_tmp216_ = _tmp215_;
			if (_tmp211_ == _tmp216_) {
				ValaElementAccess* _tmp217_;
				ValaSourceReference* _tmp218_;
				ValaSourceReference* _tmp219_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp217_ = ea;
				_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp217_);
				_tmp219_ = _tmp218_;
				vala_report_error (_tmp219_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp220_ = FALSE;
				ValaElementAccess* _tmp221_;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				_tmp221_ = ea;
				_tmp222_ = vala_element_access_get_container (_tmp221_);
				_tmp223_ = _tmp222_;
				if (VALA_IS_MEMBER_ACCESS (_tmp223_)) {
					ValaElementAccess* _tmp224_;
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaSymbol* _tmp227_;
					ValaSymbol* _tmp228_;
					_tmp224_ = ea;
					_tmp225_ = vala_element_access_get_container (_tmp224_);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_expression_get_symbol_reference (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp220_ = VALA_IS_SIGNAL (_tmp228_);
				} else {
					_tmp220_ = FALSE;
				}
				if (_tmp220_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp229_;
					ValaExpression* _tmp230_;
					ValaExpression* _tmp231_;
					ValaMemberAccess* _tmp232_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp233_;
					ValaExpression* _tmp234_;
					ValaExpression* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaSymbol* _tmp237_;
					ValaSignal* _tmp238_;
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSignal* _tmp241_;
					ValaMemberAccess* _tmp242_;
					ValaExpression* _tmp243_;
					ValaExpression* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaDelegate* _tmp247_;
					ValaDelegate* _tmp248_;
					ValaDelegateType* _tmp249_;
					ValaDelegateType* _tmp250_;
					_tmp229_ = ea;
					_tmp230_ = vala_element_access_get_container (_tmp229_);
					_tmp231_ = _tmp230_;
					_tmp232_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp231_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp232_;
					_tmp233_ = ea;
					_tmp234_ = vala_element_access_get_container (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_expression_get_symbol_reference (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp237_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp238_;
					_tmp239_ = vala_assignment_get_right (self);
					_tmp240_ = _tmp239_;
					_tmp241_ = sig;
					_tmp242_ = ma;
					_tmp243_ = vala_member_access_get_inner (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_expression_get_value_type (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_signal_get_delegate (_tmp241_, _tmp246_, (ValaCodeNode*) self);
					_tmp248_ = _tmp247_;
					_tmp249_ = vala_delegate_type_new (_tmp248_);
					_tmp250_ = _tmp249_;
					vala_expression_set_target_type (_tmp240_, (ValaDataType*) _tmp250_);
					_vala_code_node_unref0 (_tmp250_);
					_vala_code_node_unref0 (_tmp248_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp251_;
					ValaExpression* _tmp252_;
					ValaExpression* _tmp253_;
					ValaDataType* _tmp254_;
					ValaDataType* _tmp255_;
					ValaSymbol* _tmp256_;
					ValaSymbol* _tmp257_;
					gboolean _tmp258_;
					_tmp251_ = ea;
					_tmp252_ = vala_element_access_get_container (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_expression_get_value_type (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = vala_data_type_get_member (_tmp255_, "set");
					_tmp257_ = _tmp256_;
					_tmp258_ = VALA_IS_METHOD (_tmp257_);
					_vala_code_node_unref0 (_tmp257_);
					if (_tmp258_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp259_;
						ValaExpression* _tmp260_;
						ValaExpression* _tmp261_;
						ValaSourceReference* _tmp262_;
						ValaSourceReference* _tmp263_;
						ValaMemberAccess* _tmp264_;
						ValaMemberAccess* _tmp265_;
						ValaSourceReference* _tmp266_;
						ValaSourceReference* _tmp267_;
						ValaMethodCall* _tmp268_;
						ValaMethodCall* _tmp269_;
						ValaMethodCall* _tmp283_;
						ValaExpression* _tmp284_;
						ValaExpression* _tmp285_;
						ValaCodeNode* _tmp286_;
						ValaCodeNode* _tmp287_;
						ValaMethodCall* _tmp288_;
						ValaMethodCall* _tmp289_;
						_tmp259_ = ea;
						_tmp260_ = vala_element_access_get_container (_tmp259_);
						_tmp261_ = _tmp260_;
						_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp263_ = _tmp262_;
						_tmp264_ = vala_member_access_new (_tmp261_, "set", _tmp263_);
						_tmp265_ = _tmp264_;
						_tmp266_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp267_ = _tmp266_;
						_tmp268_ = vala_method_call_new ((ValaExpression*) _tmp265_, _tmp267_);
						_tmp269_ = _tmp268_;
						_vala_code_node_unref0 (_tmp265_);
						set_call = _tmp269_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp270_;
							ValaList* _tmp271_;
							gint _e_size = 0;
							ValaList* _tmp272_;
							gint _tmp273_;
							gint _tmp274_;
							gint _e_index = 0;
							_tmp270_ = ea;
							_tmp271_ = vala_element_access_get_indices (_tmp270_);
							_e_list = _tmp271_;
							_tmp272_ = _e_list;
							_tmp273_ = vala_collection_get_size ((ValaCollection*) _tmp272_);
							_tmp274_ = _tmp273_;
							_e_size = _tmp274_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp275_;
								gint _tmp276_;
								gint _tmp277_;
								ValaExpression* e = NULL;
								ValaList* _tmp278_;
								gint _tmp279_;
								gpointer _tmp280_;
								ValaMethodCall* _tmp281_;
								ValaExpression* _tmp282_;
								_tmp275_ = _e_index;
								_e_index = _tmp275_ + 1;
								_tmp276_ = _e_index;
								_tmp277_ = _e_size;
								if (!(_tmp276_ < _tmp277_)) {
									break;
								}
								_tmp278_ = _e_list;
								_tmp279_ = _e_index;
								_tmp280_ = vala_list_get (_tmp278_, _tmp279_);
								e = (ValaExpression*) _tmp280_;
								_tmp281_ = set_call;
								_tmp282_ = e;
								vala_method_call_add_argument (_tmp281_, _tmp282_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp283_ = set_call;
						_tmp284_ = vala_assignment_get_right (self);
						_tmp285_ = _tmp284_;
						vala_method_call_add_argument (_tmp283_, _tmp285_);
						_tmp286_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp287_ = _tmp286_;
						_tmp288_ = set_call;
						vala_code_node_replace_expression (_tmp287_, (ValaExpression*) self, (ValaExpression*) _tmp288_);
						_tmp289_ = set_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp289_, context);
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp290_;
						ValaExpression* _tmp291_;
						ValaExpression* _tmp292_;
						ValaExpression* _tmp293_;
						ValaDataType* _tmp294_;
						ValaDataType* _tmp295_;
						ValaDataType* _tmp296_;
						ValaDataType* _tmp297_;
						_tmp290_ = vala_assignment_get_right (self);
						_tmp291_ = _tmp290_;
						_tmp292_ = vala_assignment_get_left (self);
						_tmp293_ = _tmp292_;
						_tmp294_ = vala_expression_get_value_type (_tmp293_);
						_tmp295_ = _tmp294_;
						_tmp296_ = vala_data_type_copy (_tmp295_);
						_tmp297_ = _tmp296_;
						vala_expression_set_target_type (_tmp291_, _tmp297_);
						_vala_code_node_unref0 (_tmp297_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp298_;
			ValaExpression* _tmp299_;
			_tmp298_ = vala_assignment_get_left (self);
			_tmp299_ = _tmp298_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp299_)) {
				ValaExpression* _tmp300_;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				ValaDataType* _tmp306_;
				ValaDataType* _tmp307_;
				_tmp300_ = vala_assignment_get_right (self);
				_tmp301_ = _tmp300_;
				_tmp302_ = vala_assignment_get_left (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp306_ = vala_data_type_copy (_tmp305_);
				_tmp307_ = _tmp306_;
				vala_expression_set_target_type (_tmp301_, _tmp307_);
				_vala_code_node_unref0 (_tmp307_);
			} else {
				ValaSourceReference* _tmp308_;
				ValaSourceReference* _tmp309_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp309_ = _tmp308_;
				vala_report_error (_tmp309_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp310_ = vala_assignment_get_right (self);
	_tmp311_ = _tmp310_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp311_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp313_ = self->priv->_operator;
	if (_tmp313_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp314_;
		ValaExpression* _tmp315_;
		_tmp314_ = vala_assignment_get_left (self);
		_tmp315_ = _tmp314_;
		_tmp312_ = VALA_IS_MEMBER_ACCESS (_tmp315_);
	} else {
		_tmp312_ = FALSE;
	}
	if (_tmp312_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		ValaMemberAccess* _tmp318_;
		ValaMemberAccess* _tmp319_;
		ValaSymbol* _tmp320_;
		ValaSymbol* _tmp321_;
		_tmp316_ = vala_assignment_get_left (self);
		_tmp317_ = _tmp316_;
		_tmp318_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp318_;
		_tmp319_ = ma;
		_tmp320_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp319_);
		_tmp321_ = _tmp320_;
		if (!VALA_IS_SIGNAL (_tmp321_)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp322_;
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			ValaMemberAccess* _tmp325_;
			const gchar* _tmp326_;
			const gchar* _tmp327_;
			ValaMemberAccess* _tmp328_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp329_;
			ValaExpression* _tmp330_;
			ValaExpression* _tmp331_;
			ValaSourceReference* _tmp332_;
			ValaSourceReference* _tmp333_;
			ValaBinaryExpression* _tmp334_;
			ValaBinaryExpression* _tmp335_;
			ValaExpression* _tmp336_;
			ValaExpression* _tmp337_;
			ValaDataType* _tmp338_;
			ValaDataType* _tmp339_;
			ValaDataType* _tmp340_;
			ValaDataType* _tmp341_;
			ValaExpression* _tmp342_;
			ValaExpression* _tmp343_;
			ValaExpression* _tmp344_;
			ValaExpression* _tmp345_;
			ValaDataType* _tmp346_;
			ValaDataType* _tmp347_;
			ValaDataType* _tmp348_;
			ValaDataType* _tmp349_;
			ValaExpression* _tmp350_;
			ValaExpression* _tmp351_;
			ValaDataType* _tmp352_;
			ValaDataType* _tmp353_;
			ValaAssignmentOperator _tmp354_;
			ValaBinaryExpression* _tmp365_;
			ValaExpression* _tmp366_;
			ValaExpression* _tmp367_;
			_tmp322_ = ma;
			_tmp323_ = vala_member_access_get_inner (_tmp322_);
			_tmp324_ = _tmp323_;
			_tmp325_ = ma;
			_tmp326_ = vala_member_access_get_member_name (_tmp325_);
			_tmp327_ = _tmp326_;
			_tmp328_ = vala_member_access_new (_tmp324_, _tmp327_, NULL);
			old_value = _tmp328_;
			_tmp329_ = old_value;
			_tmp330_ = vala_assignment_get_right (self);
			_tmp331_ = _tmp330_;
			_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp333_ = _tmp332_;
			_tmp334_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp329_, _tmp331_, _tmp333_);
			bin = _tmp334_;
			_tmp335_ = bin;
			_tmp336_ = vala_assignment_get_right (self);
			_tmp337_ = _tmp336_;
			_tmp338_ = vala_expression_get_target_type (_tmp337_);
			_tmp339_ = _tmp338_;
			_tmp340_ = vala_data_type_copy (_tmp339_);
			_tmp341_ = _tmp340_;
			vala_expression_set_target_type ((ValaExpression*) _tmp335_, _tmp341_);
			_vala_code_node_unref0 (_tmp341_);
			_tmp342_ = vala_assignment_get_right (self);
			_tmp343_ = _tmp342_;
			_tmp344_ = vala_assignment_get_right (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = vala_expression_get_target_type (_tmp345_);
			_tmp347_ = _tmp346_;
			_tmp348_ = vala_data_type_copy (_tmp347_);
			_tmp349_ = _tmp348_;
			vala_expression_set_target_type (_tmp343_, _tmp349_);
			_vala_code_node_unref0 (_tmp349_);
			_tmp350_ = vala_assignment_get_right (self);
			_tmp351_ = _tmp350_;
			_tmp352_ = vala_expression_get_target_type (_tmp351_);
			_tmp353_ = _tmp352_;
			vala_data_type_set_value_owned (_tmp353_, FALSE);
			_tmp354_ = self->priv->_operator;
			switch (_tmp354_) {
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
				{
					ValaBinaryExpression* _tmp355_;
					_tmp355_ = bin;
					vala_binary_expression_set_operator (_tmp355_, VALA_BINARY_OPERATOR_BITWISE_OR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
				{
					ValaBinaryExpression* _tmp356_;
					_tmp356_ = bin;
					vala_binary_expression_set_operator (_tmp356_, VALA_BINARY_OPERATOR_BITWISE_AND);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
				{
					ValaBinaryExpression* _tmp357_;
					_tmp357_ = bin;
					vala_binary_expression_set_operator (_tmp357_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_ADD:
				{
					ValaBinaryExpression* _tmp358_;
					_tmp358_ = bin;
					vala_binary_expression_set_operator (_tmp358_, VALA_BINARY_OPERATOR_PLUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SUB:
				{
					ValaBinaryExpression* _tmp359_;
					_tmp359_ = bin;
					vala_binary_expression_set_operator (_tmp359_, VALA_BINARY_OPERATOR_MINUS);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_MUL:
				{
					ValaBinaryExpression* _tmp360_;
					_tmp360_ = bin;
					vala_binary_expression_set_operator (_tmp360_, VALA_BINARY_OPERATOR_MUL);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_DIV:
				{
					ValaBinaryExpression* _tmp361_;
					_tmp361_ = bin;
					vala_binary_expression_set_operator (_tmp361_, VALA_BINARY_OPERATOR_DIV);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_PERCENT:
				{
					ValaBinaryExpression* _tmp362_;
					_tmp362_ = bin;
					vala_binary_expression_set_operator (_tmp362_, VALA_BINARY_OPERATOR_MOD);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
				{
					ValaBinaryExpression* _tmp363_;
					_tmp363_ = bin;
					vala_binary_expression_set_operator (_tmp363_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
					break;
				}
				case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
				{
					ValaBinaryExpression* _tmp364_;
					_tmp364_ = bin;
					vala_binary_expression_set_operator (_tmp364_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
					break;
				}
				default:
				break;
			}
			_tmp365_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp365_);
			_tmp366_ = vala_assignment_get_right (self);
			_tmp367_ = _tmp366_;
			vala_code_node_check ((ValaCodeNode*) _tmp367_, context);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp368_ = vala_assignment_get_left (self);
	_tmp369_ = _tmp368_;
	_tmp370_ = vala_expression_get_symbol_reference (_tmp369_);
	_tmp371_ = _tmp370_;
	if (VALA_IS_SIGNAL (_tmp371_)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp372_;
		ValaExpression* _tmp373_;
		ValaSymbol* _tmp374_;
		ValaSymbol* _tmp375_;
		ValaSignal* _tmp376_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp377_;
		ValaExpression* _tmp378_;
		ValaSymbol* _tmp379_;
		ValaSymbol* _tmp380_;
		ValaMethod* _tmp381_;
		ValaMethod* _tmp382_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp387_;
		ValaDynamicSignal* _tmp388_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp389_;
		ValaExpression* _tmp390_;
		ValaMemberAccess* _tmp391_;
		ValaDynamicSignal* _tmp392_;
		_tmp372_ = vala_assignment_get_left (self);
		_tmp373_ = _tmp372_;
		_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
		_tmp375_ = _tmp374_;
		_tmp376_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp375_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp376_;
		_tmp377_ = vala_assignment_get_right (self);
		_tmp378_ = _tmp377_;
		_tmp379_ = vala_expression_get_symbol_reference (_tmp378_);
		_tmp380_ = _tmp379_;
		_tmp381_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp380_) ? ((ValaMethod*) _tmp380_) : NULL);
		m = _tmp381_;
		_tmp382_ = m;
		if (_tmp382_ == NULL) {
			ValaExpression* _tmp383_;
			ValaExpression* _tmp384_;
			ValaSourceReference* _tmp385_;
			ValaSourceReference* _tmp386_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp383_ = vala_assignment_get_right (self);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp384_);
			_tmp386_ = _tmp385_;
			vala_report_error (_tmp386_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp387_ = sig;
		_tmp388_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_SIGNAL (_tmp387_) ? ((ValaDynamicSignal*) _tmp387_) : NULL);
		dynamic_sig = _tmp388_;
		_tmp389_ = vala_assignment_get_right (self);
		_tmp390_ = _tmp389_;
		_tmp391_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp390_) ? ((ValaMemberAccess*) _tmp390_) : NULL);
		right_ma = _tmp391_;
		_tmp392_ = dynamic_sig;
		if (_tmp392_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp413_;
			ValaExpression* _tmp414_;
			ValaSignal* _tmp415_;
			ValaSignal* _tmp416_;
			ValaSymbol* _tmp417_;
			ValaSymbol* _tmp418_;
			ValaObjectType* _tmp419_;
			ValaObjectType* _tmp420_;
			ValaDelegate* _tmp421_;
			ValaDelegate* _tmp422_;
			ValaDelegateType* _tmp423_;
			ValaDelegateType* _tmp424_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp393_;
				ValaExpression* _tmp394_;
				ValaExpression* _tmp395_;
				ValaDataType* _tmp396_;
				ValaDataType* _tmp397_;
				ValaList* _tmp398_;
				gint _param_size = 0;
				ValaList* _tmp399_;
				gint _tmp400_;
				gint _tmp401_;
				gint _param_index = 0;
				_tmp393_ = dynamic_sig;
				_tmp394_ = vala_dynamic_signal_get_handler (_tmp393_);
				_tmp395_ = _tmp394_;
				_tmp396_ = vala_expression_get_value_type (_tmp395_);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_data_type_get_parameters (_tmp397_);
				_param_list = _tmp398_;
				_tmp399_ = _param_list;
				_tmp400_ = vala_collection_get_size ((ValaCollection*) _tmp399_);
				_tmp401_ = _tmp400_;
				_param_size = _tmp401_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp402_;
					gint _tmp403_;
					gint _tmp404_;
					ValaParameter* param = NULL;
					ValaList* _tmp405_;
					gint _tmp406_;
					gpointer _tmp407_;
					gboolean _tmp408_;
					_tmp402_ = _param_index;
					_param_index = _tmp402_ + 1;
					_tmp403_ = _param_index;
					_tmp404_ = _param_size;
					if (!(_tmp403_ < _tmp404_)) {
						break;
					}
					_tmp405_ = _param_list;
					_tmp406_ = _param_index;
					_tmp407_ = vala_list_get (_tmp405_, _tmp406_);
					param = (ValaParameter*) _tmp407_;
					_tmp408_ = first;
					if (_tmp408_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp409_;
						ValaParameter* _tmp410_;
						ValaParameter* _tmp411_;
						ValaParameter* _tmp412_;
						_tmp409_ = dynamic_sig;
						_tmp410_ = param;
						_tmp411_ = vala_parameter_copy (_tmp410_);
						_tmp412_ = _tmp411_;
						vala_callable_add_parameter ((ValaCallable*) _tmp409_, _tmp412_);
						_vala_code_node_unref0 (_tmp412_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp413_ = vala_assignment_get_right (self);
			_tmp414_ = _tmp413_;
			_tmp415_ = sig;
			_tmp416_ = sig;
			_tmp417_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp416_);
			_tmp418_ = _tmp417_;
			_tmp419_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp418_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp420_ = _tmp419_;
			_tmp421_ = vala_signal_get_delegate (_tmp415_, (ValaDataType*) _tmp420_, (ValaCodeNode*) self);
			_tmp422_ = _tmp421_;
			_tmp423_ = vala_delegate_type_new (_tmp422_);
			_tmp424_ = _tmp423_;
			vala_expression_set_target_type (_tmp414_, (ValaDataType*) _tmp424_);
			_vala_code_node_unref0 (_tmp424_);
			_vala_code_node_unref0 (_tmp422_);
			_vala_code_node_unref0 (_tmp420_);
		} else {
			ValaExpression* _tmp425_;
			ValaExpression* _tmp426_;
			ValaDataType* _tmp427_;
			ValaDataType* _tmp428_;
			ValaExpression* _tmp429_;
			ValaExpression* _tmp430_;
			ValaDataType* _tmp431_;
			ValaDataType* _tmp432_;
			_tmp425_ = vala_assignment_get_right (self);
			_tmp426_ = _tmp425_;
			_tmp427_ = vala_expression_get_value_type (_tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_assignment_get_right (self);
			_tmp430_ = _tmp429_;
			_tmp431_ = vala_expression_get_target_type (_tmp430_);
			_tmp432_ = _tmp431_;
			if (!vala_data_type_compatible (_tmp428_, _tmp432_)) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp433_;
				ValaExpression* _tmp434_;
				ValaDataType* _tmp435_;
				ValaDataType* _tmp436_;
				ValaDelegateType* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				ValaSourceReference* _tmp440_;
				ValaSourceReference* _tmp441_;
				ValaExpression* _tmp442_;
				ValaExpression* _tmp443_;
				ValaDataType* _tmp444_;
				ValaDataType* _tmp445_;
				gchar* _tmp446_;
				gchar* _tmp447_;
				ValaExpression* _tmp448_;
				ValaExpression* _tmp449_;
				ValaDataType* _tmp450_;
				ValaDataType* _tmp451_;
				gchar* _tmp452_;
				gchar* _tmp453_;
				ValaDelegateType* _tmp454_;
				ValaMethod* _tmp455_;
				const gchar* _tmp456_;
				const gchar* _tmp457_;
				gchar* _tmp458_;
				gchar* _tmp459_;
				gchar* _tmp460_;
				gchar* _tmp461_;
				_tmp433_ = vala_assignment_get_right (self);
				_tmp434_ = _tmp433_;
				_tmp435_ = vala_expression_get_target_type (_tmp434_);
				_tmp436_ = _tmp435_;
				_tmp437_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp436_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp437_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp438_ = vala_assignment_get_right (self);
				_tmp439_ = _tmp438_;
				_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_assignment_get_right (self);
				_tmp443_ = _tmp442_;
				_tmp444_ = vala_expression_get_value_type (_tmp443_);
				_tmp445_ = _tmp444_;
				_tmp446_ = vala_code_node_to_string ((ValaCodeNode*) _tmp445_);
				_tmp447_ = _tmp446_;
				_tmp448_ = vala_assignment_get_right (self);
				_tmp449_ = _tmp448_;
				_tmp450_ = vala_expression_get_target_type (_tmp449_);
				_tmp451_ = _tmp450_;
				_tmp452_ = vala_code_node_to_string ((ValaCodeNode*) _tmp451_);
				_tmp453_ = _tmp452_;
				_tmp454_ = delegate_type;
				_tmp455_ = m;
				_tmp456_ = vala_symbol_get_name ((ValaSymbol*) _tmp455_);
				_tmp457_ = _tmp456_;
				_tmp458_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp454_, _tmp457_);
				_tmp459_ = _tmp458_;
				_tmp460_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp447_, _tmp453_, _tmp459_);
				_tmp461_ = _tmp460_;
				vala_report_error (_tmp441_, _tmp461_);
				_g_free0 (_tmp461_);
				_g_free0 (_tmp459_);
				_g_free0 (_tmp453_);
				_g_free0 (_tmp447_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp462_ = FALSE;
				ValaMemberAccess* _tmp463_;
				_tmp463_ = right_ma;
				if (_tmp463_ != NULL) {
					ValaMemberAccess* _tmp464_;
					gboolean _tmp465_;
					gboolean _tmp466_;
					_tmp464_ = right_ma;
					_tmp465_ = vala_member_access_get_prototype_access (_tmp464_);
					_tmp466_ = _tmp465_;
					_tmp462_ = _tmp466_;
				} else {
					_tmp462_ = FALSE;
				}
				if (_tmp462_) {
					ValaExpression* _tmp467_;
					ValaExpression* _tmp468_;
					ValaSourceReference* _tmp469_;
					ValaSourceReference* _tmp470_;
					ValaMethod* _tmp471_;
					gchar* _tmp472_;
					gchar* _tmp473_;
					gchar* _tmp474_;
					gchar* _tmp475_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp467_ = vala_assignment_get_right (self);
					_tmp468_ = _tmp467_;
					_tmp469_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp468_);
					_tmp470_ = _tmp469_;
					_tmp471_ = m;
					_tmp472_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp471_);
					_tmp473_ = _tmp472_;
					_tmp474_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp473_);
					_tmp475_ = _tmp474_;
					vala_report_error (_tmp470_, _tmp475_);
					_g_free0 (_tmp475_);
					_g_free0 (_tmp473_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp476_;
		ValaExpression* _tmp477_;
		_tmp476_ = vala_assignment_get_left (self);
		_tmp477_ = _tmp476_;
		if (VALA_IS_MEMBER_ACCESS (_tmp477_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp478_;
			ValaExpression* _tmp479_;
			ValaMemberAccess* _tmp480_;
			ValaMemberAccess* _tmp481_;
			ValaSymbol* _tmp482_;
			ValaSymbol* _tmp483_;
			gboolean _tmp670_ = FALSE;
			ValaExpression* _tmp671_;
			ValaExpression* _tmp672_;
			ValaDataType* _tmp673_;
			ValaDataType* _tmp674_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp729_;
			ValaExpression* _tmp730_;
			ValaMemberAccess* _tmp731_;
			gboolean _tmp732_ = FALSE;
			ValaMemberAccess* _tmp733_;
			_tmp478_ = vala_assignment_get_left (self);
			_tmp479_ = _tmp478_;
			_tmp480_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp479_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp480_;
			_tmp481_ = ma;
			_tmp482_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp481_);
			_tmp483_ = _tmp482_;
			if (VALA_IS_PROPERTY (_tmp483_)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp484_;
				ValaSymbol* _tmp485_;
				ValaSymbol* _tmp486_;
				ValaProperty* _tmp487_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp488_;
				ValaDynamicProperty* _tmp489_;
				ValaDynamicProperty* _tmp490_;
				gboolean _tmp505_ = FALSE;
				ValaProperty* _tmp506_;
				ValaPropertyAccessor* _tmp507_;
				ValaPropertyAccessor* _tmp508_;
				_tmp484_ = ma;
				_tmp485_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp484_);
				_tmp486_ = _tmp485_;
				_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp487_;
				_tmp488_ = prop;
				_tmp489_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_PROPERTY (_tmp488_) ? ((ValaDynamicProperty*) _tmp488_) : NULL);
				dynamic_prop = _tmp489_;
				_tmp490_ = dynamic_prop;
				if (_tmp490_ != NULL) {
					ValaDynamicProperty* _tmp491_;
					ValaExpression* _tmp492_;
					ValaExpression* _tmp493_;
					ValaDataType* _tmp494_;
					ValaDataType* _tmp495_;
					ValaDataType* _tmp496_;
					ValaDataType* _tmp497_;
					ValaExpression* _tmp498_;
					ValaExpression* _tmp499_;
					ValaDynamicProperty* _tmp500_;
					ValaDataType* _tmp501_;
					ValaDataType* _tmp502_;
					ValaDataType* _tmp503_;
					ValaDataType* _tmp504_;
					_tmp491_ = dynamic_prop;
					_tmp492_ = vala_assignment_get_right (self);
					_tmp493_ = _tmp492_;
					_tmp494_ = vala_expression_get_value_type (_tmp493_);
					_tmp495_ = _tmp494_;
					_tmp496_ = vala_data_type_copy (_tmp495_);
					_tmp497_ = _tmp496_;
					vala_property_set_property_type ((ValaProperty*) _tmp491_, _tmp497_);
					_vala_code_node_unref0 (_tmp497_);
					_tmp498_ = vala_assignment_get_left (self);
					_tmp499_ = _tmp498_;
					_tmp500_ = dynamic_prop;
					_tmp501_ = vala_property_get_property_type ((ValaProperty*) _tmp500_);
					_tmp502_ = _tmp501_;
					_tmp503_ = vala_data_type_copy (_tmp502_);
					_tmp504_ = _tmp503_;
					vala_expression_set_value_type (_tmp499_, _tmp504_);
					_vala_code_node_unref0 (_tmp504_);
				}
				_tmp506_ = prop;
				_tmp507_ = vala_property_get_set_accessor (_tmp506_);
				_tmp508_ = _tmp507_;
				if (_tmp508_ == NULL) {
					_tmp505_ = TRUE;
				} else {
					gboolean _tmp509_ = FALSE;
					ValaProperty* _tmp510_;
					ValaPropertyAccessor* _tmp511_;
					ValaPropertyAccessor* _tmp512_;
					gboolean _tmp513_;
					gboolean _tmp514_;
					_tmp510_ = prop;
					_tmp511_ = vala_property_get_set_accessor (_tmp510_);
					_tmp512_ = _tmp511_;
					_tmp513_ = vala_property_accessor_get_writable (_tmp512_);
					_tmp514_ = _tmp513_;
					if (!_tmp514_) {
						gboolean _tmp515_ = FALSE;
						ValaSemanticAnalyzer* _tmp516_;
						ValaSemanticAnalyzer* _tmp517_;
						ValaMethod* _tmp518_;
						ValaMethod* _tmp519_;
						gboolean _tmp520_;
						_tmp516_ = vala_code_context_get_analyzer (context);
						_tmp517_ = _tmp516_;
						_tmp518_ = vala_semantic_analyzer_find_current_method (_tmp517_);
						_tmp519_ = _tmp518_;
						_tmp520_ = VALA_IS_CREATION_METHOD (_tmp519_);
						_vala_code_node_unref0 (_tmp519_);
						if (_tmp520_) {
							_tmp515_ = TRUE;
						} else {
							ValaSemanticAnalyzer* _tmp521_;
							ValaSemanticAnalyzer* _tmp522_;
							_tmp521_ = vala_code_context_get_analyzer (context);
							_tmp522_ = _tmp521_;
							_tmp515_ = vala_semantic_analyzer_is_in_constructor (_tmp522_);
						}
						_tmp509_ = !_tmp515_;
					} else {
						_tmp509_ = FALSE;
					}
					_tmp505_ = _tmp509_;
				}
				if (_tmp505_) {
					ValaMemberAccess* _tmp523_;
					ValaMemberAccess* _tmp524_;
					ValaSourceReference* _tmp525_;
					ValaSourceReference* _tmp526_;
					ValaProperty* _tmp527_;
					gchar* _tmp528_;
					gchar* _tmp529_;
					gchar* _tmp530_;
					gchar* _tmp531_;
					_tmp523_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp523_, TRUE);
					_tmp524_ = ma;
					_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp524_);
					_tmp526_ = _tmp525_;
					_tmp527_ = prop;
					_tmp528_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp527_);
					_tmp529_ = _tmp528_;
					_tmp530_ = g_strdup_printf ("Property `%s' is read-only", _tmp529_);
					_tmp531_ = _tmp530_;
					vala_report_error (_tmp526_, _tmp531_);
					_g_free0 (_tmp531_);
					_g_free0 (_tmp529_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp532_ = FALSE;
					gboolean _tmp533_ = FALSE;
					gboolean _tmp534_;
					gboolean _tmp535_;
					_tmp534_ = vala_code_context_get_deprecated (context);
					_tmp535_ = _tmp534_;
					if (!_tmp535_) {
						ValaProperty* _tmp536_;
						ValaPropertyAccessor* _tmp537_;
						ValaPropertyAccessor* _tmp538_;
						gboolean _tmp539_;
						gboolean _tmp540_;
						_tmp536_ = prop;
						_tmp537_ = vala_property_get_set_accessor (_tmp536_);
						_tmp538_ = _tmp537_;
						_tmp539_ = vala_property_accessor_get_writable (_tmp538_);
						_tmp540_ = _tmp539_;
						_tmp533_ = !_tmp540_;
					} else {
						_tmp533_ = FALSE;
					}
					if (_tmp533_) {
						ValaSemanticAnalyzer* _tmp541_;
						ValaSemanticAnalyzer* _tmp542_;
						ValaMethod* _tmp543_;
						ValaMethod* _tmp544_;
						_tmp541_ = vala_code_context_get_analyzer (context);
						_tmp542_ = _tmp541_;
						_tmp543_ = vala_semantic_analyzer_find_current_method (_tmp542_);
						_tmp544_ = _tmp543_;
						_tmp532_ = VALA_IS_CREATION_METHOD (_tmp544_);
						_vala_code_node_unref0 (_tmp544_);
					} else {
						_tmp532_ = FALSE;
					}
					if (_tmp532_) {
						ValaMemberAccess* _tmp545_;
						ValaExpression* _tmp546_;
						ValaExpression* _tmp547_;
						ValaSymbol* _tmp548_;
						ValaSymbol* _tmp549_;
						ValaSemanticAnalyzer* _tmp550_;
						ValaSemanticAnalyzer* _tmp551_;
						ValaMethod* _tmp552_;
						ValaMethod* _tmp553_;
						ValaParameter* _tmp554_;
						ValaParameter* _tmp555_;
						gboolean _tmp556_;
						_tmp545_ = ma;
						_tmp546_ = vala_member_access_get_inner (_tmp545_);
						_tmp547_ = _tmp546_;
						_tmp548_ = vala_expression_get_symbol_reference (_tmp547_);
						_tmp549_ = _tmp548_;
						_tmp550_ = vala_code_context_get_analyzer (context);
						_tmp551_ = _tmp550_;
						_tmp552_ = vala_semantic_analyzer_find_current_method (_tmp551_);
						_tmp553_ = _tmp552_;
						_tmp554_ = vala_method_get_this_parameter (_tmp553_);
						_tmp555_ = _tmp554_;
						_tmp556_ = _tmp549_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp555_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp553_);
						if (_tmp556_) {
							ValaMemberAccess* _tmp557_;
							ValaSourceReference* _tmp558_;
							ValaSourceReference* _tmp559_;
							ValaProperty* _tmp560_;
							gchar* _tmp561_;
							gchar* _tmp562_;
							gchar* _tmp563_;
							gchar* _tmp564_;
							_tmp557_ = ma;
							_tmp558_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp557_);
							_tmp559_ = _tmp558_;
							_tmp560_ = prop;
							_tmp561_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp560_);
							_tmp562_ = _tmp561_;
							_tmp563_ = g_strdup_printf ("Property `%s' is read-only", _tmp562_);
							_tmp564_ = _tmp563_;
							vala_report_error (_tmp559_, _tmp564_);
							_g_free0 (_tmp564_);
							_g_free0 (_tmp562_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp565_;
							ValaSourceReference* _tmp566_;
							ValaSourceReference* _tmp567_;
							_tmp565_ = ma;
							_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp565_);
							_tmp567_ = _tmp566_;
							vala_report_error (_tmp567_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp568_ = FALSE;
				ValaMemberAccess* _tmp569_;
				ValaSymbol* _tmp570_;
				ValaSymbol* _tmp571_;
				_tmp569_ = ma;
				_tmp570_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp569_);
				_tmp571_ = _tmp570_;
				if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp571_)) {
					ValaMemberAccess* _tmp572_;
					ValaExpression* _tmp573_;
					ValaExpression* _tmp574_;
					ValaDataType* _tmp575_;
					ValaDataType* _tmp576_;
					gboolean _tmp577_;
					gboolean _tmp578_;
					_tmp572_ = ma;
					_tmp573_ = vala_member_access_get_inner (_tmp572_);
					_tmp574_ = _tmp573_;
					_tmp575_ = vala_expression_get_value_type (_tmp574_);
					_tmp576_ = _tmp575_;
					_tmp577_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp576_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp578_ = _tmp577_;
					_tmp568_ = _tmp578_;
				} else {
					_tmp568_ = FALSE;
				}
				if (_tmp568_) {
					ValaSourceReference* _tmp579_;
					ValaSourceReference* _tmp580_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp580_ = _tmp579_;
					vala_report_error (_tmp580_, "`length' field of fixed length arrays is read-only");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp581_ = FALSE;
					ValaMemberAccess* _tmp582_;
					ValaSymbol* _tmp583_;
					ValaSymbol* _tmp584_;
					_tmp582_ = ma;
					_tmp583_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp582_);
					_tmp584_ = _tmp583_;
					if (VALA_IS_VARIABLE (_tmp584_)) {
						ValaExpression* _tmp585_;
						ValaExpression* _tmp586_;
						ValaDataType* _tmp587_;
						ValaDataType* _tmp588_;
						_tmp585_ = vala_assignment_get_right (self);
						_tmp586_ = _tmp585_;
						_tmp587_ = vala_expression_get_value_type (_tmp586_);
						_tmp588_ = _tmp587_;
						_tmp581_ = _tmp588_ == NULL;
					} else {
						_tmp581_ = FALSE;
					}
					if (_tmp581_) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp589_;
						ValaSymbol* _tmp590_;
						ValaSymbol* _tmp591_;
						ValaVariable* _tmp592_;
						gboolean _tmp593_ = FALSE;
						ValaExpression* _tmp594_;
						ValaExpression* _tmp595_;
						ValaSymbol* _tmp596_;
						ValaSymbol* _tmp597_;
						_tmp589_ = ma;
						_tmp590_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp589_);
						_tmp591_ = _tmp590_;
						_tmp592_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp591_, VALA_TYPE_VARIABLE, ValaVariable));
						variable = _tmp592_;
						_tmp594_ = vala_assignment_get_right (self);
						_tmp595_ = _tmp594_;
						_tmp596_ = vala_expression_get_symbol_reference (_tmp595_);
						_tmp597_ = _tmp596_;
						if (VALA_IS_METHOD (_tmp597_)) {
							ValaVariable* _tmp598_;
							ValaDataType* _tmp599_;
							ValaDataType* _tmp600_;
							_tmp598_ = variable;
							_tmp599_ = vala_variable_get_variable_type (_tmp598_);
							_tmp600_ = _tmp599_;
							_tmp593_ = VALA_IS_DELEGATE_TYPE (_tmp600_);
						} else {
							_tmp593_ = FALSE;
						}
						if (_tmp593_) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp601_;
							ValaExpression* _tmp602_;
							ValaSymbol* _tmp603_;
							ValaSymbol* _tmp604_;
							ValaMethod* _tmp605_;
							ValaDelegateType* dt = NULL;
							ValaVariable* _tmp606_;
							ValaDataType* _tmp607_;
							ValaDataType* _tmp608_;
							ValaDelegateType* _tmp609_;
							ValaDelegate* cb = NULL;
							ValaDelegateType* _tmp610_;
							ValaDelegate* _tmp611_;
							ValaDelegate* _tmp612_;
							ValaDelegate* _tmp613_;
							ValaDelegate* _tmp614_;
							ValaMethod* _tmp615_;
							ValaDelegateType* _tmp616_;
							ValaExpression* _tmp627_;
							ValaExpression* _tmp628_;
							ValaVariable* _tmp629_;
							ValaDataType* _tmp630_;
							ValaDataType* _tmp631_;
							ValaDataType* _tmp632_;
							ValaDataType* _tmp633_;
							_tmp601_ = vala_assignment_get_right (self);
							_tmp602_ = _tmp601_;
							_tmp603_ = vala_expression_get_symbol_reference (_tmp602_);
							_tmp604_ = _tmp603_;
							_tmp605_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp604_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp605_;
							_tmp606_ = variable;
							_tmp607_ = vala_variable_get_variable_type (_tmp606_);
							_tmp608_ = _tmp607_;
							_tmp609_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp608_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							dt = _tmp609_;
							_tmp610_ = dt;
							_tmp611_ = vala_delegate_type_get_delegate_symbol (_tmp610_);
							_tmp612_ = _tmp611_;
							_tmp613_ = _vala_code_node_ref0 (_tmp612_);
							cb = _tmp613_;
							_tmp614_ = cb;
							_tmp615_ = m;
							_tmp616_ = dt;
							if (!vala_delegate_matches_method (_tmp614_, _tmp615_, (ValaDataType*) _tmp616_)) {
								ValaSourceReference* _tmp617_;
								ValaSourceReference* _tmp618_;
								ValaMethod* _tmp619_;
								gchar* _tmp620_;
								gchar* _tmp621_;
								ValaDelegate* _tmp622_;
								gchar* _tmp623_;
								gchar* _tmp624_;
								gchar* _tmp625_;
								gchar* _tmp626_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp617_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp618_ = _tmp617_;
								_tmp619_ = m;
								_tmp620_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp619_);
								_tmp621_ = _tmp620_;
								_tmp622_ = cb;
								_tmp623_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp622_);
								_tmp624_ = _tmp623_;
								_tmp625_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp621_, _tmp624_);
								_tmp626_ = _tmp625_;
								vala_report_error (_tmp618_, _tmp626_);
								_g_free0 (_tmp626_);
								_g_free0 (_tmp624_);
								_g_free0 (_tmp621_);
								result = FALSE;
								_vala_code_node_unref0 (cb);
								_vala_code_node_unref0 (dt);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (variable);
								_vala_code_node_unref0 (ma);
								return result;
							}
							_tmp627_ = vala_assignment_get_right (self);
							_tmp628_ = _tmp627_;
							_tmp629_ = variable;
							_tmp630_ = vala_variable_get_variable_type (_tmp629_);
							_tmp631_ = _tmp630_;
							_tmp632_ = vala_data_type_copy (_tmp631_);
							_tmp633_ = _tmp632_;
							vala_expression_set_value_type (_tmp628_, _tmp633_);
							_vala_code_node_unref0 (_tmp633_);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
						} else {
							ValaSourceReference* _tmp634_;
							ValaSourceReference* _tmp635_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp634_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp635_ = _tmp634_;
							vala_report_error (_tmp635_, "Assignment: Invalid assignment attempt");
							result = FALSE;
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_vala_code_node_unref0 (variable);
					} else {
						ValaMemberAccess* _tmp636_;
						ValaSymbol* _tmp637_;
						ValaSymbol* _tmp638_;
						_tmp636_ = ma;
						_tmp637_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp636_);
						_tmp638_ = _tmp637_;
						if (VALA_IS_VARIABLE (_tmp638_)) {
							ValaVariable* variable = NULL;
							ValaMemberAccess* _tmp639_;
							ValaSymbol* _tmp640_;
							ValaSymbol* _tmp641_;
							ValaArrayType* variable_array_type = NULL;
							ValaVariable* _tmp642_;
							ValaDataType* _tmp643_;
							ValaDataType* _tmp644_;
							gboolean _tmp645_ = FALSE;
							gboolean _tmp646_ = FALSE;
							gboolean _tmp647_ = FALSE;
							ValaArrayType* _tmp648_;
							_tmp639_ = ma;
							_tmp640_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp639_);
							_tmp641_ = _tmp640_;
							variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp641_, VALA_TYPE_VARIABLE, ValaVariable);
							_tmp642_ = variable;
							_tmp643_ = vala_variable_get_variable_type (_tmp642_);
							_tmp644_ = _tmp643_;
							variable_array_type = VALA_IS_ARRAY_TYPE (_tmp644_) ? ((ValaArrayType*) _tmp644_) : NULL;
							_tmp648_ = variable_array_type;
							if (_tmp648_ != NULL) {
								ValaArrayType* _tmp649_;
								gboolean _tmp650_;
								gboolean _tmp651_;
								_tmp649_ = variable_array_type;
								_tmp650_ = vala_array_type_get_fixed_length (_tmp649_);
								_tmp651_ = _tmp650_;
								_tmp647_ = _tmp651_;
							} else {
								_tmp647_ = FALSE;
							}
							if (_tmp647_) {
								ValaExpression* _tmp652_;
								ValaExpression* _tmp653_;
								_tmp652_ = vala_assignment_get_right (self);
								_tmp653_ = _tmp652_;
								_tmp646_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp653_);
							} else {
								_tmp646_ = FALSE;
							}
							if (_tmp646_) {
								ValaExpression* _tmp654_;
								ValaExpression* _tmp655_;
								ValaInitializerList* _tmp656_;
								ValaInitializerList* _tmp657_;
								_tmp654_ = vala_assignment_get_right (self);
								_tmp655_ = _tmp654_;
								_tmp656_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp655_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
								_tmp657_ = _tmp656_;
								_tmp645_ = _tmp657_ == NULL;
							} else {
								_tmp645_ = FALSE;
							}
							if (_tmp645_) {
								ValaSourceReference* _tmp658_;
								ValaSourceReference* _tmp659_;
								ValaCodeNode* _tmp660_;
								ValaCodeNode* _tmp661_;
								ValaCodeNode* _tmp662_;
								ValaCodeNode* _tmp663_;
								ValaCodeNode* _tmp664_;
								ValaCodeNode* _tmp665_;
								ValaSourceReference* _tmp666_;
								ValaSourceReference* _tmp667_;
								ValaEmptyStatement* _tmp668_;
								ValaEmptyStatement* _tmp669_;
								_tmp658_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp659_ = _tmp658_;
								vala_report_warning (_tmp659_, "Arrays with fixed length don't require an explicit instantiation");
								_tmp660_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp661_ = _tmp660_;
								_tmp662_ = vala_code_node_get_parent_node (_tmp661_);
								_tmp663_ = _tmp662_;
								_tmp664_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp665_ = _tmp664_;
								_tmp666_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp667_ = _tmp666_;
								_tmp668_ = vala_empty_statement_new (_tmp667_);
								_tmp669_ = _tmp668_;
								vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp663_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp665_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp669_);
								_vala_code_node_unref0 (_tmp669_);
								result = TRUE;
								_vala_code_node_unref0 (ma);
								return result;
							}
						}
					}
				}
			}
			_tmp671_ = vala_assignment_get_left (self);
			_tmp672_ = _tmp671_;
			_tmp673_ = vala_expression_get_value_type (_tmp672_);
			_tmp674_ = _tmp673_;
			if (_tmp674_ != NULL) {
				ValaExpression* _tmp675_;
				ValaExpression* _tmp676_;
				ValaDataType* _tmp677_;
				ValaDataType* _tmp678_;
				_tmp675_ = vala_assignment_get_right (self);
				_tmp676_ = _tmp675_;
				_tmp677_ = vala_expression_get_value_type (_tmp676_);
				_tmp678_ = _tmp677_;
				_tmp670_ = _tmp678_ != NULL;
			} else {
				_tmp670_ = FALSE;
			}
			if (_tmp670_) {
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaDataType* _tmp681_;
				ValaDataType* _tmp682_;
				ValaExpression* _tmp683_;
				ValaExpression* _tmp684_;
				ValaDataType* _tmp685_;
				ValaDataType* _tmp686_;
				ValaMemberAccess* _tmp703_;
				ValaSymbol* _tmp704_;
				ValaSymbol* _tmp705_;
				_tmp679_ = vala_assignment_get_right (self);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_value_type (_tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = vala_assignment_get_left (self);
				_tmp684_ = _tmp683_;
				_tmp685_ = vala_expression_get_value_type (_tmp684_);
				_tmp686_ = _tmp685_;
				if (!vala_data_type_compatible (_tmp682_, _tmp686_)) {
					ValaSourceReference* _tmp687_;
					ValaSourceReference* _tmp688_;
					ValaExpression* _tmp689_;
					ValaExpression* _tmp690_;
					ValaDataType* _tmp691_;
					ValaDataType* _tmp692_;
					gchar* _tmp693_;
					gchar* _tmp694_;
					ValaExpression* _tmp695_;
					ValaExpression* _tmp696_;
					ValaDataType* _tmp697_;
					ValaDataType* _tmp698_;
					gchar* _tmp699_;
					gchar* _tmp700_;
					gchar* _tmp701_;
					gchar* _tmp702_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp687_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp688_ = _tmp687_;
					_tmp689_ = vala_assignment_get_right (self);
					_tmp690_ = _tmp689_;
					_tmp691_ = vala_expression_get_value_type (_tmp690_);
					_tmp692_ = _tmp691_;
					_tmp693_ = vala_code_node_to_string ((ValaCodeNode*) _tmp692_);
					_tmp694_ = _tmp693_;
					_tmp695_ = vala_assignment_get_left (self);
					_tmp696_ = _tmp695_;
					_tmp697_ = vala_expression_get_value_type (_tmp696_);
					_tmp698_ = _tmp697_;
					_tmp699_ = vala_code_node_to_string ((ValaCodeNode*) _tmp698_);
					_tmp700_ = _tmp699_;
					_tmp701_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp694_, _tmp700_);
					_tmp702_ = _tmp701_;
					vala_report_error (_tmp688_, _tmp702_);
					_g_free0 (_tmp702_);
					_g_free0 (_tmp700_);
					_g_free0 (_tmp694_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp703_ = ma;
				_tmp704_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp703_);
				_tmp705_ = _tmp704_;
				if (!VALA_IS_PROPERTY (_tmp705_)) {
					ValaExpression* _tmp706_;
					ValaExpression* _tmp707_;
					ValaDataType* _tmp708_;
					ValaDataType* _tmp709_;
					_tmp706_ = vala_assignment_get_right (self);
					_tmp707_ = _tmp706_;
					_tmp708_ = vala_expression_get_value_type (_tmp707_);
					_tmp709_ = _tmp708_;
					if (vala_data_type_is_disposable (_tmp709_)) {
						gboolean _tmp710_ = FALSE;
						ValaExpression* _tmp711_;
						ValaExpression* _tmp712_;
						ValaDataType* _tmp713_;
						ValaDataType* _tmp714_;
						_tmp711_ = vala_assignment_get_left (self);
						_tmp712_ = _tmp711_;
						_tmp713_ = vala_expression_get_value_type (_tmp712_);
						_tmp714_ = _tmp713_;
						if (!VALA_IS_POINTER_TYPE (_tmp714_)) {
							ValaExpression* _tmp715_;
							ValaExpression* _tmp716_;
							ValaDataType* _tmp717_;
							ValaDataType* _tmp718_;
							gboolean _tmp719_;
							gboolean _tmp720_;
							_tmp715_ = vala_assignment_get_left (self);
							_tmp716_ = _tmp715_;
							_tmp717_ = vala_expression_get_value_type (_tmp716_);
							_tmp718_ = _tmp717_;
							_tmp719_ = vala_data_type_get_value_owned (_tmp718_);
							_tmp720_ = _tmp719_;
							_tmp710_ = !_tmp720_;
						} else {
							_tmp710_ = FALSE;
						}
						if (_tmp710_) {
							ValaSourceReference* _tmp721_;
							ValaSourceReference* _tmp722_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp721_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp722_ = _tmp721_;
							vala_report_error (_tmp722_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp723_;
						ValaExpression* _tmp724_;
						ValaDataType* _tmp725_;
						ValaDataType* _tmp726_;
						gboolean _tmp727_;
						gboolean _tmp728_;
						_tmp723_ = vala_assignment_get_left (self);
						_tmp724_ = _tmp723_;
						_tmp725_ = vala_expression_get_value_type (_tmp724_);
						_tmp726_ = _tmp725_;
						_tmp727_ = vala_data_type_get_value_owned (_tmp726_);
						_tmp728_ = _tmp727_;
						if (_tmp728_) {
						}
					}
				}
			}
			_tmp729_ = vala_assignment_get_right (self);
			_tmp730_ = _tmp729_;
			_tmp731_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp730_) ? ((ValaMemberAccess*) _tmp730_) : NULL);
			right_ma = _tmp731_;
			_tmp733_ = right_ma;
			if (_tmp733_ != NULL) {
				ValaMemberAccess* _tmp734_;
				ValaSymbol* _tmp735_;
				ValaSymbol* _tmp736_;
				ValaMemberAccess* _tmp737_;
				ValaSymbol* _tmp738_;
				ValaSymbol* _tmp739_;
				_tmp734_ = ma;
				_tmp735_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp734_);
				_tmp736_ = _tmp735_;
				_tmp737_ = right_ma;
				_tmp738_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp737_);
				_tmp739_ = _tmp738_;
				_tmp732_ = _tmp736_ == _tmp739_;
			} else {
				_tmp732_ = FALSE;
			}
			if (_tmp732_) {
				gboolean _tmp740_ = FALSE;
				ValaMemberAccess* _tmp741_;
				ValaSymbol* _tmp742_;
				ValaSymbol* _tmp743_;
				_tmp741_ = ma;
				_tmp742_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp741_);
				_tmp743_ = _tmp742_;
				if (VALA_IS_LOCAL_VARIABLE (_tmp743_)) {
					_tmp740_ = TRUE;
				} else {
					ValaMemberAccess* _tmp744_;
					ValaSymbol* _tmp745_;
					ValaSymbol* _tmp746_;
					_tmp744_ = ma;
					_tmp745_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp744_);
					_tmp746_ = _tmp745_;
					_tmp740_ = VALA_IS_PARAMETER (_tmp746_);
				}
				if (_tmp740_) {
					ValaSourceReference* _tmp747_;
					ValaSourceReference* _tmp748_;
					_tmp747_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp748_ = _tmp747_;
					vala_report_warning (_tmp748_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp749_;
					ValaSymbol* _tmp750_;
					ValaSymbol* _tmp751_;
					_tmp749_ = ma;
					_tmp750_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp749_);
					_tmp751_ = _tmp750_;
					if (VALA_IS_FIELD (_tmp751_)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp752_;
						ValaSymbol* _tmp753_;
						ValaSymbol* _tmp754_;
						ValaField* _tmp755_;
						ValaField* _tmp756_;
						ValaMemberBinding _tmp757_;
						ValaMemberBinding _tmp758_;
						_tmp752_ = ma;
						_tmp753_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp752_);
						_tmp754_ = _tmp753_;
						_tmp755_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp754_, VALA_TYPE_FIELD, ValaField));
						f = _tmp755_;
						_tmp756_ = f;
						_tmp757_ = vala_field_get_binding (_tmp756_);
						_tmp758_ = _tmp757_;
						if (_tmp758_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp759_;
							ValaSourceReference* _tmp760_;
							_tmp759_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp760_ = _tmp759_;
							vala_report_warning (_tmp760_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp761_;
							ValaExpression* _tmp762_;
							ValaExpression* _tmp763_;
							ValaMemberAccess* _tmp764_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp765_;
							ValaExpression* _tmp766_;
							ValaExpression* _tmp767_;
							ValaMemberAccess* _tmp768_;
							gboolean _tmp769_ = FALSE;
							gboolean _tmp770_ = FALSE;
							gboolean _tmp771_ = FALSE;
							gboolean _tmp772_ = FALSE;
							gboolean _tmp773_ = FALSE;
							ValaMemberAccess* _tmp774_;
							_tmp761_ = ma;
							_tmp762_ = vala_member_access_get_inner (_tmp761_);
							_tmp763_ = _tmp762_;
							_tmp764_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp763_) ? ((ValaMemberAccess*) _tmp763_) : NULL);
							ma_inner = _tmp764_;
							_tmp765_ = right_ma;
							_tmp766_ = vala_member_access_get_inner (_tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp767_) ? ((ValaMemberAccess*) _tmp767_) : NULL);
							right_ma_inner = _tmp768_;
							_tmp774_ = ma_inner;
							if (_tmp774_ != NULL) {
								ValaMemberAccess* _tmp775_;
								const gchar* _tmp776_;
								const gchar* _tmp777_;
								_tmp775_ = ma_inner;
								_tmp776_ = vala_member_access_get_member_name (_tmp775_);
								_tmp777_ = _tmp776_;
								_tmp773_ = g_strcmp0 (_tmp777_, "this") == 0;
							} else {
								_tmp773_ = FALSE;
							}
							if (_tmp773_) {
								ValaMemberAccess* _tmp778_;
								ValaExpression* _tmp779_;
								ValaExpression* _tmp780_;
								_tmp778_ = ma_inner;
								_tmp779_ = vala_member_access_get_inner (_tmp778_);
								_tmp780_ = _tmp779_;
								_tmp772_ = _tmp780_ == NULL;
							} else {
								_tmp772_ = FALSE;
							}
							if (_tmp772_) {
								ValaMemberAccess* _tmp781_;
								_tmp781_ = right_ma_inner;
								_tmp771_ = _tmp781_ != NULL;
							} else {
								_tmp771_ = FALSE;
							}
							if (_tmp771_) {
								ValaMemberAccess* _tmp782_;
								const gchar* _tmp783_;
								const gchar* _tmp784_;
								_tmp782_ = right_ma_inner;
								_tmp783_ = vala_member_access_get_member_name (_tmp782_);
								_tmp784_ = _tmp783_;
								_tmp770_ = g_strcmp0 (_tmp784_, "this") == 0;
							} else {
								_tmp770_ = FALSE;
							}
							if (_tmp770_) {
								ValaMemberAccess* _tmp785_;
								ValaExpression* _tmp786_;
								ValaExpression* _tmp787_;
								_tmp785_ = right_ma_inner;
								_tmp786_ = vala_member_access_get_inner (_tmp785_);
								_tmp787_ = _tmp786_;
								_tmp769_ = _tmp787_ == NULL;
							} else {
								_tmp769_ = FALSE;
							}
							if (_tmp769_) {
								ValaSourceReference* _tmp788_;
								ValaSourceReference* _tmp789_;
								_tmp788_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp789_ = _tmp788_;
								vala_report_warning (_tmp789_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp790_;
			ValaExpression* _tmp791_;
			_tmp790_ = vala_assignment_get_left (self);
			_tmp791_ = _tmp790_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp791_)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp792_;
				ValaExpression* _tmp793_;
				ValaElementAccess* _tmp794_;
				ValaExpression* _tmp795_;
				ValaExpression* _tmp796_;
				ValaDataType* _tmp797_;
				ValaDataType* _tmp798_;
				ValaExpression* _tmp799_;
				ValaExpression* _tmp800_;
				ValaDataType* _tmp801_;
				ValaDataType* _tmp802_;
				ValaExpression* _tmp819_;
				ValaExpression* _tmp820_;
				ValaDataType* _tmp821_;
				ValaDataType* _tmp822_;
				_tmp792_ = vala_assignment_get_left (self);
				_tmp793_ = _tmp792_;
				_tmp794_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp793_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp794_;
				_tmp795_ = vala_assignment_get_right (self);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_expression_get_value_type (_tmp796_);
				_tmp798_ = _tmp797_;
				_tmp799_ = vala_assignment_get_left (self);
				_tmp800_ = _tmp799_;
				_tmp801_ = vala_expression_get_value_type (_tmp800_);
				_tmp802_ = _tmp801_;
				if (!vala_data_type_compatible (_tmp798_, _tmp802_)) {
					ValaSourceReference* _tmp803_;
					ValaSourceReference* _tmp804_;
					ValaExpression* _tmp805_;
					ValaExpression* _tmp806_;
					ValaDataType* _tmp807_;
					ValaDataType* _tmp808_;
					gchar* _tmp809_;
					gchar* _tmp810_;
					ValaExpression* _tmp811_;
					ValaExpression* _tmp812_;
					ValaDataType* _tmp813_;
					ValaDataType* _tmp814_;
					gchar* _tmp815_;
					gchar* _tmp816_;
					gchar* _tmp817_;
					gchar* _tmp818_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp803_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp804_ = _tmp803_;
					_tmp805_ = vala_assignment_get_right (self);
					_tmp806_ = _tmp805_;
					_tmp807_ = vala_expression_get_value_type (_tmp806_);
					_tmp808_ = _tmp807_;
					_tmp809_ = vala_code_node_to_string ((ValaCodeNode*) _tmp808_);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_assignment_get_left (self);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_expression_get_value_type (_tmp812_);
					_tmp814_ = _tmp813_;
					_tmp815_ = vala_code_node_to_string ((ValaCodeNode*) _tmp814_);
					_tmp816_ = _tmp815_;
					_tmp817_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp810_, _tmp816_);
					_tmp818_ = _tmp817_;
					vala_report_error (_tmp804_, _tmp818_);
					_g_free0 (_tmp818_);
					_g_free0 (_tmp816_);
					_g_free0 (_tmp810_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp819_ = vala_assignment_get_right (self);
				_tmp820_ = _tmp819_;
				_tmp821_ = vala_expression_get_value_type (_tmp820_);
				_tmp822_ = _tmp821_;
				if (vala_data_type_is_disposable (_tmp822_)) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp823_;
					ValaExpression* _tmp824_;
					ValaExpression* _tmp825_;
					ValaDataType* _tmp826_;
					ValaDataType* _tmp827_;
					gboolean _tmp849_ = FALSE;
					ValaDataType* _tmp850_;
					_tmp823_ = ea;
					_tmp824_ = vala_element_access_get_container (_tmp823_);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_expression_get_value_type (_tmp825_);
					_tmp827_ = _tmp826_;
					if (VALA_IS_ARRAY_TYPE (_tmp827_)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp828_;
						ValaExpression* _tmp829_;
						ValaExpression* _tmp830_;
						ValaDataType* _tmp831_;
						ValaDataType* _tmp832_;
						ValaArrayType* _tmp833_;
						ValaArrayType* _tmp834_;
						ValaDataType* _tmp835_;
						ValaDataType* _tmp836_;
						ValaDataType* _tmp837_;
						_tmp828_ = ea;
						_tmp829_ = vala_element_access_get_container (_tmp828_);
						_tmp830_ = _tmp829_;
						_tmp831_ = vala_expression_get_value_type (_tmp830_);
						_tmp832_ = _tmp831_;
						_tmp833_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp832_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp833_;
						_tmp834_ = array_type;
						_tmp835_ = vala_array_type_get_element_type (_tmp834_);
						_tmp836_ = _tmp835_;
						_tmp837_ = _vala_code_node_ref0 (_tmp836_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp837_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp838_;
						ValaExpression* _tmp839_;
						ValaExpression* _tmp840_;
						ValaDataType* _tmp841_;
						ValaDataType* _tmp842_;
						ValaList* _tmp843_;
						ValaList* _tmp844_;
						gint _tmp845_;
						gint _tmp846_;
						ValaList* _tmp847_;
						gpointer _tmp848_;
						_tmp838_ = ea;
						_tmp839_ = vala_element_access_get_container (_tmp838_);
						_tmp840_ = _tmp839_;
						_tmp841_ = vala_expression_get_value_type (_tmp840_);
						_tmp842_ = _tmp841_;
						_tmp843_ = vala_data_type_get_type_arguments (_tmp842_);
						args = _tmp843_;
						_tmp844_ = args;
						_tmp845_ = vala_collection_get_size ((ValaCollection*) _tmp844_);
						_tmp846_ = _tmp845_;
						_vala_assert (_tmp846_ == 1, "args.size == 1");
						_tmp847_ = args;
						_tmp848_ = vala_list_get (_tmp847_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp848_;
						_vala_iterable_unref0 (args);
					}
					_tmp850_ = element_type;
					if (!VALA_IS_POINTER_TYPE (_tmp850_)) {
						ValaDataType* _tmp851_;
						gboolean _tmp852_;
						gboolean _tmp853_;
						_tmp851_ = element_type;
						_tmp852_ = vala_data_type_get_value_owned (_tmp851_);
						_tmp853_ = _tmp852_;
						_tmp849_ = !_tmp853_;
					} else {
						_tmp849_ = FALSE;
					}
					if (_tmp849_) {
						ValaSourceReference* _tmp854_;
						ValaSourceReference* _tmp855_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp854_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp855_ = _tmp854_;
						vala_report_error (_tmp855_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp856_;
					ValaExpression* _tmp857_;
					ValaDataType* _tmp858_;
					ValaDataType* _tmp859_;
					gboolean _tmp860_;
					gboolean _tmp861_;
					_tmp856_ = vala_assignment_get_left (self);
					_tmp857_ = _tmp856_;
					_tmp858_ = vala_expression_get_value_type (_tmp857_);
					_tmp859_ = _tmp858_;
					_tmp860_ = vala_data_type_get_value_owned (_tmp859_);
					_tmp861_ = _tmp860_;
					if (_tmp861_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp862_ = vala_assignment_get_left (self);
	_tmp863_ = _tmp862_;
	_tmp864_ = vala_expression_get_value_type (_tmp863_);
	_tmp865_ = _tmp864_;
	if (_tmp865_ != NULL) {
		ValaExpression* _tmp866_;
		ValaExpression* _tmp867_;
		ValaDataType* _tmp868_;
		ValaDataType* _tmp869_;
		ValaDataType* _tmp870_;
		ValaDataType* _tmp871_;
		ValaDataType* _tmp872_;
		ValaDataType* _tmp873_;
		_tmp866_ = vala_assignment_get_left (self);
		_tmp867_ = _tmp866_;
		_tmp868_ = vala_expression_get_value_type (_tmp867_);
		_tmp869_ = _tmp868_;
		_tmp870_ = vala_data_type_copy (_tmp869_);
		_tmp871_ = _tmp870_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp871_);
		_vala_code_node_unref0 (_tmp871_);
		_tmp872_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp873_ = _tmp872_;
		vala_data_type_set_value_owned (_tmp873_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp874_ = vala_assignment_get_left (self);
	_tmp875_ = _tmp874_;
	_tmp876_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp875_);
	_tmp877_ = _tmp876_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp877_);
	_vala_iterable_unref0 (_tmp877_);
	_tmp878_ = vala_assignment_get_right (self);
	_tmp879_ = _tmp878_;
	_tmp880_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp879_);
	_tmp881_ = _tmp880_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp881_);
	_vala_iterable_unref0 (_tmp881_);
	_tmp882_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp883_ = _tmp882_;
	result = !_tmp883_;
	return result;
}


static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = VALA_IS_ARRAY_TYPE (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp137_;
	ValaExpression* _tmp138_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_POINTER_INDIRECTION (_tmp7_) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp121_ = FALSE;
		gboolean _tmp122_ = FALSE;
		gboolean _tmp123_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp12_) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp16_) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp20_) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (VALA_IS_PROPERTY (_tmp24_) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp47_);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp54_);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			gboolean _tmp56_;
			ValaExpression* _tmp63_;
			ValaExpression* _tmp64_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaTargetValue* _tmp69_;
			ValaLocalVariable* _tmp70_;
			ValaCodeNode* _tmp96_;
			ValaCodeNode* _tmp97_;
			_tmp56_ = instance;
			if (_tmp56_) {
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp55_ = _tmp59_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp60_;
				ValaExpression* _tmp61_;
				ValaExpression* _tmp62_;
				_tmp60_ = ma;
				_tmp61_ = vala_member_access_get_inner (_tmp60_);
				_tmp62_ = _tmp61_;
				vala_code_node_emit ((ValaCodeNode*) _tmp62_, codegen);
			}
			_tmp63_ = vala_assignment_get_right (self);
			_tmp64_ = _tmp63_;
			vala_code_node_emit ((ValaCodeNode*) _tmp64_, codegen);
			_tmp65_ = vala_assignment_get_right (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_target_value (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _vala_target_value_ref0 (_tmp68_);
			new_value = _tmp69_;
			_tmp70_ = local;
			if (_tmp70_ != NULL) {
				ValaLocalVariable* _tmp71_;
				ValaTargetValue* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				_tmp71_ = local;
				_tmp72_ = new_value;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				vala_code_generator_store_local (codegen, _tmp71_, _tmp72_, FALSE, _tmp74_);
			} else {
				ValaParameter* _tmp75_;
				_tmp75_ = param;
				if (_tmp75_ != NULL) {
					ValaParameter* _tmp76_;
					ValaTargetValue* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					_tmp76_ = param;
					_tmp77_ = new_value;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp79_ = _tmp78_;
					vala_code_generator_store_parameter (codegen, _tmp76_, _tmp77_, FALSE, _tmp79_);
				} else {
					ValaField* _tmp80_;
					_tmp80_ = field;
					if (_tmp80_ != NULL) {
						ValaTargetValue* _tmp81_ = NULL;
						gboolean _tmp82_ = FALSE;
						gboolean _tmp83_;
						ValaField* _tmp92_;
						ValaTargetValue* _tmp93_;
						ValaSourceReference* _tmp94_;
						ValaSourceReference* _tmp95_;
						_tmp83_ = instance;
						if (_tmp83_) {
							ValaMemberAccess* _tmp84_;
							ValaExpression* _tmp85_;
							ValaExpression* _tmp86_;
							_tmp84_ = ma;
							_tmp85_ = vala_member_access_get_inner (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp82_ = _tmp86_ != NULL;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							ValaMemberAccess* _tmp87_;
							ValaExpression* _tmp88_;
							ValaExpression* _tmp89_;
							ValaTargetValue* _tmp90_;
							ValaTargetValue* _tmp91_;
							_tmp87_ = ma;
							_tmp88_ = vala_member_access_get_inner (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_expression_get_target_value (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp81_ = _tmp91_;
						} else {
							_tmp81_ = NULL;
						}
						_tmp92_ = field;
						_tmp93_ = new_value;
						_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp95_ = _tmp94_;
						vala_code_generator_store_field (codegen, _tmp92_, _tmp81_, _tmp93_, _tmp95_);
					}
				}
			}
			_tmp96_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp97_ = _tmp96_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp97_)) {
				ValaLocalVariable* _tmp98_;
				_tmp98_ = local;
				if (_tmp98_ != NULL) {
					ValaLocalVariable* _tmp99_;
					ValaTargetValue* _tmp100_;
					ValaTargetValue* _tmp101_;
					_tmp99_ = local;
					_tmp100_ = vala_code_generator_load_local (codegen, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp101_);
					_vala_target_value_unref0 (_tmp101_);
				} else {
					ValaParameter* _tmp102_;
					_tmp102_ = param;
					if (_tmp102_ != NULL) {
						ValaParameter* _tmp103_;
						ValaTargetValue* _tmp104_;
						ValaTargetValue* _tmp105_;
						_tmp103_ = param;
						_tmp104_ = vala_code_generator_load_parameter (codegen, _tmp103_);
						_tmp105_ = _tmp104_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp105_);
						_vala_target_value_unref0 (_tmp105_);
					} else {
						ValaField* _tmp106_;
						_tmp106_ = field;
						if (_tmp106_ != NULL) {
							ValaTargetValue* _tmp107_ = NULL;
							gboolean _tmp108_ = FALSE;
							gboolean _tmp109_;
							ValaField* _tmp118_;
							ValaTargetValue* _tmp119_;
							ValaTargetValue* _tmp120_;
							_tmp109_ = instance;
							if (_tmp109_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp108_ = _tmp112_ != NULL;
							} else {
								_tmp108_ = FALSE;
							}
							if (_tmp108_) {
								ValaMemberAccess* _tmp113_;
								ValaExpression* _tmp114_;
								ValaExpression* _tmp115_;
								ValaTargetValue* _tmp116_;
								ValaTargetValue* _tmp117_;
								_tmp113_ = ma;
								_tmp114_ = vala_member_access_get_inner (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp116_ = vala_expression_get_target_value (_tmp115_);
								_tmp117_ = _tmp116_;
								_tmp107_ = _tmp117_;
							} else {
								_tmp107_ = NULL;
							}
							_tmp118_ = field;
							_tmp119_ = vala_code_generator_load_field (codegen, _tmp118_, _tmp107_);
							_tmp120_ = _tmp119_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp120_);
							_vala_target_value_unref0 (_tmp120_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp123_ = instance;
		if (_tmp123_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp122_ = _tmp126_ != NULL;
		} else {
			_tmp122_ = FALSE;
		}
		if (_tmp122_) {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			_tmp121_ = _tmp127_ != NULL;
		} else {
			_tmp121_ = FALSE;
		}
		if (_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_member_access_get_inner (_tmp128_);
			_tmp130_ = _tmp129_;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaProperty* _tmp131_;
			_tmp131_ = property;
			if (_tmp131_ == NULL) {
				ValaMemberAccess* _tmp132_;
				_tmp132_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp132_, codegen);
			}
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp133_;
		_tmp133_ = ea;
		if (_tmp133_ != NULL) {
			ValaElementAccess* _tmp134_;
			_tmp134_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp134_, codegen);
		} else {
			ValaPointerIndirection* _tmp135_;
			_tmp135_ = pi;
			if (_tmp135_ != NULL) {
				ValaPointerIndirection* _tmp136_;
				_tmp136_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp136_, codegen);
			}
		}
	}
	_tmp137_ = vala_assignment_get_right (self);
	_tmp138_ = _tmp137_;
	vala_code_node_emit ((ValaCodeNode*) _tmp138_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (VALA_IS_ELEMENT_ACCESS (_tmp4_) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_assignment_class_init (ValaAssignmentClass * klass)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void
vala_assignment_instance_init (ValaAssignment * self)
{
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



