/* valaccodeattribute.c generated by valac, the Vala compiler
 * generated from valaccodeattribute.vala, do not modify */

/* valaccodeattribute.vala
 *
 * Copyright (C) 2011  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lucabru@src.gnome.org>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCCodeAttributePrivate {
	ValaCodeNode* node;
	ValaSymbol* sym;
	ValaAttribute* ccode;
	gchar* _array_length_type;
	gchar* _array_length_name;
	gchar* _array_length_expr;
	gboolean _delegate_target;
	gchar* _sentinel;
	gchar* _name;
	gchar* _const_name;
	gchar* _type_name;
	gchar* _feature_test_macros;
	gchar* _header_filenames;
	gchar* _prefix;
	gchar* _lower_case_prefix;
	gchar* _lower_case_suffix;
	gchar* _ref_function;
	gboolean ref_function_set;
	gboolean* _ref_function_void;
	gchar* _unref_function;
	gboolean unref_function_set;
	gchar* _ref_sink_function;
	gchar* _copy_function;
	gboolean copy_function_set;
	gchar* _destroy_function;
	gboolean destroy_function_set;
	gchar* _dup_function;
	gboolean dup_function_set;
	gchar* _free_function;
	gboolean free_function_set;
	gboolean* _free_function_address_of;
	gchar* _type_id;
	gchar* _marshaller_type_name;
	gchar* _get_value_function;
	gchar* _set_value_function;
	gchar* _take_value_function;
	gchar* _param_spec_function;
	gchar* _default_value;
	gchar* _default_value_on_error;
	gdouble* _pos;
	gchar* _vfunc_name;
	gchar* _finish_name;
	gchar* _finish_vfunc_name;
	gchar* _finish_real_name;
	gboolean* _finish_instance;
	gchar* _real_name;
	gchar* _delegate_target_name;
	gchar* _ctype;
	gboolean ctype_set;
	gboolean* _array_length;
	gboolean* _array_null_terminated;
};


static gint ValaCCodeAttribute_private_offset;
static gpointer vala_ccode_attribute_parent_class = NULL;
static gint vala_ccode_attribute_dynamic_method_id;
static gint vala_ccode_attribute_dynamic_method_id = 0;

static void vala_ccode_attribute_set_delegate_target (ValaCCodeAttribute* self,
                                               gboolean value);
static void vala_ccode_attribute_set_array_length_type (ValaCCodeAttribute* self,
                                                 const gchar* value);
static void vala_ccode_attribute_set_array_length_name (ValaCCodeAttribute* self,
                                                 const gchar* value);
static void vala_ccode_attribute_set_array_length_expr (ValaCCodeAttribute* self,
                                                 const gchar* value);
static gdouble* _double_dup (gdouble* self);
static void vala_ccode_attribute_set_sentinel (ValaCCodeAttribute* self,
                                        const gchar* value);
static gchar* vala_ccode_attribute_get_default_name (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_header_filenames (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_prefix (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_lower_case_prefix (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_lower_case_suffix (ValaCCodeAttribute* self);
G_GNUC_INTERNAL ValaCCodeAttribute* vala_get_ccode_attribute (ValaCodeNode* node);
static gchar* vala_ccode_attribute_get_default_ref_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_unref_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_ref_sink_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_free_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_type_id (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_marshaller_type_name (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_get_value_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_set_value_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_take_value_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_param_spec_function (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_default_value (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_finish_name_for_basename (ValaCCodeAttribute* self,
                                                          const gchar* basename);
static gchar* vala_ccode_attribute_get_default_real_name (ValaCCodeAttribute* self);
static gchar* vala_ccode_attribute_get_default_const_name (ValaCCodeAttribute* self);
static gboolean vala_ccode_attribute_get_default_array_length (ValaCCodeAttribute* self);
static gboolean vala_ccode_attribute_get_default_array_null_terminated (ValaCCodeAttribute* self);
static gboolean* _bool_dup (gboolean* self);
static void vala_ccode_attribute_finalize (ValaAttributeCache * obj);


static inline gpointer
vala_ccode_attribute_get_instance_private (ValaCCodeAttribute* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeAttribute_private_offset);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}


static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}


ValaCCodeAttribute*
vala_ccode_attribute_construct (GType object_type,
                                ValaCodeNode* node)
{
	ValaCCodeAttribute* self = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	const gchar* _tmp20_;
	g_return_val_if_fail (node != NULL, NULL);
	self = (ValaCCodeAttribute*) vala_attribute_cache_construct (object_type);
	self->priv->node = node;
	self->priv->sym = G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) node) : NULL;
	vala_ccode_attribute_set_delegate_target (self, TRUE);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->ccode);
	self->priv->ccode = _tmp1_;
	_tmp2_ = self->priv->ccode;
	if (_tmp2_ != NULL) {
		ValaAttribute* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaAttribute* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		ValaAttribute* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValaAttribute* _tmp12_;
		ValaAttribute* _tmp16_;
		ValaAttribute* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp3_ = self->priv->ccode;
		_tmp4_ = vala_attribute_get_string (_tmp3_, "array_length_type", NULL);
		_tmp5_ = _tmp4_;
		vala_ccode_attribute_set_array_length_type (self, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->ccode;
		_tmp7_ = vala_attribute_get_string (_tmp6_, "array_length_cname", NULL);
		_tmp8_ = _tmp7_;
		vala_ccode_attribute_set_array_length_name (self, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = self->priv->ccode;
		_tmp10_ = vala_attribute_get_string (_tmp9_, "array_length_cexpr", NULL);
		_tmp11_ = _tmp10_;
		vala_ccode_attribute_set_array_length_expr (self, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->ccode;
		if (vala_attribute_has_argument (_tmp12_, "pos")) {
			ValaAttribute* _tmp13_;
			gdouble _tmp14_;
			gdouble* _tmp15_;
			_tmp13_ = self->priv->ccode;
			_tmp14_ = vala_attribute_get_double (_tmp13_, "pos", (gdouble) 0);
			_tmp15_ = __double_dup0 (&_tmp14_);
			_g_free0 (self->priv->_pos);
			self->priv->_pos = _tmp15_;
		}
		_tmp16_ = self->priv->ccode;
		vala_ccode_attribute_set_delegate_target (self, vala_attribute_get_bool (_tmp16_, "delegate_target", TRUE));
		_tmp17_ = self->priv->ccode;
		_tmp18_ = vala_attribute_get_string (_tmp17_, "sentinel", NULL);
		_tmp19_ = _tmp18_;
		vala_ccode_attribute_set_sentinel (self, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->_sentinel;
	if (_tmp20_ == NULL) {
		vala_ccode_attribute_set_sentinel (self, "NULL");
	}
	return self;
}


ValaCCodeAttribute*
vala_ccode_attribute_new (ValaCodeNode* node)
{
	return vala_ccode_attribute_construct (VALA_TYPE_CCODE_ATTRIBUTE, node);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
vala_ccode_attribute_get_default_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		ValaSymbol* _tmp2_;
		_tmp2_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CONSTANT)) {
			ValaSymbol* _tmp3_;
			_tmp3_ = self->priv->sym;
			_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_ENUM_VALUE);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaSymbol* _tmp4_;
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			ValaSymbol* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp4_ = self->priv->sym;
			_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
			_tmp6_ = _tmp5_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_BLOCK)) {
				ValaSymbol* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp7_ = self->priv->sym;
				_tmp8_ = vala_symbol_get_name (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				result = _tmp10_;
				return result;
			}
			_tmp11_ = self->priv->sym;
			_tmp12_ = vala_symbol_get_parent_symbol (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_get_ccode_lower_case_prefix (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_ascii_strup (_tmp15_, (gssize) -1);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->sym;
			_tmp19_ = vala_symbol_get_name (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf ("%s%s", _tmp17_, _tmp20_);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			result = _tmp22_;
			return result;
		} else {
			ValaSymbol* _tmp23_;
			_tmp23_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_FIELD)) {
				gchar* cname = NULL;
				ValaSymbol* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaMemberBinding _tmp29_;
				ValaMemberBinding _tmp30_;
				const gchar* _tmp40_;
				_tmp24_ = self->priv->sym;
				_tmp25_ = vala_symbol_get_name (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strdup (_tmp26_);
				cname = _tmp27_;
				_tmp28_ = self->priv->sym;
				_tmp29_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_FIELD, ValaField));
				_tmp30_ = _tmp29_;
				if (_tmp30_ == VALA_MEMBER_BINDING_STATIC) {
					ValaSymbol* _tmp31_;
					ValaSymbol* _tmp32_;
					ValaSymbol* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					ValaSymbol* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp31_ = self->priv->sym;
					_tmp32_ = vala_symbol_get_parent_symbol (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_get_ccode_lower_case_prefix (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = self->priv->sym;
					_tmp37_ = vala_symbol_get_name (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strdup_printf ("%s%s", _tmp35_, _tmp38_);
					_g_free0 (cname);
					cname = _tmp39_;
					_g_free0 (_tmp35_);
				}
				_tmp40_ = cname;
				if (g_ascii_isdigit (string_get (_tmp40_, (glong) 0))) {
					ValaCodeNode* _tmp41_;
					ValaSourceReference* _tmp42_;
					ValaSourceReference* _tmp43_;
					gchar* _tmp44_;
					_tmp41_ = self->priv->node;
					_tmp42_ = vala_code_node_get_source_reference (_tmp41_);
					_tmp43_ = _tmp42_;
					vala_report_error (_tmp43_, "Field name starts with a digit. Use the `cname' attribute to provide a" \
" valid C name if intended");
					_tmp44_ = g_strdup ("");
					result = _tmp44_;
					_g_free0 (cname);
					return result;
				}
				result = cname;
				return result;
			} else {
				ValaSymbol* _tmp45_;
				_tmp45_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, VALA_TYPE_CREATION_METHOD)) {
					ValaCreationMethod* m = NULL;
					ValaSymbol* _tmp46_;
					gchar* infix = NULL;
					ValaCreationMethod* _tmp47_;
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					ValaCreationMethod* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					_tmp46_ = self->priv->sym;
					m = G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
					_tmp47_ = m;
					_tmp48_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp47_);
					_tmp49_ = _tmp48_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, VALA_TYPE_STRUCT)) {
						gchar* _tmp50_;
						_tmp50_ = g_strdup ("init");
						_g_free0 (infix);
						infix = _tmp50_;
					} else {
						gchar* _tmp51_;
						_tmp51_ = g_strdup ("new");
						_g_free0 (infix);
						infix = _tmp51_;
					}
					_tmp52_ = m;
					_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
					_tmp54_ = _tmp53_;
					if (g_strcmp0 (_tmp54_, ".new") == 0) {
						ValaCreationMethod* _tmp55_;
						ValaSymbol* _tmp56_;
						ValaSymbol* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						const gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						_tmp55_ = m;
						_tmp56_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = vala_get_ccode_lower_case_prefix (_tmp57_);
						_tmp59_ = _tmp58_;
						_tmp60_ = infix;
						_tmp61_ = g_strdup_printf ("%s%s", _tmp59_, _tmp60_);
						_tmp62_ = _tmp61_;
						_g_free0 (_tmp59_);
						result = _tmp62_;
						_g_free0 (infix);
						return result;
					} else {
						ValaCreationMethod* _tmp63_;
						ValaSymbol* _tmp64_;
						ValaSymbol* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						const gchar* _tmp68_;
						ValaCreationMethod* _tmp69_;
						const gchar* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						_tmp63_ = m;
						_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = vala_get_ccode_lower_case_prefix (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = infix;
						_tmp69_ = m;
						_tmp70_ = vala_symbol_get_name ((ValaSymbol*) _tmp69_);
						_tmp71_ = _tmp70_;
						_tmp72_ = g_strdup_printf ("%s%s_%s", _tmp67_, _tmp68_, _tmp71_);
						_tmp73_ = _tmp72_;
						_g_free0 (_tmp67_);
						result = _tmp73_;
						_g_free0 (infix);
						return result;
					}
					_g_free0 (infix);
				} else {
					ValaSymbol* _tmp74_;
					_tmp74_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_DYNAMIC_METHOD)) {
						ValaSymbol* _tmp75_;
						const gchar* _tmp76_;
						const gchar* _tmp77_;
						gint _tmp78_;
						gchar* _tmp79_;
						_tmp75_ = self->priv->sym;
						_tmp76_ = vala_symbol_get_name (_tmp75_);
						_tmp77_ = _tmp76_;
						_tmp78_ = vala_ccode_attribute_dynamic_method_id;
						vala_ccode_attribute_dynamic_method_id = _tmp78_ + 1;
						_tmp79_ = g_strdup_printf ("_dynamic_%s%d", _tmp77_, _tmp78_);
						result = _tmp79_;
						return result;
					} else {
						ValaSymbol* _tmp80_;
						_tmp80_ = self->priv->sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_METHOD)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp81_;
							ValaMethod* _tmp82_;
							gboolean _tmp83_;
							gboolean _tmp84_;
							ValaMethod* _tmp92_;
							ValaSignal* _tmp93_;
							ValaSignal* _tmp94_;
							gboolean _tmp107_ = FALSE;
							ValaSymbol* _tmp108_;
							const gchar* _tmp109_;
							const gchar* _tmp110_;
							_tmp81_ = self->priv->sym;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_METHOD, ValaMethod);
							_tmp82_ = m;
							_tmp83_ = vala_method_get_is_async_callback (_tmp82_);
							_tmp84_ = _tmp83_;
							if (_tmp84_) {
								ValaMethod* _tmp85_;
								ValaSymbol* _tmp86_;
								ValaSymbol* _tmp87_;
								gchar* _tmp88_;
								gchar* _tmp89_;
								gchar* _tmp90_;
								gchar* _tmp91_;
								_tmp85_ = m;
								_tmp86_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = vala_get_ccode_real_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod));
								_tmp89_ = _tmp88_;
								_tmp90_ = g_strdup_printf ("%s_co", _tmp89_);
								_tmp91_ = _tmp90_;
								_g_free0 (_tmp89_);
								result = _tmp91_;
								return result;
							}
							_tmp92_ = m;
							_tmp93_ = vala_method_get_signal_reference (_tmp92_);
							_tmp94_ = _tmp93_;
							if (_tmp94_ != NULL) {
								ValaMethod* _tmp95_;
								ValaSymbol* _tmp96_;
								ValaSymbol* _tmp97_;
								gchar* _tmp98_;
								gchar* _tmp99_;
								ValaMethod* _tmp100_;
								ValaSignal* _tmp101_;
								ValaSignal* _tmp102_;
								gchar* _tmp103_;
								gchar* _tmp104_;
								gchar* _tmp105_;
								gchar* _tmp106_;
								_tmp95_ = m;
								_tmp96_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp95_);
								_tmp97_ = _tmp96_;
								_tmp98_ = vala_get_ccode_lower_case_prefix (_tmp97_);
								_tmp99_ = _tmp98_;
								_tmp100_ = m;
								_tmp101_ = vala_method_get_signal_reference (_tmp100_);
								_tmp102_ = _tmp101_;
								_tmp103_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp102_, NULL);
								_tmp104_ = _tmp103_;
								_tmp105_ = g_strdup_printf ("%s%s", _tmp99_, _tmp104_);
								_tmp106_ = _tmp105_;
								_g_free0 (_tmp104_);
								_g_free0 (_tmp99_);
								result = _tmp106_;
								return result;
							}
							_tmp108_ = self->priv->sym;
							_tmp109_ = vala_symbol_get_name (_tmp108_);
							_tmp110_ = _tmp109_;
							if (g_strcmp0 (_tmp110_, "main") == 0) {
								ValaSymbol* _tmp111_;
								ValaSymbol* _tmp112_;
								ValaSymbol* _tmp113_;
								const gchar* _tmp114_;
								const gchar* _tmp115_;
								_tmp111_ = self->priv->sym;
								_tmp112_ = vala_symbol_get_parent_symbol (_tmp111_);
								_tmp113_ = _tmp112_;
								_tmp114_ = vala_symbol_get_name (_tmp113_);
								_tmp115_ = _tmp114_;
								_tmp107_ = _tmp115_ == NULL;
							} else {
								_tmp107_ = FALSE;
							}
							if (_tmp107_) {
								gchar* _tmp116_;
								_tmp116_ = g_strdup ("_vala_main");
								result = _tmp116_;
								return result;
							} else {
								ValaSymbol* _tmp117_;
								const gchar* _tmp118_;
								const gchar* _tmp119_;
								_tmp117_ = self->priv->sym;
								_tmp118_ = vala_symbol_get_name (_tmp117_);
								_tmp119_ = _tmp118_;
								if (g_str_has_prefix (_tmp119_, "_")) {
									ValaSymbol* _tmp120_;
									ValaSymbol* _tmp121_;
									ValaSymbol* _tmp122_;
									gchar* _tmp123_;
									gchar* _tmp124_;
									ValaSymbol* _tmp125_;
									const gchar* _tmp126_;
									const gchar* _tmp127_;
									gchar* _tmp128_;
									gchar* _tmp129_;
									gchar* _tmp130_;
									gchar* _tmp131_;
									_tmp120_ = self->priv->sym;
									_tmp121_ = vala_symbol_get_parent_symbol (_tmp120_);
									_tmp122_ = _tmp121_;
									_tmp123_ = vala_get_ccode_lower_case_prefix (_tmp122_);
									_tmp124_ = _tmp123_;
									_tmp125_ = self->priv->sym;
									_tmp126_ = vala_symbol_get_name (_tmp125_);
									_tmp127_ = _tmp126_;
									_tmp128_ = string_substring (_tmp127_, (glong) 1, (glong) -1);
									_tmp129_ = _tmp128_;
									_tmp130_ = g_strdup_printf ("_%s%s", _tmp124_, _tmp129_);
									_tmp131_ = _tmp130_;
									_g_free0 (_tmp129_);
									_g_free0 (_tmp124_);
									result = _tmp131_;
									return result;
								} else {
									ValaSymbol* _tmp132_;
									ValaSymbol* _tmp133_;
									ValaSymbol* _tmp134_;
									gchar* _tmp135_;
									gchar* _tmp136_;
									ValaSymbol* _tmp137_;
									const gchar* _tmp138_;
									const gchar* _tmp139_;
									gchar* _tmp140_;
									gchar* _tmp141_;
									_tmp132_ = self->priv->sym;
									_tmp133_ = vala_symbol_get_parent_symbol (_tmp132_);
									_tmp134_ = _tmp133_;
									_tmp135_ = vala_get_ccode_lower_case_prefix (_tmp134_);
									_tmp136_ = _tmp135_;
									_tmp137_ = self->priv->sym;
									_tmp138_ = vala_symbol_get_name (_tmp137_);
									_tmp139_ = _tmp138_;
									_tmp140_ = g_strdup_printf ("%s%s", _tmp136_, _tmp139_);
									_tmp141_ = _tmp140_;
									_g_free0 (_tmp136_);
									result = _tmp141_;
									return result;
								}
							}
						} else {
							ValaSymbol* _tmp142_;
							_tmp142_ = self->priv->sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_PROPERTY_ACCESSOR)) {
								ValaPropertyAccessor* acc = NULL;
								ValaSymbol* _tmp143_;
								ValaTypeSymbol* t = NULL;
								ValaPropertyAccessor* _tmp144_;
								ValaProperty* _tmp145_;
								ValaProperty* _tmp146_;
								ValaSymbol* _tmp147_;
								ValaSymbol* _tmp148_;
								ValaTypeSymbol* _tmp149_;
								ValaPropertyAccessor* _tmp150_;
								gboolean _tmp151_;
								gboolean _tmp152_;
								_tmp143_ = self->priv->sym;
								acc = G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
								_tmp144_ = acc;
								_tmp145_ = vala_property_accessor_get_prop (_tmp144_);
								_tmp146_ = _tmp145_;
								_tmp147_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp146_);
								_tmp148_ = _tmp147_;
								_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
								t = _tmp149_;
								_tmp150_ = acc;
								_tmp151_ = vala_property_accessor_get_readable (_tmp150_);
								_tmp152_ = _tmp151_;
								if (_tmp152_) {
									ValaTypeSymbol* _tmp153_;
									gchar* _tmp154_;
									gchar* _tmp155_;
									ValaPropertyAccessor* _tmp156_;
									ValaProperty* _tmp157_;
									ValaProperty* _tmp158_;
									const gchar* _tmp159_;
									const gchar* _tmp160_;
									gchar* _tmp161_;
									gchar* _tmp162_;
									_tmp153_ = t;
									_tmp154_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp153_);
									_tmp155_ = _tmp154_;
									_tmp156_ = acc;
									_tmp157_ = vala_property_accessor_get_prop (_tmp156_);
									_tmp158_ = _tmp157_;
									_tmp159_ = vala_symbol_get_name ((ValaSymbol*) _tmp158_);
									_tmp160_ = _tmp159_;
									_tmp161_ = g_strdup_printf ("%sget_%s", _tmp155_, _tmp160_);
									_tmp162_ = _tmp161_;
									_g_free0 (_tmp155_);
									result = _tmp162_;
									_vala_code_node_unref0 (t);
									return result;
								} else {
									ValaTypeSymbol* _tmp163_;
									gchar* _tmp164_;
									gchar* _tmp165_;
									ValaPropertyAccessor* _tmp166_;
									ValaProperty* _tmp167_;
									ValaProperty* _tmp168_;
									const gchar* _tmp169_;
									const gchar* _tmp170_;
									gchar* _tmp171_;
									gchar* _tmp172_;
									_tmp163_ = t;
									_tmp164_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp163_);
									_tmp165_ = _tmp164_;
									_tmp166_ = acc;
									_tmp167_ = vala_property_accessor_get_prop (_tmp166_);
									_tmp168_ = _tmp167_;
									_tmp169_ = vala_symbol_get_name ((ValaSymbol*) _tmp168_);
									_tmp170_ = _tmp169_;
									_tmp171_ = g_strdup_printf ("%sset_%s", _tmp165_, _tmp170_);
									_tmp172_ = _tmp171_;
									_g_free0 (_tmp165_);
									result = _tmp172_;
									_vala_code_node_unref0 (t);
									return result;
								}
								_vala_code_node_unref0 (t);
							} else {
								ValaSymbol* _tmp173_;
								_tmp173_ = self->priv->sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp173_, VALA_TYPE_SIGNAL)) {
									ValaSymbol* _tmp174_;
									const gchar* _tmp175_;
									const gchar* _tmp176_;
									gchar* _tmp177_;
									gchar* _tmp178_;
									gchar* _tmp179_;
									gchar* _tmp180_;
									_tmp174_ = self->priv->sym;
									_tmp175_ = vala_symbol_get_name (_tmp174_);
									_tmp176_ = _tmp175_;
									_tmp177_ = vala_symbol_camel_case_to_lower_case (_tmp176_);
									_tmp178_ = _tmp177_;
									_tmp179_ = string_replace (_tmp178_, "_", "-");
									_tmp180_ = _tmp179_;
									_g_free0 (_tmp178_);
									result = _tmp180_;
									return result;
								} else {
									gboolean _tmp181_ = FALSE;
									ValaSymbol* _tmp182_;
									_tmp182_ = self->priv->sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, VALA_TYPE_LOCAL_VARIABLE)) {
										_tmp181_ = TRUE;
									} else {
										ValaSymbol* _tmp183_;
										_tmp183_ = self->priv->sym;
										_tmp181_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp183_, VALA_TYPE_PARAMETER);
									}
									if (_tmp181_) {
										ValaSymbol* _tmp184_;
										const gchar* _tmp185_;
										const gchar* _tmp186_;
										gchar* _tmp187_;
										_tmp184_ = self->priv->sym;
										_tmp185_ = vala_symbol_get_name (_tmp184_);
										_tmp186_ = _tmp185_;
										_tmp187_ = g_strdup (_tmp186_);
										result = _tmp187_;
										return result;
									} else {
										ValaSymbol* _tmp188_;
										ValaSymbol* _tmp189_;
										ValaSymbol* _tmp190_;
										gchar* _tmp191_;
										gchar* _tmp192_;
										ValaSymbol* _tmp193_;
										const gchar* _tmp194_;
										const gchar* _tmp195_;
										gchar* _tmp196_;
										gchar* _tmp197_;
										_tmp188_ = self->priv->sym;
										_tmp189_ = vala_symbol_get_parent_symbol (_tmp188_);
										_tmp190_ = _tmp189_;
										_tmp191_ = vala_get_ccode_prefix (_tmp190_);
										_tmp192_ = _tmp191_;
										_tmp193_ = self->priv->sym;
										_tmp194_ = vala_symbol_get_name (_tmp193_);
										_tmp195_ = _tmp194_;
										_tmp196_ = g_strdup_printf ("%s%s", _tmp192_, _tmp195_);
										_tmp197_ = _tmp196_;
										_g_free0 (_tmp192_);
										result = _tmp197_;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		ValaCodeNode* _tmp198_;
		_tmp198_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* type = NULL;
			ValaCodeNode* _tmp199_;
			ValaObjectType* _tmp200_;
			gchar* cname = NULL;
			ValaObjectType* _tmp201_;
			gboolean _tmp202_;
			gboolean _tmp203_;
			const gchar* _tmp212_;
			gchar* _tmp213_;
			_tmp199_ = self->priv->node;
			_tmp200_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			type = _tmp200_;
			_tmp201_ = type;
			_tmp202_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp201_);
			_tmp203_ = _tmp202_;
			if (!_tmp203_) {
				ValaObjectType* _tmp204_;
				ValaObjectTypeSymbol* _tmp205_;
				ValaObjectTypeSymbol* _tmp206_;
				gchar* _tmp207_;
				_tmp204_ = type;
				_tmp205_ = vala_object_type_get_type_symbol (_tmp204_);
				_tmp206_ = _tmp205_;
				_tmp207_ = vala_get_ccode_const_name ((ValaCodeNode*) _tmp206_);
				_g_free0 (cname);
				cname = _tmp207_;
			} else {
				ValaObjectType* _tmp208_;
				ValaObjectTypeSymbol* _tmp209_;
				ValaObjectTypeSymbol* _tmp210_;
				gchar* _tmp211_;
				_tmp208_ = type;
				_tmp209_ = vala_object_type_get_type_symbol (_tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_get_ccode_name ((ValaCodeNode*) _tmp210_);
				_g_free0 (cname);
				cname = _tmp211_;
			}
			_tmp212_ = cname;
			_tmp213_ = g_strdup_printf ("%s*", _tmp212_);
			result = _tmp213_;
			_g_free0 (cname);
			_vala_code_node_unref0 (type);
			return result;
		} else {
			ValaCodeNode* _tmp214_;
			_tmp214_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* type = NULL;
				ValaCodeNode* _tmp215_;
				ValaArrayType* _tmp216_;
				gchar* cname = NULL;
				ValaArrayType* _tmp217_;
				ValaDataType* _tmp218_;
				ValaDataType* _tmp219_;
				gchar* _tmp220_;
				ValaArrayType* _tmp221_;
				gboolean _tmp222_;
				gboolean _tmp223_;
				_tmp215_ = self->priv->node;
				_tmp216_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp215_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				type = _tmp216_;
				_tmp217_ = type;
				_tmp218_ = vala_array_type_get_element_type (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_get_ccode_name ((ValaCodeNode*) _tmp219_);
				cname = _tmp220_;
				_tmp221_ = type;
				_tmp222_ = vala_array_type_get_inline_allocated (_tmp221_);
				_tmp223_ = _tmp222_;
				if (_tmp223_) {
					result = cname;
					_vala_code_node_unref0 (type);
					return result;
				} else {
					const gchar* _tmp224_;
					gchar* _tmp225_;
					_tmp224_ = cname;
					_tmp225_ = g_strdup_printf ("%s*", _tmp224_);
					result = _tmp225_;
					_g_free0 (cname);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (cname);
				_vala_code_node_unref0 (type);
			} else {
				ValaCodeNode* _tmp226_;
				_tmp226_ = self->priv->node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp226_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* type = NULL;
					ValaCodeNode* _tmp227_;
					ValaDelegateType* _tmp228_;
					ValaDelegateType* _tmp229_;
					ValaDelegate* _tmp230_;
					ValaDelegate* _tmp231_;
					gchar* _tmp232_;
					_tmp227_ = self->priv->node;
					_tmp228_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp227_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					type = _tmp228_;
					_tmp229_ = type;
					_tmp230_ = vala_delegate_type_get_delegate_symbol (_tmp229_);
					_tmp231_ = _tmp230_;
					_tmp232_ = vala_get_ccode_name ((ValaCodeNode*) _tmp231_);
					result = _tmp232_;
					_vala_code_node_unref0 (type);
					return result;
				} else {
					ValaCodeNode* _tmp233_;
					_tmp233_ = self->priv->node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp233_, VALA_TYPE_ERROR_TYPE)) {
						gchar* _tmp234_;
						_tmp234_ = g_strdup ("GError*");
						result = _tmp234_;
						return result;
					} else {
						ValaCodeNode* _tmp235_;
						_tmp235_ = self->priv->node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp235_, VALA_TYPE_GENERIC_TYPE)) {
							ValaGenericType* type = NULL;
							ValaCodeNode* _tmp236_;
							ValaGenericType* _tmp237_;
							ValaGenericType* _tmp238_;
							gboolean _tmp239_;
							gboolean _tmp240_;
							_tmp236_ = self->priv->node;
							_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
							type = _tmp237_;
							_tmp238_ = type;
							_tmp239_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp238_);
							_tmp240_ = _tmp239_;
							if (_tmp240_) {
								ValaCodeContext* _tmp241_;
								ValaCodeContext* _tmp242_;
								ValaProfile _tmp243_;
								ValaProfile _tmp244_;
								gboolean _tmp245_;
								_tmp241_ = vala_code_context_get ();
								_tmp242_ = _tmp241_;
								_tmp243_ = vala_code_context_get_profile (_tmp242_);
								_tmp244_ = _tmp243_;
								_tmp245_ = _tmp244_ == VALA_PROFILE_GOBJECT;
								_vala_code_context_unref0 (_tmp242_);
								if (_tmp245_) {
									gchar* _tmp246_;
									_tmp246_ = g_strdup ("gpointer");
									result = _tmp246_;
									_vala_code_node_unref0 (type);
									return result;
								} else {
									gchar* _tmp247_;
									_tmp247_ = g_strdup ("void *");
									result = _tmp247_;
									_vala_code_node_unref0 (type);
									return result;
								}
							} else {
								ValaCodeContext* _tmp248_;
								ValaCodeContext* _tmp249_;
								ValaProfile _tmp250_;
								ValaProfile _tmp251_;
								gboolean _tmp252_;
								_tmp248_ = vala_code_context_get ();
								_tmp249_ = _tmp248_;
								_tmp250_ = vala_code_context_get_profile (_tmp249_);
								_tmp251_ = _tmp250_;
								_tmp252_ = _tmp251_ == VALA_PROFILE_GOBJECT;
								_vala_code_context_unref0 (_tmp249_);
								if (_tmp252_) {
									gchar* _tmp253_;
									_tmp253_ = g_strdup ("gconstpointer");
									result = _tmp253_;
									_vala_code_node_unref0 (type);
									return result;
								} else {
									gchar* _tmp254_;
									_tmp254_ = g_strdup ("const void *");
									result = _tmp254_;
									_vala_code_node_unref0 (type);
									return result;
								}
							}
							_vala_code_node_unref0 (type);
						} else {
							ValaCodeNode* _tmp255_;
							_tmp255_ = self->priv->node;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp255_, VALA_TYPE_METHOD_TYPE)) {
								ValaCodeContext* _tmp256_;
								ValaCodeContext* _tmp257_;
								ValaProfile _tmp258_;
								ValaProfile _tmp259_;
								gboolean _tmp260_;
								_tmp256_ = vala_code_context_get ();
								_tmp257_ = _tmp256_;
								_tmp258_ = vala_code_context_get_profile (_tmp257_);
								_tmp259_ = _tmp258_;
								_tmp260_ = _tmp259_ == VALA_PROFILE_GOBJECT;
								_vala_code_context_unref0 (_tmp257_);
								if (_tmp260_) {
									gchar* _tmp261_;
									_tmp261_ = g_strdup ("gpointer");
									result = _tmp261_;
									return result;
								} else {
									gchar* _tmp262_;
									_tmp262_ = g_strdup ("void *");
									result = _tmp262_;
									return result;
								}
							} else {
								ValaCodeNode* _tmp263_;
								_tmp263_ = self->priv->node;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp263_, VALA_TYPE_NULL_TYPE)) {
									ValaCodeContext* _tmp264_;
									ValaCodeContext* _tmp265_;
									ValaProfile _tmp266_;
									ValaProfile _tmp267_;
									gboolean _tmp268_;
									_tmp264_ = vala_code_context_get ();
									_tmp265_ = _tmp264_;
									_tmp266_ = vala_code_context_get_profile (_tmp265_);
									_tmp267_ = _tmp266_;
									_tmp268_ = _tmp267_ == VALA_PROFILE_GOBJECT;
									_vala_code_context_unref0 (_tmp265_);
									if (_tmp268_) {
										gchar* _tmp269_;
										_tmp269_ = g_strdup ("gpointer");
										result = _tmp269_;
										return result;
									} else {
										gchar* _tmp270_;
										_tmp270_ = g_strdup ("void *");
										result = _tmp270_;
										return result;
									}
								} else {
									ValaCodeNode* _tmp271_;
									_tmp271_ = self->priv->node;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp271_, VALA_TYPE_POINTER_TYPE)) {
										ValaPointerType* type = NULL;
										ValaCodeNode* _tmp272_;
										ValaPointerType* _tmp273_;
										gboolean _tmp274_ = FALSE;
										ValaPointerType* _tmp275_;
										ValaDataType* _tmp276_;
										ValaDataType* _tmp277_;
										ValaTypeSymbol* _tmp278_;
										ValaTypeSymbol* _tmp279_;
										_tmp272_ = self->priv->node;
										_tmp273_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp272_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
										type = _tmp273_;
										_tmp275_ = type;
										_tmp276_ = vala_pointer_type_get_base_type (_tmp275_);
										_tmp277_ = _tmp276_;
										_tmp278_ = vala_data_type_get_data_type (_tmp277_);
										_tmp279_ = _tmp278_;
										if (_tmp279_ != NULL) {
											ValaPointerType* _tmp280_;
											ValaDataType* _tmp281_;
											ValaDataType* _tmp282_;
											ValaTypeSymbol* _tmp283_;
											ValaTypeSymbol* _tmp284_;
											_tmp280_ = type;
											_tmp281_ = vala_pointer_type_get_base_type (_tmp280_);
											_tmp282_ = _tmp281_;
											_tmp283_ = vala_data_type_get_data_type (_tmp282_);
											_tmp284_ = _tmp283_;
											_tmp274_ = vala_typesymbol_is_reference_type (_tmp284_);
										} else {
											_tmp274_ = FALSE;
										}
										if (_tmp274_) {
											ValaPointerType* _tmp285_;
											ValaDataType* _tmp286_;
											ValaDataType* _tmp287_;
											gchar* _tmp288_;
											_tmp285_ = type;
											_tmp286_ = vala_pointer_type_get_base_type (_tmp285_);
											_tmp287_ = _tmp286_;
											_tmp288_ = vala_get_ccode_name ((ValaCodeNode*) _tmp287_);
											result = _tmp288_;
											_vala_code_node_unref0 (type);
											return result;
										} else {
											ValaPointerType* _tmp289_;
											ValaDataType* _tmp290_;
											ValaDataType* _tmp291_;
											gchar* _tmp292_;
											gchar* _tmp293_;
											gchar* _tmp294_;
											gchar* _tmp295_;
											_tmp289_ = type;
											_tmp290_ = vala_pointer_type_get_base_type (_tmp289_);
											_tmp291_ = _tmp290_;
											_tmp292_ = vala_get_ccode_name ((ValaCodeNode*) _tmp291_);
											_tmp293_ = _tmp292_;
											_tmp294_ = g_strdup_printf ("%s*", _tmp293_);
											_tmp295_ = _tmp294_;
											_g_free0 (_tmp293_);
											result = _tmp295_;
											_vala_code_node_unref0 (type);
											return result;
										}
										_vala_code_node_unref0 (type);
									} else {
										ValaCodeNode* _tmp296_;
										_tmp296_ = self->priv->node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp296_, VALA_TYPE_VOID_TYPE)) {
											gchar* _tmp297_;
											_tmp297_ = g_strdup ("void");
											result = _tmp297_;
											return result;
										} else {
											ValaCodeNode* _tmp298_;
											_tmp298_ = self->priv->node;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp298_, VALA_TYPE_CLASS_TYPE)) {
												ValaClassType* type = NULL;
												ValaCodeNode* _tmp299_;
												ValaClassType* _tmp300_;
												ValaClassType* _tmp301_;
												ValaClass* _tmp302_;
												ValaClass* _tmp303_;
												gchar* _tmp304_;
												gchar* _tmp305_;
												gchar* _tmp306_;
												gchar* _tmp307_;
												_tmp299_ = self->priv->node;
												_tmp300_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp299_, VALA_TYPE_CLASS_TYPE, ValaClassType));
												type = _tmp300_;
												_tmp301_ = type;
												_tmp302_ = vala_class_type_get_class_symbol (_tmp301_);
												_tmp303_ = _tmp302_;
												_tmp304_ = vala_get_ccode_name ((ValaCodeNode*) _tmp303_);
												_tmp305_ = _tmp304_;
												_tmp306_ = g_strdup_printf ("%sClass*", _tmp305_);
												_tmp307_ = _tmp306_;
												_g_free0 (_tmp305_);
												result = _tmp307_;
												_vala_code_node_unref0 (type);
												return result;
											} else {
												ValaCodeNode* _tmp308_;
												_tmp308_ = self->priv->node;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp308_, VALA_TYPE_INTERFACE_TYPE)) {
													ValaInterfaceType* type = NULL;
													ValaCodeNode* _tmp309_;
													ValaInterfaceType* _tmp310_;
													ValaInterfaceType* _tmp311_;
													ValaInterface* _tmp312_;
													ValaInterface* _tmp313_;
													gchar* _tmp314_;
													gchar* _tmp315_;
													gchar* _tmp316_;
													gchar* _tmp317_;
													_tmp309_ = self->priv->node;
													_tmp310_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp309_, VALA_TYPE_INTERFACE_TYPE, ValaInterfaceType));
													type = _tmp310_;
													_tmp311_ = type;
													_tmp312_ = vala_interface_type_get_interface_symbol (_tmp311_);
													_tmp313_ = _tmp312_;
													_tmp314_ = vala_get_ccode_type_name (_tmp313_);
													_tmp315_ = _tmp314_;
													_tmp316_ = g_strdup_printf ("%s*", _tmp315_);
													_tmp317_ = _tmp316_;
													_g_free0 (_tmp315_);
													result = _tmp317_;
													_vala_code_node_unref0 (type);
													return result;
												} else {
													ValaCodeNode* _tmp318_;
													_tmp318_ = self->priv->node;
													if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_VALUE_TYPE)) {
														ValaValueType* type = NULL;
														ValaCodeNode* _tmp319_;
														ValaValueType* _tmp320_;
														gchar* cname = NULL;
														ValaValueType* _tmp321_;
														ValaTypeSymbol* _tmp322_;
														ValaTypeSymbol* _tmp323_;
														gchar* _tmp324_;
														ValaValueType* _tmp325_;
														gboolean _tmp326_;
														gboolean _tmp327_;
														_tmp319_ = self->priv->node;
														_tmp320_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp319_, VALA_TYPE_VALUE_TYPE, ValaValueType));
														type = _tmp320_;
														_tmp321_ = type;
														_tmp322_ = vala_value_type_get_type_symbol (_tmp321_);
														_tmp323_ = _tmp322_;
														_tmp324_ = vala_get_ccode_name ((ValaCodeNode*) _tmp323_);
														cname = _tmp324_;
														_tmp325_ = type;
														_tmp326_ = vala_data_type_get_nullable ((ValaDataType*) _tmp325_);
														_tmp327_ = _tmp326_;
														if (_tmp327_) {
															const gchar* _tmp328_;
															gchar* _tmp329_;
															_tmp328_ = cname;
															_tmp329_ = g_strdup_printf ("%s*", _tmp328_);
															result = _tmp329_;
															_g_free0 (cname);
															_vala_code_node_unref0 (type);
															return result;
														} else {
															result = cname;
															_vala_code_node_unref0 (type);
															return result;
														}
														_g_free0 (cname);
														_vala_code_node_unref0 (type);
													} else {
														ValaCodeNode* _tmp330_;
														_tmp330_ = self->priv->node;
														if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_CTYPE)) {
															ValaCodeNode* _tmp331_;
															const gchar* _tmp332_;
															const gchar* _tmp333_;
															gchar* _tmp334_;
															_tmp331_ = self->priv->node;
															_tmp332_ = vala_ctype_get_ctype_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_CTYPE, ValaCType));
															_tmp333_ = _tmp332_;
															_tmp334_ = g_strdup (_tmp333_);
															result = _tmp334_;
															return result;
														} else {
															ValaCodeNode* _tmp335_;
															ValaSourceReference* _tmp336_;
															ValaSourceReference* _tmp337_;
															gchar* _tmp338_;
															_tmp335_ = self->priv->node;
															_tmp336_ = vala_code_node_get_source_reference (_tmp335_);
															_tmp337_ = _tmp336_;
															vala_report_error (_tmp337_, "Unresolved type reference");
															_tmp338_ = g_strdup ("");
															result = _tmp338_;
															return result;
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gchar*
vala_ccode_attribute_get_default_header_filenames (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	gboolean _tmp14_ = FALSE;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_DYNAMIC_PROPERTY)) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp2_;
		_tmp2_ = self->priv->sym;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_DYNAMIC_METHOD);
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->sym;
	_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		gchar* parent_headers = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp7_ = self->priv->sym;
		_tmp8_ = vala_symbol_get_parent_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_get_ccode_header_filenames (_tmp9_);
		parent_headers = _tmp10_;
		_tmp11_ = parent_headers;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ > 0) {
			result = parent_headers;
			return result;
		}
		_g_free0 (parent_headers);
	}
	_tmp15_ = self->priv->sym;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaSymbol* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->sym;
		_tmp19_ = vala_symbol_get_external_package (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = !_tmp20_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaSymbol* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaSourceFile* _tmp24_;
		ValaSourceFile* _tmp25_;
		gchar* _tmp26_;
		_tmp21_ = self->priv->sym;
		_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_source_reference_get_file (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_source_file_get_cinclude_filename (_tmp25_);
		result = _tmp26_;
		return result;
	}
	_tmp27_ = g_strdup ("");
	result = _tmp27_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_prefix (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = vala_ccode_attribute_get_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		ValaSymbol* _tmp5_;
		_tmp5_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM)) {
			_tmp4_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			_tmp6_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp4_) {
			ValaSymbol* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = vala_get_ccode_upper_case_name (_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("%s_", _tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			result = _tmp11_;
			return result;
		} else {
			ValaSymbol* _tmp12_;
			_tmp12_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = self->priv->sym;
				_tmp14_ = vala_symbol_get_name (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ != NULL) {
					gchar* parent_prefix = NULL;
					gchar* _tmp16_;
					ValaSymbol* _tmp17_;
					ValaSymbol* _tmp18_;
					ValaSymbol* _tmp19_;
					const gchar* _tmp24_;
					ValaSymbol* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp16_ = g_strdup ("");
					parent_prefix = _tmp16_;
					_tmp17_ = self->priv->sym;
					_tmp18_ = vala_symbol_get_parent_symbol (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_ != NULL) {
						ValaSymbol* _tmp20_;
						ValaSymbol* _tmp21_;
						ValaSymbol* _tmp22_;
						gchar* _tmp23_;
						_tmp20_ = self->priv->sym;
						_tmp21_ = vala_symbol_get_parent_symbol (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = vala_get_ccode_prefix (_tmp22_);
						_g_free0 (parent_prefix);
						parent_prefix = _tmp23_;
					}
					_tmp24_ = parent_prefix;
					_tmp25_ = self->priv->sym;
					_tmp26_ = vala_symbol_get_name (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strdup_printf ("%s%s", _tmp24_, _tmp27_);
					result = _tmp28_;
					_g_free0 (parent_prefix);
					return result;
				} else {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("");
					result = _tmp29_;
					return result;
				}
			} else {
				ValaSymbol* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = self->priv->sym;
				_tmp31_ = vala_symbol_get_name (_tmp30_);
				_tmp32_ = _tmp31_;
				if (_tmp32_ != NULL) {
					ValaSymbol* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp33_ = self->priv->sym;
					_tmp34_ = vala_symbol_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strdup (_tmp35_);
					result = _tmp36_;
					return result;
				}
			}
		}
	}
	_tmp37_ = g_strdup ("");
	result = _tmp37_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_lower_case_prefix (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = vala_symbol_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == NULL) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		} else {
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			ValaSymbol* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			ValaSymbol* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp5_ = self->priv->sym;
			_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_get_ccode_lower_case_prefix (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->sym;
			_tmp11_ = vala_symbol_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_symbol_camel_case_to_lower_case (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf ("%s%s_", _tmp9_, _tmp14_);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp9_);
			result = _tmp16_;
			return result;
		}
	} else {
		ValaSymbol* _tmp17_;
		_tmp17_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_METHOD)) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("");
			result = _tmp18_;
			return result;
		} else {
			ValaSymbol* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp19_ = self->priv->sym;
			_tmp20_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("%s_", _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			result = _tmp23_;
			return result;
		}
	}
}


static gchar*
vala_ccode_attribute_get_default_lower_case_suffix (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp42_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		gchar* csuffix = NULL;
		ValaSymbol* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp19_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = vala_symbol_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_symbol_camel_case_to_lower_case (_tmp3_);
		csuffix = _tmp4_;
		_tmp5_ = csuffix;
		if (g_str_has_prefix (_tmp5_, "type_")) {
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = csuffix;
			_tmp7_ = strlen ("type_");
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (_tmp6_, (glong) _tmp8_, (glong) -1);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat ("type", _tmp10_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp11_;
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp12_;
			_tmp12_ = csuffix;
			if (g_str_has_prefix (_tmp12_, "is_")) {
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp13_ = csuffix;
				_tmp14_ = strlen ("is_");
				_tmp15_ = _tmp14_;
				_tmp16_ = string_substring (_tmp13_, (glong) _tmp15_, (glong) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat ("is", _tmp17_, NULL);
				_g_free0 (csuffix);
				csuffix = _tmp18_;
				_g_free0 (_tmp17_);
			}
		}
		_tmp19_ = csuffix;
		if (g_str_has_suffix (_tmp19_, "_class")) {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp20_ = csuffix;
			_tmp21_ = csuffix;
			_tmp22_ = strlen (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = strlen ("_class");
			_tmp25_ = _tmp24_;
			_tmp26_ = string_substring (_tmp20_, (glong) 0, (glong) (_tmp23_ - _tmp25_));
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp27_, "class", NULL);
			_g_free0 (csuffix);
			csuffix = _tmp28_;
			_g_free0 (_tmp27_);
		}
		result = csuffix;
		return result;
	} else {
		ValaSymbol* _tmp29_;
		_tmp29_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_SIGNAL)) {
			ValaSymbol* _tmp30_;
			ValaCCodeAttribute* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp30_ = self->priv->sym;
			_tmp31_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp30_);
			_tmp32_ = vala_ccode_attribute_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = string_replace (_tmp33_, "-", "_");
			result = _tmp34_;
			return result;
		} else {
			ValaSymbol* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp35_ = self->priv->sym;
			_tmp36_ = vala_symbol_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaSymbol* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp38_ = self->priv->sym;
				_tmp39_ = vala_symbol_get_name (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_camel_case_to_lower_case (_tmp40_);
				result = _tmp41_;
				return result;
			}
		}
	}
	_tmp42_ = g_strdup ("");
	result = _tmp42_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_ref_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		_tmp1_ = self->priv->sym;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = cl;
		if (vala_class_is_fundamental (_tmp2_)) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf ("%sref", _tmp4_);
			result = _tmp5_;
			return result;
		} else {
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_base_class (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = cl;
				_tmp10_ = vala_class_get_base_class (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_get_ccode_ref_function ((ValaTypeSymbol*) _tmp11_);
				result = _tmp12_;
				return result;
			}
		}
	} else {
		ValaSymbol* _tmp13_;
		_tmp13_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
			{
				ValaList* _prereq_list = NULL;
				ValaSymbol* _tmp14_;
				ValaList* _tmp15_;
				gint _prereq_size = 0;
				ValaList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _prereq_index = 0;
				_tmp14_ = self->priv->sym;
				_tmp15_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_INTERFACE, ValaInterface));
				_prereq_list = _tmp15_;
				_tmp16_ = _prereq_list;
				_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_prereq_size = _tmp18_;
				_prereq_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					ValaDataType* prereq = NULL;
					ValaList* _tmp22_;
					gint _tmp23_;
					gpointer _tmp24_;
					gchar* ref_func = NULL;
					ValaDataType* _tmp25_;
					ValaTypeSymbol* _tmp26_;
					ValaTypeSymbol* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp19_ = _prereq_index;
					_prereq_index = _tmp19_ + 1;
					_tmp20_ = _prereq_index;
					_tmp21_ = _prereq_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _prereq_list;
					_tmp23_ = _prereq_index;
					_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
					prereq = (ValaDataType*) _tmp24_;
					_tmp25_ = prereq;
					_tmp26_ = vala_data_type_get_data_type (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_get_ccode_ref_function ((ValaTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
					ref_func = _tmp28_;
					_tmp29_ = ref_func;
					if (_tmp29_ != NULL) {
						result = ref_func;
						_vala_code_node_unref0 (prereq);
						_vala_iterable_unref0 (_prereq_list);
						return result;
					}
					_g_free0 (ref_func);
					_vala_code_node_unref0 (prereq);
				}
				_vala_iterable_unref0 (_prereq_list);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_unref_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		_tmp1_ = self->priv->sym;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = cl;
		if (vala_class_is_fundamental (_tmp2_)) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf ("%sunref", _tmp4_);
			result = _tmp5_;
			return result;
		} else {
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			_tmp6_ = cl;
			_tmp7_ = vala_class_get_base_class (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != NULL) {
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				ValaClass* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = cl;
				_tmp10_ = vala_class_get_base_class (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_get_ccode_unref_function ((ValaObjectTypeSymbol*) _tmp11_);
				result = _tmp12_;
				return result;
			}
		}
	} else {
		ValaSymbol* _tmp13_;
		_tmp13_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
			{
				ValaList* _prereq_list = NULL;
				ValaSymbol* _tmp14_;
				ValaList* _tmp15_;
				gint _prereq_size = 0;
				ValaList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _prereq_index = 0;
				_tmp14_ = self->priv->sym;
				_tmp15_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_INTERFACE, ValaInterface));
				_prereq_list = _tmp15_;
				_tmp16_ = _prereq_list;
				_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_prereq_size = _tmp18_;
				_prereq_index = -1;
				while (TRUE) {
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					ValaDataType* prereq = NULL;
					ValaList* _tmp22_;
					gint _tmp23_;
					gpointer _tmp24_;
					gchar* unref_func = NULL;
					ValaDataType* _tmp25_;
					ValaTypeSymbol* _tmp26_;
					ValaTypeSymbol* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp19_ = _prereq_index;
					_prereq_index = _tmp19_ + 1;
					_tmp20_ = _prereq_index;
					_tmp21_ = _prereq_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _prereq_list;
					_tmp23_ = _prereq_index;
					_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
					prereq = (ValaDataType*) _tmp24_;
					_tmp25_ = prereq;
					_tmp26_ = vala_data_type_get_data_type (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_get_ccode_unref_function (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
					unref_func = _tmp28_;
					_tmp29_ = unref_func;
					if (_tmp29_ != NULL) {
						result = unref_func;
						_vala_code_node_unref0 (prereq);
						_vala_iterable_unref0 (_prereq_list);
						return result;
					}
					_g_free0 (unref_func);
					_vala_code_node_unref0 (prereq);
				}
				_vala_iterable_unref0 (_prereq_list);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_ref_sink_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* base_class = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		ValaClass* _tmp4_;
		_tmp1_ = self->priv->sym;
		_tmp2_ = vala_class_get_base_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass));
		_tmp3_ = _tmp2_;
		base_class = _tmp3_;
		_tmp4_ = base_class;
		if (_tmp4_ != NULL) {
			ValaClass* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = base_class;
			_tmp6_ = vala_get_ccode_ref_sink_function ((ValaObjectTypeSymbol*) _tmp5_);
			result = _tmp6_;
			return result;
		}
	} else {
		ValaSymbol* _tmp7_;
		_tmp7_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_INTERFACE)) {
			{
				ValaList* _prereq_list = NULL;
				ValaSymbol* _tmp8_;
				ValaList* _tmp9_;
				gint _prereq_size = 0;
				ValaList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _prereq_index = 0;
				_tmp8_ = self->priv->sym;
				_tmp9_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_INTERFACE, ValaInterface));
				_prereq_list = _tmp9_;
				_tmp10_ = _prereq_list;
				_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_prereq_size = _tmp12_;
				_prereq_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					ValaDataType* prereq = NULL;
					ValaList* _tmp16_;
					gint _tmp17_;
					gpointer _tmp18_;
					gchar* ref_sink_func = NULL;
					ValaDataType* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					_tmp13_ = _prereq_index;
					_prereq_index = _tmp13_ + 1;
					_tmp14_ = _prereq_index;
					_tmp15_ = _prereq_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _prereq_list;
					_tmp17_ = _prereq_index;
					_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
					prereq = (ValaDataType*) _tmp18_;
					_tmp19_ = prereq;
					_tmp20_ = vala_data_type_get_data_type (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_get_ccode_ref_sink_function (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
					ref_sink_func = _tmp22_;
					_tmp23_ = ref_sink_func;
					if (g_strcmp0 (_tmp23_, "") != 0) {
						result = ref_sink_func;
						_vala_code_node_unref0 (prereq);
						_vala_iterable_unref0 (_prereq_list);
						return result;
					}
					_g_free0 (ref_sink_func);
					_vala_code_node_unref0 (prereq);
				}
				_vala_iterable_unref0 (_prereq_list);
			}
		}
	}
	_tmp24_ = g_strdup ("");
	result = _tmp24_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_free_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		ValaClass* _tmp3_;
		ValaClass* _tmp4_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp1_ = self->priv->sym;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = cl;
		_tmp3_ = vala_class_get_base_class (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaClass* _tmp5_;
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = cl;
			_tmp6_ = vala_class_get_base_class (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_get_ccode_free_function ((ValaTypeSymbol*) _tmp7_);
			result = _tmp8_;
			return result;
		}
		_tmp9_ = vala_ccode_attribute_get_lower_case_prefix (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%sfree", _tmp10_);
		result = _tmp11_;
		return result;
	} else {
		ValaSymbol* _tmp12_;
		_tmp12_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_STRUCT)) {
			ValaSymbol* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = self->priv->sym;
			_tmp14_ = vala_symbol_get_external_package (_tmp13_);
			_tmp15_ = _tmp14_;
			if (!_tmp15_) {
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp16_ = vala_ccode_attribute_get_lower_case_prefix (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup_printf ("%sfree", _tmp17_);
				result = _tmp18_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_type_id (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp63_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaSymbol* _tmp3_;
		_tmp3_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_CLASS)) {
			ValaSymbol* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = self->priv->sym;
			_tmp5_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = _tmp5_;
			_tmp2_ = !_tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			_tmp7_ = self->priv->sym;
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_INTERFACE);
		}
		if (_tmp1_) {
			ValaSymbol* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = self->priv->sym;
			_tmp9_ = vala_get_ccode_upper_case_name (_tmp8_, "TYPE_");
			result = _tmp9_;
			return result;
		} else {
			ValaSymbol* _tmp10_;
			_tmp10_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_ERROR_TYPE)) {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("G_TYPE_ERROR");
				result = _tmp11_;
				return result;
			} else {
				ValaSymbol* _tmp12_;
				_tmp12_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp13_;
					ValaStruct* _tmp14_;
					_tmp13_ = self->priv->sym;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_STRUCT, ValaStruct);
					_tmp14_ = st;
					if (!vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp14_)) {
						ValaStruct* base_struct = NULL;
						ValaStruct* _tmp15_;
						ValaStruct* _tmp16_;
						ValaStruct* _tmp17_;
						ValaStruct* _tmp18_;
						ValaStruct* _tmp21_;
						_tmp15_ = st;
						_tmp16_ = vala_struct_get_base_struct (_tmp15_);
						_tmp17_ = _tmp16_;
						base_struct = _tmp17_;
						_tmp18_ = base_struct;
						if (_tmp18_ != NULL) {
							ValaStruct* _tmp19_;
							gchar* _tmp20_;
							_tmp19_ = base_struct;
							_tmp20_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp19_);
							result = _tmp20_;
							return result;
						}
						_tmp21_ = st;
						if (!vala_struct_is_simple_type (_tmp21_)) {
							gchar* _tmp22_;
							_tmp22_ = g_strdup ("G_TYPE_POINTER");
							result = _tmp22_;
							return result;
						}
					} else {
						ValaStruct* _tmp23_;
						gchar* _tmp24_;
						_tmp23_ = st;
						_tmp24_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp23_, "TYPE_");
						result = _tmp24_;
						return result;
					}
				} else {
					ValaSymbol* _tmp25_;
					_tmp25_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_ENUM)) {
						ValaEnum* en = NULL;
						ValaSymbol* _tmp26_;
						ValaEnum* _tmp27_;
						_tmp26_ = self->priv->sym;
						en = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_ENUM, ValaEnum);
						_tmp27_ = en;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp27_)) {
							ValaEnum* _tmp28_;
							gchar* _tmp29_;
							_tmp28_ = en;
							_tmp29_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp28_, "TYPE_");
							result = _tmp29_;
							return result;
						} else {
							const gchar* _tmp30_ = NULL;
							ValaEnum* _tmp31_;
							gboolean _tmp32_;
							gboolean _tmp33_;
							gchar* _tmp34_;
							_tmp31_ = en;
							_tmp32_ = vala_enum_get_is_flags (_tmp31_);
							_tmp33_ = _tmp32_;
							if (_tmp33_) {
								_tmp30_ = "G_TYPE_UINT";
							} else {
								_tmp30_ = "G_TYPE_INT";
							}
							_tmp34_ = g_strdup (_tmp30_);
							result = _tmp34_;
							return result;
						}
					} else {
						gchar* _tmp35_;
						_tmp35_ = g_strdup ("G_TYPE_POINTER");
						result = _tmp35_;
						return result;
					}
				}
			}
		}
	} else {
		gboolean _tmp36_ = FALSE;
		ValaCodeNode* _tmp37_;
		_tmp37_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_ARRAY_TYPE)) {
			ValaCodeNode* _tmp38_;
			ValaDataType* _tmp39_;
			ValaDataType* _tmp40_;
			ValaTypeSymbol* _tmp41_;
			ValaTypeSymbol* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp38_ = self->priv->node;
			_tmp39_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_data_type_get_data_type (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
			_tmp44_ = _tmp43_;
			_tmp36_ = g_strcmp0 (_tmp44_, "string") == 0;
			_g_free0 (_tmp44_);
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("G_TYPE_STRV");
			result = _tmp45_;
			return result;
		} else {
			gboolean _tmp46_ = FALSE;
			ValaCodeNode* _tmp47_;
			_tmp47_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_POINTER_TYPE)) {
				_tmp46_ = TRUE;
			} else {
				ValaCodeNode* _tmp48_;
				_tmp48_ = self->priv->node;
				_tmp46_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_DELEGATE_TYPE);
			}
			if (_tmp46_) {
				gchar* _tmp49_;
				_tmp49_ = g_strdup ("G_TYPE_POINTER");
				result = _tmp49_;
				return result;
			} else {
				ValaCodeNode* _tmp50_;
				_tmp50_ = self->priv->node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_ERROR_TYPE)) {
					gchar* _tmp51_;
					_tmp51_ = g_strdup ("G_TYPE_ERROR");
					result = _tmp51_;
					return result;
				} else {
					ValaCodeNode* _tmp52_;
					_tmp52_ = self->priv->node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_VOID_TYPE)) {
						gchar* _tmp53_;
						_tmp53_ = g_strdup ("G_TYPE_NONE");
						result = _tmp53_;
						return result;
					} else {
						ValaDataType* type = NULL;
						ValaCodeNode* _tmp54_;
						ValaDataType* _tmp55_;
						ValaDataType* _tmp56_;
						ValaTypeSymbol* _tmp57_;
						ValaTypeSymbol* _tmp58_;
						_tmp54_ = self->priv->node;
						_tmp55_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_DATA_TYPE, ValaDataType));
						type = _tmp55_;
						_tmp56_ = type;
						_tmp57_ = vala_data_type_get_data_type (_tmp56_);
						_tmp58_ = _tmp57_;
						if (_tmp58_ != NULL) {
							ValaDataType* _tmp59_;
							ValaTypeSymbol* _tmp60_;
							ValaTypeSymbol* _tmp61_;
							gchar* _tmp62_;
							_tmp59_ = type;
							_tmp60_ = vala_data_type_get_data_type (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp61_);
							result = _tmp62_;
							_vala_code_node_unref0 (type);
							return result;
						}
						_vala_code_node_unref0 (type);
					}
				}
			}
		}
	}
	_tmp63_ = g_strdup ("");
	result = _tmp63_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_marshaller_type_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp122_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (_tmp0_ != NULL) {
		ValaSymbol* _tmp1_;
		_tmp1_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp2_;
			ValaClass* _tmp3_;
			ValaClass* _tmp4_;
			ValaClass* _tmp5_;
			_tmp2_ = self->priv->sym;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_CLASS, ValaClass);
			_tmp3_ = cl;
			_tmp4_ = vala_class_get_base_class (_tmp3_);
			_tmp5_ = _tmp4_;
			if (_tmp5_ != NULL) {
				ValaClass* _tmp6_;
				ValaClass* _tmp7_;
				ValaClass* _tmp8_;
				gchar* _tmp9_;
				_tmp6_ = cl;
				_tmp7_ = vala_class_get_base_class (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp8_);
				result = _tmp9_;
				return result;
			} else {
				ValaClass* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp10_ = cl;
				_tmp11_ = vala_class_get_is_compact (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					ValaClass* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = cl;
					_tmp14_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp13_, NULL);
					result = _tmp14_;
					return result;
				} else {
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = vala_ccode_attribute_get_type_id (self);
					_tmp16_ = _tmp15_;
					if (g_strcmp0 (_tmp16_, "G_TYPE_POINTER") == 0) {
						gchar* _tmp17_;
						_tmp17_ = g_strdup ("POINTER");
						result = _tmp17_;
						return result;
					} else {
						gchar* _tmp18_;
						_tmp18_ = g_strdup ("BOXED");
						result = _tmp18_;
						return result;
					}
				}
			}
		} else {
			ValaSymbol* _tmp19_;
			_tmp19_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_ENUM)) {
				ValaEnum* en = NULL;
				ValaSymbol* _tmp20_;
				ValaEnum* _tmp21_;
				_tmp20_ = self->priv->sym;
				en = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_ENUM, ValaEnum);
				_tmp21_ = en;
				if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp21_)) {
					ValaEnum* _tmp22_;
					gboolean _tmp23_;
					gboolean _tmp24_;
					_tmp22_ = en;
					_tmp23_ = vala_enum_get_is_flags (_tmp22_);
					_tmp24_ = _tmp23_;
					if (_tmp24_) {
						gchar* _tmp25_;
						_tmp25_ = g_strdup ("FLAGS");
						result = _tmp25_;
						return result;
					} else {
						gchar* _tmp26_;
						_tmp26_ = g_strdup ("ENUM");
						result = _tmp26_;
						return result;
					}
				} else {
					ValaEnum* _tmp27_;
					gboolean _tmp28_;
					gboolean _tmp29_;
					_tmp27_ = en;
					_tmp28_ = vala_enum_get_is_flags (_tmp27_);
					_tmp29_ = _tmp28_;
					if (_tmp29_) {
						gchar* _tmp30_;
						_tmp30_ = g_strdup ("UINT");
						result = _tmp30_;
						return result;
					} else {
						gchar* _tmp31_;
						_tmp31_ = g_strdup ("INT");
						result = _tmp31_;
						return result;
					}
				}
			} else {
				ValaSymbol* _tmp32_;
				_tmp32_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_INTERFACE)) {
					gchar* _tmp49_;
					{
						ValaList* _prereq_list = NULL;
						ValaSymbol* _tmp33_;
						ValaList* _tmp34_;
						gint _prereq_size = 0;
						ValaList* _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						gint _prereq_index = 0;
						_tmp33_ = self->priv->sym;
						_tmp34_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_INTERFACE, ValaInterface));
						_prereq_list = _tmp34_;
						_tmp35_ = _prereq_list;
						_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
						_tmp37_ = _tmp36_;
						_prereq_size = _tmp37_;
						_prereq_index = -1;
						while (TRUE) {
							gint _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							ValaDataType* prereq = NULL;
							ValaList* _tmp41_;
							gint _tmp42_;
							gpointer _tmp43_;
							gchar* type_name = NULL;
							ValaDataType* _tmp44_;
							ValaTypeSymbol* _tmp45_;
							ValaTypeSymbol* _tmp46_;
							gchar* _tmp47_;
							const gchar* _tmp48_;
							_tmp38_ = _prereq_index;
							_prereq_index = _tmp38_ + 1;
							_tmp39_ = _prereq_index;
							_tmp40_ = _prereq_size;
							if (!(_tmp39_ < _tmp40_)) {
								break;
							}
							_tmp41_ = _prereq_list;
							_tmp42_ = _prereq_index;
							_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
							prereq = (ValaDataType*) _tmp43_;
							_tmp44_ = prereq;
							_tmp45_ = vala_data_type_get_data_type (_tmp44_);
							_tmp46_ = _tmp45_;
							_tmp47_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp46_);
							type_name = _tmp47_;
							_tmp48_ = type_name;
							if (g_strcmp0 (_tmp48_, "") != 0) {
								result = type_name;
								_vala_code_node_unref0 (prereq);
								_vala_iterable_unref0 (_prereq_list);
								return result;
							}
							_g_free0 (type_name);
							_vala_code_node_unref0 (prereq);
						}
						_vala_iterable_unref0 (_prereq_list);
					}
					_tmp49_ = g_strdup ("POINTER");
					result = _tmp49_;
					return result;
				} else {
					ValaSymbol* _tmp50_;
					_tmp50_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						ValaSymbol* _tmp51_;
						ValaStruct* base_st = NULL;
						ValaStruct* _tmp52_;
						ValaStruct* _tmp53_;
						ValaStruct* _tmp54_;
						ValaStruct* _tmp62_;
						_tmp51_ = self->priv->sym;
						st = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp52_ = st;
						_tmp53_ = vala_struct_get_base_struct (_tmp52_);
						_tmp54_ = _tmp53_;
						base_st = _tmp54_;
						while (TRUE) {
							ValaStruct* _tmp55_;
							ValaStruct* _tmp56_;
							_tmp55_ = base_st;
							if (!(_tmp55_ != NULL)) {
								break;
							}
							_tmp56_ = base_st;
							if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp56_)) {
								ValaStruct* _tmp57_;
								gchar* _tmp58_;
								_tmp57_ = base_st;
								_tmp58_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp57_);
								result = _tmp58_;
								return result;
							} else {
								ValaStruct* _tmp59_;
								ValaStruct* _tmp60_;
								ValaStruct* _tmp61_;
								_tmp59_ = base_st;
								_tmp60_ = vala_struct_get_base_struct (_tmp59_);
								_tmp61_ = _tmp60_;
								base_st = _tmp61_;
							}
						}
						_tmp62_ = st;
						if (vala_struct_is_simple_type (_tmp62_)) {
							ValaStruct* _tmp63_;
							ValaSourceReference* _tmp64_;
							ValaSourceReference* _tmp65_;
							ValaStruct* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							_tmp63_ = st;
							_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = st;
							_tmp67_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp66_);
							_tmp68_ = _tmp67_;
							_tmp69_ = g_strdup_printf ("The type `%s` doesn't declare a marshaller type name", _tmp68_);
							_tmp70_ = _tmp69_;
							vala_report_error (_tmp65_, _tmp70_);
							_g_free0 (_tmp70_);
							_g_free0 (_tmp68_);
						} else {
							ValaStruct* _tmp71_;
							_tmp71_ = st;
							if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp71_)) {
								gchar* _tmp72_;
								_tmp72_ = g_strdup ("BOXED");
								result = _tmp72_;
								return result;
							} else {
								gchar* _tmp73_;
								_tmp73_ = g_strdup ("POINTER");
								result = _tmp73_;
								return result;
							}
						}
					} else {
						ValaSymbol* _tmp74_;
						_tmp74_ = self->priv->sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_PARAMETER)) {
							ValaParameter* param = NULL;
							ValaSymbol* _tmp75_;
							ValaParameter* _tmp76_;
							ValaParameterDirection _tmp77_;
							ValaParameterDirection _tmp78_;
							_tmp75_ = self->priv->sym;
							param = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_PARAMETER, ValaParameter);
							_tmp76_ = param;
							_tmp77_ = vala_parameter_get_direction (_tmp76_);
							_tmp78_ = _tmp77_;
							if (_tmp78_ != VALA_PARAMETER_DIRECTION_IN) {
								gchar* _tmp79_;
								_tmp79_ = g_strdup ("POINTER");
								result = _tmp79_;
								return result;
							} else {
								ValaParameter* _tmp80_;
								ValaDataType* _tmp81_;
								ValaDataType* _tmp82_;
								gchar* _tmp83_;
								_tmp80_ = param;
								_tmp81_ = vala_variable_get_variable_type ((ValaVariable*) _tmp80_);
								_tmp82_ = _tmp81_;
								_tmp83_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp82_);
								result = _tmp83_;
								return result;
							}
						} else {
							gchar* _tmp84_;
							_tmp84_ = g_strdup ("POINTER");
							result = _tmp84_;
							return result;
						}
					}
				}
			}
		}
	} else {
		gboolean _tmp85_ = FALSE;
		ValaCodeNode* _tmp86_;
		_tmp86_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, VALA_TYPE_VALUE_TYPE)) {
			ValaCodeNode* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			_tmp87_ = self->priv->node;
			_tmp88_ = vala_data_type_get_nullable ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_VALUE_TYPE, ValaValueType));
			_tmp89_ = _tmp88_;
			_tmp85_ = _tmp89_;
		} else {
			_tmp85_ = FALSE;
		}
		if (_tmp85_) {
			gchar* _tmp90_;
			_tmp90_ = g_strdup ("POINTER");
			result = _tmp90_;
			return result;
		} else {
			gboolean _tmp91_ = FALSE;
			ValaCodeNode* _tmp92_;
			_tmp92_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_POINTER_TYPE)) {
				_tmp91_ = TRUE;
			} else {
				ValaCodeNode* _tmp93_;
				_tmp93_ = self->priv->node;
				_tmp91_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_GENERIC_TYPE);
			}
			if (_tmp91_) {
				gchar* _tmp94_;
				_tmp94_ = g_strdup ("POINTER");
				result = _tmp94_;
				return result;
			} else {
				ValaCodeNode* _tmp95_;
				_tmp95_ = self->priv->node;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_ERROR_TYPE)) {
					gchar* _tmp96_;
					_tmp96_ = g_strdup ("POINTER");
					result = _tmp96_;
					return result;
				} else {
					ValaCodeNode* _tmp97_;
					_tmp97_ = self->priv->node;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_ARRAY_TYPE)) {
						ValaCodeNode* _tmp98_;
						ValaDataType* _tmp99_;
						ValaDataType* _tmp100_;
						ValaTypeSymbol* _tmp101_;
						ValaTypeSymbol* _tmp102_;
						gchar* _tmp103_;
						gchar* _tmp104_;
						gboolean _tmp105_;
						_tmp98_ = self->priv->node;
						_tmp99_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp100_ = _tmp99_;
						_tmp101_ = vala_data_type_get_data_type (_tmp100_);
						_tmp102_ = _tmp101_;
						_tmp103_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp102_);
						_tmp104_ = _tmp103_;
						_tmp105_ = g_strcmp0 (_tmp104_, "string") == 0;
						_g_free0 (_tmp104_);
						if (_tmp105_) {
							gchar* _tmp106_;
							_tmp106_ = g_strdup ("BOXED,INT");
							result = _tmp106_;
							return result;
						} else {
							gchar* ret = NULL;
							gchar* _tmp107_;
							_tmp107_ = g_strdup ("POINTER");
							ret = _tmp107_;
							{
								gint i = 0;
								i = 0;
								{
									gboolean _tmp108_ = FALSE;
									_tmp108_ = TRUE;
									while (TRUE) {
										gint _tmp110_;
										ValaCodeNode* _tmp111_;
										gint _tmp112_;
										gint _tmp113_;
										const gchar* _tmp114_;
										gchar* _tmp115_;
										if (!_tmp108_) {
											gint _tmp109_;
											_tmp109_ = i;
											i = _tmp109_ + 1;
										}
										_tmp108_ = FALSE;
										_tmp110_ = i;
										_tmp111_ = self->priv->node;
										_tmp112_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
										_tmp113_ = _tmp112_;
										if (!(_tmp110_ < _tmp113_)) {
											break;
										}
										_tmp114_ = ret;
										_tmp115_ = g_strdup_printf ("%s,INT", _tmp114_);
										_g_free0 (ret);
										ret = _tmp115_;
									}
								}
							}
							result = ret;
							return result;
						}
					} else {
						ValaCodeNode* _tmp116_;
						_tmp116_ = self->priv->node;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, VALA_TYPE_VOID_TYPE)) {
							gchar* _tmp117_;
							_tmp117_ = g_strdup ("VOID");
							result = _tmp117_;
							return result;
						} else {
							ValaCodeNode* _tmp118_;
							ValaTypeSymbol* _tmp119_;
							ValaTypeSymbol* _tmp120_;
							gchar* _tmp121_;
							_tmp118_ = self->priv->node;
							_tmp119_ = vala_data_type_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, VALA_TYPE_DATA_TYPE, ValaDataType));
							_tmp120_ = _tmp119_;
							_tmp121_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp120_);
							result = _tmp121_;
							return result;
						}
					}
				}
			}
		}
	}
	_tmp122_ = g_strdup ("");
	result = _tmp122_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_get_value_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp72_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		_tmp1_ = self->priv->sym;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = cl;
		if (vala_class_is_fundamental (_tmp2_)) {
			ValaClass* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = cl;
			_tmp4_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp3_, "value_get_");
			result = _tmp4_;
			return result;
		} else {
			ValaClass* _tmp5_;
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			_tmp5_ = cl;
			_tmp6_ = vala_class_get_base_class (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaClass* _tmp8_;
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = cl;
				_tmp9_ = vala_class_get_base_class (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp10_);
				result = _tmp11_;
				return result;
			} else {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = vala_ccode_attribute_get_type_id (self);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, "G_TYPE_POINTER") == 0) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("g_value_get_pointer");
					result = _tmp14_;
					return result;
				} else {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("g_value_get_boxed");
					result = _tmp15_;
					return result;
				}
			}
		}
	} else {
		ValaSymbol* _tmp16_;
		_tmp16_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp17_;
			ValaEnum* _tmp18_;
			_tmp17_ = self->priv->sym;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_ENUM, ValaEnum);
			_tmp18_ = en;
			if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp18_)) {
				ValaEnum* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = en;
				_tmp20_ = vala_enum_get_is_flags (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					gchar* _tmp22_;
					_tmp22_ = g_strdup ("g_value_get_flags");
					result = _tmp22_;
					return result;
				} else {
					gchar* _tmp23_;
					_tmp23_ = g_strdup ("g_value_get_enum");
					result = _tmp23_;
					return result;
				}
			} else {
				ValaEnum* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = en;
				_tmp25_ = vala_enum_get_is_flags (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_) {
					gchar* _tmp27_;
					_tmp27_ = g_strdup ("g_value_get_uint");
					result = _tmp27_;
					return result;
				} else {
					gchar* _tmp28_;
					_tmp28_ = g_strdup ("g_value_get_int");
					result = _tmp28_;
					return result;
				}
			}
		} else {
			ValaSymbol* _tmp29_;
			_tmp29_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp46_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp30_;
					ValaList* _tmp31_;
					gint _prereq_size = 0;
					ValaList* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gint _prereq_index = 0;
					_tmp30_ = self->priv->sym;
					_tmp31_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp31_;
					_tmp32_ = _prereq_list;
					_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
					_tmp34_ = _tmp33_;
					_prereq_size = _tmp34_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp38_;
						gint _tmp39_;
						gpointer _tmp40_;
						gchar* type_name = NULL;
						ValaDataType* _tmp41_;
						ValaTypeSymbol* _tmp42_;
						ValaTypeSymbol* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						_tmp35_ = _prereq_index;
						_prereq_index = _tmp35_ + 1;
						_tmp36_ = _prereq_index;
						_tmp37_ = _prereq_size;
						if (!(_tmp36_ < _tmp37_)) {
							break;
						}
						_tmp38_ = _prereq_list;
						_tmp39_ = _prereq_index;
						_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
						prereq = (ValaDataType*) _tmp40_;
						_tmp41_ = prereq;
						_tmp42_ = vala_data_type_get_data_type (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp43_);
						type_name = _tmp44_;
						_tmp45_ = type_name;
						if (g_strcmp0 (_tmp45_, "") != 0) {
							result = type_name;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (type_name);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp46_ = g_strdup ("g_value_get_pointer");
				result = _tmp46_;
				return result;
			} else {
				ValaSymbol* _tmp47_;
				_tmp47_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp48_;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp49_;
					ValaStruct* _tmp50_;
					ValaStruct* _tmp51_;
					ValaStruct* _tmp59_;
					_tmp48_ = self->priv->sym;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_STRUCT, ValaStruct);
					_tmp49_ = st;
					_tmp50_ = vala_struct_get_base_struct (_tmp49_);
					_tmp51_ = _tmp50_;
					base_st = _tmp51_;
					while (TRUE) {
						ValaStruct* _tmp52_;
						ValaStruct* _tmp53_;
						_tmp52_ = base_st;
						if (!(_tmp52_ != NULL)) {
							break;
						}
						_tmp53_ = base_st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp53_)) {
							ValaStruct* _tmp54_;
							gchar* _tmp55_;
							_tmp54_ = base_st;
							_tmp55_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp54_);
							result = _tmp55_;
							return result;
						} else {
							ValaStruct* _tmp56_;
							ValaStruct* _tmp57_;
							ValaStruct* _tmp58_;
							_tmp56_ = base_st;
							_tmp57_ = vala_struct_get_base_struct (_tmp56_);
							_tmp58_ = _tmp57_;
							base_st = _tmp58_;
						}
					}
					_tmp59_ = st;
					if (vala_struct_is_simple_type (_tmp59_)) {
						ValaStruct* _tmp60_;
						ValaSourceReference* _tmp61_;
						ValaSourceReference* _tmp62_;
						ValaStruct* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						_tmp60_ = st;
						_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = st;
						_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strdup_printf ("The type `%s` doesn't declare a GValue get function", _tmp65_);
						_tmp67_ = _tmp66_;
						vala_report_error (_tmp62_, _tmp67_);
						_g_free0 (_tmp67_);
						_g_free0 (_tmp65_);
					} else {
						ValaStruct* _tmp68_;
						_tmp68_ = st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp68_)) {
							gchar* _tmp69_;
							_tmp69_ = g_strdup ("g_value_get_boxed");
							result = _tmp69_;
							return result;
						} else {
							gchar* _tmp70_;
							_tmp70_ = g_strdup ("g_value_get_pointer");
							result = _tmp70_;
							return result;
						}
					}
				} else {
					gchar* _tmp71_;
					_tmp71_ = g_strdup ("g_value_get_pointer");
					result = _tmp71_;
					return result;
				}
			}
		}
	}
	_tmp72_ = g_strdup ("");
	result = _tmp72_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_set_value_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp72_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		_tmp1_ = self->priv->sym;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = cl;
		if (vala_class_is_fundamental (_tmp2_)) {
			ValaClass* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = cl;
			_tmp4_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp3_, "value_set_");
			result = _tmp4_;
			return result;
		} else {
			ValaClass* _tmp5_;
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			_tmp5_ = cl;
			_tmp6_ = vala_class_get_base_class (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaClass* _tmp8_;
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = cl;
				_tmp9_ = vala_class_get_base_class (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp10_);
				result = _tmp11_;
				return result;
			} else {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = vala_ccode_attribute_get_type_id (self);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, "G_TYPE_POINTER") == 0) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("g_value_set_pointer");
					result = _tmp14_;
					return result;
				} else {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("g_value_set_boxed");
					result = _tmp15_;
					return result;
				}
			}
		}
	} else {
		ValaSymbol* _tmp16_;
		_tmp16_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp17_;
			ValaEnum* _tmp18_;
			_tmp17_ = self->priv->sym;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_ENUM, ValaEnum);
			_tmp18_ = en;
			if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp18_)) {
				ValaEnum* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = en;
				_tmp20_ = vala_enum_get_is_flags (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					gchar* _tmp22_;
					_tmp22_ = g_strdup ("g_value_set_flags");
					result = _tmp22_;
					return result;
				} else {
					gchar* _tmp23_;
					_tmp23_ = g_strdup ("g_value_set_enum");
					result = _tmp23_;
					return result;
				}
			} else {
				ValaEnum* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = en;
				_tmp25_ = vala_enum_get_is_flags (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_) {
					gchar* _tmp27_;
					_tmp27_ = g_strdup ("g_value_set_uint");
					result = _tmp27_;
					return result;
				} else {
					gchar* _tmp28_;
					_tmp28_ = g_strdup ("g_value_set_int");
					result = _tmp28_;
					return result;
				}
			}
		} else {
			ValaSymbol* _tmp29_;
			_tmp29_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp46_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp30_;
					ValaList* _tmp31_;
					gint _prereq_size = 0;
					ValaList* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gint _prereq_index = 0;
					_tmp30_ = self->priv->sym;
					_tmp31_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp31_;
					_tmp32_ = _prereq_list;
					_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
					_tmp34_ = _tmp33_;
					_prereq_size = _tmp34_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp38_;
						gint _tmp39_;
						gpointer _tmp40_;
						gchar* type_name = NULL;
						ValaDataType* _tmp41_;
						ValaTypeSymbol* _tmp42_;
						ValaTypeSymbol* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						_tmp35_ = _prereq_index;
						_prereq_index = _tmp35_ + 1;
						_tmp36_ = _prereq_index;
						_tmp37_ = _prereq_size;
						if (!(_tmp36_ < _tmp37_)) {
							break;
						}
						_tmp38_ = _prereq_list;
						_tmp39_ = _prereq_index;
						_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
						prereq = (ValaDataType*) _tmp40_;
						_tmp41_ = prereq;
						_tmp42_ = vala_data_type_get_data_type (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp43_);
						type_name = _tmp44_;
						_tmp45_ = type_name;
						if (g_strcmp0 (_tmp45_, "") != 0) {
							result = type_name;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (type_name);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp46_ = g_strdup ("g_value_set_pointer");
				result = _tmp46_;
				return result;
			} else {
				ValaSymbol* _tmp47_;
				_tmp47_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp48_;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp49_;
					ValaStruct* _tmp50_;
					ValaStruct* _tmp51_;
					ValaStruct* _tmp59_;
					_tmp48_ = self->priv->sym;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_STRUCT, ValaStruct);
					_tmp49_ = st;
					_tmp50_ = vala_struct_get_base_struct (_tmp49_);
					_tmp51_ = _tmp50_;
					base_st = _tmp51_;
					while (TRUE) {
						ValaStruct* _tmp52_;
						ValaStruct* _tmp53_;
						_tmp52_ = base_st;
						if (!(_tmp52_ != NULL)) {
							break;
						}
						_tmp53_ = base_st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp53_)) {
							ValaStruct* _tmp54_;
							gchar* _tmp55_;
							_tmp54_ = base_st;
							_tmp55_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp54_);
							result = _tmp55_;
							return result;
						} else {
							ValaStruct* _tmp56_;
							ValaStruct* _tmp57_;
							ValaStruct* _tmp58_;
							_tmp56_ = base_st;
							_tmp57_ = vala_struct_get_base_struct (_tmp56_);
							_tmp58_ = _tmp57_;
							base_st = _tmp58_;
						}
					}
					_tmp59_ = st;
					if (vala_struct_is_simple_type (_tmp59_)) {
						ValaStruct* _tmp60_;
						ValaSourceReference* _tmp61_;
						ValaSourceReference* _tmp62_;
						ValaStruct* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						_tmp60_ = st;
						_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = st;
						_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strdup_printf ("The type `%s` doesn't declare a GValue set function", _tmp65_);
						_tmp67_ = _tmp66_;
						vala_report_error (_tmp62_, _tmp67_);
						_g_free0 (_tmp67_);
						_g_free0 (_tmp65_);
					} else {
						ValaStruct* _tmp68_;
						_tmp68_ = st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp68_)) {
							gchar* _tmp69_;
							_tmp69_ = g_strdup ("g_value_set_boxed");
							result = _tmp69_;
							return result;
						} else {
							gchar* _tmp70_;
							_tmp70_ = g_strdup ("g_value_set_pointer");
							result = _tmp70_;
							return result;
						}
					}
				} else {
					gchar* _tmp71_;
					_tmp71_ = g_strdup ("g_value_set_pointer");
					result = _tmp71_;
					return result;
				}
			}
		}
	}
	_tmp72_ = g_strdup ("");
	result = _tmp72_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_take_value_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp72_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* _tmp2_;
		_tmp1_ = self->priv->sym;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = cl;
		if (vala_class_is_fundamental (_tmp2_)) {
			ValaClass* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = cl;
			_tmp4_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp3_, "value_take_");
			result = _tmp4_;
			return result;
		} else {
			ValaClass* _tmp5_;
			ValaClass* _tmp6_;
			ValaClass* _tmp7_;
			_tmp5_ = cl;
			_tmp6_ = vala_class_get_base_class (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaClass* _tmp8_;
				ValaClass* _tmp9_;
				ValaClass* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = cl;
				_tmp9_ = vala_class_get_base_class (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_get_ccode_take_value_function ((ValaCodeNode*) _tmp10_);
				result = _tmp11_;
				return result;
			} else {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = vala_ccode_attribute_get_type_id (self);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, "G_TYPE_POINTER") == 0) {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("g_value_set_pointer");
					result = _tmp14_;
					return result;
				} else {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("g_value_take_boxed");
					result = _tmp15_;
					return result;
				}
			}
		}
	} else {
		ValaSymbol* _tmp16_;
		_tmp16_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp17_;
			ValaEnum* _tmp18_;
			_tmp17_ = self->priv->sym;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_ENUM, ValaEnum);
			_tmp18_ = en;
			if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp18_)) {
				ValaEnum* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = en;
				_tmp20_ = vala_enum_get_is_flags (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					gchar* _tmp22_;
					_tmp22_ = g_strdup ("g_value_take_flags");
					result = _tmp22_;
					return result;
				} else {
					gchar* _tmp23_;
					_tmp23_ = g_strdup ("g_value_take_enum");
					result = _tmp23_;
					return result;
				}
			} else {
				ValaEnum* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = en;
				_tmp25_ = vala_enum_get_is_flags (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_) {
					gchar* _tmp27_;
					_tmp27_ = g_strdup ("g_value_take_uint");
					result = _tmp27_;
					return result;
				} else {
					gchar* _tmp28_;
					_tmp28_ = g_strdup ("g_value_take_int");
					result = _tmp28_;
					return result;
				}
			}
		} else {
			ValaSymbol* _tmp29_;
			_tmp29_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp46_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp30_;
					ValaList* _tmp31_;
					gint _prereq_size = 0;
					ValaList* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gint _prereq_index = 0;
					_tmp30_ = self->priv->sym;
					_tmp31_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp31_;
					_tmp32_ = _prereq_list;
					_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
					_tmp34_ = _tmp33_;
					_prereq_size = _tmp34_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp38_;
						gint _tmp39_;
						gpointer _tmp40_;
						gchar* func = NULL;
						ValaDataType* _tmp41_;
						ValaTypeSymbol* _tmp42_;
						ValaTypeSymbol* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						_tmp35_ = _prereq_index;
						_prereq_index = _tmp35_ + 1;
						_tmp36_ = _prereq_index;
						_tmp37_ = _prereq_size;
						if (!(_tmp36_ < _tmp37_)) {
							break;
						}
						_tmp38_ = _prereq_list;
						_tmp39_ = _prereq_index;
						_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
						prereq = (ValaDataType*) _tmp40_;
						_tmp41_ = prereq;
						_tmp42_ = vala_data_type_get_data_type (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = vala_get_ccode_take_value_function ((ValaCodeNode*) _tmp43_);
						func = _tmp44_;
						_tmp45_ = func;
						if (g_strcmp0 (_tmp45_, "") != 0) {
							result = func;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (func);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp46_ = g_strdup ("g_value_set_pointer");
				result = _tmp46_;
				return result;
			} else {
				ValaSymbol* _tmp47_;
				_tmp47_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_STRUCT)) {
					ValaStruct* st = NULL;
					ValaSymbol* _tmp48_;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp49_;
					ValaStruct* _tmp50_;
					ValaStruct* _tmp51_;
					ValaStruct* _tmp59_;
					_tmp48_ = self->priv->sym;
					st = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_STRUCT, ValaStruct);
					_tmp49_ = st;
					_tmp50_ = vala_struct_get_base_struct (_tmp49_);
					_tmp51_ = _tmp50_;
					base_st = _tmp51_;
					while (TRUE) {
						ValaStruct* _tmp52_;
						ValaStruct* _tmp53_;
						_tmp52_ = base_st;
						if (!(_tmp52_ != NULL)) {
							break;
						}
						_tmp53_ = base_st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp53_)) {
							ValaStruct* _tmp54_;
							gchar* _tmp55_;
							_tmp54_ = base_st;
							_tmp55_ = vala_get_ccode_take_value_function ((ValaCodeNode*) _tmp54_);
							result = _tmp55_;
							return result;
						} else {
							ValaStruct* _tmp56_;
							ValaStruct* _tmp57_;
							ValaStruct* _tmp58_;
							_tmp56_ = base_st;
							_tmp57_ = vala_struct_get_base_struct (_tmp56_);
							_tmp58_ = _tmp57_;
							base_st = _tmp58_;
						}
					}
					_tmp59_ = st;
					if (vala_struct_is_simple_type (_tmp59_)) {
						ValaStruct* _tmp60_;
						ValaSourceReference* _tmp61_;
						ValaSourceReference* _tmp62_;
						ValaStruct* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						_tmp60_ = st;
						_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = st;
						_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strdup_printf ("The type `%s` doesn't declare a GValue take function", _tmp65_);
						_tmp67_ = _tmp66_;
						vala_report_error (_tmp62_, _tmp67_);
						_g_free0 (_tmp67_);
						_g_free0 (_tmp65_);
					} else {
						ValaStruct* _tmp68_;
						_tmp68_ = st;
						if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp68_)) {
							gchar* _tmp69_;
							_tmp69_ = g_strdup ("g_value_take_boxed");
							result = _tmp69_;
							return result;
						} else {
							gchar* _tmp70_;
							_tmp70_ = g_strdup ("g_value_set_pointer");
							result = _tmp70_;
							return result;
						}
					}
				} else {
					gchar* _tmp71_;
					_tmp71_ = g_strdup ("g_value_set_pointer");
					result = _tmp71_;
					return result;
				}
			}
		}
	}
	_tmp72_ = g_strdup ("");
	result = _tmp72_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_param_spec_function (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	gchar* _tmp100_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_SYMBOL)) {
		ValaSymbol* _tmp1_;
		_tmp1_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp2_;
			ValaClass* _tmp3_;
			_tmp2_ = self->priv->sym;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_CLASS, ValaClass);
			_tmp3_ = cl;
			if (vala_class_is_fundamental (_tmp3_)) {
				ValaClass* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = cl;
				_tmp5_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp4_, "param_spec_");
				result = _tmp5_;
				return result;
			} else {
				ValaClass* _tmp6_;
				ValaClass* _tmp7_;
				ValaClass* _tmp8_;
				_tmp6_ = cl;
				_tmp7_ = vala_class_get_base_class (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ != NULL) {
					ValaClass* _tmp9_;
					ValaClass* _tmp10_;
					ValaClass* _tmp11_;
					gchar* _tmp12_;
					_tmp9_ = cl;
					_tmp10_ = vala_class_get_base_class (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp11_);
					result = _tmp12_;
					return result;
				} else {
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp13_ = vala_ccode_attribute_get_type_id (self);
					_tmp14_ = _tmp13_;
					if (g_strcmp0 (_tmp14_, "G_TYPE_POINTER") == 0) {
						gchar* _tmp15_;
						_tmp15_ = g_strdup ("g_param_spec_pointer");
						result = _tmp15_;
						return result;
					} else {
						gchar* _tmp16_;
						_tmp16_ = g_strdup ("g_param_spec_boxed");
						result = _tmp16_;
						return result;
					}
				}
			}
		} else {
			ValaSymbol* _tmp17_;
			_tmp17_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_INTERFACE)) {
				gchar* _tmp34_;
				{
					ValaList* _prereq_list = NULL;
					ValaSymbol* _tmp18_;
					ValaList* _tmp19_;
					gint _prereq_size = 0;
					ValaList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _prereq_index = 0;
					_tmp18_ = self->priv->sym;
					_tmp19_ = vala_interface_get_prerequisites (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_INTERFACE, ValaInterface));
					_prereq_list = _tmp19_;
					_tmp20_ = _prereq_list;
					_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					_prereq_size = _tmp22_;
					_prereq_index = -1;
					while (TRUE) {
						gint _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						ValaDataType* prereq = NULL;
						ValaList* _tmp26_;
						gint _tmp27_;
						gpointer _tmp28_;
						gchar* func = NULL;
						ValaDataType* _tmp29_;
						ValaTypeSymbol* _tmp30_;
						ValaTypeSymbol* _tmp31_;
						gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp23_ = _prereq_index;
						_prereq_index = _tmp23_ + 1;
						_tmp24_ = _prereq_index;
						_tmp25_ = _prereq_size;
						if (!(_tmp24_ < _tmp25_)) {
							break;
						}
						_tmp26_ = _prereq_list;
						_tmp27_ = _prereq_index;
						_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
						prereq = (ValaDataType*) _tmp28_;
						_tmp29_ = prereq;
						_tmp30_ = vala_data_type_get_data_type (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp31_);
						func = _tmp32_;
						_tmp33_ = func;
						if (g_strcmp0 (_tmp33_, "") != 0) {
							result = func;
							_vala_code_node_unref0 (prereq);
							_vala_iterable_unref0 (_prereq_list);
							return result;
						}
						_g_free0 (func);
						_vala_code_node_unref0 (prereq);
					}
					_vala_iterable_unref0 (_prereq_list);
				}
				_tmp34_ = g_strdup ("g_param_spec_pointer");
				result = _tmp34_;
				return result;
			} else {
				ValaSymbol* _tmp35_;
				_tmp35_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_ENUM)) {
					ValaEnum* e = NULL;
					ValaSymbol* _tmp36_;
					ValaEnum* _tmp37_;
					_tmp36_ = self->priv->sym;
					e = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_ENUM, ValaEnum);
					_tmp37_ = e;
					if (vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp37_)) {
						ValaEnum* _tmp38_;
						gboolean _tmp39_;
						gboolean _tmp40_;
						_tmp38_ = e;
						_tmp39_ = vala_enum_get_is_flags (_tmp38_);
						_tmp40_ = _tmp39_;
						if (_tmp40_) {
							gchar* _tmp41_;
							_tmp41_ = g_strdup ("g_param_spec_flags");
							result = _tmp41_;
							return result;
						} else {
							gchar* _tmp42_;
							_tmp42_ = g_strdup ("g_param_spec_enum");
							result = _tmp42_;
							return result;
						}
					} else {
						ValaEnum* _tmp43_;
						gboolean _tmp44_;
						gboolean _tmp45_;
						_tmp43_ = e;
						_tmp44_ = vala_enum_get_is_flags (_tmp43_);
						_tmp45_ = _tmp44_;
						if (_tmp45_) {
							gchar* _tmp46_;
							_tmp46_ = g_strdup ("g_param_spec_uint");
							result = _tmp46_;
							return result;
						} else {
							gchar* _tmp47_;
							_tmp47_ = g_strdup ("g_param_spec_int");
							result = _tmp47_;
							return result;
						}
					}
				} else {
					ValaSymbol* _tmp48_;
					_tmp48_ = self->priv->sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_STRUCT)) {
						gchar* type_id = NULL;
						ValaSymbol* _tmp49_;
						gchar* _tmp50_;
						const gchar* _tmp51_;
						_tmp49_ = self->priv->sym;
						_tmp50_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp49_);
						type_id = _tmp50_;
						_tmp51_ = type_id;
						if (g_strcmp0 (_tmp51_, "G_TYPE_INT") == 0) {
							gchar* _tmp52_;
							_tmp52_ = g_strdup ("g_param_spec_int");
							result = _tmp52_;
							_g_free0 (type_id);
							return result;
						} else {
							const gchar* _tmp53_;
							_tmp53_ = type_id;
							if (g_strcmp0 (_tmp53_, "G_TYPE_UINT") == 0) {
								gchar* _tmp54_;
								_tmp54_ = g_strdup ("g_param_spec_uint");
								result = _tmp54_;
								_g_free0 (type_id);
								return result;
							} else {
								const gchar* _tmp55_;
								_tmp55_ = type_id;
								if (g_strcmp0 (_tmp55_, "G_TYPE_INT64") == 0) {
									gchar* _tmp56_;
									_tmp56_ = g_strdup ("g_param_spec_int64");
									result = _tmp56_;
									_g_free0 (type_id);
									return result;
								} else {
									const gchar* _tmp57_;
									_tmp57_ = type_id;
									if (g_strcmp0 (_tmp57_, "G_TYPE_UINT64") == 0) {
										gchar* _tmp58_;
										_tmp58_ = g_strdup ("g_param_spec_uint64");
										result = _tmp58_;
										_g_free0 (type_id);
										return result;
									} else {
										const gchar* _tmp59_;
										_tmp59_ = type_id;
										if (g_strcmp0 (_tmp59_, "G_TYPE_LONG") == 0) {
											gchar* _tmp60_;
											_tmp60_ = g_strdup ("g_param_spec_long");
											result = _tmp60_;
											_g_free0 (type_id);
											return result;
										} else {
											const gchar* _tmp61_;
											_tmp61_ = type_id;
											if (g_strcmp0 (_tmp61_, "G_TYPE_ULONG") == 0) {
												gchar* _tmp62_;
												_tmp62_ = g_strdup ("g_param_spec_ulong");
												result = _tmp62_;
												_g_free0 (type_id);
												return result;
											} else {
												const gchar* _tmp63_;
												_tmp63_ = type_id;
												if (g_strcmp0 (_tmp63_, "G_TYPE_BOOLEAN") == 0) {
													gchar* _tmp64_;
													_tmp64_ = g_strdup ("g_param_spec_boolean");
													result = _tmp64_;
													_g_free0 (type_id);
													return result;
												} else {
													const gchar* _tmp65_;
													_tmp65_ = type_id;
													if (g_strcmp0 (_tmp65_, "G_TYPE_CHAR") == 0) {
														gchar* _tmp66_;
														_tmp66_ = g_strdup ("g_param_spec_char");
														result = _tmp66_;
														_g_free0 (type_id);
														return result;
													} else {
														const gchar* _tmp67_;
														_tmp67_ = type_id;
														if (g_strcmp0 (_tmp67_, "G_TYPE_UCHAR") == 0) {
															gchar* _tmp68_;
															_tmp68_ = g_strdup ("g_param_spec_uchar");
															result = _tmp68_;
															_g_free0 (type_id);
															return result;
														} else {
															const gchar* _tmp69_;
															_tmp69_ = type_id;
															if (g_strcmp0 (_tmp69_, "G_TYPE_FLOAT") == 0) {
																gchar* _tmp70_;
																_tmp70_ = g_strdup ("g_param_spec_float");
																result = _tmp70_;
																_g_free0 (type_id);
																return result;
															} else {
																const gchar* _tmp71_;
																_tmp71_ = type_id;
																if (g_strcmp0 (_tmp71_, "G_TYPE_DOUBLE") == 0) {
																	gchar* _tmp72_;
																	_tmp72_ = g_strdup ("g_param_spec_double");
																	result = _tmp72_;
																	_g_free0 (type_id);
																	return result;
																} else {
																	const gchar* _tmp73_;
																	_tmp73_ = type_id;
																	if (g_strcmp0 (_tmp73_, "G_TYPE_GTYPE") == 0) {
																		gchar* _tmp74_;
																		_tmp74_ = g_strdup ("g_param_spec_gtype");
																		result = _tmp74_;
																		_g_free0 (type_id);
																		return result;
																	} else {
																		gchar* _tmp75_;
																		_tmp75_ = g_strdup ("g_param_spec_boxed");
																		result = _tmp75_;
																		_g_free0 (type_id);
																		return result;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						_g_free0 (type_id);
					}
				}
			}
		}
	} else {
		gboolean _tmp76_ = FALSE;
		ValaCodeNode* _tmp77_;
		_tmp77_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_ARRAY_TYPE)) {
			ValaCodeNode* _tmp78_;
			ValaDataType* _tmp79_;
			ValaDataType* _tmp80_;
			ValaTypeSymbol* _tmp81_;
			ValaTypeSymbol* _tmp82_;
			ValaCodeContext* _tmp83_;
			ValaCodeContext* _tmp84_;
			ValaSemanticAnalyzer* _tmp85_;
			ValaSemanticAnalyzer* _tmp86_;
			ValaDataType* _tmp87_;
			ValaTypeSymbol* _tmp88_;
			ValaTypeSymbol* _tmp89_;
			_tmp78_ = self->priv->node;
			_tmp79_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_data_type_get_data_type (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_code_context_get ();
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_code_context_get_analyzer (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = _tmp86_->string_type;
			_tmp88_ = vala_data_type_get_data_type (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp76_ = _tmp82_ == _tmp89_;
			_vala_code_context_unref0 (_tmp84_);
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			gchar* _tmp90_;
			_tmp90_ = g_strdup ("g_param_spec_boxed");
			result = _tmp90_;
			return result;
		} else {
			gboolean _tmp91_ = FALSE;
			ValaCodeNode* _tmp92_;
			_tmp92_ = self->priv->node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_DATA_TYPE)) {
				ValaCodeNode* _tmp93_;
				ValaTypeSymbol* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				_tmp93_ = self->priv->node;
				_tmp94_ = vala_data_type_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_DATA_TYPE, ValaDataType));
				_tmp95_ = _tmp94_;
				_tmp91_ = _tmp95_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaCodeNode* _tmp96_;
				ValaTypeSymbol* _tmp97_;
				ValaTypeSymbol* _tmp98_;
				gchar* _tmp99_;
				_tmp96_ = self->priv->node;
				_tmp97_ = vala_data_type_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_DATA_TYPE, ValaDataType));
				_tmp98_ = _tmp97_;
				_tmp99_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp98_);
				result = _tmp99_;
				return result;
			}
		}
	}
	_tmp100_ = g_strdup ("g_param_spec_pointer");
	result = _tmp100_;
	return result;
}


static gchar*
vala_ccode_attribute_get_default_default_value (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ENUM)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("0");
		result = _tmp1_;
		return result;
	} else {
		ValaSymbol* _tmp2_;
		_tmp2_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaSymbol* _tmp3_;
			ValaStruct* base_st = NULL;
			ValaStruct* _tmp4_;
			ValaStruct* _tmp5_;
			ValaStruct* _tmp6_;
			ValaStruct* _tmp7_;
			_tmp3_ = self->priv->sym;
			st = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_STRUCT, ValaStruct);
			_tmp4_ = st;
			_tmp5_ = vala_struct_get_base_struct (_tmp4_);
			_tmp6_ = _tmp5_;
			base_st = _tmp6_;
			_tmp7_ = base_st;
			if (_tmp7_ != NULL) {
				ValaStruct* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = base_st;
				_tmp9_ = vala_get_ccode_default_value ((ValaTypeSymbol*) _tmp8_);
				result = _tmp9_;
				return result;
			}
		}
	}
	_tmp10_ = g_strdup ("");
	result = _tmp10_;
	return result;
}


static gchar*
vala_ccode_attribute_get_finish_name_for_basename (ValaCCodeAttribute* self,
                                                   const gchar* basename)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	_tmp0_ = g_strdup (basename);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (g_str_has_suffix (_tmp1_, "_async")) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = _result_;
		_tmp3_ = _result_;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = strlen ("_async");
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp5_ - _tmp7_));
		_g_free0 (_result_);
		_result_ = _tmp8_;
	}
	_tmp9_ = _result_;
	_tmp10_ = g_strdup_printf ("%s_finish", _tmp9_);
	result = _tmp10_;
	_g_free0 (_result_);
	return result;
}


static gchar*
vala_ccode_attribute_get_default_real_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CREATION_METHOD)) {
		ValaCreationMethod* m = NULL;
		ValaSymbol* _tmp1_;
		ValaClass* parent = NULL;
		ValaCreationMethod* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		gboolean _tmp5_ = FALSE;
		ValaClass* _tmp6_;
		gchar* infix = NULL;
		gchar* _tmp13_;
		ValaCreationMethod* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp1_ = self->priv->sym;
		m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp2_ = m;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		parent = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp4_) : NULL;
		_tmp6_ = parent;
		if (_tmp6_ == NULL) {
			_tmp5_ = TRUE;
		} else {
			ValaClass* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = parent;
			_tmp8_ = vala_class_get_is_compact (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_;
		}
		if (_tmp5_) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = vala_ccode_attribute_get_name (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		_tmp13_ = g_strdup ("construct");
		infix = _tmp13_;
		_tmp14_ = m;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (g_strcmp0 (_tmp16_, ".new") == 0) {
			ValaClass* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp17_ = parent;
			_tmp18_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = infix;
			_tmp21_ = g_strdup_printf ("%s%s", _tmp19_, _tmp20_);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp19_);
			result = _tmp22_;
			_g_free0 (infix);
			return result;
		} else {
			ValaClass* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			ValaCreationMethod* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp23_ = parent;
			_tmp24_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = infix;
			_tmp27_ = m;
			_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("%s%s_%s", _tmp25_, _tmp26_, _tmp29_);
			_tmp31_ = _tmp30_;
			_g_free0 (_tmp25_);
			result = _tmp31_;
			_g_free0 (infix);
			return result;
		}
		_g_free0 (infix);
	} else {
		ValaSymbol* _tmp32_;
		_tmp32_ = self->priv->sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, VALA_TYPE_METHOD)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp33_;
			gboolean _tmp34_ = FALSE;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			ValaMethod* _tmp37_;
			_tmp33_ = self->priv->sym;
			m = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_METHOD, ValaMethod);
			_tmp35_ = m;
			_tmp36_ = vala_method_get_base_method (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				_tmp34_ = TRUE;
			} else {
				ValaMethod* _tmp38_;
				ValaMethod* _tmp39_;
				ValaMethod* _tmp40_;
				_tmp38_ = m;
				_tmp39_ = vala_method_get_base_interface_method (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp34_ = _tmp40_ != NULL;
			}
			if (_tmp34_) {
				gchar* m_name = NULL;
				ValaMethod* _tmp41_;
				ValaSignal* _tmp42_;
				ValaSignal* _tmp43_;
				ValaMethod* _tmp52_;
				ValaDataType* _tmp53_;
				ValaDataType* _tmp54_;
				_tmp41_ = m;
				_tmp42_ = vala_method_get_signal_reference (_tmp41_);
				_tmp43_ = _tmp42_;
				if (_tmp43_ != NULL) {
					ValaMethod* _tmp44_;
					ValaSignal* _tmp45_;
					ValaSignal* _tmp46_;
					gchar* _tmp47_;
					_tmp44_ = m;
					_tmp45_ = vala_method_get_signal_reference (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp46_, NULL);
					_g_free0 (m_name);
					m_name = _tmp47_;
				} else {
					ValaMethod* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = m;
					_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_strdup (_tmp50_);
					_g_free0 (m_name);
					m_name = _tmp51_;
				}
				_tmp52_ = m;
				_tmp53_ = vala_method_get_base_interface_type (_tmp52_);
				_tmp54_ = _tmp53_;
				if (_tmp54_ != NULL) {
					ValaMethod* _tmp55_;
					ValaSymbol* _tmp56_;
					ValaSymbol* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					ValaMethod* _tmp60_;
					ValaDataType* _tmp61_;
					ValaDataType* _tmp62_;
					ValaTypeSymbol* _tmp63_;
					ValaTypeSymbol* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp55_ = m;
					_tmp56_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = vala_get_ccode_lower_case_prefix (_tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = m;
					_tmp61_ = vala_method_get_base_interface_type (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = vala_data_type_get_data_type (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = m_name;
					_tmp68_ = g_strdup_printf ("%sreal_%s%s", _tmp59_, _tmp66_, _tmp67_);
					_tmp69_ = _tmp68_;
					_g_free0 (_tmp66_);
					_g_free0 (_tmp59_);
					result = _tmp69_;
					_g_free0 (m_name);
					return result;
				} else {
					ValaMethod* _tmp70_;
					ValaSymbol* _tmp71_;
					ValaSymbol* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					const gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					_tmp70_ = m;
					_tmp71_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_get_ccode_lower_case_prefix (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = m_name;
					_tmp76_ = g_strdup_printf ("%sreal_%s", _tmp74_, _tmp75_);
					_tmp77_ = _tmp76_;
					_g_free0 (_tmp74_);
					result = _tmp77_;
					_g_free0 (m_name);
					return result;
				}
				_g_free0 (m_name);
			} else {
				const gchar* _tmp78_;
				const gchar* _tmp79_;
				gchar* _tmp80_;
				_tmp78_ = vala_ccode_attribute_get_name (self);
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strdup (_tmp79_);
				result = _tmp80_;
				return result;
			}
		} else {
			ValaSymbol* _tmp81_;
			_tmp81_ = self->priv->sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, VALA_TYPE_PROPERTY_ACCESSOR)) {
				ValaPropertyAccessor* acc = NULL;
				ValaSymbol* _tmp82_;
				ValaProperty* prop = NULL;
				ValaPropertyAccessor* _tmp83_;
				ValaProperty* _tmp84_;
				ValaProperty* _tmp85_;
				gboolean _tmp86_ = FALSE;
				ValaProperty* _tmp87_;
				ValaProperty* _tmp88_;
				ValaProperty* _tmp89_;
				_tmp82_ = self->priv->sym;
				acc = G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
				_tmp83_ = acc;
				_tmp84_ = vala_property_accessor_get_prop (_tmp83_);
				_tmp85_ = _tmp84_;
				prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_PROPERTY, ValaProperty);
				_tmp87_ = prop;
				_tmp88_ = vala_property_get_base_property (_tmp87_);
				_tmp89_ = _tmp88_;
				if (_tmp89_ != NULL) {
					_tmp86_ = TRUE;
				} else {
					ValaProperty* _tmp90_;
					ValaProperty* _tmp91_;
					ValaProperty* _tmp92_;
					_tmp90_ = prop;
					_tmp91_ = vala_property_get_base_interface_property (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp86_ = _tmp92_ != NULL;
				}
				if (_tmp86_) {
					ValaPropertyAccessor* _tmp93_;
					gboolean _tmp94_;
					gboolean _tmp95_;
					_tmp93_ = acc;
					_tmp94_ = vala_property_accessor_get_readable (_tmp93_);
					_tmp95_ = _tmp94_;
					if (_tmp95_) {
						ValaProperty* _tmp96_;
						ValaSymbol* _tmp97_;
						ValaSymbol* _tmp98_;
						gchar* _tmp99_;
						gchar* _tmp100_;
						ValaProperty* _tmp101_;
						const gchar* _tmp102_;
						const gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						_tmp96_ = prop;
						_tmp97_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = vala_get_ccode_lower_case_prefix (_tmp98_);
						_tmp100_ = _tmp99_;
						_tmp101_ = prop;
						_tmp102_ = vala_symbol_get_name ((ValaSymbol*) _tmp101_);
						_tmp103_ = _tmp102_;
						_tmp104_ = g_strdup_printf ("%sreal_get_%s", _tmp100_, _tmp103_);
						_tmp105_ = _tmp104_;
						_g_free0 (_tmp100_);
						result = _tmp105_;
						return result;
					} else {
						ValaProperty* _tmp106_;
						ValaSymbol* _tmp107_;
						ValaSymbol* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						ValaProperty* _tmp111_;
						const gchar* _tmp112_;
						const gchar* _tmp113_;
						gchar* _tmp114_;
						gchar* _tmp115_;
						_tmp106_ = prop;
						_tmp107_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp106_);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_get_ccode_lower_case_prefix (_tmp108_);
						_tmp110_ = _tmp109_;
						_tmp111_ = prop;
						_tmp112_ = vala_symbol_get_name ((ValaSymbol*) _tmp111_);
						_tmp113_ = _tmp112_;
						_tmp114_ = g_strdup_printf ("%sreal_set_%s", _tmp110_, _tmp113_);
						_tmp115_ = _tmp114_;
						_g_free0 (_tmp110_);
						result = _tmp115_;
						return result;
					}
				} else {
					const gchar* _tmp116_;
					const gchar* _tmp117_;
					gchar* _tmp118_;
					_tmp116_ = vala_ccode_attribute_get_name (self);
					_tmp117_ = _tmp116_;
					_tmp118_ = g_strdup (_tmp117_);
					result = _tmp118_;
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


static gchar*
vala_ccode_attribute_get_default_const_name (ValaCCodeAttribute* self)
{
	gchar* result = NULL;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_DATA_TYPE)) {
		ValaDataType* type = NULL;
		ValaCodeNode* _tmp1_;
		gchar* ptr = NULL;
		ValaTypeSymbol* t = NULL;
		ValaDataType* _tmp2_;
		ValaTypeSymbol* _tmp13_;
		ValaTypeSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp1_ = self->priv->node;
		type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_DATA_TYPE, ValaDataType);
		_tmp2_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_ARRAY_TYPE)) {
			ValaDataType* _tmp3_;
			ValaDataType* _tmp4_;
			ValaDataType* _tmp5_;
			ValaTypeSymbol* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_tmp3_ = type;
			_tmp4_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_data_type_get_data_type (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _vala_code_node_ref0 (_tmp7_);
			_vala_code_node_unref0 (t);
			t = _tmp8_;
		} else {
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp9_ = type;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			_vala_code_node_unref0 (t);
			t = _tmp12_;
		}
		_tmp13_ = t;
		if (!vala_typesymbol_is_reference_type (_tmp13_)) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("");
			_g_free0 (ptr);
			ptr = _tmp14_;
		} else {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("*");
			_g_free0 (ptr);
			ptr = _tmp15_;
		}
		_tmp16_ = t;
		_tmp17_ = vala_get_ccode_name ((ValaCodeNode*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = ptr;
		_tmp20_ = g_strdup_printf ("const %s%s", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp18_);
		result = _tmp21_;
		_vala_code_node_unref0 (t);
		_g_free0 (ptr);
		return result;
	} else {
		gboolean _tmp22_ = FALSE;
		ValaCodeNode* _tmp23_;
		_tmp23_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_CLASS)) {
			ValaCodeNode* _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp26_;
			_tmp24_ = self->priv->node;
			_tmp25_ = vala_class_get_is_immutable (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_CLASS, ValaClass));
			_tmp26_ = _tmp25_;
			_tmp22_ = _tmp26_;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp27_ = vala_ccode_attribute_get_name (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf ("const %s", _tmp28_);
			result = _tmp29_;
			return result;
		} else {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp30_ = vala_ccode_attribute_get_name (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strdup (_tmp31_);
			result = _tmp32_;
			return result;
		}
	}
}


static gboolean
vala_ccode_attribute_get_default_array_length (ValaCCodeAttribute* self)
{
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp1_;
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		_tmp1_ = self->priv->node;
		param = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PARAMETER, ValaParameter);
		_tmp2_ = param;
		_tmp3_ = vala_parameter_get_base_parameter (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaParameter* _tmp5_;
			ValaParameter* _tmp6_;
			ValaParameter* _tmp7_;
			_tmp5_ = param;
			_tmp6_ = vala_parameter_get_base_parameter (_tmp5_);
			_tmp7_ = _tmp6_;
			result = vala_get_ccode_array_length ((ValaCodeNode*) _tmp7_);
			return result;
		}
	} else {
		ValaCodeNode* _tmp8_;
		_tmp8_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaCodeNode* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaMethod* _tmp11_;
			ValaMethod* _tmp12_;
			ValaMethod* _tmp13_;
			_tmp9_ = self->priv->node;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_METHOD, ValaMethod);
			_tmp11_ = method;
			_tmp12_ = vala_method_get_base_method (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaMethod* _tmp14_;
				ValaMethod* _tmp15_;
				ValaMethod* _tmp16_;
				ValaMethod* _tmp17_;
				_tmp14_ = method;
				_tmp15_ = vala_method_get_base_method (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = method;
				_tmp10_ = _tmp16_ != _tmp17_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaMethod* _tmp18_;
				ValaMethod* _tmp19_;
				ValaMethod* _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_base_method (_tmp18_);
				_tmp20_ = _tmp19_;
				result = vala_get_ccode_array_length ((ValaCodeNode*) _tmp20_);
				return result;
			} else {
				gboolean _tmp21_ = FALSE;
				ValaMethod* _tmp22_;
				ValaMethod* _tmp23_;
				ValaMethod* _tmp24_;
				_tmp22_ = method;
				_tmp23_ = vala_method_get_base_interface_method (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ != NULL) {
					ValaMethod* _tmp25_;
					ValaMethod* _tmp26_;
					ValaMethod* _tmp27_;
					ValaMethod* _tmp28_;
					_tmp25_ = method;
					_tmp26_ = vala_method_get_base_interface_method (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = method;
					_tmp21_ = _tmp27_ != _tmp28_;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					ValaMethod* _tmp29_;
					ValaMethod* _tmp30_;
					ValaMethod* _tmp31_;
					_tmp29_ = method;
					_tmp30_ = vala_method_get_base_interface_method (_tmp29_);
					_tmp31_ = _tmp30_;
					result = vala_get_ccode_array_length ((ValaCodeNode*) _tmp31_);
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean
vala_ccode_attribute_get_default_array_null_terminated (ValaCCodeAttribute* self)
{
	gboolean result = FALSE;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaCodeNode* _tmp1_;
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		_tmp1_ = self->priv->node;
		param = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PARAMETER, ValaParameter);
		_tmp2_ = param;
		_tmp3_ = vala_parameter_get_base_parameter (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaParameter* _tmp5_;
			ValaParameter* _tmp6_;
			ValaParameter* _tmp7_;
			_tmp5_ = param;
			_tmp6_ = vala_parameter_get_base_parameter (_tmp5_);
			_tmp7_ = _tmp6_;
			result = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp7_);
			return result;
		}
	} else {
		ValaCodeNode* _tmp8_;
		_tmp8_ = self->priv->node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaCodeNode* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaMethod* _tmp11_;
			ValaMethod* _tmp12_;
			ValaMethod* _tmp13_;
			_tmp9_ = self->priv->node;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_METHOD, ValaMethod);
			_tmp11_ = method;
			_tmp12_ = vala_method_get_base_method (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaMethod* _tmp14_;
				ValaMethod* _tmp15_;
				ValaMethod* _tmp16_;
				ValaMethod* _tmp17_;
				_tmp14_ = method;
				_tmp15_ = vala_method_get_base_method (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = method;
				_tmp10_ = _tmp16_ != _tmp17_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaMethod* _tmp18_;
				ValaMethod* _tmp19_;
				ValaMethod* _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_base_method (_tmp18_);
				_tmp20_ = _tmp19_;
				result = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp20_);
				return result;
			} else {
				gboolean _tmp21_ = FALSE;
				ValaMethod* _tmp22_;
				ValaMethod* _tmp23_;
				ValaMethod* _tmp24_;
				_tmp22_ = method;
				_tmp23_ = vala_method_get_base_interface_method (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ != NULL) {
					ValaMethod* _tmp25_;
					ValaMethod* _tmp26_;
					ValaMethod* _tmp27_;
					ValaMethod* _tmp28_;
					_tmp25_ = method;
					_tmp26_ = vala_method_get_base_interface_method (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = method;
					_tmp21_ = _tmp27_ != _tmp28_;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					ValaMethod* _tmp29_;
					ValaMethod* _tmp30_;
					ValaMethod* _tmp31_;
					_tmp29_ = method;
					_tmp30_ = vala_method_get_base_interface_method (_tmp29_);
					_tmp31_ = _tmp30_;
					result = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp31_);
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


const gchar*
vala_ccode_attribute_get_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "cname", NULL);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp3_;
		}
		_tmp4_ = self->priv->_name;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_name (self);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_name;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_const_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_const_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "const_cname", NULL);
			_g_free0 (self->priv->_const_name);
			self->priv->_const_name = _tmp3_;
		}
		_tmp4_ = self->priv->_const_name;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_const_name (self);
			_g_free0 (self->priv->_const_name);
			self->priv->_const_name = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_const_name;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_type_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "type_cname", NULL);
			_g_free0 (self->priv->_type_name);
			self->priv->_type_name = _tmp3_;
		}
		_tmp4_ = self->priv->_type_name;
		if (_tmp4_ == NULL) {
			ValaSymbol* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = self->priv->sym;
			_tmp6_ = vala_get_ccode_name ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup_printf ("%sIface", _tmp7_);
			_g_free0 (self->priv->_type_name);
			self->priv->_type_name = _tmp8_;
			_g_free0 (_tmp7_);
		}
	}
	_tmp9_ = self->priv->_type_name;
	result = _tmp9_;
	return result;
}


const gchar*
vala_ccode_attribute_get_feature_test_macros (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_feature_test_macros;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "feature_test_macro", NULL);
			_g_free0 (self->priv->_feature_test_macros);
			self->priv->_feature_test_macros = _tmp3_;
		}
		_tmp4_ = self->priv->_feature_test_macros;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			_g_free0 (self->priv->_feature_test_macros);
			self->priv->_feature_test_macros = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_feature_test_macros;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_header_filenames (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_filenames;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "cheader_filename", NULL);
			_g_free0 (self->priv->_header_filenames);
			self->priv->_header_filenames = _tmp3_;
		}
		_tmp4_ = self->priv->_header_filenames;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_header_filenames (self);
			_g_free0 (self->priv->_header_filenames);
			self->priv->_header_filenames = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_header_filenames;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_prefix (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefix;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "cprefix", NULL);
			_g_free0 (self->priv->_prefix);
			self->priv->_prefix = _tmp3_;
		}
		_tmp4_ = self->priv->_prefix;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_prefix (self);
			_g_free0 (self->priv->_prefix);
			self->priv->_prefix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_prefix;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_lower_case_prefix (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lower_case_prefix;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp11_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			gboolean _tmp4_ = FALSE;
			const gchar* _tmp5_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "lower_case_cprefix", NULL);
			_g_free0 (self->priv->_lower_case_prefix);
			self->priv->_lower_case_prefix = _tmp3_;
			_tmp5_ = self->priv->_lower_case_prefix;
			if (_tmp5_ == NULL) {
				gboolean _tmp6_ = FALSE;
				ValaSymbol* _tmp7_;
				_tmp7_ = self->priv->sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
					_tmp6_ = TRUE;
				} else {
					ValaSymbol* _tmp8_;
					_tmp8_ = self->priv->sym;
					_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_STRUCT);
				}
				_tmp4_ = _tmp6_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				ValaAttribute* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = self->priv->ccode;
				_tmp10_ = vala_attribute_get_string (_tmp9_, "cprefix", NULL);
				_g_free0 (self->priv->_lower_case_prefix);
				self->priv->_lower_case_prefix = _tmp10_;
			}
		}
		_tmp11_ = self->priv->_lower_case_prefix;
		if (_tmp11_ == NULL) {
			gchar* _tmp12_;
			_tmp12_ = vala_ccode_attribute_get_default_lower_case_prefix (self);
			_g_free0 (self->priv->_lower_case_prefix);
			self->priv->_lower_case_prefix = _tmp12_;
		}
	}
	_tmp13_ = self->priv->_lower_case_prefix;
	result = _tmp13_;
	return result;
}


const gchar*
vala_ccode_attribute_get_lower_case_suffix (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lower_case_suffix;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "lower_case_csuffix", NULL);
			_g_free0 (self->priv->_lower_case_suffix);
			self->priv->_lower_case_suffix = _tmp3_;
		}
		_tmp4_ = self->priv->_lower_case_suffix;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_lower_case_suffix (self);
			_g_free0 (self->priv->_lower_case_suffix);
			self->priv->_lower_case_suffix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_lower_case_suffix;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_ref_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ref_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "ref_function", NULL);
			_g_free0 (self->priv->_ref_function);
			self->priv->_ref_function = _tmp3_;
		}
		_tmp4_ = self->priv->_ref_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_ref_function (self);
			_g_free0 (self->priv->_ref_function);
			self->priv->_ref_function = _tmp5_;
		}
		self->priv->ref_function_set = TRUE;
	}
	_tmp6_ = self->priv->_ref_function;
	result = _tmp6_;
	return result;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_ccode_attribute_get_ref_function_void (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ref_function_void;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaAttribute* _tmp3_;
			_tmp3_ = self->priv->ccode;
			_tmp1_ = vala_attribute_has_argument (_tmp3_, "ref_function_void");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gboolean _tmp5_;
			gboolean* _tmp6_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_bool (_tmp4_, "ref_function_void", FALSE);
			_tmp6_ = __bool_dup0 (&_tmp5_);
			_g_free0 (self->priv->_ref_function_void);
			self->priv->_ref_function_void = _tmp6_;
		} else {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_;
			ValaClass* _tmp8_;
			ValaClass* _tmp9_;
			ValaClass* _tmp10_;
			ValaClass* _tmp11_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp8_;
			_tmp9_ = cl;
			_tmp10_ = vala_class_get_base_class (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaClass* _tmp12_;
				ValaClass* _tmp13_;
				ValaClass* _tmp14_;
				gboolean _tmp15_;
				gboolean* _tmp16_;
				_tmp12_ = cl;
				_tmp13_ = vala_class_get_base_class (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_get_ccode_ref_function_void (_tmp14_);
				_tmp16_ = __bool_dup0 (&_tmp15_);
				_g_free0 (self->priv->_ref_function_void);
				self->priv->_ref_function_void = _tmp16_;
			} else {
				gboolean _tmp17_;
				gboolean* _tmp18_;
				_tmp17_ = FALSE;
				_tmp18_ = __bool_dup0 (&_tmp17_);
				_g_free0 (self->priv->_ref_function_void);
				self->priv->_ref_function_void = _tmp18_;
			}
			_vala_code_node_unref0 (cl);
		}
	}
	_tmp19_ = self->priv->_ref_function_void;
	result = *_tmp19_;
	return result;
}


const gchar*
vala_ccode_attribute_get_unref_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->unref_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "unref_function", NULL);
			_g_free0 (self->priv->_unref_function);
			self->priv->_unref_function = _tmp3_;
		}
		_tmp4_ = self->priv->_unref_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_unref_function (self);
			_g_free0 (self->priv->_unref_function);
			self->priv->_unref_function = _tmp5_;
		}
		self->priv->unref_function_set = TRUE;
	}
	_tmp6_ = self->priv->_unref_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_ref_sink_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ref_sink_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "ref_sink_function", NULL);
			_g_free0 (self->priv->_ref_sink_function);
			self->priv->_ref_sink_function = _tmp3_;
		}
		_tmp4_ = self->priv->_ref_sink_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_ref_sink_function (self);
			_g_free0 (self->priv->_ref_sink_function);
			self->priv->_ref_sink_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_ref_sink_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_copy_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->copy_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "copy_function", NULL);
			_g_free0 (self->priv->_copy_function);
			self->priv->_copy_function = _tmp3_;
		}
		_tmp5_ = self->priv->_copy_function;
		if (_tmp5_ == NULL) {
			ValaSymbol* _tmp6_;
			_tmp6_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_STRUCT);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%scopy", _tmp8_);
			_g_free0 (self->priv->_copy_function);
			self->priv->_copy_function = _tmp9_;
		}
		self->priv->copy_function_set = TRUE;
	}
	_tmp10_ = self->priv->_copy_function;
	result = _tmp10_;
	return result;
}


const gchar*
vala_ccode_attribute_get_destroy_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->destroy_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "destroy_function", NULL);
			_g_free0 (self->priv->_destroy_function);
			self->priv->_destroy_function = _tmp3_;
		}
		_tmp5_ = self->priv->_destroy_function;
		if (_tmp5_ == NULL) {
			ValaSymbol* _tmp6_;
			_tmp6_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_STRUCT);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%sdestroy", _tmp8_);
			_g_free0 (self->priv->_destroy_function);
			self->priv->_destroy_function = _tmp9_;
		}
		self->priv->destroy_function_set = TRUE;
	}
	_tmp10_ = self->priv->_destroy_function;
	result = _tmp10_;
	return result;
}


const gchar*
vala_ccode_attribute_get_dup_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dup_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "dup_function", NULL);
			_g_free0 (self->priv->_dup_function);
			self->priv->_dup_function = _tmp3_;
		}
		_tmp6_ = self->priv->_dup_function;
		if (_tmp6_ == NULL) {
			ValaSymbol* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = self->priv->sym;
			_tmp8_ = vala_symbol_get_external_package (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaSymbol* _tmp10_;
			_tmp10_ = self->priv->sym;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = vala_ccode_attribute_get_lower_case_prefix (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("%sdup", _tmp12_);
			_g_free0 (self->priv->_dup_function);
			self->priv->_dup_function = _tmp13_;
		}
		self->priv->dup_function_set = TRUE;
	}
	_tmp14_ = self->priv->_dup_function;
	result = _tmp14_;
	return result;
}


const gchar*
vala_ccode_attribute_get_free_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->free_function_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "free_function", NULL);
			_g_free0 (self->priv->_free_function);
			self->priv->_free_function = _tmp3_;
		}
		_tmp4_ = self->priv->_free_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_free_function (self);
			_g_free0 (self->priv->_free_function);
			self->priv->_free_function = _tmp5_;
		}
		self->priv->free_function_set = TRUE;
	}
	_tmp6_ = self->priv->_free_function;
	result = _tmp6_;
	return result;
}


gboolean
vala_ccode_attribute_get_free_function_address_of (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_free_function_address_of;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaAttribute* _tmp3_;
			_tmp3_ = self->priv->ccode;
			_tmp1_ = vala_attribute_has_argument (_tmp3_, "free_function_address_of");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gboolean _tmp5_;
			gboolean* _tmp6_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_bool (_tmp4_, "free_function_address_of", FALSE);
			_tmp6_ = __bool_dup0 (&_tmp5_);
			_g_free0 (self->priv->_free_function_address_of);
			self->priv->_free_function_address_of = _tmp6_;
		} else {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_;
			ValaClass* _tmp8_;
			ValaClass* _tmp9_;
			ValaClass* _tmp10_;
			_tmp7_ = self->priv->sym;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_CLASS, ValaClass);
			_tmp8_ = cl;
			_tmp9_ = vala_class_get_base_class (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaClass* _tmp11_;
				ValaClass* _tmp12_;
				ValaClass* _tmp13_;
				gboolean _tmp14_;
				gboolean* _tmp15_;
				_tmp11_ = cl;
				_tmp12_ = vala_class_get_base_class (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_get_ccode_free_function_address_of (_tmp13_);
				_tmp15_ = __bool_dup0 (&_tmp14_);
				_g_free0 (self->priv->_free_function_address_of);
				self->priv->_free_function_address_of = _tmp15_;
			} else {
				gboolean _tmp16_;
				gboolean* _tmp17_;
				_tmp16_ = FALSE;
				_tmp17_ = __bool_dup0 (&_tmp16_);
				_g_free0 (self->priv->_free_function_address_of);
				self->priv->_free_function_address_of = _tmp17_;
			}
		}
	}
	_tmp18_ = self->priv->_free_function_address_of;
	result = *_tmp18_;
	return result;
}


const gchar*
vala_ccode_attribute_get_ctype (ValaCCodeAttribute* self)
{
	const gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ctype_set;
	if (!_tmp0_) {
		ValaAttribute* _tmp1_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "type", NULL);
			_g_free0 (self->priv->_ctype);
			self->priv->_ctype = _tmp3_;
			_tmp4_ = self->priv->_ctype;
			if (_tmp4_ == NULL) {
				ValaAttribute* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = self->priv->ccode;
				_tmp6_ = vala_attribute_get_string (_tmp5_, "ctype", NULL);
				_g_free0 (self->priv->_ctype);
				self->priv->_ctype = _tmp6_;
			}
		}
		self->priv->ctype_set = TRUE;
	}
	_tmp7_ = self->priv->_ctype;
	result = _tmp7_;
	return result;
}


const gchar*
vala_ccode_attribute_get_type_id (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_id;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "type_id", NULL);
			_g_free0 (self->priv->_type_id);
			self->priv->_type_id = _tmp3_;
		}
		_tmp4_ = self->priv->_type_id;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_type_id (self);
			_g_free0 (self->priv->_type_id);
			self->priv->_type_id = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_type_id;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_marshaller_type_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_marshaller_type_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "marshaller_type_name", NULL);
			_g_free0 (self->priv->_marshaller_type_name);
			self->priv->_marshaller_type_name = _tmp3_;
		}
		_tmp4_ = self->priv->_marshaller_type_name;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_marshaller_type_name (self);
			_g_free0 (self->priv->_marshaller_type_name);
			self->priv->_marshaller_type_name = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_marshaller_type_name;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_get_value_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_value_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "get_value_function", NULL);
			_g_free0 (self->priv->_get_value_function);
			self->priv->_get_value_function = _tmp3_;
		}
		_tmp4_ = self->priv->_get_value_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_get_value_function (self);
			_g_free0 (self->priv->_get_value_function);
			self->priv->_get_value_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_get_value_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_set_value_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_value_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "set_value_function", NULL);
			_g_free0 (self->priv->_set_value_function);
			self->priv->_set_value_function = _tmp3_;
		}
		_tmp4_ = self->priv->_set_value_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_set_value_function (self);
			_g_free0 (self->priv->_set_value_function);
			self->priv->_set_value_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_set_value_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_take_value_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_take_value_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "take_value_function", NULL);
			_g_free0 (self->priv->_take_value_function);
			self->priv->_take_value_function = _tmp3_;
		}
		_tmp4_ = self->priv->_take_value_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_take_value_function (self);
			_g_free0 (self->priv->_take_value_function);
			self->priv->_take_value_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_take_value_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_param_spec_function (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_param_spec_function;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "param_spec_function", NULL);
			_g_free0 (self->priv->_param_spec_function);
			self->priv->_param_spec_function = _tmp3_;
		}
		_tmp4_ = self->priv->_param_spec_function;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_param_spec_function (self);
			_g_free0 (self->priv->_param_spec_function);
			self->priv->_param_spec_function = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_param_spec_function;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_default_value (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_value;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "default_value", NULL);
			_g_free0 (self->priv->_default_value);
			self->priv->_default_value = _tmp3_;
		}
		_tmp4_ = self->priv->_default_value;
		if (_tmp4_ == NULL) {
			gchar* _tmp5_;
			_tmp5_ = vala_ccode_attribute_get_default_default_value (self);
			_g_free0 (self->priv->_default_value);
			self->priv->_default_value = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_default_value;
	result = _tmp6_;
	return result;
}


const gchar*
vala_ccode_attribute_get_default_value_on_error (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_value_on_error;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "default_value_on_error", NULL);
			_g_free0 (self->priv->_default_value_on_error);
			self->priv->_default_value_on_error = _tmp3_;
		}
		_tmp4_ = self->priv->_default_value_on_error;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = vala_ccode_attribute_get_default_value (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (self->priv->_default_value_on_error);
			self->priv->_default_value_on_error = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_default_value_on_error;
	result = _tmp8_;
	return result;
}


gdouble
vala_ccode_attribute_get_pos (ValaCCodeAttribute* self)
{
	gdouble result;
	gdouble* _tmp0_;
	gdouble* _tmp20_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_pos;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaAttribute* _tmp3_;
			_tmp3_ = self->priv->ccode;
			_tmp1_ = vala_attribute_has_argument (_tmp3_, "pos");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gdouble _tmp5_;
			gdouble* _tmp6_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_double (_tmp4_, "pos", (gdouble) 0);
			_tmp6_ = __double_dup0 (&_tmp5_);
			_g_free0 (self->priv->_pos);
			self->priv->_pos = _tmp6_;
		} else {
			ValaParameter* param = NULL;
			ValaCodeNode* _tmp7_;
			ValaCallable* callable = NULL;
			ValaParameter* _tmp8_;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaCallable* _tmp11_;
			_tmp7_ = self->priv->node;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp8_ = param;
			_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			callable = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_CALLABLE) ? ((ValaCallable*) _tmp10_) : NULL;
			_tmp11_ = callable;
			if (_tmp11_ != NULL) {
				ValaCallable* _tmp12_;
				ValaList* _tmp13_;
				ValaList* _tmp14_;
				ValaParameter* _tmp15_;
				gdouble _tmp16_;
				gdouble* _tmp17_;
				_tmp12_ = callable;
				_tmp13_ = vala_callable_get_parameters (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = param;
				_tmp16_ = vala_list_index_of (_tmp14_, _tmp15_) + 1.0;
				_tmp17_ = __double_dup0 (&_tmp16_);
				_g_free0 (self->priv->_pos);
				self->priv->_pos = _tmp17_;
				_vala_iterable_unref0 (_tmp14_);
			} else {
				gdouble _tmp18_;
				gdouble* _tmp19_;
				_tmp18_ = 0.0;
				_tmp19_ = __double_dup0 (&_tmp18_);
				_g_free0 (self->priv->_pos);
				self->priv->_pos = _tmp19_;
			}
		}
	}
	_tmp20_ = self->priv->_pos;
	result = *_tmp20_;
	return result;
}


const gchar*
vala_ccode_attribute_get_real_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_real_name;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaAttribute* _tmp2_;
		const gchar* _tmp6_;
		_tmp2_ = self->priv->ccode;
		if (_tmp2_ != NULL) {
			ValaSymbol* _tmp3_;
			_tmp3_ = self->priv->sym;
			_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaAttribute* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->ccode;
			_tmp5_ = vala_attribute_get_string (_tmp4_, "construct_function", NULL);
			_g_free0 (self->priv->_real_name);
			self->priv->_real_name = _tmp5_;
		}
		_tmp6_ = self->priv->_real_name;
		if (_tmp6_ == NULL) {
			gchar* _tmp7_;
			_tmp7_ = vala_ccode_attribute_get_default_real_name (self);
			_g_free0 (self->priv->_real_name);
			self->priv->_real_name = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_real_name;
	result = _tmp8_;
	return result;
}


const gchar*
vala_ccode_attribute_get_vfunc_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vfunc_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "vfunc_name", NULL);
			_g_free0 (self->priv->_vfunc_name);
			self->priv->_vfunc_name = _tmp3_;
		}
		_tmp4_ = self->priv->_vfunc_name;
		if (_tmp4_ == NULL) {
			ValaMethod* m = NULL;
			ValaCodeNode* _tmp5_;
			gboolean _tmp6_ = FALSE;
			ValaMethod* _tmp7_;
			_tmp5_ = self->priv->node;
			m = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp5_) : NULL;
			_tmp7_ = m;
			if (_tmp7_ != NULL) {
				ValaMethod* _tmp8_;
				ValaSignal* _tmp9_;
				ValaSignal* _tmp10_;
				_tmp8_ = m;
				_tmp9_ = vala_method_get_signal_reference (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp6_ = _tmp10_ != NULL;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				ValaMethod* _tmp11_;
				ValaSignal* _tmp12_;
				ValaSignal* _tmp13_;
				gchar* _tmp14_;
				_tmp11_ = m;
				_tmp12_ = vala_method_get_signal_reference (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp13_, NULL);
				_g_free0 (self->priv->_vfunc_name);
				self->priv->_vfunc_name = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = self->priv->sym;
				_tmp16_ = vala_symbol_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (self->priv->_vfunc_name);
				self->priv->_vfunc_name = _tmp18_;
			}
		}
	}
	_tmp19_ = self->priv->_vfunc_name;
	result = _tmp19_;
	return result;
}


const gchar*
vala_ccode_attribute_get_finish_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finish_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp7_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "finish_name", NULL);
			_g_free0 (self->priv->_finish_name);
			self->priv->_finish_name = _tmp3_;
			_tmp4_ = self->priv->_finish_name;
			if (_tmp4_ == NULL) {
				ValaAttribute* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = self->priv->ccode;
				_tmp6_ = vala_attribute_get_string (_tmp5_, "finish_function", NULL);
				_g_free0 (self->priv->_finish_name);
				self->priv->_finish_name = _tmp6_;
			}
		}
		_tmp7_ = self->priv->_finish_name;
		if (_tmp7_ == NULL) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = vala_ccode_attribute_get_name (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_ccode_attribute_get_finish_name_for_basename (self, _tmp9_);
			_g_free0 (self->priv->_finish_name);
			self->priv->_finish_name = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_finish_name;
	result = _tmp11_;
	return result;
}


const gchar*
vala_ccode_attribute_get_finish_vfunc_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finish_vfunc_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "finish_vfunc_name", NULL);
			_g_free0 (self->priv->_finish_vfunc_name);
			self->priv->_finish_vfunc_name = _tmp3_;
		}
		_tmp4_ = self->priv->_finish_vfunc_name;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = vala_ccode_attribute_get_vfunc_name (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_attribute_get_finish_name_for_basename (self, _tmp6_);
			_g_free0 (self->priv->_finish_vfunc_name);
			self->priv->_finish_vfunc_name = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_finish_vfunc_name;
	result = _tmp8_;
	return result;
}


const gchar*
vala_ccode_attribute_get_finish_real_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finish_real_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = vala_ccode_attribute_get_real_name (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_attribute_get_finish_name_for_basename (self, _tmp2_);
		_g_free0 (self->priv->_finish_real_name);
		self->priv->_finish_real_name = _tmp3_;
	}
	_tmp4_ = self->priv->_finish_real_name;
	result = _tmp4_;
	return result;
}


gboolean
vala_ccode_attribute_get_finish_instance (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp21_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_finish_instance;
	if (_tmp0_ == NULL) {
		ValaMethod* m = NULL;
		ValaCodeNode* _tmp1_;
		gboolean is_creation_method = FALSE;
		ValaMethod* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaAttribute* _tmp6_;
		_tmp1_ = self->priv->node;
		m = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL;
		_tmp2_ = m;
		is_creation_method = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CREATION_METHOD);
		_tmp6_ = self->priv->ccode;
		if (_tmp6_ == NULL) {
			_tmp5_ = TRUE;
		} else {
			ValaMethod* _tmp7_;
			_tmp7_ = m;
			_tmp5_ = _tmp7_ == NULL;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			ValaMethod* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = m;
			_tmp9_ = vala_method_get_is_abstract (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = _tmp10_;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			ValaMethod* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = m;
			_tmp12_ = vala_method_get_is_virtual (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp3_ = _tmp13_;
		}
		if (_tmp3_) {
			gboolean _tmp14_;
			gboolean _tmp15_;
			gboolean* _tmp16_;
			_tmp14_ = is_creation_method;
			_tmp15_ = !_tmp14_;
			_tmp16_ = __bool_dup0 (&_tmp15_);
			_g_free0 (self->priv->_finish_instance);
			self->priv->_finish_instance = _tmp16_;
		} else {
			ValaAttribute* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			gboolean* _tmp20_;
			_tmp17_ = self->priv->ccode;
			_tmp18_ = is_creation_method;
			_tmp19_ = vala_attribute_get_bool (_tmp17_, "finish_instance", !_tmp18_);
			_tmp20_ = __bool_dup0 (&_tmp19_);
			_g_free0 (self->priv->_finish_instance);
			self->priv->_finish_instance = _tmp20_;
		}
	}
	_tmp21_ = self->priv->_finish_instance;
	result = *_tmp21_;
	return result;
}


const gchar*
vala_ccode_attribute_get_delegate_target_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_delegate_target_name;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		const gchar* _tmp4_;
		_tmp1_ = self->priv->ccode;
		if (_tmp1_ != NULL) {
			ValaAttribute* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->ccode;
			_tmp3_ = vala_attribute_get_string (_tmp2_, "delegate_target_cname", NULL);
			_g_free0 (self->priv->_delegate_target_name);
			self->priv->_delegate_target_name = _tmp3_;
		}
		_tmp4_ = self->priv->_delegate_target_name;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = vala_ccode_attribute_get_name (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup_printf ("%s_target", _tmp6_);
			_g_free0 (self->priv->_delegate_target_name);
			self->priv->_delegate_target_name = _tmp7_;
		}
	}
	_tmp8_ = self->priv->_delegate_target_name;
	result = _tmp8_;
	return result;
}


gboolean
vala_ccode_attribute_get_array_length (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_array_length;
	if (_tmp0_ == NULL) {
		ValaCodeNode* _tmp1_;
		ValaAttribute* _tmp2_;
		_tmp1_ = self->priv->node;
		_tmp2_ = vala_code_node_get_attribute (_tmp1_, "NoArrayLength");
		if (_tmp2_ != NULL) {
			ValaCodeNode* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp3_ = self->priv->node;
			_tmp4_ = vala_code_node_get_source_reference (_tmp3_);
			_tmp5_ = _tmp4_;
			vala_report_deprecated (_tmp5_, "[NoArrayLength] is deprecated, use [CCode (array_length = false)] inst" \
"ead.");
			_tmp6_ = FALSE;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_array_length);
			self->priv->_array_length = _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			ValaAttribute* _tmp9_;
			_tmp9_ = self->priv->ccode;
			if (_tmp9_ != NULL) {
				ValaAttribute* _tmp10_;
				_tmp10_ = self->priv->ccode;
				_tmp8_ = vala_attribute_has_argument (_tmp10_, "array_length");
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaAttribute* _tmp11_;
				gboolean _tmp12_;
				gboolean* _tmp13_;
				_tmp11_ = self->priv->ccode;
				_tmp12_ = vala_attribute_get_bool (_tmp11_, "array_length", FALSE);
				_tmp13_ = __bool_dup0 (&_tmp12_);
				_g_free0 (self->priv->_array_length);
				self->priv->_array_length = _tmp13_;
			} else {
				gboolean _tmp14_;
				gboolean* _tmp15_;
				_tmp14_ = vala_ccode_attribute_get_default_array_length (self);
				_tmp15_ = __bool_dup0 (&_tmp14_);
				_g_free0 (self->priv->_array_length);
				self->priv->_array_length = _tmp15_;
			}
		}
	}
	_tmp16_ = self->priv->_array_length;
	result = *_tmp16_;
	return result;
}


gboolean
vala_ccode_attribute_get_array_null_terminated (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_array_null_terminated;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaAttribute* _tmp3_;
		_tmp3_ = self->priv->ccode;
		if (_tmp3_ != NULL) {
			ValaAttribute* _tmp4_;
			_tmp4_ = self->priv->ccode;
			_tmp2_ = vala_attribute_has_argument (_tmp4_, "array_length");
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaAttribute* _tmp5_;
			_tmp5_ = self->priv->ccode;
			_tmp1_ = vala_attribute_get_bool (_tmp5_, "array_length", FALSE);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp6_ = FALSE;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_array_null_terminated);
			self->priv->_array_null_terminated = _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			ValaAttribute* _tmp9_;
			_tmp9_ = self->priv->ccode;
			if (_tmp9_ != NULL) {
				ValaAttribute* _tmp10_;
				_tmp10_ = self->priv->ccode;
				_tmp8_ = vala_attribute_has_argument (_tmp10_, "array_null_terminated");
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaAttribute* _tmp11_;
				gboolean _tmp12_;
				gboolean* _tmp13_;
				_tmp11_ = self->priv->ccode;
				_tmp12_ = vala_attribute_get_bool (_tmp11_, "array_null_terminated", FALSE);
				_tmp13_ = __bool_dup0 (&_tmp12_);
				_g_free0 (self->priv->_array_null_terminated);
				self->priv->_array_null_terminated = _tmp13_;
			} else {
				gboolean _tmp14_;
				gboolean* _tmp15_;
				_tmp14_ = vala_ccode_attribute_get_default_array_null_terminated (self);
				_tmp15_ = __bool_dup0 (&_tmp14_);
				_g_free0 (self->priv->_array_null_terminated);
				self->priv->_array_null_terminated = _tmp15_;
			}
		}
	}
	_tmp16_ = self->priv->_array_null_terminated;
	result = *_tmp16_;
	return result;
}


const gchar*
vala_ccode_attribute_get_array_length_type (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_array_length_type;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_array_length_type (ValaCCodeAttribute* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_array_length_type);
	self->priv->_array_length_type = _tmp0_;
}


const gchar*
vala_ccode_attribute_get_array_length_name (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_array_length_name;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_array_length_name (ValaCCodeAttribute* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_array_length_name);
	self->priv->_array_length_name = _tmp0_;
}


const gchar*
vala_ccode_attribute_get_array_length_expr (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_array_length_expr;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_array_length_expr (ValaCCodeAttribute* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_array_length_expr);
	self->priv->_array_length_expr = _tmp0_;
}


gboolean
vala_ccode_attribute_get_delegate_target (ValaCCodeAttribute* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_delegate_target;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_delegate_target (ValaCCodeAttribute* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_delegate_target = value;
}


const gchar*
vala_ccode_attribute_get_sentinel (ValaCCodeAttribute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sentinel;
	result = _tmp0_;
	return result;
}


static void
vala_ccode_attribute_set_sentinel (ValaCCodeAttribute* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sentinel);
	self->priv->_sentinel = _tmp0_;
}


static void
vala_ccode_attribute_class_init (ValaCCodeAttributeClass * klass)
{
	vala_ccode_attribute_parent_class = g_type_class_peek_parent (klass);
	((ValaAttributeCacheClass *) klass)->finalize = vala_ccode_attribute_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeAttribute_private_offset);
}


static void
vala_ccode_attribute_instance_init (ValaCCodeAttribute * self)
{
	self->priv = vala_ccode_attribute_get_instance_private (self);
	self->priv->ctype_set = FALSE;
}


static void
vala_ccode_attribute_finalize (ValaAttributeCache * obj)
{
	ValaCCodeAttribute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_ATTRIBUTE, ValaCCodeAttribute);
	_vala_code_node_unref0 (self->priv->ccode);
	_g_free0 (self->priv->_array_length_type);
	_g_free0 (self->priv->_array_length_name);
	_g_free0 (self->priv->_array_length_expr);
	_g_free0 (self->priv->_sentinel);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_const_name);
	_g_free0 (self->priv->_type_name);
	_g_free0 (self->priv->_feature_test_macros);
	_g_free0 (self->priv->_header_filenames);
	_g_free0 (self->priv->_prefix);
	_g_free0 (self->priv->_lower_case_prefix);
	_g_free0 (self->priv->_lower_case_suffix);
	_g_free0 (self->priv->_ref_function);
	_g_free0 (self->priv->_ref_function_void);
	_g_free0 (self->priv->_unref_function);
	_g_free0 (self->priv->_ref_sink_function);
	_g_free0 (self->priv->_copy_function);
	_g_free0 (self->priv->_destroy_function);
	_g_free0 (self->priv->_dup_function);
	_g_free0 (self->priv->_free_function);
	_g_free0 (self->priv->_free_function_address_of);
	_g_free0 (self->priv->_type_id);
	_g_free0 (self->priv->_marshaller_type_name);
	_g_free0 (self->priv->_get_value_function);
	_g_free0 (self->priv->_set_value_function);
	_g_free0 (self->priv->_take_value_function);
	_g_free0 (self->priv->_param_spec_function);
	_g_free0 (self->priv->_default_value);
	_g_free0 (self->priv->_default_value_on_error);
	_g_free0 (self->priv->_pos);
	_g_free0 (self->priv->_vfunc_name);
	_g_free0 (self->priv->_finish_name);
	_g_free0 (self->priv->_finish_vfunc_name);
	_g_free0 (self->priv->_finish_real_name);
	_g_free0 (self->priv->_finish_instance);
	_g_free0 (self->priv->_real_name);
	_g_free0 (self->priv->_delegate_target_name);
	_g_free0 (self->priv->_ctype);
	_g_free0 (self->priv->_array_length);
	_g_free0 (self->priv->_array_null_terminated);
	VALA_ATTRIBUTE_CACHE_CLASS (vala_ccode_attribute_parent_class)->finalize (obj);
}


/**
 * Cache for the CCode attribute
 */
GType
vala_ccode_attribute_get_type (void)
{
	static volatile gsize vala_ccode_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_attribute_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAttribute), 0, (GInstanceInitFunc) vala_ccode_attribute_instance_init, NULL };
		GType vala_ccode_attribute_type_id;
		vala_ccode_attribute_type_id = g_type_register_static (VALA_TYPE_ATTRIBUTE_CACHE, "ValaCCodeAttribute", &g_define_type_info, 0);
		ValaCCodeAttribute_private_offset = g_type_add_instance_private (vala_ccode_attribute_type_id, sizeof (ValaCCodeAttributePrivate));
		g_once_init_leave (&vala_ccode_attribute_type_id__volatile, vala_ccode_attribute_type_id);
	}
	return vala_ccode_attribute_type_id__volatile;
}



