/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CONSTANT)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ARRAY_LENGTH_FIELD)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CONSTANT);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CONSTANT) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM_VALUE)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp547_ = FALSE;
	gboolean _tmp548_ = FALSE;
	ValaSymbol* _tmp549_;
	ValaSymbol* _tmp550_;
	ValaSymbol* _tmp574_;
	ValaSymbol* _tmp575_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp598_;
	ValaSymbol* _tmp599_;
	ValaSymbol* _tmp600_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp601_;
	ValaSymbol* _tmp602_;
	ValaSymbol* _tmp1015_;
	ValaSymbol* _tmp1016_;
	ValaVersionAttribute* _tmp1017_;
	ValaVersionAttribute* _tmp1018_;
	ValaSourceReference* _tmp1019_;
	ValaSourceReference* _tmp1020_;
	ValaSymbolAccessibility _tmp1021_;
	gboolean _tmp1077_ = FALSE;
	gboolean _tmp1108_ = FALSE;
	gboolean _tmp1109_ = FALSE;
	gboolean _tmp1358_;
	gboolean _tmp1359_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CREATION_METHOD)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_CONSTRUCTOR)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_DESTRUCTOR)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_METHOD)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_TYPESYMBOL);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALA_TYPE_TYPESYMBOL)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaSymbol* _tmp169_;
						ValaScope* _tmp170_;
						ValaScope* _tmp171_;
						const gchar* _tmp172_;
						ValaSymbol* _tmp173_;
						ValaSymbol* _tmp174_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_using_directive_get_namespace_symbol (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = vala_symbol_get_scope (_tmp169_);
						_tmp171_ = _tmp170_;
						_tmp172_ = self->priv->_member_name;
						_tmp173_ = vala_scope_lookup (_tmp171_, _tmp172_);
						local_sym = _tmp173_;
						_tmp174_ = local_sym;
						if (_tmp174_ != NULL) {
							gboolean _tmp175_ = FALSE;
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp193_;
							_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp177_ = _tmp176_;
							if (_tmp177_ != NULL) {
								ValaSymbol* _tmp178_;
								ValaSymbol* _tmp179_;
								ValaSymbol* _tmp180_;
								_tmp178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp179_ = _tmp178_;
								_tmp180_ = local_sym;
								_tmp175_ = _tmp179_ != _tmp180_;
							} else {
								_tmp175_ = FALSE;
							}
							if (_tmp175_) {
								ValaSourceReference* _tmp181_;
								ValaSourceReference* _tmp182_;
								const gchar* _tmp183_;
								ValaSymbol* _tmp184_;
								ValaSymbol* _tmp185_;
								gchar* _tmp186_;
								gchar* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								gchar* _tmp191_;
								gchar* _tmp192_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = self->priv->_member_name;
								_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = vala_symbol_get_full_name (_tmp185_);
								_tmp187_ = _tmp186_;
								_tmp188_ = local_sym;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp183_, _tmp187_, _tmp190_);
								_tmp192_ = _tmp191_;
								vala_report_error (_tmp182_, _tmp192_);
								_g_free0 (_tmp192_);
								_g_free0 (_tmp190_);
								_g_free0 (_tmp187_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp193_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp193_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp194_;
			ValaExpression* _tmp195_;
			gboolean _tmp196_;
			gboolean _tmp197_;
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			ValaDataType* _tmp200_;
			ValaDataType* _tmp201_;
			ValaExpression* _tmp220_;
			ValaExpression* _tmp221_;
			gboolean _tmp237_ = FALSE;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			gboolean _tmp261_ = FALSE;
			ValaSymbol* _tmp262_;
			ValaSymbol* _tmp263_;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp299_ = FALSE;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			_tmp194_ = vala_member_access_get_inner (self);
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
			_tmp197_ = _tmp196_;
			if (_tmp197_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp198_ = vala_member_access_get_inner (self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_expression_get_value_type (_tmp199_);
			_tmp201_ = _tmp200_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp201_, VALA_TYPE_POINTER_TYPE)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				ValaPointerType* _tmp206_;
				gboolean _tmp207_ = FALSE;
				ValaPointerType* _tmp208_;
				_tmp202_ = vala_member_access_get_inner (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp205_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp205_) : NULL);
				pointer_type = _tmp206_;
				_tmp208_ = pointer_type;
				if (_tmp208_ != NULL) {
					ValaPointerType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					_tmp209_ = pointer_type;
					_tmp210_ = vala_pointer_type_get_base_type (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp207_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp211_, VALA_TYPE_VALUE_TYPE);
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaPointerIndirection* _tmp216_;
					ValaPointerIndirection* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					_tmp212_ = vala_member_access_get_inner (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_pointer_indirection_new (_tmp213_, _tmp215_);
					_tmp217_ = _tmp216_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_member_access_get_inner (self);
					_tmp219_ = _tmp218_;
					vala_code_node_check ((ValaCodeNode*) _tmp219_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp220_ = vala_member_access_get_inner (self);
			_tmp221_ = _tmp220_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp221_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				ValaMemberAccess* _tmp224_;
				ValaMemberAccess* _tmp225_;
				gboolean _tmp226_;
				_tmp222_ = vala_member_access_get_inner (self);
				_tmp223_ = _tmp222_;
				_tmp224_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp224_;
				_tmp225_ = ma;
				_tmp226_ = _tmp225_->priv->_prototype_access;
				if (_tmp226_) {
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSymbol* _tmp231_;
					ValaSymbol* _tmp232_;
					gchar* _tmp233_;
					gchar* _tmp234_;
					gchar* _tmp235_;
					gchar* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_symbol_reference (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_symbol_get_full_name (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp234_);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp228_, _tmp236_);
					_g_free0 (_tmp236_);
					_g_free0 (_tmp234_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp238_ = vala_member_access_get_inner (self);
			_tmp239_ = _tmp238_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, VALA_TYPE_MEMBER_ACCESS)) {
				_tmp237_ = TRUE;
			} else {
				ValaExpression* _tmp240_;
				ValaExpression* _tmp241_;
				_tmp240_ = vala_member_access_get_inner (self);
				_tmp241_ = _tmp240_;
				_tmp237_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp241_, VALA_TYPE_BASE_ACCESS);
			}
			if (_tmp237_) {
				ValaExpression* _tmp242_;
				ValaExpression* _tmp243_;
				ValaSymbol* _tmp244_;
				ValaSymbol* _tmp245_;
				ValaSymbol* _tmp246_;
				gboolean _tmp247_ = FALSE;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				_tmp242_ = vala_member_access_get_inner (self);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = _vala_code_node_ref0 (_tmp245_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp246_;
				_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp249_ = _tmp248_;
				if (_tmp249_ == NULL) {
					gboolean _tmp250_ = FALSE;
					ValaSymbol* _tmp251_;
					_tmp251_ = base_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp251_, VALA_TYPE_NAMESPACE)) {
						_tmp250_ = TRUE;
					} else {
						ValaSymbol* _tmp252_;
						_tmp252_ = base_symbol;
						_tmp250_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_TYPESYMBOL);
					}
					_tmp247_ = _tmp250_;
				} else {
					_tmp247_ = FALSE;
				}
				if (_tmp247_) {
					ValaSymbol* _tmp253_;
					ValaScope* _tmp254_;
					ValaScope* _tmp255_;
					const gchar* _tmp256_;
					ValaSymbol* _tmp257_;
					ValaSymbol* _tmp258_;
					ValaExpression* _tmp259_;
					ValaExpression* _tmp260_;
					_tmp253_ = base_symbol;
					_tmp254_ = vala_symbol_get_scope (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = self->priv->_member_name;
					_tmp257_ = vala_scope_lookup (_tmp255_, _tmp256_);
					_tmp258_ = _tmp257_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp258_);
					_vala_code_node_unref0 (_tmp258_);
					_tmp259_ = vala_member_access_get_inner (self);
					_tmp260_ = _tmp259_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_BASE_ACCESS)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp262_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp263_ = _tmp262_;
			if (_tmp263_ == NULL) {
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaDataType* _tmp266_;
				ValaDataType* _tmp267_;
				_tmp264_ = vala_member_access_get_inner (self);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_expression_get_value_type (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp261_ = _tmp267_ != NULL;
			} else {
				_tmp261_ = FALSE;
			}
			if (_tmp261_) {
				gboolean _tmp268_;
				ValaSymbol* _tmp296_;
				ValaSymbol* _tmp297_;
				_tmp268_ = self->priv->_pointer_member_access;
				if (_tmp268_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaDataType* _tmp271_;
					ValaDataType* _tmp272_;
					const gchar* _tmp273_;
					ValaSymbol* _tmp274_;
					ValaSymbol* _tmp275_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_expression_get_value_type (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = self->priv->_member_name;
					_tmp274_ = vala_data_type_get_pointer_member (_tmp272_, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp275_);
					_vala_code_node_unref0 (_tmp275_);
				} else {
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaTypeSymbol* _tmp280_;
					ValaTypeSymbol* _tmp281_;
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					_tmp276_ = vala_member_access_get_inner (self);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_value_type (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_data_type_get_data_type (_tmp279_);
					_tmp281_ = _tmp280_;
					if (_tmp281_ != NULL) {
						ValaExpression* _tmp282_;
						ValaExpression* _tmp283_;
						ValaDataType* _tmp284_;
						ValaDataType* _tmp285_;
						ValaTypeSymbol* _tmp286_;
						ValaTypeSymbol* _tmp287_;
						ValaSymbol* _tmp288_;
						_tmp282_ = vala_member_access_get_inner (self);
						_tmp283_ = _tmp282_;
						_tmp284_ = vala_expression_get_value_type (_tmp283_);
						_tmp285_ = _tmp284_;
						_tmp286_ = vala_data_type_get_data_type (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp287_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp288_;
					}
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_data_type_get_member (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
				}
				_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp297_ = _tmp296_;
				if (_tmp297_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp301_ = _tmp300_;
			if (_tmp301_ == NULL) {
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				_tmp302_ = vala_member_access_get_inner (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp299_ = _tmp305_ != NULL;
			} else {
				_tmp299_ = FALSE;
			}
			if (_tmp299_) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_expression_get_value_type (_tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = vala_data_type_get_is_dynamic (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp298_ = _tmp311_;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaObjectType* _tmp316_;
				ValaCodeNode* _tmp317_;
				ValaCodeNode* _tmp318_;
				ValaSymbol* _tmp495_;
				ValaSymbol* _tmp496_;
				ValaSymbol* _tmp545_;
				ValaSymbol* _tmp546_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp316_;
				_tmp317_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_METHOD_CALL)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp319_;
					ValaCodeNode* _tmp320_;
					ValaMethodCall* _tmp321_;
					ValaMethodCall* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp319_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp321_;
					_tmp322_ = invoc;
					_tmp323_ = vala_method_call_get_call (_tmp322_);
					_tmp324_ = _tmp323_;
					if (_tmp324_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp325_;
						ValaDataType* _tmp326_;
						ValaDataType* _tmp327_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp342_;
						ValaExpression* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						const gchar* _tmp346_;
						ValaDataType* _tmp347_;
						ValaSourceReference* _tmp348_;
						ValaSourceReference* _tmp349_;
						ValaDynamicMethod* _tmp350_;
						ValaDynamicMethod* _tmp351_;
						ValaMethodCall* _tmp352_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp353_;
						ValaErrorType* _tmp354_;
						ValaDynamicMethod* _tmp355_;
						ValaErrorType* _tmp356_;
						ValaDynamicMethod* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaParameter* _tmp359_;
						ValaParameter* _tmp360_;
						ValaObjectType* _tmp361_;
						ValaObjectTypeSymbol* _tmp362_;
						ValaObjectTypeSymbol* _tmp363_;
						ValaScope* _tmp364_;
						ValaScope* _tmp365_;
						ValaDynamicMethod* _tmp366_;
						ValaDynamicMethod* _tmp367_;
						_tmp325_ = invoc;
						_tmp326_ = vala_expression_get_target_type ((ValaExpression*) _tmp325_);
						_tmp327_ = _tmp326_;
						if (_tmp327_ != NULL) {
							ValaMethodCall* _tmp328_;
							ValaDataType* _tmp329_;
							ValaDataType* _tmp330_;
							ValaDataType* _tmp331_;
							ValaDataType* _tmp332_;
							_tmp328_ = invoc;
							_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = vala_data_type_copy (_tmp330_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp331_;
							_tmp332_ = ret_type;
							vala_data_type_set_value_owned (_tmp332_, TRUE);
						} else {
							ValaMethodCall* _tmp333_;
							ValaCodeNode* _tmp334_;
							ValaCodeNode* _tmp335_;
							_tmp333_ = invoc;
							_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp335_, VALA_TYPE_EXPRESSION_STATEMENT)) {
								ValaVoidType* _tmp336_;
								_tmp336_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp336_;
							} else {
								ValaExpression* _tmp337_;
								ValaExpression* _tmp338_;
								ValaDataType* _tmp339_;
								ValaDataType* _tmp340_;
								ValaDataType* _tmp341_;
								_tmp337_ = vala_member_access_get_inner (self);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_expression_get_value_type (_tmp338_);
								_tmp340_ = _tmp339_;
								_tmp341_ = vala_data_type_copy (_tmp340_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp341_;
							}
						}
						_tmp342_ = vala_member_access_get_inner (self);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_expression_get_value_type (_tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = self->priv->_member_name;
						_tmp347_ = ret_type;
						_tmp348_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp349_ = _tmp348_;
						_tmp350_ = vala_dynamic_method_new (_tmp345_, _tmp346_, _tmp347_, _tmp349_, NULL);
						m = _tmp350_;
						_tmp351_ = m;
						_tmp352_ = invoc;
						vala_dynamic_method_set_invocation (_tmp351_, _tmp352_);
						_tmp353_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp353_;
						_tmp354_ = err;
						vala_error_type_set_dynamic_error (_tmp354_, TRUE);
						_tmp355_ = m;
						_tmp356_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp355_, (ValaDataType*) _tmp356_);
						_tmp357_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp357_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp358_ = m;
						_tmp359_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp360_ = _tmp359_;
						vala_callable_add_parameter ((ValaCallable*) _tmp358_, _tmp360_);
						_vala_code_node_unref0 (_tmp360_);
						_tmp361_ = dynamic_object_type;
						_tmp362_ = vala_object_type_get_type_symbol (_tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_symbol_get_scope ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = m;
						vala_scope_add (_tmp365_, NULL, (ValaSymbol*) _tmp366_);
						_tmp367_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp367_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp368_;
					ValaCodeNode* _tmp369_;
					_tmp368_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp369_ = _tmp368_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp369_, VALA_TYPE_ASSIGNMENT)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp370_;
						ValaCodeNode* _tmp371_;
						ValaAssignment* _tmp372_;
						gboolean _tmp373_ = FALSE;
						ValaAssignment* _tmp374_;
						ValaExpression* _tmp375_;
						ValaExpression* _tmp376_;
						_tmp370_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp371_ = _tmp370_;
						_tmp372_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp372_;
						_tmp374_ = a;
						_tmp375_ = vala_assignment_get_left (_tmp374_);
						_tmp376_ = _tmp375_;
						if (_tmp376_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp377_ = FALSE;
							ValaAssignment* _tmp378_;
							ValaAssignmentOperator _tmp379_;
							ValaAssignmentOperator _tmp380_;
							_tmp378_ = a;
							_tmp379_ = vala_assignment_get_operator (_tmp378_);
							_tmp380_ = _tmp379_;
							if (_tmp380_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp377_ = TRUE;
							} else {
								ValaAssignment* _tmp381_;
								ValaAssignmentOperator _tmp382_;
								ValaAssignmentOperator _tmp383_;
								_tmp381_ = a;
								_tmp382_ = vala_assignment_get_operator (_tmp381_);
								_tmp383_ = _tmp382_;
								_tmp377_ = _tmp383_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp373_ = _tmp377_;
						} else {
							_tmp373_ = FALSE;
						}
						if (_tmp373_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp384_;
							ValaExpression* _tmp385_;
							ValaDataType* _tmp386_;
							ValaDataType* _tmp387_;
							const gchar* _tmp388_;
							ValaVoidType* _tmp389_;
							ValaVoidType* _tmp390_;
							ValaSourceReference* _tmp391_;
							ValaSourceReference* _tmp392_;
							ValaDynamicSignal* _tmp393_;
							ValaDynamicSignal* _tmp394_;
							ValaDynamicSignal* _tmp395_;
							ValaAssignment* _tmp396_;
							ValaExpression* _tmp397_;
							ValaExpression* _tmp398_;
							ValaDynamicSignal* _tmp399_;
							ValaObjectType* _tmp400_;
							ValaObjectTypeSymbol* _tmp401_;
							ValaObjectTypeSymbol* _tmp402_;
							ValaScope* _tmp403_;
							ValaScope* _tmp404_;
							ValaDynamicSignal* _tmp405_;
							ValaDynamicSignal* _tmp406_;
							_tmp384_ = vala_member_access_get_inner (self);
							_tmp385_ = _tmp384_;
							_tmp386_ = vala_expression_get_value_type (_tmp385_);
							_tmp387_ = _tmp386_;
							_tmp388_ = self->priv->_member_name;
							_tmp389_ = vala_void_type_new (NULL);
							_tmp390_ = _tmp389_;
							_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp392_ = _tmp391_;
							_tmp393_ = vala_dynamic_signal_new (_tmp387_, _tmp388_, (ValaDataType*) _tmp390_, _tmp392_, NULL);
							_tmp394_ = _tmp393_;
							_vala_code_node_unref0 (_tmp390_);
							s = _tmp394_;
							_tmp395_ = s;
							_tmp396_ = a;
							_tmp397_ = vala_assignment_get_right (_tmp396_);
							_tmp398_ = _tmp397_;
							vala_dynamic_signal_set_handler (_tmp395_, _tmp398_);
							_tmp399_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp399_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp400_ = dynamic_object_type;
							_tmp401_ = vala_object_type_get_type_symbol (_tmp400_);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_symbol_get_scope ((ValaSymbol*) _tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = s;
							vala_scope_add (_tmp404_, NULL, (ValaSymbol*) _tmp405_);
							_tmp406_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp406_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp407_;
							ValaExpression* _tmp408_;
							ValaExpression* _tmp409_;
							_tmp407_ = a;
							_tmp408_ = vala_assignment_get_left (_tmp407_);
							_tmp409_ = _tmp408_;
							if (_tmp409_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp410_;
								ValaExpression* _tmp411_;
								ValaDataType* _tmp412_;
								ValaDataType* _tmp413_;
								const gchar* _tmp414_;
								ValaSourceReference* _tmp415_;
								ValaSourceReference* _tmp416_;
								ValaDynamicProperty* _tmp417_;
								ValaDynamicProperty* _tmp418_;
								ValaDynamicProperty* _tmp419_;
								ValaDynamicProperty* _tmp420_;
								ValaSourceReference* _tmp421_;
								ValaSourceReference* _tmp422_;
								ValaPropertyAccessor* _tmp423_;
								ValaPropertyAccessor* _tmp424_;
								ValaDynamicProperty* _tmp425_;
								ValaExpression* _tmp426_;
								ValaExpression* _tmp427_;
								ValaDataType* _tmp428_;
								ValaDataType* _tmp429_;
								ValaTypeSymbol* _tmp430_;
								ValaTypeSymbol* _tmp431_;
								ValaScope* _tmp432_;
								ValaScope* _tmp433_;
								ValaObjectType* _tmp434_;
								ValaObjectTypeSymbol* _tmp435_;
								ValaObjectTypeSymbol* _tmp436_;
								ValaScope* _tmp437_;
								ValaScope* _tmp438_;
								ValaDynamicProperty* _tmp439_;
								ValaDynamicProperty* _tmp440_;
								_tmp410_ = vala_member_access_get_inner (self);
								_tmp411_ = _tmp410_;
								_tmp412_ = vala_expression_get_value_type (_tmp411_);
								_tmp413_ = _tmp412_;
								_tmp414_ = self->priv->_member_name;
								_tmp415_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp416_ = _tmp415_;
								_tmp417_ = vala_dynamic_property_new (_tmp413_, _tmp414_, _tmp416_, NULL);
								prop = _tmp417_;
								_tmp418_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp418_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp419_ = prop;
								_tmp420_ = prop;
								_tmp421_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp420_);
								_tmp422_ = _tmp421_;
								_tmp423_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp422_, NULL);
								_tmp424_ = _tmp423_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp419_, _tmp424_);
								_vala_code_node_unref0 (_tmp424_);
								_tmp425_ = prop;
								_tmp426_ = vala_member_access_get_inner (self);
								_tmp427_ = _tmp426_;
								_tmp428_ = vala_expression_get_value_type (_tmp427_);
								_tmp429_ = _tmp428_;
								_tmp430_ = vala_data_type_get_data_type (_tmp429_);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_symbol_get_scope ((ValaSymbol*) _tmp431_);
								_tmp433_ = _tmp432_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp425_, _tmp433_);
								_tmp434_ = dynamic_object_type;
								_tmp435_ = vala_object_type_get_type_symbol (_tmp434_);
								_tmp436_ = _tmp435_;
								_tmp437_ = vala_symbol_get_scope ((ValaSymbol*) _tmp436_);
								_tmp438_ = _tmp437_;
								_tmp439_ = prop;
								vala_scope_add (_tmp438_, NULL, (ValaSymbol*) _tmp439_);
								_tmp440_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp440_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp441_ = FALSE;
						gboolean _tmp442_ = FALSE;
						ValaCodeNode* _tmp443_;
						ValaCodeNode* _tmp444_;
						_tmp443_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp444_ = _tmp443_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp444_, VALA_TYPE_MEMBER_ACCESS)) {
							ValaExpression* _tmp445_;
							ValaExpression* _tmp446_;
							_tmp445_ = vala_member_access_get_inner (self);
							_tmp446_ = _tmp445_;
							_tmp442_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp446_, VALA_TYPE_MEMBER_ACCESS);
						} else {
							_tmp442_ = FALSE;
						}
						if (_tmp442_) {
							ValaCodeNode* _tmp447_;
							ValaCodeNode* _tmp448_;
							ValaCodeNode* _tmp449_;
							ValaCodeNode* _tmp450_;
							_tmp447_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp448_ = _tmp447_;
							_tmp449_ = vala_code_node_get_parent_node (_tmp448_);
							_tmp450_ = _tmp449_;
							_tmp441_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp450_, VALA_TYPE_METHOD_CALL);
						} else {
							_tmp441_ = FALSE;
						}
						if (_tmp441_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp451_;
							ValaCodeNode* _tmp452_;
							ValaMemberAccess* _tmp453_;
							gboolean _tmp454_ = FALSE;
							ValaMemberAccess* _tmp455_;
							const gchar* _tmp456_;
							_tmp451_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp452_ = _tmp451_;
							_tmp453_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp452_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp453_;
							_tmp455_ = ma;
							_tmp456_ = _tmp455_->priv->_member_name;
							if (g_strcmp0 (_tmp456_, "connect") == 0) {
								_tmp454_ = TRUE;
							} else {
								ValaMemberAccess* _tmp457_;
								const gchar* _tmp458_;
								_tmp457_ = ma;
								_tmp458_ = _tmp457_->priv->_member_name;
								_tmp454_ = g_strcmp0 (_tmp458_, "connect_after") == 0;
							}
							if (_tmp454_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp459_;
								ValaExpression* _tmp460_;
								ValaDataType* _tmp461_;
								ValaDataType* _tmp462_;
								const gchar* _tmp463_;
								ValaVoidType* _tmp464_;
								ValaVoidType* _tmp465_;
								ValaSourceReference* _tmp466_;
								ValaSourceReference* _tmp467_;
								ValaDynamicSignal* _tmp468_;
								ValaDynamicSignal* _tmp469_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp470_;
								ValaCodeNode* _tmp471_;
								ValaCodeNode* _tmp472_;
								ValaCodeNode* _tmp473_;
								ValaMethodCall* _tmp474_;
								ValaMethodCall* _tmp475_;
								ValaList* _tmp476_;
								ValaList* _tmp477_;
								gint _tmp478_;
								gint _tmp479_;
								gboolean _tmp480_;
								ValaDynamicSignal* _tmp487_;
								ValaObjectType* _tmp488_;
								ValaObjectTypeSymbol* _tmp489_;
								ValaObjectTypeSymbol* _tmp490_;
								ValaScope* _tmp491_;
								ValaScope* _tmp492_;
								ValaDynamicSignal* _tmp493_;
								ValaDynamicSignal* _tmp494_;
								_tmp459_ = vala_member_access_get_inner (self);
								_tmp460_ = _tmp459_;
								_tmp461_ = vala_expression_get_value_type (_tmp460_);
								_tmp462_ = _tmp461_;
								_tmp463_ = self->priv->_member_name;
								_tmp464_ = vala_void_type_new (NULL);
								_tmp465_ = _tmp464_;
								_tmp466_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp467_ = _tmp466_;
								_tmp468_ = vala_dynamic_signal_new (_tmp462_, _tmp463_, (ValaDataType*) _tmp465_, _tmp467_, NULL);
								_tmp469_ = _tmp468_;
								_vala_code_node_unref0 (_tmp465_);
								s = _tmp469_;
								_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp471_ = _tmp470_;
								_tmp472_ = vala_code_node_get_parent_node (_tmp471_);
								_tmp473_ = _tmp472_;
								_tmp474_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp473_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp474_;
								_tmp475_ = mcall;
								_tmp476_ = vala_method_call_get_argument_list (_tmp475_);
								_tmp477_ = _tmp476_;
								_tmp478_ = vala_collection_get_size ((ValaCollection*) _tmp477_);
								_tmp479_ = _tmp478_;
								_tmp480_ = _tmp479_ > 0;
								_vala_iterable_unref0 (_tmp477_);
								if (_tmp480_) {
									ValaDynamicSignal* _tmp481_;
									ValaMethodCall* _tmp482_;
									ValaList* _tmp483_;
									ValaList* _tmp484_;
									gpointer _tmp485_;
									ValaExpression* _tmp486_;
									_tmp481_ = s;
									_tmp482_ = mcall;
									_tmp483_ = vala_method_call_get_argument_list (_tmp482_);
									_tmp484_ = _tmp483_;
									_tmp485_ = vala_list_get (_tmp484_, 0);
									_tmp486_ = (ValaExpression*) _tmp485_;
									vala_dynamic_signal_set_handler (_tmp481_, _tmp486_);
									_vala_code_node_unref0 (_tmp486_);
									_vala_iterable_unref0 (_tmp484_);
								}
								_tmp487_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp487_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp488_ = dynamic_object_type;
								_tmp489_ = vala_object_type_get_type_symbol (_tmp488_);
								_tmp490_ = _tmp489_;
								_tmp491_ = vala_symbol_get_scope ((ValaSymbol*) _tmp490_);
								_tmp492_ = _tmp491_;
								_tmp493_ = s;
								vala_scope_add (_tmp492_, NULL, (ValaSymbol*) _tmp493_);
								_tmp494_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp494_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp495_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp496_ = _tmp495_;
				if (_tmp496_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp497_;
					ValaExpression* _tmp498_;
					ValaDataType* _tmp499_;
					ValaDataType* _tmp500_;
					const gchar* _tmp501_;
					ValaSourceReference* _tmp502_;
					ValaSourceReference* _tmp503_;
					ValaDynamicProperty* _tmp504_;
					ValaDataType* _tmp505_;
					ValaDataType* _tmp506_;
					ValaDynamicProperty* _tmp517_;
					ValaDynamicProperty* _tmp518_;
					ValaDynamicProperty* _tmp519_;
					ValaDataType* _tmp520_;
					ValaDataType* _tmp521_;
					ValaDataType* _tmp522_;
					ValaDataType* _tmp523_;
					ValaDynamicProperty* _tmp524_;
					ValaSourceReference* _tmp525_;
					ValaSourceReference* _tmp526_;
					ValaPropertyAccessor* _tmp527_;
					ValaPropertyAccessor* _tmp528_;
					ValaDynamicProperty* _tmp529_;
					ValaExpression* _tmp530_;
					ValaExpression* _tmp531_;
					ValaDataType* _tmp532_;
					ValaDataType* _tmp533_;
					ValaTypeSymbol* _tmp534_;
					ValaTypeSymbol* _tmp535_;
					ValaScope* _tmp536_;
					ValaScope* _tmp537_;
					ValaObjectType* _tmp538_;
					ValaObjectTypeSymbol* _tmp539_;
					ValaObjectTypeSymbol* _tmp540_;
					ValaScope* _tmp541_;
					ValaScope* _tmp542_;
					ValaDynamicProperty* _tmp543_;
					ValaDynamicProperty* _tmp544_;
					_tmp497_ = vala_member_access_get_inner (self);
					_tmp498_ = _tmp497_;
					_tmp499_ = vala_expression_get_value_type (_tmp498_);
					_tmp500_ = _tmp499_;
					_tmp501_ = self->priv->_member_name;
					_tmp502_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp503_ = _tmp502_;
					_tmp504_ = vala_dynamic_property_new (_tmp500_, _tmp501_, _tmp503_, NULL);
					prop = _tmp504_;
					_tmp505_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp506_ = _tmp505_;
					if (_tmp506_ != NULL) {
						ValaDynamicProperty* _tmp507_;
						ValaDataType* _tmp508_;
						ValaDataType* _tmp509_;
						_tmp507_ = prop;
						_tmp508_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp509_ = _tmp508_;
						vala_property_set_property_type ((ValaProperty*) _tmp507_, _tmp509_);
					} else {
						ValaDynamicProperty* _tmp510_;
						ValaExpression* _tmp511_;
						ValaExpression* _tmp512_;
						ValaDataType* _tmp513_;
						ValaDataType* _tmp514_;
						ValaDataType* _tmp515_;
						ValaDataType* _tmp516_;
						_tmp510_ = prop;
						_tmp511_ = vala_member_access_get_inner (self);
						_tmp512_ = _tmp511_;
						_tmp513_ = vala_expression_get_value_type (_tmp512_);
						_tmp514_ = _tmp513_;
						_tmp515_ = vala_data_type_copy (_tmp514_);
						_tmp516_ = _tmp515_;
						vala_property_set_property_type ((ValaProperty*) _tmp510_, _tmp516_);
						_vala_code_node_unref0 (_tmp516_);
					}
					_tmp517_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp517_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp518_ = prop;
					_tmp519_ = prop;
					_tmp520_ = vala_property_get_property_type ((ValaProperty*) _tmp519_);
					_tmp521_ = _tmp520_;
					_tmp522_ = vala_data_type_copy (_tmp521_);
					_tmp523_ = _tmp522_;
					_tmp524_ = prop;
					_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp524_);
					_tmp526_ = _tmp525_;
					_tmp527_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp523_, NULL, _tmp526_, NULL);
					_tmp528_ = _tmp527_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp518_, _tmp528_);
					_vala_code_node_unref0 (_tmp528_);
					_vala_code_node_unref0 (_tmp523_);
					_tmp529_ = prop;
					_tmp530_ = vala_member_access_get_inner (self);
					_tmp531_ = _tmp530_;
					_tmp532_ = vala_expression_get_value_type (_tmp531_);
					_tmp533_ = _tmp532_;
					_tmp534_ = vala_data_type_get_data_type (_tmp533_);
					_tmp535_ = _tmp534_;
					_tmp536_ = vala_symbol_get_scope ((ValaSymbol*) _tmp535_);
					_tmp537_ = _tmp536_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp529_, _tmp537_);
					_tmp538_ = dynamic_object_type;
					_tmp539_ = vala_object_type_get_type_symbol (_tmp538_);
					_tmp540_ = _tmp539_;
					_tmp541_ = vala_symbol_get_scope ((ValaSymbol*) _tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = prop;
					vala_scope_add (_tmp542_, NULL, (ValaSymbol*) _tmp543_);
					_tmp544_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp544_);
					_vala_code_node_unref0 (prop);
				}
				_tmp545_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp546_ = _tmp545_;
				if (_tmp546_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
		}
	}
	_tmp549_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp550_ = _tmp549_;
	if (_tmp550_ == NULL) {
		ValaDataType* _tmp551_;
		ValaDataType* _tmp552_;
		_tmp551_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp552_ = _tmp551_;
		_tmp548_ = _tmp552_ != NULL;
	} else {
		_tmp548_ = FALSE;
	}
	if (_tmp548_) {
		ValaDataType* _tmp553_;
		ValaDataType* _tmp554_;
		ValaTypeSymbol* _tmp555_;
		ValaTypeSymbol* _tmp556_;
		_tmp553_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp554_ = _tmp553_;
		_tmp555_ = vala_data_type_get_data_type (_tmp554_);
		_tmp556_ = _tmp555_;
		_tmp547_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp556_, VALA_TYPE_ENUM);
	} else {
		_tmp547_ = FALSE;
	}
	if (_tmp547_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp557_;
		ValaDataType* _tmp558_;
		ValaTypeSymbol* _tmp559_;
		ValaTypeSymbol* _tmp560_;
		ValaEnum* _tmp561_;
		_tmp557_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp558_ = _tmp557_;
		_tmp559_ = vala_data_type_get_data_type (_tmp558_);
		_tmp560_ = _tmp559_;
		_tmp561_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp560_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp561_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp562_;
			ValaList* _tmp563_;
			gint _val_size = 0;
			ValaList* _tmp564_;
			gint _tmp565_;
			gint _tmp566_;
			gint _val_index = 0;
			_tmp562_ = enum_type;
			_tmp563_ = vala_enum_get_values (_tmp562_);
			_val_list = _tmp563_;
			_tmp564_ = _val_list;
			_tmp565_ = vala_collection_get_size ((ValaCollection*) _tmp564_);
			_tmp566_ = _tmp565_;
			_val_size = _tmp566_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp567_;
				gpointer _tmp568_;
				const gchar* _tmp569_;
				ValaEnumValue* _tmp570_;
				const gchar* _tmp571_;
				const gchar* _tmp572_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp567_ = _val_list;
				_tmp568_ = vala_list_get (_tmp567_, _val_index);
				val = (ValaEnumValue*) _tmp568_;
				_tmp569_ = self->priv->_member_name;
				_tmp570_ = val;
				_tmp571_ = vala_symbol_get_name ((ValaSymbol*) _tmp570_);
				_tmp572_ = _tmp571_;
				if (g_strcmp0 (_tmp569_, _tmp572_) == 0) {
					ValaEnumValue* _tmp573_;
					_tmp573_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp573_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp574_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp575_ = _tmp574_;
	if (_tmp575_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp576_;
		gboolean _tmp577_ = FALSE;
		ValaExpression* _tmp578_;
		ValaExpression* _tmp579_;
		ValaSourceReference* _tmp592_;
		ValaSourceReference* _tmp593_;
		const gchar* _tmp594_;
		const gchar* _tmp595_;
		gchar* _tmp596_;
		gchar* _tmp597_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp576_ = g_strdup ("(null)");
		base_type_name = _tmp576_;
		_tmp578_ = vala_member_access_get_inner (self);
		_tmp579_ = _tmp578_;
		if (_tmp579_ != NULL) {
			ValaExpression* _tmp580_;
			ValaExpression* _tmp581_;
			ValaDataType* _tmp582_;
			ValaDataType* _tmp583_;
			_tmp580_ = vala_member_access_get_inner (self);
			_tmp581_ = _tmp580_;
			_tmp582_ = vala_expression_get_value_type (_tmp581_);
			_tmp583_ = _tmp582_;
			_tmp577_ = _tmp583_ != NULL;
		} else {
			_tmp577_ = FALSE;
		}
		if (_tmp577_) {
			ValaExpression* _tmp584_;
			ValaExpression* _tmp585_;
			ValaDataType* _tmp586_;
			ValaDataType* _tmp587_;
			gchar* _tmp588_;
			_tmp584_ = vala_member_access_get_inner (self);
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_expression_get_value_type (_tmp585_);
			_tmp587_ = _tmp586_;
			_tmp588_ = vala_code_node_to_string ((ValaCodeNode*) _tmp587_);
			_g_free0 (base_type_name);
			base_type_name = _tmp588_;
		} else {
			ValaSymbol* _tmp589_;
			_tmp589_ = base_symbol;
			if (_tmp589_ != NULL) {
				ValaSymbol* _tmp590_;
				gchar* _tmp591_;
				_tmp590_ = base_symbol;
				_tmp591_ = vala_symbol_get_full_name (_tmp590_);
				_g_free0 (base_type_name);
				base_type_name = _tmp591_;
			}
		}
		_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp593_ = _tmp592_;
		_tmp594_ = self->priv->_member_name;
		_tmp595_ = base_type_name;
		_tmp596_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp594_, _tmp595_);
		_tmp597_ = _tmp596_;
		vala_report_error (_tmp593_, _tmp597_);
		_g_free0 (_tmp597_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp598_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp599_ = _tmp598_;
	_tmp600_ = _vala_code_node_ref0 (_tmp599_);
	member = _tmp600_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp601_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp601_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp602_ = member;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp602_, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp603_;
		ValaLocalVariable* _tmp604_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp605_;
		ValaSymbol* _tmp606_;
		ValaSymbol* _tmp607_;
		ValaBlock* _tmp608_;
		gboolean _tmp609_ = FALSE;
		ValaBlock* _tmp610_;
		_tmp603_ = member;
		_tmp604_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp603_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp604_;
		_tmp605_ = local;
		_tmp606_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp605_);
		_tmp607_ = _tmp606_;
		_tmp608_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp607_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp607_) : NULL);
		block = _tmp608_;
		_tmp610_ = block;
		if (_tmp610_ != NULL) {
			ValaSemanticAnalyzer* _tmp611_;
			ValaSemanticAnalyzer* _tmp612_;
			ValaBlock* _tmp613_;
			ValaSymbol* _tmp614_;
			ValaSymbol* _tmp615_;
			ValaSemanticAnalyzer* _tmp616_;
			ValaSemanticAnalyzer* _tmp617_;
			ValaSymbol* _tmp618_;
			ValaSymbol* _tmp619_;
			_tmp611_ = vala_code_context_get_analyzer (context);
			_tmp612_ = _tmp611_;
			_tmp613_ = block;
			_tmp614_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp612_, (ValaSymbol*) _tmp613_);
			_tmp615_ = _tmp614_;
			_tmp616_ = vala_code_context_get_analyzer (context);
			_tmp617_ = _tmp616_;
			_tmp618_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp617_);
			_tmp619_ = _tmp618_;
			_tmp609_ = _tmp615_ != _tmp619_;
			_vala_code_node_unref0 (_tmp615_);
		} else {
			_tmp609_ = FALSE;
		}
		if (_tmp609_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp620_;
			ValaSemanticAnalyzer* _tmp621_;
			ValaSymbol* _tmp622_;
			ValaSymbol* _tmp623_;
			ValaSymbol* _tmp624_;
			ValaLocalVariable* _tmp637_;
			ValaBlock* _tmp638_;
			_tmp620_ = vala_code_context_get_analyzer (context);
			_tmp621_ = _tmp620_;
			_tmp622_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp621_);
			_tmp623_ = _tmp622_;
			_tmp624_ = _vala_code_node_ref0 (_tmp623_);
			sym = _tmp624_;
			while (TRUE) {
				ValaSymbol* _tmp625_;
				ValaBlock* _tmp626_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp627_;
				ValaMethod* _tmp628_;
				ValaMethod* _tmp629_;
				ValaSymbol* _tmp633_;
				ValaSymbol* _tmp634_;
				ValaSymbol* _tmp635_;
				ValaSymbol* _tmp636_;
				_tmp625_ = sym;
				_tmp626_ = block;
				if (!(_tmp625_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp626_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp627_ = sym;
				_tmp628_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp627_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp627_) : NULL);
				method = _tmp628_;
				_tmp629_ = method;
				if (_tmp629_ != NULL) {
					ValaMethod* _tmp630_;
					ValaMethod* _tmp631_;
					ValaLocalVariable* _tmp632_;
					_tmp630_ = method;
					vala_method_set_closure (_tmp630_, TRUE);
					_tmp631_ = method;
					_tmp632_ = local;
					vala_method_add_captured_variable (_tmp631_, _tmp632_);
				}
				_tmp633_ = sym;
				_tmp634_ = vala_symbol_get_parent_symbol (_tmp633_);
				_tmp635_ = _tmp634_;
				_tmp636_ = _vala_code_node_ref0 (_tmp635_);
				_vala_code_node_unref0 (sym);
				sym = _tmp636_;
				_vala_code_node_unref0 (method);
			}
			_tmp637_ = local;
			vala_local_variable_set_captured (_tmp637_, TRUE);
			_tmp638_ = block;
			vala_block_set_captured (_tmp638_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp639_;
		_tmp639_ = member;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp639_, VALA_TYPE_PARAMETER)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp640_;
			ValaParameter* _tmp641_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp642_;
			ValaSymbol* _tmp643_;
			ValaSymbol* _tmp644_;
			ValaMethod* _tmp645_;
			gboolean _tmp646_ = FALSE;
			gboolean _tmp647_ = FALSE;
			ValaMethod* _tmp648_;
			_tmp640_ = member;
			_tmp641_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp640_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp641_;
			_tmp642_ = param;
			_tmp643_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp642_);
			_tmp644_ = _tmp643_;
			_tmp645_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp644_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp644_) : NULL);
			m = _tmp645_;
			_tmp648_ = m;
			if (_tmp648_ != NULL) {
				ValaMethod* _tmp649_;
				ValaSemanticAnalyzer* _tmp650_;
				ValaSemanticAnalyzer* _tmp651_;
				ValaSymbol* _tmp652_;
				ValaSymbol* _tmp653_;
				_tmp649_ = m;
				_tmp650_ = vala_code_context_get_analyzer (context);
				_tmp651_ = _tmp650_;
				_tmp652_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp651_);
				_tmp653_ = _tmp652_;
				_tmp647_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp649_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp653_;
			} else {
				_tmp647_ = FALSE;
			}
			if (_tmp647_) {
				ValaParameter* _tmp654_;
				ValaMethod* _tmp655_;
				ValaParameter* _tmp656_;
				ValaParameter* _tmp657_;
				_tmp654_ = param;
				_tmp655_ = m;
				_tmp656_ = vala_method_get_this_parameter (_tmp655_);
				_tmp657_ = _tmp656_;
				_tmp646_ = _tmp654_ != _tmp657_;
			} else {
				_tmp646_ = FALSE;
			}
			if (_tmp646_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp658_;
				ValaSemanticAnalyzer* _tmp659_;
				ValaSymbol* _tmp660_;
				ValaSymbol* _tmp661_;
				ValaSymbol* _tmp662_;
				ValaParameter* _tmp673_;
				ValaMethod* _tmp674_;
				ValaBlock* _tmp675_;
				ValaBlock* _tmp676_;
				ValaParameter* _tmp677_;
				ValaParameterDirection _tmp678_;
				ValaParameterDirection _tmp679_;
				_tmp658_ = vala_code_context_get_analyzer (context);
				_tmp659_ = _tmp658_;
				_tmp660_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp659_);
				_tmp661_ = _tmp660_;
				_tmp662_ = _vala_code_node_ref0 (_tmp661_);
				sym = _tmp662_;
				while (TRUE) {
					ValaSymbol* _tmp663_;
					ValaMethod* _tmp664_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp665_;
					ValaMethod* _tmp666_;
					ValaMethod* _tmp667_;
					ValaSymbol* _tmp669_;
					ValaSymbol* _tmp670_;
					ValaSymbol* _tmp671_;
					ValaSymbol* _tmp672_;
					_tmp663_ = sym;
					_tmp664_ = m;
					if (!(_tmp663_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp664_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp665_ = sym;
					_tmp666_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp665_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp665_) : NULL);
					method = _tmp666_;
					_tmp667_ = method;
					if (_tmp667_ != NULL) {
						ValaMethod* _tmp668_;
						_tmp668_ = method;
						vala_method_set_closure (_tmp668_, TRUE);
					}
					_tmp669_ = sym;
					_tmp670_ = vala_symbol_get_parent_symbol (_tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = _vala_code_node_ref0 (_tmp671_);
					_vala_code_node_unref0 (sym);
					sym = _tmp672_;
					_vala_code_node_unref0 (method);
				}
				_tmp673_ = param;
				vala_parameter_set_captured (_tmp673_, TRUE);
				_tmp674_ = m;
				_tmp675_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp674_);
				_tmp676_ = _tmp675_;
				vala_block_set_captured (_tmp676_, TRUE);
				_tmp677_ = param;
				_tmp678_ = vala_parameter_get_direction (_tmp677_);
				_tmp679_ = _tmp678_;
				if (_tmp679_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp680_;
					ValaSourceReference* _tmp681_;
					ValaParameter* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					gchar* _tmp685_;
					gchar* _tmp686_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp680_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp681_ = _tmp680_;
					_tmp682_ = param;
					_tmp683_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp682_);
					_tmp684_ = _tmp683_;
					_tmp685_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp684_);
					_tmp686_ = _tmp685_;
					vala_report_error (_tmp681_, _tmp686_);
					_g_free0 (_tmp686_);
					_g_free0 (_tmp684_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp687_;
				ValaSymbol* _tmp688_;
				ValaSymbol* _tmp689_;
				ValaSymbol* _tmp690_;
				ValaSymbol* _tmp691_;
				ValaPropertyAccessor* _tmp692_;
				gboolean _tmp693_ = FALSE;
				gboolean _tmp694_ = FALSE;
				ValaPropertyAccessor* _tmp695_;
				_tmp687_ = param;
				_tmp688_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp687_);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_symbol_get_parent_symbol (_tmp689_);
				_tmp691_ = _tmp690_;
				_tmp692_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp691_, VALA_TYPE_PROPERTY_ACCESSOR) ? ((ValaPropertyAccessor*) _tmp691_) : NULL);
				acc = _tmp692_;
				_tmp695_ = acc;
				if (_tmp695_ != NULL) {
					ValaPropertyAccessor* _tmp696_;
					ValaSemanticAnalyzer* _tmp697_;
					ValaSemanticAnalyzer* _tmp698_;
					ValaSymbol* _tmp699_;
					ValaSymbol* _tmp700_;
					_tmp696_ = acc;
					_tmp697_ = vala_code_context_get_analyzer (context);
					_tmp698_ = _tmp697_;
					_tmp699_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp698_);
					_tmp700_ = _tmp699_;
					_tmp694_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp700_;
				} else {
					_tmp694_ = FALSE;
				}
				if (_tmp694_) {
					ValaParameter* _tmp701_;
					ValaPropertyAccessor* _tmp702_;
					ValaProperty* _tmp703_;
					ValaProperty* _tmp704_;
					ValaParameter* _tmp705_;
					ValaParameter* _tmp706_;
					_tmp701_ = param;
					_tmp702_ = acc;
					_tmp703_ = vala_property_accessor_get_prop (_tmp702_);
					_tmp704_ = _tmp703_;
					_tmp705_ = vala_property_get_this_parameter (_tmp704_);
					_tmp706_ = _tmp705_;
					_tmp693_ = _tmp701_ != _tmp706_;
				} else {
					_tmp693_ = FALSE;
				}
				if (_tmp693_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp707_;
					ValaSemanticAnalyzer* _tmp708_;
					ValaSymbol* _tmp709_;
					ValaSymbol* _tmp710_;
					ValaSymbol* _tmp711_;
					ValaParameter* _tmp722_;
					ValaPropertyAccessor* _tmp723_;
					ValaBlock* _tmp724_;
					ValaBlock* _tmp725_;
					_tmp707_ = vala_code_context_get_analyzer (context);
					_tmp708_ = _tmp707_;
					_tmp709_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp708_);
					_tmp710_ = _tmp709_;
					_tmp711_ = _vala_code_node_ref0 (_tmp710_);
					sym = _tmp711_;
					while (TRUE) {
						ValaSymbol* _tmp712_;
						ValaMethod* _tmp713_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp714_;
						ValaMethod* _tmp715_;
						ValaMethod* _tmp716_;
						ValaSymbol* _tmp718_;
						ValaSymbol* _tmp719_;
						ValaSymbol* _tmp720_;
						ValaSymbol* _tmp721_;
						_tmp712_ = sym;
						_tmp713_ = m;
						if (!(_tmp712_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp713_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp714_ = sym;
						_tmp715_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp714_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp714_) : NULL);
						method = _tmp715_;
						_tmp716_ = method;
						if (_tmp716_ != NULL) {
							ValaMethod* _tmp717_;
							_tmp717_ = method;
							vala_method_set_closure (_tmp717_, TRUE);
						}
						_tmp718_ = sym;
						_tmp719_ = vala_symbol_get_parent_symbol (_tmp718_);
						_tmp720_ = _tmp719_;
						_tmp721_ = _vala_code_node_ref0 (_tmp720_);
						_vala_code_node_unref0 (sym);
						sym = _tmp721_;
						_vala_code_node_unref0 (method);
					}
					_tmp722_ = param;
					vala_parameter_set_captured (_tmp722_, TRUE);
					_tmp723_ = acc;
					_tmp724_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp723_);
					_tmp725_ = _tmp724_;
					vala_block_set_captured (_tmp725_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp726_;
			_tmp726_ = member;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp726_, VALA_TYPE_FIELD)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp727_;
				ValaField* _tmp728_;
				ValaField* _tmp729_;
				ValaSymbolAccessibility _tmp730_;
				ValaSymbolAccessibility _tmp731_;
				ValaField* _tmp732_;
				ValaMemberBinding _tmp733_;
				ValaMemberBinding _tmp734_;
				ValaField* _tmp735_;
				ValaMemberBinding _tmp736_;
				ValaMemberBinding _tmp737_;
				ValaField* _tmp738_;
				ValaDataType* _tmp739_;
				ValaDataType* _tmp740_;
				_tmp727_ = member;
				_tmp728_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp727_, VALA_TYPE_FIELD, ValaField));
				f = _tmp728_;
				_tmp729_ = f;
				_tmp730_ = vala_symbol_get_access ((ValaSymbol*) _tmp729_);
				_tmp731_ = _tmp730_;
				access = _tmp731_;
				_tmp732_ = f;
				_tmp733_ = vala_field_get_binding (_tmp732_);
				_tmp734_ = _tmp733_;
				instance = _tmp734_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp735_ = f;
				_tmp736_ = vala_field_get_binding (_tmp735_);
				_tmp737_ = _tmp736_;
				klass = _tmp737_ == VALA_MEMBER_BINDING_CLASS;
				_tmp738_ = f;
				_tmp739_ = vala_variable_get_variable_type ((ValaVariable*) _tmp738_);
				_tmp740_ = _tmp739_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp740_, VALA_TYPE_GENERIC_TYPE)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp741_;
				_tmp741_ = member;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp741_, VALA_TYPE_CONSTANT)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp742_;
					ValaConstant* _tmp743_;
					ValaConstant* _tmp744_;
					ValaSymbolAccessibility _tmp745_;
					ValaSymbolAccessibility _tmp746_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp747_;
					ValaSymbol* _tmp748_;
					ValaSymbol* _tmp749_;
					ValaBlock* _tmp750_;
					gboolean _tmp751_ = FALSE;
					ValaBlock* _tmp752_;
					_tmp742_ = member;
					_tmp743_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp742_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp743_;
					_tmp744_ = c;
					_tmp745_ = vala_symbol_get_access ((ValaSymbol*) _tmp744_);
					_tmp746_ = _tmp745_;
					access = _tmp746_;
					_tmp747_ = c;
					_tmp748_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp747_);
					_tmp749_ = _tmp748_;
					_tmp750_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp749_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp749_) : NULL);
					block = _tmp750_;
					_tmp752_ = block;
					if (_tmp752_ != NULL) {
						ValaSemanticAnalyzer* _tmp753_;
						ValaSemanticAnalyzer* _tmp754_;
						ValaBlock* _tmp755_;
						ValaSymbol* _tmp756_;
						ValaSymbol* _tmp757_;
						ValaSemanticAnalyzer* _tmp758_;
						ValaSemanticAnalyzer* _tmp759_;
						ValaSymbol* _tmp760_;
						ValaSymbol* _tmp761_;
						_tmp753_ = vala_code_context_get_analyzer (context);
						_tmp754_ = _tmp753_;
						_tmp755_ = block;
						_tmp756_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp754_, (ValaSymbol*) _tmp755_);
						_tmp757_ = _tmp756_;
						_tmp758_ = vala_code_context_get_analyzer (context);
						_tmp759_ = _tmp758_;
						_tmp760_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp759_);
						_tmp761_ = _tmp760_;
						_tmp751_ = _tmp757_ != _tmp761_;
						_vala_code_node_unref0 (_tmp757_);
					} else {
						_tmp751_ = FALSE;
					}
					if (_tmp751_) {
						ValaSourceReference* _tmp762_;
						ValaSourceReference* _tmp763_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp762_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp763_ = _tmp762_;
						vala_report_error (_tmp763_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp764_;
					_tmp764_ = member;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp764_, VALA_TYPE_METHOD)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp765_;
						ValaMethod* _tmp766_;
						ValaMethod* _tmp767_;
						gboolean _tmp768_;
						gboolean _tmp769_;
						ValaMethod* _tmp871_;
						ValaSymbolAccessibility _tmp872_;
						ValaSymbolAccessibility _tmp873_;
						ValaMethod* _tmp874_;
						ValaMethod* _tmp878_;
						ValaMemberBinding _tmp879_;
						ValaMemberBinding _tmp880_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp899_;
						ValaDataType* _tmp900_;
						ValaDataType* _tmp901_;
						ValaGenericType* _tmp902_;
						gboolean _tmp903_ = FALSE;
						ValaGenericType* _tmp904_;
						_tmp765_ = member;
						_tmp766_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp765_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp766_;
						_tmp767_ = m;
						_tmp768_ = vala_method_get_is_async_callback (_tmp767_);
						_tmp769_ = _tmp768_;
						if (_tmp769_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp770_;
							ValaSemanticAnalyzer* _tmp771_;
							ValaMethod* _tmp772_;
							ValaMethod* _tmp773_;
							ValaMethod* _tmp774_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp775_;
							ValaMethod* _tmp808_;
							ValaSemanticAnalyzer* _tmp809_;
							ValaSemanticAnalyzer* _tmp810_;
							ValaMethod* _tmp811_;
							ValaMethod* _tmp812_;
							ValaMethod* _tmp831_;
							ValaMethod* _tmp832_;
							ValaMethod* _tmp833_;
							ValaSymbol* _tmp834_;
							ValaSymbol* _tmp835_;
							ValaSymbol* _tmp836_;
							_tmp770_ = vala_code_context_get_analyzer (context);
							_tmp771_ = _tmp770_;
							_tmp772_ = vala_semantic_analyzer_get_current_async_method (_tmp771_);
							_tmp773_ = _tmp772_;
							_tmp774_ = _vala_code_node_ref0 (_tmp773_);
							async_method = _tmp774_;
							is_valid_access = FALSE;
							_tmp775_ = async_method;
							if (_tmp775_ != NULL) {
								ValaMethod* _tmp776_;
								ValaMethod* _tmp777_;
								ValaMethod* _tmp778_;
								ValaMethod* _tmp779_;
								gboolean _tmp780_;
								_tmp776_ = m;
								_tmp777_ = async_method;
								_tmp778_ = vala_method_get_callback_method (_tmp777_);
								_tmp779_ = _tmp778_;
								_tmp780_ = _tmp776_ == _tmp779_;
								_vala_code_node_unref0 (_tmp779_);
								if (_tmp780_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp781_ = FALSE;
									ValaMethod* _tmp782_;
									ValaMethod* _tmp783_;
									ValaMethod* _tmp784_;
									_tmp782_ = async_method;
									_tmp783_ = vala_method_get_base_method (_tmp782_);
									_tmp784_ = _tmp783_;
									if (_tmp784_ != NULL) {
										ValaMethod* _tmp785_;
										ValaMethod* _tmp786_;
										ValaMethod* _tmp787_;
										ValaMethod* _tmp788_;
										ValaMethod* _tmp789_;
										ValaMethod* _tmp790_;
										_tmp785_ = m;
										_tmp786_ = async_method;
										_tmp787_ = vala_method_get_base_method (_tmp786_);
										_tmp788_ = _tmp787_;
										_tmp789_ = vala_method_get_callback_method (_tmp788_);
										_tmp790_ = _tmp789_;
										_tmp781_ = _tmp785_ == _tmp790_;
										_vala_code_node_unref0 (_tmp790_);
									} else {
										_tmp781_ = FALSE;
									}
									if (_tmp781_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp791_ = FALSE;
										ValaMethod* _tmp792_;
										ValaMethod* _tmp793_;
										ValaMethod* _tmp794_;
										_tmp792_ = async_method;
										_tmp793_ = vala_method_get_base_interface_method (_tmp792_);
										_tmp794_ = _tmp793_;
										if (_tmp794_ != NULL) {
											ValaMethod* _tmp795_;
											ValaMethod* _tmp796_;
											ValaMethod* _tmp797_;
											ValaMethod* _tmp798_;
											ValaMethod* _tmp799_;
											ValaMethod* _tmp800_;
											_tmp795_ = m;
											_tmp796_ = async_method;
											_tmp797_ = vala_method_get_base_interface_method (_tmp796_);
											_tmp798_ = _tmp797_;
											_tmp799_ = vala_method_get_callback_method (_tmp798_);
											_tmp800_ = _tmp799_;
											_tmp791_ = _tmp795_ == _tmp800_;
											_vala_code_node_unref0 (_tmp800_);
										} else {
											_tmp791_ = FALSE;
										}
										if (_tmp791_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp801_;
								ValaSourceReference* _tmp802_;
								ValaMethod* _tmp803_;
								gchar* _tmp804_;
								gchar* _tmp805_;
								gchar* _tmp806_;
								gchar* _tmp807_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp801_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp802_ = _tmp801_;
								_tmp803_ = m;
								_tmp804_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp803_);
								_tmp805_ = _tmp804_;
								_tmp806_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp805_);
								_tmp807_ = _tmp806_;
								vala_report_error (_tmp802_, _tmp807_);
								_g_free0 (_tmp807_);
								_g_free0 (_tmp805_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp808_ = async_method;
							_tmp809_ = vala_code_context_get_analyzer (context);
							_tmp810_ = _tmp809_;
							_tmp811_ = vala_semantic_analyzer_get_current_method (_tmp810_);
							_tmp812_ = _tmp811_;
							if (_tmp808_ != _tmp812_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp813_;
								ValaSemanticAnalyzer* _tmp814_;
								ValaMethod* _tmp815_;
								ValaMethod* _tmp816_;
								ValaSymbol* _tmp817_;
								ValaMethod* _tmp828_;
								ValaBlock* _tmp829_;
								ValaBlock* _tmp830_;
								_tmp813_ = vala_code_context_get_analyzer (context);
								_tmp814_ = _tmp813_;
								_tmp815_ = vala_semantic_analyzer_get_current_method (_tmp814_);
								_tmp816_ = _tmp815_;
								_tmp817_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp816_);
								sym = _tmp817_;
								while (TRUE) {
									ValaSymbol* _tmp818_;
									ValaMethod* _tmp819_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp820_;
									ValaMethod* _tmp821_;
									ValaMethod* _tmp822_;
									ValaSymbol* _tmp824_;
									ValaSymbol* _tmp825_;
									ValaSymbol* _tmp826_;
									ValaSymbol* _tmp827_;
									_tmp818_ = sym;
									_tmp819_ = async_method;
									if (!(_tmp818_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp819_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp820_ = sym;
									_tmp821_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp820_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp820_) : NULL);
									method = _tmp821_;
									_tmp822_ = method;
									if (_tmp822_ != NULL) {
										ValaMethod* _tmp823_;
										_tmp823_ = method;
										vala_method_set_closure (_tmp823_, TRUE);
									}
									_tmp824_ = sym;
									_tmp825_ = vala_symbol_get_parent_symbol (_tmp824_);
									_tmp826_ = _tmp825_;
									_tmp827_ = _vala_code_node_ref0 (_tmp826_);
									_vala_code_node_unref0 (sym);
									sym = _tmp827_;
									_vala_code_node_unref0 (method);
								}
								_tmp828_ = async_method;
								_tmp829_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp828_);
								_tmp830_ = _tmp829_;
								vala_block_set_captured (_tmp830_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp831_ = async_method;
							_tmp832_ = vala_method_get_callback_method (_tmp831_);
							_vala_code_node_unref0 (m);
							m = _tmp832_;
							_tmp833_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp833_);
							_tmp834_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp835_ = _tmp834_;
							_tmp836_ = _vala_code_node_ref0 (_tmp835_);
							_vala_code_node_unref0 (member);
							member = _tmp836_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp837_;
							ValaMethod* _tmp838_;
							ValaMethod* _tmp839_;
							_tmp837_ = m;
							_tmp838_ = vala_method_get_base_method (_tmp837_);
							_tmp839_ = _tmp838_;
							if (_tmp839_ != NULL) {
								ValaMethod* _tmp840_;
								ValaMethod* _tmp841_;
								ValaMethod* _tmp842_;
								ValaMethod* _tmp843_;
								ValaMethod* _tmp844_;
								ValaSignal* _tmp845_;
								ValaSignal* _tmp846_;
								ValaSymbol* _tmp851_;
								ValaSymbol* _tmp852_;
								ValaSymbol* _tmp853_;
								_tmp840_ = m;
								_tmp841_ = vala_method_get_base_method (_tmp840_);
								_tmp842_ = _tmp841_;
								_tmp843_ = _vala_code_node_ref0 (_tmp842_);
								_vala_code_node_unref0 (m);
								m = _tmp843_;
								_tmp844_ = m;
								_tmp845_ = vala_method_get_signal_reference (_tmp844_);
								_tmp846_ = _tmp845_;
								if (_tmp846_ != NULL) {
									ValaMethod* _tmp847_;
									ValaSignal* _tmp848_;
									ValaSignal* _tmp849_;
									_tmp847_ = m;
									_tmp848_ = vala_method_get_signal_reference (_tmp847_);
									_tmp849_ = _tmp848_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp849_);
								} else {
									ValaMethod* _tmp850_;
									_tmp850_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp850_);
								}
								_tmp851_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp852_ = _tmp851_;
								_tmp853_ = _vala_code_node_ref0 (_tmp852_);
								_vala_code_node_unref0 (member);
								member = _tmp853_;
							} else {
								ValaMethod* _tmp854_;
								ValaMethod* _tmp855_;
								ValaMethod* _tmp856_;
								_tmp854_ = m;
								_tmp855_ = vala_method_get_base_interface_method (_tmp854_);
								_tmp856_ = _tmp855_;
								if (_tmp856_ != NULL) {
									ValaMethod* _tmp857_;
									ValaMethod* _tmp858_;
									ValaMethod* _tmp859_;
									ValaMethod* _tmp860_;
									ValaMethod* _tmp861_;
									ValaSignal* _tmp862_;
									ValaSignal* _tmp863_;
									ValaSymbol* _tmp868_;
									ValaSymbol* _tmp869_;
									ValaSymbol* _tmp870_;
									_tmp857_ = m;
									_tmp858_ = vala_method_get_base_interface_method (_tmp857_);
									_tmp859_ = _tmp858_;
									_tmp860_ = _vala_code_node_ref0 (_tmp859_);
									_vala_code_node_unref0 (m);
									m = _tmp860_;
									_tmp861_ = m;
									_tmp862_ = vala_method_get_signal_reference (_tmp861_);
									_tmp863_ = _tmp862_;
									if (_tmp863_ != NULL) {
										ValaMethod* _tmp864_;
										ValaSignal* _tmp865_;
										ValaSignal* _tmp866_;
										_tmp864_ = m;
										_tmp865_ = vala_method_get_signal_reference (_tmp864_);
										_tmp866_ = _tmp865_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp866_);
									} else {
										ValaMethod* _tmp867_;
										_tmp867_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp867_);
									}
									_tmp868_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp869_ = _tmp868_;
									_tmp870_ = _vala_code_node_ref0 (_tmp869_);
									_vala_code_node_unref0 (member);
									member = _tmp870_;
								}
							}
						}
						_tmp871_ = m;
						_tmp872_ = vala_symbol_get_access ((ValaSymbol*) _tmp871_);
						_tmp873_ = _tmp872_;
						access = _tmp873_;
						_tmp874_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp874_, VALA_TYPE_CREATION_METHOD)) {
							ValaMethod* _tmp875_;
							ValaMemberBinding _tmp876_;
							ValaMemberBinding _tmp877_;
							_tmp875_ = m;
							_tmp876_ = vala_method_get_binding (_tmp875_);
							_tmp877_ = _tmp876_;
							instance = _tmp877_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp878_ = m;
						_tmp879_ = vala_method_get_binding (_tmp878_);
						_tmp880_ = _tmp879_;
						klass = _tmp880_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp881_;
							ValaList* _tmp882_;
							gint _param_size = 0;
							ValaList* _tmp883_;
							gint _tmp884_;
							gint _tmp885_;
							gint _param_index = 0;
							_tmp881_ = m;
							_tmp882_ = vala_callable_get_parameters ((ValaCallable*) _tmp881_);
							_param_list = _tmp882_;
							_tmp883_ = _param_list;
							_tmp884_ = vala_collection_get_size ((ValaCollection*) _tmp883_);
							_tmp885_ = _tmp884_;
							_param_size = _tmp885_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp886_;
								gpointer _tmp887_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp888_;
								ValaDataType* _tmp889_;
								ValaDataType* _tmp890_;
								ValaGenericType* _tmp891_;
								gboolean _tmp892_ = FALSE;
								ValaGenericType* _tmp893_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp886_ = _param_list;
								_tmp887_ = vala_list_get (_tmp886_, _param_index);
								param = (ValaParameter*) _tmp887_;
								_tmp888_ = param;
								_tmp889_ = vala_variable_get_variable_type ((ValaVariable*) _tmp888_);
								_tmp890_ = _tmp889_;
								_tmp891_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp890_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp890_) : NULL);
								generic_type = _tmp891_;
								_tmp893_ = generic_type;
								if (_tmp893_ != NULL) {
									ValaGenericType* _tmp894_;
									ValaTypeParameter* _tmp895_;
									ValaTypeParameter* _tmp896_;
									ValaSymbol* _tmp897_;
									ValaSymbol* _tmp898_;
									_tmp894_ = generic_type;
									_tmp895_ = vala_generic_type_get_type_parameter (_tmp894_);
									_tmp896_ = _tmp895_;
									_tmp897_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp896_);
									_tmp898_ = _tmp897_;
									_tmp892_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp898_, VALA_TYPE_TYPESYMBOL);
								} else {
									_tmp892_ = FALSE;
								}
								if (_tmp892_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp899_ = m;
						_tmp900_ = vala_callable_get_return_type ((ValaCallable*) _tmp899_);
						_tmp901_ = _tmp900_;
						_tmp902_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp901_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp901_) : NULL);
						generic_type = _tmp902_;
						_tmp904_ = generic_type;
						if (_tmp904_ != NULL) {
							ValaGenericType* _tmp905_;
							ValaTypeParameter* _tmp906_;
							ValaTypeParameter* _tmp907_;
							ValaSymbol* _tmp908_;
							ValaSymbol* _tmp909_;
							_tmp905_ = generic_type;
							_tmp906_ = vala_generic_type_get_type_parameter (_tmp905_);
							_tmp907_ = _tmp906_;
							_tmp908_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp907_);
							_tmp909_ = _tmp908_;
							_tmp903_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp909_, VALA_TYPE_TYPESYMBOL);
						} else {
							_tmp903_ = FALSE;
						}
						if (_tmp903_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp910_;
						_tmp910_ = member;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp910_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp911_;
							ValaProperty* _tmp912_;
							ValaProperty* _tmp913_;
							ValaProperty* _tmp914_;
							ValaProperty* _tmp915_;
							ValaProperty* _tmp916_;
							ValaProperty* _tmp936_;
							ValaSymbolAccessibility _tmp937_;
							ValaSymbolAccessibility _tmp938_;
							gboolean _tmp939_;
							gboolean _tmp940_;
							ValaProperty* _tmp1005_;
							ValaMemberBinding _tmp1006_;
							ValaMemberBinding _tmp1007_;
							ValaProperty* _tmp1008_;
							ValaDataType* _tmp1009_;
							ValaDataType* _tmp1010_;
							_tmp911_ = member;
							_tmp912_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp911_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp912_;
							_tmp913_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp913_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp914_ = prop;
							_tmp915_ = vala_property_get_base_property (_tmp914_);
							_tmp916_ = _tmp915_;
							if (_tmp916_ != NULL) {
								ValaProperty* _tmp917_;
								ValaProperty* _tmp918_;
								ValaProperty* _tmp919_;
								ValaProperty* _tmp920_;
								ValaProperty* _tmp921_;
								ValaSymbol* _tmp922_;
								ValaSymbol* _tmp923_;
								ValaSymbol* _tmp924_;
								_tmp917_ = prop;
								_tmp918_ = vala_property_get_base_property (_tmp917_);
								_tmp919_ = _tmp918_;
								_tmp920_ = _vala_code_node_ref0 (_tmp919_);
								_vala_code_node_unref0 (prop);
								prop = _tmp920_;
								_tmp921_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp921_);
								_tmp922_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp923_ = _tmp922_;
								_tmp924_ = _vala_code_node_ref0 (_tmp923_);
								_vala_code_node_unref0 (member);
								member = _tmp924_;
							} else {
								ValaProperty* _tmp925_;
								ValaProperty* _tmp926_;
								ValaProperty* _tmp927_;
								_tmp925_ = prop;
								_tmp926_ = vala_property_get_base_interface_property (_tmp925_);
								_tmp927_ = _tmp926_;
								if (_tmp927_ != NULL) {
									ValaProperty* _tmp928_;
									ValaProperty* _tmp929_;
									ValaProperty* _tmp930_;
									ValaProperty* _tmp931_;
									ValaProperty* _tmp932_;
									ValaSymbol* _tmp933_;
									ValaSymbol* _tmp934_;
									ValaSymbol* _tmp935_;
									_tmp928_ = prop;
									_tmp929_ = vala_property_get_base_interface_property (_tmp928_);
									_tmp930_ = _tmp929_;
									_tmp931_ = _vala_code_node_ref0 (_tmp930_);
									_vala_code_node_unref0 (prop);
									prop = _tmp931_;
									_tmp932_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp932_);
									_tmp933_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp934_ = _tmp933_;
									_tmp935_ = _vala_code_node_ref0 (_tmp934_);
									_vala_code_node_unref0 (member);
									member = _tmp935_;
								}
							}
							_tmp936_ = prop;
							_tmp937_ = vala_symbol_get_access ((ValaSymbol*) _tmp936_);
							_tmp938_ = _tmp937_;
							access = _tmp938_;
							_tmp939_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp940_ = _tmp939_;
							if (_tmp940_) {
								ValaProperty* _tmp941_;
								ValaPropertyAccessor* _tmp942_;
								ValaPropertyAccessor* _tmp943_;
								ValaProperty* _tmp951_;
								ValaSymbolAccessibility _tmp952_;
								ValaSymbolAccessibility _tmp953_;
								_tmp941_ = prop;
								_tmp942_ = vala_property_get_set_accessor (_tmp941_);
								_tmp943_ = _tmp942_;
								if (_tmp943_ == NULL) {
									ValaSourceReference* _tmp944_;
									ValaSourceReference* _tmp945_;
									ValaProperty* _tmp946_;
									gchar* _tmp947_;
									gchar* _tmp948_;
									gchar* _tmp949_;
									gchar* _tmp950_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp944_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp945_ = _tmp944_;
									_tmp946_ = prop;
									_tmp947_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp946_);
									_tmp948_ = _tmp947_;
									_tmp949_ = g_strdup_printf ("Property `%s' is read-only", _tmp948_);
									_tmp950_ = _tmp949_;
									vala_report_error (_tmp945_, _tmp950_);
									_g_free0 (_tmp950_);
									_g_free0 (_tmp948_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp951_ = prop;
								_tmp952_ = vala_symbol_get_access ((ValaSymbol*) _tmp951_);
								_tmp953_ = _tmp952_;
								if (_tmp953_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp954_;
									ValaPropertyAccessor* _tmp955_;
									ValaPropertyAccessor* _tmp956_;
									ValaSymbolAccessibility _tmp957_;
									ValaSymbolAccessibility _tmp958_;
									_tmp954_ = prop;
									_tmp955_ = vala_property_get_set_accessor (_tmp954_);
									_tmp956_ = _tmp955_;
									_tmp957_ = vala_symbol_get_access ((ValaSymbol*) _tmp956_);
									_tmp958_ = _tmp957_;
									access = _tmp958_;
								} else {
									gboolean _tmp959_ = FALSE;
									ValaProperty* _tmp960_;
									ValaSymbolAccessibility _tmp961_;
									ValaSymbolAccessibility _tmp962_;
									_tmp960_ = prop;
									_tmp961_ = vala_symbol_get_access ((ValaSymbol*) _tmp960_);
									_tmp962_ = _tmp961_;
									if (_tmp962_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp963_;
										ValaPropertyAccessor* _tmp964_;
										ValaPropertyAccessor* _tmp965_;
										ValaSymbolAccessibility _tmp966_;
										ValaSymbolAccessibility _tmp967_;
										_tmp963_ = prop;
										_tmp964_ = vala_property_get_set_accessor (_tmp963_);
										_tmp965_ = _tmp964_;
										_tmp966_ = vala_symbol_get_access ((ValaSymbol*) _tmp965_);
										_tmp967_ = _tmp966_;
										_tmp959_ = _tmp967_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp959_ = FALSE;
									}
									if (_tmp959_) {
										ValaProperty* _tmp968_;
										ValaPropertyAccessor* _tmp969_;
										ValaPropertyAccessor* _tmp970_;
										ValaSymbolAccessibility _tmp971_;
										ValaSymbolAccessibility _tmp972_;
										_tmp968_ = prop;
										_tmp969_ = vala_property_get_set_accessor (_tmp968_);
										_tmp970_ = _tmp969_;
										_tmp971_ = vala_symbol_get_access ((ValaSymbol*) _tmp970_);
										_tmp972_ = _tmp971_;
										access = _tmp972_;
									}
								}
							} else {
								ValaProperty* _tmp973_;
								ValaPropertyAccessor* _tmp974_;
								ValaPropertyAccessor* _tmp975_;
								ValaProperty* _tmp983_;
								ValaSymbolAccessibility _tmp984_;
								ValaSymbolAccessibility _tmp985_;
								_tmp973_ = prop;
								_tmp974_ = vala_property_get_get_accessor (_tmp973_);
								_tmp975_ = _tmp974_;
								if (_tmp975_ == NULL) {
									ValaSourceReference* _tmp976_;
									ValaSourceReference* _tmp977_;
									ValaProperty* _tmp978_;
									gchar* _tmp979_;
									gchar* _tmp980_;
									gchar* _tmp981_;
									gchar* _tmp982_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp976_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp977_ = _tmp976_;
									_tmp978_ = prop;
									_tmp979_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp978_);
									_tmp980_ = _tmp979_;
									_tmp981_ = g_strdup_printf ("Property `%s' is write-only", _tmp980_);
									_tmp982_ = _tmp981_;
									vala_report_error (_tmp977_, _tmp982_);
									_g_free0 (_tmp982_);
									_g_free0 (_tmp980_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp983_ = prop;
								_tmp984_ = vala_symbol_get_access ((ValaSymbol*) _tmp983_);
								_tmp985_ = _tmp984_;
								if (_tmp985_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp986_;
									ValaPropertyAccessor* _tmp987_;
									ValaPropertyAccessor* _tmp988_;
									ValaSymbolAccessibility _tmp989_;
									ValaSymbolAccessibility _tmp990_;
									_tmp986_ = prop;
									_tmp987_ = vala_property_get_get_accessor (_tmp986_);
									_tmp988_ = _tmp987_;
									_tmp989_ = vala_symbol_get_access ((ValaSymbol*) _tmp988_);
									_tmp990_ = _tmp989_;
									access = _tmp990_;
								} else {
									gboolean _tmp991_ = FALSE;
									ValaProperty* _tmp992_;
									ValaSymbolAccessibility _tmp993_;
									ValaSymbolAccessibility _tmp994_;
									_tmp992_ = prop;
									_tmp993_ = vala_symbol_get_access ((ValaSymbol*) _tmp992_);
									_tmp994_ = _tmp993_;
									if (_tmp994_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp995_;
										ValaPropertyAccessor* _tmp996_;
										ValaPropertyAccessor* _tmp997_;
										ValaSymbolAccessibility _tmp998_;
										ValaSymbolAccessibility _tmp999_;
										_tmp995_ = prop;
										_tmp996_ = vala_property_get_get_accessor (_tmp995_);
										_tmp997_ = _tmp996_;
										_tmp998_ = vala_symbol_get_access ((ValaSymbol*) _tmp997_);
										_tmp999_ = _tmp998_;
										_tmp991_ = _tmp999_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp991_ = FALSE;
									}
									if (_tmp991_) {
										ValaProperty* _tmp1000_;
										ValaPropertyAccessor* _tmp1001_;
										ValaPropertyAccessor* _tmp1002_;
										ValaSymbolAccessibility _tmp1003_;
										ValaSymbolAccessibility _tmp1004_;
										_tmp1000_ = prop;
										_tmp1001_ = vala_property_get_get_accessor (_tmp1000_);
										_tmp1002_ = _tmp1001_;
										_tmp1003_ = vala_symbol_get_access ((ValaSymbol*) _tmp1002_);
										_tmp1004_ = _tmp1003_;
										access = _tmp1004_;
									}
								}
							}
							_tmp1005_ = prop;
							_tmp1006_ = vala_property_get_binding (_tmp1005_);
							_tmp1007_ = _tmp1006_;
							instance = _tmp1007_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1008_ = prop;
							_tmp1009_ = vala_property_get_property_type (_tmp1008_);
							_tmp1010_ = _tmp1009_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1010_, VALA_TYPE_GENERIC_TYPE)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1011_;
							_tmp1011_ = member;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1011_, VALA_TYPE_SIGNAL)) {
								ValaSymbol* _tmp1012_;
								ValaSymbolAccessibility _tmp1013_;
								ValaSymbolAccessibility _tmp1014_;
								instance = TRUE;
								_tmp1012_ = member;
								_tmp1013_ = vala_symbol_get_access (_tmp1012_);
								_tmp1014_ = _tmp1013_;
								access = _tmp1014_;
							}
						}
					}
				}
			}
		}
	}
	_tmp1015_ = member;
	vala_symbol_set_used (_tmp1015_, TRUE);
	_tmp1016_ = member;
	_tmp1017_ = vala_symbol_get_version (_tmp1016_);
	_tmp1018_ = _tmp1017_;
	_tmp1019_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1020_ = _tmp1019_;
	vala_version_attribute_check (_tmp1018_, _tmp1020_);
	_tmp1021_ = access;
	if (_tmp1021_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1022_;
		ValaSymbol* _tmp1023_;
		ValaSymbol* _tmp1024_;
		ValaTypeSymbol* _tmp1025_;
		gboolean in_subtype = FALSE;
		_tmp1022_ = member;
		_tmp1023_ = vala_symbol_get_parent_symbol (_tmp1022_);
		_tmp1024_ = _tmp1023_;
		_tmp1025_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1024_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1025_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1026_;
			ValaSemanticAnalyzer* _tmp1027_;
			ValaSymbol* _tmp1028_;
			ValaSymbol* _tmp1029_;
			ValaSymbol* _tmp1030_;
			_tmp1026_ = vala_code_context_get_analyzer (context);
			_tmp1027_ = _tmp1026_;
			_tmp1028_ = vala_semantic_analyzer_get_current_symbol (_tmp1027_);
			_tmp1029_ = _tmp1028_;
			_tmp1030_ = _vala_code_node_ref0 (_tmp1029_);
			this_symbol = _tmp1030_;
			{
				gboolean _tmp1031_ = FALSE;
				_tmp1031_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1036_;
					ValaSymbol* _tmp1037_;
					ValaTypeSymbol* _tmp1038_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1039_;
					ValaClass* _tmp1040_;
					gboolean _tmp1041_ = FALSE;
					ValaClass* _tmp1042_;
					if (!_tmp1031_) {
						ValaSymbol* _tmp1032_;
						ValaSymbol* _tmp1033_;
						ValaSymbol* _tmp1034_;
						ValaSymbol* _tmp1035_;
						_tmp1032_ = this_symbol;
						_tmp1033_ = vala_symbol_get_parent_symbol (_tmp1032_);
						_tmp1034_ = _tmp1033_;
						_tmp1035_ = _vala_code_node_ref0 (_tmp1034_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1035_;
					}
					_tmp1031_ = FALSE;
					_tmp1036_ = this_symbol;
					if (!(_tmp1036_ != NULL)) {
						break;
					}
					_tmp1037_ = this_symbol;
					_tmp1038_ = target_type;
					if (_tmp1037_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1038_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1039_ = this_symbol;
					_tmp1040_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1039_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1039_) : NULL);
					cl = _tmp1040_;
					_tmp1042_ = cl;
					if (_tmp1042_ != NULL) {
						ValaClass* _tmp1043_;
						ValaTypeSymbol* _tmp1044_;
						_tmp1043_ = cl;
						_tmp1044_ = target_type;
						_tmp1041_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1043_, _tmp1044_);
					} else {
						_tmp1041_ = FALSE;
					}
					if (_tmp1041_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1045_;
			ValaSourceReference* _tmp1046_;
			ValaSymbol* _tmp1047_;
			gchar* _tmp1048_;
			gchar* _tmp1049_;
			gchar* _tmp1050_;
			gchar* _tmp1051_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1045_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1046_ = _tmp1045_;
			_tmp1047_ = member;
			_tmp1048_ = vala_symbol_get_full_name (_tmp1047_);
			_tmp1049_ = _tmp1048_;
			_tmp1050_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1049_);
			_tmp1051_ = _tmp1050_;
			vala_report_error (_tmp1046_, _tmp1051_);
			_g_free0 (_tmp1051_);
			_g_free0 (_tmp1049_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1052_;
		_tmp1052_ = access;
		if (_tmp1052_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1053_;
			ValaSymbol* _tmp1054_;
			ValaSymbol* _tmp1055_;
			ValaSymbol* _tmp1056_;
			gboolean in_target_type = FALSE;
			_tmp1053_ = member;
			_tmp1054_ = vala_symbol_get_parent_symbol (_tmp1053_);
			_tmp1055_ = _tmp1054_;
			_tmp1056_ = _vala_code_node_ref0 (_tmp1055_);
			target_type = _tmp1056_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1057_;
				ValaSemanticAnalyzer* _tmp1058_;
				ValaSymbol* _tmp1059_;
				ValaSymbol* _tmp1060_;
				ValaSymbol* _tmp1061_;
				_tmp1057_ = vala_code_context_get_analyzer (context);
				_tmp1058_ = _tmp1057_;
				_tmp1059_ = vala_semantic_analyzer_get_current_symbol (_tmp1058_);
				_tmp1060_ = _tmp1059_;
				_tmp1061_ = _vala_code_node_ref0 (_tmp1060_);
				this_symbol = _tmp1061_;
				{
					gboolean _tmp1062_ = FALSE;
					_tmp1062_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1067_;
						ValaSymbol* _tmp1068_;
						ValaSymbol* _tmp1069_;
						if (!_tmp1062_) {
							ValaSymbol* _tmp1063_;
							ValaSymbol* _tmp1064_;
							ValaSymbol* _tmp1065_;
							ValaSymbol* _tmp1066_;
							_tmp1063_ = this_symbol;
							_tmp1064_ = vala_symbol_get_parent_symbol (_tmp1063_);
							_tmp1065_ = _tmp1064_;
							_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1066_;
						}
						_tmp1062_ = FALSE;
						_tmp1067_ = this_symbol;
						if (!(_tmp1067_ != NULL)) {
							break;
						}
						_tmp1068_ = target_type;
						_tmp1069_ = this_symbol;
						if (_tmp1068_ == _tmp1069_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1070_;
				ValaSourceReference* _tmp1071_;
				ValaSymbol* _tmp1072_;
				gchar* _tmp1073_;
				gchar* _tmp1074_;
				gchar* _tmp1075_;
				gchar* _tmp1076_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1070_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1071_ = _tmp1070_;
				_tmp1072_ = member;
				_tmp1073_ = vala_symbol_get_full_name (_tmp1072_);
				_tmp1074_ = _tmp1073_;
				_tmp1075_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1074_);
				_tmp1076_ = _tmp1075_;
				vala_report_error (_tmp1071_, _tmp1076_);
				_g_free0 (_tmp1076_);
				_g_free0 (_tmp1074_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1078_;
		ValaExpression* _tmp1079_;
		_tmp1078_ = vala_member_access_get_inner (self);
		_tmp1079_ = _tmp1078_;
		_tmp1077_ = _tmp1079_ != NULL;
	} else {
		_tmp1077_ = FALSE;
	}
	if (_tmp1077_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1080_;
		ValaExpression* _tmp1081_;
		ValaDataType* _tmp1082_;
		ValaDataType* _tmp1083_;
		ValaDataType* _tmp1084_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1085_;
		ValaExpression* _tmp1086_;
		ValaDataType* _tmp1087_;
		ValaDataType* _tmp1088_;
		ValaPointerType* _tmp1089_;
		ValaPointerType* _tmp1090_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1095_;
		ValaObjectType* _tmp1096_;
		gboolean _tmp1097_ = FALSE;
		gboolean _tmp1098_ = FALSE;
		ValaObjectType* _tmp1099_;
		_tmp1080_ = vala_member_access_get_inner (self);
		_tmp1081_ = _tmp1080_;
		_tmp1082_ = vala_expression_get_value_type (_tmp1081_);
		_tmp1083_ = _tmp1082_;
		_tmp1084_ = _vala_code_node_ref0 (_tmp1083_);
		instance_type = _tmp1084_;
		_tmp1085_ = vala_member_access_get_inner (self);
		_tmp1086_ = _tmp1085_;
		_tmp1087_ = vala_expression_get_value_type (_tmp1086_);
		_tmp1088_ = _tmp1087_;
		_tmp1089_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1088_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp1088_) : NULL);
		pointer_type = _tmp1089_;
		_tmp1090_ = pointer_type;
		if (_tmp1090_ != NULL) {
			ValaPointerType* _tmp1091_;
			ValaDataType* _tmp1092_;
			ValaDataType* _tmp1093_;
			ValaDataType* _tmp1094_;
			_tmp1091_ = pointer_type;
			_tmp1092_ = vala_pointer_type_get_base_type (_tmp1091_);
			_tmp1093_ = _tmp1092_;
			_tmp1094_ = _vala_code_node_ref0 (_tmp1093_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1094_;
		}
		_tmp1095_ = instance_type;
		_tmp1096_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1095_, VALA_TYPE_OBJECT_TYPE) ? ((ValaObjectType*) _tmp1095_) : NULL);
		object_type = _tmp1096_;
		_tmp1099_ = object_type;
		if (_tmp1099_ != NULL) {
			ValaObjectType* _tmp1100_;
			ValaObjectTypeSymbol* _tmp1101_;
			ValaObjectTypeSymbol* _tmp1102_;
			_tmp1100_ = object_type;
			_tmp1101_ = vala_object_type_get_type_symbol (_tmp1100_);
			_tmp1102_ = _tmp1101_;
			_tmp1098_ = vala_object_type_symbol_has_type_parameters (_tmp1102_);
		} else {
			_tmp1098_ = FALSE;
		}
		if (_tmp1098_) {
			ValaDataType* _tmp1103_;
			_tmp1103_ = instance_type;
			_tmp1097_ = !vala_data_type_has_type_arguments (_tmp1103_);
		} else {
			_tmp1097_ = FALSE;
		}
		if (_tmp1097_) {
			ValaExpression* _tmp1104_;
			ValaExpression* _tmp1105_;
			ValaSourceReference* _tmp1106_;
			ValaSourceReference* _tmp1107_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1104_ = vala_member_access_get_inner (self);
			_tmp1105_ = _tmp1104_;
			_tmp1106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1105_);
			_tmp1107_ = _tmp1106_;
			vala_report_error (_tmp1107_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1109_ = !may_access_instance_members;
	} else {
		_tmp1109_ = FALSE;
	}
	if (_tmp1109_) {
		_tmp1108_ = TRUE;
	} else {
		gboolean _tmp1110_ = FALSE;
		if (klass) {
			_tmp1110_ = !may_access_klass_members;
		} else {
			_tmp1110_ = FALSE;
		}
		_tmp1108_ = _tmp1110_;
	}
	if (_tmp1108_) {
		ValaSymbol* _tmp1111_;
		ValaSymbol* _tmp1112_;
		ValaDataType* _tmp1129_;
		ValaDataType* _tmp1130_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1112_ = _tmp1111_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1112_, VALA_TYPE_METHOD)) {
			ValaSemanticAnalyzer* _tmp1113_;
			ValaSemanticAnalyzer* _tmp1114_;
			ValaSymbol* _tmp1115_;
			ValaSymbol* _tmp1116_;
			gboolean _tmp1117_;
			gboolean _tmp1118_;
			ValaDataType* _tmp1119_;
			ValaDataType* _tmp1120_;
			_tmp1113_ = vala_code_context_get_analyzer (context);
			_tmp1114_ = _tmp1113_;
			_tmp1115_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1116_ = _tmp1115_;
			_tmp1117_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1118_ = _tmp1117_;
			_tmp1119_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1114_, _tmp1116_, _tmp1118_);
			_tmp1120_ = _tmp1119_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1120_);
			_vala_code_node_unref0 (_tmp1120_);
		} else {
			ValaSymbol* _tmp1121_;
			ValaSymbol* _tmp1122_;
			_tmp1121_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1122_ = _tmp1121_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1122_, VALA_TYPE_FIELD)) {
				ValaSymbol* _tmp1123_;
				ValaSymbol* _tmp1124_;
				ValaFieldPrototype* _tmp1125_;
				ValaFieldPrototype* _tmp1126_;
				_tmp1123_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1124_ = _tmp1123_;
				_tmp1125_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1124_, VALA_TYPE_FIELD, ValaField));
				_tmp1126_ = _tmp1125_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1126_);
				_vala_code_node_unref0 (_tmp1126_);
			} else {
				ValaInvalidType* _tmp1127_;
				ValaInvalidType* _tmp1128_;
				_tmp1127_ = vala_invalid_type_new ();
				_tmp1128_ = _tmp1127_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1128_);
				_vala_code_node_unref0 (_tmp1128_);
			}
		}
		_tmp1129_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1130_ = _tmp1129_;
		if (_tmp1130_ != NULL) {
			ValaDataType* _tmp1131_;
			ValaDataType* _tmp1132_;
			ValaDataType* _tmp1133_;
			ValaDataType* _tmp1134_;
			gboolean _tmp1135_;
			gboolean _tmp1136_;
			_tmp1131_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1132_ = _tmp1131_;
			_tmp1133_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1134_ = _tmp1133_;
			_tmp1135_ = vala_data_type_get_value_owned (_tmp1134_);
			_tmp1136_ = _tmp1135_;
			vala_data_type_set_value_owned (_tmp1132_, _tmp1136_);
		}
	} else {
		gboolean _tmp1137_ = FALSE;
		gboolean _tmp1158_ = FALSE;
		gboolean _tmp1159_ = FALSE;
		gboolean _tmp1160_ = FALSE;
		gboolean _tmp1161_ = FALSE;
		gboolean _tmp1178_ = FALSE;
		gboolean _tmp1179_ = FALSE;
		gboolean _tmp1180_ = FALSE;
		gboolean _tmp1181_ = FALSE;
		gboolean _tmp1182_ = FALSE;
		gboolean _tmp1183_;
		gboolean _tmp1184_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1211_;
		ValaSymbol* _tmp1212_;
		ValaMethod* _tmp1213_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1214_;
		ValaExpression* _tmp1215_;
		ValaMemberAccess* _tmp1216_;
		gboolean _tmp1217_ = FALSE;
		gboolean _tmp1218_ = FALSE;
		gboolean _tmp1219_ = FALSE;
		gboolean _tmp1220_ = FALSE;
		gboolean _tmp1221_ = FALSE;
		ValaMethod* _tmp1222_;
		ValaSemanticAnalyzer* _tmp1259_;
		ValaSemanticAnalyzer* _tmp1260_;
		ValaSymbol* _tmp1261_;
		ValaSymbol* _tmp1262_;
		gboolean _tmp1263_;
		gboolean _tmp1264_;
		ValaDataType* _tmp1265_;
		ValaDataType* _tmp1266_;
		gboolean _tmp1267_ = FALSE;
		ValaExpression* _tmp1268_;
		ValaExpression* _tmp1269_;
		ValaSymbol* _tmp1282_;
		ValaSymbol* _tmp1283_;
		if (instance) {
			ValaExpression* _tmp1138_;
			ValaExpression* _tmp1139_;
			_tmp1138_ = vala_member_access_get_inner (self);
			_tmp1139_ = _tmp1138_;
			_tmp1137_ = _tmp1139_ == NULL;
		} else {
			_tmp1137_ = FALSE;
		}
		if (_tmp1137_) {
			ValaSourceReference* _tmp1140_;
			ValaSourceReference* _tmp1141_;
			ValaMemberAccess* _tmp1142_;
			ValaMemberAccess* _tmp1143_;
			ValaExpression* _tmp1144_;
			ValaExpression* _tmp1145_;
			ValaParameter* _tmp1146_;
			ValaDataType* _tmp1147_;
			ValaDataType* _tmp1148_;
			ValaDataType* _tmp1149_;
			ValaDataType* _tmp1150_;
			ValaExpression* _tmp1151_;
			ValaExpression* _tmp1152_;
			ValaDataType* _tmp1153_;
			ValaDataType* _tmp1154_;
			ValaExpression* _tmp1155_;
			ValaExpression* _tmp1156_;
			ValaParameter* _tmp1157_;
			_tmp1140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = vala_member_access_new (NULL, "this", _tmp1141_);
			_tmp1143_ = _tmp1142_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1143_);
			_vala_code_node_unref0 (_tmp1143_);
			_tmp1144_ = vala_member_access_get_inner (self);
			_tmp1145_ = _tmp1144_;
			_tmp1146_ = this_parameter;
			_tmp1147_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1146_);
			_tmp1148_ = _tmp1147_;
			_tmp1149_ = vala_data_type_copy (_tmp1148_);
			_tmp1150_ = _tmp1149_;
			vala_expression_set_value_type (_tmp1145_, _tmp1150_);
			_vala_code_node_unref0 (_tmp1150_);
			_tmp1151_ = vala_member_access_get_inner (self);
			_tmp1152_ = _tmp1151_;
			_tmp1153_ = vala_expression_get_value_type (_tmp1152_);
			_tmp1154_ = _tmp1153_;
			vala_data_type_set_value_owned (_tmp1154_, FALSE);
			_tmp1155_ = vala_member_access_get_inner (self);
			_tmp1156_ = _tmp1155_;
			_tmp1157_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1156_, (ValaSymbol*) _tmp1157_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1161_ = !klass;
		} else {
			_tmp1161_ = FALSE;
		}
		if (_tmp1161_) {
			ValaSymbol* _tmp1162_;
			ValaSymbol* _tmp1163_;
			_tmp1162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1163_ = _tmp1162_;
			_tmp1160_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1163_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1160_ = FALSE;
		}
		if (_tmp1160_) {
			_tmp1159_ = may_access_instance_members;
		} else {
			_tmp1159_ = FALSE;
		}
		if (_tmp1159_) {
			ValaExpression* _tmp1164_;
			ValaExpression* _tmp1165_;
			_tmp1164_ = vala_member_access_get_inner (self);
			_tmp1165_ = _tmp1164_;
			_tmp1158_ = _tmp1165_ != NULL;
		} else {
			_tmp1158_ = FALSE;
		}
		if (_tmp1158_) {
			ValaExpression* _tmp1166_;
			ValaExpression* _tmp1167_;
			ValaSymbol* _tmp1168_;
			ValaSymbol* _tmp1169_;
			_tmp1166_ = vala_member_access_get_inner (self);
			_tmp1167_ = _tmp1166_;
			_tmp1168_ = vala_expression_get_symbol_reference (_tmp1167_);
			_tmp1169_ = _tmp1168_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1169_, VALA_TYPE_METHOD)) {
			} else {
				ValaSourceReference* _tmp1170_;
				ValaSourceReference* _tmp1171_;
				ValaSymbol* _tmp1172_;
				ValaSymbol* _tmp1173_;
				gchar* _tmp1174_;
				gchar* _tmp1175_;
				gchar* _tmp1176_;
				gchar* _tmp1177_;
				_tmp1170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1171_ = _tmp1170_;
				_tmp1172_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1173_ = _tmp1172_;
				_tmp1174_ = vala_symbol_get_full_name (_tmp1173_);
				_tmp1175_ = _tmp1174_;
				_tmp1176_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1175_);
				_tmp1177_ = _tmp1176_;
				vala_report_warning (_tmp1171_, _tmp1177_);
				_g_free0 (_tmp1177_);
				_g_free0 (_tmp1175_);
			}
		}
		_tmp1183_ = vala_code_context_get_experimental_non_null (context);
		_tmp1184_ = _tmp1183_;
		if (_tmp1184_) {
			_tmp1182_ = instance;
		} else {
			_tmp1182_ = FALSE;
		}
		if (_tmp1182_) {
			ValaExpression* _tmp1185_;
			ValaExpression* _tmp1186_;
			ValaDataType* _tmp1187_;
			ValaDataType* _tmp1188_;
			gboolean _tmp1189_;
			gboolean _tmp1190_;
			_tmp1185_ = vala_member_access_get_inner (self);
			_tmp1186_ = _tmp1185_;
			_tmp1187_ = vala_expression_get_value_type (_tmp1186_);
			_tmp1188_ = _tmp1187_;
			_tmp1189_ = vala_data_type_get_nullable (_tmp1188_);
			_tmp1190_ = _tmp1189_;
			_tmp1181_ = _tmp1190_;
		} else {
			_tmp1181_ = FALSE;
		}
		if (_tmp1181_) {
			ValaExpression* _tmp1191_;
			ValaExpression* _tmp1192_;
			ValaDataType* _tmp1193_;
			ValaDataType* _tmp1194_;
			_tmp1191_ = vala_member_access_get_inner (self);
			_tmp1192_ = _tmp1191_;
			_tmp1193_ = vala_expression_get_value_type (_tmp1192_);
			_tmp1194_ = _tmp1193_;
			_tmp1180_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1194_, VALA_TYPE_POINTER_TYPE);
		} else {
			_tmp1180_ = FALSE;
		}
		if (_tmp1180_) {
			ValaExpression* _tmp1195_;
			ValaExpression* _tmp1196_;
			ValaDataType* _tmp1197_;
			ValaDataType* _tmp1198_;
			_tmp1195_ = vala_member_access_get_inner (self);
			_tmp1196_ = _tmp1195_;
			_tmp1197_ = vala_expression_get_value_type (_tmp1196_);
			_tmp1198_ = _tmp1197_;
			_tmp1179_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1198_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1179_ = FALSE;
		}
		if (_tmp1179_) {
			ValaExpression* _tmp1199_;
			ValaExpression* _tmp1200_;
			ValaDataType* _tmp1201_;
			ValaDataType* _tmp1202_;
			_tmp1199_ = vala_member_access_get_inner (self);
			_tmp1200_ = _tmp1199_;
			_tmp1201_ = vala_expression_get_value_type (_tmp1200_);
			_tmp1202_ = _tmp1201_;
			_tmp1178_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1202_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp1178_ = FALSE;
		}
		if (_tmp1178_) {
			ValaSourceReference* _tmp1203_;
			ValaSourceReference* _tmp1204_;
			ValaSymbol* _tmp1205_;
			ValaSymbol* _tmp1206_;
			gchar* _tmp1207_;
			gchar* _tmp1208_;
			gchar* _tmp1209_;
			gchar* _tmp1210_;
			_tmp1203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1204_ = _tmp1203_;
			_tmp1205_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = vala_symbol_get_full_name (_tmp1206_);
			_tmp1208_ = _tmp1207_;
			_tmp1209_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1208_);
			_tmp1210_ = _tmp1209_;
			vala_report_error (_tmp1204_, _tmp1210_);
			_g_free0 (_tmp1210_);
			_g_free0 (_tmp1208_);
		}
		_tmp1211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1212_ = _tmp1211_;
		_tmp1213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1212_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1212_) : NULL);
		m = _tmp1213_;
		_tmp1214_ = vala_member_access_get_inner (self);
		_tmp1215_ = _tmp1214_;
		_tmp1216_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1215_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1215_) : NULL);
		inner_ma = _tmp1216_;
		_tmp1222_ = m;
		if (_tmp1222_ != NULL) {
			ValaMethod* _tmp1223_;
			ValaMemberBinding _tmp1224_;
			ValaMemberBinding _tmp1225_;
			_tmp1223_ = m;
			_tmp1224_ = vala_method_get_binding (_tmp1223_);
			_tmp1225_ = _tmp1224_;
			_tmp1221_ = _tmp1225_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1221_ = FALSE;
		}
		if (_tmp1221_) {
			ValaMethod* _tmp1226_;
			ValaSymbol* _tmp1227_;
			ValaSymbol* _tmp1228_;
			_tmp1226_ = m;
			_tmp1227_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1226_);
			_tmp1228_ = _tmp1227_;
			_tmp1220_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1228_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
		} else {
			_tmp1220_ = FALSE;
		}
		if (_tmp1220_) {
			ValaExpression* _tmp1229_;
			ValaExpression* _tmp1230_;
			_tmp1229_ = vala_member_access_get_inner (self);
			_tmp1230_ = _tmp1229_;
			_tmp1219_ = _tmp1230_ != NULL;
		} else {
			_tmp1219_ = FALSE;
		}
		if (_tmp1219_) {
			ValaExpression* _tmp1231_;
			ValaExpression* _tmp1232_;
			ValaDataType* _tmp1233_;
			ValaDataType* _tmp1234_;
			_tmp1231_ = vala_member_access_get_inner (self);
			_tmp1232_ = _tmp1231_;
			_tmp1233_ = vala_expression_get_value_type (_tmp1232_);
			_tmp1234_ = _tmp1233_;
			_tmp1218_ = _tmp1234_ == NULL;
		} else {
			_tmp1218_ = FALSE;
		}
		if (_tmp1218_) {
			ValaMemberAccess* _tmp1235_;
			ValaList* _tmp1236_;
			gint _tmp1237_;
			gint _tmp1238_;
			_tmp1235_ = inner_ma;
			_tmp1236_ = _tmp1235_->priv->type_argument_list;
			_tmp1237_ = vala_collection_get_size ((ValaCollection*) _tmp1236_);
			_tmp1238_ = _tmp1237_;
			_tmp1217_ = _tmp1238_ > 0;
		} else {
			_tmp1217_ = FALSE;
		}
		if (_tmp1217_) {
			ValaExpression* _tmp1239_;
			ValaExpression* _tmp1240_;
			ValaMethod* _tmp1241_;
			ValaSymbol* _tmp1242_;
			ValaSymbol* _tmp1243_;
			ValaObjectType* _tmp1244_;
			ValaObjectType* _tmp1245_;
			_tmp1239_ = vala_member_access_get_inner (self);
			_tmp1240_ = _tmp1239_;
			_tmp1241_ = m;
			_tmp1242_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1241_);
			_tmp1243_ = _tmp1242_;
			_tmp1244_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1243_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1245_ = _tmp1244_;
			vala_expression_set_value_type (_tmp1240_, (ValaDataType*) _tmp1245_);
			_vala_code_node_unref0 (_tmp1245_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1246_;
				ValaList* _tmp1247_;
				ValaList* _tmp1248_;
				gint _type_argument_size = 0;
				ValaList* _tmp1249_;
				gint _tmp1250_;
				gint _tmp1251_;
				gint _type_argument_index = 0;
				_tmp1246_ = inner_ma;
				_tmp1247_ = _tmp1246_->priv->type_argument_list;
				_tmp1248_ = _vala_iterable_ref0 (_tmp1247_);
				_type_argument_list = _tmp1248_;
				_tmp1249_ = _type_argument_list;
				_tmp1250_ = vala_collection_get_size ((ValaCollection*) _tmp1249_);
				_tmp1251_ = _tmp1250_;
				_type_argument_size = _tmp1251_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1252_;
					gpointer _tmp1253_;
					ValaExpression* _tmp1254_;
					ValaExpression* _tmp1255_;
					ValaDataType* _tmp1256_;
					ValaDataType* _tmp1257_;
					ValaDataType* _tmp1258_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1252_ = _type_argument_list;
					_tmp1253_ = vala_list_get (_tmp1252_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1253_;
					_tmp1254_ = vala_member_access_get_inner (self);
					_tmp1255_ = _tmp1254_;
					_tmp1256_ = vala_expression_get_value_type (_tmp1255_);
					_tmp1257_ = _tmp1256_;
					_tmp1258_ = type_argument;
					vala_data_type_add_type_argument (_tmp1257_, _tmp1258_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1259_ = vala_code_context_get_analyzer (context);
		_tmp1260_ = _tmp1259_;
		_tmp1261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1262_ = _tmp1261_;
		_tmp1263_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1264_ = _tmp1263_;
		_tmp1265_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1260_, _tmp1262_, _tmp1264_);
		_tmp1266_ = _tmp1265_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1266_);
		_vala_code_node_unref0 (_tmp1266_);
		_tmp1268_ = vala_member_access_get_inner (self);
		_tmp1269_ = _tmp1268_;
		if (_tmp1269_ != NULL) {
			ValaDataType* _tmp1270_;
			ValaDataType* _tmp1271_;
			_tmp1270_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1271_ = _tmp1270_;
			_tmp1267_ = _tmp1271_ != NULL;
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			ValaDataType* _tmp1272_;
			ValaDataType* _tmp1273_;
			ValaExpression* _tmp1274_;
			ValaExpression* _tmp1275_;
			ValaDataType* _tmp1276_;
			ValaDataType* _tmp1277_;
			ValaDataType* _tmp1278_;
			ValaDataType* _tmp1279_;
			_tmp1272_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1273_ = _tmp1272_;
			_tmp1274_ = vala_member_access_get_inner (self);
			_tmp1275_ = _tmp1274_;
			_tmp1276_ = vala_expression_get_value_type (_tmp1275_);
			_tmp1277_ = _tmp1276_;
			_tmp1278_ = vala_data_type_get_actual_type (_tmp1273_, _tmp1277_, NULL, (ValaCodeNode*) self);
			_tmp1279_ = _tmp1278_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1279_);
			_vala_code_node_unref0 (_tmp1279_);
		} else {
			ValaDataType* _tmp1280_;
			ValaDataType* _tmp1281_;
			_tmp1280_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1281_ = _tmp1280_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1281_);
		}
		_tmp1282_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1283_ = _tmp1282_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1283_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1284_;
			ValaSymbol* _tmp1285_;
			ValaMethod* _tmp1286_;
			ValaDataType* _tmp1287_;
			ValaDataType* _tmp1288_;
			gboolean _tmp1295_ = FALSE;
			_tmp1284_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1285_ = _tmp1284_;
			_tmp1286_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1285_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1286_;
			_tmp1287_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1288_ = _tmp1287_;
			if (_tmp1288_ != NULL) {
				ValaDataType* _tmp1289_;
				ValaDataType* _tmp1290_;
				ValaDataType* _tmp1291_;
				ValaDataType* _tmp1292_;
				gboolean _tmp1293_;
				gboolean _tmp1294_;
				_tmp1289_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1290_ = _tmp1289_;
				_tmp1291_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = vala_data_type_get_value_owned (_tmp1292_);
				_tmp1294_ = _tmp1293_;
				vala_data_type_set_value_owned (_tmp1290_, _tmp1294_);
			}
			if (instance) {
				ValaMethod* _tmp1296_;
				ValaSymbol* _tmp1297_;
				ValaSymbol* _tmp1298_;
				_tmp1296_ = method;
				_tmp1297_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1296_);
				_tmp1298_ = _tmp1297_;
				_tmp1295_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1298_, VALA_TYPE_TYPESYMBOL);
			} else {
				_tmp1295_ = FALSE;
			}
			if (_tmp1295_) {
				ValaExpression* _tmp1299_;
				ValaExpression* _tmp1300_;
				ValaMethod* _tmp1301_;
				ValaSymbol* _tmp1302_;
				ValaSymbol* _tmp1303_;
				ValaDataType* _tmp1304_;
				ValaDataType* _tmp1305_;
				ValaExpression* _tmp1306_;
				ValaExpression* _tmp1307_;
				ValaDataType* _tmp1308_;
				ValaDataType* _tmp1309_;
				ValaMethod* _tmp1310_;
				ValaParameter* _tmp1311_;
				ValaParameter* _tmp1312_;
				ValaDataType* _tmp1313_;
				ValaDataType* _tmp1314_;
				gboolean _tmp1315_;
				gboolean _tmp1316_;
				_tmp1299_ = vala_member_access_get_inner (self);
				_tmp1300_ = _tmp1299_;
				_tmp1301_ = method;
				_tmp1302_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1301_);
				_tmp1303_ = _tmp1302_;
				_tmp1304_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1303_);
				_tmp1305_ = _tmp1304_;
				vala_expression_set_target_type (_tmp1300_, _tmp1305_);
				_vala_code_node_unref0 (_tmp1305_);
				_tmp1306_ = vala_member_access_get_inner (self);
				_tmp1307_ = _tmp1306_;
				_tmp1308_ = vala_expression_get_target_type (_tmp1307_);
				_tmp1309_ = _tmp1308_;
				_tmp1310_ = method;
				_tmp1311_ = vala_method_get_this_parameter (_tmp1310_);
				_tmp1312_ = _tmp1311_;
				_tmp1313_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1312_);
				_tmp1314_ = _tmp1313_;
				_tmp1315_ = vala_data_type_get_value_owned (_tmp1314_);
				_tmp1316_ = _tmp1315_;
				vala_data_type_set_value_owned (_tmp1309_, _tmp1316_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1317_;
			ValaSymbol* _tmp1318_;
			_tmp1317_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1318_ = _tmp1317_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1318_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1319_;
				ValaSymbol* _tmp1320_;
				ValaProperty* _tmp1321_;
				gboolean _tmp1322_ = FALSE;
				_tmp1319_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1320_ = _tmp1319_;
				_tmp1321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1320_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1321_;
				if (instance) {
					ValaProperty* _tmp1323_;
					ValaSymbol* _tmp1324_;
					ValaSymbol* _tmp1325_;
					_tmp1323_ = prop;
					_tmp1324_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1323_);
					_tmp1325_ = _tmp1324_;
					_tmp1322_ = _tmp1325_ != NULL;
				} else {
					_tmp1322_ = FALSE;
				}
				if (_tmp1322_) {
					ValaExpression* _tmp1326_;
					ValaExpression* _tmp1327_;
					ValaProperty* _tmp1328_;
					ValaSymbol* _tmp1329_;
					ValaSymbol* _tmp1330_;
					ValaDataType* _tmp1331_;
					ValaDataType* _tmp1332_;
					_tmp1326_ = vala_member_access_get_inner (self);
					_tmp1327_ = _tmp1326_;
					_tmp1328_ = prop;
					_tmp1329_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1328_);
					_tmp1330_ = _tmp1329_;
					_tmp1331_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1330_);
					_tmp1332_ = _tmp1331_;
					vala_expression_set_target_type (_tmp1327_, _tmp1332_);
					_vala_code_node_unref0 (_tmp1332_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1333_ = FALSE;
				gboolean _tmp1334_ = FALSE;
				gboolean _tmp1335_ = FALSE;
				ValaSymbol* _tmp1336_;
				ValaSymbol* _tmp1337_;
				_tmp1336_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1337_ = _tmp1336_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1337_, VALA_TYPE_FIELD)) {
					_tmp1335_ = TRUE;
				} else {
					ValaSymbol* _tmp1338_;
					ValaSymbol* _tmp1339_;
					_tmp1338_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1339_ = _tmp1338_;
					_tmp1335_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1339_, VALA_TYPE_SIGNAL);
				}
				if (_tmp1335_) {
					_tmp1334_ = instance;
				} else {
					_tmp1334_ = FALSE;
				}
				if (_tmp1334_) {
					ValaSymbol* _tmp1340_;
					ValaSymbol* _tmp1341_;
					ValaSymbol* _tmp1342_;
					ValaSymbol* _tmp1343_;
					_tmp1340_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1341_ = _tmp1340_;
					_tmp1342_ = vala_symbol_get_parent_symbol (_tmp1341_);
					_tmp1343_ = _tmp1342_;
					_tmp1333_ = _tmp1343_ != NULL;
				} else {
					_tmp1333_ = FALSE;
				}
				if (_tmp1333_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1344_;
					ValaSymbol* _tmp1345_;
					ValaSymbol* _tmp1346_;
					ValaSymbol* _tmp1347_;
					ValaDataType* _tmp1348_;
					ValaExpression* _tmp1349_;
					ValaExpression* _tmp1350_;
					ValaDataType* _tmp1351_;
					ValaExpression* _tmp1352_;
					ValaExpression* _tmp1353_;
					ValaDataType* _tmp1354_;
					ValaDataType* _tmp1355_;
					ValaDataType* _tmp1356_;
					ValaDataType* _tmp1357_;
					_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1345_ = _tmp1344_;
					_tmp1346_ = vala_symbol_get_parent_symbol (_tmp1345_);
					_tmp1347_ = _tmp1346_;
					_tmp1348_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1347_);
					parent_type = _tmp1348_;
					_tmp1349_ = vala_member_access_get_inner (self);
					_tmp1350_ = _tmp1349_;
					_tmp1351_ = parent_type;
					_tmp1352_ = vala_member_access_get_inner (self);
					_tmp1353_ = _tmp1352_;
					_tmp1354_ = vala_expression_get_value_type (_tmp1353_);
					_tmp1355_ = _tmp1354_;
					_tmp1356_ = vala_data_type_get_actual_type (_tmp1351_, _tmp1355_, NULL, (ValaCodeNode*) self);
					_tmp1357_ = _tmp1356_;
					vala_expression_set_target_type (_tmp1350_, _tmp1357_);
					_vala_code_node_unref0 (_tmp1357_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1358_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1359_ = _tmp1358_;
	result = !_tmp1359_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_FIELD)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_METHOD)) {
			_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_PROPERTY)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_SIGNAL)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_PROPERTY)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_PARAMETER)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_POINTER_INDIRECTION);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_METHOD)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_VARIABLE);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_ELEMENT_ACCESS);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

