/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp242_;
	ValaExpression* _tmp243_;
	gboolean _tmp244_ = FALSE;
	gboolean _tmp245_ = FALSE;
	ValaAssignmentOperator _tmp246_;
	ValaMemberAccess* _tmp291_;
	ValaExpression* _tmp660_;
	ValaExpression* _tmp661_;
	ValaDataType* _tmp662_;
	ValaDataType* _tmp663_;
	gboolean _tmp672_;
	gboolean _tmp673_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaBlock* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		ValaDeclarationStatement* _tmp32_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp80_;
		ValaSemanticAnalyzer* _tmp81_;
		ValaList* _tmp82_;
		ValaCodeNode* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaExpressionStatement* _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpressionStatement* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->insert_block;
		_tmp31_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp30_, (ValaStatement*) _tmp31_);
		_tmp32_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp32_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp33_ = tuple;
			_tmp34_ = vala_tuple_get_expressions (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaExpressionStatement* _tmp40_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaElementAccess* _tmp58_;
				ValaElementAccess* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaExpression* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaIntegerLiteral* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp67_;
				ValaElementAccess* _tmp68_;
				ValaAssignmentOperator _tmp69_;
				ValaExpression* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaAssignment* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaExpressionStatement* _tmp78_;
				gint _tmp79_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp38_ = _expr_list;
				_tmp39_ = vala_list_get (_tmp38_, _expr_index);
				expr = (ValaExpression*) _tmp39_;
				_tmp40_ = stmt;
				if (_tmp40_ != NULL) {
					ValaSemanticAnalyzer* _tmp41_;
					ValaSemanticAnalyzer* _tmp42_;
					ValaBlock* _tmp43_;
					ValaExpressionStatement* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					_tmp41_ = vala_code_context_get_analyzer (context);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_->insert_block;
					_tmp44_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp43_, (ValaStatement*) _tmp44_);
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
				}
				_tmp46_ = local;
				_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_assignment_get_right (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_member_access_new_simple (_tmp48_, _tmp52_);
				temp_access = _tmp53_;
				_tmp54_ = temp_access;
				_tmp55_ = expr;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_element_access_new ((ValaExpression*) _tmp54_, _tmp57_);
				ea = _tmp58_;
				_tmp59_ = ea;
				_tmp60_ = g_strdup_printf ("%i", i);
				_tmp61_ = _tmp60_;
				_tmp62_ = expr;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_integer_literal_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_element_access_append_index (_tmp59_, (ValaExpression*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_g_free0 (_tmp61_);
				_tmp67_ = expr;
				_tmp68_ = ea;
				_tmp69_ = self->priv->_operator;
				_tmp70_ = expr;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_assignment_new (_tmp67_, (ValaExpression*) _tmp68_, _tmp69_, _tmp72_);
				assign = _tmp73_;
				_tmp74_ = assign;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_statement_new ((ValaExpression*) _tmp74_, _tmp77_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp78_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp80_ = vala_code_context_get_analyzer (context);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp82_, (ValaCodeNode*) self);
		_tmp83_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = stmt;
		_tmp86_ = vala_expression_statement_get_expression (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_node_replace_expression (_tmp84_, (ValaExpression*) self, _tmp87_);
		_tmp88_ = stmt;
		_tmp89_ = vala_expression_statement_get_expression (_tmp88_);
		_tmp90_ = _tmp89_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp91_ = vala_assignment_get_left (self);
	_tmp92_ = _tmp91_;
	vala_expression_set_lvalue (_tmp92_, TRUE);
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp94_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaMemberAccess* _tmp99_;
		ValaMemberAccess* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp105_ = FALSE;
		gboolean _tmp106_ = FALSE;
		ValaMemberAccess* _tmp107_;
		ValaSymbol* _tmp108_;
		ValaSymbol* _tmp109_;
		ValaMemberAccess* _tmp125_;
		gboolean _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp137_ = FALSE;
		ValaMemberAccess* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		ValaMemberAccess* _tmp144_;
		ValaSymbol* _tmp145_;
		ValaSymbol* _tmp146_;
		_tmp97_ = vala_assignment_get_left (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp99_;
		_tmp100_ = ma;
		_tmp101_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp100_);
		_tmp102_ = _tmp101_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp103_;
			ValaSourceReference* _tmp104_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp104_ = _tmp103_;
			vala_report_error (_tmp104_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp107_ = ma;
		_tmp108_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp107_);
		_tmp109_ = _tmp108_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_DYNAMIC_PROPERTY)) {
			ValaMemberAccess* _tmp110_;
			ValaDataType* _tmp111_;
			ValaDataType* _tmp112_;
			_tmp110_ = ma;
			_tmp111_ = vala_expression_get_value_type ((ValaExpression*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp106_ = _tmp112_ == NULL;
		} else {
			_tmp106_ = FALSE;
		}
		if (_tmp106_) {
			_tmp105_ = TRUE;
		} else {
			gboolean _tmp113_ = FALSE;
			gboolean _tmp114_ = FALSE;
			ValaMemberAccess* _tmp115_;
			ValaExpression* _tmp116_;
			ValaExpression* _tmp117_;
			_tmp115_ = ma;
			_tmp116_ = vala_member_access_get_inner (_tmp115_);
			_tmp117_ = _tmp116_;
			if (_tmp117_ == NULL) {
				ValaMemberAccess* _tmp118_;
				const gchar* _tmp119_;
				const gchar* _tmp120_;
				_tmp118_ = ma;
				_tmp119_ = vala_member_access_get_member_name (_tmp118_);
				_tmp120_ = _tmp119_;
				_tmp114_ = g_strcmp0 (_tmp120_, "this") == 0;
			} else {
				_tmp114_ = FALSE;
			}
			if (_tmp114_) {
				ValaSemanticAnalyzer* _tmp121_;
				ValaSemanticAnalyzer* _tmp122_;
				_tmp121_ = vala_code_context_get_analyzer (context);
				_tmp122_ = _tmp121_;
				_tmp113_ = vala_semantic_analyzer_is_in_instance_method (_tmp122_);
			} else {
				_tmp113_ = FALSE;
			}
			_tmp105_ = _tmp113_;
		}
		if (_tmp105_) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp124_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp125_ = ma;
		_tmp126_ = vala_member_access_get_prototype_access (_tmp125_);
		_tmp127_ = _tmp126_;
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_symbol_get_full_name (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp134_);
			_tmp136_ = _tmp135_;
			vala_report_error (_tmp129_, _tmp136_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp138_ = ma;
		_tmp139_ = vala_code_node_get_error ((ValaCodeNode*) _tmp138_);
		_tmp140_ = _tmp139_;
		if (_tmp140_) {
			_tmp137_ = TRUE;
		} else {
			ValaMemberAccess* _tmp141_;
			ValaSymbol* _tmp142_;
			ValaSymbol* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp137_ = _tmp143_ == NULL;
		}
		if (_tmp137_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp144_ = ma;
		_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp144_);
		_tmp146_ = _tmp145_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp146_, VALA_TYPE_DYNAMIC_PROPERTY)) {
		} else {
			ValaExpression* _tmp147_;
			ValaExpression* _tmp148_;
			ValaMemberAccess* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaExpression* _tmp154_;
			ValaExpression* _tmp155_;
			ValaMemberAccess* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			_tmp147_ = vala_assignment_get_right (self);
			_tmp148_ = _tmp147_;
			_tmp149_ = ma;
			_tmp150_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_data_type_copy (_tmp151_);
			_tmp153_ = _tmp152_;
			vala_expression_set_formal_target_type (_tmp148_, _tmp153_);
			_vala_code_node_unref0 (_tmp153_);
			_tmp154_ = vala_assignment_get_right (self);
			_tmp155_ = _tmp154_;
			_tmp156_ = ma;
			_tmp157_ = vala_expression_get_value_type ((ValaExpression*) _tmp156_);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_data_type_copy (_tmp158_);
			_tmp160_ = _tmp159_;
			vala_expression_set_target_type (_tmp155_, _tmp160_);
			_vala_code_node_unref0 (_tmp160_);
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp161_;
		ValaExpression* _tmp162_;
		_tmp161_ = vala_assignment_get_left (self);
		_tmp162_ = _tmp161_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp162_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaElementAccess* _tmp166_;
			ValaExpression* _tmp167_;
			ValaExpression* _tmp168_;
			ValaDataType* _tmp169_;
			ValaDataType* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaTypeSymbol* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaSemanticAnalyzer* _tmp174_;
			ValaDataType* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			ValaTypeSymbol* _tmp177_;
			_tmp163_ = vala_assignment_get_left (self);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp165_;
			_tmp166_ = ea;
			_tmp167_ = vala_element_access_get_container (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = vala_expression_get_value_type (_tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_data_type_get_data_type (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_code_context_get_analyzer (context);
			_tmp174_ = _tmp173_;
			_tmp175_ = _tmp174_->string_type;
			_tmp176_ = vala_data_type_get_data_type (_tmp175_);
			_tmp177_ = _tmp176_;
			if (_tmp172_ == _tmp177_) {
				ValaElementAccess* _tmp178_;
				ValaSourceReference* _tmp179_;
				ValaSourceReference* _tmp180_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp178_ = ea;
				_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
				_tmp180_ = _tmp179_;
				vala_report_error (_tmp180_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				ValaElementAccess* _tmp181_;
				ValaExpression* _tmp182_;
				ValaExpression* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				gboolean _tmp188_;
				_tmp181_ = ea;
				_tmp182_ = vala_element_access_get_container (_tmp181_);
				_tmp183_ = _tmp182_;
				_tmp184_ = vala_expression_get_value_type (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_data_type_get_member (_tmp185_, "set");
				_tmp187_ = _tmp186_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp187_, VALA_TYPE_METHOD);
				_vala_code_node_unref0 (_tmp187_);
				if (_tmp188_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp189_;
					ValaExpression* _tmp190_;
					ValaExpression* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaSourceReference* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaMemberAccess* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp199_;
					ValaMethodCall* _tmp209_;
					ValaExpression* _tmp210_;
					ValaExpression* _tmp211_;
					ValaCodeNode* _tmp212_;
					ValaCodeNode* _tmp213_;
					ValaMethodCall* _tmp214_;
					ValaMethodCall* _tmp215_;
					_tmp189_ = ea;
					_tmp190_ = vala_element_access_get_container (_tmp189_);
					_tmp191_ = _tmp190_;
					_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp193_ = _tmp192_;
					_tmp194_ = vala_member_access_new (_tmp191_, "set", _tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_method_call_new ((ValaExpression*) _tmp195_, _tmp197_);
					_tmp199_ = _tmp198_;
					_vala_code_node_unref0 (_tmp195_);
					set_call = _tmp199_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp200_;
						ValaList* _tmp201_;
						gint _e_size = 0;
						ValaList* _tmp202_;
						gint _tmp203_;
						gint _tmp204_;
						gint _e_index = 0;
						_tmp200_ = ea;
						_tmp201_ = vala_element_access_get_indices (_tmp200_);
						_e_list = _tmp201_;
						_tmp202_ = _e_list;
						_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
						_tmp204_ = _tmp203_;
						_e_size = _tmp204_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp205_;
							gpointer _tmp206_;
							ValaMethodCall* _tmp207_;
							ValaExpression* _tmp208_;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp205_ = _e_list;
							_tmp206_ = vala_list_get (_tmp205_, _e_index);
							e = (ValaExpression*) _tmp206_;
							_tmp207_ = set_call;
							_tmp208_ = e;
							vala_method_call_add_argument (_tmp207_, _tmp208_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp209_ = set_call;
					_tmp210_ = vala_assignment_get_right (self);
					_tmp211_ = _tmp210_;
					vala_method_call_add_argument (_tmp209_, _tmp211_);
					_tmp212_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp213_ = _tmp212_;
					_tmp214_ = set_call;
					vala_code_node_replace_expression (_tmp213_, (ValaExpression*) self, (ValaExpression*) _tmp214_);
					_tmp215_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
					_vala_code_node_unref0 (set_call);
					_vala_code_node_unref0 (ea);
					return result;
				} else {
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					_tmp216_ = vala_assignment_get_right (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_assignment_get_left (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_expression_get_value_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_data_type_copy (_tmp221_);
					_tmp223_ = _tmp222_;
					vala_expression_set_target_type (_tmp217_, _tmp223_);
					_vala_code_node_unref0 (_tmp223_);
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp224_;
			ValaExpression* _tmp225_;
			_tmp224_ = vala_assignment_get_left (self);
			_tmp225_ = _tmp224_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp225_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp226_;
				ValaExpression* _tmp227_;
				ValaExpression* _tmp228_;
				ValaExpression* _tmp229_;
				ValaDataType* _tmp230_;
				ValaDataType* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				_tmp226_ = vala_assignment_get_right (self);
				_tmp227_ = _tmp226_;
				_tmp228_ = vala_assignment_get_left (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_expression_get_value_type (_tmp229_);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_data_type_copy (_tmp231_);
				_tmp233_ = _tmp232_;
				vala_expression_set_target_type (_tmp227_, _tmp233_);
				_vala_code_node_unref0 (_tmp233_);
			} else {
				ValaExpression* _tmp234_;
				ValaExpression* _tmp235_;
				_tmp234_ = vala_assignment_get_left (self);
				_tmp235_ = _tmp234_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp235_, VALA_TYPE_LITERAL)) {
					ValaSourceReference* _tmp236_;
					ValaSourceReference* _tmp237_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp237_ = _tmp236_;
					vala_report_error (_tmp237_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp238_;
					ValaSourceReference* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp239_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp240_ = vala_assignment_get_right (self);
	_tmp241_ = _tmp240_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp241_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp242_ = vala_assignment_get_left (self);
	_tmp243_ = _tmp242_;
	ma = G_TYPE_CHECK_INSTANCE_TYPE (_tmp243_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp243_) : NULL;
	_tmp246_ = self->priv->_operator;
	if (_tmp246_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp247_;
		_tmp247_ = ma;
		_tmp245_ = _tmp247_ != NULL;
	} else {
		_tmp245_ = FALSE;
	}
	if (_tmp245_) {
		gboolean _tmp248_ = FALSE;
		ValaExpression* _tmp249_;
		ValaExpression* _tmp250_;
		ValaDataType* _tmp251_;
		ValaDataType* _tmp252_;
		_tmp249_ = vala_assignment_get_left (self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_expression_get_value_type (_tmp250_);
		_tmp252_ = _tmp251_;
		if (vala_data_type_is_non_null_simple_type (_tmp252_)) {
			ValaMemberAccess* _tmp253_;
			ValaSymbol* _tmp254_;
			ValaSymbol* _tmp255_;
			_tmp253_ = ma;
			_tmp254_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp253_);
			_tmp255_ = _tmp254_;
			_tmp248_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp255_, VALA_TYPE_LOCAL_VARIABLE);
		} else {
			_tmp248_ = FALSE;
		}
		_tmp244_ = !_tmp248_;
	} else {
		_tmp244_ = FALSE;
	}
	if (_tmp244_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp256_;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaMemberAccess* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaMemberAccess* _tmp262_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp263_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp264_;
		ValaMemberAccess* _tmp265_;
		ValaExpression* _tmp266_;
		ValaExpression* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaBinaryExpression* _tmp270_;
		ValaBinaryExpression* _tmp271_;
		ValaExpression* _tmp272_;
		ValaExpression* _tmp273_;
		ValaDataType* _tmp274_;
		ValaDataType* _tmp275_;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaDataType* _tmp280_;
		ValaDataType* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		ValaExpression* _tmp284_;
		ValaExpression* _tmp285_;
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		ValaBinaryExpression* _tmp288_;
		ValaExpression* _tmp289_;
		ValaExpression* _tmp290_;
		_tmp256_ = ma;
		_tmp257_ = vala_member_access_get_inner (_tmp256_);
		_tmp258_ = _tmp257_;
		_tmp259_ = ma;
		_tmp260_ = vala_member_access_get_member_name (_tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_member_access_new (_tmp258_, _tmp261_, NULL);
		old_value = _tmp262_;
		_tmp263_ = self->priv->_operator;
		switch (_tmp263_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				g_assert_not_reached ();
			}
		}
		_tmp264_ = bop;
		_tmp265_ = old_value;
		_tmp266_ = vala_assignment_get_right (self);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_binary_expression_new (_tmp264_, (ValaExpression*) _tmp265_, _tmp267_, _tmp269_);
		bin = _tmp270_;
		_tmp271_ = bin;
		_tmp272_ = vala_assignment_get_right (self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_expression_get_target_type (_tmp273_);
		_tmp275_ = _tmp274_;
		vala_expression_set_target_type ((ValaExpression*) _tmp271_, _tmp275_);
		_tmp276_ = vala_assignment_get_right (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_assignment_get_right (self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_expression_get_target_type (_tmp279_);
		_tmp281_ = _tmp280_;
		_tmp282_ = vala_data_type_copy (_tmp281_);
		_tmp283_ = _tmp282_;
		vala_expression_set_target_type (_tmp277_, _tmp283_);
		_vala_code_node_unref0 (_tmp283_);
		_tmp284_ = vala_assignment_get_right (self);
		_tmp285_ = _tmp284_;
		_tmp286_ = vala_expression_get_target_type (_tmp285_);
		_tmp287_ = _tmp286_;
		vala_data_type_set_value_owned (_tmp287_, FALSE);
		_tmp288_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp288_);
		_tmp289_ = vala_assignment_get_right (self);
		_tmp290_ = _tmp289_;
		vala_code_node_check ((ValaCodeNode*) _tmp290_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp291_ = ma;
	if (_tmp291_ != NULL) {
		ValaMemberAccess* _tmp292_;
		ValaSymbol* _tmp293_;
		ValaSymbol* _tmp294_;
		gboolean _tmp468_ = FALSE;
		ValaExpression* _tmp469_;
		ValaExpression* _tmp470_;
		ValaDataType* _tmp471_;
		ValaDataType* _tmp472_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp527_;
		ValaExpression* _tmp528_;
		ValaMemberAccess* _tmp529_;
		gboolean _tmp530_ = FALSE;
		ValaMemberAccess* _tmp531_;
		_tmp292_ = ma;
		_tmp293_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp292_);
		_tmp294_ = _tmp293_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, VALA_TYPE_PROPERTY)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp295_;
			ValaSymbol* _tmp296_;
			ValaSymbol* _tmp297_;
			ValaProperty* _tmp298_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp299_;
			ValaDynamicProperty* _tmp300_;
			ValaDynamicProperty* _tmp301_;
			gboolean _tmp316_ = FALSE;
			ValaProperty* _tmp317_;
			ValaPropertyAccessor* _tmp318_;
			ValaPropertyAccessor* _tmp319_;
			_tmp295_ = ma;
			_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp295_);
			_tmp297_ = _tmp296_;
			_tmp298_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp298_;
			_tmp299_ = prop;
			_tmp300_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp299_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp299_) : NULL);
			dynamic_prop = _tmp300_;
			_tmp301_ = dynamic_prop;
			if (_tmp301_ != NULL) {
				ValaDynamicProperty* _tmp302_;
				ValaExpression* _tmp303_;
				ValaExpression* _tmp304_;
				ValaDataType* _tmp305_;
				ValaDataType* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				ValaExpression* _tmp309_;
				ValaExpression* _tmp310_;
				ValaDynamicProperty* _tmp311_;
				ValaDataType* _tmp312_;
				ValaDataType* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				_tmp302_ = dynamic_prop;
				_tmp303_ = vala_assignment_get_right (self);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_expression_get_value_type (_tmp304_);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_data_type_copy (_tmp306_);
				_tmp308_ = _tmp307_;
				vala_property_set_property_type ((ValaProperty*) _tmp302_, _tmp308_);
				_vala_code_node_unref0 (_tmp308_);
				_tmp309_ = vala_assignment_get_left (self);
				_tmp310_ = _tmp309_;
				_tmp311_ = dynamic_prop;
				_tmp312_ = vala_property_get_property_type ((ValaProperty*) _tmp311_);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_data_type_copy (_tmp313_);
				_tmp315_ = _tmp314_;
				vala_expression_set_value_type (_tmp310_, _tmp315_);
				_vala_code_node_unref0 (_tmp315_);
			}
			_tmp317_ = prop;
			_tmp318_ = vala_property_get_set_accessor (_tmp317_);
			_tmp319_ = _tmp318_;
			if (_tmp319_ == NULL) {
				_tmp316_ = TRUE;
			} else {
				gboolean _tmp320_ = FALSE;
				ValaProperty* _tmp321_;
				ValaPropertyAccessor* _tmp322_;
				ValaPropertyAccessor* _tmp323_;
				gboolean _tmp324_;
				gboolean _tmp325_;
				_tmp321_ = prop;
				_tmp322_ = vala_property_get_set_accessor (_tmp321_);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_property_accessor_get_writable (_tmp323_);
				_tmp325_ = _tmp324_;
				if (!_tmp325_) {
					gboolean _tmp326_ = FALSE;
					ValaSemanticAnalyzer* _tmp327_;
					ValaSemanticAnalyzer* _tmp328_;
					ValaMethod* _tmp329_;
					ValaMethod* _tmp330_;
					gboolean _tmp331_;
					_tmp327_ = vala_code_context_get_analyzer (context);
					_tmp328_ = _tmp327_;
					_tmp329_ = vala_semantic_analyzer_find_current_method (_tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_CREATION_METHOD);
					_vala_code_node_unref0 (_tmp330_);
					if (_tmp331_) {
						_tmp326_ = TRUE;
					} else {
						ValaSemanticAnalyzer* _tmp332_;
						ValaSemanticAnalyzer* _tmp333_;
						_tmp332_ = vala_code_context_get_analyzer (context);
						_tmp333_ = _tmp332_;
						_tmp326_ = vala_semantic_analyzer_is_in_constructor (_tmp333_);
					}
					_tmp320_ = !_tmp326_;
				} else {
					_tmp320_ = FALSE;
				}
				_tmp316_ = _tmp320_;
			}
			if (_tmp316_) {
				ValaMemberAccess* _tmp334_;
				ValaMemberAccess* _tmp335_;
				ValaSourceReference* _tmp336_;
				ValaSourceReference* _tmp337_;
				ValaProperty* _tmp338_;
				gchar* _tmp339_;
				gchar* _tmp340_;
				gchar* _tmp341_;
				gchar* _tmp342_;
				_tmp334_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp334_, TRUE);
				_tmp335_ = ma;
				_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = prop;
				_tmp339_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp338_);
				_tmp340_ = _tmp339_;
				_tmp341_ = g_strdup_printf ("Property `%s' is read-only", _tmp340_);
				_tmp342_ = _tmp341_;
				vala_report_error (_tmp337_, _tmp342_);
				_g_free0 (_tmp342_);
				_g_free0 (_tmp340_);
				result = FALSE;
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
				return result;
			} else {
				gboolean _tmp343_ = FALSE;
				gboolean _tmp344_ = FALSE;
				gboolean _tmp345_;
				gboolean _tmp346_;
				_tmp345_ = vala_code_context_get_deprecated (context);
				_tmp346_ = _tmp345_;
				if (!_tmp346_) {
					ValaProperty* _tmp347_;
					ValaPropertyAccessor* _tmp348_;
					ValaPropertyAccessor* _tmp349_;
					gboolean _tmp350_;
					gboolean _tmp351_;
					_tmp347_ = prop;
					_tmp348_ = vala_property_get_set_accessor (_tmp347_);
					_tmp349_ = _tmp348_;
					_tmp350_ = vala_property_accessor_get_writable (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp344_ = !_tmp351_;
				} else {
					_tmp344_ = FALSE;
				}
				if (_tmp344_) {
					ValaSemanticAnalyzer* _tmp352_;
					ValaSemanticAnalyzer* _tmp353_;
					ValaMethod* _tmp354_;
					ValaMethod* _tmp355_;
					_tmp352_ = vala_code_context_get_analyzer (context);
					_tmp353_ = _tmp352_;
					_tmp354_ = vala_semantic_analyzer_find_current_method (_tmp353_);
					_tmp355_ = _tmp354_;
					_tmp343_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp355_, VALA_TYPE_CREATION_METHOD);
					_vala_code_node_unref0 (_tmp355_);
				} else {
					_tmp343_ = FALSE;
				}
				if (_tmp343_) {
					ValaMemberAccess* _tmp356_;
					ValaExpression* _tmp357_;
					ValaExpression* _tmp358_;
					ValaSymbol* _tmp359_;
					ValaSymbol* _tmp360_;
					ValaSemanticAnalyzer* _tmp361_;
					ValaSemanticAnalyzer* _tmp362_;
					ValaMethod* _tmp363_;
					ValaMethod* _tmp364_;
					ValaParameter* _tmp365_;
					ValaParameter* _tmp366_;
					gboolean _tmp367_;
					_tmp356_ = ma;
					_tmp357_ = vala_member_access_get_inner (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_expression_get_symbol_reference (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_code_context_get_analyzer (context);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_semantic_analyzer_find_current_method (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_method_get_this_parameter (_tmp364_);
					_tmp366_ = _tmp365_;
					_tmp367_ = _tmp360_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp366_, VALA_TYPE_SYMBOL, ValaSymbol);
					_vala_code_node_unref0 (_tmp364_);
					if (_tmp367_) {
						ValaMemberAccess* _tmp368_;
						ValaSourceReference* _tmp369_;
						ValaSourceReference* _tmp370_;
						ValaProperty* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						_tmp368_ = ma;
						_tmp369_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp368_);
						_tmp370_ = _tmp369_;
						_tmp371_ = prop;
						_tmp372_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = g_strdup_printf ("Property `%s' is read-only", _tmp373_);
						_tmp375_ = _tmp374_;
						vala_report_error (_tmp370_, _tmp375_);
						_g_free0 (_tmp375_);
						_g_free0 (_tmp373_);
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					} else {
						ValaMemberAccess* _tmp376_;
						ValaSourceReference* _tmp377_;
						ValaSourceReference* _tmp378_;
						_tmp376_ = ma;
						_tmp377_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp376_);
						_tmp378_ = _tmp377_;
						vala_report_error (_tmp378_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
						result = FALSE;
						_vala_code_node_unref0 (dynamic_prop);
						_vala_code_node_unref0 (prop);
						return result;
					}
				}
			}
			_vala_code_node_unref0 (dynamic_prop);
			_vala_code_node_unref0 (prop);
		} else {
			gboolean _tmp379_ = FALSE;
			ValaMemberAccess* _tmp380_;
			ValaSymbol* _tmp381_;
			ValaSymbol* _tmp382_;
			_tmp380_ = ma;
			_tmp381_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp380_);
			_tmp382_ = _tmp381_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp382_, VALA_TYPE_VARIABLE)) {
				ValaExpression* _tmp383_;
				ValaExpression* _tmp384_;
				ValaDataType* _tmp385_;
				ValaDataType* _tmp386_;
				_tmp383_ = vala_assignment_get_right (self);
				_tmp384_ = _tmp383_;
				_tmp385_ = vala_expression_get_value_type (_tmp384_);
				_tmp386_ = _tmp385_;
				_tmp379_ = _tmp386_ == NULL;
			} else {
				_tmp379_ = FALSE;
			}
			if (_tmp379_) {
				ValaVariable* variable = NULL;
				ValaMemberAccess* _tmp387_;
				ValaSymbol* _tmp388_;
				ValaSymbol* _tmp389_;
				ValaVariable* _tmp390_;
				gboolean _tmp391_ = FALSE;
				ValaExpression* _tmp392_;
				ValaExpression* _tmp393_;
				ValaSymbol* _tmp394_;
				ValaSymbol* _tmp395_;
				_tmp387_ = ma;
				_tmp388_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp389_, VALA_TYPE_VARIABLE, ValaVariable));
				variable = _tmp390_;
				_tmp392_ = vala_assignment_get_right (self);
				_tmp393_ = _tmp392_;
				_tmp394_ = vala_expression_get_symbol_reference (_tmp393_);
				_tmp395_ = _tmp394_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp395_, VALA_TYPE_METHOD)) {
					ValaVariable* _tmp396_;
					ValaDataType* _tmp397_;
					ValaDataType* _tmp398_;
					_tmp396_ = variable;
					_tmp397_ = vala_variable_get_variable_type (_tmp396_);
					_tmp398_ = _tmp397_;
					_tmp391_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp398_, VALA_TYPE_DELEGATE_TYPE);
				} else {
					_tmp391_ = FALSE;
				}
				if (_tmp391_) {
					ValaMethod* m = NULL;
					ValaExpression* _tmp399_;
					ValaExpression* _tmp400_;
					ValaSymbol* _tmp401_;
					ValaSymbol* _tmp402_;
					ValaMethod* _tmp403_;
					ValaDelegateType* dt = NULL;
					ValaVariable* _tmp404_;
					ValaDataType* _tmp405_;
					ValaDataType* _tmp406_;
					ValaDelegateType* _tmp407_;
					ValaDelegate* cb = NULL;
					ValaDelegateType* _tmp408_;
					ValaDelegate* _tmp409_;
					ValaDelegate* _tmp410_;
					ValaDelegate* _tmp411_;
					ValaDelegate* _tmp412_;
					ValaMethod* _tmp413_;
					ValaDelegateType* _tmp414_;
					ValaExpression* _tmp425_;
					ValaExpression* _tmp426_;
					ValaVariable* _tmp427_;
					ValaDataType* _tmp428_;
					ValaDataType* _tmp429_;
					ValaDataType* _tmp430_;
					ValaDataType* _tmp431_;
					_tmp399_ = vala_assignment_get_right (self);
					_tmp400_ = _tmp399_;
					_tmp401_ = vala_expression_get_symbol_reference (_tmp400_);
					_tmp402_ = _tmp401_;
					_tmp403_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp402_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp403_;
					_tmp404_ = variable;
					_tmp405_ = vala_variable_get_variable_type (_tmp404_);
					_tmp406_ = _tmp405_;
					_tmp407_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					dt = _tmp407_;
					_tmp408_ = dt;
					_tmp409_ = vala_delegate_type_get_delegate_symbol (_tmp408_);
					_tmp410_ = _tmp409_;
					_tmp411_ = _vala_code_node_ref0 (_tmp410_);
					cb = _tmp411_;
					_tmp412_ = cb;
					_tmp413_ = m;
					_tmp414_ = dt;
					if (!vala_delegate_matches_method (_tmp412_, _tmp413_, (ValaDataType*) _tmp414_)) {
						ValaSourceReference* _tmp415_;
						ValaSourceReference* _tmp416_;
						ValaMethod* _tmp417_;
						gchar* _tmp418_;
						gchar* _tmp419_;
						ValaDelegate* _tmp420_;
						gchar* _tmp421_;
						gchar* _tmp422_;
						gchar* _tmp423_;
						gchar* _tmp424_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp415_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp416_ = _tmp415_;
						_tmp417_ = m;
						_tmp418_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp417_);
						_tmp419_ = _tmp418_;
						_tmp420_ = cb;
						_tmp421_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp420_);
						_tmp422_ = _tmp421_;
						_tmp423_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp419_, _tmp422_);
						_tmp424_ = _tmp423_;
						vala_report_error (_tmp416_, _tmp424_);
						_g_free0 (_tmp424_);
						_g_free0 (_tmp422_);
						_g_free0 (_tmp419_);
						result = FALSE;
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (variable);
						return result;
					}
					_tmp425_ = vala_assignment_get_right (self);
					_tmp426_ = _tmp425_;
					_tmp427_ = variable;
					_tmp428_ = vala_variable_get_variable_type (_tmp427_);
					_tmp429_ = _tmp428_;
					_tmp430_ = vala_data_type_copy (_tmp429_);
					_tmp431_ = _tmp430_;
					vala_expression_set_value_type (_tmp426_, _tmp431_);
					_vala_code_node_unref0 (_tmp431_);
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
				} else {
					ValaSourceReference* _tmp432_;
					ValaSourceReference* _tmp433_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp433_ = _tmp432_;
					vala_report_error (_tmp433_, "Assignment: Invalid assignment attempt");
					result = FALSE;
					_vala_code_node_unref0 (variable);
					return result;
				}
				_vala_code_node_unref0 (variable);
			} else {
				ValaMemberAccess* _tmp434_;
				ValaSymbol* _tmp435_;
				ValaSymbol* _tmp436_;
				_tmp434_ = ma;
				_tmp435_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp434_);
				_tmp436_ = _tmp435_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp436_, VALA_TYPE_VARIABLE)) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp437_;
					ValaSymbol* _tmp438_;
					ValaSymbol* _tmp439_;
					ValaArrayType* variable_array_type = NULL;
					ValaVariable* _tmp440_;
					ValaDataType* _tmp441_;
					ValaDataType* _tmp442_;
					gboolean _tmp443_ = FALSE;
					gboolean _tmp444_ = FALSE;
					gboolean _tmp445_ = FALSE;
					ValaArrayType* _tmp446_;
					_tmp437_ = ma;
					_tmp438_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp437_);
					_tmp439_ = _tmp438_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp440_ = variable;
					_tmp441_ = vala_variable_get_variable_type (_tmp440_);
					_tmp442_ = _tmp441_;
					variable_array_type = G_TYPE_CHECK_INSTANCE_TYPE (_tmp442_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp442_) : NULL;
					_tmp446_ = variable_array_type;
					if (_tmp446_ != NULL) {
						ValaArrayType* _tmp447_;
						gboolean _tmp448_;
						gboolean _tmp449_;
						_tmp447_ = variable_array_type;
						_tmp448_ = vala_array_type_get_fixed_length (_tmp447_);
						_tmp449_ = _tmp448_;
						_tmp445_ = _tmp449_;
					} else {
						_tmp445_ = FALSE;
					}
					if (_tmp445_) {
						ValaExpression* _tmp450_;
						ValaExpression* _tmp451_;
						_tmp450_ = vala_assignment_get_right (self);
						_tmp451_ = _tmp450_;
						_tmp444_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp451_, VALA_TYPE_ARRAY_CREATION_EXPRESSION);
					} else {
						_tmp444_ = FALSE;
					}
					if (_tmp444_) {
						ValaExpression* _tmp452_;
						ValaExpression* _tmp453_;
						ValaInitializerList* _tmp454_;
						ValaInitializerList* _tmp455_;
						_tmp452_ = vala_assignment_get_right (self);
						_tmp453_ = _tmp452_;
						_tmp454_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp453_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
						_tmp455_ = _tmp454_;
						_tmp443_ = _tmp455_ == NULL;
					} else {
						_tmp443_ = FALSE;
					}
					if (_tmp443_) {
						ValaSourceReference* _tmp456_;
						ValaSourceReference* _tmp457_;
						ValaCodeNode* _tmp458_;
						ValaCodeNode* _tmp459_;
						ValaCodeNode* _tmp460_;
						ValaCodeNode* _tmp461_;
						ValaCodeNode* _tmp462_;
						ValaCodeNode* _tmp463_;
						ValaSourceReference* _tmp464_;
						ValaSourceReference* _tmp465_;
						ValaEmptyStatement* _tmp466_;
						ValaEmptyStatement* _tmp467_;
						_tmp456_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp457_ = _tmp456_;
						vala_report_warning (_tmp457_, "Arrays with fixed length don't require an explicit instantiation");
						_tmp458_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp459_ = _tmp458_;
						_tmp460_ = vala_code_node_get_parent_node (_tmp459_);
						_tmp461_ = _tmp460_;
						_tmp462_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp463_ = _tmp462_;
						_tmp464_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp465_ = _tmp464_;
						_tmp466_ = vala_empty_statement_new (_tmp465_);
						_tmp467_ = _tmp466_;
						vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp463_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp467_);
						_vala_code_node_unref0 (_tmp467_);
						result = TRUE;
						return result;
					}
				}
			}
		}
		_tmp469_ = vala_assignment_get_left (self);
		_tmp470_ = _tmp469_;
		_tmp471_ = vala_expression_get_value_type (_tmp470_);
		_tmp472_ = _tmp471_;
		if (_tmp472_ != NULL) {
			ValaExpression* _tmp473_;
			ValaExpression* _tmp474_;
			ValaDataType* _tmp475_;
			ValaDataType* _tmp476_;
			_tmp473_ = vala_assignment_get_right (self);
			_tmp474_ = _tmp473_;
			_tmp475_ = vala_expression_get_value_type (_tmp474_);
			_tmp476_ = _tmp475_;
			_tmp468_ = _tmp476_ != NULL;
		} else {
			_tmp468_ = FALSE;
		}
		if (_tmp468_) {
			ValaExpression* _tmp477_;
			ValaExpression* _tmp478_;
			ValaDataType* _tmp479_;
			ValaDataType* _tmp480_;
			ValaExpression* _tmp481_;
			ValaExpression* _tmp482_;
			ValaDataType* _tmp483_;
			ValaDataType* _tmp484_;
			ValaMemberAccess* _tmp501_;
			ValaSymbol* _tmp502_;
			ValaSymbol* _tmp503_;
			_tmp477_ = vala_assignment_get_right (self);
			_tmp478_ = _tmp477_;
			_tmp479_ = vala_expression_get_value_type (_tmp478_);
			_tmp480_ = _tmp479_;
			_tmp481_ = vala_assignment_get_left (self);
			_tmp482_ = _tmp481_;
			_tmp483_ = vala_expression_get_value_type (_tmp482_);
			_tmp484_ = _tmp483_;
			if (!vala_data_type_compatible (_tmp480_, _tmp484_)) {
				ValaSourceReference* _tmp485_;
				ValaSourceReference* _tmp486_;
				ValaExpression* _tmp487_;
				ValaExpression* _tmp488_;
				ValaDataType* _tmp489_;
				ValaDataType* _tmp490_;
				gchar* _tmp491_;
				gchar* _tmp492_;
				ValaExpression* _tmp493_;
				ValaExpression* _tmp494_;
				ValaDataType* _tmp495_;
				ValaDataType* _tmp496_;
				gchar* _tmp497_;
				gchar* _tmp498_;
				gchar* _tmp499_;
				gchar* _tmp500_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp486_ = _tmp485_;
				_tmp487_ = vala_assignment_get_right (self);
				_tmp488_ = _tmp487_;
				_tmp489_ = vala_expression_get_value_type (_tmp488_);
				_tmp490_ = _tmp489_;
				_tmp491_ = vala_code_node_to_string ((ValaCodeNode*) _tmp490_);
				_tmp492_ = _tmp491_;
				_tmp493_ = vala_assignment_get_left (self);
				_tmp494_ = _tmp493_;
				_tmp495_ = vala_expression_get_value_type (_tmp494_);
				_tmp496_ = _tmp495_;
				_tmp497_ = vala_code_node_to_string ((ValaCodeNode*) _tmp496_);
				_tmp498_ = _tmp497_;
				_tmp499_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp492_, _tmp498_);
				_tmp500_ = _tmp499_;
				vala_report_error (_tmp486_, _tmp500_);
				_g_free0 (_tmp500_);
				_g_free0 (_tmp498_);
				_g_free0 (_tmp492_);
				result = FALSE;
				return result;
			}
			_tmp501_ = ma;
			_tmp502_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp501_);
			_tmp503_ = _tmp502_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp503_, VALA_TYPE_PROPERTY)) {
				ValaExpression* _tmp504_;
				ValaExpression* _tmp505_;
				ValaDataType* _tmp506_;
				ValaDataType* _tmp507_;
				_tmp504_ = vala_assignment_get_right (self);
				_tmp505_ = _tmp504_;
				_tmp506_ = vala_expression_get_value_type (_tmp505_);
				_tmp507_ = _tmp506_;
				if (vala_data_type_is_disposable (_tmp507_)) {
					gboolean _tmp508_ = FALSE;
					ValaExpression* _tmp509_;
					ValaExpression* _tmp510_;
					ValaDataType* _tmp511_;
					ValaDataType* _tmp512_;
					_tmp509_ = vala_assignment_get_left (self);
					_tmp510_ = _tmp509_;
					_tmp511_ = vala_expression_get_value_type (_tmp510_);
					_tmp512_ = _tmp511_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_POINTER_TYPE)) {
						ValaExpression* _tmp513_;
						ValaExpression* _tmp514_;
						ValaDataType* _tmp515_;
						ValaDataType* _tmp516_;
						gboolean _tmp517_;
						gboolean _tmp518_;
						_tmp513_ = vala_assignment_get_left (self);
						_tmp514_ = _tmp513_;
						_tmp515_ = vala_expression_get_value_type (_tmp514_);
						_tmp516_ = _tmp515_;
						_tmp517_ = vala_data_type_get_value_owned (_tmp516_);
						_tmp518_ = _tmp517_;
						_tmp508_ = !_tmp518_;
					} else {
						_tmp508_ = FALSE;
					}
					if (_tmp508_) {
						ValaSourceReference* _tmp519_;
						ValaSourceReference* _tmp520_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp520_ = _tmp519_;
						vala_report_error (_tmp520_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp521_;
					ValaExpression* _tmp522_;
					ValaDataType* _tmp523_;
					ValaDataType* _tmp524_;
					gboolean _tmp525_;
					gboolean _tmp526_;
					_tmp521_ = vala_assignment_get_left (self);
					_tmp522_ = _tmp521_;
					_tmp523_ = vala_expression_get_value_type (_tmp522_);
					_tmp524_ = _tmp523_;
					_tmp525_ = vala_data_type_get_value_owned (_tmp524_);
					_tmp526_ = _tmp525_;
					if (_tmp526_) {
					}
				}
			}
		}
		_tmp527_ = vala_assignment_get_right (self);
		_tmp528_ = _tmp527_;
		_tmp529_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp528_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp528_) : NULL);
		right_ma = _tmp529_;
		_tmp531_ = right_ma;
		if (_tmp531_ != NULL) {
			ValaMemberAccess* _tmp532_;
			ValaSymbol* _tmp533_;
			ValaSymbol* _tmp534_;
			ValaMemberAccess* _tmp535_;
			ValaSymbol* _tmp536_;
			ValaSymbol* _tmp537_;
			_tmp532_ = ma;
			_tmp533_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = right_ma;
			_tmp536_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp535_);
			_tmp537_ = _tmp536_;
			_tmp530_ = _tmp534_ == _tmp537_;
		} else {
			_tmp530_ = FALSE;
		}
		if (_tmp530_) {
			gboolean _tmp538_ = FALSE;
			ValaMemberAccess* _tmp539_;
			ValaSymbol* _tmp540_;
			ValaSymbol* _tmp541_;
			_tmp539_ = ma;
			_tmp540_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp539_);
			_tmp541_ = _tmp540_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp541_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp538_ = TRUE;
			} else {
				ValaMemberAccess* _tmp542_;
				ValaSymbol* _tmp543_;
				ValaSymbol* _tmp544_;
				_tmp542_ = ma;
				_tmp543_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp542_);
				_tmp544_ = _tmp543_;
				_tmp538_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp544_, VALA_TYPE_PARAMETER);
			}
			if (_tmp538_) {
				ValaSourceReference* _tmp545_;
				ValaSourceReference* _tmp546_;
				_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp546_ = _tmp545_;
				vala_report_warning (_tmp546_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp547_;
				ValaSymbol* _tmp548_;
				ValaSymbol* _tmp549_;
				_tmp547_ = ma;
				_tmp548_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp547_);
				_tmp549_ = _tmp548_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp549_, VALA_TYPE_FIELD)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp550_;
					ValaSymbol* _tmp551_;
					ValaSymbol* _tmp552_;
					ValaField* _tmp553_;
					ValaField* _tmp554_;
					ValaMemberBinding _tmp555_;
					ValaMemberBinding _tmp556_;
					_tmp550_ = ma;
					_tmp551_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp552_, VALA_TYPE_FIELD, ValaField));
					f = _tmp553_;
					_tmp554_ = f;
					_tmp555_ = vala_field_get_binding (_tmp554_);
					_tmp556_ = _tmp555_;
					if (_tmp556_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp557_;
						ValaSourceReference* _tmp558_;
						_tmp557_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp558_ = _tmp557_;
						vala_report_warning (_tmp558_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp559_;
						ValaExpression* _tmp560_;
						ValaExpression* _tmp561_;
						ValaMemberAccess* _tmp562_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp563_;
						ValaExpression* _tmp564_;
						ValaExpression* _tmp565_;
						ValaMemberAccess* _tmp566_;
						gboolean _tmp567_ = FALSE;
						gboolean _tmp568_ = FALSE;
						gboolean _tmp569_ = FALSE;
						gboolean _tmp570_ = FALSE;
						gboolean _tmp571_ = FALSE;
						ValaMemberAccess* _tmp572_;
						_tmp559_ = ma;
						_tmp560_ = vala_member_access_get_inner (_tmp559_);
						_tmp561_ = _tmp560_;
						_tmp562_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp561_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp561_) : NULL);
						ma_inner = _tmp562_;
						_tmp563_ = right_ma;
						_tmp564_ = vala_member_access_get_inner (_tmp563_);
						_tmp565_ = _tmp564_;
						_tmp566_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp565_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp565_) : NULL);
						right_ma_inner = _tmp566_;
						_tmp572_ = ma_inner;
						if (_tmp572_ != NULL) {
							ValaMemberAccess* _tmp573_;
							const gchar* _tmp574_;
							const gchar* _tmp575_;
							_tmp573_ = ma_inner;
							_tmp574_ = vala_member_access_get_member_name (_tmp573_);
							_tmp575_ = _tmp574_;
							_tmp571_ = g_strcmp0 (_tmp575_, "this") == 0;
						} else {
							_tmp571_ = FALSE;
						}
						if (_tmp571_) {
							ValaMemberAccess* _tmp576_;
							ValaExpression* _tmp577_;
							ValaExpression* _tmp578_;
							_tmp576_ = ma_inner;
							_tmp577_ = vala_member_access_get_inner (_tmp576_);
							_tmp578_ = _tmp577_;
							_tmp570_ = _tmp578_ == NULL;
						} else {
							_tmp570_ = FALSE;
						}
						if (_tmp570_) {
							ValaMemberAccess* _tmp579_;
							_tmp579_ = right_ma_inner;
							_tmp569_ = _tmp579_ != NULL;
						} else {
							_tmp569_ = FALSE;
						}
						if (_tmp569_) {
							ValaMemberAccess* _tmp580_;
							const gchar* _tmp581_;
							const gchar* _tmp582_;
							_tmp580_ = right_ma_inner;
							_tmp581_ = vala_member_access_get_member_name (_tmp580_);
							_tmp582_ = _tmp581_;
							_tmp568_ = g_strcmp0 (_tmp582_, "this") == 0;
						} else {
							_tmp568_ = FALSE;
						}
						if (_tmp568_) {
							ValaMemberAccess* _tmp583_;
							ValaExpression* _tmp584_;
							ValaExpression* _tmp585_;
							_tmp583_ = right_ma_inner;
							_tmp584_ = vala_member_access_get_inner (_tmp583_);
							_tmp585_ = _tmp584_;
							_tmp567_ = _tmp585_ == NULL;
						} else {
							_tmp567_ = FALSE;
						}
						if (_tmp567_) {
							ValaSourceReference* _tmp586_;
							ValaSourceReference* _tmp587_;
							_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp587_ = _tmp586_;
							vala_report_warning (_tmp587_, "Assignment to same variable");
						}
						_vala_code_node_unref0 (right_ma_inner);
						_vala_code_node_unref0 (ma_inner);
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
	} else {
		ValaExpression* _tmp588_;
		ValaExpression* _tmp589_;
		_tmp588_ = vala_assignment_get_left (self);
		_tmp589_ = _tmp588_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp589_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp590_;
			ValaExpression* _tmp591_;
			ValaElementAccess* _tmp592_;
			ValaExpression* _tmp593_;
			ValaExpression* _tmp594_;
			ValaDataType* _tmp595_;
			ValaDataType* _tmp596_;
			ValaExpression* _tmp597_;
			ValaExpression* _tmp598_;
			ValaDataType* _tmp599_;
			ValaDataType* _tmp600_;
			ValaExpression* _tmp617_;
			ValaExpression* _tmp618_;
			ValaDataType* _tmp619_;
			ValaDataType* _tmp620_;
			_tmp590_ = vala_assignment_get_left (self);
			_tmp591_ = _tmp590_;
			_tmp592_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp591_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp592_;
			_tmp593_ = vala_assignment_get_right (self);
			_tmp594_ = _tmp593_;
			_tmp595_ = vala_expression_get_value_type (_tmp594_);
			_tmp596_ = _tmp595_;
			_tmp597_ = vala_assignment_get_left (self);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_expression_get_value_type (_tmp598_);
			_tmp600_ = _tmp599_;
			if (!vala_data_type_compatible (_tmp596_, _tmp600_)) {
				ValaSourceReference* _tmp601_;
				ValaSourceReference* _tmp602_;
				ValaExpression* _tmp603_;
				ValaExpression* _tmp604_;
				ValaDataType* _tmp605_;
				ValaDataType* _tmp606_;
				gchar* _tmp607_;
				gchar* _tmp608_;
				ValaExpression* _tmp609_;
				ValaExpression* _tmp610_;
				ValaDataType* _tmp611_;
				ValaDataType* _tmp612_;
				gchar* _tmp613_;
				gchar* _tmp614_;
				gchar* _tmp615_;
				gchar* _tmp616_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_assignment_get_right (self);
				_tmp604_ = _tmp603_;
				_tmp605_ = vala_expression_get_value_type (_tmp604_);
				_tmp606_ = _tmp605_;
				_tmp607_ = vala_code_node_to_string ((ValaCodeNode*) _tmp606_);
				_tmp608_ = _tmp607_;
				_tmp609_ = vala_assignment_get_left (self);
				_tmp610_ = _tmp609_;
				_tmp611_ = vala_expression_get_value_type (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_code_node_to_string ((ValaCodeNode*) _tmp612_);
				_tmp614_ = _tmp613_;
				_tmp615_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp608_, _tmp614_);
				_tmp616_ = _tmp615_;
				vala_report_error (_tmp602_, _tmp616_);
				_g_free0 (_tmp616_);
				_g_free0 (_tmp614_);
				_g_free0 (_tmp608_);
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			}
			_tmp617_ = vala_assignment_get_right (self);
			_tmp618_ = _tmp617_;
			_tmp619_ = vala_expression_get_value_type (_tmp618_);
			_tmp620_ = _tmp619_;
			if (vala_data_type_is_disposable (_tmp620_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp621_;
				ValaExpression* _tmp622_;
				ValaExpression* _tmp623_;
				ValaDataType* _tmp624_;
				ValaDataType* _tmp625_;
				gboolean _tmp647_ = FALSE;
				ValaDataType* _tmp648_;
				_tmp621_ = ea;
				_tmp622_ = vala_element_access_get_container (_tmp621_);
				_tmp623_ = _tmp622_;
				_tmp624_ = vala_expression_get_value_type (_tmp623_);
				_tmp625_ = _tmp624_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp625_, VALA_TYPE_ARRAY_TYPE)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp626_;
					ValaExpression* _tmp627_;
					ValaExpression* _tmp628_;
					ValaDataType* _tmp629_;
					ValaDataType* _tmp630_;
					ValaArrayType* _tmp631_;
					ValaArrayType* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDataType* _tmp634_;
					ValaDataType* _tmp635_;
					_tmp626_ = ea;
					_tmp627_ = vala_element_access_get_container (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_expression_get_value_type (_tmp628_);
					_tmp630_ = _tmp629_;
					_tmp631_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp630_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp631_;
					_tmp632_ = array_type;
					_tmp633_ = vala_array_type_get_element_type (_tmp632_);
					_tmp634_ = _tmp633_;
					_tmp635_ = _vala_code_node_ref0 (_tmp634_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp635_;
					_vala_code_node_unref0 (array_type);
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp636_;
					ValaExpression* _tmp637_;
					ValaExpression* _tmp638_;
					ValaDataType* _tmp639_;
					ValaDataType* _tmp640_;
					ValaList* _tmp641_;
					ValaList* _tmp642_;
					gint _tmp643_;
					gint _tmp644_;
					ValaList* _tmp645_;
					gpointer _tmp646_;
					_tmp636_ = ea;
					_tmp637_ = vala_element_access_get_container (_tmp636_);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_expression_get_value_type (_tmp638_);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_data_type_get_type_arguments (_tmp640_);
					args = _tmp641_;
					_tmp642_ = args;
					_tmp643_ = vala_collection_get_size ((ValaCollection*) _tmp642_);
					_tmp644_ = _tmp643_;
					_vala_assert (_tmp644_ == 1, "args.size == 1");
					_tmp645_ = args;
					_tmp646_ = vala_list_get (_tmp645_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp646_;
					_vala_iterable_unref0 (args);
				}
				_tmp648_ = element_type;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp648_, VALA_TYPE_POINTER_TYPE)) {
					ValaDataType* _tmp649_;
					gboolean _tmp650_;
					gboolean _tmp651_;
					_tmp649_ = element_type;
					_tmp650_ = vala_data_type_get_value_owned (_tmp649_);
					_tmp651_ = _tmp650_;
					_tmp647_ = !_tmp651_;
				} else {
					_tmp647_ = FALSE;
				}
				if (_tmp647_) {
					ValaSourceReference* _tmp652_;
					ValaSourceReference* _tmp653_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp652_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp653_ = _tmp652_;
					vala_report_error (_tmp653_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					_vala_code_node_unref0 (ea);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp654_;
				ValaExpression* _tmp655_;
				ValaDataType* _tmp656_;
				ValaDataType* _tmp657_;
				gboolean _tmp658_;
				gboolean _tmp659_;
				_tmp654_ = vala_assignment_get_left (self);
				_tmp655_ = _tmp654_;
				_tmp656_ = vala_expression_get_value_type (_tmp655_);
				_tmp657_ = _tmp656_;
				_tmp658_ = vala_data_type_get_value_owned (_tmp657_);
				_tmp659_ = _tmp658_;
				if (_tmp659_) {
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp660_ = vala_assignment_get_left (self);
	_tmp661_ = _tmp660_;
	_tmp662_ = vala_expression_get_value_type (_tmp661_);
	_tmp663_ = _tmp662_;
	if (_tmp663_ != NULL) {
		ValaExpression* _tmp664_;
		ValaExpression* _tmp665_;
		ValaDataType* _tmp666_;
		ValaDataType* _tmp667_;
		ValaDataType* _tmp668_;
		ValaDataType* _tmp669_;
		ValaDataType* _tmp670_;
		ValaDataType* _tmp671_;
		_tmp664_ = vala_assignment_get_left (self);
		_tmp665_ = _tmp664_;
		_tmp666_ = vala_expression_get_value_type (_tmp665_);
		_tmp667_ = _tmp666_;
		_tmp668_ = vala_data_type_copy (_tmp667_);
		_tmp669_ = _tmp668_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp669_);
		_vala_code_node_unref0 (_tmp669_);
		_tmp670_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp671_ = _tmp670_;
		vala_data_type_set_value_owned (_tmp671_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp672_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp673_ = _tmp672_;
	result = !_tmp673_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp133_;
	ValaExpression* _tmp134_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_ = FALSE;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			_tmp39_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp47_;
			_tmp47_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp48_ = FALSE;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp49_ = vala_assignment_get_left (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_expression_get_value_type (_tmp50_);
			_tmp52_ = _tmp51_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp52_)) {
				ValaExpression* _tmp53_;
				ValaExpression* _tmp54_;
				_tmp53_ = vala_assignment_get_right (self);
				_tmp54_ = _tmp53_;
				_tmp48_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp48_ = FALSE;
			}
			_tmp37_ = !_tmp48_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp55_ = FALSE;
			ValaExpression* _tmp62_;
			ValaExpression* _tmp63_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp64_;
			ValaExpression* _tmp65_;
			ValaTargetValue* _tmp66_;
			ValaTargetValue* _tmp67_;
			ValaTargetValue* _tmp68_;
			ValaLocalVariable* _tmp69_;
			ValaCodeNode* _tmp94_;
			ValaCodeNode* _tmp95_;
			if (instance) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp55_ = _tmp58_ != NULL;
			} else {
				_tmp55_ = FALSE;
			}
			if (_tmp55_) {
				ValaMemberAccess* _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				_tmp59_ = ma;
				_tmp60_ = vala_member_access_get_inner (_tmp59_);
				_tmp61_ = _tmp60_;
				vala_code_node_emit ((ValaCodeNode*) _tmp61_, codegen);
			}
			_tmp62_ = vala_assignment_get_right (self);
			_tmp63_ = _tmp62_;
			vala_code_node_emit ((ValaCodeNode*) _tmp63_, codegen);
			_tmp64_ = vala_assignment_get_right (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_expression_get_target_value (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _vala_target_value_ref0 (_tmp67_);
			new_value = _tmp68_;
			_tmp69_ = local;
			if (_tmp69_ != NULL) {
				ValaLocalVariable* _tmp70_;
				ValaTargetValue* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				_tmp70_ = local;
				_tmp71_ = new_value;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp73_ = _tmp72_;
				vala_code_generator_store_local (codegen, _tmp70_, _tmp71_, FALSE, _tmp73_);
			} else {
				ValaParameter* _tmp74_;
				_tmp74_ = param;
				if (_tmp74_ != NULL) {
					ValaParameter* _tmp75_;
					ValaTargetValue* _tmp76_;
					ValaSourceReference* _tmp77_;
					ValaSourceReference* _tmp78_;
					_tmp75_ = param;
					_tmp76_ = new_value;
					_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp78_ = _tmp77_;
					vala_code_generator_store_parameter (codegen, _tmp75_, _tmp76_, FALSE, _tmp78_);
				} else {
					ValaField* _tmp79_;
					_tmp79_ = field;
					if (_tmp79_ != NULL) {
						ValaTargetValue* _tmp80_ = NULL;
						gboolean _tmp81_ = FALSE;
						ValaField* _tmp90_;
						ValaTargetValue* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceReference* _tmp93_;
						if (instance) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp81_ = _tmp84_ != NULL;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaTargetValue* _tmp88_;
							ValaTargetValue* _tmp89_;
							_tmp85_ = ma;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_target_value (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp80_ = _tmp89_;
						} else {
							_tmp80_ = NULL;
						}
						_tmp90_ = field;
						_tmp91_ = new_value;
						_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp93_ = _tmp92_;
						vala_code_generator_store_field (codegen, _tmp90_, _tmp80_, _tmp91_, _tmp93_);
					}
				}
			}
			_tmp94_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp95_ = _tmp94_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp96_;
				_tmp96_ = local;
				if (_tmp96_ != NULL) {
					ValaLocalVariable* _tmp97_;
					ValaTargetValue* _tmp98_;
					ValaTargetValue* _tmp99_;
					_tmp97_ = local;
					_tmp98_ = vala_code_generator_load_local (codegen, _tmp97_);
					_tmp99_ = _tmp98_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp99_);
					_vala_target_value_unref0 (_tmp99_);
				} else {
					ValaParameter* _tmp100_;
					_tmp100_ = param;
					if (_tmp100_ != NULL) {
						ValaParameter* _tmp101_;
						ValaTargetValue* _tmp102_;
						ValaTargetValue* _tmp103_;
						_tmp101_ = param;
						_tmp102_ = vala_code_generator_load_parameter (codegen, _tmp101_);
						_tmp103_ = _tmp102_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp103_);
						_vala_target_value_unref0 (_tmp103_);
					} else {
						ValaField* _tmp104_;
						_tmp104_ = field;
						if (_tmp104_ != NULL) {
							ValaTargetValue* _tmp105_ = NULL;
							gboolean _tmp106_ = FALSE;
							ValaField* _tmp115_;
							ValaTargetValue* _tmp116_;
							ValaTargetValue* _tmp117_;
							if (instance) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp106_ = _tmp109_ != NULL;
							} else {
								_tmp106_ = FALSE;
							}
							if (_tmp106_) {
								ValaMemberAccess* _tmp110_;
								ValaExpression* _tmp111_;
								ValaExpression* _tmp112_;
								ValaTargetValue* _tmp113_;
								ValaTargetValue* _tmp114_;
								_tmp110_ = ma;
								_tmp111_ = vala_member_access_get_inner (_tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = vala_expression_get_target_value (_tmp112_);
								_tmp114_ = _tmp113_;
								_tmp105_ = _tmp114_;
							} else {
								_tmp105_ = NULL;
							}
							_tmp115_ = field;
							_tmp116_ = vala_code_generator_load_field (codegen, _tmp115_, _tmp105_);
							_tmp117_ = _tmp116_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp117_);
							_vala_target_value_unref0 (_tmp117_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp120_;
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			_tmp120_ = ma;
			_tmp121_ = vala_member_access_get_inner (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp119_ = _tmp122_ != NULL;
		} else {
			_tmp119_ = FALSE;
		}
		if (_tmp119_) {
			ValaProperty* _tmp123_;
			_tmp123_ = property;
			_tmp118_ = _tmp123_ != NULL;
		} else {
			_tmp118_ = FALSE;
		}
		if (_tmp118_) {
			ValaMemberAccess* _tmp124_;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			_tmp124_ = ma;
			_tmp125_ = vala_member_access_get_inner (_tmp124_);
			_tmp126_ = _tmp125_;
			vala_code_node_emit ((ValaCodeNode*) _tmp126_, codegen);
		} else {
			ValaProperty* _tmp127_;
			_tmp127_ = property;
			if (_tmp127_ == NULL) {
				ValaMemberAccess* _tmp128_;
				_tmp128_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp128_, codegen);
			}
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp129_;
		_tmp129_ = ea;
		if (_tmp129_ != NULL) {
			ValaElementAccess* _tmp130_;
			_tmp130_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp130_, codegen);
		} else {
			ValaPointerIndirection* _tmp131_;
			_tmp131_ = pi;
			if (_tmp131_ != NULL) {
				ValaPointerIndirection* _tmp132_;
				_tmp132_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp132_, codegen);
			}
		}
	}
	_tmp133_ = vala_assignment_get_right (self);
	_tmp134_ = _tmp133_;
	vala_code_node_emit ((ValaCodeNode*) _tmp134_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* _tmp13_;
	ValaLocalVariable* _tmp14_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_assignment_get_left (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp12_) : NULL);
	param = _tmp13_;
	_tmp14_ = local;
	if (_tmp14_ != NULL) {
		ValaLocalVariable* _tmp15_;
		_tmp15_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp15_);
	} else {
		gboolean _tmp16_ = FALSE;
		ValaParameter* _tmp17_;
		_tmp17_ = param;
		if (_tmp17_ != NULL) {
			ValaParameter* _tmp18_;
			ValaParameterDirection _tmp19_;
			ValaParameterDirection _tmp20_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_direction (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaParameter* _tmp21_;
			_tmp21_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp21_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
	} else {
		ValaElementAccess* _tmp14_;
		_tmp14_ = ea;
		if (_tmp14_ != NULL) {
			ValaElementAccess* _tmp15_;
			_tmp15_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
		}
	}
	_tmp16_ = vala_assignment_get_right (self);
	_tmp17_ = _tmp16_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

