/* gcomment.c generated by valac, the Vala compiler
 * generated from gcomment.vala, do not modify */

/* gcomment.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <valagee.h>
#include <valadoc.h>

#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
typedef struct _GtkdocHeaderPrivate GtkdocHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocParamSpecHeader GtkdocParamSpecHeader;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;
typedef struct _GtkdocGCommentPrivate GtkdocGCommentPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocParamSpecGComment GtkdocParamSpecGComment;

struct _GtkdocHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar** annotations;
	gint annotations_length1;
	gchar* value;
	gdouble pos;
	gboolean block;
	GtkdocHeaderPrivate * priv;
};

struct _GtkdocHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocHeader *self);
};

struct _GtkdocParamSpecHeader {
	GParamSpec parent_instance;
};

struct _GtkdocGComment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* symbol;
	gchar** symbol_annotations;
	gint symbol_annotations_length1;
	ValaList* headers;
	gboolean short_description;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	gchar** returns_annotations;
	gint returns_annotations_length1;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	gboolean is_section;
	GtkdocGCommentPrivate * priv;
};

struct _GtkdocGCommentClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGComment *self);
};

struct _GtkdocParamSpecGComment {
	GParamSpec parent_instance;
};

static gpointer gtkdoc_header_parent_class = NULL;
static gpointer gtkdoc_gcomment_parent_class = NULL;

gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
gint gtkdoc_header_cmp (GtkdocHeader* self,
                        GtkdocHeader* header);
static void gtkdoc_header_finalize (GtkdocHeader * obj);
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
gchar* gtkdoc_gcomment_to_string (GtkdocGComment* self);
gchar* gtkdoc_commentize (const gchar* comment);
gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
GtkdocGComment* gtkdoc_gcomment_new (void);
GtkdocGComment* gtkdoc_gcomment_construct (GType object_type);
static void gtkdoc_gcomment_finalize (GtkdocGComment * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

GtkdocHeader*
gtkdoc_header_construct (GType object_type,
                         const gchar* name,
                         const gchar* value,
                         gdouble pos,
                         gboolean block)
{
	GtkdocHeader* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocHeader*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp1_;
	self->pos = pos;
	self->block = block;
	return self;
}

GtkdocHeader*
gtkdoc_header_new (const gchar* name,
                   const gchar* value,
                   gdouble pos,
                   gboolean block)
{
	return gtkdoc_header_construct (GTKDOC_TYPE_HEADER, name, value, pos, block);
}

gint
gtkdoc_header_cmp (GtkdocHeader* self,
                   GtkdocHeader* header)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (header != NULL, 0);
	if (self->pos > header->pos) {
		result = 1;
		return result;
	} else {
		if (self->pos < header->pos) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}

static void
gtkdoc_value_header_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_header_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_header_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_header_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_header_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_header_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_header_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocHeader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_header_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_header_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	GtkdocHeader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_header_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_header (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	GtkdocParamSpecHeader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_HEADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_header (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_header (GValue* value,
                         gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_header_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}

void
gtkdoc_value_take_header (GValue* value,
                          gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}

static void
gtkdoc_header_class_init (GtkdocHeaderClass * klass,
                          gpointer klass_data)
{
	gtkdoc_header_parent_class = g_type_class_peek_parent (klass);
	((GtkdocHeaderClass *) klass)->finalize = gtkdoc_header_finalize;
}

static void
gtkdoc_header_instance_init (GtkdocHeader * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
gtkdoc_header_finalize (GtkdocHeader * obj)
{
	GtkdocHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_HEADER, GtkdocHeader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->value);
}

GType
gtkdoc_header_get_type (void)
{
	static volatile gsize gtkdoc_header_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_header_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_header_init, gtkdoc_value_header_free_value, gtkdoc_value_header_copy_value, gtkdoc_value_header_peek_pointer, "p", gtkdoc_value_header_collect_value, "p", gtkdoc_value_header_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocHeader), 0, (GInstanceInitFunc) gtkdoc_header_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_header_type_id;
		gtkdoc_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_header_type_id__volatile, gtkdoc_header_type_id);
	}
	return gtkdoc_header_type_id__volatile;
}

gpointer
gtkdoc_header_ref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_header_unref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_HEADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len = len + _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len = len + (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

gchar*
gtkdoc_gcomment_to_string (GtkdocGComment* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp13_ = FALSE;
	ValaList* _tmp19_;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp55_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gboolean _tmp65_ = FALSE;
	const gchar* _tmp66_;
	ValaList* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	GString* _tmp103_;
	GString* _tmp104_;
	const gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (self->is_section) {
		_tmp1_ = "SECTION:%s";
	} else {
		_tmp1_ = "%s:";
	}
	_tmp2_ = builder;
	_tmp3_ = self->symbol;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp2_, "/**\n * %s", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp7_ = self->symbol_annotations;
	_tmp7__length1 = self->symbol_annotations_length1;
	if (_tmp7_ != NULL) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = self->symbol_annotations;
		_tmp8__length1 = self->symbol_annotations_length1;
		_tmp6_ = _tmp8__length1 > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = self->symbol_annotations;
		_tmp9__length1 = self->symbol_annotations_length1;
		{
			gchar** annotation_collection = NULL;
			gint annotation_collection_length1 = 0;
			gint _annotation_collection_size_ = 0;
			gint annotation_it = 0;
			annotation_collection = _tmp9_;
			annotation_collection_length1 = _tmp9__length1;
			for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
				gchar* _tmp10_;
				gchar* annotation = NULL;
				_tmp10_ = g_strdup (annotation_collection[annotation_it]);
				annotation = _tmp10_;
				{
					GString* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = builder;
					_tmp12_ = annotation;
					g_string_append_printf (_tmp11_, " (%s)", _tmp12_);
					_g_free0 (annotation);
				}
			}
		}
	}
	if (self->short_description) {
		const gchar* _tmp14_;
		_tmp14_ = self->brief_comment;
		_tmp13_ = _tmp14_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GString* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = builder;
		_tmp16_ = self->brief_comment;
		_tmp17_ = gtkdoc_commentize (_tmp16_);
		_tmp18_ = _tmp17_;
		g_string_append_printf (_tmp15_, "\n * @short_description: %s", _tmp18_);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = self->headers;
	vala_list_sort (_tmp19_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _header_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _header_index = 0;
		_tmp20_ = self->headers;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_header_list = _tmp21_;
		_tmp22_ = _header_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_header_size = _tmp24_;
		_header_index = -1;
		while (TRUE) {
			GtkdocHeader* header = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			GString* _tmp27_;
			GtkdocHeader* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_ = FALSE;
			GtkdocHeader* _tmp31_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			GtkdocHeader* _tmp41_;
			const gchar* _tmp42_;
			_header_index = _header_index + 1;
			if (!(_header_index < _header_size)) {
				break;
			}
			_tmp25_ = _header_list;
			_tmp26_ = vala_list_get (_tmp25_, _header_index);
			header = (GtkdocHeader*) _tmp26_;
			_tmp27_ = builder;
			_tmp28_ = header;
			_tmp29_ = _tmp28_->name;
			g_string_append_printf (_tmp27_, "\n * @%s:", _tmp29_);
			_tmp31_ = header;
			_tmp32_ = _tmp31_->annotations;
			_tmp32__length1 = _tmp31_->annotations_length1;
			if (_tmp32_ != NULL) {
				GtkdocHeader* _tmp33_;
				gchar** _tmp34_;
				gint _tmp34__length1;
				_tmp33_ = header;
				_tmp34_ = _tmp33_->annotations;
				_tmp34__length1 = _tmp33_->annotations_length1;
				_tmp30_ = _tmp34__length1 > 0;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				GtkdocHeader* _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				GString* _tmp40_;
				_tmp35_ = header;
				_tmp36_ = _tmp35_->annotations;
				_tmp36__length1 = _tmp35_->annotations_length1;
				{
					gchar** annotation_collection = NULL;
					gint annotation_collection_length1 = 0;
					gint _annotation_collection_size_ = 0;
					gint annotation_it = 0;
					annotation_collection = _tmp36_;
					annotation_collection_length1 = _tmp36__length1;
					for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
						gchar* _tmp37_;
						gchar* annotation = NULL;
						_tmp37_ = g_strdup (annotation_collection[annotation_it]);
						annotation = _tmp37_;
						{
							GString* _tmp38_;
							const gchar* _tmp39_;
							_tmp38_ = builder;
							_tmp39_ = annotation;
							g_string_append_printf (_tmp38_, " (%s)", _tmp39_);
							_g_free0 (annotation);
						}
					}
				}
				_tmp40_ = builder;
				g_string_append_c (_tmp40_, ':');
			}
			_tmp41_ = header;
			_tmp42_ = _tmp41_->value;
			if (_tmp42_ != NULL) {
				GString* _tmp43_;
				GString* _tmp44_;
				GtkdocHeader* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp43_ = builder;
				g_string_append_c (_tmp43_, ' ');
				_tmp44_ = builder;
				_tmp45_ = header;
				_tmp46_ = _tmp45_->value;
				_tmp47_ = gtkdoc_commentize (_tmp46_);
				_tmp48_ = _tmp47_;
				g_string_append (_tmp44_, _tmp48_);
				_g_free0 (_tmp48_);
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	if (!self->short_description) {
		const gchar* _tmp50_;
		_tmp50_ = self->brief_comment;
		_tmp49_ = _tmp50_ != NULL;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		GString* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp51_ = builder;
		_tmp52_ = self->brief_comment;
		_tmp53_ = gtkdoc_commentize (_tmp52_);
		_tmp54_ = _tmp53_;
		g_string_append_printf (_tmp51_, "\n * \n * %s", _tmp54_);
		_g_free0 (_tmp54_);
	}
	_tmp55_ = self->long_comment;
	if (_tmp55_ != NULL) {
		GString* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp56_ = builder;
		_tmp57_ = self->long_comment;
		_tmp58_ = gtkdoc_commentize (_tmp57_);
		_tmp59_ = _tmp58_;
		g_string_append_printf (_tmp56_, "\n * \n * %s", _tmp59_);
		_g_free0 (_tmp59_);
	}
	_tmp60_ = self->see_also;
	_tmp60__length1 = self->see_also_length1;
	if (_tmp60__length1 > 0) {
		GString* _tmp61_;
		gchar** _tmp62_;
		gint _tmp62__length1;
		gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp61_ = builder;
		_tmp62_ = self->see_also;
		_tmp62__length1 = self->see_also_length1;
		_tmp63_ = _vala_g_strjoinv (", ", _tmp62_, (gint) _tmp62__length1);
		_tmp64_ = _tmp63_;
		g_string_append_printf (_tmp61_, "\n * \n * <emphasis>See also</emphasis>: %s", _tmp64_);
		_g_free0 (_tmp64_);
	}
	_tmp66_ = self->returns;
	if (_tmp66_ != NULL) {
		_tmp65_ = TRUE;
	} else {
		gchar** _tmp67_;
		gint _tmp67__length1;
		_tmp67_ = self->returns_annotations;
		_tmp67__length1 = self->returns_annotations_length1;
		_tmp65_ = _tmp67__length1 > 0;
	}
	if (_tmp65_) {
		GString* _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		GString* _tmp76_;
		const gchar* _tmp77_;
		_tmp68_ = builder;
		g_string_append (_tmp68_, "\n * \n * Returns:");
		_tmp69_ = self->returns_annotations;
		_tmp69__length1 = self->returns_annotations_length1;
		if (_tmp69_ != NULL) {
			gchar** _tmp70_;
			gint _tmp70__length1;
			gchar** _tmp74_;
			gint _tmp74__length1;
			_tmp70_ = self->returns_annotations;
			_tmp70__length1 = self->returns_annotations_length1;
			{
				gchar** annotation_collection = NULL;
				gint annotation_collection_length1 = 0;
				gint _annotation_collection_size_ = 0;
				gint annotation_it = 0;
				annotation_collection = _tmp70_;
				annotation_collection_length1 = _tmp70__length1;
				for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
					gchar* _tmp71_;
					gchar* annotation = NULL;
					_tmp71_ = g_strdup (annotation_collection[annotation_it]);
					annotation = _tmp71_;
					{
						GString* _tmp72_;
						const gchar* _tmp73_;
						_tmp72_ = builder;
						_tmp73_ = annotation;
						g_string_append_printf (_tmp72_, " (%s)", _tmp73_);
						_g_free0 (annotation);
					}
				}
			}
			_tmp74_ = self->returns_annotations;
			_tmp74__length1 = self->returns_annotations_length1;
			if (_tmp74__length1 > 0) {
				GString* _tmp75_;
				_tmp75_ = builder;
				g_string_append_c (_tmp75_, ':');
			}
		}
		_tmp76_ = builder;
		g_string_append_c (_tmp76_, ' ');
		_tmp77_ = self->returns;
		if (_tmp77_ != NULL) {
			GString* _tmp78_;
			const gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			_tmp78_ = builder;
			_tmp79_ = self->returns;
			_tmp80_ = gtkdoc_commentize (_tmp79_);
			_tmp81_ = _tmp80_;
			g_string_append (_tmp78_, _tmp81_);
			_g_free0 (_tmp81_);
		}
	}
	_tmp82_ = self->versioning;
	_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
	_tmp84_ = _tmp83_;
	if (_tmp84_ > 0) {
		GString* _tmp85_;
		_tmp85_ = builder;
		g_string_append (_tmp85_, "\n *");
		{
			ValaList* _version_list = NULL;
			ValaList* _tmp86_;
			ValaList* _tmp87_;
			gint _version_size = 0;
			ValaList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			gint _version_index = 0;
			_tmp86_ = self->versioning;
			_tmp87_ = _vala_iterable_ref0 (_tmp86_);
			_version_list = _tmp87_;
			_tmp88_ = _version_list;
			_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			_version_size = _tmp90_;
			_version_index = -1;
			while (TRUE) {
				GtkdocHeader* version = NULL;
				ValaList* _tmp91_;
				gpointer _tmp92_;
				GString* _tmp93_;
				GtkdocHeader* _tmp94_;
				const gchar* _tmp95_;
				GtkdocHeader* _tmp96_;
				const gchar* _tmp97_;
				_version_index = _version_index + 1;
				if (!(_version_index < _version_size)) {
					break;
				}
				_tmp91_ = _version_list;
				_tmp92_ = vala_list_get (_tmp91_, _version_index);
				version = (GtkdocHeader*) _tmp92_;
				_tmp93_ = builder;
				_tmp94_ = version;
				_tmp95_ = _tmp94_->name;
				g_string_append_printf (_tmp93_, "\n * %s:", _tmp95_);
				_tmp96_ = version;
				_tmp97_ = _tmp96_->value;
				if (_tmp97_ != NULL) {
					GString* _tmp98_;
					GtkdocHeader* _tmp99_;
					const gchar* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					_tmp98_ = builder;
					_tmp99_ = version;
					_tmp100_ = _tmp99_->value;
					_tmp101_ = gtkdoc_commentize (_tmp100_);
					_tmp102_ = _tmp101_;
					g_string_append_printf (_tmp98_, " %s", _tmp102_);
					_g_free0 (_tmp102_);
				}
				_gtkdoc_header_unref0 (version);
			}
			_vala_iterable_unref0 (_version_list);
		}
	}
	_tmp103_ = builder;
	g_string_append (_tmp103_, "\n */");
	_tmp104_ = builder;
	_tmp105_ = _tmp104_->str;
	_tmp106_ = g_strdup (_tmp105_);
	result = _tmp106_;
	_g_string_free0 (builder);
	return result;
}

gchar*
gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                            ValadocErrorReporter* reporter)
{
	gchar* deprecated = NULL;
	gchar* since = NULL;
	GString* builder = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp24_;
	const gchar* _tmp27_;
	ValaList* _tmp30_;
	gboolean _tmp31_ = FALSE;
	ValaList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	const gchar* _tmp53_;
	GString* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	deprecated = NULL;
	since = NULL;
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _header_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _header_index = 0;
		_tmp0_ = self->versioning;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_header_list = _tmp1_;
		_tmp2_ = _header_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_header_size = _tmp4_;
		_header_index = -1;
		while (TRUE) {
			GtkdocHeader* header = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			GtkdocHeader* _tmp7_;
			const gchar* _tmp8_;
			_header_index = _header_index + 1;
			if (!(_header_index < _header_size)) {
				break;
			}
			_tmp5_ = _header_list;
			_tmp6_ = vala_list_get (_tmp5_, _header_index);
			header = (GtkdocHeader*) _tmp6_;
			_tmp7_ = header;
			_tmp8_ = _tmp7_->name;
			if (g_strcmp0 (_tmp8_, "Deprecated") == 0) {
				GtkdocHeader* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp9_ = header;
				_tmp10_ = _tmp9_->value;
				_tmp11_ = g_strdup (_tmp10_);
				_g_free0 (deprecated);
				deprecated = _tmp11_;
			} else {
				GtkdocHeader* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = header;
				_tmp13_ = _tmp12_->name;
				if (g_strcmp0 (_tmp13_, "Since") == 0) {
					GtkdocHeader* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = header;
					_tmp15_ = _tmp14_->value;
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (since);
					since = _tmp16_;
				} else {
					GtkdocHeader* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = header;
					_tmp18_ = _tmp17_->name;
					valadoc_error_reporter_simple_warning (reporter, "GtkDoc", "Unknown versioning tag '%s'", _tmp18_);
				}
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp19_ = g_string_new ("");
	builder = _tmp19_;
	_tmp20_ = deprecated;
	if (_tmp20_ != NULL) {
		GString* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp21_ = builder;
		_tmp22_ = self->symbol;
		_tmp23_ = deprecated;
		g_string_append_printf (_tmp21_, "<warning><para><literal>%s</literal> is deprecated and should not be u" \
"sed in newly-written code. %s</para></warning>", _tmp22_, _tmp23_);
	}
	_tmp24_ = self->brief_comment;
	if (_tmp24_ != NULL) {
		GString* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = builder;
		_tmp26_ = self->brief_comment;
		g_string_append_printf (_tmp25_, "<para>%s</para>", _tmp26_);
	}
	_tmp27_ = self->long_comment;
	if (_tmp27_ != NULL) {
		GString* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = builder;
		_tmp29_ = self->long_comment;
		g_string_append (_tmp28_, _tmp29_);
	}
	_tmp30_ = self->headers;
	vala_list_sort (_tmp30_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	_tmp32_ = self->headers;
	_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ > 0) {
		_tmp31_ = TRUE;
	} else {
		const gchar* _tmp35_;
		_tmp35_ = self->returns;
		_tmp31_ = _tmp35_ != NULL;
	}
	if (_tmp31_) {
		GString* _tmp36_;
		const gchar* _tmp49_;
		GString* _tmp52_;
		_tmp36_ = builder;
		g_string_append (_tmp36_, "<variablelist role=\"params\">");
		{
			ValaList* _header_list = NULL;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			gint _header_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _header_index = 0;
			_tmp37_ = self->headers;
			_tmp38_ = _vala_iterable_ref0 (_tmp37_);
			_header_list = _tmp38_;
			_tmp39_ = _header_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_header_size = _tmp41_;
			_header_index = -1;
			while (TRUE) {
				GtkdocHeader* header = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				GString* _tmp44_;
				GtkdocHeader* _tmp45_;
				const gchar* _tmp46_;
				GtkdocHeader* _tmp47_;
				const gchar* _tmp48_;
				_header_index = _header_index + 1;
				if (!(_header_index < _header_size)) {
					break;
				}
				_tmp42_ = _header_list;
				_tmp43_ = vala_list_get (_tmp42_, _header_index);
				header = (GtkdocHeader*) _tmp43_;
				_tmp44_ = builder;
				_tmp45_ = header;
				_tmp46_ = _tmp45_->name;
				_tmp47_ = header;
				_tmp48_ = _tmp47_->value;
				g_string_append_printf (_tmp44_, "<varlistentry><term><parameter>%s</parameter>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp46_, _tmp48_);
				_gtkdoc_header_unref0 (header);
			}
			_vala_iterable_unref0 (_header_list);
		}
		_tmp49_ = self->returns;
		if (_tmp49_ != NULL) {
			GString* _tmp50_;
			const gchar* _tmp51_;
			_tmp50_ = builder;
			_tmp51_ = self->returns;
			g_string_append_printf (_tmp50_, "<varlistentry><term><emphasis>Returns</emphasis>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp51_);
		}
		_tmp52_ = builder;
		g_string_append (_tmp52_, "</variablelist>");
	}
	_tmp53_ = since;
	if (_tmp53_ != NULL) {
		GString* _tmp54_;
		const gchar* _tmp55_;
		_tmp54_ = builder;
		_tmp55_ = since;
		g_string_append_printf (_tmp54_, "<para role=\"since\">Since %s</para>", _tmp55_);
	}
	_tmp56_ = builder;
	_tmp57_ = _tmp56_->str;
	_tmp58_ = g_strdup (_tmp57_);
	result = _tmp58_;
	_g_string_free0 (builder);
	_g_free0 (since);
	_g_free0 (deprecated);
	return result;
}

GtkdocGComment*
gtkdoc_gcomment_construct (GType object_type)
{
	GtkdocGComment* self = NULL;
	self = (GtkdocGComment*) g_type_create_instance (object_type);
	return self;
}

GtkdocGComment*
gtkdoc_gcomment_new (void)
{
	return gtkdoc_gcomment_construct (GTKDOC_TYPE_GCOMMENT);
}

static void
gtkdoc_value_gcomment_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_gcomment_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_gcomment_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_gcomment_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_gcomment_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_gcomment_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_gcomment_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocGComment * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_gcomment_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_gcomment_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	GtkdocGComment ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_gcomment_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_gcomment (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	GtkdocParamSpecGComment* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_GCOMMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_gcomment (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_gcomment (GValue* value,
                           gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_gcomment_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}

void
gtkdoc_value_take_gcomment (GValue* value,
                            gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}

static void
gtkdoc_gcomment_class_init (GtkdocGCommentClass * klass,
                            gpointer klass_data)
{
	gtkdoc_gcomment_parent_class = g_type_class_peek_parent (klass);
	((GtkdocGCommentClass *) klass)->finalize = gtkdoc_gcomment_finalize;
}

static void
gtkdoc_gcomment_instance_init (GtkdocGComment * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->headers = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	self->ref_count = 1;
}

static void
gtkdoc_gcomment_finalize (GtkdocGComment * obj)
{
	GtkdocGComment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_GCOMMENT, GtkdocGComment);
	g_signal_handlers_destroy (self);
	_g_free0 (self->symbol);
	self->symbol_annotations = (_vala_array_free (self->symbol_annotations, self->symbol_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->headers);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	self->returns_annotations = (_vala_array_free (self->returns_annotations, self->returns_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
}

GType
gtkdoc_gcomment_get_type (void)
{
	static volatile gsize gtkdoc_gcomment_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_gcomment_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_gcomment_init, gtkdoc_value_gcomment_free_value, gtkdoc_value_gcomment_copy_value, gtkdoc_value_gcomment_peek_pointer, "p", gtkdoc_value_gcomment_collect_value, "p", gtkdoc_value_gcomment_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocGCommentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_gcomment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGComment), 0, (GInstanceInitFunc) gtkdoc_gcomment_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_gcomment_type_id;
		gtkdoc_gcomment_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocGComment", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gtkdoc_gcomment_type_id__volatile, gtkdoc_gcomment_type_id);
	}
	return gtkdoc_gcomment_type_id__volatile;
}

gpointer
gtkdoc_gcomment_ref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_gcomment_unref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_GCOMMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

