/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp89_;
	ValaDataType* _tmp90_;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp92_ = FALSE;
	gboolean _tmp93_ = FALSE;
	ValaArrayType* _tmp94_;
	gboolean _tmp106_ = FALSE;
	ValaExpression* _tmp107_;
	ValaExpression* _tmp108_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSymbol* _tmp226_;
	ValaSymbol* _tmp227_;
	ValaScope* _tmp228_;
	ValaScope* _tmp229_;
	const gchar* _tmp230_;
	const gchar* _tmp231_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp232_;
	ValaSemanticAnalyzer* _tmp233_;
	ValaSymbol* _tmp234_;
	ValaSymbol* _tmp235_;
	ValaBlock* _tmp236_;
	ValaBlock* _tmp237_;
	gboolean _tmp239_;
	gboolean _tmp240_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_experimental_non_null (context);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_REFERENCE_TYPE (_tmp7_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp9_) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp17_ = _tmp16_;
				vala_data_type_set_nullable (_tmp17_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp21_ = _tmp20_;
		if (VALA_IS_VOID_TYPE (_tmp21_)) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp26_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp31_ = _tmp30_;
		vala_expression_set_target_type (_tmp29_, _tmp31_);
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		if (VALA_IS_INITIALIZER_LIST (_tmp33_)) {
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp34_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp37_ = _tmp36_;
			initializer_size = _tmp37_;
			is_initializer_list = TRUE;
		}
		_tmp38_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp39_ = _tmp38_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp39_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == NULL) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		gboolean _tmp52_ = FALSE;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		ValaDataType* _tmp82_;
		ValaExpression* _tmp83_;
		ValaExpression* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		ValaDataType* _tmp87_;
		ValaDataType* _tmp88_;
		_tmp42_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		if (_tmp43_ == NULL) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp45_ = _tmp44_;
			vala_report_error (_tmp45_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			ValaSourceReference* _tmp50_;
			ValaSourceReference* _tmp51_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp51_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_expression_get_value_type (_tmp54_);
		_tmp56_ = _tmp55_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp56_)) {
			_tmp52_ = TRUE;
		} else {
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			_tmp57_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_expression_get_value_type (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp52_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp60_);
		}
		if (_tmp52_) {
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaSourceReference* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_symbol_get_full_name (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp70_);
			_tmp72_ = _tmp71_;
			vala_report_error (_tmp64_, _tmp72_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			result = FALSE;
			return result;
		}
		_tmp73_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_expression_get_value_type (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_data_type_copy (_tmp76_);
		_tmp78_ = _tmp77_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp78_);
		_vala_code_node_unref0 (_tmp78_);
		_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp80_ = _tmp79_;
		vala_data_type_set_value_owned (_tmp80_, TRUE);
		_tmp81_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		vala_data_type_set_floating_reference (_tmp82_, FALSE);
		_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp86_ = _tmp85_;
		vala_expression_set_target_type (_tmp84_, _tmp86_);
		_tmp87_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp88_ = _tmp87_;
		vala_code_node_check ((ValaCodeNode*) _tmp88_, context);
	}
	_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp90_ = _tmp89_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp90_) ? ((ValaArrayType*) _tmp90_) : NULL;
	_tmp94_ = variable_array_type;
	if (_tmp94_ != NULL) {
		ValaArrayType* _tmp95_;
		gboolean _tmp96_;
		gboolean _tmp97_;
		_tmp95_ = variable_array_type;
		_tmp96_ = vala_array_type_get_fixed_length (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		_tmp98_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		_tmp92_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp99_);
	} else {
		_tmp92_ = FALSE;
	}
	if (_tmp92_) {
		ValaExpression* _tmp100_;
		ValaExpression* _tmp101_;
		ValaInitializerList* _tmp102_;
		ValaInitializerList* _tmp103_;
		_tmp100_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp103_ = _tmp102_;
		_tmp91_ = _tmp103_ == NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaSourceReference* _tmp104_;
		ValaSourceReference* _tmp105_;
		_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp105_ = _tmp104_;
		vala_report_warning (_tmp105_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp107_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp108_ = _tmp107_;
	if (_tmp108_ != NULL) {
		ValaExpression* _tmp109_;
		ValaExpression* _tmp110_;
		gboolean _tmp111_;
		gboolean _tmp112_;
		_tmp109_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_code_node_get_error ((ValaCodeNode*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp106_ = !_tmp112_;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		ValaDataType* _tmp115_;
		ValaDataType* _tmp116_;
		ValaExpression* _tmp162_;
		ValaExpression* _tmp163_;
		ValaDataType* _tmp164_;
		ValaDataType* _tmp165_;
		ValaDataType* _tmp166_;
		ValaDataType* _tmp167_;
		gboolean _tmp182_ = FALSE;
		gboolean _tmp183_ = FALSE;
		gboolean _tmp184_ = FALSE;
		ValaArrayType* _tmp185_;
		gboolean _tmp199_ = FALSE;
		gboolean _tmp200_ = FALSE;
		ValaArrayType* _tmp201_;
		ValaExpression* _tmp211_;
		ValaExpression* _tmp212_;
		ValaDataType* _tmp213_;
		ValaDataType* _tmp214_;
		_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_expression_get_value_type (_tmp114_);
		_tmp116_ = _tmp115_;
		if (_tmp116_ == NULL) {
			gboolean _tmp117_ = FALSE;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			gboolean _tmp124_ = FALSE;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			ValaSymbol* _tmp127_;
			ValaSymbol* _tmp128_;
			_tmp118_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp119_ = _tmp118_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp119_)) {
				ValaExpression* _tmp120_;
				ValaExpression* _tmp121_;
				_tmp120_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp121_ = _tmp120_;
				_tmp117_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp121_);
			} else {
				_tmp117_ = FALSE;
			}
			if (_tmp117_) {
				ValaSourceReference* _tmp122_;
				ValaSourceReference* _tmp123_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp123_ = _tmp122_;
				vala_report_error (_tmp123_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_expression_get_symbol_reference (_tmp126_);
			_tmp128_ = _tmp127_;
			if (VALA_IS_METHOD (_tmp128_)) {
				ValaDataType* _tmp129_;
				ValaDataType* _tmp130_;
				_tmp129_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp130_ = _tmp129_;
				_tmp124_ = VALA_IS_DELEGATE_TYPE (_tmp130_);
			} else {
				_tmp124_ = FALSE;
			}
			if (_tmp124_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp131_;
				ValaExpression* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp134_;
				ValaMethod* _tmp135_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp136_;
				ValaDataType* _tmp137_;
				ValaDelegateType* _tmp138_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp139_;
				ValaDelegate* _tmp140_;
				ValaDelegate* _tmp141_;
				ValaDelegate* _tmp142_;
				ValaDelegate* _tmp143_;
				ValaMethod* _tmp144_;
				ValaDelegateType* _tmp145_;
				ValaExpression* _tmp156_;
				ValaExpression* _tmp157_;
				ValaDataType* _tmp158_;
				ValaDataType* _tmp159_;
				_tmp131_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_expression_get_symbol_reference (_tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp135_;
				_tmp136_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp137_ = _tmp136_;
				_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp138_;
				_tmp139_ = dt;
				_tmp140_ = vala_delegate_type_get_delegate_symbol (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = _vala_code_node_ref0 (_tmp141_);
				cb = _tmp142_;
				_tmp143_ = cb;
				_tmp144_ = m;
				_tmp145_ = dt;
				if (!vala_delegate_matches_method (_tmp143_, _tmp144_, (ValaDataType*) _tmp145_)) {
					ValaSourceReference* _tmp146_;
					ValaSourceReference* _tmp147_;
					ValaMethod* _tmp148_;
					gchar* _tmp149_;
					gchar* _tmp150_;
					ValaDelegate* _tmp151_;
					gchar* _tmp152_;
					gchar* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp147_ = _tmp146_;
					_tmp148_ = m;
					_tmp149_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp148_);
					_tmp150_ = _tmp149_;
					_tmp151_ = cb;
					_tmp152_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp151_);
					_tmp153_ = _tmp152_;
					_tmp154_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp150_, _tmp153_);
					_tmp155_ = _tmp154_;
					vala_report_error (_tmp147_, _tmp155_);
					_g_free0 (_tmp155_);
					_g_free0 (_tmp153_);
					_g_free0 (_tmp150_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp156_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp159_ = _tmp158_;
				vala_expression_set_value_type (_tmp157_, _tmp159_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp160_;
				ValaSourceReference* _tmp161_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp161_ = _tmp160_;
				vala_report_error (_tmp161_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp162_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_expression_get_value_type (_tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp167_ = _tmp166_;
		if (!vala_data_type_compatible (_tmp165_, _tmp167_)) {
			ValaSourceReference* _tmp168_;
			ValaSourceReference* _tmp169_;
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			ValaDataType* _tmp172_;
			ValaDataType* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			ValaDataType* _tmp176_;
			ValaDataType* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_expression_get_value_type (_tmp171_);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_code_node_to_string ((ValaCodeNode*) _tmp173_);
			_tmp175_ = _tmp174_;
			_tmp176_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_code_node_to_string ((ValaCodeNode*) _tmp177_);
			_tmp179_ = _tmp178_;
			_tmp180_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp175_, _tmp179_);
			_tmp181_ = _tmp180_;
			vala_report_error (_tmp169_, _tmp181_);
			_g_free0 (_tmp181_);
			_g_free0 (_tmp179_);
			_g_free0 (_tmp175_);
			result = FALSE;
			return result;
		}
		_tmp185_ = variable_array_type;
		if (_tmp185_ != NULL) {
			ValaArrayType* _tmp186_;
			gboolean _tmp187_;
			gboolean _tmp188_;
			_tmp186_ = variable_array_type;
			_tmp187_ = vala_array_type_get_inline_allocated (_tmp186_);
			_tmp188_ = _tmp187_;
			_tmp184_ = _tmp188_;
		} else {
			_tmp184_ = FALSE;
		}
		if (_tmp184_) {
			ValaArrayType* _tmp189_;
			gboolean _tmp190_;
			gboolean _tmp191_;
			_tmp189_ = variable_array_type;
			_tmp190_ = vala_array_type_get_fixed_length (_tmp189_);
			_tmp191_ = _tmp190_;
			_tmp183_ = !_tmp191_;
		} else {
			_tmp183_ = FALSE;
		}
		if (_tmp183_) {
			_tmp182_ = is_initializer_list;
		} else {
			_tmp182_ = FALSE;
		}
		if (_tmp182_) {
			ValaArrayType* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			ValaIntegerLiteral* _tmp195_;
			ValaIntegerLiteral* _tmp196_;
			ValaArrayType* _tmp197_;
			ValaArrayType* _tmp198_;
			_tmp192_ = variable_array_type;
			_tmp193_ = g_strdup_printf ("%i", initializer_size);
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_integer_literal_new (_tmp194_, NULL);
			_tmp196_ = _tmp195_;
			vala_array_type_set_length (_tmp192_, (ValaExpression*) _tmp196_);
			_vala_code_node_unref0 (_tmp196_);
			_g_free0 (_tmp194_);
			_tmp197_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp197_, TRUE);
			_tmp198_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp198_, FALSE);
		}
		_tmp201_ = variable_array_type;
		if (_tmp201_ != NULL) {
			ValaArrayType* _tmp202_;
			gboolean _tmp203_;
			gboolean _tmp204_;
			_tmp202_ = variable_array_type;
			_tmp203_ = vala_array_type_get_inline_allocated (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp200_ = _tmp204_;
		} else {
			_tmp200_ = FALSE;
		}
		if (_tmp200_) {
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			ValaDataType* _tmp207_;
			ValaDataType* _tmp208_;
			_tmp205_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_expression_get_value_type (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp199_ = VALA_IS_ARRAY_TYPE (_tmp208_) == FALSE;
		} else {
			_tmp199_ = FALSE;
		}
		if (_tmp199_) {
			ValaSourceReference* _tmp209_;
			ValaSourceReference* _tmp210_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp210_ = _tmp209_;
			vala_report_error (_tmp210_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp211_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_expression_get_value_type (_tmp212_);
		_tmp214_ = _tmp213_;
		if (vala_data_type_is_disposable (_tmp214_)) {
			gboolean _tmp215_ = FALSE;
			ValaDataType* _tmp216_;
			ValaDataType* _tmp217_;
			_tmp216_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp217_ = _tmp216_;
			if (!VALA_IS_POINTER_TYPE (_tmp217_)) {
				ValaDataType* _tmp218_;
				ValaDataType* _tmp219_;
				gboolean _tmp220_;
				gboolean _tmp221_;
				_tmp218_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_data_type_get_value_owned (_tmp219_);
				_tmp221_ = _tmp220_;
				_tmp215_ = !_tmp221_;
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValaSourceReference* _tmp222_;
				ValaSourceReference* _tmp223_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp223_ = _tmp222_;
				vala_report_error (_tmp223_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp224_ = vala_code_context_get_analyzer (context);
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_semantic_analyzer_get_current_symbol (_tmp225_);
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_symbol_get_scope (_tmp227_);
	_tmp229_ = _tmp228_;
	_tmp230_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp231_ = _tmp230_;
	vala_scope_add (_tmp229_, _tmp231_, (ValaSymbol*) self);
	_tmp232_ = vala_code_context_get_analyzer (context);
	_tmp233_ = _tmp232_;
	_tmp234_ = vala_semantic_analyzer_get_current_symbol (_tmp233_);
	_tmp235_ = _tmp234_;
	_tmp236_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp235_) ? ((ValaBlock*) _tmp235_) : NULL);
	block = _tmp236_;
	_tmp237_ = block;
	if (_tmp237_ != NULL) {
		ValaBlock* _tmp238_;
		_tmp238_ = block;
		vala_block_add_local_variable (_tmp238_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp239_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp240_ = _tmp239_;
	result = !_tmp240_;
	_vala_code_node_unref0 (block);
	return result;
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

