/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp8_;
	ValaBlock* _tmp33_;
	ValaBlock* _tmp34_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp8_ = ((ValaMethod*) self)->error_types;
	if (_tmp8_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			gint _error_type_size = 0;
			ValaList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _error_type_index = 0;
			_tmp9_ = ((ValaMethod*) self)->error_types;
			_tmp10_ = _vala_iterable_ref0 (_tmp9_);
			_error_type_list = _tmp10_;
			_tmp11_ = _error_type_list;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_error_type_size = _tmp13_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp14_;
				gpointer _tmp15_;
				ValaDataType* _tmp16_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp14_ = _error_type_list;
				_tmp15_ = vala_list_get (_tmp14_, _error_type_index);
				error_type = (ValaDataType*) _tmp15_;
				_tmp16_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _precondition_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _precondition_index = 0;
		_tmp17_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_precondition_list = _tmp18_;
		_tmp19_ = _precondition_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_precondition_size = _tmp21_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaExpression* _tmp24_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp22_ = _precondition_list;
			_tmp23_ = vala_list_get (_tmp22_, _precondition_index);
			precondition = (ValaExpression*) _tmp23_;
			_tmp24_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _postcondition_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _postcondition_index = 0;
		_tmp25_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_postcondition_list = _tmp26_;
		_tmp27_ = _postcondition_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_postcondition_size = _tmp29_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaExpression* _tmp32_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp30_ = _postcondition_list;
			_tmp31_ = vala_list_get (_tmp30_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp31_;
			_tmp32_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp33_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaBlock* _tmp35_;
		ValaBlock* _tmp36_;
		_tmp35_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSourceFile* _tmp24_;
	ValaSourceFile* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSemanticAnalyzer* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaSymbol* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	gint i = 0;
	ValaList* _tmp61_;
	ValaBlock* _tmp86_;
	ValaBlock* _tmp87_;
	ValaSemanticAnalyzer* _tmp211_;
	ValaSemanticAnalyzer* _tmp212_;
	ValaSourceFile* _tmp213_;
	ValaSemanticAnalyzer* _tmp214_;
	ValaSemanticAnalyzer* _tmp215_;
	ValaSymbol* _tmp216_;
	gboolean _tmp217_ = FALSE;
	gboolean _tmp218_ = FALSE;
	gboolean _tmp219_;
	gboolean _tmp220_;
	ValaBlock* _tmp231_;
	ValaBlock* _tmp232_;
	gboolean _tmp267_;
	gboolean _tmp268_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_semantic_analyzer_get_current_source_file (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _vala_source_file_ref0 (_tmp25_);
	old_source_file = _tmp26_;
	_tmp27_ = vala_code_context_get_analyzer (context);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_semantic_analyzer_get_current_symbol (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _vala_code_node_ref0 (_tmp30_);
	old_symbol = _tmp31_;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaSemanticAnalyzer* _tmp34_;
		ValaSemanticAnalyzer* _tmp35_;
		ValaSourceReference* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaSourceFile* _tmp39_;
		_tmp34_ = vala_code_context_get_analyzer (context);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_source_reference_get_file (_tmp37_);
		_tmp39_ = _tmp38_;
		vala_semantic_analyzer_set_current_source_file (_tmp35_, _tmp39_);
	}
	_tmp40_ = vala_code_context_get_analyzer (context);
	_tmp41_ = _tmp40_;
	vala_semantic_analyzer_set_current_symbol (_tmp41_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp42_;
		ValaList* _tmp43_;
		gint _param_size = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _param_index = 0;
		_tmp42_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp43_ = _vala_iterable_ref0 (_tmp42_);
		_param_list = _tmp43_;
		_tmp44_ = _param_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_param_size = _tmp46_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaParameter* _tmp49_;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_ = FALSE;
			gint _tmp60_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp47_ = _param_list;
			_tmp48_ = vala_list_get (_tmp47_, _param_index);
			param = (ValaParameter*) _tmp48_;
			_tmp49_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp49_, context);
			if (i == 0) {
				ValaParameter* _tmp52_;
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp52_ = param;
				_tmp53_ = vala_parameter_get_ellipsis (_tmp52_);
				_tmp54_ = _tmp53_;
				_tmp51_ = _tmp54_;
			} else {
				_tmp51_ = FALSE;
			}
			if (_tmp51_) {
				ValaBlock* _tmp55_;
				ValaBlock* _tmp56_;
				_tmp55_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp56_ = _tmp55_;
				_tmp50_ = _tmp56_ != NULL;
			} else {
				_tmp50_ = FALSE;
			}
			if (_tmp50_) {
				ValaParameter* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp57_ = param;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp59_, "Named parameter required before `...'");
			}
			_tmp60_ = i;
			i = _tmp60_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp61_ = ((ValaMethod*) self)->error_types;
	if (_tmp61_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp62_;
			ValaList* _tmp63_;
			gint _error_type_size = 0;
			ValaList* _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			gint _error_type_index = 0;
			_tmp62_ = ((ValaMethod*) self)->error_types;
			_tmp63_ = _vala_iterable_ref0 (_tmp62_);
			_error_type_list = _tmp63_;
			_tmp64_ = _error_type_list;
			_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
			_tmp66_ = _tmp65_;
			_error_type_size = _tmp66_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp67_;
				gpointer _tmp68_;
				ValaDataType* _tmp69_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp67_ = _error_type_list;
				_tmp68_ = vala_list_get (_tmp67_, _error_type_index);
				error_type = (ValaDataType*) _tmp68_;
				_tmp69_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp69_, context);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp70_;
		ValaList* _tmp71_;
		gint _precondition_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _precondition_index = 0;
		_tmp70_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp71_ = _vala_iterable_ref0 (_tmp70_);
		_precondition_list = _tmp71_;
		_tmp72_ = _precondition_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_precondition_size = _tmp74_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp75_;
			gpointer _tmp76_;
			ValaExpression* _tmp77_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp75_ = _precondition_list;
			_tmp76_ = vala_list_get (_tmp75_, _precondition_index);
			precondition = (ValaExpression*) _tmp76_;
			_tmp77_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp77_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp78_;
		ValaList* _tmp79_;
		gint _postcondition_size = 0;
		ValaList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _postcondition_index = 0;
		_tmp78_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp79_ = _vala_iterable_ref0 (_tmp78_);
		_postcondition_list = _tmp79_;
		_tmp80_ = _postcondition_list;
		_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_postcondition_size = _tmp82_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp83_;
			gpointer _tmp84_;
			ValaExpression* _tmp85_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp83_ = _postcondition_list;
			_tmp84_ = vala_list_get (_tmp83_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp84_;
			_tmp85_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp85_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp86_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp87_ = _tmp86_;
	if (_tmp87_ != NULL) {
		ValaBlock* _tmp88_;
		ValaBlock* _tmp89_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		gboolean _tmp92_ = FALSE;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_;
		_tmp88_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp89_ = _tmp88_;
		vala_code_node_check ((ValaCodeNode*) _tmp89_, context);
		_tmp90_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp91_ = _tmp90_;
		cl = VALA_IS_CLASS (_tmp91_) ? ((ValaClass*) _tmp91_) : NULL;
		_tmp94_ = self->priv->_chain_up;
		if (!_tmp94_) {
			ValaClass* _tmp95_;
			_tmp95_ = cl;
			_tmp93_ = _tmp95_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaClass* _tmp96_;
			ValaClass* _tmp97_;
			ValaClass* _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_base_class (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp92_ = _tmp98_ != NULL;
		} else {
			_tmp92_ = FALSE;
		}
		if (_tmp92_) {
			gboolean _tmp99_ = FALSE;
			gboolean _tmp100_ = FALSE;
			ValaProfile _tmp101_;
			ValaProfile _tmp102_;
			_tmp101_ = vala_code_context_get_profile (context);
			_tmp102_ = _tmp101_;
			if (_tmp102_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp103_;
				ValaClass* _tmp104_;
				ValaClass* _tmp105_;
				ValaCreationMethod* _tmp106_;
				ValaCreationMethod* _tmp107_;
				_tmp103_ = cl;
				_tmp104_ = vala_class_get_base_class (_tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = vala_class_get_default_construction_method (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp100_ = _tmp107_ != NULL;
			} else {
				_tmp100_ = FALSE;
			}
			if (_tmp100_) {
				ValaClass* _tmp108_;
				ValaClass* _tmp109_;
				ValaClass* _tmp110_;
				ValaCreationMethod* _tmp111_;
				ValaCreationMethod* _tmp112_;
				gboolean _tmp113_;
				gboolean _tmp114_;
				_tmp108_ = cl;
				_tmp109_ = vala_class_get_base_class (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_class_get_default_construction_method (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp112_);
				_tmp114_ = _tmp113_;
				_tmp99_ = !_tmp114_;
			} else {
				_tmp99_ = FALSE;
			}
			if (_tmp99_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp115_;
				ValaSemanticAnalyzer* _tmp116_;
				ValaBlock* _tmp117_;
				ValaBlock* _tmp118_;
				ValaSemanticAnalyzer* _tmp119_;
				ValaSemanticAnalyzer* _tmp120_;
				ValaBlock* _tmp121_;
				ValaBlock* _tmp122_;
				ValaSemanticAnalyzer* _tmp123_;
				ValaSemanticAnalyzer* _tmp124_;
				ValaBlock* _tmp125_;
				ValaBlock* _tmp126_;
				ValaBlock* _tmp127_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp128_;
				ValaSourceReference* _tmp129_;
				ValaMemberAccess* _tmp130_;
				ValaMemberAccess* _tmp131_;
				ValaSourceReference* _tmp132_;
				ValaSourceReference* _tmp133_;
				ValaMemberAccess* _tmp134_;
				ValaMemberAccess* _tmp135_;
				ValaSourceReference* _tmp136_;
				ValaSourceReference* _tmp137_;
				ValaMethodCall* _tmp138_;
				ValaMethodCall* _tmp139_;
				ValaSourceReference* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaExpressionStatement* _tmp142_;
				ValaExpressionStatement* _tmp143_;
				ValaBlock* _tmp144_;
				ValaBlock* _tmp145_;
				ValaExpressionStatement* _tmp146_;
				ValaExpressionStatement* _tmp147_;
				ValaSemanticAnalyzer* _tmp148_;
				ValaSemanticAnalyzer* _tmp149_;
				ValaSemanticAnalyzer* _tmp150_;
				ValaSemanticAnalyzer* _tmp151_;
				ValaBlock* _tmp152_;
				ValaBlock* _tmp153_;
				_tmp115_ = vala_code_context_get_analyzer (context);
				_tmp116_ = _tmp115_;
				_tmp117_ = _tmp116_->insert_block;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				old_insert_block = _tmp118_;
				_tmp119_ = vala_code_context_get_analyzer (context);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp122_ = _tmp121_;
				vala_semantic_analyzer_set_current_symbol (_tmp120_, (ValaSymbol*) _tmp122_);
				_tmp123_ = vala_code_context_get_analyzer (context);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (_tmp126_);
				_vala_code_node_unref0 (_tmp124_->insert_block);
				_tmp124_->insert_block = _tmp127_;
				_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_member_access_new_simple ("GLib", _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_member_access_new ((ValaExpression*) _tmp131_, "Object", _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_method_call_new ((ValaExpression*) _tmp135_, _tmp137_);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_expression_statement_new ((ValaExpression*) _tmp139_, _tmp141_);
				_tmp143_ = _tmp142_;
				_vala_code_node_unref0 (_tmp139_);
				_vala_code_node_unref0 (_tmp135_);
				_vala_code_node_unref0 (_tmp131_);
				stmt = _tmp143_;
				_tmp144_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp145_ = _tmp144_;
				_tmp146_ = stmt;
				vala_block_insert_statement (_tmp145_, 0, (ValaStatement*) _tmp146_);
				_tmp147_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
				_tmp148_ = vala_code_context_get_analyzer (context);
				_tmp149_ = _tmp148_;
				vala_semantic_analyzer_set_current_symbol (_tmp149_, (ValaSymbol*) self);
				_tmp150_ = vala_code_context_get_analyzer (context);
				_tmp151_ = _tmp150_;
				_tmp152_ = old_insert_block;
				_tmp153_ = _vala_code_node_ref0 (_tmp152_);
				_vala_code_node_unref0 (_tmp151_->insert_block);
				_tmp151_->insert_block = _tmp153_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp154_ = FALSE;
				ValaClass* _tmp155_;
				ValaClass* _tmp156_;
				ValaClass* _tmp157_;
				ValaCreationMethod* _tmp158_;
				ValaCreationMethod* _tmp159_;
				_tmp155_ = cl;
				_tmp156_ = vala_class_get_base_class (_tmp155_);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_class_get_default_construction_method (_tmp157_);
				_tmp159_ = _tmp158_;
				if (_tmp159_ == NULL) {
					_tmp154_ = TRUE;
				} else {
					ValaClass* _tmp160_;
					ValaClass* _tmp161_;
					ValaClass* _tmp162_;
					ValaCreationMethod* _tmp163_;
					ValaCreationMethod* _tmp164_;
					ValaSymbolAccessibility _tmp165_;
					ValaSymbolAccessibility _tmp166_;
					_tmp160_ = cl;
					_tmp161_ = vala_class_get_base_class (_tmp160_);
					_tmp162_ = _tmp161_;
					_tmp163_ = vala_class_get_default_construction_method (_tmp162_);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_symbol_get_access ((ValaSymbol*) _tmp164_);
					_tmp166_ = _tmp165_;
					_tmp154_ = _tmp166_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp154_) {
					ValaSourceReference* _tmp167_;
					ValaSourceReference* _tmp168_;
					_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp168_ = _tmp167_;
					vala_report_error (_tmp168_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp169_;
					ValaClass* _tmp170_;
					ValaClass* _tmp171_;
					ValaCreationMethod* _tmp172_;
					ValaCreationMethod* _tmp173_;
					_tmp169_ = cl;
					_tmp170_ = vala_class_get_base_class (_tmp169_);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_class_get_default_construction_method (_tmp171_);
					_tmp173_ = _tmp172_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp173_) > 0) {
						ValaSourceReference* _tmp174_;
						ValaSourceReference* _tmp175_;
						_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp175_ = _tmp174_;
						vala_report_error (_tmp175_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp176_;
						ValaSemanticAnalyzer* _tmp177_;
						ValaBlock* _tmp178_;
						ValaBlock* _tmp179_;
						ValaSemanticAnalyzer* _tmp180_;
						ValaSemanticAnalyzer* _tmp181_;
						ValaBlock* _tmp182_;
						ValaBlock* _tmp183_;
						ValaSemanticAnalyzer* _tmp184_;
						ValaSemanticAnalyzer* _tmp185_;
						ValaBlock* _tmp186_;
						ValaBlock* _tmp187_;
						ValaBlock* _tmp188_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp189_;
						ValaSourceReference* _tmp190_;
						ValaBaseAccess* _tmp191_;
						ValaBaseAccess* _tmp192_;
						ValaSourceReference* _tmp193_;
						ValaSourceReference* _tmp194_;
						ValaMethodCall* _tmp195_;
						ValaMethodCall* _tmp196_;
						ValaSourceReference* _tmp197_;
						ValaSourceReference* _tmp198_;
						ValaExpressionStatement* _tmp199_;
						ValaExpressionStatement* _tmp200_;
						ValaBlock* _tmp201_;
						ValaBlock* _tmp202_;
						ValaExpressionStatement* _tmp203_;
						ValaExpressionStatement* _tmp204_;
						ValaSemanticAnalyzer* _tmp205_;
						ValaSemanticAnalyzer* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaBlock* _tmp209_;
						ValaBlock* _tmp210_;
						_tmp176_ = vala_code_context_get_analyzer (context);
						_tmp177_ = _tmp176_;
						_tmp178_ = _tmp177_->insert_block;
						_tmp179_ = _vala_code_node_ref0 (_tmp178_);
						old_insert_block = _tmp179_;
						_tmp180_ = vala_code_context_get_analyzer (context);
						_tmp181_ = _tmp180_;
						_tmp182_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp183_ = _tmp182_;
						vala_semantic_analyzer_set_current_symbol (_tmp181_, (ValaSymbol*) _tmp183_);
						_tmp184_ = vala_code_context_get_analyzer (context);
						_tmp185_ = _tmp184_;
						_tmp186_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp187_ = _tmp186_;
						_tmp188_ = _vala_code_node_ref0 (_tmp187_);
						_vala_code_node_unref0 (_tmp185_->insert_block);
						_tmp185_->insert_block = _tmp188_;
						_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp190_ = _tmp189_;
						_tmp191_ = vala_base_access_new (_tmp190_);
						_tmp192_ = _tmp191_;
						_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp194_ = _tmp193_;
						_tmp195_ = vala_method_call_new ((ValaExpression*) _tmp192_, _tmp194_);
						_tmp196_ = _tmp195_;
						_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp198_ = _tmp197_;
						_tmp199_ = vala_expression_statement_new ((ValaExpression*) _tmp196_, _tmp198_);
						_tmp200_ = _tmp199_;
						_vala_code_node_unref0 (_tmp196_);
						_vala_code_node_unref0 (_tmp192_);
						stmt = _tmp200_;
						_tmp201_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp202_ = _tmp201_;
						_tmp203_ = stmt;
						vala_block_insert_statement (_tmp202_, 0, (ValaStatement*) _tmp203_);
						_tmp204_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp204_, context);
						_tmp205_ = vala_code_context_get_analyzer (context);
						_tmp206_ = _tmp205_;
						vala_semantic_analyzer_set_current_symbol (_tmp206_, (ValaSymbol*) self);
						_tmp207_ = vala_code_context_get_analyzer (context);
						_tmp208_ = _tmp207_;
						_tmp209_ = old_insert_block;
						_tmp210_ = _vala_code_node_ref0 (_tmp209_);
						_vala_code_node_unref0 (_tmp208_->insert_block);
						_tmp208_->insert_block = _tmp210_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp211_ = vala_code_context_get_analyzer (context);
	_tmp212_ = _tmp211_;
	_tmp213_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp212_, _tmp213_);
	_tmp214_ = vala_code_context_get_analyzer (context);
	_tmp215_ = _tmp214_;
	_tmp216_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp215_, _tmp216_);
	_tmp219_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp220_ = _tmp219_;
	if (_tmp220_) {
		_tmp218_ = TRUE;
	} else {
		gboolean _tmp221_;
		gboolean _tmp222_;
		_tmp221_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp222_ = _tmp221_;
		_tmp218_ = _tmp222_;
	}
	if (_tmp218_) {
		_tmp217_ = TRUE;
	} else {
		gboolean _tmp223_;
		gboolean _tmp224_;
		_tmp223_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp224_ = _tmp223_;
		_tmp217_ = _tmp224_;
	}
	if (_tmp217_) {
		ValaSourceReference* _tmp225_;
		ValaSourceReference* _tmp226_;
		gchar* _tmp227_;
		gchar* _tmp228_;
		gchar* _tmp229_;
		gchar* _tmp230_;
		_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp226_ = _tmp225_;
		_tmp227_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp228_ = _tmp227_;
		_tmp229_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp228_);
		_tmp230_ = _tmp229_;
		vala_report_error (_tmp226_, _tmp230_);
		_g_free0 (_tmp230_);
		_g_free0 (_tmp228_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp231_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp232_ = _tmp231_;
	if (_tmp232_ != NULL) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp233_;
		ValaArrayList* _tmp234_;
		ValaBlock* _tmp235_;
		ValaBlock* _tmp236_;
		ValaArrayList* _tmp237_;
		_tmp233_ = g_direct_equal;
		_tmp234_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp233_);
		body_errors = _tmp234_;
		_tmp235_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp236_ = _tmp235_;
		_tmp237_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp236_, (ValaCollection*) _tmp237_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp238_;
			ValaArrayList* _tmp239_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp240_;
			gint _tmp241_;
			gint _tmp242_;
			gint _body_error_type_index = 0;
			_tmp238_ = body_errors;
			_tmp239_ = _vala_iterable_ref0 (_tmp238_);
			_body_error_type_list = _tmp239_;
			_tmp240_ = _body_error_type_list;
			_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
			_tmp242_ = _tmp241_;
			_body_error_type_size = _tmp242_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp243_;
				gpointer _tmp244_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp245_;
				gboolean _tmp255_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp243_ = _body_error_type_list;
				_tmp244_ = vala_list_get ((ValaList*) _tmp243_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp244_;
				can_propagate_error = FALSE;
				_tmp245_ = ((ValaMethod*) self)->error_types;
				if (_tmp245_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp246_;
						ValaList* _tmp247_;
						gint _method_error_type_size = 0;
						ValaList* _tmp248_;
						gint _tmp249_;
						gint _tmp250_;
						gint _method_error_type_index = 0;
						_tmp246_ = ((ValaMethod*) self)->error_types;
						_tmp247_ = _vala_iterable_ref0 (_tmp246_);
						_method_error_type_list = _tmp247_;
						_tmp248_ = _method_error_type_list;
						_tmp249_ = vala_collection_get_size ((ValaCollection*) _tmp248_);
						_tmp250_ = _tmp249_;
						_method_error_type_size = _tmp250_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp251_;
							gpointer _tmp252_;
							ValaDataType* _tmp253_;
							ValaDataType* _tmp254_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp251_ = _method_error_type_list;
							_tmp252_ = vala_list_get (_tmp251_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp252_;
							_tmp253_ = body_error_type;
							_tmp254_ = method_error_type;
							if (vala_data_type_compatible (_tmp253_, _tmp254_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp256_;
					gboolean _tmp257_;
					gboolean _tmp258_;
					_tmp256_ = body_error_type;
					_tmp257_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp256_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp258_ = _tmp257_;
					_tmp255_ = !_tmp258_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaDataType* _tmp259_;
					ValaSourceReference* _tmp260_;
					ValaSourceReference* _tmp261_;
					ValaDataType* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					gchar* _tmp266_;
					_tmp259_ = body_error_type;
					_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp259_);
					_tmp261_ = _tmp260_;
					_tmp262_ = body_error_type;
					_tmp263_ = vala_code_node_to_string ((ValaCodeNode*) _tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = g_strdup_printf ("unhandled error `%s'", _tmp264_);
					_tmp266_ = _tmp265_;
					vala_report_warning (_tmp261_, _tmp266_);
					_g_free0 (_tmp266_);
					_g_free0 (_tmp264_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp267_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp268_ = _tmp267_;
	result = !_tmp268_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
		ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

