/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	ValaSemanticAnalyzer* _tmp36_;
	ValaSemanticAnalyzer* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp50_;
	ValaDataType* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	ValaArrayType* _tmp55_;
	ValaExpression* _tmp67_;
	ValaExpression* _tmp68_;
	gboolean _tmp191_ = FALSE;
	ValaMemberBinding _tmp192_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp197_;
	ValaSymbol* _tmp198_;
	gboolean _tmp207_ = FALSE;
	gboolean _tmp208_ = FALSE;
	gboolean _tmp209_;
	gboolean _tmp210_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSemanticAnalyzer* _tmp226_;
	ValaSourceFile* _tmp227_;
	ValaSemanticAnalyzer* _tmp228_;
	ValaSemanticAnalyzer* _tmp229_;
	ValaSymbol* _tmp230_;
	gboolean _tmp231_;
	gboolean _tmp232_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	vala_code_node_check ((ValaCodeNode*) _tmp29_, context);
	_tmp30_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp31_ = _tmp30_;
	if (!_tmp31_) {
		ValaSemanticAnalyzer* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp32_ = vala_code_context_get_analyzer (context);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp35_ = _tmp34_;
		vala_semantic_analyzer_check_type (_tmp33_, _tmp35_);
	}
	_tmp36_ = vala_code_context_get_analyzer (context);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp39_ = _tmp38_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp37_, (ValaSymbol*) self, _tmp39_)) {
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_code_node_to_string ((ValaCodeNode*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp45_, _tmp47_);
		_tmp49_ = _tmp48_;
		vala_report_error (_tmp41_, _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp45_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp50_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp51_ = _tmp50_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp51_) ? ((ValaArrayType*) _tmp51_) : NULL;
	_tmp55_ = variable_array_type;
	if (_tmp55_ != NULL) {
		ValaArrayType* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		_tmp56_ = variable_array_type;
		_tmp57_ = vala_array_type_get_fixed_length (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp54_ = _tmp58_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		_tmp53_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp60_);
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaInitializerList* _tmp63_;
		ValaInitializerList* _tmp64_;
		_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp64_ = _tmp63_;
		_tmp52_ = _tmp64_ == NULL;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaSourceReference* _tmp65_;
		ValaSourceReference* _tmp66_;
		_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp66_ = _tmp65_;
		vala_report_warning (_tmp66_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp68_ = _tmp67_;
	if (_tmp68_ != NULL) {
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaExpression* _tmp79_;
		ValaExpression* _tmp80_;
		ValaExpression* _tmp81_;
		ValaExpression* _tmp82_;
		ValaDataType* _tmp83_;
		ValaDataType* _tmp84_;
		ValaExpression* _tmp87_;
		ValaExpression* _tmp88_;
		ValaDataType* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		gboolean _tmp107_ = FALSE;
		gboolean _tmp108_ = FALSE;
		gboolean _tmp109_ = FALSE;
		ValaArrayType* _tmp110_;
		gboolean _tmp124_ = FALSE;
		gboolean _tmp125_ = FALSE;
		ValaArrayType* _tmp126_;
		ValaExpression* _tmp136_;
		ValaExpression* _tmp137_;
		ValaDataType* _tmp138_;
		ValaDataType* _tmp139_;
		gboolean _tmp149_ = FALSE;
		ValaSymbol* _tmp150_;
		ValaSymbol* _tmp151_;
		gboolean _tmp156_ = FALSE;
		gboolean _tmp157_ = FALSE;
		ValaSymbol* _tmp158_;
		ValaSymbol* _tmp159_;
		gboolean _tmp173_ = FALSE;
		gboolean _tmp174_ = FALSE;
		gboolean _tmp175_ = FALSE;
		ValaMemberBinding _tmp176_;
		gboolean _tmp187_;
		gboolean _tmp188_;
		_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		vala_expression_set_target_type (_tmp70_, _tmp72_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp73_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		if (VALA_IS_INITIALIZER_LIST (_tmp74_)) {
			ValaExpression* _tmp75_;
			ValaExpression* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			_tmp75_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp78_ = _tmp77_;
			initializer_size = _tmp78_;
			is_initializer_list = TRUE;
		}
		_tmp79_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp80_ = _tmp79_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp80_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp81_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_expression_get_value_type (_tmp82_);
		_tmp84_ = _tmp83_;
		if (_tmp84_ == NULL) {
			ValaSourceReference* _tmp85_;
			ValaSourceReference* _tmp86_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp86_ = _tmp85_;
			vala_report_error (_tmp86_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_expression_get_value_type (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp92_ = _tmp91_;
		if (!vala_data_type_compatible (_tmp90_, _tmp92_)) {
			ValaSourceReference* _tmp93_;
			ValaSourceReference* _tmp94_;
			ValaExpression* _tmp95_;
			ValaExpression* _tmp96_;
			ValaDataType* _tmp97_;
			ValaDataType* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			ValaDataType* _tmp101_;
			ValaDataType* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_expression_get_value_type (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_code_node_to_string ((ValaCodeNode*) _tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_code_node_to_string ((ValaCodeNode*) _tmp102_);
			_tmp104_ = _tmp103_;
			_tmp105_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp100_, _tmp104_);
			_tmp106_ = _tmp105_;
			vala_report_error (_tmp94_, _tmp106_);
			_g_free0 (_tmp106_);
			_g_free0 (_tmp104_);
			_g_free0 (_tmp100_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp110_ = variable_array_type;
		if (_tmp110_ != NULL) {
			ValaArrayType* _tmp111_;
			gboolean _tmp112_;
			gboolean _tmp113_;
			_tmp111_ = variable_array_type;
			_tmp112_ = vala_array_type_get_inline_allocated (_tmp111_);
			_tmp113_ = _tmp112_;
			_tmp109_ = _tmp113_;
		} else {
			_tmp109_ = FALSE;
		}
		if (_tmp109_) {
			ValaArrayType* _tmp114_;
			gboolean _tmp115_;
			gboolean _tmp116_;
			_tmp114_ = variable_array_type;
			_tmp115_ = vala_array_type_get_fixed_length (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp108_ = !_tmp116_;
		} else {
			_tmp108_ = FALSE;
		}
		if (_tmp108_) {
			_tmp107_ = is_initializer_list;
		} else {
			_tmp107_ = FALSE;
		}
		if (_tmp107_) {
			ValaArrayType* _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			ValaIntegerLiteral* _tmp120_;
			ValaIntegerLiteral* _tmp121_;
			ValaArrayType* _tmp122_;
			ValaArrayType* _tmp123_;
			_tmp117_ = variable_array_type;
			_tmp118_ = g_strdup_printf ("%i", initializer_size);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_integer_literal_new (_tmp119_, NULL);
			_tmp121_ = _tmp120_;
			vala_array_type_set_length (_tmp117_, (ValaExpression*) _tmp121_);
			_vala_code_node_unref0 (_tmp121_);
			_g_free0 (_tmp119_);
			_tmp122_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp122_, TRUE);
			_tmp123_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp123_, FALSE);
		}
		_tmp126_ = variable_array_type;
		if (_tmp126_ != NULL) {
			ValaArrayType* _tmp127_;
			gboolean _tmp128_;
			gboolean _tmp129_;
			_tmp127_ = variable_array_type;
			_tmp128_ = vala_array_type_get_inline_allocated (_tmp127_);
			_tmp129_ = _tmp128_;
			_tmp125_ = _tmp129_;
		} else {
			_tmp125_ = FALSE;
		}
		if (_tmp125_) {
			ValaExpression* _tmp130_;
			ValaExpression* _tmp131_;
			ValaDataType* _tmp132_;
			ValaDataType* _tmp133_;
			_tmp130_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_expression_get_value_type (_tmp131_);
			_tmp133_ = _tmp132_;
			_tmp124_ = !VALA_IS_ARRAY_TYPE (_tmp133_);
		} else {
			_tmp124_ = FALSE;
		}
		if (_tmp124_) {
			ValaSourceReference* _tmp134_;
			ValaSourceReference* _tmp135_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp135_ = _tmp134_;
			vala_report_error (_tmp135_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp136_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_expression_get_value_type (_tmp137_);
		_tmp139_ = _tmp138_;
		if (vala_data_type_is_disposable (_tmp139_)) {
			gboolean _tmp140_ = FALSE;
			ValaDataType* _tmp141_;
			ValaDataType* _tmp142_;
			_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp142_ = _tmp141_;
			if (!VALA_IS_POINTER_TYPE (_tmp142_)) {
				ValaDataType* _tmp143_;
				ValaDataType* _tmp144_;
				gboolean _tmp145_;
				gboolean _tmp146_;
				_tmp143_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_data_type_get_value_owned (_tmp144_);
				_tmp146_ = _tmp145_;
				_tmp140_ = !_tmp146_;
			} else {
				_tmp140_ = FALSE;
			}
			if (_tmp140_) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				vala_report_error (_tmp148_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp150_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp151_ = _tmp150_;
		if (VALA_IS_NAMESPACE (_tmp151_)) {
			ValaExpression* _tmp152_;
			ValaExpression* _tmp153_;
			_tmp152_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp153_ = _tmp152_;
			_tmp149_ = !vala_expression_is_constant (_tmp153_);
		} else {
			_tmp149_ = FALSE;
		}
		if (_tmp149_) {
			ValaSourceReference* _tmp154_;
			ValaSourceReference* _tmp155_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp155_ = _tmp154_;
			vala_report_error (_tmp155_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp158_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp159_ = _tmp158_;
		if (VALA_IS_NAMESPACE (_tmp159_)) {
			ValaExpression* _tmp160_;
			ValaExpression* _tmp161_;
			_tmp160_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp161_ = _tmp160_;
			_tmp157_ = vala_expression_is_constant (_tmp161_);
		} else {
			_tmp157_ = FALSE;
		}
		if (_tmp157_) {
			ValaExpression* _tmp162_;
			ValaExpression* _tmp163_;
			_tmp162_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp163_ = _tmp162_;
			_tmp156_ = vala_expression_is_non_null (_tmp163_);
		} else {
			_tmp156_ = FALSE;
		}
		if (_tmp156_) {
			gboolean _tmp164_ = FALSE;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			_tmp165_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp166_ = _tmp165_;
			if (vala_data_type_is_disposable (_tmp166_)) {
				ValaDataType* _tmp167_;
				ValaDataType* _tmp168_;
				gboolean _tmp169_;
				gboolean _tmp170_;
				_tmp167_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_data_type_get_value_owned (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp164_ = _tmp170_;
			} else {
				_tmp164_ = FALSE;
			}
			if (_tmp164_) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				vala_report_error (_tmp172_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp176_ = self->priv->_binding;
		if (_tmp176_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp177_;
			ValaSymbol* _tmp178_;
			_tmp177_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp178_ = _tmp177_;
			_tmp175_ = VALA_IS_CLASS (_tmp178_);
		} else {
			_tmp175_ = FALSE;
		}
		if (_tmp175_) {
			ValaSymbol* _tmp179_;
			ValaSymbol* _tmp180_;
			gboolean _tmp181_;
			gboolean _tmp182_;
			_tmp179_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp180_, VALA_TYPE_CLASS, ValaClass));
			_tmp182_ = _tmp181_;
			_tmp174_ = _tmp182_;
		} else {
			_tmp174_ = FALSE;
		}
		if (_tmp174_) {
			ValaExpression* _tmp183_;
			ValaExpression* _tmp184_;
			_tmp183_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp184_ = _tmp183_;
			_tmp173_ = !vala_expression_is_constant (_tmp184_);
		} else {
			_tmp173_ = FALSE;
		}
		if (_tmp173_) {
			ValaSourceReference* _tmp185_;
			ValaSourceReference* _tmp186_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp186_ = _tmp185_;
			vala_report_error (_tmp186_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp187_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp188_ = _tmp187_;
		if (_tmp188_) {
			ValaSourceReference* _tmp189_;
			ValaSourceReference* _tmp190_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp190_ = _tmp189_;
			vala_report_error (_tmp190_, "External fields cannot use initializers");
		}
	}
	_tmp192_ = self->priv->_binding;
	if (_tmp192_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp193_;
		ValaSymbol* _tmp194_;
		_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp194_ = _tmp193_;
		_tmp191_ = VALA_IS_INTERFACE (_tmp194_);
	} else {
		_tmp191_ = FALSE;
	}
	if (_tmp191_) {
		ValaSourceReference* _tmp195_;
		ValaSourceReference* _tmp196_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp196_ = _tmp195_;
		vala_report_error (_tmp196_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp197_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp198_ = _tmp197_;
	if (VALA_IS_CLASS (_tmp198_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp199_;
		ValaSymbol* _tmp200_;
		ValaClass* _tmp201_;
		gboolean _tmp202_ = FALSE;
		ValaClass* _tmp203_;
		gboolean _tmp204_;
		gboolean _tmp205_;
		_tmp199_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp200_ = _tmp199_;
		_tmp201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp201_;
		_tmp203_ = cl;
		_tmp204_ = vala_class_get_is_compact (_tmp203_);
		_tmp205_ = _tmp204_;
		if (_tmp205_) {
			ValaClass* _tmp206_;
			_tmp206_ = cl;
			_tmp202_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp206_);
		} else {
			_tmp202_ = FALSE;
		}
		if (_tmp202_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp209_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp210_ = _tmp209_;
	if (!_tmp210_) {
		gboolean _tmp211_;
		gboolean _tmp212_;
		_tmp211_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp212_ = _tmp211_;
		_tmp208_ = !_tmp212_;
	} else {
		_tmp208_ = FALSE;
	}
	if (_tmp208_) {
		ValaSymbol* _tmp213_;
		ValaSymbol* _tmp214_;
		_tmp213_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp214_ = _tmp213_;
		_tmp207_ = _tmp214_ != NULL;
		_vala_code_node_unref0 (_tmp214_);
	} else {
		_tmp207_ = FALSE;
	}
	if (_tmp207_) {
		ValaSourceReference* _tmp215_;
		ValaSourceReference* _tmp216_;
		gchar* _tmp217_;
		gchar* _tmp218_;
		ValaSymbol* _tmp219_;
		ValaSymbol* _tmp220_;
		gchar* _tmp221_;
		gchar* _tmp222_;
		gchar* _tmp223_;
		gchar* _tmp224_;
		_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp216_ = _tmp215_;
		_tmp217_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp218_ = _tmp217_;
		_tmp219_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_symbol_get_full_name (_tmp220_);
		_tmp222_ = _tmp221_;
		_tmp223_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp218_, _tmp222_);
		_tmp224_ = _tmp223_;
		vala_report_warning (_tmp216_, _tmp224_);
		_g_free0 (_tmp224_);
		_g_free0 (_tmp222_);
		_vala_code_node_unref0 (_tmp220_);
		_g_free0 (_tmp218_);
	}
	_tmp225_ = vala_code_context_get_analyzer (context);
	_tmp226_ = _tmp225_;
	_tmp227_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp226_, _tmp227_);
	_tmp228_ = vala_code_context_get_analyzer (context);
	_tmp229_ = _tmp228_;
	_tmp230_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp229_, _tmp230_);
	_tmp231_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp232_ = _tmp231_;
	result = !_tmp232_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

