/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp537_ = FALSE;
	gboolean _tmp538_ = FALSE;
	gboolean _tmp539_ = FALSE;
	ValaExpression* _tmp540_;
	ValaExpression* _tmp541_;
	ValaSymbol* _tmp567_;
	ValaSymbol* _tmp568_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp616_;
	ValaSymbol* _tmp617_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp618_;
	ValaSymbol* _tmp619_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1006_;
	ValaSymbol* _tmp1007_;
	ValaSymbol* _tmp1009_;
	ValaVersionAttribute* _tmp1010_;
	ValaVersionAttribute* _tmp1011_;
	ValaSourceReference* _tmp1012_;
	ValaSourceReference* _tmp1013_;
	gboolean _tmp1014_ = FALSE;
	ValaSymbolAccessibility _tmp1015_;
	gboolean _tmp1071_ = FALSE;
	gboolean _tmp1098_ = FALSE;
	gboolean _tmp1099_ = FALSE;
	ValaDataType* _tmp1351_;
	ValaDataType* _tmp1352_;
	gboolean _tmp1355_;
	gboolean _tmp1356_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp153_;
						ValaSymbol* _tmp154_;
						ValaSymbol* _tmp155_;
						ValaScope* _tmp156_;
						ValaScope* _tmp157_;
						const gchar* _tmp158_;
						ValaSymbol* _tmp159_;
						ValaSymbol* _tmp160_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_using_directive_get_namespace_symbol (_tmp153_);
						_tmp155_ = _tmp154_;
						_tmp156_ = vala_symbol_get_scope (_tmp155_);
						_tmp157_ = _tmp156_;
						_tmp158_ = self->priv->_member_name;
						_tmp159_ = vala_scope_lookup (_tmp157_, _tmp158_);
						local_sym = _tmp159_;
						_tmp160_ = local_sym;
						if (_tmp160_ != NULL) {
							gboolean _tmp161_ = FALSE;
							ValaSymbol* _tmp162_;
							ValaSymbol* _tmp163_;
							ValaSymbol* _tmp179_;
							_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp163_ = _tmp162_;
							if (_tmp163_ != NULL) {
								ValaSymbol* _tmp164_;
								ValaSymbol* _tmp165_;
								ValaSymbol* _tmp166_;
								_tmp164_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp165_ = _tmp164_;
								_tmp166_ = local_sym;
								_tmp161_ = _tmp165_ != _tmp166_;
							} else {
								_tmp161_ = FALSE;
							}
							if (_tmp161_) {
								ValaSourceReference* _tmp167_;
								ValaSourceReference* _tmp168_;
								const gchar* _tmp169_;
								ValaSymbol* _tmp170_;
								ValaSymbol* _tmp171_;
								gchar* _tmp172_;
								gchar* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								gchar* _tmp177_;
								gchar* _tmp178_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = self->priv->_member_name;
								_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = vala_symbol_get_full_name (_tmp171_);
								_tmp173_ = _tmp172_;
								_tmp174_ = local_sym;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp169_, _tmp173_, _tmp176_);
								_tmp178_ = _tmp177_;
								vala_report_error (_tmp168_, _tmp178_);
								_g_free0 (_tmp178_);
								_g_free0 (_tmp176_);
								_g_free0 (_tmp173_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp179_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp179_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			gboolean _tmp182_;
			gboolean _tmp183_;
			ValaExpression* _tmp184_;
			ValaExpression* _tmp185_;
			ValaDataType* _tmp186_;
			ValaDataType* _tmp187_;
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			gboolean _tmp221_ = FALSE;
			ValaExpression* _tmp222_;
			ValaExpression* _tmp223_;
			gboolean _tmp230_ = FALSE;
			ValaExpression* _tmp231_;
			ValaExpression* _tmp232_;
			gboolean _tmp253_ = FALSE;
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			gboolean _tmp274_ = FALSE;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			gboolean _tmp310_ = FALSE;
			gboolean _tmp311_ = FALSE;
			ValaSymbol* _tmp312_;
			ValaSymbol* _tmp313_;
			gboolean _tmp519_ = FALSE;
			ValaSymbol* _tmp520_;
			ValaSymbol* _tmp521_;
			_tmp180_ = vala_member_access_get_inner (self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_code_node_get_error ((ValaCodeNode*) _tmp181_);
			_tmp183_ = _tmp182_;
			if (_tmp183_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp184_ = vala_member_access_get_inner (self);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_expression_get_value_type (_tmp185_);
			_tmp187_ = _tmp186_;
			if (VALA_IS_POINTER_TYPE (_tmp187_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp188_;
				ValaExpression* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				gboolean _tmp192_ = FALSE;
				ValaPointerType* _tmp193_;
				_tmp188_ = vala_member_access_get_inner (self);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_expression_get_value_type (_tmp189_);
				_tmp191_ = _tmp190_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp191_) ? ((ValaPointerType*) _tmp191_) : NULL;
				_tmp193_ = pointer_type;
				if (_tmp193_ != NULL) {
					ValaPointerType* _tmp194_;
					ValaDataType* _tmp195_;
					ValaDataType* _tmp196_;
					_tmp194_ = pointer_type;
					_tmp195_ = vala_pointer_type_get_base_type (_tmp194_);
					_tmp196_ = _tmp195_;
					_tmp192_ = VALA_IS_VALUE_TYPE (_tmp196_);
				} else {
					_tmp192_ = FALSE;
				}
				if (_tmp192_) {
					ValaExpression* _tmp197_;
					ValaExpression* _tmp198_;
					ValaSourceReference* _tmp199_;
					ValaSourceReference* _tmp200_;
					ValaPointerIndirection* _tmp201_;
					ValaPointerIndirection* _tmp202_;
					ValaExpression* _tmp203_;
					ValaExpression* _tmp204_;
					_tmp197_ = vala_member_access_get_inner (self);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_pointer_indirection_new (_tmp198_, _tmp200_);
					_tmp202_ = _tmp201_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp202_);
					_vala_code_node_unref0 (_tmp202_);
					_tmp203_ = vala_member_access_get_inner (self);
					_tmp204_ = _tmp203_;
					vala_code_node_check ((ValaCodeNode*) _tmp204_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp205_ = vala_member_access_get_inner (self);
			_tmp206_ = _tmp205_;
			if (VALA_IS_MEMBER_ACCESS (_tmp206_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp207_;
				ValaExpression* _tmp208_;
				ValaMemberAccess* _tmp209_;
				gboolean _tmp210_;
				_tmp207_ = vala_member_access_get_inner (self);
				_tmp208_ = _tmp207_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp208_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp209_ = ma;
				_tmp210_ = _tmp209_->priv->_prototype_access;
				if (_tmp210_) {
					ValaSourceReference* _tmp211_;
					ValaSourceReference* _tmp212_;
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaSymbol* _tmp215_;
					ValaSymbol* _tmp216_;
					gchar* _tmp217_;
					gchar* _tmp218_;
					gchar* _tmp219_;
					gchar* _tmp220_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp212_ = _tmp211_;
					_tmp213_ = vala_member_access_get_inner (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_symbol_reference (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_symbol_get_full_name (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp218_);
					_tmp220_ = _tmp219_;
					vala_report_error (_tmp212_, _tmp220_);
					_g_free0 (_tmp220_);
					_g_free0 (_tmp218_);
					result = FALSE;
					return result;
				}
			}
			_tmp222_ = vala_member_access_get_inner (self);
			_tmp223_ = _tmp222_;
			if (VALA_IS_CAST_EXPRESSION (_tmp223_)) {
				ValaExpression* _tmp224_;
				ValaExpression* _tmp225_;
				gboolean _tmp226_;
				gboolean _tmp227_;
				_tmp224_ = vala_member_access_get_inner (self);
				_tmp225_ = _tmp224_;
				_tmp226_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp225_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp227_ = _tmp226_;
				_tmp221_ = _tmp227_;
			} else {
				_tmp221_ = FALSE;
			}
			if (_tmp221_) {
				ValaSourceReference* _tmp228_;
				ValaSourceReference* _tmp229_;
				_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp229_ = _tmp228_;
				vala_report_warning (_tmp229_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp231_ = vala_member_access_get_inner (self);
			_tmp232_ = _tmp231_;
			if (VALA_IS_MEMBER_ACCESS (_tmp232_)) {
				_tmp230_ = TRUE;
			} else {
				ValaExpression* _tmp233_;
				ValaExpression* _tmp234_;
				_tmp233_ = vala_member_access_get_inner (self);
				_tmp234_ = _tmp233_;
				_tmp230_ = VALA_IS_BASE_ACCESS (_tmp234_);
			}
			if (_tmp230_) {
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaSymbol* _tmp237_;
				ValaSymbol* _tmp238_;
				gboolean _tmp239_ = FALSE;
				ValaSymbol* _tmp240_;
				ValaSymbol* _tmp241_;
				_tmp235_ = vala_member_access_get_inner (self);
				_tmp236_ = _tmp235_;
				_tmp237_ = vala_expression_get_symbol_reference (_tmp236_);
				_tmp238_ = _tmp237_;
				base_symbol = _tmp238_;
				_tmp240_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp241_ = _tmp240_;
				if (_tmp241_ == NULL) {
					gboolean _tmp242_ = FALSE;
					ValaSymbol* _tmp243_;
					_tmp243_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp243_)) {
						_tmp242_ = TRUE;
					} else {
						ValaSymbol* _tmp244_;
						_tmp244_ = base_symbol;
						_tmp242_ = VALA_IS_TYPESYMBOL (_tmp244_);
					}
					_tmp239_ = _tmp242_;
				} else {
					_tmp239_ = FALSE;
				}
				if (_tmp239_) {
					ValaSymbol* _tmp245_;
					ValaScope* _tmp246_;
					ValaScope* _tmp247_;
					const gchar* _tmp248_;
					ValaSymbol* _tmp249_;
					ValaSymbol* _tmp250_;
					ValaExpression* _tmp251_;
					ValaExpression* _tmp252_;
					_tmp245_ = base_symbol;
					_tmp246_ = vala_symbol_get_scope (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = self->priv->_member_name;
					_tmp249_ = vala_scope_lookup (_tmp247_, _tmp248_);
					_tmp250_ = _tmp249_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
					_vala_code_node_unref0 (_tmp250_);
					_tmp251_ = vala_member_access_get_inner (self);
					_tmp252_ = _tmp251_;
					if (VALA_IS_BASE_ACCESS (_tmp252_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp254_ = vala_member_access_get_inner (self);
			_tmp255_ = _tmp254_;
			if (VALA_IS_MEMBER_ACCESS (_tmp255_)) {
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_symbol_reference (_tmp257_);
				_tmp259_ = _tmp258_;
				_tmp253_ = VALA_IS_TYPEPARAMETER (_tmp259_);
			} else {
				_tmp253_ = FALSE;
			}
			if (_tmp253_) {
				ValaExpression* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				ValaExpression* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				ValaGenericType* _tmp266_;
				ValaGenericType* _tmp267_;
				ValaExpression* _tmp268_;
				ValaExpression* _tmp269_;
				ValaDataType* _tmp270_;
				ValaDataType* _tmp271_;
				ValaSourceReference* _tmp272_;
				ValaSourceReference* _tmp273_;
				_tmp260_ = vala_member_access_get_inner (self);
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_member_access_get_inner (self);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_expression_get_symbol_reference (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp265_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp267_ = _tmp266_;
				vala_expression_set_value_type (_tmp261_, (ValaDataType*) _tmp267_);
				_vala_code_node_unref0 (_tmp267_);
				_tmp268_ = vala_member_access_get_inner (self);
				_tmp269_ = _tmp268_;
				_tmp270_ = vala_expression_get_value_type (_tmp269_);
				_tmp271_ = _tmp270_;
				_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp273_ = _tmp272_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp271_, _tmp273_);
			}
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				ValaExpression* _tmp277_;
				ValaExpression* _tmp278_;
				ValaDataType* _tmp279_;
				ValaDataType* _tmp280_;
				_tmp277_ = vala_member_access_get_inner (self);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_expression_get_value_type (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp274_ = _tmp280_ != NULL;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				gboolean _tmp281_;
				ValaSymbol* _tmp308_;
				ValaSymbol* _tmp309_;
				_tmp281_ = self->priv->_pointer_member_access;
				if (_tmp281_) {
					ValaExpression* _tmp282_;
					ValaExpression* _tmp283_;
					ValaDataType* _tmp284_;
					ValaDataType* _tmp285_;
					const gchar* _tmp286_;
					ValaSymbol* _tmp287_;
					ValaSymbol* _tmp288_;
					_tmp282_ = vala_member_access_get_inner (self);
					_tmp283_ = _tmp282_;
					_tmp284_ = vala_expression_get_value_type (_tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = self->priv->_member_name;
					_tmp287_ = vala_data_type_get_pointer_member (_tmp285_, _tmp286_);
					_tmp288_ = _tmp287_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp288_);
					_vala_code_node_unref0 (_tmp288_);
				} else {
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					ValaTypeSymbol* _tmp293_;
					ValaTypeSymbol* _tmp294_;
					ValaExpression* _tmp301_;
					ValaExpression* _tmp302_;
					ValaDataType* _tmp303_;
					ValaDataType* _tmp304_;
					const gchar* _tmp305_;
					ValaSymbol* _tmp306_;
					ValaSymbol* _tmp307_;
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_data_type_get_type_symbol (_tmp292_);
					_tmp294_ = _tmp293_;
					if (_tmp294_ != NULL) {
						ValaExpression* _tmp295_;
						ValaExpression* _tmp296_;
						ValaDataType* _tmp297_;
						ValaDataType* _tmp298_;
						ValaTypeSymbol* _tmp299_;
						ValaTypeSymbol* _tmp300_;
						_tmp295_ = vala_member_access_get_inner (self);
						_tmp296_ = _tmp295_;
						_tmp297_ = vala_expression_get_value_type (_tmp296_);
						_tmp298_ = _tmp297_;
						_tmp299_ = vala_data_type_get_type_symbol (_tmp298_);
						_tmp300_ = _tmp299_;
						base_symbol = (ValaSymbol*) _tmp300_;
					}
					_tmp301_ = vala_member_access_get_inner (self);
					_tmp302_ = _tmp301_;
					_tmp303_ = vala_expression_get_value_type (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp305_ = self->priv->_member_name;
					_tmp306_ = vala_data_type_get_member (_tmp304_, _tmp305_);
					_tmp307_ = _tmp306_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp307_);
					_vala_code_node_unref0 (_tmp307_);
				}
				_tmp308_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp309_ = _tmp308_;
				if (_tmp309_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp312_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp313_ = _tmp312_;
			if (_tmp313_ == NULL) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_value_type (_tmp315_);
				_tmp317_ = _tmp316_;
				_tmp311_ = _tmp317_ != NULL;
			} else {
				_tmp311_ = FALSE;
			}
			if (_tmp311_) {
				ValaExpression* _tmp318_;
				ValaExpression* _tmp319_;
				ValaDataType* _tmp320_;
				ValaDataType* _tmp321_;
				gboolean _tmp322_;
				gboolean _tmp323_;
				_tmp318_ = vala_member_access_get_inner (self);
				_tmp319_ = _tmp318_;
				_tmp320_ = vala_expression_get_value_type (_tmp319_);
				_tmp321_ = _tmp320_;
				_tmp322_ = vala_data_type_get_is_dynamic (_tmp321_);
				_tmp323_ = _tmp322_;
				_tmp310_ = _tmp323_;
			} else {
				_tmp310_ = FALSE;
			}
			if (_tmp310_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp324_;
				ValaExpression* _tmp325_;
				ValaDataType* _tmp326_;
				ValaDataType* _tmp327_;
				ValaObjectType* _tmp328_;
				ValaCodeNode* _tmp329_;
				ValaCodeNode* _tmp330_;
				ValaSymbol* _tmp467_;
				ValaSymbol* _tmp468_;
				ValaSymbol* _tmp517_;
				ValaSymbol* _tmp518_;
				_tmp324_ = vala_member_access_get_inner (self);
				_tmp325_ = _tmp324_;
				_tmp326_ = vala_expression_get_value_type (_tmp325_);
				_tmp327_ = _tmp326_;
				_tmp328_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp327_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp328_;
				_tmp329_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp330_ = _tmp329_;
				if (VALA_IS_METHOD_CALL (_tmp330_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp331_;
					ValaCodeNode* _tmp332_;
					ValaMethodCall* _tmp333_;
					ValaExpression* _tmp334_;
					ValaExpression* _tmp335_;
					_tmp331_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp332_ = _tmp331_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp332_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp333_ = invoc;
					_tmp334_ = vala_method_call_get_call (_tmp333_);
					_tmp335_ = _tmp334_;
					if (_tmp335_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp336_;
						ValaDataType* _tmp337_;
						ValaDataType* _tmp338_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp353_;
						ValaExpression* _tmp354_;
						ValaDataType* _tmp355_;
						ValaDataType* _tmp356_;
						const gchar* _tmp357_;
						ValaDataType* _tmp358_;
						ValaSourceReference* _tmp359_;
						ValaSourceReference* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaDynamicMethod* _tmp362_;
						ValaMethodCall* _tmp363_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp364_;
						ValaErrorType* _tmp365_;
						ValaDynamicMethod* _tmp366_;
						ValaErrorType* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaDynamicMethod* _tmp369_;
						ValaParameter* _tmp370_;
						ValaParameter* _tmp371_;
						ValaObjectType* _tmp372_;
						ValaTypeSymbol* _tmp373_;
						ValaTypeSymbol* _tmp374_;
						ValaScope* _tmp375_;
						ValaScope* _tmp376_;
						ValaDynamicMethod* _tmp377_;
						ValaDynamicMethod* _tmp378_;
						_tmp336_ = invoc;
						_tmp337_ = vala_expression_get_target_type ((ValaExpression*) _tmp336_);
						_tmp338_ = _tmp337_;
						if (_tmp338_ != NULL) {
							ValaMethodCall* _tmp339_;
							ValaDataType* _tmp340_;
							ValaDataType* _tmp341_;
							ValaDataType* _tmp342_;
							ValaDataType* _tmp343_;
							_tmp339_ = invoc;
							_tmp340_ = vala_expression_get_target_type ((ValaExpression*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_data_type_copy (_tmp341_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp342_;
							_tmp343_ = ret_type;
							vala_data_type_set_value_owned (_tmp343_, TRUE);
						} else {
							ValaMethodCall* _tmp344_;
							ValaCodeNode* _tmp345_;
							ValaCodeNode* _tmp346_;
							_tmp344_ = invoc;
							_tmp345_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp344_);
							_tmp346_ = _tmp345_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp346_)) {
								ValaVoidType* _tmp347_;
								_tmp347_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp347_;
							} else {
								ValaExpression* _tmp348_;
								ValaExpression* _tmp349_;
								ValaDataType* _tmp350_;
								ValaDataType* _tmp351_;
								ValaDataType* _tmp352_;
								_tmp348_ = vala_member_access_get_inner (self);
								_tmp349_ = _tmp348_;
								_tmp350_ = vala_expression_get_value_type (_tmp349_);
								_tmp351_ = _tmp350_;
								_tmp352_ = vala_data_type_copy (_tmp351_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp352_;
							}
						}
						_tmp353_ = vala_member_access_get_inner (self);
						_tmp354_ = _tmp353_;
						_tmp355_ = vala_expression_get_value_type (_tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = self->priv->_member_name;
						_tmp358_ = ret_type;
						_tmp359_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp360_ = _tmp359_;
						_tmp361_ = vala_dynamic_method_new (_tmp356_, _tmp357_, _tmp358_, _tmp360_, NULL);
						m = _tmp361_;
						_tmp362_ = m;
						_tmp363_ = invoc;
						vala_dynamic_method_set_invocation (_tmp362_, _tmp363_);
						_tmp364_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp364_;
						_tmp365_ = err;
						vala_error_type_set_dynamic_error (_tmp365_, TRUE);
						_tmp366_ = m;
						_tmp367_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp366_, (ValaDataType*) _tmp367_);
						_tmp368_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp368_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp369_ = m;
						_tmp370_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp371_ = _tmp370_;
						vala_callable_add_parameter ((ValaCallable*) _tmp369_, _tmp371_);
						_vala_code_node_unref0 (_tmp371_);
						_tmp372_ = dynamic_object_type;
						_tmp373_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = vala_symbol_get_scope ((ValaSymbol*) _tmp374_);
						_tmp376_ = _tmp375_;
						_tmp377_ = m;
						vala_scope_add (_tmp376_, NULL, (ValaSymbol*) _tmp377_);
						_tmp378_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp378_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp379_;
					ValaCodeNode* _tmp380_;
					_tmp379_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp380_ = _tmp379_;
					if (VALA_IS_ASSIGNMENT (_tmp380_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp381_;
						ValaCodeNode* _tmp382_;
						ValaAssignment* _tmp383_;
						ValaExpression* _tmp384_;
						ValaExpression* _tmp385_;
						_tmp381_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp382_ = _tmp381_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp382_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp383_ = a;
						_tmp384_ = vala_assignment_get_left (_tmp383_);
						_tmp385_ = _tmp384_;
						if (_tmp385_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp386_;
							ValaExpression* _tmp387_;
							ValaDataType* _tmp388_;
							ValaDataType* _tmp389_;
							const gchar* _tmp390_;
							ValaSourceReference* _tmp391_;
							ValaSourceReference* _tmp392_;
							ValaDynamicProperty* _tmp393_;
							ValaDynamicProperty* _tmp394_;
							ValaDynamicProperty* _tmp395_;
							ValaDynamicProperty* _tmp396_;
							ValaSourceReference* _tmp397_;
							ValaSourceReference* _tmp398_;
							ValaPropertyAccessor* _tmp399_;
							ValaPropertyAccessor* _tmp400_;
							ValaDynamicProperty* _tmp401_;
							ValaExpression* _tmp402_;
							ValaExpression* _tmp403_;
							ValaDataType* _tmp404_;
							ValaDataType* _tmp405_;
							ValaTypeSymbol* _tmp406_;
							ValaTypeSymbol* _tmp407_;
							ValaScope* _tmp408_;
							ValaScope* _tmp409_;
							ValaObjectType* _tmp410_;
							ValaTypeSymbol* _tmp411_;
							ValaTypeSymbol* _tmp412_;
							ValaScope* _tmp413_;
							ValaScope* _tmp414_;
							ValaDynamicProperty* _tmp415_;
							ValaDynamicProperty* _tmp416_;
							_tmp386_ = vala_member_access_get_inner (self);
							_tmp387_ = _tmp386_;
							_tmp388_ = vala_expression_get_value_type (_tmp387_);
							_tmp389_ = _tmp388_;
							_tmp390_ = self->priv->_member_name;
							_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp392_ = _tmp391_;
							_tmp393_ = vala_dynamic_property_new (_tmp389_, _tmp390_, _tmp392_, NULL);
							prop = _tmp393_;
							_tmp394_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp394_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp395_ = prop;
							_tmp396_ = prop;
							_tmp397_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp396_);
							_tmp398_ = _tmp397_;
							_tmp399_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp398_, NULL);
							_tmp400_ = _tmp399_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp395_, _tmp400_);
							_vala_code_node_unref0 (_tmp400_);
							_tmp401_ = prop;
							_tmp402_ = vala_member_access_get_inner (self);
							_tmp403_ = _tmp402_;
							_tmp404_ = vala_expression_get_value_type (_tmp403_);
							_tmp405_ = _tmp404_;
							_tmp406_ = vala_data_type_get_type_symbol (_tmp405_);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_symbol_get_scope ((ValaSymbol*) _tmp407_);
							_tmp409_ = _tmp408_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp401_, _tmp409_);
							_tmp410_ = dynamic_object_type;
							_tmp411_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp410_);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_symbol_get_scope ((ValaSymbol*) _tmp412_);
							_tmp414_ = _tmp413_;
							_tmp415_ = prop;
							vala_scope_add (_tmp414_, NULL, (ValaSymbol*) _tmp415_);
							_tmp416_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp416_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp417_ = FALSE;
						gboolean _tmp418_ = FALSE;
						ValaCodeNode* _tmp419_;
						ValaCodeNode* _tmp420_;
						_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp420_ = _tmp419_;
						if (VALA_IS_MEMBER_ACCESS (_tmp420_)) {
							ValaExpression* _tmp421_;
							ValaExpression* _tmp422_;
							_tmp421_ = vala_member_access_get_inner (self);
							_tmp422_ = _tmp421_;
							_tmp418_ = VALA_IS_MEMBER_ACCESS (_tmp422_);
						} else {
							_tmp418_ = FALSE;
						}
						if (_tmp418_) {
							ValaCodeNode* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							ValaCodeNode* _tmp426_;
							_tmp423_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp424_ = _tmp423_;
							_tmp425_ = vala_code_node_get_parent_node (_tmp424_);
							_tmp426_ = _tmp425_;
							_tmp417_ = VALA_IS_METHOD_CALL (_tmp426_);
						} else {
							_tmp417_ = FALSE;
						}
						if (_tmp417_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp427_;
							ValaCodeNode* _tmp428_;
							gboolean _tmp429_ = FALSE;
							ValaMemberAccess* _tmp430_;
							const gchar* _tmp431_;
							_tmp427_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp428_ = _tmp427_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp430_ = ma;
							_tmp431_ = _tmp430_->priv->_member_name;
							if (g_strcmp0 (_tmp431_, "connect") == 0) {
								_tmp429_ = TRUE;
							} else {
								ValaMemberAccess* _tmp432_;
								const gchar* _tmp433_;
								_tmp432_ = ma;
								_tmp433_ = _tmp432_->priv->_member_name;
								_tmp429_ = g_strcmp0 (_tmp433_, "connect_after") == 0;
							}
							if (_tmp429_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp434_;
								ValaExpression* _tmp435_;
								ValaDataType* _tmp436_;
								ValaDataType* _tmp437_;
								const gchar* _tmp438_;
								ValaVoidType* _tmp439_;
								ValaVoidType* _tmp440_;
								ValaSourceReference* _tmp441_;
								ValaSourceReference* _tmp442_;
								ValaDynamicSignal* _tmp443_;
								ValaDynamicSignal* _tmp444_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp445_;
								ValaCodeNode* _tmp446_;
								ValaCodeNode* _tmp447_;
								ValaCodeNode* _tmp448_;
								ValaMethodCall* _tmp449_;
								ValaMethodCall* _tmp450_;
								ValaList* _tmp451_;
								gint _tmp452_;
								gint _tmp453_;
								ValaDynamicSignal* _tmp459_;
								ValaObjectType* _tmp460_;
								ValaTypeSymbol* _tmp461_;
								ValaTypeSymbol* _tmp462_;
								ValaScope* _tmp463_;
								ValaScope* _tmp464_;
								ValaDynamicSignal* _tmp465_;
								ValaDynamicSignal* _tmp466_;
								_tmp434_ = vala_member_access_get_inner (self);
								_tmp435_ = _tmp434_;
								_tmp436_ = vala_expression_get_value_type (_tmp435_);
								_tmp437_ = _tmp436_;
								_tmp438_ = self->priv->_member_name;
								_tmp439_ = vala_void_type_new (NULL);
								_tmp440_ = _tmp439_;
								_tmp441_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp442_ = _tmp441_;
								_tmp443_ = vala_dynamic_signal_new (_tmp437_, _tmp438_, (ValaDataType*) _tmp440_, _tmp442_, NULL);
								_tmp444_ = _tmp443_;
								_vala_code_node_unref0 (_tmp440_);
								s = _tmp444_;
								_tmp445_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_code_node_get_parent_node (_tmp446_);
								_tmp448_ = _tmp447_;
								_tmp449_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp448_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp449_;
								_tmp450_ = mcall;
								_tmp451_ = vala_method_call_get_argument_list (_tmp450_);
								_tmp452_ = vala_collection_get_size ((ValaCollection*) _tmp451_);
								_tmp453_ = _tmp452_;
								if (_tmp453_ > 0) {
									ValaDynamicSignal* _tmp454_;
									ValaMethodCall* _tmp455_;
									ValaList* _tmp456_;
									gpointer _tmp457_;
									ValaExpression* _tmp458_;
									_tmp454_ = s;
									_tmp455_ = mcall;
									_tmp456_ = vala_method_call_get_argument_list (_tmp455_);
									_tmp457_ = vala_list_get (_tmp456_, 0);
									_tmp458_ = (ValaExpression*) _tmp457_;
									vala_dynamic_signal_set_handler (_tmp454_, _tmp458_);
									_vala_code_node_unref0 (_tmp458_);
								}
								_tmp459_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp459_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp460_ = dynamic_object_type;
								_tmp461_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp460_);
								_tmp462_ = _tmp461_;
								_tmp463_ = vala_symbol_get_scope ((ValaSymbol*) _tmp462_);
								_tmp464_ = _tmp463_;
								_tmp465_ = s;
								vala_scope_add (_tmp464_, NULL, (ValaSymbol*) _tmp465_);
								_tmp466_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp466_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp467_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp468_ = _tmp467_;
				if (_tmp468_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp469_;
					ValaExpression* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					const gchar* _tmp473_;
					ValaSourceReference* _tmp474_;
					ValaSourceReference* _tmp475_;
					ValaDynamicProperty* _tmp476_;
					ValaDataType* _tmp477_;
					ValaDataType* _tmp478_;
					ValaDynamicProperty* _tmp489_;
					ValaDynamicProperty* _tmp490_;
					ValaDynamicProperty* _tmp491_;
					ValaDataType* _tmp492_;
					ValaDataType* _tmp493_;
					ValaDataType* _tmp494_;
					ValaDataType* _tmp495_;
					ValaDynamicProperty* _tmp496_;
					ValaSourceReference* _tmp497_;
					ValaSourceReference* _tmp498_;
					ValaPropertyAccessor* _tmp499_;
					ValaPropertyAccessor* _tmp500_;
					ValaDynamicProperty* _tmp501_;
					ValaExpression* _tmp502_;
					ValaExpression* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDataType* _tmp505_;
					ValaTypeSymbol* _tmp506_;
					ValaTypeSymbol* _tmp507_;
					ValaScope* _tmp508_;
					ValaScope* _tmp509_;
					ValaObjectType* _tmp510_;
					ValaTypeSymbol* _tmp511_;
					ValaTypeSymbol* _tmp512_;
					ValaScope* _tmp513_;
					ValaScope* _tmp514_;
					ValaDynamicProperty* _tmp515_;
					ValaDynamicProperty* _tmp516_;
					_tmp469_ = vala_member_access_get_inner (self);
					_tmp470_ = _tmp469_;
					_tmp471_ = vala_expression_get_value_type (_tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = self->priv->_member_name;
					_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp475_ = _tmp474_;
					_tmp476_ = vala_dynamic_property_new (_tmp472_, _tmp473_, _tmp475_, NULL);
					prop = _tmp476_;
					_tmp477_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp478_ = _tmp477_;
					if (_tmp478_ != NULL) {
						ValaDynamicProperty* _tmp479_;
						ValaDataType* _tmp480_;
						ValaDataType* _tmp481_;
						_tmp479_ = prop;
						_tmp480_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp481_ = _tmp480_;
						vala_property_set_property_type ((ValaProperty*) _tmp479_, _tmp481_);
					} else {
						ValaDynamicProperty* _tmp482_;
						ValaExpression* _tmp483_;
						ValaExpression* _tmp484_;
						ValaDataType* _tmp485_;
						ValaDataType* _tmp486_;
						ValaDataType* _tmp487_;
						ValaDataType* _tmp488_;
						_tmp482_ = prop;
						_tmp483_ = vala_member_access_get_inner (self);
						_tmp484_ = _tmp483_;
						_tmp485_ = vala_expression_get_value_type (_tmp484_);
						_tmp486_ = _tmp485_;
						_tmp487_ = vala_data_type_copy (_tmp486_);
						_tmp488_ = _tmp487_;
						vala_property_set_property_type ((ValaProperty*) _tmp482_, _tmp488_);
						_vala_code_node_unref0 (_tmp488_);
					}
					_tmp489_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp489_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp490_ = prop;
					_tmp491_ = prop;
					_tmp492_ = vala_property_get_property_type ((ValaProperty*) _tmp491_);
					_tmp493_ = _tmp492_;
					_tmp494_ = vala_data_type_copy (_tmp493_);
					_tmp495_ = _tmp494_;
					_tmp496_ = prop;
					_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp495_, NULL, _tmp498_, NULL);
					_tmp500_ = _tmp499_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp490_, _tmp500_);
					_vala_code_node_unref0 (_tmp500_);
					_vala_code_node_unref0 (_tmp495_);
					_tmp501_ = prop;
					_tmp502_ = vala_member_access_get_inner (self);
					_tmp503_ = _tmp502_;
					_tmp504_ = vala_expression_get_value_type (_tmp503_);
					_tmp505_ = _tmp504_;
					_tmp506_ = vala_data_type_get_type_symbol (_tmp505_);
					_tmp507_ = _tmp506_;
					_tmp508_ = vala_symbol_get_scope ((ValaSymbol*) _tmp507_);
					_tmp509_ = _tmp508_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp501_, _tmp509_);
					_tmp510_ = dynamic_object_type;
					_tmp511_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp510_);
					_tmp512_ = _tmp511_;
					_tmp513_ = vala_symbol_get_scope ((ValaSymbol*) _tmp512_);
					_tmp514_ = _tmp513_;
					_tmp515_ = prop;
					vala_scope_add (_tmp514_, NULL, (ValaSymbol*) _tmp515_);
					_tmp516_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp516_);
					_vala_code_node_unref0 (prop);
				}
				_tmp517_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp518_ = _tmp517_;
				if (_tmp518_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp520_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp521_ = _tmp520_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp521_)) {
				ValaExpression* _tmp522_;
				ValaExpression* _tmp523_;
				ValaDataType* _tmp524_;
				ValaDataType* _tmp525_;
				_tmp522_ = vala_member_access_get_inner (self);
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_expression_get_value_type (_tmp523_);
				_tmp525_ = _tmp524_;
				_tmp519_ = VALA_IS_ARRAY_TYPE (_tmp525_);
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp526_;
				ValaExpression* _tmp527_;
				ValaDataType* _tmp528_;
				ValaDataType* _tmp529_;
				gboolean _tmp530_ = FALSE;
				ValaArrayType* _tmp531_;
				_tmp526_ = vala_member_access_get_inner (self);
				_tmp527_ = _tmp526_;
				_tmp528_ = vala_expression_get_value_type (_tmp527_);
				_tmp529_ = _tmp528_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp529_) ? ((ValaArrayType*) _tmp529_) : NULL;
				_tmp531_ = value_array_type;
				if (_tmp531_ != NULL) {
					ValaArrayType* _tmp532_;
					gboolean _tmp533_;
					gboolean _tmp534_;
					_tmp532_ = value_array_type;
					_tmp533_ = vala_array_type_get_inline_allocated (_tmp532_);
					_tmp534_ = _tmp533_;
					_tmp530_ = _tmp534_;
				} else {
					_tmp530_ = FALSE;
				}
				if (_tmp530_) {
					ValaSourceReference* _tmp535_;
					ValaSourceReference* _tmp536_;
					_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp536_ = _tmp535_;
					vala_report_error (_tmp536_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp540_ = vala_member_access_get_inner (self);
	_tmp541_ = _tmp540_;
	if (_tmp541_ == NULL) {
		ValaSymbol* _tmp542_;
		ValaSymbol* _tmp543_;
		_tmp542_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp543_ = _tmp542_;
		_tmp539_ = _tmp543_ == NULL;
	} else {
		_tmp539_ = FALSE;
	}
	if (_tmp539_) {
		ValaDataType* _tmp544_;
		ValaDataType* _tmp545_;
		_tmp544_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp545_ = _tmp544_;
		_tmp538_ = _tmp545_ != NULL;
	} else {
		_tmp538_ = FALSE;
	}
	if (_tmp538_) {
		ValaDataType* _tmp546_;
		ValaDataType* _tmp547_;
		ValaTypeSymbol* _tmp548_;
		ValaTypeSymbol* _tmp549_;
		_tmp546_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp547_ = _tmp546_;
		_tmp548_ = vala_data_type_get_type_symbol (_tmp547_);
		_tmp549_ = _tmp548_;
		_tmp537_ = VALA_IS_ENUM (_tmp549_);
	} else {
		_tmp537_ = FALSE;
	}
	if (_tmp537_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp550_;
		ValaDataType* _tmp551_;
		ValaTypeSymbol* _tmp552_;
		ValaTypeSymbol* _tmp553_;
		_tmp550_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp551_ = _tmp550_;
		_tmp552_ = vala_data_type_get_type_symbol (_tmp551_);
		_tmp553_ = _tmp552_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp553_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp554_;
			ValaList* _tmp555_;
			ValaList* _tmp556_;
			gint _val_size = 0;
			ValaList* _tmp557_;
			gint _tmp558_;
			gint _tmp559_;
			gint _val_index = 0;
			_tmp554_ = enum_type;
			_tmp555_ = vala_enum_get_values (_tmp554_);
			_tmp556_ = _vala_iterable_ref0 (_tmp555_);
			_val_list = _tmp556_;
			_tmp557_ = _val_list;
			_tmp558_ = vala_collection_get_size ((ValaCollection*) _tmp557_);
			_tmp559_ = _tmp558_;
			_val_size = _tmp559_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp560_;
				gpointer _tmp561_;
				const gchar* _tmp562_;
				ValaEnumValue* _tmp563_;
				const gchar* _tmp564_;
				const gchar* _tmp565_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp560_ = _val_list;
				_tmp561_ = vala_list_get (_tmp560_, _val_index);
				val = (ValaEnumValue*) _tmp561_;
				_tmp562_ = self->priv->_member_name;
				_tmp563_ = val;
				_tmp564_ = vala_symbol_get_name ((ValaSymbol*) _tmp563_);
				_tmp565_ = _tmp564_;
				if (g_strcmp0 (_tmp562_, _tmp565_) == 0) {
					ValaEnumValue* _tmp566_;
					_tmp566_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp566_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp568_ = _tmp567_;
	if (_tmp568_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp569_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp570_ = FALSE;
		ValaExpression* _tmp571_;
		ValaExpression* _tmp572_;
		gchar* base_type_package = NULL;
		gchar* _tmp592_;
		gboolean _tmp593_ = FALSE;
		ValaSymbol* _tmp594_;
		ValaSourceReference* _tmp609_;
		ValaSourceReference* _tmp610_;
		const gchar* _tmp611_;
		const gchar* _tmp612_;
		const gchar* _tmp613_;
		gchar* _tmp614_;
		gchar* _tmp615_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp569_ = g_strdup ("(null)");
		base_type_name = _tmp569_;
		base_type = NULL;
		_tmp571_ = vala_member_access_get_inner (self);
		_tmp572_ = _tmp571_;
		if (_tmp572_ != NULL) {
			ValaExpression* _tmp573_;
			ValaExpression* _tmp574_;
			ValaDataType* _tmp575_;
			ValaDataType* _tmp576_;
			_tmp573_ = vala_member_access_get_inner (self);
			_tmp574_ = _tmp573_;
			_tmp575_ = vala_expression_get_value_type (_tmp574_);
			_tmp576_ = _tmp575_;
			_tmp570_ = _tmp576_ != NULL;
		} else {
			_tmp570_ = FALSE;
		}
		if (_tmp570_) {
			ValaExpression* _tmp577_;
			ValaExpression* _tmp578_;
			ValaDataType* _tmp579_;
			ValaDataType* _tmp580_;
			gchar* _tmp581_;
			ValaExpression* _tmp582_;
			ValaExpression* _tmp583_;
			ValaDataType* _tmp584_;
			ValaDataType* _tmp585_;
			ValaTypeSymbol* _tmp586_;
			ValaTypeSymbol* _tmp587_;
			_tmp577_ = vala_member_access_get_inner (self);
			_tmp578_ = _tmp577_;
			_tmp579_ = vala_expression_get_value_type (_tmp578_);
			_tmp580_ = _tmp579_;
			_tmp581_ = vala_code_node_to_string ((ValaCodeNode*) _tmp580_);
			_g_free0 (base_type_name);
			base_type_name = _tmp581_;
			_tmp582_ = vala_member_access_get_inner (self);
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_expression_get_value_type (_tmp583_);
			_tmp585_ = _tmp584_;
			_tmp586_ = vala_data_type_get_type_symbol (_tmp585_);
			_tmp587_ = _tmp586_;
			base_type = (ValaSymbol*) _tmp587_;
		} else {
			ValaSymbol* _tmp588_;
			_tmp588_ = base_symbol;
			if (_tmp588_ != NULL) {
				ValaSymbol* _tmp589_;
				gchar* _tmp590_;
				ValaSymbol* _tmp591_;
				_tmp589_ = base_symbol;
				_tmp590_ = vala_symbol_get_full_name (_tmp589_);
				_g_free0 (base_type_name);
				base_type_name = _tmp590_;
				_tmp591_ = base_symbol;
				base_type = _tmp591_;
			}
		}
		_tmp592_ = g_strdup ("");
		base_type_package = _tmp592_;
		_tmp594_ = base_type;
		if (_tmp594_ != NULL) {
			ValaSymbol* _tmp595_;
			gboolean _tmp596_;
			gboolean _tmp597_;
			_tmp595_ = base_type;
			_tmp596_ = vala_symbol_get_external_package (_tmp595_);
			_tmp597_ = _tmp596_;
			_tmp593_ = _tmp597_;
		} else {
			_tmp593_ = FALSE;
		}
		if (_tmp593_) {
			ValaSymbol* _tmp598_;
			ValaSourceReference* _tmp599_;
			ValaSourceReference* _tmp600_;
			ValaSourceFile* _tmp601_;
			ValaSourceFile* _tmp602_;
			const gchar* _tmp603_;
			const gchar* _tmp604_;
			gchar* _tmp605_;
			const gchar* _tmp606_;
			_tmp598_ = base_symbol;
			_tmp599_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp598_);
			_tmp600_ = _tmp599_;
			_tmp601_ = vala_source_reference_get_file (_tmp600_);
			_tmp602_ = _tmp601_;
			_tmp603_ = vala_source_file_get_package_name (_tmp602_);
			_tmp604_ = _tmp603_;
			_tmp605_ = g_strdup (_tmp604_);
			_g_free0 (base_type_package);
			base_type_package = _tmp605_;
			_tmp606_ = base_type_package;
			if (_tmp606_ != NULL) {
				const gchar* _tmp607_;
				gchar* _tmp608_;
				_tmp607_ = base_type_package;
				_tmp608_ = g_strdup_printf (" (%s)", _tmp607_);
				_g_free0 (base_type_package);
				base_type_package = _tmp608_;
			}
		}
		_tmp609_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp610_ = _tmp609_;
		_tmp611_ = self->priv->_member_name;
		_tmp612_ = base_type_name;
		_tmp613_ = base_type_package;
		_tmp614_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp611_, _tmp612_, _tmp613_);
		_tmp615_ = _tmp614_;
		vala_report_error (_tmp610_, _tmp615_);
		_g_free0 (_tmp615_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	}
	_tmp616_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp617_ = _tmp616_;
	member = _tmp617_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp618_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp618_, context)) {
		result = FALSE;
		return result;
	}
	_tmp619_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp619_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp620_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp621_;
		ValaSymbol* _tmp622_;
		ValaSymbol* _tmp623_;
		gboolean _tmp624_ = FALSE;
		ValaBlock* _tmp625_;
		_tmp620_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp620_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp621_ = local;
		_tmp622_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp621_);
		_tmp623_ = _tmp622_;
		block = VALA_IS_BLOCK (_tmp623_) ? ((ValaBlock*) _tmp623_) : NULL;
		_tmp625_ = block;
		if (_tmp625_ != NULL) {
			ValaBlock* _tmp626_;
			ValaSymbol* _tmp627_;
			ValaSemanticAnalyzer* _tmp628_;
			ValaSemanticAnalyzer* _tmp629_;
			ValaSymbol* _tmp630_;
			ValaSymbol* _tmp631_;
			_tmp626_ = block;
			_tmp627_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp626_);
			_tmp628_ = vala_code_context_get_analyzer (context);
			_tmp629_ = _tmp628_;
			_tmp630_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp624_ = _tmp627_ != _tmp631_;
		} else {
			_tmp624_ = FALSE;
		}
		if (_tmp624_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp632_;
			ValaSemanticAnalyzer* _tmp633_;
			ValaSymbol* _tmp634_;
			ValaSymbol* _tmp635_;
			ValaLocalVariable* _tmp646_;
			ValaBlock* _tmp647_;
			_tmp632_ = vala_code_context_get_analyzer (context);
			_tmp633_ = _tmp632_;
			_tmp634_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp633_);
			_tmp635_ = _tmp634_;
			sym = _tmp635_;
			while (TRUE) {
				ValaSymbol* _tmp636_;
				ValaBlock* _tmp637_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp638_;
				ValaMethod* _tmp639_;
				ValaSymbol* _tmp643_;
				ValaSymbol* _tmp644_;
				ValaSymbol* _tmp645_;
				_tmp636_ = sym;
				_tmp637_ = block;
				if (!(_tmp636_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp637_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp638_ = sym;
				method = VALA_IS_METHOD (_tmp638_) ? ((ValaMethod*) _tmp638_) : NULL;
				_tmp639_ = method;
				if (_tmp639_ != NULL) {
					ValaMethod* _tmp640_;
					ValaMethod* _tmp641_;
					ValaLocalVariable* _tmp642_;
					_tmp640_ = method;
					vala_method_set_closure (_tmp640_, TRUE);
					_tmp641_ = method;
					_tmp642_ = local;
					vala_method_add_captured_variable (_tmp641_, _tmp642_);
				}
				_tmp643_ = sym;
				_tmp644_ = vala_symbol_get_parent_symbol (_tmp643_);
				_tmp645_ = _tmp644_;
				sym = _tmp645_;
			}
			_tmp646_ = local;
			vala_local_variable_set_captured (_tmp646_, TRUE);
			_tmp647_ = block;
			vala_block_set_captured (_tmp647_, TRUE);
		}
	} else {
		ValaSymbol* _tmp648_;
		_tmp648_ = member;
		if (VALA_IS_PARAMETER (_tmp648_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp649_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp650_;
			ValaSymbol* _tmp651_;
			ValaSymbol* _tmp652_;
			gboolean _tmp653_ = FALSE;
			gboolean _tmp654_ = FALSE;
			ValaMethod* _tmp655_;
			_tmp649_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp649_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp650_ = param;
			_tmp651_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp650_);
			_tmp652_ = _tmp651_;
			m = VALA_IS_METHOD (_tmp652_) ? ((ValaMethod*) _tmp652_) : NULL;
			_tmp655_ = m;
			if (_tmp655_ != NULL) {
				ValaMethod* _tmp656_;
				ValaSemanticAnalyzer* _tmp657_;
				ValaSemanticAnalyzer* _tmp658_;
				ValaSymbol* _tmp659_;
				ValaSymbol* _tmp660_;
				_tmp656_ = m;
				_tmp657_ = vala_code_context_get_analyzer (context);
				_tmp658_ = _tmp657_;
				_tmp659_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp658_);
				_tmp660_ = _tmp659_;
				_tmp654_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp656_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp660_;
			} else {
				_tmp654_ = FALSE;
			}
			if (_tmp654_) {
				ValaParameter* _tmp661_;
				ValaMethod* _tmp662_;
				ValaParameter* _tmp663_;
				ValaParameter* _tmp664_;
				_tmp661_ = param;
				_tmp662_ = m;
				_tmp663_ = vala_method_get_this_parameter (_tmp662_);
				_tmp664_ = _tmp663_;
				_tmp653_ = _tmp661_ != _tmp664_;
			} else {
				_tmp653_ = FALSE;
			}
			if (_tmp653_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp665_;
				ValaSemanticAnalyzer* _tmp666_;
				ValaSymbol* _tmp667_;
				ValaSymbol* _tmp668_;
				ValaParameter* _tmp677_;
				ValaMethod* _tmp678_;
				ValaBlock* _tmp679_;
				ValaBlock* _tmp680_;
				ValaParameter* _tmp681_;
				ValaParameterDirection _tmp682_;
				ValaParameterDirection _tmp683_;
				_tmp665_ = vala_code_context_get_analyzer (context);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp666_);
				_tmp668_ = _tmp667_;
				sym = _tmp668_;
				while (TRUE) {
					ValaSymbol* _tmp669_;
					ValaMethod* _tmp670_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp671_;
					ValaMethod* _tmp672_;
					ValaSymbol* _tmp674_;
					ValaSymbol* _tmp675_;
					ValaSymbol* _tmp676_;
					_tmp669_ = sym;
					_tmp670_ = m;
					if (!(_tmp669_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp670_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp671_ = sym;
					method = VALA_IS_METHOD (_tmp671_) ? ((ValaMethod*) _tmp671_) : NULL;
					_tmp672_ = method;
					if (_tmp672_ != NULL) {
						ValaMethod* _tmp673_;
						_tmp673_ = method;
						vala_method_set_closure (_tmp673_, TRUE);
					}
					_tmp674_ = sym;
					_tmp675_ = vala_symbol_get_parent_symbol (_tmp674_);
					_tmp676_ = _tmp675_;
					sym = _tmp676_;
				}
				_tmp677_ = param;
				vala_parameter_set_captured (_tmp677_, TRUE);
				_tmp678_ = m;
				_tmp679_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp678_);
				_tmp680_ = _tmp679_;
				vala_block_set_captured (_tmp680_, TRUE);
				_tmp681_ = param;
				_tmp682_ = vala_parameter_get_direction (_tmp681_);
				_tmp683_ = _tmp682_;
				if (_tmp683_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp684_;
					ValaSourceReference* _tmp685_;
					ValaParameter* _tmp686_;
					gchar* _tmp687_;
					gchar* _tmp688_;
					gchar* _tmp689_;
					gchar* _tmp690_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp684_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp685_ = _tmp684_;
					_tmp686_ = param;
					_tmp687_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp686_);
					_tmp688_ = _tmp687_;
					_tmp689_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp688_);
					_tmp690_ = _tmp689_;
					vala_report_error (_tmp685_, _tmp690_);
					_g_free0 (_tmp690_);
					_g_free0 (_tmp688_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp691_;
				ValaSymbol* _tmp692_;
				ValaSymbol* _tmp693_;
				ValaSymbol* _tmp694_;
				ValaSymbol* _tmp695_;
				gboolean _tmp696_ = FALSE;
				gboolean _tmp697_ = FALSE;
				ValaPropertyAccessor* _tmp698_;
				_tmp691_ = param;
				_tmp692_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp691_);
				_tmp693_ = _tmp692_;
				_tmp694_ = vala_symbol_get_parent_symbol (_tmp693_);
				_tmp695_ = _tmp694_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp695_) ? ((ValaPropertyAccessor*) _tmp695_) : NULL;
				_tmp698_ = acc;
				if (_tmp698_ != NULL) {
					ValaPropertyAccessor* _tmp699_;
					ValaSemanticAnalyzer* _tmp700_;
					ValaSemanticAnalyzer* _tmp701_;
					ValaSymbol* _tmp702_;
					ValaSymbol* _tmp703_;
					_tmp699_ = acc;
					_tmp700_ = vala_code_context_get_analyzer (context);
					_tmp701_ = _tmp700_;
					_tmp702_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp701_);
					_tmp703_ = _tmp702_;
					_tmp697_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp699_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp703_;
				} else {
					_tmp697_ = FALSE;
				}
				if (_tmp697_) {
					ValaParameter* _tmp704_;
					ValaPropertyAccessor* _tmp705_;
					ValaProperty* _tmp706_;
					ValaProperty* _tmp707_;
					ValaParameter* _tmp708_;
					ValaParameter* _tmp709_;
					_tmp704_ = param;
					_tmp705_ = acc;
					_tmp706_ = vala_property_accessor_get_prop (_tmp705_);
					_tmp707_ = _tmp706_;
					_tmp708_ = vala_property_get_this_parameter (_tmp707_);
					_tmp709_ = _tmp708_;
					_tmp696_ = _tmp704_ != _tmp709_;
				} else {
					_tmp696_ = FALSE;
				}
				if (_tmp696_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp710_;
					ValaSemanticAnalyzer* _tmp711_;
					ValaSymbol* _tmp712_;
					ValaSymbol* _tmp713_;
					ValaParameter* _tmp722_;
					ValaPropertyAccessor* _tmp723_;
					ValaBlock* _tmp724_;
					ValaBlock* _tmp725_;
					_tmp710_ = vala_code_context_get_analyzer (context);
					_tmp711_ = _tmp710_;
					_tmp712_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp711_);
					_tmp713_ = _tmp712_;
					sym = _tmp713_;
					while (TRUE) {
						ValaSymbol* _tmp714_;
						ValaMethod* _tmp715_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp716_;
						ValaMethod* _tmp717_;
						ValaSymbol* _tmp719_;
						ValaSymbol* _tmp720_;
						ValaSymbol* _tmp721_;
						_tmp714_ = sym;
						_tmp715_ = m;
						if (!(_tmp714_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp715_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp716_ = sym;
						method = VALA_IS_METHOD (_tmp716_) ? ((ValaMethod*) _tmp716_) : NULL;
						_tmp717_ = method;
						if (_tmp717_ != NULL) {
							ValaMethod* _tmp718_;
							_tmp718_ = method;
							vala_method_set_closure (_tmp718_, TRUE);
						}
						_tmp719_ = sym;
						_tmp720_ = vala_symbol_get_parent_symbol (_tmp719_);
						_tmp721_ = _tmp720_;
						sym = _tmp721_;
					}
					_tmp722_ = param;
					vala_parameter_set_captured (_tmp722_, TRUE);
					_tmp723_ = acc;
					_tmp724_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp723_);
					_tmp725_ = _tmp724_;
					vala_block_set_captured (_tmp725_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp726_;
			_tmp726_ = member;
			if (VALA_IS_FIELD (_tmp726_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp727_;
				ValaField* _tmp728_;
				ValaSymbolAccessibility _tmp729_;
				ValaSymbolAccessibility _tmp730_;
				ValaField* _tmp731_;
				ValaMemberBinding _tmp732_;
				ValaMemberBinding _tmp733_;
				ValaField* _tmp734_;
				ValaMemberBinding _tmp735_;
				ValaMemberBinding _tmp736_;
				ValaField* _tmp737_;
				ValaDataType* _tmp738_;
				ValaDataType* _tmp739_;
				_tmp727_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp727_, VALA_TYPE_FIELD, ValaField);
				_tmp728_ = f;
				_tmp729_ = vala_symbol_get_access ((ValaSymbol*) _tmp728_);
				_tmp730_ = _tmp729_;
				access = _tmp730_;
				_tmp731_ = f;
				_tmp732_ = vala_field_get_binding (_tmp731_);
				_tmp733_ = _tmp732_;
				instance = _tmp733_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp734_ = f;
				_tmp735_ = vala_field_get_binding (_tmp734_);
				_tmp736_ = _tmp735_;
				klass = _tmp736_ == VALA_MEMBER_BINDING_CLASS;
				_tmp737_ = f;
				_tmp738_ = vala_variable_get_variable_type ((ValaVariable*) _tmp737_);
				_tmp739_ = _tmp738_;
				if (VALA_IS_GENERIC_TYPE (_tmp739_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp740_;
				_tmp740_ = member;
				if (VALA_IS_CONSTANT (_tmp740_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp741_;
					ValaConstant* _tmp742_;
					ValaSymbolAccessibility _tmp743_;
					ValaSymbolAccessibility _tmp744_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp745_;
					ValaSymbol* _tmp746_;
					ValaSymbol* _tmp747_;
					gboolean _tmp748_ = FALSE;
					ValaBlock* _tmp749_;
					_tmp741_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp741_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp742_ = c;
					_tmp743_ = vala_symbol_get_access ((ValaSymbol*) _tmp742_);
					_tmp744_ = _tmp743_;
					access = _tmp744_;
					_tmp745_ = c;
					_tmp746_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp745_);
					_tmp747_ = _tmp746_;
					block = VALA_IS_BLOCK (_tmp747_) ? ((ValaBlock*) _tmp747_) : NULL;
					_tmp749_ = block;
					if (_tmp749_ != NULL) {
						ValaBlock* _tmp750_;
						ValaSymbol* _tmp751_;
						ValaSemanticAnalyzer* _tmp752_;
						ValaSemanticAnalyzer* _tmp753_;
						ValaSymbol* _tmp754_;
						ValaSymbol* _tmp755_;
						_tmp750_ = block;
						_tmp751_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp750_);
						_tmp752_ = vala_code_context_get_analyzer (context);
						_tmp753_ = _tmp752_;
						_tmp754_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp753_);
						_tmp755_ = _tmp754_;
						_tmp748_ = _tmp751_ != _tmp755_;
					} else {
						_tmp748_ = FALSE;
					}
					if (_tmp748_) {
						ValaSourceReference* _tmp756_;
						ValaSourceReference* _tmp757_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp756_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp757_ = _tmp756_;
						vala_report_error (_tmp757_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp758_;
					_tmp758_ = member;
					if (VALA_IS_METHOD (_tmp758_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp759_;
						ValaMethod* _tmp760_;
						gboolean _tmp761_;
						gboolean _tmp762_;
						ValaMethod* _tmp851_;
						ValaSymbolAccessibility _tmp852_;
						ValaSymbolAccessibility _tmp853_;
						ValaMethod* _tmp854_;
						ValaMethod* _tmp858_;
						ValaMemberBinding _tmp859_;
						ValaMemberBinding _tmp860_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp879_;
						ValaDataType* _tmp880_;
						ValaDataType* _tmp881_;
						gboolean _tmp882_ = FALSE;
						ValaGenericType* _tmp883_;
						_tmp759_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp759_, VALA_TYPE_METHOD, ValaMethod);
						_tmp760_ = m;
						_tmp761_ = vala_method_get_is_async_callback (_tmp760_);
						_tmp762_ = _tmp761_;
						if (_tmp762_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp763_;
							ValaSemanticAnalyzer* _tmp764_;
							ValaMethod* _tmp765_;
							ValaMethod* _tmp766_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp767_;
							ValaMethod* _tmp796_;
							ValaSemanticAnalyzer* _tmp797_;
							ValaSemanticAnalyzer* _tmp798_;
							ValaMethod* _tmp799_;
							ValaMethod* _tmp800_;
							ValaMethod* _tmp816_;
							ValaMethod* _tmp817_;
							ValaMethod* _tmp818_;
							ValaSymbol* _tmp819_;
							ValaSymbol* _tmp820_;
							_tmp763_ = vala_code_context_get_analyzer (context);
							_tmp764_ = _tmp763_;
							_tmp765_ = vala_semantic_analyzer_get_current_async_method (_tmp764_);
							_tmp766_ = _tmp765_;
							async_method = _tmp766_;
							is_valid_access = FALSE;
							_tmp767_ = async_method;
							if (_tmp767_ != NULL) {
								ValaMethod* _tmp768_;
								ValaMethod* _tmp769_;
								ValaMethod* _tmp770_;
								_tmp768_ = m;
								_tmp769_ = async_method;
								_tmp770_ = vala_method_get_callback_method (_tmp769_);
								if (_tmp768_ == _tmp770_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp771_ = FALSE;
									ValaMethod* _tmp772_;
									ValaMethod* _tmp773_;
									ValaMethod* _tmp774_;
									_tmp772_ = async_method;
									_tmp773_ = vala_method_get_base_method (_tmp772_);
									_tmp774_ = _tmp773_;
									if (_tmp774_ != NULL) {
										ValaMethod* _tmp775_;
										ValaMethod* _tmp776_;
										ValaMethod* _tmp777_;
										ValaMethod* _tmp778_;
										ValaMethod* _tmp779_;
										_tmp775_ = m;
										_tmp776_ = async_method;
										_tmp777_ = vala_method_get_base_method (_tmp776_);
										_tmp778_ = _tmp777_;
										_tmp779_ = vala_method_get_callback_method (_tmp778_);
										_tmp771_ = _tmp775_ == _tmp779_;
									} else {
										_tmp771_ = FALSE;
									}
									if (_tmp771_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp780_ = FALSE;
										ValaMethod* _tmp781_;
										ValaMethod* _tmp782_;
										ValaMethod* _tmp783_;
										_tmp781_ = async_method;
										_tmp782_ = vala_method_get_base_interface_method (_tmp781_);
										_tmp783_ = _tmp782_;
										if (_tmp783_ != NULL) {
											ValaMethod* _tmp784_;
											ValaMethod* _tmp785_;
											ValaMethod* _tmp786_;
											ValaMethod* _tmp787_;
											ValaMethod* _tmp788_;
											_tmp784_ = m;
											_tmp785_ = async_method;
											_tmp786_ = vala_method_get_base_interface_method (_tmp785_);
											_tmp787_ = _tmp786_;
											_tmp788_ = vala_method_get_callback_method (_tmp787_);
											_tmp780_ = _tmp784_ == _tmp788_;
										} else {
											_tmp780_ = FALSE;
										}
										if (_tmp780_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp789_;
								ValaSourceReference* _tmp790_;
								ValaMethod* _tmp791_;
								gchar* _tmp792_;
								gchar* _tmp793_;
								gchar* _tmp794_;
								gchar* _tmp795_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp789_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp790_ = _tmp789_;
								_tmp791_ = m;
								_tmp792_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp791_);
								_tmp793_ = _tmp792_;
								_tmp794_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp793_);
								_tmp795_ = _tmp794_;
								vala_report_error (_tmp790_, _tmp795_);
								_g_free0 (_tmp795_);
								_g_free0 (_tmp793_);
								result = FALSE;
								return result;
							}
							_tmp796_ = async_method;
							_tmp797_ = vala_code_context_get_analyzer (context);
							_tmp798_ = _tmp797_;
							_tmp799_ = vala_semantic_analyzer_get_current_method (_tmp798_);
							_tmp800_ = _tmp799_;
							if (_tmp796_ != _tmp800_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp801_;
								ValaSemanticAnalyzer* _tmp802_;
								ValaMethod* _tmp803_;
								ValaMethod* _tmp804_;
								ValaMethod* _tmp813_;
								ValaBlock* _tmp814_;
								ValaBlock* _tmp815_;
								_tmp801_ = vala_code_context_get_analyzer (context);
								_tmp802_ = _tmp801_;
								_tmp803_ = vala_semantic_analyzer_get_current_method (_tmp802_);
								_tmp804_ = _tmp803_;
								sym = (ValaSymbol*) _tmp804_;
								while (TRUE) {
									ValaSymbol* _tmp805_;
									ValaMethod* _tmp806_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp807_;
									ValaMethod* _tmp808_;
									ValaSymbol* _tmp810_;
									ValaSymbol* _tmp811_;
									ValaSymbol* _tmp812_;
									_tmp805_ = sym;
									_tmp806_ = async_method;
									if (!(_tmp805_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp806_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp807_ = sym;
									method = VALA_IS_METHOD (_tmp807_) ? ((ValaMethod*) _tmp807_) : NULL;
									_tmp808_ = method;
									if (_tmp808_ != NULL) {
										ValaMethod* _tmp809_;
										_tmp809_ = method;
										vala_method_set_closure (_tmp809_, TRUE);
									}
									_tmp810_ = sym;
									_tmp811_ = vala_symbol_get_parent_symbol (_tmp810_);
									_tmp812_ = _tmp811_;
									sym = _tmp812_;
								}
								_tmp813_ = async_method;
								_tmp814_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp813_);
								_tmp815_ = _tmp814_;
								vala_block_set_captured (_tmp815_, TRUE);
							}
							_tmp816_ = async_method;
							_tmp817_ = vala_method_get_callback_method (_tmp816_);
							m = _tmp817_;
							_tmp818_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp818_);
							_tmp819_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp820_ = _tmp819_;
							member = _tmp820_;
						} else {
							ValaMethod* _tmp821_;
							ValaMethod* _tmp822_;
							ValaMethod* _tmp823_;
							_tmp821_ = m;
							_tmp822_ = vala_method_get_base_method (_tmp821_);
							_tmp823_ = _tmp822_;
							if (_tmp823_ != NULL) {
								ValaMethod* _tmp824_;
								ValaMethod* _tmp825_;
								ValaMethod* _tmp826_;
								ValaMethod* _tmp827_;
								ValaSignal* _tmp828_;
								ValaSignal* _tmp829_;
								ValaSymbol* _tmp834_;
								ValaSymbol* _tmp835_;
								_tmp824_ = m;
								_tmp825_ = vala_method_get_base_method (_tmp824_);
								_tmp826_ = _tmp825_;
								m = _tmp826_;
								_tmp827_ = m;
								_tmp828_ = vala_method_get_signal_reference (_tmp827_);
								_tmp829_ = _tmp828_;
								if (_tmp829_ != NULL) {
									ValaMethod* _tmp830_;
									ValaSignal* _tmp831_;
									ValaSignal* _tmp832_;
									_tmp830_ = m;
									_tmp831_ = vala_method_get_signal_reference (_tmp830_);
									_tmp832_ = _tmp831_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp832_);
								} else {
									ValaMethod* _tmp833_;
									_tmp833_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp833_);
								}
								_tmp834_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp835_ = _tmp834_;
								member = _tmp835_;
							} else {
								ValaMethod* _tmp836_;
								ValaMethod* _tmp837_;
								ValaMethod* _tmp838_;
								_tmp836_ = m;
								_tmp837_ = vala_method_get_base_interface_method (_tmp836_);
								_tmp838_ = _tmp837_;
								if (_tmp838_ != NULL) {
									ValaMethod* _tmp839_;
									ValaMethod* _tmp840_;
									ValaMethod* _tmp841_;
									ValaMethod* _tmp842_;
									ValaSignal* _tmp843_;
									ValaSignal* _tmp844_;
									ValaSymbol* _tmp849_;
									ValaSymbol* _tmp850_;
									_tmp839_ = m;
									_tmp840_ = vala_method_get_base_interface_method (_tmp839_);
									_tmp841_ = _tmp840_;
									m = _tmp841_;
									_tmp842_ = m;
									_tmp843_ = vala_method_get_signal_reference (_tmp842_);
									_tmp844_ = _tmp843_;
									if (_tmp844_ != NULL) {
										ValaMethod* _tmp845_;
										ValaSignal* _tmp846_;
										ValaSignal* _tmp847_;
										_tmp845_ = m;
										_tmp846_ = vala_method_get_signal_reference (_tmp845_);
										_tmp847_ = _tmp846_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp847_);
									} else {
										ValaMethod* _tmp848_;
										_tmp848_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp848_);
									}
									_tmp849_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp850_ = _tmp849_;
									member = _tmp850_;
								}
							}
						}
						_tmp851_ = m;
						_tmp852_ = vala_symbol_get_access ((ValaSymbol*) _tmp851_);
						_tmp853_ = _tmp852_;
						access = _tmp853_;
						_tmp854_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp854_)) {
							ValaMethod* _tmp855_;
							ValaMemberBinding _tmp856_;
							ValaMemberBinding _tmp857_;
							_tmp855_ = m;
							_tmp856_ = vala_method_get_binding (_tmp855_);
							_tmp857_ = _tmp856_;
							instance = _tmp857_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp858_ = m;
						_tmp859_ = vala_method_get_binding (_tmp858_);
						_tmp860_ = _tmp859_;
						klass = _tmp860_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp861_;
							ValaList* _tmp862_;
							ValaList* _tmp863_;
							gint _param_size = 0;
							ValaList* _tmp864_;
							gint _tmp865_;
							gint _tmp866_;
							gint _param_index = 0;
							_tmp861_ = m;
							_tmp862_ = vala_callable_get_parameters ((ValaCallable*) _tmp861_);
							_tmp863_ = _vala_iterable_ref0 (_tmp862_);
							_param_list = _tmp863_;
							_tmp864_ = _param_list;
							_tmp865_ = vala_collection_get_size ((ValaCollection*) _tmp864_);
							_tmp866_ = _tmp865_;
							_param_size = _tmp866_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp867_;
								gpointer _tmp868_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp869_;
								ValaDataType* _tmp870_;
								ValaDataType* _tmp871_;
								gboolean _tmp872_ = FALSE;
								ValaGenericType* _tmp873_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp867_ = _param_list;
								_tmp868_ = vala_list_get (_tmp867_, _param_index);
								param = (ValaParameter*) _tmp868_;
								_tmp869_ = param;
								_tmp870_ = vala_variable_get_variable_type ((ValaVariable*) _tmp869_);
								_tmp871_ = _tmp870_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp871_) ? ((ValaGenericType*) _tmp871_) : NULL;
								_tmp873_ = generic_type;
								if (_tmp873_ != NULL) {
									ValaGenericType* _tmp874_;
									ValaTypeParameter* _tmp875_;
									ValaTypeParameter* _tmp876_;
									ValaSymbol* _tmp877_;
									ValaSymbol* _tmp878_;
									_tmp874_ = generic_type;
									_tmp875_ = vala_generic_type_get_type_parameter (_tmp874_);
									_tmp876_ = _tmp875_;
									_tmp877_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp876_);
									_tmp878_ = _tmp877_;
									_tmp872_ = VALA_IS_TYPESYMBOL (_tmp878_);
								} else {
									_tmp872_ = FALSE;
								}
								if (_tmp872_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp879_ = m;
						_tmp880_ = vala_callable_get_return_type ((ValaCallable*) _tmp879_);
						_tmp881_ = _tmp880_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp881_) ? ((ValaGenericType*) _tmp881_) : NULL;
						_tmp883_ = generic_type;
						if (_tmp883_ != NULL) {
							ValaGenericType* _tmp884_;
							ValaTypeParameter* _tmp885_;
							ValaTypeParameter* _tmp886_;
							ValaSymbol* _tmp887_;
							ValaSymbol* _tmp888_;
							_tmp884_ = generic_type;
							_tmp885_ = vala_generic_type_get_type_parameter (_tmp884_);
							_tmp886_ = _tmp885_;
							_tmp887_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp886_);
							_tmp888_ = _tmp887_;
							_tmp882_ = VALA_IS_TYPESYMBOL (_tmp888_);
						} else {
							_tmp882_ = FALSE;
						}
						if (_tmp882_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp889_;
						_tmp889_ = member;
						if (VALA_IS_PROPERTY (_tmp889_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp890_;
							ValaProperty* _tmp891_;
							ValaProperty* _tmp892_;
							ValaProperty* _tmp893_;
							ValaProperty* _tmp894_;
							ValaProperty* _tmp910_;
							ValaSymbolAccessibility _tmp911_;
							ValaSymbolAccessibility _tmp912_;
							gboolean _tmp913_;
							gboolean _tmp914_;
							ValaProperty* _tmp979_;
							ValaMemberBinding _tmp980_;
							ValaMemberBinding _tmp981_;
							ValaProperty* _tmp982_;
							ValaDataType* _tmp983_;
							ValaDataType* _tmp984_;
							_tmp890_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp890_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp891_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp891_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp892_ = prop;
							_tmp893_ = vala_property_get_base_property (_tmp892_);
							_tmp894_ = _tmp893_;
							if (_tmp894_ != NULL) {
								ValaProperty* _tmp895_;
								ValaProperty* _tmp896_;
								ValaProperty* _tmp897_;
								ValaProperty* _tmp898_;
								ValaSymbol* _tmp899_;
								ValaSymbol* _tmp900_;
								_tmp895_ = prop;
								_tmp896_ = vala_property_get_base_property (_tmp895_);
								_tmp897_ = _tmp896_;
								prop = _tmp897_;
								_tmp898_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp898_);
								_tmp899_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp900_ = _tmp899_;
								member = _tmp900_;
							} else {
								ValaProperty* _tmp901_;
								ValaProperty* _tmp902_;
								ValaProperty* _tmp903_;
								_tmp901_ = prop;
								_tmp902_ = vala_property_get_base_interface_property (_tmp901_);
								_tmp903_ = _tmp902_;
								if (_tmp903_ != NULL) {
									ValaProperty* _tmp904_;
									ValaProperty* _tmp905_;
									ValaProperty* _tmp906_;
									ValaProperty* _tmp907_;
									ValaSymbol* _tmp908_;
									ValaSymbol* _tmp909_;
									_tmp904_ = prop;
									_tmp905_ = vala_property_get_base_interface_property (_tmp904_);
									_tmp906_ = _tmp905_;
									prop = _tmp906_;
									_tmp907_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp907_);
									_tmp908_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp909_ = _tmp908_;
									member = _tmp909_;
								}
							}
							_tmp910_ = prop;
							_tmp911_ = vala_symbol_get_access ((ValaSymbol*) _tmp910_);
							_tmp912_ = _tmp911_;
							access = _tmp912_;
							_tmp913_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp914_ = _tmp913_;
							if (_tmp914_) {
								ValaProperty* _tmp915_;
								ValaPropertyAccessor* _tmp916_;
								ValaPropertyAccessor* _tmp917_;
								ValaProperty* _tmp925_;
								ValaSymbolAccessibility _tmp926_;
								ValaSymbolAccessibility _tmp927_;
								_tmp915_ = prop;
								_tmp916_ = vala_property_get_set_accessor (_tmp915_);
								_tmp917_ = _tmp916_;
								if (_tmp917_ == NULL) {
									ValaSourceReference* _tmp918_;
									ValaSourceReference* _tmp919_;
									ValaProperty* _tmp920_;
									gchar* _tmp921_;
									gchar* _tmp922_;
									gchar* _tmp923_;
									gchar* _tmp924_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp918_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp919_ = _tmp918_;
									_tmp920_ = prop;
									_tmp921_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp920_);
									_tmp922_ = _tmp921_;
									_tmp923_ = g_strdup_printf ("Property `%s' is read-only", _tmp922_);
									_tmp924_ = _tmp923_;
									vala_report_error (_tmp919_, _tmp924_);
									_g_free0 (_tmp924_);
									_g_free0 (_tmp922_);
									result = FALSE;
									return result;
								}
								_tmp925_ = prop;
								_tmp926_ = vala_symbol_get_access ((ValaSymbol*) _tmp925_);
								_tmp927_ = _tmp926_;
								if (_tmp927_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp928_;
									ValaPropertyAccessor* _tmp929_;
									ValaPropertyAccessor* _tmp930_;
									ValaSymbolAccessibility _tmp931_;
									ValaSymbolAccessibility _tmp932_;
									_tmp928_ = prop;
									_tmp929_ = vala_property_get_set_accessor (_tmp928_);
									_tmp930_ = _tmp929_;
									_tmp931_ = vala_symbol_get_access ((ValaSymbol*) _tmp930_);
									_tmp932_ = _tmp931_;
									access = _tmp932_;
								} else {
									gboolean _tmp933_ = FALSE;
									ValaProperty* _tmp934_;
									ValaSymbolAccessibility _tmp935_;
									ValaSymbolAccessibility _tmp936_;
									_tmp934_ = prop;
									_tmp935_ = vala_symbol_get_access ((ValaSymbol*) _tmp934_);
									_tmp936_ = _tmp935_;
									if (_tmp936_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp937_;
										ValaPropertyAccessor* _tmp938_;
										ValaPropertyAccessor* _tmp939_;
										ValaSymbolAccessibility _tmp940_;
										ValaSymbolAccessibility _tmp941_;
										_tmp937_ = prop;
										_tmp938_ = vala_property_get_set_accessor (_tmp937_);
										_tmp939_ = _tmp938_;
										_tmp940_ = vala_symbol_get_access ((ValaSymbol*) _tmp939_);
										_tmp941_ = _tmp940_;
										_tmp933_ = _tmp941_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp933_ = FALSE;
									}
									if (_tmp933_) {
										ValaProperty* _tmp942_;
										ValaPropertyAccessor* _tmp943_;
										ValaPropertyAccessor* _tmp944_;
										ValaSymbolAccessibility _tmp945_;
										ValaSymbolAccessibility _tmp946_;
										_tmp942_ = prop;
										_tmp943_ = vala_property_get_set_accessor (_tmp942_);
										_tmp944_ = _tmp943_;
										_tmp945_ = vala_symbol_get_access ((ValaSymbol*) _tmp944_);
										_tmp946_ = _tmp945_;
										access = _tmp946_;
									}
								}
							} else {
								ValaProperty* _tmp947_;
								ValaPropertyAccessor* _tmp948_;
								ValaPropertyAccessor* _tmp949_;
								ValaProperty* _tmp957_;
								ValaSymbolAccessibility _tmp958_;
								ValaSymbolAccessibility _tmp959_;
								_tmp947_ = prop;
								_tmp948_ = vala_property_get_get_accessor (_tmp947_);
								_tmp949_ = _tmp948_;
								if (_tmp949_ == NULL) {
									ValaSourceReference* _tmp950_;
									ValaSourceReference* _tmp951_;
									ValaProperty* _tmp952_;
									gchar* _tmp953_;
									gchar* _tmp954_;
									gchar* _tmp955_;
									gchar* _tmp956_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp950_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp951_ = _tmp950_;
									_tmp952_ = prop;
									_tmp953_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp952_);
									_tmp954_ = _tmp953_;
									_tmp955_ = g_strdup_printf ("Property `%s' is write-only", _tmp954_);
									_tmp956_ = _tmp955_;
									vala_report_error (_tmp951_, _tmp956_);
									_g_free0 (_tmp956_);
									_g_free0 (_tmp954_);
									result = FALSE;
									return result;
								}
								_tmp957_ = prop;
								_tmp958_ = vala_symbol_get_access ((ValaSymbol*) _tmp957_);
								_tmp959_ = _tmp958_;
								if (_tmp959_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp960_;
									ValaPropertyAccessor* _tmp961_;
									ValaPropertyAccessor* _tmp962_;
									ValaSymbolAccessibility _tmp963_;
									ValaSymbolAccessibility _tmp964_;
									_tmp960_ = prop;
									_tmp961_ = vala_property_get_get_accessor (_tmp960_);
									_tmp962_ = _tmp961_;
									_tmp963_ = vala_symbol_get_access ((ValaSymbol*) _tmp962_);
									_tmp964_ = _tmp963_;
									access = _tmp964_;
								} else {
									gboolean _tmp965_ = FALSE;
									ValaProperty* _tmp966_;
									ValaSymbolAccessibility _tmp967_;
									ValaSymbolAccessibility _tmp968_;
									_tmp966_ = prop;
									_tmp967_ = vala_symbol_get_access ((ValaSymbol*) _tmp966_);
									_tmp968_ = _tmp967_;
									if (_tmp968_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp969_;
										ValaPropertyAccessor* _tmp970_;
										ValaPropertyAccessor* _tmp971_;
										ValaSymbolAccessibility _tmp972_;
										ValaSymbolAccessibility _tmp973_;
										_tmp969_ = prop;
										_tmp970_ = vala_property_get_get_accessor (_tmp969_);
										_tmp971_ = _tmp970_;
										_tmp972_ = vala_symbol_get_access ((ValaSymbol*) _tmp971_);
										_tmp973_ = _tmp972_;
										_tmp965_ = _tmp973_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp965_ = FALSE;
									}
									if (_tmp965_) {
										ValaProperty* _tmp974_;
										ValaPropertyAccessor* _tmp975_;
										ValaPropertyAccessor* _tmp976_;
										ValaSymbolAccessibility _tmp977_;
										ValaSymbolAccessibility _tmp978_;
										_tmp974_ = prop;
										_tmp975_ = vala_property_get_get_accessor (_tmp974_);
										_tmp976_ = _tmp975_;
										_tmp977_ = vala_symbol_get_access ((ValaSymbol*) _tmp976_);
										_tmp978_ = _tmp977_;
										access = _tmp978_;
									}
								}
							}
							_tmp979_ = prop;
							_tmp980_ = vala_property_get_binding (_tmp979_);
							_tmp981_ = _tmp980_;
							instance = _tmp981_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp982_ = prop;
							_tmp983_ = vala_property_get_property_type (_tmp982_);
							_tmp984_ = _tmp983_;
							if (VALA_IS_GENERIC_TYPE (_tmp984_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp985_;
							_tmp985_ = member;
							if (VALA_IS_SIGNAL (_tmp985_)) {
								ValaSymbol* _tmp986_;
								ValaSymbolAccessibility _tmp987_;
								ValaSymbolAccessibility _tmp988_;
								instance = TRUE;
								_tmp986_ = member;
								_tmp987_ = vala_symbol_get_access (_tmp986_);
								_tmp988_ = _tmp987_;
								access = _tmp988_;
							} else {
								gboolean _tmp989_ = FALSE;
								gboolean _tmp990_;
								_tmp990_ = self->priv->_creation_member;
								if (!_tmp990_) {
									ValaSymbol* _tmp991_;
									_tmp991_ = member;
									_tmp989_ = VALA_IS_ERROR_CODE (_tmp991_);
								} else {
									_tmp989_ = FALSE;
								}
								if (_tmp989_) {
									ValaSymbol* _tmp992_;
									ValaConstant* _tmp993_;
									ValaConstant* _tmp994_;
									ValaSymbol* _tmp995_;
									ValaSymbol* _tmp996_;
									_tmp992_ = member;
									_tmp993_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp992_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp994_ = _tmp993_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp994_);
									_tmp995_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp996_ = _tmp995_;
									member = _tmp996_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp997_;
		ValaSymbol* _tmp998_;
		ValaCodeNode* _tmp999_;
		ValaCodeNode* _tmp1000_;
		ValaCodeNode* _tmp1001_;
		gboolean _tmp1002_ = FALSE;
		ValaCodeNode* _tmp1003_;
		_tmp997_ = parent;
		_tmp998_ = member;
		if (!(_tmp997_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp998_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp999_ = parent;
		_tmp1000_ = vala_code_node_get_parent_node (_tmp999_);
		_tmp1001_ = _tmp1000_;
		parent = _tmp1001_;
		_tmp1003_ = parent;
		if (_tmp1003_ == NULL) {
			_tmp1002_ = TRUE;
		} else {
			ValaCodeNode* _tmp1004_;
			ValaSymbol* _tmp1005_;
			_tmp1004_ = parent;
			_tmp1005_ = member;
			_tmp1002_ = _tmp1004_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1005_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1002_) {
			break;
		}
	}
	_tmp1006_ = parent;
	_tmp1007_ = member;
	if (_tmp1006_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1007_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1008_;
		_tmp1008_ = member;
		vala_symbol_set_used (_tmp1008_, TRUE);
	}
	_tmp1009_ = member;
	_tmp1010_ = vala_symbol_get_version (_tmp1009_);
	_tmp1011_ = _tmp1010_;
	_tmp1012_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1013_ = _tmp1012_;
	vala_version_attribute_check (_tmp1011_, _tmp1013_);
	_tmp1015_ = access;
	if (_tmp1015_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1016_;
		ValaSymbol* _tmp1017_;
		ValaSymbol* _tmp1018_;
		_tmp1016_ = member;
		_tmp1017_ = vala_symbol_get_parent_symbol (_tmp1016_);
		_tmp1018_ = _tmp1017_;
		_tmp1014_ = VALA_IS_TYPESYMBOL (_tmp1018_);
	} else {
		_tmp1014_ = FALSE;
	}
	if (_tmp1014_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1019_;
		ValaSymbol* _tmp1020_;
		ValaSymbol* _tmp1021_;
		gboolean in_subtype = FALSE;
		_tmp1019_ = member;
		_tmp1020_ = vala_symbol_get_parent_symbol (_tmp1019_);
		_tmp1021_ = _tmp1020_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1021_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1022_;
			ValaSemanticAnalyzer* _tmp1023_;
			ValaSymbol* _tmp1024_;
			ValaSymbol* _tmp1025_;
			ValaSymbol* _tmp1026_;
			_tmp1022_ = vala_code_context_get_analyzer (context);
			_tmp1023_ = _tmp1022_;
			_tmp1024_ = vala_semantic_analyzer_get_current_symbol (_tmp1023_);
			_tmp1025_ = _tmp1024_;
			_tmp1026_ = _vala_code_node_ref0 (_tmp1025_);
			this_symbol = _tmp1026_;
			{
				gboolean _tmp1027_ = FALSE;
				_tmp1027_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1032_;
					ValaSymbol* _tmp1033_;
					ValaTypeSymbol* _tmp1034_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1035_;
					gboolean _tmp1036_ = FALSE;
					ValaClass* _tmp1037_;
					if (!_tmp1027_) {
						ValaSymbol* _tmp1028_;
						ValaSymbol* _tmp1029_;
						ValaSymbol* _tmp1030_;
						ValaSymbol* _tmp1031_;
						_tmp1028_ = this_symbol;
						_tmp1029_ = vala_symbol_get_parent_symbol (_tmp1028_);
						_tmp1030_ = _tmp1029_;
						_tmp1031_ = _vala_code_node_ref0 (_tmp1030_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1031_;
					}
					_tmp1027_ = FALSE;
					_tmp1032_ = this_symbol;
					if (!(_tmp1032_ != NULL)) {
						break;
					}
					_tmp1033_ = this_symbol;
					_tmp1034_ = target_type;
					if (_tmp1033_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1034_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1035_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1035_) ? ((ValaClass*) _tmp1035_) : NULL;
					_tmp1037_ = cl;
					if (_tmp1037_ != NULL) {
						ValaClass* _tmp1038_;
						ValaTypeSymbol* _tmp1039_;
						_tmp1038_ = cl;
						_tmp1039_ = target_type;
						_tmp1036_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1038_, _tmp1039_);
					} else {
						_tmp1036_ = FALSE;
					}
					if (_tmp1036_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1040_;
			ValaSourceReference* _tmp1041_;
			ValaSymbol* _tmp1042_;
			gchar* _tmp1043_;
			gchar* _tmp1044_;
			gchar* _tmp1045_;
			gchar* _tmp1046_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1040_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1041_ = _tmp1040_;
			_tmp1042_ = member;
			_tmp1043_ = vala_symbol_get_full_name (_tmp1042_);
			_tmp1044_ = _tmp1043_;
			_tmp1045_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1044_);
			_tmp1046_ = _tmp1045_;
			vala_report_error (_tmp1041_, _tmp1046_);
			_g_free0 (_tmp1046_);
			_g_free0 (_tmp1044_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1047_;
		_tmp1047_ = access;
		if (_tmp1047_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1048_;
			ValaSymbol* _tmp1049_;
			ValaSymbol* _tmp1050_;
			gboolean in_target_type = FALSE;
			_tmp1048_ = member;
			_tmp1049_ = vala_symbol_get_parent_symbol (_tmp1048_);
			_tmp1050_ = _tmp1049_;
			target_type = _tmp1050_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1051_;
				ValaSemanticAnalyzer* _tmp1052_;
				ValaSymbol* _tmp1053_;
				ValaSymbol* _tmp1054_;
				ValaSymbol* _tmp1055_;
				_tmp1051_ = vala_code_context_get_analyzer (context);
				_tmp1052_ = _tmp1051_;
				_tmp1053_ = vala_semantic_analyzer_get_current_symbol (_tmp1052_);
				_tmp1054_ = _tmp1053_;
				_tmp1055_ = _vala_code_node_ref0 (_tmp1054_);
				this_symbol = _tmp1055_;
				{
					gboolean _tmp1056_ = FALSE;
					_tmp1056_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1061_;
						ValaSymbol* _tmp1062_;
						ValaSymbol* _tmp1063_;
						if (!_tmp1056_) {
							ValaSymbol* _tmp1057_;
							ValaSymbol* _tmp1058_;
							ValaSymbol* _tmp1059_;
							ValaSymbol* _tmp1060_;
							_tmp1057_ = this_symbol;
							_tmp1058_ = vala_symbol_get_parent_symbol (_tmp1057_);
							_tmp1059_ = _tmp1058_;
							_tmp1060_ = _vala_code_node_ref0 (_tmp1059_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1060_;
						}
						_tmp1056_ = FALSE;
						_tmp1061_ = this_symbol;
						if (!(_tmp1061_ != NULL)) {
							break;
						}
						_tmp1062_ = target_type;
						_tmp1063_ = this_symbol;
						if (_tmp1062_ == _tmp1063_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1064_;
				ValaSourceReference* _tmp1065_;
				ValaSymbol* _tmp1066_;
				gchar* _tmp1067_;
				gchar* _tmp1068_;
				gchar* _tmp1069_;
				gchar* _tmp1070_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1064_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1065_ = _tmp1064_;
				_tmp1066_ = member;
				_tmp1067_ = vala_symbol_get_full_name (_tmp1066_);
				_tmp1068_ = _tmp1067_;
				_tmp1069_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1068_);
				_tmp1070_ = _tmp1069_;
				vala_report_error (_tmp1065_, _tmp1070_);
				_g_free0 (_tmp1070_);
				_g_free0 (_tmp1068_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1072_;
		ValaExpression* _tmp1073_;
		_tmp1072_ = vala_member_access_get_inner (self);
		_tmp1073_ = _tmp1072_;
		_tmp1071_ = _tmp1073_ != NULL;
	} else {
		_tmp1071_ = FALSE;
	}
	if (_tmp1071_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1074_;
		ValaExpression* _tmp1075_;
		ValaDataType* _tmp1076_;
		ValaDataType* _tmp1077_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1078_;
		ValaExpression* _tmp1079_;
		ValaDataType* _tmp1080_;
		ValaDataType* _tmp1081_;
		ValaPointerType* _tmp1082_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1086_;
		gboolean _tmp1087_ = FALSE;
		gboolean _tmp1088_ = FALSE;
		ValaObjectType* _tmp1089_;
		_tmp1074_ = vala_member_access_get_inner (self);
		_tmp1075_ = _tmp1074_;
		_tmp1076_ = vala_expression_get_value_type (_tmp1075_);
		_tmp1077_ = _tmp1076_;
		instance_type = _tmp1077_;
		_tmp1078_ = vala_member_access_get_inner (self);
		_tmp1079_ = _tmp1078_;
		_tmp1080_ = vala_expression_get_value_type (_tmp1079_);
		_tmp1081_ = _tmp1080_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1081_) ? ((ValaPointerType*) _tmp1081_) : NULL;
		_tmp1082_ = pointer_type;
		if (_tmp1082_ != NULL) {
			ValaPointerType* _tmp1083_;
			ValaDataType* _tmp1084_;
			ValaDataType* _tmp1085_;
			_tmp1083_ = pointer_type;
			_tmp1084_ = vala_pointer_type_get_base_type (_tmp1083_);
			_tmp1085_ = _tmp1084_;
			instance_type = _tmp1085_;
		}
		_tmp1086_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1086_) ? ((ValaObjectType*) _tmp1086_) : NULL;
		_tmp1089_ = object_type;
		if (_tmp1089_ != NULL) {
			ValaObjectType* _tmp1090_;
			ValaObjectTypeSymbol* _tmp1091_;
			ValaObjectTypeSymbol* _tmp1092_;
			_tmp1090_ = object_type;
			_tmp1091_ = vala_object_type_get_object_type_symbol (_tmp1090_);
			_tmp1092_ = _tmp1091_;
			_tmp1088_ = vala_object_type_symbol_has_type_parameters (_tmp1092_);
		} else {
			_tmp1088_ = FALSE;
		}
		if (_tmp1088_) {
			ValaDataType* _tmp1093_;
			_tmp1093_ = instance_type;
			_tmp1087_ = !vala_data_type_has_type_arguments (_tmp1093_);
		} else {
			_tmp1087_ = FALSE;
		}
		if (_tmp1087_) {
			ValaExpression* _tmp1094_;
			ValaExpression* _tmp1095_;
			ValaSourceReference* _tmp1096_;
			ValaSourceReference* _tmp1097_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1094_ = vala_member_access_get_inner (self);
			_tmp1095_ = _tmp1094_;
			_tmp1096_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1095_);
			_tmp1097_ = _tmp1096_;
			vala_report_error (_tmp1097_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1099_ = !may_access_instance_members;
	} else {
		_tmp1099_ = FALSE;
	}
	if (_tmp1099_) {
		_tmp1098_ = TRUE;
	} else {
		gboolean _tmp1100_ = FALSE;
		if (klass) {
			_tmp1100_ = !may_access_klass_members;
		} else {
			_tmp1100_ = FALSE;
		}
		_tmp1098_ = _tmp1100_;
	}
	if (_tmp1098_) {
		ValaSymbol* _tmp1101_;
		ValaSymbol* _tmp1102_;
		ValaDataType* _tmp1125_;
		ValaDataType* _tmp1126_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1101_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1102_ = _tmp1101_;
		if (VALA_IS_METHOD (_tmp1102_)) {
			ValaSemanticAnalyzer* _tmp1103_;
			ValaSemanticAnalyzer* _tmp1104_;
			ValaSymbol* _tmp1105_;
			ValaSymbol* _tmp1106_;
			gboolean _tmp1107_;
			gboolean _tmp1108_;
			ValaDataType* _tmp1109_;
			ValaDataType* _tmp1110_;
			_tmp1103_ = vala_code_context_get_analyzer (context);
			_tmp1104_ = _tmp1103_;
			_tmp1105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1106_ = _tmp1105_;
			_tmp1107_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1108_ = _tmp1107_;
			_tmp1109_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1104_, _tmp1106_, _tmp1108_);
			_tmp1110_ = _tmp1109_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1110_);
			_vala_code_node_unref0 (_tmp1110_);
		} else {
			ValaSymbol* _tmp1111_;
			ValaSymbol* _tmp1112_;
			_tmp1111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1112_ = _tmp1111_;
			if (VALA_IS_FIELD (_tmp1112_)) {
				ValaSymbol* _tmp1113_;
				ValaSymbol* _tmp1114_;
				ValaFieldPrototype* _tmp1115_;
				ValaFieldPrototype* _tmp1116_;
				_tmp1113_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1114_ = _tmp1113_;
				_tmp1115_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1114_, VALA_TYPE_FIELD, ValaField));
				_tmp1116_ = _tmp1115_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1116_);
				_vala_code_node_unref0 (_tmp1116_);
			} else {
				ValaSymbol* _tmp1117_;
				ValaSymbol* _tmp1118_;
				_tmp1117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1118_ = _tmp1117_;
				if (VALA_IS_PROPERTY (_tmp1118_)) {
					ValaSymbol* _tmp1119_;
					ValaSymbol* _tmp1120_;
					ValaPropertyPrototype* _tmp1121_;
					ValaPropertyPrototype* _tmp1122_;
					_tmp1119_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1120_ = _tmp1119_;
					_tmp1121_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1120_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1122_ = _tmp1121_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1122_);
					_vala_code_node_unref0 (_tmp1122_);
				} else {
					ValaInvalidType* _tmp1123_;
					ValaInvalidType* _tmp1124_;
					_tmp1123_ = vala_invalid_type_new ();
					_tmp1124_ = _tmp1123_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1124_);
					_vala_code_node_unref0 (_tmp1124_);
				}
			}
		}
		_tmp1125_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1126_ = _tmp1125_;
		if (_tmp1126_ != NULL) {
			ValaDataType* _tmp1127_;
			ValaDataType* _tmp1128_;
			ValaDataType* _tmp1129_;
			ValaDataType* _tmp1130_;
			gboolean _tmp1131_;
			gboolean _tmp1132_;
			_tmp1127_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1128_ = _tmp1127_;
			_tmp1129_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1130_ = _tmp1129_;
			_tmp1131_ = vala_data_type_get_value_owned (_tmp1130_);
			_tmp1132_ = _tmp1131_;
			vala_data_type_set_value_owned (_tmp1128_, _tmp1132_);
		}
	} else {
		gboolean _tmp1133_ = FALSE;
		gboolean _tmp1154_ = FALSE;
		gboolean _tmp1155_ = FALSE;
		gboolean _tmp1156_ = FALSE;
		gboolean _tmp1157_ = FALSE;
		gboolean _tmp1174_ = FALSE;
		gboolean _tmp1175_ = FALSE;
		gboolean _tmp1176_ = FALSE;
		gboolean _tmp1177_ = FALSE;
		gboolean _tmp1178_ = FALSE;
		gboolean _tmp1179_;
		gboolean _tmp1180_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1207_;
		ValaSymbol* _tmp1208_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1209_;
		ValaExpression* _tmp1210_;
		gboolean _tmp1211_ = FALSE;
		gboolean _tmp1212_ = FALSE;
		gboolean _tmp1213_ = FALSE;
		gboolean _tmp1214_ = FALSE;
		gboolean _tmp1215_ = FALSE;
		ValaMethod* _tmp1216_;
		ValaSemanticAnalyzer* _tmp1253_;
		ValaSemanticAnalyzer* _tmp1254_;
		ValaSymbol* _tmp1255_;
		ValaSymbol* _tmp1256_;
		gboolean _tmp1257_;
		gboolean _tmp1258_;
		ValaDataType* _tmp1259_;
		ValaDataType* _tmp1260_;
		gboolean _tmp1261_ = FALSE;
		ValaExpression* _tmp1262_;
		ValaExpression* _tmp1263_;
		ValaSymbol* _tmp1276_;
		ValaSymbol* _tmp1277_;
		if (instance) {
			ValaExpression* _tmp1134_;
			ValaExpression* _tmp1135_;
			_tmp1134_ = vala_member_access_get_inner (self);
			_tmp1135_ = _tmp1134_;
			_tmp1133_ = _tmp1135_ == NULL;
		} else {
			_tmp1133_ = FALSE;
		}
		if (_tmp1133_) {
			ValaSourceReference* _tmp1136_;
			ValaSourceReference* _tmp1137_;
			ValaMemberAccess* _tmp1138_;
			ValaMemberAccess* _tmp1139_;
			ValaExpression* _tmp1140_;
			ValaExpression* _tmp1141_;
			ValaParameter* _tmp1142_;
			ValaDataType* _tmp1143_;
			ValaDataType* _tmp1144_;
			ValaDataType* _tmp1145_;
			ValaDataType* _tmp1146_;
			ValaExpression* _tmp1147_;
			ValaExpression* _tmp1148_;
			ValaDataType* _tmp1149_;
			ValaDataType* _tmp1150_;
			ValaExpression* _tmp1151_;
			ValaExpression* _tmp1152_;
			ValaParameter* _tmp1153_;
			_tmp1136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1137_ = _tmp1136_;
			_tmp1138_ = vala_member_access_new (NULL, "this", _tmp1137_);
			_tmp1139_ = _tmp1138_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1139_);
			_vala_code_node_unref0 (_tmp1139_);
			_tmp1140_ = vala_member_access_get_inner (self);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = this_parameter;
			_tmp1143_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1142_);
			_tmp1144_ = _tmp1143_;
			_tmp1145_ = vala_data_type_copy (_tmp1144_);
			_tmp1146_ = _tmp1145_;
			vala_expression_set_value_type (_tmp1141_, _tmp1146_);
			_vala_code_node_unref0 (_tmp1146_);
			_tmp1147_ = vala_member_access_get_inner (self);
			_tmp1148_ = _tmp1147_;
			_tmp1149_ = vala_expression_get_value_type (_tmp1148_);
			_tmp1150_ = _tmp1149_;
			vala_data_type_set_value_owned (_tmp1150_, FALSE);
			_tmp1151_ = vala_member_access_get_inner (self);
			_tmp1152_ = _tmp1151_;
			_tmp1153_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1152_, (ValaSymbol*) _tmp1153_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1157_ = !klass;
		} else {
			_tmp1157_ = FALSE;
		}
		if (_tmp1157_) {
			ValaSymbol* _tmp1158_;
			ValaSymbol* _tmp1159_;
			_tmp1158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1159_ = _tmp1158_;
			_tmp1156_ = !VALA_IS_CREATION_METHOD (_tmp1159_);
		} else {
			_tmp1156_ = FALSE;
		}
		if (_tmp1156_) {
			_tmp1155_ = may_access_instance_members;
		} else {
			_tmp1155_ = FALSE;
		}
		if (_tmp1155_) {
			ValaExpression* _tmp1160_;
			ValaExpression* _tmp1161_;
			_tmp1160_ = vala_member_access_get_inner (self);
			_tmp1161_ = _tmp1160_;
			_tmp1154_ = _tmp1161_ != NULL;
		} else {
			_tmp1154_ = FALSE;
		}
		if (_tmp1154_) {
			ValaExpression* _tmp1162_;
			ValaExpression* _tmp1163_;
			ValaSymbol* _tmp1164_;
			ValaSymbol* _tmp1165_;
			_tmp1162_ = vala_member_access_get_inner (self);
			_tmp1163_ = _tmp1162_;
			_tmp1164_ = vala_expression_get_symbol_reference (_tmp1163_);
			_tmp1165_ = _tmp1164_;
			if (VALA_IS_METHOD (_tmp1165_)) {
			} else {
				ValaSourceReference* _tmp1166_;
				ValaSourceReference* _tmp1167_;
				ValaSymbol* _tmp1168_;
				ValaSymbol* _tmp1169_;
				gchar* _tmp1170_;
				gchar* _tmp1171_;
				gchar* _tmp1172_;
				gchar* _tmp1173_;
				_tmp1166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1167_ = _tmp1166_;
				_tmp1168_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1169_ = _tmp1168_;
				_tmp1170_ = vala_symbol_get_full_name (_tmp1169_);
				_tmp1171_ = _tmp1170_;
				_tmp1172_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1171_);
				_tmp1173_ = _tmp1172_;
				vala_report_warning (_tmp1167_, _tmp1173_);
				_g_free0 (_tmp1173_);
				_g_free0 (_tmp1171_);
			}
		}
		_tmp1179_ = vala_code_context_get_experimental_non_null (context);
		_tmp1180_ = _tmp1179_;
		if (_tmp1180_) {
			_tmp1178_ = instance;
		} else {
			_tmp1178_ = FALSE;
		}
		if (_tmp1178_) {
			ValaExpression* _tmp1181_;
			ValaExpression* _tmp1182_;
			ValaDataType* _tmp1183_;
			ValaDataType* _tmp1184_;
			gboolean _tmp1185_;
			gboolean _tmp1186_;
			_tmp1181_ = vala_member_access_get_inner (self);
			_tmp1182_ = _tmp1181_;
			_tmp1183_ = vala_expression_get_value_type (_tmp1182_);
			_tmp1184_ = _tmp1183_;
			_tmp1185_ = vala_data_type_get_nullable (_tmp1184_);
			_tmp1186_ = _tmp1185_;
			_tmp1177_ = _tmp1186_;
		} else {
			_tmp1177_ = FALSE;
		}
		if (_tmp1177_) {
			ValaExpression* _tmp1187_;
			ValaExpression* _tmp1188_;
			ValaDataType* _tmp1189_;
			ValaDataType* _tmp1190_;
			_tmp1187_ = vala_member_access_get_inner (self);
			_tmp1188_ = _tmp1187_;
			_tmp1189_ = vala_expression_get_value_type (_tmp1188_);
			_tmp1190_ = _tmp1189_;
			_tmp1176_ = !VALA_IS_POINTER_TYPE (_tmp1190_);
		} else {
			_tmp1176_ = FALSE;
		}
		if (_tmp1176_) {
			ValaExpression* _tmp1191_;
			ValaExpression* _tmp1192_;
			ValaDataType* _tmp1193_;
			ValaDataType* _tmp1194_;
			_tmp1191_ = vala_member_access_get_inner (self);
			_tmp1192_ = _tmp1191_;
			_tmp1193_ = vala_expression_get_value_type (_tmp1192_);
			_tmp1194_ = _tmp1193_;
			_tmp1175_ = !VALA_IS_GENERIC_TYPE (_tmp1194_);
		} else {
			_tmp1175_ = FALSE;
		}
		if (_tmp1175_) {
			ValaExpression* _tmp1195_;
			ValaExpression* _tmp1196_;
			ValaDataType* _tmp1197_;
			ValaDataType* _tmp1198_;
			_tmp1195_ = vala_member_access_get_inner (self);
			_tmp1196_ = _tmp1195_;
			_tmp1197_ = vala_expression_get_value_type (_tmp1196_);
			_tmp1198_ = _tmp1197_;
			_tmp1174_ = !VALA_IS_ARRAY_TYPE (_tmp1198_);
		} else {
			_tmp1174_ = FALSE;
		}
		if (_tmp1174_) {
			ValaSourceReference* _tmp1199_;
			ValaSourceReference* _tmp1200_;
			ValaSymbol* _tmp1201_;
			ValaSymbol* _tmp1202_;
			gchar* _tmp1203_;
			gchar* _tmp1204_;
			gchar* _tmp1205_;
			gchar* _tmp1206_;
			_tmp1199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1200_ = _tmp1199_;
			_tmp1201_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1202_ = _tmp1201_;
			_tmp1203_ = vala_symbol_get_full_name (_tmp1202_);
			_tmp1204_ = _tmp1203_;
			_tmp1205_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1204_);
			_tmp1206_ = _tmp1205_;
			vala_report_error (_tmp1200_, _tmp1206_);
			_g_free0 (_tmp1206_);
			_g_free0 (_tmp1204_);
		}
		_tmp1207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1208_ = _tmp1207_;
		m = VALA_IS_METHOD (_tmp1208_) ? ((ValaMethod*) _tmp1208_) : NULL;
		_tmp1209_ = vala_member_access_get_inner (self);
		_tmp1210_ = _tmp1209_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1210_) ? ((ValaMemberAccess*) _tmp1210_) : NULL;
		_tmp1216_ = m;
		if (_tmp1216_ != NULL) {
			ValaMethod* _tmp1217_;
			ValaMemberBinding _tmp1218_;
			ValaMemberBinding _tmp1219_;
			_tmp1217_ = m;
			_tmp1218_ = vala_method_get_binding (_tmp1217_);
			_tmp1219_ = _tmp1218_;
			_tmp1215_ = _tmp1219_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1215_ = FALSE;
		}
		if (_tmp1215_) {
			ValaMethod* _tmp1220_;
			ValaSymbol* _tmp1221_;
			ValaSymbol* _tmp1222_;
			_tmp1220_ = m;
			_tmp1221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1220_);
			_tmp1222_ = _tmp1221_;
			_tmp1214_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1222_);
		} else {
			_tmp1214_ = FALSE;
		}
		if (_tmp1214_) {
			ValaExpression* _tmp1223_;
			ValaExpression* _tmp1224_;
			_tmp1223_ = vala_member_access_get_inner (self);
			_tmp1224_ = _tmp1223_;
			_tmp1213_ = _tmp1224_ != NULL;
		} else {
			_tmp1213_ = FALSE;
		}
		if (_tmp1213_) {
			ValaExpression* _tmp1225_;
			ValaExpression* _tmp1226_;
			ValaDataType* _tmp1227_;
			ValaDataType* _tmp1228_;
			_tmp1225_ = vala_member_access_get_inner (self);
			_tmp1226_ = _tmp1225_;
			_tmp1227_ = vala_expression_get_value_type (_tmp1226_);
			_tmp1228_ = _tmp1227_;
			_tmp1212_ = _tmp1228_ == NULL;
		} else {
			_tmp1212_ = FALSE;
		}
		if (_tmp1212_) {
			ValaMemberAccess* _tmp1229_;
			ValaList* _tmp1230_;
			gint _tmp1231_;
			gint _tmp1232_;
			_tmp1229_ = inner_ma;
			_tmp1230_ = _tmp1229_->priv->type_argument_list;
			_tmp1231_ = vala_collection_get_size ((ValaCollection*) _tmp1230_);
			_tmp1232_ = _tmp1231_;
			_tmp1211_ = _tmp1232_ > 0;
		} else {
			_tmp1211_ = FALSE;
		}
		if (_tmp1211_) {
			ValaExpression* _tmp1233_;
			ValaExpression* _tmp1234_;
			ValaMethod* _tmp1235_;
			ValaSymbol* _tmp1236_;
			ValaSymbol* _tmp1237_;
			ValaObjectType* _tmp1238_;
			ValaObjectType* _tmp1239_;
			_tmp1233_ = vala_member_access_get_inner (self);
			_tmp1234_ = _tmp1233_;
			_tmp1235_ = m;
			_tmp1236_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1235_);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1237_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1239_ = _tmp1238_;
			vala_expression_set_value_type (_tmp1234_, (ValaDataType*) _tmp1239_);
			_vala_code_node_unref0 (_tmp1239_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1240_;
				ValaList* _tmp1241_;
				ValaList* _tmp1242_;
				gint _type_argument_size = 0;
				ValaList* _tmp1243_;
				gint _tmp1244_;
				gint _tmp1245_;
				gint _type_argument_index = 0;
				_tmp1240_ = inner_ma;
				_tmp1241_ = _tmp1240_->priv->type_argument_list;
				_tmp1242_ = _vala_iterable_ref0 (_tmp1241_);
				_type_argument_list = _tmp1242_;
				_tmp1243_ = _type_argument_list;
				_tmp1244_ = vala_collection_get_size ((ValaCollection*) _tmp1243_);
				_tmp1245_ = _tmp1244_;
				_type_argument_size = _tmp1245_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1246_;
					gpointer _tmp1247_;
					ValaExpression* _tmp1248_;
					ValaExpression* _tmp1249_;
					ValaDataType* _tmp1250_;
					ValaDataType* _tmp1251_;
					ValaDataType* _tmp1252_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1246_ = _type_argument_list;
					_tmp1247_ = vala_list_get (_tmp1246_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1247_;
					_tmp1248_ = vala_member_access_get_inner (self);
					_tmp1249_ = _tmp1248_;
					_tmp1250_ = vala_expression_get_value_type (_tmp1249_);
					_tmp1251_ = _tmp1250_;
					_tmp1252_ = type_argument;
					vala_data_type_add_type_argument (_tmp1251_, _tmp1252_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1253_ = vala_code_context_get_analyzer (context);
		_tmp1254_ = _tmp1253_;
		_tmp1255_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1256_ = _tmp1255_;
		_tmp1257_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1258_ = _tmp1257_;
		_tmp1259_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1254_, _tmp1256_, _tmp1258_);
		_tmp1260_ = _tmp1259_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1260_);
		_vala_code_node_unref0 (_tmp1260_);
		_tmp1262_ = vala_member_access_get_inner (self);
		_tmp1263_ = _tmp1262_;
		if (_tmp1263_ != NULL) {
			ValaDataType* _tmp1264_;
			ValaDataType* _tmp1265_;
			_tmp1264_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1265_ = _tmp1264_;
			_tmp1261_ = _tmp1265_ != NULL;
		} else {
			_tmp1261_ = FALSE;
		}
		if (_tmp1261_) {
			ValaDataType* _tmp1266_;
			ValaDataType* _tmp1267_;
			ValaExpression* _tmp1268_;
			ValaExpression* _tmp1269_;
			ValaDataType* _tmp1270_;
			ValaDataType* _tmp1271_;
			ValaDataType* _tmp1272_;
			ValaDataType* _tmp1273_;
			_tmp1266_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1267_ = _tmp1266_;
			_tmp1268_ = vala_member_access_get_inner (self);
			_tmp1269_ = _tmp1268_;
			_tmp1270_ = vala_expression_get_value_type (_tmp1269_);
			_tmp1271_ = _tmp1270_;
			_tmp1272_ = vala_data_type_get_actual_type (_tmp1267_, _tmp1271_, NULL, (ValaCodeNode*) self);
			_tmp1273_ = _tmp1272_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1273_);
			_vala_code_node_unref0 (_tmp1273_);
		} else {
			ValaDataType* _tmp1274_;
			ValaDataType* _tmp1275_;
			_tmp1274_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1275_ = _tmp1274_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1275_);
		}
		_tmp1276_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1277_ = _tmp1276_;
		if (VALA_IS_METHOD (_tmp1277_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1278_;
			ValaSymbol* _tmp1279_;
			ValaDataType* _tmp1280_;
			ValaDataType* _tmp1281_;
			gboolean _tmp1288_ = FALSE;
			_tmp1278_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1279_ = _tmp1278_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1279_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1280_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1281_ = _tmp1280_;
			if (_tmp1281_ != NULL) {
				ValaDataType* _tmp1282_;
				ValaDataType* _tmp1283_;
				ValaDataType* _tmp1284_;
				ValaDataType* _tmp1285_;
				gboolean _tmp1286_;
				gboolean _tmp1287_;
				_tmp1282_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1283_ = _tmp1282_;
				_tmp1284_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1285_ = _tmp1284_;
				_tmp1286_ = vala_data_type_get_value_owned (_tmp1285_);
				_tmp1287_ = _tmp1286_;
				vala_data_type_set_value_owned (_tmp1283_, _tmp1287_);
			}
			if (instance) {
				ValaMethod* _tmp1289_;
				ValaSymbol* _tmp1290_;
				ValaSymbol* _tmp1291_;
				_tmp1289_ = method;
				_tmp1290_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1289_);
				_tmp1291_ = _tmp1290_;
				_tmp1288_ = VALA_IS_TYPESYMBOL (_tmp1291_);
			} else {
				_tmp1288_ = FALSE;
			}
			if (_tmp1288_) {
				ValaExpression* _tmp1292_;
				ValaExpression* _tmp1293_;
				ValaMethod* _tmp1294_;
				ValaSymbol* _tmp1295_;
				ValaSymbol* _tmp1296_;
				ValaDataType* _tmp1297_;
				ValaDataType* _tmp1298_;
				ValaExpression* _tmp1299_;
				ValaExpression* _tmp1300_;
				ValaDataType* _tmp1301_;
				ValaDataType* _tmp1302_;
				ValaMethod* _tmp1303_;
				ValaParameter* _tmp1304_;
				ValaParameter* _tmp1305_;
				ValaDataType* _tmp1306_;
				ValaDataType* _tmp1307_;
				gboolean _tmp1308_;
				gboolean _tmp1309_;
				_tmp1292_ = vala_member_access_get_inner (self);
				_tmp1293_ = _tmp1292_;
				_tmp1294_ = method;
				_tmp1295_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1294_);
				_tmp1296_ = _tmp1295_;
				_tmp1297_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1296_);
				_tmp1298_ = _tmp1297_;
				vala_expression_set_target_type (_tmp1293_, _tmp1298_);
				_vala_code_node_unref0 (_tmp1298_);
				_tmp1299_ = vala_member_access_get_inner (self);
				_tmp1300_ = _tmp1299_;
				_tmp1301_ = vala_expression_get_target_type (_tmp1300_);
				_tmp1302_ = _tmp1301_;
				_tmp1303_ = method;
				_tmp1304_ = vala_method_get_this_parameter (_tmp1303_);
				_tmp1305_ = _tmp1304_;
				_tmp1306_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1305_);
				_tmp1307_ = _tmp1306_;
				_tmp1308_ = vala_data_type_get_value_owned (_tmp1307_);
				_tmp1309_ = _tmp1308_;
				vala_data_type_set_value_owned (_tmp1302_, _tmp1309_);
			}
		} else {
			gboolean _tmp1310_ = FALSE;
			gboolean _tmp1311_ = FALSE;
			ValaSymbol* _tmp1312_;
			ValaSymbol* _tmp1313_;
			_tmp1312_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1313_ = _tmp1312_;
			if (VALA_IS_PROPERTY (_tmp1313_)) {
				_tmp1311_ = instance;
			} else {
				_tmp1311_ = FALSE;
			}
			if (_tmp1311_) {
				ValaSymbol* _tmp1314_;
				ValaSymbol* _tmp1315_;
				ValaSymbol* _tmp1316_;
				ValaSymbol* _tmp1317_;
				_tmp1314_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1315_ = _tmp1314_;
				_tmp1316_ = vala_symbol_get_parent_symbol (_tmp1315_);
				_tmp1317_ = _tmp1316_;
				_tmp1310_ = _tmp1317_ != NULL;
			} else {
				_tmp1310_ = FALSE;
			}
			if (_tmp1310_) {
				ValaExpression* _tmp1318_;
				ValaExpression* _tmp1319_;
				ValaSymbol* _tmp1320_;
				ValaSymbol* _tmp1321_;
				ValaSymbol* _tmp1322_;
				ValaSymbol* _tmp1323_;
				ValaDataType* _tmp1324_;
				ValaDataType* _tmp1325_;
				_tmp1318_ = vala_member_access_get_inner (self);
				_tmp1319_ = _tmp1318_;
				_tmp1320_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1321_ = _tmp1320_;
				_tmp1322_ = vala_symbol_get_parent_symbol (_tmp1321_);
				_tmp1323_ = _tmp1322_;
				_tmp1324_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1323_);
				_tmp1325_ = _tmp1324_;
				vala_expression_set_target_type (_tmp1319_, _tmp1325_);
				_vala_code_node_unref0 (_tmp1325_);
			} else {
				gboolean _tmp1326_ = FALSE;
				gboolean _tmp1327_ = FALSE;
				gboolean _tmp1328_ = FALSE;
				ValaSymbol* _tmp1329_;
				ValaSymbol* _tmp1330_;
				_tmp1329_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1330_ = _tmp1329_;
				if (VALA_IS_FIELD (_tmp1330_)) {
					_tmp1328_ = TRUE;
				} else {
					ValaSymbol* _tmp1331_;
					ValaSymbol* _tmp1332_;
					_tmp1331_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1332_ = _tmp1331_;
					_tmp1328_ = VALA_IS_SIGNAL (_tmp1332_);
				}
				if (_tmp1328_) {
					_tmp1327_ = instance;
				} else {
					_tmp1327_ = FALSE;
				}
				if (_tmp1327_) {
					ValaSymbol* _tmp1333_;
					ValaSymbol* _tmp1334_;
					ValaSymbol* _tmp1335_;
					ValaSymbol* _tmp1336_;
					_tmp1333_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1334_ = _tmp1333_;
					_tmp1335_ = vala_symbol_get_parent_symbol (_tmp1334_);
					_tmp1336_ = _tmp1335_;
					_tmp1326_ = _tmp1336_ != NULL;
				} else {
					_tmp1326_ = FALSE;
				}
				if (_tmp1326_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1337_;
					ValaSymbol* _tmp1338_;
					ValaSymbol* _tmp1339_;
					ValaSymbol* _tmp1340_;
					ValaDataType* _tmp1341_;
					ValaExpression* _tmp1342_;
					ValaExpression* _tmp1343_;
					ValaDataType* _tmp1344_;
					ValaExpression* _tmp1345_;
					ValaExpression* _tmp1346_;
					ValaDataType* _tmp1347_;
					ValaDataType* _tmp1348_;
					ValaDataType* _tmp1349_;
					ValaDataType* _tmp1350_;
					_tmp1337_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1338_ = _tmp1337_;
					_tmp1339_ = vala_symbol_get_parent_symbol (_tmp1338_);
					_tmp1340_ = _tmp1339_;
					_tmp1341_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1340_);
					parent_type = _tmp1341_;
					_tmp1342_ = vala_member_access_get_inner (self);
					_tmp1343_ = _tmp1342_;
					_tmp1344_ = parent_type;
					_tmp1345_ = vala_member_access_get_inner (self);
					_tmp1346_ = _tmp1345_;
					_tmp1347_ = vala_expression_get_value_type (_tmp1346_);
					_tmp1348_ = _tmp1347_;
					_tmp1349_ = vala_data_type_get_actual_type (_tmp1344_, _tmp1348_, NULL, (ValaCodeNode*) self);
					_tmp1350_ = _tmp1349_;
					vala_expression_set_target_type (_tmp1343_, _tmp1350_);
					_vala_code_node_unref0 (_tmp1350_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1351_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1352_ = _tmp1351_;
	if (_tmp1352_ != NULL) {
		ValaDataType* _tmp1353_;
		ValaDataType* _tmp1354_;
		_tmp1353_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1354_ = _tmp1353_;
		vala_code_node_check ((ValaCodeNode*) _tmp1354_, context);
	}
	_tmp1355_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1356_ = _tmp1355_;
	result = !_tmp1356_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

